"use strict";

exports.__esModule = true;
exports.default = getLabelTransform;
var _orientation = _interopRequireDefault(require("../constants/orientation"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function getLabelTransform(_ref) {
  var labelOffset = _ref.labelOffset,
    labelProps = _ref.labelProps,
    orientation = _ref.orientation,
    range = _ref.range,
    tickLabelFontSize = _ref.tickLabelFontSize,
    tickLength = _ref.tickLength;
  var sign = orientation === _orientation.default.left || orientation === _orientation.default.top ? -1 : 1;
  var x;
  var y;
  var transform;
  if (orientation === _orientation.default.top || orientation === _orientation.default.bottom) {
    var yBottomOffset = orientation === _orientation.default.bottom && typeof labelProps.fontSize === 'number' ? labelProps.fontSize : 0;
    x = (Number(range[0]) + Number(range[range.length - 1])) / 2;
    y = sign * (tickLength + labelOffset + tickLabelFontSize + yBottomOffset);
  } else {
    x = sign * ((Number(range[0]) + Number(range[range.length - 1])) / 2);
    y = -(tickLength + labelOffset);
    transform = "rotate(" + sign * 90 + ")";
  }
  return {
    x: x,
    y: y,
    transform: transform
  };
}