/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.message.subscribe;

import com.hivemq.client.internal.mqtt.datatypes.MqttTopicFilterImpl;
import com.hivemq.client.internal.mqtt.datatypes.MqttTopicFilterImplBuilder;
import com.hivemq.client.internal.mqtt.message.subscribe.MqttSubscription;
import com.hivemq.client.internal.mqtt.util.MqttChecks;
import com.hivemq.client.internal.util.Checks;
import com.hivemq.client.mqtt.datatypes.MqttQos;
import com.hivemq.client.mqtt.datatypes.MqttTopicFilter;
import com.hivemq.client.mqtt.mqtt5.message.subscribe.Mqtt5RetainHandling;
import com.hivemq.client.mqtt.mqtt5.message.subscribe.Mqtt5Subscription;
import com.hivemq.client.mqtt.mqtt5.message.subscribe.Mqtt5SubscriptionBuilder;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MqttSubscriptionBuilder<B extends MqttSubscriptionBuilder<B>> {
    @Nullable
    private MqttTopicFilterImpl topicFilter;
    @NotNull
    private MqttQos qos = MqttSubscription.DEFAULT_QOS;
    private boolean noLocal = false;
    @NotNull
    private Mqtt5RetainHandling retainHandling = MqttSubscription.DEFAULT_RETAIN_HANDLING;
    private boolean retainAsPublished = false;

    MqttSubscriptionBuilder() {
    }

    MqttSubscriptionBuilder(@NotNull MqttSubscription subscription) {
        this.topicFilter = subscription.getTopicFilter();
        this.qos = subscription.getQos();
        this.noLocal = subscription.isNoLocal();
        this.retainHandling = subscription.getRetainHandling();
        this.retainAsPublished = subscription.isRetainAsPublished();
    }

    @NotNull
    abstract B self();

    @NotNull
    public B topicFilter(@Nullable String topicFilter) {
        this.topicFilter = MqttTopicFilterImpl.of(topicFilter);
        return this.self();
    }

    @NotNull
    public B topicFilter(@Nullable MqttTopicFilter topicFilter) {
        this.topicFilter = MqttChecks.topicFilter(topicFilter);
        return this.self();
    }

    public @NotNull MqttTopicFilterImplBuilder.Nested<B> topicFilter() {
        return new MqttTopicFilterImplBuilder.Nested<MqttSubscriptionBuilder>(this::topicFilter);
    }

    @NotNull
    public B qos(@Nullable MqttQos qos) {
        this.qos = Checks.notNull(qos, "QoS");
        return this.self();
    }

    @NotNull
    public B noLocal(boolean noLocal) {
        this.noLocal = noLocal;
        return this.self();
    }

    @NotNull
    public B retainHandling(@Nullable Mqtt5RetainHandling retainHandling) {
        this.retainHandling = Checks.notNull(retainHandling, "Retain handling");
        return this.self();
    }

    @NotNull
    public B retainAsPublished(boolean retainAsPublished) {
        this.retainAsPublished = retainAsPublished;
        return this.self();
    }

    @NotNull
    public MqttSubscription build() {
        Checks.notNull(this.topicFilter, "Topic filter");
        Checks.state(!this.topicFilter.isShared() || !this.noLocal, "It is a Protocol Error to set no local to true on a Shared Subscription.");
        return new MqttSubscription(this.topicFilter, this.qos, this.noLocal, this.retainHandling, this.retainAsPublished);
    }

    public static class Nested<P>
    extends MqttSubscriptionBuilder<Nested<P>>
    implements Mqtt5SubscriptionBuilder.Nested.Complete<P> {
        @NotNull
        private final Function<? super Mqtt5Subscription, P> parentConsumer;

        public Nested(@NotNull Function<? super Mqtt5Subscription, P> parentConsumer) {
            this.parentConsumer = parentConsumer;
        }

        @Override
        @NotNull
        Nested<P> self() {
            return this;
        }

        @Override
        @NotNull
        public P applySubscription() {
            return this.parentConsumer.apply(this.build());
        }
    }

    public static class Default
    extends MqttSubscriptionBuilder<Default>
    implements Mqtt5SubscriptionBuilder.Complete {
        public Default() {
        }

        Default(@NotNull MqttSubscription subscription) {
            super(subscription);
        }

        @Override
        @NotNull
        Default self() {
            return this;
        }
    }
}

