/*
# <<BEGIN-copyright>>
# <<END-copyright>>
*/
#include <string.h>
#include <statusMessageReporting.h>

#include "MCGIDI_mass.h"

#if defined __cplusplus
namespace GIDI {
using namespace GIDI;
#endif

struct ZAMass {
    char const *symbol;
    double mass;
};

static struct ZAMass ZAMasses[] = {
         { "Am242_m1", 2.420595491590000e+02 + 0.048 },
         { "FissionProductENDL99120", 117.5 },
         { "FissionProductENDL99121", 116.546 },
         { "FissionProductENDL99122", 118.544 },
         { "FissionProductENDL99125", 117.5 },
         { "gamma",      0. },
         { "n",          1.008664915740000e+00 }, { "H_natural",  1.007900000000000e+00 }, { "H1",         1.007825032070000e+00 }, { "H2",         2.014101777850000e+00 },
         { "H3",         3.016049277670000e+00 }, { "H4",         4.027806424000000e+00 }, { "H5",         5.035311488000000e+00 }, { "H6",         6.044942594000000e+00 },
         { "H7",         7.052749000000000e+00 }, { "He_natural", 4.002600000000000e+00 }, { "He3",        3.016029319140000e+00 }, { "He4",        4.002603254150000e+00 },
         { "He5",        5.012223624000000e+00 }, { "He6",        6.018889124000000e+00 }, { "He7",        7.028020618000000e+00 }, { "He8",        8.033921897000001e+00 },
         { "He9",        9.043950285999999e+00 }, { "He10",       1.005239883700000e+01 }, { "Li_natural", 6.941000000000000e+00 }, { "Li3",        3.030775000000000e+00 },
         { "Li4",        4.027185558000000e+00 }, { "Li5",        5.012537800000000e+00 }, { "Li6",        6.015122794000000e+00 }, { "Li7",        7.016004548000000e+00 },
         { "Li8",        8.022487362000000e+00 }, { "Li9",        9.026789505000000e+00 }, { "Li10",       1.003548125900000e+01 }, { "Li11",       1.104379771500000e+01 },
         { "Li12",       1.205378000000000e+01 }, { "Be_natural", 9.012180000000001e+00 }, { "Be5",        5.040790000000000e+00 }, { "Be6",        6.019726317000000e+00 },
         { "Be7",        7.016929828000000e+00 }, { "Be8",        8.005305103000000e+00 }, { "Be9",        9.012182201000000e+00 }, { "Be10",       1.001353381800000e+01 },
         { "Be11",       1.102165774900000e+01 }, { "Be12",       1.202692073700000e+01 }, { "Be13",       1.303569300700000e+01 }, { "Be14",       1.404289292000000e+01 },
         { "Be15",       1.505346000000000e+01 }, { "Be16",       1.606192000000000e+01 }, { "B_natural",  1.081000000000000e+01 }, { "B6",         6.046810000000000e+00 },
         { "B7",         7.029917901000000e+00 }, { "B8",         8.024607232999999e+00 }, { "B9",         9.013328782000000e+00 }, { "B10",        1.001293699200000e+01 },
         { "B11",        1.100930540600000e+01 }, { "B12",        1.201435210400000e+01 }, { "B13",        1.301778021700000e+01 }, { "B14",        1.402540400900000e+01 },
         { "B15",        1.503110302100000e+01 }, { "B16",        1.603980882900000e+01 }, { "B17",        1.704698990600000e+01 }, { "B18",        1.805617000000000e+01 },
         { "B19",        1.906373000000000e+01 }, { "C_natural",  1.201100000000000e+01 }, { "C8",         8.037675025000000e+00 }, { "C9",         9.031036689000000e+00 },
         { "C10",        1.001685322800000e+01 }, { "C11",        1.101143361300000e+01 }, { "C12",        1.200000000000000e+01 }, { "C13",        1.300335483778000e+01 },
         { "C14",        1.400324198870000e+01 }, { "C15",        1.501059925600000e+01 }, { "C16",        1.601470125200000e+01 }, { "C17",        1.702258611600000e+01 },
         { "C18",        1.802675935400000e+01 }, { "C19",        1.903480501800000e+01 }, { "C20",        2.004031975400000e+01 }, { "C21",        2.104934000000000e+01 },
         { "C23",        2.205720000000000e+01 }, { "N_natural",  1.400670000000000e+01 }, { "N10",        1.004165367400000e+01 }, { "N11",        1.102609095600000e+01 },
         { "N12",        1.201861319700000e+01 }, { "N13",        1.300573860900000e+01 }, { "N14",        1.400307400478000e+01 }, { "N15",        1.500010889823000e+01 },
         { "N16",        1.600610165800000e+01 }, { "N17",        1.700845026100000e+01 }, { "N18",        1.801407895900000e+01 }, { "N19",        1.901702869700000e+01 },
         { "N20",        2.002336580700000e+01 }, { "N21",        2.102710824000000e+01 }, { "N22",        2.203439493400000e+01 }, { "N23",        2.304122000000000e+01 },
         { "N24",        2.405104000000000e+01 }, { "N25",        2.506066000000000e+01 }, { "O_natural",  1.599940000000000e+01 }, { "O12",        1.203440489500000e+01 },
         { "O13",        1.302481221300000e+01 }, { "O14",        1.400859625000000e+01 }, { "O15",        1.500306561700000e+01 }, { "O16",        1.599491461956000e+01 },
         { "O17",        1.699913170300000e+01 }, { "O18",        1.799916100100000e+01 }, { "O19",        1.900358013000000e+01 }, { "O20",        2.000407674200000e+01 },
         { "O21",        2.100865588600000e+01 }, { "O22",        2.200996694700000e+01 }, { "O23",        2.301568765900000e+01 }, { "O24",        2.402047291700000e+01 },
         { "O25",        2.502946000000000e+01 }, { "O26",        2.603834000000000e+01 }, { "O27",        2.704826000000000e+01 }, { "O28",        2.805781000000000e+01 },
         { "F_natural",  1.899840300000000e+01 }, { "F14",        1.403506000000000e+01 }, { "F15",        1.501800910300000e+01 }, { "F16",        1.601146572400000e+01 },
         { "F17",        1.700209523700000e+01 }, { "F18",        1.800093795600000e+01 }, { "F19",        1.899840322400000e+01 }, { "F20",        1.999998131500000e+01 },
         { "F21",        2.099994895100000e+01 }, { "F22",        2.200299881500000e+01 }, { "F23",        2.300357463100000e+01 }, { "F24",        2.400811548500000e+01 },
         { "F25",        2.501210174700000e+01 }, { "F26",        2.601961555500000e+01 }, { "F27",        2.702676008600000e+01 }, { "F28",        2.803567000000000e+01 },
         { "F29",        2.904326000000000e+01 }, { "F30",        3.005250000000000e+01 }, { "F31",        3.106042900000000e+01 }, { "Ne_natural", 2.017900000000000e+01 },
         { "Ne16",       1.602576126200000e+01 }, { "Ne17",       1.701767150400000e+01 }, { "Ne18",       1.800570821300000e+01 }, { "Ne19",       1.900188024800000e+01 },
         { "Ne20",       1.999244017542000e+01 }, { "Ne21",       2.099384668400000e+01 }, { "Ne22",       2.199138511300000e+01 }, { "Ne23",       2.299446690400000e+01 },
         { "Ne24",       2.399361077900000e+01 }, { "Ne25",       2.499773688800000e+01 }, { "Ne26",       2.600046120600000e+01 }, { "Ne27",       2.700758990300000e+01 },
         { "Ne28",       2.801207157500000e+01 }, { "Ne29",       2.901938593300000e+01 }, { "Ne30",       3.002480104500000e+01 }, { "Ne31",       3.103311000000000e+01 },
         { "Ne32",       3.204002000000000e+01 }, { "Ne33",       3.304938000000000e+01 }, { "Ne34",       3.405702800000000e+01 }, { "Na_natural", 2.298977000000000e+01 },
         { "Na18",       1.802596900000000e+01 }, { "Na19",       1.901387749900000e+01 }, { "Na20",       2.000735132800000e+01 }, { "Na21",       2.099765520600000e+01 },
         { "Na22",       2.199443642500000e+01 }, { "Na23",       2.298976928087000e+01 }, { "Na24",       2.399096278200000e+01 }, { "Na25",       2.498995396800000e+01 },
         { "Na26",       2.599263300000000e+01 }, { "Na27",       2.699407678800000e+01 }, { "Na28",       2.799893800000000e+01 }, { "Na29",       2.900286100000000e+01 },
         { "Na30",       3.000897600000000e+01 }, { "Na31",       3.101358545200000e+01 }, { "Na32",       3.202046656000000e+01 }, { "Na33",       3.302671975600000e+01 },
         { "Na34",       3.403517000000000e+01 }, { "Na35",       3.504249300000000e+01 }, { "Na36",       3.605148000000000e+01 }, { "Na37",       3.705934000000000e+01 },
         { "Mg_natural", 2.430500000000000e+01 }, { "Mg19",       1.903547000000000e+01 }, { "Mg20",       2.001886254500000e+01 }, { "Mg21",       2.101171291000000e+01 },
         { "Mg22",       2.199957384300000e+01 }, { "Mg23",       2.299412366900000e+01 }, { "Mg24",       2.398504169900000e+01 }, { "Mg25",       2.498583691700000e+01 },
         { "Mg26",       2.598259292900000e+01 }, { "Mg27",       2.698434058500000e+01 }, { "Mg28",       2.798387682500000e+01 }, { "Mg29",       2.898860000000000e+01 },
         { "Mg30",       2.999043400000000e+01 }, { "Mg31",       3.099654600000000e+01 }, { "Mg32",       3.199897500000000e+01 }, { "Mg33",       3.300525400000000e+01 },
         { "Mg34",       3.400945642400000e+01 }, { "Mg35",       3.501734000000000e+01 }, { "Mg36",       3.602300000000000e+01 }, { "Mg37",       3.703140000000000e+01 },
         { "Mg38",       3.803757000000000e+01 }, { "Mg39",       3.904677200000000e+01 }, { "Mg40",       4.005393000000000e+01 }, { "Al_natural", 2.698154000000000e+01 },
         { "Al21",       2.102804000000000e+01 }, { "Al22",       2.201952000000000e+01 }, { "Al23",       2.300726743200000e+01 }, { "Al24",       2.399993886500000e+01 },
         { "Al25",       2.499042809500000e+01 }, { "Al26",       2.598689169200000e+01 }, { "Al27",       2.698153862700000e+01 }, { "Al28",       2.798191030600000e+01 },
         { "Al29",       2.898044504600000e+01 }, { "Al30",       2.998296025600000e+01 }, { "Al31",       3.098394661900000e+01 }, { "Al32",       3.198812448900000e+01 },
         { "Al33",       3.299084333600000e+01 }, { "Al34",       3.399685183700000e+01 }, { "Al35",       3.499986023500000e+01 }, { "Al36",       3.600620720400000e+01 },
         { "Al37",       3.701067782000000e+01 }, { "Al38",       3.801723102100000e+01 }, { "Al39",       3.902297000000000e+01 }, { "Al40",       4.003145000000000e+01 },
         { "Al41",       4.103833000000000e+01 }, { "Al42",       4.204689000000000e+01 }, { "Si_natural", 2.808550000000000e+01 }, { "Si22",       2.203453000000000e+01 },
         { "Si23",       2.302552000000000e+01 }, { "Si24",       2.401154561600000e+01 }, { "Si25",       2.500410557400000e+01 }, { "Si26",       2.599232992100000e+01 },
         { "Si27",       2.698670490500000e+01 }, { "Si28",       2.797692653246000e+01 }, { "Si29",       2.897649470000000e+01 }, { "Si30",       2.997377017100000e+01 },
         { "Si31",       3.097536322700000e+01 }, { "Si32",       3.197414808200000e+01 }, { "Si33",       3.297800022000000e+01 }, { "Si34",       3.397857552400000e+01 },
         { "Si35",       3.498458357500000e+01 }, { "Si36",       3.598659947700000e+01 }, { "Si37",       3.699293608000000e+01 }, { "Si38",       3.799563360100000e+01 },
         { "Si39",       3.900207001300000e+01 }, { "Si40",       4.000586912100000e+01 }, { "Si41",       4.101456000000000e+01 }, { "Si42",       4.201979000000000e+01 },
         { "Si43",       4.302866000000000e+01 }, { "Si44",       4.403526000000000e+01 }, { "P_natural",  3.097376000000000e+01 }, { "P24",        2.403435000000000e+01 },
         { "P25",        2.502026000000000e+01 }, { "P26",        2.601178000000000e+01 }, { "P27",        2.699923023600000e+01 }, { "P28",        2.799231476100000e+01 },
         { "P29",        2.898180060600000e+01 }, { "P30",        2.997831378900000e+01 }, { "P31",        3.097376162900000e+01 }, { "P32",        3.197390727400000e+01 },
         { "P33",        3.297172554300000e+01 }, { "P34",        3.397363625700000e+01 }, { "P35",        3.497331411700000e+01 }, { "P36",        3.597825968000000e+01 },
         { "P37",        3.697960894600000e+01 }, { "P38",        3.798415682700000e+01 }, { "P39",        3.898617947500000e+01 }, { "P40",        3.999129695100000e+01 },
         { "P41",        4.099433543500000e+01 }, { "P42",        4.200100791300000e+01 }, { "P43",        4.300619000000000e+01 }, { "P44",        4.401299000000000e+01 },
         { "P45",        4.501922000000000e+01 }, { "P46",        4.602738000000000e+01 }, { "S_natural",  3.206000000000000e+01 }, { "S26",        2.602788000000000e+01 },
         { "S27",        2.701883300000000e+01 }, { "S28",        2.800437276300000e+01 }, { "S29",        2.899660804900000e+01 }, { "S30",        2.998490324900000e+01 },
         { "S31",        3.097955472800000e+01 }, { "S32",        3.197207099900000e+01 }, { "S33",        3.297145875900000e+01 }, { "S34",        3.396786690200000e+01 },
         { "S35",        3.496903216100000e+01 }, { "S36",        3.596708076000000e+01 }, { "S37",        3.697112556700000e+01 }, { "S38",        3.797116331700000e+01 },
         { "S39",        3.897513430600000e+01 }, { "S40",        3.997545172800000e+01 }, { "S41",        4.097958214900000e+01 }, { "S42",        4.198102241900000e+01 },
         { "S43",        4.298715479000000e+01 }, { "S44",        4.399021339000000e+01 }, { "S45",        4.499650811200000e+01 }, { "S46",        4.600075000000000e+01 },
         { "S47",        4.700859000000000e+01 }, { "S48",        4.801417000000000e+01 }, { "S49",        4.902361900000000e+01 }, { "Cl_natural", 3.545300000000000e+01 },
         { "Cl28",       2.802851000000000e+01 }, { "Cl29",       2.901411000000000e+01 }, { "Cl30",       3.000477000000000e+01 }, { "Cl31",       3.099241308600000e+01 },
         { "Cl32",       3.198568990100000e+01 }, { "Cl33",       3.297745188700000e+01 }, { "Cl34",       3.397376281900000e+01 }, { "Cl35",       3.496885268200000e+01 },
         { "Cl36",       3.596830698100000e+01 }, { "Cl37",       3.696590259100000e+01 }, { "Cl38",       3.796801042500000e+01 }, { "Cl39",       3.896800816400000e+01 },
         { "Cl40",       3.997041547200000e+01 }, { "Cl41",       4.097068452500000e+01 }, { "Cl42",       4.197325480400000e+01 }, { "Cl43",       4.297405440300000e+01 },
         { "Cl44",       4.397828107100000e+01 }, { "Cl45",       4.498028688600000e+01 }, { "Cl46",       4.598421004000000e+01 }, { "Cl47",       4.698871000000000e+01 },
         { "Cl48",       4.799495000000000e+01 }, { "Cl49",       4.900032000000000e+01 }, { "Cl50",       5.000784000000000e+01 }, { "Cl51",       5.101449000000000e+01 },
         { "Ar_natural", 3.994800000000000e+01 }, { "Ar30",       3.002156000000000e+01 }, { "Ar31",       3.101212300000000e+01 }, { "Ar32",       3.199763798400000e+01 },
         { "Ar33",       3.298992570900000e+01 }, { "Ar34",       3.398027124400000e+01 }, { "Ar35",       3.497525758500000e+01 }, { "Ar36",       3.596754510500000e+01 },
         { "Ar37",       3.696677632000000e+01 }, { "Ar38",       3.796273239400000e+01 }, { "Ar39",       3.896431323100000e+01 }, { "Ar40",       3.996238312251000e+01 },
         { "Ar41",       4.096450061100000e+01 }, { "Ar42",       4.196304573600000e+01 }, { "Ar43",       4.296563605600000e+01 }, { "Ar44",       4.396492403300000e+01 },
         { "Ar45",       4.496803995600000e+01 }, { "Ar46",       4.596809412900000e+01 }, { "Ar47",       4.697218679200000e+01 }, { "Ar48",       4.797454000000000e+01 },
         { "Ar49",       4.898052000000000e+01 }, { "Ar50",       4.998443000000000e+01 }, { "Ar51",       5.099163000000000e+01 }, { "Ar52",       5.199678000000000e+01 },
         { "Ar53",       5.300494000000000e+01 }, { "K_natural",  3.909830000000000e+01 }, { "K32",        3.202192000000000e+01 }, { "K33",        3.300726000000000e+01 },
         { "K34",        3.399841000000000e+01 }, { "K35",        3.498800969200000e+01 }, { "K36",        3.598129223500000e+01 }, { "K37",        3.697337588900000e+01 },
         { "K38",        3.796908118400000e+01 }, { "K39",        3.896370667900000e+01 }, { "K40",        3.996399847500000e+01 }, { "K41",        4.096182576200000e+01 },
         { "K42",        4.196240281000000e+01 }, { "K43",        4.296071554000000e+01 }, { "K44",        4.396155680400000e+01 }, { "K45",        4.496069949300000e+01 },
         { "K46",        4.596197686400000e+01 }, { "K47",        4.696167847300000e+01 }, { "K48",        4.796551353500000e+01 }, { "K49",        4.896745092800000e+01 },
         { "K50",        4.997278335500000e+01 }, { "K51",        5.097638000000000e+01 }, { "K52",        5.198261000000000e+01 }, { "K53",        5.298712000000000e+01 },
         { "K54",        5.399420000000000e+01 }, { "K55",        5.499971000000000e+01 }, { "Ca_natural", 4.008000000000000e+01 }, { "Ca34",       3.401412000000000e+01 },
         { "Ca35",       3.500494000000000e+01 }, { "Ca36",       3.599308706300000e+01 }, { "Ca37",       3.698587026900000e+01 }, { "Ca38",       3.797631845200000e+01 },
         { "Ca39",       3.897071972500000e+01 }, { "Ca40",       3.996259098300000e+01 }, { "Ca41",       4.096227806200000e+01 }, { "Ca42",       4.195861801400000e+01 },
         { "Ca43",       4.295876662800000e+01 }, { "Ca44",       4.395548175400000e+01 }, { "Ca45",       4.495618656600000e+01 }, { "Ca46",       4.595369258700000e+01 },
         { "Ca47",       4.695454600600000e+01 }, { "Ca48",       4.795253417700000e+01 }, { "Ca49",       4.895567414800000e+01 }, { "Ca50",       4.995751896200000e+01 },
         { "Ca51",       5.096149921400000e+01 }, { "Ca52",       5.196510000000000e+01 }, { "Ca53",       5.297005000000000e+01 }, { "Ca54",       5.397435000000000e+01 },
         { "Ca55",       5.498055000000000e+01 }, { "Ca56",       5.598557000000000e+01 }, { "Ca57",       5.699235600000000e+01 }, { "Sc_natural", 4.495590000000000e+01 },
         { "Sc36",       3.601492000000000e+01 }, { "Sc37",       3.700305000000000e+01 }, { "Sc38",       3.799470000000000e+01 }, { "Sc39",       3.898479000200000e+01 },
         { "Sc40",       3.997796740700000e+01 }, { "Sc41",       4.096925112500000e+01 }, { "Sc42",       4.196551642900000e+01 }, { "Sc43",       4.296115065800000e+01 },
         { "Sc44",       4.395940275200000e+01 }, { "Sc45",       4.495591190900000e+01 }, { "Sc46",       4.595517189000000e+01 }, { "Sc47",       4.695240750800000e+01 },
         { "Sc48",       4.795223146800000e+01 }, { "Sc49",       4.895002397500000e+01 }, { "Sc50",       4.995218768500000e+01 }, { "Sc51",       5.095360336800000e+01 },
         { "Sc52",       5.195667546800000e+01 }, { "Sc53",       5.295961000000000e+01 }, { "Sc54",       5.396326456100000e+01 }, { "Sc55",       5.496824394900000e+01 },
         { "Sc56",       5.597287000000000e+01 }, { "Sc57",       5.697779000000000e+01 }, { "Sc58",       5.798371000000000e+01 }, { "Sc59",       5.898922000000000e+01 },
         { "Sc60",       5.999571000000000e+01 }, { "Ti_natural", 4.790000000000000e+01 }, { "Ti38",       3.800977000000000e+01 }, { "Ti39",       3.900161000000000e+01 },
         { "Ti40",       3.999049883800000e+01 }, { "Ti41",       4.098314500000000e+01 }, { "Ti42",       4.197303090200000e+01 }, { "Ti43",       4.296852249900000e+01 },
         { "Ti44",       4.395969006900000e+01 }, { "Ti45",       4.495812561600000e+01 }, { "Ti46",       4.595263155500000e+01 }, { "Ti47",       4.695176308800000e+01 },
         { "Ti48",       4.794794628100000e+01 }, { "Ti49",       4.894786998200000e+01 }, { "Ti50",       4.994479119400000e+01 }, { "Ti51",       5.094661495500000e+01 },
         { "Ti52",       5.194689731100000e+01 }, { "Ti53",       5.294972717100000e+01 }, { "Ti54",       5.395105240100000e+01 }, { "Ti55",       5.495526505600000e+01 },
         { "Ti56",       5.595819963900000e+01 }, { "Ti57",       5.696398913700000e+01 }, { "Ti58",       5.796697000000000e+01 }, { "Ti59",       5.897293000000000e+01 },
         { "Ti60",       5.997676000000000e+01 }, { "Ti61",       6.098320000000000e+01 }, { "Ti62",       6.198749000000000e+01 }, { "Ti63",       6.299442000000000e+01 },
         { "V_natural",  5.094150000000000e+01 }, { "V40",        4.001109000000000e+01 }, { "V41",        4.099978000000000e+01 }, { "V42",        4.199123000000000e+01 },
         { "V43",        4.298065000000000e+01 }, { "V44",        4.397411000000000e+01 }, { "V45",        4.496577580800000e+01 }, { "V46",        4.596020048100000e+01 },
         { "V47",        4.695490894000000e+01 }, { "V48",        4.795225370700000e+01 }, { "V49",        4.894851610100000e+01 }, { "V50",        4.994715848500000e+01 },
         { "V51",        5.094395950700000e+01 }, { "V52",        5.194477547900000e+01 }, { "V53",        5.294433797900000e+01 }, { "V54",        5.394643985400000e+01 },
         { "V55",        5.494723370100000e+01 }, { "V56",        5.595053096600000e+01 }, { "V57",        5.695256143200000e+01 }, { "V58",        5.795683413600000e+01 },
         { "V59",        5.896020740700000e+01 }, { "V60",        5.996502686200000e+01 }, { "V61",        6.096848000000000e+01 }, { "V62",        6.197378000000000e+01 },
         { "V63",        6.297755000000000e+01 }, { "V64",        6.398347000000000e+01 }, { "V65",        6.498792000000000e+01 }, { "Cr_natural", 5.199600000000000e+01 },
         { "Cr42",       4.200643000000000e+01 }, { "Cr43",       4.299771000000000e+01 }, { "Cr44",       4.398554900000000e+01 }, { "Cr45",       4.497964000000000e+01 },
         { "Cr46",       4.596835863500000e+01 }, { "Cr47",       4.696290004600000e+01 }, { "Cr48",       4.795403171600000e+01 }, { "Cr49",       4.895133572100000e+01 },
         { "Cr50",       4.994604420500000e+01 }, { "Cr51",       5.094476743100000e+01 }, { "Cr52",       5.194050747200000e+01 }, { "Cr53",       5.294064938600000e+01 },
         { "Cr54",       5.393888039500000e+01 }, { "Cr55",       5.494083967200000e+01 }, { "Cr56",       5.594065313900000e+01 }, { "Cr57",       5.694361301300000e+01 },
         { "Cr58",       5.794435312900000e+01 }, { "Cr59",       5.894858636700000e+01 }, { "Cr60",       5.995007603300000e+01 }, { "Cr61",       6.095471720400000e+01 },
         { "Cr62",       6.195661319000000e+01 }, { "Cr63",       6.296186000000000e+01 }, { "Cr64",       6.396441000000000e+01 }, { "Cr65",       6.497016000000001e+01 },
         { "Cr66",       6.597338000000001e+01 }, { "Cr67",       6.697955000000000e+01 }, { "Mn_natural", 5.493800000000000e+01 }, { "Mn44",       4.400687000000000e+01 },
         { "Mn45",       4.499451000000000e+01 }, { "Mn46",       4.598672000000000e+01 }, { "Mn47",       4.697610000000000e+01 }, { "Mn48",       4.796852000000000e+01 },
         { "Mn49",       4.895961800500000e+01 }, { "Mn50",       4.995423823000000e+01 }, { "Mn51",       5.094821078700000e+01 }, { "Mn52",       5.194556546400000e+01 },
         { "Mn53",       5.294129011700000e+01 }, { "Mn54",       5.394035885400000e+01 }, { "Mn55",       5.493804514100000e+01 }, { "Mn56",       5.593890491000000e+01 },
         { "Mn57",       5.693828537800000e+01 }, { "Mn58",       5.793998154900000e+01 }, { "Mn59",       5.894044023700000e+01 }, { "Mn60",       5.994291124600000e+01 },
         { "Mn61",       6.094465263800000e+01 }, { "Mn62",       6.194842822000000e+01 }, { "Mn63",       6.295023999000000e+01 }, { "Mn64",       6.395424909000000e+01 },
         { "Mn65",       6.495633606500000e+01 }, { "Mn66",       6.596108000000000e+01 }, { "Mn67",       6.696414000000000e+01 }, { "Mn68",       6.796930000000000e+01 },
         { "Mn69",       6.897284000000001e+01 }, { "Fe_natural", 5.584700000000000e+01 }, { "Fe45",       4.501457800000000e+01 }, { "Fe46",       4.600081000000000e+01 },
         { "Fe47",       4.699289000000000e+01 }, { "Fe48",       4.798050400000000e+01 }, { "Fe49",       4.897361000000000e+01 }, { "Fe50",       4.996298898200000e+01 },
         { "Fe51",       5.095681953800000e+01 }, { "Fe52",       5.194811387500000e+01 }, { "Fe53",       5.294530794200000e+01 }, { "Fe54",       5.393961050100000e+01 },
         { "Fe55",       5.493829335700000e+01 }, { "Fe56",       5.593493747500000e+01 }, { "Fe57",       5.693539396900000e+01 }, { "Fe58",       5.793327555800000e+01 },
         { "Fe59",       5.893487546400000e+01 }, { "Fe60",       5.993407168300000e+01 }, { "Fe61",       6.093674528100000e+01 }, { "Fe62",       6.193676744200000e+01 },
         { "Fe63",       6.294036909100000e+01 }, { "Fe64",       6.394120126500000e+01 }, { "Fe65",       6.494538027000000e+01 }, { "Fe66",       6.594678063800001e+01 },
         { "Fe67",       6.695094724400001e+01 }, { "Fe68",       6.795370000000000e+01 }, { "Fe69",       6.895878000000000e+01 }, { "Fe70",       6.996146000000000e+01 },
         { "Fe71",       7.096672000000000e+01 }, { "Fe72",       7.196962000000001e+01 }, { "Co_natural", 5.893320000000000e+01 }, { "Co47",       4.701149000000000e+01 },
         { "Co48",       4.800176000000000e+01 }, { "Co49",       4.898972000000000e+01 }, { "Co50",       4.998154000000000e+01 }, { "Co51",       5.097072000000000e+01 },
         { "Co52",       5.196359000000000e+01 }, { "Co53",       5.295421889600000e+01 }, { "Co54",       5.394845963500000e+01 }, { "Co55",       5.494199902900000e+01 },
         { "Co56",       5.593983927800000e+01 }, { "Co57",       5.693629137300000e+01 }, { "Co58",       5.793575281400000e+01 }, { "Co59",       5.893319504800000e+01 },
         { "Co60",       5.993381705900000e+01 }, { "Co61",       6.093247576300000e+01 }, { "Co62",       6.193405056300000e+01 }, { "Co63",       6.293361161100000e+01 },
         { "Co64",       6.393580990800000e+01 }, { "Co65",       6.493647846000000e+01 }, { "Co66",       6.593976200400000e+01 }, { "Co67",       6.694088952900000e+01 },
         { "Co68",       6.794487305800000e+01 }, { "Co69",       6.894632000000000e+01 }, { "Co70",       6.995099999999999e+01 }, { "Co71",       7.095290000000000e+01 },
         { "Co72",       7.195780999999999e+01 }, { "Co73",       7.296024000000000e+01 }, { "Co74",       7.396538000000000e+01 }, { "Co75",       7.496832999999999e+01 },
         { "Ni_natural", 5.870000000000000e+01 }, { "Ni48",       4.801975000000000e+01 }, { "Ni49",       4.900966000000000e+01 }, { "Ni50",       4.999593000000000e+01 },
         { "Ni51",       5.098772000000000e+01 }, { "Ni52",       5.197568000000000e+01 }, { "Ni53",       5.296847000000000e+01 }, { "Ni54",       5.395790549500000e+01 },
         { "Ni55",       5.495133025100000e+01 }, { "Ni56",       5.594213202200000e+01 }, { "Ni57",       5.693979352600000e+01 }, { "Ni58",       5.793534290700000e+01 },
         { "Ni59",       5.893434670500000e+01 }, { "Ni60",       5.993078637200000e+01 }, { "Ni61",       6.093105603300000e+01 }, { "Ni62",       6.192834511500000e+01 },
         { "Ni63",       6.292966937400000e+01 }, { "Ni64",       6.392796595900000e+01 }, { "Ni65",       6.493008430400000e+01 }, { "Ni66",       6.592913933400000e+01 },
         { "Ni67",       6.693156941399999e+01 }, { "Ni68",       6.793186878900001e+01 }, { "Ni69",       6.893561026899999e+01 }, { "Ni70",       6.993650000000000e+01 },
         { "Ni71",       7.094073628300001e+01 }, { "Ni72",       7.194209268199999e+01 }, { "Ni73",       7.294647000000001e+01 }, { "Ni74",       7.394807000000000e+01 },
         { "Ni75",       7.495287000000000e+01 }, { "Ni76",       7.595533000000000e+01 }, { "Ni77",       7.696055000000000e+01 }, { "Ni78",       7.796317999999999e+01 },
         { "Cu_natural", 6.354600000000000e+01 }, { "Cu52",       5.199718000000000e+01 }, { "Cu53",       5.298555000000000e+01 }, { "Cu54",       5.397671000000000e+01 },
         { "Cu55",       5.496605000000000e+01 }, { "Cu56",       5.595856000000000e+01 }, { "Cu57",       5.694921107800000e+01 }, { "Cu58",       5.794453849900000e+01 },
         { "Cu59",       5.893949802800000e+01 }, { "Cu60",       5.993736503000000e+01 }, { "Cu61",       6.093345782100000e+01 }, { "Cu62",       6.193258374500000e+01 },
         { "Cu63",       6.292959747400000e+01 }, { "Cu64",       6.392976418300000e+01 }, { "Cu65",       6.492778948500001e+01 }, { "Cu66",       6.592886881299999e+01 },
         { "Cu67",       6.692773031400000e+01 }, { "Cu68",       6.792961088900000e+01 }, { "Cu69",       6.892942926900000e+01 }, { "Cu70",       6.993239234300000e+01 },
         { "Cu71",       7.093267683300000e+01 }, { "Cu72",       7.193582030700000e+01 }, { "Cu73",       7.293667528200000e+01 }, { "Cu74",       7.393987486200000e+01 },
         { "Cu75",       7.494190000000000e+01 }, { "Cu76",       7.594527502600000e+01 }, { "Cu77",       7.694785000000000e+01 }, { "Cu78",       7.795196000000000e+01 },
         { "Cu79",       7.895456000000000e+01 }, { "Cu80",       7.996087000000000e+01 }, { "Zn_natural", 6.538000000000000e+01 }, { "Zn54",       5.399295000000000e+01 },
         { "Zn55",       5.498398000000000e+01 }, { "Zn56",       5.597238000000000e+01 }, { "Zn57",       5.696478800000000e+01 }, { "Zn58",       5.795459155500000e+01 },
         { "Zn59",       5.894926376400000e+01 }, { "Zn60",       5.994182703500000e+01 }, { "Zn61",       6.093951063500000e+01 }, { "Zn62",       6.193432976400000e+01 },
         { "Zn63",       6.293321156600000e+01 }, { "Zn64",       6.392914222200000e+01 }, { "Zn65",       6.492924098400000e+01 }, { "Zn66",       6.592603341900001e+01 },
         { "Zn67",       6.692712734500000e+01 }, { "Zn68",       6.792484415400000e+01 }, { "Zn69",       6.892655028100000e+01 }, { "Zn70",       6.992531927400000e+01 },
         { "Zn71",       7.092772159899999e+01 }, { "Zn72",       7.192685795100000e+01 }, { "Zn73",       7.292977910400000e+01 }, { "Zn74",       7.392945860899999e+01 },
         { "Zn75",       7.493293674100001e+01 }, { "Zn76",       7.593329357000000e+01 }, { "Zn77",       7.693695896700000e+01 }, { "Zn78",       7.793844021600000e+01 },
         { "Zn79",       7.894265200000000e+01 }, { "Zn80",       7.994434234800001e+01 }, { "Zn81",       8.095048000000000e+01 }, { "Zn82",       8.195442000000000e+01 },
         { "Zn83",       8.296102999999999e+01 }, { "Ga_natural", 6.972000000000000e+01 }, { "Ga56",       5.599491000000000e+01 }, { "Ga57",       5.698293000000000e+01 },
         { "Ga58",       5.797425000000000e+01 }, { "Ga59",       5.896337000000000e+01 }, { "Ga60",       5.995706000000000e+01 }, { "Ga61",       6.094944628700000e+01 },
         { "Ga62",       6.194417523800000e+01 }, { "Ga63",       6.293929419600000e+01 }, { "Ga64",       6.393683874700000e+01 }, { "Ga65",       6.493273475399999e+01 },
         { "Ga66",       6.593158901000000e+01 }, { "Ga67",       6.692820170300000e+01 }, { "Ga68",       6.792798008400000e+01 }, { "Ga69",       6.892557358700000e+01 },
         { "Ga70",       6.992602197200000e+01 }, { "Ga71",       7.092470134900000e+01 }, { "Ga72",       7.192636626800000e+01 }, { "Ga73",       7.292517468200001e+01 },
         { "Ga74",       7.392694576200000e+01 }, { "Ga75",       7.492650024600000e+01 }, { "Ga76",       7.592882762600000e+01 }, { "Ga77",       7.692915429999999e+01 },
         { "Ga78",       7.793160818000000e+01 }, { "Ga79",       7.893289326000000e+01 }, { "Ga80",       7.993651578100000e+01 }, { "Ga81",       8.093775235500000e+01 },
         { "Ga82",       8.194298999999999e+01 }, { "Ga83",       8.294698000000000e+01 }, { "Ga84",       8.395265000000001e+01 }, { "Ga85",       8.495699999999999e+01 },
         { "Ga86",       8.596312000000000e+01 }, { "Ge_natural", 7.259000000000000e+01 }, { "Ge58",       5.799101000000000e+01 }, { "Ge59",       5.898175000000000e+01 },
         { "Ge60",       5.997019000000000e+01 }, { "Ge61",       6.096379000000000e+01 }, { "Ge62",       6.195465000000000e+01 }, { "Ge63",       6.294964000000000e+01 },
         { "Ge64",       6.394165300000000e+01 }, { "Ge65",       6.493943640600000e+01 }, { "Ge66",       6.593384345299999e+01 }, { "Ge67",       6.693273407000000e+01 },
         { "Ge68",       6.792809423999999e+01 }, { "Ge69",       6.892796453299999e+01 }, { "Ge70",       6.992424738100000e+01 }, { "Ge71",       7.092495095400000e+01 },
         { "Ge72",       7.192207581500000e+01 }, { "Ge73",       7.292345894499999e+01 }, { "Ge74",       7.392117776700000e+01 }, { "Ge75",       7.492285894800000e+01 },
         { "Ge76",       7.592140255699999e+01 }, { "Ge77",       7.692354859100000e+01 }, { "Ge78",       7.792285273900001e+01 }, { "Ge79",       7.892540099500000e+01 },
         { "Ge80",       7.992537239200000e+01 }, { "Ge81",       8.092882046699999e+01 }, { "Ge82",       8.192954972500000e+01 }, { "Ge83",       8.293462000000000e+01 },
         { "Ge84",       8.393747000000000e+01 }, { "Ge85",       8.494302999999999e+01 }, { "Ge86",       8.594649000000000e+01 }, { "Ge87",       8.695251000000000e+01 },
         { "Ge88",       8.795690999999999e+01 }, { "Ge89",       8.896383000000000e+01 }, { "As_natural", 7.492160000000000e+01 }, { "As60",       5.999313000000000e+01 },
         { "As61",       6.098062000000000e+01 }, { "As62",       6.197320000000000e+01 }, { "As63",       6.296369000000000e+01 }, { "As64",       6.395757200000000e+01 },
         { "As65",       6.494956400000000e+01 }, { "As66",       6.594471000000000e+01 }, { "As67",       6.693918607099999e+01 }, { "As68",       6.793676906899999e+01 },
         { "As69",       6.893227367500000e+01 }, { "As70",       6.993092482599999e+01 }, { "As71",       7.092711242800000e+01 }, { "As72",       7.192675228300000e+01 },
         { "As73",       7.292382484399999e+01 }, { "As74",       7.392392869200000e+01 }, { "As75",       7.492159647800000e+01 }, { "As76",       7.592239402100000e+01 },
         { "As77",       7.692064728600000e+01 }, { "As78",       7.792182728100001e+01 }, { "As79",       7.892094793400000e+01 }, { "As80",       7.992253381600000e+01 },
         { "As81",       8.092213228700000e+01 }, { "As82",       8.192450406700000e+01 }, { "As83",       8.292498002400001e+01 }, { "As84",       8.392905800000000e+01 },
         { "As85",       8.493201999999999e+01 }, { "As86",       8.593650000000000e+01 }, { "As87",       8.693989999999999e+01 }, { "As88",       8.794494000000000e+01 },
         { "As89",       8.894938999999999e+01 }, { "As90",       8.995550000000000e+01 }, { "As91",       9.096043000000000e+01 }, { "As92",       9.196680000000001e+01 },
         { "Se_natural", 7.895999999999999e+01 }, { "Se65",       6.496465999999999e+01 }, { "Se66",       6.595520999999999e+01 }, { "Se67",       6.695009000000000e+01 },
         { "Se68",       6.794179800000001e+01 }, { "Se69",       6.893955781699999e+01 }, { "Se70",       6.993339064400000e+01 }, { "Se71",       7.093224182199999e+01 },
         { "Se72",       7.192711235199999e+01 }, { "Se73",       7.292676534500001e+01 }, { "Se74",       7.392247643600000e+01 }, { "Se75",       7.492252336800000e+01 },
         { "Se76",       7.591921359700000e+01 }, { "Se77",       7.691991403800000e+01 }, { "Se78",       7.791730909000000e+01 }, { "Se79",       7.891849909800000e+01 },
         { "Se80",       7.991652127099999e+01 }, { "Se81",       8.091799247400000e+01 }, { "Se82",       8.191669940100000e+01 }, { "Se83",       8.291911847300000e+01 },
         { "Se84",       8.391846235400000e+01 }, { "Se85",       8.492224505300000e+01 }, { "Se86",       8.592427157900001e+01 }, { "Se87",       8.692852135800000e+01 },
         { "Se88",       8.793142399800000e+01 }, { "Se89",       8.893644999999999e+01 }, { "Se90",       8.993996000000000e+01 }, { "Se91",       9.094596000000000e+01 },
         { "Se92",       9.194992000000001e+01 }, { "Se93",       9.295629000000000e+01 }, { "Se94",       9.396048999999999e+01 }, { "Br_natural", 7.990400000000000e+01 },
         { "Br67",       6.696478999999999e+01 }, { "Br68",       6.795851600000000e+01 }, { "Br69",       6.895010600000001e+01 }, { "Br70",       6.994479200000001e+01 },
         { "Br71",       7.093874000000000e+01 }, { "Br72",       7.193664457200001e+01 }, { "Br73",       7.293169152400000e+01 }, { "Br74",       7.392989103399999e+01 },
         { "Br75",       7.492577620700000e+01 }, { "Br76",       7.592454146900000e+01 }, { "Br77",       7.692137908200000e+01 }, { "Br78",       7.792114570600000e+01 },
         { "Br79",       7.891833708700000e+01 }, { "Br80",       7.991852929600000e+01 }, { "Br81",       8.091629056300000e+01 }, { "Br82",       8.191680411900001e+01 },
         { "Br83",       8.291518042100000e+01 }, { "Br84",       8.391647897400000e+01 }, { "Br85",       8.491560840299999e+01 }, { "Br86",       8.591879757700001e+01 },
         { "Br87",       8.692071132400000e+01 }, { "Br88",       8.792406592600000e+01 }, { "Br89",       8.892638533400000e+01 }, { "Br90",       8.993062773699999e+01 },
         { "Br91",       9.093396809500000e+01 }, { "Br92",       9.193925871400000e+01 }, { "Br93",       9.294305000000000e+01 }, { "Br94",       9.394868000000000e+01 },
         { "Br95",       9.495287000000000e+01 }, { "Br96",       9.595853000000000e+01 }, { "Br97",       9.696280000000000e+01 }, { "Kr_natural", 8.380000000000000e+01 },
         { "Kr69",       6.896518000000000e+01 }, { "Kr70",       6.995525900000000e+01 }, { "Kr71",       7.094962573799999e+01 }, { "Kr72",       7.194209203800000e+01 },
         { "Kr73",       7.293928919500000e+01 }, { "Kr74",       7.393308436900000e+01 }, { "Kr75",       7.493094574600001e+01 }, { "Kr76",       7.592591007800000e+01 },
         { "Kr77",       7.692467000000001e+01 }, { "Kr78",       7.792036478300000e+01 }, { "Kr79",       7.892008243100000e+01 }, { "Kr80",       7.991637896500001e+01 },
         { "Kr81",       8.091659201500001e+01 }, { "Kr82",       8.191348360000001e+01 }, { "Kr83",       8.291413609900000e+01 }, { "Kr84",       8.391150668700000e+01 },
         { "Kr85",       8.491252733100001e+01 }, { "Kr86",       8.591061072900000e+01 }, { "Kr87",       8.691335486200001e+01 }, { "Kr88",       8.791444696900000e+01 },
         { "Kr89",       8.891763058100000e+01 }, { "Kr90",       8.991951655500000e+01 }, { "Kr91",       9.092344521500000e+01 }, { "Kr92",       9.192615621000000e+01 },
         { "Kr93",       9.293127435700001e+01 }, { "Kr94",       9.393436000000000e+01 }, { "Kr95",       9.493984000000000e+01 }, { "Kr96",       9.594307000000001e+01 },
         { "Kr97",       9.694856000000000e+01 }, { "Kr98",       9.795191000000000e+01 }, { "Kr99",       9.895760000000000e+01 }, { "Kr100",      9.996114000000000e+01 },
         { "Rb_natural", 8.546780000000000e+01 }, { "Rb71",       7.096532000000001e+01 }, { "Rb72",       7.195908000000000e+01 }, { "Rb73",       7.295056099999999e+01 },
         { "Rb74",       7.394426475100001e+01 }, { "Rb75",       7.493857000000000e+01 }, { "Rb76",       7.593507222600000e+01 }, { "Rb77",       7.693040800000000e+01 },
         { "Rb78",       7.792814100000000e+01 }, { "Rb79",       7.892398946000000e+01 }, { "Rb80",       7.992251924999999e+01 }, { "Rb81",       8.091899591300000e+01 },
         { "Rb82",       8.191820859800001e+01 }, { "Rb83",       8.291510970100001e+01 }, { "Rb84",       8.391438482100000e+01 }, { "Rb85",       8.491178973700001e+01 },
         { "Rb86",       8.591116741899999e+01 }, { "Rb87",       8.690918052600000e+01 }, { "Rb88",       8.791131558799999e+01 }, { "Rb89",       8.891227801600000e+01 },
         { "Rb90",       8.991480169400000e+01 }, { "Rb91",       9.091653695799999e+01 }, { "Rb92",       9.191972890000000e+01 }, { "Rb93",       9.292204187599999e+01 },
         { "Rb94",       9.392640494600001e+01 }, { "Rb95",       9.492930288900000e+01 }, { "Rb96",       9.593427263700001e+01 }, { "Rb97",       9.693735191600000e+01 },
         { "Rb98",       9.794179066800000e+01 }, { "Rb99",       9.894537928299999e+01 }, { "Rb100",      9.994987000000000e+01 }, { "Rb101",      1.009531964450000e+02 },
         { "Rb102",      1.019588700000000e+02 }, { "Sr_natural", 8.762000000000000e+01 }, { "Sr73",       7.296597000000000e+01 }, { "Sr74",       7.395631000000000e+01 },
         { "Sr75",       7.494994956799999e+01 }, { "Sr76",       7.594176678200000e+01 }, { "Sr77",       7.693794478200000e+01 }, { "Sr78",       7.793218000000000e+01 },
         { "Sr79",       7.892970800000001e+01 }, { "Sr80",       7.992452101300000e+01 }, { "Sr81",       8.092321184600000e+01 }, { "Sr82",       8.191840163900000e+01 },
         { "Sr83",       8.291755670100000e+01 }, { "Sr84",       8.391342527499999e+01 }, { "Sr85",       8.491293280300000e+01 }, { "Sr86",       8.590926020400001e+01 },
         { "Sr87",       8.690887712400000e+01 }, { "Sr88",       8.790561212400000e+01 }, { "Sr89",       8.890745067500001e+01 }, { "Sr90",       8.990773788800000e+01 },
         { "Sr91",       9.091020309500000e+01 }, { "Sr92",       9.191103785800000e+01 }, { "Sr93",       9.291402563400000e+01 }, { "Sr94",       9.391536131200000e+01 },
         { "Sr95",       9.491935876600000e+01 }, { "Sr96",       9.592169680200000e+01 }, { "Sr97",       9.692615292300000e+01 }, { "Sr98",       9.792845293400001e+01 },
         { "Sr99",       9.893324092600000e+01 }, { "Sr100",      9.993535191100000e+01 }, { "Sr101",      1.009405178880000e+02 }, { "Sr102",      1.019430189870000e+02 },
         { "Sr103",      1.029489500000000e+02 }, { "Sr104",      1.039523300000000e+02 }, { "Sr105",      1.049585800000000e+02 }, { "Y_natural",  8.890590000000000e+01 },
         { "Y76",        7.595845000000000e+01 }, { "Y77",        7.694964500000000e+01 }, { "Y78",        7.794361000000001e+01 }, { "Y79",        7.893735163400000e+01 },
         { "Y80",        7.993428000000000e+01 }, { "Y81",        8.092912746800000e+01 }, { "Y82",        8.192679245100000e+01 }, { "Y83",        8.292235424300000e+01 },
         { "Y84",        8.392038826400000e+01 }, { "Y85",        8.491643303900000e+01 }, { "Y86",        8.591488557600000e+01 }, { "Y87",        8.691087573000000e+01 },
         { "Y88",        8.790950114600000e+01 }, { "Y89",        8.890584829500000e+01 }, { "Y90",        8.990715188599999e+01 }, { "Y91",        9.090730479100000e+01 },
         { "Y92",        9.190894914300000e+01 }, { "Y93",        9.290958271300001e+01 }, { "Y94",        9.391159524500000e+01 }, { "Y95",        9.491282062099999e+01 },
         { "Y96",        9.591589134300000e+01 }, { "Y97",        9.691813399500001e+01 }, { "Y98",        9.792220302000000e+01 }, { "Y99",        9.892463620400000e+01 },
         { "Y100",       9.992775658600000e+01 }, { "Y101",       1.009303138500000e+02 }, { "Y102",       1.019335556950000e+02 }, { "Y103",       1.029367300000000e+02 },
         { "Y104",       1.039410500000000e+02 }, { "Y105",       1.049448700000000e+02 }, { "Y106",       1.059497900000000e+02 }, { "Y107",       1.069541400000000e+02 },
         { "Y108",       1.079594800000000e+02 }, { "Zr_natural", 9.122000000000000e+01 }, { "Zr78",       7.795523000000000e+01 }, { "Zr79",       7.894916000000001e+01 },
         { "Zr80",       7.994040000000000e+01 }, { "Zr81",       8.093721002600000e+01 }, { "Zr82",       8.193108700000001e+01 }, { "Zr83",       8.292865380100000e+01 },
         { "Zr84",       8.392325000000000e+01 }, { "Zr85",       8.492147118200000e+01 }, { "Zr86",       8.591647359100000e+01 }, { "Zr87",       8.691481625199999e+01 },
         { "Zr88",       8.791022690400000e+01 }, { "Zr89",       8.890888950000000e+01 }, { "Zr90",       8.990470441600000e+01 }, { "Zr91",       9.090564576700000e+01 },
         { "Zr92",       9.190504084700000e+01 }, { "Zr93",       9.290647600600001e+01 }, { "Zr94",       9.390631519199999e+01 }, { "Zr95",       9.490804260000000e+01 },
         { "Zr96",       9.590827338600000e+01 }, { "Zr97",       9.691095310900000e+01 }, { "Zr98",       9.791273489200000e+01 }, { "Zr99",       9.891651210600000e+01 },
         { "Zr100",      9.991776188900000e+01 }, { "Zr101",      1.009211404150000e+02 }, { "Zr102",      1.019229812850000e+02 }, { "Zr103",      1.029265996060000e+02 },
         { "Zr104",      1.039287800000000e+02 }, { "Zr105",      1.049330500000000e+02 }, { "Zr106",      1.059359100000000e+02 }, { "Zr107",      1.069407500000000e+02 },
         { "Zr108",      1.079439600000000e+02 }, { "Zr109",      1.089492400000000e+02 }, { "Zr110",      1.099528700000000e+02 }, { "Nb_natural", 9.290640000000000e+01 },
         { "Nb81",       8.094902999999999e+01 }, { "Nb82",       8.194313000000000e+01 }, { "Nb83",       8.293670538200000e+01 }, { "Nb84",       8.393357000000000e+01 },
         { "Nb85",       8.492791244700000e+01 }, { "Nb86",       8.592503832600001e+01 }, { "Nb87",       8.692036110799999e+01 }, { "Nb88",       8.791833216300000e+01 },
         { "Nb89",       8.891341824500000e+01 }, { "Nb90",       8.991126484500001e+01 }, { "Nb91",       9.090699624299999e+01 }, { "Nb92",       9.190719388799999e+01 },
         { "Nb93",       9.290637805800000e+01 }, { "Nb94",       9.390728388799999e+01 }, { "Nb95",       9.490683579200000e+01 }, { "Nb96",       9.590810064700000e+01 },
         { "Nb97",       9.690809855600000e+01 }, { "Nb98",       9.791032841200000e+01 }, { "Nb99",       9.891161837500000e+01 }, { "Nb100",      9.991418161900000e+01 },
         { "Nb101",      1.009152520250000e+02 }, { "Nb102",      1.019180376140000e+02 }, { "Nb103",      1.029191438420000e+02 }, { "Nb104",      1.039224647010000e+02 },
         { "Nb105",      1.049239365450000e+02 }, { "Nb106",      1.059279700000000e+02 }, { "Nb107",      1.069303100000000e+02 }, { "Nb108",      1.079348400000000e+02 },
         { "Nb109",      1.089376300000000e+02 }, { "Nb110",      1.099424400000000e+02 }, { "Nb111",      1.109456500000000e+02 }, { "Nb112",      1.119508300000000e+02 },
         { "Nb113",      1.129547000000000e+02 }, { "Mo_natural", 9.594000000000000e+01 }, { "Mo83",       8.294874000000000e+01 }, { "Mo84",       8.394009000000000e+01 },
         { "Mo85",       8.493655000000000e+01 }, { "Mo86",       8.593069590400000e+01 }, { "Mo87",       8.692732650200000e+01 }, { "Mo88",       8.792195324100000e+01 },
         { "Mo89",       8.891948000900000e+01 }, { "Mo90",       8.991393689600000e+01 }, { "Mo91",       9.091175019400001e+01 }, { "Mo92",       9.190681099100000e+01 },
         { "Mo93",       9.290681261000000e+01 }, { "Mo94",       9.390508826900000e+01 }, { "Mo95",       9.490584212900001e+01 }, { "Mo96",       9.590467947700000e+01 },
         { "Mo97",       9.690602146499999e+01 }, { "Mo98",       9.790540816900000e+01 }, { "Mo99",       9.890771187000000e+01 }, { "Mo100",      9.990747733600000e+01 },
         { "Mo101",      1.009103470010000e+02 }, { "Mo102",      1.019102973600000e+02 }, { "Mo103",      1.029132071420000e+02 }, { "Mo104",      1.039137636250000e+02 },
         { "Mo105",      1.049169746100000e+02 }, { "Mo106",      1.059181368020000e+02 }, { "Mo107",      1.069216926040000e+02 }, { "Mo108",      1.079234530000000e+02 },
         { "Mo109",      1.089278100000000e+02 }, { "Mo110",      1.099297300000000e+02 }, { "Mo111",      1.109344100000000e+02 }, { "Mo112",      1.119368400000000e+02 },
         { "Mo113",      1.129418800000000e+02 }, { "Mo114",      1.139449200000000e+02 }, { "Mo115",      1.149502900000000e+02 }, { "Tc_natural", 9.800000000000000e+01 },
         { "Tc85",       8.494883000000000e+01 }, { "Tc86",       8.594288000000000e+01 }, { "Tc87",       8.693653000000000e+01 }, { "Tc88",       8.793267800000000e+01 },
         { "Tc89",       8.892716700000000e+01 }, { "Tc90",       8.992355656399999e+01 }, { "Tc91",       9.091842763900000e+01 }, { "Tc92",       9.191526016600000e+01 },
         { "Tc93",       9.291024898400001e+01 }, { "Tc94",       9.390965700200000e+01 }, { "Tc95",       9.490765708399999e+01 }, { "Tc96",       9.590787138300000e+01 },
         { "Tc97",       9.690636535800000e+01 }, { "Tc98",       9.790721596600000e+01 }, { "Tc99",       9.890625474700001e+01 }, { "Tc100",      9.990765777999999e+01 },
         { "Tc101",      1.009073146590000e+02 }, { "Tc102",      1.019092150190000e+02 }, { "Tc103",      1.029091813510000e+02 }, { "Tc104",      1.039114474540000e+02 },
         { "Tc105",      1.049116605660000e+02 }, { "Tc106",      1.059143579270000e+02 }, { "Tc107",      1.069150795720000e+02 }, { "Tc108",      1.079184612260000e+02 },
         { "Tc109",      1.089199826650000e+02 }, { "Tc110",      1.099238204830000e+02 }, { "Tc111",      1.109256928300000e+02 }, { "Tc112",      1.119291464930000e+02 },
         { "Tc113",      1.129315900000000e+02 }, { "Tc114",      1.139358800000000e+02 }, { "Tc115",      1.149386900000000e+02 }, { "Tc116",      1.159433700000000e+02 },
         { "Tc117",      1.169464800000000e+02 }, { "Tc118",      1.179514800000000e+02 }, { "Ru_natural", 1.010700000000000e+02 }, { "Ru87",       8.694918000000000e+01 },
         { "Ru88",       8.794025999999999e+01 }, { "Ru89",       8.893611000000000e+01 }, { "Ru90",       8.992989000000000e+01 }, { "Ru91",       9.092629200000000e+01 },
         { "Ru92",       9.192012000000000e+01 }, { "Ru93",       9.291705203399999e+01 }, { "Ru94",       9.391135971100000e+01 }, { "Ru95",       9.491041292900000e+01 },
         { "Ru96",       9.590759783500000e+01 }, { "Ru97",       9.690755470000001e+01 }, { "Ru98",       9.790528713200000e+01 }, { "Ru99",       9.890593930199999e+01 },
         { "Ru100",      9.990421947599999e+01 }, { "Ru101",      1.009055820870000e+02 }, { "Ru102",      1.019043493120000e+02 }, { "Ru103",      1.029063238470000e+02 },
         { "Ru104",      1.039054327010000e+02 }, { "Ru105",      1.049077528660000e+02 }, { "Ru106",      1.059073294330000e+02 }, { "Ru107",      1.069099050890000e+02 },
         { "Ru108",      1.079101734650000e+02 }, { "Ru109",      1.089132032330000e+02 }, { "Ru110",      1.099141360410000e+02 }, { "Ru111",      1.109176960000000e+02 },
         { "Ru112",      1.119189650000000e+02 }, { "Ru113",      1.129224871940000e+02 }, { "Ru114",      1.139242810000000e+02 }, { "Ru115",      1.149286861730000e+02 },
         { "Ru116",      1.159308100000000e+02 }, { "Ru117",      1.169355800000000e+02 }, { "Ru118",      1.179378200000000e+02 }, { "Ru119",      1.189428400000000e+02 },
         { "Ru120",      1.199453100000000e+02 }, { "Rh_natural", 1.029055000000000e+02 }, { "Rh89",       8.894883700000000e+01 }, { "Rh90",       8.994287000000000e+01 },
         { "Rh91",       9.093655000000000e+01 }, { "Rh92",       9.193198000000000e+01 }, { "Rh93",       9.292574000000000e+01 }, { "Rh94",       9.392169800000001e+01 },
         { "Rh95",       9.491589874000000e+01 }, { "Rh96",       9.591446063100000e+01 }, { "Rh97",       9.691133679700000e+01 }, { "Rh98",       9.791070815800001e+01 },
         { "Rh99",       9.890813210400000e+01 }, { "Rh100",      9.990812155000000e+01 }, { "Rh101",      1.009061636250000e+02 }, { "Rh102",      1.019068431960000e+02 },
         { "Rh103",      1.029055042920000e+02 }, { "Rh104",      1.039066555180000e+02 }, { "Rh105",      1.049056938210000e+02 }, { "Rh106",      1.059072871350000e+02 },
         { "Rh107",      1.069067484230000e+02 }, { "Rh108",      1.079087280180000e+02 }, { "Rh109",      1.089087372890000e+02 }, { "Rh110",      1.099111364110000e+02 },
         { "Rh111",      1.109115859130000e+02 }, { "Rh112",      1.119143941590000e+02 }, { "Rh113",      1.129155306270000e+02 }, { "Rh114",      1.139188060000000e+02 },
         { "Rh115",      1.149203340000000e+02 }, { "Rh116",      1.159240620000000e+02 }, { "Rh117",      1.169259800000000e+02 }, { "Rh118",      1.179300700000000e+02 },
         { "Rh119",      1.189321100000000e+02 }, { "Rh120",      1.199364100000000e+02 }, { "Rh121",      1.209387200000000e+02 }, { "Rh122",      1.219432100000000e+02 },
         { "Pd_natural", 1.064000000000000e+02 }, { "Pd91",       9.094911000000000e+01 }, { "Pd92",       9.194042000000000e+01 }, { "Pd93",       9.293591000000001e+01 },
         { "Pd94",       9.392877000000000e+01 }, { "Pd95",       9.492469000000000e+01 }, { "Pd96",       9.591816435900000e+01 }, { "Pd97",       9.691647907300000e+01 },
         { "Pd98",       9.791272090200000e+01 }, { "Pd99",       9.891176783300000e+01 }, { "Pd100",      9.990850588600000e+01 }, { "Pd101",      1.009082892420000e+02 },
         { "Pd102",      1.019056085440000e+02 }, { "Pd103",      1.029060873070000e+02 }, { "Pd104",      1.039040358340000e+02 }, { "Pd105",      1.049050849200000e+02 },
         { "Pd106",      1.059034857150000e+02 }, { "Pd107",      1.069051334810000e+02 }, { "Pd108",      1.079038917010000e+02 }, { "Pd109",      1.089059504510000e+02 },
         { "Pd110",      1.099051532540000e+02 }, { "Pd111",      1.109076707340000e+02 }, { "Pd112",      1.119073140580000e+02 }, { "Pd113",      1.129101529080000e+02 },
         { "Pd114",      1.139103626380000e+02 }, { "Pd115",      1.149136838240000e+02 }, { "Pd116",      1.159141586620000e+02 }, { "Pd117",      1.169178413380000e+02 },
         { "Pd118",      1.179189843000000e+02 }, { "Pd119",      1.189231100000000e+02 }, { "Pd120",      1.199246918780000e+02 }, { "Pd121",      1.209288700000000e+02 },
         { "Pd122",      1.219305500000000e+02 }, { "Pd123",      1.229349300000000e+02 }, { "Pd124",      1.239368800000000e+02 }, { "Ag_natural", 1.078680000000000e+02 },
         { "Ag93",       9.294978000000000e+01 }, { "Ag94",       9.394278000000000e+01 }, { "Ag95",       9.493548000000000e+01 }, { "Ag96",       9.593068000000000e+01 },
         { "Ag97",       9.692397241200000e+01 }, { "Ag98",       9.792156620100000e+01 }, { "Ag99",       9.891759717799999e+01 }, { "Ag100",      9.991610425499999e+01 },
         { "Ag101",      1.009128022330000e+02 }, { "Ag102",      1.019116850000000e+02 }, { "Ag103",      1.029089727200000e+02 }, { "Ag104",      1.039086291570000e+02 },
         { "Ag105",      1.049065286610000e+02 }, { "Ag106",      1.059066689210000e+02 }, { "Ag107",      1.069050968200000e+02 }, { "Ag108",      1.079059555560000e+02 },
         { "Ag109",      1.089047522920000e+02 }, { "Ag110",      1.099061072310000e+02 }, { "Ag111",      1.109052911570000e+02 }, { "Ag112",      1.119070048140000e+02 },
         { "Ag113",      1.129065665790000e+02 }, { "Ag114",      1.139088037040000e+02 }, { "Ag115",      1.149087626980000e+02 }, { "Ag116",      1.159113599330000e+02 },
         { "Ag117",      1.169116845620000e+02 }, { "Ag118",      1.179145827680000e+02 }, { "Ag119",      1.189156650590000e+02 }, { "Ag120",      1.199187873840000e+02 },
         { "Ag121",      1.209198480460000e+02 }, { "Ag122",      1.219235300000000e+02 }, { "Ag123",      1.229249000000000e+02 }, { "Ag124",      1.239286400000000e+02 },
         { "Ag125",      1.249304300000000e+02 }, { "Ag126",      1.259345000000000e+02 }, { "Ag127",      1.269367700000000e+02 }, { "Ag128",      1.279411700000000e+02 },
         { "Ag129",      1.289436900000000e+02 }, { "Ag130",      1.299504480000000e+02 }, { "Cd_natural", 1.124100000000000e+02 }, { "Cd95",       9.494987000000000e+01 },
         { "Cd96",       9.593977000000000e+01 }, { "Cd97",       9.693494000000000e+01 }, { "Cd98",       9.792739554600000e+01 }, { "Cd99",       9.892501000000000e+01 },
         { "Cd100",      9.992028952500000e+01 }, { "Cd101",      1.009186815380000e+02 }, { "Cd102",      1.019144622580000e+02 }, { "Cd103",      1.029134192460000e+02 },
         { "Cd104",      1.039098494750000e+02 }, { "Cd105",      1.049094679050000e+02 }, { "Cd106",      1.059064594100000e+02 }, { "Cd107",      1.069066179280000e+02 },
         { "Cd108",      1.079041836830000e+02 }, { "Cd109",      1.089049822930000e+02 }, { "Cd110",      1.099030020700000e+02 }, { "Cd111",      1.109041781070000e+02 },
         { "Cd112",      1.119027578090000e+02 }, { "Cd113",      1.129044016620000e+02 }, { "Cd114",      1.139033585400000e+02 }, { "Cd115",      1.149054309690000e+02 },
         { "Cd116",      1.159047558090000e+02 }, { "Cd117",      1.169072186180000e+02 }, { "Cd118",      1.179069145300000e+02 }, { "Cd119",      1.189099215970000e+02 },
         { "Cd120",      1.199098501290000e+02 }, { "Cd121",      1.209129773630000e+02 }, { "Cd122",      1.219133324320000e+02 }, { "Cd123",      1.229170029990000e+02 },
         { "Cd124",      1.239176476160000e+02 }, { "Cd125",      1.249212463700000e+02 }, { "Cd126",      1.259223533210000e+02 }, { "Cd127",      1.269264438640000e+02 },
         { "Cd128",      1.279277622850000e+02 }, { "Cd129",      1.289321500000000e+02 }, { "Cd130",      1.299339019370000e+02 }, { "Cd131",      1.309406700000000e+02 },
         { "Cd132",      1.319455500000000e+02 }, { "In_natural", 1.148200000000000e+02 }, { "In97",       9.694954000000000e+01 }, { "In98",       9.794213999999999e+01 },
         { "In99",       9.893422000000000e+01 }, { "In100",      9.993111085100000e+01 }, { "In101",      1.009263400000000e+02 }, { "In102",      1.019240902380000e+02 },
         { "In103",      1.029199141880000e+02 }, { "In104",      1.039182961710000e+02 }, { "In105",      1.049146735400000e+02 }, { "In106",      1.059134654110000e+02 },
         { "In107",      1.069102951000000e+02 }, { "In108",      1.079096981800000e+02 }, { "In109",      1.089071505070000e+02 }, { "In110",      1.099071652740000e+02 },
         { "In111",      1.109051032780000e+02 }, { "In112",      1.119055323310000e+02 }, { "In113",      1.129040577610000e+02 }, { "In114",      1.139049138760000e+02 },
         { "In115",      1.149038784840000e+02 }, { "In116",      1.159052597030000e+02 }, { "In117",      1.169045135640000e+02 }, { "In118",      1.179063543670000e+02 },
         { "In119",      1.189058453500000e+02 }, { "In120",      1.199079596080000e+02 }, { "In121",      1.209078458220000e+02 }, { "In122",      1.219102760100000e+02 },
         { "In123",      1.229104382760000e+02 }, { "In124",      1.239131752310000e+02 }, { "In125",      1.249136005880000e+02 }, { "In126",      1.259164638570000e+02 },
         { "In127",      1.269173530910000e+02 }, { "In128",      1.279201723280000e+02 }, { "In129",      1.289216969800000e+02 }, { "In130",      1.299249700490000e+02 },
         { "In131",      1.309268517670000e+02 }, { "In132",      1.319329902600000e+02 }, { "In133",      1.329378100000000e+02 }, { "In134",      1.339441500000000e+02 },
         { "In135",      1.349493300000000e+02 }, { "Sn_natural", 1.186900000000000e+02 }, { "Sn99",       9.894933000000000e+01 }, { "Sn100",      9.993904434300001e+01 },
         { "Sn101",      1.009360600000000e+02 }, { "Sn102",      1.019302953240000e+02 }, { "Sn103",      1.029281000000000e+02 }, { "Sn104",      1.039231432230000e+02 },
         { "Sn105",      1.049213494370000e+02 }, { "Sn106",      1.059168806200000e+02 }, { "Sn107",      1.069156443290000e+02 }, { "Sn108",      1.079119253780000e+02 },
         { "Sn109",      1.089112832140000e+02 }, { "Sn110",      1.099078427910000e+02 }, { "Sn111",      1.109077344600000e+02 }, { "Sn112",      1.119048182070000e+02 },
         { "Sn113",      1.129051705770000e+02 }, { "Sn114",      1.139027788690000e+02 }, { "Sn115",      1.149033423970000e+02 }, { "Sn116",      1.159017405300000e+02 },
         { "Sn117",      1.169029516560000e+02 }, { "Sn118",      1.179016031670000e+02 }, { "Sn119",      1.189033076300000e+02 }, { "Sn120",      1.199021946760000e+02 },
         { "Sn121",      1.209042354800000e+02 }, { "Sn122",      1.219034390460000e+02 }, { "Sn123",      1.229057208380000e+02 }, { "Sn124",      1.239052739460000e+02 },
         { "Sn125",      1.249077841250000e+02 }, { "Sn126",      1.259076532800000e+02 }, { "Sn127",      1.269103600240000e+02 }, { "Sn128",      1.279105366240000e+02 },
         { "Sn129",      1.289134790000000e+02 }, { "Sn130",      1.299139672950000e+02 }, { "Sn131",      1.309169997690000e+02 }, { "Sn132",      1.319178157130000e+02 },
         { "Sn133",      1.329238292490000e+02 }, { "Sn134",      1.339282917650000e+02 }, { "Sn135",      1.349347300000000e+02 }, { "Sn136",      1.359393400000000e+02 },
         { "Sn137",      1.369459900000000e+02 }, { "Sb_natural", 1.217500000000000e+02 }, { "Sb103",      1.029396900000000e+02 }, { "Sb104",      1.039364720000000e+02 },
         { "Sb105",      1.049314863480000e+02 }, { "Sb106",      1.059287910000000e+02 }, { "Sb107",      1.069241500000000e+02 }, { "Sb108",      1.079221600000000e+02 },
         { "Sb109",      1.089181324260000e+02 }, { "Sb110",      1.099167530000000e+02 }, { "Sb111",      1.109131630000000e+02 }, { "Sb112",      1.119123980090000e+02 },
         { "Sb113",      1.129093716720000e+02 }, { "Sb114",      1.139092690000000e+02 }, { "Sb115",      1.149065980000000e+02 }, { "Sb116",      1.159067936290000e+02 },
         { "Sb117",      1.169048359410000e+02 }, { "Sb118",      1.179055287310000e+02 }, { "Sb119",      1.189039420090000e+02 }, { "Sb120",      1.199050724270000e+02 },
         { "Sb121",      1.209038156860000e+02 }, { "Sb122",      1.219051736510000e+02 }, { "Sb123",      1.229042139700000e+02 }, { "Sb124",      1.239059357430000e+02 },
         { "Sb125",      1.249052538180000e+02 }, { "Sb126",      1.259072474800000e+02 }, { "Sb127",      1.269069236090000e+02 }, { "Sb128",      1.279091690010000e+02 },
         { "Sb129",      1.289091484420000e+02 }, { "Sb130",      1.299116563240000e+02 }, { "Sb131",      1.309119822750000e+02 }, { "Sb132",      1.319144668960000e+02 },
         { "Sb133",      1.329152516300000e+02 }, { "Sb134",      1.339203797440000e+02 }, { "Sb135",      1.349251657710000e+02 }, { "Sb136",      1.359303500000000e+02 },
         { "Sb137",      1.369353100000000e+02 }, { "Sb138",      1.379407900000000e+02 }, { "Sb139",      1.389459800000000e+02 }, { "Te_natural", 1.276000000000000e+02 },
         { "Te105",      1.049436400000000e+02 }, { "Te106",      1.059375042370000e+02 }, { "Te107",      1.069350060000000e+02 }, { "Te108",      1.079294445970000e+02 },
         { "Te109",      1.089274155150000e+02 }, { "Te110",      1.099224073160000e+02 }, { "Te111",      1.109211106920000e+02 }, { "Te112",      1.119170136720000e+02 },
         { "Te113",      1.129158910000000e+02 }, { "Te114",      1.139120890000000e+02 }, { "Te115",      1.149119020000000e+02 }, { "Te116",      1.159084600000000e+02 },
         { "Te117",      1.169086447190000e+02 }, { "Te118",      1.179058275810000e+02 }, { "Te119",      1.189064036450000e+02 }, { "Te120",      1.199040202220000e+02 },
         { "Te121",      1.209049364240000e+02 }, { "Te122",      1.219030438980000e+02 }, { "Te123",      1.229042700290000e+02 }, { "Te124",      1.239028178960000e+02 },
         { "Te125",      1.249044307310000e+02 }, { "Te126",      1.259033116960000e+02 }, { "Te127",      1.269052263360000e+02 }, { "Te128",      1.279044630560000e+02 },
         { "Te129",      1.289065982380000e+02 }, { "Te130",      1.299062243990000e+02 }, { "Te131",      1.309085238640000e+02 }, { "Te132",      1.319085531600000e+02 },
         { "Te133",      1.329109553060000e+02 }, { "Te134",      1.339113687370000e+02 }, { "Te135",      1.349164485920000e+02 }, { "Te136",      1.359201012460000e+02 },
         { "Te137",      1.369253229540000e+02 }, { "Te138",      1.379292200000000e+02 }, { "Te139",      1.389347300000000e+02 }, { "Te140",      1.399388500000000e+02 },
         { "Te141",      1.409446500000000e+02 }, { "Te142",      1.419490800000000e+02 }, { "I_natural",  1.269045000000000e+02 }, { "I108",       1.079434750000000e+02 },
         { "I109",       1.089381494170000e+02 }, { "I110",       1.099352420000000e+02 }, { "I111",       1.109302760000000e+02 }, { "I112",       1.119279700000000e+02 },
         { "I113",       1.129236405830000e+02 }, { "I114",       1.139218500000000e+02 }, { "I115",       1.149180480000000e+02 }, { "I116",       1.159168086330000e+02 },
         { "I117",       1.169136500000000e+02 }, { "I118",       1.179130740000000e+02 }, { "I119",       1.189100740000000e+02 }, { "I120",       1.199100481730000e+02 },
         { "I121",       1.209073668110000e+02 }, { "I122",       1.219075892840000e+02 }, { "I123",       1.229055889650000e+02 }, { "I124",       1.239062098520000e+02 },
         { "I125",       1.249046301640000e+02 }, { "I126",       1.259056241530000e+02 }, { "I127",       1.269044726810000e+02 }, { "I128",       1.279058094430000e+02 },
         { "I129",       1.289049877220000e+02 }, { "I130",       1.299066742470000e+02 }, { "I131",       1.309061246090000e+02 }, { "I132",       1.319079973810000e+02 },
         { "I133",       1.329077969390000e+02 }, { "I134",       1.339097444650000e+02 }, { "I135",       1.349100481210000e+02 }, { "I136",       1.359146539930000e+02 },
         { "I137",       1.369178708400000e+02 }, { "I138",       1.379223495910000e+02 }, { "I139",       1.389260994780000e+02 }, { "I140",       1.399310000000000e+02 },
         { "I141",       1.409350300000000e+02 }, { "I142",       1.419401800000000e+02 }, { "I143",       1.429445600000000e+02 }, { "I144",       1.439499900000000e+02 },
         { "Xe_natural", 1.313000000000000e+02 }, { "Xe110",      1.099442780680000e+02 }, { "Xe111",      1.109416020000000e+02 }, { "Xe112",      1.119356231120000e+02 },
         { "Xe113",      1.129333411740000e+02 }, { "Xe114",      1.139279803060000e+02 }, { "Xe115",      1.149262939200000e+02 }, { "Xe116",      1.159215810870000e+02 },
         { "Xe117",      1.169203587350000e+02 }, { "Xe118",      1.179161786550000e+02 }, { "Xe119",      1.189154106880000e+02 }, { "Xe120",      1.199117842440000e+02 },
         { "Xe121",      1.209114618290000e+02 }, { "Xe122",      1.219083676320000e+02 }, { "Xe123",      1.229084819100000e+02 }, { "Xe124",      1.239058930030000e+02 },
         { "Xe125",      1.249063954640000e+02 }, { "Xe126",      1.259042736340000e+02 }, { "Xe127",      1.269051837230000e+02 }, { "Xe128",      1.279035312750000e+02 },
         { "Xe129",      1.289047794350000e+02 }, { "Xe130",      1.299035080070000e+02 }, { "Xe131",      1.309050823620000e+02 }, { "Xe132",      1.319041534570000e+02 },
         { "Xe133",      1.329059107220000e+02 }, { "Xe134",      1.339053944640000e+02 }, { "Xe135",      1.349072274950000e+02 }, { "Xe136",      1.359072187940000e+02 },
         { "Xe137",      1.369115621250000e+02 }, { "Xe138",      1.379139544750000e+02 }, { "Xe139",      1.389187929360000e+02 }, { "Xe140",      1.399216409430000e+02 },
         { "Xe141",      1.409266480490000e+02 }, { "Xe142",      1.419297095900000e+02 }, { "Xe143",      1.429351100000000e+02 }, { "Xe144",      1.439385100000000e+02 },
         { "Xe145",      1.449440700000000e+02 }, { "Xe146",      1.459477500000000e+02 }, { "Xe147",      1.469535600000000e+02 }, { "Cs_natural", 1.329054000000000e+02 },
         { "Cs112",      1.119503010000000e+02 }, { "Cs113",      1.129444932740000e+02 }, { "Cs114",      1.139414500000000e+02 }, { "Cs115",      1.149359100000000e+02 },
         { "Cs116",      1.159333670000000e+02 }, { "Cs117",      1.169286707010000e+02 }, { "Cs118",      1.179265594940000e+02 }, { "Cs119",      1.189223773040000e+02 },
         { "Cs120",      1.199206772530000e+02 }, { "Cs121",      1.209172292090000e+02 }, { "Cs122",      1.219161134340000e+02 }, { "Cs123",      1.229129960360000e+02 },
         { "Cs124",      1.239122577980000e+02 }, { "Cs125",      1.249097282700000e+02 }, { "Cs126",      1.259094519770000e+02 }, { "Cs127",      1.269074175250000e+02 },
         { "Cs128",      1.279077488660000e+02 }, { "Cs129",      1.289060644260000e+02 }, { "Cs130",      1.299067085520000e+02 }, { "Cs131",      1.309054639260000e+02 },
         { "Cs132",      1.319064342600000e+02 }, { "Cs133",      1.329054519320000e+02 }, { "Cs134",      1.339067184750000e+02 }, { "Cs135",      1.349059770080000e+02 },
         { "Cs136",      1.359073115760000e+02 }, { "Cs137",      1.369070894730000e+02 }, { "Cs138",      1.379110167040000e+02 }, { "Cs139",      1.389133639990000e+02 },
         { "Cs140",      1.399172823540000e+02 }, { "Cs141",      1.409200457520000e+02 }, { "Cs142",      1.419242989270000e+02 }, { "Cs143",      1.429273517500000e+02 },
         { "Cs144",      1.439320769140000e+02 }, { "Cs145",      1.449355261700000e+02 }, { "Cs146",      1.459402894230000e+02 }, { "Cs147",      1.469441550080000e+02 },
         { "Cs148",      1.479492181530000e+02 }, { "Cs149",      1.489529300000000e+02 }, { "Cs150",      1.499581700000000e+02 }, { "Cs151",      1.509621900000000e+02 },
         { "Ba_natural", 1.373300000000000e+02 }, { "Ba114",      1.139506754050000e+02 }, { "Ba115",      1.149473700000000e+02 }, { "Ba116",      1.159413800000000e+02 },
         { "Ba117",      1.169384990000000e+02 }, { "Ba118",      1.179330400000000e+02 }, { "Ba119",      1.189306596610000e+02 }, { "Ba120",      1.199260449740000e+02 },
         { "Ba121",      1.209240544990000e+02 }, { "Ba122",      1.219199040000000e+02 }, { "Ba123",      1.229187810360000e+02 }, { "Ba124",      1.239150936030000e+02 },
         { "Ba125",      1.249144729120000e+02 }, { "Ba126",      1.259112501770000e+02 }, { "Ba127",      1.269110937970000e+02 }, { "Ba128",      1.279083176980000e+02 },
         { "Ba129",      1.289086794390000e+02 }, { "Ba130",      1.299063208110000e+02 }, { "Ba131",      1.309069411180000e+02 }, { "Ba132",      1.319050612880000e+02 },
         { "Ba133",      1.329060074900000e+02 }, { "Ba134",      1.339045083830000e+02 }, { "Ba135",      1.349056885910000e+02 }, { "Ba136",      1.359045759450000e+02 },
         { "Ba137",      1.369058273840000e+02 }, { "Ba138",      1.379052472370000e+02 }, { "Ba139",      1.389088413410000e+02 }, { "Ba140",      1.399106045050000e+02 },
         { "Ba141",      1.409144110090000e+02 }, { "Ba142",      1.419164534100000e+02 }, { "Ba143",      1.429206267190000e+02 }, { "Ba144",      1.439229528530000e+02 },
         { "Ba145",      1.449276270320000e+02 }, { "Ba146",      1.459302195720000e+02 }, { "Ba147",      1.469349450000000e+02 }, { "Ba148",      1.479377200470000e+02 },
         { "Ba149",      1.489425800000000e+02 }, { "Ba150",      1.499456800000000e+02 }, { "Ba151",      1.509508100000000e+02 }, { "Ba152",      1.519542700000000e+02 },
         { "Ba153",      1.529596100000000e+02 }, { "La_natural", 1.389055000000000e+02 }, { "La117",      1.169500680000000e+02 }, { "La118",      1.179467300000000e+02 },
         { "La119",      1.189409900000000e+02 }, { "La120",      1.199380700000000e+02 }, { "La121",      1.209330100000000e+02 }, { "La122",      1.219307100000000e+02 },
         { "La123",      1.229262400000000e+02 }, { "La124",      1.239245742750000e+02 }, { "La125",      1.249208160340000e+02 }, { "La126",      1.259195126670000e+02 },
         { "La127",      1.269163754480000e+02 }, { "La128",      1.279155851770000e+02 }, { "La129",      1.289126928150000e+02 }, { "La130",      1.299123687240000e+02 },
         { "La131",      1.309100700000000e+02 }, { "La132",      1.319101011450000e+02 }, { "La133",      1.329082180000000e+02 }, { "La134",      1.339085140110000e+02 },
         { "La135",      1.349069768440000e+02 }, { "La136",      1.359076355360000e+02 }, { "La137",      1.369064935980000e+02 }, { "La138",      1.379071119300000e+02 },
         { "La139",      1.389063532670000e+02 }, { "La140",      1.399094776450000e+02 }, { "La141",      1.409109621520000e+02 }, { "La142",      1.419140791300000e+02 },
         { "La143",      1.429160627200000e+02 }, { "La144",      1.439195996470000e+02 }, { "La145",      1.449216454010000e+02 }, { "La146",      1.459257934600000e+02 },
         { "La147",      1.469282352840000e+02 }, { "La148",      1.479322288680000e+02 }, { "La149",      1.489347340000000e+02 }, { "La150",      1.499387700000000e+02 },
         { "La151",      1.509417200000000e+02 }, { "La152",      1.519462500000000e+02 }, { "La153",      1.529496200000000e+02 }, { "La154",      1.539545000000000e+02 },
         { "La155",      1.549583500000000e+02 }, { "Ce_natural", 1.401200000000000e+02 }, { "Ce119",      1.189527600000000e+02 }, { "Ce120",      1.199466400000000e+02 },
         { "Ce121",      1.209434200000000e+02 }, { "Ce122",      1.219379100000000e+02 }, { "Ce123",      1.229354000000000e+02 }, { "Ce124",      1.239304100000000e+02 },
         { "Ce125",      1.249284400000000e+02 }, { "Ce126",      1.259239710000000e+02 }, { "Ce127",      1.269227310000000e+02 }, { "Ce128",      1.279189110000000e+02 },
         { "Ce129",      1.289181020000000e+02 }, { "Ce130",      1.299147360000000e+02 }, { "Ce131",      1.309144220000000e+02 }, { "Ce132",      1.319114604870000e+02 },
         { "Ce133",      1.329115150200000e+02 }, { "Ce134",      1.339089248210000e+02 }, { "Ce135",      1.349091513960000e+02 }, { "Ce136",      1.359071724220000e+02 },
         { "Ce137",      1.369078055770000e+02 }, { "Ce138",      1.379059913210000e+02 }, { "Ce139",      1.389066526510000e+02 }, { "Ce140",      1.399054387060000e+02 },
         { "Ce141",      1.409082762700000e+02 }, { "Ce142",      1.419092442050000e+02 }, { "Ce143",      1.429123859100000e+02 }, { "Ce144",      1.439136473360000e+02 },
         { "Ce145",      1.449172331350000e+02 }, { "Ce146",      1.459187590090000e+02 }, { "Ce147",      1.469226739540000e+02 }, { "Ce148",      1.479244324100000e+02 },
         { "Ce149",      1.489283998830000e+02 }, { "Ce150",      1.499304089310000e+02 }, { "Ce151",      1.509339761960000e+02 }, { "Ce152",      1.519365400000000e+02 },
         { "Ce153",      1.529405800000000e+02 }, { "Ce154",      1.539434200000000e+02 }, { "Ce155",      1.549480400000000e+02 }, { "Ce156",      1.559512600000000e+02 },
         { "Ce157",      1.569563400000000e+02 }, { "Pr_natural", 1.409077000000000e+02 }, { "Pr121",      1.209553640000000e+02 }, { "Pr122",      1.219518100000000e+02 },
         { "Pr123",      1.229459600000000e+02 }, { "Pr124",      1.239429600000000e+02 }, { "Pr125",      1.249378300000000e+02 }, { "Pr126",      1.259353100000000e+02 },
         { "Pr127",      1.269308300000000e+02 }, { "Pr128",      1.279287910000000e+02 }, { "Pr129",      1.289250950000000e+02 }, { "Pr130",      1.299235900000000e+02 },
         { "Pr131",      1.309202590000000e+02 }, { "Pr132",      1.319192550000000e+02 }, { "Pr133",      1.329163305320000e+02 }, { "Pr134",      1.339157117370000e+02 },
         { "Pr135",      1.349131117450000e+02 }, { "Pr136",      1.359126916110000e+02 }, { "Pr137",      1.369107054550000e+02 }, { "Pr138",      1.379107546360000e+02 },
         { "Pr139",      1.389089383990000e+02 }, { "Pr140",      1.399090758740000e+02 }, { "Pr141",      1.409076527690000e+02 }, { "Pr142",      1.419100448060000e+02 },
         { "Pr143",      1.429108169260000e+02 }, { "Pr144",      1.439133052450000e+02 }, { "Pr145",      1.449145117000000e+02 }, { "Pr146",      1.459176443360000e+02 },
         { "Pr147",      1.469189959920000e+02 }, { "Pr148",      1.479221350260000e+02 }, { "Pr149",      1.489237176510000e+02 }, { "Pr150",      1.499266729970000e+02 },
         { "Pr151",      1.509283186180000e+02 }, { "Pr152",      1.519314992250000e+02 }, { "Pr153",      1.529338389050000e+02 }, { "Pr154",      1.539375181530000e+02 },
         { "Pr155",      1.549401200000000e+02 }, { "Pr156",      1.559442700000000e+02 }, { "Pr157",      1.569474300000000e+02 }, { "Pr158",      1.579519800000000e+02 },
         { "Pr159",      1.589555000000000e+02 }, { "Nd_natural", 1.442400000000000e+02 }, { "Nd124",      1.239522300000000e+02 }, { "Nd125",      1.249488800000000e+02 },
         { "Nd126",      1.259432200000000e+02 }, { "Nd127",      1.269405000000000e+02 }, { "Nd128",      1.279353900000000e+02 }, { "Nd129",      1.289331880000000e+02 },
         { "Nd130",      1.299285060000000e+02 }, { "Nd131",      1.309272470000000e+02 }, { "Nd132",      1.319233212370000e+02 }, { "Nd133",      1.329223480000000e+02 },
         { "Nd134",      1.339187901810000e+02 }, { "Nd135",      1.349181811600000e+02 }, { "Nd136",      1.359149760350000e+02 }, { "Nd137",      1.369145671370000e+02 },
         { "Nd138",      1.379119499610000e+02 }, { "Nd139",      1.389119782880000e+02 }, { "Nd140",      1.399095520000000e+02 }, { "Nd141",      1.409096098540000e+02 },
         { "Nd142",      1.419077232970000e+02 }, { "Nd143",      1.429098142900000e+02 }, { "Nd144",      1.439100872740000e+02 }, { "Nd145",      1.449125736360000e+02 },
         { "Nd146",      1.459131169390000e+02 }, { "Nd147",      1.469161004410000e+02 }, { "Nd148",      1.479168932880000e+02 }, { "Nd149",      1.489201488420000e+02 },
         { "Nd150",      1.499208908880000e+02 }, { "Nd151",      1.509238289290000e+02 }, { "Nd152",      1.519246822190000e+02 }, { "Nd153",      1.529276982320000e+02 },
         { "Nd154",      1.539294773070000e+02 }, { "Nd155",      1.549329320000000e+02 }, { "Nd156",      1.559350181140000e+02 }, { "Nd157",      1.569390300000000e+02 },
         { "Nd158",      1.579416000000000e+02 }, { "Nd159",      1.589460900000000e+02 }, { "Nd160",      1.599490900000000e+02 }, { "Nd161",      1.609538800000000e+02 },
         { "Pm_natural", 1.450000000000000e+02 }, { "Pm126",      1.259575200000000e+02 }, { "Pm127",      1.269516300000000e+02 }, { "Pm128",      1.279484200000000e+02 },
         { "Pm129",      1.289431600000000e+02 }, { "Pm130",      1.299404500000000e+02 }, { "Pm131",      1.309358700000000e+02 }, { "Pm132",      1.319337500000000e+02 },
         { "Pm133",      1.329297820000000e+02 }, { "Pm134",      1.339283530000000e+02 }, { "Pm135",      1.349248760000000e+02 }, { "Pm136",      1.359235658290000e+02 },
         { "Pm137",      1.369204794930000e+02 }, { "Pm138",      1.379195482810000e+02 }, { "Pm139",      1.389168040820000e+02 }, { "Pm140",      1.399160417890000e+02 },
         { "Pm141",      1.409135550540000e+02 }, { "Pm142",      1.419128744710000e+02 }, { "Pm143",      1.429109326160000e+02 }, { "Pm144",      1.439125908430000e+02 },
         { "Pm145",      1.449127490230000e+02 }, { "Pm146",      1.459146963050000e+02 }, { "Pm147",      1.469151385450000e+02 }, { "Pm148",      1.479174746180000e+02 },
         { "Pm149",      1.489183341550000e+02 }, { "Pm150",      1.499209835610000e+02 }, { "Pm151",      1.509212069730000e+02 }, { "Pm152",      1.519234967950000e+02 },
         { "Pm153",      1.529241168890000e+02 }, { "Pm154",      1.539264639430000e+02 }, { "Pm155",      1.549281012670000e+02 }, { "Pm156",      1.559310567360000e+02 },
         { "Pm157",      1.569330393690000e+02 }, { "Pm158",      1.579365614070000e+02 }, { "Pm159",      1.589389700000000e+02 }, { "Pm160",      1.599429900000000e+02 },
         { "Pm161",      1.609458600000000e+02 }, { "Pm162",      1.619502900000000e+02 }, { "Pm163",      1.629536800000000e+02 }, { "Sm_natural", 1.504000000000000e+02 },
         { "Sm128",      1.279580800000000e+02 }, { "Sm129",      1.289546400000000e+02 }, { "Sm130",      1.299489200000000e+02 }, { "Sm131",      1.309461100000000e+02 },
         { "Sm132",      1.319406900000000e+02 }, { "Sm133",      1.329386700000000e+02 }, { "Sm134",      1.339339700000000e+02 }, { "Sm135",      1.349325200000000e+02 },
         { "Sm136",      1.359282755270000e+02 }, { "Sm137",      1.369269717460000e+02 }, { "Sm138",      1.379232439610000e+02 }, { "Sm139",      1.389222966050000e+02 },
         { "Sm140",      1.399189946870000e+02 }, { "Sm141",      1.409184764880000e+02 }, { "Sm142",      1.419151976410000e+02 }, { "Sm143",      1.429146283380000e+02 },
         { "Sm144",      1.439119994780000e+02 }, { "Sm145",      1.449134103530000e+02 }, { "Sm146",      1.459130409000000e+02 }, { "Sm147",      1.469148979230000e+02 },
         { "Sm148",      1.479148226740000e+02 }, { "Sm149",      1.489171847350000e+02 }, { "Sm150",      1.499172755390000e+02 }, { "Sm151",      1.509199324090000e+02 },
         { "Sm152",      1.519197324250000e+02 }, { "Sm153",      1.529220973560000e+02 }, { "Sm154",      1.539222092730000e+02 }, { "Sm155",      1.549246401610000e+02 },
         { "Sm156",      1.559255278870000e+02 }, { "Sm157",      1.569283587170000e+02 }, { "Sm158",      1.579299913170000e+02 }, { "Sm159",      1.589332112710000e+02 },
         { "Sm160",      1.599351400000000e+02 }, { "Sm161",      1.609388300000000e+02 }, { "Sm162",      1.619412200000000e+02 }, { "Sm163",      1.629453600000000e+02 },
         { "Sm164",      1.639482800000000e+02 }, { "Sm165",      1.649529800000000e+02 }, { "Eu_natural", 1.519600000000000e+02 }, { "Eu130",      1.299635690000000e+02 },
         { "Eu131",      1.309577530000000e+02 }, { "Eu132",      1.319543700000000e+02 }, { "Eu133",      1.329492400000000e+02 }, { "Eu134",      1.339465100000000e+02 },
         { "Eu135",      1.349418200000000e+02 }, { "Eu136",      1.359396000000000e+02 }, { "Eu137",      1.369355700000000e+02 }, { "Eu138",      1.379337090000000e+02 },
         { "Eu139",      1.389297922800000e+02 }, { "Eu140",      1.399280876070000e+02 }, { "Eu141",      1.409249307200000e+02 }, { "Eu142",      1.419234349450000e+02 },
         { "Eu143",      1.429202975090000e+02 }, { "Eu144",      1.439188168230000e+02 }, { "Eu145",      1.449162652370000e+02 }, { "Eu146",      1.459172058170000e+02 },
         { "Eu147",      1.469167461110000e+02 }, { "Eu148",      1.479180858950000e+02 }, { "Eu149",      1.489179312380000e+02 }, { "Eu150",      1.499197018190000e+02 },
         { "Eu151",      1.509198501610000e+02 }, { "Eu152",      1.519217445340000e+02 }, { "Eu153",      1.529212303390000e+02 }, { "Eu154",      1.539229792370000e+02 },
         { "Eu155",      1.549228932600000e+02 }, { "Eu156",      1.559247522490000e+02 }, { "Eu157",      1.569254236470000e+02 }, { "Eu158",      1.579278453020000e+02 },
         { "Eu159",      1.589290888610000e+02 }, { "Eu160",      1.599319710000000e+02 }, { "Eu161",      1.609336800000000e+02 }, { "Eu162",      1.619370400000000e+02 },
         { "Eu163",      1.629392100000000e+02 }, { "Eu164",      1.639429900000000e+02 }, { "Eu165",      1.649457200000000e+02 }, { "Eu166",      1.659499700000000e+02 },
         { "Eu167",      1.669532100000000e+02 }, { "Gd_natural", 1.572500000000000e+02 }, { "Gd134",      1.339553700000000e+02 }, { "Gd135",      1.349525700000000e+02 },
         { "Gd136",      1.359473400000000e+02 }, { "Gd137",      1.369450200000000e+02 }, { "Gd138",      1.379401200000000e+02 }, { "Gd139",      1.389382400000000e+02 },
         { "Gd140",      1.399336740000000e+02 }, { "Gd141",      1.409321260000000e+02 }, { "Gd142",      1.419281160000000e+02 }, { "Gd143",      1.429267495100000e+02 },
         { "Gd144",      1.439229630000000e+02 }, { "Gd145",      1.449217092520000e+02 }, { "Gd146",      1.459183106080000e+02 }, { "Gd147",      1.469190944200000e+02 },
         { "Gd148",      1.479181145240000e+02 }, { "Gd149",      1.489193409150000e+02 }, { "Gd150",      1.499186588760000e+02 }, { "Gd151",      1.509203484820000e+02 },
         { "Gd152",      1.519197909960000e+02 }, { "Gd153",      1.529217495430000e+02 }, { "Gd154",      1.539208655980000e+02 }, { "Gd155",      1.549226220220000e+02 },
         { "Gd156",      1.559221227430000e+02 }, { "Gd157",      1.569239601350000e+02 }, { "Gd158",      1.579241039120000e+02 }, { "Gd159",      1.589263886580000e+02 },
         { "Gd160",      1.599270541460000e+02 }, { "Gd161",      1.609296692110000e+02 }, { "Gd162",      1.619309847510000e+02 }, { "Gd163",      1.629339900000000e+02 },
         { "Gd164",      1.639358600000000e+02 }, { "Gd165",      1.649393800000000e+02 }, { "Gd166",      1.659416000000000e+02 }, { "Gd167",      1.669455700000000e+02 },
         { "Gd168",      1.679483600000000e+02 }, { "Gd169",      1.689528700000000e+02 }, { "Tb_natural", 1.589254000000000e+02 }, { "Tb136",      1.359613800000000e+02 },
         { "Tb137",      1.369559800000000e+02 }, { "Tb138",      1.379531600000000e+02 }, { "Tb139",      1.389482900000000e+02 }, { "Tb140",      1.399458050490000e+02 },
         { "Tb141",      1.409414480000000e+02 }, { "Tb142",      1.419387440000000e+02 }, { "Tb143",      1.429351210000000e+02 }, { "Tb144",      1.439330450000000e+02 },
         { "Tb145",      1.449292740000000e+02 }, { "Tb146",      1.459272465840000e+02 }, { "Tb147",      1.469240445850000e+02 }, { "Tb148",      1.479242717010000e+02 },
         { "Tb149",      1.489232459090000e+02 }, { "Tb150",      1.499236596860000e+02 }, { "Tb151",      1.509231025430000e+02 }, { "Tb152",      1.519240744380000e+02 },
         { "Tb153",      1.529234345880000e+02 }, { "Tb154",      1.539246780190000e+02 }, { "Tb155",      1.549235052360000e+02 }, { "Tb156",      1.559247472130000e+02 },
         { "Tb157",      1.569240246040000e+02 }, { "Tb158",      1.579254131370000e+02 }, { "Tb159",      1.589253467570000e+02 }, { "Tb160",      1.599271676060000e+02 },
         { "Tb161",      1.609275699190000e+02 }, { "Tb162",      1.619294882340000e+02 }, { "Tb163",      1.629306475360000e+02 }, { "Tb164",      1.639333508380000e+02 },
         { "Tb165",      1.649348800000000e+02 }, { "Tb166",      1.659379919590000e+02 }, { "Tb167",      1.669400500000000e+02 }, { "Tb168",      1.679436400000000e+02 },
         { "Tb169",      1.689462200000000e+02 }, { "Tb170",      1.699502500000000e+02 }, { "Tb171",      1.709533000000000e+02 }, { "Dy_natural", 1.625000000000000e+02 },
         { "Dy138",      1.379624900000000e+02 }, { "Dy139",      1.389595400000000e+02 }, { "Dy140",      1.399540100000000e+02 }, { "Dy141",      1.409513500000000e+02 },
         { "Dy142",      1.419463660000000e+02 }, { "Dy143",      1.429438300000000e+02 }, { "Dy144",      1.439392540000000e+02 }, { "Dy145",      1.449374250000000e+02 },
         { "Dy146",      1.459328453690000e+02 }, { "Dy147",      1.469310915000000e+02 }, { "Dy148",      1.479271498310000e+02 }, { "Dy149",      1.489273047870000e+02 },
         { "Dy150",      1.499255851840000e+02 }, { "Dy151",      1.509261846010000e+02 }, { "Dy152",      1.519247183000000e+02 }, { "Dy153",      1.529257646700000e+02 },
         { "Dy154",      1.539244244570000e+02 }, { "Dy155",      1.549257537750000e+02 }, { "Dy156",      1.559242831100000e+02 }, { "Dy157",      1.569254660950000e+02 },
         { "Dy158",      1.579244094870000e+02 }, { "Dy159",      1.589257392140000e+02 }, { "Dy160",      1.599251975170000e+02 }, { "Dy161",      1.609269333640000e+02 },
         { "Dy162",      1.619267984470000e+02 }, { "Dy163",      1.629287311590000e+02 }, { "Dy164",      1.639291747510000e+02 }, { "Dy165",      1.649317033330000e+02 },
         { "Dy166",      1.659328067410000e+02 }, { "Dy167",      1.669356554620000e+02 }, { "Dy168",      1.679371287690000e+02 }, { "Dy169",      1.689403076140000e+02 },
         { "Dy170",      1.699423900000000e+02 }, { "Dy171",      1.709462000000000e+02 }, { "Dy172",      1.719487600000000e+02 }, { "Dy173",      1.729530000000000e+02 },
         { "Ho_natural", 1.649304000000000e+02 }, { "Ho140",      1.399685390000000e+02 }, { "Ho141",      1.409630980000000e+02 }, { "Ho142",      1.419597700000000e+02 },
         { "Ho143",      1.429546100000000e+02 }, { "Ho144",      1.439514800000000e+02 }, { "Ho145",      1.449472000000000e+02 }, { "Ho146",      1.459446400000000e+02 },
         { "Ho147",      1.469400560000000e+02 }, { "Ho148",      1.479377180000000e+02 }, { "Ho149",      1.489337747710000e+02 }, { "Ho150",      1.499334961820000e+02 },
         { "Ho151",      1.509316881420000e+02 }, { "Ho152",      1.519317137140000e+02 }, { "Ho153",      1.529301987890000e+02 }, { "Ho154",      1.539306015790000e+02 },
         { "Ho155",      1.549291034910000e+02 }, { "Ho156",      1.559298390000000e+02 }, { "Ho157",      1.569282561880000e+02 }, { "Ho158",      1.579289410070000e+02 },
         { "Ho159",      1.589277119590000e+02 }, { "Ho160",      1.599287294780000e+02 }, { "Ho161",      1.609278547760000e+02 }, { "Ho162",      1.619290955040000e+02 },
         { "Ho163",      1.629287339030000e+02 }, { "Ho164",      1.639302335070000e+02 }, { "Ho165",      1.649303220700000e+02 }, { "Ho166",      1.659322841620000e+02 },
         { "Ho167",      1.669331326330000e+02 }, { "Ho168",      1.679355157080000e+02 }, { "Ho169",      1.689368722730000e+02 }, { "Ho170",      1.699396189290000e+02 },
         { "Ho171",      1.709414651500000e+02 }, { "Ho172",      1.719448200000000e+02 }, { "Ho173",      1.729472900000000e+02 }, { "Ho174",      1.739511500000000e+02 },
         { "Ho175",      1.749540500000000e+02 }, { "Er_natural", 1.672600000000000e+02 }, { "Er143",      1.429663400000000e+02 }, { "Er144",      1.439603800000000e+02 },
         { "Er145",      1.449573900000000e+02 }, { "Er146",      1.459520000000000e+02 }, { "Er147",      1.469494900000000e+02 }, { "Er148",      1.479445500000000e+02 },
         { "Er149",      1.489423060000000e+02 }, { "Er150",      1.499379138390000e+02 }, { "Er151",      1.509374489030000e+02 }, { "Er152",      1.519350503890000e+02 },
         { "Er153",      1.529350634920000e+02 }, { "Er154",      1.539327830810000e+02 }, { "Er155",      1.549332089490000e+02 }, { "Er156",      1.559310646980000e+02 },
         { "Er157",      1.569319160000000e+02 }, { "Er158",      1.579298934740000e+02 }, { "Er159",      1.589306840660000e+02 }, { "Er160",      1.599290832920000e+02 },
         { "Er161",      1.609299953090000e+02 }, { "Er162",      1.619287782640000e+02 }, { "Er163",      1.629300327490000e+02 }, { "Er164",      1.639292002290000e+02 },
         { "Er165",      1.649307260030000e+02 }, { "Er166",      1.659302930610000e+02 }, { "Er167",      1.669320481590000e+02 }, { "Er168",      1.679323702240000e+02 },
         { "Er169",      1.689345903640000e+02 }, { "Er170",      1.699354643120000e+02 }, { "Er171",      1.709380298080000e+02 }, { "Er172",      1.719393561130000e+02 },
         { "Er173",      1.729424000000000e+02 }, { "Er174",      1.739442300000000e+02 }, { "Er175",      1.749477700000000e+02 }, { "Er176",      1.759500800000000e+02 },
         { "Er177",      1.769540500000000e+02 }, { "Tm_natural", 1.689342000000000e+02 }, { "Tm145",      1.449700730000000e+02 }, { "Tm146",      1.459664250000000e+02 },
         { "Tm147",      1.469609610000000e+02 }, { "Tm148",      1.479578400000000e+02 }, { "Tm149",      1.489527200000000e+02 }, { "Tm150",      1.499499600000000e+02 },
         { "Tm151",      1.509454834900000e+02 }, { "Tm152",      1.519444220000000e+02 }, { "Tm153",      1.529420121120000e+02 }, { "Tm154",      1.539415678080000e+02 },
         { "Tm155",      1.549391994590000e+02 }, { "Tm156",      1.559389799330000e+02 }, { "Tm157",      1.569369730000000e+02 }, { "Tm158",      1.579369795250000e+02 },
         { "Tm159",      1.589349750000000e+02 }, { "Tm160",      1.599352628010000e+02 }, { "Tm161",      1.609335490000000e+02 }, { "Tm162",      1.619339946820000e+02 },
         { "Tm163",      1.629326511240000e+02 }, { "Tm164",      1.639335600000000e+02 }, { "Tm165",      1.649324354920000e+02 }, { "Tm166",      1.659335541310000e+02 },
         { "Tm167",      1.669328516220000e+02 }, { "Tm168",      1.679341727760000e+02 }, { "Tm169",      1.689342132500000e+02 }, { "Tm170",      1.699358013970000e+02 },
         { "Tm171",      1.709364294400000e+02 }, { "Tm172",      1.719384000440000e+02 }, { "Tm173",      1.729396036070000e+02 }, { "Tm174",      1.739421686050000e+02 },
         { "Tm175",      1.749438368530000e+02 }, { "Tm176",      1.759469946850000e+02 }, { "Tm177",      1.769490400000000e+02 }, { "Tm178",      1.779526400000000e+02 },
         { "Tm179",      1.789553400000000e+02 }, { "Yb_natural", 1.730400000000000e+02 }, { "Yb148",      1.479674200000000e+02 }, { "Yb149",      1.489640400000000e+02 },
         { "Yb150",      1.499584200000000e+02 }, { "Yb151",      1.509554007690000e+02 }, { "Yb152",      1.519502889190000e+02 }, { "Yb153",      1.529494800000000e+02 },
         { "Yb154",      1.539463939280000e+02 }, { "Yb155",      1.549457823320000e+02 }, { "Yb156",      1.559428182150000e+02 }, { "Yb157",      1.569426278480000e+02 },
         { "Yb158",      1.579398656170000e+02 }, { "Yb159",      1.589400500990000e+02 }, { "Yb160",      1.599375523440000e+02 }, { "Yb161",      1.609379016780000e+02 },
         { "Yb162",      1.619357682100000e+02 }, { "Yb163",      1.629363343050000e+02 }, { "Yb164",      1.639344894160000e+02 }, { "Yb165",      1.649352790000000e+02 },
         { "Yb166",      1.659338820420000e+02 }, { "Yb167",      1.669349496050000e+02 }, { "Yb168",      1.679338968950000e+02 }, { "Yb169",      1.689351898020000e+02 },
         { "Yb170",      1.699347618370000e+02 }, { "Yb171",      1.709363257990000e+02 }, { "Yb172",      1.719363814690000e+02 }, { "Yb173",      1.729382107870000e+02 },
         { "Yb174",      1.739388620890000e+02 }, { "Yb175",      1.749412764500000e+02 }, { "Yb176",      1.759425716830000e+02 }, { "Yb177",      1.769452608220000e+02 },
         { "Yb178",      1.779466466800000e+02 }, { "Yb179",      1.789501700000000e+02 }, { "Yb180",      1.799523300000000e+02 }, { "Yb181",      1.809561500000000e+02 },
         { "Lu_natural", 1.749670000000000e+02 }, { "Lu150",      1.499732280000000e+02 }, { "Lu151",      1.509675770000000e+02 }, { "Lu152",      1.519641200000000e+02 },
         { "Lu153",      1.529587673310000e+02 }, { "Lu154",      1.539575220000000e+02 }, { "Lu155",      1.549543162160000e+02 }, { "Lu156",      1.559530325230000e+02 },
         { "Lu157",      1.569500983000000e+02 }, { "Lu158",      1.579493132830000e+02 }, { "Lu159",      1.589466287760000e+02 }, { "Lu160",      1.599460330000000e+02 },
         { "Lu161",      1.609435720000000e+02 }, { "Lu162",      1.619432772880000e+02 }, { "Lu163",      1.629411790000000e+02 }, { "Lu164",      1.639413390000000e+02 },
         { "Lu165",      1.649394067240000e+02 }, { "Lu166",      1.659398590000000e+02 }, { "Lu167",      1.669382700000000e+02 }, { "Lu168",      1.679387391110000e+02 },
         { "Lu169",      1.689376514390000e+02 }, { "Lu170",      1.699384749680000e+02 }, { "Lu171",      1.709379131360000e+02 }, { "Lu172",      1.719390856690000e+02 },
         { "Lu173",      1.729389306020000e+02 }, { "Lu174",      1.739403374800000e+02 }, { "Lu175",      1.749407718190000e+02 }, { "Lu176",      1.759426863100000e+02 },
         { "Lu177",      1.769437580550000e+02 }, { "Lu178",      1.779459545590000e+02 }, { "Lu179",      1.789473274430000e+02 }, { "Lu180",      1.799498811600000e+02 },
         { "Lu181",      1.809519700000000e+02 }, { "Lu182",      1.819550400000000e+02 }, { "Lu183",      1.829575700000000e+02 }, { "Lu184",      1.839609100000000e+02 },
         { "Hf_natural", 1.784900000000000e+02 }, { "Hf153",      1.529706900000000e+02 }, { "Hf154",      1.539648600000000e+02 }, { "Hf155",      1.549633900000000e+02 },
         { "Hf156",      1.559593640250000e+02 }, { "Hf157",      1.569583960000000e+02 }, { "Hf158",      1.579547993660000e+02 }, { "Hf159",      1.589539948700000e+02 },
         { "Hf160",      1.599506843790000e+02 }, { "Hf161",      1.609502748440000e+02 }, { "Hf162",      1.619472104980000e+02 }, { "Hf163",      1.629470890000000e+02 },
         { "Hf164",      1.639443672840000e+02 }, { "Hf165",      1.649445670000000e+02 }, { "Hf166",      1.659421800000000e+02 }, { "Hf167",      1.669426000000000e+02 },
         { "Hf168",      1.679405680000000e+02 }, { "Hf169",      1.689412590000000e+02 }, { "Hf170",      1.699396090000000e+02 }, { "Hf171",      1.709404920000000e+02 },
         { "Hf172",      1.719394483010000e+02 }, { "Hf173",      1.729405130000000e+02 }, { "Hf174",      1.739400461780000e+02 }, { "Hf175",      1.749415091810000e+02 },
         { "Hf176",      1.759414086310000e+02 }, { "Hf177",      1.769432206510000e+02 }, { "Hf178",      1.779436987660000e+02 }, { "Hf179",      1.789458161450000e+02 },
         { "Hf180",      1.799465499530000e+02 }, { "Hf181",      1.809491012460000e+02 }, { "Hf182",      1.819505540960000e+02 }, { "Hf183",      1.829535304390000e+02 },
         { "Hf184",      1.839554465150000e+02 }, { "Hf185",      1.849588200000000e+02 }, { "Hf186",      1.859608900000000e+02 }, { "Hf187",      1.869645900000000e+02 },
         { "Hf188",      1.879668500000000e+02 }, { "Ta_natural", 1.809479000000000e+02 }, { "Ta155",      1.549745920000000e+02 }, { "Ta156",      1.559723030000000e+02 },
         { "Ta157",      1.569681924450000e+02 }, { "Ta158",      1.579666990000000e+02 }, { "Ta159",      1.589630181730000e+02 }, { "Ta160",      1.599614860560000e+02 },
         { "Ta161",      1.609584170000000e+02 }, { "Ta162",      1.619572918590000e+02 }, { "Ta163",      1.629543302710000e+02 }, { "Ta164",      1.639535340000000e+02 },
         { "Ta165",      1.649507725140000e+02 }, { "Ta166",      1.659505120000000e+02 }, { "Ta167",      1.669480930000000e+02 }, { "Ta168",      1.679480470000000e+02 },
         { "Ta169",      1.689460110000000e+02 }, { "Ta170",      1.699461750000000e+02 }, { "Ta171",      1.709444760000000e+02 }, { "Ta172",      1.719448950000000e+02 },
         { "Ta173",      1.729437500000000e+02 }, { "Ta174",      1.739444540000000e+02 }, { "Ta175",      1.749437370000000e+02 }, { "Ta176",      1.759448570000000e+02 },
         { "Ta177",      1.769444724030000e+02 }, { "Ta178",      1.779457782210000e+02 }, { "Ta179",      1.789459295350000e+02 }, { "Ta180",      1.799474648310000e+02 },
         { "Ta181",      1.809479957630000e+02 }, { "Ta182",      1.819501518490000e+02 }, { "Ta183",      1.829513726160000e+02 }, { "Ta184",      1.839540079660000e+02 },
         { "Ta185",      1.849555593750000e+02 }, { "Ta186",      1.859585520230000e+02 }, { "Ta187",      1.869605300000000e+02 }, { "Ta188",      1.879637000000000e+02 },
         { "Ta189",      1.889658300000000e+02 }, { "Ta190",      1.899692300000000e+02 }, { "W_natural",  1.838500000000000e+02 }, { "W158",       1.579745620000000e+02 },
         { "W159",       1.589729180000000e+02 }, { "W160",       1.599684788050000e+02 }, { "W161",       1.609673570000000e+02 }, { "W162",       1.619634974170000e+02 },
         { "W163",       1.629625235420000e+02 }, { "W164",       1.639589543820000e+02 }, { "W165",       1.649582799490000e+02 }, { "W166",       1.659550272530000e+02 },
         { "W167",       1.669548160140000e+02 }, { "W168",       1.679518083940000e+02 }, { "W169",       1.689517787900000e+02 }, { "W170",       1.699492284820000e+02 },
         { "W171",       1.709494510000000e+02 }, { "W172",       1.719472920000000e+02 }, { "W173",       1.729476890000000e+02 }, { "W174",       1.739460790000000e+02 },
         { "W175",       1.749467170000000e+02 }, { "W176",       1.759456340000000e+02 }, { "W177",       1.769466430000000e+02 }, { "W178",       1.779458762360000e+02 },
         { "W179",       1.789470704470000e+02 }, { "W180",       1.799467044590000e+02 }, { "W181",       1.809481972480000e+02 }, { "W182",       1.819482041560000e+02 },
         { "W183",       1.829502229510000e+02 }, { "W184",       1.839509311880000e+02 }, { "W185",       1.849534192640000e+02 }, { "W186",       1.859543641270000e+02 },
         { "W187",       1.869571604660000e+02 }, { "W188",       1.879584891050000e+02 }, { "W189",       1.889619128680000e+02 }, { "W190",       1.899631813780000e+02 },
         { "W191",       1.909666000000000e+02 }, { "W192",       1.919681700000000e+02 }, { "Re_natural", 1.862070000000000e+02 }, { "Re160",      1.599821150000000e+02 },
         { "Re161",      1.609775891190000e+02 }, { "Re162",      1.619760020000000e+02 }, { "Re163",      1.629720805350000e+02 }, { "Re164",      1.639703230000000e+02 },
         { "Re165",      1.649670885570000e+02 }, { "Re166",      1.659658080000000e+02 }, { "Re167",      1.669626010000000e+02 }, { "Re168",      1.679615726080000e+02 },
         { "Re169",      1.689587910960000e+02 }, { "Re170",      1.699582200710000e+02 }, { "Re171",      1.709557160000000e+02 }, { "Re172",      1.719554229610000e+02 },
         { "Re173",      1.729532430000000e+02 }, { "Re174",      1.739531150000000e+02 }, { "Re175",      1.749513810000000e+02 }, { "Re176",      1.759516230000000e+02 },
         { "Re177",      1.769503280000000e+02 }, { "Re178",      1.779509890000000e+02 }, { "Re179",      1.789499876410000e+02 }, { "Re180",      1.799507890840000e+02 },
         { "Re181",      1.809500679160000e+02 }, { "Re182",      1.819512100800000e+02 }, { "Re183",      1.829508198410000e+02 }, { "Re184",      1.839525207560000e+02 },
         { "Re185",      1.849529549820000e+02 }, { "Re186",      1.859549860840000e+02 }, { "Re187",      1.869557531090000e+02 }, { "Re188",      1.879581144380000e+02 },
         { "Re189",      1.889592290070000e+02 }, { "Re190",      1.899618179770000e+02 }, { "Re191",      1.909631252420000e+02 }, { "Re192",      1.919659600000000e+02 },
         { "Re193",      1.929674700000000e+02 }, { "Re194",      1.939704200000000e+02 }, { "Os_natural", 1.902000000000000e+02 }, { "Os162",      1.619844310000000e+02 },
         { "Os163",      1.629826900000000e+02 }, { "Os164",      1.639780356490000e+02 }, { "Os165",      1.649767620000000e+02 }, { "Os166",      1.659726907530000e+02 },
         { "Os167",      1.669715479690000e+02 }, { "Os168",      1.679678036780000e+02 }, { "Os169",      1.689670192700000e+02 }, { "Os170",      1.699635770280000e+02 },
         { "Os171",      1.709631848190000e+02 }, { "Os172",      1.719600233030000e+02 }, { "Os173",      1.729598084090000e+02 }, { "Os174",      1.739570622020000e+02 },
         { "Os175",      1.749569458350000e+02 }, { "Os176",      1.759548060000000e+02 }, { "Os177",      1.769549653240000e+02 }, { "Os178",      1.779532512410000e+02 },
         { "Os179",      1.789538160170000e+02 }, { "Os180",      1.799523788030000e+02 }, { "Os181",      1.809532440000000e+02 }, { "Os182",      1.819521101860000e+02 },
         { "Os183",      1.829531261020000e+02 }, { "Os184",      1.839524890710000e+02 }, { "Os185",      1.849540422650000e+02 }, { "Os186",      1.859538381580000e+02 },
         { "Os187",      1.869557504580000e+02 }, { "Os188",      1.879558382280000e+02 }, { "Os189",      1.889581474700000e+02 }, { "Os190",      1.899584470480000e+02 },
         { "Os191",      1.909609297180000e+02 }, { "Os192",      1.919614806900000e+02 }, { "Os193",      1.929641515630000e+02 }, { "Os194",      1.939651820830000e+02 },
         { "Os195",      1.949681266610000e+02 }, { "Os196",      1.959696393330000e+02 }, { "Ir_natural", 1.922200000000000e+02 }, { "Ir164",      1.639922010000000e+02 },
         { "Ir165",      1.649875200000000e+02 }, { "Ir166",      1.659858240000000e+02 }, { "Ir167",      1.669816651560000e+02 }, { "Ir168",      1.679798810000000e+02 },
         { "Ir169",      1.689762949420000e+02 }, { "Ir170",      1.699749650000000e+02 }, { "Ir171",      1.709716260420000e+02 }, { "Ir172",      1.719704560000000e+02 },
         { "Ir173",      1.729675017390000e+02 }, { "Ir174",      1.739668610450000e+02 }, { "Ir175",      1.749641128950000e+02 }, { "Ir176",      1.759636486880000e+02 },
         { "Ir177",      1.769613015000000e+02 }, { "Ir178",      1.779610820000000e+02 }, { "Ir179",      1.789591222660000e+02 }, { "Ir180",      1.799592294460000e+02 },
         { "Ir181",      1.809576252970000e+02 }, { "Ir182",      1.819580762960000e+02 }, { "Ir183",      1.829568464580000e+02 }, { "Ir184",      1.839574760000000e+02 },
         { "Ir185",      1.849566980000000e+02 }, { "Ir186",      1.859579461040000e+02 }, { "Ir187",      1.869573633610000e+02 }, { "Ir188",      1.879588531210000e+02 },
         { "Ir189",      1.889587189350000e+02 }, { "Ir190",      1.899605459680000e+02 }, { "Ir191",      1.909605940460000e+02 }, { "Ir192",      1.919626050120000e+02 },
         { "Ir193",      1.929629264300000e+02 }, { "Ir194",      1.939650783780000e+02 }, { "Ir195",      1.949659795730000e+02 }, { "Ir196",      1.959683965420000e+02 },
         { "Ir197",      1.969696532850000e+02 }, { "Ir198",      1.979722800000000e+02 }, { "Ir199",      1.989738045830000e+02 }, { "Pt_natural", 1.950900000000000e+02 },
         { "Pt166",      1.659948550000000e+02 }, { "Pt167",      1.669929790000000e+02 }, { "Pt168",      1.679881507420000e+02 }, { "Pt169",      1.689867150000000e+02 },
         { "Pt170",      1.699824952890000e+02 }, { "Pt171",      1.709812445420000e+02 }, { "Pt172",      1.719773471280000e+02 }, { "Pt173",      1.729764447540000e+02 },
         { "Pt174",      1.739728187670000e+02 }, { "Pt175",      1.749724205520000e+02 }, { "Pt176",      1.759689446220000e+02 }, { "Pt177",      1.769684694810000e+02 },
         { "Pt178",      1.779656487240000e+02 }, { "Pt179",      1.789653634040000e+02 }, { "Pt180",      1.799630314770000e+02 }, { "Pt181",      1.809630972850000e+02 },
         { "Pt182",      1.819611706560000e+02 }, { "Pt183",      1.829615967030000e+02 }, { "Pt184",      1.839599222510000e+02 }, { "Pt185",      1.849606190000000e+02 },
         { "Pt186",      1.859593508130000e+02 }, { "Pt187",      1.869605870000000e+02 }, { "Pt188",      1.879593953910000e+02 }, { "Pt189",      1.889608336860000e+02 },
         { "Pt190",      1.899599316550000e+02 }, { "Pt191",      1.909616766610000e+02 }, { "Pt192",      1.919610380050000e+02 }, { "Pt193",      1.929629874010000e+02 },
         { "Pt194",      1.939626802530000e+02 }, { "Pt195",      1.949647911340000e+02 }, { "Pt196",      1.959649515210000e+02 }, { "Pt197",      1.969673401820000e+02 },
         { "Pt198",      1.979678927900000e+02 }, { "Pt199",      1.989705930940000e+02 }, { "Pt200",      1.999714406770000e+02 }, { "Pt201",      2.009745128680000e+02 },
         { "Pt202",      2.019757400000000e+02 }, { "Au_natural", 1.969665000000000e+02 }, { "Au169",      1.689980800000000e+02 }, { "Au170",      1.699961220000000e+02 },
         { "Au171",      1.709918788810000e+02 }, { "Au172",      1.719900350000000e+02 }, { "Au173",      1.729862373800000e+02 }, { "Au174",      1.739847610000000e+02 },
         { "Au175",      1.749812741070000e+02 }, { "Au176",      1.759800990000000e+02 }, { "Au177",      1.769768649080000e+02 }, { "Au178",      1.779760319200000e+02 },
         { "Au179",      1.789732128120000e+02 }, { "Au180",      1.799725211240000e+02 }, { "Au181",      1.809700790480000e+02 }, { "Au182",      1.819696178740000e+02 },
         { "Au183",      1.829675930340000e+02 }, { "Au184",      1.839674515240000e+02 }, { "Au185",      1.849657894110000e+02 }, { "Au186",      1.859659527030000e+02 },
         { "Au187",      1.869645675410000e+02 }, { "Au188",      1.879653236610000e+02 }, { "Au189",      1.889639482860000e+02 }, { "Au190",      1.899647003390000e+02 },
         { "Au191",      1.909637042250000e+02 }, { "Au192",      1.919648129530000e+02 }, { "Au193",      1.929641497150000e+02 }, { "Au194",      1.939653652500000e+02 },
         { "Au195",      1.949650346400000e+02 }, { "Au196",      1.959665698130000e+02 }, { "Au197",      1.969665686620000e+02 }, { "Au198",      1.979682423030000e+02 },
         { "Au199",      1.989687651930000e+02 }, { "Au200",      1.999707256470000e+02 }, { "Au201",      2.009716572400000e+02 }, { "Au202",      2.019738058380000e+02 },
         { "Au203",      2.029751545420000e+02 }, { "Au204",      2.039777240000000e+02 }, { "Au205",      2.049798700000000e+02 }, { "Hg_natural", 2.005900000000000e+02 },
         { "Hg171",      1.710037600000000e+02 }, { "Hg172",      1.719988326860000e+02 }, { "Hg173",      1.729972420000000e+02 }, { "Hg174",      1.739928636950000e+02 },
         { "Hg175",      1.749914232700000e+02 }, { "Hg176",      1.759873545800000e+02 }, { "Hg177",      1.769862791580000e+02 }, { "Hg178",      1.779824831430000e+02 },
         { "Hg179",      1.789818338610000e+02 }, { "Hg180",      1.799782663940000e+02 }, { "Hg181",      1.809778193110000e+02 }, { "Hg182",      1.819746899640000e+02 },
         { "Hg183",      1.829744498410000e+02 }, { "Hg184",      1.839717130510000e+02 }, { "Hg185",      1.849718990860000e+02 }, { "Hg186",      1.859693617900000e+02 },
         { "Hg187",      1.869698142360000e+02 }, { "Hg188",      1.879675770490000e+02 }, { "Hg189",      1.889681900340000e+02 }, { "Hg190",      1.899663224490000e+02 },
         { "Hg191",      1.909671571050000e+02 }, { "Hg192",      1.919656343270000e+02 }, { "Hg193",      1.929666654210000e+02 }, { "Hg194",      1.939654394090000e+02 },
         { "Hg195",      1.949667201130000e+02 }, { "Hg196",      1.959658326490000e+02 }, { "Hg197",      1.969672129080000e+02 }, { "Hg198",      1.979667690320000e+02 },
         { "Hg199",      1.989682799320000e+02 }, { "Hg200",      1.999683260040000e+02 }, { "Hg201",      2.009703022680000e+02 }, { "Hg202",      2.019706430110000e+02 },
         { "Hg203",      2.029728724840000e+02 }, { "Hg204",      2.039734939330000e+02 }, { "Hg205",      2.049760733860000e+02 }, { "Hg206",      2.059775140660000e+02 },
         { "Hg207",      2.069825885450000e+02 }, { "Hg208",      2.079859400000000e+02 }, { "Hg209",      2.089910400000000e+02 }, { "Hg210",      2.099945100000000e+02 },
         { "Tl_natural", 2.043700000000000e+02 }, { "Tl176",      1.760005900000000e+02 }, { "Tl177",      1.769964272860000e+02 }, { "Tl178",      1.779948970000000e+02 },
         { "Tl179",      1.789910890820000e+02 }, { "Tl180",      1.799899060000000e+02 }, { "Tl181",      1.809862574470000e+02 }, { "Tl182",      1.819856671040000e+02 },
         { "Tl183",      1.829821928020000e+02 }, { "Tl184",      1.839818731220000e+02 }, { "Tl185",      1.849787913050000e+02 }, { "Tl186",      1.859783250000000e+02 },
         { "Tl187",      1.869759058970000e+02 }, { "Tl188",      1.879760097820000e+02 }, { "Tl189",      1.889735884280000e+02 }, { "Tl190",      1.899738771490000e+02 },
         { "Tl191",      1.909717861540000e+02 }, { "Tl192",      1.919722250000000e+02 }, { "Tl193",      1.929706720000000e+02 }, { "Tl194",      1.939712000000000e+02 },
         { "Tl195",      1.949697743350000e+02 }, { "Tl196",      1.959704811510000e+02 }, { "Tl197",      1.969695745110000e+02 }, { "Tl198",      1.979704834950000e+02 },
         { "Tl199",      1.989698770000000e+02 }, { "Tl200",      1.999709626720000e+02 }, { "Tl201",      2.009708188910000e+02 }, { "Tl202",      2.019721058080000e+02 },
         { "Tl203",      2.029723442200000e+02 }, { "Tl204",      2.039738635220000e+02 }, { "Tl205",      2.049744275410000e+02 }, { "Tl206",      2.059761103200000e+02 },
         { "Tl207",      2.069774194290000e+02 }, { "Tl208",      2.079820187000000e+02 }, { "Tl209",      2.089853589520000e+02 }, { "Tl210",      2.099900736890000e+02 },
         { "Tl211",      2.109934770000000e+02 }, { "Tl212",      2.119982280000000e+02 }, { "Pb_natural", 2.072000000000000e+02 }, { "Pb178",      1.780038301910000e+02 },
         { "Pb179",      1.790021500000000e+02 }, { "Pb180",      1.799979181730000e+02 }, { "Pb181",      1.809966239580000e+02 }, { "Pb182",      1.819926718420000e+02 },
         { "Pb183",      1.829918746290000e+02 }, { "Pb184",      1.839881423390000e+02 }, { "Pb185",      1.849876099440000e+02 }, { "Pb186",      1.859842389450000e+02 },
         { "Pb187",      1.869839183700000e+02 }, { "Pb188",      1.879808743380000e+02 }, { "Pb189",      1.889808070000000e+02 }, { "Pb190",      1.899780815170000e+02 },
         { "Pb191",      1.909782650000000e+02 }, { "Pb192",      1.919757851710000e+02 }, { "Pb193",      1.929761732340000e+02 }, { "Pb194",      1.939740120700000e+02 },
         { "Pb195",      1.949745420500000e+02 }, { "Pb196",      1.959727741090000e+02 }, { "Pb197",      1.969734311240000e+02 }, { "Pb198",      1.979720339590000e+02 },
         { "Pb199",      1.989729166500000e+02 }, { "Pb200",      1.999718266750000e+02 }, { "Pb201",      2.009728845110000e+02 }, { "Pb202",      2.019721591330000e+02 },
         { "Pb203",      2.029733905210000e+02 }, { "Pb204",      2.039730435890000e+02 }, { "Pb205",      2.049744817550000e+02 }, { "Pb206",      2.059744652780000e+02 },
         { "Pb207",      2.069758968870000e+02 }, { "Pb208",      2.079766520710000e+02 }, { "Pb209",      2.089810901200000e+02 }, { "Pb210",      2.099841885270000e+02 },
         { "Pb211",      2.109887369640000e+02 }, { "Pb212",      2.119918975430000e+02 }, { "Pb213",      2.129965814990000e+02 }, { "Pb214",      2.139998054080000e+02 },
         { "Pb215",      2.150048070000000e+02 }, { "Bi_natural", 2.089804000000000e+02 }, { "Bi184",      1.840011240000000e+02 }, { "Bi185",      1.849976250000000e+02 },
         { "Bi186",      1.859965976250000e+02 }, { "Bi187",      1.869931578350000e+02 }, { "Bi188",      1.879922651540000e+02 }, { "Bi189",      1.889891990120000e+02 },
         { "Bi190",      1.899882951290000e+02 }, { "Bi191",      1.909857861190000e+02 }, { "Bi192",      1.919854579540000e+02 }, { "Bi193",      1.929829597710000e+02 },
         { "Bi194",      1.939828339600000e+02 }, { "Bi195",      1.949806507370000e+02 }, { "Bi196",      1.959806665090000e+02 }, { "Bi197",      1.969788644540000e+02 },
         { "Bi198",      1.979792060000000e+02 }, { "Bi199",      1.989776719610000e+02 }, { "Bi200",      1.999781318290000e+02 }, { "Bi201",      2.009770090360000e+02 },
         { "Bi202",      2.019777423240000e+02 }, { "Bi203",      2.029768760010000e+02 }, { "Bi204",      2.039778127360000e+02 }, { "Bi205",      2.049773893660000e+02 },
         { "Bi206",      2.059784991300000e+02 }, { "Bi207",      2.069784706790000e+02 }, { "Bi208",      2.079797421960000e+02 }, { "Bi209",      2.089803987340000e+02 },
         { "Bi210",      2.099841203710000e+02 }, { "Bi211",      2.109872694600000e+02 }, { "Bi212",      2.119912857240000e+02 }, { "Bi213",      2.129943846660000e+02 },
         { "Bi214",      2.139987115390000e+02 }, { "Bi215",      2.150017697760000e+02 }, { "Bi216",      2.160063059430000e+02 }, { "Bi217",      2.170094700000000e+02 },
         { "Bi218",      2.180143160000000e+02 }, { "Po_natural", 2.090000000000000e+02 }, { "Po188",      1.879994220480000e+02 }, { "Po189",      1.889984805620000e+02 },
         { "Po190",      1.899951011850000e+02 }, { "Po191",      1.909945744850000e+02 }, { "Po192",      1.919913351490000e+02 }, { "Po193",      1.929910252750000e+02 },
         { "Po194",      1.939881856060000e+02 }, { "Po195",      1.949881107280000e+02 }, { "Po196",      1.959855345800000e+02 }, { "Po197",      1.969856596300000e+02 },
         { "Po198",      1.979833886160000e+02 }, { "Po199",      1.989836660630000e+02 }, { "Po200",      1.999817986040000e+02 }, { "Po201",      2.009822597640000e+02 },
         { "Po202",      2.019807575410000e+02 }, { "Po203",      2.029814201030000e+02 }, { "Po204",      2.039803181210000e+02 }, { "Po205",      2.049812033220000e+02 },
         { "Po206",      2.059804810990000e+02 }, { "Po207",      2.069815931730000e+02 }, { "Po208",      2.079812457020000e+02 }, { "Po209",      2.089824304350000e+02 },
         { "Po210",      2.099828736730000e+02 }, { "Po211",      2.109866531540000e+02 }, { "Po212",      2.119888679690000e+02 }, { "Po213",      2.129928572800000e+02 },
         { "Po214",      2.139952013500000e+02 }, { "Po215",      2.149994199880000e+02 }, { "Po216",      2.160019150350000e+02 }, { "Po217",      2.170063347960000e+02 },
         { "Po218",      2.180089730370000e+02 }, { "Po219",      2.190137440000000e+02 }, { "Po220",      2.200166020000000e+02 }, { "At_natural", 2.100000000000000e+02 },
         { "At193",      1.929998431120000e+02 }, { "At194",      1.939987250850000e+02 }, { "At195",      1.949962680980000e+02 }, { "At196",      1.959957880770000e+02 },
         { "At197",      1.969931892150000e+02 }, { "At198",      1.979928372020000e+02 }, { "At199",      1.989905322540000e+02 }, { "At200",      1.999903512640000e+02 },
         { "At201",      2.009884169990000e+02 }, { "At202",      2.019886302360000e+02 }, { "At203",      2.029869419840000e+02 }, { "At204",      2.039872513260000e+02 },
         { "At205",      2.049860744830000e+02 }, { "At206",      2.059866670360000e+02 }, { "At207",      2.069857835020000e+02 }, { "At208",      2.079865899770000e+02 },
         { "At209",      2.089861731430000e+02 }, { "At210",      2.099871477100000e+02 }, { "At211",      2.109874962710000e+02 }, { "At212",      2.119907447710000e+02 },
         { "At213",      2.129929366460000e+02 }, { "At214",      2.139963717330000e+02 }, { "At215",      2.149986525700000e+02 }, { "At216",      2.160024232570000e+02 },
         { "At217",      2.170047188220000e+02 }, { "At218",      2.180086943360000e+02 }, { "At219",      2.190111616910000e+02 }, { "At220",      2.200154076820000e+02 },
         { "At221",      2.210180500000000e+02 }, { "At222",      2.220223300000000e+02 }, { "At223",      2.230251900000000e+02 }, { "Rn_natural", 2.220000000000000e+02 },
         { "Rn195",      1.950054376960000e+02 }, { "Rn196",      1.960021152230000e+02 }, { "Rn197",      1.970015843510000e+02 }, { "Rn198",      1.979986786630000e+02 },
         { "Rn199",      1.989983702970000e+02 }, { "Rn200",      1.999956993000000e+02 }, { "Rn201",      2.009956283350000e+02 }, { "Rn202",      2.019932634920000e+02 },
         { "Rn203",      2.029933866870000e+02 }, { "Rn204",      2.039914287400000e+02 }, { "Rn205",      2.049917187990000e+02 }, { "Rn206",      2.059902141040000e+02 },
         { "Rn207",      2.069907342250000e+02 }, { "Rn208",      2.079896424700000e+02 }, { "Rn209",      2.089904147420000e+02 }, { "Rn210",      2.099896962160000e+02 },
         { "Rn211",      2.109906005230000e+02 }, { "Rn212",      2.119907035290000e+02 }, { "Rn213",      2.129938826680000e+02 }, { "Rn214",      2.139953625540000e+02 },
         { "Rn215",      2.149987454830000e+02 }, { "Rn216",      2.160002743700000e+02 }, { "Rn217",      2.170039276750000e+02 }, { "Rn218",      2.180056012560000e+02 },
         { "Rn219",      2.190094802040000e+02 }, { "Rn220",      2.200113939810000e+02 }, { "Rn221",      2.210155367820000e+02 }, { "Rn222",      2.220175777380000e+02 },
         { "Rn223",      2.230217900000000e+02 }, { "Rn224",      2.240240900000000e+02 }, { "Rn225",      2.250284400000000e+02 }, { "Rn226",      2.260308900000000e+02 },
         { "Rn227",      2.270354070000000e+02 }, { "Rn228",      2.280379860000000e+02 }, { "Fr_natural", 2.230000000000000e+02 }, { "Fr199",      1.990072581470000e+02 },
         { "Fr200",      2.000065724900000e+02 }, { "Fr201",      2.010038608670000e+02 }, { "Fr202",      2.020033728470000e+02 }, { "Fr203",      2.030009246470000e+02 },
         { "Fr204",      2.040006532040000e+02 }, { "Fr205",      2.049985939600000e+02 }, { "Fr206",      2.059986660660000e+02 }, { "Fr207",      2.069969494140000e+02 },
         { "Fr208",      2.079971387830000e+02 }, { "Fr209",      2.089959535550000e+02 }, { "Fr210",      2.099964077380000e+02 }, { "Fr211",      2.109955365440000e+02 },
         { "Fr212",      2.119962022440000e+02 }, { "Fr213",      2.129961890810000e+02 }, { "Fr214",      2.139989711450000e+02 }, { "Fr215",      2.150003414970000e+02 },
         { "Fr216",      2.160031979900000e+02 }, { "Fr217",      2.170046319510000e+02 }, { "Fr218",      2.180075783220000e+02 }, { "Fr219",      2.190092521490000e+02 },
         { "Fr220",      2.200123274050000e+02 }, { "Fr221",      2.210142547620000e+02 }, { "Fr222",      2.220175517300000e+02 }, { "Fr223",      2.230197358570000e+02 },
         { "Fr224",      2.240232499510000e+02 }, { "Fr225",      2.250255654140000e+02 }, { "Fr226",      2.260293862310000e+02 }, { "Fr227",      2.270318359380000e+02 },
         { "Fr228",      2.280357290000000e+02 }, { "Fr229",      2.290384502280000e+02 }, { "Fr230",      2.300425100000000e+02 }, { "Fr231",      2.310454400000000e+02 },
         { "Fr232",      2.320497720000000e+02 }, { "Ra_natural", 2.260000000000000e+02 }, { "Ra202",      2.020098906860000e+02 }, { "Ra203",      2.030092716190000e+02 },
         { "Ra204",      2.040064996680000e+02 }, { "Ra205",      2.050062685700000e+02 }, { "Ra206",      2.060038272700000e+02 }, { "Ra207",      2.070037981050000e+02 },
         { "Ra208",      2.080018399400000e+02 }, { "Ra209",      2.090019913730000e+02 }, { "Ra210",      2.100004949780000e+02 }, { "Ra211",      2.110008979870000e+02 },
         { "Ra212",      2.119997944990000e+02 }, { "Ra213",      2.130003839590000e+02 }, { "Ra214",      2.140001078940000e+02 }, { "Ra215",      2.150027198340000e+02 },
         { "Ra216",      2.160035330350000e+02 }, { "Ra217",      2.170063203270000e+02 }, { "Ra218",      2.180071402300000e+02 }, { "Ra219",      2.190100850780000e+02 },
         { "Ra220",      2.200110283840000e+02 }, { "Ra221",      2.210139173380000e+02 }, { "Ra222",      2.220153745300000e+02 }, { "Ra223",      2.230185021710000e+02 },
         { "Ra224",      2.240202118210000e+02 }, { "Ra225",      2.250236115640000e+02 }, { "Ra226",      2.260254098230000e+02 }, { "Ra227",      2.270291778420000e+02 },
         { "Ra228",      2.280310702920000e+02 }, { "Ra229",      2.290349575770000e+02 }, { "Ra230",      2.300370563940000e+02 }, { "Ra231",      2.310412200000000e+02 },
         { "Ra232",      2.320436380000000e+02 }, { "Ra233",      2.330480600000000e+02 }, { "Ra234",      2.340507040000000e+02 }, { "Ac_natural", 2.270000000000000e+02 },
         { "Ac206",      2.060145049800000e+02 }, { "Ac207",      2.070119497480000e+02 }, { "Ac208",      2.080115515510000e+02 }, { "Ac209",      2.090094948630000e+02 },
         { "Ac210",      2.100094359860000e+02 }, { "Ac211",      2.110077348350000e+02 }, { "Ac212",      2.120078138220000e+02 }, { "Ac213",      2.130066076430000e+02 },
         { "Ac214",      2.140069017980000e+02 }, { "Ac215",      2.150064536250000e+02 }, { "Ac216",      2.160087200750000e+02 }, { "Ac217",      2.170093469140000e+02 },
         { "Ac218",      2.180116414530000e+02 }, { "Ac219",      2.190124203890000e+02 }, { "Ac220",      2.200147629790000e+02 }, { "Ac221",      2.210155912480000e+02 },
         { "Ac222",      2.220178438510000e+02 }, { "Ac223",      2.230191374680000e+02 }, { "Ac224",      2.240217228660000e+02 }, { "Ac225",      2.250232295850000e+02 },
         { "Ac226",      2.260260980890000e+02 }, { "Ac227",      2.270277521270000e+02 }, { "Ac228",      2.280310211120000e+02 }, { "Ac229",      2.290330152430000e+02 },
         { "Ac230",      2.300362941780000e+02 }, { "Ac231",      2.310385587860000e+02 }, { "Ac232",      2.320420274380000e+02 }, { "Ac233",      2.330445500000000e+02 },
         { "Ac234",      2.340484200000000e+02 }, { "Ac235",      2.350512320000000e+02 }, { "Ac236",      2.360552960000000e+02 }, { "Th_natural", 2.320381000000000e+02 },
         { "Th209",      2.090177156820000e+02 }, { "Th210",      2.100150753420000e+02 }, { "Th211",      2.110149284130000e+02 }, { "Th212",      2.120129802880000e+02 },
         { "Th213",      2.130130101400000e+02 }, { "Th214",      2.140114997700000e+02 }, { "Th215",      2.150117303300000e+02 }, { "Th216",      2.160110621150000e+02 },
         { "Th217",      2.170131143280000e+02 }, { "Th218",      2.180132844990000e+02 }, { "Th219",      2.190155368950000e+02 }, { "Th220",      2.200157477620000e+02 },
         { "Th221",      2.210181836740000e+02 }, { "Th222",      2.220184681210000e+02 }, { "Th223",      2.230208114480000e+02 }, { "Th224",      2.240214668950000e+02 },
         { "Th225",      2.250239510210000e+02 }, { "Th226",      2.260249030690000e+02 }, { "Th227",      2.270277040700000e+02 }, { "Th228",      2.280287411270000e+02 },
         { "Th229",      2.290317624300000e+02 }, { "Th230",      2.300331338430000e+02 }, { "Th231",      2.310363043430000e+02 }, { "Th232",      2.320380553250000e+02 },
         { "Th233",      2.330415818430000e+02 }, { "Th234",      2.340436012300000e+02 }, { "Th235",      2.350475100740000e+02 }, { "Th236",      2.360498700000000e+02 },
         { "Th237",      2.370538940000000e+02 }, { "Th238",      2.380564960000000e+02 }, { "Pa_natural", 2.310000000000000e+02 }, { "Pa212",      2.120232041380000e+02 },
         { "Pa213",      2.130211093400000e+02 }, { "Pa214",      2.140209184170000e+02 }, { "Pa215",      2.150191858650000e+02 }, { "Pa216",      2.160191095640000e+02 },
         { "Pa217",      2.170183239860000e+02 }, { "Pa218",      2.180200418890000e+02 }, { "Pa219",      2.190198831430000e+02 }, { "Pa220",      2.200218753030000e+02 },
         { "Pa221",      2.210218779830000e+02 }, { "Pa222",      2.220237420000000e+02 }, { "Pa223",      2.230239622730000e+02 }, { "Pa224",      2.240256257380000e+02 },
         { "Pa225",      2.250261306780000e+02 }, { "Pa226",      2.260279477530000e+02 }, { "Pa227",      2.270288050720000e+02 }, { "Pa228",      2.280310513760000e+02 },
         { "Pa229",      2.290320967930000e+02 }, { "Pa230",      2.300345407540000e+02 }, { "Pa231",      2.310358839900000e+02 }, { "Pa232",      2.320385915920000e+02 },
         { "Pa233",      2.330402472770000e+02 }, { "Pa234",      2.340433080580000e+02 }, { "Pa235",      2.350454436150000e+02 }, { "Pa236",      2.360486812840000e+02 },
         { "Pa237",      2.370511456590000e+02 }, { "Pa238",      2.380545027100000e+02 }, { "Pa239",      2.390572600000000e+02 }, { "Pa240",      2.400609800000000e+02 },
         { "U_natural",  2.380290000000000e+02 }, { "U217",       2.170243687910000e+02 }, { "U218",       2.180235356710000e+02 }, { "U219",       2.190249191600000e+02 },
         { "U220",       2.200247230000000e+02 }, { "U221",       2.210263990000000e+02 }, { "U222",       2.220260860000000e+02 }, { "U223",       2.230277386000000e+02 },
         { "U224",       2.240276047780000e+02 }, { "U225",       2.250293907170000e+02 }, { "U226",       2.260293387020000e+02 }, { "U227",       2.270311563670000e+02 },
         { "U228",       2.280313740060000e+02 }, { "U229",       2.290335059390000e+02 }, { "U230",       2.300339397840000e+02 }, { "U231",       2.310362937040000e+02 },
         { "U232",       2.320371561520000e+02 }, { "U233",       2.330396352070000e+02 }, { "U234",       2.340409520880000e+02 }, { "U235",       2.350439299180000e+02 },
         { "U236",       2.360455680060000e+02 }, { "U237",       2.370487301840000e+02 }, { "U238",       2.380507882470000e+02 }, { "U239",       2.390542932990000e+02 },
         { "U240",       2.400565919880000e+02 }, { "U241",       2.410603300000000e+02 }, { "U242",       2.420629310000000e+02 }, { "Np_natural", 2.370000000000000e+02 },
         { "Np225",      2.250339139330000e+02 }, { "Np226",      2.260351450000000e+02 }, { "Np227",      2.270349567890000e+02 }, { "Np228",      2.280361800000000e+02 },
         { "Np229",      2.290362638080000e+02 }, { "Np230",      2.300378275970000e+02 }, { "Np231",      2.310382450850000e+02 }, { "Np232",      2.320401080000000e+02 },
         { "Np233",      2.330407405460000e+02 }, { "Np234",      2.340428950380000e+02 }, { "Np235",      2.350440632670000e+02 }, { "Np236",      2.360465696000000e+02 },
         { "Np237",      2.370481734440000e+02 }, { "Np238",      2.380509464050000e+02 }, { "Np239",      2.390529390250000e+02 }, { "Np240",      2.400561621820000e+02 },
         { "Np241",      2.410582524310000e+02 }, { "Np242",      2.420616411800000e+02 }, { "Np243",      2.430642790000000e+02 }, { "Np244",      2.440678500000000e+02 },
         { "Pu_natural", 2.440000000000000e+02 }, { "Pu228",      2.280387423280000e+02 }, { "Pu229",      2.290401502120000e+02 }, { "Pu230",      2.300396498860000e+02 },
         { "Pu231",      2.310411011070000e+02 }, { "Pu232",      2.320411870970000e+02 }, { "Pu233",      2.330429973750000e+02 }, { "Pu234",      2.340433170760000e+02 },
         { "Pu235",      2.350452860500000e+02 }, { "Pu236",      2.360460579640000e+02 }, { "Pu237",      2.370484096580000e+02 }, { "Pu238",      2.380495598940000e+02 },
         { "Pu239",      2.390521633810000e+02 }, { "Pu240",      2.400538135450000e+02 }, { "Pu241",      2.410568514560000e+02 }, { "Pu242",      2.420587426110000e+02 },
         { "Pu243",      2.430620030920000e+02 }, { "Pu244",      2.440642039070000e+02 }, { "Pu245",      2.450677471540000e+02 }, { "Pu246",      2.460702046270000e+02 },
         { "Pu247",      2.470740700000000e+02 }, { "Am_natural", 2.430000000000000e+02 }, { "Am231",      2.310455600000000e+02 }, { "Am232",      2.320465900000000e+02 },
         { "Am233",      2.330463480000000e+02 }, { "Am234",      2.340478090000000e+02 }, { "Am235",      2.350479460000000e+02 }, { "Am236",      2.360495790000000e+02 },
         { "Am237",      2.370499960000000e+02 }, { "Am238",      2.380519843240000e+02 }, { "Am239",      2.390530244790000e+02 }, { "Am240",      2.400553001790000e+02 },
         { "Am241",      2.410568291440000e+02 }, { "Am242",      2.420595491590000e+02 }, { "Am243",      2.430613810800000e+02 }, { "Am244",      2.440642848470000e+02 },
         { "Am245",      2.450664521140000e+02 }, { "Am246",      2.460697746190000e+02 }, { "Am247",      2.470720930000000e+02 }, { "Am248",      2.480757520000000e+02 },
         { "Am249",      2.490784800000000e+02 }, { "Cm_natural", 2.470000000000000e+02 }, { "Cm233",      2.330507712320000e+02 }, { "Cm234",      2.340501598410000e+02 },
         { "Cm235",      2.350514340000000e+02 }, { "Cm236",      2.360514130000000e+02 }, { "Cm237",      2.370529010000000e+02 }, { "Cm238",      2.380530286970000e+02 },
         { "Cm239",      2.390549570000000e+02 }, { "Cm240",      2.400555295390000e+02 }, { "Cm241",      2.410576530010000e+02 }, { "Cm242",      2.420588358240000e+02 },
         { "Cm243",      2.430613891140000e+02 }, { "Cm244",      2.440627525780000e+02 }, { "Cm245",      2.450654912490000e+02 }, { "Cm246",      2.460672236620000e+02 },
         { "Cm247",      2.470703535400000e+02 }, { "Cm248",      2.480723485080000e+02 }, { "Cm249",      2.490759534130000e+02 }, { "Cm250",      2.500783569590000e+02 },
         { "Cm251",      2.510822846050000e+02 }, { "Cm252",      2.520848700000000e+02 }, { "Bk_natural", 2.470000000000000e+02 }, { "Bk235",      2.350565800000000e+02 },
         { "Bk236",      2.360573300000000e+02 }, { "Bk237",      2.370570030000000e+02 }, { "Bk238",      2.380582810000000e+02 }, { "Bk239",      2.390582790000000e+02 },
         { "Bk240",      2.400597590000000e+02 }, { "Bk241",      2.410602300000000e+02 }, { "Bk242",      2.420619810000000e+02 }, { "Bk243",      2.430630075720000e+02 },
         { "Bk244",      2.440651807740000e+02 }, { "Bk245",      2.450663616160000e+02 }, { "Bk246",      2.460686729470000e+02 }, { "Bk247",      2.470703070800000e+02 },
         { "Bk248",      2.480730860000000e+02 }, { "Bk249",      2.490749866570000e+02 }, { "Bk250",      2.500783165200000e+02 }, { "Bk251",      2.510807601720000e+02 },
         { "Bk252",      2.520843100000000e+02 }, { "Bk253",      2.530868800000000e+02 }, { "Bk254",      2.540906000000000e+02 }, { "Cf_natural", 2.510000000000000e+02 },
         { "Cf237",      2.370620700000000e+02 }, { "Cf238",      2.380614100000000e+02 }, { "Cf239",      2.390624220000000e+02 }, { "Cf240",      2.400623020000000e+02 },
         { "Cf241",      2.410637260000000e+02 }, { "Cf242",      2.420637015520000e+02 }, { "Cf243",      2.430654270000000e+02 }, { "Cf244",      2.440660006890000e+02 },
         { "Cf245",      2.450680486120000e+02 }, { "Cf246",      2.460688053090000e+02 }, { "Cf247",      2.470710005890000e+02 }, { "Cf248",      2.480721848610000e+02 },
         { "Cf249",      2.490748535370000e+02 }, { "Cf250",      2.500764060660000e+02 }, { "Cf251",      2.510795867880000e+02 }, { "Cf252",      2.520816258460000e+02 },
         { "Cf253",      2.530851331450000e+02 }, { "Cf254",      2.540873229090000e+02 }, { "Cf255",      2.550910460000000e+02 }, { "Cf256",      2.560934400000000e+02 },
         { "Es_natural", 2.520000000000000e+02 }, { "Es120",      1.175000000000000e+02 }, { "Es121",      1.165460000000000e+02 }, { "Es122",      1.185440000000000e+02 },
         { "Es125",      1.175000000000000e+02 }, { "Es240",      2.400689200000000e+02 }, { "Es241",      2.410685380000000e+02 }, { "Es242",      2.420697450000000e+02 },
         { "Es243",      2.430695480000000e+02 }, { "Es244",      2.440708830000000e+02 }, { "Es245",      2.450713240000000e+02 }, { "Es246",      2.460728960000000e+02 },
         { "Es247",      2.470736560000000e+02 }, { "Es248",      2.480754710000000e+02 }, { "Es249",      2.490764110000000e+02 }, { "Es250",      2.500786120000000e+02 },
         { "Es251",      2.510799921420000e+02 }, { "Es252",      2.520829785120000e+02 }, { "Es253",      2.530848246970000e+02 }, { "Es254",      2.540880220210000e+02 },
         { "Es255",      2.550902731220000e+02 }, { "Es256",      2.560935980000000e+02 }, { "Es257",      2.570959790000000e+02 }, { "Es258",      2.580995200000000e+02 },
         { "Fm_natural", 2.570000000000000e+02 }, { "Fm242",      2.420734300000000e+02 }, { "Fm243",      2.430743530000000e+02 }, { "Fm244",      2.440740840000000e+02 },
         { "Fm245",      2.450753850000000e+02 }, { "Fm246",      2.460752990230000e+02 }, { "Fm247",      2.470768470000000e+02 }, { "Fm248",      2.480771947140000e+02 },
         { "Fm249",      2.490790340000000e+02 }, { "Fm250",      2.500795212640000e+02 }, { "Fm251",      2.510815750170000e+02 }, { "Fm252",      2.520824668550000e+02 },
         { "Fm253",      2.530851852360000e+02 }, { "Fm254",      2.540868542200000e+02 }, { "Fm255",      2.550899622020000e+02 }, { "Fm256",      2.560917731170000e+02 },
         { "Fm257",      2.570951047240000e+02 }, { "Fm258",      2.580970760000000e+02 }, { "Fm259",      2.591005950000000e+02 }, { "Fm260",      2.601026780000000e+02 },
         { "Md_natural", 2.580000000000000e+02 }, { "Md245",      2.450808290000000e+02 }, { "Md246",      2.460818860000000e+02 }, { "Md247",      2.470816350000000e+02 },
         { "Md248",      2.480828230000000e+02 }, { "Md249",      2.490830130000000e+02 }, { "Md250",      2.500844200000000e+02 }, { "Md251",      2.510848390000000e+02 },
         { "Md252",      2.520865600000000e+02 }, { "Md253",      2.530872800000000e+02 }, { "Md254",      2.540896560000000e+02 }, { "Md255",      2.550910827050000e+02 },
         { "Md256",      2.560940590250000e+02 }, { "Md257",      2.570955413680000e+02 }, { "Md258",      2.580984313190000e+02 }, { "Md259",      2.591005090000000e+02 },
         { "Md260",      2.601036520000000e+02 }, { "Md261",      2.611057210000000e+02 }, { "Md262",      2.621088650000000e+02 }, { "No_natural", 2.590000000000000e+02 },
         { "No248",      2.480865960000000e+02 }, { "No249",      2.490878330000000e+02 }, { "No250",      2.500875100000000e+02 }, { "No251",      2.510890120000000e+02 },
         { "No252",      2.520889765210000e+02 }, { "No253",      2.530906780000000e+02 }, { "No254",      2.540909552530000e+02 }, { "No255",      2.550932411310000e+02 },
         { "No256",      2.560942826660000e+02 }, { "No257",      2.570968771900000e+02 }, { "No258",      2.580982070000000e+02 }, { "No259",      2.591010310000000e+02 },
         { "No260",      2.601026430000000e+02 }, { "No261",      2.611057490000000e+02 }, { "No262",      2.621073010000000e+02 }, { "No263",      2.631105520000000e+02 },
         { "No264",      2.641123450000000e+02 }, { "Lr_natural", 2.600000000000000e+02 }, { "Lr251",      2.510943600000000e+02 }, { "Lr252",      2.520953710000000e+02 },
         { "Lr253",      2.530952100000000e+02 }, { "Lr254",      2.540964540000000e+02 }, { "Lr255",      2.550966810000000e+02 }, { "Lr256",      2.560986290000000e+02 },
         { "Lr257",      2.570995550000000e+02 }, { "Lr258",      2.581018140000000e+02 }, { "Lr259",      2.591029010000000e+02 }, { "Lr260",      2.601055040000000e+02 },
         { "Lr261",      2.611068830000000e+02 }, { "Lr262",      2.621096340000000e+02 }, { "Lr263",      2.631112930000000e+02 }, { "Lr264",      2.641140380000000e+02 },
         { "Lr265",      2.651158390000000e+02 }, { "Lr266",      2.661193050000000e+02 }, { "Rf_natural", 2.610000000000000e+02 }, { "Rf253",      2.531006890000000e+02 },
         { "Rf254",      2.541001840000000e+02 }, { "Rf255",      2.551013400000000e+02 }, { "Rf256",      2.561011661940000e+02 }, { "Rf257",      2.571029900000000e+02 },
         { "Rf258",      2.581034890000000e+02 }, { "Rf259",      2.591056370000000e+02 }, { "Rf260",      2.601064400000000e+02 }, { "Rf261",      2.611087665560000e+02 },
         { "Rf262",      2.621099250000000e+02 }, { "Rf263",      2.631125470000000e+02 }, { "Rf264",      2.641139850000000e+02 }, { "Rf265",      2.651167040000000e+02 },
         { "Rf266",      2.661179560000000e+02 }, { "Rf267",      2.671215290000000e+02 }, { "Rf268",      2.681236440000000e+02 }, { "Db_natural", 2.620000000000000e+02 },
         { "Db255",      2.551073980000000e+02 }, { "Db256",      2.561081270000000e+02 }, { "Db257",      2.571077220000000e+02 }, { "Db258",      2.581092310000000e+02 },
         { "Db259",      2.591096100000000e+02 }, { "Db260",      2.601113000000000e+02 }, { "Db261",      2.611120560000000e+02 }, { "Db262",      2.621140840000000e+02 },
         { "Db263",      2.631149880000000e+02 }, { "Db264",      2.641174040000000e+02 }, { "Db265",      2.651186010000000e+02 }, { "Db266",      2.661210290000000e+02 },
         { "Db267",      2.671223770000000e+02 }, { "Db268",      2.681254450000000e+02 }, { "Db269",      2.691274600000000e+02 }, { "Db270",      2.701307120000000e+02 },
         { "Sg_natural", 2.630000000000000e+02 }, { "Sg258",      2.581131680000000e+02 }, { "Sg259",      2.591145000000000e+02 }, { "Sg260",      2.601144220710000e+02 },
         { "Sg261",      2.611161170000000e+02 }, { "Sg262",      2.621163980000000e+02 }, { "Sg263",      2.631183220000000e+02 }, { "Sg264",      2.641189310000000e+02 },
         { "Sg265",      2.651211146930000e+02 }, { "Sg266",      2.661220650000000e+02 }, { "Sg267",      2.671244250000000e+02 }, { "Sg268",      2.681256060000000e+02 },
         { "Sg269",      2.691287550000000e+02 }, { "Sg270",      2.701303290000000e+02 }, { "Sg271",      2.711334720000000e+02 }, { "Sg272",      2.721351580000000e+02 },
         { "Sg273",      2.731382200000000e+02 }, { "Bh260",      2.601219700000000e+02 }, { "Bh261",      2.611216640000000e+02 }, { "Bh262",      2.621228920000000e+02 },
         { "Bh263",      2.631230350000000e+02 }, { "Bh264",      2.641246040000000e+02 }, { "Bh265",      2.651251470000000e+02 }, { "Bh266",      2.661269420000000e+02 },
         { "Bh267",      2.671276500000000e+02 }, { "Bh268",      2.681297550000000e+02 }, { "Bh269",      2.691306940000000e+02 }, { "Bh270",      2.701336160000000e+02 },
         { "Bh271",      2.711351790000000e+02 }, { "Bh272",      2.721380320000000e+02 }, { "Bh273",      2.731396180000000e+02 }, { "Bh274",      2.741424400000000e+02 },
         { "Bh275",      2.751442500000000e+02 }, { "Hs263",      2.631285580000000e+02 }, { "Hs264",      2.641283948850000e+02 }, { "Hs265",      2.651300850000000e+02 },
         { "Hs266",      2.661300970000000e+02 }, { "Hs267",      2.671317890000000e+02 }, { "Hs268",      2.681321620000000e+02 }, { "Hs269",      2.691340560000000e+02 },
         { "Hs270",      2.701346500000000e+02 }, { "Hs271",      2.711376570000000e+02 }, { "Hs272",      2.721390520000000e+02 }, { "Hs273",      2.731419860000000e+02 },
         { "Hs274",      2.741431310000000e+02 }, { "Hs275",      2.751459520000000e+02 }, { "Hs276",      2.761472080000000e+02 }, { "Hs277",      2.771498410000000e+02 },
         { "Mt265",      2.651361510000000e+02 }, { "Mt266",      2.661372990000000e+02 }, { "Mt267",      2.671373070000000e+02 }, { "Mt268",      2.681387280000000e+02 },
         { "Mt269",      2.691390550000000e+02 }, { "Mt270",      2.701406570000000e+02 }, { "Mt271",      2.711411390000000e+02 }, { "Mt272",      2.721437380000000e+02 },
         { "Mt273",      2.731449130000000e+02 }, { "Mt274",      2.741474920000000e+02 }, { "Mt275",      2.751486470000000e+02 }, { "Mt276",      2.761511560000000e+02 },
         { "Mt277",      2.771524200000000e+02 }, { "Mt278",      2.781548120000000e+02 }, { "Mt279",      2.791561930000000e+02 }, { "Uun267",     2.671443410000000e+02 },
         { "Uun268",     2.681437950000000e+02 }, { "Uun269",     2.691451240000000e+02 }, { "Uun270",     2.701447200000000e+02 }, { "Uun271",     2.711460620000000e+02 },
         { "Uun272",     2.721463170000000e+02 }, { "Uun273",     2.731488630000000e+02 }, { "Uun274",     2.741494920000000e+02 }, { "Uun275",     2.751521760000000e+02 },
         { "Uun276",     2.761530340000000e+02 }, { "Uun277",     2.771556470000000e+02 }, { "Uun278",     2.781564690000000e+02 }, { "Uun279",     2.791588610000000e+02 },
         { "Uun280",     2.801597950000000e+02 }, { "Uun281",     2.811620610000000e+02 }, { "Uuu272",     2.721536150000000e+02 }, { "Uuu273",     2.731536820000000e+02 },
         { "Uuu274",     2.741557130000000e+02 }, { "Uuu275",     2.751561420000000e+02 }, { "Uuu276",     2.761584930000000e+02 }, { "Uuu277",     2.771595190000000e+02 },
         { "Uuu278",     2.781616040000000e+02 }, { "Uuu279",     2.791624680000000e+02 }, { "Uuu280",     2.801644730000000e+02 }, { "Uuu281",     2.811653720000000e+02 },
         { "Uuu282",     2.821674860000000e+02 }, { "Uuu283",     2.831684150000000e+02 }, { "Uub277",     2.771639430000000e+02 }, { "Uub278",     2.781643120000000e+02 },
         { "Uub279",     2.791665460000000e+02 }, { "Uub280",     2.801670390000000e+02 }, { "Uub281",     2.811692860000000e+02 }, { "Uub282",     2.821697650000000e+02 },
         { "Uub283",     2.831717920000000e+02 }, { "Uub284",     2.841723840000000e+02 }, { "Uub285",     2.851741050000000e+02 }, { "283",        2.831764510000000e+02 },
         { "284",        2.841780800000000e+02 }, { "285",        2.851787320000000e+02 }, { "286",        2.861804810000000e+02 }, { "287",        2.871810450000000e+02 },
         { "Uuq285",     2.851836980000000e+02 }, { "Uuq286",     2.861838550000000e+02 }, { "Uuq287",     2.871855990000000e+02 }, { "Uuq288",     2.881856890000000e+02 },
         { "Uuq289",     2.891872790000000e+02 }, { "287",        2.871911860000000e+02 }, { "288",        2.881924920000000e+02 }, { "289",        2.891927150000000e+02 },
         { "290",        2.901941410000000e+02 }, { "291",        2.911943840000000e+02 }, { "Uuh289",     2.891988620000000e+02 }, { "Uuh290",     2.901985900000000e+02 },
         { "Uuh291",     2.912000110000000e+02 }, { "Uuh292",     2.921997860000000e+02 }, { "291",        2.912065640000000e+02 }, { "292",        2.922075490000000e+02 },
         { "Uuo293",     2.932146700000000e+02 } };
/*
***************************************************************
*/
double MCGIDI_particleMass_AMU( statusMessageReporting *smr, const char *name ) {

    int i, n = sizeof( ZAMasses ) / sizeof( ZAMasses[0] );
    double mass = -1.;

    for( i = 0; i < n; i++ ) {
        if( strcmp( ZAMasses[i].symbol, name ) == 0 ) {
            mass = ZAMasses[i].mass;
            break;
        }
    }
    if( mass == -1. ) smr_setReportError2( smr, smr_unknownID, 1, "particle %s not in mass table", name );
    return( mass );
}

#if defined __cplusplus
}
#endif

