/*
 * Decompiled with CFR 0.152.
 */
package proguard.resources.file.visitor;

import proguard.resources.file.ResourceFile;
import proguard.resources.file.visitor.ResourceFileVisitor;

public class ResourceFileProcessingFlagFilter
implements ResourceFileVisitor {
    private final int requiredSetProcessingFlags;
    private final int requiredUnsetProcessingFlags;
    private final ResourceFileVisitor acceptedVisitor;

    public ResourceFileProcessingFlagFilter(int requiredSetProcessingFlags, int requiredUnsetProcessingFlags, ResourceFileVisitor acceptedVisitor) {
        this.requiredSetProcessingFlags = requiredSetProcessingFlags;
        this.requiredUnsetProcessingFlags = requiredUnsetProcessingFlags;
        this.acceptedVisitor = acceptedVisitor;
    }

    @Override
    public void visitAnyResourceFile(ResourceFile resourceFile) {
        if (this.accepted(resourceFile.getProcessingFlags())) {
            resourceFile.accept(this.acceptedVisitor);
        }
    }

    private boolean accepted(int accessFlags) {
        return (this.requiredSetProcessingFlags & ~accessFlags) == 0 && (this.requiredUnsetProcessingFlags & accessFlags) == 0;
    }
}

