// ------------------------------------------------------------------------
//
// SPDX-License-Identifier: LGPL-2.1-or-later
// Copyright (C) 2016 - 2023 by the deal.II authors
//
// This file is part of the deal.II library.
//
// Part of the source code is dual licensed under Apache-2.0 WITH
// LLVM-exception OR LGPL-2.1-or-later. Detailed license information
// governing the source code and code contributions can be found in
// LICENSE.md and CONTRIBUTING.md at the top level directory of deal.II.
//
// ------------------------------------------------------------------------


/**
 * @page CodeGallery The deal.II code gallery
 *
 * The deal.II code gallery contains a collection of programs based on deal.II
 * that were contributed by others to serve as starting points for more complex
 * applications. The code gallery is an extension of the @ref Tutorial "tutorial"
 * in that the programs are intended to show how applications can be
 * implemented with deal.II, but without the requirement to have these code
 * documented at the same, extensive level as used in the tutorial.
 * Instructions for obtaining the code gallery programs can be found at
 * https://dealii.org/code-gallery.html .
 *
 * @warning The programs that form part of the code gallery are contributed by
 *   others and are not part of deal.II itself. The deal.II authors make
 *   no assurances that these programs are documented in any reasonable way,
 *   nor that the programs are in fact correct. Please contact the authors
 *   of the code gallery programs if you have questions.
 *
 * The code gallery currently consists of the following programs (with
 * connections to other programs shown in the graph on the
 * @ref TutorialConnectionGraph "tutorial page"):
 *
<dl>
  <dt><b>@ref code_gallery_advection_reaction_estimator "Adaptive advection-reaction"</b> (by Marco Feder <marco.feder@sissa.it>)</dt>
    <dd>
      Implementation of an a-posteriori error estimator for first order hyperbolic problems
    </dd>

  <dt><b>@ref code_gallery_cdr "Convection Diffusion Reaction"</b> (by David R. Wells <wellsd2@rpi.edu>)</dt>
    <dd>
      Parallel convection-diffusion-reaction (CDR) solver with theta time stepping utilizing Trilinos.
    </dd>

  <dt><b>@ref code_gallery_Crystal_Growth_Phase_Field_Model "Crystal growth problem using phase field modeling"</b> (by Umair Hussain <husain.umair2010@gmail.com>)</dt>
    <dd>
      Solves the Allen-Cahn phase field equation along with heat equation to model crystal solidification.
    </dd>

  <dt><b>@ref code_gallery_Distributed_LDG_Method "Distributed LDG Method"</b> (by Michael Harmon <mdh266@gmail.com>)</dt>
    <dd>
      Solving Poisson's equation using the local discontinuous Galerkin method and Trilinos
    </dd>

  <dt><b>@ref code_gallery_Distributed_Moving_Laser_Heating "Distributed moving laser heating"</b> (by Hongfeng Ma <hongfeng.mark.ma@gmail.com>, Tatiana E. Itina <tatiana.itina@gmail.com>)</dt>
    <dd>
      Distributed moving laser heating
    </dd>

  <dt><b>@ref code_gallery_ElastoplasticTorsion "Elastoplastic Torsion"</b> (by Salvador Flores <sflores@dim.uchile.cl>)</dt>
    <dd>
      Solving variational problems with uniform gradient bounds by p-Laplacian approximation.
    </dd>

  <dt><b>@ref code_gallery_Swift_Hohenberg_Solver "Generalized Swift-Hohenberg Equation Solve"</b> (by Samuel Scheuerman <sam.scheuerman.051@gmail.com>)</dt>
    <dd>
      Solving the generalized Swift-Hohenberg equation    </dd>

  <dt><b>@ref code_gallery_Maxwell_Eigenvalue_hp_Refinement "Goal-Oriented hp-Adaptivity for the Maxwell Eigenvalue Problem"</b> (by Jake J. Harmon <jake.harmon@ieee.org>)</dt>
    <dd>
      An implementation of goal-oriented hp-refinement for the Maxwell eigenvalue problem, with a focus on computing eigenvalues accurately
    </dd>

  <dt><b>@ref code_gallery_goal_oriented_elastoplasticity "Goal-oriented mesh adaptivity in elastoplasticity problems"</b> (by Seyed Shahram Ghorashi <s.sh.ghorashi@gmail.com>)</dt>
    <dd>
      Solving 2d/3d elastoplasticity problem with linear isotropic hardening and adapting the mesh based on goal-oriented error estimation
    </dd>

  <dt><b>@ref code_gallery_MultipointFluxMixedFiniteElementMethods "Higher Order Multipoint Flux Mixed Finite Element (MFMFE) methods"</b> (by Eldar Khattatov <elk58@pitt.edu>, Ilona Ambartsumyan <ila6@pitt.edu>)</dt>
    <dd>
      Solving Darcy equation of flow in porous media using the multipoint flux mixed finite element method.
    </dd>

  <dt><b>@ref code_gallery_information_based_mesh_refinement "Information density-based mesh refinement"</b> (by Wolfgang Bangerth <bangerth@colostate.edu>)</dt>
    <dd>
      Implementation of a mesh refinement criterion for an inverse source identification problem based on an "information density".
    </dd>

  <dt><b>@ref code_gallery_coupled_laplace_problem "Laplace equation coupled to an external simulation program"</b> (by David Schneider <dav.schneider@tum.de>, Benjamin Uekermann <uekerman@in.tum.de>)</dt>
    <dd>
      Laplace equation surface coupled to an external simulation program (here simply a fancy boundary condition) using the coupling library preCICE.
    </dd>

  <dt><b>@ref code_gallery_Linear_Elastic_Active_Skeletal_Muscle_Model "Linear Elastic Active Skeletal Muscle Model"</b> (by Jean-Paul Pelteret <jppelteret@gmail.com>, Tim Hamann <tim.hamann@online.de>)</dt>
    <dd>
      Linear elasticity including active skeletal muscle model solving the concentric contraction of an idealized biceps brachii.
    </dd>

  <dt><b>@ref code_gallery_MCMC_Laplace "MCMC for the Laplace equation"</b> (by Wolfgang Bangerth <bangerth@colostate.edu>)</dt>
    <dd>
      An implementation of a Markov Chain Monte Carlo solver for an inverse problem involving the Laplace equation
    </dd>

  <dt><b>@ref code_gallery_nonlinear_heat_transfer_with_AD_NOX "Nonlinear heat transfer problem"</b> (by Narasimhan Swaminathan <n.swaminathan@iitm.ac.in>)</dt>
    <dd>
      Nonlinear heat transfer problem, using automatic differentiation and TRILINOS NOX.
    </dd>

  <dt><b>@ref code_gallery_Nonlinear_PoroViscoelasticity "Nonlinear poro-viscoelasticity"</b> (by Ester Comellas <ester.comellas@upc.edu>, Jean-Paul Pelteret <jppelteret@gmail.com>)</dt>
    <dd>
      A parallelized biphasic nonlinear poro-viscoelastic formulation based on Ogden hyperelasticity, using automatic differentiation and MPI from the Trilinos package.
    </dd>

  <dt><b>@ref code_gallery_parallel_in_time "Parallel in Time Heat Equation"</b> (by Joshua Christopher <chrisjoshtopher@gmail.com>)</dt>
    <dd>
      Solves the heat equation time steps in parallel using the multigrid reduction in time technique from the XBraid library.
    </dd>

  <dt><b>@ref code_gallery_Phase_field_fracture_model_in_3D "Phase-field fracture model in 3D"</b> (by Wasim Niyaz Munshi <munshiw0@gmail.com>, Chandrasekhar Annavarapu <annavarapuc@civil.iitm.ac.in>, Wolfgang Bangerth <bangerth@colostate.edu>, Marc Fehling <marc.fehling@matfyz.cuni.cz>)</dt>
    <dd>
      Phase-field fracture model in 3D with adaptive mesh refinement and a parallel solver
    </dd>

  <dt><b>@ref code_gallery_Quasi_static_Finite_strain_Compressible_Elasticity "Quasi-Static Finite-Strain Compressible Elasticity"</b> (by Jean-Paul Pelteret <jppelteret@gmail.com>, Andrew McBride <mcbride.andrew@gmail.com>)</dt>
    <dd>
      Classical quasi-static finite-strain elasticity solving the Cook membrane problem composed of a compressible Neo-Hookean material.
    </dd>

  <dt><b>@ref code_gallery_Quasi_static_Finite_strain_Quasi_incompressible_ViscoElasticity "Quasi-Static Finite-Strain Quasi-incompressible Visco-elasticity"</b> (by Jean-Paul Pelteret <jppelteret@gmail.com>)</dt>
    <dd>
      Quasi-static finite-strain quasi-incompressible rate-dependent elasticity computing the displacement history of a thin viscoelastic strip with a hole.
    </dd>

  <dt><b>@ref code_gallery_NavierStokes_TRBDF2_DG "TRBDF2-DG projection solver for the incompressible Navier-Stokes equations"</b> (by Giuseppe Orlando <giuseppe.orlando@polimi.it>)</dt>
    <dd>
      Projection solver for the incompressible Navier-Stokes equations based on a DG spatial discretization and on the TR-BDF2 method for time discretization
    </dd>

  <dt><b>@ref code_gallery_time_dependent_navier_stokes "Time-dependent Navier-Stokes"</b> (by Jie Cheng <chengjiehust@gmail.com>)</dt>
    <dd>
      Solving time-dependent incompressible Navier-Stokes problem in parallel with Grad-Div stabilization using IMEX scheme.
    </dd>

  <dt><b>@ref code_gallery_TravelingWaves "Traveling-wave solutions of a qualitative model for combustion waves."</b> (by Shamil Magomedov <magomedov.shamil.m@gmail.com>)</dt>
    <dd>
      Traveling waves
    </dd>

  <dt><b>@ref code_gallery_two_phase_flow "Two phase flow interaction "</b> (by Manuel Quezada de Luna <manuel.quezada.dl@gmail.com>)</dt>
    <dd>
      Simulating two-phase flow interaction via level set method and incompressible Navier-Stokes equations. 
    </dd>

  <dt><b>@ref code_gallery_CeresFE "Viscoelastoplastic topography evolution"</b> (by Roger Fu <rogerfu@fas.harvard.edu>, Anton Ermakov <eai@mit.edu>)</dt>
    <dd>
      Topographic evolution
    </dd>

</dl>
 */
