/**
 * Mandelbulber v2, a 3D fractal generator  _%}}i*<.        ____                _______
 * Copyright (C) 2023 Mandelbulber Team   _>]|=||i=i<,     / __ \___  ___ ___  / ___/ /
 *                                        \><||i|=>>%)    / /_/ / _ \/ -_) _ \/ /__/ /__
 * This file is part of Mandelbulber.     )<=i=]=|=i<>    \____/ .__/\__/_//_/\___/____/
 * The project is licensed under GPLv3,   -<>>=|><|||`        /_/
 * see also COPYING file in this folder.    ~+{i%+++
 *
 * spherical invert ( v2.17)
 * from M3D. Formula by Luca GN 2011, updated May 2012.
 * @reference
 * http://www.fractalforums.com/mandelbulb-3d/custom-formulas-and-transforms-release-t17106/

 * This file has been autogenerated by tools/populateUiInformation.php
 * from the file "fractal_transf_spherical_inv_v2.cpp" in the folder formula/definition
 * D O    N O T    E D I T    T H I S    F I L E !
 */

REAL4 TransfSphericalInvV2Iteration(REAL4 z, __constant sFractalCl *fractal, sExtendedAuxCl *aux)
{
	REAL rr = 0.0f;
	// unconditional mode
	if (fractal->transformCommon.functionEnabledCz)
	{
		if (aux->i >= fractal->transformCommon.startIterationsD
				&& aux->i < fractal->transformCommon.stopIterationsD1)
		{
			z += fractal->transformCommon.offset000;
			rr = dot(z, z);
			REAL inv = 1.0f / rr;
			z *= fractal->transformCommon.maxR2d1 * inv;
			z += fractal->transformCommon.additionConstant000 - fractal->transformCommon.offset000;

			if (!fractal->transformCommon.functionEnabledNFalse)
				aux->DE *= inv * fractal->transformCommon.maxR2d1;
			else
			{
				REAL r = native_sqrt(rr);
				aux->DE *=
					inv * (fractal->transformCommon.maxR2d1 + r * aux->DE * fractal->transformCommon.scale0);
			}
		}
	}

	// conditional modes
	if (fractal->transformCommon.functionEnabledCxFalse
			&& aux->i >= fractal->transformCommon.startIterationsC
			&& aux->i < fractal->transformCommon.stopIterationsC)
	{
		rr = dot(z, z);
		REAL mode;
		z += fractal->mandelbox.offset;

		if (rr < fractal->mandelbox.foldingSphericalFixed)
		{
			mode = 0.0f;
			if (fractal->transformCommon.functionEnabledFalse) // Mode 1 minR0
			{
				if (rr < fractal->transformCommon.minR0) mode = fractal->transformCommon.minR0;
			}
			if (fractal->transformCommon.functionEnabledxFalse) // Mode 2
			{
				if (rr < fractal->transformCommon.minR0) mode = 2.0f * fractal->transformCommon.minR0 - rr;
			}
			mode = 1.0f / mode;
			z *= mode;
			aux->DE *= fabs(mode);
		}
		z -= fractal->mandelbox.offset;
	}

	// other modes
	if (fractal->transformCommon.functionEnabledCyFalse
			&& aux->i >= fractal->transformCommon.startIterationsB
			&& aux->i < fractal->transformCommon.stopIterationsB)
	{
		rr = dot(z, z);
		REAL mode = rr;
		if (rr < fractal->transformCommon.scaleE1) // < maxRR
		{
			REAL lengthAB = fractal->transformCommon.scaleE1 - fractal->transformCommon.offsetC0;

			if (fractal->transformCommon.functionEnabledyFalse) // Mode 3a, linear addition 0.0f at Max,
			{
				if (rr < fractal->transformCommon.offsetC0)
					mode += rr * (fractal->transformCommon.offset0 / fractal->transformCommon.offsetC0);
				else
					mode +=
						(fractal->transformCommon.scaleE1 - rr) * fractal->transformCommon.offset0 / lengthAB;
			}

			if (fractal->transformCommon.functionEnabledzFalse) // Mode 3b
			{

				if (rr > fractal->transformCommon.offsetC0)
					mode += fractal->transformCommon.offsetB0 * (fractal->transformCommon.scaleE1 - rr);
				else
					mode += fractal->transformCommon.offsetA0 * (fractal->transformCommon.offsetC0 - rr)
									+ fractal->transformCommon.offsetB0 * lengthAB;
			}

			if (fractal->transformCommon.functionEnabledwFalse) // Mode 3c, basic parabolic curve
			{

				REAL halfLen = fractal->transformCommon.scaleE1 / 2.0f;
				REAL slope = 2.0f / fractal->transformCommon.scaleE1;
				REAL factor = slope / fractal->transformCommon.scaleE1;
				REAL parab = 0.0f;

				if (rr < halfLen)
				{
					parab = rr * rr * factor * fractal->transformCommon.scaleG1;
					mode += rr * slope * fractal->transformCommon.scaleF1 - parab;
				}
				else
				{
					REAL temp = fractal->transformCommon.scaleE1 - rr;
					parab = temp * temp * factor * fractal->transformCommon.scaleG1;
					mode += temp * slope * fractal->transformCommon.scaleF1 - parab;
				}
			}

			/*if (fractal->transformCommon.functionEnabledwFalse) // Mode 3d
			{
				mode = rr + fractal->transformCommon.offset0 * (fractal->mandelbox.foldingSphericalFixed -
			rr);
				if (rr < fractal->transformCommon.minR0)
					mode -= rr * (fractal->transformCommon.offset0
									* (fractal->mandelbox.foldingSphericalFixed - fractal->transformCommon.minR0))
							/ fractal->transformCommon.minR0;
			}*/
			mode = 1.0f / mode;
			z *= mode;
			aux->DE *= fabs(mode);
		}
	}

	if (fractal->analyticDE.enabledFalse)
	{
		aux->DE = aux->DE * fractal->analyticDE.scale1 + fractal->analyticDE.offset0;
	}
	return z;
}