// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.23.0
// 	protoc        v5.26.1
// source: cilium/api/npds.proto

package cilium

import (
	context "context"
	_ "github.com/cilium/proxy/go/envoy/annotations"
	v3 "github.com/cilium/proxy/go/envoy/config/core/v3"
	v31 "github.com/cilium/proxy/go/envoy/config/route/v3"
	v33 "github.com/cilium/proxy/go/envoy/service/discovery/v3"
	v32 "github.com/cilium/proxy/go/envoy/type/matcher/v3"
	_ "github.com/envoyproxy/protoc-gen-validate/validate"
	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// Action specifies what to do when the header matches.
type HeaderMatch_MatchAction int32

const (
	HeaderMatch_CONTINUE_ON_MATCH HeaderMatch_MatchAction = 0 // Keep checking other matches (default)
	HeaderMatch_FAIL_ON_MATCH     HeaderMatch_MatchAction = 1 // Drop the request if no other rule matches
	HeaderMatch_DELETE_ON_MATCH   HeaderMatch_MatchAction = 2 // Remove the whole matching header
)

// Enum value maps for HeaderMatch_MatchAction.
var (
	HeaderMatch_MatchAction_name = map[int32]string{
		0: "CONTINUE_ON_MATCH",
		1: "FAIL_ON_MATCH",
		2: "DELETE_ON_MATCH",
	}
	HeaderMatch_MatchAction_value = map[string]int32{
		"CONTINUE_ON_MATCH": 0,
		"FAIL_ON_MATCH":     1,
		"DELETE_ON_MATCH":   2,
	}
)

func (x HeaderMatch_MatchAction) Enum() *HeaderMatch_MatchAction {
	p := new(HeaderMatch_MatchAction)
	*p = x
	return p
}

func (x HeaderMatch_MatchAction) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (HeaderMatch_MatchAction) Descriptor() protoreflect.EnumDescriptor {
	return file_cilium_api_npds_proto_enumTypes[0].Descriptor()
}

func (HeaderMatch_MatchAction) Type() protoreflect.EnumType {
	return &file_cilium_api_npds_proto_enumTypes[0]
}

func (x HeaderMatch_MatchAction) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use HeaderMatch_MatchAction.Descriptor instead.
func (HeaderMatch_MatchAction) EnumDescriptor() ([]byte, []int) {
	return file_cilium_api_npds_proto_rawDescGZIP(), []int{5, 0}
}

type HeaderMatch_MismatchAction int32

const (
	HeaderMatch_FAIL_ON_MISMATCH     HeaderMatch_MismatchAction = 0 // Drop the request if no other rule matches (default)
	HeaderMatch_CONTINUE_ON_MISMATCH HeaderMatch_MismatchAction = 1 // Keep checking other matches, log the mismatch
	HeaderMatch_ADD_ON_MISMATCH      HeaderMatch_MismatchAction = 2 // Add 'value' to the multivalued header
	HeaderMatch_DELETE_ON_MISMATCH   HeaderMatch_MismatchAction = 3 // Remove the whole mismatching header
	HeaderMatch_REPLACE_ON_MISMATCH  HeaderMatch_MismatchAction = 4 // Replace the whole mismatching header with 'value'
)

// Enum value maps for HeaderMatch_MismatchAction.
var (
	HeaderMatch_MismatchAction_name = map[int32]string{
		0: "FAIL_ON_MISMATCH",
		1: "CONTINUE_ON_MISMATCH",
		2: "ADD_ON_MISMATCH",
		3: "DELETE_ON_MISMATCH",
		4: "REPLACE_ON_MISMATCH",
	}
	HeaderMatch_MismatchAction_value = map[string]int32{
		"FAIL_ON_MISMATCH":     0,
		"CONTINUE_ON_MISMATCH": 1,
		"ADD_ON_MISMATCH":      2,
		"DELETE_ON_MISMATCH":   3,
		"REPLACE_ON_MISMATCH":  4,
	}
)

func (x HeaderMatch_MismatchAction) Enum() *HeaderMatch_MismatchAction {
	p := new(HeaderMatch_MismatchAction)
	*p = x
	return p
}

func (x HeaderMatch_MismatchAction) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (HeaderMatch_MismatchAction) Descriptor() protoreflect.EnumDescriptor {
	return file_cilium_api_npds_proto_enumTypes[1].Descriptor()
}

func (HeaderMatch_MismatchAction) Type() protoreflect.EnumType {
	return &file_cilium_api_npds_proto_enumTypes[1]
}

func (x HeaderMatch_MismatchAction) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use HeaderMatch_MismatchAction.Descriptor instead.
func (HeaderMatch_MismatchAction) EnumDescriptor() ([]byte, []int) {
	return file_cilium_api_npds_proto_rawDescGZIP(), []int{5, 1}
}

// A network policy that is enforced by a filter on the network flows to/from
// associated hosts.
type NetworkPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// IPs of the endpoint to which this policy applies.
	// Required.
	EndpointIps []string `protobuf:"bytes,1,rep,name=endpoint_ips,json=endpointIps,proto3" json:"endpoint_ips,omitempty"`
	// The endpoint identifier associated with the network policy.
	// Required.
	EndpointId uint64 `protobuf:"varint,2,opt,name=endpoint_id,json=endpointId,proto3" json:"endpoint_id,omitempty"`
	// The part of the policy to be enforced at ingress by the filter, as a set
	// of per-port network policies, one per destination L4 port.
	// Every PortNetworkPolicy element in this set has a unique port / protocol
	// combination.
	// Optional. If empty, all flows in this direction are denied.
	IngressPerPortPolicies []*PortNetworkPolicy `protobuf:"bytes,3,rep,name=ingress_per_port_policies,json=ingressPerPortPolicies,proto3" json:"ingress_per_port_policies,omitempty"`
	// The part of the policy to be enforced at egress by the filter, as a set
	// of per-port network policies, one per destination L4 port.
	// Every PortNetworkPolicy element in this set has a unique port / protocol
	// combination.
	// Optional. If empty, all flows in this direction are denied.
	EgressPerPortPolicies []*PortNetworkPolicy `protobuf:"bytes,4,rep,name=egress_per_port_policies,json=egressPerPortPolicies,proto3" json:"egress_per_port_policies,omitempty"`
	// Name of the conntrack map to use with this policy.
	// The paths to various Cilium conntrack maps are derived using this name.
	// Optional. If empty, ipcache or hostmap lookup is used instead of conntrack
	// map.
	ConntrackMapName string `protobuf:"bytes,5,opt,name=conntrack_map_name,json=conntrackMapName,proto3" json:"conntrack_map_name,omitempty"`
}

func (x *NetworkPolicy) Reset() {
	*x = NetworkPolicy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cilium_api_npds_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NetworkPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NetworkPolicy) ProtoMessage() {}

func (x *NetworkPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_cilium_api_npds_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NetworkPolicy.ProtoReflect.Descriptor instead.
func (*NetworkPolicy) Descriptor() ([]byte, []int) {
	return file_cilium_api_npds_proto_rawDescGZIP(), []int{0}
}

func (x *NetworkPolicy) GetEndpointIps() []string {
	if x != nil {
		return x.EndpointIps
	}
	return nil
}

func (x *NetworkPolicy) GetEndpointId() uint64 {
	if x != nil {
		return x.EndpointId
	}
	return 0
}

func (x *NetworkPolicy) GetIngressPerPortPolicies() []*PortNetworkPolicy {
	if x != nil {
		return x.IngressPerPortPolicies
	}
	return nil
}

func (x *NetworkPolicy) GetEgressPerPortPolicies() []*PortNetworkPolicy {
	if x != nil {
		return x.EgressPerPortPolicies
	}
	return nil
}

func (x *NetworkPolicy) GetConntrackMapName() string {
	if x != nil {
		return x.ConntrackMapName
	}
	return ""
}

// A network policy to whitelist flows to a specific destination L4 port,
// as a conjunction of predicates on L3/L4/L7 flows.
// If all the predicates of a policy match a flow, the flow is whitelisted.
type PortNetworkPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The flows' destination L4 port number, as an unsigned 16-bit integer.
	// If 0, all destination L4 port numbers are matched by this predicate.
	Port uint32 `protobuf:"varint,1,opt,name=port,proto3" json:"port,omitempty"`
	// The end of the destination port range, if non-zero.
	EndPort uint32 `protobuf:"varint,4,opt,name=end_port,json=endPort,proto3" json:"end_port,omitempty"`
	// The flows' L4 transport protocol.
	// Required.
	Protocol v3.SocketAddress_Protocol `protobuf:"varint,2,opt,name=protocol,proto3,enum=envoy.config.core.v3.SocketAddress_Protocol" json:"protocol,omitempty"`
	// The network policy rules to be enforced on the flows to the port.
	// Optional. A flow is matched by this predicate if either the set of
	// rules is empty or any of the rules matches it.
	Rules []*PortNetworkPolicyRule `protobuf:"bytes,3,rep,name=rules,proto3" json:"rules,omitempty"`
}

func (x *PortNetworkPolicy) Reset() {
	*x = PortNetworkPolicy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cilium_api_npds_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PortNetworkPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PortNetworkPolicy) ProtoMessage() {}

func (x *PortNetworkPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_cilium_api_npds_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PortNetworkPolicy.ProtoReflect.Descriptor instead.
func (*PortNetworkPolicy) Descriptor() ([]byte, []int) {
	return file_cilium_api_npds_proto_rawDescGZIP(), []int{1}
}

func (x *PortNetworkPolicy) GetPort() uint32 {
	if x != nil {
		return x.Port
	}
	return 0
}

func (x *PortNetworkPolicy) GetEndPort() uint32 {
	if x != nil {
		return x.EndPort
	}
	return 0
}

func (x *PortNetworkPolicy) GetProtocol() v3.SocketAddress_Protocol {
	if x != nil {
		return x.Protocol
	}
	return v3.SocketAddress_TCP
}

func (x *PortNetworkPolicy) GetRules() []*PortNetworkPolicyRule {
	if x != nil {
		return x.Rules
	}
	return nil
}

type TLSContext struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// CA certificates. If present, the counterparty must provide a valid
	// certificate.
	// Deprecated, use 'validation_context_sds_secret' instead.
	TrustedCa string `protobuf:"bytes,1,opt,name=trusted_ca,json=trustedCa,proto3" json:"trusted_ca,omitempty"`
	// Certificate chain.
	// Deprecated, use 'tls_sds_secret' instead.
	CertificateChain string `protobuf:"bytes,2,opt,name=certificate_chain,json=certificateChain,proto3" json:"certificate_chain,omitempty"`
	// Private key
	// Deprecated, use 'tls_sds_secret' instead.
	PrivateKey string `protobuf:"bytes,3,opt,name=private_key,json=privateKey,proto3" json:"private_key,omitempty"`
	// Server Name Indicator. For downstream this helps choose the certificate to
	// present to the client. For upstream this will be used as the SNI on the
	// client connection.
	ServerNames []string `protobuf:"bytes,4,rep,name=server_names,json=serverNames,proto3" json:"server_names,omitempty"`
	// Name of an SDS secret for CA certificates. Secret is fetched from the same gRPC source as
	// this Network Policy. If present, the counterparty must provide a valid certificate.
	// May not be used at the same time with 'trusted_ca'.
	ValidationContextSdsSecret string `protobuf:"bytes,5,opt,name=validation_context_sds_secret,json=validationContextSdsSecret,proto3" json:"validation_context_sds_secret,omitempty"`
	// Name of an SDS secret for both TLS private key and certificate chain. Secret is fetched
	// from the same gRPC source as this Network Policy.
	// May not be used at the same time with 'certificate_chain' or 'private_key'.
	TlsSdsSecret string `protobuf:"bytes,6,opt,name=tls_sds_secret,json=tlsSdsSecret,proto3" json:"tls_sds_secret,omitempty"`
	// Set of ALPN protocols, e.g., [ “h2", "http/1.1” ] when both HTTP 1.1 and HTTP 2 are supported.
	AlpnProtocols []string `protobuf:"bytes,7,rep,name=alpn_protocols,json=alpnProtocols,proto3" json:"alpn_protocols,omitempty"`
}

func (x *TLSContext) Reset() {
	*x = TLSContext{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cilium_api_npds_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TLSContext) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TLSContext) ProtoMessage() {}

func (x *TLSContext) ProtoReflect() protoreflect.Message {
	mi := &file_cilium_api_npds_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TLSContext.ProtoReflect.Descriptor instead.
func (*TLSContext) Descriptor() ([]byte, []int) {
	return file_cilium_api_npds_proto_rawDescGZIP(), []int{2}
}

func (x *TLSContext) GetTrustedCa() string {
	if x != nil {
		return x.TrustedCa
	}
	return ""
}

func (x *TLSContext) GetCertificateChain() string {
	if x != nil {
		return x.CertificateChain
	}
	return ""
}

func (x *TLSContext) GetPrivateKey() string {
	if x != nil {
		return x.PrivateKey
	}
	return ""
}

func (x *TLSContext) GetServerNames() []string {
	if x != nil {
		return x.ServerNames
	}
	return nil
}

func (x *TLSContext) GetValidationContextSdsSecret() string {
	if x != nil {
		return x.ValidationContextSdsSecret
	}
	return ""
}

func (x *TLSContext) GetTlsSdsSecret() string {
	if x != nil {
		return x.TlsSdsSecret
	}
	return ""
}

func (x *TLSContext) GetAlpnProtocols() []string {
	if x != nil {
		return x.AlpnProtocols
	}
	return nil
}

// A network policy rule, as a conjunction of predicates on L3/L7 flows.
// If all the predicates of a rule match a flow, the flow is matched by the
// rule.
type PortNetworkPolicyRule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Traffic on this port is denied for all `remote_policies` if true
	Deny bool `protobuf:"varint,8,opt,name=deny,proto3" json:"deny,omitempty"`
	// Optional name for the rule, can be used in logging and error messages.
	Name string `protobuf:"bytes,5,opt,name=name,proto3" json:"name,omitempty"`
	// The set of numeric remote security IDs explicitly allowed or denied.
	// A flow is matched by this predicate if the identifier of the policy
	// applied on the flow's remote host is contained in this set.
	// Optional. If not specified, any remote host is matched by this predicate.
	// This field is deprecated, use remote_policies instead.
	// TODO: Remove when Cilium 1.14 no longer supported.
	DeprecatedRemotePolicies_64 []uint64 `protobuf:"varint,1,rep,packed,name=deprecated_remote_policies_64,json=deprecatedRemotePolicies64,proto3" json:"deprecated_remote_policies_64,omitempty"`
	RemotePolicies              []uint32 `protobuf:"varint,7,rep,packed,name=remote_policies,json=remotePolicies,proto3" json:"remote_policies,omitempty"`
	// Optional downstream TLS context. If present, the incoming connection must
	// be a TLS connection.
	DownstreamTlsContext *TLSContext `protobuf:"bytes,3,opt,name=downstream_tls_context,json=downstreamTlsContext,proto3" json:"downstream_tls_context,omitempty"`
	// Optional upstream TLS context. If present, the outgoing connection will use
	// TLS.
	UpstreamTlsContext *TLSContext `protobuf:"bytes,4,opt,name=upstream_tls_context,json=upstreamTlsContext,proto3" json:"upstream_tls_context,omitempty"`
	// Optional allowed SNIs in TLS handshake.
	ServerNames []string `protobuf:"bytes,6,rep,name=server_names,json=serverNames,proto3" json:"server_names,omitempty"`
	// Optional L7 protocol parser name. This is only used if the parser is not
	// one of the well knows ones. If specified, the l7 parser having this name
	// needs to be built in to libcilium.so.
	L7Proto string `protobuf:"bytes,2,opt,name=l7_proto,json=l7Proto,proto3" json:"l7_proto,omitempty"`
	// Optional. If not specified, any L7 request is matched by this predicate.
	// All rules on any given port must have the same type of L7 rules!
	//
	// Types that are assignable to L7:
	//
	//	*PortNetworkPolicyRule_HttpRules
	//	*PortNetworkPolicyRule_KafkaRules
	//	*PortNetworkPolicyRule_L7Rules
	L7 isPortNetworkPolicyRule_L7 `protobuf_oneof:"l7"`
}

func (x *PortNetworkPolicyRule) Reset() {
	*x = PortNetworkPolicyRule{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cilium_api_npds_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PortNetworkPolicyRule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PortNetworkPolicyRule) ProtoMessage() {}

func (x *PortNetworkPolicyRule) ProtoReflect() protoreflect.Message {
	mi := &file_cilium_api_npds_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PortNetworkPolicyRule.ProtoReflect.Descriptor instead.
func (*PortNetworkPolicyRule) Descriptor() ([]byte, []int) {
	return file_cilium_api_npds_proto_rawDescGZIP(), []int{3}
}

func (x *PortNetworkPolicyRule) GetDeny() bool {
	if x != nil {
		return x.Deny
	}
	return false
}

func (x *PortNetworkPolicyRule) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *PortNetworkPolicyRule) GetDeprecatedRemotePolicies_64() []uint64 {
	if x != nil {
		return x.DeprecatedRemotePolicies_64
	}
	return nil
}

func (x *PortNetworkPolicyRule) GetRemotePolicies() []uint32 {
	if x != nil {
		return x.RemotePolicies
	}
	return nil
}

func (x *PortNetworkPolicyRule) GetDownstreamTlsContext() *TLSContext {
	if x != nil {
		return x.DownstreamTlsContext
	}
	return nil
}

func (x *PortNetworkPolicyRule) GetUpstreamTlsContext() *TLSContext {
	if x != nil {
		return x.UpstreamTlsContext
	}
	return nil
}

func (x *PortNetworkPolicyRule) GetServerNames() []string {
	if x != nil {
		return x.ServerNames
	}
	return nil
}

func (x *PortNetworkPolicyRule) GetL7Proto() string {
	if x != nil {
		return x.L7Proto
	}
	return ""
}

func (m *PortNetworkPolicyRule) GetL7() isPortNetworkPolicyRule_L7 {
	if m != nil {
		return m.L7
	}
	return nil
}

func (x *PortNetworkPolicyRule) GetHttpRules() *HttpNetworkPolicyRules {
	if x, ok := x.GetL7().(*PortNetworkPolicyRule_HttpRules); ok {
		return x.HttpRules
	}
	return nil
}

func (x *PortNetworkPolicyRule) GetKafkaRules() *KafkaNetworkPolicyRules {
	if x, ok := x.GetL7().(*PortNetworkPolicyRule_KafkaRules); ok {
		return x.KafkaRules
	}
	return nil
}

func (x *PortNetworkPolicyRule) GetL7Rules() *L7NetworkPolicyRules {
	if x, ok := x.GetL7().(*PortNetworkPolicyRule_L7Rules); ok {
		return x.L7Rules
	}
	return nil
}

type isPortNetworkPolicyRule_L7 interface {
	isPortNetworkPolicyRule_L7()
}

type PortNetworkPolicyRule_HttpRules struct {
	// The set of HTTP network policy rules.
	// An HTTP request is matched by this predicate if any of its rules matches
	// the request.
	HttpRules *HttpNetworkPolicyRules `protobuf:"bytes,100,opt,name=http_rules,json=httpRules,proto3,oneof"`
}

type PortNetworkPolicyRule_KafkaRules struct {
	// The set of Kafka network policy rules.
	// A Kafka request is matched by this predicate if any of its rules matches
	// the request.
	KafkaRules *KafkaNetworkPolicyRules `protobuf:"bytes,101,opt,name=kafka_rules,json=kafkaRules,proto3,oneof"`
}

type PortNetworkPolicyRule_L7Rules struct {
	// Set of Generic policy rules used when 'l7_proto' is defined.
	// Only to be used for l7 protocols for which a specific oneof
	// is not defined
	L7Rules *L7NetworkPolicyRules `protobuf:"bytes,102,opt,name=l7_rules,json=l7Rules,proto3,oneof"`
}

func (*PortNetworkPolicyRule_HttpRules) isPortNetworkPolicyRule_L7() {}

func (*PortNetworkPolicyRule_KafkaRules) isPortNetworkPolicyRule_L7() {}

func (*PortNetworkPolicyRule_L7Rules) isPortNetworkPolicyRule_L7() {}

// A set of network policy rules that match HTTP requests.
type HttpNetworkPolicyRules struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The set of HTTP network policy rules.
	// An HTTP request is matched if any of its rules matches the request.
	// Required and may not be empty.
	HttpRules []*HttpNetworkPolicyRule `protobuf:"bytes,1,rep,name=http_rules,json=httpRules,proto3" json:"http_rules,omitempty"`
}

func (x *HttpNetworkPolicyRules) Reset() {
	*x = HttpNetworkPolicyRules{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cilium_api_npds_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HttpNetworkPolicyRules) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HttpNetworkPolicyRules) ProtoMessage() {}

func (x *HttpNetworkPolicyRules) ProtoReflect() protoreflect.Message {
	mi := &file_cilium_api_npds_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HttpNetworkPolicyRules.ProtoReflect.Descriptor instead.
func (*HttpNetworkPolicyRules) Descriptor() ([]byte, []int) {
	return file_cilium_api_npds_proto_rawDescGZIP(), []int{4}
}

func (x *HttpNetworkPolicyRules) GetHttpRules() []*HttpNetworkPolicyRule {
	if x != nil {
		return x.HttpRules
	}
	return nil
}

type HeaderMatch struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name           string                     `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Value          string                     `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"` // empty for presence match. For secret data use 'value_sds_secret' instead.
	MatchAction    HeaderMatch_MatchAction    `protobuf:"varint,3,opt,name=match_action,json=matchAction,proto3,enum=cilium.HeaderMatch_MatchAction" json:"match_action,omitempty"`
	MismatchAction HeaderMatch_MismatchAction `protobuf:"varint,4,opt,name=mismatch_action,json=mismatchAction,proto3,enum=cilium.HeaderMatch_MismatchAction" json:"mismatch_action,omitempty"`
	// Generic secret name for fetching value via SDS. Secret is fetched from the same gRPC source as
	// this Network Policy.
	ValueSdsSecret string `protobuf:"bytes,5,opt,name=value_sds_secret,json=valueSdsSecret,proto3" json:"value_sds_secret,omitempty"`
}

func (x *HeaderMatch) Reset() {
	*x = HeaderMatch{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cilium_api_npds_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HeaderMatch) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HeaderMatch) ProtoMessage() {}

func (x *HeaderMatch) ProtoReflect() protoreflect.Message {
	mi := &file_cilium_api_npds_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HeaderMatch.ProtoReflect.Descriptor instead.
func (*HeaderMatch) Descriptor() ([]byte, []int) {
	return file_cilium_api_npds_proto_rawDescGZIP(), []int{5}
}

func (x *HeaderMatch) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *HeaderMatch) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

func (x *HeaderMatch) GetMatchAction() HeaderMatch_MatchAction {
	if x != nil {
		return x.MatchAction
	}
	return HeaderMatch_CONTINUE_ON_MATCH
}

func (x *HeaderMatch) GetMismatchAction() HeaderMatch_MismatchAction {
	if x != nil {
		return x.MismatchAction
	}
	return HeaderMatch_FAIL_ON_MISMATCH
}

func (x *HeaderMatch) GetValueSdsSecret() string {
	if x != nil {
		return x.ValueSdsSecret
	}
	return ""
}

// An HTTP network policy rule, as a conjunction of predicates on HTTP requests.
// If all the predicates of a rule match an HTTP request, the request is
// allowed. Otherwise, it is denied.
type HttpNetworkPolicyRule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A set of matchers on the HTTP request's headers' names and values.
	// If all the matchers in this set match an HTTP request, the request is
	// allowed by this rule. Otherwise, it is denied.
	//
	// Some special header names are:
	//
	// * *:uri*: The HTTP request's URI.
	// * *:method*: The HTTP request's method.
	// * *:authority*: Also maps to the HTTP 1.1 *Host* header.
	//
	// Optional. If empty, matches any HTTP request.
	Headers []*v31.HeaderMatcher `protobuf:"bytes,1,rep,name=headers,proto3" json:"headers,omitempty"`
	// header_matches is a set of HTTP header name and value pairs that
	// will be matched against the request headers, if all the other match
	// requirements in 'headers' are met. Each HeaderAction determines what to do
	// when there is a match or mismatch.
	//
	// Optional.
	HeaderMatches []*HeaderMatch `protobuf:"bytes,2,rep,name=header_matches,json=headerMatches,proto3" json:"header_matches,omitempty"`
}

func (x *HttpNetworkPolicyRule) Reset() {
	*x = HttpNetworkPolicyRule{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cilium_api_npds_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HttpNetworkPolicyRule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HttpNetworkPolicyRule) ProtoMessage() {}

func (x *HttpNetworkPolicyRule) ProtoReflect() protoreflect.Message {
	mi := &file_cilium_api_npds_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HttpNetworkPolicyRule.ProtoReflect.Descriptor instead.
func (*HttpNetworkPolicyRule) Descriptor() ([]byte, []int) {
	return file_cilium_api_npds_proto_rawDescGZIP(), []int{6}
}

func (x *HttpNetworkPolicyRule) GetHeaders() []*v31.HeaderMatcher {
	if x != nil {
		return x.Headers
	}
	return nil
}

func (x *HttpNetworkPolicyRule) GetHeaderMatches() []*HeaderMatch {
	if x != nil {
		return x.HeaderMatches
	}
	return nil
}

// A set of network policy rules that match Kafka requests.
type KafkaNetworkPolicyRules struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The set of Kafka network policy rules.
	// A Kafka request is matched if any of its rules matches the request.
	// Required and may not be empty.
	KafkaRules []*KafkaNetworkPolicyRule `protobuf:"bytes,1,rep,name=kafka_rules,json=kafkaRules,proto3" json:"kafka_rules,omitempty"`
}

func (x *KafkaNetworkPolicyRules) Reset() {
	*x = KafkaNetworkPolicyRules{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cilium_api_npds_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *KafkaNetworkPolicyRules) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KafkaNetworkPolicyRules) ProtoMessage() {}

func (x *KafkaNetworkPolicyRules) ProtoReflect() protoreflect.Message {
	mi := &file_cilium_api_npds_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KafkaNetworkPolicyRules.ProtoReflect.Descriptor instead.
func (*KafkaNetworkPolicyRules) Descriptor() ([]byte, []int) {
	return file_cilium_api_npds_proto_rawDescGZIP(), []int{7}
}

func (x *KafkaNetworkPolicyRules) GetKafkaRules() []*KafkaNetworkPolicyRule {
	if x != nil {
		return x.KafkaRules
	}
	return nil
}

// A Kafka network policy rule, as a conjunction of predicates on Kafka
// requests. If all the predicates of a rule match a Kafka request, the request
// is allowed. Otherwise, it is denied.
type KafkaNetworkPolicyRule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Kafka request's API version.
	// If < 0, all Kafka requests are matched by this predicate.
	ApiVersion int32 `protobuf:"varint,1,opt,name=api_version,json=apiVersion,proto3" json:"api_version,omitempty"`
	// Set of allowed API keys in the Kafka request.
	// If none, all Kafka requests are matched by this predicate.
	ApiKeys []int32 `protobuf:"varint,2,rep,packed,name=api_keys,json=apiKeys,proto3" json:"api_keys,omitempty"`
	// The Kafka request's client ID.
	// Optional. If not specified, all Kafka requests are matched by this
	// predicate. If specified, this predicates only matches requests that contain
	// this client ID, and never matches requests that don't contain any client
	// ID.
	ClientId string `protobuf:"bytes,3,opt,name=client_id,json=clientId,proto3" json:"client_id,omitempty"`
	// The Kafka request's topic.
	// Optional. If not specified, this rule will not consider the Kafka request's
	// topics. If specified, this predicates only matches requests that contain
	// this topic, and never matches requests that don't contain any topic.
	// However, messages that can not contain a topic will also me matched.
	Topic string `protobuf:"bytes,4,opt,name=topic,proto3" json:"topic,omitempty"`
}

func (x *KafkaNetworkPolicyRule) Reset() {
	*x = KafkaNetworkPolicyRule{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cilium_api_npds_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *KafkaNetworkPolicyRule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KafkaNetworkPolicyRule) ProtoMessage() {}

func (x *KafkaNetworkPolicyRule) ProtoReflect() protoreflect.Message {
	mi := &file_cilium_api_npds_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KafkaNetworkPolicyRule.ProtoReflect.Descriptor instead.
func (*KafkaNetworkPolicyRule) Descriptor() ([]byte, []int) {
	return file_cilium_api_npds_proto_rawDescGZIP(), []int{8}
}

func (x *KafkaNetworkPolicyRule) GetApiVersion() int32 {
	if x != nil {
		return x.ApiVersion
	}
	return 0
}

func (x *KafkaNetworkPolicyRule) GetApiKeys() []int32 {
	if x != nil {
		return x.ApiKeys
	}
	return nil
}

func (x *KafkaNetworkPolicyRule) GetClientId() string {
	if x != nil {
		return x.ClientId
	}
	return ""
}

func (x *KafkaNetworkPolicyRule) GetTopic() string {
	if x != nil {
		return x.Topic
	}
	return ""
}

// A set of network policy rules that match generic L7 requests.
type L7NetworkPolicyRules struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The set of allowing l7 policy rules.
	// A request is allowed if any of these rules matches the request,
	// and the request does not match any of the deny rules.
	// Optional. If missing or empty then all requests are allowed, unless
	// denied by a deny rule.
	L7AllowRules []*L7NetworkPolicyRule `protobuf:"bytes,1,rep,name=l7_allow_rules,json=l7AllowRules,proto3" json:"l7_allow_rules,omitempty"`
	// The set of denying l7 policy rules.
	// A request is denied if any of these rules matches the request.
	// A request that is not denied may be allowed by 'l7_allow_rules'.
	// Optional.
	L7DenyRules []*L7NetworkPolicyRule `protobuf:"bytes,2,rep,name=l7_deny_rules,json=l7DenyRules,proto3" json:"l7_deny_rules,omitempty"`
}

func (x *L7NetworkPolicyRules) Reset() {
	*x = L7NetworkPolicyRules{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cilium_api_npds_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *L7NetworkPolicyRules) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*L7NetworkPolicyRules) ProtoMessage() {}

func (x *L7NetworkPolicyRules) ProtoReflect() protoreflect.Message {
	mi := &file_cilium_api_npds_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use L7NetworkPolicyRules.ProtoReflect.Descriptor instead.
func (*L7NetworkPolicyRules) Descriptor() ([]byte, []int) {
	return file_cilium_api_npds_proto_rawDescGZIP(), []int{9}
}

func (x *L7NetworkPolicyRules) GetL7AllowRules() []*L7NetworkPolicyRule {
	if x != nil {
		return x.L7AllowRules
	}
	return nil
}

func (x *L7NetworkPolicyRules) GetL7DenyRules() []*L7NetworkPolicyRule {
	if x != nil {
		return x.L7DenyRules
	}
	return nil
}

// A generic L7 policy rule, as a conjunction of predicates on l7 requests.
// If all the predicates of a rule match a request, the request is allowed.
// Otherwise, it is denied.
type L7NetworkPolicyRule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional rule name, can be used in logging and error messages.
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// Generic rule for Go extensions.
	// Optional. If empty, matches any request. Not allowed if 'metadata_rule' is
	// present.
	Rule map[string]string `protobuf:"bytes,1,rep,name=rule,proto3" json:"rule,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Generic rule for Envoy metadata enforcement. All matchers must match for
	// the rule to allow the request/connection. Optional. If empty, matches any
	// request. Not allowed if 'rule' is present.
	MetadataRule []*v32.MetadataMatcher `protobuf:"bytes,2,rep,name=metadata_rule,json=metadataRule,proto3" json:"metadata_rule,omitempty"`
}

func (x *L7NetworkPolicyRule) Reset() {
	*x = L7NetworkPolicyRule{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cilium_api_npds_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *L7NetworkPolicyRule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*L7NetworkPolicyRule) ProtoMessage() {}

func (x *L7NetworkPolicyRule) ProtoReflect() protoreflect.Message {
	mi := &file_cilium_api_npds_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use L7NetworkPolicyRule.ProtoReflect.Descriptor instead.
func (*L7NetworkPolicyRule) Descriptor() ([]byte, []int) {
	return file_cilium_api_npds_proto_rawDescGZIP(), []int{10}
}

func (x *L7NetworkPolicyRule) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *L7NetworkPolicyRule) GetRule() map[string]string {
	if x != nil {
		return x.Rule
	}
	return nil
}

func (x *L7NetworkPolicyRule) GetMetadataRule() []*v32.MetadataMatcher {
	if x != nil {
		return x.MetadataRule
	}
	return nil
}

// Cilium's network policy manager fills this message with all currently known network policies.
type NetworkPoliciesConfigDump struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The loaded networkpolicy configs.
	Networkpolicies []*NetworkPolicy `protobuf:"bytes,1,rep,name=networkpolicies,proto3" json:"networkpolicies,omitempty"`
}

func (x *NetworkPoliciesConfigDump) Reset() {
	*x = NetworkPoliciesConfigDump{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cilium_api_npds_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NetworkPoliciesConfigDump) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NetworkPoliciesConfigDump) ProtoMessage() {}

func (x *NetworkPoliciesConfigDump) ProtoReflect() protoreflect.Message {
	mi := &file_cilium_api_npds_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NetworkPoliciesConfigDump.ProtoReflect.Descriptor instead.
func (*NetworkPoliciesConfigDump) Descriptor() ([]byte, []int) {
	return file_cilium_api_npds_proto_rawDescGZIP(), []int{11}
}

func (x *NetworkPoliciesConfigDump) GetNetworkpolicies() []*NetworkPolicy {
	if x != nil {
		return x.Networkpolicies
	}
	return nil
}

var File_cilium_api_npds_proto protoreflect.FileDescriptor

var file_cilium_api_npds_proto_rawDesc = []byte{
	0x0a, 0x15, 0x63, 0x69, 0x6c, 0x69, 0x75, 0x6d, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x6e, 0x70, 0x64,
	0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x06, 0x63, 0x69, 0x6c, 0x69, 0x75, 0x6d, 0x1a,
	0x22, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2f, 0x63, 0x6f,
	0x72, 0x65, 0x2f, 0x76, 0x33, 0x2f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x2c, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2f, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x2f, 0x76, 0x33, 0x2f, 0x72, 0x6f, 0x75, 0x74, 0x65,
	0x5f, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x2a, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x2f, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x2f, 0x76, 0x33, 0x2f, 0x64, 0x69,
	0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x24, 0x65,
	0x6e, 0x76, 0x6f, 0x79, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x65,
	0x72, 0x2f, 0x76, 0x33, 0x2f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x20, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x2f, 0x76, 0x61,
	0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xbd, 0x02, 0x0a,
	0x0d, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x33,
	0x0a, 0x0c, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x5f, 0x69, 0x70, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x09, 0x42, 0x10, 0xfa, 0x42, 0x0d, 0x92, 0x01, 0x0a, 0x08, 0x01, 0x10, 0x02,
	0x22, 0x04, 0x72, 0x02, 0x10, 0x01, 0x52, 0x0b, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74,
	0x49, 0x70, 0x73, 0x12, 0x1f, 0x0a, 0x0b, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x5f,
	0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0a, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69,
	0x6e, 0x74, 0x49, 0x64, 0x12, 0x54, 0x0a, 0x19, 0x69, 0x6e, 0x67, 0x72, 0x65, 0x73, 0x73, 0x5f,
	0x70, 0x65, 0x72, 0x5f, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65,
	0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x63, 0x69, 0x6c, 0x69, 0x75, 0x6d,
	0x2e, 0x50, 0x6f, 0x72, 0x74, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x52, 0x16, 0x69, 0x6e, 0x67, 0x72, 0x65, 0x73, 0x73, 0x50, 0x65, 0x72, 0x50, 0x6f,
	0x72, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x12, 0x52, 0x0a, 0x18, 0x65, 0x67,
	0x72, 0x65, 0x73, 0x73, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x70, 0x6f,
	0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x63,
	0x69, 0x6c, 0x69, 0x75, 0x6d, 0x2e, 0x50, 0x6f, 0x72, 0x74, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x15, 0x65, 0x67, 0x72, 0x65, 0x73, 0x73, 0x50,
	0x65, 0x72, 0x50, 0x6f, 0x72, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x12, 0x2c,
	0x0a, 0x12, 0x63, 0x6f, 0x6e, 0x6e, 0x74, 0x72, 0x61, 0x63, 0x6b, 0x5f, 0x6d, 0x61, 0x70, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x63, 0x6f, 0x6e, 0x6e,
	0x74, 0x72, 0x61, 0x63, 0x6b, 0x4d, 0x61, 0x70, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0xd7, 0x01, 0x0a,
	0x11, 0x50, 0x6f, 0x72, 0x74, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x12, 0x1d, 0x0a, 0x04, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d,
	0x42, 0x09, 0xfa, 0x42, 0x06, 0x2a, 0x04, 0x18, 0xff, 0xff, 0x03, 0x52, 0x04, 0x70, 0x6f, 0x72,
	0x74, 0x12, 0x24, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0d, 0x42, 0x09, 0xfa, 0x42, 0x06, 0x2a, 0x04, 0x18, 0xff, 0xff, 0x03, 0x52, 0x07,
	0x65, 0x6e, 0x64, 0x50, 0x6f, 0x72, 0x74, 0x12, 0x48, 0x0a, 0x08, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x63, 0x6f, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2c, 0x2e, 0x65, 0x6e, 0x76, 0x6f,
	0x79, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x33,
	0x2e, 0x53, 0x6f, 0x63, 0x6b, 0x65, 0x74, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x2e, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x52, 0x08, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f,
	0x6c, 0x12, 0x33, 0x0a, 0x05, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x1d, 0x2e, 0x63, 0x69, 0x6c, 0x69, 0x75, 0x6d, 0x2e, 0x50, 0x6f, 0x72, 0x74, 0x4e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x75, 0x6c, 0x65, 0x52,
	0x05, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x22, 0xac, 0x02, 0x0a, 0x0a, 0x54, 0x4c, 0x53, 0x43, 0x6f,
	0x6e, 0x74, 0x65, 0x78, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x74, 0x72, 0x75, 0x73, 0x74, 0x65, 0x64,
	0x5f, 0x63, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x74, 0x72, 0x75, 0x73, 0x74,
	0x65, 0x64, 0x43, 0x61, 0x12, 0x2b, 0x0a, 0x11, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x65, 0x5f, 0x63, 0x68, 0x61, 0x69, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x10, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x43, 0x68, 0x61, 0x69,
	0x6e, 0x12, 0x1f, 0x0a, 0x0b, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x6b, 0x65, 0x79,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x4b,
	0x65, 0x79, 0x12, 0x21, 0x0a, 0x0c, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72,
	0x4e, 0x61, 0x6d, 0x65, 0x73, 0x12, 0x41, 0x0a, 0x1d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x5f, 0x73, 0x64, 0x73, 0x5f,
	0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x1a, 0x76, 0x61,
	0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x53,
	0x64, 0x73, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x12, 0x24, 0x0a, 0x0e, 0x74, 0x6c, 0x73, 0x5f,
	0x73, 0x64, 0x73, 0x5f, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0c, 0x74, 0x6c, 0x73, 0x53, 0x64, 0x73, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x12, 0x25,
	0x0a, 0x0e, 0x61, 0x6c, 0x70, 0x6e, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x73,
	0x18, 0x07, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0d, 0x61, 0x6c, 0x70, 0x6e, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x63, 0x6f, 0x6c, 0x73, 0x22, 0xbf, 0x04, 0x0a, 0x15, 0x50, 0x6f, 0x72, 0x74, 0x4e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x75, 0x6c, 0x65, 0x12,
	0x12, 0x0a, 0x04, 0x64, 0x65, 0x6e, 0x79, 0x18, 0x08, 0x20, 0x01, 0x28, 0x08, 0x52, 0x04, 0x64,
	0x65, 0x6e, 0x79, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x41, 0x0a, 0x1d, 0x64, 0x65, 0x70, 0x72, 0x65,
	0x63, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x5f, 0x70, 0x6f, 0x6c,
	0x69, 0x63, 0x69, 0x65, 0x73, 0x5f, 0x36, 0x34, 0x18, 0x01, 0x20, 0x03, 0x28, 0x04, 0x52, 0x1a,
	0x64, 0x65, 0x70, 0x72, 0x65, 0x63, 0x61, 0x74, 0x65, 0x64, 0x52, 0x65, 0x6d, 0x6f, 0x74, 0x65,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x36, 0x34, 0x12, 0x27, 0x0a, 0x0f, 0x72, 0x65,
	0x6d, 0x6f, 0x74, 0x65, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x18, 0x07, 0x20,
	0x03, 0x28, 0x0d, 0x52, 0x0e, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x69, 0x65, 0x73, 0x12, 0x48, 0x0a, 0x16, 0x64, 0x6f, 0x77, 0x6e, 0x73, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x5f, 0x74, 0x6c, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x63, 0x69, 0x6c, 0x69, 0x75, 0x6d, 0x2e, 0x54, 0x4c, 0x53,
	0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x52, 0x14, 0x64, 0x6f, 0x77, 0x6e, 0x73, 0x74, 0x72,
	0x65, 0x61, 0x6d, 0x54, 0x6c, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x12, 0x44, 0x0a,
	0x14, 0x75, 0x70, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x5f, 0x74, 0x6c, 0x73, 0x5f, 0x63, 0x6f,
	0x6e, 0x74, 0x65, 0x78, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x63, 0x69,
	0x6c, 0x69, 0x75, 0x6d, 0x2e, 0x54, 0x4c, 0x53, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x52,
	0x12, 0x75, 0x70, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x54, 0x6c, 0x73, 0x43, 0x6f, 0x6e, 0x74,
	0x65, 0x78, 0x74, 0x12, 0x21, 0x0a, 0x0c, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x73, 0x65, 0x72, 0x76, 0x65,
	0x72, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x12, 0x19, 0x0a, 0x08, 0x6c, 0x37, 0x5f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6c, 0x37, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x3f, 0x0a, 0x0a, 0x68, 0x74, 0x74, 0x70, 0x5f, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x18,
	0x64, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x63, 0x69, 0x6c, 0x69, 0x75, 0x6d, 0x2e, 0x48,
	0x74, 0x74, 0x70, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x52, 0x75, 0x6c, 0x65, 0x73, 0x48, 0x00, 0x52, 0x09, 0x68, 0x74, 0x74, 0x70, 0x52, 0x75, 0x6c,
	0x65, 0x73, 0x12, 0x42, 0x0a, 0x0b, 0x6b, 0x61, 0x66, 0x6b, 0x61, 0x5f, 0x72, 0x75, 0x6c, 0x65,
	0x73, 0x18, 0x65, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x63, 0x69, 0x6c, 0x69, 0x75, 0x6d,
	0x2e, 0x4b, 0x61, 0x66, 0x6b, 0x61, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x48, 0x00, 0x52, 0x0a, 0x6b, 0x61, 0x66, 0x6b,
	0x61, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x12, 0x39, 0x0a, 0x08, 0x6c, 0x37, 0x5f, 0x72, 0x75, 0x6c,
	0x65, 0x73, 0x18, 0x66, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x63, 0x69, 0x6c, 0x69, 0x75,
	0x6d, 0x2e, 0x4c, 0x37, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x48, 0x00, 0x52, 0x07, 0x6c, 0x37, 0x52, 0x75, 0x6c, 0x65,
	0x73, 0x42, 0x04, 0x0a, 0x02, 0x6c, 0x37, 0x22, 0x60, 0x0a, 0x16, 0x48, 0x74, 0x74, 0x70, 0x4e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x75, 0x6c, 0x65,
	0x73, 0x12, 0x46, 0x0a, 0x0a, 0x68, 0x74, 0x74, 0x70, 0x5f, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x63, 0x69, 0x6c, 0x69, 0x75, 0x6d, 0x2e, 0x48,
	0x74, 0x74, 0x70, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x52, 0x75, 0x6c, 0x65, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x92, 0x01, 0x02, 0x08, 0x01, 0x52, 0x09,
	0x68, 0x74, 0x74, 0x70, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x22, 0xd2, 0x03, 0x0a, 0x0b, 0x48, 0x65,
	0x61, 0x64, 0x65, 0x72, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x12, 0x1b, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x07, 0xfa, 0x42, 0x04, 0x72, 0x02, 0x10, 0x01,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x42, 0x0a, 0x0c,
	0x6d, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x1f, 0x2e, 0x63, 0x69, 0x6c, 0x69, 0x75, 0x6d, 0x2e, 0x48, 0x65, 0x61, 0x64,
	0x65, 0x72, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x2e, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x41, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x0b, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x4b, 0x0a, 0x0f, 0x6d, 0x69, 0x73, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x22, 0x2e, 0x63, 0x69, 0x6c, 0x69,
	0x75, 0x6d, 0x2e, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x2e, 0x4d,
	0x69, 0x73, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0e, 0x6d,
	0x69, 0x73, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x28, 0x0a,
	0x10, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f, 0x73, 0x64, 0x73, 0x5f, 0x73, 0x65, 0x63, 0x72, 0x65,
	0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x53, 0x64,
	0x73, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x22, 0x4c, 0x0a, 0x0b, 0x4d, 0x61, 0x74, 0x63, 0x68,
	0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x15, 0x0a, 0x11, 0x43, 0x4f, 0x4e, 0x54, 0x49, 0x4e,
	0x55, 0x45, 0x5f, 0x4f, 0x4e, 0x5f, 0x4d, 0x41, 0x54, 0x43, 0x48, 0x10, 0x00, 0x12, 0x11, 0x0a,
	0x0d, 0x46, 0x41, 0x49, 0x4c, 0x5f, 0x4f, 0x4e, 0x5f, 0x4d, 0x41, 0x54, 0x43, 0x48, 0x10, 0x01,
	0x12, 0x13, 0x0a, 0x0f, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x5f, 0x4f, 0x4e, 0x5f, 0x4d, 0x41,
	0x54, 0x43, 0x48, 0x10, 0x02, 0x22, 0x86, 0x01, 0x0a, 0x0e, 0x4d, 0x69, 0x73, 0x6d, 0x61, 0x74,
	0x63, 0x68, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x14, 0x0a, 0x10, 0x46, 0x41, 0x49, 0x4c,
	0x5f, 0x4f, 0x4e, 0x5f, 0x4d, 0x49, 0x53, 0x4d, 0x41, 0x54, 0x43, 0x48, 0x10, 0x00, 0x12, 0x18,
	0x0a, 0x14, 0x43, 0x4f, 0x4e, 0x54, 0x49, 0x4e, 0x55, 0x45, 0x5f, 0x4f, 0x4e, 0x5f, 0x4d, 0x49,
	0x53, 0x4d, 0x41, 0x54, 0x43, 0x48, 0x10, 0x01, 0x12, 0x13, 0x0a, 0x0f, 0x41, 0x44, 0x44, 0x5f,
	0x4f, 0x4e, 0x5f, 0x4d, 0x49, 0x53, 0x4d, 0x41, 0x54, 0x43, 0x48, 0x10, 0x02, 0x12, 0x16, 0x0a,
	0x12, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x5f, 0x4f, 0x4e, 0x5f, 0x4d, 0x49, 0x53, 0x4d, 0x41,
	0x54, 0x43, 0x48, 0x10, 0x03, 0x12, 0x17, 0x0a, 0x13, 0x52, 0x45, 0x50, 0x4c, 0x41, 0x43, 0x45,
	0x5f, 0x4f, 0x4e, 0x5f, 0x4d, 0x49, 0x53, 0x4d, 0x41, 0x54, 0x43, 0x48, 0x10, 0x04, 0x22, 0x93,
	0x01, 0x0a, 0x15, 0x48, 0x74, 0x74, 0x70, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x52, 0x75, 0x6c, 0x65, 0x12, 0x3e, 0x0a, 0x07, 0x68, 0x65, 0x61, 0x64,
	0x65, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x65, 0x6e, 0x76, 0x6f,
	0x79, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x2e, 0x76,
	0x33, 0x2e, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x52,
	0x07, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x12, 0x3a, 0x0a, 0x0e, 0x68, 0x65, 0x61, 0x64,
	0x65, 0x72, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x13, 0x2e, 0x63, 0x69, 0x6c, 0x69, 0x75, 0x6d, 0x2e, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72,
	0x4d, 0x61, 0x74, 0x63, 0x68, 0x52, 0x0d, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x4d, 0x61, 0x74,
	0x63, 0x68, 0x65, 0x73, 0x22, 0x64, 0x0a, 0x17, 0x4b, 0x61, 0x66, 0x6b, 0x61, 0x4e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x12,
	0x49, 0x0a, 0x0b, 0x6b, 0x61, 0x66, 0x6b, 0x61, 0x5f, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x63, 0x69, 0x6c, 0x69, 0x75, 0x6d, 0x2e, 0x4b, 0x61,
	0x66, 0x6b, 0x61, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x52, 0x75, 0x6c, 0x65, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x92, 0x01, 0x02, 0x08, 0x01, 0x52, 0x0a,
	0x6b, 0x61, 0x66, 0x6b, 0x61, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x22, 0xbe, 0x01, 0x0a, 0x16, 0x4b,
	0x61, 0x66, 0x6b, 0x61, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x52, 0x75, 0x6c, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x61, 0x70, 0x69, 0x5f, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0a, 0x61, 0x70, 0x69, 0x56,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x19, 0x0a, 0x08, 0x61, 0x70, 0x69, 0x5f, 0x6b, 0x65,
	0x79, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x05, 0x52, 0x07, 0x61, 0x70, 0x69, 0x4b, 0x65, 0x79,
	0x73, 0x12, 0x35, 0x0a, 0x09, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x18, 0xfa, 0x42, 0x15, 0x72, 0x13, 0x32, 0x11, 0x5e, 0x5b, 0x61,
	0x2d, 0x7a, 0x41, 0x2d, 0x5a, 0x30, 0x2d, 0x39, 0x2e, 0x5f, 0x2d, 0x5d, 0x2a, 0x24, 0x52, 0x08,
	0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x12, 0x31, 0x0a, 0x05, 0x74, 0x6f, 0x70, 0x69,
	0x63, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x1b, 0xfa, 0x42, 0x18, 0x72, 0x16, 0x18, 0xff,
	0x01, 0x32, 0x11, 0x5e, 0x5b, 0x61, 0x2d, 0x7a, 0x41, 0x2d, 0x5a, 0x30, 0x2d, 0x39, 0x2e, 0x5f,
	0x2d, 0x5d, 0x2a, 0x24, 0x52, 0x05, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x22, 0x9a, 0x01, 0x0a, 0x14,
	0x4c, 0x37, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52,
	0x75, 0x6c, 0x65, 0x73, 0x12, 0x41, 0x0a, 0x0e, 0x6c, 0x37, 0x5f, 0x61, 0x6c, 0x6c, 0x6f, 0x77,
	0x5f, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x63,
	0x69, 0x6c, 0x69, 0x75, 0x6d, 0x2e, 0x4c, 0x37, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x75, 0x6c, 0x65, 0x52, 0x0c, 0x6c, 0x37, 0x41, 0x6c, 0x6c,
	0x6f, 0x77, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x12, 0x3f, 0x0a, 0x0d, 0x6c, 0x37, 0x5f, 0x64, 0x65,
	0x6e, 0x79, 0x5f, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1b,
	0x2e, 0x63, 0x69, 0x6c, 0x69, 0x75, 0x6d, 0x2e, 0x4c, 0x37, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x75, 0x6c, 0x65, 0x52, 0x0b, 0x6c, 0x37, 0x44,
	0x65, 0x6e, 0x79, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x22, 0xea, 0x01, 0x0a, 0x13, 0x4c, 0x37, 0x4e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x75, 0x6c, 0x65,
	0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x39, 0x0a, 0x04, 0x72, 0x75, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x25, 0x2e, 0x63, 0x69, 0x6c, 0x69, 0x75, 0x6d, 0x2e, 0x4c, 0x37, 0x4e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x75, 0x6c, 0x65, 0x2e,
	0x52, 0x75, 0x6c, 0x65, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x04, 0x72, 0x75, 0x6c, 0x65, 0x12,
	0x4b, 0x0a, 0x0d, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x72, 0x75, 0x6c, 0x65,
	0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x74,
	0x79, 0x70, 0x65, 0x2e, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76, 0x33, 0x2e, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x52, 0x0c,
	0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x75, 0x6c, 0x65, 0x1a, 0x37, 0x0a, 0x09,
	0x52, 0x75, 0x6c, 0x65, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x5c, 0x0a, 0x19, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x44, 0x75,
	0x6d, 0x70, 0x12, 0x3f, 0x0a, 0x0f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x70, 0x6f, 0x6c,
	0x69, 0x63, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x63, 0x69,
	0x6c, 0x69, 0x75, 0x6d, 0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x52, 0x0f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x70, 0x6f, 0x6c, 0x69, 0x63,
	0x69, 0x65, 0x73, 0x32, 0xda, 0x02, 0x0a, 0x1d, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x53, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x7a, 0x0a, 0x15, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x4e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x12, 0x2c,
	0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x64,
	0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x2e, 0x76, 0x33, 0x2e, 0x44, 0x69, 0x73, 0x63,
	0x6f, 0x76, 0x65, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2d, 0x2e, 0x65,
	0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x64, 0x69, 0x73,
	0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x2e, 0x76, 0x33, 0x2e, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76,
	0x65, 0x72, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x28, 0x01, 0x30,
	0x01, 0x12, 0x9e, 0x01, 0x0a, 0x14, 0x46, 0x65, 0x74, 0x63, 0x68, 0x4e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x12, 0x2c, 0x2e, 0x65, 0x6e, 0x76,
	0x6f, 0x79, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f,
	0x76, 0x65, 0x72, 0x79, 0x2e, 0x76, 0x33, 0x2e, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72,
	0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2d, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79,
	0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65,
	0x72, 0x79, 0x2e, 0x76, 0x33, 0x2e, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x29, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x23, 0x22,
	0x1e, 0x2f, 0x76, 0x33, 0x2f, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x3a, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x3a,
	0x01, 0x2a, 0x1a, 0x1c, 0x8a, 0xa4, 0x96, 0xf3, 0x07, 0x16, 0x0a, 0x14, 0x63, 0x69, 0x6c, 0x69,
	0x75, 0x6d, 0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x42, 0x2e, 0x5a, 0x2c, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x63,
	0x69, 0x6c, 0x69, 0x75, 0x6d, 0x2f, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x2f, 0x67, 0x6f, 0x2f, 0x63,
	0x69, 0x6c, 0x69, 0x75, 0x6d, 0x2f, 0x61, 0x70, 0x69, 0x3b, 0x63, 0x69, 0x6c, 0x69, 0x75, 0x6d,
	0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_cilium_api_npds_proto_rawDescOnce sync.Once
	file_cilium_api_npds_proto_rawDescData = file_cilium_api_npds_proto_rawDesc
)

func file_cilium_api_npds_proto_rawDescGZIP() []byte {
	file_cilium_api_npds_proto_rawDescOnce.Do(func() {
		file_cilium_api_npds_proto_rawDescData = protoimpl.X.CompressGZIP(file_cilium_api_npds_proto_rawDescData)
	})
	return file_cilium_api_npds_proto_rawDescData
}

var file_cilium_api_npds_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_cilium_api_npds_proto_msgTypes = make([]protoimpl.MessageInfo, 13)
var file_cilium_api_npds_proto_goTypes = []interface{}{
	(HeaderMatch_MatchAction)(0),      // 0: cilium.HeaderMatch.MatchAction
	(HeaderMatch_MismatchAction)(0),   // 1: cilium.HeaderMatch.MismatchAction
	(*NetworkPolicy)(nil),             // 2: cilium.NetworkPolicy
	(*PortNetworkPolicy)(nil),         // 3: cilium.PortNetworkPolicy
	(*TLSContext)(nil),                // 4: cilium.TLSContext
	(*PortNetworkPolicyRule)(nil),     // 5: cilium.PortNetworkPolicyRule
	(*HttpNetworkPolicyRules)(nil),    // 6: cilium.HttpNetworkPolicyRules
	(*HeaderMatch)(nil),               // 7: cilium.HeaderMatch
	(*HttpNetworkPolicyRule)(nil),     // 8: cilium.HttpNetworkPolicyRule
	(*KafkaNetworkPolicyRules)(nil),   // 9: cilium.KafkaNetworkPolicyRules
	(*KafkaNetworkPolicyRule)(nil),    // 10: cilium.KafkaNetworkPolicyRule
	(*L7NetworkPolicyRules)(nil),      // 11: cilium.L7NetworkPolicyRules
	(*L7NetworkPolicyRule)(nil),       // 12: cilium.L7NetworkPolicyRule
	(*NetworkPoliciesConfigDump)(nil), // 13: cilium.NetworkPoliciesConfigDump
	nil,                               // 14: cilium.L7NetworkPolicyRule.RuleEntry
	(v3.SocketAddress_Protocol)(0),    // 15: envoy.config.core.v3.SocketAddress.Protocol
	(*v31.HeaderMatcher)(nil),         // 16: envoy.config.route.v3.HeaderMatcher
	(*v32.MetadataMatcher)(nil),       // 17: envoy.type.matcher.v3.MetadataMatcher
	(*v33.DiscoveryRequest)(nil),      // 18: envoy.service.discovery.v3.DiscoveryRequest
	(*v33.DiscoveryResponse)(nil),     // 19: envoy.service.discovery.v3.DiscoveryResponse
}
var file_cilium_api_npds_proto_depIdxs = []int32{
	3,  // 0: cilium.NetworkPolicy.ingress_per_port_policies:type_name -> cilium.PortNetworkPolicy
	3,  // 1: cilium.NetworkPolicy.egress_per_port_policies:type_name -> cilium.PortNetworkPolicy
	15, // 2: cilium.PortNetworkPolicy.protocol:type_name -> envoy.config.core.v3.SocketAddress.Protocol
	5,  // 3: cilium.PortNetworkPolicy.rules:type_name -> cilium.PortNetworkPolicyRule
	4,  // 4: cilium.PortNetworkPolicyRule.downstream_tls_context:type_name -> cilium.TLSContext
	4,  // 5: cilium.PortNetworkPolicyRule.upstream_tls_context:type_name -> cilium.TLSContext
	6,  // 6: cilium.PortNetworkPolicyRule.http_rules:type_name -> cilium.HttpNetworkPolicyRules
	9,  // 7: cilium.PortNetworkPolicyRule.kafka_rules:type_name -> cilium.KafkaNetworkPolicyRules
	11, // 8: cilium.PortNetworkPolicyRule.l7_rules:type_name -> cilium.L7NetworkPolicyRules
	8,  // 9: cilium.HttpNetworkPolicyRules.http_rules:type_name -> cilium.HttpNetworkPolicyRule
	0,  // 10: cilium.HeaderMatch.match_action:type_name -> cilium.HeaderMatch.MatchAction
	1,  // 11: cilium.HeaderMatch.mismatch_action:type_name -> cilium.HeaderMatch.MismatchAction
	16, // 12: cilium.HttpNetworkPolicyRule.headers:type_name -> envoy.config.route.v3.HeaderMatcher
	7,  // 13: cilium.HttpNetworkPolicyRule.header_matches:type_name -> cilium.HeaderMatch
	10, // 14: cilium.KafkaNetworkPolicyRules.kafka_rules:type_name -> cilium.KafkaNetworkPolicyRule
	12, // 15: cilium.L7NetworkPolicyRules.l7_allow_rules:type_name -> cilium.L7NetworkPolicyRule
	12, // 16: cilium.L7NetworkPolicyRules.l7_deny_rules:type_name -> cilium.L7NetworkPolicyRule
	14, // 17: cilium.L7NetworkPolicyRule.rule:type_name -> cilium.L7NetworkPolicyRule.RuleEntry
	17, // 18: cilium.L7NetworkPolicyRule.metadata_rule:type_name -> envoy.type.matcher.v3.MetadataMatcher
	2,  // 19: cilium.NetworkPoliciesConfigDump.networkpolicies:type_name -> cilium.NetworkPolicy
	18, // 20: cilium.NetworkPolicyDiscoveryService.StreamNetworkPolicies:input_type -> envoy.service.discovery.v3.DiscoveryRequest
	18, // 21: cilium.NetworkPolicyDiscoveryService.FetchNetworkPolicies:input_type -> envoy.service.discovery.v3.DiscoveryRequest
	19, // 22: cilium.NetworkPolicyDiscoveryService.StreamNetworkPolicies:output_type -> envoy.service.discovery.v3.DiscoveryResponse
	19, // 23: cilium.NetworkPolicyDiscoveryService.FetchNetworkPolicies:output_type -> envoy.service.discovery.v3.DiscoveryResponse
	22, // [22:24] is the sub-list for method output_type
	20, // [20:22] is the sub-list for method input_type
	20, // [20:20] is the sub-list for extension type_name
	20, // [20:20] is the sub-list for extension extendee
	0,  // [0:20] is the sub-list for field type_name
}

func init() { file_cilium_api_npds_proto_init() }
func file_cilium_api_npds_proto_init() {
	if File_cilium_api_npds_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_cilium_api_npds_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NetworkPolicy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cilium_api_npds_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PortNetworkPolicy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cilium_api_npds_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TLSContext); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cilium_api_npds_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PortNetworkPolicyRule); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cilium_api_npds_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HttpNetworkPolicyRules); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cilium_api_npds_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HeaderMatch); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cilium_api_npds_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HttpNetworkPolicyRule); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cilium_api_npds_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*KafkaNetworkPolicyRules); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cilium_api_npds_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*KafkaNetworkPolicyRule); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cilium_api_npds_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*L7NetworkPolicyRules); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cilium_api_npds_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*L7NetworkPolicyRule); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cilium_api_npds_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NetworkPoliciesConfigDump); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_cilium_api_npds_proto_msgTypes[3].OneofWrappers = []interface{}{
		(*PortNetworkPolicyRule_HttpRules)(nil),
		(*PortNetworkPolicyRule_KafkaRules)(nil),
		(*PortNetworkPolicyRule_L7Rules)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_cilium_api_npds_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   13,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_cilium_api_npds_proto_goTypes,
		DependencyIndexes: file_cilium_api_npds_proto_depIdxs,
		EnumInfos:         file_cilium_api_npds_proto_enumTypes,
		MessageInfos:      file_cilium_api_npds_proto_msgTypes,
	}.Build()
	File_cilium_api_npds_proto = out.File
	file_cilium_api_npds_proto_rawDesc = nil
	file_cilium_api_npds_proto_goTypes = nil
	file_cilium_api_npds_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// NetworkPolicyDiscoveryServiceClient is the client API for NetworkPolicyDiscoveryService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type NetworkPolicyDiscoveryServiceClient interface {
	StreamNetworkPolicies(ctx context.Context, opts ...grpc.CallOption) (NetworkPolicyDiscoveryService_StreamNetworkPoliciesClient, error)
	FetchNetworkPolicies(ctx context.Context, in *v33.DiscoveryRequest, opts ...grpc.CallOption) (*v33.DiscoveryResponse, error)
}

type networkPolicyDiscoveryServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewNetworkPolicyDiscoveryServiceClient(cc grpc.ClientConnInterface) NetworkPolicyDiscoveryServiceClient {
	return &networkPolicyDiscoveryServiceClient{cc}
}

func (c *networkPolicyDiscoveryServiceClient) StreamNetworkPolicies(ctx context.Context, opts ...grpc.CallOption) (NetworkPolicyDiscoveryService_StreamNetworkPoliciesClient, error) {
	stream, err := c.cc.NewStream(ctx, &_NetworkPolicyDiscoveryService_serviceDesc.Streams[0], "/cilium.NetworkPolicyDiscoveryService/StreamNetworkPolicies", opts...)
	if err != nil {
		return nil, err
	}
	x := &networkPolicyDiscoveryServiceStreamNetworkPoliciesClient{stream}
	return x, nil
}

type NetworkPolicyDiscoveryService_StreamNetworkPoliciesClient interface {
	Send(*v33.DiscoveryRequest) error
	Recv() (*v33.DiscoveryResponse, error)
	grpc.ClientStream
}

type networkPolicyDiscoveryServiceStreamNetworkPoliciesClient struct {
	grpc.ClientStream
}

func (x *networkPolicyDiscoveryServiceStreamNetworkPoliciesClient) Send(m *v33.DiscoveryRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *networkPolicyDiscoveryServiceStreamNetworkPoliciesClient) Recv() (*v33.DiscoveryResponse, error) {
	m := new(v33.DiscoveryResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *networkPolicyDiscoveryServiceClient) FetchNetworkPolicies(ctx context.Context, in *v33.DiscoveryRequest, opts ...grpc.CallOption) (*v33.DiscoveryResponse, error) {
	out := new(v33.DiscoveryResponse)
	err := c.cc.Invoke(ctx, "/cilium.NetworkPolicyDiscoveryService/FetchNetworkPolicies", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// NetworkPolicyDiscoveryServiceServer is the server API for NetworkPolicyDiscoveryService service.
type NetworkPolicyDiscoveryServiceServer interface {
	StreamNetworkPolicies(NetworkPolicyDiscoveryService_StreamNetworkPoliciesServer) error
	FetchNetworkPolicies(context.Context, *v33.DiscoveryRequest) (*v33.DiscoveryResponse, error)
}

// UnimplementedNetworkPolicyDiscoveryServiceServer can be embedded to have forward compatible implementations.
type UnimplementedNetworkPolicyDiscoveryServiceServer struct {
}

func (*UnimplementedNetworkPolicyDiscoveryServiceServer) StreamNetworkPolicies(NetworkPolicyDiscoveryService_StreamNetworkPoliciesServer) error {
	return status.Errorf(codes.Unimplemented, "method StreamNetworkPolicies not implemented")
}
func (*UnimplementedNetworkPolicyDiscoveryServiceServer) FetchNetworkPolicies(context.Context, *v33.DiscoveryRequest) (*v33.DiscoveryResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method FetchNetworkPolicies not implemented")
}

func RegisterNetworkPolicyDiscoveryServiceServer(s *grpc.Server, srv NetworkPolicyDiscoveryServiceServer) {
	s.RegisterService(&_NetworkPolicyDiscoveryService_serviceDesc, srv)
}

func _NetworkPolicyDiscoveryService_StreamNetworkPolicies_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(NetworkPolicyDiscoveryServiceServer).StreamNetworkPolicies(&networkPolicyDiscoveryServiceStreamNetworkPoliciesServer{stream})
}

type NetworkPolicyDiscoveryService_StreamNetworkPoliciesServer interface {
	Send(*v33.DiscoveryResponse) error
	Recv() (*v33.DiscoveryRequest, error)
	grpc.ServerStream
}

type networkPolicyDiscoveryServiceStreamNetworkPoliciesServer struct {
	grpc.ServerStream
}

func (x *networkPolicyDiscoveryServiceStreamNetworkPoliciesServer) Send(m *v33.DiscoveryResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *networkPolicyDiscoveryServiceStreamNetworkPoliciesServer) Recv() (*v33.DiscoveryRequest, error) {
	m := new(v33.DiscoveryRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _NetworkPolicyDiscoveryService_FetchNetworkPolicies_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v33.DiscoveryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworkPolicyDiscoveryServiceServer).FetchNetworkPolicies(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cilium.NetworkPolicyDiscoveryService/FetchNetworkPolicies",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworkPolicyDiscoveryServiceServer).FetchNetworkPolicies(ctx, req.(*v33.DiscoveryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _NetworkPolicyDiscoveryService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "cilium.NetworkPolicyDiscoveryService",
	HandlerType: (*NetworkPolicyDiscoveryServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "FetchNetworkPolicies",
			Handler:    _NetworkPolicyDiscoveryService_FetchNetworkPolicies_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "StreamNetworkPolicies",
			Handler:       _NetworkPolicyDiscoveryService_StreamNetworkPolicies_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "cilium/api/npds.proto",
}
