/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.objects;

import it.unimi.dsi.fastutil.objects.ObjectArrays;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectIterators;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import it.unimi.dsi.fastutil.objects.ObjectSpliterator;
import it.unimi.dsi.fastutil.objects.ReferenceArrayList;
import it.unimi.dsi.fastutil.objects.ReferenceCollection;
import it.unimi.dsi.fastutil.objects.ReferenceCollections;
import it.unimi.dsi.fastutil.objects.ReferenceImmutableList;
import it.unimi.dsi.fastutil.objects.ReferenceList;
import it.unimi.dsi.fastutil.objects.ReferenceLists;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.RandomAccess;
import java.util.function.Consumer;
import java.util.stream.Collector;

public class ReferenceImmutableList<K>
extends ReferenceLists.ImmutableListBase<K>
implements ReferenceList<K>,
RandomAccess,
Cloneable,
Serializable {
    private static final long serialVersionUID = 0L;
    static final ReferenceImmutableList EMPTY = new ReferenceImmutableList<Object>(ObjectArrays.EMPTY_ARRAY);
    private final K[] a;
    private static final Collector<Object, ?, ReferenceImmutableList<Object>> TO_LIST_COLLECTOR = Collector.of(ReferenceArrayList::new, ReferenceArrayList::add, ReferenceArrayList::combine, ReferenceImmutableList::convertTrustedToImmutableList, new Collector.Characteristics[0]);

    private static final <K> K[] emptyArray() {
        return ObjectArrays.EMPTY_ARRAY;
    }

    public ReferenceImmutableList(K[] a) {
        this.a = a;
    }

    public ReferenceImmutableList(Collection<? extends K> c) {
        this(c.isEmpty() ? ReferenceImmutableList.emptyArray() : ObjectIterators.unwrap(c.iterator()));
    }

    public ReferenceImmutableList(ReferenceCollection<? extends K> c) {
        this(c.isEmpty() ? ReferenceImmutableList.emptyArray() : ObjectIterators.unwrap(c.iterator()));
    }

    public ReferenceImmutableList(ReferenceList<? extends K> l) {
        this(l.isEmpty() ? ReferenceImmutableList.emptyArray() : new Object[l.size()]);
        l.getElements(0, this.a, 0, l.size());
    }

    public ReferenceImmutableList(K[] a, int offset, int length) {
        this(length == 0 ? ReferenceImmutableList.emptyArray() : new Object[length]);
        System.arraycopy(a, offset, this.a, 0, length);
    }

    public ReferenceImmutableList(ObjectIterator<? extends K> i) {
        this(i.hasNext() ? ObjectIterators.unwrap(i) : ReferenceImmutableList.emptyArray());
    }

    public static <K> ReferenceImmutableList<K> of() {
        return EMPTY;
    }

    @SafeVarargs
    public static <K> ReferenceImmutableList<K> of(K ... init) {
        return init.length == 0 ? ReferenceImmutableList.of() : new ReferenceImmutableList<K>(init);
    }

    private static <K> ReferenceImmutableList<K> convertTrustedToImmutableList(ReferenceArrayList<K> arrayList) {
        if (arrayList.isEmpty()) {
            return ReferenceImmutableList.of();
        }
        Object[] backingArray = arrayList.elements();
        if (arrayList.size() != backingArray.length) {
            backingArray = Arrays.copyOf(backingArray, arrayList.size());
        }
        return new ReferenceImmutableList<Object>(backingArray);
    }

    public static <K> Collector<K, ?, ReferenceImmutableList<K>> toList() {
        return TO_LIST_COLLECTOR;
    }

    public static <K> Collector<K, ?, ReferenceImmutableList<K>> toListWithExpectedSize(int expectedSize) {
        if (expectedSize <= 10) {
            return ReferenceImmutableList.toList();
        }
        return Collector.of(new ReferenceCollections.SizeDecreasingSupplier(expectedSize, size -> size <= 10 ? new ReferenceArrayList() : new ReferenceArrayList(size)), ReferenceArrayList::add, ReferenceArrayList::combine, ReferenceImmutableList::convertTrustedToImmutableList, new Collector.Characteristics[0]);
    }

    @Override
    public K get(int index) {
        if (index >= this.a.length) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than or equal to list size (" + this.a.length + ")");
        }
        return this.a[index];
    }

    @Override
    public int indexOf(Object k) {
        K[] a = this.a;
        int size = a.length;
        for (int i = 0; i < size; ++i) {
            if (k != a[i]) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object k) {
        K[] a = this.a;
        int i = a.length;
        while (i-- != 0) {
            if (k != a[i]) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int size() {
        return this.a.length;
    }

    @Override
    public boolean isEmpty() {
        return this.a.length == 0;
    }

    @Override
    public void getElements(int from, Object[] a, int offset, int length) {
        ObjectArrays.ensureOffsetLength(a, offset, length);
        System.arraycopy(this.a, from, a, offset, length);
    }

    @Override
    public void forEach(Consumer<? super K> action) {
        K[] a = this.a;
        for (int i = 0; i < a.length; ++i) {
            action.accept(a[i]);
        }
    }

    @Override
    public Object[] toArray() {
        if (this.a.length == 0) {
            return ObjectArrays.EMPTY_ARRAY;
        }
        if (this.a.getClass() == Object[].class) {
            return (Object[])this.a.clone();
        }
        return Arrays.copyOf(this.a, this.a.length, Object[].class);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        if (a == null) {
            a = new Object[this.size()];
        } else if (a.length < this.size()) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.size());
        }
        System.arraycopy(this.a, 0, a, 0, this.size());
        if (a.length > this.size()) {
            a[this.size()] = null;
        }
        return a;
    }

    @Override
    public ObjectListIterator<K> listIterator(int index) {
        this.ensureIndex(index);
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @Override
    public ObjectSpliterator<K> spliterator() {
        return new Spliterator(this);
    }

    @Override
    public ReferenceList<K> subList(int from, int to) {
        if (from == 0 && to == this.size()) {
            return this;
        }
        this.ensureIndex(from);
        this.ensureIndex(to);
        if (from == to) {
            return EMPTY;
        }
        if (from > to) {
            throw new IllegalArgumentException("Start index (" + from + ") is greater than end index (" + to + ")");
        }
        return new ImmutableSubList(this, from, to);
    }

    public ReferenceImmutableList<K> clone() {
        return this;
    }

    public boolean equals(ReferenceImmutableList<K> l) {
        if (l == this) {
            return true;
        }
        if (this.a == l.a) {
            return true;
        }
        int s = this.size();
        if (s != l.size()) {
            return false;
        }
        K[] a1 = this.a;
        K[] a2 = l.a;
        while (s-- != 0) {
            if (a1[s] == a2[s]) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof List)) {
            return false;
        }
        if (o instanceof ReferenceImmutableList) {
            return this.equals((ReferenceImmutableList)o);
        }
        if (o instanceof ImmutableSubList) {
            return ((ImmutableSubList)o).equals((Object)this);
        }
        return super.equals(o);
    }

    static /* synthetic */ Object[] access$000(ReferenceImmutableList x0) {
        return x0.a;
    }
}

