// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package fcgi_app

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// GetFCGIAppOKCode is the HTTP code returned for type GetFCGIAppOK
const GetFCGIAppOKCode int = 200

/*
GetFCGIAppOK Successful operation

swagger:response getFcgiAppOK
*/
type GetFCGIAppOK struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.FCGIApp `json:"body,omitempty"`
}

// NewGetFCGIAppOK creates GetFCGIAppOK with default headers values
func NewGetFCGIAppOK() *GetFCGIAppOK {

	return &GetFCGIAppOK{}
}

// WithConfigurationVersion adds the configurationVersion to the get Fcgi app o k response
func (o *GetFCGIAppOK) WithConfigurationVersion(configurationVersion string) *GetFCGIAppOK {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get Fcgi app o k response
func (o *GetFCGIAppOK) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get Fcgi app o k response
func (o *GetFCGIAppOK) WithPayload(payload *models.FCGIApp) *GetFCGIAppOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get Fcgi app o k response
func (o *GetFCGIAppOK) SetPayload(payload *models.FCGIApp) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetFCGIAppOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(200)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// GetFCGIAppNotFoundCode is the HTTP code returned for type GetFCGIAppNotFound
const GetFCGIAppNotFoundCode int = 404

/*
GetFCGIAppNotFound The specified resource was not found

swagger:response getFcgiAppNotFound
*/
type GetFCGIAppNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetFCGIAppNotFound creates GetFCGIAppNotFound with default headers values
func NewGetFCGIAppNotFound() *GetFCGIAppNotFound {

	return &GetFCGIAppNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the get Fcgi app not found response
func (o *GetFCGIAppNotFound) WithConfigurationVersion(configurationVersion string) *GetFCGIAppNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get Fcgi app not found response
func (o *GetFCGIAppNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get Fcgi app not found response
func (o *GetFCGIAppNotFound) WithPayload(payload *models.Error) *GetFCGIAppNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get Fcgi app not found response
func (o *GetFCGIAppNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetFCGIAppNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
GetFCGIAppDefault General Error

swagger:response getFcgiAppDefault
*/
type GetFCGIAppDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetFCGIAppDefault creates GetFCGIAppDefault with default headers values
func NewGetFCGIAppDefault(code int) *GetFCGIAppDefault {
	if code <= 0 {
		code = 500
	}

	return &GetFCGIAppDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the get FCGI app default response
func (o *GetFCGIAppDefault) WithStatusCode(code int) *GetFCGIAppDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the get FCGI app default response
func (o *GetFCGIAppDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the get FCGI app default response
func (o *GetFCGIAppDefault) WithConfigurationVersion(configurationVersion string) *GetFCGIAppDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get FCGI app default response
func (o *GetFCGIAppDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get FCGI app default response
func (o *GetFCGIAppDefault) WithPayload(payload *models.Error) *GetFCGIAppDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get FCGI app default response
func (o *GetFCGIAppDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetFCGIAppDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
