namespace NAPS2.Scan.Internal.Sane;

/// <summary>
/// Translations of option values used for matching against SANE, which doesn't provide non-localized
/// option values.
///
/// This isn't perfect as it doesn't fully account for historical/future translations or third-party
/// backends, but it's the best we can do for now.
/// </summary>
//
// Auto-generated by NAPS2.Tools.Localization.SaneOptsCommand.
// Run "n2 saneopts" to update.
internal static class SaneOptionTranslations {
    public static readonly string[] Color = {
        "Barva",
        "Color",
        "Colore",
        "Colour",
        "Cor",
        "Couleur",
        "Farbe",
        "Färg",
        "Farge",
        "Farve",
        "Kleur",
        "Kolor",
        "Koloro",
        "Színes",
        "Väri",
        "Кольоровий",
        "Цветной",
        "Цвят",
        "צבע",
        "カラー",
        "彩色"
    };

    public static readonly string[] Gray = {
        "Cinzento",
        "Grå",
        "Gråtone",
        "Graustufen",
        "Gray",
        "Grey",
        "Grigio",
        "Grijs",
        "Gris",
        "Grizo",
        "Harmaasävy",
        "Šedá",
        "Skala szarości",
        "Szürke",
        "Сиво",
        "Сірий",
        "Чёрно-белый",
        "אפור",
        "グレー",
        "灰阶"
    };

    public static readonly string[] Lineart = {
        "Art lineal",
        "Binario",
        "Duuma",
        "Lijntekening",
        "Liña de arte",
        "Línea de arte",
        "Lineart",
        "Linhas",
        "Perokresba",
        "Streckteckning",
        "Stregtegning",
        "Strektegning",
        "Strichzeichnung",
        "Trait",
        "Tryb kreski",
        "Viivapiirros",
        "Vonalas",
        "Штрихове",
        "Штриховой",
        "סגנון קווי",
        "線画",
        "线稿"
    };

    public static readonly string[] ADF = {
        "ADF",
        "Alimentador automático de documentos (ADF)",
        "Automatische documentinvoer",
        "Automatischer Dokumenteneinzug",
        "Automatisk dokumentmatare",
        "Chargeur automatique de documents",
        "АПД",
        "מזין מסמכים אוטומטי",
        "自动输稿器"
    };

    public static readonly string[] adf = {
        "adf",
        "ADF",
        "Automatischer Dokumenteneinzug",
        "АПД",
        "מזין מסמכים אוטומטי",
        "自动输稿器"
    };

    public static readonly string[] ADF_Front = {
        "A tapa do alimentador está aberta",
        "ADF Front",
        "ADF per a l'anvers",
        "ADF przód",
        "ADF表面",
        "Automatische documentinvoer voorzijde",
        "Automatischer Dokumenteneinzug vorne",
        "Automatisk dokumentmatare framsida",
        "Chargeur automatique de documents, recto",
        "Fronte ADF",
        "Kovrilo de ADF estas malfermita",
        "la tapa del alimentador está abierta",
        "Перед протяжного механізму",
        "חזית מזין מסמכים אוטומטי",
        "自动输稿器正面"
    };

    public static readonly string[] Automatic_Document_Feeder = {
        "Alimentador automàtic de documents",
        "Alimentador automático de documentos (ADF)",
        "Alimentatore automatico dei documenti",
        "Automaattinen syöttö",
        "Aŭtomata Provizilo de Dokumentoj",
        "Automatic Document Feeder",
        "Automatický podavač dokumentů",
        "Automatikus dokumentum adagoló",
        "Automatische documentinvoer",
        "Automatischer Dokumenteneinzug",
        "Automatisk dokumentføder",
        "Automatisk dokumentmatare",
        "Automatyczny podajnik dokumentów",
        "Chargeur automatique de document",
        "Автоматический податчик документов",
        "Автоматична подача документів",
        "Автоматично подаване на документи",
        "מזין מסמכים אוטומטי",
        "自动输稿器",
        "自動原稿送り装置"
    };

    public static readonly string[] ADF_Duplex = {
        "ADF Duplex",
        "ADF dwustronny",
        "ADF per a les dues cares",
        "ADF両面",
        "Alimentador a dos caras",
        "Alimentador dúplex",
        "Automatische documentinvoer dubbelzijdig",
        "Automatisk dokumentmatare dubbelsidigt",
        "Chargeur automatique de documents, recto-verso",
        "Dobbeltsidet",
        "Dokumenteneinzug mit Duplex",
        "Fronta-dorsa ADF",
        "Kaksipuolinen",
        "Oboustraně",
        "Двобічна АПД",
        "Двухсторонний",
        "Дуплексно",
        "דו צדדי מזין מסמכים אוטומטי",
        "自动输稿器双向"
    };

    public static readonly string[] Duplex = {
        "Dobbeltsidet",
        "Dos caras",
        "Duas caras",
        "Dubbelsidigt",
        "Dubbelzijdig",
        "Dues cares",
        "Duplex",
        "Dwustronny",
        "Fronta-dorsa",
        "Fronte e retro",
        "Kaksipuolinen",
        "Oboustraně",
        "Recto-verso",
        "Двобічна",
        "Двухсторонний",
        "Дуплексно",
        "דו צדדי",
        "両面",
        "双工"
    };

    public static readonly string[] Flatbed = {
        "A plat",
        "De superfície plana",
        "Fiksa ebeno",
        "Flachbett",
        "Flatbädd",
        "Flatbed",
        "Piano fisso",
        "Plana",
        "Plano",
        "Płyta",
        "Síkágyas",
        "Stolní",
        "Taso",
        "Планшет",
        "Планшетный",
        "סורק שטוח",
        "フラットベッド",
        "平板扫描仪"
    };

    public static readonly string[] FB = {
        "FB"
    };

    public static readonly string[] fb = {
        "fb",
        "Flachbett",
        "vitre",
        "планшет",
        "שטוח",
        "前按钮"
    };
}