// @generated by protoc-gen-es v2.6.0 with parameter "target=js+dts,import_extension=none,json_types=true"
// @generated from file runme/runner/v2/runner.proto (package runme.runner.v2, syntax proto3)
/* eslint-disable */

import type { GenEnum, GenFile, GenMessage, GenService } from "@bufbuild/protobuf/codegenv2";
import type { Message } from "@bufbuild/protobuf";
import type { ProgramConfig, ProgramConfigJson } from "./config_pb";
import type { UInt32ValueJson } from "@bufbuild/protobuf/wkt";

/**
 * Describes the file runme/runner/v2/runner.proto.
 */
export declare const file_runme_runner_v2_runner: GenFile;

/**
 * @generated from message runme.runner.v2.Project
 */
export declare type Project = Message<"runme.runner.v2.Project"> & {
  /**
   * root is a root directory of the project.
   * The semantic is the same as for the "--project"
   * flag in "runme".
   *
   * @generated from field: string root = 1;
   */
  root: string;

  /**
   * env_load_order is list of environment files
   * to try and load env from.
   *
   * @generated from field: repeated string env_load_order = 2;
   */
  envLoadOrder: string[];
};

/**
 * @generated from message runme.runner.v2.Project
 */
export declare type ProjectJson = {
  /**
   * root is a root directory of the project.
   * The semantic is the same as for the "--project"
   * flag in "runme".
   *
   * @generated from field: string root = 1;
   */
  root?: string;

  /**
   * env_load_order is list of environment files
   * to try and load env from.
   *
   * @generated from field: repeated string env_load_order = 2;
   */
  envLoadOrder?: string[];
};

/**
 * Describes the message runme.runner.v2.Project.
 * Use `create(ProjectSchema)` to create a new message.
 */
export declare const ProjectSchema: GenMessage<Project, {jsonType: ProjectJson}>;

/**
 * @generated from message runme.runner.v2.Session
 */
export declare type Session = Message<"runme.runner.v2.Session"> & {
  /**
   * @generated from field: string id = 1;
   */
  id: string;

  /**
   * env keeps track of session environment variables.
   * They can be modified by executing programs which
   * alter them through "export" and "unset" commands.
   *
   * @generated from field: repeated string env = 2;
   */
  env: string[];

  /**
   * metadata is a map of client specific metadata.
   *
   * @generated from field: map<string, string> metadata = 3;
   */
  metadata: { [key: string]: string };
};

/**
 * @generated from message runme.runner.v2.Session
 */
export declare type SessionJson = {
  /**
   * @generated from field: string id = 1;
   */
  id?: string;

  /**
   * env keeps track of session environment variables.
   * They can be modified by executing programs which
   * alter them through "export" and "unset" commands.
   *
   * @generated from field: repeated string env = 2;
   */
  env?: string[];

  /**
   * metadata is a map of client specific metadata.
   *
   * @generated from field: map<string, string> metadata = 3;
   */
  metadata?: { [key: string]: string };
};

/**
 * Describes the message runme.runner.v2.Session.
 * Use `create(SessionSchema)` to create a new message.
 */
export declare const SessionSchema: GenMessage<Session, {jsonType: SessionJson}>;

/**
 * @generated from message runme.runner.v2.CreateSessionRequest
 */
export declare type CreateSessionRequest = Message<"runme.runner.v2.CreateSessionRequest"> & {
  /**
   * metadata is a map of client specific metadata.
   *
   * @generated from field: map<string, string> metadata = 1;
   */
  metadata: { [key: string]: string };

  /**
   * env field provides an initial set of environment variables
   * for a newly created session.
   *
   * @generated from field: repeated string env = 2;
   */
  env: string[];

  /**
   * project from which to load environment variables.
   * They will be appended to the list from the env field.
   * The env field has a higher priority.
   *
   * @generated from field: optional runme.runner.v2.Project project = 3;
   */
  project?: Project;

  /**
   * Deprecated use config instead. optional selection
   * of which env store implementation to use.
   *
   * @generated from field: optional runme.runner.v2.SessionEnvStoreType env_store_type = 4;
   */
  envStoreType?: SessionEnvStoreType;

  /**
   * @generated from field: runme.runner.v2.CreateSessionRequest.Config config = 5;
   */
  config?: CreateSessionRequest_Config;
};

/**
 * @generated from message runme.runner.v2.CreateSessionRequest
 */
export declare type CreateSessionRequestJson = {
  /**
   * metadata is a map of client specific metadata.
   *
   * @generated from field: map<string, string> metadata = 1;
   */
  metadata?: { [key: string]: string };

  /**
   * env field provides an initial set of environment variables
   * for a newly created session.
   *
   * @generated from field: repeated string env = 2;
   */
  env?: string[];

  /**
   * project from which to load environment variables.
   * They will be appended to the list from the env field.
   * The env field has a higher priority.
   *
   * @generated from field: optional runme.runner.v2.Project project = 3;
   */
  project?: ProjectJson;

  /**
   * Deprecated use config instead. optional selection
   * of which env store implementation to use.
   *
   * @generated from field: optional runme.runner.v2.SessionEnvStoreType env_store_type = 4;
   */
  envStoreType?: SessionEnvStoreTypeJson;

  /**
   * @generated from field: runme.runner.v2.CreateSessionRequest.Config config = 5;
   */
  config?: CreateSessionRequest_ConfigJson;
};

/**
 * Describes the message runme.runner.v2.CreateSessionRequest.
 * Use `create(CreateSessionRequestSchema)` to create a new message.
 */
export declare const CreateSessionRequestSchema: GenMessage<CreateSessionRequest, {jsonType: CreateSessionRequestJson}>;

/**
 * @generated from message runme.runner.v2.CreateSessionRequest.Config
 */
export declare type CreateSessionRequest_Config = Message<"runme.runner.v2.CreateSessionRequest.Config"> & {
  /**
   * optional selection of which env store implementation to use.
   *
   * @generated from field: optional runme.runner.v2.SessionEnvStoreType env_store_type = 1;
   */
  envStoreType?: SessionEnvStoreType;

  /**
   * how to seed initial ENV
   *
   * @generated from field: optional runme.runner.v2.CreateSessionRequest.Config.SessionEnvStoreSeeding env_store_seeding = 2;
   */
  envStoreSeeding?: CreateSessionRequest_Config_SessionEnvStoreSeeding;
};

/**
 * @generated from message runme.runner.v2.CreateSessionRequest.Config
 */
export declare type CreateSessionRequest_ConfigJson = {
  /**
   * optional selection of which env store implementation to use.
   *
   * @generated from field: optional runme.runner.v2.SessionEnvStoreType env_store_type = 1;
   */
  envStoreType?: SessionEnvStoreTypeJson;

  /**
   * how to seed initial ENV
   *
   * @generated from field: optional runme.runner.v2.CreateSessionRequest.Config.SessionEnvStoreSeeding env_store_seeding = 2;
   */
  envStoreSeeding?: CreateSessionRequest_Config_SessionEnvStoreSeedingJson;
};

/**
 * Describes the message runme.runner.v2.CreateSessionRequest.Config.
 * Use `create(CreateSessionRequest_ConfigSchema)` to create a new message.
 */
export declare const CreateSessionRequest_ConfigSchema: GenMessage<CreateSessionRequest_Config, {jsonType: CreateSessionRequest_ConfigJson}>;

/**
 * @generated from enum runme.runner.v2.CreateSessionRequest.Config.SessionEnvStoreSeeding
 */
export enum CreateSessionRequest_Config_SessionEnvStoreSeeding {
  /**
   * default seeding; ignore system
   *
   * @generated from enum value: SESSION_ENV_STORE_SEEDING_UNSPECIFIED = 0;
   */
  UNSPECIFIED = 0,

  /**
   * enable seeding from system
   *
   * @generated from enum value: SESSION_ENV_STORE_SEEDING_SYSTEM = 1;
   */
  SYSTEM = 1,
}

/**
 * @generated from enum runme.runner.v2.CreateSessionRequest.Config.SessionEnvStoreSeeding
 */
export declare type CreateSessionRequest_Config_SessionEnvStoreSeedingJson = "SESSION_ENV_STORE_SEEDING_UNSPECIFIED" | "SESSION_ENV_STORE_SEEDING_SYSTEM";

/**
 * Describes the enum runme.runner.v2.CreateSessionRequest.Config.SessionEnvStoreSeeding.
 */
export declare const CreateSessionRequest_Config_SessionEnvStoreSeedingSchema: GenEnum<CreateSessionRequest_Config_SessionEnvStoreSeeding, CreateSessionRequest_Config_SessionEnvStoreSeedingJson>;

/**
 * @generated from message runme.runner.v2.CreateSessionResponse
 */
export declare type CreateSessionResponse = Message<"runme.runner.v2.CreateSessionResponse"> & {
  /**
   * @generated from field: runme.runner.v2.Session session = 1;
   */
  session?: Session;
};

/**
 * @generated from message runme.runner.v2.CreateSessionResponse
 */
export declare type CreateSessionResponseJson = {
  /**
   * @generated from field: runme.runner.v2.Session session = 1;
   */
  session?: SessionJson;
};

/**
 * Describes the message runme.runner.v2.CreateSessionResponse.
 * Use `create(CreateSessionResponseSchema)` to create a new message.
 */
export declare const CreateSessionResponseSchema: GenMessage<CreateSessionResponse, {jsonType: CreateSessionResponseJson}>;

/**
 * @generated from message runme.runner.v2.GetSessionRequest
 */
export declare type GetSessionRequest = Message<"runme.runner.v2.GetSessionRequest"> & {
  /**
   * @generated from field: string id = 1;
   */
  id: string;
};

/**
 * @generated from message runme.runner.v2.GetSessionRequest
 */
export declare type GetSessionRequestJson = {
  /**
   * @generated from field: string id = 1;
   */
  id?: string;
};

/**
 * Describes the message runme.runner.v2.GetSessionRequest.
 * Use `create(GetSessionRequestSchema)` to create a new message.
 */
export declare const GetSessionRequestSchema: GenMessage<GetSessionRequest, {jsonType: GetSessionRequestJson}>;

/**
 * @generated from message runme.runner.v2.GetSessionResponse
 */
export declare type GetSessionResponse = Message<"runme.runner.v2.GetSessionResponse"> & {
  /**
   * @generated from field: runme.runner.v2.Session session = 1;
   */
  session?: Session;
};

/**
 * @generated from message runme.runner.v2.GetSessionResponse
 */
export declare type GetSessionResponseJson = {
  /**
   * @generated from field: runme.runner.v2.Session session = 1;
   */
  session?: SessionJson;
};

/**
 * Describes the message runme.runner.v2.GetSessionResponse.
 * Use `create(GetSessionResponseSchema)` to create a new message.
 */
export declare const GetSessionResponseSchema: GenMessage<GetSessionResponse, {jsonType: GetSessionResponseJson}>;

/**
 * @generated from message runme.runner.v2.ListSessionsRequest
 */
export declare type ListSessionsRequest = Message<"runme.runner.v2.ListSessionsRequest"> & {
};

/**
 * @generated from message runme.runner.v2.ListSessionsRequest
 */
export declare type ListSessionsRequestJson = {
};

/**
 * Describes the message runme.runner.v2.ListSessionsRequest.
 * Use `create(ListSessionsRequestSchema)` to create a new message.
 */
export declare const ListSessionsRequestSchema: GenMessage<ListSessionsRequest, {jsonType: ListSessionsRequestJson}>;

/**
 * @generated from message runme.runner.v2.ListSessionsResponse
 */
export declare type ListSessionsResponse = Message<"runme.runner.v2.ListSessionsResponse"> & {
  /**
   * @generated from field: repeated runme.runner.v2.Session sessions = 1;
   */
  sessions: Session[];
};

/**
 * @generated from message runme.runner.v2.ListSessionsResponse
 */
export declare type ListSessionsResponseJson = {
  /**
   * @generated from field: repeated runme.runner.v2.Session sessions = 1;
   */
  sessions?: SessionJson[];
};

/**
 * Describes the message runme.runner.v2.ListSessionsResponse.
 * Use `create(ListSessionsResponseSchema)` to create a new message.
 */
export declare const ListSessionsResponseSchema: GenMessage<ListSessionsResponse, {jsonType: ListSessionsResponseJson}>;

/**
 * @generated from message runme.runner.v2.UpdateSessionRequest
 */
export declare type UpdateSessionRequest = Message<"runme.runner.v2.UpdateSessionRequest"> & {
  /**
   * @generated from field: string id = 1;
   */
  id: string;

  /**
   * metadata is a map of client specific metadata.
   *
   * @generated from field: map<string, string> metadata = 2;
   */
  metadata: { [key: string]: string };

  /**
   * env field provides an initial set of environment variables
   * for a newly created session.
   *
   * @generated from field: repeated string env = 3;
   */
  env: string[];

  /**
   * project from which to load environment variables.
   * They will be appended to the list from the env field.
   * The env field has a higher priority.
   *
   * @generated from field: optional runme.runner.v2.Project project = 4;
   */
  project?: Project;
};

/**
 * @generated from message runme.runner.v2.UpdateSessionRequest
 */
export declare type UpdateSessionRequestJson = {
  /**
   * @generated from field: string id = 1;
   */
  id?: string;

  /**
   * metadata is a map of client specific metadata.
   *
   * @generated from field: map<string, string> metadata = 2;
   */
  metadata?: { [key: string]: string };

  /**
   * env field provides an initial set of environment variables
   * for a newly created session.
   *
   * @generated from field: repeated string env = 3;
   */
  env?: string[];

  /**
   * project from which to load environment variables.
   * They will be appended to the list from the env field.
   * The env field has a higher priority.
   *
   * @generated from field: optional runme.runner.v2.Project project = 4;
   */
  project?: ProjectJson;
};

/**
 * Describes the message runme.runner.v2.UpdateSessionRequest.
 * Use `create(UpdateSessionRequestSchema)` to create a new message.
 */
export declare const UpdateSessionRequestSchema: GenMessage<UpdateSessionRequest, {jsonType: UpdateSessionRequestJson}>;

/**
 * @generated from message runme.runner.v2.UpdateSessionResponse
 */
export declare type UpdateSessionResponse = Message<"runme.runner.v2.UpdateSessionResponse"> & {
  /**
   * @generated from field: runme.runner.v2.Session session = 1;
   */
  session?: Session;
};

/**
 * @generated from message runme.runner.v2.UpdateSessionResponse
 */
export declare type UpdateSessionResponseJson = {
  /**
   * @generated from field: runme.runner.v2.Session session = 1;
   */
  session?: SessionJson;
};

/**
 * Describes the message runme.runner.v2.UpdateSessionResponse.
 * Use `create(UpdateSessionResponseSchema)` to create a new message.
 */
export declare const UpdateSessionResponseSchema: GenMessage<UpdateSessionResponse, {jsonType: UpdateSessionResponseJson}>;

/**
 * @generated from message runme.runner.v2.DeleteSessionRequest
 */
export declare type DeleteSessionRequest = Message<"runme.runner.v2.DeleteSessionRequest"> & {
  /**
   * @generated from field: string id = 1;
   */
  id: string;
};

/**
 * @generated from message runme.runner.v2.DeleteSessionRequest
 */
export declare type DeleteSessionRequestJson = {
  /**
   * @generated from field: string id = 1;
   */
  id?: string;
};

/**
 * Describes the message runme.runner.v2.DeleteSessionRequest.
 * Use `create(DeleteSessionRequestSchema)` to create a new message.
 */
export declare const DeleteSessionRequestSchema: GenMessage<DeleteSessionRequest, {jsonType: DeleteSessionRequestJson}>;

/**
 * @generated from message runme.runner.v2.DeleteSessionResponse
 */
export declare type DeleteSessionResponse = Message<"runme.runner.v2.DeleteSessionResponse"> & {
};

/**
 * @generated from message runme.runner.v2.DeleteSessionResponse
 */
export declare type DeleteSessionResponseJson = {
};

/**
 * Describes the message runme.runner.v2.DeleteSessionResponse.
 * Use `create(DeleteSessionResponseSchema)` to create a new message.
 */
export declare const DeleteSessionResponseSchema: GenMessage<DeleteSessionResponse, {jsonType: DeleteSessionResponseJson}>;

/**
 * @generated from message runme.runner.v2.Winsize
 */
export declare type Winsize = Message<"runme.runner.v2.Winsize"> & {
  /**
   * @generated from field: uint32 rows = 1;
   */
  rows: number;

  /**
   * @generated from field: uint32 cols = 2;
   */
  cols: number;

  /**
   * @generated from field: uint32 x = 3;
   */
  x: number;

  /**
   * @generated from field: uint32 y = 4;
   */
  y: number;
};

/**
 * @generated from message runme.runner.v2.Winsize
 */
export declare type WinsizeJson = {
  /**
   * @generated from field: uint32 rows = 1;
   */
  rows?: number;

  /**
   * @generated from field: uint32 cols = 2;
   */
  cols?: number;

  /**
   * @generated from field: uint32 x = 3;
   */
  x?: number;

  /**
   * @generated from field: uint32 y = 4;
   */
  y?: number;
};

/**
 * Describes the message runme.runner.v2.Winsize.
 * Use `create(WinsizeSchema)` to create a new message.
 */
export declare const WinsizeSchema: GenMessage<Winsize, {jsonType: WinsizeJson}>;

/**
 * @generated from message runme.runner.v2.ExecuteRequest
 */
export declare type ExecuteRequest = Message<"runme.runner.v2.ExecuteRequest"> & {
  /**
   * @generated from field: runme.runner.v2.ProgramConfig config = 1;
   */
  config?: ProgramConfig;

  /**
   * input_data is a byte array that will be send as input
   * to the program.
   *
   * @generated from field: bytes input_data = 8;
   */
  inputData: Uint8Array;

  /**
   * stop requests the running process to be stopped.
   * It is allowed only in the consecutive calls.
   *
   * @generated from field: runme.runner.v2.ExecuteStop stop = 9;
   */
  stop: ExecuteStop;

  /**
   * sets pty winsize
   * has no effect in non-interactive mode
   *
   * @generated from field: optional runme.runner.v2.Winsize winsize = 10;
   */
  winsize?: Winsize;

  /**
   * session_id indicates in which Session the program should execute.
   * Executing in a Session might provide additional context like
   * environment variables.
   *
   * @generated from field: string session_id = 20;
   */
  sessionId: string;

  /**
   * session_strategy is a strategy for selecting the session.
   *
   * @generated from field: runme.runner.v2.SessionStrategy session_strategy = 21;
   */
  sessionStrategy: SessionStrategy;

  /**
   * project used to load environment variables from .env files.
   *
   * @generated from field: optional runme.runner.v2.Project project = 22;
   */
  project?: Project;

  /**
   * store_stdout_in_env, if true, will store the stdout under well known name
   * and the last ran block in the environment variable `__`.
   *
   * @generated from field: bool store_stdout_in_env = 23;
   */
  storeStdoutInEnv: boolean;
};

/**
 * @generated from message runme.runner.v2.ExecuteRequest
 */
export declare type ExecuteRequestJson = {
  /**
   * @generated from field: runme.runner.v2.ProgramConfig config = 1;
   */
  config?: ProgramConfigJson;

  /**
   * input_data is a byte array that will be send as input
   * to the program.
   *
   * @generated from field: bytes input_data = 8;
   */
  inputData?: string;

  /**
   * stop requests the running process to be stopped.
   * It is allowed only in the consecutive calls.
   *
   * @generated from field: runme.runner.v2.ExecuteStop stop = 9;
   */
  stop?: ExecuteStopJson;

  /**
   * sets pty winsize
   * has no effect in non-interactive mode
   *
   * @generated from field: optional runme.runner.v2.Winsize winsize = 10;
   */
  winsize?: WinsizeJson;

  /**
   * session_id indicates in which Session the program should execute.
   * Executing in a Session might provide additional context like
   * environment variables.
   *
   * @generated from field: string session_id = 20;
   */
  sessionId?: string;

  /**
   * session_strategy is a strategy for selecting the session.
   *
   * @generated from field: runme.runner.v2.SessionStrategy session_strategy = 21;
   */
  sessionStrategy?: SessionStrategyJson;

  /**
   * project used to load environment variables from .env files.
   *
   * @generated from field: optional runme.runner.v2.Project project = 22;
   */
  project?: ProjectJson;

  /**
   * store_stdout_in_env, if true, will store the stdout under well known name
   * and the last ran block in the environment variable `__`.
   *
   * @generated from field: bool store_stdout_in_env = 23;
   */
  storeStdoutInEnv?: boolean;
};

/**
 * Describes the message runme.runner.v2.ExecuteRequest.
 * Use `create(ExecuteRequestSchema)` to create a new message.
 */
export declare const ExecuteRequestSchema: GenMessage<ExecuteRequest, {jsonType: ExecuteRequestJson}>;

/**
 * @generated from message runme.runner.v2.ExecuteResponse
 */
export declare type ExecuteResponse = Message<"runme.runner.v2.ExecuteResponse"> & {
  /**
   * exit_code is sent only in the final message.
   *
   * @generated from field: google.protobuf.UInt32Value exit_code = 1;
   */
  exitCode?: number;

  /**
   * stdout_data contains bytes from stdout since the last response.
   *
   * @generated from field: bytes stdout_data = 2;
   */
  stdoutData: Uint8Array;

  /**
   * stderr_data contains bytes from stderr since the last response.
   *
   * @generated from field: bytes stderr_data = 3;
   */
  stderrData: Uint8Array;

  /**
   * pid contains the process' PID.
   *
   * This is only sent once in an initial response for background processes.
   *
   * @generated from field: google.protobuf.UInt32Value pid = 4;
   */
  pid?: number;

  /**
   * mime_type is a detected MIME type of the stdout_data.
   *
   * This is only sent once in the first response containing stdout_data.
   *
   * @generated from field: string mime_type = 5;
   */
  mimeType: string;
};

/**
 * @generated from message runme.runner.v2.ExecuteResponse
 */
export declare type ExecuteResponseJson = {
  /**
   * exit_code is sent only in the final message.
   *
   * @generated from field: google.protobuf.UInt32Value exit_code = 1;
   */
  exitCode?: UInt32ValueJson;

  /**
   * stdout_data contains bytes from stdout since the last response.
   *
   * @generated from field: bytes stdout_data = 2;
   */
  stdoutData?: string;

  /**
   * stderr_data contains bytes from stderr since the last response.
   *
   * @generated from field: bytes stderr_data = 3;
   */
  stderrData?: string;

  /**
   * pid contains the process' PID.
   *
   * This is only sent once in an initial response for background processes.
   *
   * @generated from field: google.protobuf.UInt32Value pid = 4;
   */
  pid?: UInt32ValueJson;

  /**
   * mime_type is a detected MIME type of the stdout_data.
   *
   * This is only sent once in the first response containing stdout_data.
   *
   * @generated from field: string mime_type = 5;
   */
  mimeType?: string;
};

/**
 * Describes the message runme.runner.v2.ExecuteResponse.
 * Use `create(ExecuteResponseSchema)` to create a new message.
 */
export declare const ExecuteResponseSchema: GenMessage<ExecuteResponse, {jsonType: ExecuteResponseJson}>;

/**
 * @generated from message runme.runner.v2.ResolveProgramCommandList
 */
export declare type ResolveProgramCommandList = Message<"runme.runner.v2.ResolveProgramCommandList"> & {
  /**
   * commands are commands to be executed by the program.
   * The commands are joined and executed as a script.
   * For example: ["echo 'Hello, World'", "ls -l /etc"].
   *
   * @generated from field: repeated string lines = 1;
   */
  lines: string[];
};

/**
 * @generated from message runme.runner.v2.ResolveProgramCommandList
 */
export declare type ResolveProgramCommandListJson = {
  /**
   * commands are commands to be executed by the program.
   * The commands are joined and executed as a script.
   * For example: ["echo 'Hello, World'", "ls -l /etc"].
   *
   * @generated from field: repeated string lines = 1;
   */
  lines?: string[];
};

/**
 * Describes the message runme.runner.v2.ResolveProgramCommandList.
 * Use `create(ResolveProgramCommandListSchema)` to create a new message.
 */
export declare const ResolveProgramCommandListSchema: GenMessage<ResolveProgramCommandList, {jsonType: ResolveProgramCommandListJson}>;

/**
 * @generated from message runme.runner.v2.ResolveProgramRequest
 */
export declare type ResolveProgramRequest = Message<"runme.runner.v2.ResolveProgramRequest"> & {
  /**
   * use script for unnormalized cell content
   * whereas commands is for normalized shell commands
   *
   * @generated from oneof runme.runner.v2.ResolveProgramRequest.source
   */
  source: {
    /**
     * commands are commands to be executed by the program.
     * The commands are joined and executed as a script.
     *
     * @generated from field: runme.runner.v2.ResolveProgramCommandList commands = 1;
     */
    value: ResolveProgramCommandList;
    case: "commands";
  } | {
    /**
     * script is code to be executed by the program.
     * Individual lines are joined with the new line character.
     *
     * @generated from field: string script = 2;
     */
    value: string;
    case: "script";
  } | { case: undefined; value?: undefined };

  /**
   * mode determines how variables resolution occurs.
   * It is usually based on document or cell annotation config.
   *
   * @generated from field: runme.runner.v2.ResolveProgramRequest.Mode mode = 3;
   */
  mode: ResolveProgramRequest_Mode;

  /**
   * env is a list of explicit environment variables that will be used
   * to resolve the environment variables found in the source.
   *
   * @generated from field: repeated string env = 4;
   */
  env: string[];

  /**
   * session_id indicates which session is the source of
   * environment variables. If not provided, the most recent
   * session can be used using session_strategy.
   *
   * @generated from field: string session_id = 5;
   */
  sessionId: string;

  /**
   * session_strategy is a strategy for selecting the session.
   *
   * @generated from field: runme.runner.v2.SessionStrategy session_strategy = 6;
   */
  sessionStrategy: SessionStrategy;

  /**
   * project used to load environment variables from .env files.
   *
   * @generated from field: optional runme.runner.v2.Project project = 7;
   */
  project?: Project;

  /**
   * language id associated with script.
   *
   * @generated from field: string language_id = 8;
   */
  languageId: string;

  /**
   * retention determines how variables are retained once resolved.
   *
   * @generated from field: runme.runner.v2.ResolveProgramRequest.Retention retention = 9;
   */
  retention: ResolveProgramRequest_Retention;
};

/**
 * @generated from message runme.runner.v2.ResolveProgramRequest
 */
export declare type ResolveProgramRequestJson = {
  /**
   * commands are commands to be executed by the program.
   * The commands are joined and executed as a script.
   *
   * @generated from field: runme.runner.v2.ResolveProgramCommandList commands = 1;
   */
  commands?: ResolveProgramCommandListJson;

  /**
   * script is code to be executed by the program.
   * Individual lines are joined with the new line character.
   *
   * @generated from field: string script = 2;
   */
  script?: string;

  /**
   * mode determines how variables resolution occurs.
   * It is usually based on document or cell annotation config.
   *
   * @generated from field: runme.runner.v2.ResolveProgramRequest.Mode mode = 3;
   */
  mode?: ResolveProgramRequest_ModeJson;

  /**
   * env is a list of explicit environment variables that will be used
   * to resolve the environment variables found in the source.
   *
   * @generated from field: repeated string env = 4;
   */
  env?: string[];

  /**
   * session_id indicates which session is the source of
   * environment variables. If not provided, the most recent
   * session can be used using session_strategy.
   *
   * @generated from field: string session_id = 5;
   */
  sessionId?: string;

  /**
   * session_strategy is a strategy for selecting the session.
   *
   * @generated from field: runme.runner.v2.SessionStrategy session_strategy = 6;
   */
  sessionStrategy?: SessionStrategyJson;

  /**
   * project used to load environment variables from .env files.
   *
   * @generated from field: optional runme.runner.v2.Project project = 7;
   */
  project?: ProjectJson;

  /**
   * language id associated with script.
   *
   * @generated from field: string language_id = 8;
   */
  languageId?: string;

  /**
   * retention determines how variables are retained once resolved.
   *
   * @generated from field: runme.runner.v2.ResolveProgramRequest.Retention retention = 9;
   */
  retention?: ResolveProgramRequest_RetentionJson;
};

/**
 * Describes the message runme.runner.v2.ResolveProgramRequest.
 * Use `create(ResolveProgramRequestSchema)` to create a new message.
 */
export declare const ResolveProgramRequestSchema: GenMessage<ResolveProgramRequest, {jsonType: ResolveProgramRequestJson}>;

/**
 * @generated from enum runme.runner.v2.ResolveProgramRequest.Mode
 */
export enum ResolveProgramRequest_Mode {
  /**
   * unspecified is auto (default) which prompts for all
   * unresolved environment variables.
   * Subsequent runs will likely resolve via the session.
   *
   * @generated from enum value: MODE_UNSPECIFIED = 0;
   */
  UNSPECIFIED = 0,

  /**
   * prompt always means to prompt for all environment variables.
   *
   * @generated from enum value: MODE_PROMPT_ALL = 1;
   */
  PROMPT_ALL = 1,

  /**
   * skip means to not prompt for any environment variables.
   * All variables will be marked as resolved.
   *
   * @generated from enum value: MODE_SKIP_ALL = 2;
   */
  SKIP_ALL = 2,
}

/**
 * @generated from enum runme.runner.v2.ResolveProgramRequest.Mode
 */
export declare type ResolveProgramRequest_ModeJson = "MODE_UNSPECIFIED" | "MODE_PROMPT_ALL" | "MODE_SKIP_ALL";

/**
 * Describes the enum runme.runner.v2.ResolveProgramRequest.Mode.
 */
export declare const ResolveProgramRequest_ModeSchema: GenEnum<ResolveProgramRequest_Mode, ResolveProgramRequest_ModeJson>;

/**
 * @generated from enum runme.runner.v2.ResolveProgramRequest.Retention
 */
export enum ResolveProgramRequest_Retention {
  /**
   * @generated from enum value: RETENTION_UNSPECIFIED = 0;
   */
  UNSPECIFIED = 0,

  /**
   * first run means to always retain the first resolved value.
   *
   * @generated from enum value: RETENTION_FIRST_RUN = 1;
   */
  FIRST_RUN = 1,

  /**
   * last run means to always retain the last resolved value.
   *
   * @generated from enum value: RETENTION_LAST_RUN = 2;
   */
  LAST_RUN = 2,
}

/**
 * @generated from enum runme.runner.v2.ResolveProgramRequest.Retention
 */
export declare type ResolveProgramRequest_RetentionJson = "RETENTION_UNSPECIFIED" | "RETENTION_FIRST_RUN" | "RETENTION_LAST_RUN";

/**
 * Describes the enum runme.runner.v2.ResolveProgramRequest.Retention.
 */
export declare const ResolveProgramRequest_RetentionSchema: GenEnum<ResolveProgramRequest_Retention, ResolveProgramRequest_RetentionJson>;

/**
 * @generated from message runme.runner.v2.ResolveProgramResponse
 */
export declare type ResolveProgramResponse = Message<"runme.runner.v2.ResolveProgramResponse"> & {
  /**
   * @generated from field: string script = 1;
   */
  script: string;

  /**
   * use script until commands normalization is implemented
   *
   * @generated from field: runme.runner.v2.ResolveProgramCommandList commands = 2;
   */
  commands?: ResolveProgramCommandList;

  /**
   * @generated from field: repeated runme.runner.v2.ResolveProgramResponse.VarResult vars = 3;
   */
  vars: ResolveProgramResponse_VarResult[];
};

/**
 * @generated from message runme.runner.v2.ResolveProgramResponse
 */
export declare type ResolveProgramResponseJson = {
  /**
   * @generated from field: string script = 1;
   */
  script?: string;

  /**
   * use script until commands normalization is implemented
   *
   * @generated from field: runme.runner.v2.ResolveProgramCommandList commands = 2;
   */
  commands?: ResolveProgramCommandListJson;

  /**
   * @generated from field: repeated runme.runner.v2.ResolveProgramResponse.VarResult vars = 3;
   */
  vars?: ResolveProgramResponse_VarResultJson[];
};

/**
 * Describes the message runme.runner.v2.ResolveProgramResponse.
 * Use `create(ResolveProgramResponseSchema)` to create a new message.
 */
export declare const ResolveProgramResponseSchema: GenMessage<ResolveProgramResponse, {jsonType: ResolveProgramResponseJson}>;

/**
 * @generated from message runme.runner.v2.ResolveProgramResponse.VarResult
 */
export declare type ResolveProgramResponse_VarResult = Message<"runme.runner.v2.ResolveProgramResponse.VarResult"> & {
  /**
   * prompt indicates the resolution status of the env variable.
   *
   * @generated from field: runme.runner.v2.ResolveProgramResponse.Status status = 1;
   */
  status: ResolveProgramResponse_Status;

  /**
   * name is the name of the environment variable.
   *
   * @generated from field: string name = 2;
   */
  name: string;

  /**
   * original_value is a default value of the environment variable.
   * It might be a value that is assigned to the variable in the script,
   * like FOO=bar or FOO=${FOO:-bar}.
   * If the variable is not assigned, it is an empty string.
   *
   * @generated from field: string original_value = 3;
   */
  originalValue: string;

  /**
   * resolved_value is a value of the environment variable resolved from a source.
   * If it is an empty string, it means that the environment variable is not resolved.
   *
   * @generated from field: string resolved_value = 4;
   */
  resolvedValue: string;
};

/**
 * @generated from message runme.runner.v2.ResolveProgramResponse.VarResult
 */
export declare type ResolveProgramResponse_VarResultJson = {
  /**
   * prompt indicates the resolution status of the env variable.
   *
   * @generated from field: runme.runner.v2.ResolveProgramResponse.Status status = 1;
   */
  status?: ResolveProgramResponse_StatusJson;

  /**
   * name is the name of the environment variable.
   *
   * @generated from field: string name = 2;
   */
  name?: string;

  /**
   * original_value is a default value of the environment variable.
   * It might be a value that is assigned to the variable in the script,
   * like FOO=bar or FOO=${FOO:-bar}.
   * If the variable is not assigned, it is an empty string.
   *
   * @generated from field: string original_value = 3;
   */
  originalValue?: string;

  /**
   * resolved_value is a value of the environment variable resolved from a source.
   * If it is an empty string, it means that the environment variable is not resolved.
   *
   * @generated from field: string resolved_value = 4;
   */
  resolvedValue?: string;
};

/**
 * Describes the message runme.runner.v2.ResolveProgramResponse.VarResult.
 * Use `create(ResolveProgramResponse_VarResultSchema)` to create a new message.
 */
export declare const ResolveProgramResponse_VarResultSchema: GenMessage<ResolveProgramResponse_VarResult, {jsonType: ResolveProgramResponse_VarResultJson}>;

/**
 * @generated from enum runme.runner.v2.ResolveProgramResponse.Status
 */
export enum ResolveProgramResponse_Status {
  /**
   * unspecified is the default value and it means unresolved.
   *
   * @generated from enum value: STATUS_UNSPECIFIED = 0;
   */
  UNSPECIFIED = 0,

  /**
   * resolved means that the variable is resolved.
   *
   * @generated from enum value: STATUS_RESOLVED = 1;
   */
  RESOLVED = 1,

  /**
   * unresolved with message means that the variable is unresolved
   * but it contains a message. E.g. FOO=this is message.
   *
   * @generated from enum value: STATUS_UNRESOLVED_WITH_MESSAGE = 2;
   */
  UNRESOLVED_WITH_MESSAGE = 2,

  /**
   * unresolved with placeholder means that the variable is unresolved
   * but it contains a placeholder. E.g. FOO="this is placeholder".
   *
   * @generated from enum value: STATUS_UNRESOLVED_WITH_PLACEHOLDER = 3;
   */
  UNRESOLVED_WITH_PLACEHOLDER = 3,

  /**
   * unresolved with secret means that the variable is unresolved
   * and it requires treatment as a secret.
   *
   * @generated from enum value: STATUS_UNRESOLVED_WITH_SECRET = 4;
   */
  UNRESOLVED_WITH_SECRET = 4,
}

/**
 * @generated from enum runme.runner.v2.ResolveProgramResponse.Status
 */
export declare type ResolveProgramResponse_StatusJson = "STATUS_UNSPECIFIED" | "STATUS_RESOLVED" | "STATUS_UNRESOLVED_WITH_MESSAGE" | "STATUS_UNRESOLVED_WITH_PLACEHOLDER" | "STATUS_UNRESOLVED_WITH_SECRET";

/**
 * Describes the enum runme.runner.v2.ResolveProgramResponse.Status.
 */
export declare const ResolveProgramResponse_StatusSchema: GenEnum<ResolveProgramResponse_Status, ResolveProgramResponse_StatusJson>;

/**
 * @generated from message runme.runner.v2.MonitorEnvStoreRequest
 */
export declare type MonitorEnvStoreRequest = Message<"runme.runner.v2.MonitorEnvStoreRequest"> & {
  /**
   * @generated from field: runme.runner.v2.Session session = 1;
   */
  session?: Session;
};

/**
 * @generated from message runme.runner.v2.MonitorEnvStoreRequest
 */
export declare type MonitorEnvStoreRequestJson = {
  /**
   * @generated from field: runme.runner.v2.Session session = 1;
   */
  session?: SessionJson;
};

/**
 * Describes the message runme.runner.v2.MonitorEnvStoreRequest.
 * Use `create(MonitorEnvStoreRequestSchema)` to create a new message.
 */
export declare const MonitorEnvStoreRequestSchema: GenMessage<MonitorEnvStoreRequest, {jsonType: MonitorEnvStoreRequestJson}>;

/**
 * @generated from message runme.runner.v2.MonitorEnvStoreResponseSnapshot
 */
export declare type MonitorEnvStoreResponseSnapshot = Message<"runme.runner.v2.MonitorEnvStoreResponseSnapshot"> & {
  /**
   * @generated from field: repeated runme.runner.v2.MonitorEnvStoreResponseSnapshot.SnapshotEnv envs = 1;
   */
  envs: MonitorEnvStoreResponseSnapshot_SnapshotEnv[];
};

/**
 * @generated from message runme.runner.v2.MonitorEnvStoreResponseSnapshot
 */
export declare type MonitorEnvStoreResponseSnapshotJson = {
  /**
   * @generated from field: repeated runme.runner.v2.MonitorEnvStoreResponseSnapshot.SnapshotEnv envs = 1;
   */
  envs?: MonitorEnvStoreResponseSnapshot_SnapshotEnvJson[];
};

/**
 * Describes the message runme.runner.v2.MonitorEnvStoreResponseSnapshot.
 * Use `create(MonitorEnvStoreResponseSnapshotSchema)` to create a new message.
 */
export declare const MonitorEnvStoreResponseSnapshotSchema: GenMessage<MonitorEnvStoreResponseSnapshot, {jsonType: MonitorEnvStoreResponseSnapshotJson}>;

/**
 * @generated from message runme.runner.v2.MonitorEnvStoreResponseSnapshot.SnapshotEnv
 */
export declare type MonitorEnvStoreResponseSnapshot_SnapshotEnv = Message<"runme.runner.v2.MonitorEnvStoreResponseSnapshot.SnapshotEnv"> & {
  /**
   * @generated from field: runme.runner.v2.MonitorEnvStoreResponseSnapshot.Status status = 1;
   */
  status: MonitorEnvStoreResponseSnapshot_Status;

  /**
   * @generated from field: string name = 2;
   */
  name: string;

  /**
   * @generated from field: string description = 3;
   */
  description: string;

  /**
   * @generated from field: string spec = 4;
   */
  spec: string;

  /**
   * @generated from field: bool is_required = 5;
   */
  isRequired: boolean;

  /**
   * @generated from field: string origin = 6;
   */
  origin: string;

  /**
   * @generated from field: string original_value = 7;
   */
  originalValue: string;

  /**
   * @generated from field: string resolved_value = 8;
   */
  resolvedValue: string;

  /**
   * @generated from field: string create_time = 9;
   */
  createTime: string;

  /**
   * @generated from field: string update_time = 10;
   */
  updateTime: string;

  /**
   * @generated from field: repeated runme.runner.v2.MonitorEnvStoreResponseSnapshot.Error errors = 11;
   */
  errors: MonitorEnvStoreResponseSnapshot_Error[];
};

/**
 * @generated from message runme.runner.v2.MonitorEnvStoreResponseSnapshot.SnapshotEnv
 */
export declare type MonitorEnvStoreResponseSnapshot_SnapshotEnvJson = {
  /**
   * @generated from field: runme.runner.v2.MonitorEnvStoreResponseSnapshot.Status status = 1;
   */
  status?: MonitorEnvStoreResponseSnapshot_StatusJson;

  /**
   * @generated from field: string name = 2;
   */
  name?: string;

  /**
   * @generated from field: string description = 3;
   */
  description?: string;

  /**
   * @generated from field: string spec = 4;
   */
  spec?: string;

  /**
   * @generated from field: bool is_required = 5;
   */
  isRequired?: boolean;

  /**
   * @generated from field: string origin = 6;
   */
  origin?: string;

  /**
   * @generated from field: string original_value = 7;
   */
  originalValue?: string;

  /**
   * @generated from field: string resolved_value = 8;
   */
  resolvedValue?: string;

  /**
   * @generated from field: string create_time = 9;
   */
  createTime?: string;

  /**
   * @generated from field: string update_time = 10;
   */
  updateTime?: string;

  /**
   * @generated from field: repeated runme.runner.v2.MonitorEnvStoreResponseSnapshot.Error errors = 11;
   */
  errors?: MonitorEnvStoreResponseSnapshot_ErrorJson[];
};

/**
 * Describes the message runme.runner.v2.MonitorEnvStoreResponseSnapshot.SnapshotEnv.
 * Use `create(MonitorEnvStoreResponseSnapshot_SnapshotEnvSchema)` to create a new message.
 */
export declare const MonitorEnvStoreResponseSnapshot_SnapshotEnvSchema: GenMessage<MonitorEnvStoreResponseSnapshot_SnapshotEnv, {jsonType: MonitorEnvStoreResponseSnapshot_SnapshotEnvJson}>;

/**
 * @generated from message runme.runner.v2.MonitorEnvStoreResponseSnapshot.Error
 */
export declare type MonitorEnvStoreResponseSnapshot_Error = Message<"runme.runner.v2.MonitorEnvStoreResponseSnapshot.Error"> & {
  /**
   * @generated from field: uint32 code = 1;
   */
  code: number;

  /**
   * @generated from field: string message = 2;
   */
  message: string;
};

/**
 * @generated from message runme.runner.v2.MonitorEnvStoreResponseSnapshot.Error
 */
export declare type MonitorEnvStoreResponseSnapshot_ErrorJson = {
  /**
   * @generated from field: uint32 code = 1;
   */
  code?: number;

  /**
   * @generated from field: string message = 2;
   */
  message?: string;
};

/**
 * Describes the message runme.runner.v2.MonitorEnvStoreResponseSnapshot.Error.
 * Use `create(MonitorEnvStoreResponseSnapshot_ErrorSchema)` to create a new message.
 */
export declare const MonitorEnvStoreResponseSnapshot_ErrorSchema: GenMessage<MonitorEnvStoreResponseSnapshot_Error, {jsonType: MonitorEnvStoreResponseSnapshot_ErrorJson}>;

/**
 * @generated from enum runme.runner.v2.MonitorEnvStoreResponseSnapshot.Status
 */
export enum MonitorEnvStoreResponseSnapshot_Status {
  /**
   * @generated from enum value: STATUS_UNSPECIFIED = 0;
   */
  UNSPECIFIED = 0,

  /**
   * @generated from enum value: STATUS_LITERAL = 1;
   */
  LITERAL = 1,

  /**
   * @generated from enum value: STATUS_HIDDEN = 2;
   */
  HIDDEN = 2,

  /**
   * @generated from enum value: STATUS_MASKED = 3;
   */
  MASKED = 3,
}

/**
 * @generated from enum runme.runner.v2.MonitorEnvStoreResponseSnapshot.Status
 */
export declare type MonitorEnvStoreResponseSnapshot_StatusJson = "STATUS_UNSPECIFIED" | "STATUS_LITERAL" | "STATUS_HIDDEN" | "STATUS_MASKED";

/**
 * Describes the enum runme.runner.v2.MonitorEnvStoreResponseSnapshot.Status.
 */
export declare const MonitorEnvStoreResponseSnapshot_StatusSchema: GenEnum<MonitorEnvStoreResponseSnapshot_Status, MonitorEnvStoreResponseSnapshot_StatusJson>;

/**
 * @generated from message runme.runner.v2.MonitorEnvStoreResponse
 */
export declare type MonitorEnvStoreResponse = Message<"runme.runner.v2.MonitorEnvStoreResponse"> & {
  /**
   * @generated from field: runme.runner.v2.MonitorEnvStoreType type = 1;
   */
  type: MonitorEnvStoreType;

  /**
   * @generated from oneof runme.runner.v2.MonitorEnvStoreResponse.data
   */
  data: {
    /**
     * @generated from field: runme.runner.v2.MonitorEnvStoreResponseSnapshot snapshot = 2;
     */
    value: MonitorEnvStoreResponseSnapshot;
    case: "snapshot";
  } | { case: undefined; value?: undefined };
};

/**
 * @generated from message runme.runner.v2.MonitorEnvStoreResponse
 */
export declare type MonitorEnvStoreResponseJson = {
  /**
   * @generated from field: runme.runner.v2.MonitorEnvStoreType type = 1;
   */
  type?: MonitorEnvStoreTypeJson;

  /**
   * @generated from field: runme.runner.v2.MonitorEnvStoreResponseSnapshot snapshot = 2;
   */
  snapshot?: MonitorEnvStoreResponseSnapshotJson;
};

/**
 * Describes the message runme.runner.v2.MonitorEnvStoreResponse.
 * Use `create(MonitorEnvStoreResponseSchema)` to create a new message.
 */
export declare const MonitorEnvStoreResponseSchema: GenMessage<MonitorEnvStoreResponse, {jsonType: MonitorEnvStoreResponseJson}>;

/**
 * env store implementation
 *
 * @generated from enum runme.runner.v2.SessionEnvStoreType
 */
export enum SessionEnvStoreType {
  /**
   * uses default env store
   *
   * @generated from enum value: SESSION_ENV_STORE_TYPE_UNSPECIFIED = 0;
   */
  UNSPECIFIED = 0,

  /**
   * uses owl store
   *
   * @generated from enum value: SESSION_ENV_STORE_TYPE_OWL = 1;
   */
  OWL = 1,
}

/**
 * env store implementation
 *
 * @generated from enum runme.runner.v2.SessionEnvStoreType
 */
export declare type SessionEnvStoreTypeJson = "SESSION_ENV_STORE_TYPE_UNSPECIFIED" | "SESSION_ENV_STORE_TYPE_OWL";

/**
 * Describes the enum runme.runner.v2.SessionEnvStoreType.
 */
export declare const SessionEnvStoreTypeSchema: GenEnum<SessionEnvStoreType, SessionEnvStoreTypeJson>;

/**
 * @generated from enum runme.runner.v2.ExecuteStop
 */
export enum ExecuteStop {
  /**
   * @generated from enum value: EXECUTE_STOP_UNSPECIFIED = 0;
   */
  UNSPECIFIED = 0,

  /**
   * @generated from enum value: EXECUTE_STOP_INTERRUPT = 1;
   */
  INTERRUPT = 1,

  /**
   * @generated from enum value: EXECUTE_STOP_KILL = 2;
   */
  KILL = 2,
}

/**
 * @generated from enum runme.runner.v2.ExecuteStop
 */
export declare type ExecuteStopJson = "EXECUTE_STOP_UNSPECIFIED" | "EXECUTE_STOP_INTERRUPT" | "EXECUTE_STOP_KILL";

/**
 * Describes the enum runme.runner.v2.ExecuteStop.
 */
export declare const ExecuteStopSchema: GenEnum<ExecuteStop, ExecuteStopJson>;

/**
 * SessionStrategy determines a session selection in
 * an initial execute request.
 *
 * @generated from enum runme.runner.v2.SessionStrategy
 */
export enum SessionStrategy {
  /**
   * Uses the session_id field to determine the session.
   * If none is present, a new session is created.
   *
   * @generated from enum value: SESSION_STRATEGY_UNSPECIFIED = 0;
   */
  UNSPECIFIED = 0,

  /**
   * Uses the most recent session on the server.
   * If there is none, a new one is created.
   *
   * @generated from enum value: SESSION_STRATEGY_MOST_RECENT = 1;
   */
  MOST_RECENT = 1,
}

/**
 * SessionStrategy determines a session selection in
 * an initial execute request.
 *
 * @generated from enum runme.runner.v2.SessionStrategy
 */
export declare type SessionStrategyJson = "SESSION_STRATEGY_UNSPECIFIED" | "SESSION_STRATEGY_MOST_RECENT";

/**
 * Describes the enum runme.runner.v2.SessionStrategy.
 */
export declare const SessionStrategySchema: GenEnum<SessionStrategy, SessionStrategyJson>;

/**
 * @generated from enum runme.runner.v2.MonitorEnvStoreType
 */
export enum MonitorEnvStoreType {
  /**
   * @generated from enum value: MONITOR_ENV_STORE_TYPE_UNSPECIFIED = 0;
   */
  UNSPECIFIED = 0,

  /**
   * possible expansion to have a "timeline" view
   * MONITOR_ENV_STORE_TYPE_TIMELINE = 2;
   *
   * @generated from enum value: MONITOR_ENV_STORE_TYPE_SNAPSHOT = 1;
   */
  SNAPSHOT = 1,
}

/**
 * @generated from enum runme.runner.v2.MonitorEnvStoreType
 */
export declare type MonitorEnvStoreTypeJson = "MONITOR_ENV_STORE_TYPE_UNSPECIFIED" | "MONITOR_ENV_STORE_TYPE_SNAPSHOT";

/**
 * Describes the enum runme.runner.v2.MonitorEnvStoreType.
 */
export declare const MonitorEnvStoreTypeSchema: GenEnum<MonitorEnvStoreType, MonitorEnvStoreTypeJson>;

/**
 * @generated from service runme.runner.v2.RunnerService
 */
export declare const RunnerService: GenService<{
  /**
   * @generated from rpc runme.runner.v2.RunnerService.CreateSession
   */
  createSession: {
    methodKind: "unary";
    input: typeof CreateSessionRequestSchema;
    output: typeof CreateSessionResponseSchema;
  },
  /**
   * @generated from rpc runme.runner.v2.RunnerService.GetSession
   */
  getSession: {
    methodKind: "unary";
    input: typeof GetSessionRequestSchema;
    output: typeof GetSessionResponseSchema;
  },
  /**
   * @generated from rpc runme.runner.v2.RunnerService.ListSessions
   */
  listSessions: {
    methodKind: "unary";
    input: typeof ListSessionsRequestSchema;
    output: typeof ListSessionsResponseSchema;
  },
  /**
   * @generated from rpc runme.runner.v2.RunnerService.UpdateSession
   */
  updateSession: {
    methodKind: "unary";
    input: typeof UpdateSessionRequestSchema;
    output: typeof UpdateSessionResponseSchema;
  },
  /**
   * @generated from rpc runme.runner.v2.RunnerService.DeleteSession
   */
  deleteSession: {
    methodKind: "unary";
    input: typeof DeleteSessionRequestSchema;
    output: typeof DeleteSessionResponseSchema;
  },
  /**
   * @generated from rpc runme.runner.v2.RunnerService.MonitorEnvStore
   */
  monitorEnvStore: {
    methodKind: "server_streaming";
    input: typeof MonitorEnvStoreRequestSchema;
    output: typeof MonitorEnvStoreResponseSchema;
  },
  /**
   * Execute executes a program. Examine "ExecuteRequest" to explore
   * configuration options.
   *
   * It's a bidirectional stream RPC method. It expects the first
   * "ExecuteRequest" to contain details of a program to execute.
   * Subsequent "ExecuteRequest" should only contain "input_data" as
   * other fields will be ignored.
   *
   * @generated from rpc runme.runner.v2.RunnerService.Execute
   */
  execute: {
    methodKind: "bidi_streaming";
    input: typeof ExecuteRequestSchema;
    output: typeof ExecuteResponseSchema;
  },
  /**
   * ResolveProgram resolves variables from a script or a list of commands
   * using the provided sources, which can be a list of environment variables,
   * a session, or a project.
   * For now, the resolved variables are only the exported ones using `export`.
   *
   * @generated from rpc runme.runner.v2.RunnerService.ResolveProgram
   */
  resolveProgram: {
    methodKind: "unary";
    input: typeof ResolveProgramRequestSchema;
    output: typeof ResolveProgramResponseSchema;
  },
}>;
