---
title: "DOI"
description: "Rclone docs for DOI"
versionIntroduced: "v1.70"
---

# {{< icon "fa fa-building-columns" >}} DOI

The DOI remote is a read only remote for reading files from digital object
identifiers (DOI).

Currently, the DOI backend supports DOIs hosted with:

- [InvenioRDM](https://inveniosoftware.org/products/rdm/)
  - [Zenodo](https://zenodo.org)
  - [CaltechDATA](https://data.caltech.edu)
  - [Other InvenioRDM repositories](https://inveniosoftware.org/showcase/)
- [Dataverse](https://dataverse.org)
  - [Harvard Dataverse](https://dataverse.harvard.edu)
  - [Other Dataverse repositories](https://dataverse.org/installations)

Paths are specified as `remote:path`

Paths may be as deep as required, e.g. `remote:directory/subdirectory`.

## Configuration

Here is an example of how to make a remote called `remote`.  First run:

```console
rclone config
```

This will guide you through an interactive setup process:

```text
No remotes found, make a new one?
n) New remote
s) Set configuration password
q) Quit config
n/s/q> n
Enter name for new remote.
name> remote
Type of storage to configure.
Choose a number from below, or type in your own value
[snip]
XX / DOI datasets
   \ (doi)
[snip]
Storage> doi
Option doi.
The DOI or the doi.org URL.
Enter a value.
doi> 10.5281/zenodo.5876941
Edit advanced config?
y) Yes
n) No (default)
y/n> n
Configuration complete.
Options:
- type: doi
- doi: 10.5281/zenodo.5876941
Keep this "remote" remote?
y) Yes this is OK (default)
e) Edit this remote
d) Delete this remote
y/e/d> y
```

<!-- autogenerated options start - DO NOT EDIT - instead edit fs.RegInfo in backend/doi/doi.go and run make backenddocs to verify --> <!-- markdownlint-disable-line line-length -->
### Standard options

Here are the Standard options specific to doi (DOI datasets).

#### --doi-doi

The DOI or the doi.org URL.

Properties:

- Config:      doi
- Env Var:     RCLONE_DOI_DOI
- Type:        string
- Required:    true

### Advanced options

Here are the Advanced options specific to doi (DOI datasets).

#### --doi-provider

DOI provider.

The DOI provider can be set when rclone does not automatically recognize a supported DOI provider.

Properties:

- Config:      provider
- Env Var:     RCLONE_DOI_PROVIDER
- Type:        string
- Required:    false
- Examples:
  - "auto"
    - Auto-detect provider
  - "zenodo"
    - Zenodo
  - "dataverse"
    - Dataverse
  - "invenio"
    - Invenio

#### --doi-doi-resolver-api-url

The URL of the DOI resolver API to use.

The DOI resolver can be set for testing or for cases when the the canonical DOI resolver API cannot be used.

Defaults to "https://doi.org/api".

Properties:

- Config:      doi_resolver_api_url
- Env Var:     RCLONE_DOI_DOI_RESOLVER_API_URL
- Type:        string
- Required:    false

#### --doi-description

Description of the remote.

Properties:

- Config:      description
- Env Var:     RCLONE_DOI_DESCRIPTION
- Type:        string
- Required:    false

## Backend commands

Here are the commands specific to the doi backend.

Run them with:

```console
rclone backend COMMAND remote:
```

The help below will explain what arguments each command takes.

See the [backend](/commands/rclone_backend/) command for more
info on how to pass options and arguments.

These can be run on a running backend using the rc command
[backend/command](/rc/#backend-command).

### metadata

Show metadata about the DOI.

```console
rclone backend metadata remote: [options] [<arguments>+]
```

This command returns a JSON object with some information about the DOI.

Usage example:

```console
rclone backend metadata doi:
```

It returns a JSON object representing metadata about the DOI.

### set

Set command for updating the config parameters.

```console
rclone backend set remote: [options] [<arguments>+]
```

This set command can be used to update the config parameters
for a running doi backend.

Usage examples:

```console
rclone backend set doi: [-o opt_name=opt_value] [-o opt_name2=opt_value2]
rclone rc backend/command command=set fs=doi: [-o opt_name=opt_value] [-o opt_name2=opt_value2]
rclone rc backend/command command=set fs=doi: -o doi=NEW_DOI
```

The option keys are named as they are in the config file.

This rebuilds the connection to the doi backend when it is called with
the new parameters. Only new parameters need be passed as the values
will default to those currently in use.

It doesn't return anything.

<!-- autogenerated options stop -->
