package servicefabricmesh

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// ApplicationResourceStatus enumerates the values for application resource status.
type ApplicationResourceStatus string

const (
	// Creating ...
	Creating ApplicationResourceStatus = "Creating"
	// Deleting ...
	Deleting ApplicationResourceStatus = "Deleting"
	// Failed ...
	Failed ApplicationResourceStatus = "Failed"
	// Invalid ...
	Invalid ApplicationResourceStatus = "Invalid"
	// Ready ...
	Ready ApplicationResourceStatus = "Ready"
	// Upgrading ...
	Upgrading ApplicationResourceStatus = "Upgrading"
)

// PossibleApplicationResourceStatusValues returns an array of possible values for the ApplicationResourceStatus const type.
func PossibleApplicationResourceStatusValues() []ApplicationResourceStatus {
	return []ApplicationResourceStatus{Creating, Deleting, Failed, Invalid, Ready, Upgrading}
}

// DiagnosticsSinkKind enumerates the values for diagnostics sink kind.
type DiagnosticsSinkKind string

const (
	// DiagnosticsSinkKindAzureInternalMonitoringPipeline Diagnostics settings for Geneva.
	DiagnosticsSinkKindAzureInternalMonitoringPipeline DiagnosticsSinkKind = "AzureInternalMonitoringPipeline"
	// DiagnosticsSinkKindInvalid Indicates an invalid sink kind. All Service Fabric enumerations have the
	// invalid type.
	DiagnosticsSinkKindInvalid DiagnosticsSinkKind = "Invalid"
)

// PossibleDiagnosticsSinkKindValues returns an array of possible values for the DiagnosticsSinkKind const type.
func PossibleDiagnosticsSinkKindValues() []DiagnosticsSinkKind {
	return []DiagnosticsSinkKind{DiagnosticsSinkKindAzureInternalMonitoringPipeline, DiagnosticsSinkKindInvalid}
}

// HealthState enumerates the values for health state.
type HealthState string

const (
	// HealthStateError Indicates the health state is at an error level. Error health state should be
	// investigated, as they can impact the correct functionality of the cluster. The value is 3.
	HealthStateError HealthState = "Error"
	// HealthStateInvalid Indicates an invalid health state. All Service Fabric enumerations have the invalid
	// type. The value is zero.
	HealthStateInvalid HealthState = "Invalid"
	// HealthStateOk Indicates the health state is okay. The value is 1.
	HealthStateOk HealthState = "Ok"
	// HealthStateUnknown Indicates an unknown health status. The value is 65535.
	HealthStateUnknown HealthState = "Unknown"
	// HealthStateWarning Indicates the health state is at a warning level. The value is 2.
	HealthStateWarning HealthState = "Warning"
)

// PossibleHealthStateValues returns an array of possible values for the HealthState const type.
func PossibleHealthStateValues() []HealthState {
	return []HealthState{HealthStateError, HealthStateInvalid, HealthStateOk, HealthStateUnknown, HealthStateWarning}
}

// IngressQoSLevel enumerates the values for ingress qo s level.
type IngressQoSLevel string

const (
	// Bronze ...
	Bronze IngressQoSLevel = "Bronze"
)

// PossibleIngressQoSLevelValues returns an array of possible values for the IngressQoSLevel const type.
func PossibleIngressQoSLevelValues() []IngressQoSLevel {
	return []IngressQoSLevel{Bronze}
}

// Kind enumerates the values for kind.
type Kind string

const (
	// KindAzureInternalMonitoringPipeline ...
	KindAzureInternalMonitoringPipeline Kind = "AzureInternalMonitoringPipeline"
	// KindDiagnosticsSinkProperties ...
	KindDiagnosticsSinkProperties Kind = "DiagnosticsSinkProperties"
)

// PossibleKindValues returns an array of possible values for the Kind const type.
func PossibleKindValues() []Kind {
	return []Kind{KindAzureInternalMonitoringPipeline, KindDiagnosticsSinkProperties}
}

// OperatingSystemTypes enumerates the values for operating system types.
type OperatingSystemTypes string

const (
	// Linux ...
	Linux OperatingSystemTypes = "Linux"
	// Windows ...
	Windows OperatingSystemTypes = "Windows"
)

// PossibleOperatingSystemTypesValues returns an array of possible values for the OperatingSystemTypes const type.
func PossibleOperatingSystemTypesValues() []OperatingSystemTypes {
	return []OperatingSystemTypes{Linux, Windows}
}

// ServiceResourceStatus enumerates the values for service resource status.
type ServiceResourceStatus string

const (
	// ServiceResourceStatusActive ...
	ServiceResourceStatusActive ServiceResourceStatus = "Active"
	// ServiceResourceStatusCreating ...
	ServiceResourceStatusCreating ServiceResourceStatus = "Creating"
	// ServiceResourceStatusDeleting ...
	ServiceResourceStatusDeleting ServiceResourceStatus = "Deleting"
	// ServiceResourceStatusFailed ...
	ServiceResourceStatusFailed ServiceResourceStatus = "Failed"
	// ServiceResourceStatusUnknown ...
	ServiceResourceStatusUnknown ServiceResourceStatus = "Unknown"
	// ServiceResourceStatusUpgrading ...
	ServiceResourceStatusUpgrading ServiceResourceStatus = "Upgrading"
)

// PossibleServiceResourceStatusValues returns an array of possible values for the ServiceResourceStatus const type.
func PossibleServiceResourceStatusValues() []ServiceResourceStatus {
	return []ServiceResourceStatus{ServiceResourceStatusActive, ServiceResourceStatusCreating, ServiceResourceStatusDeleting, ServiceResourceStatusFailed, ServiceResourceStatusUnknown, ServiceResourceStatusUpgrading}
}
