package ecs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyDedicatedHostClusterAttribute invokes the ecs.ModifyDedicatedHostClusterAttribute API synchronously
func (client *Client) ModifyDedicatedHostClusterAttribute(request *ModifyDedicatedHostClusterAttributeRequest) (response *ModifyDedicatedHostClusterAttributeResponse, err error) {
	response = CreateModifyDedicatedHostClusterAttributeResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyDedicatedHostClusterAttributeWithChan invokes the ecs.ModifyDedicatedHostClusterAttribute API asynchronously
func (client *Client) ModifyDedicatedHostClusterAttributeWithChan(request *ModifyDedicatedHostClusterAttributeRequest) (<-chan *ModifyDedicatedHostClusterAttributeResponse, <-chan error) {
	responseChan := make(chan *ModifyDedicatedHostClusterAttributeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyDedicatedHostClusterAttribute(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyDedicatedHostClusterAttributeWithCallback invokes the ecs.ModifyDedicatedHostClusterAttribute API asynchronously
func (client *Client) ModifyDedicatedHostClusterAttributeWithCallback(request *ModifyDedicatedHostClusterAttributeRequest, callback func(response *ModifyDedicatedHostClusterAttributeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyDedicatedHostClusterAttributeResponse
		var err error
		defer close(result)
		response, err = client.ModifyDedicatedHostClusterAttribute(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyDedicatedHostClusterAttributeRequest is the request struct for api ModifyDedicatedHostClusterAttribute
type ModifyDedicatedHostClusterAttributeRequest struct {
	*requests.RpcRequest
	DedicatedHostClusterName string           `position:"Query" name:"DedicatedHostClusterName"`
	ResourceOwnerId          requests.Integer `position:"Query" name:"ResourceOwnerId"`
	Description              string           `position:"Query" name:"Description"`
	DedicatedHostClusterId   string           `position:"Query" name:"DedicatedHostClusterId"`
	ResourceOwnerAccount     string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount             string           `position:"Query" name:"OwnerAccount"`
	OwnerId                  requests.Integer `position:"Query" name:"OwnerId"`
}

// ModifyDedicatedHostClusterAttributeResponse is the response struct for api ModifyDedicatedHostClusterAttribute
type ModifyDedicatedHostClusterAttributeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyDedicatedHostClusterAttributeRequest creates a request to invoke ModifyDedicatedHostClusterAttribute API
func CreateModifyDedicatedHostClusterAttributeRequest() (request *ModifyDedicatedHostClusterAttributeRequest) {
	request = &ModifyDedicatedHostClusterAttributeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ecs", "2014-05-26", "ModifyDedicatedHostClusterAttribute", "ecs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyDedicatedHostClusterAttributeResponse creates a response to parse from ModifyDedicatedHostClusterAttribute response
func CreateModifyDedicatedHostClusterAttributeResponse() (response *ModifyDedicatedHostClusterAttributeResponse) {
	response = &ModifyDedicatedHostClusterAttributeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
