package qualitycheck

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RemoveAndGetTaskRules invokes the qualitycheck.RemoveAndGetTaskRules API synchronously
func (client *Client) RemoveAndGetTaskRules(request *RemoveAndGetTaskRulesRequest) (response *RemoveAndGetTaskRulesResponse, err error) {
	response = CreateRemoveAndGetTaskRulesResponse()
	err = client.DoAction(request, response)
	return
}

// RemoveAndGetTaskRulesWithChan invokes the qualitycheck.RemoveAndGetTaskRules API asynchronously
func (client *Client) RemoveAndGetTaskRulesWithChan(request *RemoveAndGetTaskRulesRequest) (<-chan *RemoveAndGetTaskRulesResponse, <-chan error) {
	responseChan := make(chan *RemoveAndGetTaskRulesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RemoveAndGetTaskRules(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RemoveAndGetTaskRulesWithCallback invokes the qualitycheck.RemoveAndGetTaskRules API asynchronously
func (client *Client) RemoveAndGetTaskRulesWithCallback(request *RemoveAndGetTaskRulesRequest, callback func(response *RemoveAndGetTaskRulesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RemoveAndGetTaskRulesResponse
		var err error
		defer close(result)
		response, err = client.RemoveAndGetTaskRules(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RemoveAndGetTaskRulesRequest is the request struct for api RemoveAndGetTaskRules
type RemoveAndGetTaskRulesRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	JsonStr         string           `position:"Query" name:"JsonStr"`
}

// RemoveAndGetTaskRulesResponse is the response struct for api RemoveAndGetTaskRules
type RemoveAndGetTaskRulesResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateRemoveAndGetTaskRulesRequest creates a request to invoke RemoveAndGetTaskRules API
func CreateRemoveAndGetTaskRulesRequest() (request *RemoveAndGetTaskRulesRequest) {
	request = &RemoveAndGetTaskRulesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Qualitycheck", "2019-01-15", "RemoveAndGetTaskRules", "", "")
	request.Method = requests.POST
	return
}

// CreateRemoveAndGetTaskRulesResponse creates a response to parse from RemoveAndGetTaskRules response
func CreateRemoveAndGetTaskRulesResponse() (response *RemoveAndGetTaskRulesResponse) {
	response = &RemoveAndGetTaskRulesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
