/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx.skins;

import com.dlsc.gemsfx.infocenter.InfoCenterPane;
import com.dlsc.gemsfx.infocenter.InfoCenterView;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.InvalidationListener;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import javafx.scene.shape.Rectangle;

public class InfoCenterPaneSkin
extends SkinBase<InfoCenterPane> {
    private DoubleProperty visibility = new SimpleDoubleProperty((Object)this, "visibility");
    private Timeline timeline = new Timeline();

    public InfoCenterPaneSkin(InfoCenterPane pane) {
        super((Control)pane);
        this.updateChildren();
        InvalidationListener rebuildListener = observable -> this.updateChildren();
        pane.contentProperty().addListener(rebuildListener);
        this.visibility.addListener(it -> pane.requestLayout());
        Rectangle clip = new Rectangle();
        clip.widthProperty().bind((ObservableValue)((InfoCenterPane)this.getSkinnable()).widthProperty());
        clip.heightProperty().bind((ObservableValue)((InfoCenterPane)this.getSkinnable()).heightProperty());
        ((InfoCenterPane)this.getSkinnable()).setClip((Node)clip);
        pane.showInfoCenterProperty().addListener(it -> {
            if (pane.isShowInfoCenter()) {
                this.show();
            } else {
                this.hide();
            }
        });
    }

    private void show() {
        this.timeline.stop();
        KeyValue keyValue = new KeyValue((WritableValue)this.visibility, (Object)1);
        KeyFrame keyFrame = new KeyFrame(((InfoCenterPane)this.getSkinnable()).getSlideInDuration(), new KeyValue[]{keyValue});
        this.timeline.getKeyFrames().setAll((Object[])new KeyFrame[]{keyFrame});
        this.timeline.play();
    }

    private void hide() {
        this.timeline.stop();
        KeyValue keyValues = new KeyValue((WritableValue)this.visibility, (Object)0);
        KeyFrame keyFrame = new KeyFrame(((InfoCenterPane)this.getSkinnable()).getSlideInDuration(), new KeyValue[]{keyValues});
        this.timeline.getKeyFrames().setAll((Object[])new KeyFrame[]{keyFrame});
        this.timeline.play();
    }

    private void updateChildren() {
        this.getChildren().clear();
        InfoCenterPane infoCenterPane = (InfoCenterPane)this.getSkinnable();
        if (infoCenterPane.getContent() != null) {
            this.getChildren().add((Object)infoCenterPane.getContent());
        }
        if (infoCenterPane.getInfoCenterView() != null) {
            this.getChildren().add((Object)infoCenterPane.getInfoCenterView());
        }
    }

    protected double computeMinWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        Node content = ((InfoCenterPane)this.getSkinnable()).getContent();
        if (content != null) {
            return content.minWidth(height) + leftInset + rightInset;
        }
        return 0.0;
    }

    protected double computePrefWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        Node content = ((InfoCenterPane)this.getSkinnable()).getContent();
        if (content != null) {
            return content.prefWidth(height) + leftInset + rightInset;
        }
        return 0.0;
    }

    protected double computeMaxWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        Node content = ((InfoCenterPane)this.getSkinnable()).getContent();
        if (content != null) {
            return content.maxWidth(height) + leftInset + rightInset;
        }
        return 0.0;
    }

    protected double computeMinHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        Node content = ((InfoCenterPane)this.getSkinnable()).getContent();
        if (content != null) {
            return content.minHeight(width) + leftInset + rightInset;
        }
        return 0.0;
    }

    protected double computePrefHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        Node content = ((InfoCenterPane)this.getSkinnable()).getContent();
        if (content != null) {
            return content.prefHeight(width) + leftInset + rightInset;
        }
        return 0.0;
    }

    protected double computeMaxHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        Node content = ((InfoCenterPane)this.getSkinnable()).getContent();
        if (content != null) {
            return content.maxHeight(width) + leftInset + rightInset;
        }
        return 0.0;
    }

    protected void layoutChildren(double contentX, double contentY, double contentWidth, double contentHeight) {
        InfoCenterView view;
        Node content = ((InfoCenterPane)this.getSkinnable()).getContent();
        if (content != null) {
            content.resizeRelocate(contentX, contentY, contentWidth, contentHeight);
        }
        if ((view = ((InfoCenterPane)this.getSkinnable()).getInfoCenterView()) != null) {
            double prefWidth = view.prefWidth(-1.0);
            double prefHeight = view.prefHeight(prefWidth);
            double v = this.visibility.get();
            double offset = prefWidth * v;
            if (view.getShowAllGroup() != null) {
                view.resizeRelocate(contentX + contentWidth - offset, contentY, prefWidth, contentHeight);
            } else {
                view.resizeRelocate(contentX + contentWidth - offset, contentY, prefWidth, Math.min(contentHeight, prefHeight));
            }
            view.setVisible(v > 0.0);
        }
    }
}

