/*
 * Decompiled with CFR 0.152.
 */
package org.javamodularity.moduleplugin.shadow.javaparser;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Predicate;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.Node;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.observer.Observable;

public interface HasParentNode<T>
extends Observable {
    default public boolean hasParentNode() {
        return this.getParentNode().isPresent();
    }

    public Optional<Node> getParentNode();

    public T setParentNode(Node var1);

    public Node getParentNodeForChildren();

    default public <N> Optional<N> findAncestor(Class<N> ... types) {
        return this.findAncestor((Predicate<Object> & Serializable)(N x) -> true, types);
    }

    @Deprecated
    default public <N> Optional<N> findAncestor(Class<N> type, Predicate<N> predicate) {
        return this.findAncestor(predicate, type);
    }

    default public <N> Optional<N> findAncestor(Predicate<N> predicate, Class<N> ... types) {
        if (!this.hasParentNode()) {
            return Optional.empty();
        }
        Node parent = this.getParentNode().get();
        Optional<Class<N>> oType = Arrays.stream(types).filter((Predicate<Class> & Serializable)type -> type.isAssignableFrom(parent.getClass()) && predicate.test(type.cast(parent))).findFirst();
        if (oType.isPresent()) {
            return Optional.of(oType.get().cast(parent));
        }
        return parent.findAncestor(predicate, types);
    }

    default public boolean isDescendantOf(Node ancestor) {
        return this.findAncestor((Predicate<Node> & Serializable)(N n) -> n == ancestor, Node.class).isPresent();
    }
}

