/*
 * Decompiled with CFR 0.152.
 */
package org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.javaparsermodel;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.UnsolvedSymbolException;

public class FailureHandler {
    private static final Map<Class<? extends Throwable>, Function<Throwable, ? extends RuntimeException>> FAILURE_CONVERTER = new HashMap<Class<? extends Throwable>, Function<Throwable, ? extends RuntimeException>>();

    public RuntimeException handle(Throwable th) {
        return this.handle(th, null);
    }

    public RuntimeException handle(Throwable th, String message) {
        Function<Throwable, ? extends RuntimeException> converter = FAILURE_CONVERTER.get(this.findRootCause(th).getClass());
        if (converter != null) {
            return converter.apply(th);
        }
        if (RuntimeException.class.isAssignableFrom(th.getClass())) {
            return (RuntimeException)th;
        }
        return this.getRuntimeExceptionFrom((Throwable)this.findRootCause(th), message);
    }

    protected final <E extends Throwable> E findRootCause(Throwable failure) {
        while (failure != null) {
            if (this.isRootCause(failure)) {
                return (E)failure;
            }
            failure = failure.getCause();
        }
        return null;
    }

    private boolean isRootCause(Throwable th) {
        return th.getCause() == null;
    }

    private RuntimeException getRuntimeExceptionFrom(Throwable th, String message) {
        if (message == null || message.isEmpty()) {
            return new RuntimeException((Throwable)this.findRootCause(th));
        }
        return new RuntimeException(message, (Throwable)this.findRootCause(th));
    }

    static {
        FAILURE_CONVERTER.put(UnsolvedSymbolException.class, (Function<Throwable, ? extends RuntimeException>)(Function<Throwable, RuntimeException> & Serializable)th -> (RuntimeException)th);
    }
}

