#pragma once

#include "codegenv2.h"

struct Instr_Def InstrTableV2[] = {

  /* | mnemonic | operand count | operand types | encoding group | flags | opcode len | opcode bytes | op size | modRM | sib | OSO | ASO | Valid segment modes | opnd direction | mandatory prefix type | immediate Operand? | memory Operand? | CPU mode | */

  /* No operand gp instructions */
  { "aaa",    0, { OP_N,     OP_N    }, GP1, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 1, { 0x37, 0x00, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
  { "aad",    0, { OP_N,     OP_N    }, GP1, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 2, { 0xd5, 0x0a, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
  { "aad",    1, { IMM8,     OP_N    }, GP1, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 1, { 0xd5, 0x00, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32), NO_DST, NO_PREFIX, IMM_OPND_0, NO_MEM, P_86, 0, NULL },
  { "aam",    0, { OP_N,     OP_N    }, GP1, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 2, { 0xd4, 0x0a, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
  { "aam",    1, { IMM8,     OP_N    }, GP1, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 1, { 0xd4, 0x00, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32), NO_DST, NO_PREFIX, IMM_OPND_0, NO_MEM, P_86, 0, NULL },
  { "aas",    0, { OP_N,     OP_N    }, GP1, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 1, { 0x3f, 0x00, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
  { "clc",    0, { OP_N,     OP_N    }, GP1, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 1, { 0xf8, 0x00, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
  { "cld",    0, { OP_N,     OP_N    }, GP1, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 1, { 0xfc, 0x00, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
  { "cli",    0, { OP_N,     OP_N    }, GP1, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 1, { 0xfa, 0x00, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
  { "clts",   0, { OP_N,     OP_N    }, GP1, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x06, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
  { "cmc",    0, { OP_N,     OP_N    }, GP1, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 1, { 0xf5, 0x00, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
  { "cpuid",  0, { OP_N,     OP_N    }, GP1, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0xa2, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
  { "popa",   0, { OP_N,     OP_N    }, GP1, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 1, { 0x61, 0x00, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
  { "popad",  0, { OP_N,     OP_N    }, GP1, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 1, { 0x61, 0x00, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
  { "popaw",  0, { OP_N,     OP_N    }, GP1, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 1, { 0x61, 0x00, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
  { "popfd",  0, { OP_N,     OP_N    }, GP1, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 1, { 0x9d, 0x00, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
  { "pushd",  1, { R32_EAX,          }, GP4,  (F_OPCODE_REG),									               NO_VEX, NO_EVEX, 1, 1, { 0x50, 0x00, 0x00 }, 4,  0, NO_MOD,      0, 0, 0,                        (X16 | X32), REG_DST,  NO_PREFIX,  NO_IMM,      NO_MEM,     P_86,  0, NULL },
  { "pushd",  1, { R32,              }, GP4,  (F_OPCODE_REG),									               NO_VEX, NO_EVEX, 1, 1, { 0x50, 0x00, 0x00 }, 4,  0, NO_MOD,      0, 0, 0,                        (X16 | X32), REG_DST,  NO_PREFIX,  NO_IMM,      NO_MEM,     P_86,  0, NULL },
  { "pushd",  1, { R_SEG,            }, GP4,  (F_OPCODE_REG),							                   NO_VEX, NO_EVEX, 1, 1, { 0x06, 0x00, 0x00 }, 1,  0, NO_MOD,      0, 0, 0,                        (X16 | X32), REG_DST,  NO_PREFIX,  NO_IMM,      NO_MEM,     P_86,  0, NULL },
  { "pushd",  1, { M32,              }, GP4,   ALLOW_SEG,                                    NO_VEX, NO_EVEX, 1, 1, { 0xff, 0x00, 0x00 }, 4,  0, 0x30, 0, 0, ADDR_SIZE_OVERRIDE,              (X16 | X32), RM_DST,   NO_PREFIX,  NO_IMM,      MEM_OPND_0, P_86,  0, NULL },
  { "pushd",  1, { M_ANY,            }, GP4,   ALLOW_SEG,                                    NO_VEX, NO_EVEX, 1, 1, { 0xff, 0x00, 0x00 }, 4,  0, 0x30, 0, 0, ADDR_SIZE_OVERRIDE,              (X16 | X32), RM_DST,   NO_PREFIX,  NO_IMM,      MEM_OPND_0, P_86,  0, NULL },
  { "pushd",  1, { R16_AX,           }, GP4,  (F_OPCODE_REG),									               NO_VEX, NO_EVEX, 1, 1, { 0x50, 0x00, 0x00 }, 2,  0, NO_MOD,      0, OP_SIZE_OVERRIDE, 0,         (X16 | X32), REG_DST,  NO_PREFIX,  NO_IMM,      NO_MEM,     P_86,  0, NULL },
  { "pushd",  1, { R16,              }, GP4,  (F_OPCODE_REG),									               NO_VEX, NO_EVEX, 1, 1, { 0x50, 0x00, 0x00 }, 2,  0, NO_MOD,      0, OP_SIZE_OVERRIDE, 0,         (X16 | X32), REG_DST,  NO_PREFIX,  NO_IMM,      NO_MEM,     P_86,  0, NULL },
  { "pushd",  1, { M16,              }, GP4,   ALLOW_SEG,                                    NO_VEX, NO_EVEX, 1, 1, { 0xff, 0x00, 0x00 }, 2,  0, 0x30,        0, OP_SIZE_OVERRIDE, 0,         (X16 | X32), RM_DST,   NO_PREFIX,  NO_IMM,      MEM_OPND_0, P_486, 0, NULL },
  { "pushd",  1, { M_ANY,            }, GP4,   ALLOW_SEG,                                    NO_VEX, NO_EVEX, 1, 1, { 0xff, 0x00, 0x00 }, 8,  0, 0x30,        0, 0, ADDR_SIZE_OVERRIDE,       (X16 | X32), RM_DST,   NO_PREFIX,  NO_IMM,      MEM_OPND_0, P_64,  0, NULL },
  { "pushd",  1, { IMM8,             }, GP4,  0,		                                         NO_VEX, NO_EVEX, 1, 1, { 0x6a, 0x00, 0x00 }, 1,  0, MOD_MEM_IMM, 0, 0, 0,                        (X16 | X32), NO_DST,   NO_PREFIX, IMM_OPND_0,   NO_MEM,     P_86,  0, NULL },
  { "pushd",  1, { IMM32,            }, GP4,  0,		                                         NO_VEX, NO_EVEX, 1, 1, { 0x68, 0x00, 0x00 }, 4,  0, MOD_MEM_IMM, 0, 0, 0,                              (X32), NO_DST,   NO_PREFIX, IMM_OPND_0,   NO_MEM,     P_386, 0, NULL },
  { "pusha",  0, { OP_N,     OP_N    }, GP1, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 1, { 0x60, 0x00, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
  { "pushad", 0, { OP_N,     OP_N    }, GP1, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 1, { 0x60, 0x00, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
  { "pushaw", 0, { OP_N,     OP_N    }, GP1, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 1, { 0x60, 0x00, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
  { "pushfd", 0, { OP_N,     OP_N    }, GP1, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 1, { 0x9c, 0x00, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
  { "daa",    0, { OP_N,     OP_N    }, GP1, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 1, { 0x27, 0x00, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
  { "das",    0, { OP_N,     OP_N    }, GP1, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 1, { 0x2f, 0x00, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
  { "hlt",    0, { OP_N,     OP_N    }, GP1, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 1, { 0xf4, 0x00, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
  { "invd",   0, { OP_N,     OP_N    }, GP1, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x08, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
  { "lahf",   0, { OP_N,     OP_N    }, GP1, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 1, { 0x9f, 0x00, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
  { "leave",  0, { OP_N,     OP_N    }, GP1, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 1, { 0xc9, 0x00, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
  { "stc",    0, { OP_N,     OP_N    }, GP1, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 1, { 0xf9, 0x00, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
  { "std",    0, { OP_N,     OP_N    }, GP1, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 1, { 0xfd, 0x00, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
  { "sti",    0, { OP_N,     OP_N    }, GP1, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 1, { 0xfb, 0x00, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
  //CBW, CWDE, 98 REX.W + 98 CDQE
  { "cbw",    0, { OP_N,     OP_N    }, GP1, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 1, { 0x98, 0x00, 0x00 }, 2, 0, NO_MOD,      0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
  { "cwd",    0, { OP_N,     OP_N    }, GP1, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 1, { 0x99, 0x00, 0x00 }, 2, 0, NO_MOD,      0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
  { "cdq",    0, { OP_N,     OP_N    }, GP1, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 1, { 0x99, 0x00, 0x00 }, 4, 0, NO_MOD,      0, 0,                0,                  (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
  { "cwde",   0, { OP_N,     OP_N    }, GP1, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 1, { 0x98, 0x00, 0x00 }, 4, 0, NO_MOD,      0, 0,                0,                  (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
  { "cdqe",   0, { OP_N,     OP_N    }, GP1, (REX | REXW),														NO_VEX, NO_EVEX, 1, 1, { 0x98, 0x00, 0x00 }, 8, 0, NO_MOD,      0, 0,                0,                              (X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_64, 0, NULL },

  //CLAC NP 0F 01 CA vmload
  { "clac",   0, { OP_N,     OP_N    }, GP0, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 2, { 0x01, 0xca, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32 | X64), NO_DST, PFX_0xF, NO_IMM, NO_MEM, P_86, 0, NULL },
  { "clts",   0, { OP_N,     OP_N    }, GP0, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x06, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32 | X64), NO_DST, PFX_0xF, NO_IMM, NO_MEM, P_86, 0, NULL },
  { "into",   0, { OP_N,     OP_N    }, GP1, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 1, { 0xce, 0x00, 0x00 }, 4, 0, NO_MOD,      0, 0,                0,                  (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
  { "iret",   0, { OP_N,     OP_N    }, GP1, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 1, { 0xcf, 0x00, 0x00 }, 4, 0, NO_MOD,      0, 0,                0,                  (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
  { "iretd",  0, { OP_N,     OP_N    }, GP1, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 1, { 0xcf, 0x00, 0x00 }, 4, 0, NO_MOD,      0, 0,                0,                  (X16 | X32), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_386, 0, NULL },
  { "iretf",  0, { OP_N,     OP_N    }, GP1, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 1, { 0xcf, 0x00, 0x00 }, 4, 0, NO_MOD,      0, 0,                0,                  (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
  { "iretdf", 0, { OP_N,     OP_N    }, GP1, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 1, { 0xcf, 0x00, 0x00 }, 4, 0, NO_MOD,      0, 0,                0,                  (X16 | X32), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_386, 0, NULL },
  { "nop",    0, { OP_N,     OP_N    }, GP0, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 1, { 0x90, 0x00, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
  { "rdmsr",  0, { OP_N,     OP_N    }, GP1, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 1, { 0x32, 0x00, 0x00 }, 4, 0, NO_MOD,      0, 0,                0,                  (X16 | X32 | X64), NO_DST, PFX_0xF, NO_IMM, NO_MEM, P_586, 0, NULL },
  { "rdpmc",  0, { OP_N,     OP_N    }, GP1, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 1, { 0x33, 0x00, 0x00 }, 4, 0, NO_MOD,      0, 0,                0,                  (X16 | X32 | X64), NO_DST, PFX_0xF, NO_IMM, NO_MEM, P_586, 0, NULL },
  { "rdtsc",  0, { OP_N,     OP_N    }, GP1, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 1, { 0x31, 0x00, 0x00 }, 4, 0, NO_MOD,      0, 0,                0,                  (X16 | X32 | X64), NO_DST, PFX_0xF, NO_IMM, NO_MEM, P_586, 0, NULL },
  { "rdtscp", 0, { OP_N,     OP_N    }, GP1, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 2, { 0x01, 0xf9, 0x00 }, 4, 0, NO_MOD,      0, 0,                0,                  (X16 | X32 | X64), NO_DST, PFX_0xF, NO_IMM, NO_MEM, P_686, 0, NULL },
 
  { "wait",   0, { OP_N,     OP_N    }, GP0, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 2, { 0x9b, 0x00, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86,  0, NULL },
  { "ud2",    0, { OP_N,     OP_N    }, GP2, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 2, { 0x0b, 0x00, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32 | X64), NO_DST, PFX_0xF,   NO_IMM, NO_MEM, P_686, 0, NULL },
  { "wbinvd", 0, { OP_N,     OP_N    }, GP2, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 1, { 0x09, 0x00, 0x00 }, 4, 0, NO_MOD,      0, 0,                0,                  (X16 | X32 | X64), NO_DST, PFX_0xF,   NO_IMM, NO_MEM, P_486, 0, NULL },
  { "wrmsr",  0, { OP_N,     OP_N    }, GP2, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 1, { 0x30, 0x00, 0x00 }, 4, 0, NO_MOD,      0, 0,                0,                  (X16 | X32 | X64), NO_DST, PFX_0xF,   NO_IMM, NO_MEM, P_586, 0, NULL },
  //14 ib ADC AL, imm8
  { "adc",    2, { R8_AL,    IMM8    }, GP0, (F_OPCODE_REG),												                                  NO_VEX, NO_EVEX, 1, 1, { 0x14, 0x00, 0x00 }, 1, 0, NO_MOD,      0, 0,				         0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
  //15 iw ADC AX, imm16 I Valid Valid ADC imm16 to AX.
  //15 id ADC EAX, imm32 I Valid Valid ADC imm32 to EAX.
  //REX.W + 15 id ADC RAX, imm32 I Valid N.E.ADC imm32 sign extended to 64 - bits to RAX.
  { "adc",    2, { R16_AX,   IMM16   }, GP0, (F_OPCODE_REG),												                                  NO_VEX, NO_EVEX, 1, 1, { 0x15, 0x00, 0x00 }, 2, 0, NO_MOD,      0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
  { "adc",    2, { R32_EAX,  IMM32   }, GP0, (F_OPCODE_REG),												                                  NO_VEX, NO_EVEX, 1, 1, { 0x15, 0x00, 0x00 }, 4, 0, NO_MOD,      0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
  { "adc",    2, { R64_RAX,  IMM32   }, GP3, (REX | REXW) | (F_OPCODE_REG),						                                NO_VEX, NO_EVEX, 1, 1, { 0x15, 0x00, 0x00 }, 4, 0, NO_MOD,      0, 0,				         0,                              (X64), NO_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
  //80 / 2 ib ADC r / m8, imm8 MI Valid Valid ADC imm8 to r / m8.
  //REX + 80 / 2 ib ADC r / m8 * , imm8 MI Valid N.E.ADC imm8 to r / m8.
  { "adc",    2, { R8,       IMM8    }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),		                      NO_VEX, NO_EVEX, 1, 1, { 0x80, 0x02, 0x00 }, 1, 0, MOD_REG_IMM, 0, 0,	               0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
  { "adc",    2, { R8H,      IMM8    }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	                        NO_VEX, NO_EVEX, 1, 1, { 0x80, 0x02, 0x00 }, 1, 0, MOD_REG_IMM, 0, 0,	               0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
  { "adc",    2, { R8U,      IMM8    }, GP3, REX | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),									  NO_VEX, NO_EVEX, 1, 1, { 0x80, 0x02, 0x00 }, 1, 0, MOD_REG_IMM, 0, 0,				         0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
  { "adc",    2, { R8E,      IMM8    }, GP3, (REX | REXB) | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),				  NO_VEX, NO_EVEX, 1, 1, { 0x80, 0x02, 0x00 }, 1, 0, MOD_REG_IMM, 0, 0,				         0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
  { "adc",    2, { M8,       IMM8    }, GP0, ALLOW_SEG | (F_MODRM | OPCODE_EXT | IMM8_ONLY),									        NO_VEX, NO_EVEX, 1, 1, { 0x80, 0x02, 0x00 }, 1, 0, MOD_MEM_IMM, 0, 0,	               ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0,P_86,  0, NULL },
  //81 / 2 iw ADC r / m16, imm16
  //81 / 2 id ADC r / m32, imm32
  //REX.W + 81 / 2 id ADC r / m64, imm32
{ "adc",    2, { R16,      IMM16   }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT),		                                  NO_VEX, NO_EVEX, 1, 1, { 0x81, 0x02, 0x00 }, 2, 0, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "adc",    2, { R16E,     IMM16   }, GP3, (REX | REXB) | (F_MODRM_RM | F_MODRM | OPCODE_EXT),								      NO_VEX, NO_EVEX, 1, 1, { 0x81, 0x02, 0x00 }, 2, 0, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
{ "adc",    2, { M16,      IMM16   }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT),		                                  NO_VEX, NO_EVEX, 1, 1, { 0x81, 0x02, 0x00 }, 2, 0, MOD_MEM_IMM, 0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0, P_86,  0, NULL },
{ "adc",    2, { R32,      IMM32   }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT),		                                  NO_VEX, NO_EVEX, 1, 1, { 0x81, 0x02, 0x00 }, 4, 0, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "adc",    2, { R32E,     IMM32   }, GP3, (REX | REXB) | (F_MODRM_RM | F_MODRM | OPCODE_EXT),								      NO_VEX, NO_EVEX, 1, 1, { 0x81, 0x02, 0x00 }, 4, 0, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
{ "adc",    2, { R32,      IMM16   }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT),		                                  NO_VEX, NO_EVEX, 1, 1, { 0x81, 0x02, 0x00 }, 4, 0, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "adc",    2, { R32E,     IMM16   }, GP3, (REX | REXB) | (F_MODRM_RM | F_MODRM | OPCODE_EXT),								      NO_VEX, NO_EVEX, 1, 1, { 0x81, 0x02, 0x00 }, 4, 0, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
{ "adc",    2, { M32,      IMM32   }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT),		                                  NO_VEX, NO_EVEX, 1, 1, { 0x81, 0x02, 0x00 }, 4, 0, MOD_MEM_IMM, 0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0, P_86,  0, NULL },
{ "adc",    2, { R64,      IMM32   }, GP3, (REX | REXW) | (F_MODRM_RM | F_MODRM | OPCODE_EXT),                      NO_VEX, NO_EVEX, 1, 1, { 0x81, 0x02, 0x00 }, 4, 0, MOD_REG_IMM, 0, 0,	               0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
{ "adc",    2, { R64,      IMM16   }, GP3, (REX | REXW) | (F_MODRM_RM | F_MODRM | OPCODE_EXT),                      NO_VEX, NO_EVEX, 1, 1, { 0x81, 0x02, 0x00 }, 4, 0, MOD_REG_IMM, 0, 0,	               0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
{ "adc",    2, { R64E,     IMM32   }, GP3, (REX | REXW | REXB) | (F_MODRM_RM | F_MODRM | OPCODE_EXT),               NO_VEX, NO_EVEX, 1, 1, { 0x81, 0x02, 0x00 }, 4, 0, MOD_REG_IMM, 0, 0,	               0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
{ "adc",    2, { R64E,     IMM16   }, GP3, (REX | REXW | REXB) | (F_MODRM_RM | F_MODRM | OPCODE_EXT),               NO_VEX, NO_EVEX, 1, 1, { 0x81, 0x02, 0x00 }, 4, 0, MOD_REG_IMM, 0, 0,	               0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
{ "adc",    2, { M64,      IMM32   }, GP3, REXW | (F_MODRM_RM | F_MODRM | OPCODE_EXT),		                          NO_VEX, NO_EVEX, 1, 1, { 0x81, 0x02, 0x00 }, 4, 0, MOD_MEM_IMM, 0, 0,	               0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0, P_64,  0, NULL },
//83 / 2 ib ADC r / m16, imm8
//83 / 2 ib ADC r / m32, imm8
//REX.W + 83 / 2 ib ADC r / m64, imm8
{ "adc",    2, { R16,      IMM8    }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	                        NO_VEX, NO_EVEX, 1, 1, { 0x83, 0x02, 0x00 }, 2, 0, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "adc",    2, { R16E,     IMM8    }, GP3, (REX | REXB) | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	        NO_VEX, NO_EVEX, 1, 1, { 0x83, 0x02, 0x00 }, 2, 0, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "adc",    2, { M16,      IMM8    }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	                        NO_VEX, NO_EVEX, 1, 1, { 0x83, 0x02, 0x00 }, 2, 0, MOD_MEM_IMM, 0, OP_SIZE_OVERRIDE, ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0, P_86,  0, NULL },
{ "adc",    2, { R32,      IMM8    }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	                        NO_VEX, NO_EVEX, 1, 1, { 0x83, 0x02, 0x00 }, 4, 0, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "adc",    2, { R32E,     IMM8    }, GP3, (REX | REXB) | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	        NO_VEX, NO_EVEX, 1, 1, { 0x83, 0x02, 0x00 }, 4, 0, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "adc",    2, { M32,      IMM8    }, GP0, ALLOW_SEG | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	            NO_VEX, NO_EVEX, 1, 1, { 0x83, 0x02, 0x00 }, 4, 0, MOD_MEM_IMM, 0, OP_SIZE_OVERRIDE, ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0, P_86,  0, NULL },
{ "adc",    2, { R64,      IMM8    }, GP3, (REX | REXW) | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),          NO_VEX, NO_EVEX, 1, 1, { 0x83, 0x02, 0x00 }, 4, 0, MOD_REG_IMM, 0, 0,	               0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
{ "adc",    2, { R64E,     IMM8    }, GP3, (REX | REXW | REXB) | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),   NO_VEX, NO_EVEX, 1, 1, { 0x83, 0x02, 0x00 }, 4, 0, MOD_REG_IMM, 0, 0,				         0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
{ "adc",    2, { M64,      IMM8    }, GP3, (REX | REXW) | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),		      NO_VEX, NO_EVEX, 1, 1, { 0x83, 0x02, 0x00 }, 4, 0, MOD_MEM_IMM, 0, 0,ADDR_SIZE_OVERRIDE,                             (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0, P_64,  0, NULL },
//10 / r ADC r / m8, r8
//REX + 10 / r ADC r / m8 *, r8 *
{ "adc",    2, { M_ANY,    R8      }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                              NO_VEX, NO_EVEX, 1, 1, { 0x10, 0x00, 0x00 }, 1, 0, MOD_MEM_REG, 0, 0,				ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_86,  0, NULL },
{ "adc",    2, { M_ANY,    R8H     }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                              NO_VEX, NO_EVEX, 1, 1, { 0x10, 0x00, 0x00 }, 1, 0, MOD_MEM_REG, 0, 0,				ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_86,  0, NULL },
{ "adc",    2, { M_ANY,    R8E     }, GP3, ALLOW_SEG | (REX | REXR) | (F_MODRM | F_MODRM_REG),	                    NO_VEX, NO_EVEX, 1, 1, { 0x10, 0x00, 0x00 }, 1, 0, MOD_MEM_REG, 0, 0,				ADDR_SIZE_OVERRIDE,             (X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_64,  0, NULL },
{ "adc",    2, { M_ANY,    R8U     }, GP3, ALLOW_SEG | (REX) | (F_MODRM | F_MODRM_REG),						                  NO_VEX, NO_EVEX, 1, 1, { 0x10, 0x00, 0x00 }, 1, 0, MOD_MEM_REG, 0, 0,				ADDR_SIZE_OVERRIDE,             (X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_64,  0, NULL },
//11 / r ADC r / m16, r16
//11 / r ADC r / m32, r32
//REX.W + 11 / r ADC r / m64, r64
{ "adc",     2, { M_ANY,    R16     }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                            NO_VEX, NO_EVEX, 1, 1, { 0x11, 0x00, 0x00 }, 2, 0, MOD_MEM_REG, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_86,  0, NULL },
{ "adc",     2, { M_ANY,    R16E    }, GP3, ALLOW_SEG | (REX | REXR) | (F_MODRM | F_MODRM_REG),	                    NO_VEX, NO_EVEX, 1, 1, { 0x11, 0x00, 0x00 }, 2, 0, MOD_MEM_REG, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE,             (X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_64,  0, NULL },
{ "adc",     2, { M_ANY,    R32     }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                            NO_VEX, NO_EVEX, 1, 1, { 0x11, 0x00, 0x00 }, 4, 0, MOD_MEM_REG, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_86,  0, NULL },
{ "adc",     2, { M_ANY,    R32E    }, GP3, ALLOW_SEG | (REX | REXR) | (F_MODRM | F_MODRM_REG),	                    NO_VEX, NO_EVEX, 1, 1, { 0x11, 0x00, 0x00 }, 4, 0, MOD_MEM_REG, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE,             (X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_64,  0, NULL },
{ "adc",     2, { M_ANY,    R64     }, GP3, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_REG),			                NO_VEX, NO_EVEX, 1, 1, { 0x11, 0x00, 0x00 }, 8, 0, MOD_MEM_REG, 0, 0,				          ADDR_SIZE_OVERRIDE,             (X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_64,  0, NULL },
{ "adc",     2, { M_ANY,    R64E    }, GP3, ALLOW_SEG | (REX | REXW | REXR) | (F_MODRM | F_MODRM_REG),	            NO_VEX, NO_EVEX, 1, 1, { 0x11, 0x00, 0x00 }, 8, 0, MOD_MEM_REG, 0, 0,				          ADDR_SIZE_OVERRIDE,             (X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_64,  0, NULL },
//12 / r ADC r8, r / m8
//REX + 12 / r ADC r8*, r / m8 *
{ "adc",     2, { R8,       R8      }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT | IMM8_ONLY),          NO_VEX, NO_EVEX, 1, 1, { 0x12, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                  (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "adc",     2, { R8,       R8H     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT | IMM8_ONLY),		      NO_VEX, NO_EVEX, 1, 1, { 0x12, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                  (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "adc",     2, { R8H,      R8      }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT | IMM8_ONLY),		      NO_VEX, NO_EVEX, 1, 1, { 0x12, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                  (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "adc",     2, { R8H,      R8H     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT | IMM8_ONLY),		      NO_VEX, NO_EVEX, 1, 1, { 0x12, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                  (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "adc",     2, { R8E,      R8E     }, GP3, (REX | REXB | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),	            NO_VEX, NO_EVEX, 1, 1, { 0x12, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                              (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "adc",     2, { R8,       R8E     }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				            NO_VEX, NO_EVEX, 1, 1, { 0x12, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                              (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "adc",     2, { R8E,      R8      }, GP3, (REX | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				            NO_VEX, NO_EVEX, 1, 1, { 0x12, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                              (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "adc",     2, { R8U,      R8      }, GP3, (REX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),					                  NO_VEX, NO_EVEX, 1, 1, { 0x12, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                              (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "adc",     2, { R8U,      R8E     }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),					          NO_VEX, NO_EVEX, 1, 1, { 0x12, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                              (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "adc",     2, { R8,       R8U     }, GP3, (REX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),					                  NO_VEX, NO_EVEX, 1, 1, { 0x12, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                              (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "adc",     2, { R8,       M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                            NO_VEX, NO_EVEX, 1, 1, { 0x12, 0x00, 0x00 }, 1, 0, MOD_REG_MEM, 0, 0, ADDR_SIZE_OVERRIDE,                (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_86,  0, NULL },
{ "adc",     2, { R8H,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                            NO_VEX, NO_EVEX, 1, 1, { 0x12, 0x00, 0x00 }, 1, 0, MOD_REG_MEM, 0, 0,	ADDR_SIZE_OVERRIDE,                (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_86,  0, NULL },
{ "adc",     2, { R8E,      M_ANY   }, GP3, ALLOW_SEG | (REX | REXR) | (F_MODRM | F_MODRM_REG),	                    NO_VEX, NO_EVEX, 1, 1, { 0x12, 0x00, 0x00 }, 1, 0, MOD_REG_MEM, 0, 0,	ADDR_SIZE_OVERRIDE,                            (X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_64,  0, NULL },
{ "adc",     2, { R8U,      M_ANY   }, GP3, ALLOW_SEG | (REX) | (F_MODRM | F_MODRM_REG),						                NO_VEX, NO_EVEX, 1, 1, { 0x12, 0x00, 0x00 }, 1, 0, MOD_REG_MEM, 0, 0,	ADDR_SIZE_OVERRIDE,                            (X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_64,  0, NULL },
//13 / r ADC r16, r / m16
//13 / r ADC r32, r / m32
//REX.W + 13 / r ADC r64, r / m64
{ "adc",     2, { R16,      R16     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                      NO_VEX, NO_EVEX, 1, 1, { 0x13, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                   (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "adc",     2, { R16E,     R16E    }, GP3, (REX | REXB | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),             NO_VEX, NO_EVEX, 1, 1, { 0x13, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "adc",     2, { R16E,     R16     }, GP3, (REX | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				            NO_VEX, NO_EVEX, 1, 1, { 0x13, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "adc",     2, { R16,      R16E    }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				            NO_VEX, NO_EVEX, 1, 1, { 0x13, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "adc",     2, { R32,      R32     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                      NO_VEX, NO_EVEX, 1, 1, { 0x13, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, 0,                0,                   (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "adc",     2, { R32E,     R32E    }, GP3, (REX | REXB | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),	            NO_VEX, NO_EVEX, 1, 1, { 0x13, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, 0,                0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "adc",     2, { R32E,     R32     }, GP3, (REX | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				            NO_VEX, NO_EVEX, 1, 1, { 0x13, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, 0,                0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "adc",     2, { R32,      R32E    }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				            NO_VEX, NO_EVEX, 1, 1, { 0x13, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, 0,                0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "adc",     2, { R64,      R64     }, GP3, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		                NO_VEX, NO_EVEX, 1, 1, { 0x13, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "adc",     2, { R64E,     R64E    }, GP3, (REX | REXR | REXB | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),      NO_VEX, NO_EVEX, 1, 1, { 0x13, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "adc",     2, { R64,      R64E    }, GP3, (REX | REXB | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		          NO_VEX, NO_EVEX, 1, 1, { 0x13, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "adc",     2, { R64E,     R64     }, GP3, (REX | REXR | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		          NO_VEX, NO_EVEX, 1, 1, { 0x13, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "adc",     2, { R16,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                            NO_VEX, NO_EVEX, 1, 1, { 0x13, 0x00, 0x00 }, 2, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE, 0,                   (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_86,  0, NULL },
{ "adc",     2, { R16E,     M_ANY   }, GP3, ALLOW_SEG | (REX | REXR) | (F_MODRM | F_MODRM_REG),	                    NO_VEX, NO_EVEX, 1, 1, { 0x13, 0x00, 0x00 }, 2, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE,             (X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_64,  0, NULL },
{ "adc",     2, { R32,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                            NO_VEX, NO_EVEX, 1, 1, { 0x13, 0x00, 0x00 }, 4, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_86,  0, NULL },
{ "adc",     2, { R32E,     M_ANY   }, GP3, ALLOW_SEG | (REX | REXR) | (F_MODRM | F_MODRM_REG),	                    NO_VEX, NO_EVEX, 1, 1, { 0x13, 0x00, 0x00 }, 4, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE,             (X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_64,  0, NULL },
{ "adc",     2, { R64,      M_ANY   }, GP3, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_REG),				              NO_VEX, NO_EVEX, 1, 1, { 0x13, 0x00, 0x00 }, 8, 0, MOD_REG_MEM, 0, 0,				          ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_64,  0, NULL },
{ "adc",     2, { R64E,     M_ANY   }, GP3, ALLOW_SEG | (REX | REXW | REXR) | (F_MODRM | F_MODRM_REG),	            NO_VEX, NO_EVEX, 1, 1, { 0x13, 0x00, 0x00 }, 8, 0, MOD_REG_MEM, 0, 0,				          ADDR_SIZE_OVERRIDE,             (X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_64,  0, NULL },

//04 ib ADD AL, imm8 I Valid Valid Add imm8 to AL.
{ "add",    2, { R8_AL,    IMM8    }, GP0, (F_OPCODE_REG),												                                  NO_VEX, NO_EVEX, 1, 1, { 0x04, 0x00, 0x00 }, 1, 0, NO_MOD,      0, 0,				         0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
//05 iw ADD AX, imm16 I Valid Valid Add imm16 to AX.
//05 id ADD EAX, imm32 I Valid Valid Add imm32 to EAX.
//REX.W + 05 id ADD RAX, imm32 I Valid N.E.Add imm32 sign - extended to 64 - bits to RAX.
{ "add",    2, { R16_AX,   IMM16   }, GP0, (F_OPCODE_REG),												                                  NO_VEX, NO_EVEX, 1, 1, { 0x05, 0x00, 0x00 }, 2, 0, NO_MOD,      0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "add",    2, { R32_EAX,  IMM32   }, GP0, (F_OPCODE_REG),												                                  NO_VEX, NO_EVEX, 1, 1, { 0x05, 0x00, 0x00 }, 4, 0, NO_MOD,      0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "add",    2, { R64_RAX,  IMM32   }, GP3, (REX | REXW) | (F_OPCODE_REG),						                                NO_VEX, NO_EVEX, 1, 1, { 0x05, 0x00, 0x00 }, 4, 0, NO_MOD,      0, 0,				         0,                  (X64), NO_DST,              NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
//80 / 0 ib ADD r / m8, imm8 MI Valid Valid Add imm8 to r / m8.
//REX + 80 / 0 ib ADD r / m8 * , imm8 MI Valid N.E.Add sign - extended imm8 to r / m8.
{ "add",    2, { R8,       IMM8    }, GP0, REX | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),		                NO_VEX, NO_EVEX, 1, 1, { 0x80, 0x00, 0x00 }, 1, 0, MOD_REG_IMM, 0, 0,	               0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "add",    2, { R8H,      IMM8    }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	                        NO_VEX, NO_EVEX, 1, 1, { 0x80, 0x00, 0x00 }, 1, 0, MOD_REG_IMM, 0, 0,	               0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "add",    2, { R8U,      IMM8    }, GP3, REX | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),									  NO_VEX, NO_EVEX, 1, 1, { 0x80, 0x00, 0x00 }, 1, 0, MOD_REG_IMM, 0, 0,				         0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
{ "add",    2, { R8E,      IMM8    }, GP3, (REX | REXB) | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),				  NO_VEX, NO_EVEX, 1, 1, { 0x80, 0x00, 0x00 }, 1, 0, MOD_REG_IMM, 0, 0,				         0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
{ "add",    2, { M8,       IMM8    }, GP0, ALLOW_SEG | (F_MODRM | OPCODE_EXT | IMM8_ONLY),									        NO_VEX, NO_EVEX, 1, 1, { 0x80, 0x00, 0x00 }, 1, 0, MOD_MEM_IMM, 0, 0,	               ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0,P_86,  0, NULL },
//81 / 0 iw ADD r / m16, imm16 MI Valid Valid Add imm16 to r / m16.
//81 / 0 id ADD r / m32, imm32 MI Valid Valid Add imm32 to r / m32.
//REX.W + 81 / 0 id ADD r / m64, imm32 MI Valid N.E.Add imm32 sign - extended to 64 - bits to r / m64.
{ "add",    2, { R16,      IMM16   }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT),		                                  NO_VEX, NO_EVEX, 1, 1, { 0x81, 0x00, 0x00 }, 2, 0, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "add",    2, { R16E,     IMM16   }, GP3, (REX | REXB) | (F_MODRM_RM | F_MODRM | OPCODE_EXT),								      NO_VEX, NO_EVEX, 1, 1, { 0x81, 0x00, 0x00 }, 2, 0, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
{ "add",    2, { M16,      IMM16   }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT),		                                  NO_VEX, NO_EVEX, 1, 1, { 0x81, 0x00, 0x00 }, 2, 0, MOD_MEM_IMM, 0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0, P_86,  0, NULL },
{ "add",    2, { R32,      IMM32   }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT),		                                  NO_VEX, NO_EVEX, 1, 1, { 0x81, 0x00, 0x00 }, 4, 0, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "add",    2, { R32E,     IMM32   }, GP3, (REX | REXB) | (F_MODRM_RM | F_MODRM | OPCODE_EXT),								      NO_VEX, NO_EVEX, 1, 1, { 0x81, 0x00, 0x00 }, 4, 0, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
{ "add",    2, { R32,      IMM16   }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT),		                                  NO_VEX, NO_EVEX, 1, 1, { 0x81, 0x00, 0x00 }, 4, 0, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "add",    2, { R32E,     IMM16   }, GP3, (REX | REXB) | (F_MODRM_RM | F_MODRM | OPCODE_EXT),								      NO_VEX, NO_EVEX, 1, 1, { 0x81, 0x00, 0x00 }, 4, 0, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
{ "add",    2, { M32,      IMM32   }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT),		                                  NO_VEX, NO_EVEX, 1, 1, { 0x81, 0x00, 0x00 }, 4, 0, MOD_MEM_IMM, 0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0, P_86,  0, NULL },
{ "add",    2, { R64,      IMM32   }, GP3, (REX | REXW) | (F_MODRM_RM | F_MODRM | OPCODE_EXT),                      NO_VEX, NO_EVEX, 1, 1, { 0x81, 0x00, 0x00 }, 4, 0, MOD_REG_IMM, 0, 0,	               0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
{ "add",    2, { R64,      IMM16   }, GP3, (REX | REXW) | (F_MODRM_RM | F_MODRM | OPCODE_EXT),                      NO_VEX, NO_EVEX, 1, 1, { 0x81, 0x00, 0x00 }, 4, 0, MOD_REG_IMM, 0, 0,	               0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
{ "add",    2, { R64E,     IMM16   }, GP3, (REX | REXW | REXB) | (F_MODRM_RM | F_MODRM | OPCODE_EXT),               NO_VEX, NO_EVEX, 1, 1, { 0x81, 0x00, 0x00 }, 4, 0, MOD_REG_IMM, 0, 0,	               0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
{ "add",    2, { R64E,     IMM32   }, GP3, (REX | REXW | REXB) | (F_MODRM_RM | F_MODRM | OPCODE_EXT),               NO_VEX, NO_EVEX, 1, 1, { 0x81, 0x00, 0x00 }, 4, 0, MOD_REG_IMM, 0, 0,	               0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
{ "add",    2, { M64,      IMM32   }, GP3, REXW | (F_MODRM_RM | F_MODRM | OPCODE_EXT),		                          NO_VEX, NO_EVEX, 1, 1, { 0x81, 0x00, 0x00 }, 4, 0, MOD_MEM_IMM, 0, 0,	               0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0, P_64,  0, NULL },
//83 / 0 ib ADD r / m16, imm8 MI Valid Valid Add sign - extended imm8 to r / m16.
//83 / 0 ib ADD r / m32, imm8 MI Valid Valid Add sign - extended imm8 to r / m32.
//REX.W + 83 / 0 ib ADD r / m64, imm8 MI Valid N.E.Add sign - extended imm8 to r / m64.
{ "add",    2, { R16,      IMM8    }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	                        NO_VEX, NO_EVEX, 1, 1, { 0x83, 0x00, 0x00 }, 2, 0, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "add",    2, { R16E,     IMM8    }, GP3, (REX | REXB) | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	        NO_VEX, NO_EVEX, 1, 1, { 0x83, 0x00, 0x00 }, 2, 0, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "add",    2, { M16,      IMM8    }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	                        NO_VEX, NO_EVEX, 1, 1, { 0x83, 0x00, 0x00 }, 2, 0, MOD_MEM_IMM, 0, OP_SIZE_OVERRIDE, ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0, P_86,  0, NULL },
{ "add",    2, { R32,      IMM8    }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	                        NO_VEX, NO_EVEX, 1, 1, { 0x83, 0x00, 0x00 }, 4, 0, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "add",    2, { R32E,     IMM8    }, GP3, (REX | REXB) | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	        NO_VEX, NO_EVEX, 1, 1, { 0x83, 0x00, 0x00 }, 4, 0, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "add",    2, { M32,      IMM8    }, GP0, ALLOW_SEG | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	            NO_VEX, NO_EVEX, 1, 1, { 0x83, 0x00, 0x00 }, 4, 0, MOD_MEM_IMM, 0, OP_SIZE_OVERRIDE, ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0, P_86,  0, NULL },
{ "add",    2, { R64,      IMM8    }, GP3, (REX | REXW) | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),          NO_VEX, NO_EVEX, 1, 1, { 0x83, 0x00, 0x00 }, 4, 0, MOD_REG_IMM, 0, 0,	               0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
{ "add",    2, { R64E,     IMM8    }, GP3, (REX | REXW | REXB) | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),   NO_VEX, NO_EVEX, 1, 1, { 0x83, 0x00, 0x00 }, 4, 0, MOD_REG_IMM, 0, 0,				         0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
{ "add",    2, { M64,      IMM8    }, GP3, (REX | REXW) | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),		      NO_VEX, NO_EVEX, 1, 1, { 0x83, 0x00, 0x00 }, 4, 0, MOD_MEM_IMM, 0, 0,ADDR_SIZE_OVERRIDE,                             (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0, P_64,  0, NULL },
//00 / r ADD r8, r / m8                   
//REX + 00 / r ADD r / m8 * , r8*  
{ "add",    2, { M_ANY,    R8      }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                              NO_VEX, NO_EVEX, 1, 1, { 0x00, 0x00, 0x00 }, 1, 0, MOD_MEM_REG, 0, 0,				ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_86,  0, NULL },
{ "add",    2, { M_ANY,    R8H     }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                              NO_VEX, NO_EVEX, 1, 1, { 0x00, 0x00, 0x00 }, 1, 0, MOD_MEM_REG, 0, 0,				ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_86,  0, NULL },
{ "add",    2, { M_ANY,    R8E     }, GP3, ALLOW_SEG | (REX | REXR) | (F_MODRM | F_MODRM_REG),	                    NO_VEX, NO_EVEX, 1, 1, { 0x00, 0x00, 0x00 }, 1, 0, MOD_MEM_REG, 0, 0,				ADDR_SIZE_OVERRIDE,             (X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_64,  0, NULL },
{ "add",    2, { M_ANY,    R8U     }, GP3, ALLOW_SEG | (REX) | (F_MODRM | F_MODRM_REG),						                  NO_VEX, NO_EVEX, 1, 1, { 0x00, 0x00, 0x00 }, 1, 0, MOD_MEM_REG, 0, 0,				ADDR_SIZE_OVERRIDE,             (X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_64,  0, NULL },
//01 / r ADD r / m16, r16 MR Valid Valid Add r16 to r / m16.
//01 / r ADD r / m32, r32 MR Valid Valid Add r32 to r / m32.
//REX.W + 01 / r ADD r / m64, r64 MR Valid N.E.Add r64 to r / m64.
{ "add",     2, { M_ANY,    R16     }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                            NO_VEX, NO_EVEX, 1, 1, { 0x01, 0x00, 0x00 }, 2, 0, MOD_MEM_REG, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_86,  0, NULL },
{ "add",     2, { M_ANY,    R16E    }, GP3, ALLOW_SEG | (REX | REXR) | (F_MODRM | F_MODRM_REG),	                    NO_VEX, NO_EVEX, 1, 1, { 0x01, 0x00, 0x00 }, 2, 0, MOD_MEM_REG, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE,             (X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_64,  0, NULL },
{ "add",     2, { M_ANY,    R32     }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                            NO_VEX, NO_EVEX, 1, 1, { 0x01, 0x00, 0x00 }, 4, 0, MOD_MEM_REG, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_86,  0, NULL },
{ "add",     2, { M_ANY,    R32E    }, GP3, ALLOW_SEG | (REX | REXR) | (F_MODRM | F_MODRM_REG),	                    NO_VEX, NO_EVEX, 1, 1, { 0x01, 0x00, 0x00 }, 4, 0, MOD_MEM_REG, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE,             (X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_64,  0, NULL },
{ "add",     2, { M_ANY,    R64     }, GP3, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_REG),			                NO_VEX, NO_EVEX, 1, 1, { 0x01, 0x00, 0x00 }, 8, 0, MOD_MEM_REG, 0, 0,				          ADDR_SIZE_OVERRIDE,             (X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_64,  0, NULL },
{ "add",     2, { M_ANY,    R64E    }, GP3, ALLOW_SEG | (REX | REXW | REXR) | (F_MODRM | F_MODRM_REG),	            NO_VEX, NO_EVEX, 1, 1, { 0x01, 0x00, 0x00 }, 8, 0, MOD_MEM_REG, 0, 0,				          ADDR_SIZE_OVERRIDE,             (X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_64,  0, NULL },
//02 / r ADD r8, r / m8            OR r8, r / m8
//REX + 02 / r ADD r8*, r / m8 *   OR r8*, r / m8 *
{ "add",     2, { R8,       R8      }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT | IMM8_ONLY),          NO_VEX, NO_EVEX, 1, 1, { 0x02, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                  (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "add",     2, { R8,       R8H     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT | IMM8_ONLY),		      NO_VEX, NO_EVEX, 1, 1, { 0x02, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                  (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "add",     2, { R8H,      R8      }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT | IMM8_ONLY),		      NO_VEX, NO_EVEX, 1, 1, { 0x02, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                  (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "add",     2, { R8H,      R8H     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT | IMM8_ONLY),		      NO_VEX, NO_EVEX, 1, 1, { 0x02, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                  (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "add",     2, { R8E,      R8E     }, GP3, (REX | REXB | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),	            NO_VEX, NO_EVEX, 1, 1, { 0x02, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                              (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "add",     2, { R8,       R8E     }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				            NO_VEX, NO_EVEX, 1, 1, { 0x02, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                              (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "add",     2, { R8E,      R8      }, GP3, (REX | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				            NO_VEX, NO_EVEX, 1, 1, { 0x02, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                              (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "add",     2, { R8U,      R8      }, GP3, (REX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),					                  NO_VEX, NO_EVEX, 1, 1, { 0x02, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                              (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "add",     2, { R8U,      R8E     }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),					          NO_VEX, NO_EVEX, 1, 1, { 0x02, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                              (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "add",     2, { R8,       R8U     }, GP3, (REX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),					                  NO_VEX, NO_EVEX, 1, 1, { 0x02, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                              (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "add",     2, { R8,       M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                            NO_VEX, NO_EVEX, 1, 1, { 0x02, 0x00, 0x00 }, 1, 0, MOD_REG_MEM, 0, 0, ADDR_SIZE_OVERRIDE,                (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_86,  0, NULL },
{ "add",     2, { R8H,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                            NO_VEX, NO_EVEX, 1, 1, { 0x02, 0x00, 0x00 }, 1, 0, MOD_REG_MEM, 0, 0,	ADDR_SIZE_OVERRIDE,                (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_86,  0, NULL },
{ "add",     2, { R8E,      M_ANY   }, GP3, ALLOW_SEG | (REX | REXR) | (F_MODRM | F_MODRM_REG),	                    NO_VEX, NO_EVEX, 1, 1, { 0x02, 0x00, 0x00 }, 1, 0, MOD_REG_MEM, 0, 0,	ADDR_SIZE_OVERRIDE,                            (X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_64,  0, NULL },
{ "add",     2, { R8U,      M_ANY   }, GP3, ALLOW_SEG | (REX) | (F_MODRM | F_MODRM_REG),						                NO_VEX, NO_EVEX, 1, 1, { 0x02, 0x00, 0x00 }, 1, 0, MOD_REG_MEM, 0, 0,	ADDR_SIZE_OVERRIDE,                            (X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_64,  0, NULL },
//03 / r ADD r16, r / m16 RM Valid Valid Add r / m16 to r16.
//03 / r ADD r32, r / m32 RM Valid Valid Add r / m32 to r32.
//REX.W + 03 / r ADD r64, r / m64 RM Valid N.E.Add r / m64 to r64.  { "add",    2, { R16,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                  NO_VEX, NO_EVEX, 1, 1, { 0x13, 0x00, 0x00 }, 2, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST, NO_PREFIX, NO_IMM    , MEM_OPND_1, P_86,  0, NULL },
{ "add",     2, { R16,      R16     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                      NO_VEX, NO_EVEX, 1, 1, { 0x03, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                   (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "add",     2, { R16E,     R16E    }, GP3, (REX | REXB | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),             NO_VEX, NO_EVEX, 1, 1, { 0x03, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "add",     2, { R16E,     R16     }, GP3, (REX | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				            NO_VEX, NO_EVEX, 1, 1, { 0x03, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "add",     2, { R16,      R16E    }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				            NO_VEX, NO_EVEX, 1, 1, { 0x03, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "add",     2, { R32,      R32     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                      NO_VEX, NO_EVEX, 1, 1, { 0x03, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, 0,                0,                   (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "add",     2, { R32E,     R32E    }, GP3, (REX | REXB | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),	            NO_VEX, NO_EVEX, 1, 1, { 0x03, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, 0,                0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "add",     2, { R32E,     R32     }, GP3, (REX | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				            NO_VEX, NO_EVEX, 1, 1, { 0x03, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, 0,                0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "add",     2, { R32,      R32E    }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				            NO_VEX, NO_EVEX, 1, 1, { 0x03, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, 0,                0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "add",     2, { R64,      R64     }, GP3, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		                NO_VEX, NO_EVEX, 1, 1, { 0x03, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "add",     2, { R64E,     R64E    }, GP3, (REX | REXR | REXB | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),      NO_VEX, NO_EVEX, 1, 1, { 0x03, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "add",     2, { R64,      R64E    }, GP3, (REX | REXB | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		          NO_VEX, NO_EVEX, 1, 1, { 0x03, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "add",     2, { R64E,     R64     }, GP3, (REX | REXR | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		          NO_VEX, NO_EVEX, 1, 1, { 0x03, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "add",     2, { R16,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                            NO_VEX, NO_EVEX, 1, 1, { 0x03, 0x00, 0x00 }, 2, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE, 0,                   (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_86,  0, NULL },
{ "add",     2, { R16E,     M_ANY   }, GP3, ALLOW_SEG | (REX | REXR) | (F_MODRM | F_MODRM_REG),	                    NO_VEX, NO_EVEX, 1, 1, { 0x03, 0x00, 0x00 }, 2, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE,             (X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_64,  0, NULL },
{ "add",     2, { R32,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                            NO_VEX, NO_EVEX, 1, 1, { 0x03, 0x00, 0x00 }, 4, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_86,  0, NULL },
{ "add",     2, { R32E,     M_ANY   }, GP3, ALLOW_SEG | (REX | REXR) | (F_MODRM | F_MODRM_REG),	                    NO_VEX, NO_EVEX, 1, 1, { 0x03, 0x00, 0x00 }, 4, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE,             (X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_64,  0, NULL },
{ "add",     2, { R64,      M_ANY   }, GP3, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_REG),				              NO_VEX, NO_EVEX, 1, 1, { 0x03, 0x00, 0x00 }, 8, 0, MOD_REG_MEM, 0, 0,				          ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_64,  0, NULL },
{ "add",     2, { R64E,     M_ANY   }, GP3, ALLOW_SEG | (REX | REXW | REXR) | (F_MODRM | F_MODRM_REG),	            NO_VEX, NO_EVEX, 1, 1, { 0x03, 0x00, 0x00 }, 8, 0, MOD_REG_MEM, 0, 0,				          ADDR_SIZE_OVERRIDE,             (X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_64,  0, NULL },

//0C ib           	OR AL, imm8
{ "or",     2, { R8_AL,    IMM8    }, GP0, (F_OPCODE_REG),												                                  NO_VEX, NO_EVEX, 1, 1, { 0x0c, 0x00, 0x00 }, 1, 0, NO_MOD,      0, 0,				         0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
//0D iw           	OR AX, imm16
//0D id           	OR EAX, imm32
//REX.W + 0D id   	OR RAX, imm32
{ "or",     2, { R16_AX,   IMM16   }, GP0, (F_OPCODE_REG),												                                  NO_VEX, NO_EVEX, 1, 1, { 0x0d, 0x00, 0x00 }, 2, 0, NO_MOD,      0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "or",     2, { R32_EAX,  IMM32   }, GP0, (F_OPCODE_REG),												                                  NO_VEX, NO_EVEX, 1, 1, { 0x0d, 0x00, 0x00 }, 4, 0, NO_MOD,      0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "or",     2, { R64_RAX,  IMM32   }, GP3, (REX | REXW) | (F_OPCODE_REG),						                                NO_VEX, NO_EVEX, 1, 1, { 0x0d, 0x00, 0x00 }, 4, 0, NO_MOD,      0, 0,				         0,                  (X64), NO_DST,              NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
//80 / 1 ib        	OR r / m8, imm8
//REX + 80 / 1 ib  	OR r / m8 *, imm8
{ "or",     2, { R8,       IMM8    }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),		                      NO_VEX, NO_EVEX, 1, 1, { 0x80, 0x01, 0x00 }, 1, 0, MOD_REG_IMM, 0, 0,	               0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "or",     2, { R8H,      IMM8    }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	                        NO_VEX, NO_EVEX, 1, 1, { 0x80, 0x01, 0x00 }, 1, 0, MOD_REG_IMM, 0, 0,	               0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "or",     2, { R8U,      IMM8    }, GP3, REX | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),									  NO_VEX, NO_EVEX, 1, 1, { 0x80, 0x01, 0x00 }, 1, 0, MOD_REG_IMM, 0, 0,				         0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
{ "or",     2, { R8E,      IMM8    }, GP3, (REX | REXB) | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),				  NO_VEX, NO_EVEX, 1, 1, { 0x80, 0x01, 0x00 }, 1, 0, MOD_REG_IMM, 0, 0,				         0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
{ "or",     2, { M8,       IMM8    }, GP0, ALLOW_SEG | (F_MODRM | OPCODE_EXT | IMM8_ONLY),									        NO_VEX, NO_EVEX, 1, 1, { 0x80, 0x01, 0x00 }, 1, 0, MOD_MEM_IMM, 0, 0,	               ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0,P_86,  0, NULL },
//81 / 1 iw        	OR r / m16, imm16
//81 / 1 id        	OR r / m32, imm32
//REX.W + 81 / 1 id	OR r / m64, imm32
{ "or",     2, { R16,      IMM16   }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT),		                                  NO_VEX, NO_EVEX, 1, 1, { 0x81, 0x01, 0x00 }, 2, 0, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "or",     2, { R16E,     IMM16   }, GP3, (REX | REXB) | (F_MODRM_RM | F_MODRM | OPCODE_EXT),								      NO_VEX, NO_EVEX, 1, 1, { 0x81, 0x01, 0x00 }, 2, 0, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
{ "or",     2, { M16,      IMM16   }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT),		                                  NO_VEX, NO_EVEX, 1, 1, { 0x81, 0x01, 0x00 }, 2, 0, MOD_MEM_IMM, 0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0, P_86,  0, NULL },
{ "or",     2, { R32,      IMM32   }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT),		                                  NO_VEX, NO_EVEX, 1, 1, { 0x81, 0x01, 0x00 }, 4, 0, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "or",     2, { R32E,     IMM32   }, GP3, (REX | REXB) | (F_MODRM_RM | F_MODRM | OPCODE_EXT),								      NO_VEX, NO_EVEX, 1, 1, { 0x81, 0x01, 0x00 }, 4, 0, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
{ "or",     2, { R32,      IMM16   }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT),		                                  NO_VEX, NO_EVEX, 1, 1, { 0x81, 0x01, 0x00 }, 4, 0, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "or",     2, { R32E,     IMM16   }, GP3, (REX | REXB) | (F_MODRM_RM | F_MODRM | OPCODE_EXT),								      NO_VEX, NO_EVEX, 1, 1, { 0x81, 0x01, 0x00 }, 4, 0, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
{ "or",     2, { M32,      IMM32   }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT),		                                  NO_VEX, NO_EVEX, 1, 1, { 0x81, 0x01, 0x00 }, 4, 0, MOD_MEM_IMM, 0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0, P_86,  0, NULL },
{ "or",     2, { R64,      IMM32   }, GP3, (REX | REXW) | (F_MODRM_RM | F_MODRM | OPCODE_EXT),                      NO_VEX, NO_EVEX, 1, 1, { 0x81, 0x01, 0x00 }, 4, 0, MOD_REG_IMM, 0, 0,	               0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
{ "or",     2, { R64,      IMM16   }, GP3, (REX | REXW) | (F_MODRM_RM | F_MODRM | OPCODE_EXT),                      NO_VEX, NO_EVEX, 1, 1, { 0x81, 0x01, 0x00 }, 4, 0, MOD_REG_IMM, 0, 0,	               0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
{ "or",     2, { R64E,     IMM32   }, GP3, (REX | REXW | REXB) | (F_MODRM_RM | F_MODRM | OPCODE_EXT),                      NO_VEX, NO_EVEX, 1, 1, { 0x81, 0x01, 0x00 }, 4, 0, MOD_REG_IMM, 0, 0,	               0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
{ "or",     2, { R64E,     IMM16   }, GP3, (REX | REXW | REXB) | (F_MODRM_RM | F_MODRM | OPCODE_EXT),                      NO_VEX, NO_EVEX, 1, 1, { 0x81, 0x01, 0x00 }, 4, 0, MOD_REG_IMM, 0, 0,	               0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
{ "or",     2, { M64,      IMM32   }, GP3, REXW | (F_MODRM_RM | F_MODRM | OPCODE_EXT),		                          NO_VEX, NO_EVEX, 1, 1, { 0x81, 0x01, 0x00 }, 4, 0, MOD_MEM_IMM, 0, 0,	               0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0, P_64,  0, NULL },
//83 / 1 ib        	OR r / m16, imm8
//83 / 1 ib        	OR r / m32, imm8
//REX.W + 83 / 1 ib	OR r / m64, imm8
{ "or",     2, { R16,      IMM8    }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	                        NO_VEX, NO_EVEX, 1, 1, { 0x83, 0x01, 0x00 }, 2, 0, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "or",     2, { R16E,     IMM8    }, GP3, (REX | REXB) | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	        NO_VEX, NO_EVEX, 1, 1, { 0x83, 0x01, 0x00 }, 2, 0, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "or",     2, { M16,      IMM8    }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	                        NO_VEX, NO_EVEX, 1, 1, { 0x83, 0x01, 0x00 }, 2, 0, MOD_MEM_IMM, 0, OP_SIZE_OVERRIDE, ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0, P_86,  0, NULL },
{ "or",     2, { R32,      IMM8    }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	                        NO_VEX, NO_EVEX, 1, 1, { 0x83, 0x01, 0x00 }, 4, 0, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "or",     2, { R32E,     IMM8    }, GP3, (REX | REXB) | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	        NO_VEX, NO_EVEX, 1, 1, { 0x83, 0x01, 0x00 }, 4, 0, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "or",     2, { M32,      IMM8    }, GP0, ALLOW_SEG | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	            NO_VEX, NO_EVEX, 1, 1, { 0x83, 0x01, 0x00 }, 4, 0, MOD_MEM_IMM, 0, OP_SIZE_OVERRIDE, ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0, P_86,  0, NULL },
{ "or",     2, { R64,      IMM8    }, GP3, (REX | REXW) | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),          NO_VEX, NO_EVEX, 1, 1, { 0x83, 0x01, 0x00 }, 4, 0, MOD_REG_IMM, 0, 0,	               0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
{ "or",     2, { R64E,     IMM8    }, GP3, (REX | REXW | REXB) | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),   NO_VEX, NO_EVEX, 1, 1, { 0x83, 0x01, 0x00 }, 4, 0, MOD_REG_IMM, 0, 0,				         0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
{ "or",     2, { M64,      IMM8    }, GP3, (REX | REXW) | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),		      NO_VEX, NO_EVEX, 1, 1, { 0x83, 0x01, 0x00 }, 4, 0, MOD_MEM_IMM, 0, 0,ADDR_SIZE_OVERRIDE,                             (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0, P_64,  0, NULL },
//08 / r OR r / m8, r8
//REX + 08 / r OR r / m8 *, r8*
{ "or",     2, { M_ANY,    R8      }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                              NO_VEX, NO_EVEX, 1, 1, { 0x08, 0x00, 0x00 }, 1, 0, MOD_MEM_REG, 0, 0,				ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_86,  0, NULL },
{ "or",     2, { M_ANY,    R8H     }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                              NO_VEX, NO_EVEX, 1, 1, { 0x08, 0x00, 0x00 }, 1, 0, MOD_MEM_REG, 0, 0,				ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_86,  0, NULL },
{ "or",     2, { M_ANY,    R8E     }, GP3, ALLOW_SEG | (REX | REXR) | (F_MODRM | F_MODRM_REG),	                    NO_VEX, NO_EVEX, 1, 1, { 0x08, 0x00, 0x00 }, 1, 0, MOD_MEM_REG, 0, 0,				ADDR_SIZE_OVERRIDE,             (X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_64,  0, NULL },
{ "or",     2, { M_ANY,    R8U     }, GP3, ALLOW_SEG | (REX) | (F_MODRM | F_MODRM_REG),						                  NO_VEX, NO_EVEX, 1, 1, { 0x08, 0x00, 0x00 }, 1, 0, MOD_MEM_REG, 0, 0,				ADDR_SIZE_OVERRIDE,             (X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_64,  0, NULL },
//09 / r           	OR r / m16, r16
//09 / r           	OR r / m32, r32
//REX.W + 09 / r   	OR r / m64, r64
{ "or",     2, { M_ANY,    R16     }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                              NO_VEX, NO_EVEX, 1, 1, { 0x09, 0x00, 0x00 }, 2, 0, MOD_MEM_REG, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_86,  0, NULL },
{ "or",     2, { M_ANY,    R16E    }, GP3, ALLOW_SEG | (REX | REXR) | (F_MODRM | F_MODRM_REG),	                    NO_VEX, NO_EVEX, 1, 1, { 0x09, 0x00, 0x00 }, 2, 0, MOD_MEM_REG, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE,             (X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_64,  0, NULL },
{ "or",     2, { M_ANY,    R32     }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                              NO_VEX, NO_EVEX, 1, 1, { 0x09, 0x00, 0x00 }, 4, 0, MOD_MEM_REG, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_86,  0, NULL },
{ "or",     2, { M_ANY,    R32E    }, GP3, ALLOW_SEG | (REX | REXR) | (F_MODRM | F_MODRM_REG),	                    NO_VEX, NO_EVEX, 1, 1, { 0x09, 0x00, 0x00 }, 4, 0, MOD_MEM_REG, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE,             (X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_64,  0, NULL },
{ "or",     2, { M_ANY,    R64     }, GP3, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_REG),			                NO_VEX, NO_EVEX, 1, 1, { 0x09, 0x00, 0x00 }, 8, 0, MOD_MEM_REG, 0, 0,				          ADDR_SIZE_OVERRIDE,             (X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_64,  0, NULL },
{ "or",     2, { M_ANY,    R64E    }, GP3, ALLOW_SEG | (REX | REXW | REXR) | (F_MODRM | F_MODRM_REG),	              NO_VEX, NO_EVEX, 1, 1, { 0x09, 0x00, 0x00 }, 8, 0, MOD_MEM_REG, 0, 0,				          ADDR_SIZE_OVERRIDE,             (X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_64,  0, NULL },
//0A / r           	OR r8, r / m8
//REX + 0A / r     	OR r8*, r / m8 *
{ "or",     2, { R8,       R8      }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT | IMM8_ONLY),           NO_VEX, NO_EVEX, 1, 1, { 0x0a, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                  (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "or",     2, { R8,       R8H     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT | IMM8_ONLY),		        NO_VEX, NO_EVEX, 1, 1, { 0x0a, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                  (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "or",     2, { R8H,      R8      }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT | IMM8_ONLY),		        NO_VEX, NO_EVEX, 1, 1, { 0x0a, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                  (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "or",     2, { R8H,      R8H     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT | IMM8_ONLY),		        NO_VEX, NO_EVEX, 1, 1, { 0x0a, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                  (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "or",     2, { R8E,      R8E     }, GP3, (REX | REXB | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),	            NO_VEX, NO_EVEX, 1, 1, { 0x0a, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                              (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "or",     2, { R8,       R8E     }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				              NO_VEX, NO_EVEX, 1, 1, { 0x0a, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                              (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "or",     2, { R8E,      R8      }, GP3, (REX | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				              NO_VEX, NO_EVEX, 1, 1, { 0x0a, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                              (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "or",     2, { R8U,      R8      }, GP3, (REX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),					                  NO_VEX, NO_EVEX, 1, 1, { 0x0a, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                              (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "or",     2, { R8U,      R8E     }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),					            NO_VEX, NO_EVEX, 1, 1, { 0x0a, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                              (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "or",     2, { R8,       R8U     }, GP3, (REX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),					                  NO_VEX, NO_EVEX, 1, 1, { 0x0a, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                              (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "or",     2, { R8,       M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                              NO_VEX, NO_EVEX, 1, 1, { 0x0a, 0x00, 0x00 }, 1, 0, MOD_REG_MEM, 0, 0, ADDR_SIZE_OVERRIDE,                (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_86,  0, NULL },
{ "or",     2, { R8H,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                              NO_VEX, NO_EVEX, 1, 1, { 0x0a, 0x00, 0x00 }, 1, 0, MOD_REG_MEM, 0, 0,	ADDR_SIZE_OVERRIDE,                (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_86,  0, NULL },
{ "or",     2, { R8E,      M_ANY   }, GP3, ALLOW_SEG | (REX | REXR) | (F_MODRM | F_MODRM_REG),	                    NO_VEX, NO_EVEX, 1, 1, { 0x0a, 0x00, 0x00 }, 1, 0, MOD_REG_MEM, 0, 0,	ADDR_SIZE_OVERRIDE,                            (X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_64,  0, NULL },
{ "or",     2, { R8U,      M_ANY   }, GP3, ALLOW_SEG | (REX) | (F_MODRM | F_MODRM_REG),						                  NO_VEX, NO_EVEX, 1, 1, { 0x0a, 0x00, 0x00 }, 1, 0, MOD_REG_MEM, 0, 0,	ADDR_SIZE_OVERRIDE,                            (X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_64,  0, NULL },
//0B / r           	OR r16, r / m16
//0B / r           	OR r32, r / m32
//REX.W + 0B / r   	OR r64, r / m64
{ "or",     2, { R16,      R16     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                      NO_VEX, NO_EVEX, 1, 1, { 0x0b, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                   (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "or",     2, { R16E,     R16E    }, GP3, (REX | REXB | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),              NO_VEX, NO_EVEX, 1, 1, { 0x0b, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "or",     2, { R16E,     R16     }, GP3, (REX | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				              NO_VEX, NO_EVEX, 1, 1, { 0x0b, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "or",     2, { R16,      R16E    }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				              NO_VEX, NO_EVEX, 1, 1, { 0x0b, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "or",     2, { R32,      R32     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                      NO_VEX, NO_EVEX, 1, 1, { 0x0b, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, 0,                0,                   (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "or",     2, { R32E,     R32E    }, GP3, (REX | REXB | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),	            NO_VEX, NO_EVEX, 1, 1, { 0x0b, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, 0,                0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "or",     2, { R32E,     R32     }, GP3, (REX | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				              NO_VEX, NO_EVEX, 1, 1, { 0x0b, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, 0,                0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "or",     2, { R32,      R32E    }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				              NO_VEX, NO_EVEX, 1, 1, { 0x0b, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, 0,                0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "or",     2, { R64,      R64     }, GP3, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		                  NO_VEX, NO_EVEX, 1, 1, { 0x0b, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "or",     2, { R64E,     R64E    }, GP3, (REX | REXR | REXB | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),       NO_VEX, NO_EVEX, 1, 1, { 0x0b, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "or",     2, { R64,      R64E    }, GP3, (REX | REXB | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		          NO_VEX, NO_EVEX, 1, 1, { 0x0b, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "or",     2, { R64E,     R64     }, GP3, (REX | REXR | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		          NO_VEX, NO_EVEX, 1, 1, { 0x0b, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "or",     2, { R16,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                              NO_VEX, NO_EVEX, 1, 1, { 0x0b, 0x00, 0x00 }, 2, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE, 0,                   (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_86,  0, NULL },
{ "or",     2, { R16E,     M_ANY   }, GP3, ALLOW_SEG | (REX | REXR) | (F_MODRM | F_MODRM_REG),	                    NO_VEX, NO_EVEX, 1, 1, { 0x0b, 0x00, 0x00 }, 2, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE,             (X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_64,  0, NULL },
{ "or",     2, { R32,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                              NO_VEX, NO_EVEX, 1, 1, { 0x0b, 0x00, 0x00 }, 4, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_86,  0, NULL },
{ "or",     2, { R32E,     M_ANY   }, GP3, ALLOW_SEG | (REX | REXR) | (F_MODRM | F_MODRM_REG),	                    NO_VEX, NO_EVEX, 1, 1, { 0x0b, 0x00, 0x00 }, 4, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE,             (X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_64,  0, NULL },
{ "or",     2, { R64,      M_ANY   }, GP3, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_REG),				              NO_VEX, NO_EVEX, 1, 1, { 0x0b, 0x00, 0x00 }, 8, 0, MOD_REG_MEM, 0, 0,				          ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_64,  0, NULL },
{ "or",     2, { R64E,     M_ANY   }, GP3, ALLOW_SEG | (REX | REXW | REXR) | (F_MODRM | F_MODRM_REG),	              NO_VEX, NO_EVEX, 1, 1, { 0x0b, 0x00, 0x00 }, 8, 0, MOD_REG_MEM, 0, 0,				          ADDR_SIZE_OVERRIDE,             (X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_64,  0, NULL },
//34 ib XOR AL, imm8
{ "xor",     2, { R8_AL,    IMM8    }, GP0, (F_OPCODE_REG),												                                  NO_VEX, NO_EVEX, 1, 1, { 0x34, 0x00, 0x00 }, 1, 0, NO_MOD,      0, 0,				         0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
//35 iw XOR AX, imm16
//35 id XOR EAX, imm32
//REX.W + 35 id XOR RAX, imm32
{ "xor",     2, { R16_AX,   IMM16   }, GP0, (F_OPCODE_REG),												                                  NO_VEX, NO_EVEX, 1, 1, { 0x35, 0x00, 0x00 }, 2, 0, NO_MOD,      0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "xor",     2, { R32_EAX,  IMM32   }, GP0, (F_OPCODE_REG),												                                  NO_VEX, NO_EVEX, 1, 1, { 0x35, 0x00, 0x00 }, 4, 0, NO_MOD,      0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "xor",     2, { R64_RAX,  IMM32   }, GP3, (REX | REXW) | (F_OPCODE_REG),					                                NO_VEX, NO_EVEX, 1, 1, { 0x35, 0x00, 0x00 }, 4, 0, NO_MOD,      0, 0,				         0,                  (X64), NO_DST,              NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
//80 / 6 ib XOR r / m8, imm8
//REX + 80 / 6 ib XOR r / m8 *, imm8
{ "xor",    2, { R8,       IMM8    }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),		                      NO_VEX, NO_EVEX, 1, 1, { 0x80, 0x06, 0x00 }, 1, 0, MOD_REG_IMM, 0, 0,	               0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "xor",    2, { R8H,      IMM8    }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	                        NO_VEX, NO_EVEX, 1, 1, { 0x80, 0x06, 0x00 }, 1, 0, MOD_REG_IMM, 0, 0,	               0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "xor",    2, { R8U,      IMM8    }, GP3, REX | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),									  NO_VEX, NO_EVEX, 1, 1, { 0x80, 0x06, 0x00 }, 1, 0, MOD_REG_IMM, 0, 0,				         0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
{ "xor",    2, { R8E,      IMM8    }, GP3, (REX | REXB) | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),				  NO_VEX, NO_EVEX, 1, 1, { 0x80, 0x06, 0x00 }, 1, 0, MOD_REG_IMM, 0, 0,				         0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
{ "xor",    2, { M8,       IMM8    }, GP0, ALLOW_SEG | (F_MODRM | OPCODE_EXT | IMM8_ONLY),									        NO_VEX, NO_EVEX, 1, 1, { 0x80, 0x06, 0x00 }, 1, 0, MOD_MEM_IMM, 0, 0,	               ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0,P_86,  0, NULL },
//81 / 6 iw XOR r / m16, imm16
//81 / 6 id XOR r / m32, imm32
//REX.W + 81 / 6 id XOR r / m64, imm32
{ "xor",    2, { R16,      IMM16   }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT),		                                  NO_VEX, NO_EVEX, 1, 1, { 0x81, 0x06, 0x00 }, 2, 0, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "xor",    2, { R16E,     IMM16   }, GP3, (REX | REXB) | (F_MODRM_RM | F_MODRM | OPCODE_EXT),								      NO_VEX, NO_EVEX, 1, 1, { 0x81, 0x06, 0x00 }, 2, 0, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
{ "xor",    2, { M16,      IMM16   }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT),		                                  NO_VEX, NO_EVEX, 1, 1, { 0x81, 0x06, 0x00 }, 2, 0, MOD_MEM_IMM, 0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0, P_86,  0, NULL },
{ "xor",    2, { R32,      IMM32   }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT),		                                  NO_VEX, NO_EVEX, 1, 1, { 0x81, 0x06, 0x00 }, 4, 0, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "xor",    2, { R32E,     IMM32   }, GP3, (REX | REXB) | (F_MODRM_RM | F_MODRM | OPCODE_EXT),								      NO_VEX, NO_EVEX, 1, 1, { 0x81, 0x06, 0x00 }, 4, 0, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
{ "xor",    2, { R32,      IMM16   }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT),		                                  NO_VEX, NO_EVEX, 1, 1, { 0x81, 0x06, 0x00 }, 4, 0, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "xor",    2, { R32E,     IMM16   }, GP3, (REX | REXB) | (F_MODRM_RM | F_MODRM | OPCODE_EXT),								      NO_VEX, NO_EVEX, 1, 1, { 0x81, 0x06, 0x00 }, 4, 0, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
{ "xor",    2, { M32,      IMM32   }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT),		                                  NO_VEX, NO_EVEX, 1, 1, { 0x81, 0x06, 0x00 }, 4, 0, MOD_MEM_IMM, 0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0, P_86,  0, NULL },
{ "xor",    2, { R64,      IMM32   }, GP3, (REX | REXW) | (F_MODRM_RM | F_MODRM | OPCODE_EXT),                      NO_VEX, NO_EVEX, 1, 1, { 0x81, 0x06, 0x00 }, 4, 0, MOD_REG_IMM, 0, 0,	               0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
{ "xor",    2, { R64,      IMM16   }, GP3, (REX | REXW) | (F_MODRM_RM | F_MODRM | OPCODE_EXT),                      NO_VEX, NO_EVEX, 1, 1, { 0x81, 0x06, 0x00 }, 4, 0, MOD_REG_IMM, 0, 0,	               0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
{ "xor",    2, { R64E,     IMM32   }, GP3, (REX | REXW | REXB) | (F_MODRM_RM | F_MODRM | OPCODE_EXT),                      NO_VEX, NO_EVEX, 1, 1, { 0x81, 0x06, 0x00 }, 4, 0, MOD_REG_IMM, 0, 0,	               0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
{ "xor",    2, { R64E,     IMM16   }, GP3, (REX | REXW | REXB) | (F_MODRM_RM | F_MODRM | OPCODE_EXT),                      NO_VEX, NO_EVEX, 1, 1, { 0x81, 0x06, 0x00 }, 4, 0, MOD_REG_IMM, 0, 0,	               0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
{ "xor",    2, { M64,      IMM32   }, GP3, REXW | (F_MODRM_RM | F_MODRM | OPCODE_EXT),		                          NO_VEX, NO_EVEX, 1, 1, { 0x81, 0x06, 0x00 }, 4, 0, MOD_MEM_IMM, 0, 0,	               0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0, P_64,  0, NULL },
//83 / 6 ib XOR r / m16, imm8
//83 / 6 ib XOR r / m32, imm8
//REX.W + 83 / 6 ib XOR r / m64, imm8
{ "xor",    2, { R16,      IMM8    }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	                        NO_VEX, NO_EVEX, 1, 1, { 0x83, 0x06, 0x00 }, 2, 0, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "xor",    2, { R16E,     IMM8    }, GP3, (REX | REXB) | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	        NO_VEX, NO_EVEX, 1, 1, { 0x83, 0x06, 0x00 }, 2, 0, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "xor",    2, { M16,      IMM8    }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	                        NO_VEX, NO_EVEX, 1, 1, { 0x83, 0x06, 0x00 }, 2, 0, MOD_MEM_IMM, 0, OP_SIZE_OVERRIDE, ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0, P_86,  0, NULL },
{ "xor",    2, { R32,      IMM8    }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	                        NO_VEX, NO_EVEX, 1, 1, { 0x83, 0x06, 0x00 }, 4, 0, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "xor",    2, { R32E,     IMM8    }, GP0, (REX | REXB) | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	        NO_VEX, NO_EVEX, 1, 1, { 0x83, 0x06, 0x00 }, 4, 0, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "xor",    2, { M32,      IMM8    }, GP0, ALLOW_SEG | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	            NO_VEX, NO_EVEX, 1, 1, { 0x83, 0x06, 0x00 }, 4, 0, MOD_MEM_IMM, 0, OP_SIZE_OVERRIDE, ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0, P_86,  0, NULL },
{ "xor",    2, { R64,      IMM8    }, GP3, (REX | REXW) | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),          NO_VEX, NO_EVEX, 1, 1, { 0x83, 0x06, 0x00 }, 4, 0, MOD_REG_IMM, 0, 0,	               0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
{ "xor",    2, { R64E,     IMM8    }, GP3, (REX | REXW | REXB) | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),   NO_VEX, NO_EVEX, 1, 1, { 0x83, 0x06, 0x00 }, 4, 0, MOD_REG_IMM, 0, 0,				         0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
{ "xor",    2, { M64,      IMM8    }, GP3, (REX | REXW) | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),		      NO_VEX, NO_EVEX, 1, 1, { 0x83, 0x06, 0x00 }, 4, 0, MOD_MEM_IMM, 0, 0,ADDR_SIZE_OVERRIDE,                             (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0, P_64,  0, NULL },
//30 / r XOR r / m8, r8
//REX + 30 / r XOR r / m8 *, r8*
{ "xor",    2, { M_ANY,    R8      }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                              NO_VEX, NO_EVEX, 1, 1, { 0x30, 0x00, 0x00 }, 1, 0, MOD_MEM_REG, 0, 0,				ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_86,  0, NULL },
{ "xor",    2, { M_ANY,    R8H     }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                              NO_VEX, NO_EVEX, 1, 1, { 0x30, 0x00, 0x00 }, 1, 0, MOD_MEM_REG, 0, 0,				ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_86,  0, NULL },
{ "xor",    2, { M_ANY,    R8E     }, GP3, ALLOW_SEG | (REX | REXR) | (F_MODRM | F_MODRM_REG),	                    NO_VEX, NO_EVEX, 1, 1, { 0x30, 0x00, 0x00 }, 1, 0, MOD_MEM_REG, 0, 0,				ADDR_SIZE_OVERRIDE,             (X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_64,  0, NULL },
{ "xor",    2, { M_ANY,    R8U     }, GP3, ALLOW_SEG | (REX) | (F_MODRM | F_MODRM_REG),						                  NO_VEX, NO_EVEX, 1, 1, { 0x30, 0x00, 0x00 }, 1, 0, MOD_MEM_REG, 0, 0,				ADDR_SIZE_OVERRIDE,             (X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_64,  0, NULL },
//31 / r XOR r / m16, r16
//31 / r XOR r / m32, r32
//REX.W + 31 / r XOR r / m64, r64
{ "xor",     2, { M_ANY,    R16     }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                            NO_VEX, NO_EVEX, 1, 1, { 0x31, 0x00, 0x00 }, 2, 0, MOD_MEM_REG, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_86,  0, NULL },
{ "xor",     2, { M_ANY,    R16E    }, GP3, ALLOW_SEG | (REX | REXR) | (F_MODRM | F_MODRM_REG),	                    NO_VEX, NO_EVEX, 1, 1, { 0x31, 0x00, 0x00 }, 2, 0, MOD_MEM_REG, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE,             (X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_64,  0, NULL },
{ "xor",     2, { M_ANY,    R32     }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                            NO_VEX, NO_EVEX, 1, 1, { 0x31, 0x00, 0x00 }, 4, 0, MOD_MEM_REG, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_86,  0, NULL },
{ "xor",     2, { M_ANY,    R32E    }, GP3, ALLOW_SEG | (REX | REXR) | (F_MODRM | F_MODRM_REG),	                    NO_VEX, NO_EVEX, 1, 1, { 0x31, 0x00, 0x00 }, 4, 0, MOD_MEM_REG, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE,             (X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_64,  0, NULL },
{ "xor",     2, { M_ANY,    R64     }, GP3, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_REG),			                NO_VEX, NO_EVEX, 1, 1, { 0x31, 0x00, 0x00 }, 8, 0, MOD_MEM_REG, 0, 0,				          ADDR_SIZE_OVERRIDE,             (X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_64,  0, NULL },
{ "xor",     2, { M_ANY,    R64E    }, GP3, ALLOW_SEG | (REX | REXW | REXR) | (F_MODRM | F_MODRM_REG),	            NO_VEX, NO_EVEX, 1, 1, { 0x31, 0x00, 0x00 }, 8, 0, MOD_MEM_REG, 0, 0,				          ADDR_SIZE_OVERRIDE,             (X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_64,  0, NULL },
//32 / r XOR r8, r / m8
//REX + 32 / r XOR r8*, r / m8 *
{ "xor",     2, { R8,       R8      }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT | IMM8_ONLY),          NO_VEX, NO_EVEX, 1, 1, { 0x32, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                  (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "xor",     2, { R8,       R8H     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT | IMM8_ONLY),		      NO_VEX, NO_EVEX, 1, 1, { 0x32, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                  (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "xor",     2, { R8H,      R8      }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT | IMM8_ONLY),		      NO_VEX, NO_EVEX, 1, 1, { 0x32, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                  (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "xor",     2, { R8H,      R8H     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT | IMM8_ONLY),		      NO_VEX, NO_EVEX, 1, 1, { 0x32, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                  (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "xor",     2, { R8E,      R8E     }, GP3, (REX | REXB | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),	            NO_VEX, NO_EVEX, 1, 1, { 0x32, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                              (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "xor",     2, { R8,       R8E     }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				            NO_VEX, NO_EVEX, 1, 1, { 0x32, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                              (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "xor",     2, { R8E,      R8      }, GP3, (REX | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				            NO_VEX, NO_EVEX, 1, 1, { 0x32, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                              (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "xor",     2, { R8U,      R8      }, GP3, (REX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),					                  NO_VEX, NO_EVEX, 1, 1, { 0x32, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                              (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "xor",     2, { R8U,      R8E     }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),					          NO_VEX, NO_EVEX, 1, 1, { 0x32, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                              (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "xor",     2, { R8,       R8U     }, GP3, (REX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),					                  NO_VEX, NO_EVEX, 1, 1, { 0x32, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                              (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "xor",     2, { R8,       M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                            NO_VEX, NO_EVEX, 1, 1, { 0x32, 0x00, 0x00 }, 1, 0, MOD_REG_MEM, 0, 0, ADDR_SIZE_OVERRIDE,                (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_86,  0, NULL },
{ "xor",     2, { R8H,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                            NO_VEX, NO_EVEX, 1, 1, { 0x32, 0x00, 0x00 }, 1, 0, MOD_REG_MEM, 0, 0,	ADDR_SIZE_OVERRIDE,                (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_86,  0, NULL },
{ "xor",     2, { R8E,      M_ANY   }, GP3, ALLOW_SEG | (REX | REXR) | (F_MODRM | F_MODRM_REG),	                    NO_VEX, NO_EVEX, 1, 1, { 0x32, 0x00, 0x00 }, 1, 0, MOD_REG_MEM, 0, 0,	ADDR_SIZE_OVERRIDE,                            (X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_64,  0, NULL },
{ "xor",     2, { R8U,      M_ANY   }, GP3, ALLOW_SEG | (REX) | (F_MODRM | F_MODRM_REG),						                NO_VEX, NO_EVEX, 1, 1, { 0x32, 0x00, 0x00 }, 1, 0, MOD_REG_MEM, 0, 0,	ADDR_SIZE_OVERRIDE,                            (X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_64,  0, NULL },
//33 / r XOR r16, r / m16
//33 / r XOR r32, r / m32
//REX.W + 33 / r XOR r64, r / m64
{ "xor",     2, { R16,      R16     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                      NO_VEX, NO_EVEX, 1, 1, { 0x33, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                   (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "xor",     2, { R16E,     R16E    }, GP3, (REX | REXB | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),             NO_VEX, NO_EVEX, 1, 1, { 0x33, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "xor",     2, { R16E,     R16     }, GP3, (REX | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				            NO_VEX, NO_EVEX, 1, 1, { 0x33, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "xor",     2, { R16,      R16E    }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				            NO_VEX, NO_EVEX, 1, 1, { 0x33, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "xor",     2, { R32,      R32     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                      NO_VEX, NO_EVEX, 1, 1, { 0x33, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, 0,                0,                   (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "xor",     2, { R32E,     R32E    }, GP3, (REX | REXB | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),	            NO_VEX, NO_EVEX, 1, 1, { 0x33, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, 0,                0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "xor",     2, { R32E,     R32     }, GP3, (REX | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				            NO_VEX, NO_EVEX, 1, 1, { 0x33, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, 0,                0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "xor",     2, { R32,      R32E    }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				            NO_VEX, NO_EVEX, 1, 1, { 0x33, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, 0,                0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "xor",     2, { R64,      R64     }, GP3, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		                NO_VEX, NO_EVEX, 1, 1, { 0x33, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "xor",     2, { R64E,     R64E    }, GP3, (REX | REXR | REXB | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),      NO_VEX, NO_EVEX, 1, 1, { 0x33, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "xor",     2, { R64,      R64E    }, GP3, (REX | REXB | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		          NO_VEX, NO_EVEX, 1, 1, { 0x33, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "xor",     2, { R64E,     R64     }, GP3, (REX | REXR | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		          NO_VEX, NO_EVEX, 1, 1, { 0x33, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "xor",     2, { R16,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                            NO_VEX, NO_EVEX, 1, 1, { 0x33, 0x00, 0x00 }, 2, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE, 0,                   (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_86,  0, NULL },
{ "xor",     2, { R16E,     M_ANY   }, GP3, ALLOW_SEG | (REX | REXR) | (F_MODRM | F_MODRM_REG),	                    NO_VEX, NO_EVEX, 1, 1, { 0x33, 0x00, 0x00 }, 2, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE,             (X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_64,  0, NULL },
{ "xor",     2, { R32,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                            NO_VEX, NO_EVEX, 1, 1, { 0x33, 0x00, 0x00 }, 4, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_86,  0, NULL },
{ "xor",     2, { R32E,     M_ANY   }, GP3, ALLOW_SEG | (REX | REXR) | (F_MODRM | F_MODRM_REG),	                    NO_VEX, NO_EVEX, 1, 1, { 0x33, 0x00, 0x00 }, 4, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE,             (X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_64,  0, NULL },
{ "xor",     2, { R64,      M_ANY   }, GP3, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_REG),				              NO_VEX, NO_EVEX, 1, 1, { 0x33, 0x00, 0x00 }, 8, 0, MOD_REG_MEM, 0, 0,				          ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_64,  0, NULL },
{ "xor",     2, { R64E,     M_ANY   }, GP3, ALLOW_SEG | (REX | REXW | REXR) | (F_MODRM | F_MODRM_REG),	            NO_VEX, NO_EVEX, 1, 1, { 0x33, 0x00, 0x00 }, 8, 0, MOD_REG_MEM, 0, 0,				          ADDR_SIZE_OVERRIDE,             (X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_64,  0, NULL },

//24 ib AND AL, imm8 I Valid Valid AND imm8 to AL.
{ "and",    2, { R8_AL,    IMM8    }, GP0, (F_OPCODE_REG),												                                  NO_VEX, NO_EVEX, 1, 1, { 0x24, 0x00, 0x00 }, 1, 0, NO_MOD,      0, 0,				         0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
//25 iw AND AX, imm16 I Valid Valid AND imm16 to AX.
//25 id AND EAX, imm32 I Valid Valid AND imm32 to EAX.
//REX.W + 25 id AND RAX, imm32 I Valid N.E.AND imm32 sign extended to 64 - bits to RAX.
{ "and",    2, { R16_AX,   IMM16   }, GP0, (F_OPCODE_REG),												                                  NO_VEX, NO_EVEX, 1, 1, { 0x25, 0x00, 0x00 }, 2, 0, NO_MOD,      0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "and",    2, { R32_EAX,  IMM32   }, GP0, (F_OPCODE_REG),												                                  NO_VEX, NO_EVEX, 1, 1, { 0x25, 0x00, 0x00 }, 4, 0, NO_MOD,      0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "and",    2, { R64_RAX,  IMM32   }, GP3, (REX | REXW) | (F_OPCODE_REG),						                                NO_VEX, NO_EVEX, 1, 1, { 0x25, 0x00, 0x00 }, 4, 0, NO_MOD,      0, 0,				         0,                              (X64), NO_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
//80 / 2 ib AND r / m8, imm8 MI Valid Valid AND imm8 to r / m8.
//REX + 80 / 2 ib AND r / m8 * , imm8 MI Valid N.E.AND imm8 to r / m8.
{ "and",    2, { R8,       IMM8    }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),		                      NO_VEX, NO_EVEX, 1, 1, { 0x80, 0x04, 0x00 }, 1, 0, MOD_REG_IMM, 0, 0,	               0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "and",    2, { R8H,      IMM8    }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	                        NO_VEX, NO_EVEX, 1, 1, { 0x80, 0x04, 0x00 }, 1, 0, MOD_REG_IMM, 0, 0,	               0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "and",    2, { R8U,      IMM8    }, GP3, REX | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),									  NO_VEX, NO_EVEX, 1, 1, { 0x80, 0x04, 0x00 }, 1, 0, MOD_REG_IMM, 0, 0,				         0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
{ "and",    2, { R8E,      IMM8    }, GP3, (REX | REXB) | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),				  NO_VEX, NO_EVEX, 1, 1, { 0x80, 0x04, 0x00 }, 1, 0, MOD_REG_IMM, 0, 0,				         0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
{ "and",    2, { M8,       IMM8    }, GP0, ALLOW_SEG | (F_MODRM | OPCODE_EXT | IMM8_ONLY),									        NO_VEX, NO_EVEX, 1, 1, { 0x80, 0x04, 0x00 }, 1, 0, MOD_MEM_IMM, 0, 0,	               ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0,P_86,  0, NULL },
{ "and",    2, { M_ANY,    IMM8    }, GP0, ALLOW_SEG | (F_MODRM | OPCODE_EXT | IMM8_ONLY),									        NO_VEX, NO_EVEX, 1, 1, { 0x80, 0x04, 0x00 }, 1, 0, MOD_MEM_IMM, 0, 0,	               ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0,P_86,  0, NULL },
//83 / 2 ib AND r / m16, imm8 MI Valid Valid AND with CF sign - extended imm8 to r / m16.
//83 / 2 ib AND r / m32, imm8 MI Valid Valid AND with CF sign - extended imm8 into r / m32.
//REX.W + 83 / 2 ib AND r / m64, imm8 MI Valid N.E.AND with CF sign - extended imm8 into r / m64.
{ "and",    2, { R16,      IMM8    }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	                        NO_VEX, NO_EVEX, 1, 1, { 0x83, 0x04, 0x00 }, 2, 0, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "and",    2, { R16E,     IMM8    }, GP0, (REX | REXB) | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	        NO_VEX, NO_EVEX, 1, 1, { 0x83, 0x04, 0x00 }, 2, 0, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "and",    2, { M16,      IMM8    }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	                        NO_VEX, NO_EVEX, 1, 1, { 0x83, 0x04, 0x00 }, 2, 0, MOD_MEM_IMM, 0, OP_SIZE_OVERRIDE, ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0, P_86,  0, NULL },
{ "and",    2, { M_ANY,    IMM8    }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	                        NO_VEX, NO_EVEX, 1, 1, { 0x83, 0x04, 0x00 }, 2, 0, MOD_MEM_IMM, 0, OP_SIZE_OVERRIDE, ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0, P_86,  0, NULL },
{ "and",    2, { R32,      IMM8    }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	                        NO_VEX, NO_EVEX, 1, 1, { 0x83, 0x04, 0x00 }, 4, 0, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "and",    2, { R32E,     IMM8    }, GP3, (REX | REXB) | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	        NO_VEX, NO_EVEX, 1, 1, { 0x83, 0x04, 0x00 }, 4, 0, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "and",    2, { M32,      IMM8    }, GP0, ALLOW_SEG | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	            NO_VEX, NO_EVEX, 1, 1, { 0x83, 0x04, 0x00 }, 4, 0, MOD_MEM_IMM, 0, OP_SIZE_OVERRIDE, ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0, P_86,  0, NULL },
{ "and",    2, { M_ANY,    IMM8    }, GP0, ALLOW_SEG | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	            NO_VEX, NO_EVEX, 1, 1, { 0x83, 0x04, 0x00 }, 4, 0, MOD_MEM_IMM, 0, OP_SIZE_OVERRIDE, ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0, P_86,  0, NULL },
{ "and",    2, { R64,      IMM8    }, GP3, (REX | REXW) | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),          NO_VEX, NO_EVEX, 1, 1, { 0x83, 0x04, 0x00 }, 4, 0, MOD_REG_IMM, 0, 0,	               0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
{ "and",    2, { R64E,     IMM8    }, GP3, (REX | REXW | REXB) | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),   NO_VEX, NO_EVEX, 1, 1, { 0x83, 0x04, 0x00 }, 4, 0, MOD_REG_IMM, 0, 0,				         0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
{ "and",    2, { M64,      IMM8    }, GP3, (REX | REXW) | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),		      NO_VEX, NO_EVEX, 1, 1, { 0x83, 0x04, 0x00 }, 4, 0, MOD_MEM_IMM, 0, 0,ADDR_SIZE_OVERRIDE,                             (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0, P_64,  0, NULL },
{ "and",    2, { M_ANY,    IMM8    }, GP3, (REX | REXW) | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),		      NO_VEX, NO_EVEX, 1, 1, { 0x83, 0x04, 0x00 }, 4, 0, MOD_MEM_IMM, 0, 0,ADDR_SIZE_OVERRIDE,                             (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0, P_64,  0, NULL },
//81 / 2 iw AND r / m16, imm16 MI Valid Valid AND imm16 to r / m16.
//81 / 2 id AND r / m32, imm32 MI Valid Valid AND with CF imm32 to r / m32.
//REX.W + 81 / 2 id AND r / m64, imm32 MI Valid N.E.AND with CF imm32 sign extended to 64 - bits to r / m64.
{ "and",    2, { R16,      IMM16   }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT),		                                  NO_VEX, NO_EVEX, 1, 1, { 0x81, 0x04, 0x00 }, 2, 0, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "and",    2, { R16E,     IMM16   }, GP3, (REX | REXB) | (F_MODRM_RM | F_MODRM | OPCODE_EXT),								      NO_VEX, NO_EVEX, 1, 1, { 0x81, 0x04, 0x00 }, 2, 0, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
{ "and",    2, { M16,      IMM16   }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT),		                                  NO_VEX, NO_EVEX, 1, 1, { 0x81, 0x04, 0x00 }, 2, 0, MOD_MEM_IMM, 0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0, P_86,  0, NULL },
{ "and",    2, { M_ANY,    IMM16   }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT),		                                  NO_VEX, NO_EVEX, 1, 1, { 0x81, 0x04, 0x00 }, 2, 0, MOD_MEM_IMM, 0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0, P_86,  0, NULL },
{ "and",    2, { R32,      IMM32   }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT),		                                  NO_VEX, NO_EVEX, 1, 1, { 0x81, 0x04, 0x00 }, 4, 0, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "and",    2, { R32E,     IMM32   }, GP3, (REX | REXB) | (F_MODRM_RM | F_MODRM | OPCODE_EXT),								      NO_VEX, NO_EVEX, 1, 1, { 0x81, 0x04, 0x00 }, 4, 0, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
{ "and",    2, { R32,      IMM16   }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT),		                                  NO_VEX, NO_EVEX, 1, 1, { 0x81, 0x04, 0x00 }, 4, 0, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "and",    2, { R32E,     IMM16   }, GP3, (REX | REXB) | (F_MODRM_RM | F_MODRM | OPCODE_EXT),								      NO_VEX, NO_EVEX, 1, 1, { 0x81, 0x04, 0x00 }, 4, 0, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
{ "and",    2, { M32,      IMM32   }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT),		                                  NO_VEX, NO_EVEX, 1, 1, { 0x81, 0x04, 0x00 }, 4, 0, MOD_MEM_IMM, 0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0, P_86,  0, NULL },
{ "and",    2, { M_ANY,    IMM32   }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT),		                                  NO_VEX, NO_EVEX, 1, 1, { 0x81, 0x04, 0x00 }, 4, 0, MOD_MEM_IMM, 0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0, P_86,  0, NULL },
{ "and",    2, { R64,      IMM32   }, GP3, (REX | REXW) | (F_MODRM_RM | F_MODRM | OPCODE_EXT),                      NO_VEX, NO_EVEX, 1, 1, { 0x81, 0x04, 0x00 }, 4, 0, MOD_REG_IMM, 0, 0,	               0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
{ "and",    2, { R64,      IMM16   }, GP3, (REX | REXW) | (F_MODRM_RM | F_MODRM | OPCODE_EXT),                      NO_VEX, NO_EVEX, 1, 1, { 0x81, 0x04, 0x00 }, 4, 0, MOD_REG_IMM, 0, 0,	               0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
{ "and",    2, { R64E,     IMM32   }, GP3, (REX | REXW | REXB) | (F_MODRM_RM | F_MODRM | OPCODE_EXT),               NO_VEX, NO_EVEX, 1, 1, { 0x81, 0x04, 0x00 }, 4, 0, MOD_REG_IMM, 0, 0,	               0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
{ "and",    2, { R64E,     IMM16   }, GP3, (REX | REXW | REXB) | (F_MODRM_RM | F_MODRM | OPCODE_EXT),               NO_VEX, NO_EVEX, 1, 1, { 0x81, 0x04, 0x00 }, 4, 0, MOD_REG_IMM, 0, 0,	               0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
{ "and",    2, { M64,      IMM32   }, GP3, REXW | (F_MODRM_RM | F_MODRM | OPCODE_EXT),		                          NO_VEX, NO_EVEX, 1, 1, { 0x81, 0x04, 0x00 }, 4, 0, MOD_MEM_IMM, 0, 0,	               0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0, P_64,  0, NULL },
{ "and",    2, { M_ANY,    IMM32   }, GP3, REXW | (F_MODRM_RM | F_MODRM | OPCODE_EXT),		                          NO_VEX, NO_EVEX, 1, 1, { 0x81, 0x04, 0x00 }, 4, 0, MOD_MEM_IMM, 0, 0,	               0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0, P_64,  0, NULL },
//20 / r AND r / m8, r8 MR Valid Valid AND byte register to r / m8.
//REX + 20 / r AND r / m8 * , r8* MR Valid N.E.AND byte register to r / m64.
{ "and",    2, { M_ANY,    R8      }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                              NO_VEX, NO_EVEX, 1, 1, { 0x20, 0x00, 0x00 }, 1, 0, MOD_MEM_REG, 0, 0,				ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_86,  0, NULL },
{ "and",    2, { M_ANY,    R8H     }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                              NO_VEX, NO_EVEX, 1, 1, { 0x20, 0x00, 0x00 }, 1, 0, MOD_MEM_REG, 0, 0,				ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_86,  0, NULL },
{ "and",    2, { M_ANY,    R8E     }, GP3, ALLOW_SEG | (REX | REXR) | (F_MODRM | F_MODRM_REG),	                    NO_VEX, NO_EVEX, 1, 1, { 0x20, 0x00, 0x00 }, 1, 0, MOD_MEM_REG, 0, 0,				ADDR_SIZE_OVERRIDE,             (X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_64,  0, NULL },
{ "and",    2, { M_ANY,    R8U     }, GP3, ALLOW_SEG | (REX) | (F_MODRM | F_MODRM_REG),						                  NO_VEX, NO_EVEX, 1, 1, { 0x20, 0x00, 0x00 }, 1, 0, MOD_MEM_REG, 0, 0,				ADDR_SIZE_OVERRIDE,             (X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_64,  0, NULL },
//21 / r AND r / m16, r16 MR Valid Valid AND r16 to r / m16.
//21 / r AND r / m32, r32 MR Valid Valid AND with CF r32 to r / m32.
//REX.W + 21 / r AND r / m64, r64 MR Valid N.E.AND with CF r64 to r / m64.
{ "and",     2, { M_ANY,    R16     }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                            NO_VEX, NO_EVEX, 1, 1, { 0x21, 0x00, 0x00 }, 2, 0, MOD_MEM_REG, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_86,  0, NULL },
{ "and",     2, { M_ANY,    R16E    }, GP3, ALLOW_SEG | (REX | REXR) | (F_MODRM | F_MODRM_REG),	                    NO_VEX, NO_EVEX, 1, 1, { 0x21, 0x00, 0x00 }, 2, 0, MOD_MEM_REG, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE,             (X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_64,  0, NULL },
{ "and",     2, { M_ANY,    R32     }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                            NO_VEX, NO_EVEX, 1, 1, { 0x21, 0x00, 0x00 }, 4, 0, MOD_MEM_REG, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_86,  0, NULL },
{ "and",     2, { M_ANY,    R32E    }, GP3, ALLOW_SEG | (REX | REXR) | (F_MODRM | F_MODRM_REG),	                    NO_VEX, NO_EVEX, 1, 1, { 0x21, 0x00, 0x00 }, 4, 0, MOD_MEM_REG, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE,             (X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_64,  0, NULL },
{ "and",     2, { M_ANY,    R64     }, GP3, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_REG),			                NO_VEX, NO_EVEX, 1, 1, { 0x21, 0x00, 0x00 }, 8, 0, MOD_MEM_REG, 0, 0,				          ADDR_SIZE_OVERRIDE,             (X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_64,  0, NULL },
{ "and",     2, { M_ANY,    R64E    }, GP3, ALLOW_SEG | (REX | REXW | REXR) | (F_MODRM | F_MODRM_REG),	            NO_VEX, NO_EVEX, 1, 1, { 0x21, 0x00, 0x00 }, 8, 0, MOD_MEM_REG, 0, 0,				          ADDR_SIZE_OVERRIDE,             (X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_64,  0, NULL },
//22 / r AND r8, r / m8 RM Valid Valid AND r / m8 to byte register.
//REX + 22 / r AND r8*, r / m8 * RM Valid N.E.AND r / m64 to byte register.
{ "and",     2, { R8,       R8      }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT | IMM8_ONLY),          NO_VEX, NO_EVEX, 1, 1, { 0x22, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                  (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "and",     2, { R8,       R8H     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT | IMM8_ONLY),		      NO_VEX, NO_EVEX, 1, 1, { 0x22, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                  (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "and",     2, { R8H,      R8      }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT | IMM8_ONLY),		      NO_VEX, NO_EVEX, 1, 1, { 0x22, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                  (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "and",     2, { R8H,      R8H     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT | IMM8_ONLY),		      NO_VEX, NO_EVEX, 1, 1, { 0x22, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                  (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "and",     2, { R8E,      R8E     }, GP3, (REX | REXB | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),	            NO_VEX, NO_EVEX, 1, 1, { 0x22, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                              (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "and",     2, { R8,       R8E     }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				            NO_VEX, NO_EVEX, 1, 1, { 0x22, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                              (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "and",     2, { R8E,      R8      }, GP3, (REX | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				            NO_VEX, NO_EVEX, 1, 1, { 0x22, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                              (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "and",     2, { R8U,      R8      }, GP3, (REX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),					                  NO_VEX, NO_EVEX, 1, 1, { 0x22, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                              (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "and",     2, { R8U,      R8E     }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),					          NO_VEX, NO_EVEX, 1, 1, { 0x22, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                              (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "and",     2, { R8,       R8U     }, GP3, (REX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),					                  NO_VEX, NO_EVEX, 1, 1, { 0x22, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                              (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "and",     2, { R8,       M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                            NO_VEX, NO_EVEX, 1, 1, { 0x22, 0x00, 0x00 }, 1, 0, MOD_REG_MEM, 0, 0, ADDR_SIZE_OVERRIDE,                (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_86,  0, NULL },
{ "and",     2, { R8H,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                            NO_VEX, NO_EVEX, 1, 1, { 0x22, 0x00, 0x00 }, 1, 0, MOD_REG_MEM, 0, 0,	ADDR_SIZE_OVERRIDE,                (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_86,  0, NULL },
{ "and",     2, { R8E,      M_ANY   }, GP3, ALLOW_SEG | (REX | REXR) | (F_MODRM | F_MODRM_REG),	                    NO_VEX, NO_EVEX, 1, 1, { 0x22, 0x00, 0x00 }, 1, 0, MOD_REG_MEM, 0, 0,	ADDR_SIZE_OVERRIDE,                            (X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_64,  0, NULL },
{ "and",     2, { R8U,      M_ANY   }, GP3, ALLOW_SEG | (REX) | (F_MODRM | F_MODRM_REG),						                NO_VEX, NO_EVEX, 1, 1, { 0x22, 0x00, 0x00 }, 1, 0, MOD_REG_MEM, 0, 0,	ADDR_SIZE_OVERRIDE,                            (X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_64,  0, NULL },
//2and3 / r AND r16, r / m16 RM Valid Valid AND r / m16 to r16.
//23 / r AND r32, r / m32 RM Valid Valid AND with CF r / m32 to r32.
//REX.W + 23 / r AND r64, r / m64 RM Valid N.E.AND with CF r / m64 to r64. 
{ "and",     2, { R16,      R16     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                      NO_VEX, NO_EVEX, 1, 1, { 0x23, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                   (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "and",     2, { R16E,     R16E    }, GP3, (REX | REXB | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),             NO_VEX, NO_EVEX, 1, 1, { 0x23, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "and",     2, { R16E,     R16     }, GP3, (REX | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				            NO_VEX, NO_EVEX, 1, 1, { 0x23, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "and",     2, { R16,      R16E    }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				            NO_VEX, NO_EVEX, 1, 1, { 0x23, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "and",     2, { R32,      R32     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                      NO_VEX, NO_EVEX, 1, 1, { 0x23, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, 0,                0,                   (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "and",     2, { R32E,     R32E    }, GP3, (REX | REXB | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),	            NO_VEX, NO_EVEX, 1, 1, { 0x23, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, 0,                0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "and",     2, { R32E,     R32     }, GP3, (REX | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				            NO_VEX, NO_EVEX, 1, 1, { 0x23, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, 0,                0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "and",     2, { R32,      R32E    }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				            NO_VEX, NO_EVEX, 1, 1, { 0x23, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, 0,                0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "and",     2, { R64,      R64     }, GP3, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		                NO_VEX, NO_EVEX, 1, 1, { 0x23, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "and",     2, { R64E,     R64E    }, GP3, (REX | REXR | REXB | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),      NO_VEX, NO_EVEX, 1, 1, { 0x23, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "and",     2, { R64,      R64E    }, GP3, (REX | REXB | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		          NO_VEX, NO_EVEX, 1, 1, { 0x23, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "and",     2, { R64E,     R64     }, GP3, (REX | REXR | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		          NO_VEX, NO_EVEX, 1, 1, { 0x23, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "and",     2, { R16,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                            NO_VEX, NO_EVEX, 1, 1, { 0x23, 0x00, 0x00 }, 2, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE, 0,                   (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_86,  0, NULL },
{ "and",     2, { R16E,     M_ANY   }, GP3, ALLOW_SEG | (REX | REXR) | (F_MODRM | F_MODRM_REG),	                    NO_VEX, NO_EVEX, 1, 1, { 0x23, 0x00, 0x00 }, 2, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE,             (X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_64,  0, NULL },
{ "and",     2, { R32,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                            NO_VEX, NO_EVEX, 1, 1, { 0x23, 0x00, 0x00 }, 4, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_86,  0, NULL },
{ "and",     2, { R32E,     M_ANY   }, GP3, ALLOW_SEG | (REX | REXR) | (F_MODRM | F_MODRM_REG),	                    NO_VEX, NO_EVEX, 1, 1, { 0x23, 0x00, 0x00 }, 4, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE,             (X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_64,  0, NULL },
{ "and",     2, { R64,      M_ANY   }, GP3, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_REG),				              NO_VEX, NO_EVEX, 1, 1, { 0x23, 0x00, 0x00 }, 8, 0, MOD_REG_MEM, 0, 0,				          ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_64,  0, NULL },
{ "and",     2, { R64E,     M_ANY   }, GP3, ALLOW_SEG | (REX | REXW | REXR) | (F_MODRM | F_MODRM_REG),	            NO_VEX, NO_EVEX, 1, 1, { 0x23, 0x00, 0x00 }, 8, 0, MOD_REG_MEM, 0, 0,				          ADDR_SIZE_OVERRIDE,             (X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_64,  0, NULL },
//1C ib SBB AL, imm8
{ "sbb",    2, { R8_AL,    IMM8    }, GP0, (F_OPCODE_REG),												                                  NO_VEX, NO_EVEX, 1, 1, { 0x1c, 0x00, 0x00 }, 1, 0, NO_MOD,      0, 0,				         0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
//1D iw SBB AX, imm16
//1D id SBB EAX, imm32
//REX.W + 1D id SBB RAX, imm32
{ "sbb",    2, { R16_AX,   IMM16   }, GP0, (F_OPCODE_REG),												                                  NO_VEX, NO_EVEX, 1, 1, { 0x1d, 0x00, 0x00 }, 2, 0, NO_MOD,      0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "sbb",    2, { R32_EAX,  IMM32   }, GP0, (F_OPCODE_REG),												                                  NO_VEX, NO_EVEX, 1, 1, { 0x1d, 0x00, 0x00 }, 4, 0, NO_MOD,      0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "sbb",    2, { R64_RAX,  IMM32   }, GP3, (REX | REXW) | (F_OPCODE_REG),						                                NO_VEX, NO_EVEX, 1, 1, { 0x1d, 0x00, 0x00 }, 4, 0, NO_MOD,      0, 0,				         0,                  (X64), NO_DST,              NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
//80 / 3 ib SBB r / m8, imm8
//REX + 80 / 3 ib SBB r / m8 *, imm8
{ "sbb",     2, { R8,       IMM8    }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),		                    NO_VEX, NO_EVEX, 1, 1, { 0x80, 0x03, 0x00 }, 1, 0, MOD_REG_IMM, 0, 0,	               0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "sbb",     2, { R8H,      IMM8    }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	                      NO_VEX, NO_EVEX, 1, 1, { 0x80, 0x03, 0x00 }, 1, 0, MOD_REG_IMM, 0, 0,	               0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "sbb",     2, { R8U,      IMM8    }, GP3, REX | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),					        NO_VEX, NO_EVEX, 1, 1, { 0x80, 0x03, 0x00 }, 1, 0, MOD_REG_IMM, 0, 0,				         0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
{ "sbb",     2, { R8E,      IMM8    }, GP3, (REX | REXB) | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),         NO_VEX, NO_EVEX, 1, 1, { 0x80, 0x03, 0x00 }, 1, 0, MOD_REG_IMM, 0, 0,				         0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
{ "sbb",     2, { M8,       IMM8    }, GP3, ALLOW_SEG | (F_MODRM | OPCODE_EXT | IMM8_ONLY),									        NO_VEX, NO_EVEX, 1, 1, { 0x80, 0x03, 0x00 }, 1, 0, MOD_MEM_IMM, 0, 0,	               ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0,P_86,  0, NULL },
//81 / 3 iw SBB r / m16, imm16
//81 / 3 id SBB r / m32, imm32
//REX.W + 81 / 3 id SBB r / m64, imm32
{ "sbb",    2, { R16,      IMM16   }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT),		                                  NO_VEX, NO_EVEX, 1, 1, { 0x81, 0x03, 0x00 }, 2, 0, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "sbb",    2, { R16E,     IMM16   }, GP3, (REX | REXB) | (F_MODRM_RM | F_MODRM | OPCODE_EXT),                      NO_VEX, NO_EVEX, 1, 1, { 0x81, 0x03, 0x00 }, 2, 0, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
{ "sbb",    2, { M16,      IMM16   }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT),		                                  NO_VEX, NO_EVEX, 1, 1, { 0x81, 0x03, 0x00 }, 2, 0, MOD_MEM_IMM, 0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0, P_86,  0, NULL },
{ "sbb",    2, { R32,      IMM32   }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT),		                                  NO_VEX, NO_EVEX, 1, 1, { 0x81, 0x03, 0x00 }, 4, 0, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "sbb",    2, { R32E,     IMM32   }, GP3, (REX | REXB) | (F_MODRM_RM | F_MODRM | OPCODE_EXT),								      NO_VEX, NO_EVEX, 1, 1, { 0x81, 0x03, 0x00 }, 4, 0, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                               (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
{ "sbb",    2, { R32,      IMM16   }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT),		                                  NO_VEX, NO_EVEX, 1, 1, { 0x81, 0x03, 0x00 }, 4, 0, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "sbb",    2, { R32E,     IMM16   }, GP3, (REX | REXB) | (F_MODRM_RM | F_MODRM | OPCODE_EXT),								      NO_VEX, NO_EVEX, 1, 1, { 0x81, 0x03, 0x00 }, 4, 0, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                               (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
{ "sbb",    2, { M32,      IMM32   }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT),		                                  NO_VEX, NO_EVEX, 1, 1, { 0x81, 0x03, 0x00 }, 4, 0, MOD_MEM_IMM, 0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0, P_86,  0, NULL },
{ "sbb",    2, { R64,      IMM32   }, GP3, (REX | REXW) | (F_MODRM_RM | F_MODRM | OPCODE_EXT),                      NO_VEX, NO_EVEX, 1, 1, { 0x81, 0x03, 0x00 }, 4, 0, MOD_REG_IMM, 0, 0,	               0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
{ "sbb",    2, { R64,      IMM16   }, GP3, (REX | REXW) | (F_MODRM_RM | F_MODRM | OPCODE_EXT),                      NO_VEX, NO_EVEX, 1, 1, { 0x81, 0x03, 0x00 }, 4, 0, MOD_REG_IMM, 0, 0,	               0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
{ "sbb",    2, { R64E,     IMM16   }, GP3, (REX | REXW | REXB) | (F_MODRM_RM | F_MODRM | OPCODE_EXT),                      NO_VEX, NO_EVEX, 1, 1, { 0x81, 0x03, 0x00 }, 4, 0, MOD_REG_IMM, 0, 0,	               0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
{ "sbb",    2, { R64E,     IMM32   }, GP3, (REX | REXW | REXB) | (F_MODRM_RM | F_MODRM | OPCODE_EXT),                      NO_VEX, NO_EVEX, 1, 1, { 0x81, 0x03, 0x00 }, 4, 0, MOD_REG_IMM, 0, 0,	               0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
{ "sbb",    2, { M64,      IMM32   }, GP3, REXW | (F_MODRM_RM | F_MODRM | OPCODE_EXT),		                          NO_VEX, NO_EVEX, 1, 1, { 0x81, 0x03, 0x00 }, 4, 0, MOD_MEM_IMM, 0, 0,	               0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0, P_64,  0, NULL },
//83 / 3 ib SBB r / m16, imm8
//83 / 3 ib SBB r / m32, imm8
//REX.W + 83 / 3 ib SBB r / m64, imm8
{ "sbb",    2, { R16,      IMM8    }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	                         NO_VEX, NO_EVEX, 1, 1, { 0x83, 0x03, 0x00 }, 2, 0, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "sbb",    2, { R16E,     IMM8    }, GP3, (REX | REXB) | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	         NO_VEX, NO_EVEX, 1, 1, { 0x83, 0x03, 0x00 }, 2, 0, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
{ "sbb",    2, { M16,      IMM8    }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	                         NO_VEX, NO_EVEX, 1, 1, { 0x83, 0x03, 0x00 }, 2, 0, MOD_MEM_IMM, 0, OP_SIZE_OVERRIDE, ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0, P_86,  0, NULL },
{ "sbb",    2, { R32,      IMM8    }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	                         NO_VEX, NO_EVEX, 1, 1, { 0x83, 0x03, 0x00 }, 4, 0, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "sbb",    2, { R32E,     IMM8    }, GP3, (REX | REXB) | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	         NO_VEX, NO_EVEX, 1, 1, { 0x83, 0x03, 0x00 }, 4, 0, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "sbb",    2, { M32,      IMM8    }, GP0, ALLOW_SEG | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	             NO_VEX, NO_EVEX, 1, 1, { 0x83, 0x03, 0x00 }, 4, 0, MOD_MEM_IMM, 0, OP_SIZE_OVERRIDE, ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0, P_86,  0, NULL },
{ "sbb",    2, { R64,      IMM8    }, GP3, (REX | REXW) | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),           NO_VEX, NO_EVEX, 1, 1, { 0x83, 0x03, 0x00 }, 4, 0, MOD_REG_IMM, 0, 0,	               0,                             (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
{ "sbb",    2, { R64E,     IMM8    }, GP3, (REX | REXW | REXB) | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),    NO_VEX, NO_EVEX, 1, 1, { 0x83, 0x03, 0x00 }, 4, 0, MOD_REG_IMM, 0, 0,				         0,                             (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
{ "sbb",    2, { M64,      IMM8    }, GP3, (REX | REXW) | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),		       NO_VEX, NO_EVEX, 1, 1, { 0x83, 0x03, 0x00 }, 4, 0, MOD_MEM_IMM, 0, 0,ADDR_SIZE_OVERRIDE,                             (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0, P_64,  0, NULL },
//18 / r SBB r / m8, r8                  D byte register to r / m8.
//REX + 18 / r SBB r / m8 *, r8
{ "sbb",    2, { M_ANY,    R8      }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                              NO_VEX, NO_EVEX, 1, 1, { 0x18, 0x00, 0x00 }, 1, 0, MOD_MEM_REG, 0, 0,				ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_86,  0, NULL },
{ "sbb",    2, { M_ANY,    R8H     }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                              NO_VEX, NO_EVEX, 1, 1, { 0x18, 0x00, 0x00 }, 1, 0, MOD_MEM_REG, 0, 0,				ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_86,  0, NULL },
{ "sbb",    2, { M_ANY,    R8E     }, GP3, ALLOW_SEG | (REX | REXR) | (F_MODRM | F_MODRM_REG),	                    NO_VEX, NO_EVEX, 1, 1, { 0x18, 0x00, 0x00 }, 1, 0, MOD_MEM_REG, 0, 0,				ADDR_SIZE_OVERRIDE,             (X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_64,  0, NULL },
{ "sbb",    2, { M_ANY,    R8U     }, GP3, ALLOW_SEG | (REX) | (F_MODRM | F_MODRM_REG),						                  NO_VEX, NO_EVEX, 1, 1, { 0x18, 0x00, 0x00 }, 1, 0, MOD_MEM_REG, 0, 0,				ADDR_SIZE_OVERRIDE,             (X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_64,  0, NULL },
//19 / r SBB r / m16, r16
//19 / r SBB r / m32, r32
//REX.W + 19 / r SBB r / m64, r64
{ "sbb",     2, { M_ANY,    R16     }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                            NO_VEX, NO_EVEX, 1, 1, { 0x19, 0x00, 0x00 }, 2, 0, MOD_MEM_REG, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_86,  0, NULL },
{ "sbb",     2, { M_ANY,    R16E    }, GP3, ALLOW_SEG | (REX | REXR) | (F_MODRM | F_MODRM_REG),	                    NO_VEX, NO_EVEX, 1, 1, { 0x19, 0x00, 0x00 }, 2, 0, MOD_MEM_REG, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE,             (X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_64,  0, NULL },
{ "sbb",     2, { M_ANY,    R32     }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                            NO_VEX, NO_EVEX, 1, 1, { 0x19, 0x00, 0x00 }, 4, 0, MOD_MEM_REG, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_86,  0, NULL },
{ "sbb",     2, { M_ANY,    R32E    }, GP3, ALLOW_SEG | (REX | REXR) | (F_MODRM | F_MODRM_REG),	                    NO_VEX, NO_EVEX, 1, 1, { 0x19, 0x00, 0x00 }, 4, 0, MOD_MEM_REG, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE,             (X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_64,  0, NULL },
{ "sbb",     2, { M_ANY,    R64     }, GP3, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_REG),			                NO_VEX, NO_EVEX, 1, 1, { 0x19, 0x00, 0x00 }, 8, 0, MOD_MEM_REG, 0, 0,				          ADDR_SIZE_OVERRIDE,             (X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_64,  0, NULL },
{ "sbb",     2, { M_ANY,    R64E    }, GP3, ALLOW_SEG | (REX | REXW | REXR) | (F_MODRM | F_MODRM_REG),	            NO_VEX, NO_EVEX, 1, 1, { 0x19, 0x00, 0x00 }, 8, 0, MOD_MEM_REG, 0, 0,				          ADDR_SIZE_OVERRIDE,             (X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_64,  0, NULL },
//1A / r SBB r8, r / m8
//REX + 1A / r SBB r8*, r / m8 *
{ "sbb",     2, { R8,       R8      }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT | IMM8_ONLY),          NO_VEX, NO_EVEX, 1, 1, { 0x1a, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                  (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "sbb",     2, { R8,       R8H     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT | IMM8_ONLY),		      NO_VEX, NO_EVEX, 1, 1, { 0x1a, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                  (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "sbb",     2, { R8H,      R8      }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT | IMM8_ONLY),		      NO_VEX, NO_EVEX, 1, 1, { 0x1a, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                  (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "sbb",     2, { R8H,      R8H     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT | IMM8_ONLY),		      NO_VEX, NO_EVEX, 1, 1, { 0x1a, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                  (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "sbb",     2, { R8E,      R8E     }, GP3, (REX | REXB | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),	            NO_VEX, NO_EVEX, 1, 1, { 0x1a, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                              (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "sbb",     2, { R8,       R8E     }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				            NO_VEX, NO_EVEX, 1, 1, { 0x1a, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                              (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "sbb",     2, { R8E,      R8      }, GP3, (REX | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				            NO_VEX, NO_EVEX, 1, 1, { 0x1a, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                              (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "sbb",     2, { R8U,      R8      }, GP3, (REX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),					                  NO_VEX, NO_EVEX, 1, 1, { 0x1a, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                              (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "sbb",     2, { R8U,      R8E     }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),					          NO_VEX, NO_EVEX, 1, 1, { 0x1a, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                              (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "sbb",     2, { R8,       R8U     }, GP3, (REX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),					                  NO_VEX, NO_EVEX, 1, 1, { 0x1a, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                              (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "sbb",     2, { R8,       M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                            NO_VEX, NO_EVEX, 1, 1, { 0x1a, 0x00, 0x00 }, 1, 0, MOD_REG_MEM, 0, 0, ADDR_SIZE_OVERRIDE,                (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_86,  0, NULL },
{ "sbb",     2, { R8H,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                            NO_VEX, NO_EVEX, 1, 1, { 0x1a, 0x00, 0x00 }, 1, 0, MOD_REG_MEM, 0, 0,	ADDR_SIZE_OVERRIDE,                (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_86,  0, NULL },
{ "sbb",     2, { R8E,      M_ANY   }, GP3, ALLOW_SEG | (REX | REXR) | (F_MODRM | F_MODRM_REG),	                    NO_VEX, NO_EVEX, 1, 1, { 0x1a, 0x00, 0x00 }, 1, 0, MOD_REG_MEM, 0, 0,	ADDR_SIZE_OVERRIDE,                            (X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_64,  0, NULL },
{ "sbb",     2, { R8U,      M_ANY   }, GP3, ALLOW_SEG | (REX) | (F_MODRM | F_MODRM_REG),						                NO_VEX, NO_EVEX, 1, 1, { 0x1a, 0x00, 0x00 }, 1, 0, MOD_REG_MEM, 0, 0,	ADDR_SIZE_OVERRIDE,                            (X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_64,  0, NULL },
//1B / r SBB r16, r / m16
//1B / r SBB r32, r / m32
//REX.W + 1B / r SBB r64, r / m64
{ "sbb",     2, { R16,      R16     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                      NO_VEX, NO_EVEX, 1, 1, { 0x1b, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                   (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "sbb",     2, { R16E,     R16E    }, GP3, (REX | REXB | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),             NO_VEX, NO_EVEX, 1, 1, { 0x1b, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "sbb",     2, { R16E,     R16     }, GP3, (REX | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				            NO_VEX, NO_EVEX, 1, 1, { 0x1b, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "sbb",     2, { R16,      R16E    }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				            NO_VEX, NO_EVEX, 1, 1, { 0x1b, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "sbb",     2, { R32,      R32     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                      NO_VEX, NO_EVEX, 1, 1, { 0x1b, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, 0,                0,                   (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "sbb",     2, { R32E,     R32E    }, GP3, (REX | REXB | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),	            NO_VEX, NO_EVEX, 1, 1, { 0x1b, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, 0,                0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "sbb",     2, { R32E,     R32     }, GP3, (REX | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				            NO_VEX, NO_EVEX, 1, 1, { 0x1b, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, 0,                0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "sbb",     2, { R32,      R32E    }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				            NO_VEX, NO_EVEX, 1, 1, { 0x1b, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, 0,                0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "sbb",     2, { R64,      R64     }, GP3, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		                NO_VEX, NO_EVEX, 1, 1, { 0x1b, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "sbb",     2, { R64E,     R64E    }, GP3, (REX | REXR | REXB | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),      NO_VEX, NO_EVEX, 1, 1, { 0x1b, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "sbb",     2, { R64,      R64E    }, GP3, (REX | REXB | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		          NO_VEX, NO_EVEX, 1, 1, { 0x1b, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "sbb",     2, { R64E,     R64     }, GP3, (REX | REXR | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		          NO_VEX, NO_EVEX, 1, 1, { 0x1b, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "sbb",     2, { R16,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                            NO_VEX, NO_EVEX, 1, 1, { 0x1b, 0x00, 0x00 }, 2, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE, 0,                   (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_86,  0, NULL },
{ "sbb",     2, { R16E,     M_ANY   }, GP3, ALLOW_SEG | (REX | REXR) | (F_MODRM | F_MODRM_REG),	                    NO_VEX, NO_EVEX, 1, 1, { 0x1b, 0x00, 0x00 }, 2, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE,             (X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_64,  0, NULL },
{ "sbb",     2, { R32,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                            NO_VEX, NO_EVEX, 1, 1, { 0x1b, 0x00, 0x00 }, 4, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_86,  0, NULL },
{ "sbb",     2, { R32E,     M_ANY   }, GP3, ALLOW_SEG | (REX | REXR) | (F_MODRM | F_MODRM_REG),	                    NO_VEX, NO_EVEX, 1, 1, { 0x1b, 0x00, 0x00 }, 4, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE,             (X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_64,  0, NULL },
{ "sbb",     2, { R64,      M_ANY   }, GP3, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_REG),				              NO_VEX, NO_EVEX, 1, 1, { 0x1b, 0x00, 0x00 }, 8, 0, MOD_REG_MEM, 0, 0,				          ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_64,  0, NULL },
{ "sbb",     2, { R64E,     M_ANY   }, GP3, ALLOW_SEG | (REX | REXW | REXR) | (F_MODRM | F_MODRM_REG),	            NO_VEX, NO_EVEX, 1, 1, { 0x1b, 0x00, 0x00 }, 8, 0, MOD_REG_MEM, 0, 0,				          ADDR_SIZE_OVERRIDE,             (X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_64,  0, NULL },
//2C ib SUB AL, imm8 I Valid Valid SUB imm8 to AL.
{ "sub",    2, { R8_AL,    IMM8    }, GP0, (F_OPCODE_REG),												                                  NO_VEX, NO_EVEX, 1, 1, { 0x2c, 0x00, 0x00 }, 1, 0, NO_MOD,      0, 0,				         0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
//25 iw SUB AX, imm16 I Valid Valid SUB imm16 to AX.
//25 id SUB EAX, imm32 I Valid Valid SUB imm32 to EAX.
//REX.W + 25 id SUB RAX, imm32 I Valid N.E.SUB imm32 sign extended to 64 - bits to RAX.
{ "sub",    2, { R16_AX,   IMM16   }, GP0, (F_OPCODE_REG),												                                  NO_VEX, NO_EVEX, 1, 1, { 0x2d, 0x00, 0x00 }, 2, 0, NO_MOD,      0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "sub",    2, { R32_EAX,  IMM32   }, GP0, (F_OPCODE_REG),												                                  NO_VEX, NO_EVEX, 1, 1, { 0x2d, 0x00, 0x00 }, 4, 0, NO_MOD,      0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "sub",    2, { R64_RAX,  IMM32   }, GP3, (REX | REXW) | (F_OPCODE_REG),						                                        NO_VEX, NO_EVEX, 1, 1, { 0x2d, 0x00, 0x00 }, 4, 0, NO_MOD,      0, 0,				         0,                              (X64), NO_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
//80 / 5 ib SUB r / m8, imm8 MI Valid Valid SUB imm8 to r / m8.
//REX + 80 / 2 ib SUB r / m8 * , imm8 MI Valid N.E.SUB imm8 to r / m8.
{ "sub",    2, { R8,       IMM8    }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),		                NO_VEX, NO_EVEX, 1, 1, { 0x80, 0x05, 0x00 }, 1, 0, MOD_REG_IMM, 0, 0,	               0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "sub",    2, { R8H,      IMM8    }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	                  NO_VEX, NO_EVEX, 1, 1, { 0x80, 0x05, 0x00 }, 1, 0, MOD_REG_IMM, 0, 0,	               0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "sub",    2, { R8U,      IMM8    }, GP3, REX | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),									  NO_VEX, NO_EVEX, 1, 1, { 0x80, 0x05, 0x00 }, 1, 0, MOD_REG_IMM, 0, 0,				         0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
{ "sub",    2, { R8E,      IMM8    }, GP3, (REX | REXB) | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),				  NO_VEX, NO_EVEX, 1, 1, { 0x80, 0x05, 0x00 }, 1, 0, MOD_REG_IMM, 0, 0,				         0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
{ "sub",    2, { M8,       IMM8    }, GP0, ALLOW_SEG | (F_MODRM | OPCODE_EXT | IMM8_ONLY),									        NO_VEX, NO_EVEX, 1, 1, { 0x80, 0x05, 0x00 }, 1, 0, MOD_MEM_IMM, 0, 0,	               ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0,P_86,  0, NULL },
//81 / 5 iw SUB r / m16, imm16 MI Valid Valid SUB imm16 to r / m16.
//81 / 5 id SUB r / m32, imm32 MI Valid Valid SUB with CF imm32 to r / m32.
//REX.W + 81 / 5 id SUB r / m64, imm32 MI Valid N.E.SUB with CF imm32 sign extended to 64 - bits to r / m64.
{ "sub",    2, { R16,      IMM16   }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT),		                                  NO_VEX, NO_EVEX, 1, 1, { 0x81, 0x05, 0x00 }, 2, 0, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "sub",    2, { R16E,     IMM16   }, GP3, (REX | REXB) | (F_MODRM_RM | F_MODRM | OPCODE_EXT),								      NO_VEX, NO_EVEX, 1, 1, { 0x81, 0x05, 0x00 }, 2, 0, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
{ "sub",    2, { M16,      IMM16   }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT),		                                  NO_VEX, NO_EVEX, 1, 1, { 0x81, 0x05, 0x00 }, 2, 0, MOD_MEM_IMM, 0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0, P_86,  0, NULL },
{ "sub",    2, { R32,      IMM32   }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT),		                                  NO_VEX, NO_EVEX, 1, 1, { 0x81, 0x05, 0x00 }, 4, 0, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "sub",    2, { R32E,     IMM32   }, GP3, (REX | REXB) | (F_MODRM_RM | F_MODRM | OPCODE_EXT),								      NO_VEX, NO_EVEX, 1, 1, { 0x81, 0x05, 0x00 }, 4, 0, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
{ "sub",    2, { R32,      IMM16   }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT),		                                  NO_VEX, NO_EVEX, 1, 1, { 0x81, 0x05, 0x00 }, 4, 0, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "sub",    2, { R32E,     IMM16   }, GP3, (REX | REXB) | (F_MODRM_RM | F_MODRM | OPCODE_EXT),								      NO_VEX, NO_EVEX, 1, 1, { 0x81, 0x05, 0x00 }, 4, 0, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
{ "sub",    2, { M32,      IMM32   }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT),		                                  NO_VEX, NO_EVEX, 1, 1, { 0x81, 0x05, 0x00 }, 4, 0, MOD_MEM_IMM, 0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0, P_86,  0, NULL },
{ "sub",    2, { R64,      IMM32   }, GP3, (REX | REXW) | (F_MODRM_RM | F_MODRM | OPCODE_EXT),                      NO_VEX, NO_EVEX, 1, 1, { 0x81, 0x05, 0x00 }, 4, 0, MOD_REG_IMM, 0, 0,	               0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
{ "sub",    2, { R64,      IMM16   }, GP3, (REX | REXW) | (F_MODRM_RM | F_MODRM | OPCODE_EXT),                      NO_VEX, NO_EVEX, 1, 1, { 0x81, 0x05, 0x00 }, 4, 0, MOD_REG_IMM, 0, 0,	               0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
{ "sub",    2, { R64E,     IMM32   }, GP3, (REX | REXW | REXB) | (F_MODRM_RM | F_MODRM | OPCODE_EXT),                      NO_VEX, NO_EVEX, 1, 1, { 0x81, 0x05, 0x00 }, 4, 0, MOD_REG_IMM, 0, 0,	               0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
{ "sub",    2, { R64E,     IMM16   }, GP3, (REX | REXW | REXB) | (F_MODRM_RM | F_MODRM | OPCODE_EXT),                      NO_VEX, NO_EVEX, 1, 1, { 0x81, 0x05, 0x00 }, 4, 0, MOD_REG_IMM, 0, 0,	               0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
{ "sub",    2, { M64,      IMM32   }, GP3, REXW | (F_MODRM_RM | F_MODRM | OPCODE_EXT),		                          NO_VEX, NO_EVEX, 1, 1, { 0x81, 0x05, 0x00 }, 4, 0, MOD_MEM_IMM, 0, 0,	               0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0, P_64,  0, NULL },
//83 / 5 ib SUB r / m16, imm8 MI Valid Valid SUB with CF sign - extended imm8 to r / m16.
//83 / 5 ib SUB r / m32, imm8 MI Valid Valid SUB with CF sign - extended imm8 into r / m32.
//REX.W + 83 / 5 ib SUB r / m64, imm8 MI Valid N.E.SUB with CF sign - extended imm8 into r / m64.
{ "sub",    2, { R16,      IMM8    }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	                        NO_VEX, NO_EVEX, 1, 1, { 0x83, 0x05, 0x00 }, 2, 0, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "sub",    2, { R16E,     IMM8    }, GP0, (REX | REXB) | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	        NO_VEX, NO_EVEX, 1, 1, { 0x83, 0x05, 0x00 }, 2, 0, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "sub",    2, { M16,      IMM8    }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	                        NO_VEX, NO_EVEX, 1, 1, { 0x83, 0x05, 0x00 }, 2, 0, MOD_MEM_IMM, 0, OP_SIZE_OVERRIDE, ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0, P_86,  0, NULL },
{ "sub",    2, { R32,      IMM8    }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	                        NO_VEX, NO_EVEX, 1, 1, { 0x83, 0x05, 0x00 }, 4, 0, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "sub",    2, { R32E,     IMM8    }, GP3, (REX | REXB) | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	        NO_VEX, NO_EVEX, 1, 1, { 0x83, 0x05, 0x00 }, 4, 0, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "sub",    2, { M32,      IMM8    }, GP0, ALLOW_SEG | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	            NO_VEX, NO_EVEX, 1, 1, { 0x83, 0x05, 0x00 }, 4, 0, MOD_MEM_IMM, 0, OP_SIZE_OVERRIDE, ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0, P_86,  0, NULL },
{ "sub",    2, { R64,      IMM8    }, GP3, (REX | REXW) | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),          NO_VEX, NO_EVEX, 1, 1, { 0x83, 0x05, 0x00 }, 4, 0, MOD_REG_IMM, 0, 0,	               0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
{ "sub",    2, { R64E,     IMM8    }, GP3, (REX | REXW | REXB) | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),   NO_VEX, NO_EVEX, 1, 1, { 0x83, 0x05, 0x00 }, 4, 0, MOD_REG_IMM, 0, 0,				         0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
{ "sub",    2, { M64,      IMM8    }, GP3, (REX | REXW) | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),		      NO_VEX, NO_EVEX, 1, 1, { 0x83, 0x05, 0x00 }, 4, 0, MOD_MEM_IMM, 0, 0,ADDR_SIZE_OVERRIDE,                             (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0, P_64,  0, NULL },
//28 / r SUB r / m8, r8 MR Valid Valid SUB byte register to r / m8.
//REX + 28 / r SUB r / m8 * , r8* MR Valid N.E.SUB byte register to r / m64.
{ "sub",    2, { M_ANY,    R8      }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                              NO_VEX, NO_EVEX, 1, 1, { 0x28, 0x00, 0x00 }, 1, 0, MOD_MEM_REG, 0, 0,				ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_86,  0, NULL },
{ "sub",    2, { M_ANY,    R8H     }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                              NO_VEX, NO_EVEX, 1, 1, { 0x28, 0x00, 0x00 }, 1, 0, MOD_MEM_REG, 0, 0,				ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_86,  0, NULL },
{ "sub",    2, { M_ANY,    R8E     }, GP3, ALLOW_SEG | (REX | REXR) | (F_MODRM | F_MODRM_REG),	                    NO_VEX, NO_EVEX, 1, 1, { 0x28, 0x00, 0x00 }, 1, 0, MOD_MEM_REG, 0, 0,				ADDR_SIZE_OVERRIDE,             (X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_64,  0, NULL },
{ "sub",    2, { M_ANY,    R8U     }, GP3, ALLOW_SEG | (REX) | (F_MODRM | F_MODRM_REG),						                  NO_VEX, NO_EVEX, 1, 1, { 0x28, 0x00, 0x00 }, 1, 0, MOD_MEM_REG, 0, 0,				ADDR_SIZE_OVERRIDE,             (X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_64,  0, NULL },
//29 / r SUB r / m16, r16 MR Valid Valid SUB r16 to r / m16.
//29 / r SUB r / m32, r32 MR Valid Valid SUB with CF r32 to r / m32.
//REX.W + 29 / r SUB r / m64, r64 MR Valid N.E.SUB with CF r64 to r / m64.
{ "sub",     2, { M_ANY,    R16     }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                            NO_VEX, NO_EVEX, 1, 1, { 0x29, 0x00, 0x00 }, 2, 0, MOD_MEM_REG, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_86,  0, NULL },
{ "sub",     2, { M_ANY,    R16E    }, GP3, ALLOW_SEG | (REX | REXR) | (F_MODRM | F_MODRM_REG),	                    NO_VEX, NO_EVEX, 1, 1, { 0x29, 0x00, 0x00 }, 2, 0, MOD_MEM_REG, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE,             (X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_64,  0, NULL },
{ "sub",     2, { M_ANY,    R32     }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                            NO_VEX, NO_EVEX, 1, 1, { 0x29, 0x00, 0x00 }, 4, 0, MOD_MEM_REG, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_86,  0, NULL },
{ "sub",     2, { M_ANY,    R32E    }, GP3, ALLOW_SEG | (REX | REXR) | (F_MODRM | F_MODRM_REG),	                    NO_VEX, NO_EVEX, 1, 1, { 0x29, 0x00, 0x00 }, 4, 0, MOD_MEM_REG, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE,             (X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_64,  0, NULL },
{ "sub",     2, { M_ANY,    R64     }, GP3, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_REG),			                NO_VEX, NO_EVEX, 1, 1, { 0x29, 0x00, 0x00 }, 8, 0, MOD_MEM_REG, 0, 0,				          ADDR_SIZE_OVERRIDE,             (X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_64,  0, NULL },
{ "sub",     2, { M_ANY,    R64E    }, GP3, ALLOW_SEG | (REX | REXW | REXR) | (F_MODRM | F_MODRM_REG),	            NO_VEX, NO_EVEX, 1, 1, { 0x29, 0x00, 0x00 }, 8, 0, MOD_MEM_REG, 0, 0,				          ADDR_SIZE_OVERRIDE,             (X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_64,  0, NULL },
//2A / r SUB r8, r / m8 RM Valid Valid SUB r / m8 to byte register.
//REX + 2A / r SUB r8*, r / m8 * RM Valid N.E.SUB r / m64 to byte register.
{ "sub",     2, { R8,       R8      }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT | IMM8_ONLY),          NO_VEX, NO_EVEX, 1, 1, { 0x2a, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                  (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "sub",     2, { R8,       R8H     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT | IMM8_ONLY),		      NO_VEX, NO_EVEX, 1, 1, { 0x2a, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                  (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "sub",     2, { R8H,      R8      }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT | IMM8_ONLY),		      NO_VEX, NO_EVEX, 1, 1, { 0x2a, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                  (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "sub",     2, { R8H,      R8H     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT | IMM8_ONLY),		      NO_VEX, NO_EVEX, 1, 1, { 0x2a, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                  (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "sub",     2, { R8E,      R8E     }, GP3, (REX | REXB | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),	            NO_VEX, NO_EVEX, 1, 1, { 0x2a, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                              (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "sub",     2, { R8,       R8E     }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				            NO_VEX, NO_EVEX, 1, 1, { 0x2a, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                              (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "sub",     2, { R8E,      R8      }, GP3, (REX | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				            NO_VEX, NO_EVEX, 1, 1, { 0x2a, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                              (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "sub",     2, { R8U,      R8      }, GP3, (REX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),					                  NO_VEX, NO_EVEX, 1, 1, { 0x2a, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                              (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "sub",     2, { R8U,      R8E     }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),					          NO_VEX, NO_EVEX, 1, 1, { 0x2a, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                              (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "sub",     2, { R8,       R8U     }, GP3, (REX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),					                  NO_VEX, NO_EVEX, 1, 1, { 0x2a, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                              (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "sub",     2, { R8,       M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                            NO_VEX, NO_EVEX, 1, 1, { 0x2a, 0x00, 0x00 }, 1, 0, MOD_REG_MEM, 0, 0, ADDR_SIZE_OVERRIDE,                (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_86,  0, NULL },
{ "sub",     2, { R8H,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                            NO_VEX, NO_EVEX, 1, 1, { 0x2a, 0x00, 0x00 }, 1, 0, MOD_REG_MEM, 0, 0,	ADDR_SIZE_OVERRIDE,                (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_86,  0, NULL },
{ "sub",     2, { R8E,      M_ANY   }, GP3, ALLOW_SEG | (REX | REXR) | (F_MODRM | F_MODRM_REG),	                    NO_VEX, NO_EVEX, 1, 1, { 0x2a, 0x00, 0x00 }, 1, 0, MOD_REG_MEM, 0, 0,	ADDR_SIZE_OVERRIDE,                            (X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_64,  0, NULL },
{ "sub",     2, { R8U,      M_ANY   }, GP3, ALLOW_SEG | (REX) | (F_MODRM | F_MODRM_REG),						                NO_VEX, NO_EVEX, 1, 1, { 0x2a, 0x00, 0x00 }, 1, 0, MOD_REG_MEM, 0, 0,	ADDR_SIZE_OVERRIDE,                            (X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_64,  0, NULL },
//2and3 / r SUB r16, r / m16 RM Valid Valid SUB r / m16 to r16.
//2B / r SUB r32, r / m32 RM Valid Valid SUB with CF r / m32 to r32.
//REX.W + 2B / r SUB r64, r / m64 RM Valid N.E.SUB with CF r / m64 to r64. 
{ "sub",     2, { R16,      R16     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                      NO_VEX, NO_EVEX, 1, 1, { 0x2b, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                   (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "sub",     2, { R16E,     R16E    }, GP3, (REX | REXB | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),             NO_VEX, NO_EVEX, 1, 1, { 0x2b, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "sub",     2, { R16E,     R16     }, GP3, (REX | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				            NO_VEX, NO_EVEX, 1, 1, { 0x2b, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "sub",     2, { R16,      R16E    }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				            NO_VEX, NO_EVEX, 1, 1, { 0x2b, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "sub",     2, { R32,      R32     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                      NO_VEX, NO_EVEX, 1, 1, { 0x2b, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, 0,                0,                   (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "sub",     2, { R32E,     R32E    }, GP3, (REX | REXB | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),	            NO_VEX, NO_EVEX, 1, 1, { 0x2b, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, 0,                0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "sub",     2, { R32E,     R32     }, GP3, (REX | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				            NO_VEX, NO_EVEX, 1, 1, { 0x2b, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, 0,                0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "sub",     2, { R32,      R32E    }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				            NO_VEX, NO_EVEX, 1, 1, { 0x2b, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, 0,                0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "sub",     2, { R64,      R64     }, GP3, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		                NO_VEX, NO_EVEX, 1, 1, { 0x2b, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "sub",     2, { R64E,     R64E    }, GP3, (REX | REXR | REXB | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),      NO_VEX, NO_EVEX, 1, 1, { 0x2b, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "sub",     2, { R64,      R64E    }, GP3, (REX | REXB | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		          NO_VEX, NO_EVEX, 1, 1, { 0x2b, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "sub",     2, { R64E,     R64     }, GP3, (REX | REXR | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		          NO_VEX, NO_EVEX, 1, 1, { 0x2b, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "sub",     2, { R16,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                            NO_VEX, NO_EVEX, 1, 1, { 0x2b, 0x00, 0x00 }, 2, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE, 0,                   (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_86,  0, NULL },
{ "sub",     2, { R16E,     M_ANY   }, GP3, ALLOW_SEG | (REX | REXR) | (F_MODRM | F_MODRM_REG),	                    NO_VEX, NO_EVEX, 1, 1, { 0x2b, 0x00, 0x00 }, 2, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE,             (X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_64,  0, NULL },
{ "sub",     2, { R32,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                            NO_VEX, NO_EVEX, 1, 1, { 0x2b, 0x00, 0x00 }, 4, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_86,  0, NULL },
{ "sub",     2, { R32E,     M_ANY   }, GP3, ALLOW_SEG | (REX | REXR) | (F_MODRM | F_MODRM_REG),	                    NO_VEX, NO_EVEX, 1, 1, { 0x2b, 0x00, 0x00 }, 4, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE,             (X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_64,  0, NULL },
{ "sub",     2, { R64,      M_ANY   }, GP3, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_REG),				              NO_VEX, NO_EVEX, 1, 1, { 0x2b, 0x00, 0x00 }, 8, 0, MOD_REG_MEM, 0, 0,				          ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_64,  0, NULL },
{ "sub",     2, { R64E,     M_ANY   }, GP3, ALLOW_SEG | (REX | REXW | REXR) | (F_MODRM | F_MODRM_REG),	            NO_VEX, NO_EVEX, 1, 1, { 0x2b, 0x00, 0x00 }, 8, 0, MOD_REG_MEM, 0, 0,				          ADDR_SIZE_OVERRIDE,             (X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_64,  0, NULL },
//3C ib CMP AL, imm8
{ "cmp",    2, { R8_AL,    IMM8    }, GP0, (F_OPCODE_REG),												                                  NO_VEX, NO_EVEX, 1, 1, { 0x3c, 0x00, 0x00 }, 1, 0, NO_MOD,      0, 0,				         0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
//25 iw CMP AX, imm16 I Valid Valid CMP imm16 to AX.
//25 id CMP EAX, imm32 I Valid Valid CMP imm32 to EAX.
//REX.W + 25 id CMP RAX, imm32 I Valid N.E.CMP imm32 sign extended to 64 - bits to RAX.
{ "cmp",    2, { R16_AX,   IMM16   }, GP0, (F_OPCODE_REG),												                                  NO_VEX, NO_EVEX, 1, 1, { 0x3d, 0x00, 0x00 }, 2, 0, NO_MOD,      0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "cmp",    2, { R32_EAX,  IMM32   }, GP0, (F_OPCODE_REG),												                                  NO_VEX, NO_EVEX, 1, 1, { 0x3d, 0x00, 0x00 }, 4, 0, NO_MOD,      0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "cmp",    2, { R64_RAX,  IMM32   }, GP3, (REX | REXW) | (F_OPCODE_REG),						                                        NO_VEX, NO_EVEX, 1, 1, { 0x3d, 0x00, 0x00 }, 4, 0, NO_MOD,      0, 0,				         0,                              (X64), NO_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
//80 / 5 ib CMP r / m8, imm8 MI Valid Valid CMP imm8 to r / m8.
//REX + 80 / 2 ib CMP r / m8 * , imm8 MI Valid N.E.CMP imm8 to r / m8.
{ "cmp",    2, { R8,       IMM8    }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),		                NO_VEX, NO_EVEX, 1, 1, { 0x80, 0x07, 0x00 }, 1, 0, MOD_REG_IMM, 0, 0,	               0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "cmp",    2, { R8H,      IMM8    }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	                  NO_VEX, NO_EVEX, 1, 1, { 0x80, 0x07, 0x00 }, 1, 0, MOD_REG_IMM, 0, 0,	               0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "cmp",    2, { R8U,      IMM8    }, GP3, REX | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),									  NO_VEX, NO_EVEX, 1, 1, { 0x80, 0x07, 0x00 }, 1, 0, MOD_REG_IMM, 0, 0,				         0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
{ "cmp",    2, { R8E,      IMM8    }, GP3, (REX | REXB) | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),				  NO_VEX, NO_EVEX, 1, 1, { 0x80, 0x07, 0x00 }, 1, 0, MOD_REG_IMM, 0, 0,				         0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
{ "cmp",    2, { M8,       IMM8    }, GP0, ALLOW_SEG | (F_MODRM | OPCODE_EXT | IMM8_ONLY),									        NO_VEX, NO_EVEX, 1, 1, { 0x80, 0x07, 0x00 }, 1, 0, MOD_MEM_IMM, 0, 0,	               ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0,P_86,  0, NULL },
{ "cmp",    2, { M_ANY,    IMM8    }, GP0, ALLOW_SEG | (F_MODRM | OPCODE_EXT | IMM8_ONLY),									        NO_VEX, NO_EVEX, 1, 1, { 0x80, 0x07, 0x00 }, 1, 0, MOD_MEM_IMM, 0, 0,	               ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0,P_86,  0, NULL },
//81 / 7 iw CMP r / m16, imm16
//81 / 7 id CMP r / m32, imm32
//REX.W + 81 / 7 id CMP r / m64, imm32
{ "cmp",    2, { R16,      IMM16   }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT),		                                  NO_VEX, NO_EVEX, 1, 1, { 0x81, 0x07, 0x00 }, 2, 0, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "cmp",    2, { R16E,     IMM16   }, GP3, (REX | REXB) | (F_MODRM_RM | F_MODRM | OPCODE_EXT),								      NO_VEX, NO_EVEX, 1, 1, { 0x81, 0x07, 0x00 }, 2, 0, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
{ "cmp",    2, { M16,      IMM16   }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT),		                                  NO_VEX, NO_EVEX, 1, 1, { 0x81, 0x07, 0x00 }, 2, 0, MOD_MEM_IMM, 0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0, P_86,  0, NULL },
{ "cmp",    2, { M_ANY,    IMM16   }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT),		                                  NO_VEX, NO_EVEX, 1, 1, { 0x81, 0x07, 0x00 }, 2, 0, MOD_MEM_IMM, 0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0, P_86,  0, NULL },
{ "cmp",    2, { R32,      IMM32   }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT),		                                  NO_VEX, NO_EVEX, 1, 1, { 0x81, 0x07, 0x00 }, 4, 0, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "cmp",    2, { R32,      IMM16   }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT),		                                  NO_VEX, NO_EVEX, 1, 1, { 0x81, 0x07, 0x00 }, 4, 0, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "cmp",    2, { R32E,     IMM32   }, GP3, (REX | REXB) | (F_MODRM_RM | F_MODRM | OPCODE_EXT),								      NO_VEX, NO_EVEX, 1, 1, { 0x81, 0x07, 0x00 }, 4, 0, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
{ "cmp",    2, { M32,      IMM32   }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT),		                                  NO_VEX, NO_EVEX, 1, 1, { 0x81, 0x07, 0x00 }, 4, 0, MOD_MEM_IMM, 0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0, P_86,  0, NULL },
{ "cmp",    2, { M_ANY,    IMM32   }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT),		                                  NO_VEX, NO_EVEX, 1, 1, { 0x81, 0x07, 0x00 }, 4, 0, MOD_MEM_IMM, 0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0, P_86,  0, NULL },
{ "cmp",    2, { R32E,     IMM16   }, GP3, (REX | REXB) | (F_MODRM_RM | F_MODRM | OPCODE_EXT),								      NO_VEX, NO_EVEX, 1, 1, { 0x81, 0x07, 0x00 }, 4, 0, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
{ "cmp",    2, { R64,      IMM32   }, GP3, (REX | REXW) | (F_MODRM_RM | F_MODRM | OPCODE_EXT),                      NO_VEX, NO_EVEX, 1, 1, { 0x81, 0x07, 0x00 }, 4, 0, MOD_REG_IMM, 0, 0,	               0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
{ "cmp",    2, { R64,      IMM16   }, GP3, (REX | REXW) | (F_MODRM_RM | F_MODRM | OPCODE_EXT),                      NO_VEX, NO_EVEX, 1, 1, { 0x81, 0x07, 0x00 }, 4, 0, MOD_REG_IMM, 0, 0,	               0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
{ "cmp",    2, { R64E,     IMM32   }, GP3, (REX | REXW | REXB) | (F_MODRM_RM | F_MODRM | OPCODE_EXT),                      NO_VEX, NO_EVEX, 1, 1, { 0x81, 0x07, 0x00 }, 4, 0, MOD_REG_IMM, 0, 0,	               0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
{ "cmp",    2, { R64E,     IMM16   }, GP3, (REX | REXW | REXB) | (F_MODRM_RM | F_MODRM | OPCODE_EXT),                      NO_VEX, NO_EVEX, 1, 1, { 0x81, 0x07, 0x00 }, 4, 0, MOD_REG_IMM, 0, 0,	               0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
{ "cmp",    2, { M64,      IMM32   }, GP3, REXW | (F_MODRM_RM | F_MODRM | OPCODE_EXT),		                          NO_VEX, NO_EVEX, 1, 1, { 0x81, 0x07, 0x00 }, 4, 0, MOD_MEM_IMM, 0, 0,	               0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0, P_64,  0, NULL },
{ "cmp",    2, { M_ANY,    IMM32   }, GP3, REXW | (F_MODRM_RM | F_MODRM | OPCODE_EXT),		                          NO_VEX, NO_EVEX, 1, 1, { 0x81, 0x07, 0x00 }, 4, 0, MOD_MEM_IMM, 0, 0,	               0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0, P_64,  0, NULL },
//83 / 7 ib CMP r / m16, imm8
//83 / 7 ib CMP r / m32, imm8
//REX.W + 83 / 7 ib CMP r / m64, imm8
{ "cmp",    2, { R16,      IMM8    }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	                        NO_VEX, NO_EVEX, 1, 1, { 0x83, 0x07, 0x00 }, 2, 0, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "cmp",    2, { R16E,     IMM8    }, GP3, (REX | REXB) | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	        NO_VEX, NO_EVEX, 1, 1, { 0x83, 0x07, 0x00 }, 2, 0, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "cmp",    2, { M16,      IMM8    }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	                        NO_VEX, NO_EVEX, 1, 1, { 0x83, 0x07, 0x00 }, 2, 0, MOD_MEM_IMM, 0, OP_SIZE_OVERRIDE, ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0, P_86,  0, NULL },
{ "cmp",    2, { M_ANY,    IMM8    }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	                        NO_VEX, NO_EVEX, 1, 1, { 0x83, 0x07, 0x00 }, 2, 0, MOD_MEM_IMM, 0, OP_SIZE_OVERRIDE, ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0, P_86,  0, NULL },
{ "cmp",    2, { R32,      IMM8    }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	                        NO_VEX, NO_EVEX, 1, 1, { 0x83, 0x07, 0x00 }, 4, 0, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "cmp",    2, { R32E,     IMM8    }, GP3, (REX | REXB) | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	        NO_VEX, NO_EVEX, 1, 1, { 0x83, 0x07, 0x00 }, 4, 0, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "cmp",    2, { M32,      IMM8    }, GP0, ALLOW_SEG | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	            NO_VEX, NO_EVEX, 1, 1, { 0x83, 0x07, 0x00 }, 4, 0, MOD_MEM_IMM, 0, OP_SIZE_OVERRIDE, ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0, P_86,  0, NULL },
{ "cmp",    2, { M_ANY,    IMM8    }, GP0, ALLOW_SEG | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	            NO_VEX, NO_EVEX, 1, 1, { 0x83, 0x07, 0x00 }, 4, 0, MOD_MEM_IMM, 0, OP_SIZE_OVERRIDE, ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0, P_86,  0, NULL },
{ "cmp",    2, { R64,      IMM8    }, GP3, (REX | REXW) | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),          NO_VEX, NO_EVEX, 1, 1, { 0x83, 0x07, 0x00 }, 4, 0, MOD_REG_IMM, 0, 0,	               0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
{ "cmp",    2, { R64E,     IMM8    }, GP3, (REX | REXW | REXB) | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),   NO_VEX, NO_EVEX, 1, 1, { 0x83, 0x07, 0x00 }, 4, 0, MOD_REG_IMM, 0, 0,				         0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
{ "cmp",    2, { M64,      IMM8    }, GP3, (REX | REXW) | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),		      NO_VEX, NO_EVEX, 1, 1, { 0x83, 0x07, 0x00 }, 4, 0, MOD_MEM_IMM, 0, 0,ADDR_SIZE_OVERRIDE,                             (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0, P_64,  0, NULL },
{ "cmp",    2, { M_ANY,    IMM8    }, GP3, (REX | REXW) | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),		      NO_VEX, NO_EVEX, 1, 1, { 0x83, 0x07, 0x00 }, 4, 0, MOD_MEM_IMM, 0, 0,ADDR_SIZE_OVERRIDE,                             (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0, P_64,  0, NULL },
//38 / r CMP r / m8, r8
//REX + 38 / r CMP r / m8 *, r8 *
{ "cmp",    2, { M_ANY,    R8      }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                              NO_VEX, NO_EVEX, 1, 1, { 0x38, 0x00, 0x00 }, 1, 0, MOD_MEM_REG, 0, 0,				ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_86,  0, NULL },
{ "cmp",    2, { M_ANY,    R8H     }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                              NO_VEX, NO_EVEX, 1, 1, { 0x38, 0x00, 0x00 }, 1, 0, MOD_MEM_REG, 0, 0,				ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_86,  0, NULL },
{ "cmp",    2, { M_ANY,    R8E     }, GP3, ALLOW_SEG | (REX | REXR) | (F_MODRM | F_MODRM_REG),	                    NO_VEX, NO_EVEX, 1, 1, { 0x38, 0x00, 0x00 }, 1, 0, MOD_MEM_REG, 0, 0,				ADDR_SIZE_OVERRIDE,             (X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_64,  0, NULL },
{ "cmp",    2, { M_ANY,    R8U     }, GP3, ALLOW_SEG | (REX) | (F_MODRM | F_MODRM_REG),						                  NO_VEX, NO_EVEX, 1, 1, { 0x38, 0x00, 0x00 }, 1, 0, MOD_MEM_REG, 0, 0,				ADDR_SIZE_OVERRIDE,             (X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_64,  0, NULL },
//39 / r CMP r / m16, r16
//39 / r CMP r / m32, r32
//REX.W + 39 / r CMP r / m64, r64
{ "cmp",     2, { M_ANY,    R16     }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                            NO_VEX, NO_EVEX, 1, 1, { 0x39, 0x00, 0x00 }, 2, 0, MOD_MEM_REG, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_86,  0, NULL },
{ "cmp",     2, { M_ANY,    R16E    }, GP3, ALLOW_SEG | (REX | REXR) | (F_MODRM | F_MODRM_REG),	                    NO_VEX, NO_EVEX, 1, 1, { 0x39, 0x00, 0x00 }, 2, 0, MOD_MEM_REG, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE,             (X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_64,  0, NULL },
{ "cmp",     2, { M_ANY,    R32     }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                            NO_VEX, NO_EVEX, 1, 1, { 0x39, 0x00, 0x00 }, 4, 0, MOD_MEM_REG, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_86,  0, NULL },
{ "cmp",     2, { M_ANY,    R32E    }, GP3, ALLOW_SEG | (REX | REXR) | (F_MODRM | F_MODRM_REG),	                    NO_VEX, NO_EVEX, 1, 1, { 0x39, 0x00, 0x00 }, 4, 0, MOD_MEM_REG, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE,             (X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_64,  0, NULL },
{ "cmp",     2, { M_ANY,    R64     }, GP3, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_REG),			                NO_VEX, NO_EVEX, 1, 1, { 0x39, 0x00, 0x00 }, 8, 0, MOD_MEM_REG, 0, 0,				          ADDR_SIZE_OVERRIDE,             (X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_64,  0, NULL },
{ "cmp",     2, { M_ANY,    R64E    }, GP3, ALLOW_SEG | (REX | REXW | REXR) | (F_MODRM | F_MODRM_REG),	            NO_VEX, NO_EVEX, 1, 1, { 0x39, 0x00, 0x00 }, 8, 0, MOD_MEM_REG, 0, 0,				          ADDR_SIZE_OVERRIDE,             (X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_64,  0, NULL },
//3A / r CMP r8, r / m8
//REX + 3A / r CMP r8*, r / m8 *
{ "cmp",     2, { R8,       R8      }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT | IMM8_ONLY),          NO_VEX, NO_EVEX, 1, 1, { 0x3a, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                  (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "cmp",     2, { R8,       R8H     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT | IMM8_ONLY),		      NO_VEX, NO_EVEX, 1, 1, { 0x3a, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                  (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "cmp",     2, { R8H,      R8      }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT | IMM8_ONLY),		      NO_VEX, NO_EVEX, 1, 1, { 0x3a, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                  (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "cmp",     2, { R8H,      R8H     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT | IMM8_ONLY),		      NO_VEX, NO_EVEX, 1, 1, { 0x3a, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                  (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "cmp",     2, { R8E,      R8E     }, GP3, (REX | REXB | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),	            NO_VEX, NO_EVEX, 1, 1, { 0x3a, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                              (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "cmp",     2, { R8,       R8E     }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				            NO_VEX, NO_EVEX, 1, 1, { 0x3a, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                              (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "cmp",     2, { R8E,      R8      }, GP3, (REX | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				            NO_VEX, NO_EVEX, 1, 1, { 0x3a, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                              (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "cmp",     2, { R8U,      R8      }, GP3, (REX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),					                  NO_VEX, NO_EVEX, 1, 1, { 0x3a, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                              (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "cmp",     2, { R8U,      R8E     }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),					          NO_VEX, NO_EVEX, 1, 1, { 0x3a, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                              (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "cmp",     2, { R8,       R8U     }, GP3, (REX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),					                  NO_VEX, NO_EVEX, 1, 1, { 0x3a, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                              (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "cmp",     2, { R8,       M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                            NO_VEX, NO_EVEX, 1, 1, { 0x3a, 0x00, 0x00 }, 1, 0, MOD_REG_MEM, 0, 0, ADDR_SIZE_OVERRIDE,                (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_86,  0, NULL },
{ "cmp",     2, { R8H,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                            NO_VEX, NO_EVEX, 1, 1, { 0x3a, 0x00, 0x00 }, 1, 0, MOD_REG_MEM, 0, 0,	ADDR_SIZE_OVERRIDE,                (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_86,  0, NULL },
{ "cmp",     2, { R8E,      M_ANY   }, GP3, ALLOW_SEG | (REX | REXR) | (F_MODRM | F_MODRM_REG),	                    NO_VEX, NO_EVEX, 1, 1, { 0x3a, 0x00, 0x00 }, 1, 0, MOD_REG_MEM, 0, 0,	ADDR_SIZE_OVERRIDE,                            (X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_64,  0, NULL },
{ "cmp",     2, { R8U,      M_ANY   }, GP3, ALLOW_SEG | (REX) | (F_MODRM | F_MODRM_REG),						                NO_VEX, NO_EVEX, 1, 1, { 0x3a, 0x00, 0x00 }, 1, 0, MOD_REG_MEM, 0, 0,	ADDR_SIZE_OVERRIDE,                            (X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_64,  0, NULL },
//3B / r CMP r16, r / m16
//3B / r CMP r32, r / m32
//REX.W + 3B / r CMP r64, r / m64
{ "cmp",     2, { R16,      R16     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                      NO_VEX, NO_EVEX, 1, 1, { 0x3b, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                   (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "cmp",     2, { R16E,     R16E    }, GP3, (REX | REXB | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),             NO_VEX, NO_EVEX, 1, 1, { 0x3b, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "cmp",     2, { R16E,     R16     }, GP3, (REX | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				            NO_VEX, NO_EVEX, 1, 1, { 0x3b, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "cmp",     2, { R16,      R16E    }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				            NO_VEX, NO_EVEX, 1, 1, { 0x3b, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "cmp",     2, { R32,      R32     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                      NO_VEX, NO_EVEX, 1, 1, { 0x3b, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, 0,                0,                   (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "cmp",     2, { R32E,     R32E    }, GP3, (REX | REXB | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),	            NO_VEX, NO_EVEX, 1, 1, { 0x3b, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, 0,                0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "cmp",     2, { R32E,     R32     }, GP3, (REX | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				            NO_VEX, NO_EVEX, 1, 1, { 0x3b, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, 0,                0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "cmp",     2, { R32,      R32E    }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				            NO_VEX, NO_EVEX, 1, 1, { 0x3b, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, 0,                0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "cmp",     2, { R64,      R64     }, GP3, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		                NO_VEX, NO_EVEX, 1, 1, { 0x3b, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "cmp",     2, { R64E,     R64E    }, GP3, (REX | REXR | REXB | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),      NO_VEX, NO_EVEX, 1, 1, { 0x3b, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "cmp",     2, { R64,      R64E    }, GP3, (REX | REXB | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		          NO_VEX, NO_EVEX, 1, 1, { 0x3b, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "cmp",     2, { R64E,     R64     }, GP3, (REX | REXR | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		          NO_VEX, NO_EVEX, 1, 1, { 0x3b, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "cmp",     2, { R16,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                            NO_VEX, NO_EVEX, 1, 1, { 0x3b, 0x00, 0x00 }, 2, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE, 0,                   (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_86,  0, NULL },
{ "cmp",     2, { R16E,     M_ANY   }, GP3, ALLOW_SEG | (REX | REXR) | (F_MODRM | F_MODRM_REG),	                    NO_VEX, NO_EVEX, 1, 1, { 0x3b, 0x00, 0x00 }, 2, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE,             (X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_64,  0, NULL },
{ "cmp",     2, { R32,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                            NO_VEX, NO_EVEX, 1, 1, { 0x3b, 0x00, 0x00 }, 4, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_86,  0, NULL },
{ "cmp",     2, { R32E,     M_ANY   }, GP3, ALLOW_SEG | (REX | REXR) | (F_MODRM | F_MODRM_REG),	                    NO_VEX, NO_EVEX, 1, 1, { 0x3b, 0x00, 0x00 }, 4, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE,             (X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_64,  0, NULL },
{ "cmp",     2, { R64,      M_ANY   }, GP3, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_REG),				              NO_VEX, NO_EVEX, 1, 1, { 0x3b, 0x00, 0x00 }, 8, 0, MOD_REG_MEM, 0, 0,				          ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_64,  0, NULL },
{ "cmp",     2, { R64E,     M_ANY   }, GP3, ALLOW_SEG | (REX | REXW | REXR) | (F_MODRM | F_MODRM_REG),	            NO_VEX, NO_EVEX, 1, 1, { 0x3b, 0x00, 0x00 }, 8, 0, MOD_REG_MEM, 0, 0,				          ADDR_SIZE_OVERRIDE,             (X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_64,  0, NULL },
//66 0F 38 F6 / r ADCX r32, r/m32 RM V / V ADX Unsigned addition of r32 with CF, r / m32 to r32, writes CF.
//66 REX.w 0F38 F6 / r ADCX r64, r/m64 RM V / NE ADX Unsigned addition of r64 with CF, r / m64 to r64, writes CF.
{ "adcx",    2, { R32,      R32     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                  NO_VEX, NO_EVEX, 1, 1, { 0xf6, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, 0,                0,            (X32 | X64), REG_DST,  PFX_0x66F38, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "adcx",    2, { R32E,     R32E    }, GP3, (REX | REXB | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),	        NO_VEX, NO_EVEX, 1, 1, { 0xf6, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, 0,                0,            (X32 | X64), REG_DST,  PFX_0x66F38, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "adcx",    2, { R32E,     R32     }, GP3, (REX | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				        NO_VEX, NO_EVEX, 1, 1, { 0xf6, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, 0,                0,            (X32 | X64), REG_DST,  PFX_0x66F38, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "adcx",    2, { R32,      R32E    }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				        NO_VEX, NO_EVEX, 1, 1, { 0xf6, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, 0,                0,            (X32 | X64), REG_DST,  PFX_0x66F38, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "adcx",    2, { R64,      R64     }, GP3, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		            NO_VEX, NO_EVEX, 1, 1, { 0xf6, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                  (X64), REG_DST,  PFX_0x66F38, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "adcx",    2, { R64E,     R64E    }, GP3, (REX | REXR | REXB | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),  NO_VEX, NO_EVEX, 1, 1, { 0xf6, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                  (X64), REG_DST,  PFX_0x66F38, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "adcx",    2, { R64,      R64E    }, GP3, (REX | REXB | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		      NO_VEX, NO_EVEX, 1, 1, { 0xf6, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                  (X64), REG_DST,  PFX_0x66F38, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "adcx",    2, { R64E,     R64     }, GP3, (REX | REXR | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		      NO_VEX, NO_EVEX, 1, 1, { 0xf6, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                  (X64), REG_DST,  PFX_0x66F38, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "adcx",    2, { R32,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                        NO_VEX, NO_EVEX, 1, 1, { 0xf6, 0x00, 0x00 }, 4, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE,       (X32 | X64), REG_DST, PFX_0x66F38, NO_IMM    , MEM_OPND_1, P_86,  0, NULL },
{ "adcx",    2, { R32E,     M_ANY   }, GP3, ALLOW_SEG | (REX | REXR) | (F_MODRM | F_MODRM_REG),	                NO_VEX, NO_EVEX, 1, 1, { 0xf6, 0x00, 0x00 }, 4, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE,       (X32 | X64), REG_DST, PFX_0x66F38, NO_IMM    , MEM_OPND_1, P_64,  0, NULL },
{ "adcx",    2, { R64,      M_ANY   }, GP3, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_REG),				          NO_VEX, NO_EVEX, 1, 1, { 0xf6, 0x00, 0x00 }, 8, 0, MOD_REG_MEM, 0, 0,				          ADDR_SIZE_OVERRIDE,       (X64), REG_DST, PFX_0x66F38, NO_IMM    , MEM_OPND_1, P_64,  0, NULL },
{ "adcx",    2, { R64E,     M_ANY   }, GP3, ALLOW_SEG | (REX | REXW | REXR) | (F_MODRM | F_MODRM_REG),	        NO_VEX, NO_EVEX, 1, 1, { 0xf6, 0x00, 0x00 }, 8, 0, MOD_REG_MEM, 0, 0,				          ADDR_SIZE_OVERRIDE,       (X64), REG_DST, PFX_0x66F38, NO_IMM    , MEM_OPND_1, P_64,  0, NULL },
//F30F38 F6 / r ADOX r32, r / m32 RM V / V ADX Unsigned addition of r32 with OF, r / m32 to r32, writes OF.
//F3 REX.w 0F38 F6 / r ADOX r64, r / m64 RM V / NE ADX Unsigned addition of r64 with OF, r / m64 to r64, writes OF.
{ "adox",    2, { R32,      R32     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                  NO_VEX, NO_EVEX, 1, 1, { 0xf6, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, 0,                0,            (X32 | X64), REG_DST,  PFX_0xF3F38, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "adox",    2, { R32E,     R32E    }, GP3, (REX | REXB | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),	        NO_VEX, NO_EVEX, 1, 1, { 0xf6, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, 0,                0,            (X32 | X64), REG_DST,  PFX_0xF3F38, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "adox",    2, { R32E,     R32     }, GP3, (REX | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				        NO_VEX, NO_EVEX, 1, 1, { 0xf6, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, 0,                0,            (X32 | X64), REG_DST,  PFX_0xF3F38, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "adox",    2, { R32,      R32E    }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				        NO_VEX, NO_EVEX, 1, 1, { 0xf6, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, 0,                0,            (X32 | X64), REG_DST,  PFX_0xF3F38, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "adox",    2, { R64,      R64     }, GP3, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		            NO_VEX, NO_EVEX, 1, 1, { 0xf6, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                  (X64), REG_DST,  PFX_0xF3F38, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "adox",    2, { R64E,     R64E    }, GP3, (REX | REXR | REXB | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),  NO_VEX, NO_EVEX, 1, 1, { 0xf6, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                  (X64), REG_DST,  PFX_0xF3F38, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "adox",    2, { R64,      R64E    }, GP3, (REX | REXB | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		      NO_VEX, NO_EVEX, 1, 1, { 0xf6, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                  (X64), REG_DST,  PFX_0xF3F38, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "adox",    2, { R64E,     R64     }, GP3, (REX | REXR | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		      NO_VEX, NO_EVEX, 1, 1, { 0xf6, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                  (X64), REG_DST,  PFX_0xF3F38, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "adox",    2, { R32,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                        NO_VEX, NO_EVEX, 1, 1, { 0xf6, 0x00, 0x00 }, 4, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE,       (X32 | X64), REG_DST, PFX_0xF3F38, NO_IMM    , MEM_OPND_1, P_86,  0, NULL },
{ "adox",    2, { R32E,     M_ANY   }, GP3, ALLOW_SEG | (REX | REXR) | (F_MODRM | F_MODRM_REG),	                NO_VEX, NO_EVEX, 1, 1, { 0xf6, 0x00, 0x00 }, 4, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE,       (X32 | X64), REG_DST, PFX_0xF3F38, NO_IMM    , MEM_OPND_1, P_64,  0, NULL },
{ "adox",    2, { R64,      M_ANY   }, GP3, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_REG),				          NO_VEX, NO_EVEX, 1, 1, { 0xf6, 0x00, 0x00 }, 8, 0, MOD_REG_MEM, 0, 0,				          ADDR_SIZE_OVERRIDE,       (X64), REG_DST, PFX_0xF3F38, NO_IMM    , MEM_OPND_1, P_64,  0, NULL },
{ "adox",    2, { R64E,     M_ANY   }, GP3, ALLOW_SEG | (REX | REXW | REXR) | (F_MODRM | F_MODRM_REG),	        NO_VEX, NO_EVEX, 1, 1, { 0xf6, 0x00, 0x00 }, 8, 0, MOD_REG_MEM, 0, 0,				          ADDR_SIZE_OVERRIDE,       (X64), REG_DST, PFX_0xF3F38, NO_IMM    , MEM_OPND_1, P_64,  0, NULL },
//ARPL r / m16, r16 63 / r 
{ "arpl",    2, { R16,      R16     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							          NO_VEX, NO_EVEX, 1, 1, { 0x63, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, 0, 0,                   (X16 | X32), RM_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "arpl",    2, { M_ANY,    R16     }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                NO_VEX, NO_EVEX, 1, 1, { 0x63, 0x00, 0x00 }, 2, 0, MOD_MEM_REG, 0, 0, 0, (X16 | X32), RM_DST,  NO_PREFIX, NO_IMM    , MEM_OPND_0, P_86,  0, NULL },
//BOUND r16, m16 & 16 62 / r 
//BOUND r32, m32 & 32 62 / r 
{ "bound",    2, { R16,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                  NO_VEX, NO_EVEX, 1, 1, { 0x62, 0x00, 0x00 }, 2, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32), REG_DST, NO_PREFIX, NO_IMM    , MEM_OPND_1, P_86,  0, NULL },
{ "bound",    2, { R32,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                  NO_VEX, NO_EVEX, 1, 1, { 0x62, 0x00, 0x00 }, 4, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32), REG_DST, NO_PREFIX, NO_IMM    , MEM_OPND_1, P_86,  0, NULL },
//BSF r16, r / m16 0F BC / r
//BSF r32, r / m32 0F BC / r
//BSF r64, r / m64 REX.W + 0F BC / r
{ "bsf",    2, { R16,      R16     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                NO_VEX, NO_EVEX, 1, 1, { 0xbc, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,      (X16 | X32 | X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "bsf",    2, { R16E,     R16E    }, GP3, (REX | REXB | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),        NO_VEX, NO_EVEX, 1, 1, { 0xbc, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                  (X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "bsf",    2, { R16E,     R16     }, GP3, (REX | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				        NO_VEX, NO_EVEX, 1, 1, { 0xbc, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                  (X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "bsf",    2, { R16,      R16E    }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				        NO_VEX, NO_EVEX, 1, 1, { 0xbc, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                  (X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "bsf",    2, { R32,      R32     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                NO_VEX, NO_EVEX, 1, 1, { 0xbc, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, 0,                0,      (X16 | X32 | X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "bsf",    2, { R32E,     R32E    }, GP3, (REX | REXB | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),	      NO_VEX, NO_EVEX, 1, 1, { 0xbc, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, 0,                0,                  (X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "bsf",    2, { R32E,     R32     }, GP3, (REX | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				        NO_VEX, NO_EVEX, 1, 1, { 0xbc, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, 0,                0,                  (X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "bsf",    2, { R32,      R32E    }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				        NO_VEX, NO_EVEX, 1, 1, { 0xbc, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, 0,                0,                  (X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "bsf",    2, { R64,      R64     }, GP3, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		            NO_VEX, NO_EVEX, 1, 1, { 0xbc, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                  (X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "bsf",    2, { R64E,     R64E    }, GP3, (REX | REXR | REXB | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM), NO_VEX, NO_EVEX, 1, 1, { 0xbc, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                  (X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "bsf",    2, { R64,      R64E    }, GP3, (REX | REXB | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		    NO_VEX, NO_EVEX, 1, 1, { 0xbc, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                  (X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "bsf",    2, { R64E,     R64     }, GP3, (REX | REXR | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		    NO_VEX, NO_EVEX, 1, 1, { 0xbc, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                  (X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "bsf",    2, { R16,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                        NO_VEX, NO_EVEX, 1, 1, { 0xbc, 0x00, 0x00 }, 2, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST, PFX_0xF, NO_IMM    , MEM_OPND_1, P_86,  0, NULL },
{ "bsf",    2, { R16E,     M_ANY   }, GP3, ALLOW_SEG | (REX | REXR) | (F_MODRM | F_MODRM_REG),	              NO_VEX, NO_EVEX, 1, 1, { 0xbc, 0x00, 0x00 }, 2, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE,             (X64), REG_DST, PFX_0xF, NO_IMM    , MEM_OPND_1, P_64,  0, NULL },
{ "bsf",    2, { R32,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                        NO_VEX, NO_EVEX, 1, 1, { 0xbc, 0x00, 0x00 }, 4, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST, PFX_0xF, NO_IMM    , MEM_OPND_1, P_86,  0, NULL },
{ "bsf",    2, { R32E,     M_ANY   }, GP3, ALLOW_SEG | (REX | REXR) | (F_MODRM | F_MODRM_REG),	              NO_VEX, NO_EVEX, 1, 1, { 0xbc, 0x00, 0x00 }, 4, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE,             (X64), REG_DST, PFX_0xF, NO_IMM    , MEM_OPND_1, P_64,  0, NULL },
{ "bsf",    2, { R64,      M_ANY   }, GP0, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_REG),				        NO_VEX, NO_EVEX, 1, 1, { 0xbc, 0x00, 0x00 }, 8, 0, MOD_REG_MEM, 0, 0,				          ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST, PFX_0xF, NO_IMM    , MEM_OPND_1, P_64,  0, NULL },
{ "bsf",    2, { R64E,     M_ANY   }, GP3, ALLOW_SEG | (REX | REXW | REXR) | (F_MODRM | F_MODRM_REG),	        NO_VEX, NO_EVEX, 1, 1, { 0xbc, 0x00, 0x00 }, 8, 0, MOD_REG_MEM, 0, 0,				          ADDR_SIZE_OVERRIDE,             (X64), REG_DST, PFX_0xF, NO_IMM    , MEM_OPND_1, P_64,  0, NULL },
//BSR r16, r / m16 0F BD / r 
//BSR r32, r / m32 0F BD / r 
//BSR r64, r / m64 REX.W + 0F BD / r 
{ "bsr",    2, { R16,      R16     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                NO_VEX, NO_EVEX, 1, 1, { 0xbd, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,      (X16 | X32 | X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "bsr",    2, { R16E,     R16E    }, GP3, (REX | REXB | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),        NO_VEX, NO_EVEX, 1, 1, { 0xbd, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                  (X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "bsr",    2, { R16E,     R16     }, GP3, (REX | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				        NO_VEX, NO_EVEX, 1, 1, { 0xbd, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                  (X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "bsr",    2, { R16,      R16E    }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				        NO_VEX, NO_EVEX, 1, 1, { 0xbd, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                  (X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "bsr",    2, { R32,      R32     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                NO_VEX, NO_EVEX, 1, 1, { 0xbd, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, 0,                0,      (X16 | X32 | X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "bsr",    2, { R32E,     R32E    }, GP3, (REX | REXB | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),	      NO_VEX, NO_EVEX, 1, 1, { 0xbd, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, 0,                0,                  (X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "bsr",    2, { R32E,     R32     }, GP3, (REX | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				        NO_VEX, NO_EVEX, 1, 1, { 0xbd, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, 0,                0,                  (X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "bsr",    2, { R32,      R32E    }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				        NO_VEX, NO_EVEX, 1, 1, { 0xbd, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, 0,                0,                  (X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "bsr",    2, { R64,      R64     }, GP3, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		            NO_VEX, NO_EVEX, 1, 1, { 0xbd, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                  (X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "bsr",    2, { R64E,     R64E    }, GP3, (REX | REXR | REXB | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM), NO_VEX, NO_EVEX, 1, 1, { 0xbd, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                  (X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "bsr",    2, { R64,      R64E    }, GP3, (REX | REXB | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		    NO_VEX, NO_EVEX, 1, 1, { 0xbd, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                  (X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "bsr",    2, { R64E,     R64     }, GP3, (REX | REXR | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		    NO_VEX, NO_EVEX, 1, 1, { 0xbd, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                               (X64), REG_DST, PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "bsr",    2, { R16,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                        NO_VEX, NO_EVEX, 1, 1, { 0xbd, 0x00, 0x00 }, 2, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST, PFX_0xF, NO_IMM    , MEM_OPND_1, P_86,  0, NULL },
{ "bsr",    2, { R16E,     M_ANY   }, GP3, ALLOW_SEG | (REX | REXR) | (F_MODRM | F_MODRM_REG),	              NO_VEX, NO_EVEX, 1, 1, { 0xbd, 0x00, 0x00 }, 2, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE,             (X64), REG_DST, PFX_0xF, NO_IMM    , MEM_OPND_1, P_64,  0, NULL },
{ "bsr",    2, { R32,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                        NO_VEX, NO_EVEX, 1, 1, { 0xbd, 0x00, 0x00 }, 4, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST, PFX_0xF, NO_IMM    , MEM_OPND_1, P_86,  0, NULL },
{ "bsr",    2, { R32E,     M_ANY   }, GP3, ALLOW_SEG | (REX | REXR) | (F_MODRM | F_MODRM_REG),	              NO_VEX, NO_EVEX, 1, 1, { 0xbd, 0x00, 0x00 }, 4, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE,             (X64), REG_DST, PFX_0xF, NO_IMM    , MEM_OPND_1, P_64,  0, NULL },
{ "bsr",    2, { R64,      M_ANY   }, GP0, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_REG),				        NO_VEX, NO_EVEX, 1, 1, { 0xbd, 0x00, 0x00 }, 8, 0, MOD_REG_MEM, 0, 0,				          ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST, PFX_0xF, NO_IMM    , MEM_OPND_1, P_64,  0, NULL },
{ "bsr",    2, { R64E,     M_ANY   }, GP3, ALLOW_SEG | (REX | REXW | REXR) | (F_MODRM | F_MODRM_REG),	        NO_VEX, NO_EVEX, 1, 1, { 0xbd, 0x00, 0x00 }, 8, 0, MOD_REG_MEM, 0, 0,				          ADDR_SIZE_OVERRIDE,             (X64), REG_DST, PFX_0xF, NO_IMM    , MEM_OPND_1, P_64,  0, NULL },
//BSWAP r32 0F C8 + rd 
//BSWAP r64 REX.W + 0F C8 + rd
{ "bswap",    1, { R32,         }, GP0, (F_MODRM_REG | F_MODRM_RM),							                  NO_VEX, NO_EVEX, 1, 1, { 0xc8, 0x00, 0x00 }, 4, 0, NO_MOD, 0, 0,                0,      (X16 | X32 | X64), NO_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "bswap",    1, { R32E,        }, GP3, (REX | REXB | REXR) | (F_MODRM_REG | F_MODRM_RM),	        NO_VEX, NO_EVEX, 1, 1, { 0xc8, 0x00, 0x00 }, 4, 0, NO_MOD, 0, 0,                0,                  (X64), NO_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "bswap",    1, { R64,         }, GP3, (REX | REXW) | (F_MODRM_REG | F_MODRM_RM),		            NO_VEX, NO_EVEX, 1, 1, { 0xc8, 0x00, 0x00 }, 8, 0, NO_MOD, 0, 0,                0,                  (X64), NO_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "bswap",    1, { R64E,        }, GP3, (REX | REXR | REXB | REXW) | (F_MODRM_REG | F_MODRM_RM),  NO_VEX, NO_EVEX, 1, 1, { 0xc8, 0x00, 0x00 }, 8, 0, NO_MOD, 0, 0,                0,                  (X64), NO_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
//BT r / m16, r16 0F A3 / r 
//BT r / m32, r32 0F A3 / r 
//BT r / m64, r64 REX.W + 0F A3 / r 
{ "bt",    2, { R16,      R16     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                  NO_VEX, NO_EVEX, 1, 1, { 0xa3, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                   (X16 | X32 | X64), RM_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "bt",    2, { R32,      R32     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                  NO_VEX, NO_EVEX, 1, 1, { 0xa3, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, 0,                0,                   (X16 | X32 | X64), RM_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "bt",    2, { R64,      R64     }, GP3, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		            NO_VEX, NO_EVEX, 1, 1, { 0xa3, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                               (X64), RM_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "bt",    2, { M_ANY,    R16     }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                        NO_VEX, NO_EVEX, 1, 1, { 0xa3, 0x00, 0x00 }, 2, 0, MOD_MEM_REG, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  PFX_0xF, NO_IMM    , MEM_OPND_0, P_86,  0, NULL },
{ "bt",    2, { M_ANY,    R32     }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                        NO_VEX, NO_EVEX, 1, 1, { 0xa3, 0x00, 0x00 }, 4, 0, MOD_MEM_REG, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  PFX_0xF, NO_IMM    , MEM_OPND_0, P_86,  0, NULL },
{ "bt",    2, { M_ANY,    R64     }, GP0, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_REG),			            NO_VEX, NO_EVEX, 1, 1, { 0xa3, 0x00, 0x00 }, 8, 0, MOD_MEM_REG, 0, 0,				ADDR_SIZE_OVERRIDE,                       (X64), RM_DST,  PFX_0xF, NO_IMM    , MEM_OPND_0, P_64,  0, NULL },
//BT r / m16, imm8 0F BA / 4 ib 
//BT r / m32, imm8 0F BA / 4 ib 
//BT r / m64, imm8 REX.W + 0F BA / 4 ib 
{ "bt",    2, { R16,      IMM8    }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	                    NO_VEX, NO_EVEX, 1, 1, { 0xba, 0x04, 0x00 }, 2, 0, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), RM_DST,  PFX_0xF, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "bt",    2, { M16,      IMM8    }, GP0, ALLOW_LOCK | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	        NO_VEX, NO_EVEX, 1, 1, { 0xba, 0x04, 0x00 }, 2, 0, MOD_MEM_IMM, 0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), RM_DST,  PFX_0xF, IMM_OPND_1, MEM_OPND_0, P_86,  0, NULL },
{ "bt",    2, { M_ANY,    IMM8    }, GP0, ALLOW_LOCK | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	        NO_VEX, NO_EVEX, 1, 1, { 0xba, 0x04, 0x00 }, 2, 0, MOD_MEM_IMM, 0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), RM_DST,  PFX_0xF, IMM_OPND_1, MEM_OPND_0, P_86,  0, NULL },
{ "bt",    2, { R32,      IMM8    }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	                    NO_VEX, NO_EVEX, 1, 1, { 0xba, 0x04, 0x00 }, 4, 0, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, ADDR_SIZE_OVERRIDE,                  (X16 | X32 | X64), RM_DST,  PFX_0xF, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "bt",    2, { M32,      IMM8    }, GP0, ALLOW_LOCK | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	        NO_VEX, NO_EVEX, 1, 1, { 0xba, 0x04, 0x00 }, 4, 0, MOD_MEM_IMM, 0, OP_SIZE_OVERRIDE, ADDR_SIZE_OVERRIDE,                  (X16 | X32 | X64), RM_DST,  PFX_0xF, IMM_OPND_1, MEM_OPND_0, P_86,  0, NULL },
{ "bt",    2, { M_ANY,    IMM8    }, GP0, ALLOW_LOCK | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	        NO_VEX, NO_EVEX, 1, 1, { 0xba, 0x04, 0x00 }, 4, 0, MOD_MEM_IMM, 0, OP_SIZE_OVERRIDE, ADDR_SIZE_OVERRIDE,                  (X16 | X32 | X64), RM_DST,  PFX_0xF, IMM_OPND_1, MEM_OPND_0, P_86,  0, NULL },
{ "bt",    2, { R64,      IMM8    }, GP3, REXW | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	              NO_VEX, NO_EVEX, 1, 1, { 0xba, 0x04, 0x00 }, 8, 0, MOD_REG_IMM, 0, 0,	               0,  (X16 | X32 | X64), RM_DST,  PFX_0xF, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
{ "bt",    2, { M64,      IMM8    }, GP3, REXW | ALLOW_LOCK | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	NO_VEX, NO_EVEX, 1, 1, { 0xba, 0x04, 0x00 }, 8, 0, MOD_MEM_IMM, 0, 0,	               0,  (X16 | X32 | X64), RM_DST,  PFX_0xF, IMM_OPND_1, MEM_OPND_0, P_64,  0, NULL },
{ "bt",    2, { M_ANY,    IMM8    }, GP3, REXW | ALLOW_LOCK | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	NO_VEX, NO_EVEX, 1, 1, { 0xba, 0x04, 0x00 }, 8, 0, MOD_MEM_IMM, 0, 0,	               0,  (X16 | X32 | X64), RM_DST,  PFX_0xF, IMM_OPND_1, MEM_OPND_0, P_64,  0, NULL },
//BTC r / m16, r16   0F BB / r             
//BTC r / m32, r32   0F BB / r             
//BTC r / m64, r64   REX.W + 0F BB / r     
{ "btc",    2, { R16,      R16     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                  NO_VEX, NO_EVEX, 1, 1, { 0xbb, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                   (X16 | X32 | X64), RM_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "btc",    2, { R32,      R32     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                  NO_VEX, NO_EVEX, 1, 1, { 0xbb, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, 0,                0,                   (X16 | X32 | X64), RM_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "btc",    2, { R64,      R64     }, GP3, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		              NO_VEX, NO_EVEX, 1, 1, { 0xbb, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                               (X64), RM_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "btc",    2, { M_ANY,    R16     }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                          NO_VEX, NO_EVEX, 1, 1, { 0xbb, 0x00, 0x00 }, 2, 0, MOD_MEM_REG, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  PFX_0xF, NO_IMM    , MEM_OPND_0, P_86,  0, NULL },
{ "btc",    2, { M_ANY,    R32     }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                          NO_VEX, NO_EVEX, 1, 1, { 0xbb, 0x00, 0x00 }, 4, 0, MOD_MEM_REG, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  PFX_0xF, NO_IMM    , MEM_OPND_0, P_86,  0, NULL },
{ "btc",    2, { M_ANY,    R64     }, GP0, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_REG),			            NO_VEX, NO_EVEX, 1, 1, { 0xbb, 0x00, 0x00 }, 8, 0, MOD_MEM_REG, 0, 0,				ADDR_SIZE_OVERRIDE,                       (X64), RM_DST,  PFX_0xF, NO_IMM    , MEM_OPND_0, P_64,  0, NULL },
//BTC r / m16, imm8  0F BA / 7 ib          
//BTC r / m32, imm8  0F BA / 7 ib          
//BTC r / m64, imm8  REX.W + 0F BA / 7 ib  
{ "btc",    2, { R16,      IMM8    }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	                    NO_VEX, NO_EVEX, 1, 1, { 0xba, 0x07, 0x00 }, 2, 0, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), RM_DST,  PFX_0xF, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "btc",    2, { M16,      IMM8    }, GP0, ALLOW_LOCK | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	      NO_VEX, NO_EVEX, 1, 1, { 0xba, 0x07, 0x00 }, 2, 0, MOD_MEM_IMM, 0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), RM_DST,  PFX_0xF, IMM_OPND_1, MEM_OPND_0, P_86,  0, NULL },
{ "btc",    2, { M_ANY,    IMM8    }, GP0, ALLOW_LOCK | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	      NO_VEX, NO_EVEX, 1, 1, { 0xba, 0x07, 0x00 }, 2, 0, MOD_MEM_IMM, 0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), RM_DST,  PFX_0xF, IMM_OPND_1, MEM_OPND_0, P_86,  0, NULL },
{ "btc",    2, { R32,      IMM8    }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	                    NO_VEX, NO_EVEX, 1, 1, { 0xba, 0x07, 0x00 }, 4, 0, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), RM_DST,  PFX_0xF, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "btc",    2, { M32,      IMM8    }, GP0, ALLOW_LOCK | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	      NO_VEX, NO_EVEX, 1, 1, { 0xba, 0x07, 0x00 }, 4, 0, MOD_MEM_IMM, 0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), RM_DST,  PFX_0xF, IMM_OPND_1, MEM_OPND_0, P_86,  0, NULL },
{ "btc",    2, { M_ANY,    IMM8    }, GP0, ALLOW_LOCK | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	      NO_VEX, NO_EVEX, 1, 1, { 0xba, 0x07, 0x00 }, 4, 0, MOD_MEM_IMM, 0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), RM_DST,  PFX_0xF, IMM_OPND_1, MEM_OPND_0, P_86,  0, NULL },
{ "btc",    2, { R64,      IMM8    }, GP3, REXW | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	            NO_VEX, NO_EVEX, 1, 1, { 0xba, 0x07, 0x00 }, 8, 0, MOD_REG_IMM, 0, 0,	               0,  (X16 | X32 | X64), RM_DST,  PFX_0xF, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
{ "btc",    2, { M64,      IMM8    }, GP3, REXW | ALLOW_LOCK | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	NO_VEX, NO_EVEX, 1, 1, { 0xba, 0x07, 0x00 }, 8, 0, MOD_MEM_IMM, 0, 0,	               0,  (X16 | X32 | X64), RM_DST,  PFX_0xF, IMM_OPND_1, MEM_OPND_0, P_64,  0, NULL },
{ "btc",    2, { M_ANY,    IMM8    }, GP3, REXW | ALLOW_LOCK | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	NO_VEX, NO_EVEX, 1, 1, { 0xba, 0x07, 0x00 }, 8, 0, MOD_MEM_IMM, 0, 0,	               0,  (X16 | X32 | X64), RM_DST,  PFX_0xF, IMM_OPND_1, MEM_OPND_0, P_64,  0, NULL },
//BTR r / m16, r16 0F B3 / r 
//BTR r / m32, r32 0F B3 / r 
//BTR r / m64, r64 REX.W + 0F B3 / r 
{ "btr",    2, { R16,      R16     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                  NO_VEX, NO_EVEX, 1, 1, { 0xb3, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                   (X16 | X32 | X64), RM_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "btr",    2, { R32,      R32     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                  NO_VEX, NO_EVEX, 1, 1, { 0xb3, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, 0,                0,                   (X16 | X32 | X64), RM_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "btr",    2, { R64,      R64     }, GP3, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		              NO_VEX, NO_EVEX, 1, 1, { 0xb3, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                               (X64), RM_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "btr",    2, { M_ANY,    R16     }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                          NO_VEX, NO_EVEX, 1, 1, { 0xb3, 0x00, 0x00 }, 2, 0, MOD_MEM_REG, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  PFX_0xF, NO_IMM    , MEM_OPND_0, P_86,  0, NULL },
{ "btr",    2, { M_ANY,    R32     }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                          NO_VEX, NO_EVEX, 1, 1, { 0xb3, 0x00, 0x00 }, 4, 0, MOD_MEM_REG, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  PFX_0xF, NO_IMM    , MEM_OPND_0, P_86,  0, NULL },
{ "btr",    2, { M_ANY,    R64     }, GP0, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_REG),			            NO_VEX, NO_EVEX, 1, 1, { 0xb3, 0x00, 0x00 }, 8, 0, MOD_MEM_REG, 0, 0,				ADDR_SIZE_OVERRIDE,                       (X64), RM_DST,  PFX_0xF, NO_IMM    , MEM_OPND_0, P_64,  0, NULL },
//BTR r / m16, imm8 0F BA /          6 ib 
//BTR r / m32, imm8 0F BA /          6 ib 
//BTR r / m64, imm8 REX.W + 0F BA /  6 ib 
{ "btr",    2, { R16,      IMM8    }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	                    NO_VEX, NO_EVEX, 1, 1, { 0xba, 0x06, 0x00 }, 2, 0, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), RM_DST,  PFX_0xF, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "btr",    2, { M16,      IMM8    }, GP0, ALLOW_LOCK | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	      NO_VEX, NO_EVEX, 1, 1, { 0xba, 0x06, 0x00 }, 2, 0, MOD_MEM_IMM, 0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), RM_DST,  PFX_0xF, IMM_OPND_1, MEM_OPND_0, P_86,  0, NULL },
{ "btr",    2, { M_ANY,    IMM8    }, GP0, ALLOW_LOCK | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	      NO_VEX, NO_EVEX, 1, 1, { 0xba, 0x06, 0x00 }, 2, 0, MOD_MEM_IMM, 0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), RM_DST,  PFX_0xF, IMM_OPND_1, MEM_OPND_0, P_86,  0, NULL },
{ "btr",    2, { R32,      IMM8    }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	                    NO_VEX, NO_EVEX, 1, 1, { 0xba, 0x06, 0x00 }, 4, 0, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), RM_DST,  PFX_0xF, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "btr",    2, { M32,      IMM8    }, GP0, ALLOW_LOCK | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	      NO_VEX, NO_EVEX, 1, 1, { 0xba, 0x06, 0x00 }, 4, 0, MOD_MEM_IMM, 0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), RM_DST,  PFX_0xF, IMM_OPND_1, MEM_OPND_0, P_86,  0, NULL },
{ "btr",    2, { M_ANY,    IMM8    }, GP0, ALLOW_LOCK | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	      NO_VEX, NO_EVEX, 1, 1, { 0xba, 0x06, 0x00 }, 4, 0, MOD_MEM_IMM, 0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), RM_DST,  PFX_0xF, IMM_OPND_1, MEM_OPND_0, P_86,  0, NULL },
{ "btr",    2, { R64,      IMM8    }, GP3, REXW | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	            NO_VEX, NO_EVEX, 1, 1, { 0xba, 0x06, 0x00 }, 8, 0, MOD_REG_IMM, 0, 0,	               0,  (X16 | X32 | X64), RM_DST,  PFX_0xF, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
{ "btr",    2, { M64,      IMM8    }, GP3, REXW | ALLOW_LOCK | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	NO_VEX, NO_EVEX, 1, 1, { 0xba, 0x06, 0x00 }, 8, 0, MOD_MEM_IMM, 0, 0,	               0,  (X16 | X32 | X64), RM_DST,  PFX_0xF, IMM_OPND_1, MEM_OPND_0, P_64,  0, NULL },
{ "btr",    2, { M_ANY,    IMM8    }, GP3, REXW | ALLOW_LOCK | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	NO_VEX, NO_EVEX, 1, 1, { 0xba, 0x06, 0x00 }, 8, 0, MOD_MEM_IMM, 0, 0,	               0,  (X16 | X32 | X64), RM_DST,  PFX_0xF, IMM_OPND_1, MEM_OPND_0, P_64,  0, NULL },
//BTS r / m16, r16  0F AB / r 
//BTS r / m32, r32  0F AB / r 
//BTS r / m64, r64  REX.W + 0F AB / r 
{ "bts",    2, { R16,      R16     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                  NO_VEX, NO_EVEX, 1, 1, { 0xab, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                   (X16 | X32 | X64), RM_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "bts",    2, { R32,      R32     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                  NO_VEX, NO_EVEX, 1, 1, { 0xab, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, 0,                0,                   (X16 | X32 | X64), RM_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "bts",    2, { R64,      R64     }, GP3, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		              NO_VEX, NO_EVEX, 1, 1, { 0xab, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                               (X64), RM_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "bts",    2, { M_ANY,    R16     }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                          NO_VEX, NO_EVEX, 1, 1, { 0xab, 0x00, 0x00 }, 2, 0, MOD_MEM_REG, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  PFX_0xF, NO_IMM    , MEM_OPND_0, P_86,  0, NULL },
{ "bts",    2, { M_ANY,    R32     }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                          NO_VEX, NO_EVEX, 1, 1, { 0xab, 0x00, 0x00 }, 4, 0, MOD_MEM_REG, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  PFX_0xF, NO_IMM    , MEM_OPND_0, P_86,  0, NULL },
{ "bts",    2, { M_ANY,    R64     }, GP0, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_REG),			            NO_VEX, NO_EVEX, 1, 1, { 0xab, 0x00, 0x00 }, 8, 0, MOD_MEM_REG, 0, 0,				ADDR_SIZE_OVERRIDE,                       (X64), RM_DST,  PFX_0xF, NO_IMM    , MEM_OPND_0, P_64,  0, NULL },
//BTS r / m16, imm8  0F BA /          5 ib 
//BTS r / m32, imm8  0F BA /          5 ib 
//BTS r / m64, imm8  REX.W + 0F BA /  5 ib 
{ "bts",    2, { R16,      IMM8    }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	        NO_VEX, NO_EVEX, 1, 1, { 0xba, 0x05, 0x00 }, 2, 0, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), RM_DST,  PFX_0xF, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "bts",    2, { M16,      IMM8    }, GP0, ALLOW_LOCK | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	        NO_VEX, NO_EVEX, 1, 1, { 0xba, 0x05, 0x00 }, 2, 0, MOD_MEM_IMM, 0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), RM_DST,  PFX_0xF, IMM_OPND_1, MEM_OPND_0, P_86,  0, NULL },
{ "bts",    2, { M_ANY,    IMM8    }, GP0, ALLOW_LOCK | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	        NO_VEX, NO_EVEX, 1, 1, { 0xba, 0x05, 0x00 }, 2, 0, MOD_MEM_IMM, 0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), RM_DST,  PFX_0xF, IMM_OPND_1, MEM_OPND_0, P_86,  0, NULL },
{ "bts",    2, { R32,      IMM8    }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	        NO_VEX, NO_EVEX, 1, 1, { 0xba, 0x05, 0x00 }, 4, 0, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), RM_DST,  PFX_0xF, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "bts",    2, { M32,      IMM8    }, GP0, ALLOW_LOCK | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	        NO_VEX, NO_EVEX, 1, 1, { 0xba, 0x05, 0x00 }, 4, 0, MOD_MEM_IMM, 0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), RM_DST,  PFX_0xF, IMM_OPND_1, MEM_OPND_0, P_86,  0, NULL },
{ "bts",    2, { M_ANY,    IMM8    }, GP0, ALLOW_LOCK | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	        NO_VEX, NO_EVEX, 1, 1, { 0xba, 0x05, 0x00 }, 4, 0, MOD_MEM_IMM, 0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), RM_DST,  PFX_0xF, IMM_OPND_1, MEM_OPND_0, P_86,  0, NULL },
{ "bts",    2, { R64,      IMM8    }, GP3, REXW | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	NO_VEX, NO_EVEX, 1, 1, { 0xba, 0x05, 0x00 }, 8, 0, MOD_REG_IMM, 0, 0,	               0,                  (X16 | X32 | X64), RM_DST,  PFX_0xF, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
{ "bts",    2, { M64,      IMM8    }, GP3, REXW | ALLOW_LOCK | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	NO_VEX, NO_EVEX, 1, 1, { 0xba, 0x05, 0x00 }, 8, 0, MOD_MEM_IMM, 0, 0,	               0,                  (X16 | X32 | X64), RM_DST,  PFX_0xF, IMM_OPND_1, MEM_OPND_0, P_64,  0, NULL },
{ "bts",    2, { M_ANY,    IMM8    }, GP3, REXW | ALLOW_LOCK | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	NO_VEX, NO_EVEX, 1, 1, { 0xba, 0x05, 0x00 }, 8, 0, MOD_MEM_IMM, 0, 0,	               0,                  (X16 | X32 | X64), RM_DST,  PFX_0xF, IMM_OPND_1, MEM_OPND_0, P_64,  0, NULL },
//ins(SETcc, seta, OpCls(R8_M08, NONE, NONE), F_0F, 0, no_WDS, 0x97, 0x00, P_386, 0)
{ "seta",   1, { R8,         }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),							  NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x97, 0x00 }, 1, 0, MOD_REG_REG, 0, 0, 0,                                 (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "seta",   1, { R8H,        }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),							  NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x97, 0x00 }, 1, 0, MOD_REG_REG, 0, 0, 0,                                 (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "seta",   1, { M8,         }, GP3, ALLOW_SEG | REXW | (F_MODRM | F_MODRM_RM),                     NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x97, 0x00 }, 1, 0, MOD_MEM_REG, 0, 0, ADDR_SIZE_OVERRIDE,                (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_0, P_64,  0, NULL },
{ "setae",  1, { R8,         }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),							  NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x93, 0x00 }, 1, 0, MOD_REG_REG, 0, 0, 0,                                 (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "setae",  1, { R8H,        }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),							  NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x93, 0x00 }, 1, 0, MOD_REG_REG, 0, 0, 0,                                 (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "setae",  1, { M8,         }, GP3, ALLOW_SEG | REXW | (F_MODRM | F_MODRM_RM),                     NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x93, 0x00 }, 1, 0, MOD_MEM_REG, 0, 0, ADDR_SIZE_OVERRIDE,                (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_0, P_64,  0, NULL },
{ "setb",   1, { R8,         }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),							  NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x92, 0x00 }, 1, 0, MOD_REG_REG, 0, 0, 0,                                 (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "setb",   1, { R8H,        }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),							  NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x92, 0x00 }, 1, 0, MOD_REG_REG, 0, 0, 0,                                 (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "setb",   1, { M8,         }, GP3, ALLOW_SEG | REXW | (F_MODRM | F_MODRM_RM),                     NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x92, 0x00 }, 1, 0, MOD_MEM_REG, 0, 0, ADDR_SIZE_OVERRIDE,                (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_0, P_64,  0, NULL },
{ "setbe",  1, { R8,         }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),							  NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x96, 0x00 }, 1, 0, MOD_REG_REG, 0, 0, 0,                                 (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "setbe",  1, { R8H,        }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),							  NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x96, 0x00 }, 1, 0, MOD_REG_REG, 0, 0, 0,                                 (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "setbe",  1, { M8,         }, GP3, ALLOW_SEG | REXW | (F_MODRM | F_MODRM_RM),                     NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x96, 0x00 }, 1, 0, MOD_MEM_REG, 0, 0, ADDR_SIZE_OVERRIDE,                (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_0, P_64,  0, NULL },
{ "setc",   1, { R8,         }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),							  NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x92, 0x00 }, 1, 0, MOD_REG_REG, 0, 0, 0,                                 (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "setc",   1, { R8H,        }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),							  NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x92, 0x00 }, 1, 0, MOD_REG_REG, 0, 0, 0,                                 (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "setc",   1, { M8,         }, GP3, ALLOW_SEG | REXW | (F_MODRM | F_MODRM_RM),                     NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x92, 0x00 }, 1, 0, MOD_MEM_REG, 0, 0, ADDR_SIZE_OVERRIDE,                (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_0, P_64,  0, NULL },
{ "sete",   1, { R8,         }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),							  NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x94, 0x00 }, 1, 0, MOD_REG_REG, 0, 0, 0,                                 (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "sete",   1, { R8H,        }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),							  NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x94, 0x00 }, 1, 0, MOD_REG_REG, 0, 0, 0,                                 (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "sete",   1, { M8,         }, GP3, ALLOW_SEG | REXW | (F_MODRM | F_MODRM_RM),                     NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x94, 0x00 }, 1, 0, MOD_MEM_REG, 0, 0, ADDR_SIZE_OVERRIDE,                (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_0, P_64,  0, NULL },
{ "setg",   1, { R8,         }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),							  NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x9f, 0x00 }, 1, 0, MOD_REG_REG, 0, 0, 0,                                 (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "setg",   1, { R8H,        }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),							  NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x9f, 0x00 }, 1, 0, MOD_REG_REG, 0, 0, 0,                                 (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "setg",   1, { M8,         }, GP3, ALLOW_SEG | REXW | (F_MODRM | F_MODRM_RM),                     NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x9f, 0x00 }, 1, 0, MOD_MEM_REG, 0, 0, ADDR_SIZE_OVERRIDE,                (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_0, P_64,  0, NULL },
{ "setge",  1, { R8,         }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),							  NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x9d, 0x00 }, 1, 0, MOD_REG_REG, 0, 0, 0,                                 (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "setge",  1, { R8H,        }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),							  NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x9d, 0x00 }, 1, 0, MOD_REG_REG, 0, 0, 0,                                 (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "setge",  1, { M8,         }, GP3, ALLOW_SEG | REXW | (F_MODRM | F_MODRM_RM),                     NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x9d, 0x00 }, 1, 0, MOD_MEM_REG, 0, 0, ADDR_SIZE_OVERRIDE,                (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_0, P_64,  0, NULL },
{ "setl",   1, { R8,         }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),							  NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x9c, 0x00 }, 1, 0, MOD_REG_REG, 0, 0, 0,                                 (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "setl",   1, { R8H,        }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),							  NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x9c, 0x00 }, 1, 0, MOD_REG_REG, 0, 0, 0,                                 (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "setl",   1, { M8,         }, GP3, ALLOW_SEG | REXW | (F_MODRM | F_MODRM_RM),                     NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x9c, 0x00 }, 1, 0, MOD_MEM_REG, 0, 0, ADDR_SIZE_OVERRIDE,                (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_0, P_64,  0, NULL },
{ "setle",  1, { R8,         }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),							  NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x9e, 0x00 }, 1, 0, MOD_REG_REG, 0, 0, 0,                                 (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "setle",  1, { R8H,        }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),							  NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x9e, 0x00 }, 1, 0, MOD_REG_REG, 0, 0, 0,                                 (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "setle",  1, { M8,         }, GP3, ALLOW_SEG | REXW | (F_MODRM | F_MODRM_RM),                     NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x9e, 0x00 }, 1, 0, MOD_MEM_REG, 0, 0, ADDR_SIZE_OVERRIDE,                (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_0, P_64,  0, NULL },
{ "setna",  1, { R8,         }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),							  NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x96, 0x00 }, 1, 0, MOD_REG_REG, 0, 0, 0,                                 (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "setna",  1, { R8H,        }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),							  NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x96, 0x00 }, 1, 0, MOD_REG_REG, 0, 0, 0,                                 (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "setna",  1, { M8,         }, GP3, ALLOW_SEG | REXW | (F_MODRM | F_MODRM_RM),                     NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x96, 0x00 }, 1, 0, MOD_MEM_REG, 0, 0, ADDR_SIZE_OVERRIDE,                (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_0, P_64,  0, NULL },
{ "setnae", 1, { R8,         }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),							  NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x92, 0x00 }, 1, 0, MOD_REG_REG, 0, 0, 0,                                 (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "setnae", 1, { R8H,        }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),							  NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x92, 0x00 }, 1, 0, MOD_REG_REG, 0, 0, 0,                                 (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "setnae", 1, { M8,         }, GP3, ALLOW_SEG | REXW | (F_MODRM | F_MODRM_RM),                     NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x92, 0x00 }, 1, 0, MOD_MEM_REG, 0, 0, ADDR_SIZE_OVERRIDE,                (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_0, P_64,  0, NULL },
{ "setnb",  1, { R8,         }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),							  NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x93, 0x00 }, 1, 0, MOD_REG_REG, 0, 0, 0,                                 (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "setnb",  1, { R8H,        }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),							  NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x93, 0x00 }, 1, 0, MOD_REG_REG, 0, 0, 0,                                 (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "setnb",  1, { M8,         }, GP3, ALLOW_SEG | REXW | (F_MODRM | F_MODRM_RM),                     NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x93, 0x00 }, 1, 0, MOD_MEM_REG, 0, 0, ADDR_SIZE_OVERRIDE,                (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_0, P_64,  0, NULL },
{ "setnbe", 1, { R8,         }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),							  NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x97, 0x00 }, 1, 0, MOD_REG_REG, 0, 0, 0,                                 (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "setnbe", 1, { R8H,        }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),							  NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x97, 0x00 }, 1, 0, MOD_REG_REG, 0, 0, 0,                                 (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "setnbe", 1, { M8,         }, GP3, ALLOW_SEG | REXW | (F_MODRM | F_MODRM_RM),                     NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x97, 0x00 }, 1, 0, MOD_MEM_REG, 0, 0, ADDR_SIZE_OVERRIDE,                (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_0, P_64,  0, NULL },
{ "setnc",  1, { R8,         }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),							  NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x93, 0x00 }, 1, 0, MOD_REG_REG, 0, 0, 0,                                 (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "setnc",  1, { R8H,        }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),							  NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x93, 0x00 }, 1, 0, MOD_REG_REG, 0, 0, 0,                                 (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "setnc",  1, { M8,         }, GP3, ALLOW_SEG | REXW | (F_MODRM | F_MODRM_RM),                     NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x93, 0x00 }, 1, 0, MOD_MEM_REG, 0, 0, ADDR_SIZE_OVERRIDE,                (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_0, P_64,  0, NULL },
{ "setne",  1, { R8,         }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),							  NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x95, 0x00 }, 1, 0, MOD_REG_REG, 0, 0, 0,                                 (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "setne",  1, { R8H,        }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),							  NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x95, 0x00 }, 1, 0, MOD_REG_REG, 0, 0, 0,                                 (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "setne",  1, { M8,         }, GP3, ALLOW_SEG | REXW | (F_MODRM | F_MODRM_RM),                     NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x95, 0x00 }, 1, 0, MOD_MEM_REG, 0, 0, ADDR_SIZE_OVERRIDE,                (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_0, P_64,  0, NULL },
{ "setng",  1, { R8,         }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),							  NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x9e, 0x00 }, 1, 0, MOD_REG_REG, 0, 0, 0,                                 (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "setng",  1, { R8H,        }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),							  NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x9e, 0x00 }, 1, 0, MOD_REG_REG, 0, 0, 0,                                 (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "setng",  1, { M8,         }, GP3, ALLOW_SEG | REXW | (F_MODRM | F_MODRM_RM),                     NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x9e, 0x00 }, 1, 0, MOD_MEM_REG, 0, 0, ADDR_SIZE_OVERRIDE,                (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_0, P_64,  0, NULL },
{ "setnge", 1, { R8,         }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),							  NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x9c, 0x00 }, 1, 0, MOD_REG_REG, 0, 0, 0,                                 (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "setnge", 1, { R8H,        }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),							  NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x9c, 0x00 }, 1, 0, MOD_REG_REG, 0, 0, 0,                                 (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "setnge", 1, { M8,         }, GP3, ALLOW_SEG | REXW | (F_MODRM | F_MODRM_RM),                     NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x9c, 0x00 }, 1, 0, MOD_MEM_REG, 0, 0, ADDR_SIZE_OVERRIDE,                (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_0, P_64,  0, NULL },
{ "setnl",  1, { R8,         }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),							  NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x9d, 0x00 }, 1, 0, MOD_REG_REG, 0, 0, 0,                                 (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "setnl",  1, { R8H,        }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),							  NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x9d, 0x00 }, 1, 0, MOD_REG_REG, 0, 0, 0,                                 (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "setnl",  1, { M8,         }, GP3, ALLOW_SEG | REXW | (F_MODRM | F_MODRM_RM),                     NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x9d, 0x00 }, 1, 0, MOD_MEM_REG, 0, 0, ADDR_SIZE_OVERRIDE,                (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_0, P_64,  0, NULL },
{ "setnle", 1, { R8,         }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),							  NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x9f, 0x00 }, 1, 0, MOD_REG_REG, 0, 0, 0,                                 (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "setnle", 1, { R8H,        }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),							  NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x9f, 0x00 }, 1, 0, MOD_REG_REG, 0, 0, 0,                                 (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "setnle", 1, { M8,         }, GP3, ALLOW_SEG | REXW | (F_MODRM | F_MODRM_RM),                     NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x9f, 0x00 }, 1, 0, MOD_MEM_REG, 0, 0, ADDR_SIZE_OVERRIDE,                (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_0, P_64,  0, NULL },
{ "setno",  1, { R8,         }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),							  NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x91, 0x00 }, 1, 0, MOD_REG_REG, 0, 0, 0,                                 (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "setno",  1, { R8H,        }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),							  NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x91, 0x00 }, 1, 0, MOD_REG_REG, 0, 0, 0,                                 (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "setno",  1, { M8,         }, GP3, ALLOW_SEG | REXW | (F_MODRM | F_MODRM_RM),                     NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x91, 0x00 }, 1, 0, MOD_MEM_REG, 0, 0, ADDR_SIZE_OVERRIDE,                (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_0, P_64,  0, NULL },
{ "setnp",  1, { R8,         }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),							  NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x9b, 0x00 }, 1, 0, MOD_REG_REG, 0, 0, 0,                                 (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "setnp",  1, { R8H,        }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),							  NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x9b, 0x00 }, 1, 0, MOD_REG_REG, 0, 0, 0,                                 (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "setnp",  1, { M8,         }, GP3, ALLOW_SEG | REXW | (F_MODRM | F_MODRM_RM),                     NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x9b, 0x00 }, 1, 0, MOD_MEM_REG, 0, 0, ADDR_SIZE_OVERRIDE,                (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_0, P_64,  0, NULL },
{ "setns",  1, { R8,         }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),							  NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x99, 0x00 }, 1, 0, MOD_REG_REG, 0, 0, 0,                                 (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "setns",  1, { R8H,        }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),							  NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x99, 0x00 }, 1, 0, MOD_REG_REG, 0, 0, 0,                                 (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "setns",  1, { M8,         }, GP3, ALLOW_SEG | REXW | (F_MODRM | F_MODRM_RM),                     NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x99, 0x00 }, 1, 0, MOD_MEM_REG, 0, 0, ADDR_SIZE_OVERRIDE,                (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_0, P_64,  0, NULL },
{ "setnz",  1, { R8,         }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),							  NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x95, 0x00 }, 1, 0, MOD_REG_REG, 0, 0, 0,                                 (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "setnz",  1, { R8H,        }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),							  NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x95, 0x00 }, 1, 0, MOD_REG_REG, 0, 0, 0,                                 (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "setnz",  1, { M8,         }, GP3, ALLOW_SEG | REXW | (F_MODRM | F_MODRM_RM),                     NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x95, 0x00 }, 1, 0, MOD_MEM_REG, 0, 0, ADDR_SIZE_OVERRIDE,                (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_0, P_64,  0, NULL },
{ "seto",   1, { R8,         }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),							  NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x90, 0x00 }, 1, 0, MOD_REG_REG, 0, 0, 0,                                 (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "seto",   1, { R8H,        }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),							  NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x90, 0x00 }, 1, 0, MOD_REG_REG, 0, 0, 0,                                 (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "seto",   1, { M8,         }, GP3, ALLOW_SEG | REXW | (F_MODRM | F_MODRM_RM),                     NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x90, 0x00 }, 1, 0, MOD_MEM_REG, 0, 0, ADDR_SIZE_OVERRIDE,                (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_0, P_64,  0, NULL },
{ "setp",   1, { R8,         }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),							  NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x9a, 0x00 }, 1, 0, MOD_REG_REG, 0, 0, 0,                                 (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "setp",   1, { R8H,        }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),							  NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x9a, 0x00 }, 1, 0, MOD_REG_REG, 0, 0, 0,                                 (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "setp",   1, { M8,         }, GP3, ALLOW_SEG | REXW | (F_MODRM | F_MODRM_RM),                     NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x9a, 0x00 }, 1, 0, MOD_MEM_REG, 0, 0, ADDR_SIZE_OVERRIDE,                (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_0, P_64,  0, NULL },
{ "setpe",  1, { R8,         }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),							  NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x9a, 0x00 }, 1, 0, MOD_REG_REG, 0, 0, 0,                                 (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "setpe",  1, { R8H,        }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),							  NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x9a, 0x00 }, 1, 0, MOD_REG_REG, 0, 0, 0,                                 (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "setpe",  1, { M8,         }, GP3, ALLOW_SEG | REXW | (F_MODRM | F_MODRM_RM),                     NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x9a, 0x00 }, 1, 0, MOD_MEM_REG, 0, 0, ADDR_SIZE_OVERRIDE,                (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_0, P_64,  0, NULL },
{ "setpo",  1, { R8,         }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),							  NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x9b, 0x00 }, 1, 0, MOD_REG_REG, 0, 0, 0,                                 (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "setpo",  1, { R8H,        }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),							  NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x9b, 0x00 }, 1, 0, MOD_REG_REG, 0, 0, 0,                                 (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "setpo",  1, { M8,         }, GP3, ALLOW_SEG | REXW | (F_MODRM | F_MODRM_RM),                     NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x9b, 0x00 }, 1, 0, MOD_MEM_REG, 0, 0, ADDR_SIZE_OVERRIDE,                (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_0, P_64,  0, NULL },
{ "sets",   1, { R8,         }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),							  NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x98, 0x00 }, 1, 0, MOD_REG_REG, 0, 0, 0,                                 (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "sets",   1, { R8H,        }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),							  NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x98, 0x00 }, 1, 0, MOD_REG_REG, 0, 0, 0,                                 (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "sets",   1, { M8,         }, GP3, ALLOW_SEG | REXW | (F_MODRM | F_MODRM_RM),                     NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x98, 0x00 }, 1, 0, MOD_MEM_REG, 0, 0, ADDR_SIZE_OVERRIDE,                (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_0, P_64,  0, NULL },
{ "setz",   1, { R8,         }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),							  NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x94, 0x00 }, 1, 0, MOD_REG_REG, 0, 0, 0,                                 (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "setz",   1, { R8H,        }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),							  NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x94, 0x00 }, 1, 0, MOD_REG_REG, 0, 0, 0,                                 (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "setz",   1, { M8,         }, GP3, ALLOW_SEG | REXW | (F_MODRM | F_MODRM_RM),                     NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x94, 0x00 }, 1, 0, MOD_MEM_REG, 0, 0, ADDR_SIZE_OVERRIDE,                (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_0, P_64,  0, NULL },
//cmov(A, 0x47, a)
{ "cmova",    2, { R16,      R16     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                NO_VEX, NO_EVEX, 1, 1, { 0x47, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,      (X16 | X32 | X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "cmova",    2, { R32,      R32     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                NO_VEX, NO_EVEX, 1, 1, { 0x47, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, 0,                0,      (X16 | X32 | X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "cmova",    2, { R64,      R64     }, GP3, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		            NO_VEX, NO_EVEX, 1, 1, { 0x47, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                  (X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "cmova",    2, { R16,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                        NO_VEX, NO_EVEX, 1, 1, { 0x47, 0x00, 0x00 }, 2, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST, PFX_0xF, NO_IMM    , MEM_OPND_1, P_86,  0, NULL },
{ "cmova",    2, { R32,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                        NO_VEX, NO_EVEX, 1, 1, { 0x47, 0x00, 0x00 }, 4, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST, PFX_0xF, NO_IMM    , MEM_OPND_1, P_86,  0, NULL },
{ "cmova",    2, { R64,      M_ANY   }, GP0, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_REG),				        NO_VEX, NO_EVEX, 1, 1, { 0x47, 0x00, 0x00 }, 8, 0, MOD_REG_MEM, 0, 0,				          ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST, PFX_0xF, NO_IMM    , MEM_OPND_1, P_64,  0, NULL },
{ "cmovae",   2, { R16,      R16     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                NO_VEX, NO_EVEX, 1, 1, { 0x43, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,      (X16 | X32 | X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "cmovae",   2, { R32,      R32     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                NO_VEX, NO_EVEX, 1, 1, { 0x43, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, 0,                0,      (X16 | X32 | X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "cmovae",   2, { R64,      R64     }, GP3, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		            NO_VEX, NO_EVEX, 1, 1, { 0x43, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                  (X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "cmovae",   2, { R16,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                        NO_VEX, NO_EVEX, 1, 1, { 0x43, 0x00, 0x00 }, 2, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST, PFX_0xF, NO_IMM    , MEM_OPND_1, P_86,  0, NULL },
{ "cmovae",   2, { R32,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                        NO_VEX, NO_EVEX, 1, 1, { 0x43, 0x00, 0x00 }, 4, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST, PFX_0xF, NO_IMM    , MEM_OPND_1, P_86,  0, NULL },
{ "cmovae",   2, { R64,      M_ANY   }, GP0, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_REG),				        NO_VEX, NO_EVEX, 1, 1, { 0x43, 0x00, 0x00 }, 8, 0, MOD_REG_MEM, 0, 0,				          ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST, PFX_0xF, NO_IMM    , MEM_OPND_1, P_64,  0, NULL },
{ "cmovb",    2, { R16,      R16     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                NO_VEX, NO_EVEX, 1, 1, { 0x42, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,      (X16 | X32 | X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "cmovb",    2, { R32,      R32     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                NO_VEX, NO_EVEX, 1, 1, { 0x42, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, 0,                0,      (X16 | X32 | X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "cmovb",    2, { R64,      R64     }, GP3, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		            NO_VEX, NO_EVEX, 1, 1, { 0x42, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                  (X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "cmovb",    2, { R16,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                        NO_VEX, NO_EVEX, 1, 1, { 0x42, 0x00, 0x00 }, 2, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST, PFX_0xF, NO_IMM    , MEM_OPND_1, P_86,  0, NULL },
{ "cmovb",    2, { R32,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                        NO_VEX, NO_EVEX, 1, 1, { 0x42, 0x00, 0x00 }, 4, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST, PFX_0xF, NO_IMM    , MEM_OPND_1, P_86,  0, NULL },
{ "cmovb",    2, { R64,      M_ANY   }, GP0, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_REG),				        NO_VEX, NO_EVEX, 1, 1, { 0x42, 0x00, 0x00 }, 8, 0, MOD_REG_MEM, 0, 0,				          ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST, PFX_0xF, NO_IMM    , MEM_OPND_1, P_64,  0, NULL },
{ "cmovbe",   2, { R16,      R16     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                NO_VEX, NO_EVEX, 1, 1, { 0x46, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,      (X16 | X32 | X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "cmovbe",   2, { R32,      R32     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                NO_VEX, NO_EVEX, 1, 1, { 0x46, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, 0,                0,      (X16 | X32 | X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "cmovbe",   2, { R64,      R64     }, GP3, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		            NO_VEX, NO_EVEX, 1, 1, { 0x46, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                  (X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "cmovbe",   2, { R16,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                        NO_VEX, NO_EVEX, 1, 1, { 0x46, 0x00, 0x00 }, 2, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST, PFX_0xF, NO_IMM    , MEM_OPND_1, P_86,  0, NULL },
{ "cmovbe",   2, { R32,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                        NO_VEX, NO_EVEX, 1, 1, { 0x46, 0x00, 0x00 }, 4, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST, PFX_0xF, NO_IMM    , MEM_OPND_1, P_86,  0, NULL },
{ "cmovbe",   2, { R64,      M_ANY   }, GP0, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_REG),				        NO_VEX, NO_EVEX, 1, 1, { 0x46, 0x00, 0x00 }, 8, 0, MOD_REG_MEM, 0, 0,				          ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST, PFX_0xF, NO_IMM    , MEM_OPND_1, P_64,  0, NULL },
{ "cmovc",    2, { R16,      R16     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                NO_VEX, NO_EVEX, 1, 1, { 0x42, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,      (X16 | X32 | X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "cmovc",    2, { R32,      R32     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                NO_VEX, NO_EVEX, 1, 1, { 0x42, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, 0,                0,      (X16 | X32 | X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "cmovc",    2, { R64,      R64     }, GP3, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		            NO_VEX, NO_EVEX, 1, 1, { 0x42, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                  (X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "cmovc",    2, { R16,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                        NO_VEX, NO_EVEX, 1, 1, { 0x42, 0x00, 0x00 }, 2, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST, PFX_0xF, NO_IMM    , MEM_OPND_1, P_86,  0, NULL },
{ "cmovc",    2, { R32,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                        NO_VEX, NO_EVEX, 1, 1, { 0x42, 0x00, 0x00 }, 4, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST, PFX_0xF, NO_IMM    , MEM_OPND_1, P_86,  0, NULL },
{ "cmovc",    2, { R64,      M_ANY   }, GP0, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_REG),				        NO_VEX, NO_EVEX, 1, 1, { 0x42, 0x00, 0x00 }, 8, 0, MOD_REG_MEM, 0, 0,				          ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST, PFX_0xF, NO_IMM    , MEM_OPND_1, P_64,  0, NULL },
{ "cmove",    2, { R16,      R16     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                NO_VEX, NO_EVEX, 1, 1, { 0x44, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,      (X16 | X32 | X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "cmove",    2, { R32,      R32     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                NO_VEX, NO_EVEX, 1, 1, { 0x44, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, 0,                0,      (X16 | X32 | X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "cmove",    2, { R64,      R64     }, GP3, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		            NO_VEX, NO_EVEX, 1, 1, { 0x44, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                  (X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "cmove",    2, { R16,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                        NO_VEX, NO_EVEX, 1, 1, { 0x44, 0x00, 0x00 }, 2, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST, PFX_0xF, NO_IMM    , MEM_OPND_1, P_86,  0, NULL },
{ "cmove",    2, { R32,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                        NO_VEX, NO_EVEX, 1, 1, { 0x44, 0x00, 0x00 }, 4, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST, PFX_0xF, NO_IMM    , MEM_OPND_1, P_86,  0, NULL },
{ "cmove",    2, { R64,      M_ANY   }, GP0, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_REG),				        NO_VEX, NO_EVEX, 1, 1, { 0x44, 0x00, 0x00 }, 8, 0, MOD_REG_MEM, 0, 0,				          ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST, PFX_0xF, NO_IMM    , MEM_OPND_1, P_64,  0, NULL },
{ "cmovg",    2, { R16,      R16     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                NO_VEX, NO_EVEX, 1, 1, { 0x4f, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,      (X16 | X32 | X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "cmovg",    2, { R32,      R32     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                NO_VEX, NO_EVEX, 1, 1, { 0x4f, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, 0,                0,      (X16 | X32 | X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "cmovg",    2, { R64,      R64     }, GP3, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		            NO_VEX, NO_EVEX, 1, 1, { 0x4f, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                  (X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "cmovg",    2, { R16,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                        NO_VEX, NO_EVEX, 1, 1, { 0x4f, 0x00, 0x00 }, 2, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST, PFX_0xF, NO_IMM    , MEM_OPND_1, P_86,  0, NULL },
{ "cmovg",    2, { R32,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                        NO_VEX, NO_EVEX, 1, 1, { 0x4f, 0x00, 0x00 }, 4, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST, PFX_0xF, NO_IMM    , MEM_OPND_1, P_86,  0, NULL },
{ "cmovg",    2, { R64,      M_ANY   }, GP0, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_REG),				        NO_VEX, NO_EVEX, 1, 1, { 0x4f, 0x00, 0x00 }, 8, 0, MOD_REG_MEM, 0, 0,				          ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST, PFX_0xF, NO_IMM    , MEM_OPND_1, P_64,  0, NULL },
{ "cmovge",   2, { R16,      R16     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                NO_VEX, NO_EVEX, 1, 1, { 0x4d, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,      (X16 | X32 | X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "cmovge",   2, { R32,      R32     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                NO_VEX, NO_EVEX, 1, 1, { 0x4d, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, 0,                0,      (X16 | X32 | X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "cmovge",   2, { R64,      R64     }, GP3, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		            NO_VEX, NO_EVEX, 1, 1, { 0x4d, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                  (X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "cmovge",   2, { R16,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                        NO_VEX, NO_EVEX, 1, 1, { 0x4d, 0x00, 0x00 }, 2, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST, PFX_0xF, NO_IMM    , MEM_OPND_1, P_86,  0, NULL },
{ "cmovge",   2, { R32,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                        NO_VEX, NO_EVEX, 1, 1, { 0x4d, 0x00, 0x00 }, 4, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST, PFX_0xF, NO_IMM    , MEM_OPND_1, P_86,  0, NULL },
{ "cmovge",   2, { R64,      M_ANY   }, GP0, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_REG),				        NO_VEX, NO_EVEX, 1, 1, { 0x4d, 0x00, 0x00 }, 8, 0, MOD_REG_MEM, 0, 0,				          ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST, PFX_0xF, NO_IMM    , MEM_OPND_1, P_64,  0, NULL },
{ "cmovl",    2, { R16,      R16     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                NO_VEX, NO_EVEX, 1, 1, { 0x4c, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,      (X16 | X32 | X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "cmovl",    2, { R32,      R32     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                NO_VEX, NO_EVEX, 1, 1, { 0x4c, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, 0,                0,      (X16 | X32 | X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "cmovl",    2, { R64,      R64     }, GP3, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		            NO_VEX, NO_EVEX, 1, 1, { 0x4c, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                  (X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "cmovl",    2, { R16,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                        NO_VEX, NO_EVEX, 1, 1, { 0x4c, 0x00, 0x00 }, 2, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST, PFX_0xF, NO_IMM    , MEM_OPND_1, P_86,  0, NULL },
{ "cmovl",    2, { R32,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                        NO_VEX, NO_EVEX, 1, 1, { 0x4c, 0x00, 0x00 }, 4, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST, PFX_0xF, NO_IMM    , MEM_OPND_1, P_86,  0, NULL },
{ "cmovl",    2, { R64,      M_ANY   }, GP0, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_REG),				        NO_VEX, NO_EVEX, 1, 1, { 0x4c, 0x00, 0x00 }, 8, 0, MOD_REG_MEM, 0, 0,				          ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST, PFX_0xF, NO_IMM    , MEM_OPND_1, P_64,  0, NULL },
{ "cmovle",    2, { R16,      R16     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                NO_VEX, NO_EVEX, 1, 1, { 0x4e, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,      (X16 | X32 | X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "cmovle",    2, { R32,      R32     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                NO_VEX, NO_EVEX, 1, 1, { 0x4e, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, 0,                0,      (X16 | X32 | X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "cmovle",    2, { R64,      R64     }, GP3, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		          NO_VEX, NO_EVEX, 1, 1, { 0x4e, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                  (X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "cmovle",    2, { R16,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                      NO_VEX, NO_EVEX, 1, 1, { 0x4e, 0x00, 0x00 }, 2, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST, PFX_0xF, NO_IMM    , MEM_OPND_1, P_86,  0, NULL },
{ "cmovle",    2, { R32,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                      NO_VEX, NO_EVEX, 1, 1, { 0x4e, 0x00, 0x00 }, 4, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST, PFX_0xF, NO_IMM    , MEM_OPND_1, P_86,  0, NULL },
{ "cmovle",    2, { R64,      M_ANY   }, GP0, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_REG),				        NO_VEX, NO_EVEX, 1, 1, { 0x4e, 0x00, 0x00 }, 8, 0, MOD_REG_MEM, 0, 0,				          ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST, PFX_0xF, NO_IMM    , MEM_OPND_1, P_64,  0, NULL },
{ "cmovna",    2, { R16,      R16     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                NO_VEX, NO_EVEX, 1, 1, { 0x46, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,      (X16 | X32 | X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "cmovna",    2, { R32,      R32     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                NO_VEX, NO_EVEX, 1, 1, { 0x46, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, 0,                0,      (X16 | X32 | X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "cmovna",    2, { R64,      R64     }, GP3, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		          NO_VEX, NO_EVEX, 1, 1, { 0x46, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                  (X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "cmovna",    2, { R16,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                      NO_VEX, NO_EVEX, 1, 1, { 0x46, 0x00, 0x00 }, 2, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST, PFX_0xF, NO_IMM    , MEM_OPND_1, P_86,  0, NULL },
{ "cmovna",    2, { R32,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                      NO_VEX, NO_EVEX, 1, 1, { 0x46, 0x00, 0x00 }, 4, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST, PFX_0xF, NO_IMM    , MEM_OPND_1, P_86,  0, NULL },
{ "cmovna",    2, { R64,      M_ANY   }, GP0, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_REG),				        NO_VEX, NO_EVEX, 1, 1, { 0x46, 0x00, 0x00 }, 8, 0, MOD_REG_MEM, 0, 0,				          ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST, PFX_0xF, NO_IMM    , MEM_OPND_1, P_64,  0, NULL },
{ "cmovnae",   2, { R16,      R16     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                NO_VEX, NO_EVEX, 1, 1, { 0x42, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,      (X16 | X32 | X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "cmovnae",   2, { R32,      R32     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                NO_VEX, NO_EVEX, 1, 1, { 0x42, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, 0,                0,      (X16 | X32 | X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "cmovnae",   2, { R64,      R64     }, GP3, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		          NO_VEX, NO_EVEX, 1, 1, { 0x42, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                  (X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "cmovnae",   2, { R16,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                      NO_VEX, NO_EVEX, 1, 1, { 0x42, 0x00, 0x00 }, 2, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST, PFX_0xF, NO_IMM    , MEM_OPND_1, P_86,  0, NULL },
{ "cmovnae",   2, { R32,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                      NO_VEX, NO_EVEX, 1, 1, { 0x42, 0x00, 0x00 }, 4, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST, PFX_0xF, NO_IMM    , MEM_OPND_1, P_86,  0, NULL },
{ "cmovnae",   2, { R64,      M_ANY   }, GP0, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_REG),				        NO_VEX, NO_EVEX, 1, 1, { 0x42, 0x00, 0x00 }, 8, 0, MOD_REG_MEM, 0, 0,				          ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST, PFX_0xF, NO_IMM    , MEM_OPND_1, P_64,  0, NULL },
{ "cmovnb",    2, { R16,      R16     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                NO_VEX, NO_EVEX, 1, 1, { 0x43, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,      (X16 | X32 | X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "cmovnb",    2, { R32,      R32     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                NO_VEX, NO_EVEX, 1, 1, { 0x43, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, 0,                0,      (X16 | X32 | X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "cmovnb",    2, { R64,      R64     }, GP3, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		          NO_VEX, NO_EVEX, 1, 1, { 0x43, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                  (X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "cmovnb",    2, { R16,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                      NO_VEX, NO_EVEX, 1, 1, { 0x43, 0x00, 0x00 }, 2, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST, PFX_0xF, NO_IMM    , MEM_OPND_1, P_86,  0, NULL },
{ "cmovnb",    2, { R32,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                      NO_VEX, NO_EVEX, 1, 1, { 0x43, 0x00, 0x00 }, 4, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST, PFX_0xF, NO_IMM    , MEM_OPND_1, P_86,  0, NULL },
{ "cmovnb",    2, { R64,      M_ANY   }, GP0, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_REG),				        NO_VEX, NO_EVEX, 1, 1, { 0x43, 0x00, 0x00 }, 8, 0, MOD_REG_MEM, 0, 0,				          ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST, PFX_0xF, NO_IMM    , MEM_OPND_1, P_64,  0, NULL },
{ "cmovnbe",   2, { R16,      R16     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                NO_VEX, NO_EVEX, 1, 1, { 0x47, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,      (X16 | X32 | X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "cmovnbe",   2, { R32,      R32     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                NO_VEX, NO_EVEX, 1, 1, { 0x47, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, 0,                0,      (X16 | X32 | X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "cmovnbe",   2, { R64,      R64     }, GP3, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		          NO_VEX, NO_EVEX, 1, 1, { 0x47, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                  (X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "cmovnbe",   2, { R16,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                      NO_VEX, NO_EVEX, 1, 1, { 0x47, 0x00, 0x00 }, 2, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST, PFX_0xF, NO_IMM    , MEM_OPND_1, P_86,  0, NULL },
{ "cmovnbe",   2, { R32,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                      NO_VEX, NO_EVEX, 1, 1, { 0x47, 0x00, 0x00 }, 4, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST, PFX_0xF, NO_IMM    , MEM_OPND_1, P_86,  0, NULL },
{ "cmovnbe",   2, { R64,      M_ANY   }, GP0, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_REG),				        NO_VEX, NO_EVEX, 1, 1, { 0x47, 0x00, 0x00 }, 8, 0, MOD_REG_MEM, 0, 0,				          ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST, PFX_0xF, NO_IMM    , MEM_OPND_1, P_64,  0, NULL },
{ "cmovnc",    2, { R16,      R16     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                NO_VEX, NO_EVEX, 1, 1, { 0x43, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,      (X16 | X32 | X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "cmovnc",    2, { R32,      R32     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                NO_VEX, NO_EVEX, 1, 1, { 0x43, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, 0,                0,      (X16 | X32 | X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "cmovnc",    2, { R64,      R64     }, GP3, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		          NO_VEX, NO_EVEX, 1, 1, { 0x43, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                  (X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "cmovnc",    2, { R16,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                      NO_VEX, NO_EVEX, 1, 1, { 0x43, 0x00, 0x00 }, 2, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST, PFX_0xF, NO_IMM    , MEM_OPND_1, P_86,  0, NULL },
{ "cmovnc",    2, { R32,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                      NO_VEX, NO_EVEX, 1, 1, { 0x43, 0x00, 0x00 }, 4, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST, PFX_0xF, NO_IMM    , MEM_OPND_1, P_86,  0, NULL },
{ "cmovnc",    2, { R64,      M_ANY   }, GP0, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_REG),				        NO_VEX, NO_EVEX, 1, 1, { 0x43, 0x00, 0x00 }, 8, 0, MOD_REG_MEM, 0, 0,				          ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST, PFX_0xF, NO_IMM    , MEM_OPND_1, P_64,  0, NULL },
{ "cmovne",    2, { R16,      R16     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                NO_VEX, NO_EVEX, 1, 1, { 0x45, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,      (X16 | X32 | X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "cmovne",    2, { R32,      R32     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                NO_VEX, NO_EVEX, 1, 1, { 0x45, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, 0,                0,      (X16 | X32 | X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "cmovne",    2, { R64,      R64     }, GP3, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		          NO_VEX, NO_EVEX, 1, 1, { 0x45, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                  (X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "cmovne",    2, { R16,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                      NO_VEX, NO_EVEX, 1, 1, { 0x45, 0x00, 0x00 }, 2, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST, PFX_0xF, NO_IMM    , MEM_OPND_1, P_86,  0, NULL },
{ "cmovne",    2, { R32,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                      NO_VEX, NO_EVEX, 1, 1, { 0x45, 0x00, 0x00 }, 4, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST, PFX_0xF, NO_IMM    , MEM_OPND_1, P_86,  0, NULL },
{ "cmovne",    2, { R64,      M_ANY   }, GP0, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_REG),				        NO_VEX, NO_EVEX, 1, 1, { 0x45, 0x00, 0x00 }, 8, 0, MOD_REG_MEM, 0, 0,				          ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST, PFX_0xF, NO_IMM    , MEM_OPND_1, P_64,  0, NULL },
{ "cmovng",    2, { R16,      R16     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                NO_VEX, NO_EVEX, 1, 1, { 0x4e, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,      (X16 | X32 | X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "cmovng",    2, { R32,      R32     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                NO_VEX, NO_EVEX, 1, 1, { 0x4e, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, 0,                0,      (X16 | X32 | X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "cmovng",    2, { R64,      R64     }, GP3, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		          NO_VEX, NO_EVEX, 1, 1, { 0x4e, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                  (X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "cmovng",    2, { R16,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                      NO_VEX, NO_EVEX, 1, 1, { 0x4e, 0x00, 0x00 }, 2, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST, PFX_0xF, NO_IMM    , MEM_OPND_1, P_86,  0, NULL },
{ "cmovng",    2, { R32,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                      NO_VEX, NO_EVEX, 1, 1, { 0x4e, 0x00, 0x00 }, 4, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST, PFX_0xF, NO_IMM    , MEM_OPND_1, P_86,  0, NULL },
{ "cmovng",    2, { R64,      M_ANY   }, GP0, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_REG),				        NO_VEX, NO_EVEX, 1, 1, { 0x4e, 0x00, 0x00 }, 8, 0, MOD_REG_MEM, 0, 0,				          ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST, PFX_0xF, NO_IMM    , MEM_OPND_1, P_64,  0, NULL },
{ "cmovnge",   2, { R16,      R16     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                NO_VEX, NO_EVEX, 1, 1, { 0x4c, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,      (X16 | X32 | X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "cmovnge",   2, { R32,      R32     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                NO_VEX, NO_EVEX, 1, 1, { 0x4c, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, 0,                0,      (X16 | X32 | X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "cmovnge",   2, { R64,      R64     }, GP3, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		          NO_VEX, NO_EVEX, 1, 1, { 0x4c, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                  (X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "cmovnge",   2, { R16,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                      NO_VEX, NO_EVEX, 1, 1, { 0x4c, 0x00, 0x00 }, 2, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST, PFX_0xF, NO_IMM    , MEM_OPND_1, P_86,  0, NULL },
{ "cmovnge",   2, { R32,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                      NO_VEX, NO_EVEX, 1, 1, { 0x4c, 0x00, 0x00 }, 4, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST, PFX_0xF, NO_IMM    , MEM_OPND_1, P_86,  0, NULL },
{ "cmovnge",   2, { R64,      M_ANY   }, GP0, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_REG),				        NO_VEX, NO_EVEX, 1, 1, { 0x4c, 0x00, 0x00 }, 8, 0, MOD_REG_MEM, 0, 0,				          ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST, PFX_0xF, NO_IMM    , MEM_OPND_1, P_64,  0, NULL },
{ "cmovnl",    2, { R16,      R16     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                NO_VEX, NO_EVEX, 1, 1, { 0x4d, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,      (X16 | X32 | X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "cmovnl",    2, { R32,      R32     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                NO_VEX, NO_EVEX, 1, 1, { 0x4d, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, 0,                0,      (X16 | X32 | X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "cmovnl",    2, { R64,      R64     }, GP3, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		          NO_VEX, NO_EVEX, 1, 1, { 0x4d, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                  (X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "cmovnl",    2, { R16,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                      NO_VEX, NO_EVEX, 1, 1, { 0x4d, 0x00, 0x00 }, 2, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST, PFX_0xF, NO_IMM    , MEM_OPND_1, P_86,  0, NULL },
{ "cmovnl",    2, { R32,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                      NO_VEX, NO_EVEX, 1, 1, { 0x4d, 0x00, 0x00 }, 4, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST, PFX_0xF, NO_IMM    , MEM_OPND_1, P_86,  0, NULL },
{ "cmovnl",    2, { R64,      M_ANY   }, GP0, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_REG),				        NO_VEX, NO_EVEX, 1, 1, { 0x4d, 0x00, 0x00 }, 8, 0, MOD_REG_MEM, 0, 0,				          ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST, PFX_0xF, NO_IMM    , MEM_OPND_1, P_64,  0, NULL },
{ "cmovnle",   2, { R16,      R16     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                NO_VEX, NO_EVEX, 1, 1, { 0x4f, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,      (X16 | X32 | X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "cmovnle",   2, { R32,      R32     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                NO_VEX, NO_EVEX, 1, 1, { 0x4f, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, 0,                0,      (X16 | X32 | X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "cmovnle",   2, { R64,      R64     }, GP3, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		          NO_VEX, NO_EVEX, 1, 1, { 0x4f, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                  (X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "cmovnle",   2, { R16,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                      NO_VEX, NO_EVEX, 1, 1, { 0x4f, 0x00, 0x00 }, 2, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST, PFX_0xF, NO_IMM    , MEM_OPND_1, P_86,  0, NULL },
{ "cmovnle",   2, { R32,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                      NO_VEX, NO_EVEX, 1, 1, { 0x4f, 0x00, 0x00 }, 4, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST, PFX_0xF, NO_IMM    , MEM_OPND_1, P_86,  0, NULL },
{ "cmovnle",   2, { R64,      M_ANY   }, GP0, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_REG),				        NO_VEX, NO_EVEX, 1, 1, { 0x4f, 0x00, 0x00 }, 8, 0, MOD_REG_MEM, 0, 0,				          ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST, PFX_0xF, NO_IMM    , MEM_OPND_1, P_64,  0, NULL },
{ "cmovno",    2, { R16,      R16     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                NO_VEX, NO_EVEX, 1, 1, { 0x41, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,      (X16 | X32 | X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "cmovno",    2, { R32,      R32     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                NO_VEX, NO_EVEX, 1, 1, { 0x41, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, 0,                0,      (X16 | X32 | X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "cmovno",    2, { R64,      R64     }, GP3, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		          NO_VEX, NO_EVEX, 1, 1, { 0x41, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                  (X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "cmovno",    2, { R16,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                      NO_VEX, NO_EVEX, 1, 1, { 0x41, 0x00, 0x00 }, 2, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST, PFX_0xF, NO_IMM    , MEM_OPND_1, P_86,  0, NULL },
{ "cmovno",    2, { R32,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                      NO_VEX, NO_EVEX, 1, 1, { 0x41, 0x00, 0x00 }, 4, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST, PFX_0xF, NO_IMM    , MEM_OPND_1, P_86,  0, NULL },
{ "cmovno",    2, { R64,      M_ANY   }, GP0, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_REG),				        NO_VEX, NO_EVEX, 1, 1, { 0x41, 0x00, 0x00 }, 8, 0, MOD_REG_MEM, 0, 0,				          ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST, PFX_0xF, NO_IMM    , MEM_OPND_1, P_64,  0, NULL },
{ "cmovnp",    2, { R16,      R16     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                NO_VEX, NO_EVEX, 1, 1, { 0x4b, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,      (X16 | X32 | X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "cmovnp",    2, { R32,      R32     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                NO_VEX, NO_EVEX, 1, 1, { 0x4b, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, 0,                0,      (X16 | X32 | X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "cmovnp",    2, { R64,      R64     }, GP3, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		          NO_VEX, NO_EVEX, 1, 1, { 0x4b, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                  (X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "cmovnp",    2, { R16,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                      NO_VEX, NO_EVEX, 1, 1, { 0x4b, 0x00, 0x00 }, 2, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST, PFX_0xF, NO_IMM    , MEM_OPND_1, P_86,  0, NULL },
{ "cmovnp",    2, { R32,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                      NO_VEX, NO_EVEX, 1, 1, { 0x4b, 0x00, 0x00 }, 4, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST, PFX_0xF, NO_IMM    , MEM_OPND_1, P_86,  0, NULL },
{ "cmovnp",    2, { R64,      M_ANY   }, GP0, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_REG),				        NO_VEX, NO_EVEX, 1, 1, { 0x4b, 0x00, 0x00 }, 8, 0, MOD_REG_MEM, 0, 0,				          ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST, PFX_0xF, NO_IMM    , MEM_OPND_1, P_64,  0, NULL },
{ "cmovns",    2, { R16,      R16     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                NO_VEX, NO_EVEX, 1, 1, { 0x49, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,      (X16 | X32 | X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "cmovns",    2, { R32,      R32     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                NO_VEX, NO_EVEX, 1, 1, { 0x49, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, 0,                0,      (X16 | X32 | X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "cmovns",    2, { R64,      R64     }, GP3, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		          NO_VEX, NO_EVEX, 1, 1, { 0x49, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                  (X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "cmovns",    2, { R16,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                      NO_VEX, NO_EVEX, 1, 1, { 0x49, 0x00, 0x00 }, 2, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST, PFX_0xF, NO_IMM    , MEM_OPND_1, P_86,  0, NULL },
{ "cmovns",    2, { R32,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                      NO_VEX, NO_EVEX, 1, 1, { 0x49, 0x00, 0x00 }, 4, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST, PFX_0xF, NO_IMM    , MEM_OPND_1, P_86,  0, NULL },
{ "cmovns",    2, { R64,      M_ANY   }, GP0, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_REG),				        NO_VEX, NO_EVEX, 1, 1, { 0x49, 0x00, 0x00 }, 8, 0, MOD_REG_MEM, 0, 0,				          ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST, PFX_0xF, NO_IMM    , MEM_OPND_1, P_64,  0, NULL },
{ "cmovnz",    2, { R16,      R16     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                NO_VEX, NO_EVEX, 1, 1, { 0x45, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,      (X16 | X32 | X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "cmovnz",    2, { R32,      R32     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                NO_VEX, NO_EVEX, 1, 1, { 0x45, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, 0,                0,      (X16 | X32 | X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "cmovnz",    2, { R64,      R64     }, GP3, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		          NO_VEX, NO_EVEX, 1, 1, { 0x45, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                  (X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "cmovnz",    2, { R16,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                      NO_VEX, NO_EVEX, 1, 1, { 0x45, 0x00, 0x00 }, 2, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST, PFX_0xF, NO_IMM    , MEM_OPND_1, P_86,  0, NULL },
{ "cmovnz",    2, { R32,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                      NO_VEX, NO_EVEX, 1, 1, { 0x45, 0x00, 0x00 }, 4, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST, PFX_0xF, NO_IMM    , MEM_OPND_1, P_86,  0, NULL },
{ "cmovnz",    2, { R64,      M_ANY   }, GP0, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_REG),				        NO_VEX, NO_EVEX, 1, 1, { 0x45, 0x00, 0x00 }, 8, 0, MOD_REG_MEM, 0, 0,				          ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST, PFX_0xF, NO_IMM    , MEM_OPND_1, P_64,  0, NULL },
{ "cmovo",     2, { R16,      R16     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                NO_VEX, NO_EVEX, 1, 1, { 0x00, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,      (X16 | X32 | X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "cmovo",     2, { R32,      R32     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                NO_VEX, NO_EVEX, 1, 1, { 0x00, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, 0,                0,      (X16 | X32 | X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "cmovo",     2, { R64,      R64     }, GP3, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		          NO_VEX, NO_EVEX, 1, 1, { 0x00, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                  (X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "cmovo",     2, { R16,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                      NO_VEX, NO_EVEX, 1, 1, { 0x00, 0x00, 0x00 }, 2, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST, PFX_0xF, NO_IMM    , MEM_OPND_1, P_86,  0, NULL },
{ "cmovo",     2, { R32,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                      NO_VEX, NO_EVEX, 1, 1, { 0x00, 0x00, 0x00 }, 4, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST, PFX_0xF, NO_IMM    , MEM_OPND_1, P_86,  0, NULL },
{ "cmovo",     2, { R64,      M_ANY   }, GP0, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_REG),				        NO_VEX, NO_EVEX, 1, 1, { 0x00, 0x00, 0x00 }, 8, 0, MOD_REG_MEM, 0, 0,				          ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST, PFX_0xF, NO_IMM    , MEM_OPND_1, P_64,  0, NULL },
{ "cmovp",     2, { R16,      R16     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                NO_VEX, NO_EVEX, 1, 1, { 0x4a, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,      (X16 | X32 | X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "cmovp",     2, { R32,      R32     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                NO_VEX, NO_EVEX, 1, 1, { 0x4a, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, 0,                0,      (X16 | X32 | X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "cmovp",     2, { R64,      R64     }, GP3, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		          NO_VEX, NO_EVEX, 1, 1, { 0x4a, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                  (X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "cmovp",     2, { R16,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                      NO_VEX, NO_EVEX, 1, 1, { 0x4a, 0x00, 0x00 }, 2, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST, PFX_0xF, NO_IMM    , MEM_OPND_1, P_86,  0, NULL },
{ "cmovp",     2, { R32,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                      NO_VEX, NO_EVEX, 1, 1, { 0x4a, 0x00, 0x00 }, 4, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST, PFX_0xF, NO_IMM    , MEM_OPND_1, P_86,  0, NULL },
{ "cmovp",     2, { R64,      M_ANY   }, GP0, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_REG),				        NO_VEX, NO_EVEX, 1, 1, { 0x4a, 0x00, 0x00 }, 8, 0, MOD_REG_MEM, 0, 0,				          ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST, PFX_0xF, NO_IMM    , MEM_OPND_1, P_64,  0, NULL },
{ "cmovpe",    2, { R16,      R16     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                NO_VEX, NO_EVEX, 1, 1, { 0x4a, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,      (X16 | X32 | X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "cmovpe",    2, { R32,      R32     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                NO_VEX, NO_EVEX, 1, 1, { 0x4a, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, 0,                0,      (X16 | X32 | X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "cmovpe",    2, { R64,      R64     }, GP3, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		          NO_VEX, NO_EVEX, 1, 1, { 0x4a, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                  (X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "cmovpe",    2, { R16,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                      NO_VEX, NO_EVEX, 1, 1, { 0x4a, 0x00, 0x00 }, 2, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST, PFX_0xF, NO_IMM    , MEM_OPND_1, P_86,  0, NULL },
{ "cmovpe",    2, { R32,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                      NO_VEX, NO_EVEX, 1, 1, { 0x4a, 0x00, 0x00 }, 4, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST, PFX_0xF, NO_IMM    , MEM_OPND_1, P_86,  0, NULL },
{ "cmovpe",    2, { R64,      M_ANY   }, GP0, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_REG),				        NO_VEX, NO_EVEX, 1, 1, { 0x4a, 0x00, 0x00 }, 8, 0, MOD_REG_MEM, 0, 0,				          ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST, PFX_0xF, NO_IMM    , MEM_OPND_1, P_64,  0, NULL },
{ "cmovpo",    2, { R16,      R16     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                NO_VEX, NO_EVEX, 1, 1, { 0x4b, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,      (X16 | X32 | X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "cmovpo",    2, { R32,      R32     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                NO_VEX, NO_EVEX, 1, 1, { 0x4b, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, 0,                0,      (X16 | X32 | X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "cmovpo",    2, { R64,      R64     }, GP3, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		          NO_VEX, NO_EVEX, 1, 1, { 0x4b, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                  (X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "cmovpo",    2, { R16,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                      NO_VEX, NO_EVEX, 1, 1, { 0x4b, 0x00, 0x00 }, 2, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST, PFX_0xF, NO_IMM    , MEM_OPND_1, P_86,  0, NULL },
{ "cmovpo",    2, { R32,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                      NO_VEX, NO_EVEX, 1, 1, { 0x4b, 0x00, 0x00 }, 4, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST, PFX_0xF, NO_IMM    , MEM_OPND_1, P_86,  0, NULL },
{ "cmovpo",    2, { R64,      M_ANY   }, GP0, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_REG),				        NO_VEX, NO_EVEX, 1, 1, { 0x4b, 0x00, 0x00 }, 8, 0, MOD_REG_MEM, 0, 0,				          ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST, PFX_0xF, NO_IMM    , MEM_OPND_1, P_64,  0, NULL },
{ "cmovs",     2, { R16,      R16     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                NO_VEX, NO_EVEX, 1, 1, { 0x48, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,      (X16 | X32 | X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "cmovs",     2, { R32,      R32     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                NO_VEX, NO_EVEX, 1, 1, { 0x48, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, 0,                0,      (X16 | X32 | X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "cmovs",     2, { R64,      R64     }, GP3, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		          NO_VEX, NO_EVEX, 1, 1, { 0x48, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                  (X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "cmovs",     2, { R16,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                      NO_VEX, NO_EVEX, 1, 1, { 0x48, 0x00, 0x00 }, 2, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST, PFX_0xF, NO_IMM    , MEM_OPND_1, P_86,  0, NULL },
{ "cmovs",     2, { R32,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                      NO_VEX, NO_EVEX, 1, 1, { 0x48, 0x00, 0x00 }, 4, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST, PFX_0xF, NO_IMM    , MEM_OPND_1, P_86,  0, NULL },
{ "cmovs",     2, { R64,      M_ANY   }, GP0, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_REG),				        NO_VEX, NO_EVEX, 1, 1, { 0x48, 0x00, 0x00 }, 8, 0, MOD_REG_MEM, 0, 0,				          ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST, PFX_0xF, NO_IMM    , MEM_OPND_1, P_64,  0, NULL },
{ "cmovz",     2, { R16,      R16     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                NO_VEX, NO_EVEX, 1, 1, { 0x44, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,      (X16 | X32 | X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "cmovz",     2, { R32,      R32     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                NO_VEX, NO_EVEX, 1, 1, { 0x44, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, 0,                0,      (X16 | X32 | X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "cmovz",     2, { R64,      R64     }, GP3, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		          NO_VEX, NO_EVEX, 1, 1, { 0x44, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                  (X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "cmovz",     2, { R16,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                      NO_VEX, NO_EVEX, 1, 1, { 0x44, 0x00, 0x00 }, 2, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST, PFX_0xF, NO_IMM    , MEM_OPND_1, P_86,  0, NULL },
{ "cmovz",     2, { R32,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                      NO_VEX, NO_EVEX, 1, 1, { 0x44, 0x00, 0x00 }, 4, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST, PFX_0xF, NO_IMM    , MEM_OPND_1, P_86,  0, NULL },
{ "cmovz",     2, { R64,      M_ANY   }, GP0, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_REG),				        NO_VEX, NO_EVEX, 1, 1, { 0x44, 0x00, 0x00 }, 8, 0, MOD_REG_MEM, 0, 0,				          ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST, PFX_0xF, NO_IMM    , MEM_OPND_1, P_64,  0, NULL },
{ "ret",       1, { IMM16,            }, GP0, (NO_FLAGS),	                                                      NO_VEX, NO_EVEX, 1, 1, { 0xc2, 0x00, 0x00 }, 2, 0, NO_MOD, 0, 0, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, IMM_OPND_0, NO_MEM, P_86,  0, NULL },
{ "ret",       0, { OP_N,     OP_N    }, GP0, (NO_FLAGS),                                                       NO_VEX, NO_EVEX, 1, 1, { 0xc3, 0x00, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
{ "retn",      1, { IMM16,            }, GP0, (NO_FLAGS),	                                                      NO_VEX, NO_EVEX, 1, 1, { 0xc2, 0x00, 0x00 }, 2, 0, NO_MOD, 0, 0, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, IMM_OPND_0, NO_MEM, P_86,  0, NULL },
{ "retn",      0, { OP_N,     OP_N    }, GP0, (NO_FLAGS),                                                       NO_VEX, NO_EVEX, 1, 1, { 0xc3, 0x00, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
{ "retf",      1, { IMM16,            }, GP0, (NO_FLAGS),	                                                      NO_VEX, NO_EVEX, 1, 1, { 0xca, 0x00, 0x00 }, 2, 0, MOD_REG_IMM, 0, 0, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, IMM_OPND_0, NO_MEM, P_86,  0, NULL },
{ "retf",      0, { OP_N,     OP_N    }, GP0, (NO_FLAGS),                                                       NO_VEX, NO_EVEX, 1, 1, { 0xcb, 0x00, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
{ "rsm",       0, { OP_N,     OP_N    }, GP0, (NO_FLAGS),                                                       NO_VEX, NO_EVEX, 1, 1, { 0xaa, 0x00, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32 | X64), NO_DST, PFX_0xF,   NO_IMM, NO_MEM, P_586, 0, NULL },
{ "sahf",      0, { OP_N,     OP_N    }, GP0, (NO_FLAGS),                                                       NO_VEX, NO_EVEX, 1, 1, { 0x9e, 0x00, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_586, 0, NULL },
//0F 01 / 0 SGDT m M Valid Valid
{ "sgdt",    1, { M_ANY,         }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_RM | OPCODE_EXT),                       NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x01, 0x00 }, 4, 0, 0x04,     0, 0, ADDR_SIZE_OVERRIDE,  (X16 | X32 | X64), RM_DST, NO_PREFIX, NO_IMM, MEM_OPND_0, P_286, 0, NULL },
//0F 01 / 1 SIDT m M Valid Valid
{ "sidt",    1, { M_ANY,         }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_RM | OPCODE_EXT),                       NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x01, 0x00 }, 4, 0, 0x0c,     0, 0, ADDR_SIZE_OVERRIDE,  (X16 | X32 | X64), RM_DST, NO_PREFIX, NO_IMM, MEM_OPND_0, P_286, 0, NULL },

//CALL rel16       E8 cw           M N.S.    Valid
//CALL rel32       E8 cd           M Valid   Valid
{ "call",    1, { IMM16,       }, GP4, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0xe8, 0x00, 0x00 }, 4, 0, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,   (X16 | X32), NO_DST,  NO_PREFIX, IMM_OPND_0, NO_MEM, P_86,  0, NULL },
{ "call",    1, { IMM32,       }, GP0, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0xe8, 0x00, 0x00 }, 4, 0, MOD_MEM_IMM, 0, 0, 0,                  (X32 | X64), NO_DST,  NO_PREFIX, IMM_OPND_0, NO_MEM, P_386, 0, NULL },
//CALL r/m16       FF /2           M N.E.    Valid
//CALL r/m32       FF /2           M N.E.    Valid
//CALL r/m64       FF /2           M Valid   N.E. 
{ "call",    1, { R16,         }, GP4, (F_OPCODE2_REG),					                                              NO_VEX, NO_EVEX, 1, 2, { 0xff, 0xd0, 0x00 }, 2, 0, NO_MOD, 0,       0,                0,       (X16 | X32), NO_DST, NO_PREFIX, NO_IMM, NO_MEM,     P_86,  0, NULL },
{ "call",    1, { R32,         }, GP4, (F_OPCODE2_REG),					                                              NO_VEX, NO_EVEX, 1, 2, { 0xff, 0xd0, 0x00 }, 4, 0, NO_MOD, 0,       0,                0,       (X16 | X32), NO_DST, NO_PREFIX, NO_IMM, NO_MEM,     P_386, 0, NULL },
{ "call",    1, { R64,         }, GP3, (F_OPCODE2_REG),		                                                    NO_VEX, NO_EVEX, 1, 2, { 0xff, 0xd0, 0x00 }, 8, 0, NO_MOD, 0,       0,                0,             (X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM,     P_64,  0, NULL },
{ "call",    1, { M16,         }, GP4, ALLOW_SEG,                                                             NO_VEX, NO_EVEX, 1, 1, { 0xff, 0x00, 0x00 }, 2, 0, 0x10,     0, OP_SIZE_OVERRIDE, 0,  (X16 | X32), RM_DST, NO_PREFIX, NO_IMM, MEM_OPND_0, P_86,  0, NULL },
{ "call",    1, { M32,         }, GP4, ALLOW_SEG,                                                             NO_VEX, NO_EVEX, 1, 1, { 0xff, 0x00, 0x00 }, 4, 0, 0x10,     0, 0, ADDR_SIZE_OVERRIDE,  (X16 | X32), RM_DST, NO_PREFIX, NO_IMM, MEM_OPND_0, P_386, 0, NULL },
{ "call",    1, { M64,         }, GP3, ALLOW_SEG | (REX | REXW),                                              NO_VEX, NO_EVEX, 1, 1, { 0xff, 0x00, 0x00 }, 8, 0, 0x10,     0, 0, ADDR_SIZE_OVERRIDE,        (X64), RM_DST, NO_PREFIX, NO_IMM, MEM_OPND_0, P_64,  0, NULL },
//CALL ptr16:16    9A cd           D Invalid Valid
//CALL ptr16:32    9A cp           D Invalid Valid
{ "call",    1, { IMM16,       }, GP4, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0x9a, 0x00, 0x00 }, 4, 0, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32), NO_DST,  NO_PREFIX, IMM_OPND_0, NO_MEM, P_86,  0, NULL },
{ "call",    1, { IMM48,       }, GP4, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0x9a, 0x00, 0x00 }, 4, 0, MOD_MEM_IMM, 0, OP_SIZE_OVERRIDE, 0,                  (X32), NO_DST,  NO_PREFIX, IMM_OPND_0, NO_MEM, P_386,  0, NULL },
//CALL m16:16      FF /3           M Valid   Valid
//CALL m16:32      FF /3           M Valid   Valid
//CALL m16:64      REX.W + FF /3   M Valid   N.E. 
{ "call",    1, { M32,       }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_RM | OPCODE_EXT),		                      NO_VEX, NO_EVEX, 1, 1, { 0xff, 0x00, 0x00 }, 4, 0, 0x18,     0, 0, 0,  (X16 | X32), RM_DST, NO_PREFIX, NO_IMM, MEM_OPND_0, P_86, 0, NULL },
{ "call",    1, { M48,       }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_RM | OPCODE_EXT),	                        NO_VEX, NO_EVEX, 1, 1, { 0xff, 0x00, 0x00 }, 4, 0, 0x18,     0, 0, 0,  (X16 | X32), RM_DST, NO_PREFIX, NO_IMM, MEM_OPND_0, P_386, 0, NULL },
{ "call",    1, { M80,       }, GP3, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_RM | OPCODE_EXT),          NO_VEX, NO_EVEX, 1, 1, { 0xff, 0x00, 0x00 }, 8, 0, 0x18,     0, 0, 0,        (X64), RM_DST, NO_PREFIX, NO_IMM, MEM_OPND_0, P_64, 0, NULL },
//JMP rel8        EB cb           D   Valid   Valid   Jump short, RIP = RIP + 8-bit displacement sign extended to 64-bits                          
//JMP rel16       E9 cw           D   N.S.    Valid   Jump near, relative, displacement relative to next instruction. Not supported in 64-bit mode.
//JMP rel32       E9 cd           D   Valid   Valid   Jump near, relative, RIP = RIP + 32-bit displacement sign extended to 64-bits                
{ "jmp",    1, { IMM8,        }, GP0, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0xeb, 0x00, 0x00 }, 1, 0, MOD_REG_IMM, 0, 0, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, IMM_OPND_0, NO_MEM, P_86,  0, NULL },
{ "jmp",    1, { IMM16,       }, GP4, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0xe9, 0x00, 0x00 }, 2, 0, MOD_REG_IMM, 0, 0, 0,                        (X16 | X32), NO_DST,  NO_PREFIX, IMM_OPND_0, NO_MEM, P_86,  0, NULL },
{ "jmp",    1, { IMM32,       }, GP0, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0xe9, 0x00, 0x00 }, 4, 0, MOD_MEM_IMM, 0, 0, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, IMM_OPND_0, NO_MEM, P_386, 0, NULL },
//JMP r/m16       FF /4           M   N.S.    Valid   Jump near, absolute indirect, address = zeroextended r/m16. Not supported in 64-bit mode.    
//JMP r/m32       FF /4           M   N.S.    Valid   Jump near, absolute indirect, address given in r/m32. Not supported in 64-bit mode.          
//JMP r/m64       FF /4           M   Valid   N.E.    Jump near, absolute indirect, RIP = 64-Bit offset from register or memory                    

{ "jmp",    1, { R16,         }, GP4, (F_OPCODE2_REG),					                                              NO_VEX, NO_EVEX, 1, 2, { 0xff, 0xe0, 0x00 }, 2, 0, NO_MOD, 0,       0,                0,       (X16 | X32), NO_DST, NO_PREFIX, NO_IMM, NO_MEM,     P_86,  0, NULL },
{ "jmp",    1, { R32,         }, GP4, (F_OPCODE2_REG),					                                              NO_VEX, NO_EVEX, 1, 2, { 0xff, 0xe0, 0x00 }, 4, 0, NO_MOD, 0,       0,                0,       (X16 | X32), NO_DST, NO_PREFIX, NO_IMM, NO_MEM,     P_386, 0, NULL },
{ "jmp",    1, { M16,         }, GP4, ALLOW_SEG,                                                              NO_VEX, NO_EVEX, 1, 1, { 0xff, 0x00, 0x00 }, 2, 0, 0x20,   0, OP_SIZE_OVERRIDE, 0,             (X16 | X32), RM_DST, NO_PREFIX, NO_IMM, MEM_OPND_0, P_86,  0, NULL },
{ "jmp",    1, { M32,         }, GP4, ALLOW_SEG,                                                              NO_VEX, NO_EVEX, 1, 1, { 0xff, 0x00, 0x00 }, 4, 0, 0x20,   0,       0, ADDR_SIZE_OVERRIDE,     (X16 | X32), RM_DST, NO_PREFIX, NO_IMM, MEM_OPND_0, P_386, 0, NULL },
{ "jmp",    1, { R64,         }, GP3, (F_OPCODE2_REG),		                                                    NO_VEX, NO_EVEX, 1, 2, { 0xff, 0xe0, 0x00 }, 8, 0, NO_MOD, 0,       0,                0,             (X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM,     P_64,  0, NULL },
{ "jmp",    1, { M64,         }, GP3, ALLOW_SEG | REXW,                                                       NO_VEX, NO_EVEX, 1, 1, { 0xff, 0x00, 0x00 }, 8, 0, 0x20,   0,       0, ADDR_SIZE_OVERRIDE,           (X64), RM_DST, NO_PREFIX, NO_IMM, MEM_OPND_0, P_64,  0, NULL },

//JMP ptr16:16    EA cd           D   Inv.    Valid   Jump far, absolute, address given in operand                                                 
//JMP ptr16:32    EA cp           D   Inv.    Valid   Jump far, absolute, address given in operand                                                 

{ "jmp",    1, { IMM16,       }, GP4, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0xea, 0x00, 0x00 }, 2, 0, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32), NO_DST,  PFX_0xF, IMM_OPND_0, NO_MEM, P_86,  0, NULL },
{ "jmp",    1, { IMM48,       }, GP4, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0xea, 0x00, 0x00 }, 4, 0, MOD_MEM_IMM, 0, OP_SIZE_OVERRIDE, 0,                  (X32), NO_DST,  NO_PREFIX, IMM_OPND_0, NO_MEM, P_386,  0, NULL },
//JMP m16:16      FF /5           D   Valid   Valid   Jump far, absolute indirect, address given in m16:16                                         
//JMP m16:32      FF /5           D   Valid   Valid   Jump far, absolute indirect, address given in m16:32.                                        
//JMP m16:64      REX.W + FF /5   D   Valid   N.E.    Jump far, absolute indirect, address given in m16:64.                                        
{ "jmp",    1, { M32,       }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_RM | OPCODE_EXT),		                      NO_VEX, NO_EVEX, 1, 1, { 0xff, 0x00, 0x00 }, 2, 0, 0x28,     0, 0, 0,  (X16 | X32 | X64), RM_DST, NO_PREFIX, NO_IMM, MEM_OPND_0, P_86, 0, NULL },
{ "jmp",    1, { M48,       }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_RM | OPCODE_EXT),	                        NO_VEX, NO_EVEX, 1, 1, { 0xff, 0x00, 0x00 }, 4, 0, 0x28,     0, 0, 0,  (X16 | X32 | X64), RM_DST, NO_PREFIX, NO_IMM, MEM_OPND_0, P_386, 0, NULL },
{ "jmp",    1, { M80,       }, GP3, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_RM | OPCODE_EXT),           NO_VEX, NO_EVEX, 1, 1, { 0xff, 0x00, 0x00 }, 8, 0, 0x28,     0, 0, 0,              (X64), RM_DST, NO_PREFIX, NO_IMM, MEM_OPND_0, P_64, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */

{ "ja",    1, { IMM8,        }, GP0, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0x77, 0x00, 0x00 }, 1, 0, MOD_REG_IMM, 0, 0, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, IMM_OPND_0, NO_MEM, P_86,  0, NULL },
{ "ja",    1, { IMM16,       }, GP0, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0x87, 0x00, 0x00 }, 2, 0, MOD_REG_IMM, 0, 0, 0,                  (X16 | X32 | X64), NO_DST,  PFX_0xF,   IMM_OPND_0, NO_MEM, P_386, 0, NULL },
{ "ja",    1, { IMM32,       }, GP0, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0x87, 0x00, 0x00 }, 4, 0, MOD_MEM_IMM, 0, 0, 0,                  (X16 | X32 | X64), NO_DST,  PFX_0xF,   IMM_OPND_0, NO_MEM, P_386, 0, NULL },
{ "jae",   1, { IMM8,        }, GP0, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0x73, 0x00, 0x00 }, 1, 0, MOD_REG_IMM, 0, 0, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, IMM_OPND_0, NO_MEM, P_86,  0, NULL },
{ "jae",   1, { IMM16,       }, GP0, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0x83, 0x00, 0x00 }, 2, 0, MOD_REG_IMM, 0, 0, 0,                  (X16 | X32 | X64), NO_DST,  PFX_0xF,   IMM_OPND_0, NO_MEM, P_386, 0, NULL },
{ "jae",   1, { IMM32,       }, GP0, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0x83, 0x00, 0x00 }, 4, 0, MOD_MEM_IMM, 0, 0, 0,                  (X16 | X32 | X64), NO_DST,  PFX_0xF,   IMM_OPND_0, NO_MEM, P_386, 0, NULL },
{ "jb",    1, { IMM8,        }, GP0, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0x72, 0x00, 0x00 }, 1, 0, MOD_REG_IMM, 0, 0, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, IMM_OPND_0, NO_MEM, P_86,  0, NULL },
{ "jb",    1, { IMM16,       }, GP0, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0x82, 0x00, 0x00 }, 2, 0, MOD_REG_IMM, 0, 0, 0,                  (X16 | X32 | X64), NO_DST,  PFX_0xF,   IMM_OPND_0, NO_MEM, P_386, 0, NULL },
{ "jb",    1, { IMM32,       }, GP0, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0x82, 0x00, 0x00 }, 4, 0, MOD_MEM_IMM, 0, 0, 0,                  (X16 | X32 | X64), NO_DST,  PFX_0xF,   IMM_OPND_0, NO_MEM, P_386, 0, NULL },
{ "jbe",   1, { IMM8,        }, GP0, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0x76, 0x00, 0x00 }, 1, 0, MOD_REG_IMM, 0, 0, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, IMM_OPND_0, NO_MEM, P_86,  0, NULL },
{ "jbe",   1, { IMM16,       }, GP0, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0x86, 0x00, 0x00 }, 2, 0, MOD_REG_IMM, 0, 0, 0,                  (X16 | X32 | X64), NO_DST,  PFX_0xF,   IMM_OPND_0, NO_MEM, P_386, 0, NULL },
{ "jbe",   1, { IMM32,       }, GP0, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0x86, 0x00, 0x00 }, 4, 0, MOD_MEM_IMM, 0, 0, 0,                  (X16 | X32 | X64), NO_DST,  PFX_0xF,   IMM_OPND_0, NO_MEM, P_386, 0, NULL },
{ "jc",    1, { IMM8,        }, GP0, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0x72, 0x00, 0x00 }, 1, 0, MOD_REG_IMM, 0, 0, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, IMM_OPND_0, NO_MEM, P_86,  0, NULL },
{ "jc",    1, { IMM16,       }, GP0, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0x82, 0x00, 0x00 }, 2, 0, MOD_REG_IMM, 0, 0, 0,                  (X16 | X32 | X64), NO_DST,  PFX_0xF,   IMM_OPND_0, NO_MEM, P_386, 0, NULL },
{ "jc",    1, { IMM32,       }, GP0, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0x82, 0x00, 0x00 }, 4, 0, MOD_MEM_IMM, 0, 0, 0,                  (X16 | X32 | X64), NO_DST,  PFX_0xF,   IMM_OPND_0, NO_MEM, P_386, 0, NULL },
{ "je",    1, { IMM8,        }, GP0, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0x74, 0x00, 0x00 }, 1, 0, MOD_REG_IMM, 0, 0, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, IMM_OPND_0, NO_MEM, P_86,  0, NULL },
{ "je",    1, { IMM16,       }, GP0, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0x84, 0x00, 0x00 }, 2, 0, MOD_REG_IMM, 0, 0, 0,                  (X16 | X32 | X64), NO_DST,  PFX_0xF,   IMM_OPND_0, NO_MEM, P_386, 0, NULL },
{ "je",    1, { IMM32,       }, GP0, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0x84, 0x00, 0x00 }, 4, 0, MOD_MEM_IMM, 0, 0, 0,                  (X16 | X32 | X64), NO_DST,  PFX_0xF,   IMM_OPND_0, NO_MEM, P_386, 0, NULL },
{ "jg",    1, { IMM8,        }, GP0, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0x7f, 0x00, 0x00 }, 1, 0, MOD_REG_IMM, 0, 0, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, IMM_OPND_0, NO_MEM, P_86,  0, NULL },
{ "jg",    1, { IMM16,       }, GP0, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0x8f, 0x00, 0x00 }, 2, 0, MOD_REG_IMM, 0, 0, 0,                  (X16 | X32 | X64), NO_DST,  PFX_0xF,   IMM_OPND_0, NO_MEM, P_386, 0, NULL },
{ "jg",    1, { IMM32,       }, GP0, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0x8f, 0x00, 0x00 }, 4, 0, MOD_MEM_IMM, 0, 0, 0,                  (X16 | X32 | X64), NO_DST,  PFX_0xF,   IMM_OPND_0, NO_MEM, P_386, 0, NULL },
{ "jge",   1, { IMM8,        }, GP0, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0x7d, 0x00, 0x00 }, 1, 0, MOD_REG_IMM, 0, 0, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, IMM_OPND_0, NO_MEM, P_86,  0, NULL },
{ "jge",   1, { IMM16,       }, GP0, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0x8d, 0x00, 0x00 }, 2, 0, MOD_REG_IMM, 0, 0, 0,                  (X16 | X32 | X64), NO_DST,  PFX_0xF,   IMM_OPND_0, NO_MEM, P_386, 0, NULL },
{ "jge",   1, { IMM32,       }, GP0, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0x8d, 0x00, 0x00 }, 4, 0, MOD_MEM_IMM, 0, 0, 0,                  (X16 | X32 | X64), NO_DST,  PFX_0xF,   IMM_OPND_0, NO_MEM, P_386, 0, NULL },
{ "jl",    1, { IMM8,        }, GP0, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0x7c, 0x00, 0x00 }, 1, 0, MOD_REG_IMM, 0, 0, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, IMM_OPND_0, NO_MEM, P_86,  0, NULL },
{ "jl",    1, { IMM16,       }, GP0, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0x8c, 0x00, 0x00 }, 2, 0, MOD_REG_IMM, 0, 0, 0,                  (X16 | X32 | X64), NO_DST,  PFX_0xF,   IMM_OPND_0, NO_MEM, P_386, 0, NULL },
{ "jl",    1, { IMM32,       }, GP0, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0x8c, 0x00, 0x00 }, 4, 0, MOD_MEM_IMM, 0, 0, 0,                  (X16 | X32 | X64), NO_DST,  PFX_0xF,   IMM_OPND_0, NO_MEM, P_386, 0, NULL },
{ "jle",   1, { IMM8,        }, GP0, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0x7e, 0x00, 0x00 }, 1, 0, MOD_REG_IMM, 0, 0, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, IMM_OPND_0, NO_MEM, P_86,  0, NULL },
{ "jle",   1, { IMM16,       }, GP0, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0x8e, 0x00, 0x00 }, 2, 0, MOD_REG_IMM, 0, 0, 0,                  (X16 | X32 | X64), NO_DST,  PFX_0xF,   IMM_OPND_0, NO_MEM, P_386, 0, NULL },
{ "jle",   1, { IMM32,       }, GP0, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0x8e, 0x00, 0x00 }, 4, 0, MOD_MEM_IMM, 0, 0, 0,                  (X16 | X32 | X64), NO_DST,  PFX_0xF,   IMM_OPND_0, NO_MEM, P_386, 0, NULL },
{ "jna",   1, { IMM8,        }, GP0, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0x76, 0x00, 0x00 }, 1, 0, MOD_REG_IMM, 0, 0, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, IMM_OPND_0, NO_MEM, P_86,  0, NULL },
{ "jna",   1, { IMM16,       }, GP0, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0x86, 0x00, 0x00 }, 2, 0, MOD_REG_IMM, 0, 0, 0,                  (X16 | X32 | X64), NO_DST,  PFX_0xF,   IMM_OPND_0, NO_MEM, P_386, 0, NULL },
{ "jna",   1, { IMM32,       }, GP0, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0x86, 0x00, 0x00 }, 4, 0, MOD_MEM_IMM, 0, 0, 0,                  (X16 | X32 | X64), NO_DST,  PFX_0xF,   IMM_OPND_0, NO_MEM, P_386, 0, NULL },
{ "jnae",  1, { IMM8,        }, GP0, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0x72, 0x00, 0x00 }, 1, 0, MOD_REG_IMM, 0, 0, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, IMM_OPND_0, NO_MEM, P_86,  0, NULL },
{ "jnae",  1, { IMM16,       }, GP0, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0x82, 0x00, 0x00 }, 2, 0, MOD_REG_IMM, 0, 0, 0,                  (X16 | X32 | X64), NO_DST,  PFX_0xF,   IMM_OPND_0, NO_MEM, P_386, 0, NULL },
{ "jnae",  1, { IMM32,       }, GP0, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0x82, 0x00, 0x00 }, 4, 0, MOD_MEM_IMM, 0, 0, 0,                  (X16 | X32 | X64), NO_DST,  PFX_0xF,   IMM_OPND_0, NO_MEM, P_386, 0, NULL },
{ "jnb",   1, { IMM8,        }, GP0, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0x73, 0x00, 0x00 }, 1, 0, MOD_REG_IMM, 0, 0, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, IMM_OPND_0, NO_MEM, P_86,  0, NULL },
{ "jnb",   1, { IMM16,       }, GP0, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0x83, 0x00, 0x00 }, 2, 0, MOD_REG_IMM, 0, 0, 0,                  (X16 | X32 | X64), NO_DST,  PFX_0xF,   IMM_OPND_0, NO_MEM, P_386, 0, NULL },
{ "jnb",   1, { IMM32,       }, GP0, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0x83, 0x00, 0x00 }, 4, 0, MOD_MEM_IMM, 0, 0, 0,                  (X16 | X32 | X64), NO_DST,  PFX_0xF,   IMM_OPND_0, NO_MEM, P_386, 0, NULL },
{ "jnbe",  1, { IMM8,        }, GP0, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0x77, 0x00, 0x00 }, 1, 0, MOD_REG_IMM, 0, 0, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, IMM_OPND_0, NO_MEM, P_86,  0, NULL },
{ "jnbe",  1, { IMM16,       }, GP0, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0x87, 0x00, 0x00 }, 2, 0, MOD_REG_IMM, 0, 0, 0,                  (X16 | X32 | X64), NO_DST,  PFX_0xF,   IMM_OPND_0, NO_MEM, P_386, 0, NULL },
{ "jnbe",  1, { IMM32,       }, GP0, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0x87, 0x00, 0x00 }, 4, 0, MOD_MEM_IMM, 0, 0, 0,                  (X16 | X32 | X64), NO_DST,  PFX_0xF,   IMM_OPND_0, NO_MEM, P_386, 0, NULL },
{ "jnc",   1, { IMM8,        }, GP0, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0x73, 0x00, 0x00 }, 1, 0, MOD_REG_IMM, 0, 0, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, IMM_OPND_0, NO_MEM, P_86,  0, NULL },
{ "jnc",   1, { IMM16,       }, GP0, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0x83, 0x00, 0x00 }, 2, 0, MOD_REG_IMM, 0, 0, 0,                  (X16 | X32 | X64), NO_DST,  PFX_0xF,   IMM_OPND_0, NO_MEM, P_386, 0, NULL },
{ "jnc",   1, { IMM32,       }, GP0, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0x83, 0x00, 0x00 }, 4, 0, MOD_MEM_IMM, 0, 0, 0,                  (X16 | X32 | X64), NO_DST,  PFX_0xF,   IMM_OPND_0, NO_MEM, P_386, 0, NULL },
{ "jne",   1, { IMM8,        }, GP0, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0x75, 0x00, 0x00 }, 1, 0, MOD_REG_IMM, 0, 0, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, IMM_OPND_0, NO_MEM, P_86,  0, NULL },
{ "jne",   1, { IMM16,       }, GP0, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0x85, 0x00, 0x00 }, 2, 0, MOD_REG_IMM, 0, 0, 0,                  (X16 | X32 | X64), NO_DST,  PFX_0xF,   IMM_OPND_0, NO_MEM, P_386, 0, NULL },
{ "jne",   1, { IMM32,       }, GP0, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0x85, 0x00, 0x00 }, 4, 0, MOD_MEM_IMM, 0, 0, 0,                  (X16 | X32 | X64), NO_DST,  PFX_0xF,   IMM_OPND_0, NO_MEM, P_386, 0, NULL },
{ "jng",   1, { IMM8,        }, GP0, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0x7e, 0x00, 0x00 }, 1, 0, MOD_REG_IMM, 0, 0, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, IMM_OPND_0, NO_MEM, P_86,  0, NULL },
{ "jng",   1, { IMM16,       }, GP0, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0x8e, 0x00, 0x00 }, 2, 0, MOD_REG_IMM, 0, 0, 0,                  (X16 | X32 | X64), NO_DST,  PFX_0xF,   IMM_OPND_0, NO_MEM, P_386, 0, NULL },
{ "jng",   1, { IMM32,       }, GP0, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0x8e, 0x00, 0x00 }, 4, 0, MOD_MEM_IMM, 0, 0, 0,                  (X16 | X32 | X64), NO_DST,  PFX_0xF,   IMM_OPND_0, NO_MEM, P_386, 0, NULL },
{ "jnge",  1, { IMM8,        }, GP0, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0x7c, 0x00, 0x00 }, 1, 0, MOD_REG_IMM, 0, 0, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, IMM_OPND_0, NO_MEM, P_86,  0, NULL },
{ "jnge",  1, { IMM16,       }, GP0, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0x8c, 0x00, 0x00 }, 2, 0, MOD_REG_IMM, 0, 0, 0,                  (X16 | X32 | X64), NO_DST,  PFX_0xF,   IMM_OPND_0, NO_MEM, P_386, 0, NULL },
{ "jnge",  1, { IMM32,       }, GP0, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0x8c, 0x00, 0x00 }, 4, 0, MOD_MEM_IMM, 0, 0, 0,                  (X16 | X32 | X64), NO_DST,  PFX_0xF,   IMM_OPND_0, NO_MEM, P_386, 0, NULL },
{ "jnl",   1, { IMM8,        }, GP0, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0x7d, 0x00, 0x00 }, 1, 0, MOD_REG_IMM, 0, 0, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, IMM_OPND_0, NO_MEM, P_86,  0, NULL },
{ "jnl",   1, { IMM16,       }, GP0, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0x8d, 0x00, 0x00 }, 2, 0, MOD_REG_IMM, 0, 0, 0,                  (X16 | X32 | X64), NO_DST,  PFX_0xF,   IMM_OPND_0, NO_MEM, P_386, 0, NULL },
{ "jnl",   1, { IMM32,       }, GP0, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0x8d, 0x00, 0x00 }, 4, 0, MOD_MEM_IMM, 0, 0, 0,                  (X16 | X32 | X64), NO_DST,  PFX_0xF,   IMM_OPND_0, NO_MEM, P_386, 0, NULL },
{ "jnle",  1, { IMM8,        }, GP0, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0x7f, 0x00, 0x00 }, 1, 0, MOD_REG_IMM, 0, 0, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, IMM_OPND_0, NO_MEM, P_86,  0, NULL },
{ "jnle",  1, { IMM16,       }, GP0, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0x8f, 0x00, 0x00 }, 2, 0, MOD_REG_IMM, 0, 0, 0,                  (X16 | X32 | X64), NO_DST,  PFX_0xF,   IMM_OPND_0, NO_MEM, P_386, 0, NULL },
{ "jnle",  1, { IMM32,       }, GP0, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0x8f, 0x00, 0x00 }, 4, 0, MOD_MEM_IMM, 0, 0, 0,                  (X16 | X32 | X64), NO_DST,  PFX_0xF,   IMM_OPND_0, NO_MEM, P_386, 0, NULL },
{ "jno",   1, { IMM8,        }, GP0, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0x71, 0x00, 0x00 }, 1, 0, MOD_REG_IMM, 0, 0, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, IMM_OPND_0, NO_MEM, P_86,  0, NULL },
{ "jno",   1, { IMM16,       }, GP0, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0x81, 0x00, 0x00 }, 2, 0, MOD_REG_IMM, 0, 0, 0,                  (X16 | X32 | X64), NO_DST,  PFX_0xF,   IMM_OPND_0, NO_MEM, P_386, 0, NULL },
{ "jno",   1, { IMM32,       }, GP0, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0x81, 0x00, 0x00 }, 4, 0, MOD_MEM_IMM, 0, 0, 0,                  (X16 | X32 | X64), NO_DST,  PFX_0xF,   IMM_OPND_0, NO_MEM, P_386, 0, NULL },
{ "jnp",   1, { IMM8,        }, GP0, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0x7b, 0x00, 0x00 }, 1, 0, MOD_REG_IMM, 0, 0, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, IMM_OPND_0, NO_MEM, P_86,  0, NULL },
{ "jnp",   1, { IMM16,       }, GP0, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0x8b, 0x00, 0x00 }, 2, 0, MOD_REG_IMM, 0, 0, 0,                  (X16 | X32 | X64), NO_DST,  PFX_0xF,   IMM_OPND_0, NO_MEM, P_386, 0, NULL },
{ "jnp",   1, { IMM32,       }, GP0, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0x8b, 0x00, 0x00 }, 4, 0, MOD_MEM_IMM, 0, 0, 0,                  (X16 | X32 | X64), NO_DST,  PFX_0xF,   IMM_OPND_0, NO_MEM, P_386, 0, NULL },
{ "jns",   1, { IMM8,        }, GP0, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0x79, 0x00, 0x00 }, 1, 0, MOD_REG_IMM, 0, 0, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, IMM_OPND_0, NO_MEM, P_86,  0, NULL },
{ "jns",   1, { IMM16,       }, GP0, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0x89, 0x00, 0x00 }, 2, 0, MOD_REG_IMM, 0, 0, 0,                  (X16 | X32 | X64), NO_DST,  PFX_0xF,   IMM_OPND_0, NO_MEM, P_386, 0, NULL },
{ "jns",   1, { IMM32,       }, GP0, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0x89, 0x00, 0x00 }, 4, 0, MOD_MEM_IMM, 0, 0, 0,                  (X16 | X32 | X64), NO_DST,  PFX_0xF,   IMM_OPND_0, NO_MEM, P_386, 0, NULL },
{ "jnz",   1, { IMM8,        }, GP0, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0x75, 0x00, 0x00 }, 1, 0, MOD_REG_IMM, 0, 0, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, IMM_OPND_0, NO_MEM, P_86,  0, NULL },
{ "jnz",   1, { IMM16,       }, GP0, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0x85, 0x00, 0x00 }, 2, 0, MOD_REG_IMM, 0, 0, 0,                  (X16 | X32 | X64), NO_DST,  PFX_0xF,   IMM_OPND_0, NO_MEM, P_386, 0, NULL },
{ "jnz",   1, { IMM32,       }, GP0, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0x85, 0x00, 0x00 }, 4, 0, MOD_MEM_IMM, 0, 0, 0,                  (X16 | X32 | X64), NO_DST,  PFX_0xF,   IMM_OPND_0, NO_MEM, P_386, 0, NULL },
{ "jo",    1, { IMM8,        }, GP0, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0x70, 0x00, 0x00 }, 1, 0, MOD_REG_IMM, 0, 0, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, IMM_OPND_0, NO_MEM, P_86,  0, NULL },
{ "jo",    1, { IMM16,       }, GP0, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0x80, 0x00, 0x00 }, 2, 0, MOD_REG_IMM, 0, 0, 0,                  (X16 | X32 | X64), NO_DST,  PFX_0xF,   IMM_OPND_0, NO_MEM, P_386, 0, NULL },
{ "jo",    1, { IMM32,       }, GP0, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0x80, 0x00, 0x00 }, 4, 0, MOD_MEM_IMM, 0, 0, 0,                  (X16 | X32 | X64), NO_DST,  PFX_0xF,   IMM_OPND_0, NO_MEM, P_386, 0, NULL },
{ "jp",    1, { IMM8,        }, GP0, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0x7a, 0x00, 0x00 }, 1, 0, MOD_REG_IMM, 0, 0, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, IMM_OPND_0, NO_MEM, P_86,  0, NULL },
{ "jp",    1, { IMM16,       }, GP0, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0x8a, 0x00, 0x00 }, 2, 0, MOD_REG_IMM, 0, 0, 0,                  (X16 | X32 | X64), NO_DST,  PFX_0xF,   IMM_OPND_0, NO_MEM, P_386, 0, NULL },
{ "jp",    1, { IMM32,       }, GP0, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0x8a, 0x00, 0x00 }, 4, 0, MOD_MEM_IMM, 0, 0, 0,                  (X16 | X32 | X64), NO_DST,  PFX_0xF,   IMM_OPND_0, NO_MEM, P_386, 0, NULL },
{ "jpe",   1, { IMM8,        }, GP0, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0x7a, 0x00, 0x00 }, 1, 0, MOD_REG_IMM, 0, 0, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, IMM_OPND_0, NO_MEM, P_86,  0, NULL },
{ "jpe",   1, { IMM16,       }, GP0, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0x8a, 0x00, 0x00 }, 2, 0, MOD_REG_IMM, 0, 0, 0,                  (X16 | X32 | X64), NO_DST,  PFX_0xF,   IMM_OPND_0, NO_MEM, P_386, 0, NULL },
{ "jpe",   1, { IMM32,       }, GP0, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0x8a, 0x00, 0x00 }, 4, 0, MOD_MEM_IMM, 0, 0, 0,                  (X16 | X32 | X64), NO_DST,  PFX_0xF,   IMM_OPND_0, NO_MEM, P_386, 0, NULL },
{ "jpo",   1, { IMM8,        }, GP0, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0x7b, 0x00, 0x00 }, 1, 0, MOD_REG_IMM, 0, 0, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, IMM_OPND_0, NO_MEM, P_86,  0, NULL },
{ "jpo",   1, { IMM16,       }, GP0, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0x8b, 0x00, 0x00 }, 2, 0, MOD_REG_IMM, 0, 0, 0,                  (X16 | X32 | X64), NO_DST,  PFX_0xF,   IMM_OPND_0, NO_MEM, P_386, 0, NULL },
{ "jpo",   1, { IMM32,       }, GP0, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0x8b, 0x00, 0x00 }, 4, 0, MOD_MEM_IMM, 0, 0, 0,                  (X16 | X32 | X64), NO_DST,  PFX_0xF,   IMM_OPND_0, NO_MEM, P_386, 0, NULL },
{ "js",    1, { IMM8,        }, GP0, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0x78, 0x00, 0x00 }, 1, 0, MOD_REG_IMM, 0, 0, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, IMM_OPND_0, NO_MEM, P_86,  0, NULL },
{ "js",    1, { IMM16,       }, GP0, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0x88, 0x00, 0x00 }, 2, 0, MOD_REG_IMM, 0, 0, 0,                  (X16 | X32 | X64), NO_DST,  PFX_0xF,   IMM_OPND_0, NO_MEM, P_386, 0, NULL },
{ "js",    1, { IMM32,       }, GP0, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0x88, 0x00, 0x00 }, 4, 0, MOD_MEM_IMM, 0, 0, 0,                  (X16 | X32 | X64), NO_DST,  PFX_0xF,   IMM_OPND_0, NO_MEM, P_386, 0, NULL },
{ "jz",    1, { IMM8,        }, GP0, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0x74, 0x00, 0x00 }, 1, 0, MOD_REG_IMM, 0, 0, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, IMM_OPND_0, NO_MEM, P_86,  0, NULL },
{ "jz",    1, { IMM16,       }, GP0, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0x84, 0x00, 0x00 }, 2, 0, MOD_REG_IMM, 0, 0, 0,                  (X16 | X32 | X64), NO_DST,  PFX_0xF,   IMM_OPND_0, NO_MEM, P_386, 0, NULL },
{ "jz",    1, { IMM32,       }, GP0, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0x84, 0x00, 0x00 }, 4, 0, MOD_MEM_IMM, 0, 0, 0,                  (X16 | X32 | X64), NO_DST,  PFX_0xF,   IMM_OPND_0, NO_MEM, P_386, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//RCL r / m8, 1       D0 / 2                 M1 Valid Valid Rotate 9 bits(CF, r / m8) left once.
//RCL r / m8*, 1      REX + D0 / 2           M1 Valid N.E.Rotate 9 bits(CF, r / m8) left once.
//RCL r / m8, CL      D2 / 2                 MC Valid Valid Rotate 9 bits(CF, r / m8) left CL times.
//RCL r / m8*, CL     REX + D2 / 2           MC Valid N.E.Rotate 9 bits(CF, r / m8) left CL times.
//RCL r / m8, imm8    C0 / 2 ib              MI Valid Valid Rotate 9 bits(CF, r / m8) left imm8 times.
//RCL r / m8*, imm8   REX + C0 / 2 ib        MI Valid N.E.Rotate 9 bits(CF, r / m8) left imm8 times.
//RCL r / m16, 1      D1 / 2                 M1 Valid Valid Rotate 17 bits(CF, r / m16) left once.
//RCL r / m16, CL     D3 / 2                 MC Valid Valid Rotate 17 bits(CF, r / m16) left CL times.
//RCL r / m16, imm8   C1 / 2 ib              MI Valid Valid Rotate 17 bits(CF, r / m16) left imm8 times.
//RCL r / m32, 1      D1 / 2                 M1 Valid Valid Rotate 33 bits(CF, r / m32) left once.
//RCL r / m64, 1      REX.W + D1 / 2         M1 Valid N.E.Rotate 65 bits(CF, r / m64) left once.Uses a 6bit count.
//RCL r / m32, CL     D3 / 2                 MC Valid Valid Rotate 33 bits(CF, r / m32) left CL times.
//RCL r / m64, CL     REX.W + D3 / 2         MC Valid N.E.Rotate 65 bits(CF, r / m64) left CL times.Uses 6 bit count.
//RCL r / m32, imm8   C1 / 2 ib              MI Valid Valid Rotate 33 bits(CF, r / m32) left imm8 times.
//RCL r / m64, imm8   REX.W + C1 / 2 ib      MI Valid N.E.Rotate 65 bits(CF, r / m64) left imm8 times.Uses a 6 bit count.
/* ----------------------------------------------------------------------------------------------- */
{ "rcl",    2, { R8,       IMM_1   }, GP0, (F_OPCODE2_REG),												                                    NO_VEX, NO_EVEX, 1, 2, { 0xd0, 0xd0, 0x00 }, 1, 0, NO_MOD,      0, 0, 0,                       (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "rcl",    2, { R8H,      IMM_1   }, GP0, (F_OPCODE2_REG),												                                    NO_VEX, NO_EVEX, 1, 2, { 0xd0, 0xd0, 0x00 }, 1, 0, NO_MOD,      0, 0, 0,                       (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL }, 
{ "rcl",    2, { R8U,      IMM_1   }, GP3, REX | (F_OPCODE2_REG),												                              NO_VEX, NO_EVEX, 1, 2, { 0xd0, 0xd0, 0x00 }, 1, 0, NO_MOD,      0, 0, 0,                       (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "rcl",    2, { R8E,      IMM_1   }, GP3, (REX | REXB) | (F_OPCODE2_REG),												                    NO_VEX, NO_EVEX, 1, 2, { 0xd0, 0xd0, 0x00 }, 1, 0, NO_MOD,      0, 0, 0,                       (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "rcl",    2, { R8,       R8      }, GP0, (F_OPCODE2_REG),												                                    NO_VEX, NO_EVEX, 1, 2, { 0xd2, 0xd0, 0x00 }, 1, 0, NO_MOD,      0, 0, 0,                       (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "rcl",    2, { R8H,      R8      }, GP0, (F_OPCODE2_REG),												                                    NO_VEX, NO_EVEX, 1, 2, { 0xd2, 0xd0, 0x00 }, 1, 0, NO_MOD,      0, 0, 0,                       (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "rcl",    2, { R8U,      R8      }, GP3, REX | (F_OPCODE2_REG),												                              NO_VEX, NO_EVEX, 1, 2, { 0xd2, 0xd0, 0x00 }, 1, 0, NO_MOD,      0, 0, 0,                       (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "rcl",    2, { R8E,      R8      }, GP3, (REX | REXB) | (F_OPCODE2_REG),												                    NO_VEX, NO_EVEX, 1, 2, { 0xd2, 0xd0, 0x00 }, 1, 0, NO_MOD,      0, 0, 0,                       (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "rcl",    2, { R8,       IMM8    }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	                          NO_VEX, NO_EVEX, 1, 1, { 0xc0, 0x02, 0x00 }, 1, 0, MOD_REG_IMM, 0, 0, 0,                       (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "rcl",    2, { R8H,      IMM8    }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	                          NO_VEX, NO_EVEX, 1, 1, { 0xc0, 0x02, 0x00 }, 1, 0, MOD_REG_IMM, 0, 0, 0,                       (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "rcl",    2, { R8U,      IMM8    }, GP3, REX | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	                    NO_VEX, NO_EVEX, 1, 1, { 0xc0, 0x02, 0x00 }, 1, 0, MOD_REG_IMM, 0, 0, 0,                       (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "rcl",    2, { R8E,      IMM8    }, GP3, (REX | REXB) | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	          NO_VEX, NO_EVEX, 1, 1, { 0xc0, 0x02, 0x00 }, 1, 0, MOD_REG_IMM, 0, 0, 0,                       (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "rcl",    2, { M8,       IMM_1   }, GP0, ALLOW_SEG | (F_OPCODE2_REG),                                               NO_VEX, NO_EVEX, 1, 1, { 0xd0, 0x10, 0x00 }, 1, 0, 0x00, 0, 0,	           ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM, NO_MEM,P_86,  0, NULL },
{ "rcl",    2, { M8,       R8_CL   }, GP0, ALLOW_SEG | (F_OPCODE2_REG),									                              NO_VEX, NO_EVEX, 1, 1, { 0xd2, 0x10, 0x00 }, 1, 0, 0x00, 0, 0,	           ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM, NO_MEM,P_86,  0, NULL },
{ "rcl",    2, { M8,       IMM8    }, GP0, ALLOW_SEG | (F_MODRM | OPCODE_EXT | IMM8_ONLY),									          NO_VEX, NO_EVEX, 1, 1, { 0xc0, 0x02, 0x00 }, 1, 0, MOD_MEM_IMM, 0, 0,	     ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0,P_86,  0, NULL },
{ "rcl",    2, { R16,      IMM_1   }, GP0, (F_OPCODE2_REG),									                                          NO_VEX, NO_EVEX, 1, 2, { 0xd1, 0xd0, 0x00 }, 2, 0, NO_MOD,      0,    OP_SIZE_OVERRIDE, 0,      (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "rcl",    2, { R16E,     IMM_1   }, GP0, (REX | REXB) | (F_OPCODE2_REG),									                          NO_VEX, NO_EVEX, 1, 2, { 0xd1, 0xd0, 0x00 }, 2, 0, NO_MOD,      0,    OP_SIZE_OVERRIDE, 0,      (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "rcl",    2, { R16,      R8      }, GP0, (F_OPCODE2_REG),									                                          NO_VEX, NO_EVEX, 1, 1, { 0xd3, 0xd0, 0x00 }, 2, 0, NO_MOD,      0,    OP_SIZE_OVERRIDE, 0,      (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "rcl",    2, { R16E,     R8      }, GP0, (REX | REXB) | (F_OPCODE2_REG),									                          NO_VEX, NO_EVEX, 1, 1, { 0xd3, 0xd0, 0x00 }, 2, 0, NO_MOD,      0,    OP_SIZE_OVERRIDE, 0,      (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "rcl",    2, { R16,      IMM8    }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	                          NO_VEX, NO_EVEX, 1, 1, { 0xc1, 0x00, 0x00 }, 2, 0, 0xd0,        0,    OP_SIZE_OVERRIDE, 0,      (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "rcl",    2, { R16E,     IMM8    }, GP0, (REX | REXB) | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	          NO_VEX, NO_EVEX, 1, 1, { 0xc1, 0x00, 0x00 }, 2, 0, 0xd0,        0,    OP_SIZE_OVERRIDE, 0,      (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "rcl",    2, { R32,      IMM_1   }, GP0, (F_OPCODE2_REG),									                                          NO_VEX, NO_EVEX, 1, 2, { 0xd1, 0xd0, 0x00 }, 4, 0, NO_MOD,      0, 0, 0,                        (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "rcl",    2, { R32E,     IMM_1   }, GP0, (REX | REXB) | (F_OPCODE2_REG),									                          NO_VEX, NO_EVEX, 1, 2, { 0xd1, 0xd0, 0x00 }, 4, 0, NO_MOD,      0, 0, 0,                        (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "rcl",    2, { R32,      R8      }, GP0, (F_OPCODE2_REG),									                                          NO_VEX, NO_EVEX, 1, 2, { 0xd3, 0xd0, 0x00 }, 4, 0, NO_MOD,      0, 0, 0,                        (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "rcl",    2, { R32E,     R8      }, GP0, (REX | REXB) | (F_OPCODE2_REG),									                          NO_VEX, NO_EVEX, 1, 2, { 0xd3, 0xd0, 0x00 }, 4, 0, NO_MOD,      0, 0, 0,                        (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "rcl",    2, { R32,      IMM8    }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),                           NO_VEX, NO_EVEX, 1, 1, { 0xc1, 0x00, 0x00 }, 4, 0, 0xd0,        0, 0, 0,                        (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "rcl",    2, { R32E,     IMM8    }, GP0, (REX | REXB) | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),            NO_VEX, NO_EVEX, 1, 1, { 0xc1, 0x00, 0x00 }, 4, 0, 0xd0,        0, 0, 0,                        (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "rcl",    2, { R64,      IMM_1   }, GP3, (REX | REXW) | (F_OPCODE2_REG),                                            NO_VEX, NO_EVEX, 1, 2, { 0xd1, 0xd0, 0x00 }, 8, 0, NO_MOD,      0, 0, 0,                                    (X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "rcl",    2, { R64E,     IMM_1   }, GP3, (REX | REXW | REXB) | (F_OPCODE2_REG),                                     NO_VEX, NO_EVEX, 1, 2, { 0xd1, 0xd0, 0x00 }, 8, 0, NO_MOD,      0, 0, 0,                                    (X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "rcl",    2, { R64,      R8      }, GP3, (REX | REXW) | (F_OPCODE2_REG),                                            NO_VEX, NO_EVEX, 1, 2, { 0xd3, 0xd0, 0x00 }, 8, 0, NO_MOD,      0, 0, 0,                                    (X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "rcl",    2, { R64E,     R8      }, GP3, (REX | REXW | REXB) | (F_OPCODE2_REG),                                     NO_VEX, NO_EVEX, 1, 2, { 0xd3, 0xd0, 0x00 }, 8, 0, NO_MOD,      0, 0, 0,                                    (X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "rcl",    2, { R64,      IMM8    }, GP3, (REX | REXW) | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),            NO_VEX, NO_EVEX, 1, 1, { 0xc1, 0x00, 0x00 }, 8, 0, 0xd0,        0, 0, 0,                        (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "rcl",    2, { R64E,     IMM8    }, GP3, (REX | REXW | REXB) | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),     NO_VEX, NO_EVEX, 1, 1, { 0xc1, 0x00, 0x00 }, 8, 0, 0xd0,        0, 0, 0,                        (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "rcl",    2, { M16,      IMM_1   }, GP0, ALLOW_SEG | (F_MODRM | OPCODE_EXT | IMM8_ONLY),                            NO_VEX, NO_EVEX, 1, 1, { 0xd1, 0x02, 0x00 }, 2, 0, MOD_MEM_IMM, 0,     OP_SIZE_OVERRIDE,	0,    (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0,P_86,  0, NULL },
{ "rcl",    2, { M16,      R8_CL   }, GP0, ALLOW_SEG | (F_MODRM | OPCODE_EXT | IMM8_ONLY),									          NO_VEX, NO_EVEX, 1, 1, { 0xd3, 0x02, 0x00 }, 2, 0, MOD_MEM_IMM, 0,     OP_SIZE_OVERRIDE,  0,    (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0,P_86,  0, NULL },
{ "rcl",    2, { M16,      IMM8    }, GP0, ALLOW_SEG | (F_MODRM | OPCODE_EXT | IMM8_ONLY),									          NO_VEX, NO_EVEX, 1, 1, { 0xc1, 0x02, 0x00 }, 2, 0, MOD_MEM_IMM, 0,     OP_SIZE_OVERRIDE, 	0,    (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0,P_86,  0, NULL },
{ "rcl",    2, { M32,      IMM_1   }, GP0, ALLOW_SEG | (F_MODRM | OPCODE_EXT | IMM8_ONLY),                            NO_VEX, NO_EVEX, 1, 1, { 0xd1, 0x02, 0x00 }, 4, 0, MOD_MEM_IMM, 0,     0,	 ADDR_SIZE_OVERRIDE,  (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0,P_86,  0, NULL },
{ "rcl",    2, { M32,      R8_CL   }, GP0, ALLOW_SEG | (F_MODRM | OPCODE_EXT | IMM8_ONLY),									          NO_VEX, NO_EVEX, 1, 1, { 0xd3, 0x02, 0x00 }, 4, 0, MOD_MEM_IMM, 0,     0,  ADDR_SIZE_OVERRIDE,  (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0,P_86,  0, NULL },
{ "rcl",    2, { M32,      IMM8    }, GP0, ALLOW_SEG | (F_MODRM | OPCODE_EXT | IMM8_ONLY),									          NO_VEX, NO_EVEX, 1, 1, { 0xc1, 0x02, 0x00 }, 4, 0, MOD_MEM_IMM, 0,     0,  ADDR_SIZE_OVERRIDE,  (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0,P_86,  0, NULL },
{ "rcl",    2, { M64,      IMM_1   }, GP0, ALLOW_SEG | (REX | REXW) | (F_MODRM | OPCODE_EXT | IMM8_ONLY),             NO_VEX, NO_EVEX, 1, 1, { 0xd1, 0x02, 0x00 }, 8, 0, MOD_MEM_IMM, 0,     0,	 0,                   (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0,P_86,  0, NULL },
{ "rcl",    2, { M64,      R8_CL   }, GP0, ALLOW_SEG | (REX | REXW) | (F_MODRM | OPCODE_EXT | IMM8_ONLY),						  NO_VEX, NO_EVEX, 1, 1, { 0xd3, 0x02, 0x00 }, 8, 0, MOD_MEM_IMM, 0,     0,  0,                   (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0,P_86,  0, NULL },
{ "rcl",    2, { M64,      IMM8    }, GP0, ALLOW_SEG | (REX | REXW) | (F_MODRM | OPCODE_EXT | IMM8_ONLY),						  NO_VEX, NO_EVEX, 1, 1, { 0xc1, 0x02, 0x00 }, 8, 0, MOD_MEM_IMM, 0,     0,  0,                   (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0,P_86,  0, NULL },


/* ----------------------------------------------------------------------------------------------- */
//RCR r / m8, 1       D0 / 3                 M1 Valid Valid Rotate 9 bits(CF, r / m8) right once.
//RCR r / m8*, 1      REX + D0 / 3           M1 Valid N.E.Rotate 9 bits(CF, r / m8) right once.
//RCR r / m8, CL      D2 / 3                 MC Valid Valid Rotate 9 bits(CF, r / m8) right CL times.
//RCR r / m8*, CL     REX + D2 / 3           MC Valid N.E.Rotate 9 bits(CF, r / m8) right CL times.
//RCR r / m8, imm8    C0 / 3 ib              MI Valid Valid Rotate 9 bits(CF, r / m8) right imm8 times.
//RCR r / m8*, imm8   REX + C0 / 3 ib        MI Valid N.E.Rotate 9 bits(CF, r / m8) right imm8 times.
//RCR r / m16, 1      D1 / 3                 M1 Valid Valid Rotate 17 bits(CF, r / m16) right once.
//RCR r / m16, CL     D3 / 3                 MC Valid Valid Rotate 17 bits(CF, r / m16) right CL times.
//RCR r / m16, imm8   C1 / 3 ib              MI Valid Valid Rotate 17 bits(CF, r / m16) right imm8 times.
//RCR r / m32, 1      D1 / 3                 M1 Valid Valid Rotate 33 bits(CF, r / m32) right once.Uses a 6 bit count.
//RCR r / m64, 1      REX.W + D1 / 3         M1 Valid N.E.Rotate 65 bits(CF, r / m64) right once.Uses a 6 bit count.
//RCR r / m32, CL     D3 / 3                 MC Valid Valid Rotate 33 bits(CF, r / m32) right CL times.
//RCR r / m64, CL     REX.W + D3 / 3         MC Valid N.E.Rotate 65 bits(CF, r / m64) right CL times.Uses a 6 bit count.
//RCR r / m32, imm8   C1 / 3 ib              MI Valid Valid Rotate 33 bits(CF, r / m32) right imm8 times.
//RCR r / m64, imm8   REX.W + C1 / 3 ib      MI Valid N.E.Rotate 65 bits(CF, r / m64) right imm8 times.Uses a 6 bit count.
/* ----------------------------------------------------------------------------------------------- */
{ "rcr",    2, { R8,       IMM_1   }, GP0, (F_OPCODE2_REG),												                                    NO_VEX, NO_EVEX, 1, 2, { 0xd0, 0xd8, 0x00 }, 1, 0, NO_MOD,      0, 0, 0,                       (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "rcr",    2, { R8H,      IMM_1   }, GP0, (F_OPCODE2_REG),												                                    NO_VEX, NO_EVEX, 1, 2, { 0xd0, 0xd8, 0x00 }, 1, 0, NO_MOD,      0, 0, 0,                       (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "rcr",    2, { R8U,      IMM_1   }, GP3, REX | (F_OPCODE2_REG),												                              NO_VEX, NO_EVEX, 1, 2, { 0xd0, 0xd8, 0x00 }, 1, 0, NO_MOD,      0, 0, 0,                       (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "rcr",    2, { R8E,      IMM_1   }, GP3, (REX | REXB) | (F_OPCODE2_REG),												                    NO_VEX, NO_EVEX, 1, 2, { 0xd0, 0xd8, 0x00 }, 1, 0, NO_MOD,      0, 0, 0,                       (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "rcr",    2, { R8,       R8      }, GP0, (F_OPCODE2_REG),												                                    NO_VEX, NO_EVEX, 1, 2, { 0xd2, 0xd8, 0x00 }, 1, 0, NO_MOD,      0, 0, 0,                       (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "rcr",    2, { R8H,      R8      }, GP0, (F_OPCODE2_REG),												                                    NO_VEX, NO_EVEX, 1, 2, { 0xd2, 0xd8, 0x00 }, 1, 0, NO_MOD,      0, 0, 0,                       (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "rcr",    2, { R8U,      R8      }, GP3, REX | (F_OPCODE2_REG),												                              NO_VEX, NO_EVEX, 1, 2, { 0xd2, 0xd8, 0x00 }, 1, 0, NO_MOD,      0, 0, 0,                       (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "rcr",    2, { R8E,      R8      }, GP3, (REX | REXB) | (F_OPCODE2_REG),												                    NO_VEX, NO_EVEX, 1, 2, { 0xd2, 0xd8, 0x00 }, 1, 0, NO_MOD,      0, 0, 0,                       (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "rcr",    2, { R8,       IMM8    }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	                          NO_VEX, NO_EVEX, 1, 1, { 0xc0, 0x03, 0x00 }, 1, 0, MOD_REG_IMM, 0, 0, 0,                       (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "rcr",    2, { R8H,      IMM8    }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	                          NO_VEX, NO_EVEX, 1, 1, { 0xc0, 0x03, 0x00 }, 1, 0, MOD_REG_IMM, 0, 0, 0,                       (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "rcr",    2, { R8U,      IMM8    }, GP3, REX | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	                    NO_VEX, NO_EVEX, 1, 1, { 0xc0, 0x03, 0x00 }, 1, 0, MOD_REG_IMM, 0, 0, 0,                       (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "rcr",    2, { R8E,      IMM8    }, GP3, (REX | REXB) | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	          NO_VEX, NO_EVEX, 1, 1, { 0xc0, 0x03, 0x00 }, 1, 0, MOD_REG_IMM, 0, 0, 0,                       (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "rcr",    2, { M8,       IMM_1   }, GP0, ALLOW_SEG | (F_OPCODE2_REG),                                               NO_VEX, NO_EVEX, 1, 1, { 0xd0, 0x18, 0x00 }, 1, 0, 0x00, 0, 0,	           ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM, NO_MEM,P_86,  0, NULL },
{ "rcr",    2, { M8,       R8_CL   }, GP0, ALLOW_SEG | (F_OPCODE2_REG),									                              NO_VEX, NO_EVEX, 1, 1, { 0xd2, 0x18, 0x00 }, 1, 0, 0x00, 0, 0,	           ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM, NO_MEM,P_86,  0, NULL },
{ "rcr",    2, { M8,       IMM8    }, GP0, ALLOW_SEG | (F_MODRM | OPCODE_EXT | IMM8_ONLY),									          NO_VEX, NO_EVEX, 1, 1, { 0xc0, 0x03, 0x00 }, 1, 0, MOD_MEM_IMM, 0, 0,	     ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0,P_86,  0, NULL },
{ "rcr",    2, { R16,      IMM_1   }, GP0, (F_OPCODE2_REG),									                                          NO_VEX, NO_EVEX, 1, 2, { 0xd1, 0xd8, 0x00 }, 2, 0, NO_MOD,      0,    OP_SIZE_OVERRIDE, 0,      (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "rcr",    2, { R16E,     IMM_1   }, GP0, (REX | REXB) | (F_OPCODE2_REG),									                          NO_VEX, NO_EVEX, 1, 2, { 0xd1, 0xd8, 0x00 }, 2, 0, NO_MOD,      0,    OP_SIZE_OVERRIDE, 0,      (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "rcr",    2, { R16,      R8      }, GP0, (F_OPCODE2_REG),									                                          NO_VEX, NO_EVEX, 1, 1, { 0xd3, 0xd8, 0x00 }, 2, 0, NO_MOD,      0,    OP_SIZE_OVERRIDE, 0,      (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "rcr",    2, { R16E,     R8      }, GP0, (REX | REXB) | (F_OPCODE2_REG),									                          NO_VEX, NO_EVEX, 1, 1, { 0xd3, 0xd8, 0x00 }, 2, 0, NO_MOD,      0,    OP_SIZE_OVERRIDE, 0,      (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "rcr",    2, { R16,      IMM8    }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	                          NO_VEX, NO_EVEX, 1, 1, { 0xc1, 0x00, 0x00 }, 2, 0, 0xd8,        0,    OP_SIZE_OVERRIDE, 0,      (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "rcr",    2, { R16E,     IMM8    }, GP0, (REX | REXB) | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	          NO_VEX, NO_EVEX, 1, 1, { 0xc1, 0x00, 0x00 }, 2, 0, 0xd8,        0,    OP_SIZE_OVERRIDE, 0,      (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "rcr",    2, { R32,      IMM_1   }, GP0, (F_OPCODE2_REG),									                                          NO_VEX, NO_EVEX, 1, 2, { 0xd1, 0xd8, 0x00 }, 4, 0, NO_MOD,      0, 0, 0,                        (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "rcr",    2, { R32E,     IMM_1   }, GP0, (REX | REXB) | (F_OPCODE2_REG),									                          NO_VEX, NO_EVEX, 1, 2, { 0xd1, 0xd8, 0x00 }, 4, 0, NO_MOD,      0, 0, 0,                        (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "rcr",    2, { R32,      R8      }, GP0, (F_OPCODE2_REG),									                                          NO_VEX, NO_EVEX, 1, 2, { 0xd3, 0xd8, 0x00 }, 4, 0, NO_MOD,      0, 0, 0,                        (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "rcr",    2, { R32E,     R8      }, GP0, (REX | REXB) | (F_OPCODE2_REG),									                          NO_VEX, NO_EVEX, 1, 2, { 0xd3, 0xd8, 0x00 }, 4, 0, NO_MOD,      0, 0, 0,                        (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "rcr",    2, { R32,      IMM8    }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),                           NO_VEX, NO_EVEX, 1, 1, { 0xc1, 0x00, 0x00 }, 4, 0, 0xd8,        0, 0, 0,                        (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "rcr",    2, { R32E,     IMM8    }, GP0, (REX | REXB) | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),            NO_VEX, NO_EVEX, 1, 1, { 0xc1, 0x00, 0x00 }, 4, 0, 0xd8,        0, 0, 0,                        (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "rcr",    2, { R64,      IMM_1   }, GP3, (REX | REXW) | (F_OPCODE2_REG),                                            NO_VEX, NO_EVEX, 1, 2, { 0xd1, 0xd8, 0x00 }, 8, 0, NO_MOD,      0, 0, 0,                                    (X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "rcr",    2, { R64E,     IMM_1   }, GP3, (REX | REXW | REXB) | (F_OPCODE2_REG),                                     NO_VEX, NO_EVEX, 1, 2, { 0xd1, 0xd8, 0x00 }, 8, 0, NO_MOD,      0, 0, 0,                                    (X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "rcr",    2, { R64,      R8      }, GP3, (REX | REXW) | (F_OPCODE2_REG),                                            NO_VEX, NO_EVEX, 1, 2, { 0xd3, 0xd8, 0x00 }, 8, 0, NO_MOD,      0, 0, 0,                                    (X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "rcr",    2, { R64E,     R8      }, GP3, (REX | REXW | REXB) | (F_OPCODE2_REG),                                     NO_VEX, NO_EVEX, 1, 2, { 0xd3, 0xd8, 0x00 }, 8, 0, NO_MOD,      0, 0, 0,                                    (X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "rcr",    2, { R64,      IMM8    }, GP3, (REX | REXW) | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),            NO_VEX, NO_EVEX, 1, 1, { 0xc1, 0x00, 0x00 }, 8, 0, 0xd8,        0, 0, 0,                        (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "rcr",    2, { R64E,     IMM8    }, GP3, (REX | REXW | REXB) | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),     NO_VEX, NO_EVEX, 1, 1, { 0xc1, 0x00, 0x00 }, 8, 0, 0xd8,        0, 0, 0,                        (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "rcr",    2, { M16,      IMM_1   }, GP0, ALLOW_SEG | (F_MODRM | OPCODE_EXT | IMM8_ONLY),                            NO_VEX, NO_EVEX, 1, 1, { 0xd1, 0x03, 0x00 }, 2, 0, MOD_MEM_IMM, 0,     OP_SIZE_OVERRIDE,	0,    (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0,P_86,  0, NULL },
{ "rcr",    2, { M16,      R8_CL   }, GP0, ALLOW_SEG | (F_MODRM | OPCODE_EXT | IMM8_ONLY),									          NO_VEX, NO_EVEX, 1, 1, { 0xd3, 0x03, 0x00 }, 2, 0, MOD_MEM_IMM, 0,     OP_SIZE_OVERRIDE,  0,    (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0,P_86,  0, NULL },
{ "rcr",    2, { M16,      IMM8    }, GP0, ALLOW_SEG | (F_MODRM | OPCODE_EXT | IMM8_ONLY),									          NO_VEX, NO_EVEX, 1, 1, { 0xc1, 0x03, 0x00 }, 2, 0, MOD_MEM_IMM, 0,     OP_SIZE_OVERRIDE, 	0,    (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0,P_86,  0, NULL },
{ "rcr",    2, { M32,      IMM_1   }, GP0, ALLOW_SEG | (F_MODRM | OPCODE_EXT | IMM8_ONLY),                            NO_VEX, NO_EVEX, 1, 1, { 0xd1, 0x03, 0x00 }, 4, 0, MOD_MEM_IMM, 0,     0,	 ADDR_SIZE_OVERRIDE,  (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0,P_86,  0, NULL },
{ "rcr",    2, { M32,      R8_CL   }, GP0, ALLOW_SEG | (F_MODRM | OPCODE_EXT | IMM8_ONLY),									          NO_VEX, NO_EVEX, 1, 1, { 0xd3, 0x03, 0x00 }, 4, 0, MOD_MEM_IMM, 0,     0,  ADDR_SIZE_OVERRIDE,  (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0,P_86,  0, NULL },
{ "rcr",    2, { M32,      IMM8    }, GP0, ALLOW_SEG | (F_MODRM | OPCODE_EXT | IMM8_ONLY),									          NO_VEX, NO_EVEX, 1, 1, { 0xc1, 0x03, 0x00 }, 4, 0, MOD_MEM_IMM, 0,     0,  ADDR_SIZE_OVERRIDE,  (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0,P_86,  0, NULL },
{ "rcr",    2, { M64,      IMM_1   }, GP0, ALLOW_SEG | (REX | REXW) | (F_MODRM | OPCODE_EXT | IMM8_ONLY),             NO_VEX, NO_EVEX, 1, 1, { 0xd1, 0x03, 0x00 }, 8, 0, MOD_MEM_IMM, 0,     0,	 0,                   (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0,P_86,  0, NULL },
{ "rcr",    2, { M64,      R8_CL   }, GP0, ALLOW_SEG | (REX | REXW) | (F_MODRM | OPCODE_EXT | IMM8_ONLY),						  NO_VEX, NO_EVEX, 1, 1, { 0xd3, 0x03, 0x00 }, 8, 0, MOD_MEM_IMM, 0,     0,  0,                   (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0,P_86,  0, NULL },
{ "rcr",    2, { M64,      IMM8    }, GP0, ALLOW_SEG | (REX | REXW) | (F_MODRM | OPCODE_EXT | IMM8_ONLY),						  NO_VEX, NO_EVEX, 1, 1, { 0xc1, 0x03, 0x00 }, 8, 0, MOD_MEM_IMM, 0,     0,  0,                   (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0,P_86,  0, NULL },


/* ----------------------------------------------------------------------------------------------- */
//ROL r / m8, 1       D0 / 0                 M1 Valid Valid Rotate 8 bits r / m8 left once.
//ROL r / m8*, 1      REX + D0 / 0           M1 Valid N.E.Rotate 8 bits r / m8 left once
//ROL r / m8, CL      D2 / 0                 MC Valid Valid Rotate 8 bits r / m8 left CL times.
//ROL r / m8*, CL     REX + D2 / 0           MC Valid N.E.Rotate 8 bits r / m8 left CL times.
//ROL r / m8, imm8    C0 / 0 ib              MI Valid Valid Rotate 8 bits r / m8 left imm8 times.
//ROL r / m8*, imm8   REX + C0 / 0 ib        MI Valid N.E.Rotate 8 bits r / m8 left imm8 times.
//ROL r / m16, 1      D1 / 0                 M1 Valid Valid Rotate 16 bits r / m16 left once.
//ROL r / m16, CL     D3 / 0                 MC Valid Valid Rotate 16 bits r / m16 left CL times.
//ROL r / m16, imm8   C1 / 0 ib              MI Valid Valid Rotate 16 bits r / m16 left imm8 times.
//ROL r / m32, 1      D1 / 0                 M1 Valid Valid Rotate 32 bits r / m32 left once.
//ROL r / m64, 1      REX.W + D1 / 0         M1 Valid N.E.Rotate 64 bits r / m64 left once.Uses a 6 bit count.
//ROL r / m32, CL     D3 / 0                 MC Valid Valid Rotate 32 bits r / m32 left CL times.
//ROL r / m64, CL     REX.W + D3 / 0         MC Valid N.E.Rotate 64 bits r / m64 left CL times.Uses a 6 bit count.
//ROL r / m32, imm8   C1 / 0 ib              MI Valid Valid Rotate 32 bits r / m32 left imm8 times.
//ROL r / m64, imm8   REX.W + C1 / 0 ib      MI Valid N.E.Rotate 64 bits r / m64 left imm8 times.Uses a 6 bit count.
/* ----------------------------------------------------------------------------------------------- */
{ "rol",    2, { R8,       IMM_1   }, GP0, (F_OPCODE2_REG),												                                    NO_VEX, NO_EVEX, 1, 2, { 0xd0, 0xc0, 0x00 }, 1, 0, NO_MOD,      0, 0, 0,                       (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "rol",    2, { R8H,      IMM_1   }, GP0, (F_OPCODE2_REG),												                                    NO_VEX, NO_EVEX, 1, 2, { 0xd0, 0xc0, 0x00 }, 1, 0, NO_MOD,      0, 0, 0,                       (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "rol",    2, { R8U,      IMM_1   }, GP3, REX | (F_OPCODE2_REG),												                              NO_VEX, NO_EVEX, 1, 2, { 0xd0, 0xc0, 0x00 }, 1, 0, NO_MOD,      0, 0, 0,                       (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "rol",    2, { R8E,      IMM_1   }, GP3, (REX | REXB) | (F_OPCODE2_REG),												                    NO_VEX, NO_EVEX, 1, 2, { 0xd0, 0xc0, 0x00 }, 1, 0, NO_MOD,      0, 0, 0,                       (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "rol",    2, { R8,       R8      }, GP0, (F_OPCODE2_REG),												                                    NO_VEX, NO_EVEX, 1, 2, { 0xd2, 0xc0, 0x00 }, 1, 0, NO_MOD,      0, 0, 0,                       (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "rol",    2, { R8H,      R8      }, GP0, (F_OPCODE2_REG),												                                    NO_VEX, NO_EVEX, 1, 2, { 0xd2, 0xc0, 0x00 }, 1, 0, NO_MOD,      0, 0, 0,                       (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "rol",    2, { R8U,      R8      }, GP3, REX | (F_OPCODE2_REG),												                              NO_VEX, NO_EVEX, 1, 2, { 0xd2, 0xc0, 0x00 }, 1, 0, NO_MOD,      0, 0, 0,                       (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "rol",    2, { R8E,      R8      }, GP3, (REX | REXB) | (F_OPCODE2_REG),												                    NO_VEX, NO_EVEX, 1, 2, { 0xd2, 0xc0, 0x00 }, 1, 0, NO_MOD,      0, 0, 0,                       (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "rol",    2, { R8,       IMM8    }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	                          NO_VEX, NO_EVEX, 1, 1, { 0xc0, 0x00, 0x00 }, 1, 0, 0xc0, 0, 0, 0,                       (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "rol",    2, { R8H,      IMM8    }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	                          NO_VEX, NO_EVEX, 1, 1, { 0xc0, 0x00, 0x00 }, 1, 0, 0xc0, 0, 0, 0,                       (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "rol",    2, { R8U,      IMM8    }, GP3, REX | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	                    NO_VEX, NO_EVEX, 1, 1, { 0xc0, 0x00, 0x00 }, 1, 0, 0xc0, 0, 0, 0,                       (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "rol",    2, { R8E,      IMM8    }, GP3, (REX | REXB) | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	          NO_VEX, NO_EVEX, 1, 1, { 0xc0, 0x00, 0x00 }, 1, 0, 0xc0, 0, 0, 0,                       (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "rol",    2, { M8,       IMM_1   }, GP0, ALLOW_SEG | (F_OPCODE2_REG),                                               NO_VEX, NO_EVEX, 1, 1, { 0xd0, 0x00, 0x00 }, 1, 0, 0xc0, 0, 0,	           ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM, NO_MEM,P_86,  0, NULL },
{ "rol",    2, { M8,       R8_CL   }, GP0, ALLOW_SEG | (F_OPCODE2_REG),									                              NO_VEX, NO_EVEX, 1, 1, { 0xd2, 0x00, 0x00 }, 1, 0, 0xc0, 0, 0,	           ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM, NO_MEM,P_86,  0, NULL },
{ "rol",    2, { M8,       IMM8    }, GP0, ALLOW_SEG | (F_MODRM | OPCODE_EXT | IMM8_ONLY),									          NO_VEX, NO_EVEX, 1, 1, { 0xc0, 0x00, 0x00 }, 1, 0, MOD_MEM_IMM, 0, 0,	     ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0,P_86,  0, NULL },

{ "rol",    2, { R16,      IMM_1   }, GP0, (F_OPCODE2_REG),									                                          NO_VEX, NO_EVEX, 1, 2, { 0xd1, 0xc0, 0x00 }, 2, 0, NO_MOD,      0,    OP_SIZE_OVERRIDE, 0,      (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "rol",    2, { R16E,     IMM_1   }, GP0, (REX | REXB) | (F_OPCODE2_REG),									                          NO_VEX, NO_EVEX, 1, 2, { 0xd1, 0xc0, 0x00 }, 2, 0, NO_MOD,      0,    OP_SIZE_OVERRIDE, 0,      (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "rol",    2, { R16,      R8      }, GP0, (F_OPCODE2_REG),									                                          NO_VEX, NO_EVEX, 1, 1, { 0xd3, 0xc0, 0x00 }, 2, 0, NO_MOD,      0,    OP_SIZE_OVERRIDE, 0,      (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "rol",    2, { R16E,     R8      }, GP0, (REX | REXB) | (F_OPCODE2_REG),									                          NO_VEX, NO_EVEX, 1, 1, { 0xd3, 0xc0, 0x00 }, 2, 0, NO_MOD,      0,    OP_SIZE_OVERRIDE, 0,      (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "rol",    2, { R16,      IMM8    }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	                          NO_VEX, NO_EVEX, 1, 1, { 0xc1, 0x00, 0x00 }, 2, 0, 0xc0,        0,    OP_SIZE_OVERRIDE, 0,      (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "rol",    2, { R16E,     IMM8    }, GP0, (REX | REXB) | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	          NO_VEX, NO_EVEX, 1, 1, { 0xc1, 0x00, 0x00 }, 2, 0, 0xc0,        0,    OP_SIZE_OVERRIDE, 0,      (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "rol",    2, { R32,      IMM_1   }, GP0, (F_OPCODE2_REG),									                                          NO_VEX, NO_EVEX, 1, 2, { 0xd1, 0xc0, 0x00 }, 4, 0, NO_MOD,      0, 0, 0,                        (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "rol",    2, { R32E,     IMM_1   }, GP0, (REX | REXB) | (F_OPCODE2_REG),									                          NO_VEX, NO_EVEX, 1, 2, { 0xd1, 0xc0, 0x00 }, 4, 0, NO_MOD,      0, 0, 0,                        (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "rol",    2, { R32,      R8      }, GP0, (F_OPCODE2_REG),									                                          NO_VEX, NO_EVEX, 1, 2, { 0xd3, 0xc0, 0x00 }, 4, 0, NO_MOD,      0, 0, 0,                        (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "rol",    2, { R32E,     R8      }, GP0, (REX | REXB) | (F_OPCODE2_REG),									                          NO_VEX, NO_EVEX, 1, 2, { 0xd3, 0xc0, 0x00 }, 4, 0, NO_MOD,      0, 0, 0,                        (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "rol",    2, { R32,      IMM8    }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),                           NO_VEX, NO_EVEX, 1, 1, { 0xc1, 0x00, 0x00 }, 4, 0, 0xc0,        0, 0, 0,                        (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "rol",    2, { R32E,     IMM8    }, GP0, (REX | REXB) | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),            NO_VEX, NO_EVEX, 1, 1, { 0xc1, 0x00, 0x00 }, 4, 0, 0xc0,        0, 0, 0,                        (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "rol",    2, { R64,      IMM_1   }, GP3, (REX | REXW) | (F_OPCODE2_REG),                                            NO_VEX, NO_EVEX, 1, 2, { 0xd1, 0xc0, 0x00 }, 8, 0, NO_MOD,      0, 0, 0,                                    (X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "rol",    2, { R64E,     IMM_1   }, GP3, (REX | REXW | REXB) | (F_OPCODE2_REG),                                     NO_VEX, NO_EVEX, 1, 2, { 0xd1, 0xc0, 0x00 }, 8, 0, NO_MOD,      0, 0, 0,                                    (X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "rol",    2, { R64,      R8      }, GP3, (REX | REXW) | (F_OPCODE2_REG),                                            NO_VEX, NO_EVEX, 1, 2, { 0xd3, 0xc0, 0x00 }, 8, 0, NO_MOD,      0, 0, 0,                                    (X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "rol",    2, { R64E,     R8      }, GP3, (REX | REXW | REXB) | (F_OPCODE2_REG),                                     NO_VEX, NO_EVEX, 1, 2, { 0xd3, 0xc0, 0x00 }, 8, 0, NO_MOD,      0, 0, 0,                                    (X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "rol",    2, { R64,      IMM8    }, GP3, (REX | REXW) | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),            NO_VEX, NO_EVEX, 1, 1, { 0xc1, 0x00, 0x00 }, 8, 0, 0xc0,        0, 0, 0,                        (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "rol",    2, { R64E,     IMM8    }, GP3, (REX | REXW | REXB) | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),     NO_VEX, NO_EVEX, 1, 1, { 0xc1, 0x00, 0x00 }, 8, 0, 0xc0,        0, 0, 0,                        (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },

{ "rol",    2, { M16,      IMM_1   }, GP0, ALLOW_SEG | (F_MODRM | OPCODE_EXT | IMM8_ONLY),                            NO_VEX, NO_EVEX, 1, 1, { 0xd1, 0x00, 0x00 }, 2, 0, MOD_MEM_IMM, 0,     OP_SIZE_OVERRIDE,	0,    (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0,P_86,  0, NULL },
{ "rol",    2, { M16,      R8_CL   }, GP0, ALLOW_SEG | (F_MODRM | OPCODE_EXT | IMM8_ONLY),									          NO_VEX, NO_EVEX, 1, 1, { 0xd3, 0x00, 0x00 }, 2, 0, MOD_MEM_IMM, 0,     OP_SIZE_OVERRIDE,  0,    (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0,P_86,  0, NULL },
{ "rol",    2, { M16,      IMM8    }, GP0, ALLOW_SEG | (F_MODRM | OPCODE_EXT | IMM8_ONLY),									          NO_VEX, NO_EVEX, 1, 1, { 0xc1, 0x00, 0x00 }, 2, 0, MOD_MEM_IMM, 0,     OP_SIZE_OVERRIDE, 	0,    (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0,P_86,  0, NULL },
{ "rol",    2, { M32,      IMM_1   }, GP0, ALLOW_SEG | (F_MODRM | OPCODE_EXT | IMM8_ONLY),                            NO_VEX, NO_EVEX, 1, 1, { 0xd1, 0x00, 0x00 }, 4, 0, MOD_MEM_IMM, 0,     0,	 ADDR_SIZE_OVERRIDE,  (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0,P_86,  0, NULL },
{ "rol",    2, { M32,      R8_CL   }, GP0, ALLOW_SEG | (F_MODRM | OPCODE_EXT | IMM8_ONLY),									          NO_VEX, NO_EVEX, 1, 1, { 0xd3, 0x00, 0x00 }, 4, 0, MOD_MEM_IMM, 0,     0,  ADDR_SIZE_OVERRIDE,  (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0,P_86,  0, NULL },
{ "rol",    2, { M32,      IMM8    }, GP0, ALLOW_SEG | (F_MODRM | OPCODE_EXT | IMM8_ONLY),									          NO_VEX, NO_EVEX, 1, 1, { 0xc1, 0x00, 0x00 }, 4, 0, MOD_MEM_IMM, 0,     0,  ADDR_SIZE_OVERRIDE,  (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0,P_86,  0, NULL },
{ "rol",    2, { M64,      IMM_1   }, GP0, ALLOW_SEG | (REX | REXW) | (F_MODRM | OPCODE_EXT | IMM8_ONLY),             NO_VEX, NO_EVEX, 1, 1, { 0xd1, 0x00, 0x00 }, 8, 0, MOD_MEM_IMM, 0,     0,	 0,                   (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0,P_86,  0, NULL },
{ "rol",    2, { M64,      R8_CL   }, GP0, ALLOW_SEG | (REX | REXW) | (F_MODRM | OPCODE_EXT | IMM8_ONLY),						  NO_VEX, NO_EVEX, 1, 1, { 0xd3, 0x00, 0x00 }, 8, 0, MOD_MEM_IMM, 0,     0,  0,                   (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0,P_86,  0, NULL },
{ "rol",    2, { M64,      IMM8    }, GP0, ALLOW_SEG | (REX | REXW) | (F_MODRM | OPCODE_EXT | IMM8_ONLY),						  NO_VEX, NO_EVEX, 1, 1, { 0xc1, 0x00, 0x00 }, 8, 0, MOD_MEM_IMM, 0,     0,  0,                   (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0,P_86,  0, NULL },


/* ----------------------------------------------------------------------------------------------- */
//ROR r / m8, 1       D0 / 1                 M1 Valid Valid Rotate 8 bits r / m8 right once.
//ROR r / m8*, 1      REX + D0 / 1           M1 Valid N.E.Rotate 8 bits r / m8 right once.
//ROR r / m8, CL      D2 / 1                 MC Valid Valid Rotate 8 bits r / m8 right CL times.
//ROR r / m8*, CL     REX + D2 / 1           MC Valid N.E.Rotate 8 bits r / m8 right CL times.
//ROR r / m8, imm8    C0 / 1 ib              MI Valid Valid Rotate 8 bits r / m16 right imm8 times.
//ROR r / m8*, imm8   REX + C0 / 1 ib        MI Valid N.E.Rotate 8 bits r / m16 right imm8 times.
//ROR r / m16, 1      D1 / 1                 M1 Valid Valid Rotate 16 bits r / m16 right once.
//ROR r / m16, CL     D3 / 1                 MC Valid Valid Rotate 16 bits r / m16 right CL times.
//ROR r / m16, imm8   C1 / 1 ib              MI Valid Valid Rotate 16 bits r / m16 right imm8 times.
//ROR r / m32, 1      D1 / 1                 M1 Valid Valid Rotate 32 bits r / m32 right once.
//ROR r / m64, 1      REX.W + D1 / 1         M1 Valid N.E.Rotate 64 bits r / m64 right once.Uses a 6 bit count.
//ROR r / m32, CL     D3 / 1                 MC Valid Valid Rotate 32 bits r / m32 right CL times.
//ROR r / m64, CL     REX.W + D3 / 1         MC Valid N.E.Rotate 64 bits r / m64 right CL times.Uses a 6 bit count.
//ROR r / m32, imm8   C1 / 1 ib              MI Valid Valid Rotate 32 bits r / m32 right imm8 times.
//ROR r / m64, imm8   REX.W + C1 / 1 ib      MI Valid N.E.Rotate 64 bits r / m64 right imm8 times.Uses a 6 bit count.
/* ----------------------------------------------------------------------------------------------- */
{ "ror",    2, { R8,       IMM_1   }, GP0, (F_OPCODE2_REG),												                                    NO_VEX, NO_EVEX, 1, 2, { 0xd0, 0xc8, 0x00 }, 1, 0, NO_MOD,      0, 0, 0,                       (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "ror",    2, { R8H,      IMM_1   }, GP0, (F_OPCODE2_REG),												                                    NO_VEX, NO_EVEX, 1, 2, { 0xd0, 0xc8, 0x00 }, 1, 0, NO_MOD,      0, 0, 0,                       (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "ror",    2, { R8U,      IMM_1   }, GP3, REX | (F_OPCODE2_REG),												                              NO_VEX, NO_EVEX, 1, 2, { 0xd0, 0xc8, 0x00 }, 1, 0, NO_MOD,      0, 0, 0,                       (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "ror",    2, { R8E,      IMM_1   }, GP3, (REX | REXB) | (F_OPCODE2_REG),												                    NO_VEX, NO_EVEX, 1, 2, { 0xd0, 0xc8, 0x00 }, 1, 0, NO_MOD,      0, 0, 0,                       (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "ror",    2, { R8,       R8      }, GP0, (F_OPCODE2_REG),												                                    NO_VEX, NO_EVEX, 1, 2, { 0xd2, 0xc8, 0x00 }, 1, 0, NO_MOD,      0, 0, 0,                       (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "ror",    2, { R8H,      R8      }, GP0, (F_OPCODE2_REG),												                                    NO_VEX, NO_EVEX, 1, 2, { 0xd2, 0xc8, 0x00 }, 1, 0, NO_MOD,      0, 0, 0,                       (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "ror",    2, { R8U,      R8      }, GP3, REX | (F_OPCODE2_REG),												                              NO_VEX, NO_EVEX, 1, 2, { 0xd2, 0xc8, 0x00 }, 1, 0, NO_MOD,      0, 0, 0,                       (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "ror",    2, { R8E,      R8      }, GP3, (REX | REXB) | (F_OPCODE2_REG),												                    NO_VEX, NO_EVEX, 1, 2, { 0xd2, 0xc8, 0x00 }, 1, 0, NO_MOD,      0, 0, 0,                       (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "ror",    2, { R8,       IMM8    }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	                          NO_VEX, NO_EVEX, 1, 1, { 0xc0, 0x00, 0x00 }, 1, 0, 0xc8, 0, 0, 0,                       (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "ror",    2, { R8H,      IMM8    }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	                          NO_VEX, NO_EVEX, 1, 1, { 0xc0, 0x00, 0x00 }, 1, 0, 0xc8, 0, 0, 0,                       (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "ror",    2, { R8U,      IMM8    }, GP3, REX | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	                    NO_VEX, NO_EVEX, 1, 1, { 0xc0, 0x00, 0x00 }, 1, 0, 0xc8, 0, 0, 0,                       (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "ror",    2, { R8E,      IMM8    }, GP3, (REX | REXB) | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	          NO_VEX, NO_EVEX, 1, 1, { 0xc0, 0x00, 0x00 }, 1, 0, 0xc8, 0, 0, 0,                       (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "ror",    2, { M8,       IMM_1   }, GP0, ALLOW_SEG | (F_OPCODE2_REG),                                               NO_VEX, NO_EVEX, 1, 1, { 0xd0, 0x00, 0x00 }, 1, 0, 0xc8, 0, 0,	           ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM, NO_MEM,P_86,  0, NULL },
{ "ror",    2, { M8,       R8_CL   }, GP0, ALLOW_SEG | (F_OPCODE2_REG),									                              NO_VEX, NO_EVEX, 1, 1, { 0xd2, 0x00, 0x00 }, 1, 0, 0xc8, 0, 0,	           ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM, NO_MEM,P_86,  0, NULL },
{ "ror",    2, { M8,       IMM8    }, GP0, ALLOW_SEG | (F_MODRM | OPCODE_EXT | IMM8_ONLY),									          NO_VEX, NO_EVEX, 1, 1, { 0xc0, 0x00, 0x00 }, 1, 0, MOD_MEM_IMM, 0, 0,	     ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0,P_86,  0, NULL },
{ "ror",    2, { R16,      IMM_1   }, GP0, (F_OPCODE2_REG),									                                          NO_VEX, NO_EVEX, 1, 2, { 0xd1, 0xc8, 0x00 }, 2, 0, NO_MOD,      0,    OP_SIZE_OVERRIDE, 0,      (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "ror",    2, { R16E,     IMM_1   }, GP0, (REX | REXB) | (F_OPCODE2_REG),									                          NO_VEX, NO_EVEX, 1, 2, { 0xd1, 0xc8, 0x00 }, 2, 0, NO_MOD,      0,    OP_SIZE_OVERRIDE, 0,      (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "ror",    2, { R16,      R8      }, GP0, (F_OPCODE2_REG),									                                          NO_VEX, NO_EVEX, 1, 1, { 0xd3, 0xc8, 0x00 }, 2, 0, NO_MOD,      0,    OP_SIZE_OVERRIDE, 0,      (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "ror",    2, { R16E,     R8      }, GP0, (REX | REXB) | (F_OPCODE2_REG),									                          NO_VEX, NO_EVEX, 1, 1, { 0xd3, 0xc8, 0x00 }, 2, 0, NO_MOD,      0,    OP_SIZE_OVERRIDE, 0,      (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "ror",    2, { R16,      IMM8    }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	                          NO_VEX, NO_EVEX, 1, 1, { 0xc1, 0x00, 0x00 }, 2, 0, 0xc8,        0,    OP_SIZE_OVERRIDE, 0,      (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "ror",    2, { R16E,     IMM8    }, GP0, (REX | REXB) | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	          NO_VEX, NO_EVEX, 1, 1, { 0xc1, 0x00, 0x00 }, 2, 0, 0xc8,        0,    OP_SIZE_OVERRIDE, 0,      (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "ror",    2, { R32,      IMM_1   }, GP0, (F_OPCODE2_REG),									                                          NO_VEX, NO_EVEX, 1, 2, { 0xd1, 0xc8, 0x00 }, 4, 0, NO_MOD,      0, 0, 0,                        (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "ror",    2, { R32E,     IMM_1   }, GP0, (REX | REXB) | (F_OPCODE2_REG),									                          NO_VEX, NO_EVEX, 1, 2, { 0xd1, 0xc8, 0x00 }, 4, 0, NO_MOD,      0, 0, 0,                        (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "ror",    2, { R32,      R8      }, GP0, (F_OPCODE2_REG),									                                          NO_VEX, NO_EVEX, 1, 2, { 0xd3, 0xc8, 0x00 }, 4, 0, NO_MOD,      0, 0, 0,                        (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "ror",    2, { R32E,     R8      }, GP0, (REX | REXB) | (F_OPCODE2_REG),									                          NO_VEX, NO_EVEX, 1, 2, { 0xd3, 0xc8, 0x00 }, 4, 0, NO_MOD,      0, 0, 0,                        (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "ror",    2, { R32,      IMM8    }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),                           NO_VEX, NO_EVEX, 1, 1, { 0xc1, 0x00, 0x00 }, 4, 0, 0xc8,        0, 0, 0,                        (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "ror",    2, { R32E,     IMM8    }, GP0, (REX | REXB) | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),            NO_VEX, NO_EVEX, 1, 1, { 0xc1, 0x00, 0x00 }, 4, 0, 0xc8,        0, 0, 0,                        (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "ror",    2, { R64,      IMM_1   }, GP3, (REX | REXW) | (F_OPCODE2_REG),                                            NO_VEX, NO_EVEX, 1, 2, { 0xd1, 0xc8, 0x00 }, 8, 0, NO_MOD,      0, 0, 0,                                    (X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "ror",    2, { R64E,     IMM_1   }, GP3, (REX | REXW | REXB) | (F_OPCODE2_REG),                                     NO_VEX, NO_EVEX, 1, 2, { 0xd1, 0xc8, 0x00 }, 8, 0, NO_MOD,      0, 0, 0,                                    (X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "ror",    2, { R64,      R8      }, GP3, (REX | REXW) | (F_OPCODE2_REG),                                            NO_VEX, NO_EVEX, 1, 2, { 0xd3, 0xc8, 0x00 }, 8, 0, NO_MOD,      0, 0, 0,                                    (X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "ror",    2, { R64E,     R8      }, GP3, (REX | REXW | REXB) | (F_OPCODE2_REG),                                     NO_VEX, NO_EVEX, 1, 2, { 0xd3, 0xc8, 0x00 }, 8, 0, NO_MOD,      0, 0, 0,                                    (X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "ror",    2, { R64,      IMM8    }, GP3, (REX | REXW) | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),            NO_VEX, NO_EVEX, 1, 1, { 0xc1, 0x00, 0x00 }, 8, 0, 0xc8,        0, 0, 0,                        (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "ror",    2, { R64E,     IMM8    }, GP3, (REX | REXW | REXB) | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),     NO_VEX, NO_EVEX, 1, 1, { 0xc1, 0x00, 0x00 }, 8, 0, 0xc8,        0, 0, 0,                        (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "ror",    2, { M16,      IMM_1   }, GP0, ALLOW_SEG | (F_MODRM | OPCODE_EXT | IMM8_ONLY),                            NO_VEX, NO_EVEX, 1, 1, { 0xd1, 0x00, 0x00 }, 2, 0, MOD_MEM_IMM, 0,     OP_SIZE_OVERRIDE,	0,    (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0,P_86,  0, NULL },
{ "ror",    2, { M16,      R8_CL   }, GP0, ALLOW_SEG | (F_MODRM | OPCODE_EXT | IMM8_ONLY),									          NO_VEX, NO_EVEX, 1, 1, { 0xd3, 0x00, 0x00 }, 2, 0, MOD_MEM_IMM, 0,     OP_SIZE_OVERRIDE,  0,    (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0,P_86,  0, NULL },
{ "ror",    2, { M16,      IMM8    }, GP0, ALLOW_SEG | (F_MODRM | OPCODE_EXT | IMM8_ONLY),									          NO_VEX, NO_EVEX, 1, 1, { 0xc1, 0x00, 0x00 }, 2, 0, MOD_MEM_IMM, 0,     OP_SIZE_OVERRIDE, 	0,    (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0,P_86,  0, NULL },
{ "ror",    2, { M32,      IMM_1   }, GP0, ALLOW_SEG | (F_MODRM | OPCODE_EXT | IMM8_ONLY),                            NO_VEX, NO_EVEX, 1, 1, { 0xd1, 0x00, 0x00 }, 4, 0, MOD_MEM_IMM, 0,     0,	 ADDR_SIZE_OVERRIDE,  (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0,P_86,  0, NULL },
{ "ror",    2, { M32,      R8_CL   }, GP0, ALLOW_SEG | (F_MODRM | OPCODE_EXT | IMM8_ONLY),									          NO_VEX, NO_EVEX, 1, 1, { 0xd3, 0x00, 0x00 }, 4, 0, MOD_MEM_IMM, 0,     0,  ADDR_SIZE_OVERRIDE,  (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0,P_86,  0, NULL },
{ "ror",    2, { M32,      IMM8    }, GP0, ALLOW_SEG | (F_MODRM | OPCODE_EXT | IMM8_ONLY),									          NO_VEX, NO_EVEX, 1, 1, { 0xc1, 0x00, 0x00 }, 4, 0, MOD_MEM_IMM, 0,     0,  ADDR_SIZE_OVERRIDE,  (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0,P_86,  0, NULL },
{ "ror",    2, { M64,      IMM_1   }, GP0, ALLOW_SEG | (REX | REXW) | (F_MODRM | OPCODE_EXT | IMM8_ONLY),             NO_VEX, NO_EVEX, 1, 1, { 0xd1, 0x00, 0x00 }, 8, 0, MOD_MEM_IMM, 0,     0,	 0,                   (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0,P_86,  0, NULL },
{ "ror",    2, { M64,      R8_CL   }, GP0, ALLOW_SEG | (REX | REXW) | (F_MODRM | OPCODE_EXT | IMM8_ONLY),						  NO_VEX, NO_EVEX, 1, 1, { 0xd3, 0x00, 0x00 }, 8, 0, MOD_MEM_IMM, 0,     0,  0,                   (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0,P_86,  0, NULL },
{ "ror",    2, { M64,      IMM8    }, GP0, ALLOW_SEG | (REX | REXW) | (F_MODRM | OPCODE_EXT | IMM8_ONLY),						  NO_VEX, NO_EVEX, 1, 1, { 0xc1, 0x00, 0x00 }, 8, 0, MOD_MEM_IMM, 0,     0,  0,                   (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0,P_86,  0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//SAL r/m8, 1          D0 / 4                 M1 Valid Valid Multiply r / m8 by 2, once.
//SAL r/m8**, 1        REX + D0 / 4           M1 Valid N.E.Multiply r / m8 by 2, once.
//SAL r/m8, CL         D2 / 4                 MC Valid Valid Multiply r / m8 by 2, CL times.
//SAL r/m8**, CL       REX + D2 / 4           MC Valid N.E.Multiply r / m8 by 2, CL times.
//SAL r/m8, imm8       C0 / 4 ib              MI Valid Valid Multiply r / m8 by 2, imm8 times.
//SAL r/m8**, imm8     REX + C0 / 4 ib        MI Valid N.E.Multiply r / m8 by 2, imm8 times.
//SAL r/m16, 1         D1 / 4                 M1 Valid Valid Multiply r / m16 by 2, once.
//SAL r/m16, CL        D3 / 4                 MC Valid Valid Multiply r / m16 by 2, CL times.
//SAL r/m16, imm8      C1 / 4 ib              MI Valid Valid Multiply r / m16 by 2, imm8 times.
//SAL r/m32, 1         D1 / 4                 M1 Valid Valid Multiply r / m32 by 2, once.
//SAL r/m64, 1         REX.W + D1 / 4         M1 Valid N.E.Multiply r / m64 by 2, once.
//SAL r/m32, CL        D3 / 4                 MC Valid Valid Multiply r / m32 by 2, CL times.
//SAL r/m64, CL        REX.W + D3 / 4         MC Valid N.E.Multiply r / m64 by 2, CL times.
//SAL r/m32, imm8      C1 / 4 ib              MI Valid Valid Multiply r / m32 by 2, imm8 times.
//SAL r/m64, imm8      REX.W + C1 / 4 ib      MI Valid N.E.Multiply r / m64 by 2, imm8 times.
/* ----------------------------------------------------------------------------------------------- */
{ "sal",    2, { R8,       IMM_1   }, GP0, (F_OPCODE2_REG),												                                    NO_VEX, NO_EVEX, 1, 2, { 0xd0, 0xe0, 0x00 }, 1, 0, NO_MOD,      0, 0, 0,                       (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "sal",    2, { R8H,      IMM_1   }, GP0, (F_OPCODE2_REG),												                                    NO_VEX, NO_EVEX, 1, 2, { 0xd0, 0xe0, 0x00 }, 1, 0, NO_MOD,      0, 0, 0,                       (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "sal",    2, { R8U,      IMM_1   }, GP3, REX | (F_OPCODE2_REG),												                              NO_VEX, NO_EVEX, 1, 2, { 0xd0, 0xe0, 0x00 }, 1, 0, NO_MOD,      0, 0, 0,                       (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "sal",    2, { R8E,      IMM_1   }, GP3, (REX | REXB) | (F_OPCODE2_REG),												                    NO_VEX, NO_EVEX, 1, 2, { 0xd0, 0xe0, 0x00 }, 1, 0, NO_MOD,      0, 0, 0,                       (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "sal",    2, { R8,       R8      }, GP0, (F_OPCODE2_REG),												                                    NO_VEX, NO_EVEX, 1, 2, { 0xd2, 0xe0, 0x00 }, 1, 0, NO_MOD,      0, 0, 0,                       (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "sal",    2, { R8H,      R8      }, GP0, (F_OPCODE2_REG),												                                    NO_VEX, NO_EVEX, 1, 2, { 0xd2, 0xe0, 0x00 }, 1, 0, NO_MOD,      0, 0, 0,                       (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "sal",    2, { R8U,      R8      }, GP3, REX | (F_OPCODE2_REG),												                              NO_VEX, NO_EVEX, 1, 2, { 0xd2, 0xe0, 0x00 }, 1, 0, NO_MOD,      0, 0, 0,                       (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "sal",    2, { R8E,      R8      }, GP3, (REX | REXB) | (F_OPCODE2_REG),												                    NO_VEX, NO_EVEX, 1, 2, { 0xd2, 0xe0, 0x00 }, 1, 0, NO_MOD,      0, 0, 0,                       (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "sal",    2, { R8,       IMM8    }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	                          NO_VEX, NO_EVEX, 1, 1, { 0xc0, 0x04, 0x00 }, 1, 0, MOD_REG_IMM, 0, 0, 0,                       (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "sal",    2, { R8H,      IMM8    }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	                          NO_VEX, NO_EVEX, 1, 1, { 0xc0, 0x04, 0x00 }, 1, 0, MOD_REG_IMM, 0, 0, 0,                       (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "sal",    2, { R8U,      IMM8    }, GP3, REX | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	                    NO_VEX, NO_EVEX, 1, 1, { 0xc0, 0x04, 0x00 }, 1, 0, MOD_REG_IMM, 0, 0, 0,                       (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "sal",    2, { R8E,      IMM8    }, GP3, (REX | REXB) | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	          NO_VEX, NO_EVEX, 1, 1, { 0xc0, 0x04, 0x00 }, 1, 0, MOD_REG_IMM, 0, 0, 0,                       (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "sal",    2, { M8,       IMM_1   }, GP0, ALLOW_SEG | (F_OPCODE2_REG),                                               NO_VEX, NO_EVEX, 1, 1, { 0xd0, 0x20, 0x00 }, 1, 0, 0x00, 0, 0,	           ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM, NO_MEM,P_86,  0, NULL },
{ "sal",    2, { M8,       R8_CL   }, GP0, ALLOW_SEG | (F_OPCODE2_REG),									                              NO_VEX, NO_EVEX, 1, 1, { 0xd2, 0x20, 0x00 }, 1, 0, 0x00, 0, 0,	           ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM, NO_MEM,P_86,  0, NULL },
{ "sal",    2, { M8,       IMM8    }, GP0, ALLOW_SEG | (F_MODRM | OPCODE_EXT | IMM8_ONLY),									          NO_VEX, NO_EVEX, 1, 1, { 0xc0, 0x04, 0x00 }, 1, 0, MOD_MEM_IMM, 0, 0,	     ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0,P_86,  0, NULL },
{ "sal",    2, { R16,      IMM_1   }, GP0, (F_OPCODE2_REG),									                                          NO_VEX, NO_EVEX, 1, 2, { 0xd1, 0xe0, 0x00 }, 2, 0, NO_MOD,      0,    OP_SIZE_OVERRIDE, 0,      (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "sal",    2, { R16E,     IMM_1   }, GP0, (REX | REXB) | (F_OPCODE2_REG),									                          NO_VEX, NO_EVEX, 1, 2, { 0xd1, 0xe0, 0x00 }, 2, 0, NO_MOD,      0,    OP_SIZE_OVERRIDE, 0,      (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "sal",    2, { R16,      R8      }, GP0, (F_OPCODE2_REG),									                                          NO_VEX, NO_EVEX, 1, 1, { 0xd3, 0xe0, 0x00 }, 2, 0, NO_MOD,      0,    OP_SIZE_OVERRIDE, 0,      (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "sal",    2, { R16E,     R8      }, GP0, (REX | REXB) | (F_OPCODE2_REG),									                          NO_VEX, NO_EVEX, 1, 1, { 0xd3, 0xe0, 0x00 }, 2, 0, NO_MOD,      0,    OP_SIZE_OVERRIDE, 0,      (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "sal",    2, { R16,      IMM8    }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	                          NO_VEX, NO_EVEX, 1, 1, { 0xc1, 0x00, 0x00 }, 2, 0, 0xe0,        0,    OP_SIZE_OVERRIDE, 0,      (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "sal",    2, { R16E,     IMM8    }, GP0, (REX | REXB) | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	          NO_VEX, NO_EVEX, 1, 1, { 0xc1, 0x00, 0x00 }, 2, 0, 0xe0,        0,    OP_SIZE_OVERRIDE, 0,      (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "sal",    2, { R32,      IMM_1   }, GP0, (F_OPCODE2_REG),									                                          NO_VEX, NO_EVEX, 1, 2, { 0xd1, 0xe0, 0x00 }, 4, 0, NO_MOD,      0, 0, 0,                        (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "sal",    2, { R32E,     IMM_1   }, GP0, (REX | REXB) | (F_OPCODE2_REG),									                          NO_VEX, NO_EVEX, 1, 2, { 0xd1, 0xe0, 0x00 }, 4, 0, NO_MOD,      0, 0, 0,                        (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "sal",    2, { R32,      R8      }, GP0, (F_OPCODE2_REG),									                                          NO_VEX, NO_EVEX, 1, 2, { 0xd3, 0xe0, 0x00 }, 4, 0, NO_MOD,      0, 0, 0,                        (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "sal",    2, { R32E,     R8      }, GP0, (REX | REXB) | (F_OPCODE2_REG),									                          NO_VEX, NO_EVEX, 1, 2, { 0xd3, 0xe0, 0x00 }, 4, 0, NO_MOD,      0, 0, 0,                        (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "sal",    2, { R32,      IMM8    }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),                           NO_VEX, NO_EVEX, 1, 1, { 0xc1, 0x00, 0x00 }, 4, 0, 0xe0,        0, 0, 0,                        (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "sal",    2, { R32E,     IMM8    }, GP0, (REX | REXB) | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),            NO_VEX, NO_EVEX, 1, 1, { 0xc1, 0x00, 0x00 }, 4, 0, 0xe0,        0, 0, 0,                        (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "sal",    2, { R64,      IMM_1   }, GP3, (REX | REXW) | (F_OPCODE2_REG),                                            NO_VEX, NO_EVEX, 1, 2, { 0xd1, 0xe0, 0x00 }, 8, 0, NO_MOD,      0, 0, 0,                                    (X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "sal",    2, { R64E,     IMM_1   }, GP3, (REX | REXW | REXB) | (F_OPCODE2_REG),                                     NO_VEX, NO_EVEX, 1, 2, { 0xd1, 0xe0, 0x00 }, 8, 0, NO_MOD,      0, 0, 0,                                    (X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "sal",    2, { R64,      R8      }, GP3, (REX | REXW) | (F_OPCODE2_REG),                                            NO_VEX, NO_EVEX, 1, 2, { 0xd3, 0xe0, 0x00 }, 8, 0, NO_MOD,      0, 0, 0,                                    (X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "sal",    2, { R64E,     R8      }, GP3, (REX | REXW | REXB) | (F_OPCODE2_REG),                                     NO_VEX, NO_EVEX, 1, 2, { 0xd3, 0xe0, 0x00 }, 8, 0, NO_MOD,      0, 0, 0,                                    (X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "sal",    2, { R64,      IMM8    }, GP3, (REX | REXW) | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),            NO_VEX, NO_EVEX, 1, 1, { 0xc1, 0x00, 0x00 }, 8, 0, 0xe0,        0, 0, 0,                        (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "sal",    2, { R64E,     IMM8    }, GP3, (REX | REXW | REXB) | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),     NO_VEX, NO_EVEX, 1, 1, { 0xc1, 0x00, 0x00 }, 8, 0, 0xe0,        0, 0, 0,                        (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "sal",    2, { M16,      IMM_1   }, GP0, ALLOW_SEG | (F_MODRM | OPCODE_EXT | IMM8_ONLY),                            NO_VEX, NO_EVEX, 1, 1, { 0xd1, 0x04, 0x00 }, 2, 0, MOD_MEM_IMM, 0,     OP_SIZE_OVERRIDE,	0,    (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0,P_86,  0, NULL },
{ "sal",    2, { M16,      R8_CL   }, GP0, ALLOW_SEG | (F_MODRM | OPCODE_EXT | IMM8_ONLY),									          NO_VEX, NO_EVEX, 1, 1, { 0xd3, 0x04, 0x00 }, 2, 0, MOD_MEM_IMM, 0,     OP_SIZE_OVERRIDE,  0,    (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0,P_86,  0, NULL },
{ "sal",    2, { M16,      IMM8    }, GP0, ALLOW_SEG | (F_MODRM | OPCODE_EXT | IMM8_ONLY),									          NO_VEX, NO_EVEX, 1, 1, { 0xc1, 0x04, 0x00 }, 2, 0, MOD_MEM_IMM, 0,     OP_SIZE_OVERRIDE, 	0,    (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0,P_86,  0, NULL },
{ "sal",    2, { M32,      IMM_1   }, GP0, ALLOW_SEG | (F_MODRM | OPCODE_EXT | IMM8_ONLY),                            NO_VEX, NO_EVEX, 1, 1, { 0xd1, 0x04, 0x00 }, 4, 0, MOD_MEM_IMM, 0,     0,	 ADDR_SIZE_OVERRIDE,  (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0,P_86,  0, NULL },
{ "sal",    2, { M32,      R8_CL   }, GP0, ALLOW_SEG | (F_MODRM | OPCODE_EXT | IMM8_ONLY),									          NO_VEX, NO_EVEX, 1, 1, { 0xd3, 0x04, 0x00 }, 4, 0, MOD_MEM_IMM, 0,     0,  ADDR_SIZE_OVERRIDE,  (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0,P_86,  0, NULL },
{ "sal",    2, { M32,      IMM8    }, GP0, ALLOW_SEG | (F_MODRM | OPCODE_EXT | IMM8_ONLY),									          NO_VEX, NO_EVEX, 1, 1, { 0xc1, 0x04, 0x00 }, 4, 0, MOD_MEM_IMM, 0,     0,  ADDR_SIZE_OVERRIDE,  (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0,P_86,  0, NULL },
{ "sal",    2, { M64,      IMM_1   }, GP0, ALLOW_SEG | (REX | REXW) | (F_MODRM | OPCODE_EXT | IMM8_ONLY),             NO_VEX, NO_EVEX, 1, 1, { 0xd1, 0x04, 0x00 }, 8, 0, MOD_MEM_IMM, 0,     0,	 0,                   (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0,P_86,  0, NULL },
{ "sal",    2, { M64,      R8_CL   }, GP0, ALLOW_SEG | (REX | REXW) | (F_MODRM | OPCODE_EXT | IMM8_ONLY),						  NO_VEX, NO_EVEX, 1, 1, { 0xd3, 0x04, 0x00 }, 8, 0, MOD_MEM_IMM, 0,     0,  0,                   (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0,P_86,  0, NULL },
{ "sal",    2, { M64,      IMM8    }, GP0, ALLOW_SEG | (REX | REXW) | (F_MODRM | OPCODE_EXT | IMM8_ONLY),						  NO_VEX, NO_EVEX, 1, 1, { 0xc1, 0x04, 0x00 }, 8, 0, MOD_MEM_IMM, 0,     0,  0,                   (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0,P_86,  0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//SAR r/m8, 1          D0 / 7                 M1 Valid Valid Signed divide * r / m8 by 2, once.
//SAR r/m8**, 1        REX + D0 / 7           M1 Valid N.E.Signed divide * r / m8 by 2, once.
//SAR r/m8, CL         D2 / 7                 MC Valid Valid Signed divide * r / m8 by 2, CL times.
//SAR r/m8**, CL       REX + D2 / 7           MC Valid N.E.Signed divide * r / m8 by 2, CL times.
//SAR r/m8, imm8       C0 / 7 ib              MI Valid Valid Signed divide * r / m8 by 2, imm8 time.
//SAR r/m8**, imm8     REX + C0 / 7 ib        MI Valid N.E.Signed divide * r / m8 by 2, imm8 times.
//SAR r/m16, 1         D1 / 7                 M1 Valid Valid Signed divide * r / m16 by 2, once.
//SAR r/m16, CL        D3 / 7                 MC Valid Valid Signed divide * r / m16 by 2, CL times.
//SAR r/m16, imm8      C1 / 7 ib              MI Valid Valid Signed divide * r / m16 by 2, imm8 times.
//SAR r/m32, 1         D1 / 7                 M1 Valid Valid Signed divide * r / m32 by 2, once.
//SAR r/m64, 1         REX.W + D1 / 7         M1 Valid N.E.Signed divide * r / m64 by 2, once.
//SAR r/m32, CL        D3 / 7                 MC Valid Valid Signed divide * r / m32 by 2, CL times.
//SAR r/m64, CL        REX.W + D3 / 7         MC Valid N.E.Signed divide * r / m64 by 2, CL times.
//SAR r/m32, imm8      C1 / 7 ib              MI Valid Valid Signed divide * r / m32 by 2, imm8 times.
//SAR r/m64, imm8      REX.W + C1 / 7 ib      MI Valid N.E.Signed divide * r / m64 by 2, imm8 times
/* ----------------------------------------------------------------------------------------------- */
{ "sar",    2, { R8,       IMM_1   }, GP0, (F_OPCODE2_REG),												                                    NO_VEX, NO_EVEX, 1, 2, { 0xd0, 0xf8, 0x00 }, 1, 0, NO_MOD,      0, 0, 0,                       (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "sar",    2, { R8H,      IMM_1   }, GP0, (F_OPCODE2_REG),												                                    NO_VEX, NO_EVEX, 1, 2, { 0xd0, 0xf8, 0x00 }, 1, 0, NO_MOD,      0, 0, 0,                       (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "sar",    2, { R8U,      IMM_1   }, GP3, REX | (F_OPCODE2_REG),												                              NO_VEX, NO_EVEX, 1, 2, { 0xd0, 0xf8, 0x00 }, 1, 0, NO_MOD,      0, 0, 0,                       (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "sar",    2, { R8E,      IMM_1   }, GP3, (REX | REXB) | (F_OPCODE2_REG),												                    NO_VEX, NO_EVEX, 1, 2, { 0xd0, 0xf8, 0x00 }, 1, 0, NO_MOD,      0, 0, 0,                       (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "sar",    2, { R8,       R8      }, GP0, (F_OPCODE2_REG),												                                    NO_VEX, NO_EVEX, 1, 2, { 0xd2, 0xf8, 0x00 }, 1, 0, NO_MOD,      0, 0, 0,                       (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "sar",    2, { R8H,      R8      }, GP0, (F_OPCODE2_REG),												                                    NO_VEX, NO_EVEX, 1, 2, { 0xd2, 0xf8, 0x00 }, 1, 0, NO_MOD,      0, 0, 0,                       (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "sar",    2, { R8U,      R8      }, GP3, REX | (F_OPCODE2_REG),												                              NO_VEX, NO_EVEX, 1, 2, { 0xd2, 0xf8, 0x00 }, 1, 0, NO_MOD,      0, 0, 0,                       (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "sar",    2, { R8E,      R8      }, GP3, (REX | REXB) | (F_OPCODE2_REG),												                    NO_VEX, NO_EVEX, 1, 2, { 0xd2, 0xf8, 0x00 }, 1, 0, NO_MOD,      0, 0, 0,                       (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "sar",    2, { R8,       IMM8    }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	                          NO_VEX, NO_EVEX, 1, 1, { 0xc0, 0x07, 0x00 }, 1, 0, MOD_REG_IMM, 0, 0, 0,                       (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "sar",    2, { R8H,      IMM8    }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	                          NO_VEX, NO_EVEX, 1, 1, { 0xc0, 0x07, 0x00 }, 1, 0, MOD_REG_IMM, 0, 0, 0,                       (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "sar",    2, { R8U,      IMM8    }, GP3, REX | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	                    NO_VEX, NO_EVEX, 1, 1, { 0xc0, 0x07, 0x00 }, 1, 0, MOD_REG_IMM, 0, 0, 0,                       (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "sar",    2, { R8E,      IMM8    }, GP3, (REX | REXB) | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	          NO_VEX, NO_EVEX, 1, 1, { 0xc0, 0x07, 0x00 }, 1, 0, MOD_REG_IMM, 0, 0, 0,                       (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "sar",    2, { M8,       IMM_1   }, GP0, ALLOW_SEG | (F_OPCODE2_REG),                                               NO_VEX, NO_EVEX, 1, 1, { 0xd0, 0x38, 0x00 }, 1, 0, 0x00, 0, 0,	           ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM, NO_MEM,P_86,  0, NULL },
{ "sar",    2, { M8,       R8_CL   }, GP0, ALLOW_SEG | (F_OPCODE2_REG),									                              NO_VEX, NO_EVEX, 1, 1, { 0xd2, 0x38, 0x00 }, 1, 0, 0x00, 0, 0,	           ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM, NO_MEM,P_86,  0, NULL },
{ "sar",    2, { M8,       IMM8    }, GP0, ALLOW_SEG | (F_MODRM | OPCODE_EXT | IMM8_ONLY),									          NO_VEX, NO_EVEX, 1, 1, { 0xc0, 0x07, 0x00 }, 1, 0, MOD_MEM_IMM, 0, 0,	     ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0,P_86,  0, NULL },
{ "sar",    2, { R16,      IMM_1   }, GP0, (F_OPCODE2_REG),									                                          NO_VEX, NO_EVEX, 1, 2, { 0xd1, 0xf8, 0x00 }, 2, 0, NO_MOD,      0,    OP_SIZE_OVERRIDE, 0,      (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "sar",    2, { R16E,     IMM_1   }, GP0, (REX | REXB) | (F_OPCODE2_REG),									                          NO_VEX, NO_EVEX, 1, 2, { 0xd1, 0xf8, 0x00 }, 2, 0, NO_MOD,      0,    OP_SIZE_OVERRIDE, 0,      (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "sar",    2, { R16,      R8      }, GP0, (F_OPCODE2_REG),									                                          NO_VEX, NO_EVEX, 1, 1, { 0xd3, 0xf8, 0x00 }, 2, 0, NO_MOD,      0,    OP_SIZE_OVERRIDE, 0,      (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "sar",    2, { R16E,     R8      }, GP0, (REX | REXB) | (F_OPCODE2_REG),									                          NO_VEX, NO_EVEX, 1, 1, { 0xd3, 0xf8, 0x00 }, 2, 0, NO_MOD,      0,    OP_SIZE_OVERRIDE, 0,      (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "sar",    2, { R16,      IMM8    }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	                          NO_VEX, NO_EVEX, 1, 1, { 0xc1, 0x00, 0x00 }, 2, 0, 0xf8,        0,    OP_SIZE_OVERRIDE, 0,      (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "sar",    2, { R16E,     IMM8    }, GP0, (REX | REXB) | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	          NO_VEX, NO_EVEX, 1, 1, { 0xc1, 0x00, 0x00 }, 2, 0, 0xf8,        0,    OP_SIZE_OVERRIDE, 0,      (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "sar",    2, { R32,      IMM_1   }, GP0, (F_OPCODE2_REG),									                                          NO_VEX, NO_EVEX, 1, 2, { 0xd1, 0xf8, 0x00 }, 4, 0, NO_MOD,      0, 0, 0,                        (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "sar",    2, { R32E,     IMM_1   }, GP0, (REX | REXB) | (F_OPCODE2_REG),									                          NO_VEX, NO_EVEX, 1, 2, { 0xd1, 0xf8, 0x00 }, 4, 0, NO_MOD,      0, 0, 0,                        (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "sar",    2, { R32,      R8      }, GP0, (F_OPCODE2_REG),									                                          NO_VEX, NO_EVEX, 1, 2, { 0xd3, 0xf8, 0x00 }, 4, 0, NO_MOD,      0, 0, 0,                        (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "sar",    2, { R32E,     R8      }, GP0, (REX | REXB) | (F_OPCODE2_REG),									                          NO_VEX, NO_EVEX, 1, 2, { 0xd3, 0xf8, 0x00 }, 4, 0, NO_MOD,      0, 0, 0,                        (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "sar",    2, { R32,      IMM8    }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),                           NO_VEX, NO_EVEX, 1, 1, { 0xc1, 0x00, 0x00 }, 4, 0, 0xf8,        0, 0, 0,                        (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "sar",    2, { R32E,     IMM8    }, GP0, (REX | REXB) | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),            NO_VEX, NO_EVEX, 1, 1, { 0xc1, 0x00, 0x00 }, 4, 0, 0xf8,        0, 0, 0,                        (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "sar",    2, { R64,      IMM_1   }, GP3, (REX | REXW) | (F_OPCODE2_REG),                                            NO_VEX, NO_EVEX, 1, 2, { 0xd1, 0xf8, 0x00 }, 8, 0, NO_MOD,      0, 0, 0,                                    (X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "sar",    2, { R64E,     IMM_1   }, GP3, (REX | REXW | REXB) | (F_OPCODE2_REG),                                     NO_VEX, NO_EVEX, 1, 2, { 0xd1, 0xf8, 0x00 }, 8, 0, NO_MOD,      0, 0, 0,                                    (X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "sar",    2, { R64,      R8      }, GP3, (REX | REXW) | (F_OPCODE2_REG),                                            NO_VEX, NO_EVEX, 1, 2, { 0xd3, 0xf8, 0x00 }, 8, 0, NO_MOD,      0, 0, 0,                                    (X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "sar",    2, { R64E,     R8      }, GP3, (REX | REXW | REXB) | (F_OPCODE2_REG),                                     NO_VEX, NO_EVEX, 1, 2, { 0xd3, 0xf8, 0x00 }, 8, 0, NO_MOD,      0, 0, 0,                                    (X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "sar",    2, { R64,      IMM8    }, GP3, (REX | REXW) | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),            NO_VEX, NO_EVEX, 1, 1, { 0xc1, 0x00, 0x00 }, 8, 0, 0xf8,        0, 0, 0,                        (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "sar",    2, { R64E,     IMM8    }, GP3, (REX | REXW | REXB) | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),     NO_VEX, NO_EVEX, 1, 1, { 0xc1, 0x00, 0x00 }, 8, 0, 0xf8,        0, 0, 0,                        (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "sar",    2, { M16,      IMM_1   }, GP0, ALLOW_SEG | (F_MODRM | OPCODE_EXT | IMM8_ONLY),                            NO_VEX, NO_EVEX, 1, 1, { 0xd1, 0x07, 0x00 }, 2, 0, MOD_MEM_IMM, 0,     OP_SIZE_OVERRIDE,	0,    (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0,P_86,  0, NULL },
{ "sar",    2, { M16,      R8_CL   }, GP0, ALLOW_SEG | (F_MODRM | OPCODE_EXT | IMM8_ONLY),									          NO_VEX, NO_EVEX, 1, 1, { 0xd3, 0x07, 0x00 }, 2, 0, MOD_MEM_IMM, 0,     OP_SIZE_OVERRIDE,  0,    (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0,P_86,  0, NULL },
{ "sar",    2, { M16,      IMM8    }, GP0, ALLOW_SEG | (F_MODRM | OPCODE_EXT | IMM8_ONLY),									          NO_VEX, NO_EVEX, 1, 1, { 0xc1, 0x07, 0x00 }, 2, 0, MOD_MEM_IMM, 0,     OP_SIZE_OVERRIDE, 	0,    (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0,P_86,  0, NULL },
{ "sar",    2, { M32,      IMM_1   }, GP0, ALLOW_SEG | (F_MODRM | OPCODE_EXT | IMM8_ONLY),                            NO_VEX, NO_EVEX, 1, 1, { 0xd1, 0x07, 0x00 }, 4, 0, MOD_MEM_IMM, 0,     0,	 ADDR_SIZE_OVERRIDE,  (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0,P_86,  0, NULL },
{ "sar",    2, { M32,      R8_CL   }, GP0, ALLOW_SEG | (F_MODRM | OPCODE_EXT | IMM8_ONLY),									          NO_VEX, NO_EVEX, 1, 1, { 0xd3, 0x07, 0x00 }, 4, 0, MOD_MEM_IMM, 0,     0,  ADDR_SIZE_OVERRIDE,  (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0,P_86,  0, NULL },
{ "sar",    2, { M32,      IMM8    }, GP0, ALLOW_SEG | (F_MODRM | OPCODE_EXT | IMM8_ONLY),									          NO_VEX, NO_EVEX, 1, 1, { 0xc1, 0x07, 0x00 }, 4, 0, MOD_MEM_IMM, 0,     0,  ADDR_SIZE_OVERRIDE,  (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0,P_86,  0, NULL },
{ "sar",    2, { M64,      IMM_1   }, GP0, ALLOW_SEG | (REX | REXW) | (F_MODRM | OPCODE_EXT | IMM8_ONLY),             NO_VEX, NO_EVEX, 1, 1, { 0xd1, 0x07, 0x00 }, 8, 0, MOD_MEM_IMM, 0,     0,	 0,                   (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0,P_86,  0, NULL },
{ "sar",    2, { M64,      R8_CL   }, GP0, ALLOW_SEG | (REX | REXW) | (F_MODRM | OPCODE_EXT | IMM8_ONLY),						  NO_VEX, NO_EVEX, 1, 1, { 0xd3, 0x07, 0x00 }, 8, 0, MOD_MEM_IMM, 0,     0,  0,                   (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0,P_86,  0, NULL },
{ "sar",    2, { M64,      IMM8    }, GP0, ALLOW_SEG | (REX | REXW) | (F_MODRM | OPCODE_EXT | IMM8_ONLY),						  NO_VEX, NO_EVEX, 1, 1, { 0xc1, 0x07, 0x00 }, 8, 0, MOD_MEM_IMM, 0,     0,  0,                   (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0,P_86,  0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//SHL r/m8, 1          D0 / 4                 M1 Valid Valid Multiply r / m8 by 2, once.
//SHL r/m8**, 1        REX + D0 / 4           M1 Valid N.E.Multiply r / m8 by 2, once.
//SHL r/m8, CL         D2 / 4                 MC Valid Valid Multiply r / m8 by 2, CL times.
//SHL r/m8**, CL       REX + D2 / 4           MC Valid N.E.Multiply r / m8 by 2, CL times.
//SHL r/m8, imm8       C0 / 4 ib              MI Valid Valid Multiply r / m8 by 2, imm8 times.
//SHL r/m8**, imm8     REX + C0 / 4 ib        MI Valid N.E.Multiply r / m8 by 2, imm8 times.
//SHL r/m16, 1         D1 / 4                 M1 Valid Valid Multiply r / m16 by 2, once.
//SHL r/m16, CL        D3 / 4                 MC Valid Valid Multiply r / m16 by 2, CL times.
//SHL r/m16, imm8      C1 / 4 ib              MI Valid Valid Multiply r / m16 by 2, imm8 times.
//SHL r/m32, 1         D1 / 4                 M1 Valid Valid Multiply r / m32 by 2, once.
//SHL r/m64,1          REX.W + D1 /4          M1 Valid N.E.Multiply r / m64 by 2, once.
//SHL r/m32, CL        D3 /4                  MC Valid Valid Multiply r / m32 by 2, CL times.
//SHL r/m64, CL        REX.W + D3 /4          MC Valid N.E.Multiply r / m64 by 2, CL times.
//SHL r/m32, imm8      C1 /4 ib               MI Valid Valid Multiply r / m32 by 2, imm8 times.
//SHL r/m64, imm8      REX.W + C1 /4 ib       MI Valid N.E.Multiply r / m64 by 2, imm8 times.
/* ----------------------------------------------------------------------------------------------- */
{ "shl",    2, { R8,       IMM_1   }, GP0, (F_OPCODE2_REG),												                                    NO_VEX, NO_EVEX, 1, 2, { 0xd0, 0xe0, 0x00 }, 1, 0, NO_MOD,      0, 0, 0,                       (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "shl",    2, { R8H,      IMM_1   }, GP0, (F_OPCODE2_REG),												                                    NO_VEX, NO_EVEX, 1, 2, { 0xd0, 0xe0, 0x00 }, 1, 0, NO_MOD,      0, 0, 0,                       (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "shl",    2, { R8U,      IMM_1   }, GP3, REX | (F_OPCODE2_REG),												                              NO_VEX, NO_EVEX, 1, 2, { 0xd0, 0xe0, 0x00 }, 1, 0, NO_MOD,      0, 0, 0,                       (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "shl",    2, { R8E,      IMM_1   }, GP3, (REX | REXB) | (F_OPCODE2_REG),												                    NO_VEX, NO_EVEX, 1, 2, { 0xd0, 0xe0, 0x00 }, 1, 0, NO_MOD,      0, 0, 0,                       (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "shl",    2, { R8,       R8      }, GP0, (F_OPCODE2_REG),												                                    NO_VEX, NO_EVEX, 1, 2, { 0xd2, 0xe0, 0x00 }, 1, 0, NO_MOD,      0, 0, 0,                       (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "shl",    2, { R8H,      R8      }, GP0, (F_OPCODE2_REG),												                                    NO_VEX, NO_EVEX, 1, 2, { 0xd2, 0xe0, 0x00 }, 1, 0, NO_MOD,      0, 0, 0,                       (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "shl",    2, { R8U,      R8      }, GP3, REX | (F_OPCODE2_REG),												                              NO_VEX, NO_EVEX, 1, 2, { 0xd2, 0xe0, 0x00 }, 1, 0, NO_MOD,      0, 0, 0,                       (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "shl",    2, { R8E,      R8      }, GP3, (REX | REXB) | (F_OPCODE2_REG),												                    NO_VEX, NO_EVEX, 1, 2, { 0xd2, 0xe0, 0x00 }, 1, 0, NO_MOD,      0, 0, 0,                       (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "shl",    2, { R8,       IMM8    }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	                          NO_VEX, NO_EVEX, 1, 1, { 0xc0, 0x04, 0x00 }, 1, 0, MOD_REG_IMM, 0, 0, 0,                       (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "shl",    2, { R8H,      IMM8    }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	                          NO_VEX, NO_EVEX, 1, 1, { 0xc0, 0x04, 0x00 }, 1, 0, MOD_REG_IMM, 0, 0, 0,                       (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "shl",    2, { R8U,      IMM8    }, GP3, REX | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	                    NO_VEX, NO_EVEX, 1, 1, { 0xc0, 0x04, 0x00 }, 1, 0, MOD_REG_IMM, 0, 0, 0,                       (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "shl",    2, { R8E,      IMM8    }, GP3, (REX | REXB) | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	          NO_VEX, NO_EVEX, 1, 1, { 0xc0, 0x04, 0x00 }, 1, 0, MOD_REG_IMM, 0, 0, 0,                       (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "shl",    2, { M8,       IMM_1   }, GP0, ALLOW_SEG | (F_OPCODE2_REG),                                               NO_VEX, NO_EVEX, 1, 1, { 0xd0, 0x20, 0x00 }, 1, 0, 0x00, 0, 0,	           ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM, NO_MEM,P_86,  0, NULL },
{ "shl",    2, { M8,       R8_CL   }, GP0, ALLOW_SEG | (F_OPCODE2_REG),									                              NO_VEX, NO_EVEX, 1, 1, { 0xd2, 0x20, 0x00 }, 1, 0, 0x00, 0, 0,	           ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM, NO_MEM,P_86,  0, NULL },
{ "shl",    2, { M8,       IMM8    }, GP0, ALLOW_SEG | (F_MODRM | OPCODE_EXT | IMM8_ONLY),									          NO_VEX, NO_EVEX, 1, 1, { 0xc0, 0x04, 0x00 }, 1, 0, MOD_MEM_IMM, 0, 0,	     ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0,P_86,  0, NULL },
{ "shl",    2, { R16,      IMM_1   }, GP0, (F_OPCODE2_REG),									                                          NO_VEX, NO_EVEX, 1, 2, { 0xd1, 0xe0, 0x00 }, 2, 0, NO_MOD,      0,    OP_SIZE_OVERRIDE, 0,      (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "shl",    2, { R16E,     IMM_1   }, GP0, (REX | REXB) | (F_OPCODE2_REG),									                          NO_VEX, NO_EVEX, 1, 2, { 0xd1, 0xe0, 0x00 }, 2, 0, NO_MOD,      0,    OP_SIZE_OVERRIDE, 0,      (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "shl",    2, { R16,      R8      }, GP0, (F_OPCODE2_REG),									                                          NO_VEX, NO_EVEX, 1, 1, { 0xd3, 0xe0, 0x00 }, 2, 0, NO_MOD,      0,    OP_SIZE_OVERRIDE, 0,      (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "shl",    2, { R16E,     R8      }, GP0, (REX | REXB) | (F_OPCODE2_REG),									                          NO_VEX, NO_EVEX, 1, 1, { 0xd3, 0xe0, 0x00 }, 2, 0, NO_MOD,      0,    OP_SIZE_OVERRIDE, 0,      (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "shl",    2, { R16,      IMM8    }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	                          NO_VEX, NO_EVEX, 1, 1, { 0xc1, 0x00, 0x00 }, 2, 0, 0xe0,        0,    OP_SIZE_OVERRIDE, 0,      (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "shl",    2, { R16E,     IMM8    }, GP0, (REX | REXB) | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	          NO_VEX, NO_EVEX, 1, 1, { 0xc1, 0x00, 0x00 }, 2, 0, 0xe0,        0,    OP_SIZE_OVERRIDE, 0,      (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "shl",    2, { R32,      IMM_1   }, GP0, (F_OPCODE2_REG),									                                          NO_VEX, NO_EVEX, 1, 2, { 0xd1, 0xe0, 0x00 }, 4, 0, NO_MOD,      0, 0, 0,                        (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "shl",    2, { R32E,     IMM_1   }, GP0, (REX | REXB) | (F_OPCODE2_REG),									                          NO_VEX, NO_EVEX, 1, 2, { 0xd1, 0xe0, 0x00 }, 4, 0, NO_MOD,      0, 0, 0,                        (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "shl",    2, { R32,      R8      }, GP0, (F_OPCODE2_REG),									                                          NO_VEX, NO_EVEX, 1, 2, { 0xd3, 0xe0, 0x00 }, 4, 0, NO_MOD,      0, 0, 0,                        (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "shl",    2, { R32E,     R8      }, GP0, (REX | REXB) | (F_OPCODE2_REG),									                          NO_VEX, NO_EVEX, 1, 2, { 0xd3, 0xe0, 0x00 }, 4, 0, NO_MOD,      0, 0, 0,                        (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "shl",    2, { R32,      IMM8    }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),                           NO_VEX, NO_EVEX, 1, 1, { 0xc1, 0x00, 0x00 }, 4, 0, 0xe0,        0, 0, 0,                        (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "shl",    2, { R32E,     IMM8    }, GP0, (REX | REXB) | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),            NO_VEX, NO_EVEX, 1, 1, { 0xc1, 0x00, 0x00 }, 4, 0, 0xe0,        0, 0, 0,                        (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "shl",    2, { R64,      IMM_1   }, GP3, (REX | REXW) | (F_OPCODE2_REG),                                            NO_VEX, NO_EVEX, 1, 2, { 0xd1, 0xe0, 0x00 }, 8, 0, NO_MOD,      0, 0, 0,                                    (X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "shl",    2, { R64E,     IMM_1   }, GP3, (REX | REXW | REXB) | (F_OPCODE2_REG),                                     NO_VEX, NO_EVEX, 1, 2, { 0xd1, 0xe0, 0x00 }, 8, 0, NO_MOD,      0, 0, 0,                                    (X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "shl",    2, { R64,      R8      }, GP3, (REX | REXW) | (F_OPCODE2_REG),                                            NO_VEX, NO_EVEX, 1, 2, { 0xd3, 0xe0, 0x00 }, 8, 0, NO_MOD,      0, 0, 0,                                    (X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "shl",    2, { R64E,     R8      }, GP3, (REX | REXW | REXB) | (F_OPCODE2_REG),                                     NO_VEX, NO_EVEX, 1, 2, { 0xd3, 0xe0, 0x00 }, 8, 0, NO_MOD,      0, 0, 0,                                    (X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "shl",    2, { R64,      IMM8    }, GP3, (REX | REXW) | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),            NO_VEX, NO_EVEX, 1, 1, { 0xc1, 0x00, 0x00 }, 8, 0, 0xe0,        0, 0, 0,                        (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "shl",    2, { R64E,     IMM8    }, GP3, (REX | REXW | REXB) | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),     NO_VEX, NO_EVEX, 1, 1, { 0xc1, 0x00, 0x00 }, 8, 0, 0xe0,        0, 0, 0,                        (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "shl",    2, { M16,      IMM_1   }, GP0, ALLOW_SEG | (F_MODRM | OPCODE_EXT | IMM8_ONLY),                            NO_VEX, NO_EVEX, 1, 1, { 0xd1, 0x04, 0x00 }, 2, 0, MOD_MEM_IMM, 0,     OP_SIZE_OVERRIDE,	0,    (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0,P_86,  0, NULL },
{ "shl",    2, { M16,      R8_CL   }, GP0, ALLOW_SEG | (F_MODRM | OPCODE_EXT | IMM8_ONLY),									          NO_VEX, NO_EVEX, 1, 1, { 0xd3, 0x04, 0x00 }, 2, 0, MOD_MEM_IMM, 0,     OP_SIZE_OVERRIDE,  0,    (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0,P_86,  0, NULL },
{ "shl",    2, { M16,      IMM8    }, GP0, ALLOW_SEG | (F_MODRM | OPCODE_EXT | IMM8_ONLY),									          NO_VEX, NO_EVEX, 1, 1, { 0xc1, 0x04, 0x00 }, 2, 0, MOD_MEM_IMM, 0,     OP_SIZE_OVERRIDE, 	0,    (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0,P_86,  0, NULL },
{ "shl",    2, { M32,      IMM_1   }, GP0, ALLOW_SEG | (F_MODRM | OPCODE_EXT | IMM8_ONLY),                            NO_VEX, NO_EVEX, 1, 1, { 0xd1, 0x04, 0x00 }, 4, 0, MOD_MEM_IMM, 0,     0,	 ADDR_SIZE_OVERRIDE,  (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0,P_86,  0, NULL },
{ "shl",    2, { M32,      R8_CL   }, GP0, ALLOW_SEG | (F_MODRM | OPCODE_EXT | IMM8_ONLY),									          NO_VEX, NO_EVEX, 1, 1, { 0xd3, 0x04, 0x00 }, 4, 0, MOD_MEM_IMM, 0,     0,  ADDR_SIZE_OVERRIDE,  (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0,P_86,  0, NULL },
{ "shl",    2, { M32,      IMM8    }, GP0, ALLOW_SEG | (F_MODRM | OPCODE_EXT | IMM8_ONLY),									          NO_VEX, NO_EVEX, 1, 1, { 0xc1, 0x04, 0x00 }, 4, 0, MOD_MEM_IMM, 0,     0,  ADDR_SIZE_OVERRIDE,  (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0,P_86,  0, NULL },
{ "shl",    2, { M64,      IMM_1   }, GP0, ALLOW_SEG | (REX | REXW) | (F_MODRM | OPCODE_EXT | IMM8_ONLY),             NO_VEX, NO_EVEX, 1, 1, { 0xd1, 0x04, 0x00 }, 8, 0, MOD_MEM_IMM, 0,     0,	 0,                   (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0,P_86,  0, NULL },
{ "shl",    2, { M64,      R8_CL   }, GP0, ALLOW_SEG | (REX | REXW) | (F_MODRM | OPCODE_EXT | IMM8_ONLY),						  NO_VEX, NO_EVEX, 1, 1, { 0xd3, 0x04, 0x00 }, 8, 0, MOD_MEM_IMM, 0,     0,  0,                   (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0,P_86,  0, NULL },
{ "shl",    2, { M64,      IMM8    }, GP0, ALLOW_SEG | (REX | REXW) | (F_MODRM | OPCODE_EXT | IMM8_ONLY),						  NO_VEX, NO_EVEX, 1, 1, { 0xc1, 0x04, 0x00 }, 8, 0, MOD_MEM_IMM, 0,     0,  0,                   (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0,P_86,  0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//SHR r/m8,1           D0 /5                  M1 Valid Valid Unsigned divide r / m8 by 2, once.
//SHR r/m8**, 1        REX + D0 /5            M1 Valid N.E.Unsigned divide r / m8 by 2, once.
//SHR r/m8, CL         D2 /5                  MC Valid Valid Unsigned divide r / m8 by 2, CL times.
//SHR r/m8**, CL       REX + D2 /5            MC Valid N.E.Unsigned divide r / m8 by 2, CL times.
//SHR r/m8, imm8       C0 /5 ib               MI Valid Valid Unsigned divide r / m8 by 2, imm8 times.
//SHR r/m8**, imm8     REX + C0 /5 ib         MI Valid N.E.Unsigned divide r / m8 by 2, imm8 times.
//SHR r/m16, 1         D1 /5                  M1 Valid Valid Unsigned divide r / m16 by 2, once.
//SHR r/m16, CL        D3 /5                  MC Valid Valid Unsigned divide r / m16 by 2, CL times
//SHR r/m16, imm8      C1 /5 ib               MI Valid Valid Unsigned divide r / m16 by 2, imm8 times.
//SHR r/m32, 1         D1 /5                  M1 Valid Valid Unsigned divide r / m32 by 2, once.
//SHR r/m64, 1         REX.W + D1 /5          M1 Valid N.E.Unsigned divide r / m64 by 2, once.
//SHR r/m32, CL        D3 /5                  MC Valid Valid Unsigned divide r / m32 by 2, CL times.
//SHR r/m64, CL        REX.W + D3 /5          MC Valid N.E.Unsigned divide r / m64 by 2, CL times.
//SHR r/m32, imm8      C1 /5 ib               MI Valid Valid Unsigned divide r / m32 by 2, imm8 times.
//SHR r/m64, imm8      REX.W + C1 /5 ib       MI Valid N.E.Unsigned divide r / m64 by 2, imm8 times.
/* ----------------------------------------------------------------------------------------------- */
{ "shr",    2, { R8,       IMM_1   }, GP0, (F_OPCODE2_REG),												                                    NO_VEX, NO_EVEX, 1, 2, { 0xd0, 0xe8, 0x00 }, 1, 0, NO_MOD,      0, 0, 0,                       (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "shr",    2, { R8H,      IMM_1   }, GP0, (F_OPCODE2_REG),												                                    NO_VEX, NO_EVEX, 1, 2, { 0xd0, 0xe8, 0x00 }, 1, 0, NO_MOD,      0, 0, 0,                       (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "shr",    2, { R8U,      IMM_1   }, GP3, REX | (F_OPCODE2_REG),												                              NO_VEX, NO_EVEX, 1, 2, { 0xd0, 0xe8, 0x00 }, 1, 0, NO_MOD,      0, 0, 0,                       (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "shr",    2, { R8E,      IMM_1   }, GP3, (REX | REXB) | (F_OPCODE2_REG),												                    NO_VEX, NO_EVEX, 1, 2, { 0xd0, 0xe8, 0x00 }, 1, 0, NO_MOD,      0, 0, 0,                       (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "shr",    2, { R8,       R8      }, GP0, (F_OPCODE2_REG),												                                    NO_VEX, NO_EVEX, 1, 2, { 0xd2, 0xe8, 0x00 }, 1, 0, NO_MOD,      0, 0, 0,                       (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "shr",    2, { R8H,      R8      }, GP0, (F_OPCODE2_REG),												                                    NO_VEX, NO_EVEX, 1, 2, { 0xd2, 0xe8, 0x00 }, 1, 0, NO_MOD,      0, 0, 0,                       (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "shr",    2, { R8U,      R8      }, GP3, REX | (F_OPCODE2_REG),												                              NO_VEX, NO_EVEX, 1, 2, { 0xd2, 0xe8, 0x00 }, 1, 0, NO_MOD,      0, 0, 0,                       (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "shr",    2, { R8E,      R8      }, GP3, (REX | REXB) | (F_OPCODE2_REG),												                    NO_VEX, NO_EVEX, 1, 2, { 0xd2, 0xe8, 0x00 }, 1, 0, NO_MOD,      0, 0, 0,                       (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "shr",    2, { R8,       IMM8    }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	                          NO_VEX, NO_EVEX, 1, 1, { 0xc0, 0x05, 0x00 }, 1, 0, MOD_REG_IMM, 0, 0, 0,                       (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "shr",    2, { R8H,      IMM8    }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	                          NO_VEX, NO_EVEX, 1, 1, { 0xc0, 0x05, 0x00 }, 1, 0, MOD_REG_IMM, 0, 0, 0,                       (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "shr",    2, { R8U,      IMM8    }, GP3, REX | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	                    NO_VEX, NO_EVEX, 1, 1, { 0xc0, 0x05, 0x00 }, 1, 0, MOD_REG_IMM, 0, 0, 0,                       (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "shr",    2, { R8E,      IMM8    }, GP3, (REX | REXB) | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	          NO_VEX, NO_EVEX, 1, 1, { 0xc0, 0x05, 0x00 }, 1, 0, MOD_REG_IMM, 0, 0, 0,                       (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "shr",    2, { M8,       IMM_1   }, GP0, ALLOW_SEG | (F_OPCODE2_REG),                                               NO_VEX, NO_EVEX, 1, 1, { 0xd0, 0x28, 0x00 }, 1, 0, 0x00, 0, 0,	           ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM, NO_MEM,P_86,  0, NULL },
{ "shr",    2, { M8,       R8_CL   }, GP0, ALLOW_SEG | (F_OPCODE2_REG),									                              NO_VEX, NO_EVEX, 1, 1, { 0xd2, 0x28, 0x00 }, 1, 0, 0x00, 0, 0,	           ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM, NO_MEM,P_86,  0, NULL },
{ "shr",    2, { M8,       IMM8    }, GP0, ALLOW_SEG | (F_MODRM | OPCODE_EXT | IMM8_ONLY),									          NO_VEX, NO_EVEX, 1, 1, { 0xc0, 0x05, 0x00 }, 1, 0, MOD_MEM_IMM, 0, 0,	     ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0,P_86,  0, NULL },
{ "shr",    2, { R16,      IMM_1   }, GP0, (F_OPCODE2_REG),									                                          NO_VEX, NO_EVEX, 1, 2, { 0xd1, 0xe8, 0x00 }, 2, 0, NO_MOD,      0,    OP_SIZE_OVERRIDE, 0,      (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "shr",    2, { R16E,     IMM_1   }, GP0, (REX | REXB) | (F_OPCODE2_REG),									                          NO_VEX, NO_EVEX, 1, 2, { 0xd1, 0xe8, 0x00 }, 2, 0, NO_MOD,      0,    OP_SIZE_OVERRIDE, 0,      (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "shr",    2, { R16,      R8      }, GP0, (F_OPCODE2_REG),									                                          NO_VEX, NO_EVEX, 1, 1, { 0xd3, 0xe8, 0x00 }, 2, 0, NO_MOD,      0,    OP_SIZE_OVERRIDE, 0,      (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "shr",    2, { R16E,     R8      }, GP0, (REX | REXB) | (F_OPCODE2_REG),									                          NO_VEX, NO_EVEX, 1, 1, { 0xd3, 0xe8, 0x00 }, 2, 0, NO_MOD,      0,    OP_SIZE_OVERRIDE, 0,      (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "shr",    2, { R16,      IMM8    }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	                          NO_VEX, NO_EVEX, 1, 1, { 0xc1, 0x00, 0x00 }, 2, 0, 0xe8,        0,    OP_SIZE_OVERRIDE, 0,      (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "shr",    2, { R16E,     IMM8    }, GP0, (REX | REXB) | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	          NO_VEX, NO_EVEX, 1, 1, { 0xc1, 0x00, 0x00 }, 2, 0, 0xe8,        0,    OP_SIZE_OVERRIDE, 0,      (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "shr",    2, { R32,      IMM_1   }, GP0, (F_OPCODE2_REG),									                                          NO_VEX, NO_EVEX, 1, 2, { 0xd1, 0xe8, 0x00 }, 4, 0, NO_MOD,      0, 0, 0,                        (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "shr",    2, { R32E,     IMM_1   }, GP0, (REX | REXB) | (F_OPCODE2_REG),									                          NO_VEX, NO_EVEX, 1, 2, { 0xd1, 0xe8, 0x00 }, 4, 0, NO_MOD,      0, 0, 0,                        (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "shr",    2, { R32,      R8      }, GP0, (F_OPCODE2_REG),									                                          NO_VEX, NO_EVEX, 1, 2, { 0xd3, 0xe8, 0x00 }, 4, 0, NO_MOD,      0, 0, 0,                        (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "shr",    2, { R32E,     R8      }, GP0, (REX | REXB) | (F_OPCODE2_REG),									                          NO_VEX, NO_EVEX, 1, 2, { 0xd3, 0xe8, 0x00 }, 4, 0, NO_MOD,      0, 0, 0,                        (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "shr",    2, { R32,      IMM8    }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),                           NO_VEX, NO_EVEX, 1, 1, { 0xc1, 0x00, 0x00 }, 4, 0, 0xe8,        0, 0, 0,                        (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "shr",    2, { R32E,     IMM8    }, GP0, (REX | REXB) | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),            NO_VEX, NO_EVEX, 1, 1, { 0xc1, 0x00, 0x00 }, 4, 0, 0xe8,        0, 0, 0,                        (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "shr",    2, { R64,      IMM_1   }, GP3, (REX | REXW) | (F_OPCODE2_REG),                                            NO_VEX, NO_EVEX, 1, 2, { 0xd1, 0xe8, 0x00 }, 8, 0, NO_MOD,      0, 0, 0,                                    (X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "shr",    2, { R64E,     IMM_1   }, GP3, (REX | REXW | REXB) | (F_OPCODE2_REG),                                     NO_VEX, NO_EVEX, 1, 2, { 0xd1, 0xe8, 0x00 }, 8, 0, NO_MOD,      0, 0, 0,                                    (X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "shr",    2, { R64,      R8      }, GP3, (REX | REXW) | (F_OPCODE2_REG),                                            NO_VEX, NO_EVEX, 1, 2, { 0xd3, 0xe8, 0x00 }, 8, 0, NO_MOD,      0, 0, 0,                                    (X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "shr",    2, { R64E,     R8      }, GP3, (REX | REXW | REXB) | (F_OPCODE2_REG),                                     NO_VEX, NO_EVEX, 1, 2, { 0xd3, 0xe8, 0x00 }, 8, 0, NO_MOD,      0, 0, 0,                                    (X64), NO_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "shr",    2, { R64,      IMM8    }, GP3, (REX | REXW) | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),            NO_VEX, NO_EVEX, 1, 1, { 0xc1, 0x00, 0x00 }, 8, 0, 0xe8,        0, 0, 0,                        (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "shr",    2, { R64E,     IMM8    }, GP3, (REX | REXW | REXB) | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),     NO_VEX, NO_EVEX, 1, 1, { 0xc1, 0x00, 0x00 }, 8, 0, 0xe8,        0, 0, 0,                        (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "shr",    2, { M16,      IMM_1   }, GP0, ALLOW_SEG | (F_MODRM | OPCODE_EXT | IMM8_ONLY),                            NO_VEX, NO_EVEX, 1, 1, { 0xd1, 0x05, 0x00 }, 2, 0, MOD_MEM_IMM, 0,     OP_SIZE_OVERRIDE,	0,    (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0,P_86,  0, NULL },
{ "shr",    2, { M16,      R8_CL   }, GP0, ALLOW_SEG | (F_MODRM | OPCODE_EXT | IMM8_ONLY),									          NO_VEX, NO_EVEX, 1, 1, { 0xd3, 0x05, 0x00 }, 2, 0, MOD_MEM_IMM, 0,     OP_SIZE_OVERRIDE,  0,    (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0,P_86,  0, NULL },
{ "shr",    2, { M16,      IMM8    }, GP0, ALLOW_SEG | (F_MODRM | OPCODE_EXT | IMM8_ONLY),									          NO_VEX, NO_EVEX, 1, 1, { 0xc1, 0x05, 0x00 }, 2, 0, MOD_MEM_IMM, 0,     OP_SIZE_OVERRIDE, 	0,    (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0,P_86,  0, NULL },
{ "shr",    2, { M32,      IMM_1   }, GP0, ALLOW_SEG | (F_MODRM | OPCODE_EXT | IMM8_ONLY),                            NO_VEX, NO_EVEX, 1, 1, { 0xd1, 0x05, 0x00 }, 4, 0, MOD_MEM_IMM, 0,     0,	 ADDR_SIZE_OVERRIDE,  (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0,P_86,  0, NULL },
{ "shr",    2, { M32,      R8_CL   }, GP0, ALLOW_SEG | (F_MODRM | OPCODE_EXT | IMM8_ONLY),									          NO_VEX, NO_EVEX, 1, 1, { 0xd3, 0x05, 0x00 }, 4, 0, MOD_MEM_IMM, 0,     0,  ADDR_SIZE_OVERRIDE,  (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0,P_86,  0, NULL },
{ "shr",    2, { M32,      IMM8    }, GP0, ALLOW_SEG | (F_MODRM | OPCODE_EXT | IMM8_ONLY),									          NO_VEX, NO_EVEX, 1, 1, { 0xc1, 0x05, 0x00 }, 4, 0, MOD_MEM_IMM, 0,     0,  ADDR_SIZE_OVERRIDE,  (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0,P_86,  0, NULL },
{ "shr",    2, { M64,      IMM_1   }, GP0, ALLOW_SEG | (REX | REXW) | (F_MODRM | OPCODE_EXT | IMM8_ONLY),             NO_VEX, NO_EVEX, 1, 1, { 0xd1, 0x05, 0x00 }, 8, 0, MOD_MEM_IMM, 0,     0,	 0,                   (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0,P_86,  0, NULL },
{ "shr",    2, { M64,      R8_CL   }, GP0, ALLOW_SEG | (REX | REXW) | (F_MODRM | OPCODE_EXT | IMM8_ONLY),						  NO_VEX, NO_EVEX, 1, 1, { 0xd3, 0x05, 0x00 }, 8, 0, MOD_MEM_IMM, 0,     0,  0,                   (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0,P_86,  0, NULL },
{ "shr",    2, { M64,      IMM8    }, GP0, ALLOW_SEG | (REX | REXW) | (F_MODRM | OPCODE_EXT | IMM8_ONLY),						  NO_VEX, NO_EVEX, 1, 1, { 0xc1, 0x05, 0x00 }, 8, 0, MOD_MEM_IMM, 0,     0,  0,                   (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0,P_86,  0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//TEST AL, imm8 I Valid Valid      A8 ib
{ "test",    2, { R8_AL,    IMM8    }, GP0, (F_OPCODE_REG),												                                   NO_VEX, NO_EVEX, 1, 1, { 0xa8, 0x00, 0x00 }, 1, 0, NO_MOD,      0, 0,				         0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
//TEST AX, imm16 I Valid Valid     A9 iw
//TEST EAX, imm32 I Valid Valid     A9 id
//TEST RAX, imm32 I Valid N.E.REX.W + A9 id
{ "test",    2, { R16_AX,   IMM16   }, GP0, (F_OPCODE_REG),												                                   NO_VEX, NO_EVEX, 1, 1, { 0xa9, 0x00, 0x00 }, 2, 0, NO_MOD,      0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "test",    2, { R32_EAX,  IMM32   }, GP0, (F_OPCODE_REG),												                                   NO_VEX, NO_EVEX, 1, 1, { 0xa9, 0x00, 0x00 }, 4, 0, NO_MOD,      0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "test",    2, { R64_RAX,  IMM32   }, GP3, (REX | REXW) | (F_OPCODE_REG),						                               NO_VEX, NO_EVEX, 1, 1, { 0xa9, 0x00, 0x00 }, 4, 0, NO_MOD,      0, 0,				         0,                              (X64), NO_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
//TEST r / m8, imm8 MI Valid Valid     F6 / 0 ib
//TEST r / m8*, imm8 MI Valid N.E.REX + F6 / 0 ib
{ "test",    2, { R8,       IMM8    }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),		                     NO_VEX, NO_EVEX, 1, 1, { 0xf6, 0x00, 0x00 }, 1, 0, MOD_REG_IMM, 0, 0,	               0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "test",    2, { R8H,      IMM8    }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),	                       NO_VEX, NO_EVEX, 1, 1, { 0xf6, 0x00, 0x00 }, 1, 0, MOD_REG_IMM, 0, 0,	               0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "test",    2, { R8U,      IMM8    }, GP3, REX | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),									 NO_VEX, NO_EVEX, 1, 1, { 0xf6, 0x00, 0x00 }, 1, 0, MOD_REG_IMM, 0, 0,				         0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
{ "test",    2, { R8E,      IMM8    }, GP3, (REX | REXB) | (F_MODRM_RM | F_MODRM | OPCODE_EXT | IMM8_ONLY),				   NO_VEX, NO_EVEX, 1, 1, { 0xf6, 0x00, 0x00 }, 1, 0, MOD_REG_IMM, 0, 0,				         0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
{ "test",    2, { M8,       IMM8    }, GP0, ALLOW_SEG | (F_MODRM | OPCODE_EXT | IMM8_ONLY),									         NO_VEX, NO_EVEX, 1, 1, { 0xf6, 0x00, 0x00 }, 1, 0, MOD_MEM_IMM, 0, 0,	               ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0,P_86,  0, NULL },
//TEST r / m16, imm16 MI Valid Valid    F7 / 0 iw
//TEST r / m32, imm32 MI Valid Valid    F7 / 0 id
//TEST r / m64, imm32 MI Valid N.E.REX.W + F7 / 0 id
{ "test",    2, { R16,      IMM8    }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT),		                                 NO_VEX, NO_EVEX, 1, 1, { 0xf7, 0x00, 0x00 }, 2, 0, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "test",    2, { R16,      IMM16   }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT),		                                 NO_VEX, NO_EVEX, 1, 1, { 0xf7, 0x00, 0x00 }, 2, 0, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "test",    2, { R16E,     IMM8    }, GP3, (REX | REXB) | (F_MODRM_RM | F_MODRM | OPCODE_EXT),								       NO_VEX, NO_EVEX, 1, 1, { 0xf7, 0x00, 0x00 }, 2, 0, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
{ "test",    2, { R16E,     IMM16   }, GP3, (REX | REXB) | (F_MODRM_RM | F_MODRM | OPCODE_EXT),								       NO_VEX, NO_EVEX, 1, 1, { 0xf7, 0x00, 0x00 }, 2, 0, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
{ "test",    2, { M16,      IMM16   }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT),		                                 NO_VEX, NO_EVEX, 1, 1, { 0xf7, 0x00, 0x00 }, 2, 0, MOD_MEM_IMM, 0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0, P_86,  0, NULL },
{ "test",    2, { R32,      IMM8    }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT),		                                 NO_VEX, NO_EVEX, 1, 1, { 0xf7, 0x00, 0x00 }, 4, 0, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "test",    2, { R32,      IMM32   }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT),		                                 NO_VEX, NO_EVEX, 1, 1, { 0xf7, 0x00, 0x00 }, 4, 0, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "test",    2, { R32E,     IMM8    }, GP3, (REX | REXB) | (F_MODRM_RM | F_MODRM | OPCODE_EXT),								       NO_VEX, NO_EVEX, 1, 1, { 0xf7, 0x00, 0x00 }, 4, 0, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
{ "test",    2, { R32E,     IMM32   }, GP3, (REX | REXB) | (F_MODRM_RM | F_MODRM | OPCODE_EXT),								       NO_VEX, NO_EVEX, 1, 1, { 0xf7, 0x00, 0x00 }, 4, 0, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
{ "test",    2, { R32,      IMM16   }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT),		                                 NO_VEX, NO_EVEX, 1, 1, { 0xf7, 0x00, 0x00 }, 4, 0, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "test",    2, { R32E,     IMM16   }, GP3, (REX | REXB) | (F_MODRM_RM | F_MODRM | OPCODE_EXT),								       NO_VEX, NO_EVEX, 1, 1, { 0xf7, 0x00, 0x00 }, 4, 0, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
{ "test",    2, { M32,      IMM32   }, GP0, (F_MODRM_RM | F_MODRM | OPCODE_EXT),		                                 NO_VEX, NO_EVEX, 1, 1, { 0xf7, 0x00, 0x00 }, 4, 0, MOD_MEM_IMM, 0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0, P_86,  0, NULL },
{ "test",    2, { R64,      IMM32   }, GP3, (REX | REXW) | (F_MODRM_RM | F_MODRM | OPCODE_EXT),                      NO_VEX, NO_EVEX, 1, 1, { 0xf7, 0x00, 0x00 }, 4, 0, MOD_REG_IMM, 0, 0,	               0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
{ "test",    2, { R64,      IMM8    }, GP3, (REX | REXW) | (F_MODRM_RM | F_MODRM | OPCODE_EXT),                      NO_VEX, NO_EVEX, 1, 1, { 0xf7, 0x00, 0x00 }, 4, 0, MOD_REG_IMM, 0, 0,	               0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
{ "test",    2, { R64,      IMM16   }, GP3, (REX | REXW) | (F_MODRM_RM | F_MODRM | OPCODE_EXT),                      NO_VEX, NO_EVEX, 1, 1, { 0xf7, 0x00, 0x00 }, 4, 0, MOD_REG_IMM, 0, 0,	               0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
{ "test",    2, { R64E,     IMM32   }, GP3, (REX | REXW | REXB) | (F_MODRM_RM | F_MODRM | OPCODE_EXT),               NO_VEX, NO_EVEX, 1, 1, { 0xf7, 0x00, 0x00 }, 4, 0, MOD_REG_IMM, 0, 0,	               0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
{ "test",    2, { R64E,     IMM16   }, GP3, (REX | REXW | REXB) | (F_MODRM_RM | F_MODRM | OPCODE_EXT),               NO_VEX, NO_EVEX, 1, 1, { 0xf7, 0x00, 0x00 }, 4, 0, MOD_REG_IMM, 0, 0,	               0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
{ "test",    2, { R64E,     IMM8    }, GP3, (REX | REXW | REXB) | (F_MODRM_RM | F_MODRM | OPCODE_EXT),               NO_VEX, NO_EVEX, 1, 1, { 0xf7, 0x00, 0x00 }, 4, 0, MOD_REG_IMM, 0, 0,	               0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
{ "test",    2, { M64,      IMM32   }, GP3, REXW | (F_MODRM_RM | F_MODRM | OPCODE_EXT),		                           NO_VEX, NO_EVEX, 1, 1, { 0xf7, 0x00, 0x00 }, 4, 0, MOD_MEM_IMM, 0, 0,	               0,                              (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0, P_64,  0, NULL },
//TEST r / m8, r8 MR Valid Valid       84 / r
//TEST r / m8*, r8* MR Valid N.E.REX + 84 / r
{ "test",    2, { R8,       R8      }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),                               NO_VEX, NO_EVEX, 1, 1, { 0x84, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                  (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "test",    2, { R8,       R8H     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),		                            NO_VEX, NO_EVEX, 1, 1, { 0x84, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                  (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "test",    2, { R8H,      R8      }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),		                            NO_VEX, NO_EVEX, 1, 1, { 0x84, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                  (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "test",    2, { R8H,      R8H     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),		                            NO_VEX, NO_EVEX, 1, 1, { 0x84, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                  (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "test",    2, { R8E,      R8E     }, GP3, (REX | REXB | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		      NO_VEX, NO_EVEX, 1, 1, { 0x84, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                  (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "test",    2, { R8,       R8E     }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				        NO_VEX, NO_EVEX, 1, 1, { 0x84, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                  (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "test",    2, { R8E,      R8      }, GP3, (REX | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				        NO_VEX, NO_EVEX, 1, 1, { 0x84, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                  (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "test",    2, { R8U,      R8      }, GP3, (REX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),					              NO_VEX, NO_EVEX, 1, 1, { 0x84, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                  (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "test",    2, { R8U,      R8E     }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),					      NO_VEX, NO_EVEX, 1, 1, { 0x84, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                  (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "test",    2, { R8,       R8U     }, GP3, (REX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),					              NO_VEX, NO_EVEX, 1, 1, { 0x84, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                  (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },

{ "test",    2, { R16,      R16     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                  NO_VEX, NO_EVEX, 1, 1, { 0x85, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "test",    2, { R16E,     R16E    }, GP3, (REX | REXB | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		      NO_VEX, NO_EVEX, 1, 1, { 0x85, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                  (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "test",    2, { R16E,     R16     }, GP3, (REX | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				        NO_VEX, NO_EVEX, 1, 1, { 0x85, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                  (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "test",    2, { R16,      R16E    }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				        NO_VEX, NO_EVEX, 1, 1, { 0x85, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                  (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "test",    2, { R32,      R32     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                  NO_VEX, NO_EVEX, 1, 1, { 0x85, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "test",    2, { R32E,     R32E    }, GP3, (REX | REXB | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		      NO_VEX, NO_EVEX, 1, 1, { 0x85, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                  (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "test",    2, { R32E,     R32     }, GP3, (REX | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				        NO_VEX, NO_EVEX, 1, 1, { 0x85, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                  (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "test",    2, { R32,      R32E    }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				        NO_VEX, NO_EVEX, 1, 1, { 0x85, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                  (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "test",    2, { R64,      R64     }, GP3, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		            NO_VEX, NO_EVEX, 1, 1, { 0x85, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                  (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "test",    2, { R64E,     R64E    }, GP3, (REX | REXR | REXB | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),  NO_VEX, NO_EVEX, 1, 1, { 0x85, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                  (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "test",    2, { R64,      R64E    }, GP3, (REX | REXB | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		      NO_VEX, NO_EVEX, 1, 1, { 0x85, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                  (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "test",    2, { R64E,     R64     }, GP3, (REX | REXR | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		      NO_VEX, NO_EVEX, 1, 1, { 0x85, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                  (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },


{ "test",    2, { M_ANY,    R8      }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                              NO_VEX, NO_EVEX, 1, 1, { 0x84, 0x00, 0x00 }, 1, 0, MOD_MEM_REG, 0, 0,				ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_86,  0, NULL },
{ "test",    2, { M_ANY,    R8H     }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                              NO_VEX, NO_EVEX, 1, 1, { 0x84, 0x00, 0x00 }, 1, 0, MOD_MEM_REG, 0, 0,				ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_86,  0, NULL },
{ "test",    2, { M_ANY,    R8E     }, GP3, ALLOW_SEG | (REX | REXR) | (F_MODRM | F_MODRM_REG),	                      NO_VEX, NO_EVEX, 1, 1, { 0x84, 0x00, 0x00 }, 1, 0, MOD_MEM_REG, 0, 0,				ADDR_SIZE_OVERRIDE,             (X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_64,  0, NULL },
{ "test",    2, { M_ANY,    R8U     }, GP3, ALLOW_SEG | (REX) | (F_MODRM | F_MODRM_REG),						                  NO_VEX, NO_EVEX, 1, 1, { 0x84, 0x00, 0x00 }, 1, 0, MOD_MEM_REG, 0, 0,				ADDR_SIZE_OVERRIDE,             (X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_64,  0, NULL },
//TEST r / m16, r16 MR Valid Valid      85 / r
//TEST r / m32, r32 MR Valid Valid      85 / r
//TEST r / m64, r64 MR Valid N.E.REX.W + 85 / r
{ "test",     2, { M_ANY,    R16     }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                              NO_VEX, NO_EVEX, 1, 1, { 0x85, 0x00, 0x00 }, 2, 0, MOD_MEM_REG, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_86,  0, NULL },
{ "test",     2, { M_ANY,    R16E    }, GP3, ALLOW_SEG | (REX | REXR) | (F_MODRM | F_MODRM_REG),	                    NO_VEX, NO_EVEX, 1, 1, { 0x85, 0x00, 0x00 }, 2, 0, MOD_MEM_REG, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE,             (X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_64,  0, NULL },
{ "test",     2, { M_ANY,    R32     }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                              NO_VEX, NO_EVEX, 1, 1, { 0x85, 0x00, 0x00 }, 4, 0, MOD_MEM_REG, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_86,  0, NULL },
{ "test",     2, { M_ANY,    R32E    }, GP3, ALLOW_SEG | (REX | REXR) | (F_MODRM | F_MODRM_REG),	                    NO_VEX, NO_EVEX, 1, 1, { 0x85, 0x00, 0x00 }, 4, 0, MOD_MEM_REG, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE,             (X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_64,  0, NULL },
{ "test",     2, { M_ANY,    R64     }, GP3, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_REG),			                NO_VEX, NO_EVEX, 1, 1, { 0x85, 0x00, 0x00 }, 8, 0, MOD_MEM_REG, 0, 0,				          ADDR_SIZE_OVERRIDE,             (X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_64,  0, NULL },
{ "test",     2, { M_ANY,    R64E    }, GP3, ALLOW_SEG | (REX | REXW | REXR) | (F_MODRM | F_MODRM_REG),	              NO_VEX, NO_EVEX, 1, 1, { 0x85, 0x00, 0x00 }, 8, 0, MOD_MEM_REG, 0, 0,				          ADDR_SIZE_OVERRIDE,             (X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_64,  0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//SHLD r / m16, r16, imm8 MRI Valid Valid   0F A4 / r ib          
//SHLD r / m16, r16, CL   MRC Valid Valid   0F A5 / r             
//SHLD r / m32, r32, imm8 MRI Valid Valid   0F A4 / r ib          
//SHLD r / m64, r64, imm8 MRI Valid N.E.    REX.W + 0F A4 / r ib  
//SHLD r / m32, r32, CL   MRC Valid Valid   0F A5 / r             
//SHLD r / m64, r64, CL   MRC Valid N.E.    REX.W + 0F A5 / r     
/* ----------------------------------------------------------------------------------------------- */
{ "shld",    3, { R16,      R16_AX, IMM8 }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT | IMM8_ONLY),							                    NO_VEX, NO_EVEX, 2, 1, { 0xa4, 0x00, 0x00 }, 1, 1, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                   (X16 | X32 | X64), RM_DST,  PFX_0xF, IMM_OPND_2,     NO_MEM,     P_86,  0, NULL },
{ "shld",    3, { R16_AX,   R16,    IMM8 }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT | IMM8_ONLY),							                    NO_VEX, NO_EVEX, 2, 1, { 0xa4, 0x00, 0x00 }, 1, 1, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                   (X16 | X32 | X64), RM_DST,  PFX_0xF, IMM_OPND_2,     NO_MEM,     P_86,  0, NULL },
{ "shld",    3, { R16_AX,   R16_AX, IMM8 }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT | IMM8_ONLY),							                    NO_VEX, NO_EVEX, 2, 1, { 0xa4, 0x00, 0x00 }, 1, 1, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                   (X16 | X32 | X64), RM_DST,  PFX_0xF, IMM_OPND_2,     NO_MEM,     P_86,  0, NULL },
{ "shld",    3, { R16,      R16,    IMM8 }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT | IMM8_ONLY),							                    NO_VEX, NO_EVEX, 2, 1, { 0xa4, 0x00, 0x00 }, 1, 1, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                   (X16 | X32 | X64), RM_DST,  PFX_0xF, IMM_OPND_2,     NO_MEM,     P_86,  0, NULL },
{ "shld",    3, { R16E,     R16E,   IMM8 }, GP3, (REX | REXB | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT | IMM8_ONLY),           NO_VEX, NO_EVEX, 2, 1, { 0xa4, 0x00, 0x00 }, 1, 1, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                               (X64), RM_DST,  PFX_0xF, IMM_OPND_2,     NO_MEM,     P_64,  0, NULL },
{ "shld",    3, { R16E,     R16,    IMM8 }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT | IMM8_ONLY),				          NO_VEX, NO_EVEX, 2, 1, { 0xa4, 0x00, 0x00 }, 1, 1, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                               (X64), RM_DST,  PFX_0xF, IMM_OPND_2,     NO_MEM,     P_64,  0, NULL },
{ "shld",    3, { R16,      R16E,   IMM8 }, GP3, (REX | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT | IMM8_ONLY),				          NO_VEX, NO_EVEX, 2, 1, { 0xa4, 0x00, 0x00 }, 1, 1, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                               (X64), RM_DST,  PFX_0xF, IMM_OPND_2,     NO_MEM,     P_64,  0, NULL },
{ "shld",    3, { R32,      R32,    IMM8 }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT | IMM8_ONLY),							                    NO_VEX, NO_EVEX, 4, 1, { 0xa4, 0x00, 0x00 }, 1, 1, MOD_REG_IMM, 0, 0,                0,                   (X16 | X32 | X64), RM_DST,  PFX_0xF, IMM_OPND_2,     NO_MEM,     P_86,  0, NULL },
{ "shld",    3, { R32_EAX,  R32,    IMM8 }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT | IMM8_ONLY),							                    NO_VEX, NO_EVEX, 4, 1, { 0xa4, 0x00, 0x00 }, 1, 1, MOD_REG_IMM, 0, 0,                0,                   (X16 | X32 | X64), RM_DST,  PFX_0xF, IMM_OPND_2,     NO_MEM,     P_86,  0, NULL },
{ "shld",    3, { R32_EAX,  R32_EAX,IMM8 }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT | IMM8_ONLY),							                    NO_VEX, NO_EVEX, 4, 1, { 0xa4, 0x00, 0x00 }, 1, 1, MOD_REG_IMM, 0, 0,                0,                   (X16 | X32 | X64), RM_DST,  PFX_0xF, IMM_OPND_2,     NO_MEM,     P_86,  0, NULL },
{ "shld",    3, { R32,      R32_EAX,IMM8 }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT | IMM8_ONLY),							                    NO_VEX, NO_EVEX, 4, 1, { 0xa4, 0x00, 0x00 }, 1, 1, MOD_REG_IMM, 0, 0,                0,                   (X16 | X32 | X64), RM_DST,  PFX_0xF, IMM_OPND_2,     NO_MEM,     P_86,  0, NULL },
{ "shld",    3, { R32E,     R32E,   IMM8 }, GP3, (REX | REXB | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM | IMM8_ONLY),	                      NO_VEX, NO_EVEX, 4, 1, { 0xa4, 0x00, 0x00 }, 1, 1, MOD_REG_IMM, 0, 0,                0,                               (X64), RM_DST,  PFX_0xF, IMM_OPND_2,     NO_MEM,     P_64,  0, NULL },
{ "shld",    3, { R32E,     R32,    IMM8 }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT | IMM8_ONLY),				          NO_VEX, NO_EVEX, 4, 1, { 0xa4, 0x00, 0x00 }, 1, 1, MOD_REG_IMM, 0, 0,                0,                               (X64), RM_DST,  PFX_0xF, IMM_OPND_2,     NO_MEM,     P_64,  0, NULL },
{ "shld",    3, { R32,      R32E,   IMM8 }, GP3, (REX | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT | IMM8_ONLY),				          NO_VEX, NO_EVEX, 4, 1, { 0xa4, 0x00, 0x00 }, 1, 1, MOD_REG_IMM, 0, 0,                0,                               (X64), RM_DST,  PFX_0xF, IMM_OPND_2,     NO_MEM,     P_64,  0, NULL },
{ "shld",    3, { R64,      R64,    IMM8 }, GP3, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT | IMM8_ONLY),		              NO_VEX, NO_EVEX, 1, 1, { 0xa4, 0x00, 0x00 }, 8, 1, MOD_REG_IMM, 0, 0,                0,                               (X64), RM_DST,  PFX_0xF, IMM_OPND_2,     NO_MEM,     P_64,  0, NULL },
{ "shld",    3, { R64_RAX,  R64,    IMM8 }, GP3, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT | IMM8_ONLY),		              NO_VEX, NO_EVEX, 1, 1, { 0xa4, 0x00, 0x00 }, 8, 1, MOD_REG_IMM, 0, 0,                0,                               (X64), RM_DST,  PFX_0xF, IMM_OPND_2,     NO_MEM,     P_64,  0, NULL },
{ "shld",    3, { R64,      R64_RAX,IMM8 }, GP3, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT | IMM8_ONLY),		              NO_VEX, NO_EVEX, 1, 1, { 0xa4, 0x00, 0x00 }, 8, 1, MOD_REG_IMM, 0, 0,                0,                               (X64), RM_DST,  PFX_0xF, IMM_OPND_2,     NO_MEM,     P_64,  0, NULL },
{ "shld",    3, { R64_RAX,  R64_RAX,IMM8 }, GP3, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT | IMM8_ONLY),		              NO_VEX, NO_EVEX, 1, 1, { 0xa4, 0x00, 0x00 }, 8, 1, MOD_REG_IMM, 0, 0,                0,                               (X64), RM_DST,  PFX_0xF, IMM_OPND_2,     NO_MEM,     P_64,  0, NULL },
{ "shld",    3, { R64E,     R64E,   IMM8 }, GP3, (REX | REXR | REXB | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM | IMM8_ONLY),                 NO_VEX, NO_EVEX, 1, 1, { 0xa4, 0x00, 0x00 }, 8, 1, MOD_REG_IMM, 0, 0,                0,                               (X64), RM_DST,  PFX_0xF, IMM_OPND_2,     NO_MEM,     P_64,  0, NULL },
{ "shld",    3, { R64,      R64E,   IMM8 }, GP3, (REX | REXR | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT | IMM8_ONLY),		        NO_VEX, NO_EVEX, 1, 1, { 0xa4, 0x00, 0x00 }, 8, 1, MOD_REG_IMM, 0, 0,                0,                               (X64), RM_DST,  PFX_0xF, IMM_OPND_2,     NO_MEM,     P_64,  0, NULL },
{ "shld",    3, { R64E,     R64,    IMM8 }, GP3, (REX | REXB | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT | IMM8_ONLY),		        NO_VEX, NO_EVEX, 1, 1, { 0xa4, 0x00, 0x00 }, 8, 1, MOD_REG_IMM, 0, 0,                0,                               (X64), RM_DST,  PFX_0xF, IMM_OPND_2,     NO_MEM,     P_64,  0, NULL },
{ "shld",    3, { M_ANY,    R16,    IMM8 }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG | OPCODE_EXT | IMM8_ONLY),				                          NO_VEX, NO_EVEX, 1, 1, { 0xa4, 0x00, 0x00 }, 2, 1, MOD_MEM_IMM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  PFX_0xF, IMM_OPND_2,     MEM_OPND_0, P_86,  0, NULL },
{ "shld",    3, { M_ANY,    R16_AX, IMM8 }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG | OPCODE_EXT | IMM8_ONLY),				                          NO_VEX, NO_EVEX, 1, 1, { 0xa4, 0x00, 0x00 }, 2, 1, MOD_MEM_IMM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  PFX_0xF, IMM_OPND_2,     MEM_OPND_0, P_86,  0, NULL },
{ "shld",    3, { M_ANY,    R16E,   IMM8 }, GP3, ALLOW_SEG | (REX | REXR) | (F_MODRM | F_MODRM_REG | IMM8_ONLY),	                              NO_VEX, NO_EVEX, 1, 1, { 0xa4, 0x00, 0x00 }, 2, 1, MOD_MEM_IMM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE,             (X64), RM_DST,  PFX_0xF, IMM_OPND_2,     MEM_OPND_0, P_64,  0, NULL },
{ "shld",    3, { M_ANY,    R32,    IMM8 }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG | OPCODE_EXT | IMM8_ONLY),				                          NO_VEX, NO_EVEX, 1, 1, { 0xa4, 0x00, 0x00 }, 4, 1, MOD_MEM_IMM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  PFX_0xF, IMM_OPND_2,     MEM_OPND_0, P_86,  0, NULL },
{ "shld",    3, { M_ANY,    R32_EAX,IMM8 }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG | OPCODE_EXT | IMM8_ONLY),				                          NO_VEX, NO_EVEX, 1, 1, { 0xa4, 0x00, 0x00 }, 4, 1, MOD_MEM_IMM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  PFX_0xF, IMM_OPND_2,     MEM_OPND_0, P_86,  0, NULL },
{ "shld",    3, { M_ANY,    R32E,   IMM8 }, GP3, ALLOW_SEG | (REX | REXR) | (F_MODRM | F_MODRM_REG | OPCODE_EXT | IMM8_ONLY),	                  NO_VEX, NO_EVEX, 1, 1, { 0xa4, 0x00, 0x00 }, 4, 1, MOD_MEM_IMM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE,             (X64), RM_DST,  PFX_0xF, IMM_OPND_2,     MEM_OPND_0, P_64,  0, NULL },
{ "shld",    3, { M_ANY,    R64,    IMM8 }, GP0, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_REG | OPCODE_EXT | IMM8_ONLY),				            NO_VEX, NO_EVEX, 1, 1, { 0xa4, 0x00, 0x00 }, 8, 1, MOD_MEM_IMM, 0, 0,				          ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  PFX_0xF, IMM_OPND_2,     MEM_OPND_0, P_64,  0, NULL },
{ "shld",    3, { M_ANY,    R64_RAX,IMM8 }, GP0, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_REG | OPCODE_EXT | IMM8_ONLY),				            NO_VEX, NO_EVEX, 1, 1, { 0xa4, 0x00, 0x00 }, 8, 1, MOD_MEM_IMM, 0, 0,				          ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  PFX_0xF, IMM_OPND_2,     MEM_OPND_0, P_64,  0, NULL },
{ "shld",    3, { M_ANY,    R64E,   IMM8 }, GP3, ALLOW_SEG | (REX | REXW | REXR) | (F_MODRM | F_MODRM_REG | OPCODE_EXT | IMM8_ONLY),	          NO_VEX, NO_EVEX, 1, 1, { 0xa4, 0x00, 0x00 }, 8, 1, MOD_MEM_IMM, 0, 0,				          ADDR_SIZE_OVERRIDE,             (X64), RM_DST,  PFX_0xF, IMM_OPND_2,     MEM_OPND_0, P_64,  0, NULL },
{ "shld",    3, { R16,      R16,    R8   }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM ),							                                            NO_VEX, NO_EVEX, 1, 1, { 0xa5, 0x00, 0x00 }, 2, 1, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                   (X16 | X32 | X64), RM_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "shld",    3, { R16,      R16_AX, R8   }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM ),							                                            NO_VEX, NO_EVEX, 1, 1, { 0xa5, 0x00, 0x00 }, 2, 1, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                   (X16 | X32 | X64), RM_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "shld",    3, { R16_AX,   R16,    R8   }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM ),							                                            NO_VEX, NO_EVEX, 1, 1, { 0xa5, 0x00, 0x00 }, 2, 1, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                   (X16 | X32 | X64), RM_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "shld",    3, { R16_AX,   R16_AX, R8   }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM ),							                                            NO_VEX, NO_EVEX, 1, 1, { 0xa5, 0x00, 0x00 }, 2, 1, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                   (X16 | X32 | X64), RM_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "shld",    3, { R16E,     R16E,   R8   }, GP3, (REX | REXB | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),                                    NO_VEX, NO_EVEX, 1, 1, { 0xa5, 0x00, 0x00 }, 2, 1, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                               (X64), RM_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "shld",    3, { R16E,     R16,    R8   }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				                                    NO_VEX, NO_EVEX, 1, 1, { 0xa5, 0x00, 0x00 }, 2, 1, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                               (X64), RM_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "shld",    3, { R16,      R16E,   R8   }, GP3, (REX | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				                                    NO_VEX, NO_EVEX, 1, 1, { 0xa5, 0x00, 0x00 }, 2, 1, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                               (X64), RM_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "shld",    3, { R32,      R32,    R8   }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                                            NO_VEX, NO_EVEX, 1, 1, { 0xa5, 0x00, 0x00 }, 4, 1, MOD_REG_REG, 0, 0,                0,                   (X16 | X32 | X64), RM_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "shld",    3, { R32_EAX,  R32,    R8   }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                                            NO_VEX, NO_EVEX, 1, 1, { 0xa5, 0x00, 0x00 }, 4, 1, MOD_REG_REG, 0, 0,                0,                   (X16 | X32 | X64), RM_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "shld",    3, { R32_EAX,  R32_EAX,R8   }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                                            NO_VEX, NO_EVEX, 1, 1, { 0xa5, 0x00, 0x00 }, 4, 1, MOD_REG_REG, 0, 0,                0,                   (X16 | X32 | X64), RM_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "shld",    3, { R32,      R32_EAX,R8   }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                                            NO_VEX, NO_EVEX, 1, 1, { 0xa5, 0x00, 0x00 }, 4, 1, MOD_REG_REG, 0, 0,                0,                   (X16 | X32 | X64), RM_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "shld",    3, { R32E,     R32E,   R8   }, GP3, (REX | REXB | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),	                                  NO_VEX, NO_EVEX, 1, 1, { 0xa5, 0x00, 0x00 }, 4, 1, MOD_REG_REG, 0, 0,                0,                               (X64), RM_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "shld",    3, { R32E,     R32,    R8   }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				                                    NO_VEX, NO_EVEX, 1, 1, { 0xa5, 0x00, 0x00 }, 4, 1, MOD_REG_REG, 0, 0,                0,                               (X64), RM_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "shld",    3, { R32,      R32E,   R8   }, GP3, (REX | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				                                    NO_VEX, NO_EVEX, 1, 1, { 0xa5, 0x00, 0x00 }, 4, 1, MOD_REG_REG, 0, 0,                0,                               (X64), RM_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "shld",    3, { R64,      R64,    R8   }, GP3, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		                                        NO_VEX, NO_EVEX, 1, 1, { 0xa5, 0x00, 0x00 }, 8, 1, MOD_REG_REG, 0, 0,                0,                               (X64), RM_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "shld",    3, { R64_RAX,  R64,    R8   }, GP3, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		                                        NO_VEX, NO_EVEX, 1, 1, { 0xa5, 0x00, 0x00 }, 8, 1, MOD_REG_REG, 0, 0,                0,                               (X64), RM_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "shld",    3, { R64,      R64_RAX,R8   }, GP3, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		                                        NO_VEX, NO_EVEX, 1, 1, { 0xa5, 0x00, 0x00 }, 8, 1, MOD_REG_REG, 0, 0,                0,                               (X64), RM_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "shld",    3, { R64_RAX,  R64_RAX,R8   }, GP3, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		                                        NO_VEX, NO_EVEX, 1, 1, { 0xa5, 0x00, 0x00 }, 8, 1, MOD_REG_REG, 0, 0,                0,                               (X64), RM_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "shld",    3, { R64E,     R64E,   R8   }, GP3, (REX | REXR | REXB | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),                             NO_VEX, NO_EVEX, 1, 1, { 0xa5, 0x00, 0x00 }, 8, 1, MOD_REG_REG, 0, 0,                0,                               (X64), RM_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "shld",    3, { R64,      R64E,   R8   }, GP3, (REX | REXR | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		                                NO_VEX, NO_EVEX, 1, 1, { 0xa5, 0x00, 0x00 }, 8, 1, MOD_REG_REG, 0, 0,                0,                               (X64), RM_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "shld",    3, { R64E,     R64,    R8   }, GP3, (REX | REXB | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		                                NO_VEX, NO_EVEX, 1, 1, { 0xa5, 0x00, 0x00 }, 8, 1, MOD_REG_REG, 0, 0,                0,                               (X64), RM_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "shld",    3, { M_ANY,    R16,    R8   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                                                    NO_VEX, NO_EVEX, 1, 1, { 0xa5, 0x00, 0x00 }, 2, 1, MOD_MEM_REG, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  PFX_0xF, NO_IMM,     MEM_OPND_0, P_86,  0, NULL },
{ "shld",    3, { M_ANY,    R16_AX, R8   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                                                    NO_VEX, NO_EVEX, 1, 1, { 0xa5, 0x00, 0x00 }, 2, 1, MOD_MEM_REG, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  PFX_0xF, NO_IMM,     MEM_OPND_0, P_86,  0, NULL },
{ "shld",    3, { M_ANY,    R16E,   R8   }, GP3, ALLOW_SEG | (REX | REXR) | (F_MODRM | F_MODRM_REG),	                                          NO_VEX, NO_EVEX, 1, 1, { 0xa5, 0x00, 0x00 }, 2, 1, MOD_MEM_REG, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE,             (X64), RM_DST,  PFX_0xF, NO_IMM,     MEM_OPND_0, P_64,  0, NULL },
{ "shld",    3, { M_ANY,    R32,    R8   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                                                    NO_VEX, NO_EVEX, 1, 1, { 0xa5, 0x00, 0x00 }, 4, 1, MOD_MEM_REG, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  PFX_0xF, NO_IMM,     MEM_OPND_0, P_86,  0, NULL },
{ "shld",    3, { M_ANY,    R32_EAX,R8   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                                                    NO_VEX, NO_EVEX, 1, 1, { 0xa5, 0x00, 0x00 }, 4, 1, MOD_MEM_REG, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  PFX_0xF, NO_IMM,     MEM_OPND_0, P_86,  0, NULL },
{ "shld",    3, { M_ANY,    R32E,   R8   }, GP3, ALLOW_SEG | (REX | REXR) | (F_MODRM | F_MODRM_REG),	                                          NO_VEX, NO_EVEX, 1, 1, { 0xa5, 0x00, 0x00 }, 4, 1, MOD_MEM_REG, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE,             (X64), RM_DST,  PFX_0xF, NO_IMM,     MEM_OPND_0, P_64,  0, NULL },
{ "shld",    3, { M_ANY,    R64,    R8   }, GP0, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_REG),				                                    NO_VEX, NO_EVEX, 1, 1, { 0xa5, 0x00, 0x00 }, 8, 1, MOD_MEM_REG, 0, 0,				          ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  PFX_0xF, NO_IMM,     MEM_OPND_0, P_64,  0, NULL },
{ "shld",    3, { M_ANY,    R64_RAX,R8   }, GP0, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_REG),				                                    NO_VEX, NO_EVEX, 1, 1, { 0xa5, 0x00, 0x00 }, 8, 1, MOD_MEM_REG, 0, 0,				          ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  PFX_0xF, NO_IMM,     MEM_OPND_0, P_64,  0, NULL },
{ "shld",    3, { M_ANY,    R64E,   R8   }, GP3, ALLOW_SEG | (REX | REXW | REXR) | (F_MODRM | F_MODRM_REG),	                                    NO_VEX, NO_EVEX, 1, 1, { 0xa5, 0x00, 0x00 }, 8, 1, MOD_MEM_REG, 0, 0,				          ADDR_SIZE_OVERRIDE,             (X64), RM_DST,  PFX_0xF, NO_IMM,     MEM_OPND_0, P_64,  0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//SHRD r / m16, r16, imm8 MRI Valid Valid   0F AC / r ib          
//SHRD r / m16, r16, CL   MRC Valid Valid   0F AD / r             
//SHRD r / m32, r32, imm8 MRI Valid Valid   0F AC / r ib          
//SHRD r / m64, r64, imm8 MRI Valid N.E.    REX.W + 0F AC / r ib  
//SHRD r / m32, r32, CL   MRC Valid Valid   0F AD / r             
//SHRD r / m64, r64, CL   MRC Valid N.E.    REX.W + 0F AD / r     
/* ----------------------------------------------------------------------------------------------- */
{ "shrd",    3, { R16,      R16_AX, IMM8 }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT | IMM8_ONLY),							                    NO_VEX, NO_EVEX, 2, 1, { 0xac, 0x00, 0x00 }, 1, 1, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                   (X16 | X32 | X64), RM_DST,  PFX_0xF, IMM_OPND_2,     NO_MEM,     P_86,  0, NULL },
{ "shrd",    3, { R16_AX,   R16,    IMM8 }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT | IMM8_ONLY),							                    NO_VEX, NO_EVEX, 2, 1, { 0xac, 0x00, 0x00 }, 1, 1, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                   (X16 | X32 | X64), RM_DST,  PFX_0xF, IMM_OPND_2,     NO_MEM,     P_86,  0, NULL },
{ "shrd",    3, { R16_AX,   R16_AX, IMM8 }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT | IMM8_ONLY),							                    NO_VEX, NO_EVEX, 2, 1, { 0xac, 0x00, 0x00 }, 1, 1, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                   (X16 | X32 | X64), RM_DST,  PFX_0xF, IMM_OPND_2,     NO_MEM,     P_86,  0, NULL },
{ "shrd",    3, { R16,      R16,    IMM8 }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT | IMM8_ONLY),							                    NO_VEX, NO_EVEX, 2, 1, { 0xac, 0x00, 0x00 }, 1, 1, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                   (X16 | X32 | X64), RM_DST,  PFX_0xF, IMM_OPND_2,     NO_MEM,     P_86,  0, NULL },
{ "shrd",    3, { R16E,     R16E,   IMM8 }, GP3, (REX | REXB | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT | IMM8_ONLY),           NO_VEX, NO_EVEX, 2, 1, { 0xac, 0x00, 0x00 }, 1, 1, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                               (X64), RM_DST,  PFX_0xF, IMM_OPND_2,     NO_MEM,     P_64,  0, NULL },
{ "shrd",    3, { R16E,     R16,    IMM8 }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT | IMM8_ONLY),				          NO_VEX, NO_EVEX, 2, 1, { 0xac, 0x00, 0x00 }, 1, 1, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                               (X64), RM_DST,  PFX_0xF, IMM_OPND_2,     NO_MEM,     P_64,  0, NULL },
{ "shrd",    3, { R16,      R16E,   IMM8 }, GP3, (REX | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT | IMM8_ONLY),				          NO_VEX, NO_EVEX, 2, 1, { 0xac, 0x00, 0x00 }, 1, 1, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                               (X64), RM_DST,  PFX_0xF, IMM_OPND_2,     NO_MEM,     P_64,  0, NULL },
{ "shrd",    3, { R32,      R32,    IMM8 }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT | IMM8_ONLY),							                    NO_VEX, NO_EVEX, 4, 1, { 0xac, 0x00, 0x00 }, 1, 1, MOD_REG_IMM, 0, 0,                0,                   (X16 | X32 | X64), RM_DST,  PFX_0xF, IMM_OPND_2,     NO_MEM,     P_86,  0, NULL },
{ "shrd",    3, { R32_EAX,  R32,    IMM8 }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT | IMM8_ONLY),							                    NO_VEX, NO_EVEX, 4, 1, { 0xac, 0x00, 0x00 }, 1, 1, MOD_REG_IMM, 0, 0,                0,                   (X16 | X32 | X64), RM_DST,  PFX_0xF, IMM_OPND_2,     NO_MEM,     P_86,  0, NULL },
{ "shrd",    3, { R32_EAX,  R32_EAX,IMM8 }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT | IMM8_ONLY),							                    NO_VEX, NO_EVEX, 4, 1, { 0xac, 0x00, 0x00 }, 1, 1, MOD_REG_IMM, 0, 0,                0,                   (X16 | X32 | X64), RM_DST,  PFX_0xF, IMM_OPND_2,     NO_MEM,     P_86,  0, NULL },
{ "shrd",    3, { R32,      R32_EAX,IMM8 }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT | IMM8_ONLY),							                    NO_VEX, NO_EVEX, 4, 1, { 0xac, 0x00, 0x00 }, 1, 1, MOD_REG_IMM, 0, 0,                0,                   (X16 | X32 | X64), RM_DST,  PFX_0xF, IMM_OPND_2,     NO_MEM,     P_86,  0, NULL },
{ "shrd",    3, { R32E,     R32E,   IMM8 }, GP3, (REX | REXB | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM | IMM8_ONLY),	                      NO_VEX, NO_EVEX, 4, 1, { 0xac, 0x00, 0x00 }, 1, 1, MOD_REG_IMM, 0, 0,                0,                               (X64), RM_DST,  PFX_0xF, IMM_OPND_2,     NO_MEM,     P_64,  0, NULL },
{ "shrd",    3, { R32E,     R32,    IMM8 }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT | IMM8_ONLY),				          NO_VEX, NO_EVEX, 4, 1, { 0xac, 0x00, 0x00 }, 1, 1, MOD_REG_IMM, 0, 0,                0,                               (X64), RM_DST,  PFX_0xF, IMM_OPND_2,     NO_MEM,     P_64,  0, NULL },
{ "shrd",    3, { R32,      R32E,   IMM8 }, GP3, (REX | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT | IMM8_ONLY),				          NO_VEX, NO_EVEX, 4, 1, { 0xac, 0x00, 0x00 }, 1, 1, MOD_REG_IMM, 0, 0,                0,                               (X64), RM_DST,  PFX_0xF, IMM_OPND_2,     NO_MEM,     P_64,  0, NULL },
{ "shrd",    3, { R64,      R64,    IMM8 }, GP3, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT | IMM8_ONLY),		              NO_VEX, NO_EVEX, 1, 1, { 0xac, 0x00, 0x00 }, 8, 1, MOD_REG_IMM, 0, 0,                0,                               (X64), RM_DST,  PFX_0xF, IMM_OPND_2,     NO_MEM,     P_64,  0, NULL },
{ "shrd",    3, { R64_RAX,  R64,    IMM8 }, GP3, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT | IMM8_ONLY),		              NO_VEX, NO_EVEX, 1, 1, { 0xac, 0x00, 0x00 }, 8, 1, MOD_REG_IMM, 0, 0,                0,                               (X64), RM_DST,  PFX_0xF, IMM_OPND_2,     NO_MEM,     P_64,  0, NULL },
{ "shrd",    3, { R64,      R64_RAX,IMM8 }, GP3, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT | IMM8_ONLY),		              NO_VEX, NO_EVEX, 1, 1, { 0xac, 0x00, 0x00 }, 8, 1, MOD_REG_IMM, 0, 0,                0,                               (X64), RM_DST,  PFX_0xF, IMM_OPND_2,     NO_MEM,     P_64,  0, NULL },
{ "shrd",    3, { R64_RAX,  R64_RAX,IMM8 }, GP3, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT | IMM8_ONLY),		              NO_VEX, NO_EVEX, 1, 1, { 0xac, 0x00, 0x00 }, 8, 1, MOD_REG_IMM, 0, 0,                0,                               (X64), RM_DST,  PFX_0xF, IMM_OPND_2,     NO_MEM,     P_64,  0, NULL },
{ "shrd",    3, { R64E,     R64E,   IMM8 }, GP3, (REX | REXR | REXB | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM | IMM8_ONLY),                 NO_VEX, NO_EVEX, 1, 1, { 0xac, 0x00, 0x00 }, 8, 1, MOD_REG_IMM, 0, 0,                0,                               (X64), RM_DST,  PFX_0xF, IMM_OPND_2,     NO_MEM,     P_64,  0, NULL },
{ "shrd",    3, { R64,      R64E,   IMM8 }, GP3, (REX | REXR | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT | IMM8_ONLY),		        NO_VEX, NO_EVEX, 1, 1, { 0xac, 0x00, 0x00 }, 8, 1, MOD_REG_IMM, 0, 0,                0,                               (X64), RM_DST,  PFX_0xF, IMM_OPND_2,     NO_MEM,     P_64,  0, NULL },
{ "shrd",    3, { R64E,     R64,    IMM8 }, GP3, (REX | REXB | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT | IMM8_ONLY),		        NO_VEX, NO_EVEX, 1, 1, { 0xac, 0x00, 0x00 }, 8, 1, MOD_REG_IMM, 0, 0,                0,                               (X64), RM_DST,  PFX_0xF, IMM_OPND_2,     NO_MEM,     P_64,  0, NULL },
{ "shrd",    3, { M_ANY,    R16,    IMM8 }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG | OPCODE_EXT | IMM8_ONLY),				                          NO_VEX, NO_EVEX, 1, 1, { 0xac, 0x00, 0x00 }, 2, 1, MOD_MEM_IMM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  PFX_0xF, IMM_OPND_2,     MEM_OPND_0, P_86,  0, NULL },
{ "shrd",    3, { M_ANY,    R16_AX, IMM8 }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG | OPCODE_EXT | IMM8_ONLY),				                          NO_VEX, NO_EVEX, 1, 1, { 0xac, 0x00, 0x00 }, 2, 1, MOD_MEM_IMM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  PFX_0xF, IMM_OPND_2,     MEM_OPND_0, P_86,  0, NULL },
{ "shrd",    3, { M_ANY,    R16E,   IMM8 }, GP3, ALLOW_SEG | (REX | REXR) | (F_MODRM | F_MODRM_REG | IMM8_ONLY),	                              NO_VEX, NO_EVEX, 1, 1, { 0xac, 0x00, 0x00 }, 2, 1, MOD_MEM_IMM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE,             (X64), RM_DST,  PFX_0xF, IMM_OPND_2,     MEM_OPND_0, P_64,  0, NULL },
{ "shrd",    3, { M_ANY,    R32,    IMM8 }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG | OPCODE_EXT | IMM8_ONLY),				                          NO_VEX, NO_EVEX, 1, 1, { 0xac, 0x00, 0x00 }, 4, 1, MOD_MEM_IMM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  PFX_0xF, IMM_OPND_2,     MEM_OPND_0, P_86,  0, NULL },
{ "shrd",    3, { M_ANY,    R32_EAX,IMM8 }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG | OPCODE_EXT | IMM8_ONLY),				                          NO_VEX, NO_EVEX, 1, 1, { 0xac, 0x00, 0x00 }, 4, 1, MOD_MEM_IMM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  PFX_0xF, IMM_OPND_2,     MEM_OPND_0, P_86,  0, NULL },
{ "shrd",    3, { M_ANY,    R32E,   IMM8 }, GP3, ALLOW_SEG | (REX | REXR) | (F_MODRM | F_MODRM_REG | OPCODE_EXT | IMM8_ONLY),	                  NO_VEX, NO_EVEX, 1, 1, { 0xac, 0x00, 0x00 }, 4, 1, MOD_MEM_IMM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE,             (X64), RM_DST,  PFX_0xF, IMM_OPND_2,     MEM_OPND_0, P_64,  0, NULL },
{ "shrd",    3, { M_ANY,    R64,    IMM8 }, GP0, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_REG | OPCODE_EXT | IMM8_ONLY),				            NO_VEX, NO_EVEX, 1, 1, { 0xac, 0x00, 0x00 }, 8, 1, MOD_MEM_IMM, 0, 0,				          ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  PFX_0xF, IMM_OPND_2,     MEM_OPND_0, P_64,  0, NULL },
{ "shrd",    3, { M_ANY,    R64_RAX,IMM8 }, GP0, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_REG | OPCODE_EXT | IMM8_ONLY),				            NO_VEX, NO_EVEX, 1, 1, { 0xac, 0x00, 0x00 }, 8, 1, MOD_MEM_IMM, 0, 0,				          ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  PFX_0xF, IMM_OPND_2,     MEM_OPND_0, P_64,  0, NULL },
{ "shrd",    3, { M_ANY,    R64E,   IMM8 }, GP3, ALLOW_SEG | (REX | REXW | REXR) | (F_MODRM | F_MODRM_REG | OPCODE_EXT | IMM8_ONLY),	          NO_VEX, NO_EVEX, 1, 1, { 0xac, 0x00, 0x00 }, 8, 1, MOD_MEM_IMM, 0, 0,				          ADDR_SIZE_OVERRIDE,             (X64), RM_DST,  PFX_0xF, IMM_OPND_2,     MEM_OPND_0, P_64,  0, NULL },
{ "shrd",    3, { R16,      R16,    R8   }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                                            NO_VEX, NO_EVEX, 1, 1, { 0xad, 0x00, 0x00 }, 2, 1, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                   (X16 | X32 | X64), RM_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "shrd",    3, { R16,      R16_AX, R8   }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                                            NO_VEX, NO_EVEX, 1, 1, { 0xad, 0x00, 0x00 }, 2, 1, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                   (X16 | X32 | X64), RM_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "shrd",    3, { R16_AX,   R16,    R8   }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                                            NO_VEX, NO_EVEX, 1, 1, { 0xad, 0x00, 0x00 }, 2, 1, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                   (X16 | X32 | X64), RM_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "shrd",    3, { R16_AX,   R16_AX, R8   }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                                            NO_VEX, NO_EVEX, 1, 1, { 0xad, 0x00, 0x00 }, 2, 1, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                   (X16 | X32 | X64), RM_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "shrd",    3, { R16E,     R16E,   R8   }, GP3, (REX | REXB | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),                                    NO_VEX, NO_EVEX, 1, 1, { 0xad, 0x00, 0x00 }, 2, 1, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                               (X64), RM_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "shrd",    3, { R16E,     R16,    R8   }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				                                    NO_VEX, NO_EVEX, 1, 1, { 0xad, 0x00, 0x00 }, 2, 1, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                               (X64), RM_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "shrd",    3, { R16,      R16E,   R8   }, GP3, (REX | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				                                    NO_VEX, NO_EVEX, 1, 1, { 0xad, 0x00, 0x00 }, 2, 1, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                               (X64), RM_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "shrd",    3, { R32,      R32,    R8   }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                                            NO_VEX, NO_EVEX, 1, 1, { 0xad, 0x00, 0x00 }, 4, 1, MOD_REG_REG, 0, 0,                0,                   (X16 | X32 | X64), RM_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "shrd",    3, { R32_EAX,  R32,    R8   }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                                            NO_VEX, NO_EVEX, 1, 1, { 0xad, 0x00, 0x00 }, 4, 1, MOD_REG_REG, 0, 0,                0,                   (X16 | X32 | X64), RM_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "shrd",    3, { R32_EAX,  R32_EAX,R8   }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                                            NO_VEX, NO_EVEX, 1, 1, { 0xad, 0x00, 0x00 }, 4, 1, MOD_REG_REG, 0, 0,                0,                   (X16 | X32 | X64), RM_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "shrd",    3, { R32,      R32_EAX,R8   }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                                            NO_VEX, NO_EVEX, 1, 1, { 0xad, 0x00, 0x00 }, 4, 1, MOD_REG_REG, 0, 0,                0,                   (X16 | X32 | X64), RM_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "shrd",    3, { R32E,     R32E,   R8   }, GP3, (REX | REXB | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),	                                  NO_VEX, NO_EVEX, 1, 1, { 0xad, 0x00, 0x00 }, 4, 1, MOD_REG_REG, 0, 0,                0,                               (X64), RM_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "shrd",    3, { R32E,     R32,    R8   }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				                                    NO_VEX, NO_EVEX, 1, 1, { 0xad, 0x00, 0x00 }, 4, 1, MOD_REG_REG, 0, 0,                0,                               (X64), RM_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "shrd",    3, { R32,      R32E,   R8   }, GP3, (REX | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				                                    NO_VEX, NO_EVEX, 1, 1, { 0xad, 0x00, 0x00 }, 4, 1, MOD_REG_REG, 0, 0,                0,                               (X64), RM_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "shrd",    3, { R64,      R64,    R8   }, GP3, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		                                        NO_VEX, NO_EVEX, 1, 1, { 0xad, 0x00, 0x00 }, 8, 1, MOD_REG_REG, 0, 0,                0,                               (X64), RM_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "shrd",    3, { R64_RAX,  R64,    R8   }, GP3, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		                                        NO_VEX, NO_EVEX, 1, 1, { 0xad, 0x00, 0x00 }, 8, 1, MOD_REG_REG, 0, 0,                0,                               (X64), RM_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "shrd",    3, { R64,      R64_RAX,R8   }, GP3, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		                                        NO_VEX, NO_EVEX, 1, 1, { 0xad, 0x00, 0x00 }, 8, 1, MOD_REG_REG, 0, 0,                0,                               (X64), RM_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "shrd",    3, { R64_RAX,  R64_RAX,R8   }, GP3, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		                                        NO_VEX, NO_EVEX, 1, 1, { 0xad, 0x00, 0x00 }, 8, 1, MOD_REG_REG, 0, 0,                0,                               (X64), RM_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "shrd",    3, { R64E,     R64E,   R8   }, GP3, (REX | REXR | REXB | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),                             NO_VEX, NO_EVEX, 1, 1, { 0xad, 0x00, 0x00 }, 8, 1, MOD_REG_REG, 0, 0,                0,                               (X64), RM_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "shrd",    3, { R64,      R64E,   R8   }, GP3, (REX | REXR | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		                                NO_VEX, NO_EVEX, 1, 1, { 0xad, 0x00, 0x00 }, 8, 1, MOD_REG_REG, 0, 0,                0,                               (X64), RM_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "shrd",    3, { R64E,     R64,    R8   }, GP3, (REX | REXB | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		                                NO_VEX, NO_EVEX, 1, 1, { 0xad, 0x00, 0x00 }, 8, 1, MOD_REG_REG, 0, 0,                0,                               (X64), RM_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "shrd",    3, { M_ANY,    R16,    R8   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                                                    NO_VEX, NO_EVEX, 1, 1, { 0xad, 0x00, 0x00 }, 2, 1, MOD_MEM_REG, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  PFX_0xF, NO_IMM,     MEM_OPND_0, P_86,  0, NULL },
{ "shrd",    3, { M_ANY,    R16_AX, R8   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                                                    NO_VEX, NO_EVEX, 1, 1, { 0xad, 0x00, 0x00 }, 2, 1, MOD_MEM_REG, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  PFX_0xF, NO_IMM,     MEM_OPND_0, P_86,  0, NULL },
{ "shrd",    3, { M_ANY,    R16E,   R8   }, GP3, ALLOW_SEG | (REX | REXR) | (F_MODRM | F_MODRM_REG),	                                          NO_VEX, NO_EVEX, 1, 1, { 0xad, 0x00, 0x00 }, 2, 1, MOD_MEM_REG, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE,             (X64), RM_DST,  PFX_0xF, NO_IMM,     MEM_OPND_0, P_64,  0, NULL },
{ "shrd",    3, { M_ANY,    R32,    R8   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                                                    NO_VEX, NO_EVEX, 1, 1, { 0xad, 0x00, 0x00 }, 4, 1, MOD_MEM_REG, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  PFX_0xF, NO_IMM,     MEM_OPND_0, P_86,  0, NULL },
{ "shrd",    3, { M_ANY,    R32_EAX,R8   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                                                    NO_VEX, NO_EVEX, 1, 1, { 0xad, 0x00, 0x00 }, 4, 1, MOD_MEM_REG, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  PFX_0xF, NO_IMM,     MEM_OPND_0, P_86,  0, NULL },
{ "shrd",    3, { M_ANY,    R32E,   R8   }, GP3, ALLOW_SEG | (REX | REXR) | (F_MODRM | F_MODRM_REG),	                                          NO_VEX, NO_EVEX, 1, 1, { 0xad, 0x00, 0x00 }, 4, 1, MOD_MEM_REG, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE,             (X64), RM_DST,  PFX_0xF, NO_IMM,     MEM_OPND_0, P_64,  0, NULL },
{ "shrd",    3, { M_ANY,    R64,    R8   }, GP0, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_REG),				                                    NO_VEX, NO_EVEX, 1, 1, { 0xad, 0x00, 0x00 }, 8, 1, MOD_MEM_REG, 0, 0,				          ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  PFX_0xF, NO_IMM,     MEM_OPND_0, P_64,  0, NULL },
{ "shrd",    3, { M_ANY,    R64_RAX,R8   }, GP0, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_REG),				                                    NO_VEX, NO_EVEX, 1, 1, { 0xad, 0x00, 0x00 }, 8, 1, MOD_MEM_REG, 0, 0,				          ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  PFX_0xF, NO_IMM,     MEM_OPND_0, P_64,  0, NULL },
{ "shrd",    3, { M_ANY,    R64E,   R8   }, GP3, ALLOW_SEG | (REX | REXW | REXR) | (F_MODRM | F_MODRM_REG),	                                    NO_VEX, NO_EVEX, 1, 1, { 0xad, 0x00, 0x00 }, 8, 1, MOD_MEM_REG, 0, 0,				          ADDR_SIZE_OVERRIDE,             (X64), RM_DST,  PFX_0xF, NO_IMM,     MEM_OPND_0, P_64,  0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//SYSENTER ZO  0F 34   Valid Valid Fast call to privilege level 0 system procedures
//SYSEXIT 0F 35 ZO Valid Valid
//SYSEXIT REX.W + 0F 35 ZO Valid Valid
/* ----------------------------------------------------------------------------------------------- */
{ "sysenter",    0, { OP_N,     OP_N    }, GP2, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 1, { 0x34, 0x00, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32 | X64), NO_DST, PFX_0xF, NO_IMM, NO_MEM, P_686, 0, NULL },
{ "sysexit",     0, { OP_N,     OP_N    }, GP4, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 1, { 0x35, 0x00, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32 | X64), NO_DST, PFX_0xF, NO_IMM, NO_MEM, P_686, 0, NULL },
{ "sysexit",     0, { OP_N,     OP_N    }, GP3, (REX | REXW),														NO_VEX, NO_EVEX, 1, 1, { 0x35, 0x00, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32 | X64), NO_DST, PFX_0xF, NO_IMM, NO_MEM, P_64, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//XADD r/m8,   r8   0F C0 /r             MR Valid Valid Exchange r8 and r/m8; load sum into r/m8.
//XADD r/m8*, r8*   REX + 0F C0 /r       MR Valid N.E.  Exchange r8 and r/m8; load sum into r/m8.
//XADD r/m16, r16   0F C1 /r             MR Valid Valid Exchange r16 and r/m16; load sum into r/m16.
//XADD r/m32, r32   0F C1 /r             MR Valid Valid Exchange r32 and r/m32; load sum into r/m32.
//XADD r/m64, r64   REX.W + 0F C1 /r     MR Valid N.E.  Exchange r64 and r/m64; load sum into r/m64.
/* ----------------------------------------------------------------------------------------------- */
{ "xadd",    2, { R8,       R8      }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),                                   NO_VEX, NO_EVEX, 1, 1, { 0xc0, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                   (X16 | X32 | X64), RM_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "xadd",    2, { R8,       R8H     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),		                                NO_VEX, NO_EVEX, 1, 1, { 0xc0, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                   (X16 | X32 | X64), RM_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "xadd",    2, { R8H,      R8      }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),		                                NO_VEX, NO_EVEX, 1, 1, { 0xc0, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                   (X16 | X32 | X64), RM_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "xadd",    2, { R8H,      R8H     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),		                                NO_VEX, NO_EVEX, 1, 1, { 0xc0, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                   (X16 | X32 | X64), RM_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "xadd",    2, { R8E,      R8E     }, GP3, (REX | REXB | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		          NO_VEX, NO_EVEX, 1, 1, { 0xc0, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                               (X64), RM_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "xadd",    2, { R8,       R8E     }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				            NO_VEX, NO_EVEX, 1, 1, { 0xc0, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                               (X64), RM_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "xadd",    2, { R8E,      R8      }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				            NO_VEX, NO_EVEX, 1, 1, { 0xc0, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                               (X64), RM_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "xadd",    2, { R8U,      R8      }, GP3, (REX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),					                  NO_VEX, NO_EVEX, 1, 1, { 0xc0, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                               (X64), RM_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "xadd",    2, { R8U,      R8U     }, GP3, (REX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),					                  NO_VEX, NO_EVEX, 1, 1, { 0xc0, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                               (X64), RM_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "xadd",    2, { R8U,      R8E     }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),					          NO_VEX, NO_EVEX, 1, 1, { 0xc0, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                               (X64), RM_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "xadd",    2, { R8E,      R8U     }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),					          NO_VEX, NO_EVEX, 1, 1, { 0xc0, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                               (X64), RM_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "xadd",    2, { R8,       R8U     }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),					                  NO_VEX, NO_EVEX, 1, 1, { 0xc0, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                               (X64), RM_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "xadd",    2, { R16,      R16     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                      NO_VEX, NO_EVEX, 1, 1, { 0xc1, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                   (X16 | X32 | X64), RM_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "xadd",    2, { R16E,     R16E    }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		          NO_VEX, NO_EVEX, 1, 1, { 0xc1, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                               (X64), RM_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "xadd",    2, { R16E,     R16     }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				            NO_VEX, NO_EVEX, 1, 1, { 0xc1, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                               (X64), RM_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "xadd",    2, { R16,      R16E    }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				            NO_VEX, NO_EVEX, 1, 1, { 0xc1, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                               (X64), RM_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "xadd",    2, { R32,      R32     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                      NO_VEX, NO_EVEX, 1, 1, { 0xc1, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                   (X16 | X32 | X64), RM_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "xadd",    2, { R32E,     R32E    }, GP3, (REX | REXB | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		          NO_VEX, NO_EVEX, 1, 1, { 0xc1, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                               (X64), RM_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "xadd",    2, { R32E,     R32     }, GP3, (REX | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				            NO_VEX, NO_EVEX, 1, 1, { 0xc1, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                               (X64), RM_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "xadd",    2, { R32,      R32E    }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				            NO_VEX, NO_EVEX, 1, 1, { 0xc1, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                               (X64), RM_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "xadd",    2, { R64,      R64     }, GP3, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		                NO_VEX, NO_EVEX, 1, 1, { 0xc1, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                               (X64), RM_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "xadd",    2, { R64E,     R64E    }, GP3, (REX | REXR | REXB | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),      NO_VEX, NO_EVEX, 1, 1, { 0xc1, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                               (X64), RM_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "xadd",    2, { R64,      R64E    }, GP3, (REX | REXB | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		          NO_VEX, NO_EVEX, 1, 1, { 0xc1, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                               (X64), RM_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "xadd",    2, { R64E,     R64     }, GP3, (REX | REXR | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		          NO_VEX, NO_EVEX, 1, 1, { 0xc1, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                               (X64), RM_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "xadd",    2, { M_ANY,    R8      }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                            NO_VEX, NO_EVEX, 1, 1, { 0xc1, 0x00, 0x00 }, 1, 0, MOD_MEM_REG, 0, 0,				          ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,   PFX_0xF, NO_IMM,     MEM_OPND_0, P_86,  0, NULL },
{ "xadd",    2, { M_ANY,    R8H     }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                            NO_VEX, NO_EVEX, 1, 1, { 0xc1, 0x00, 0x00 }, 1, 0, MOD_MEM_REG, 0, 0,				          ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,   PFX_0xF, NO_IMM,     MEM_OPND_0, P_86,  0, NULL },
{ "xadd",    2, { M_ANY,    R8E     }, GP3, ALLOW_SEG | (REX | REXR) | (F_MODRM | F_MODRM_REG),	                    NO_VEX, NO_EVEX, 1, 1, { 0xc1, 0x00, 0x00 }, 1, 0, MOD_MEM_REG, 0, 0,				          ADDR_SIZE_OVERRIDE,             (X64), RM_DST,   PFX_0xF, NO_IMM,     MEM_OPND_0, P_64,  0, NULL },
{ "xadd",    2, { M_ANY,    R8U     }, GP3, ALLOW_SEG | (REX) | (F_MODRM | F_MODRM_REG),						                NO_VEX, NO_EVEX, 1, 1, { 0xc1, 0x00, 0x00 }, 1, 0, MOD_MEM_REG, 0, 0,				          ADDR_SIZE_OVERRIDE,             (X64), RM_DST,   PFX_0xF, NO_IMM,     MEM_OPND_0, P_64,  0, NULL },
{ "xadd",    2, { M_ANY,    R16     }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                            NO_VEX, NO_EVEX, 1, 1, { 0xc1, 0x00, 0x00 }, 2, 0, MOD_MEM_REG, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,   PFX_0xF, NO_IMM,     MEM_OPND_0, P_86,  0, NULL },
{ "xadd",    2, { M_ANY,    R16E    }, GP3, ALLOW_SEG | (REX | REXR) | (F_MODRM | F_MODRM_REG),	                    NO_VEX, NO_EVEX, 1, 1, { 0xc1, 0x00, 0x00 }, 2, 0, MOD_MEM_REG, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE,             (X64), RM_DST,   PFX_0xF, NO_IMM,     MEM_OPND_0, P_64,  0, NULL },
{ "xadd",    2, { M_ANY,    R32     }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                            NO_VEX, NO_EVEX, 1, 1, { 0xc1, 0x00, 0x00 }, 4, 0, MOD_MEM_REG, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,   PFX_0xF, NO_IMM,     MEM_OPND_0, P_86,  0, NULL },
{ "xadd",    2, { M_ANY,    R32E    }, GP3, ALLOW_SEG | (REX | REXR) | (F_MODRM | F_MODRM_REG),	                    NO_VEX, NO_EVEX, 1, 1, { 0xc1, 0x00, 0x00 }, 4, 0, MOD_MEM_REG, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE,             (X64), RM_DST,   PFX_0xF, NO_IMM,     MEM_OPND_0, P_64,  0, NULL },
{ "xadd",    2, { M_ANY,    R64     }, GP3, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_REG),			                NO_VEX, NO_EVEX, 1, 1, { 0xc1, 0x00, 0x00 }, 8, 0, MOD_MEM_REG, 0, 0,				          ADDR_SIZE_OVERRIDE,             (X64), RM_DST,   PFX_0xF, NO_IMM,     MEM_OPND_0, P_64,  0, NULL },
{ "xadd",    2, { M_ANY,    R64E    }, GP3, ALLOW_SEG | (REX | REXW | REXR) | (F_MODRM | F_MODRM_REG),	            NO_VEX, NO_EVEX, 1, 1, { 0xc1, 0x00, 0x00 }, 8, 0, MOD_MEM_REG, 0, 0,				          ADDR_SIZE_OVERRIDE,             (X64), RM_DST,   PFX_0xF, NO_IMM,     MEM_OPND_0, P_64,  0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//XCHG AX,  r16      90+rw             O  Valid Valid        Exchange r16 with AX.
//XCHG EAX, r32      90+rd             O  Valid Valid        Exchange r32 with EAX.
//XCHG RAX, r64      REX.W + 90+rd     O  Valid N.E.         Exchange r64 with RAX.
//XCHG r16, AX       90+rw             O  Valid Valid        Exchange AX with r16.
//XCHG r32, EAX      90+rd             O  Valid Valid        Exchange EAX with r32.
//XCHG r64, RAX      REX.W + 90+rd     O  Valid N.E.         Exchange RAX with r64.
//XCHG r/m8, r8      86 /r             MR Valid Valid        Exchange r8r/m8. (byte register) with byte from
//XCHG r/m8*, r8*    REX + 86 /r       MR Valid N.E.         Exchange r8r/m8. (byte register) with byte from
//XCHG r8, r/m8      86 /r             RM Valid Valid        Exchange byte from r/m8 with r8 (byte register).
//XCHG r8*, r/m8*    REX + 86 /r       RM Valid N.E.         Exchange byte from r/m8 with r8 (byte register).
//XCHG r/m16, r16    87 /r             MR Valid Valid        Exchange r16 with word from r/m16.
//XCHG r16, r/m16    87 /r             RM Valid Valid        Exchange word from r/m16 with r16.
//XCHG r/m32, r32    87 /r             MR Valid Valid        Exchange r32 with doubleword from r/m32.
//XCHG r/m64, r64    REX.W + 87 /r     MR Valid N.E.         Exchange r64 with quadword from r/m64.
//XCHG r32, r/m32    87 /r             RM Valid Valid        Exchange doubleword from r/m32 with r32.
//XCHG r64, r/m64    REX.W + 87 /r     RM Valid N.E.         Exchange quadword from r/m64 with r64.
/* ----------------------------------------------------------------------------------------------- */
{ "xchg",    2, { R16_AX,   R16     }, GP0, (F_OPCODE_REG2),												                                NO_VEX, NO_EVEX, 1, 1, { 0x90, 0x00, 0x00 }, 2, 0, NO_MOD,      0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM, NO_MEM,     P_86,  0, NULL },
{ "xchg",    2, { R16_AX,   R16E    }, GP0, (REX | REXB) | (F_OPCODE_REG2),												                  NO_VEX, NO_EVEX, 1, 1, { 0x90, 0x00, 0x00 }, 2, 0, NO_MOD,      0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM, NO_MEM,     P_86,  0, NULL },
{ "xchg",    2, { R32_EAX,  R32     }, GP0, (F_OPCODE_REG2),												                                NO_VEX, NO_EVEX, 1, 1, { 0x90, 0x00, 0x00 }, 4, 0, NO_MOD,      0, 0, 0,                                 (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM, NO_MEM,     P_86,  0, NULL },
{ "xchg",    2, { R32_EAX,  R32E    }, GP0, (REX | REXB) | (F_OPCODE_REG2),												                  NO_VEX, NO_EVEX, 1, 1, { 0x90, 0x00, 0x00 }, 4, 0, NO_MOD,      0, 0, 0,                                 (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM, NO_MEM,     P_86,  0, NULL },
{ "xchg",    2, { R64_RAX,  R64     }, GP3, (REX | REXW) | (F_OPCODE_REG2),						                              NO_VEX, NO_EVEX, 1, 1, { 0x90, 0x00, 0x00 }, 8, 0, NO_MOD,      0, 0,				        0,                               (X64), NO_DST,  NO_PREFIX, NO_IMM, NO_MEM,     P_64,  0, NULL },
{ "xchg",    2, { R64_RAX,  R64E    }, GP3, (REX | REXW | REXB) | (F_OPCODE_REG2),						                      NO_VEX, NO_EVEX, 1, 1, { 0x90, 0x00, 0x00 }, 8, 0, NO_MOD,      0, 0,				        0,                               (X64), NO_DST,  NO_PREFIX, NO_IMM, NO_MEM,     P_64,  0, NULL },
{ "xchg",    2, { R16,   R16_AX     }, GP0, (F_OPCODE_REG),												                                  NO_VEX, NO_EVEX, 1, 1, { 0x90, 0x00, 0x00 }, 2, 0, NO_MOD,      0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM, NO_MEM,     P_86,  0, NULL },
{ "xchg",    2, { R16E,  R16_AX     }, GP0, (REX | REXB)|(F_OPCODE_REG),												                    NO_VEX, NO_EVEX, 1, 1, { 0x90, 0x00, 0x00 }, 2, 0, NO_MOD,      0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM, NO_MEM,     P_86,  0, NULL },
{ "xchg",    2, { R32,   R32_EAX    }, GP0, (F_OPCODE_REG),												                                  NO_VEX, NO_EVEX, 1, 1, { 0x90, 0x00, 0x00 }, 4, 0, NO_MOD,      0, 0, 0,                                 (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM, NO_MEM,     P_86,  0, NULL },
{ "xchg",    2, { R32E,  R32_EAX    }, GP0, (REX | REXB) | (F_OPCODE_REG),												                  NO_VEX, NO_EVEX, 1, 1, { 0x90, 0x00, 0x00 }, 4, 0, NO_MOD,      0, 0, 0,                                 (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM, NO_MEM,     P_86,  0, NULL },
{ "xchg",    2, { R64,   R64_RAX    }, GP3, (REX | REXW) | (F_OPCODE_REG),						                              NO_VEX, NO_EVEX, 1, 1, { 0x90, 0x00, 0x00 }, 4, 0, NO_MOD,      0, 0,				        0,                               (X64), NO_DST,  NO_PREFIX, NO_IMM, NO_MEM,     P_64,  0, NULL },
{ "xchg",    2, { R64E,  R64_RAX    }, GP3, (REX | REXW | REXB) | (F_OPCODE_REG),						                        NO_VEX, NO_EVEX, 1, 1, { 0x90, 0x00, 0x00 }, 4, 0, NO_MOD,      0, 0,				        0,                               (X64), NO_DST,  NO_PREFIX, NO_IMM, NO_MEM,     P_64,  0, NULL },
{ "xchg",    2, { R8,       R8      }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),                                   NO_VEX, NO_EVEX, 1, 1, { 0x86, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                   (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "xchg",    2, { R8,       R8H     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),		                                NO_VEX, NO_EVEX, 1, 1, { 0x86, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                   (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "xchg",    2, { R8H,      R8      }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),		                                NO_VEX, NO_EVEX, 1, 1, { 0x86, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                   (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "xchg",    2, { R8H,      R8H     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),		                                NO_VEX, NO_EVEX, 1, 1, { 0x86, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                   (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "xchg",    2, { R8E,      R8E     }, GP3, (REX | REXB | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		          NO_VEX, NO_EVEX, 1, 1, { 0x86, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "xchg",    2, { R8,       R8E     }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				            NO_VEX, NO_EVEX, 1, 1, { 0x86, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "xchg",    2, { R8E,      R8      }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				            NO_VEX, NO_EVEX, 1, 1, { 0x86, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "xchg",    2, { R8U,      R8      }, GP3, (REX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),					                  NO_VEX, NO_EVEX, 1, 1, { 0x86, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "xchg",    2, { R8U,      R8U     }, GP3, (REX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),					                  NO_VEX, NO_EVEX, 1, 1, { 0x86, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "xchg",    2, { R8U,      R8E     }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),					          NO_VEX, NO_EVEX, 1, 1, { 0x86, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "xchg",    2, { R8E,      R8U     }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),					          NO_VEX, NO_EVEX, 1, 1, { 0x86, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "xchg",    2, { R8,       R8U     }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),					          NO_VEX, NO_EVEX, 1, 1, { 0x86, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "xchg",    2, { R16,      R16     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                      NO_VEX, NO_EVEX, 1, 1, { 0x87, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                   (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "xchg",    2, { R16E,     R16E    }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		                NO_VEX, NO_EVEX, 1, 1, { 0x87, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "xchg",    2, { R16E,     R16     }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				            NO_VEX, NO_EVEX, 1, 1, { 0x87, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "xchg",    2, { R16,      R16E    }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				            NO_VEX, NO_EVEX, 1, 1, { 0x87, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "xchg",    2, { R32,      R32     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                      NO_VEX, NO_EVEX, 1, 1, { 0x87, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                   (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "xchg",    2, { R32E,     R32E    }, GP3, (REX | REXB | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		          NO_VEX, NO_EVEX, 1, 1, { 0x87, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "xchg",    2, { R32E,     R32     }, GP3, (REX | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				            NO_VEX, NO_EVEX, 1, 1, { 0x87, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "xchg",    2, { R32,      R32E    }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				            NO_VEX, NO_EVEX, 1, 1, { 0x87, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "xchg",    2, { R64,      R64     }, GP3, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		                NO_VEX, NO_EVEX, 1, 1, { 0x87, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "xchg",    2, { R64E,     R64E    }, GP3, (REX | REXR | REXB | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),      NO_VEX, NO_EVEX, 1, 1, { 0x87, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "xchg",    2, { R64,      R64E    }, GP3, (REX | REXB | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		          NO_VEX, NO_EVEX, 1, 1, { 0x87, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "xchg",    2, { R64E,     R64     }, GP3, (REX | REXR | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		          NO_VEX, NO_EVEX, 1, 1, { 0x87, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "xchg",    2, { M_ANY,    R8      }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                            NO_VEX, NO_EVEX, 1, 1, { 0x86, 0x00, 0x00 }, 1, 0, MOD_MEM_REG, 0, 0,				          ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,   NO_PREFIX, NO_IMM,     MEM_OPND_0, P_86,  0, NULL },
{ "xchg",    2, { M_ANY,    R8H     }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                            NO_VEX, NO_EVEX, 1, 1, { 0x86, 0x00, 0x00 }, 1, 0, MOD_MEM_REG, 0, 0,				          ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,   NO_PREFIX, NO_IMM,     MEM_OPND_0, P_86,  0, NULL },
{ "xchg",    2, { M_ANY,    R8E     }, GP3, ALLOW_SEG | (REX | REXR) | (F_MODRM | F_MODRM_REG),	                    NO_VEX, NO_EVEX, 1, 1, { 0x86, 0x00, 0x00 }, 1, 0, MOD_MEM_REG, 0, 0,				          ADDR_SIZE_OVERRIDE,             (X64), RM_DST,   NO_PREFIX, NO_IMM,     MEM_OPND_0, P_64,  0, NULL },
{ "xchg",    2, { M_ANY,    R8U     }, GP3, ALLOW_SEG | (REX) | (F_MODRM | F_MODRM_REG),						                NO_VEX, NO_EVEX, 1, 1, { 0x86, 0x00, 0x00 }, 1, 0, MOD_MEM_REG, 0, 0,				          ADDR_SIZE_OVERRIDE,             (X64), RM_DST,   NO_PREFIX, NO_IMM,     MEM_OPND_0, P_64,  0, NULL },
{ "xchg",    2, { M_ANY,    R16     }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                            NO_VEX, NO_EVEX, 1, 1, { 0x87, 0x00, 0x00 }, 2, 0, MOD_MEM_REG, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,   NO_PREFIX, NO_IMM,     MEM_OPND_0, P_86,  0, NULL },
{ "xchg",    2, { M_ANY,    R16E    }, GP3, ALLOW_SEG | (REX | REXR) | (F_MODRM | F_MODRM_REG),	                    NO_VEX, NO_EVEX, 1, 1, { 0x87, 0x00, 0x00 }, 2, 0, MOD_MEM_REG, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE,             (X64), RM_DST,   NO_PREFIX, NO_IMM,     MEM_OPND_0, P_64,  0, NULL },
{ "xchg",    2, { M_ANY,    R32     }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                            NO_VEX, NO_EVEX, 1, 1, { 0x87, 0x00, 0x00 }, 4, 0, MOD_MEM_REG, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,   NO_PREFIX, NO_IMM,     MEM_OPND_0, P_86,  0, NULL },
{ "xchg",    2, { M_ANY,    R32E    }, GP3, ALLOW_SEG | (REX | REXR) | (F_MODRM | F_MODRM_REG),	                    NO_VEX, NO_EVEX, 1, 1, { 0x87, 0x00, 0x00 }, 4, 0, MOD_MEM_REG, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE,             (X64), RM_DST,   NO_PREFIX, NO_IMM,     MEM_OPND_0, P_64,  0, NULL },
{ "xchg",    2, { M_ANY,    R64     }, GP3, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_REG),			                NO_VEX, NO_EVEX, 1, 1, { 0x87, 0x00, 0x00 }, 8, 0, MOD_MEM_REG, 0, 0,				          ADDR_SIZE_OVERRIDE,             (X64), RM_DST,   NO_PREFIX, NO_IMM,     MEM_OPND_0, P_64,  0, NULL },
{ "xchg",    2, { M_ANY,    R64E    }, GP3, ALLOW_SEG | (REX | REXW | REXR) | (F_MODRM | F_MODRM_REG),	            NO_VEX, NO_EVEX, 1, 1, { 0x87, 0x00, 0x00 }, 8, 0, MOD_MEM_REG, 0, 0,				          ADDR_SIZE_OVERRIDE,             (X64), RM_DST,   NO_PREFIX, NO_IMM,     MEM_OPND_0, P_64,  0, NULL },
{ "xchg",    2, { R8,       M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                            NO_VEX, NO_EVEX, 1, 1, { 0x86, 0x00, 0x00 }, 1, 0, MOD_REG_MEM, 0, 0,				          ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST, NO_PREFIX, NO_IMM    , MEM_OPND_1, P_86,  0, NULL },
{ "xchg",    2, { R8H,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                            NO_VEX, NO_EVEX, 1, 1, { 0x86, 0x00, 0x00 }, 1, 0, MOD_REG_MEM, 0, 0,				          ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST, NO_PREFIX, NO_IMM    , MEM_OPND_1, P_86,  0, NULL },
{ "xchg",    2, { R8E,      M_ANY   }, GP3, ALLOW_SEG | (REX | REXR) | (F_MODRM | F_MODRM_REG),	                    NO_VEX, NO_EVEX, 1, 1, { 0x86, 0x00, 0x00 }, 1, 0, MOD_REG_MEM, 0, 0,				          ADDR_SIZE_OVERRIDE,             (X64), REG_DST, NO_PREFIX, NO_IMM    , MEM_OPND_1, P_64,  0, NULL },
{ "xchg",    2, { R8U,      M_ANY   }, GP3, ALLOW_SEG | (REX) | (F_MODRM | F_MODRM_REG),						                NO_VEX, NO_EVEX, 1, 1, { 0x86, 0x00, 0x00 }, 1, 0, MOD_REG_MEM, 0, 0,				          ADDR_SIZE_OVERRIDE,             (X64), REG_DST, NO_PREFIX, NO_IMM    , MEM_OPND_1, P_64,  0, NULL },
{ "xchg",    2, { R16,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                            NO_VEX, NO_EVEX, 1, 1, { 0x87, 0x00, 0x00 }, 2, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST, NO_PREFIX, NO_IMM    , MEM_OPND_1, P_86,  0, NULL },
{ "xchg",    2, { R16E,     M_ANY   }, GP3, ALLOW_SEG | (REX | REXR) | (F_MODRM | F_MODRM_REG),	                    NO_VEX, NO_EVEX, 1, 1, { 0x87, 0x00, 0x00 }, 2, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE,             (X64), REG_DST, NO_PREFIX, NO_IMM    , MEM_OPND_1, P_64,  0, NULL },
{ "xchg",    2, { R32,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                            NO_VEX, NO_EVEX, 1, 1, { 0x87, 0x00, 0x00 }, 4, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST, NO_PREFIX, NO_IMM    , MEM_OPND_1, P_86,  0, NULL },
{ "xchg",    2, { R32E,     M_ANY   }, GP3, ALLOW_SEG | (REX | REXR) | (F_MODRM | F_MODRM_REG),	                    NO_VEX, NO_EVEX, 1, 1, { 0x87, 0x00, 0x00 }, 4, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE,             (X64), REG_DST, NO_PREFIX, NO_IMM    , MEM_OPND_1, P_64,  0, NULL },
{ "xchg",    2, { R64,      M_ANY   }, GP0, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_REG),				              NO_VEX, NO_EVEX, 1, 1, { 0x87, 0x00, 0x00 }, 8, 0, MOD_REG_MEM, 0, 0,				ADDR_SIZE_OVERRIDE,           (X16 | X32 | X64), REG_DST, NO_PREFIX, NO_IMM    , MEM_OPND_1, P_64,  0, NULL },
{ "xchg",    2, { R64E,     M_ANY   }, GP3, ALLOW_SEG | (REX | REXW | REXR) | (F_MODRM | F_MODRM_REG),	            NO_VEX, NO_EVEX, 1, 1, { 0x87, 0x00, 0x00 }, 8, 0, MOD_REG_MEM, 0, 0,				ADDR_SIZE_OVERRIDE,                       (X64), REG_DST, NO_PREFIX, NO_IMM    , MEM_OPND_1, P_64,  0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//XLAT m8 ZO D7          Valid Valid Set AL to memory byte DS : [(E)BX + unsigned AL] .
//XLATB   ZO D7          Valid Valid Set AL to memory byte DS : [(E)BX + unsigned AL] .
//XLATB   ZO REX.W + D7  Valid N.E.  Set AL to memory byte[RBX + unsigned AL].
/* ----------------------------------------------------------------------------------------------- */
{ "xlat",    0, { OP_N,     OP_N    }, GP0, (NO_FLAGS),          NO_VEX, NO_EVEX, 1, 1, { 0xd7, 0x00, 0x00 }, 1, 1, NO_MOD, 0, 0, 0, (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
{ "xlat",    1, { M_ANY,    OP_N    }, GP0, (NO_FLAGS),          NO_VEX, NO_EVEX, 1, 1, { 0xd7, 0x00, 0x00 }, 1, 1, NO_MOD, 0, 0, 0, (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
{ "xlatb",   0, { OP_N,     OP_N    }, GP0, (NO_FLAGS),          NO_VEX, NO_EVEX, 1, 1, { 0xd7, 0x00, 0x00 }, 1, 1, NO_MOD, 0, 0, 0, (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
{ "xlatb",   1, { M_ANY,    OP_N    }, GP0, (NO_FLAGS),          NO_VEX, NO_EVEX, 1, 1, { 0xd7, 0x00, 0x00 }, 1, 1, NO_MOD, 0, 0, 0, (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
  /* FPU no operand instructions */
{ "f2xm1",    0, { OP_N,     OP_N    }, FP0, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 2, { 0xd9, 0xf0, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
{ "fabs",     0, { OP_N,     OP_N    }, FP0, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 2, { 0xd9, 0xe1, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
{ "fchs",     0, { OP_N,     OP_N    }, FP0, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 2, { 0xd9, 0xe0, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
{ "fclex",    0, { OP_N,     OP_N    }, FP0, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 3, { 0x9b, 0xdb, 0xe2 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
{ "fnclex",   0, { OP_N,     OP_N    }, FP0, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 2, { 0xdb, 0xe2, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
{ "fcos",     0, { OP_N,     OP_N    }, FP0, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 2, { 0xd9, 0xff, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
{ "fdecstp",  0, { OP_N,     OP_N    }, FP0, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 2, { 0xd9, 0xf6, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
{ "fincstp",  0, { OP_N,     OP_N    }, FP0, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 2, { 0xd9, 0xf7, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
{ "finit",    0, { OP_N,     OP_N    }, FP0, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 3, { 0x9b, 0xdb, 0xe3 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
{ "fninit",   0, { OP_N,     OP_N    }, FP0, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 2, { 0xdb, 0xe3, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
{ "fld1",     0, { OP_N,     OP_N    }, FP0, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 2, { 0xd9, 0xe8, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
{ "fldl2t",   0, { OP_N,     OP_N    }, FP0, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 2, { 0xd9, 0xe9, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
{ "fldl2e",   0, { OP_N,     OP_N    }, FP0, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 2, { 0xd9, 0xea, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
{ "fldpi",    0, { OP_N,     OP_N    }, FP0, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 2, { 0xd9, 0xeb, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
{ "fldlg2",   0, { OP_N,     OP_N    }, FP0, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 2, { 0xd9, 0xec, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
{ "fldln2",   0, { OP_N,     OP_N    }, FP0, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 2, { 0xd9, 0xed, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
{ "fldz",     0, { OP_N,     OP_N    }, FP0, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 2, { 0xd9, 0xee, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
{ "fnop",     0, { OP_N,     OP_N    }, FP0, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 2, { 0xd9, 0xd0, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
{ "fpatan",   0, { OP_N,     OP_N    }, FP0, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 2, { 0xd9, 0xf3, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
{ "fprem",    0, { OP_N,     OP_N    }, FP0, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 2, { 0xd9, 0xf8, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
{ "fprem1",   0, { OP_N,     OP_N    }, FP0, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 2, { 0xd9, 0xf5, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
{ "fptan",    0, { OP_N,     OP_N    }, FP0, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 2, { 0xd9, 0xf2, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
{ "frndint",  0, { OP_N,     OP_N    }, FP0, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 2, { 0xd9, 0xfc, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
{ "fscale",   0, { OP_N,     OP_N    }, FP0, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 2, { 0xd9, 0xfd, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
{ "fsin",     0, { OP_N,     OP_N    }, FP0, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 2, { 0xd9, 0xfe, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
{ "fsincos",  0, { OP_N,     OP_N    }, FP0, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 2, { 0xd9, 0xfb, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
{ "fsqrt",    0, { OP_N,     OP_N    }, FP0, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 2, { 0xd9, 0xfa, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
{ "ftst",     0, { OP_N,     OP_N    }, FP0, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 2, { 0xd9, 0xe4, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
{ "fxam",     0, { OP_N,     OP_N    }, FP0, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 2, { 0xd9, 0xe5, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
{ "fxtract",  0, { OP_N,     OP_N    }, FP0, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 2, { 0xd9, 0xf4, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
{ "fyl2x",    0, { OP_N,     OP_N    }, FP0, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 2, { 0xd9, 0xf1, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
{ "fyl2xp1",  0, { OP_N,     OP_N    }, FP0, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 2, { 0xd9, 0xf9, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
//FCMOVB ST(0),  ST(i) DA C0 + i  Valid Valid Move if below(CF = 1).
//FCMOVE ST(0),  ST(i) DA C8 + i  Valid Valid Move if equal(ZF = 1).
//FCMOVBE ST(0), ST(i) DA D0 + i  Valid Valid Move if below or equal(CF = 1 or ZF = 1).
//FCMOVU ST(0),  ST(i) DA D8 + i  Valid Valid Move if unordered(PF = 1).
//FCMOVNB ST(0), ST(i) DB C0 + i  Valid Valid Move if not below(CF = 0).
//FCMOVNE ST(0), ST(i) DB C8 + i  Valid Valid Move if not equal(ZF = 0).
//FCMOVNBE ST(0),ST(i) DB D0 + i  Valid Valid Move if not below or equal(CF = 0 and ZF = 0).
//FCMOVNU ST(0), ST(i) DB D8 + i  Valid Valid Move if not unordered(PF = 0).
/* ----------------------------------------------------------------------------------------------- */
{ "fcmovb",   2, { R_ST,    R_STI    }, FP0, (F_OPCODE2_STI),												                           NO_VEX, NO_EVEX, 1, 2, { 0xda, 0xc0, 0x00 }, 2, 0, NO_MOD,      0, 0, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM, NO_MEM,     P_87,  0, NULL },
{ "fcmovbe",  2, { R_ST,    R_STI    }, FP0, (F_OPCODE2_STI),												                           NO_VEX, NO_EVEX, 1, 2, { 0xda, 0xd0, 0x00 }, 2, 0, NO_MOD,      0, 0, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM, NO_MEM,     P_87,  0, NULL },
{ "fcmove",   2, { R_ST,    R_STI    }, FP0, (F_OPCODE2_STI),												                           NO_VEX, NO_EVEX, 1, 2, { 0xda, 0xc8, 0x00 }, 2, 0, NO_MOD,      0, 0, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM, NO_MEM,     P_87,  0, NULL },
{ "fcmovnb",  2, { R_ST,    R_STI    }, FP0, (F_OPCODE2_STI),												                           NO_VEX, NO_EVEX, 1, 2, { 0xdb, 0xc0, 0x00 }, 2, 0, NO_MOD,      0, 0, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM, NO_MEM,     P_87,  0, NULL },
{ "fcmovnbe", 2, { R_ST,    R_STI    }, FP0, (F_OPCODE2_STI),												                           NO_VEX, NO_EVEX, 1, 2, { 0xdb, 0xd0, 0x00 }, 2, 0, NO_MOD,      0, 0, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM, NO_MEM,     P_87,  0, NULL },
{ "fcmovne",  2, { R_ST,    R_STI    }, FP0, (F_OPCODE2_STI),												                           NO_VEX, NO_EVEX, 1, 2, { 0xdb, 0xc8, 0x00 }, 2, 0, NO_MOD,      0, 0, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM, NO_MEM,     P_87,  0, NULL },
{ "fcmovnu",  2, { R_ST,    R_STI    }, FP0, (F_OPCODE2_STI),												                           NO_VEX, NO_EVEX, 1, 2, { 0xdb, 0xd8, 0x00 }, 2, 0, NO_MOD,      0, 0, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM, NO_MEM,     P_87,  0, NULL },
{ "fcmovu",   2, { R_ST,    R_STI    }, FP0, (F_OPCODE2_STI),												                           NO_VEX, NO_EVEX, 1, 2, { 0xda, 0xd8, 0x00 }, 2, 0, NO_MOD,      0, 0, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM, NO_MEM,     P_87,  0, NULL },
/* ----------------------------------------------------------------------------------------------- */
{ "fcom",     1, { R_STI,   OP_N     }, FP0, (F_OPCODE2_STI),												                           NO_VEX, NO_EVEX, 1, 2, { 0xd8, 0xd0, 0x00 }, 2, 0, NO_MOD,      0, 0, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM, NO_MEM,     P_87,  0, NULL },
{ "fcom",     1, { M32,     OP_N     }, FP0, ALLOW_SEG | (F_MODRM | F_MODRM_RM),                               NO_VEX, NO_EVEX, 1, 1, { 0xd8, 0x00, 0x00 }, 4, 1, 0x10,        0, 0, 0,                        (X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_87,  0, NULL },
{ "fcom",     1, { M64,     OP_N     }, FP0, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_RM),                NO_VEX, NO_EVEX, 1, 1, { 0xdc, 0x00, 0x00 }, 8, 1, 0x10,        0, 0, 0,                        (X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_87,  0, NULL },
{ "fcom",     0, { OP_N,    OP_N     }, FP0, (NO_FLAGS),														                           NO_VEX, NO_EVEX, 1, 2, { 0xd8, 0xd1, 0x00 }, 1, 0, NO_MOD,      0, 0, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM, NO_MEM,     P_87,  0, NULL },
/* ----------------------------------------------------------------------------------------------- */
{ "fucom",    1, { R_STI,   OP_N     }, FP0, (F_OPCODE2_STI),												                           NO_VEX, NO_EVEX, 1, 2, { 0xdd, 0xe0, 0x00 }, 2, 0, NO_MOD,      0, 0, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM, NO_MEM,     P_87,  0, NULL },
{ "fucom",    0, { OP_N,    OP_N     }, FP0, (NO_FLAGS),														                           NO_VEX, NO_EVEX, 1, 2, { 0xdd, 0xe1, 0x00 }, 1, 0, NO_MOD,      0, 0, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM, NO_MEM,     P_87,  0, NULL },
/* ----------------------------------------------------------------------------------------------- */
{ "fucomp",   1, { R_STI,   OP_N     }, FP0, (F_OPCODE2_STI),												                           NO_VEX, NO_EVEX, 1, 2, { 0xdd, 0xe8, 0x00 }, 2, 0, NO_MOD,      0, 0, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM, NO_MEM,     P_87,  0, NULL },
{ "fucomp",   0, { OP_N,    OP_N     }, FP0, (NO_FLAGS),														                           NO_VEX, NO_EVEX, 1, 2, { 0xdd, 0xe9, 0x00 }, 1, 0, NO_MOD,      0, 0, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM, NO_MEM,     P_87,  0, NULL },
/* ----------------------------------------------------------------------------------------------- */
{ "fucompp",  0, { OP_N,    OP_N     }, FP0, (NO_FLAGS),														                           NO_VEX, NO_EVEX, 1, 2, { 0xda, 0xe9, 0x00 }, 1, 0, NO_MOD,      0, 0, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM, NO_MEM,     P_87,  0, NULL },
/* ----------------------------------------------------------------------------------------------- */
{ "fcomi",    2, { R_ST,    R_STI    }, FP0, (F_OPCODE2_STI),												                           NO_VEX, NO_EVEX, 1, 2, { 0xdb, 0xf0, 0x00 }, 2, 0, NO_MOD,      0, 0, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM, NO_MEM,     P_87,  0, NULL },
{ "fcomip",   2, { R_ST,    R_STI    }, FP0, (F_OPCODE2_STI),												                           NO_VEX, NO_EVEX, 1, 2, { 0xdf, 0xf0, 0x00 }, 2, 0, NO_MOD,      0, 0, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM, NO_MEM,     P_87,  0, NULL },
{ "fucomi",   2, { R_ST,    R_STI    }, FP0, (F_OPCODE2_STI),												                           NO_VEX, NO_EVEX, 1, 2, { 0xdb, 0xe8, 0x00 }, 2, 0, NO_MOD,      0, 0, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM, NO_MEM,     P_87,  0, NULL },
{ "fucomip",  2, { R_ST,    R_STI    }, FP0, (F_OPCODE2_STI),												                           NO_VEX, NO_EVEX, 1, 2, { 0xdf, 0xe0, 0x00 }, 2, 0, NO_MOD,      0, 0, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM, NO_MEM,     P_87,  0, NULL },

/* ----------------------------------------------------------------------------------------------- */
{ "fadd",   2, { R_ST,    R_STI    }, FP0, (F_OPCODE2_STI),												                           NO_VEX, NO_EVEX, 1, 2, { 0xd8, 0xc8, 0x00 }, 2, 0, NO_MOD,      0, 0, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM, NO_MEM,     P_87,  0, NULL},
{ "fadd",   2, { R_STI,   R_ST     }, FP0, (F_OPCODE2_STI),												                           NO_VEX, NO_EVEX, 1, 2, { 0xdc, 0xc0, 0x00 }, 2, 0, NO_MOD,      0, 0, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM, NO_MEM,     P_87,  0, NULL },
{ "fadd",   1, { M32,     OP_N     }, FP0, ALLOW_SEG | (F_MODRM | F_MODRM_RM),                               NO_VEX, NO_EVEX, 1, 1, { 0xd8, 0x00, 0x00 }, 4, 1, 0x00,        0, 0, 0,                        (X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_87,  0, NULL },
{ "fadd",   1, { M64,     OP_N     }, FP0, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_RM),                NO_VEX, NO_EVEX, 1, 1, { 0xdc, 0x00, 0x00 }, 8, 1, 0x00,        0, 0, 0,                        (X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_87,  0, NULL },
{ "fadd",   0, { OP_N,    OP_N     }, FP0, (NO_FLAGS),														                           NO_VEX, NO_EVEX, 1, 2, { 0xd8, 0xc1, 0x00 }, 1, 0, NO_MOD,      0, 0, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM, NO_MEM,     P_87,  0, NULL },
{ "faddp",  2, { R_STI,   R_ST     }, FP0, (F_OPCODE2_STI),												                         NO_VEX, NO_EVEX, 1, 2, { 0xde, 0xc1, 0x00 }, 2, 0, NO_MOD,      0, 0, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM, NO_MEM,       P_87,  0, NULL },
{ "faddp",  0, { OP_N,    OP_N     }, FP0, (NO_FLAGS),														                           NO_VEX, NO_EVEX, 1, 2, { 0xd8, 0xc8, 0x00 }, 1, 0, NO_MOD,      0, 0, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM, NO_MEM,     P_87,  0, NULL },
/* ----------------------------------------------------------------------------------------------- */
{ "fmul",   2, { R_ST,    R_STI    }, FP0, (F_OPCODE2_STI),												                           NO_VEX, NO_EVEX, 1, 2, { 0xd8, 0xc8, 0x00 }, 2, 0, NO_MOD,      0, 0, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM, NO_MEM,     P_87,  0, NULL },
{ "fmul",   2, { R_STI,   R_ST     }, FP0, (F_OPCODE2_STI),												                           NO_VEX, NO_EVEX, 1, 2, { 0xdc, 0xc8, 0x00 }, 2, 0, NO_MOD,      0, 0, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM, NO_MEM,     P_87,  0, NULL },
{ "fmul",   1, { M32,     OP_N     }, FP0, ALLOW_SEG | (F_MODRM | F_MODRM_RM),                               NO_VEX, NO_EVEX, 1, 1, { 0xd8, 0x00, 0x00 }, 4, 1, 0x08,        0, 0, 0,                        (X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_87,  0, NULL },
{ "fmul",   1, { M64,     OP_N     }, FP0, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_RM),                NO_VEX, NO_EVEX, 1, 1, { 0xdc, 0x00, 0x00 }, 8, 1, 0x08,        0, 0, 0,                        (X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_87,  0, NULL },
{ "fmul",   0, { OP_N,    OP_N     }, FP0, (NO_FLAGS),														                           NO_VEX, NO_EVEX, 1, 2, { 0xde, 0xc9, 0x00 }, 1, 0, NO_MOD,      0, 0, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM, NO_MEM,     P_87,  0, NULL },
{ "fmulp",  2, { R_STI,   R_ST     }, FP0, (F_OPCODE2_STI),												                         NO_VEX, NO_EVEX, 1, 2, { 0xde, 0xc8, 0x00 }, 2, 0, NO_MOD,      0, 0, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM, NO_MEM,       P_87,  0, NULL },
{ "fmulp",  0, { OP_N,    OP_N     }, FP0, (NO_FLAGS),														                           NO_VEX, NO_EVEX, 1, 2, { 0xde, 0xc9, 0x00 }, 1, 0, NO_MOD,      0, 0, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM, NO_MEM,     P_87,  0, NULL },
/* ----------------------------------------------------------------------------------------------- */
{ "fdiv",   2, { R_ST,    R_STI    }, FP0, (F_OPCODE2_STI),												                           NO_VEX, NO_EVEX, 1, 2, { 0xd8, 0xf0, 0x00 }, 2, 0, NO_MOD,      0, 0, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM, NO_MEM,     P_87,  0, NULL },
{ "fdiv",   2, { R_STI,   R_ST     }, FP0, (F_OPCODE2_STI),												                           NO_VEX, NO_EVEX, 1, 2, { 0xdc, 0xf8, 0x00 }, 2, 0, NO_MOD,      0, 0, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM, NO_MEM,     P_87,  0, NULL },
{ "fdiv",   1, { M32,     OP_N     }, FP0, ALLOW_SEG | (F_MODRM | F_MODRM_RM),                               NO_VEX, NO_EVEX, 1, 1, { 0xd8, 0x00, 0x00 }, 4, 1, 0x30,        0, 0, 0,                        (X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_87,  0, NULL },
{ "fdiv",   1, { M64,     OP_N     }, FP0, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_RM),                NO_VEX, NO_EVEX, 1, 1, { 0xdc, 0x00, 0x00 }, 8, 1, 0x30,        0, 0, 0,                        (X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_87,  0, NULL },
{ "fdiv",   0, { OP_N,    OP_N     }, FP0, (NO_FLAGS),														                           NO_VEX, NO_EVEX, 1, 2, { 0xde, 0xf9, 0x00 }, 1, 0, NO_MOD,      0, 0, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM, NO_MEM,     P_87,  0, NULL },
{ "fdivp",  2, { R_STI,   R_ST     }, FP0, (F_OPCODE2_STI),												                           NO_VEX, NO_EVEX, 1, 2, { 0xde, 0xf8, 0x00 }, 2, 0, NO_MOD,      0, 0, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM, NO_MEM,     P_87,  0, NULL },
{ "fdivp",  0, { OP_N,    OP_N     }, FP0, (NO_FLAGS),														                           NO_VEX, NO_EVEX, 1, 2, { 0xde, 0xf9, 0x00 }, 1, 0, NO_MOD,      0, 0, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM, NO_MEM,     P_87,  0, NULL },
/* ----------------------------------------------------------------------------------------------- */
{ "fdivr",  2, { R_ST,    R_STI    }, FP0, (F_OPCODE2_STI),												                           NO_VEX, NO_EVEX, 1, 2, { 0xd8, 0xf8, 0x00 }, 2, 0, NO_MOD,      0, 0, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM, NO_MEM,     P_87,  0, NULL },
{ "fdivr",  2, { R_STI,   R_ST     }, FP0, (F_OPCODE2_STI),												                           NO_VEX, NO_EVEX, 1, 2, { 0xdc, 0xf0, 0x00 }, 2, 0, NO_MOD,      0, 0, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM, NO_MEM,     P_87,  0, NULL },
{ "fdivr",  1, { M32,     OP_N     }, FP0, ALLOW_SEG | (F_MODRM | F_MODRM_RM),                               NO_VEX, NO_EVEX, 1, 1, { 0xd8, 0x00, 0x00 }, 4, 1, 0x38,        0, 0, 0,                        (X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_87,  0, NULL },
{ "fdivr",  1, { M64,     OP_N     }, FP0, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_RM),                NO_VEX, NO_EVEX, 1, 1, { 0xdc, 0x00, 0x00 }, 8, 1, 0x38,        0, 0, 0,                        (X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_87,  0, NULL },
{ "fdivr",  0, { OP_N,    OP_N     }, FP0, (NO_FLAGS),														                           NO_VEX, NO_EVEX, 1, 2, { 0xde, 0xf1, 0x00 }, 1, 0, NO_MOD,      0, 0, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM, NO_MEM,     P_87,  0, NULL },
{ "fdivrp", 2, { R_STI,   R_ST     }, FP0, (F_OPCODE2_STI),												                           NO_VEX, NO_EVEX, 1, 2, { 0xde, 0xf0, 0x00 }, 2, 0, NO_MOD,      0, 0, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM, NO_MEM,     P_87,  0, NULL },
{ "fdivrp", 0, { OP_N,    OP_N     }, FP0, (NO_FLAGS),														                           NO_VEX, NO_EVEX, 1, 2, { 0xde, 0xf1, 0x00 }, 1, 0, NO_MOD,      0, 0, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM, NO_MEM,     P_87,  0, NULL },
/* ----------------------------------------------------------------------------------------------- */
{ "fsub",   2, { R_ST,    R_STI    }, FP0, (F_OPCODE2_STI),												                           NO_VEX, NO_EVEX, 1, 2, { 0xd8, 0xe0, 0x00 }, 2, 0, NO_MOD,      0, 0, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM, NO_MEM,     P_87,  0, NULL },
{ "fsub",   2, { R_STI,   R_ST     }, FP0, (F_OPCODE2_STI),												                           NO_VEX, NO_EVEX, 1, 2, { 0xdc, 0xe8, 0x00 }, 2, 0, NO_MOD,      0, 0, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM, NO_MEM,     P_87,  0, NULL },
{ "fsub",   1, { M32,     OP_N     }, FP0, ALLOW_SEG | (F_MODRM | F_MODRM_RM),                               NO_VEX, NO_EVEX, 1, 1, { 0xd8, 0x00, 0x00 }, 4, 1, 0x20,        0, 0, 0,                        (X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_87,  0, NULL },
{ "fsub",   1, { M64,     OP_N     }, FP0, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_RM),                NO_VEX, NO_EVEX, 1, 1, { 0xdc, 0x00, 0x00 }, 8, 1, 0x20,        0, 0, 0,                        (X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_87,  0, NULL },
{ "fsub",   0, { OP_N,    OP_N     }, FP0, (NO_FLAGS),														                           NO_VEX, NO_EVEX, 1, 2, { 0xde, 0xe9, 0x00 }, 1, 0, NO_MOD,      0, 0, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM, NO_MEM,     P_87,  0, NULL },
{ "fsubp",  2, { R_STI,   R_ST     }, FP0, (F_OPCODE2_STI),												                           NO_VEX, NO_EVEX, 1, 2, { 0xde, 0xe8, 0x00 }, 2, 0, NO_MOD,      0, 0, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM, NO_MEM,     P_87,  0, NULL },
{ "fsubp",  0, { OP_N,    OP_N     }, FP0, (NO_FLAGS),														                           NO_VEX, NO_EVEX, 1, 2, { 0xde, 0xe9, 0x00 }, 1, 0, NO_MOD,      0, 0, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM, NO_MEM,     P_87,  0, NULL },
/* ----------------------------------------------------------------------------------------------- */
{ "fsubr",  2, { R_ST,    R_STI    }, FP0, (F_OPCODE2_STI),												                           NO_VEX, NO_EVEX, 1, 2, { 0xd8, 0xe8, 0x00 }, 2, 0, NO_MOD,      0, 0, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM, NO_MEM,     P_87,  0, NULL },
{ "fsubr",  2, { R_STI,   R_ST     }, FP0, (F_OPCODE2_STI),												                           NO_VEX, NO_EVEX, 1, 2, { 0xdc, 0xe0, 0x00 }, 2, 0, NO_MOD,      0, 0, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM, NO_MEM,     P_87,  0, NULL },
{ "fsubr",  1, { M32,     OP_N     }, FP0, ALLOW_SEG | (F_MODRM | F_MODRM_RM),                               NO_VEX, NO_EVEX, 1, 1, { 0xd8, 0x00, 0x00 }, 4, 1, 0x28,        0, 0, 0,                        (X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_87,  0, NULL },
{ "fsubr",  1, { M64,     OP_N     }, FP0, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_RM),                NO_VEX, NO_EVEX, 1, 1, { 0xdc, 0x00, 0x00 }, 8, 1, 0x28,        0, 0, 0,                        (X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_87,  0, NULL },
{ "fsubr",  0, { OP_N,    OP_N     }, FP0, (NO_FLAGS),														                           NO_VEX, NO_EVEX, 1, 2, { 0xde, 0xe1, 0x00 }, 1, 0, NO_MOD,      0, 0, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM, NO_MEM,     P_87,  0, NULL },
{ "fsubrp", 2, { R_STI,   R_ST     }, FP0, (F_OPCODE2_STI),												                           NO_VEX, NO_EVEX, 1, 2, { 0xde, 0xe0, 0x00 }, 2, 0, NO_MOD,      0, 0, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM, NO_MEM,     P_87,  0, NULL },
{ "fsubrp", 0, { OP_N,    OP_N     }, FP0, (NO_FLAGS),														                           NO_VEX, NO_EVEX, 1, 2, { 0xde, 0xe1, 0x00 }, 1, 0, NO_MOD,      0, 0, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM, NO_MEM,     P_87,  0, NULL },
/* ----------------------------------------------------------------------------------------------- */
{ "fiadd",   1, { M32,     OP_N     }, FP0, ALLOW_SEG | (F_MODRM | F_MODRM_RM),                               NO_VEX, NO_EVEX, 1, 1, { 0xda, 0x00, 0x00 }, 4, 1, 0x00,        0, 0, 0,                        (X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_87,  0, NULL },
{ "fiadd",   1, { M16,     OP_N     }, FP0, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_RM),                NO_VEX, NO_EVEX, 1, 1, { 0xde, 0x00, 0x00 }, 8, 1, 0x00,        0, 0, 0,                        (X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_87,  0, NULL },
{ "ficom",   1, { M32,     OP_N     }, FP0, ALLOW_SEG | (F_MODRM | F_MODRM_RM),                               NO_VEX, NO_EVEX, 1, 1, { 0xda, 0x00, 0x00 }, 4, 1, 0x10,        0, 0, 0,                        (X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_87,  0, NULL },
{ "ficom",   1, { M16,     OP_N     }, FP0, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_RM),                NO_VEX, NO_EVEX, 1, 1, { 0xde, 0x00, 0x00 }, 8, 1, 0x10,        0, 0, 0,                        (X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_87,  0, NULL },
{ "ficomp",  1, { M32,     OP_N     }, FP0, ALLOW_SEG | (F_MODRM | F_MODRM_RM),                               NO_VEX, NO_EVEX, 1, 1, { 0xda, 0x00, 0x00 }, 4, 1, 0x18,        0, 0, 0,                        (X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_87,  0, NULL },
{ "ficomp",  1, { M16,     OP_N     }, FP0, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_RM),                NO_VEX, NO_EVEX, 1, 1, { 0xde, 0x00, 0x00 }, 8, 1, 0x18,        0, 0, 0,                        (X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_87,  0, NULL },
{ "fidiv",   1, { M32,     OP_N     }, FP0, ALLOW_SEG | (F_MODRM | F_MODRM_RM),                               NO_VEX, NO_EVEX, 1, 1, { 0xda, 0x00, 0x00 }, 4, 1, 0x30,        0, 0, 0,                        (X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_87,  0, NULL },
{ "fidiv",   1, { M16,     OP_N     }, FP0, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_RM),                NO_VEX, NO_EVEX, 1, 1, { 0xde, 0x00, 0x00 }, 8, 1, 0x30,        0, 0, 0,                        (X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_87,  0, NULL },
{ "fidivr",  1, { M32,     OP_N     }, FP0, ALLOW_SEG | (F_MODRM | F_MODRM_RM),                               NO_VEX, NO_EVEX, 1, 1, { 0xda, 0x00, 0x00 }, 4, 1, 0x38,        0, 0, 0,                        (X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_87,  0, NULL },
{ "fidivr",  1, { M16,     OP_N     }, FP0, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_RM),                NO_VEX, NO_EVEX, 1, 1, { 0xde, 0x00, 0x00 }, 8, 1, 0x38,        0, 0, 0,                        (X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_87,  0, NULL },
{ "fimul",   1, { M32,     OP_N     }, FP0, ALLOW_SEG | (F_MODRM | F_MODRM_RM),                               NO_VEX, NO_EVEX, 1, 1, { 0xda, 0x00, 0x00 }, 4, 1, 0x08,        0, 0, 0,                        (X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_87,  0, NULL },
{ "fimul",   1, { M16,     OP_N     }, FP0, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_RM),                NO_VEX, NO_EVEX, 1, 1, { 0xde, 0x00, 0x00 }, 8, 1, 0x08,        0, 0, 0,                        (X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_87,  0, NULL },
{ "fisub",   1, { M32,     OP_N     }, FP0, ALLOW_SEG | (F_MODRM | F_MODRM_RM),                               NO_VEX, NO_EVEX, 1, 1, { 0xda, 0x00, 0x00 }, 4, 1, 0x20,        0, 0, 0,                        (X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_87,  0, NULL },
{ "fisub",   1, { M16,     OP_N     }, FP0, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_RM),                NO_VEX, NO_EVEX, 1, 1, { 0xde, 0x00, 0x00 }, 8, 1, 0x20,        0, 0, 0,                        (X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_87,  0, NULL },
{ "fisubr",  1, { M32,     OP_N     }, FP0, ALLOW_SEG | (F_MODRM | F_MODRM_RM),                               NO_VEX, NO_EVEX, 1, 1, { 0xda, 0x00, 0x00 }, 4, 1, 0x28,        0, 0, 0,                        (X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_87,  0, NULL },
{ "fisubr",  1, { M16,     OP_N     }, FP0, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_RM),                NO_VEX, NO_EVEX, 1, 1, { 0xde, 0x00, 0x00 }, 8, 1, 0x28,        0, 0, 0,                        (X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_87,  0, NULL },
/* ----------------------------------------------------------------------------------------------- */
{ "fild",    1, { M32,     OP_N     }, FP0, ALLOW_SEG | (F_MODRM | F_MODRM_RM),                               NO_VEX, NO_EVEX, 1, 1, { 0xdb, 0x00, 0x00 }, 4, 1, 0x00,        0, 0, 0,                        (X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_87,  0, NULL },
{ "fild",    1, { M64,     OP_N     }, FP0, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_RM),                NO_VEX, NO_EVEX, 1, 1, { 0xdf, 0x00, 0x00 }, 8, 1, 0x28,        0, 0, 0,                        (X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_87,  0, NULL },
{ "fild",    1, { M16,     OP_N     }, FP0, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_RM),                NO_VEX, NO_EVEX, 1, 1, { 0xdf, 0x00, 0x00 }, 8, 1, 0x00,        0, 0, 0,                        (X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_87,  0, NULL },
{ "fistp",   1, { M32,     OP_N     }, FP0, ALLOW_SEG | (F_MODRM | F_MODRM_RM),                               NO_VEX, NO_EVEX, 1, 1, { 0xdb, 0x00, 0x00 }, 4, 1, 0x18,        0, 0, 0,                        (X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_87,  0, NULL },
{ "fistp",   1, { M64,     OP_N     }, FP0, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_RM),                NO_VEX, NO_EVEX, 1, 1, { 0xdf, 0x00, 0x00 }, 8, 1, 0x38,        0, 0, 0,                        (X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_87,  0, NULL },
{ "fistp",   1, { M16,     OP_N     }, FP0, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_RM),                NO_VEX, NO_EVEX, 1, 1, { 0xdf, 0x00, 0x00 }, 8, 1, 0x18,        0, 0, 0,                        (X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_87,  0, NULL },
{ "fist",    1, { M32,     OP_N     }, FP0, ALLOW_SEG | (F_MODRM | F_MODRM_RM),                               NO_VEX, NO_EVEX, 1, 1, { 0xdb, 0x00, 0x00 }, 4, 1, 0x10,        0, 0, 0,                        (X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_87,  0, NULL },
{ "fist",    1, { M16,     OP_N     }, FP0, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_RM),                NO_VEX, NO_EVEX, 1, 1, { 0xdf, 0x00, 0x00 }, 8, 1, 0x10,        0, 0, 0,                        (X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_87,  0, NULL },
/* ----------------------------------------------------------------------------------------------- */
{ "fld",    1, { R_STI,   OP_N     }, FP0, (F_OPCODE2_STI),												                           NO_VEX, NO_EVEX, 1, 2, { 0xd9, 0xe0, 0xc0 }, 2, 0, NO_MOD,      0, 0, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM, NO_MEM,     P_87,  0, NULL },
{ "fld",    1, { M32,     OP_N     }, FP0, ALLOW_SEG | (F_MODRM | F_MODRM_RM),                               NO_VEX, NO_EVEX, 1, 1, { 0xd9, 0x00, 0x00 }, 4, 1, 0x00,        0, 0, 0,                        (X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_87,  0, NULL },
{ "fld",    1, { M64,     OP_N     }, FP0, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_RM),                NO_VEX, NO_EVEX, 1, 1, { 0xdd, 0x00, 0x00 }, 8, 1, 0x00,        0, 0, 0,                        (X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_87,  0, NULL },
{ "fld",    1, { M80,     OP_N     }, FP0, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_RM),                NO_VEX, NO_EVEX, 1, 1, { 0xdb, 0x00, 0x00 }, 8, 1, 0x28,        0, 0, 0,                        (X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_87,  0, NULL },
{ "fstp",   1, { R_STI,   OP_N     }, FP0, (F_OPCODE2_STI),												                           NO_VEX, NO_EVEX, 1, 2, { 0xdd, 0xe0, 0xd8 }, 2, 0, NO_MOD,      0, 0, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM, NO_MEM,     P_87,  0, NULL },
{ "fstp",   1, { M32,     OP_N     }, FP0, ALLOW_SEG | (F_MODRM | F_MODRM_RM),                               NO_VEX, NO_EVEX, 1, 1, { 0xd9, 0x00, 0x00 }, 4, 1, 0x18,        0, 0, 0,                        (X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_87,  0, NULL },
{ "fstp",   1, { M64,     OP_N     }, FP0, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_RM),                NO_VEX, NO_EVEX, 1, 1, { 0xdd, 0x00, 0x00 }, 8, 1, 0x18,        0, 0, 0,                        (X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_87,  0, NULL },
{ "fstp",   1, { M80,     OP_N     }, FP0, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_RM),                NO_VEX, NO_EVEX, 1, 1, { 0xdb, 0x00, 0x00 }, 8, 1, 0x28,        0, 0, 0,                        (X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_87,  0, NULL },
{ "fst",    1, { R_STI,   OP_N     }, FP0, (F_OPCODE2_STI),												                           NO_VEX, NO_EVEX, 1, 2, { 0xdd, 0xe0, 0xd0 }, 2, 0, NO_MOD,      0, 0, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM, NO_MEM,     P_87,  0, NULL },
{ "fst",    1, { M32,     OP_N     }, FP0, ALLOW_SEG | (F_MODRM | F_MODRM_RM),                               NO_VEX, NO_EVEX, 1, 1, { 0xd9, 0x00, 0x00 }, 4, 1, 0x10,        0, 0, 0,                        (X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_87,  0, NULL },
{ "fst",    1, { M64,     OP_N     }, FP0, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_RM),                NO_VEX, NO_EVEX, 1, 1, { 0xdd, 0x00, 0x00 }, 8, 1, 0x10,        0, 0, 0,                        (X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_87,  0, NULL },
/* ----------------------------------------------------------------------------------------------- */
{ "fldenv",   1, {  M_ANY,   OP_N   }, FP0, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_RM),                NO_VEX, NO_EVEX, 1, 1, { 0xd9, 0x00, 0x00 }, 8, 1, 0x20,        0, 0, 0,                        (X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_87,   0, NULL },
{ "fldenvd",  1, {  M_ANY,   OP_N   }, FP0, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_RM),                NO_VEX, NO_EVEX, 1, 1, { 0xd9, 0x00, 0x00 }, 8, 1, 0x20,        0, 0, 0,                        (X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_387,  0, NULL },
{ "fldenvw",  1, {  M_ANY,   OP_N   }, FP0, ALLOW_SEG | (F_MODRM | F_MODRM_RM),                               NO_VEX, NO_EVEX, 1, 1, { 0xd9, 0x00, 0x00 }, 4, 1, 0x20,        0, 0, 0,                        (X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_87,   0, NULL },
{ "fnsave",   1, {  M_ANY,   OP_N   }, FP0, ALLOW_SEG | (NO_FWAIT) | (REX | REXW) | (F_MODRM | F_MODRM_RM),   NO_VEX, NO_EVEX, 1, 1, { 0xdd, 0x00, 0x00 }, 8, 1, 0x30,        0, 0, 0,                        (X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_87,   0, NULL },
{ "fnsaved",  1, {  M_ANY,   OP_N   }, FP0, ALLOW_SEG | (NO_FWAIT) | (REX | REXW) | (F_MODRM | F_MODRM_RM),   NO_VEX, NO_EVEX, 1, 1, { 0xdd, 0x00, 0x00 }, 8, 1, 0x30,        0, 0, 0,                        (X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_387,  0, NULL },
{ "fnsavew",  1, {  M_ANY,   OP_N   }, FP0, ALLOW_SEG | (NO_FWAIT) | (F_MODRM | F_MODRM_RM),                  NO_VEX, NO_EVEX, 1, 1, { 0xdd, 0x00, 0x00 }, 4, 1, 0x30,        0, 0, 0,                        (X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_87,   0, NULL },
{ "fnstenv",  1, {  M_ANY,   OP_N   }, FP0, ALLOW_SEG | (NO_FWAIT) | (REX | REXW) | (F_MODRM | F_MODRM_RM),   NO_VEX, NO_EVEX, 1, 1, { 0xd9, 0x00, 0x00 }, 8, 1, 0x30,        0, 0, 0,                        (X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_87,   0, NULL },
{ "fnstenvd", 1, {  M_ANY,   OP_N   }, FP0, ALLOW_SEG | (NO_FWAIT) | (REX | REXW) | (F_MODRM | F_MODRM_RM),   NO_VEX, NO_EVEX, 1, 1, { 0xd9, 0x00, 0x00 }, 8, 1, 0x30,        0, 0, 0,                        (X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_387,  0, NULL },
{ "fnstenvw", 1, {  M_ANY,   OP_N   }, FP0, ALLOW_SEG | (NO_FWAIT) | (F_MODRM | F_MODRM_RM),                  NO_VEX, NO_EVEX, 1, 1, { 0xd9, 0x00, 0x00 }, 4, 1, 0x30,        0, 0, 0,                        (X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_87,   0, NULL },
{ "frstor",   1, {  M_ANY,   OP_N   }, FP0, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_RM),                NO_VEX, NO_EVEX, 1, 1, { 0xdd, 0x00, 0x00 }, 8, 1, 0x20,        0, 0, 0,                        (X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_87,   0, NULL },
{ "frstord",  1, {  M_ANY,   OP_N   }, FP0, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_RM),                NO_VEX, NO_EVEX, 1, 1, { 0xdd, 0x00, 0x00 }, 8, 1, 0x20,        0, 0, 0,                        (X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_387,  0, NULL },
{ "frstorw",  1, {  M_ANY,   OP_N   }, FP0, ALLOW_SEG | (F_MODRM | F_MODRM_RM),                               NO_VEX, NO_EVEX, 1, 1, { 0xdd, 0x00, 0x00 }, 4, 1, 0x20,        0, 0, 0,                        (X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_87,   0, NULL },
{ "fsave",    1, {  M_ANY,   OP_N   }, FP0, ALLOW_SEG | (ALLOW_FWAIT) | (REX | REXW) | (F_MODRM | F_MODRM_RM),      NO_VEX, NO_EVEX, 1, 1, { 0xdd, 0x00, 0x00 }, 8, 1, 0x30,        0, 0, 0,                        (X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_87,   0, NULL },
{ "fsaved",   1, {  M_ANY,   OP_N   }, FP0, ALLOW_SEG | (ALLOW_FWAIT) | (REX | REXW) | (F_MODRM | F_MODRM_RM),      NO_VEX, NO_EVEX, 1, 1, { 0xdd, 0x00, 0x00 }, 8, 1, 0x30,        0, 0, 0,                        (X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_387,  0, NULL },
{ "fsavew",   1, {  M_ANY,   OP_N   }, FP0, ALLOW_SEG | (ALLOW_FWAIT) | (F_MODRM | F_MODRM_RM),                     NO_VEX, NO_EVEX, 1, 1, { 0xdd, 0x00, 0x00 }, 4, 1, 0x30,        0, 0, 0,                        (X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_87,   0, NULL },
{ "fstenv",   1, {  M_ANY,   OP_N   }, FP0, ALLOW_SEG | (ALLOW_FWAIT) | (REX | REXW) | (F_MODRM | F_MODRM_RM),      NO_VEX, NO_EVEX, 1, 1, { 0xd9, 0x00, 0x00 }, 8, 1, 0x30,        0, 0, 0,                        (X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_87,   0, NULL },
{ "fstenvd",  1, {  M_ANY,   OP_N   }, FP0, ALLOW_SEG | (ALLOW_FWAIT) | (REX | REXW) | (F_MODRM | F_MODRM_RM),      NO_VEX, NO_EVEX, 1, 1, { 0xd9, 0x00, 0x00 }, 8, 1, 0x30,        0, 0, 0,                        (X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_387,  0, NULL },
{ "fstenvw",  1, {  M_ANY,   OP_N   }, FP0, ALLOW_SEG | (ALLOW_FWAIT) | (F_MODRM | F_MODRM_RM),                     NO_VEX, NO_EVEX, 1, 1, { 0xd9, 0x00, 0x00 }, 4, 1, 0x30,        0, 0, 0,                        (X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_87,   0, NULL },
/* ----------------------------------------------------------------------------------------------- */
{ "fldcw",   1, { M16,     OP_N     }, FP0, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_RM),                          NO_VEX, NO_EVEX, 1, 1, { 0xd9, 0x00, 0x00 }, 8, 1, 0x28,        0, 0, 0,                        (X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_87,   0, NULL },
{ "fnstcw",  1, { M16,     OP_N     }, FP0, ALLOW_SEG | (NO_FWAIT) | (REX | REXW) | (F_MODRM | F_MODRM_RM),             NO_VEX, NO_EVEX, 1, 1, { 0xd9, 0x00, 0x00 }, 8, 1, 0x38,        0, 0, 0,                        (X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_87,   0, NULL },
{ "fnstsw",  1, { R16_AX,  OP_N     }, FP0, (NO_FWAIT) | (F_OPCODE2_REG),													                      NO_VEX, NO_EVEX, 1, 2, { 0xdf, 0xE0, 0x00 }, 2,  0, NO_MOD,     0, OP_SIZE_OVERRIDE, 0, (X16 | X32 | X64), REG_DST,  NO_PREFIX,  NO_IMM,     NO_MEM, P_287,  0, NULL },
{ "fnstsw",  1, { M16,     OP_N     }, FP0, ALLOW_SEG | (NO_FWAIT) | (REX | REXW) | (F_MODRM | F_MODRM_RM),             NO_VEX, NO_EVEX, 1, 1, { 0xdd, 0x00, 0x00 }, 8, 1, 0x38,        0, 0, 0,                        (X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_87,   0, NULL },
{ "fstcw",   1, { M16,     OP_N     }, FP0, ALLOW_SEG | (ALLOW_FWAIT) | (REX | REXW) | (F_MODRM | F_MODRM_RM),                NO_VEX, NO_EVEX, 1, 1, { 0xd9, 0x00, 0x00 }, 8, 1, 0x38,        0, 0, 0,                        (X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_87,   0, NULL },
{ "fstsw",   1, { R16_AX,  OP_N     }, FP0, (ALLOW_FWAIT) | (F_OPCODE2_REG),													                        NO_VEX, NO_EVEX, 1, 2, { 0xdf, 0xE0, 0x00 }, 2,  0, NO_MOD,     0, OP_SIZE_OVERRIDE, 0, (X16 | X32 | X64), REG_DST,  NO_PREFIX,  NO_IMM,     NO_MEM, P_287,  0, NULL },
{ "fstsw",   1, { M16,     OP_N     }, FP0, ALLOW_SEG | (ALLOW_FWAIT) | (REX | REXW) | (F_MODRM | F_MODRM_RM),                NO_VEX, NO_EVEX, 1, 1, { 0xdd, 0x00, 0x00 }, 8, 1, 0x38,        0, 0, 0,                        (X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_87,   0, NULL },
/* ----------------------------------------------------------------------------------------------- */
{ "fbld",    1, { M80,     OP_N     }, FP0, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_RM),                 NO_VEX, NO_EVEX, 1, 1, { 0xdf, 0x00, 0x00 }, 8, 1, 0x20,        0, 0, 0,                        (X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_87,  0, NULL },
{ "fbstp",   1, { M80,     OP_N     }, FP0, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_RM),                 NO_VEX, NO_EVEX, 1, 1, { 0xdf, 0x00, 0x00 }, 8, 1, 0x30,        0, 0, 0,                        (X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_87,  0, NULL },
{ "ffree",   1, { R_STI,   OP_N     }, FP0, (F_OPCODE2_STI),												                           NO_VEX, NO_EVEX, 1, 2, { 0xdd, 0xc0, 0xd0 }, 2, 0, NO_MOD,      0, 0, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM, NO_MEM,     P_87,  0, NULL },
{ "ffreep",  1, { R_STI,   OP_N     }, FP0, (F_OPCODE2_STI),												                           NO_VEX, NO_EVEX, 1, 2, { 0xdf, 0xc0, 0xd0 }, 2, 0, NO_MOD,      0, 0, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM, NO_MEM,     P_87,  0, NULL },
{ "fxch",    1, { R_STI,   OP_N     }, FP0, (F_OPCODE2_STI),												                           NO_VEX, NO_EVEX, 1, 2, { 0xd9, 0xc8, 0xd0 }, 2, 0, NO_MOD,      0, 0, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM, NO_MEM,     P_87,  0, NULL },
{ "fxch",    0, { OP_N,    OP_N     }, FP0, (NO_FLAGS),                                                        NO_VEX, NO_EVEX, 1, 2, { 0xd9, 0xc9, 0x00 }, 1, 0, NO_MOD,      0, 0, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, NO_IMM, NO_MEM,     P_87,  0, NULL },
{ "fxrstor", 1, { M_ANY,   OP_N     }, FP0, ALLOW_SEG | (ALLOW_FWAIT) | (REX | REXW) | (F_MODRM | F_MODRM_RM), NO_VEX, NO_EVEX, 1, 1, { 0xae, 0x00, 0x00 }, 8, 1, 0x08,        0, 0, 0,                        (X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_87,  0, NULL },
/* ----------------------------------------------------------------------------------------------- */
/* MMX/SSE related opcodes (except SSE instructions CMPSD and MOVSD) */
{ "emms",       0, { OP_N,    OP_N     }, GP0, (NO_FLAGS),                                                  NO_VEX, NO_EVEX, 1, 2, { 0x77, 0x00, 0x00 }, 1, 0, NO_MOD,      0, 0, 0,                  (X16 | X32 | X64), NO_DST,  PFX_0xF, NO_IMM, NO_MEM,     P_686 | P_MMX,  0, NULL },
{ "clflush",    1, { M_ANY,   OP_N     }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_RM),                          NO_VEX, NO_EVEX, 1, 1, { 0xae, 0x00, 0x00 }, 8, 1, 0x38, 0, 0, ADDR_SIZE_OVERRIDE,              (X32 | X64), RM_DST,  PFX_0xF, NO_IMM, MEM_OPND_0, P_686 | P_SSE2, 0, NULL },
{ "clflushopt", 1, { M_ANY,            }, GP3, ALLOW_SEG | (F_MODRM | F_MODRM_RM),                          NO_VEX, NO_EVEX, 1, 1, { 0xae, 0x00, 0x00 }, 8, 0, 0x38, 0, 0, ADDR_SIZE_OVERRIDE,              (X32 | X64), RM_DST, PFX_0x66F,NO_IMM, MEM_OPND_0, P_686 | P_SSE2, 0, NULL },
{ "ldmxcsr",    1, { M_ANY,   OP_N     }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_RM),                          NO_VEX, NO_EVEX, 1, 1, { 0xae, 0x00, 0x00 }, 4, 1, 0x10, 0, 0, ADDR_SIZE_OVERRIDE,              (X32 | X64), RM_DST,  PFX_0xF, NO_IMM, MEM_OPND_0, P_686 | P_SSE2, 0, NULL },
{ "stmxcsr",    1, { M_ANY,   OP_N     }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_RM),                          NO_VEX, NO_EVEX, 1, 1, { 0xae, 0x00, 0x00 }, 4, 1, 0x18, 0, 0, ADDR_SIZE_OVERRIDE,              (X32 | X64), RM_DST,  PFX_0xF, NO_IMM, MEM_OPND_0, P_686 | P_SSE2, 0, NULL },
{ "lfence",     0, { OP_N,    OP_N     }, GP0, (NO_FLAGS),                                                  NO_VEX, NO_EVEX, 1, 2, { 0xae, 0xe8, 0x00 }, 1, 0, NO_MOD,      0, 0, 0,                  (X16 | X32 | X64), NO_DST,  PFX_0xF, NO_IMM, NO_MEM,     P_686 | P_SSE2, 0, NULL },
{ "mfence",     0, { OP_N,    OP_N     }, GP0, (NO_FLAGS),                                                  NO_VEX, NO_EVEX, 1, 2, { 0xae, 0xf0, 0x00 }, 1, 0, NO_MOD,      0, 0, 0,                  (X16 | X32 | X64), NO_DST,  PFX_0xF, NO_IMM, NO_MEM,     P_686 | P_SSE2, 0, NULL },
{ "sfence",     0, { OP_N,    OP_N     }, GP0, (NO_FLAGS),                                                  NO_VEX, NO_EVEX, 1, 2, { 0xae, 0xf8, 0x00 }, 1, 0, NO_MOD,      0, 0, 0,                  (X16 | X32 | X64), NO_DST,  PFX_0xF, NO_IMM, NO_MEM,     P_686 | P_SSE1, 0, NULL },
{ "prefetchnta",1, { M_ANY,   OP_N     }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_RM),                          NO_VEX, NO_EVEX, 1, 1, { 0x18, 0x00, 0x00 }, 8, 1, 0x00, 0, 0, ADDR_SIZE_OVERRIDE,              (X32 | X64), RM_DST,  PFX_0xF, NO_IMM, MEM_OPND_0, P_686 | P_SSE2, 0, NULL },
{ "prefetcht0", 1, { M_ANY,   OP_N     }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_RM),                          NO_VEX, NO_EVEX, 1, 1, { 0x18, 0x00, 0x00 }, 8, 1, 0x08, 0, 0, ADDR_SIZE_OVERRIDE,              (X32 | X64), RM_DST,  PFX_0xF, NO_IMM, MEM_OPND_0, P_686 | P_SSE2, 0, NULL },
{ "prefetcht1", 1, { M_ANY,   OP_N     }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_RM),                          NO_VEX, NO_EVEX, 1, 1, { 0x18, 0x00, 0x00 }, 8, 1, 0x10, 0, 0, ADDR_SIZE_OVERRIDE,              (X32 | X64), RM_DST,  PFX_0xF, NO_IMM, MEM_OPND_0, P_686 | P_SSE2, 0, NULL },
{ "prefetcht2", 1, { M_ANY,   OP_N     }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_RM),                          NO_VEX, NO_EVEX, 1, 1, { 0x18, 0x00, 0x00 }, 8, 1, 0x18, 0, 0, ADDR_SIZE_OVERRIDE,              (X32 | X64), RM_DST,  PFX_0xF, NO_IMM, MEM_OPND_0, P_686 | P_SSE2, 0, NULL },
{ "pause",      0, { OP_N,    OP_N     }, GP0, (NO_FLAGS),                                                  NO_VEX, NO_EVEX, 1, 1, { 0x90, 0x00, 0x00 }, 1, 0, NO_MOD,      0, 0, 0,                  (X16 | X32 | X64), NO_DST,  PFX_0xF3,NO_IMM, NO_MEM,     P_686 | P_MMX,  0, NULL },

//{ "clac",   0, { OP_N,     OP_N    }, GP0, (NO_FLAGS),														  NO_VEX, NO_EVEX, 1, 2, { 0x01, 0xca, 0x00 }, 1, 0, NO_MOD,      0, 0,                0,                  (X16 | X32 | X64), NO_DST, PFX_0xF, NO_IMM, NO_MEM, P_86, 0, NULL },
  //CLFLUSH m8 NP 0F AE / 7 
{ "clwb", 1,       { M_ANY,        }, GP3, ALLOW_SEG | REXW | (F_MODRM | F_MODRM_RM | OPCODE_EXT),            NO_VEX, NO_EVEX, 1, 1, { 0xae, 0x06, 0x00 }, 1, 0, MOD_MEM_REG, 0, 0, ADDR_SIZE_OVERRIDE, (X32 | X64), RM_DST, PFX_0x66F, NO_IMM, MEM_OPND_0, P_686 | P_SSE2, 0, NULL },

/* General Purpose Reg->Reg moves (We use 8a/8b(masm) instead of 88/89(gcc) */
{ "mov",    2, { R8_CL,    R8_AL   }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),                                        NO_VEX, NO_EVEX, 1, 1, { 0x8a, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                  (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "mov",    2, { R8,       R8      }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),                                        NO_VEX, NO_EVEX, 1, 1, { 0x8a, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                  (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "mov",    2, { R8,       R8_AL   }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),                                        NO_VEX, NO_EVEX, 1, 1, { 0x8a, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                  (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "mov",    2, { R8,       R8_CL   }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),                                        NO_VEX, NO_EVEX, 1, 1, { 0x8a, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                  (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "mov",    2, { R8_CL,    R8      }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),                                        NO_VEX, NO_EVEX, 1, 1, { 0x8a, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                  (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "mov",    2, { R8_AL,    R8_CL   }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),                                        NO_VEX, NO_EVEX, 1, 1, { 0x8a, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                  (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "mov",    2, { R8,       R8H     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),		                          NO_VEX, NO_EVEX, 1, 1, { 0x8a, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                  (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "mov",    2, { R8H,      R8      }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),		                          NO_VEX, NO_EVEX, 1, 1, { 0x8a, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                  (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "mov",    2, { R8H,      R8H     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),		                          NO_VEX, NO_EVEX, 1, 1, { 0x8a, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                  (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "mov",    2, { R8E,      R8E     }, GP3, (REX | REXB | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		    NO_VEX, NO_EVEX, 1, 1, { 0x8a, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                  (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "mov",    2, { R8,       R8E     }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				        NO_VEX, NO_EVEX, 1, 1, { 0x8a, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                  (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "mov",    2, { R8E,      R8      }, GP3, (REX | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				        NO_VEX, NO_EVEX, 1, 1, { 0x8a, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                  (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "mov",    2, { R8U,      R8      }, GP3, (REX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),					            NO_VEX, NO_EVEX, 1, 1, { 0x8a, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                  (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "mov",    2, { R8U,      R8E     }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),					      NO_VEX, NO_EVEX, 1, 1, { 0x8a, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                  (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "mov",    2, { R8,       R8U     }, GP3, (REX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),					            NO_VEX, NO_EVEX, 1, 1, { 0x8a, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, 0,                0,                  (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "mov",    2, { R16,      R16     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                NO_VEX, NO_EVEX, 1, 1, { 0x8b, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "mov",    2, { R16E,     R16E    }, GP3, (REX | REXB | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		    NO_VEX, NO_EVEX, 1, 1, { 0x8b, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                  (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "mov",    2, { R16E,     R16     }, GP3, (REX | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				        NO_VEX, NO_EVEX, 1, 1, { 0x8b, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                  (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "mov",    2, { R16,      R16E    }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				        NO_VEX, NO_EVEX, 1, 1, { 0x8b, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                  (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "mov",    2, { R32,      R32     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                NO_VEX, NO_EVEX, 1, 1, { 0x8b, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "mov",    2, { R32E,     R32E    }, GP3, (REX | REXB | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		    NO_VEX, NO_EVEX, 1, 1, { 0x8b, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                  (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "mov",    2, { R32E,     R32     }, GP3, (REX | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				        NO_VEX, NO_EVEX, 1, 1, { 0x8b, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                  (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "mov",    2, { R32,      R32E    }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				        NO_VEX, NO_EVEX, 1, 1, { 0x8b, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                  (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "mov",    2, { R64,      R64     }, GP3, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		            NO_VEX, NO_EVEX, 1, 1, { 0x8b, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                  (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "mov",    2, { R64E,     R64E    }, GP3, (REX | REXR | REXB | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM), NO_VEX, NO_EVEX, 1, 1, { 0x8b, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                  (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "mov",    2, { R64,      R64E    }, GP3, (REX | REXB | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		    NO_VEX, NO_EVEX, 1, 1, { 0x8b, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                  (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "mov",    2, { R64E,     R64     }, GP3, (REX | REXR | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		    NO_VEX, NO_EVEX, 1, 1, { 0x8b, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                  (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
/* CR0-CR8 register moves */
{ "mov",    2, { R32,      R_CR    }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x20, 0x00 }, 4, 0, MOD_REG_REG, 0, 0,                0,                  (X16 | X32), RM_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "mov",    2, { R64,      R_CR    }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x20, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                  (X64), RM_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "mov",    2, { R64E,     R_CR    }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),			          NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x20, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                  (X64), RM_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "mov",    2, { R64,      R_CR8   }, GP3, (REX | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				        NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x20, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                  (X64), RM_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "mov",    2, { R64E,     R_CR8   }, GP3, (REX | REXB | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),	      NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x20, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                  (X64), RM_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "mov",    2, { R_CR,     R32     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x22, 0x00 }, 4, 0, MOD_REG_REG, 0, 0,                0,                  (X16 | X32), REG_DST, NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "mov",    2, { R_CR,     R64     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x22, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                  (X64), REG_DST, NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "mov",    2, { R_CR,     R64E    }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				        NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x22, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                  (X64), REG_DST, NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "mov",    2, { R_CR8,    R64     }, GP3, (REX | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				        NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x22, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                  (X64), REG_DST, NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "mov",    2, { R_CR8,    R64E    }, GP3, (REX | REXB | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		    NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x22, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                  (X64), REG_DST, NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
/* DR0-DR7 register moves */
{ "mov",    2, { R32,      R_DR    }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x21, 0x00 }, 4, 0, MOD_REG_REG, 0, 0,                0,                  (X16 | X32), RM_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "mov",    2, { R64,      R_DR    }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x21, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                  (X64), RM_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "mov",    2, { R64E,     R_DR    }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),			          NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x21, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                  (X64), RM_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "mov",    2, { R_DR,     R32     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x23, 0x00 }, 4, 0, MOD_REG_REG, 0, 0,                0,                  (X16 | X32), REG_DST, NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "mov",    2, { R_DR,     R64     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x23, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                  (X64), REG_DST, NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "mov",    2, { R_DR,     R64E    }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),	              NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x23, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                  (X64), REG_DST, NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
/* Segment register to register moves */
{ "mov",    2, { R16,      R_SEG   }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                NO_VEX, NO_EVEX, 1, 1, { 0x8c, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "mov",    2, { R16,      R_SEGE  }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                NO_VEX, NO_EVEX, 1, 1, { 0x8c, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                  (X32 | X64), RM_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_386, 0, NULL },
{ "mov",    2, { R32,      R_SEG   }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                NO_VEX, NO_EVEX, 1, 1, { 0x8c, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                  (X32 | X64), RM_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_386, 0, NULL },
{ "mov",    2, { R32,      R_SEGE  }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                NO_VEX, NO_EVEX, 1, 1, { 0x8c, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                  (X32 | X64), RM_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_386, 0, NULL },
{ "mov",    2, { R64,      R_SEG   }, GP3, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				        NO_VEX, NO_EVEX, 1, 1, { 0x8c, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,				0,                  (X64), RM_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "mov",    2, { R64,      R_SEGE  }, GP3, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				        NO_VEX, NO_EVEX, 1, 1, { 0x8c, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,				0,                  (X64), RM_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "mov",    2, { R16E,     R_SEG   }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				        NO_VEX, NO_EVEX, 1, 1, { 0x8c, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                  (X64), RM_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "mov",    2, { R16E,     R_SEGE  }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				        NO_VEX, NO_EVEX, 1, 1, { 0x8c, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                  (X64), RM_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "mov",    2, { R32E,     R_SEG   }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				        NO_VEX, NO_EVEX, 1, 1, { 0x8c, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                  (X64), RM_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "mov",    2, { R32E,     R_SEGE  }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				        NO_VEX, NO_EVEX, 1, 1, { 0x8c, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                  (X64), RM_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "mov",    2, { R64E,     R_SEG   }, GP3, (REX | REXB | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		    NO_VEX, NO_EVEX, 1, 1, { 0x8c, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,				0,                  (X64), RM_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "mov",    2, { R64E,     R_SEGE  }, GP3, (REX | REXB | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		    NO_VEX, NO_EVEX, 1, 1, { 0x8c, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,				0,                  (X64), RM_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "mov",    2, { R_SEG,    R16     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                NO_VEX, NO_EVEX, 1, 1, { 0x8e, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "mov",    2, { R_SEGE,   R16     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                NO_VEX, NO_EVEX, 1, 1, { 0x8e, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                  (X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_386, 0, NULL },
{ "mov",    2, { R_SEG,    R32     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                NO_VEX, NO_EVEX, 1, 1, { 0x8e, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                  (X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_386, 0, NULL },
{ "mov",    2, { R_SEGE,   R32     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                NO_VEX, NO_EVEX, 1, 1, { 0x8e, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                  (X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_386, 0, NULL },
{ "mov",    2, { R_SEG,    R64     }, GP3, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				        NO_VEX, NO_EVEX, 1, 1, { 0x8e, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,				0,                  (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "mov",    2, { R_SEGE,   R64     }, GP3, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				        NO_VEX, NO_EVEX, 1, 1, { 0x8e, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,				0,                  (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "mov",    2, { R_SEG,    R16E    }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				        NO_VEX, NO_EVEX, 1, 1, { 0x8e, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                  (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "mov",    2, { R_SEGE,   R16E    }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				        NO_VEX, NO_EVEX, 1, 1, { 0x8e, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                  (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "mov",    2, { R_SEG,    R32E    }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				        NO_VEX, NO_EVEX, 1, 1, { 0x8e, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                  (X64), REG_DST,  NO_PREFIX, NO_IMM,	   NO_MEM,     P_64,  0, NULL },
{ "mov",    2, { R_SEGE,   R32E    }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				        NO_VEX, NO_EVEX, 1, 1, { 0x8e, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                  (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "mov",    2, { R_SEG,    R64E    }, GP3, (REX | REXB | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),        NO_VEX, NO_EVEX, 1, 1, { 0x8e, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,				0,                  (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "mov",    2, { R_SEGE,   R64E    }, GP3, (REX | REXB | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),        NO_VEX, NO_EVEX, 1, 1, { 0x8e, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,				0,                  (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
/* Reg->Immediate moves */
{ "mov",    2, { R8,       IMM8    }, GP0, (F_OPCODE_REG),												                            NO_VEX, NO_EVEX, 1, 1, { 0xb0, 0x00, 0x00 }, 1, 0, NO_MOD,      0, 0,				0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "mov",    2, { R8H,      IMM8    }, GP0, (F_OPCODE_REG),													                          NO_VEX, NO_EVEX, 1, 1, { 0xb0, 0x00, 0x00 }, 1, 0, NO_MOD,      0, 0,				0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "mov",    2, { R8U,      IMM8    }, GP3, (REX) | (F_OPCODE_REG),											                      NO_VEX, NO_EVEX, 1, 1, { 0xb0, 0x00, 0x00 }, 1, 0, NO_MOD,      0, 0,				0,                  (X64), NO_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
{ "mov",    2, { R8E,      IMM8    }, GP3, (REX | REXB) | (F_OPCODE_REG),							                        NO_VEX, NO_EVEX, 1, 1, { 0xb0, 0x00, 0x00 }, 1, 0, NO_MOD,      0, 0,				0,                  (X64), NO_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
{ "mov",    2, { R16,      IMM8    }, GP0, (F_OPCODE_REG),												                            NO_VEX, NO_EVEX, 1, 1, { 0xb8, 0x00, 0x00 }, 2, 0, NO_MOD,      0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "mov",    2, { R16E,     IMM8    }, GP3, (REX | REXB) | (F_OPCODE_REG),								                      NO_VEX, NO_EVEX, 1, 1, { 0xb8, 0x00, 0x00 }, 2, 0, NO_MOD,      0, OP_SIZE_OVERRIDE,	0,                  (X64), NO_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
{ "mov",    2, { R16,      IMM16   }, GP0, (F_OPCODE_REG),												                            NO_VEX, NO_EVEX, 1, 1, { 0xb8, 0x00, 0x00 }, 2, 0, NO_MOD,      0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "mov",    2, { R16E,     IMM16   }, GP3, (REX | REXB) | (F_OPCODE_REG),								                      NO_VEX, NO_EVEX, 1, 1, { 0xb8, 0x00, 0x00 }, 2, 0, NO_MOD,      0, OP_SIZE_OVERRIDE,	0,                  (X64), NO_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
{ "mov",    2, { R32,      IMM8    }, GP0, (F_OPCODE_REG),												                            NO_VEX, NO_EVEX, 1, 1, { 0xb8, 0x00, 0x00 }, 4, 0, NO_MOD,      0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "mov",    2, { R32E,     IMM8    }, GP3, (REX | REXB) | (F_OPCODE_REG),								                      NO_VEX, NO_EVEX, 1, 1, { 0xb8, 0x00, 0x00 }, 4, 0, NO_MOD,      0, OP_SIZE_OVERRIDE,	0,                  (X64), NO_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
{ "mov",    2, { R32,      IMM16   }, GP0, (F_OPCODE_REG),												                            NO_VEX, NO_EVEX, 1, 1, { 0xb8, 0x00, 0x00 }, 4, 0, NO_MOD,      0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "mov",    2, { R32E,     IMM16   }, GP3, (REX | REXB) | (F_OPCODE_REG),								                      NO_VEX, NO_EVEX, 1, 1, { 0xb8, 0x00, 0x00 }, 4, 0, NO_MOD,      0, OP_SIZE_OVERRIDE,	0,                  (X64), NO_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
{ "mov",    2, { R32,      IMM32   }, GP0, (F_OPCODE_REG),												                            NO_VEX, NO_EVEX, 1, 1, { 0xb8, 0x00, 0x00 }, 4, 0, NO_MOD,      0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_86,  0, NULL },
{ "mov",    2, { R32E,     IMM32   }, GP3, (REX | REXB) | (F_OPCODE_REG),								                      NO_VEX, NO_EVEX, 1, 1, { 0xb8, 0x00, 0x00 }, 4, 0, NO_MOD,      0, OP_SIZE_OVERRIDE,	0,                  (X64), NO_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
{ "mov",    2, { R64,      IMM64   }, GP3, (REX | REXW) | (F_OPCODE_REG),								                      NO_VEX, NO_EVEX, 1, 1, { 0xb8, 0x00, 0x00 }, 8, 0, NO_MOD,      0, 0,				0,                  (X64), NO_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
{ "mov",    2, { R64E,     IMM64   }, GP3, (REX | REXW | REXB) | (F_OPCODE_REG),						                  NO_VEX, NO_EVEX, 1, 1, { 0xb8, 0x00, 0x00 }, 8, 0, NO_MOD,      0, 0,				0,                  (X64), NO_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,     P_64,  0, NULL },
{ "mov",    2, { R64,      IMM8    }, GP3, (REX | REXW) | (F_MODRM | F_MODRM_RM),						                  NO_VEX, NO_EVEX, 1, 1, { 0xc7, 0x00, 0x00 }, 4, 0, MOD_REG_IMM, 0, 0,				0,                  (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,	   P_64,  0, NULL },
{ "mov",    2, { R64E,     IMM8    }, GP3, (REX | REXW | REXB) | (F_MODRM | F_MODRM_RM),					            NO_VEX, NO_EVEX, 1, 1, { 0xc7, 0x00, 0x00 }, 4, 0, MOD_REG_IMM, 0, 0,				0,                  (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,	   P_64,  0, NULL },
{ "mov",    2, { R64,      IMM16   }, GP3, (REX | REXW) | (F_MODRM | F_MODRM_RM),							                NO_VEX, NO_EVEX, 1, 1, { 0xc7, 0x00, 0x00 }, 4, 0, MOD_REG_IMM, 0, 0,				0,                  (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,	   P_64,  0, NULL },
{ "mov",    2, { R64E,     IMM16   }, GP3, (REX | REXW | REXB) | (F_MODRM | F_MODRM_RM),					            NO_VEX, NO_EVEX, 1, 1, { 0xc7, 0x00, 0x00 }, 4, 0, MOD_REG_IMM, 0, 0,				0,                  (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,	   P_64,  0, NULL },
{ "mov",    2, { R64,      IMM32   }, GP3, (REX | REXW) | (F_MODRM | F_MODRM_RM),							                NO_VEX, NO_EVEX, 1, 1, { 0xc7, 0x00, 0x00 }, 4, 0, MOD_REG_IMM, 0, 0,				0,                  (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,	   P_64,  0, NULL },
{ "mov",    2, { R64E,     IMM32   }, GP3, (REX | REXW | REXB) | (F_MODRM | F_MODRM_RM),					            NO_VEX, NO_EVEX, 1, 1, { 0xc7, 0x00, 0x00 }, 4, 0, MOD_REG_IMM, 0, 0,				0,                  (X64), RM_DST,  NO_PREFIX, IMM_OPND_1, NO_MEM,	   P_64,  0, NULL },
/* Mem->Reg moves */
{ "mov",    2, { R8,       M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                        NO_VEX, NO_EVEX, 1, 1, { 0x8a, 0x00, 0x00 }, 1, 0, MOD_REG_MEM, 0, 0,				ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST, NO_PREFIX, NO_IMM    , MEM_OPND_1, P_86,  0, NULL },
{ "mov",    2, { R8H,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                        NO_VEX, NO_EVEX, 1, 1, { 0x8a, 0x00, 0x00 }, 1, 0, MOD_REG_MEM, 0, 0,				ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST, NO_PREFIX, NO_IMM    , MEM_OPND_1, P_86,  0, NULL },
{ "mov",    2, { R8E,      M_ANY   }, GP3, ALLOW_SEG | (REX | REXR) | (F_MODRM | F_MODRM_REG),	              NO_VEX, NO_EVEX, 1, 1, { 0x8a, 0x00, 0x00 }, 1, 0, MOD_REG_MEM, 0, 0,				ADDR_SIZE_OVERRIDE, (X64), REG_DST, NO_PREFIX, NO_IMM    , MEM_OPND_1, P_64,  0, NULL },
{ "mov",    2, { R8U,      M_ANY   }, GP3, ALLOW_SEG | (REX) | (F_MODRM | F_MODRM_REG),						            NO_VEX, NO_EVEX, 1, 1, { 0x8a, 0x00, 0x00 }, 1, 0, MOD_REG_MEM, 0, 0,				ADDR_SIZE_OVERRIDE, (X64), REG_DST, NO_PREFIX, NO_IMM    , MEM_OPND_1, P_64,  0, NULL },
{ "mov",    2, { R16,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                        NO_VEX, NO_EVEX, 1, 1, { 0x8b, 0x00, 0x00 }, 2, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST, NO_PREFIX, NO_IMM    , MEM_OPND_1, P_86,  0, NULL },
{ "mov",    2, { R16E,     M_ANY   }, GP3, ALLOW_SEG | (REX | REXR) | (F_MODRM | F_MODRM_REG),	              NO_VEX, NO_EVEX, 1, 1, { 0x8b, 0x00, 0x00 }, 2, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X64), REG_DST, NO_PREFIX, NO_IMM    , MEM_OPND_1, P_64,  0, NULL },
{ "mov",    2, { R32,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                        NO_VEX, NO_EVEX, 1, 1, { 0x8b, 0x00, 0x00 }, 4, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST, NO_PREFIX, NO_IMM    , MEM_OPND_1, P_86,  0, NULL },
{ "mov",    2, { R32E,     M_ANY   }, GP3, ALLOW_SEG | (REX | REXR) | (F_MODRM | F_MODRM_REG),	              NO_VEX, NO_EVEX, 1, 1, { 0x8b, 0x00, 0x00 }, 4, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X64), REG_DST, NO_PREFIX, NO_IMM    , MEM_OPND_1, P_64,  0, NULL },
{ "mov",    2, { R64,      M_ANY   }, GP0, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_REG),				        NO_VEX, NO_EVEX, 1, 1, { 0x8b, 0x00, 0x00 }, 8, 0, MOD_REG_MEM, 0, 0,				ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST, NO_PREFIX, NO_IMM    , MEM_OPND_1, P_64,  0, NULL },
{ "mov",    2, { R64E,     M_ANY   }, GP3, ALLOW_SEG | (REX | REXW | REXR) | (F_MODRM | F_MODRM_REG),	        NO_VEX, NO_EVEX, 1, 1, { 0x8b, 0x00, 0x00 }, 8, 0, MOD_REG_MEM, 0, 0,				ADDR_SIZE_OVERRIDE, (X64), REG_DST, NO_PREFIX, NO_IMM    , MEM_OPND_1, P_64,  0, NULL },
{ "mov",    2, { M_ANY,    R8      }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                        NO_VEX, NO_EVEX, 1, 1, { 0x88, 0x00, 0x00 }, 1, 0, MOD_MEM_REG, 0, 0,				ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_86,  0, NULL },
{ "mov",    2, { M_ANY,    R8H     }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                        NO_VEX, NO_EVEX, 1, 1, { 0x88, 0x00, 0x00 }, 1, 0, MOD_MEM_REG, 0, 0,				ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_86,  0, NULL },
{ "mov",    2, { M_ANY,    R8E     }, GP3, ALLOW_SEG | (REX | REXR) | (F_MODRM | F_MODRM_REG),	              NO_VEX, NO_EVEX, 1, 1, { 0x88, 0x00, 0x00 }, 1, 0, MOD_MEM_REG, 0, 0,				ADDR_SIZE_OVERRIDE, (X64), RM_DST,  NO_PREFIX,  NO_IMM,    MEM_OPND_0, P_64,  0, NULL },
{ "mov",    2, { M_ANY,    R8U     }, GP3, ALLOW_SEG | (REX) | (F_MODRM | F_MODRM_REG),						            NO_VEX, NO_EVEX, 1, 1, { 0x88, 0x00, 0x00 }, 1, 0, MOD_MEM_REG, 0, 0,				ADDR_SIZE_OVERRIDE, (X64), RM_DST,  NO_PREFIX,  NO_IMM,    MEM_OPND_0, P_64,  0, NULL },
{ "mov",    2, { M_ANY,    R16     }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                        NO_VEX, NO_EVEX, 1, 1, { 0x89, 0x00, 0x00 }, 2, 0, MOD_MEM_REG, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM    , MEM_OPND_0, P_86,  0, NULL },
{ "mov",    2, { M_ANY,    R16E    }, GP3, ALLOW_SEG | (REX | REXR) | (F_MODRM | F_MODRM_REG),	              NO_VEX, NO_EVEX, 1, 1, { 0x89, 0x00, 0x00 }, 2, 0, MOD_MEM_REG, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X64), RM_DST,  NO_PREFIX, NO_IMM    , MEM_OPND_0, P_64,  0, NULL },
{ "mov",    2, { M_ANY,    R32     }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                        NO_VEX, NO_EVEX, 1, 1, { 0x89, 0x00, 0x00 }, 4, 0, MOD_MEM_REG, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM    , MEM_OPND_0, P_86,  0, NULL },
{ "mov",    2, { M_ANY,    R32E    }, GP3, ALLOW_SEG | (REX | REXR) | (F_MODRM | F_MODRM_REG),	              NO_VEX, NO_EVEX, 1, 1, { 0x89, 0x00, 0x00 }, 4, 0, MOD_MEM_REG, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X64), RM_DST,  NO_PREFIX, NO_IMM    , MEM_OPND_0, P_64,  0, NULL },
{ "mov",    2, { M_ANY,    R64     }, GP0, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_REG),			          NO_VEX, NO_EVEX, 1, 1, { 0x89, 0x00, 0x00 }, 8, 0, MOD_MEM_REG, 0, 0,				ADDR_SIZE_OVERRIDE, (X64), RM_DST,  NO_PREFIX, NO_IMM    , MEM_OPND_0, P_64,  0, NULL },
{ "mov",    2, { M_ANY,    R64E    }, GP3, ALLOW_SEG | (REX | REXW | REXR) | (F_MODRM | F_MODRM_REG),	        NO_VEX, NO_EVEX, 1, 1, { 0x89, 0x00, 0x00 }, 8, 0, MOD_MEM_REG, 0, 0,				ADDR_SIZE_OVERRIDE, (X64), RM_DST,  NO_PREFIX, NO_IMM    , MEM_OPND_0, P_64,  0, NULL },
/* Moffset moves */
{ "mov",    2, { R8_AL,    M_ANY   }, GP0, (ALLOW_SEG | ALLOW_SEGX) | (DSPW) | NO_MEM_REG,				            NO_VEX, NO_EVEX, 1, 1, { 0xa0, 0x00, 0x00 }, 1, 0, NO_MOD,      0, 0,				0,                  (X16 | X32 | X64), REG_DST, NO_PREFIX, NO_IMM    , MEM_ABS_1, P_86,  0, NULL },
{ "mov",    2, { R8_AL,    M8      }, GP0, (ALLOW_SEG | ALLOW_SEGX) | (DSPW) | NO_MEM_REG,				            NO_VEX, NO_EVEX, 1, 1, { 0xa0, 0x00, 0x00 }, 1, 0, NO_MOD,      0, 0,				0,                  (X16 | X32 | X64), REG_DST, NO_PREFIX, NO_IMM    , MEM_ABS_1, P_86,  0, NULL },
{ "mov",    2, { M_ANY,    R8_AL   }, GP0, (ALLOW_SEG | ALLOW_SEGX) | (DSPW) | NO_MEM_REG,				            NO_VEX, NO_EVEX, 1, 1, { 0xa2, 0x00, 0x00 }, 1, 0, NO_MOD,      0, 0,				0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM    , MEM_ABS_0, P_86,  0, NULL },
{ "mov",    2, { M8,       R8_AL   }, GP0, (ALLOW_SEG | ALLOW_SEGX) | (DSPW) | NO_MEM_REG,				            NO_VEX, NO_EVEX, 1, 1, { 0xa2, 0x00, 0x00 }, 1, 0, NO_MOD,      0, 0,				0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM    , MEM_ABS_0, P_86,  0, NULL },
{ "mov",    2, { R16_AX,   M_ANY   }, GP0, (ALLOW_SEG | ALLOW_SEGX) | (DSPW) | NO_MEM_REG,				            NO_VEX, NO_EVEX, 1, 1, { 0xa1, 0x00, 0x00 }, 2, 0, NO_MOD,      0, OP_SIZE_OVERRIDE,	0,					(X16 | X32 | X64), REG_DST, NO_PREFIX, NO_IMM    , MEM_ABS_1, P_86,  0, NULL },
{ "mov",    2, { M_ANY,    R16_AX  }, GP0, (ALLOW_SEG | ALLOW_SEGX) | (DSPW) | NO_MEM_REG,				            NO_VEX, NO_EVEX, 1, 1, { 0xa3, 0x00, 0x00 }, 2, 0, NO_MOD,      0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM    , MEM_ABS_0, P_86,  0, NULL },
{ "mov",    2, { R16_AX,   M16     }, GP0, (ALLOW_SEG | ALLOW_SEGX) | (DSPW) | NO_MEM_REG,				            NO_VEX, NO_EVEX, 1, 1, { 0xa1, 0x00, 0x00 }, 2, 0, NO_MOD,      0, OP_SIZE_OVERRIDE,	0,					(X16 | X32 | X64), REG_DST, NO_PREFIX, NO_IMM    , MEM_ABS_1, P_86,  0, NULL },
{ "mov",    2, { M16,      R16_AX  }, GP0, (ALLOW_SEG | ALLOW_SEGX) | (DSPW) | NO_MEM_REG,				            NO_VEX, NO_EVEX, 1, 1, { 0xa3, 0x00, 0x00 }, 2, 0, NO_MOD,      0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM    , MEM_ABS_0, P_86,  0, NULL },
{ "mov",    2, { R32_EAX,  M_ANY   }, GP0, (ALLOW_SEG | ALLOW_SEGX) | (DSPW) | NO_MEM_REG,                    NO_VEX, NO_EVEX, 1, 1, { 0xa1, 0x00, 0x00 }, 4, 0, NO_MOD,      0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), REG_DST, NO_PREFIX, NO_IMM    , MEM_ABS_1, P_86,  0, NULL },
{ "mov",    2, { M_ANY,    R32_EAX }, GP0, (ALLOW_SEG | ALLOW_SEGX) | (DSPW) | NO_MEM_REG,		                NO_VEX, NO_EVEX, 1, 1, { 0xa3, 0x00, 0x00 }, 4, 0, NO_MOD,      0, OP_SIZE_OVERRIDE,	0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM    , MEM_ABS_0, P_86,  0, NULL },
{ "mov",    2, { R32_EAX,  M32     }, GP0, (ALLOW_SEG | ALLOW_SEGX) | (DSPW) | NO_MEM_REG,                    NO_VEX, NO_EVEX, 1, 1, { 0xa1, 0x00, 0x00 }, 4, 0, NO_MOD,      0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), REG_DST, NO_PREFIX, NO_IMM    , MEM_ABS_1, P_86,  0, NULL },
{ "mov",    2, { M32,      R32_EAX }, GP0, (ALLOW_SEG | ALLOW_SEGX) | (DSPW) | NO_MEM_REG,		                NO_VEX, NO_EVEX, 1, 1, { 0xa3, 0x00, 0x00 }, 4, 0, NO_MOD,      0, OP_SIZE_OVERRIDE,	0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM    , MEM_ABS_0, P_86,  0, NULL },
{ "mov",    2, { R64_RAX,  M_ANY   }, GP3, (ALLOW_SEG | ALLOW_SEGX) | (REX | REXW) | (DSPW) | NO_MEM_REG,     NO_VEX, NO_EVEX, 1, 1, { 0xa1, 0x00, 0x00 }, 8, 0, NO_MOD,      0, 0,				0,                  (X64), REG_DST, NO_PREFIX, NO_IMM    , MEM_ABS_1, P_64,  0, NULL },
{ "mov",    2, { M_ANY,    R64_RAX }, GP3, (ALLOW_SEG | ALLOW_SEGX) | (REX | REXW) | (DSPW) | NO_MEM_REG,     NO_VEX, NO_EVEX, 1, 1, { 0xa3, 0x00, 0x00 }, 8, 0, NO_MOD,      0, 0,				0,                  (X64), RM_DST,  NO_PREFIX, NO_IMM    , MEM_ABS_0, P_64,  0, NULL },
{ "mov",    2, { R64_RAX,  M64     }, GP3, (ALLOW_SEG | ALLOW_SEGX) | (REX | REXW) | (DSPW) | NO_MEM_REG,     NO_VEX, NO_EVEX, 1, 1, { 0xa1, 0x00, 0x00 }, 8, 0, NO_MOD,      0, 0,				0,                  (X64), REG_DST, NO_PREFIX, NO_IMM    , MEM_ABS_1, P_64,  0, NULL },
{ "mov",    2, { M64,      R64_RAX }, GP3, (ALLOW_SEG | ALLOW_SEGX) | (REX | REXW) | (DSPW) | NO_MEM_REG,     NO_VEX, NO_EVEX, 1, 1, { 0xa3, 0x00, 0x00 }, 8, 0, NO_MOD,      0, 0,				0,                  (X64), RM_DST,  NO_PREFIX, NO_IMM    , MEM_ABS_0, P_64,  0, NULL },
{ "movabs", 2, { R8_AL,    M_ANY   }, GP0, (ALLOW_SEG | ALLOW_SEGX) | (DSPW) | NO_MEM_REG,				            NO_VEX, NO_EVEX, 1, 1, { 0xa0, 0x00, 0x00 }, 1, 0, NO_MOD,      0, 0,				0,                  (X16 | X32 | X64), REG_DST, NO_PREFIX, NO_IMM    , MEM_ABS_1, P_86,  0, NULL },
{ "movabs", 2, { R8_AL,    M8      }, GP0, (ALLOW_SEG | ALLOW_SEGX) | (DSPW) | NO_MEM_REG,				            NO_VEX, NO_EVEX, 1, 1, { 0xa0, 0x00, 0x00 }, 1, 0, NO_MOD,      0, 0,				0,                  (X16 | X32 | X64), REG_DST, NO_PREFIX, NO_IMM    , MEM_ABS_1, P_86,  0, NULL },
{ "movabs", 2, { M_ANY,    R8_AL   }, GP0, (ALLOW_SEG | ALLOW_SEGX) | (DSPW) | NO_MEM_REG,				            NO_VEX, NO_EVEX, 1, 1, { 0xa2, 0x00, 0x00 }, 1, 0, NO_MOD,      0, 0,				0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM    , MEM_ABS_0, P_86,  0, NULL },
{ "movabs", 2, { M8,       R8_AL   }, GP0, (ALLOW_SEG | ALLOW_SEGX) | (DSPW) | NO_MEM_REG,				            NO_VEX, NO_EVEX, 1, 1, { 0xa2, 0x00, 0x00 }, 1, 0, NO_MOD,      0, 0,				0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM    , MEM_ABS_0, P_86,  0, NULL },
{ "movabs", 2, { R16_AX,   M_ANY   }, GP0, (ALLOW_SEG | ALLOW_SEGX) | (DSPW) | NO_MEM_REG,				            NO_VEX, NO_EVEX, 1, 1, { 0xa1, 0x00, 0x00 }, 2, 0, NO_MOD,      0, OP_SIZE_OVERRIDE,	0,					(X16 | X32 | X64), REG_DST, NO_PREFIX, NO_IMM    , MEM_ABS_1, P_86,  0, NULL },
{ "movabs", 2, { M_ANY,    R16_AX  }, GP0, (ALLOW_SEG | ALLOW_SEGX) | (DSPW) | NO_MEM_REG,				            NO_VEX, NO_EVEX, 1, 1, { 0xa3, 0x00, 0x00 }, 2, 0, NO_MOD,      0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM    , MEM_ABS_0, P_86,  0, NULL },
{ "movabs", 2, { R16_AX,   M16     }, GP0, (ALLOW_SEG | ALLOW_SEGX) | (DSPW) | NO_MEM_REG,				            NO_VEX, NO_EVEX, 1, 1, { 0xa1, 0x00, 0x00 }, 2, 0, NO_MOD,      0, OP_SIZE_OVERRIDE,	0,					(X16 | X32 | X64), REG_DST, NO_PREFIX, NO_IMM    , MEM_ABS_1, P_86,  0, NULL },
{ "movabs", 2, { M16,      R16_AX  }, GP0, (ALLOW_SEG | ALLOW_SEGX) | (DSPW) | NO_MEM_REG,				            NO_VEX, NO_EVEX, 1, 1, { 0xa3, 0x00, 0x00 }, 2, 0, NO_MOD,      0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM    , MEM_ABS_0, P_86,  0, NULL },
{ "movabs", 2, { R32_EAX,  M_ANY   }, GP0, (ALLOW_SEG | ALLOW_SEGX) | (DSPW) | NO_MEM_REG,                    NO_VEX, NO_EVEX, 1, 1, { 0xa1, 0x00, 0x00 }, 4, 0, NO_MOD,      0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), REG_DST, NO_PREFIX, NO_IMM    , MEM_ABS_1, P_86,  0, NULL },
{ "movabs", 2, { M_ANY,    R32_EAX }, GP0, (ALLOW_SEG | ALLOW_SEGX) | (DSPW) | NO_MEM_REG,		                NO_VEX, NO_EVEX, 1, 1, { 0xa3, 0x00, 0x00 }, 4, 0, NO_MOD,      0, OP_SIZE_OVERRIDE,	0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM    , MEM_ABS_0, P_86,  0, NULL },
{ "movabs", 2, { R32_EAX,  M32     }, GP0, (ALLOW_SEG | ALLOW_SEGX) | (DSPW) | NO_MEM_REG,                    NO_VEX, NO_EVEX, 1, 1, { 0xa1, 0x00, 0x00 }, 4, 0, NO_MOD,      0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), REG_DST, NO_PREFIX, NO_IMM    , MEM_ABS_1, P_86,  0, NULL },
{ "movabs", 2, { M32,      R32_EAX }, GP0, (ALLOW_SEG | ALLOW_SEGX) | (DSPW) | NO_MEM_REG,		                NO_VEX, NO_EVEX, 1, 1, { 0xa3, 0x00, 0x00 }, 4, 0, NO_MOD,      0, OP_SIZE_OVERRIDE,	0,                  (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM    , MEM_ABS_0, P_86,  0, NULL },
{ "movabs", 2, { R64_RAX,  M_ANY   }, GP3, (ALLOW_SEG | ALLOW_SEGX) | (REX | REXW) | (DSPW) | NO_MEM_REG,     NO_VEX, NO_EVEX, 1, 1, { 0xa1, 0x00, 0x00 }, 8, 0, NO_MOD,      0, 0,				0,                  (X64), REG_DST, NO_PREFIX, NO_IMM    , MEM_ABS_1, P_64,  0, NULL },
{ "movabs", 2, { M_ANY,    R64_RAX }, GP3, (ALLOW_SEG | ALLOW_SEGX) | (REX | REXW) | (DSPW) | NO_MEM_REG,     NO_VEX, NO_EVEX, 1, 1, { 0xa3, 0x00, 0x00 }, 8, 0, NO_MOD,      0, 0,				0,                  (X64), RM_DST,  NO_PREFIX, NO_IMM    , MEM_ABS_0, P_64,  0, NULL },
{ "movabs", 2, { R64_RAX,  M64     }, GP3, (ALLOW_SEG | ALLOW_SEGX) | (REX | REXW) | (DSPW) | NO_MEM_REG,     NO_VEX, NO_EVEX, 1, 1, { 0xa1, 0x00, 0x00 }, 8, 0, NO_MOD,      0, 0,				0,                  (X64), REG_DST, NO_PREFIX, NO_IMM    , MEM_ABS_1, P_64,  0, NULL },
{ "movabs", 2, { M64,      R64_RAX }, GP3, (ALLOW_SEG | ALLOW_SEGX) | (REX | REXW) | (DSPW) | NO_MEM_REG,     NO_VEX, NO_EVEX, 1, 1, { 0xa3, 0x00, 0x00 }, 8, 0, NO_MOD,      0, 0,				0,                  (X64), RM_DST,  NO_PREFIX, NO_IMM    , MEM_ABS_0, P_64,  0, NULL },
/* Mem->Immediate moves*/
//MOV r / m8, imm8     C6 / 0 ib          MI Valid Valid Move imm8 to r / m8.
//MOV r / m8***, imm8  REX + C6 / 0 ib    MI Valid N.E.Move imm8 to r / m8.
//MOV r / m16, imm16   C7 / 0 iw          MI Valid Valid Move imm16 to r / m16.
//MOV r / m32, imm32   C7 / 0 id          MI Valid Valid Move imm32 to r / m32.
//MOV r / m64, imm32   REX.W + C7 / 0 id  MI Valid N.E.Move imm32 sign extended to 64 - bits to r / m64.
{ "mov",    2, { M8,       IMM8    }, GP3, ALLOW_SEG | (F_MODRM),											          NO_VEX, NO_EVEX, 1, 1, { 0xc6, 0x00, 0x00 }, 1, 0, MOD_MEM_IMM, 0, 0,	            ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0,P_86,  0, NULL },
{ "mov",    2, { M16,      IMM8    }, GP3, ALLOW_SEG | (F_MODRM),											          NO_VEX, NO_EVEX, 1, 1, { 0xc7, 0x00, 0x00 }, 2, 0, MOD_MEM_IMM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0,P_86,  0, NULL },
{ "mov",    2, { M16,      IMM16   }, GP3, ALLOW_SEG | (F_MODRM),											          NO_VEX, NO_EVEX, 1, 1, { 0xc7, 0x00, 0x00 }, 2, 0, MOD_MEM_IMM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0,P_86,  0, NULL },
{ "mov",    2, { M32,      IMM8    }, GP3, ALLOW_SEG | (REXP_MEM) | (F_MODRM),								  NO_VEX, NO_EVEX, 1, 1, { 0xc7, 0x00, 0x00 }, 4, 0, MOD_MEM_IMM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0,P_86,  0, NULL },
{ "mov",    2, { M32,      IMM16   }, GP3, ALLOW_SEG | (REXP_MEM) | (F_MODRM),								  NO_VEX, NO_EVEX, 1, 1, { 0xc7, 0x00, 0x00 }, 4, 0, MOD_MEM_IMM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0,P_86,  0, NULL },
{ "mov",    2, { M32,      IMM32   }, GP3, ALLOW_SEG | (REXP_MEM) | (F_MODRM),								  NO_VEX, NO_EVEX, 1, 1, { 0xc7, 0x00, 0x00 }, 4, 0, MOD_MEM_IMM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0,P_86,  0, NULL },
{ "mov",    2, { M64,      IMM8    }, GP3, ALLOW_SEG | (REXP_MEM) | (F_MODRM),								  NO_VEX, NO_EVEX, 1, 1, { 0xc7, 0x00, 0x00 }, 4, 0, MOD_MEM_IMM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0,P_86,  0, NULL },
{ "mov",    2, { M64,      IMM16   }, GP3, ALLOW_SEG | (REXP_MEM) | (F_MODRM),								  NO_VEX, NO_EVEX, 1, 1, { 0xc7, 0x00, 0x00 }, 4, 0, MOD_MEM_IMM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0,P_86,  0, NULL },
{ "mov",    2, { M64,      IMM32   }, GP3, ALLOW_SEG | (REXP_MEM) | (F_MODRM),								  NO_VEX, NO_EVEX, 1, 1, { 0xc7, 0x00, 0x00 }, 4, 0, MOD_MEM_IMM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0,P_86,  0, NULL },
{ "mov",    2, { M_ANY,    IMM8    }, GP3, ALLOW_SEG | (REXP_MEM) | (F_MODRM),								  NO_VEX, NO_EVEX, 1, 1, { 0xc6, 0x00, 0x00 }, 1, 0, MOD_MEM_IMM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0,P_86,  0, NULL },
{ "mov",    2, { M_ANY,    IMM16   }, GP3, ALLOW_SEG | (REXP_MEM) | (F_MODRM),								  NO_VEX, NO_EVEX, 1, 1, { 0xc7, 0x00, 0x00 }, 2, 0, MOD_MEM_IMM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0,P_86,  0, NULL },
{ "mov",    2, { M_ANY,    IMM32   }, GP3, ALLOW_SEG | (REXP_MEM) | (F_MODRM),								  NO_VEX, NO_EVEX, 1, 1, { 0xc7, 0x00, 0x00 }, 4, 0, MOD_MEM_IMM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  NO_PREFIX, IMM_OPND_1, MEM_OPND_0,P_86,  0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//ENTER imm16, 0     C8 iw 00 
//ENTER imm16, 1     C8 iw 01 
//ENTER imm16, imm8  C8 iw ib 
/* ----------------------------------------------------------------------------------------------- */
{ "enter",    2, { IMM16,  IMM8    }, GP0, 0,		      NO_VEX, NO_EVEX, 1, 1, { 0xc8, 0x00, 0x00 }, 2, 0, NO_MOD, 0, 0, 0,                  (X16 | X32), NO_DST,  NO_PREFIX, IMM_OPND_0, NO_MEM, P_86,  0, NULL },

  //MOVAPD xmm1, xmm2 / m128 66 0F 28 / r
/* SSE */
{ "movaps",    2, { R_XMM,    R_XMM       }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),                       NO_VEX, NO_EVEX, 1, 1, { 0x28, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     NO_MEM,    P_686 | P_SSE1, 0, NULL },
{ "movaps",    2, { R_XMM,    M_ANY       }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),						                        NO_VEX, NO_EVEX, 1, 1, { 0x28, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     MEM_OPND_1,P_686 | P_SSE1, 0, NULL },
{ "movaps",    2, { M_ANY,    R_XMM       }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),						                        NO_VEX, NO_EVEX, 1, 1, { 0x29, 0x00, 0x00 }, 16, 1, MOD_MEM_REG, 0, 0, 0, (X32 | X64), RM_DST,  PFX_0xF,    NO_IMM,     MEM_OPND_0,P_686 | P_SSE1, 0, NULL },
{ "movapd",    2, { R_XMM,    R_XMM       }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),                       NO_VEX, NO_EVEX, 1, 1, { 0x28, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  NO_IMM,     NO_MEM,    P_686 | P_SSE2, 0, NULL },
{ "movapd",    2, { R_XMM,    M_ANY       }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),						                        NO_VEX, NO_EVEX, 1, 1, { 0x28, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  NO_IMM,     MEM_OPND_1,P_686 | P_SSE2, 0, NULL },
{ "movapd",    2, { M_ANY,    R_XMM       }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),						                        NO_VEX, NO_EVEX, 1, 1, { 0x29, 0x00, 0x00 }, 16, 1, MOD_MEM_REG, 0, 0, 0, (X32 | X64), RM_DST,  PFX_0x66F,  NO_IMM,     MEM_OPND_0,P_686 | P_SSE2, 0, NULL },
// MOVHPD xmm1, m64 66 0F 16 / r
// MOVHPD m64, xmm1 66 0F 17 / r
{ "movhpd",    2, { R_XMM,    M_ANY       }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),						                        NO_VEX, NO_EVEX, 2, 1, { 0x16, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  NO_IMM,     MEM_OPND_1,P_686 | P_SSE2, 0, NULL },
{ "movhpd",    2, { M_ANY,    R_XMM       }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),						                        NO_VEX, NO_EVEX, 2, 1, { 0x17, 0x00, 0x00 }, 16, 1, MOD_MEM_REG, 0, 0, 0, (X32 | X64), RM_DST,  PFX_0x66F,  NO_IMM,     MEM_OPND_0,P_686 | P_SSE2, 0, NULL },
//MOVHPS xmm1, m64 NP 0F 16 / r
//MOVHPS m64, xmm1 NP 0F 17 / r
{ "movhps",    2, { R_XMM,    M_ANY       }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),						                        NO_VEX, NO_EVEX, 2, 1, { 0x16, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     MEM_OPND_1,P_686 | P_SSE1, 0, NULL },
{ "movhps",    2, { M_ANY,    R_XMM       }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),						                        NO_VEX, NO_EVEX, 2, 1, { 0x17, 0x00, 0x00 }, 16, 1, MOD_MEM_REG, 0, 0, 0, (X32 | X64), RM_DST,  PFX_0xF,    NO_IMM,     MEM_OPND_0,P_686 | P_SSE1, 0, NULL },
//MOVLPD xmm1, m64    66 0F 12 / r
//MOVLPD m64, xmm1    66 0F 13 / r
{ "movlpd",    2, { R_XMM,    M_ANY       }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),						                        NO_VEX, NO_EVEX, 2, 1, { 0x12, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  NO_IMM,     MEM_OPND_1,P_686 | P_SSE2, 0, NULL },
{ "movlpd",    2, { M_ANY,    R_XMM       }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),						                        NO_VEX, NO_EVEX, 2, 1, { 0x13, 0x00, 0x00 }, 16, 1, MOD_MEM_REG, 0, 0, 0, (X32 | X64), RM_DST,  PFX_0x66F,  NO_IMM,     MEM_OPND_0,P_686 | P_SSE2, 0, NULL },
//MOVLPS xmm1, m64    NP 0F 12 / r
//MOVLPS m64, xmm1    0F 13 / r
{ "movlps",    2, { R_XMM,    M_ANY       }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),						                        NO_VEX, NO_EVEX, 2, 1, { 0x12, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     MEM_OPND_1,P_686 | P_SSE1, 0, NULL },
{ "movlps",    2, { M_ANY,    R_XMM       }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),						                        NO_VEX, NO_EVEX, 2, 1, { 0x13, 0x00, 0x00 }, 16, 1, MOD_MEM_REG, 0, 0, 0, (X32 | X64), RM_DST,  PFX_0xF,    NO_IMM,     MEM_OPND_0,P_686 | P_SSE1, 0, NULL },
//MOVHLPS xmm1, xmm2    NP 0F 12 / r
{ "movhlps",     2, { R_XMM,    R_XMM     }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),                       NO_VEX, NO_EVEX, 1, 1, { 0x12, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     NO_MEM,    P_686 | P_SSE1, 0, NULL },
//MOVLHPS xmm1, xmm2    NP 0F 16 / r
{ "movlhps",     2, { R_XMM,    R_XMM     }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),                       NO_VEX, NO_EVEX, 1, 1, { 0x16, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     NO_MEM,    P_686 | P_SSE1, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//MOVDQA xmm1, xmm2 / m128    66 0F 6F / r
//MOVDQA xmm2 / m128, xmm1    66 0F 7F / r
/* ----------------------------------------------------------------------------------------------- */
{ "movdqa", 2, { R_XMM,    R_XMM       }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),	                        NO_VEX, NO_EVEX,  1, 1, { 0x6f, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F, NO_IMM,     NO_MEM,    P_686 | P_SSE2, 0, NULL },
{ "movdqa", 2, { R_XMM,    M_ANY       }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),						                            NO_VEX, NO_EVEX,  1, 1, { 0x6f, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F, NO_IMM,     MEM_OPND_1,P_686 | P_SSE2, 0, NULL },
{ "movdqa", 2, { M_ANY,    R_XMM       }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),	                                      NO_VEX, NO_EVEX,  1, 1, { 0x7f, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), RM_DST,  PFX_0x66F, NO_IMM,     MEM_OPND_0,P_686 | P_SSE2, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//MOVDQU xmm1, xmm2 / m128    F3 0F 6F / r
//MOVDQU xmm2 / m128, xmm1    F3 0F 7F / r
/* ----------------------------------------------------------------------------------------------- */
{ "movdqu", 2, { R_XMM,    R_XMM       }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),	                        NO_VEX, NO_EVEX,  1, 1, { 0x6f, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF30F, NO_IMM,     NO_MEM,    P_686 | P_SSE2, 0, NULL },
{ "movdqu", 2, { R_XMM,    M_ANY       }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),						                            NO_VEX, NO_EVEX,  1, 1, { 0x6f, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF30F, NO_IMM,     MEM_OPND_1,P_686 | P_SSE2, 0, NULL },
{ "movdqu", 2, { M_ANY,    R_XMM       }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),	                                      NO_VEX, NO_EVEX,  1, 1, { 0x7f, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), RM_DST,  PFX_0xF30F, NO_IMM,     MEM_OPND_0,P_686 | P_SSE2, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//MOVDQ2Q mm, xmm F2 0F D6 / r
/* ----------------------------------------------------------------------------------------------- */
{ "movdq2q", 2, { MMX64,    R_XMM      }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),	                        NO_VEX, NO_EVEX,  1, 1, { 0xd6, 0x00, 0x00 }, 8, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF20F, NO_IMM,     NO_MEM,    P_686 | P_SSE2, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//MOVQ2DQ xmm, mm F3 0F D6 /r 
/* ----------------------------------------------------------------------------------------------- */
{ "movq2dq", 2, { R_XMM,   MMX64       }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),	                        NO_VEX, NO_EVEX,  1, 1, { 0xd6, 0x00, 0x00 }, 8, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF30F, NO_IMM,     NO_MEM,    P_686 | P_SSE2, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//MOVMSKPD reg, xmm 66 0F 50 /r
/* ----------------------------------------------------------------------------------------------- */
{ "movmskpd",    2, { R32,    R_XMM       }, SSE0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),                                NO_VEX, NO_EVEX, 1, 1, { 0x50, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F, NO_IMM,     NO_MEM,    P_686 | P_SSE2, 0, NULL },
{ "movmskpd",    2, { R32E,   R_XMM       }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),                       NO_VEX, NO_EVEX, 1, 1, { 0x50, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F, NO_IMM,     NO_MEM,    P_686 | P_SSE2, 0, NULL },
{ "movmskpd",    2, { R64,    R_XMM       }, SSE0, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),                 NO_VEX, NO_EVEX, 1, 1, { 0x50, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F, NO_IMM,     NO_MEM,    P_686 | P_SSE2, 0, NULL },
{ "movmskpd",    2, { R64E,   R_XMM       }, SSE0, (REX | REXR | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),          NO_VEX, NO_EVEX, 1, 1, { 0x50, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F, NO_IMM,     NO_MEM,    P_686 | P_SSE2, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//MOVMSKPS reg, xmm    NP 0F 50 / r
/* ----------------------------------------------------------------------------------------------- */
{ "movmskps",    2, { R32,    R_XMM       }, SSE0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),                                NO_VEX, NO_EVEX, 1, 1, { 0x50, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF, NO_IMM,     NO_MEM,    P_686 | P_SSE2, 0, NULL },
{ "movmskps",    2, { R32E,   R_XMM       }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),                       NO_VEX, NO_EVEX, 1, 1, { 0x50, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF, NO_IMM,     NO_MEM,    P_686 | P_SSE2, 0, NULL },
{ "movmskps",    2, { R64,    R_XMM       }, SSE0, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),                 NO_VEX, NO_EVEX, 1, 1, { 0x50, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF, NO_IMM,     NO_MEM,    P_686 | P_SSE2, 0, NULL },
{ "movmskps",    2, { R64E,   R_XMM       }, SSE0, (REX | REXR | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),          NO_VEX, NO_EVEX, 1, 1, { 0x50, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF, NO_IMM,     NO_MEM,    P_686 | P_SSE2, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//MOVUPD xmm1, xmm2 / m128    66 0F 10 / r
//MOVUPD xmm2 / m128, xmm1    66 0F 11 / r
/* ----------------------------------------------------------------------------------------------- */
{ "movupd", 2, { R_XMM,    R_XMM       }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),	                        NO_VEX, NO_EVEX,  1, 1, { 0x10, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F, NO_IMM,     NO_MEM,    P_686 | P_SSE2, 0, NULL },
{ "movupd", 2, { R_XMM,    M_ANY       }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),						                            NO_VEX, NO_EVEX,  1, 1, { 0x10, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F, NO_IMM,     MEM_OPND_1,P_686 | P_SSE2, 0, NULL },
{ "movupd", 2, { M_ANY,    R_XMM       }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),	                                      NO_VEX, NO_EVEX,  1, 1, { 0x11, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), RM_DST,  PFX_0x66F, NO_IMM,     MEM_OPND_0,P_686 | P_SSE2, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//MOVUPS xmm1, xmm2 / m128    NP 0F 10 / r
//MOVUPS xmm2 / m128, xmm1    NP 0F 11 / r
/* ----------------------------------------------------------------------------------------------- */
{ "movups", 2, { R_XMM,    R_XMM       }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),	                        NO_VEX, NO_EVEX,  1, 1, { 0x10, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     NO_MEM,    P_686 | P_SSE2, 0, NULL },
{ "movups", 2, { R_XMM,    M_ANY       }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),						                            NO_VEX, NO_EVEX,  1, 1, { 0x10, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     MEM_OPND_1,P_686 | P_SSE2, 0, NULL },
{ "movups", 2, { M_ANY,    R_XMM       }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),	                                      NO_VEX, NO_EVEX,  1, 1, { 0x11, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), RM_DST,  PFX_0xF,    NO_IMM,     MEM_OPND_0,P_686 | P_SSE2, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//MASKMOVDQU xmm1, xmm2    66 0F F7 / r
/* ----------------------------------------------------------------------------------------------- */
{ "maskmovdqu", 2, { R_XMM,    R_XMM   }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),	                        NO_VEX, NO_EVEX,  1, 1, { 0xf7, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F, NO_IMM,     NO_MEM,    P_686 | P_SSE2, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//MASKMOVQ mm1, mm2 NP 0F F7 / r
/* ----------------------------------------------------------------------------------------------- */
{ "maskmovq", 2, { MMX64,    MMX64       }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),	                      NO_VEX, NO_EVEX,  1, 1, { 0xf7, 0x00, 0x00 }, 8, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     NO_MEM,    P_686 | P_SSE2, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//MOVNTDQ m128, xmm1    66 0F E7 / r
/* ----------------------------------------------------------------------------------------------- */
{ "movntdq", 2, { M_ANY,    R_XMM       }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),	                                    NO_VEX, NO_EVEX,  1, 1, { 0xe7, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), RM_DST,  PFX_0x66F, NO_IMM,     MEM_OPND_0, P_686 | P_SSE2, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//MOVNTDQA xmm1, m128 66 0F 38 2A / r
/* ----------------------------------------------------------------------------------------------- */
{ "movntdqa", 2, { R_XMM,   M_ANY       }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),	                                    NO_VEX, NO_EVEX,  1, 1, { 0x2a, 0x00, 0x00 }, 16, 1, MOD_MEM_REG, 0, 0, 0, (X32 | X64), REG_DST,  PFX_0x66F38, NO_IMM,     MEM_OPND_1, P_686 | P_SSE2, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//MOVNTI m32, r32  NP 0F C3 / r 
//MOVNTI m64, r64 NP REX.W + 0F C3 / r 
/* ----------------------------------------------------------------------------------------------- */
{ "movnti",    2, { M_ANY,    R32     }, GP0, (F_MODRM | F_MODRM_REG),				                              NO_VEX, NO_EVEX, 1, 1, { 0xc3, 0x00, 0x00 }, 4, 0, MOD_MEM_REG, 0, 0,	0, (X32 | X64),  RM_DST,  PFX_0xF, NO_IMM    , MEM_OPND_0, P_686 | P_SSE2,  0, NULL },
{ "movnti",    2, { M32,      R32_EAX }, GP0, (F_MODRM | F_MODRM_REG),				                              NO_VEX, NO_EVEX, 1, 1, { 0xc3, 0x00, 0x00 }, 4, 0, MOD_MEM_REG, 0, 0,	0, (X32 | X64),  RM_DST,  PFX_0xF, NO_IMM    , MEM_OPND_0, P_686 | P_SSE2,  0, NULL },
{ "movnti",    2, { M_ANY,    R32_EAX }, GP0, (F_MODRM | F_MODRM_REG),				                              NO_VEX, NO_EVEX, 1, 1, { 0xc3, 0x00, 0x00 }, 4, 0, MOD_MEM_REG, 0, 0,	0, (X32 | X64),  RM_DST,  PFX_0xF, NO_IMM    , MEM_OPND_0, P_686 | P_SSE2,  0, NULL },
{ "movnti",    2, { M_ANY,    R32E    }, GP3, (REX | REXR) | (F_MODRM | F_MODRM_REG),	                      NO_VEX, NO_EVEX, 1, 1, { 0xc3, 0x00, 0x00 }, 4, 0, MOD_MEM_REG, 0, 0,	0, (X64),        RM_DST,  PFX_0xF, NO_IMM    , MEM_OPND_0, P_686 | P_SSE2,  0, NULL },
{ "movnti",    2, { M64,      R64_RAX }, GP3, (REX | REXW) | (F_MODRM | F_MODRM_REG),			                  NO_VEX, NO_EVEX, 1, 1, { 0xc3, 0x00, 0x00 }, 8, 0, MOD_MEM_REG, 0, 0,	0, (X64),        RM_DST,  PFX_0xF, NO_IMM    , MEM_OPND_0, P_686 | P_SSE2,  0, NULL },
{ "movnti",    2, { M_ANY,    R64_RAX }, GP3, (REX | REXW) | (F_MODRM | F_MODRM_REG),			                  NO_VEX, NO_EVEX, 1, 1, { 0xc3, 0x00, 0x00 }, 8, 0, MOD_MEM_REG, 0, 0,	0, (X64),        RM_DST,  PFX_0xF, NO_IMM    , MEM_OPND_0, P_686 | P_SSE2,  0, NULL },
{ "movnti",    2, { M_ANY,    R64     }, GP3, (REX | REXW) | (F_MODRM | F_MODRM_REG),			                  NO_VEX, NO_EVEX, 1, 1, { 0xc3, 0x00, 0x00 }, 8, 0, MOD_MEM_REG, 0, 0,	0, (X64),        RM_DST,  PFX_0xF, NO_IMM    , MEM_OPND_0, P_686 | P_SSE2,  0, NULL },
{ "movnti",    2, { M_ANY,    R64E    }, GP3, (REX | REXW | REXR) | (F_MODRM | F_MODRM_REG),	              NO_VEX, NO_EVEX, 1, 1, { 0xc3, 0x00, 0x00 }, 8, 0, MOD_MEM_REG, 0, 0,	0, (X64),        RM_DST,  PFX_0xF, NO_IMM    , MEM_OPND_0, P_686 | P_SSE2,  0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//MOVNTPD m128, xmm1 66 0F 2B / r
/* ----------------------------------------------------------------------------------------------- */
{ "movntpd", 2, { M_ANY,    R_XMM       }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),	                                    NO_VEX, NO_EVEX,  1, 1, { 0x2b, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), RM_DST,  PFX_0x66F, NO_IMM,     MEM_OPND_0, P_686 | P_SSE2, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//MOVNTPS m128, xmm1 NP 0F 2B / r
{ "movntps", 2, { M_ANY,    R_XMM       }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),	                                    NO_VEX, NO_EVEX,  1, 1, { 0x2b, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), RM_DST,  PFX_0xF,   NO_IMM,     MEM_OPND_0, P_686 | P_SSE2, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//MOVNTQ m64, mm NP 0F E7 / r
/* ----------------------------------------------------------------------------------------------- */
{ "movntq",    2, { M_ANY,    MMX64       }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),						                        NO_VEX, NO_EVEX, 2, 1, { 0xe7, 0x00, 0x00 }, 16, 1, MOD_MEM_REG, 0, 0, 0, (X32 | X64), RM_DST,  PFX_0xF,    NO_IMM,     MEM_OPND_0,P_686 | P_SSE1, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//INS m8,  DX 6C
//INS m16, DX 6D
//INS m32, DX 6D
/* ----------------------------------------------------------------------------------------------- */
{ "ins", 2, { M8,          R16_DX      }, GP0,  ALLOW_REP,													                                    NO_VEX, NO_EVEX,  1, 1, { 0x6c, 0x00, 0x00 }, 1,  2, NO_MOD,      0, 0, ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), NO_DST,  NO_PREFIX,  NO_IMM,     MEM_OPND_0,     P_386,           0, NULL },
{ "ins", 2, { M16,         R16_DX      }, GP2,  ALLOW_REP,													                                    NO_VEX, NO_EVEX,  1, 1, { 0x6d, 0x00, 0x00 }, 2,  2, NO_MOD,      0, OP_SIZE_OVERRIDE, ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), NO_DST,  NO_PREFIX,  NO_IMM,     MEM_OPND_0,     P_386,           0, NULL },
{ "ins", 2, { M32,         R16_DX      }, GP2,  ALLOW_REP,													                                    NO_VEX, NO_EVEX,  1, 1, { 0x6d, 0x00, 0x00 }, 4,  2, NO_MOD,      0, 0, ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), NO_DST,  NO_PREFIX,  NO_IMM,     MEM_OPND_0,     P_386,           0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//INSB        6C
/* ----------------------------------------------------------------------------------------------- */
{ "insb", 0, { OP_N,     OP_N        }, GP1,  ALLOW_REP,													                                    NO_VEX, NO_EVEX,  1, 1, { 0x6c, 0x00, 0x00 }, 1,  0, NO_MOD,      0, 0, 0, (X16 | X32 | X64), NO_DST,  NO_PREFIX,  NO_IMM,     NO_MEM,     P_86,           0, NULL },
{ "insb", 2, { M8,       R16_DX      }, GP2,  ALLOW_REP,													                                    NO_VEX, NO_EVEX,  1, 1, { 0x6c, 0x00, 0x00 }, 1,  2, NO_MOD,      0, 0, ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), NO_DST,  NO_PREFIX,  NO_IMM,     MEM_OPND_0,     P_386,           0, NULL },
{ "insb", 2, { M_ANY,    R16_DX      }, GP2,  ALLOW_REP,													                                    NO_VEX, NO_EVEX,  1, 1, { 0x6c, 0x00, 0x00 }, 1,  2, NO_MOD,      0, 0, ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), NO_DST,  NO_PREFIX,  NO_IMM,     MEM_OPND_0,     P_386,           0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//INSW        6D
/* ----------------------------------------------------------------------------------------------- */
{ "insw", 0, { OP_N,     OP_N        }, GP1,  ALLOW_REP,													                                    NO_VEX, NO_EVEX,  1, 1, { 0x6d, 0x00, 0x00 }, 2,  0, NO_MOD,      0, 0, 0, (X16 | X32 | X64), NO_DST,  NO_PREFIX,  NO_IMM,     NO_MEM,     P_86,           0, NULL },
{ "insw", 2, { M16,      R16_DX      }, GP2,  ALLOW_REP,													                                    NO_VEX, NO_EVEX,  1, 1, { 0x6d, 0x00, 0x00 }, 2,  2, NO_MOD,      0, OP_SIZE_OVERRIDE, ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), NO_DST,  NO_PREFIX,  NO_IMM,     MEM_OPND_0,     P_386,           0, NULL },
{ "insw", 2, { M_ANY,    R16_DX      }, GP2,  ALLOW_REP,													                                    NO_VEX, NO_EVEX,  1, 1, { 0x6d, 0x00, 0x00 }, 2,  2, NO_MOD,      0, OP_SIZE_OVERRIDE, ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), NO_DST,  NO_PREFIX,  NO_IMM,     MEM_OPND_0,     P_386,           0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//INSD        6D
/* ----------------------------------------------------------------------------------------------- */
{ "insd", 0, { OP_N,     OP_N        }, GP1,  ALLOW_REP,													                                    NO_VEX, NO_EVEX,  1, 1, { 0x6d, 0x00, 0x00 }, 1,  0, NO_MOD,      0, 0, 0, (X16 | X32 | X64), NO_DST,  NO_PREFIX,  NO_IMM,     NO_MEM,     P_86,           0, NULL },
{ "insd", 2, { M32,      R16_DX      }, GP2,  ALLOW_REP,													                                    NO_VEX, NO_EVEX,  1, 1, { 0x6d, 0x00, 0x00 }, 4,  2, NO_MOD,      0, 0, ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), NO_DST,  NO_PREFIX,  NO_IMM,     MEM_OPND_0,     P_386,           0, NULL },
{ "insd", 2, { M_ANY,    R16_DX      }, GP2,  ALLOW_REP,													                                    NO_VEX, NO_EVEX,  1, 1, { 0x6d, 0x00, 0x00 }, 4,  2, NO_MOD,      0, 0, ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), NO_DST,  NO_PREFIX,  NO_IMM,     MEM_OPND_0,     P_386,           0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//6E OUTS DX, m8
//6F OUTS DX, m16
//6F OUTS DX, m32
//6E OUTSB
//6F OUTSW
//6F OUTSD
/* ----------------------------------------------------------------------------------------------- */
{ "outs", 2, { R16_DX,       M8       }, GP0,  ALLOW_REP,													                                    NO_VEX, NO_EVEX,  1, 1, { 0x6e, 0x00, 0x00 }, 1,  2, NO_MOD,      0, 0, ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), NO_DST,  NO_PREFIX,  NO_IMM,     MEM_OPND_1,     P_386,           0, NULL },
{ "outs", 2, { R16_DX,       M16      }, GP2,  ALLOW_REP,													                                    NO_VEX, NO_EVEX,  1, 1, { 0x6f, 0x00, 0x00 }, 2,  2, NO_MOD,      0, OP_SIZE_OVERRIDE, ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), NO_DST,  NO_PREFIX,  NO_IMM,     MEM_OPND_1,     P_386,           0, NULL },
{ "outs", 2, { R16_DX,       M32      }, GP2,  ALLOW_REP,													                                    NO_VEX, NO_EVEX,  1, 1, { 0x6f, 0x00, 0x00 }, 4,  2, NO_MOD,      0, 0, ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), NO_DST,  NO_PREFIX,  NO_IMM,     MEM_OPND_1,     P_386,           0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//INSB        6C
/* ----------------------------------------------------------------------------------------------- */
{ "outsb", 0, { OP_N,        OP_N     }, GP1,  ALLOW_REP,													                                    NO_VEX, NO_EVEX,  1, 1, { 0x6e, 0x00, 0x00 }, 1,  0, NO_MOD,      0, 0, 0, (X16 | X32 | X64), NO_DST,  NO_PREFIX,  NO_IMM,     NO_MEM,     P_86,           0, NULL },
{ "outsb", 2, { R16_DX,      M8       }, GP2,  ALLOW_REP,													                                    NO_VEX, NO_EVEX,  1, 1, { 0x6e, 0x00, 0x00 }, 1,  2, NO_MOD,      0, 0, ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), NO_DST,  NO_PREFIX,  NO_IMM,     MEM_OPND_1,     P_386,           0, NULL },
{ "outsb", 2, { R16_DX,      M_ANY    }, GP2,  ALLOW_REP,													                                    NO_VEX, NO_EVEX,  1, 1, { 0x6e, 0x00, 0x00 }, 1,  2, NO_MOD,      0, 0, ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), NO_DST,  NO_PREFIX,  NO_IMM,     MEM_OPND_1,     P_386,           0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//INSW        6D
/* ----------------------------------------------------------------------------------------------- */
{ "outsw", 0, { OP_N,        OP_N     }, GP1,  ALLOW_REP,													                                    NO_VEX, NO_EVEX,  1, 1, { 0x6f, 0x00, 0x00 }, 2,  0, NO_MOD,      0, 0, 0, (X16 | X32 | X64), NO_DST,  NO_PREFIX,  NO_IMM,     NO_MEM,     P_86,           0, NULL },
{ "outsw", 2, { R16_DX,      M16      }, GP2,  ALLOW_REP,													                                    NO_VEX, NO_EVEX,  1, 1, { 0x6f, 0x00, 0x00 }, 2,  2, NO_MOD,      0, OP_SIZE_OVERRIDE, ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), NO_DST,  NO_PREFIX,  NO_IMM,     MEM_OPND_1,     P_386,           0, NULL },
{ "outsw", 2, { R16_DX,      M_ANY    }, GP2,  ALLOW_REP,													                                    NO_VEX, NO_EVEX,  1, 1, { 0x6f, 0x00, 0x00 }, 2,  2, NO_MOD,      0, OP_SIZE_OVERRIDE, ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), NO_DST,  NO_PREFIX,  NO_IMM,     MEM_OPND_1,     P_386,           0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//OUT imm8, AL  I  Valid Valid    E6 ib
//OUT imm8, AX  I  Valid Valid    E7 ib
//OUT imm8, EAX I  Valid Valid    E7 ib
//OUT DX, AL    ZO Valid Valid    EE
//OUT DX, AX    ZO Valid Valid    EF
//OUT DX, EAX   ZO Valid Valid    EF
/* ----------------------------------------------------------------------------------------------- */
{ "out",    2, { IMM8,     R8_AL      }, GP0,  ALLOW_REP,												                                      NO_VEX, NO_EVEX,  1, 1, { 0xe6, 0x00, 0x00 }, 1,  2, NO_MOD,      0, 0, 0,                (X16 | X32 | X64), NO_DST,  NO_PREFIX, IMM_OPND_0,  NO_MEM,     P_86,  0, NULL },
{ "out",    2, { IMM8,     R16_AX     }, GP0,  ALLOW_REP,												                                      NO_VEX, NO_EVEX,  2, 1, { 0xe7, 0x00, 0x00 }, 1,  2, NO_MOD,      0, OP_SIZE_OVERRIDE, 0, (X16 | X32 | X64), NO_DST,  NO_PREFIX, IMM_OPND_0,  NO_MEM,     P_86,  0, NULL },
{ "out",    2, { IMM8,     R32_EAX    }, GP0,  ALLOW_REP,												                                      NO_VEX, NO_EVEX,  4, 1, { 0xe7, 0x00, 0x00 }, 1,  2, NO_MOD,      0, 0, 0,                (X16 | X32 | X64), NO_DST,  NO_PREFIX, IMM_OPND_0,  NO_MEM,     P_86,  0, NULL },
{ "out",    2, { R16_DX,   R8_AL      }, GP0,  ALLOW_REP,													                                    NO_VEX, NO_EVEX,  1, 1, { 0xee, 0x00, 0x00 }, 1,  2, NO_MOD,      0, 0, 0,                (X16 | X32 | X64), NO_DST,  NO_PREFIX,  NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "out",    2, { R16_DX,   R16_AX     }, GP2,  ALLOW_REP,													                                    NO_VEX, NO_EVEX,  2, 1, { 0xef, 0x00, 0x00 }, 1,  2, NO_MOD,      0, OP_SIZE_OVERRIDE, 0, (X16 | X32 | X64), NO_DST,  NO_PREFIX,  NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "out",    2, { R16_DX,   R32_EAX    }, GP2,  ALLOW_REP,													                                    NO_VEX, NO_EVEX,  4, 1, { 0xef, 0x00, 0x00 }, 1,  2, NO_MOD,      0, 0, 0,                (X16 | X32 | X64), NO_DST,  NO_PREFIX,  NO_IMM,     NO_MEM,     P_86,  0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//OUTSD        6D
/* ----------------------------------------------------------------------------------------------- */
{ "outsd", 0, { OP_N,        OP_N     }, GP1,  ALLOW_REP,													                                    NO_VEX, NO_EVEX,  1, 1, { 0x6f, 0x00, 0x00 }, 1,  0, NO_MOD,      0, 0, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX,  NO_IMM,     NO_MEM,         P_86,            0, NULL },
{ "outsd", 2, { R16_DX,      M32      }, GP2,  ALLOW_REP,													                                    NO_VEX, NO_EVEX,  1, 1, { 0x6f, 0x00, 0x00 }, 4,  2, NO_MOD,      0, 0, ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), NO_DST,  NO_PREFIX,  NO_IMM,     MEM_OPND_1,     P_386,           0, NULL },
{ "outsd", 2, { R16_DX,      M_ANY    }, GP2,  ALLOW_REP,													                                    NO_VEX, NO_EVEX,  1, 1, { 0x6f, 0x00, 0x00 }, 4,  2, NO_MOD,      0, 0, ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), NO_DST,  NO_PREFIX,  NO_IMM,     MEM_OPND_1,     P_386,           0, NULL },
/* ----------------------------------------------------------------------------------------------- */
// IN AL,   imm8  E4 ib
// IN AX,   imm8  E5 ib
// IN EAX,  imm8  E5 ib
/* ----------------------------------------------------------------------------------------------- */
{ "in",     2, { R8_AL,        IMM8    }, GP0,  ALLOW_REP,													                                    NO_VEX, NO_EVEX,  1, 1, { 0xe4, 0x00, 0x00 }, 1,  0, NO_MOD,      0, 0, 0, (X16 | X32 | X64), NO_DST,  NO_PREFIX,  IMM_OPND_1,     NO_MEM,     P_86,           0, NULL },
{ "in",     2, { R16_AX,       IMM8    }, GP0,  ALLOW_REP,													                                    NO_VEX, NO_EVEX,  1, 1, { 0xe5, 0x00, 0x00 }, 1,  0, NO_MOD,      0, OP_SIZE_OVERRIDE, 0, (X16 | X32 | X64), NO_DST,  NO_PREFIX,  IMM_OPND_1,     NO_MEM,     P_86,           0, NULL },
{ "in",     2, { R32_EAX,      IMM8    }, GP0,  ALLOW_REP,													                                    NO_VEX, NO_EVEX,  1, 1, { 0xe5, 0x00, 0x00 }, 1,  0, NO_MOD,      0, 0, 0, (X16 | X32 | X64), NO_DST,  NO_PREFIX,  IMM_OPND_1,     NO_MEM,     P_86,           0, NULL },
/* ----------------------------------------------------------------------------------------------- */
// IN AL,   DX    EC
// IN AX,   DX    ED
// IN EAX,  DX    ED
/* ----------------------------------------------------------------------------------------------- */
{ "in",     2, { R8_AL,        R16_DX  }, GP0,  ALLOW_REP,													                                    NO_VEX, NO_EVEX,  1, 1, { 0xec, 0x00, 0x00 }, 1,  0, NO_MOD,      0, 0, 0, (X16 | X32 | X64), NO_DST,  NO_PREFIX,  NO_IMM,     NO_MEM,     P_86,           0, NULL },
{ "in",     2, { R16_AX,       R16_DX  }, GP0,  ALLOW_REP,													                                    NO_VEX, NO_EVEX,  1, 1, { 0xed, 0x00, 0x00 }, 2,  0, NO_MOD,      0, OP_SIZE_OVERRIDE, 0, (X16 | X32 | X64), NO_DST,  NO_PREFIX,  NO_IMM,     NO_MEM,     P_86,           0, NULL },
{ "in",     2, { R32_EAX,      R16_DX  }, GP0,  ALLOW_REP,													                                    NO_VEX, NO_EVEX,  1, 1, { 0xed, 0x00, 0x00 }, 4,  0, NO_MOD,      0, 0, 0, (X16 | X32 | X64), NO_DST,  NO_PREFIX,  NO_IMM,     NO_MEM,     P_86,           0, NULL },
/* ----------------------------------------------------------------------------------------------- */
{ "int",     1, {  OP_N,   OP_N }, GP0,  (NO_FLAGS),													                                    NO_VEX, NO_EVEX,  1, 1, { 0xcc, 0x00, 0x00 }, 1,  0, NO_MOD,      0, 0, 0, (X16 | X32 | X64), NO_DST,  NO_PREFIX,  NO_IMM,     NO_MEM,     P_86,           0, NULL },
{ "int",     1, {  IMM8,   OP_N }, GP0,  (NO_FLAGS),													                                    NO_VEX, NO_EVEX,  1, 1, { 0xcd, 0x00, 0x00 }, 1,  0, NO_MOD,      0, 0, 0, (X16 | X32 | X64), NO_DST,  NO_PREFIX,  IMM_OPND_0,     NO_MEM,     P_86,           0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//INVLPG, invlpg, OpCls(M_ANY, NONE, NONE), F_0F, 0, no_WDS, 0x01, 0x38, P_486, 0)
/* ----------------------------------------------------------------------------------------------- */
{ "invlpg", 1,  { M8,          }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_RM | OPCODE_EXT),                    NO_VEX, NO_EVEX, 1, 1, { 0x1, 0x00, 0x00 }, 1, 1, 0x38, 0, 0, 0, (X32 | X64), RM_DST, PFX_0xF, NO_IMM, MEM_OPND_0, P_486, 0, NULL },
{ "invlpg", 1,  { M16,         }, GP2, ALLOW_SEG | (F_MODRM | F_MODRM_RM | OPCODE_EXT),                    NO_VEX, NO_EVEX, 2, 1, { 0x1, 0x00, 0x00 }, 1, 1, 0x38, 0, OP_SIZE_OVERRIDE, ADDR_SIZE_OVERRIDE, (X32 | X64), RM_DST, PFX_0xF, NO_IMM, MEM_OPND_0, P_486, 0, NULL },
{ "invlpg", 1,  { M32,         }, GP2, ALLOW_SEG | (F_MODRM | F_MODRM_RM | OPCODE_EXT),                    NO_VEX, NO_EVEX, 4, 1, { 0x1, 0x00, 0x00 }, 1, 1, 0x38, 0, 0, ADDR_SIZE_OVERRIDE, (X32 | X64), RM_DST, PFX_0xF, NO_IMM, MEM_OPND_0, P_486, 0, NULL },
{ "invlpg", 1,  { M64,         }, GP3, ALLOW_SEG | (REX | REXW)| (F_MODRM | F_MODRM_RM | OPCODE_EXT),      NO_VEX, NO_EVEX, 8, 1, { 0x1, 0x00, 0x00 }, 1, 1, 0x38, 0, 0, 0, (X32 | X64), RM_DST, PFX_0xF, NO_IMM, MEM_OPND_0, P_486, 0, NULL },
{ "invlpg", 1,  { M_ANY,       }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_RM | OPCODE_EXT),                    NO_VEX, NO_EVEX, 1, 1, { 0x1, 0x00, 0x00 }, 1, 1, 0x38, 0, 0, ADDR_SIZE_OVERRIDE, (X32 | X64), RM_DST, PFX_0xF, NO_IMM, MEM_OPND_0, P_486, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
/* DIV */
/* ----------------------------------------------------------------------------------------------- */
{ "div",    1, { R8_AL,    OP_N    }, GP0,  (F_OPCODE2_REG),													                              NO_VEX, NO_EVEX, 1, 2, { 0xf6, 0xf0, 0x00 }, 1,  0, NO_MOD,      0, 0, 0, (X16 | X32 | X64), REG_DST,  NO_PREFIX,  NO_IMM,     NO_MEM,     P_86,           0, NULL },
{ "div",    1, { R8_CL,    OP_N    }, GP0,  (F_OPCODE2_REG),													                              NO_VEX, NO_EVEX, 1, 2, { 0xf6, 0xf0, 0x00 }, 1,  0, NO_MOD,      0, 0, 0, (X16 | X32 | X64), REG_DST,  NO_PREFIX,  NO_IMM,     NO_MEM,     P_86,           0, NULL },
{ "div",    1, { R8,       OP_N    }, GP0,  (F_OPCODE2_REG),													                              NO_VEX, NO_EVEX, 1, 2, { 0xf6, 0xf0, 0x00 }, 1,  0, NO_MOD,      0, 0, 0, (X16 | X32 | X64), REG_DST,  NO_PREFIX,  NO_IMM,     NO_MEM,     P_86,           0, NULL },
{ "div",    1, { R8E,      OP_N    }, GP3,  (REX | REXB) | (F_OPCODE2_REG),													                NO_VEX, NO_EVEX, 1, 2, { 0xf6, 0xf0, 0x00 }, 1,  0, NO_MOD,      0, 0, 0, (X64), REG_DST,  NO_PREFIX,  NO_IMM,     NO_MEM,     P_64,           0, NULL },
{ "div",    1, { R8U,      OP_N    }, GP3,  (REX) | (F_OPCODE2_REG),													                      NO_VEX, NO_EVEX, 1, 2, { 0xf6, 0xf0, 0x00 }, 1,  0, NO_MOD,      0, 0, 0, (X64), REG_DST,  NO_PREFIX,  NO_IMM,     NO_MEM,     P_64,           0, NULL },
{ "div",    1, { R16_AX,   OP_N    }, GP0,  (F_OPCODE2_REG),													                              NO_VEX, NO_EVEX, 1, 2, { 0xf7, 0xf0, 0x00 }, 2,  0, NO_MOD,      0, OP_SIZE_OVERRIDE, 0, (X16 | X32 | X64), REG_DST,  NO_PREFIX,  NO_IMM,     NO_MEM,     P_86,           0, NULL },
{ "div",    1, { R16,      OP_N    }, GP0,  (F_OPCODE2_REG),													                              NO_VEX, NO_EVEX, 1, 2, { 0xf7, 0xf0, 0x00 }, 2,  0, NO_MOD,      0, OP_SIZE_OVERRIDE, 0, (X16 | X32 | X64), REG_DST,  NO_PREFIX,  NO_IMM,     NO_MEM,     P_86,           0, NULL },
{ "div",    1, { R16E,     OP_N    }, GP3,  (REX | REXB) | (F_OPCODE2_REG),													                NO_VEX, NO_EVEX, 1, 2, { 0xf7, 0xf0, 0x00 }, 2,  0, NO_MOD,      0, OP_SIZE_OVERRIDE, 0, (X64), REG_DST,  NO_PREFIX,  NO_IMM,     NO_MEM,     P_64,           0, NULL },
{ "div",    1, { R32,      OP_N    }, GP0,  (F_OPCODE2_REG),												                                NO_VEX, NO_EVEX, 1, 2, { 0xf7, 0xf0, 0x00 }, 4,  0, NO_MOD,      0, 0, 0, (X16 | X32 | X64), REG_DST,  NO_PREFIX,  NO_IMM,     NO_MEM,     P_86,           0, NULL },
{ "div",    1, { R32_EAX,  OP_N    }, GP0,  (F_OPCODE2_REG),												                                NO_VEX, NO_EVEX, 1, 2, { 0xf7, 0xf0, 0x00 }, 4,  0, NO_MOD,      0, 0, 0, (X16 | X32 | X64), REG_DST,  NO_PREFIX,  NO_IMM,     NO_MEM,     P_86,           0, NULL },
{ "div",    1, { R32E,     OP_N    }, GP3,  (REX | REXB) | (F_OPCODE2_REG),												                  NO_VEX, NO_EVEX, 1, 2, { 0xf7, 0xf0, 0x00 }, 4,  0, NO_MOD,      0, 0, 0, (X64), REG_DST,  NO_PREFIX,  NO_IMM,     NO_MEM,     P_64,           0, NULL },
{ "div",    1, { R64,      OP_N    }, GP3,  (REX | REXW) | (F_OPCODE2_REG),												                  NO_VEX, NO_EVEX, 1, 2, { 0xf7, 0xf0, 0x00 }, 8,  0, NO_MOD,      0, 0, 0, (X16 | X32 | X64), REG_DST,  NO_PREFIX,  NO_IMM,     NO_MEM,     P_64,           0, NULL },
{ "div",    1, { R64_RAX,  OP_N    }, GP3,  (REX | REXW) | (F_OPCODE2_REG),												                  NO_VEX, NO_EVEX, 1, 2, { 0xf7, 0xf0, 0x00 }, 8,  0, NO_MOD,      0, 0, 0, (X16 | X32 | X64), REG_DST,  NO_PREFIX,  NO_IMM,     NO_MEM,     P_64,           0, NULL },
{ "div",    1, { R64E,     OP_N    }, GP3,  (REX | REXW | REXB) | (F_OPCODE2_REG),												          NO_VEX, NO_EVEX, 1, 2, { 0xf7, 0xf0, 0x00 }, 8,  0, NO_MOD,      0, 0, 0, (X16 | X32 | X64), REG_DST,  NO_PREFIX,  NO_IMM,     NO_MEM,     P_64,           0, NULL },
{ "div",    1, { M8,       OP_N    }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_RM | OPCODE_EXT),                         NO_VEX, NO_EVEX, 1, 1, { 0xf6, 0x00, 0x00 }, 1, 1, 0x30, 0, 0, 0, (X32 | X64), RM_DST, NO_PREFIX, NO_IMM, MEM_OPND_0, P_486, 0, NULL },
{ "div",    1, { M16,      OP_N    }, GP2, ALLOW_SEG | (F_MODRM | F_MODRM_RM | OPCODE_EXT),                         NO_VEX, NO_EVEX, 1, 1, { 0xf7, 0x00, 0x00 }, 2, 1, 0x30, 0, OP_SIZE_OVERRIDE, ADDR_SIZE_OVERRIDE, (X32 | X64), RM_DST, NO_PREFIX, NO_IMM, MEM_OPND_0, P_486, 0, NULL },
{ "div",    1, { M32,      OP_N    }, GP2, ALLOW_SEG | (F_MODRM | F_MODRM_RM | OPCODE_EXT),                         NO_VEX, NO_EVEX, 1, 1, { 0xf7, 0x00, 0x00 }, 4, 1, 0x30, 0, 0, ADDR_SIZE_OVERRIDE, (X32 | X64), RM_DST, NO_PREFIX, NO_IMM, MEM_OPND_0, P_486, 0, NULL },
{ "div",    1, { M64,      OP_N    }, GP3, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_RM | OPCODE_EXT),          NO_VEX, NO_EVEX, 1, 1, { 0xf7, 0x00, 0x00 }, 8, 1, 0x30, 0, 0, 0, (X32 | X64), RM_DST, NO_PREFIX, NO_IMM, MEM_OPND_0, P_486, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
/* IDIV */
/* ----------------------------------------------------------------------------------------------- */
{ "idiv",    1, { R8_AL,    OP_N    }, GP0,  (F_OPCODE2_REG),													                                NO_VEX, NO_EVEX, 1, 2, { 0xf6, 0xf8, 0x00 }, 1,  0, NO_MOD,      0, 0, 0, (X16 | X32 | X64), REG_DST,  NO_PREFIX,  NO_IMM,     NO_MEM,     P_86,           0, NULL },
{ "idiv",    1, { R8_CL,    OP_N    }, GP0,  (F_OPCODE2_REG),													                                NO_VEX, NO_EVEX, 1, 2, { 0xf6, 0xf8, 0x00 }, 1,  0, NO_MOD,      0, 0, 0, (X16 | X32 | X64), REG_DST,  NO_PREFIX,  NO_IMM,     NO_MEM,     P_86,           0, NULL },
{ "idiv",    1, { R8,       OP_N    }, GP0,  (F_OPCODE2_REG),													                                NO_VEX, NO_EVEX, 1, 2, { 0xf6, 0xf8, 0x00 }, 1,  0, NO_MOD,      0, 0, 0, (X16 | X32 | X64), REG_DST,  NO_PREFIX,  NO_IMM,     NO_MEM,     P_86,           0, NULL },
{ "idiv",    1, { R8E,      OP_N    }, GP3,  (REX | REXB) | (F_OPCODE2_REG),													                NO_VEX, NO_EVEX, 1, 2, { 0xf6, 0xf8, 0x00 }, 1,  0, NO_MOD,      0, 0, 0, (X64), REG_DST,  NO_PREFIX,  NO_IMM,     NO_MEM,     P_64,           0, NULL },
{ "idiv",    1, { R8U,      OP_N    }, GP3,  (REX) | (F_OPCODE2_REG),													                        NO_VEX, NO_EVEX, 1, 2, { 0xf6, 0xf8, 0x00 }, 1,  0, NO_MOD,      0, 0, 0, (X64), REG_DST,  NO_PREFIX,  NO_IMM,     NO_MEM,     P_64,           0, NULL },
{ "idiv",    1, { R16_AX,   OP_N    }, GP0,  (F_OPCODE2_REG),													                                NO_VEX, NO_EVEX, 1, 2, { 0xf7, 0xf8, 0x00 }, 2,  0, NO_MOD,      0, OP_SIZE_OVERRIDE, 0, (X16 | X32 | X64), REG_DST,  NO_PREFIX,  NO_IMM,     NO_MEM,     P_86,           0, NULL },
{ "idiv",    1, { R16,      OP_N    }, GP0,  (F_OPCODE2_REG),													                                NO_VEX, NO_EVEX, 1, 2, { 0xf7, 0xf8, 0x00 }, 2,  0, NO_MOD,      0, OP_SIZE_OVERRIDE, 0, (X16 | X32 | X64), REG_DST,  NO_PREFIX,  NO_IMM,     NO_MEM,     P_86,           0, NULL },
{ "idiv",    1, { R16E,     OP_N    }, GP3,  (REX | REXB) | (F_OPCODE2_REG),													                NO_VEX, NO_EVEX, 1, 2, { 0xf7, 0xf8, 0x00 }, 2,  0, NO_MOD,      0, OP_SIZE_OVERRIDE, 0, (X64), REG_DST,  NO_PREFIX,  NO_IMM,     NO_MEM,     P_64,           0, NULL },
{ "idiv",    1, { R32,      OP_N    }, GP0,  (F_OPCODE2_REG),												                                  NO_VEX, NO_EVEX, 1, 2, { 0xf7, 0xf8, 0x00 }, 4,  0, NO_MOD,      0, 0, 0, (X16 | X32 | X64), REG_DST,  NO_PREFIX,  NO_IMM,     NO_MEM,     P_86,           0, NULL },
{ "idiv",    1, { R32_EAX,  OP_N    }, GP0,  (F_OPCODE2_REG),												                                  NO_VEX, NO_EVEX, 1, 2, { 0xf7, 0xf8, 0x00 }, 4,  0, NO_MOD,      0, 0, 0, (X16 | X32 | X64), REG_DST,  NO_PREFIX,  NO_IMM,     NO_MEM,     P_86,           0, NULL },
{ "idiv",    1, { R32E,     OP_N    }, GP3,  (REX | REXB) | (F_OPCODE2_REG),												                  NO_VEX, NO_EVEX, 1, 2, { 0xf7, 0xf8, 0x00 }, 4,  0, NO_MOD,      0, 0, 0, (X64), REG_DST,  NO_PREFIX,  NO_IMM,     NO_MEM,     P_64,           0, NULL },
{ "idiv",    1, { R64,      OP_N    }, GP3,  (REX | REXW) | (F_OPCODE2_REG),												                  NO_VEX, NO_EVEX, 1, 2, { 0xf7, 0xf8, 0x00 }, 8,  0, NO_MOD,      0, 0, 0, (X16 | X32 | X64), REG_DST,  NO_PREFIX,  NO_IMM,     NO_MEM,     P_64,           0, NULL },
{ "idiv",    1, { R64_RAX,  OP_N    }, GP3,  (REX | REXW) | (F_OPCODE2_REG),												                  NO_VEX, NO_EVEX, 1, 2, { 0xf7, 0xf8, 0x00 }, 8,  0, NO_MOD,      0, 0, 0, (X16 | X32 | X64), REG_DST,  NO_PREFIX,  NO_IMM,     NO_MEM,     P_64,           0, NULL },
{ "idiv",    1, { R64E,     OP_N    }, GP3,  (REX | REXW | REXB) | (F_OPCODE2_REG),												            NO_VEX, NO_EVEX, 1, 2, { 0xf7, 0xf8, 0x00 }, 8,  0, NO_MOD,      0, 0, 0, (X16 | X32 | X64), REG_DST,  NO_PREFIX,  NO_IMM,     NO_MEM,     P_64,           0, NULL },
{ "idiv",    1, { M8,       OP_N    }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_RM | OPCODE_EXT),                          NO_VEX, NO_EVEX, 1, 1, { 0xf6, 0x00, 0x00 }, 1, 1, 0x38, 0, 0, 0, (X32 | X64), RM_DST, NO_PREFIX, NO_IMM, MEM_OPND_0, P_486, 0, NULL },
{ "idiv",    1, { M16,      OP_N    }, GP2, ALLOW_SEG | (F_MODRM | F_MODRM_RM | OPCODE_EXT),                          NO_VEX, NO_EVEX, 1, 1, { 0xf7, 0x00, 0x00 }, 2, 1, 0x38, 0, OP_SIZE_OVERRIDE, ADDR_SIZE_OVERRIDE, (X32 | X64), RM_DST, NO_PREFIX, NO_IMM, MEM_OPND_0, P_486, 0, NULL },
{ "idiv",    1, { M32,      OP_N    }, GP2, ALLOW_SEG | (F_MODRM | F_MODRM_RM | OPCODE_EXT),                          NO_VEX, NO_EVEX, 1, 1, { 0xf7, 0x00, 0x00 }, 4, 1, 0x38, 0, 0, ADDR_SIZE_OVERRIDE, (X32 | X64), RM_DST, NO_PREFIX, NO_IMM, MEM_OPND_0, P_486, 0, NULL },
{ "idiv",    1, { M64,      OP_N    }, GP3, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_RM | OPCODE_EXT),           NO_VEX, NO_EVEX, 1, 1, { 0xf7, 0x00, 0x00 }, 8, 1, 0x38, 0, 0, 0, (X32 | X64), RM_DST, NO_PREFIX, NO_IMM, MEM_OPND_0, P_486, 0, NULL },

/* ----------------------------------------------------------------------------------------------- */
/* NEG */
/* ----------------------------------------------------------------------------------------------- */
{ "neg",    1, { R8_AL,    OP_N    }, GP0,  (F_OPCODE2_REG),													                              NO_VEX, NO_EVEX, 1, 2, { 0xf6, 0xd8, 0x00 }, 1,  0, NO_MOD,      0, 0, 0, (X16 | X32 | X64), REG_DST,  NO_PREFIX,  NO_IMM,     NO_MEM,     P_86,           0, NULL },
{ "neg",    1, { R8_CL,    OP_N    }, GP0,  (F_OPCODE2_REG),													                              NO_VEX, NO_EVEX, 1, 2, { 0xf6, 0xd8, 0x00 }, 1,  0, NO_MOD,      0, 0, 0, (X16 | X32 | X64), REG_DST,  NO_PREFIX,  NO_IMM,     NO_MEM,     P_86,           0, NULL },
{ "neg",    1, { R8,       OP_N    }, GP0,  (F_OPCODE2_REG),													                              NO_VEX, NO_EVEX, 1, 2, { 0xf6, 0xd8, 0x00 }, 1,  0, NO_MOD,      0, 0, 0, (X16 | X32 | X64), REG_DST,  NO_PREFIX,  NO_IMM,     NO_MEM,     P_86,           0, NULL },
{ "neg",    1, { R8E,      OP_N    }, GP3,  (REX | REXB) | (F_OPCODE2_REG),													                NO_VEX, NO_EVEX, 1, 2, { 0xf6, 0xd8, 0x00 }, 1,  0, NO_MOD,      0, 0, 0, (X64), REG_DST,  NO_PREFIX,  NO_IMM,     NO_MEM,     P_64,           0, NULL },
{ "neg",    1, { R8U,      OP_N    }, GP3,  (REX) | (F_OPCODE2_REG),													                      NO_VEX, NO_EVEX, 1, 2, { 0xf6, 0xd8, 0x00 }, 1,  0, NO_MOD,      0, 0, 0, (X64), REG_DST,  NO_PREFIX,  NO_IMM,     NO_MEM,     P_64,           0, NULL },
{ "neg",    1, { R16_AX,   OP_N    }, GP0,  (F_OPCODE2_REG),													                              NO_VEX, NO_EVEX, 1, 2, { 0xf7, 0xd8, 0x00 }, 2,  0, NO_MOD,      0, OP_SIZE_OVERRIDE, 0, (X16 | X32 | X64), REG_DST,  NO_PREFIX,  NO_IMM,     NO_MEM,     P_86,           0, NULL },
{ "neg",    1, { R16,      OP_N    }, GP0,  (F_OPCODE2_REG),													                              NO_VEX, NO_EVEX, 1, 2, { 0xf7, 0xd8, 0x00 }, 2,  0, NO_MOD,      0, OP_SIZE_OVERRIDE, 0, (X16 | X32 | X64), REG_DST,  NO_PREFIX,  NO_IMM,     NO_MEM,     P_86,           0, NULL },
{ "neg",    1, { R16E,     OP_N    }, GP3,  (REX | REXB) | (F_OPCODE2_REG),													                NO_VEX, NO_EVEX, 1, 2, { 0xf7, 0xd8, 0x00 }, 2,  0, NO_MOD,      0, OP_SIZE_OVERRIDE, 0, (X64), REG_DST,  NO_PREFIX,  NO_IMM,     NO_MEM,     P_64,           0, NULL },
{ "neg",    1, { R32,      OP_N    }, GP0,  (F_OPCODE2_REG),												                                NO_VEX, NO_EVEX, 1, 2, { 0xf7, 0xd8, 0x00 }, 4,  0, NO_MOD,      0, 0, 0, (X16 | X32 | X64), REG_DST,  NO_PREFIX,  NO_IMM,     NO_MEM,     P_86,           0, NULL },
{ "neg",    1, { R32_EAX,  OP_N    }, GP0,  (F_OPCODE2_REG),												                                NO_VEX, NO_EVEX, 1, 2, { 0xf7, 0xd8, 0x00 }, 4,  0, NO_MOD,      0, 0, 0, (X16 | X32 | X64), REG_DST,  NO_PREFIX,  NO_IMM,     NO_MEM,     P_86,           0, NULL },
{ "neg",    1, { R32E,     OP_N    }, GP3,  (REX | REXB) | (F_OPCODE2_REG),												                  NO_VEX, NO_EVEX, 1, 2, { 0xf7, 0xd8, 0x00 }, 4,  0, NO_MOD,      0, 0, 0, (X64), REG_DST,  NO_PREFIX,  NO_IMM,     NO_MEM,     P_64,           0, NULL },
{ "neg",    1, { R64,      OP_N    }, GP3,  (REX | REXW) | (F_OPCODE2_REG),												                  NO_VEX, NO_EVEX, 1, 2, { 0xf7, 0xd8, 0x00 }, 8,  0, NO_MOD,      0, 0, 0, (X16 | X32 | X64), REG_DST,  NO_PREFIX,  NO_IMM,     NO_MEM,     P_64,           0, NULL },
{ "neg",    1, { R64_RAX,  OP_N    }, GP3,  (REX | REXW) | (F_OPCODE2_REG),												                  NO_VEX, NO_EVEX, 1, 2, { 0xf7, 0xd8, 0x00 }, 8,  0, NO_MOD,      0, 0, 0, (X16 | X32 | X64), REG_DST,  NO_PREFIX,  NO_IMM,     NO_MEM,     P_64,           0, NULL },
{ "neg",    1, { R64E,     OP_N    }, GP3,  (REX | REXW | REXB) | (F_OPCODE2_REG),												          NO_VEX, NO_EVEX, 1, 2, { 0xf7, 0xd8, 0x00 }, 8,  0, NO_MOD,      0, 0, 0, (X16 | X32 | X64), REG_DST,  NO_PREFIX,  NO_IMM,     NO_MEM,     P_64,           0, NULL },
{ "neg",    1, { M8,       OP_N    }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_RM | OPCODE_EXT),                         NO_VEX, NO_EVEX, 1, 1, { 0xf6, 0x00, 0x00 }, 1, 1, 0x18, 0, 0, 0, (X32 | X64), RM_DST, NO_PREFIX, NO_IMM, MEM_OPND_0, P_486, 0, NULL },
{ "neg",    1, { M16,      OP_N    }, GP2, ALLOW_SEG | (F_MODRM | F_MODRM_RM | OPCODE_EXT),                         NO_VEX, NO_EVEX, 1, 1, { 0xf7, 0x00, 0x00 }, 2, 1, 0x18, 0, OP_SIZE_OVERRIDE, ADDR_SIZE_OVERRIDE, (X32 | X64), RM_DST, NO_PREFIX, NO_IMM, MEM_OPND_0, P_486, 0, NULL },
{ "neg",    1, { M32,      OP_N    }, GP2, ALLOW_SEG | (F_MODRM | F_MODRM_RM | OPCODE_EXT),                         NO_VEX, NO_EVEX, 1, 1, { 0xf7, 0x00, 0x00 }, 4, 1, 0x18, 0, 0, ADDR_SIZE_OVERRIDE, (X32 | X64), RM_DST, NO_PREFIX, NO_IMM, MEM_OPND_0, P_486, 0, NULL },
{ "neg",    1, { M64,      OP_N    }, GP3, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_RM | OPCODE_EXT),          NO_VEX, NO_EVEX, 1, 1, { 0xf7, 0x00, 0x00 }, 8, 1, 0x18, 0, 0, 0, (X32 | X64), RM_DST, NO_PREFIX, NO_IMM, MEM_OPND_0, P_486, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
/* NOT */
/* ----------------------------------------------------------------------------------------------- */

{ "not",    1, { R8_AL,    OP_N    }, GP0,  (F_OPCODE2_REG),													                              NO_VEX, NO_EVEX, 1, 2, { 0xf6, 0xd0, 0x00 }, 1,  0, NO_MOD,      0, 0, 0, (X16 | X32 | X64), REG_DST,  NO_PREFIX,  NO_IMM,     NO_MEM,     P_86,           0, NULL },
{ "not",    1, { R8_CL,    OP_N    }, GP0,  (F_OPCODE2_REG),													                              NO_VEX, NO_EVEX, 1, 2, { 0xf6, 0xd0, 0x00 }, 1,  0, NO_MOD,      0, 0, 0, (X16 | X32 | X64), REG_DST,  NO_PREFIX,  NO_IMM,     NO_MEM,     P_86,           0, NULL },
{ "not",    1, { R8,       OP_N    }, GP0,  (F_OPCODE2_REG),													                              NO_VEX, NO_EVEX, 1, 2, { 0xf6, 0xd0, 0x00 }, 1,  0, NO_MOD,      0, 0, 0, (X16 | X32 | X64), REG_DST,  NO_PREFIX,  NO_IMM,     NO_MEM,     P_86,           0, NULL },
{ "not",    1, { R8E,      OP_N    }, GP3,  (REX | REXB) | (F_OPCODE2_REG),													                NO_VEX, NO_EVEX, 1, 2, { 0xf6, 0xd0, 0x00 }, 1,  0, NO_MOD,      0, 0, 0, (X64), REG_DST,  NO_PREFIX,  NO_IMM,     NO_MEM,     P_64,           0, NULL },
{ "not",    1, { R8U,      OP_N    }, GP3,  (REX) | (F_OPCODE2_REG),													                      NO_VEX, NO_EVEX, 1, 2, { 0xf6, 0xd0, 0x00 }, 1,  0, NO_MOD,      0, 0, 0, (X64), REG_DST,  NO_PREFIX,  NO_IMM,     NO_MEM,     P_64,           0, NULL },
{ "not",    1, { R16_AX,   OP_N    }, GP0,  (F_OPCODE2_REG),													                              NO_VEX, NO_EVEX, 1, 2, { 0xf7, 0xd0, 0x00 }, 2,  0, NO_MOD,      0, OP_SIZE_OVERRIDE, 0, (X16 | X32 | X64), REG_DST,  NO_PREFIX,  NO_IMM,     NO_MEM,     P_86,           0, NULL },
{ "not",    1, { R16,      OP_N    }, GP0,  (F_OPCODE2_REG),													                              NO_VEX, NO_EVEX, 1, 2, { 0xf7, 0xd0, 0x00 }, 2,  0, NO_MOD,      0, OP_SIZE_OVERRIDE, 0, (X16 | X32 | X64), REG_DST,  NO_PREFIX,  NO_IMM,     NO_MEM,     P_86,           0, NULL },
{ "not",    1, { R16E,     OP_N    }, GP3,  (REX | REXB) | (F_OPCODE2_REG),													                NO_VEX, NO_EVEX, 1, 2, { 0xf7, 0xd0, 0x00 }, 2,  0, NO_MOD,      0, OP_SIZE_OVERRIDE, 0, (X64), REG_DST,  NO_PREFIX,  NO_IMM,     NO_MEM,     P_64,           0, NULL },
{ "not",    1, { R32,      OP_N    }, GP0,  (F_OPCODE2_REG),												                                NO_VEX, NO_EVEX, 1, 2, { 0xf7, 0xd0, 0x00 }, 4,  0, NO_MOD,      0, 0, 0, (X16 | X32 | X64), REG_DST,  NO_PREFIX,  NO_IMM,     NO_MEM,     P_86,           0, NULL },
{ "not",    1, { R32_EAX,  OP_N    }, GP0,  (F_OPCODE2_REG),												                                NO_VEX, NO_EVEX, 1, 2, { 0xf7, 0xd0, 0x00 }, 4,  0, NO_MOD,      0, 0, 0, (X16 | X32 | X64), REG_DST,  NO_PREFIX,  NO_IMM,     NO_MEM,     P_86,           0, NULL },
{ "not",    1, { R32E,     OP_N    }, GP3,  (REX | REXB) | (F_OPCODE2_REG),												                  NO_VEX, NO_EVEX, 1, 2, { 0xf7, 0xd0, 0x00 }, 4,  0, NO_MOD,      0, 0, 0, (X64), REG_DST,  NO_PREFIX,  NO_IMM,     NO_MEM,     P_64,           0, NULL },
{ "not",    1, { R64,      OP_N    }, GP3,  (REX | REXW) | (F_OPCODE2_REG),												                  NO_VEX, NO_EVEX, 1, 2, { 0xf7, 0xd0, 0x00 }, 8,  0, NO_MOD,      0, 0, 0, (X16 | X32 | X64), REG_DST,  NO_PREFIX,  NO_IMM,     NO_MEM,     P_64,           0, NULL },
{ "not",    1, { R64_RAX,  OP_N    }, GP3,  (REX | REXW) | (F_OPCODE2_REG),												                  NO_VEX, NO_EVEX, 1, 2, { 0xf7, 0xd0, 0x00 }, 8,  0, NO_MOD,      0, 0, 0, (X16 | X32 | X64), REG_DST,  NO_PREFIX,  NO_IMM,     NO_MEM,     P_64,           0, NULL },
{ "not",    1, { R64E,     OP_N    }, GP3,  (REX | REXW | REXB) | (F_OPCODE2_REG),												          NO_VEX, NO_EVEX, 1, 2, { 0xf7, 0xd0, 0x00 }, 8,  0, NO_MOD,      0, 0, 0, (X16 | X32 | X64), REG_DST,  NO_PREFIX,  NO_IMM,     NO_MEM,     P_64,           0, NULL },
{ "not",    1, { M8,       OP_N    }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_RM | OPCODE_EXT),                         NO_VEX, NO_EVEX, 1, 1, { 0xf6, 0x00, 0x00 }, 1, 1, 0x10, 0, 0, 0, (X32 | X64), RM_DST, NO_PREFIX, NO_IMM, MEM_OPND_0, P_486, 0, NULL },
{ "not",    1, { M16,      OP_N    }, GP2, ALLOW_SEG | (F_MODRM | F_MODRM_RM | OPCODE_EXT),                         NO_VEX, NO_EVEX, 1, 1, { 0xf7, 0x00, 0x00 }, 2, 1, 0x10, 0, OP_SIZE_OVERRIDE, ADDR_SIZE_OVERRIDE, (X32 | X64), RM_DST, NO_PREFIX, NO_IMM, MEM_OPND_0, P_486, 0, NULL },
{ "not",    1, { M32,      OP_N    }, GP2, ALLOW_SEG | (F_MODRM | F_MODRM_RM | OPCODE_EXT),                         NO_VEX, NO_EVEX, 1, 1, { 0xf7, 0x00, 0x00 }, 4, 1, 0x10, 0, 0, ADDR_SIZE_OVERRIDE, (X32 | X64), RM_DST, NO_PREFIX, NO_IMM, MEM_OPND_0, P_486, 0, NULL },
{ "not",    1, { M64,      OP_N    }, GP3, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_RM | OPCODE_EXT),          NO_VEX, NO_EVEX, 1, 1, { 0xf7, 0x00, 0x00 }, 8, 1, 0x10, 0, 0, 0, (X32 | X64), RM_DST, NO_PREFIX, NO_IMM, MEM_OPND_0, P_486, 0, NULL },

/* ----------------------------------------------------------------------------------------------- */
//MUL r / m8    F6 / 4             REX  = 40
//MUL r / m8 *  REX + F6 / 4       REXB =  1
//MUL r / m16   F7 / 4             REXX =  2
//MUL r / m32   F7 / 4             REXR =  4
//MUL r / m64   REX.W + F7 / 4     REXW =  8
/* ----------------------------------------------------------------------------------------------- */
{ "mul",    1, { R8_AL,    OP_N    }, GP0,  (F_OPCODE2_REG),													                              NO_VEX, NO_EVEX, 1, 2, { 0xf6, 0xe0, 0x00 }, 1,  0, NO_MOD,      0, 0, 0, (X16 | X32 | X64), REG_DST,  NO_PREFIX,  NO_IMM,     NO_MEM,     P_86,           0, NULL },
{ "mul",    1, { R8_CL,    OP_N    }, GP0,  (F_OPCODE2_REG),													                              NO_VEX, NO_EVEX, 1, 2, { 0xf6, 0xe0, 0x00 }, 1,  0, NO_MOD,      0, 0, 0, (X16 | X32 | X64), REG_DST,  NO_PREFIX,  NO_IMM,     NO_MEM,     P_86,           0, NULL },
{ "mul",    1, { R8,       OP_N    }, GP0,  (F_OPCODE2_REG),													                              NO_VEX, NO_EVEX, 1, 2, { 0xf6, 0xe0, 0x00 }, 1,  0, NO_MOD,      0, 0, 0, (X16 | X32 | X64), REG_DST,  NO_PREFIX,  NO_IMM,     NO_MEM,     P_86,           0, NULL },
{ "mul",    1, { R8E,      OP_N    }, GP3,  (REX | REXB) | (F_OPCODE2_REG),													                NO_VEX, NO_EVEX, 1, 2, { 0xf6, 0xe0, 0x00 }, 1,  0, NO_MOD,      0, 0, 0, (X64), REG_DST,  NO_PREFIX,  NO_IMM,     NO_MEM,     P_64,           0, NULL },
{ "mul",    1, { R8U,      OP_N    }, GP3,  (REX) | (F_OPCODE2_REG),													                      NO_VEX, NO_EVEX, 1, 2, { 0xf6, 0xe0, 0x00 }, 1,  0, NO_MOD,      0, 0, 0, (X64), REG_DST,  NO_PREFIX,  NO_IMM,     NO_MEM,     P_64,           0, NULL },
{ "mul",    1, { R16_AX,   OP_N    }, GP0,  (F_OPCODE2_REG),													                              NO_VEX, NO_EVEX, 1, 2, { 0xf7, 0xe0, 0x00 }, 2,  0, NO_MOD,      0, OP_SIZE_OVERRIDE, 0, (X16 | X32 | X64), REG_DST,  NO_PREFIX,  NO_IMM,     NO_MEM,     P_86,           0, NULL },
{ "mul",    1, { R16,      OP_N    }, GP0,  (F_OPCODE2_REG),													                              NO_VEX, NO_EVEX, 1, 2, { 0xf7, 0xe0, 0x00 }, 2,  0, NO_MOD,      0, OP_SIZE_OVERRIDE, 0, (X16 | X32 | X64), REG_DST,  NO_PREFIX,  NO_IMM,     NO_MEM,     P_86,           0, NULL },
{ "mul",    1, { R16E,     OP_N    }, GP3,  (REX | REXB) | (F_OPCODE2_REG),													                NO_VEX, NO_EVEX, 1, 2, { 0xf7, 0xe0, 0x00 }, 2,  0, NO_MOD,      0, OP_SIZE_OVERRIDE, 0, (X64), REG_DST,  NO_PREFIX,  NO_IMM,     NO_MEM,     P_64,           0, NULL },
{ "mul",    1, { R32,      OP_N    }, GP0,  (F_OPCODE2_REG),												                                NO_VEX, NO_EVEX, 1, 2, { 0xf7, 0xe0, 0x00 }, 4,  0, NO_MOD,      0, 0, 0, (X16 | X32 | X64), REG_DST,  NO_PREFIX,  NO_IMM,     NO_MEM,     P_86,           0, NULL },
{ "mul",    1, { R32_EAX,  OP_N    }, GP0,  (F_OPCODE2_REG),												                                NO_VEX, NO_EVEX, 1, 2, { 0xf7, 0xe0, 0x00 }, 4,  0, NO_MOD,      0, 0, 0, (X16 | X32 | X64), REG_DST,  NO_PREFIX,  NO_IMM,     NO_MEM,     P_86,           0, NULL },
{ "mul",    1, { R32E,     OP_N    }, GP3,  (REX | REXB) | (F_OPCODE2_REG),												                  NO_VEX, NO_EVEX, 1, 2, { 0xf7, 0xe0, 0x00 }, 4,  0, NO_MOD,      0, 0, 0, (X64), REG_DST,  NO_PREFIX,  NO_IMM,     NO_MEM,     P_64,           0, NULL },
{ "mul",    1, { R64,      OP_N    }, GP3,  (REX | REXW) | (F_OPCODE2_REG),												                  NO_VEX, NO_EVEX, 1, 2, { 0xf7, 0xe0, 0x00 }, 8,  0, NO_MOD,      0, 0, 0, (X16 | X32 | X64), REG_DST,  NO_PREFIX,  NO_IMM,     NO_MEM,     P_64,           0, NULL },
{ "mul",    1, { R64_RAX,  OP_N    }, GP3,  (REX | REXW) | (F_OPCODE2_REG),												                  NO_VEX, NO_EVEX, 1, 2, { 0xf7, 0xe0, 0x00 }, 8,  0, NO_MOD,      0, 0, 0, (X16 | X32 | X64), REG_DST,  NO_PREFIX,  NO_IMM,     NO_MEM,     P_64,           0, NULL },
{ "mul",    1, { R64E,     OP_N    }, GP3,  (REX | REXW | REXB) | (F_OPCODE2_REG),												          NO_VEX, NO_EVEX, 1, 2, { 0xf7, 0xe0, 0x00 }, 8,  0, NO_MOD,      0, 0, 0, (X16 | X32 | X64), REG_DST,  NO_PREFIX,  NO_IMM,     NO_MEM,     P_64,           0, NULL },
{ "mul",    1, { M8,       OP_N    }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_RM | OPCODE_EXT),                         NO_VEX, NO_EVEX, 1, 1, { 0xf6, 0x00, 0x00 }, 1, 1, 0x20, 0, 0, 0, (X32 | X64), RM_DST, NO_PREFIX, NO_IMM, MEM_OPND_0, P_486, 0, NULL },
{ "mul",    1, { M16,      OP_N    }, GP2, ALLOW_SEG | (F_MODRM | F_MODRM_RM | OPCODE_EXT),                         NO_VEX, NO_EVEX, 1, 1, { 0xf7, 0x00, 0x00 }, 2, 1, 0x20, 0, OP_SIZE_OVERRIDE, ADDR_SIZE_OVERRIDE, (X32 | X64), RM_DST, NO_PREFIX, NO_IMM, MEM_OPND_0, P_486, 0, NULL },
{ "mul",    1, { M32,      OP_N    }, GP2, ALLOW_SEG | (F_MODRM | F_MODRM_RM | OPCODE_EXT),                         NO_VEX, NO_EVEX, 1, 1, { 0xf7, 0x00, 0x00 }, 4, 1, 0x20, 0, 0, ADDR_SIZE_OVERRIDE, (X32 | X64), RM_DST, NO_PREFIX, NO_IMM, MEM_OPND_0, P_486, 0, NULL },
{ "mul",    1, { M64,      OP_N    }, GP3, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_RM | OPCODE_EXT),          NO_VEX, NO_EVEX, 1, 1, { 0xf7, 0x00, 0x00 }, 8, 1, 0x20, 0, 0, 0, (X32 | X64), RM_DST, NO_PREFIX, NO_IMM, MEM_OPND_0, P_486, 0, NULL },

/* ----------------------------------------------------------------------------------------------- */
//IMUL r/m8*              F6 /5             REX  = 40
//IMUL r/m16              F7 /5             REXB =  1
//IMUL r/m32              F7 /5             REXX =  2
//IMUL r/m64              REX.W + F7 /5     REXR =  4
//IMUL r16, r/m16         0F AF /r          REXW =  8
//IMUL r32, r/m32         0F AF /r          
//IMUL r64, r/m64 REX.W + 0F AF /r  
//IMUL r16, r/m16, imm8   6B /r ib          
//IMUL r32, r/m32, imm8   6B /r ib          
//IMUL r64, r/m64, imm8   REX.W + 6B /r ib  
//IMUL r16, r/m16, imm16  69 /r iw          
//IMUL r32, r/m32, imm32  69 /r id          
//IMUL r64, r/m64, imm32  REX.W + 69 /r id  
/* ----------------------------------------------------------------------------------------------- */
{ "imul",    1, { R8_AL,    OP_N    }, GP0,  (F_OPCODE2_REG),													                                NO_VEX, NO_EVEX, 1, 2, { 0xf6, 0xe8, 0x00 }, 1,  0, NO_MOD,      0, 0, 0, (X16 | X32 | X64), REG_DST,  NO_PREFIX,  NO_IMM,     NO_MEM,     P_86,           0, NULL },
{ "imul",    1, { R8_CL,    OP_N    }, GP0,  (F_OPCODE2_REG),													                                NO_VEX, NO_EVEX, 1, 2, { 0xf6, 0xe8, 0x00 }, 1,  0, NO_MOD,      0, 0, 0, (X16 | X32 | X64), REG_DST,  NO_PREFIX,  NO_IMM,     NO_MEM,     P_86,           0, NULL },
{ "imul",    1, { R8,       OP_N    }, GP0,  (F_OPCODE2_REG),													                                NO_VEX, NO_EVEX, 1, 2, { 0xf6, 0xe8, 0x00 }, 1,  0, NO_MOD,      0, 0, 0, (X16 | X32 | X64), REG_DST,  NO_PREFIX,  NO_IMM,     NO_MEM,     P_86,           0, NULL },
{ "imul",    1, { R8E,      OP_N    }, GP3,  (REX | REXB) | (F_OPCODE2_REG),													                NO_VEX, NO_EVEX, 1, 2, { 0xf6, 0xe8, 0x00 }, 1,  0, NO_MOD,      0, 0, 0, (X64), REG_DST,  NO_PREFIX,  NO_IMM,     NO_MEM,     P_64,           0, NULL },
{ "imul",    1, { R8U,      OP_N    }, GP3,  (REX) | (F_OPCODE2_REG),													                        NO_VEX, NO_EVEX, 1, 2, { 0xf6, 0xe8, 0x00 }, 1,  0, NO_MOD,      0, 0, 0, (X64), REG_DST,  NO_PREFIX,  NO_IMM,     NO_MEM,     P_64,           0, NULL },
{ "imul",    1, { R16_AX,   OP_N    }, GP0,  (F_OPCODE2_REG),													                                NO_VEX, NO_EVEX, 1, 2, { 0xf7, 0xe8, 0x00 }, 2,  0, NO_MOD,      0, OP_SIZE_OVERRIDE, 0, (X16 | X32 | X64), REG_DST,  NO_PREFIX,  NO_IMM,     NO_MEM,     P_86,           0, NULL },
{ "imul",    1, { R16,      OP_N    }, GP0,  (F_OPCODE2_REG),													                                NO_VEX, NO_EVEX, 1, 2, { 0xf7, 0xe8, 0x00 }, 2,  0, NO_MOD,      0, OP_SIZE_OVERRIDE, 0, (X16 | X32 | X64), REG_DST,  NO_PREFIX,  NO_IMM,     NO_MEM,     P_86,           0, NULL },
{ "imul",    1, { R16E,     OP_N    }, GP3,  (REX | REXB) | (F_OPCODE2_REG),													                NO_VEX, NO_EVEX, 1, 2, { 0xf7, 0xe8, 0x00 }, 2,  0, NO_MOD,      0, OP_SIZE_OVERRIDE, 0, (X64), REG_DST,  NO_PREFIX,  NO_IMM,     NO_MEM,     P_64,           0, NULL },
{ "imul",    1, { R32,      OP_N    }, GP0,  (F_OPCODE2_REG),												                                  NO_VEX, NO_EVEX, 1, 2, { 0xf7, 0xe8, 0x00 }, 4,  0, NO_MOD,      0, 0, 0, (X16 | X32 | X64), REG_DST,  NO_PREFIX,  NO_IMM,     NO_MEM,     P_86,           0, NULL },
{ "imul",    1, { R32_EAX,  OP_N    }, GP0,  (F_OPCODE2_REG),												                                  NO_VEX, NO_EVEX, 1, 2, { 0xf7, 0xe8, 0x00 }, 4,  0, NO_MOD,      0, 0, 0, (X16 | X32 | X64), REG_DST,  NO_PREFIX,  NO_IMM,     NO_MEM,     P_86,           0, NULL },
{ "imul",    1, { R32E,     OP_N    }, GP3,  (REX | REXB) | (F_OPCODE2_REG),												                  NO_VEX, NO_EVEX, 1, 2, { 0xf7, 0xe8, 0x00 }, 4,  0, NO_MOD,      0, 0, 0, (X64), REG_DST,  NO_PREFIX,  NO_IMM,     NO_MEM,     P_64,           0, NULL },
{ "imul",    1, { R64,      OP_N    }, GP3,  (REX | REXW) | (F_OPCODE2_REG),												                  NO_VEX, NO_EVEX, 1, 2, { 0xf7, 0xe8, 0x00 }, 8,  0, NO_MOD,      0, 0, 0, (X16 | X32 | X64), REG_DST,  NO_PREFIX,  NO_IMM,     NO_MEM,     P_64,           0, NULL },
{ "imul",    1, { R64_RAX,  OP_N    }, GP3,  (REX | REXW) | (F_OPCODE2_REG),												                  NO_VEX, NO_EVEX, 1, 2, { 0xf7, 0xe8, 0x00 }, 8,  0, NO_MOD,      0, 0, 0, (X16 | X32 | X64), REG_DST,  NO_PREFIX,  NO_IMM,     NO_MEM,     P_64,           0, NULL },
{ "imul",    1, { R64E,     OP_N    }, GP3,  (REX | REXW | REXB) | (F_OPCODE2_REG),												            NO_VEX, NO_EVEX, 1, 2, { 0xf7, 0xe8, 0x00 }, 8,  0, NO_MOD,      0, 0, 0, (X16 | X32 | X64), REG_DST,  NO_PREFIX,  NO_IMM,     NO_MEM,     P_64,           0, NULL },
{ "imul",    1, { M8,       OP_N    }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_RM | OPCODE_EXT),                          NO_VEX, NO_EVEX, 1, 1, { 0xf6, 0x00, 0x00 }, 1, 1, 0x28, 0, 0, 0, (X32 | X64), RM_DST, NO_PREFIX, NO_IMM, MEM_OPND_0, P_486, 0, NULL },
{ "imul",    1, { M16,      OP_N    }, GP2, ALLOW_SEG | (F_MODRM | F_MODRM_RM | OPCODE_EXT),                          NO_VEX, NO_EVEX, 1, 1, { 0xf7, 0x00, 0x00 }, 2, 1, 0x28, 0, OP_SIZE_OVERRIDE, ADDR_SIZE_OVERRIDE, (X32 | X64), RM_DST, NO_PREFIX, NO_IMM, MEM_OPND_0, P_486, 0, NULL },
{ "imul",    1, { M32,      OP_N    }, GP2, ALLOW_SEG | (F_MODRM | F_MODRM_RM | OPCODE_EXT),                          NO_VEX, NO_EVEX, 1, 1, { 0xf7, 0x00, 0x00 }, 4, 1, 0x28, 0, 0, ADDR_SIZE_OVERRIDE, (X32 | X64), RM_DST, NO_PREFIX, NO_IMM, MEM_OPND_0, P_486, 0, NULL },
{ "imul",    1, { M64,      OP_N    }, GP3, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_RM | OPCODE_EXT),           NO_VEX, NO_EVEX, 1, 1, { 0xf7, 0x00, 0x00 }, 8, 1, 0x28, 0, 0, 0, (X32 | X64), RM_DST, NO_PREFIX, NO_IMM, MEM_OPND_0, P_486, 0, NULL },
{ "imul",    2, { R16,      R16_AX  }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                        NO_VEX, NO_EVEX, 1, 1, { 0xaf, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                                               (X16 | X32 | X64), REG_DST,  PFX_0xF,       NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "imul",    2, { R16_AX,   R16     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                        NO_VEX, NO_EVEX, 1, 1, { 0xaf, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                                               (X16 | X32 | X64), REG_DST,  PFX_0xF,       NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "imul",    2, { R16_AX,   R16_AX  }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                        NO_VEX, NO_EVEX, 1, 1, { 0xaf, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                                               (X16 | X32 | X64), REG_DST,  PFX_0xF,       NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "imul",    2, { R16,      R16     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                        NO_VEX, NO_EVEX, 1, 1, { 0xaf, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                                               (X16 | X32 | X64), REG_DST,  PFX_0xF,       NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "imul",    2, { R16E,     R16E    }, GP3, (REX | REXB | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),               NO_VEX, NO_EVEX, 1, 1, { 0xaf, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                                                           (X64), REG_DST,  PFX_0xF,       NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "imul",    2, { R16E,     R16     }, GP3, (REX | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				              NO_VEX, NO_EVEX, 1, 1, { 0xaf, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                                                           (X64), REG_DST,  PFX_0xF,       NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "imul",    2, { R16,      R16E    }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				              NO_VEX, NO_EVEX, 1, 1, { 0xaf, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                                                           (X64), REG_DST,  PFX_0xF,       NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "imul",    2, { R32,      R32     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                        NO_VEX, NO_EVEX, 1, 1, { 0xaf, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, 0,                0,                                               (X16 | X32 | X64), REG_DST,  PFX_0xF,       NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "imul",    2, { R32_EAX,  R32     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                        NO_VEX, NO_EVEX, 1, 1, { 0xaf, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, 0,                0,                                               (X16 | X32 | X64), REG_DST,  PFX_0xF,       NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "imul",    2, { R32_EAX,  R32_EAX }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                        NO_VEX, NO_EVEX, 1, 1, { 0xaf, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, 0,                0,                                               (X16 | X32 | X64), REG_DST,  PFX_0xF,       NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "imul",    2, { R32,      R32_EAX }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                        NO_VEX, NO_EVEX, 1, 1, { 0xaf, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, 0,                0,                                               (X16 | X32 | X64), REG_DST,  PFX_0xF,       NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "imul",    2, { R32E,     R32E    }, GP3, (REX | REXB | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),	              NO_VEX, NO_EVEX, 1, 1, { 0xaf, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, 0,                0,                                                           (X64), REG_DST,  PFX_0xF,       NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "imul",    2, { R32E,     R32     }, GP3, (REX | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				              NO_VEX, NO_EVEX, 1, 1, { 0xaf, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, 0,                0,                                                           (X64), REG_DST,  PFX_0xF,       NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "imul",    2, { R32,      R32E    }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				              NO_VEX, NO_EVEX, 1, 1, { 0xaf, 0x00, 0x00 }, 4, 0, MOD_REG_REG, 0, 0,                0,                                                           (X64), REG_DST,  PFX_0xF,       NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "imul",    2, { R64,      R64     }, GP3, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		                  NO_VEX, NO_EVEX, 1, 1, { 0xaf, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                                                           (X64), REG_DST,  PFX_0xF,       NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "imul",    2, { R64_RAX,  R64     }, GP3, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		                  NO_VEX, NO_EVEX, 1, 1, { 0xaf, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                                                           (X64), REG_DST,  PFX_0xF,       NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "imul",    2, { R64,      R64_RAX }, GP3, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		                  NO_VEX, NO_EVEX, 1, 1, { 0xaf, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                                                           (X64), REG_DST,  PFX_0xF,       NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "imul",    2, { R64_RAX,  R64_RAX }, GP3, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		                  NO_VEX, NO_EVEX, 1, 1, { 0xaf, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                                                           (X64), REG_DST,  PFX_0xF,       NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "imul",    2, { R64E,     R64E    }, GP3, (REX | REXR | REXB | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),        NO_VEX, NO_EVEX, 1, 1, { 0xaf, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                                                           (X64), REG_DST,  PFX_0xF,       NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "imul",    2, { R64,      R64E    }, GP3, (REX | REXB | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		            NO_VEX, NO_EVEX, 1, 1, { 0xaf, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                                                           (X64), REG_DST,  PFX_0xF,       NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "imul",    2, { R64E,     R64     }, GP3, (REX | REXR | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		            NO_VEX, NO_EVEX, 1, 1, { 0xaf, 0x00, 0x00 }, 8, 0, MOD_REG_REG, 0, 0,                0,                                                           (X64), REG_DST,  PFX_0xF,       NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "imul",    2, { R16,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                              NO_VEX, NO_EVEX, 1, 1, { 0xaf, 0x00, 0x00 }, 2, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE,                             (X16 | X32 | X64), REG_DST,  PFX_0xF,       NO_IMM,     MEM_OPND_1, P_86,  0, NULL },
{ "imul",    2, { R16_AX,   M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                              NO_VEX, NO_EVEX, 1, 1, { 0xaf, 0x00, 0x00 }, 2, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE,                             (X16 | X32 | X64), REG_DST,  PFX_0xF,       NO_IMM,     MEM_OPND_1, P_86,  0, NULL },
{ "imul",    2, { R16E,     M_ANY   }, GP3, ALLOW_SEG | (REX | REXR) | (F_MODRM | F_MODRM_REG),	                      NO_VEX, NO_EVEX, 1, 1, { 0xaf, 0x00, 0x00 }, 2, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE,                                         (X64), REG_DST,  PFX_0xF,       NO_IMM,     MEM_OPND_1, P_64,  0, NULL },
{ "imul",    2, { R32,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                              NO_VEX, NO_EVEX, 1, 1, { 0xaf, 0x00, 0x00 }, 4, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE,                             (X16 | X32 | X64), REG_DST,  PFX_0xF,       NO_IMM,     MEM_OPND_1, P_86,  0, NULL },
{ "imul",    2, { R32_EAX,  M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                              NO_VEX, NO_EVEX, 1, 1, { 0xaf, 0x00, 0x00 }, 4, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE,                             (X16 | X32 | X64), REG_DST,  PFX_0xF,       NO_IMM,     MEM_OPND_1, P_86,  0, NULL },
{ "imul",    2, { R32E,     M_ANY   }, GP3, ALLOW_SEG | (REX | REXR) | (F_MODRM | F_MODRM_REG),	                      NO_VEX, NO_EVEX, 1, 1, { 0xaf, 0x00, 0x00 }, 4, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE,                                         (X64), REG_DST,  PFX_0xF,       NO_IMM,     MEM_OPND_1, P_64,  0, NULL },
{ "imul",    2, { R64,      M_ANY   }, GP0, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_REG),				                NO_VEX, NO_EVEX, 1, 1, { 0xaf, 0x00, 0x00 }, 8, 0, MOD_REG_MEM, 0, 0,				          ADDR_SIZE_OVERRIDE,                             (X16 | X32 | X64), REG_DST,  PFX_0xF,       NO_IMM,     MEM_OPND_1, P_64,  0, NULL },
{ "imul",    2, { R64_RAX,  M_ANY   }, GP0, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_REG),				                NO_VEX, NO_EVEX, 1, 1, { 0xaf, 0x00, 0x00 }, 8, 0, MOD_REG_MEM, 0, 0,				          ADDR_SIZE_OVERRIDE,                             (X16 | X32 | X64), REG_DST,  PFX_0xF,       NO_IMM,     MEM_OPND_1, P_64,  0, NULL },
{ "imul",    2, { R64E,     M_ANY   }, GP3, ALLOW_SEG | (REX | REXW | REXR) | (F_MODRM | F_MODRM_REG),	              NO_VEX, NO_EVEX, 1, 1, { 0xaf, 0x00, 0x00 }, 8, 0, MOD_REG_MEM, 0, 0,				          ADDR_SIZE_OVERRIDE,                                         (X64), REG_DST,  PFX_0xF,       NO_IMM,     MEM_OPND_1, P_64,  0, NULL },
{ "imul",    3, { R16,      R16_AX, IMM8 }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT | IMM8_ONLY),							                    NO_VEX, NO_EVEX, 1, 1, { 0x6b, 0x00, 0x00 }, 2, 1, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE,   0,                   (X16 | X32 | X64), REG_DST,  NO_PREFIX, IMM_OPND_2,     NO_MEM,     P_86,  0, NULL },
{ "imul",    3, { R16_AX,   R16,    IMM8 }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT | IMM8_ONLY),							                    NO_VEX, NO_EVEX, 1, 1, { 0x6b, 0x00, 0x00 }, 2, 1, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE,   0,                   (X16 | X32 | X64), REG_DST,  NO_PREFIX, IMM_OPND_2,     NO_MEM,     P_86,  0, NULL },
{ "imul",    3, { R16_AX,   R16_AX, IMM8 }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT | IMM8_ONLY),							                    NO_VEX, NO_EVEX, 1, 1, { 0x6b, 0x00, 0x00 }, 2, 1, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE,   0,                   (X16 | X32 | X64), REG_DST,  NO_PREFIX, IMM_OPND_2,     NO_MEM,     P_86,  0, NULL },
{ "imul",    3, { R16,      R16,    IMM8 }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT | IMM8_ONLY),							                    NO_VEX, NO_EVEX, 1, 1, { 0x6b, 0x00, 0x00 }, 2, 1, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE,   0,                   (X16 | X32 | X64), REG_DST,  NO_PREFIX, IMM_OPND_2,     NO_MEM,     P_86,  0, NULL },
{ "imul",    3, { R16E,     R16E,   IMM8 }, GP3, (REX | REXB | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT | IMM8_ONLY),           NO_VEX, NO_EVEX, 1, 1, { 0x6b, 0x00, 0x00 }, 2, 1, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE,   0,                               (X64), REG_DST,  NO_PREFIX, IMM_OPND_2,     NO_MEM,     P_64,  0, NULL },
{ "imul",    3, { R16E,     R16,    IMM8 }, GP3, (REX | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT | IMM8_ONLY),				          NO_VEX, NO_EVEX, 1, 1, { 0x6b, 0x00, 0x00 }, 2, 1, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE,   0,                               (X64), REG_DST,  NO_PREFIX, IMM_OPND_2,     NO_MEM,     P_64,  0, NULL },
{ "imul",    3, { R16,      R16E,   IMM8 }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT | IMM8_ONLY),				          NO_VEX, NO_EVEX, 1, 1, { 0x6b, 0x00, 0x00 }, 2, 1, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE,   0,                               (X64), REG_DST,  NO_PREFIX, IMM_OPND_2,     NO_MEM,     P_64,  0, NULL },
{ "imul",    3, { R32,      R32,    IMM8 }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT | IMM8_ONLY),							                    NO_VEX, NO_EVEX, 1, 1, { 0x6b, 0x00, 0x00 }, 4, 1, MOD_REG_IMM, 0, 0,                  0,                   (X16 | X32 | X64), REG_DST,  NO_PREFIX, IMM_OPND_2,     NO_MEM,     P_86,  0, NULL },
{ "imul",    3, { R32_EAX,  R32,    IMM8 }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT | IMM8_ONLY),							                    NO_VEX, NO_EVEX, 1, 1, { 0x6b, 0x00, 0x00 }, 4, 1, MOD_REG_IMM, 0, 0,                  0,                   (X16 | X32 | X64), REG_DST,  NO_PREFIX, IMM_OPND_2,     NO_MEM,     P_86,  0, NULL },
{ "imul",    3, { R32_EAX,  R32_EAX,IMM8 }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT | IMM8_ONLY),							                    NO_VEX, NO_EVEX, 1, 1, { 0x6b, 0x00, 0x00 }, 4, 1, MOD_REG_IMM, 0, 0,                  0,                   (X16 | X32 | X64), REG_DST,  NO_PREFIX, IMM_OPND_2,     NO_MEM,     P_86,  0, NULL },
{ "imul",    3, { R32,      R32_EAX,IMM8 }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT | IMM8_ONLY),							                    NO_VEX, NO_EVEX, 1, 1, { 0x6b, 0x00, 0x00 }, 4, 1, MOD_REG_IMM, 0, 0,                  0,                   (X16 | X32 | X64), REG_DST,  NO_PREFIX, IMM_OPND_2,     NO_MEM,     P_86,  0, NULL },
{ "imul",    3, { R32E,     R32E,   IMM8 }, GP3, (REX | REXB | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM | IMM8_ONLY),	                      NO_VEX, NO_EVEX, 1, 1, { 0x6b, 0x00, 0x00 }, 4, 1, MOD_REG_IMM, 0, 0,                  0,                               (X64), REG_DST,  NO_PREFIX, IMM_OPND_2,     NO_MEM,     P_64,  0, NULL },
{ "imul",    3, { R32E,     R32,    IMM8 }, GP3, (REX | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT | IMM8_ONLY),				          NO_VEX, NO_EVEX, 1, 1, { 0x6b, 0x00, 0x00 }, 4, 1, MOD_REG_IMM, 0, 0,                  0,                               (X64), REG_DST,  NO_PREFIX, IMM_OPND_2,     NO_MEM,     P_64,  0, NULL },
{ "imul",    3, { R32,      R32E,   IMM8 }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT | IMM8_ONLY),				          NO_VEX, NO_EVEX, 1, 1, { 0x6b, 0x00, 0x00 }, 4, 1, MOD_REG_IMM, 0, 0,                  0,                               (X64), REG_DST,  NO_PREFIX, IMM_OPND_2,     NO_MEM,     P_64,  0, NULL },
{ "imul",    3, { R64,      R64,    IMM8 }, GP3, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT | IMM8_ONLY),		              NO_VEX, NO_EVEX, 1, 1, { 0x6b, 0x00, 0x00 }, 8, 1, MOD_REG_IMM, 0, 0,                  0,                               (X64), REG_DST,  NO_PREFIX, IMM_OPND_2,     NO_MEM,     P_64,  0, NULL },
{ "imul",    3, { R64_RAX,  R64,    IMM8 }, GP3, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT | IMM8_ONLY),		              NO_VEX, NO_EVEX, 1, 1, { 0x6b, 0x00, 0x00 }, 8, 1, MOD_REG_IMM, 0, 0,                  0,                               (X64), REG_DST,  NO_PREFIX, IMM_OPND_2,     NO_MEM,     P_64,  0, NULL },
{ "imul",    3, { R64,      R64_RAX,IMM8 }, GP3, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT | IMM8_ONLY),		              NO_VEX, NO_EVEX, 1, 1, { 0x6b, 0x00, 0x00 }, 8, 1, MOD_REG_IMM, 0, 0,                  0,                               (X64), REG_DST,  NO_PREFIX, IMM_OPND_2,     NO_MEM,     P_64,  0, NULL },
{ "imul",    3, { R64_RAX,  R64_RAX,IMM8 }, GP3, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT | IMM8_ONLY),		              NO_VEX, NO_EVEX, 1, 1, { 0x6b, 0x00, 0x00 }, 8, 1, MOD_REG_IMM, 0, 0,                  0,                               (X64), REG_DST,  NO_PREFIX, IMM_OPND_2,     NO_MEM,     P_64,  0, NULL },
{ "imul",    3, { R64E,     R64E,   IMM8 }, GP3, (REX | REXR | REXB | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM | IMM8_ONLY),                 NO_VEX, NO_EVEX, 1, 1, { 0x6b, 0x00, 0x00 }, 8, 1, MOD_REG_IMM, 0, 0,                  0,                               (X64), REG_DST,  NO_PREFIX, IMM_OPND_2,     NO_MEM,     P_64,  0, NULL },
{ "imul",    3, { R64,      R64E,   IMM8 }, GP3, (REX | REXB | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT | IMM8_ONLY),		        NO_VEX, NO_EVEX, 1, 1, { 0x6b, 0x00, 0x00 }, 8, 1, MOD_REG_IMM, 0, 0,                  0,                               (X64), REG_DST,  NO_PREFIX, IMM_OPND_2,     NO_MEM,     P_64,  0, NULL },
{ "imul",    3, { R64E,     R64,    IMM8 }, GP3, (REX | REXR | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT | IMM8_ONLY),		        NO_VEX, NO_EVEX, 1, 1, { 0x6b, 0x00, 0x00 }, 8, 1, MOD_REG_IMM, 0, 0,                  0,                               (X64), REG_DST,  NO_PREFIX, IMM_OPND_2,     NO_MEM,     P_64,  0, NULL },
{ "imul",    3, { R16,      M_ANY,  IMM8 }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG | OPCODE_EXT | IMM8_ONLY),				                          NO_VEX, NO_EVEX, 1, 1, { 0x6b, 0x00, 0x00 }, 2, 1, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE,	  ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST,  NO_PREFIX, IMM_OPND_2,     MEM_OPND_1, P_86,  0, NULL },
{ "imul",    3, { R16_AX,   M_ANY,  IMM8 }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG | OPCODE_EXT | IMM8_ONLY),				                          NO_VEX, NO_EVEX, 1, 1, { 0x6b, 0x00, 0x00 }, 2, 1, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE,	  ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST,  NO_PREFIX, IMM_OPND_2,     MEM_OPND_1, P_86,  0, NULL },
{ "imul",    3, { R16E,     M_ANY,  IMM8 }, GP3, ALLOW_SEG | (REX | REXR) | (F_MODRM | F_MODRM_REG | IMM8_ONLY),	                              NO_VEX, NO_EVEX, 1, 1, { 0x6b, 0x00, 0x00 }, 2, 1, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE,	  ADDR_SIZE_OVERRIDE,             (X64), REG_DST,  NO_PREFIX, IMM_OPND_2,     MEM_OPND_1, P_64,  0, NULL },
{ "imul",    3, { R32,      M_ANY,  IMM8 }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG | OPCODE_EXT | IMM8_ONLY),				                          NO_VEX, NO_EVEX, 1, 1, { 0x6b, 0x00, 0x00 }, 4, 1, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE,	  ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST,  NO_PREFIX, IMM_OPND_2,     MEM_OPND_1, P_86,  0, NULL },
{ "imul",    3, { R32_EAX,  M_ANY,  IMM8 }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG | OPCODE_EXT | IMM8_ONLY),				                          NO_VEX, NO_EVEX, 1, 1, { 0x6b, 0x00, 0x00 }, 4, 1, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE,	  ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST,  NO_PREFIX, IMM_OPND_2,     MEM_OPND_1, P_86,  0, NULL },
{ "imul",    3, { R32E,     M_ANY,  IMM8 }, GP3, ALLOW_SEG | (REX | REXR) | (F_MODRM | F_MODRM_REG | OPCODE_EXT | IMM8_ONLY),	                  NO_VEX, NO_EVEX, 1, 1, { 0x6b, 0x00, 0x00 }, 4, 1, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE,	  ADDR_SIZE_OVERRIDE,             (X64), REG_DST,  NO_PREFIX, IMM_OPND_2,     MEM_OPND_1, P_64,  0, NULL },
{ "imul",    3, { R64,      M_ANY,  IMM8 }, GP0, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_REG | OPCODE_EXT | IMM8_ONLY),				            NO_VEX, NO_EVEX, 1, 1, { 0x6b, 0x00, 0x00 }, 8, 1, MOD_REG_IMM, 0, 0,				            ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST,  NO_PREFIX, IMM_OPND_2,     MEM_OPND_1, P_64,  0, NULL },
{ "imul",    3, { R64_RAX,  M_ANY,  IMM8 }, GP0, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_REG | OPCODE_EXT | IMM8_ONLY),				            NO_VEX, NO_EVEX, 1, 1, { 0x6b, 0x00, 0x00 }, 8, 1, MOD_REG_IMM, 0, 0,				            ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST,  NO_PREFIX, IMM_OPND_2,     MEM_OPND_1, P_64,  0, NULL },
{ "imul",    3, { R64E,     M_ANY,  IMM8 }, GP3, ALLOW_SEG | (REX | REXW | REXR) | (F_MODRM | F_MODRM_REG | OPCODE_EXT | IMM8_ONLY),	          NO_VEX, NO_EVEX, 1, 1, { 0x6b, 0x00, 0x00 }, 8, 1, MOD_REG_IMM, 0, 0,				            ADDR_SIZE_OVERRIDE,             (X64), REG_DST,  NO_PREFIX, IMM_OPND_2,     MEM_OPND_1, P_64,  0, NULL },
{ "imul",    3, { R16,      R16_AX, IMM16 }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT),							                  NO_VEX, NO_EVEX, 1, 1, { 0x69, 0x00, 0x00 }, 2, 1, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE,               0,                   (X16 | X32 | X64), REG_DST,  NO_PREFIX, IMM_OPND_2,     NO_MEM,     P_86,  0, NULL },
{ "imul",    3, { R16_AX,   R16,    IMM16 }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT),							                  NO_VEX, NO_EVEX, 1, 1, { 0x69, 0x00, 0x00 }, 2, 1, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE,               0,                   (X16 | X32 | X64), REG_DST,  NO_PREFIX, IMM_OPND_2,     NO_MEM,     P_86,  0, NULL },
{ "imul",    3, { R16_AX,   R16_AX, IMM16 }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT),							                  NO_VEX, NO_EVEX, 1, 1, { 0x69, 0x00, 0x00 }, 2, 1, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE,               0,                   (X16 | X32 | X64), REG_DST,  NO_PREFIX, IMM_OPND_2,     NO_MEM,     P_86,  0, NULL },
{ "imul",    3, { R16,      R16,    IMM16 }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT),							                  NO_VEX, NO_EVEX, 1, 1, { 0x69, 0x00, 0x00 }, 2, 1, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE,               0,                   (X16 | X32 | X64), REG_DST,  NO_PREFIX, IMM_OPND_2,     NO_MEM,     P_86,  0, NULL },
{ "imul",    3, { R16E,     R16E,   IMM16 }, GP3, (REX | REXB | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT),          NO_VEX, NO_EVEX, 1, 1, { 0x69, 0x00, 0x00 }, 2, 1, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE,               0,                               (X64), REG_DST,  NO_PREFIX, IMM_OPND_2,     NO_MEM,     P_64,  0, NULL },
{ "imul",    3, { R16E,     R16,    IMM16 }, GP3, (REX | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT),				          NO_VEX, NO_EVEX, 1, 1, { 0x69, 0x00, 0x00 }, 2, 1, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE,               0,                               (X64), REG_DST,  NO_PREFIX, IMM_OPND_2,     NO_MEM,     P_64,  0, NULL },
{ "imul",    3, { R16,      R16E,   IMM16 }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT),				          NO_VEX, NO_EVEX, 1, 1, { 0x69, 0x00, 0x00 }, 2, 1, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE,               0,                               (X64), REG_DST,  NO_PREFIX, IMM_OPND_2,     NO_MEM,     P_64,  0, NULL },
{ "imul",    3, { R32,      R32,    IMM32 }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT),							                  NO_VEX, NO_EVEX, 1, 1, { 0x69, 0x00, 0x00 }, 4, 1, MOD_REG_IMM, 0, 0,                              0,                   (X16 | X32 | X64), REG_DST,  NO_PREFIX, IMM_OPND_2,     NO_MEM,     P_86,  0, NULL },
{ "imul",    3, { R32_EAX,  R32,    IMM32 }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT),							                  NO_VEX, NO_EVEX, 1, 1, { 0x69, 0x00, 0x00 }, 4, 1, MOD_REG_IMM, 0, 0,                              0,                   (X16 | X32 | X64), REG_DST,  NO_PREFIX, IMM_OPND_2,     NO_MEM,     P_86,  0, NULL },
{ "imul",    3, { R32_EAX,  R32_EAX,IMM32 }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT),							                  NO_VEX, NO_EVEX, 1, 1, { 0x69, 0x00, 0x00 }, 4, 1, MOD_REG_IMM, 0, 0,                              0,                   (X16 | X32 | X64), REG_DST,  NO_PREFIX, IMM_OPND_2,     NO_MEM,     P_86,  0, NULL },
{ "imul",    3, { R32,      R32_EAX,IMM32 }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT),							                  NO_VEX, NO_EVEX, 1, 1, { 0x69, 0x00, 0x00 }, 4, 1, MOD_REG_IMM, 0, 0,                              0,                   (X16 | X32 | X64), REG_DST,  NO_PREFIX, IMM_OPND_2,     NO_MEM,     P_86,  0, NULL },
{ "imul",    3, { R32E,     R32E,   IMM32 }, GP3, (REX | REXB | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),	                      NO_VEX, NO_EVEX, 1, 1, { 0x69, 0x00, 0x00 }, 4, 1, MOD_REG_IMM, 0, 0,                              0,                               (X64), REG_DST,  NO_PREFIX, IMM_OPND_2,     NO_MEM,     P_64,  0, NULL },
{ "imul",    3, { R32E,     R32,    IMM32 }, GP3, (REX | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT),				          NO_VEX, NO_EVEX, 1, 1, { 0x69, 0x00, 0x00 }, 4, 1, MOD_REG_IMM, 0, 0,                              0,                               (X64), REG_DST,  NO_PREFIX, IMM_OPND_2,     NO_MEM,     P_64,  0, NULL },
{ "imul",    3, { R32,      R32E,   IMM32 }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT),				          NO_VEX, NO_EVEX, 1, 1, { 0x69, 0x00, 0x00 }, 4, 1, MOD_REG_IMM, 0, 0,                              0,                               (X64), REG_DST,  NO_PREFIX, IMM_OPND_2,     NO_MEM,     P_64,  0, NULL },
{ "imul",    3, { R64,      R64,    IMM32 }, GP3, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT),		              NO_VEX, NO_EVEX, 1, 1, { 0x69, 0x00, 0x00 }, 4, 1, MOD_REG_IMM, 0, 0,                              0,                               (X64), REG_DST,  NO_PREFIX, IMM_OPND_2,     NO_MEM,     P_64,  0, NULL },
{ "imul",    3, { R64_RAX,  R64,    IMM32 }, GP3, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT),		              NO_VEX, NO_EVEX, 1, 1, { 0x69, 0x00, 0x00 }, 4, 1, MOD_REG_IMM, 0, 0,                              0,                               (X64), REG_DST,  NO_PREFIX, IMM_OPND_2,     NO_MEM,     P_64,  0, NULL },
{ "imul",    3, { R64,      R64_RAX,IMM32 }, GP3, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT),		              NO_VEX, NO_EVEX, 1, 1, { 0x69, 0x00, 0x00 }, 4, 1, MOD_REG_IMM, 0, 0,                              0,                               (X64), REG_DST,  NO_PREFIX, IMM_OPND_2,     NO_MEM,     P_64,  0, NULL },
{ "imul",    3, { R64_RAX,  R64_RAX,IMM32 }, GP3, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT),		              NO_VEX, NO_EVEX, 1, 1, { 0x69, 0x00, 0x00 }, 4, 1, MOD_REG_IMM, 0, 0,                              0,                               (X64), REG_DST,  NO_PREFIX, IMM_OPND_2,     NO_MEM,     P_64,  0, NULL },
{ "imul",    3, { R64E,     R64E,   IMM32 }, GP3, (REX | REXR | REXB | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),                NO_VEX, NO_EVEX, 1, 1, { 0x69, 0x00, 0x00 }, 4, 1, MOD_REG_IMM, 0, 0,                              0,                               (X64), REG_DST,  NO_PREFIX, IMM_OPND_2,     NO_MEM,     P_64,  0, NULL },
{ "imul",    3, { R64,      R64E,   IMM32 }, GP3, (REX | REXB | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT),		      NO_VEX, NO_EVEX, 1, 1, { 0x69, 0x00, 0x00 }, 4, 1, MOD_REG_IMM, 0, 0,                              0,                               (X64), REG_DST,  NO_PREFIX, IMM_OPND_2,     NO_MEM,     P_64,  0, NULL },
{ "imul",    3, { R64E,     R64,    IMM32 }, GP3, (REX | REXR | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT),		      NO_VEX, NO_EVEX, 1, 1, { 0x69, 0x00, 0x00 }, 4, 1, MOD_REG_IMM, 0, 0,                              0,                               (X64), REG_DST,  NO_PREFIX, IMM_OPND_2,     NO_MEM,     P_64,  0, NULL },
 /* first register used for first and second operand */                                          
{ "imul",    3, { R16,               IMM8 }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT | IMM8_ONLY),							                    NO_VEX, NO_EVEX, 1, 1, { 0x6b, 0x00, 0x00 }, 2, 1, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                   (X16 | X32 | X64), REG_DST,  NO_PREFIX, IMM_OPND_1,     NO_MEM,     P_86,  0, NULL },
{ "imul",    3, { R16_AX,            IMM8 }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT | IMM8_ONLY),							                    NO_VEX, NO_EVEX, 1, 1, { 0x6b, 0x00, 0x00 }, 2, 1, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                   (X16 | X32 | X64), REG_DST,  NO_PREFIX, IMM_OPND_1,     NO_MEM,     P_86,  0, NULL },
{ "imul",    3, { R16_AX,            IMM8 }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT | IMM8_ONLY),							                    NO_VEX, NO_EVEX, 1, 1, { 0x6b, 0x00, 0x00 }, 2, 1, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                   (X16 | X32 | X64), REG_DST,  NO_PREFIX, IMM_OPND_1,     NO_MEM,     P_86,  0, NULL },
{ "imul",    3, { R16,               IMM8 }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT | IMM8_ONLY),							                    NO_VEX, NO_EVEX, 1, 1, { 0x6b, 0x00, 0x00 }, 2, 1, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                   (X16 | X32 | X64), REG_DST,  NO_PREFIX, IMM_OPND_1,     NO_MEM,     P_86,  0, NULL },
{ "imul",    3, { R16E,              IMM8 }, GP3, (REX | REXB | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT | IMM8_ONLY),            NO_VEX, NO_EVEX, 1, 1, { 0x6b, 0x00, 0x00 }, 2, 1, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                               (X64), REG_DST,  NO_PREFIX, IMM_OPND_1,     NO_MEM,     P_64,  0, NULL },
{ "imul",    3, { R16E,              IMM8 }, GP3, (REX | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT | IMM8_ONLY),				            NO_VEX, NO_EVEX, 1, 1, { 0x6b, 0x00, 0x00 }, 2, 1, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                               (X64), REG_DST,  NO_PREFIX, IMM_OPND_1,     NO_MEM,     P_64,  0, NULL },
{ "imul",    3, { R16,               IMM8 }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT | IMM8_ONLY),				            NO_VEX, NO_EVEX, 1, 1, { 0x6b, 0x00, 0x00 }, 2, 1, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                               (X64), REG_DST,  NO_PREFIX, IMM_OPND_1,     NO_MEM,     P_64,  0, NULL },
{ "imul",    3, { R32,               IMM8 }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT | IMM8_ONLY),							                    NO_VEX, NO_EVEX, 1, 1, { 0x6b, 0x00, 0x00 }, 4, 1, MOD_REG_IMM, 0, 0,                0,                   (X16 | X32 | X64), REG_DST,  NO_PREFIX, IMM_OPND_1,     NO_MEM,     P_86,  0, NULL },
{ "imul",    3, { R32_EAX,           IMM8 }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT | IMM8_ONLY),							                    NO_VEX, NO_EVEX, 1, 1, { 0x6b, 0x00, 0x00 }, 4, 1, MOD_REG_IMM, 0, 0,                0,                   (X16 | X32 | X64), REG_DST,  NO_PREFIX, IMM_OPND_1,     NO_MEM,     P_86,  0, NULL },
{ "imul",    3, { R32_EAX,           IMM8 }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT | IMM8_ONLY),							                    NO_VEX, NO_EVEX, 1, 1, { 0x6b, 0x00, 0x00 }, 4, 1, MOD_REG_IMM, 0, 0,                0,                   (X16 | X32 | X64), REG_DST,  NO_PREFIX, IMM_OPND_1,     NO_MEM,     P_86,  0, NULL },
{ "imul",    3, { R32,               IMM8 }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT | IMM8_ONLY),							                    NO_VEX, NO_EVEX, 1, 1, { 0x6b, 0x00, 0x00 }, 4, 1, MOD_REG_IMM, 0, 0,                0,                   (X16 | X32 | X64), REG_DST,  NO_PREFIX, IMM_OPND_1,     NO_MEM,     P_86,  0, NULL },
{ "imul",    3, { R32E,              IMM8 }, GP3, (REX | REXB | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM | IMM8_ONLY),	                        NO_VEX, NO_EVEX, 1, 1, { 0x6b, 0x00, 0x00 }, 4, 1, MOD_REG_IMM, 0, 0,                0,                               (X64), REG_DST,  NO_PREFIX, IMM_OPND_1,     NO_MEM,     P_64,  0, NULL },
{ "imul",    3, { R32E,              IMM8 }, GP3, (REX | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT | IMM8_ONLY),				            NO_VEX, NO_EVEX, 1, 1, { 0x6b, 0x00, 0x00 }, 4, 1, MOD_REG_IMM, 0, 0,                0,                               (X64), REG_DST,  NO_PREFIX, IMM_OPND_1,     NO_MEM,     P_64,  0, NULL },
{ "imul",    3, { R32,               IMM8 }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT | IMM8_ONLY),				            NO_VEX, NO_EVEX, 1, 1, { 0x6b, 0x00, 0x00 }, 4, 1, MOD_REG_IMM, 0, 0,                0,                               (X64), REG_DST,  NO_PREFIX, IMM_OPND_1,     NO_MEM,     P_64,  0, NULL },
{ "imul",    3, { R64,               IMM8 }, GP3, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT | IMM8_ONLY),		                NO_VEX, NO_EVEX, 1, 1, { 0x6b, 0x00, 0x00 }, 8, 1, MOD_REG_IMM, 0, 0,                0,                               (X64), REG_DST,  NO_PREFIX, IMM_OPND_1,     NO_MEM,     P_64,  0, NULL },
{ "imul",    3, { R64_RAX,           IMM8 }, GP3, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT | IMM8_ONLY),		                NO_VEX, NO_EVEX, 1, 1, { 0x6b, 0x00, 0x00 }, 8, 1, MOD_REG_IMM, 0, 0,                0,                               (X64), REG_DST,  NO_PREFIX, IMM_OPND_1,     NO_MEM,     P_64,  0, NULL },
{ "imul",    3, { R64,               IMM8 }, GP3, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT | IMM8_ONLY),		                NO_VEX, NO_EVEX, 1, 1, { 0x6b, 0x00, 0x00 }, 8, 1, MOD_REG_IMM, 0, 0,                0,                               (X64), REG_DST,  NO_PREFIX, IMM_OPND_1,     NO_MEM,     P_64,  0, NULL },
{ "imul",    3, { R64_RAX,           IMM8 }, GP3, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT | IMM8_ONLY),		                NO_VEX, NO_EVEX, 1, 1, { 0x6b, 0x00, 0x00 }, 8, 1, MOD_REG_IMM, 0, 0,                0,                               (X64), REG_DST,  NO_PREFIX, IMM_OPND_1,     NO_MEM,     P_64,  0, NULL },
{ "imul",    3, { R64E,              IMM8 }, GP3, (REX | REXR | REXB | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM | IMM8_ONLY),                  NO_VEX, NO_EVEX, 1, 1, { 0x6b, 0x00, 0x00 }, 8, 1, MOD_REG_IMM, 0, 0,                0,                               (X64), REG_DST,  NO_PREFIX, IMM_OPND_1,     NO_MEM,     P_64,  0, NULL },
{ "imul",    3, { R64,               IMM8 }, GP3, (REX | REXB | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT | IMM8_ONLY),		        NO_VEX, NO_EVEX, 1, 1, { 0x6b, 0x00, 0x00 }, 8, 1, MOD_REG_IMM, 0, 0,                0,                               (X64), REG_DST,  NO_PREFIX, IMM_OPND_1,     NO_MEM,     P_64,  0, NULL },
{ "imul",    3, { R64E,              IMM8 }, GP3, (REX | REXR | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT | IMM8_ONLY),		        NO_VEX, NO_EVEX, 1, 1, { 0x6b, 0x00, 0x00 }, 8, 1, MOD_REG_IMM, 0, 0,                0,                               (X64), REG_DST,  NO_PREFIX, IMM_OPND_1,     NO_MEM,     P_64,  0, NULL },
{ "imul",    3, { R16,               IMM16 }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT),							                                NO_VEX, NO_EVEX, 1, 1, { 0x69, 0x00, 0x00 }, 2, 1, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                   (X16 | X32 | X64), REG_DST,  NO_PREFIX, IMM_OPND_1,     NO_MEM,     P_86,  0, NULL },
{ "imul",    3, { R16_AX,            IMM16 }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT),							                                NO_VEX, NO_EVEX, 1, 1, { 0x69, 0x00, 0x00 }, 2, 1, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                   (X16 | X32 | X64), REG_DST,  NO_PREFIX, IMM_OPND_1,     NO_MEM,     P_86,  0, NULL },
{ "imul",    3, { R16_AX,            IMM16 }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT),							                                NO_VEX, NO_EVEX, 1, 1, { 0x69, 0x00, 0x00 }, 2, 1, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                   (X16 | X32 | X64), REG_DST,  NO_PREFIX, IMM_OPND_1,     NO_MEM,     P_86,  0, NULL },
{ "imul",    3, { R16,               IMM16 }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT),							                                NO_VEX, NO_EVEX, 1, 1, { 0x69, 0x00, 0x00 }, 2, 1, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                   (X16 | X32 | X64), REG_DST,  NO_PREFIX, IMM_OPND_1,     NO_MEM,     P_86,  0, NULL },
{ "imul",    3, { R16E,              IMM16 }, GP3, (REX | REXB | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT),                       NO_VEX, NO_EVEX, 1, 1, { 0x69, 0x00, 0x00 }, 2, 1, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                               (X64), REG_DST,  NO_PREFIX, IMM_OPND_1,     NO_MEM,     P_64,  0, NULL },
{ "imul",    3, { R16E,              IMM16 }, GP3, (REX | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT),				                      NO_VEX, NO_EVEX, 1, 1, { 0x69, 0x00, 0x00 }, 2, 1, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                               (X64), REG_DST,  NO_PREFIX, IMM_OPND_1,     NO_MEM,     P_64,  0, NULL },
{ "imul",    3, { R16,               IMM16 }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT),				                      NO_VEX, NO_EVEX, 1, 1, { 0x69, 0x00, 0x00 }, 2, 1, MOD_REG_IMM, 0, OP_SIZE_OVERRIDE, 0,                               (X64), REG_DST,  NO_PREFIX, IMM_OPND_1,     NO_MEM,     P_64,  0, NULL },
{ "imul",    3, { R32,               IMM32 }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT),							                                NO_VEX, NO_EVEX, 1, 1, { 0x69, 0x00, 0x00 }, 4, 1, MOD_REG_IMM, 0, 0,                0,                   (X16 | X32 | X64), REG_DST,  NO_PREFIX, IMM_OPND_1,     NO_MEM,     P_86,  0, NULL },
{ "imul",    3, { R32_EAX,           IMM32 }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT),							                                NO_VEX, NO_EVEX, 1, 1, { 0x69, 0x00, 0x00 }, 4, 1, MOD_REG_IMM, 0, 0,                0,                   (X16 | X32 | X64), REG_DST,  NO_PREFIX, IMM_OPND_1,     NO_MEM,     P_86,  0, NULL },
{ "imul",    3, { R32_EAX,           IMM32 }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT),							                                NO_VEX, NO_EVEX, 1, 1, { 0x69, 0x00, 0x00 }, 4, 1, MOD_REG_IMM, 0, 0,                0,                   (X16 | X32 | X64), REG_DST,  NO_PREFIX, IMM_OPND_1,     NO_MEM,     P_86,  0, NULL },
{ "imul",    3, { R32,               IMM32 }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT),							                                NO_VEX, NO_EVEX, 1, 1, { 0x69, 0x00, 0x00 }, 4, 1, MOD_REG_IMM, 0, 0,                0,                   (X16 | X32 | X64), REG_DST,  NO_PREFIX, IMM_OPND_1,     NO_MEM,     P_86,  0, NULL },
{ "imul",    3, { R32E,              IMM32 }, GP3, (REX | REXB | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),	                                  NO_VEX, NO_EVEX, 1, 1, { 0x69, 0x00, 0x00 }, 4, 1, MOD_REG_IMM, 0, 0,                0,                               (X64), REG_DST,  NO_PREFIX, IMM_OPND_1,     NO_MEM,     P_64,  0, NULL },
{ "imul",    3, { R32E,              IMM32 }, GP3, (REX | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT),				                      NO_VEX, NO_EVEX, 1, 1, { 0x69, 0x00, 0x00 }, 4, 1, MOD_REG_IMM, 0, 0,                0,                               (X64), REG_DST,  NO_PREFIX, IMM_OPND_1,     NO_MEM,     P_64,  0, NULL },
{ "imul",    3, { R32,               IMM32 }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT),				                      NO_VEX, NO_EVEX, 1, 1, { 0x69, 0x00, 0x00 }, 4, 1, MOD_REG_IMM, 0, 0,                0,                               (X64), REG_DST,  NO_PREFIX, IMM_OPND_1,     NO_MEM,     P_64,  0, NULL },
{ "imul",    3, { R64,               IMM32 }, GP3, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT),		                          NO_VEX, NO_EVEX, 1, 1, { 0x69, 0x00, 0x00 }, 4, 1, MOD_REG_IMM, 0, 0,                0,                               (X64), REG_DST,  NO_PREFIX, IMM_OPND_1,     NO_MEM,     P_64,  0, NULL },
{ "imul",    3, { R64_RAX,           IMM32 }, GP3, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT),		                          NO_VEX, NO_EVEX, 1, 1, { 0x69, 0x00, 0x00 }, 4, 1, MOD_REG_IMM, 0, 0,                0,                               (X64), REG_DST,  NO_PREFIX, IMM_OPND_1,     NO_MEM,     P_64,  0, NULL },
{ "imul",    3, { R64,               IMM32 }, GP3, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT),		                          NO_VEX, NO_EVEX, 1, 1, { 0x69, 0x00, 0x00 }, 4, 1, MOD_REG_IMM, 0, 0,                0,                               (X64), REG_DST,  NO_PREFIX, IMM_OPND_1,     NO_MEM,     P_64,  0, NULL },
{ "imul",    3, { R64_RAX,           IMM32 }, GP3, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT),		                          NO_VEX, NO_EVEX, 1, 1, { 0x69, 0x00, 0x00 }, 4, 1, MOD_REG_IMM, 0, 0,                0,                               (X64), REG_DST,  NO_PREFIX, IMM_OPND_1,     NO_MEM,     P_64,  0, NULL },
{ "imul",    3, { R64E,              IMM32 }, GP3, (REX | REXR | REXB | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),                             NO_VEX, NO_EVEX, 1, 1, { 0x69, 0x00, 0x00 }, 4, 1, MOD_REG_IMM, 0, 0,                0,                               (X64), REG_DST,  NO_PREFIX, IMM_OPND_1,     NO_MEM,     P_64,  0, NULL },
{ "imul",    3, { R64,               IMM32 }, GP3, (REX | REXB | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT),		                    NO_VEX, NO_EVEX, 1, 1, { 0x69, 0x00, 0x00 }, 4, 1, MOD_REG_IMM, 0, 0,                0,                               (X64), REG_DST,  NO_PREFIX, IMM_OPND_1,     NO_MEM,     P_64,  0, NULL },
{ "imul",    3, { R64E,              IMM32 }, GP3, (REX | REXR | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM | OPCODE_EXT),		                    NO_VEX, NO_EVEX, 1, 1, { 0x69, 0x00, 0x00 }, 4, 1, MOD_REG_IMM, 0, 0,                0,                               (X64), REG_DST,  NO_PREFIX, IMM_OPND_1,     NO_MEM,     P_64,  0, NULL },
//* ----------------------------------------------------------------------------------------------- */
//INC r/m8    FE /0         
//INC r/m8*   REX + FE /0   
//INC r/m16   FF /0         
//INC r/m32   FF /0         
//INC r/m64   REX.W + FF /0 
//INC r16    40+ rw**      
//INC r32    40+ rd        
/* ----------------------------------------------------------------------------------------------- */
{ "inc",    1, { R16_AX,           }, GP4,  (F_OPCODE_REG),									              NO_VEX, NO_EVEX, 1, 1, { 0x40, 0x00, 0x00 }, 2,  0, NO_MOD,      0, OP_SIZE_OVERRIDE, 0,  (X16 | X32 | X64), REG_DST,  NO_PREFIX,  NO_IMM,      NO_MEM,     P_86,  0, NULL },
{ "inc",    1, { R16,              }, GP4,  (F_OPCODE_REG),									              NO_VEX, NO_EVEX, 1, 1, { 0x40, 0x00, 0x00 }, 2,  0, NO_MOD,      0, OP_SIZE_OVERRIDE, 0,  (X16 | X32 | X64), REG_DST,  NO_PREFIX,  NO_IMM,      NO_MEM,     P_86,  0, NULL },
{ "inc",    1, { R32_EAX,          }, GP4,  (F_OPCODE_REG),									              NO_VEX, NO_EVEX, 1, 1, { 0x40, 0x00, 0x00 }, 4,  0, NO_MOD,      0, 0, 0,                 (X16 | X32 | X64), REG_DST,  NO_PREFIX,  NO_IMM,      NO_MEM,     P_86,  0, NULL },
{ "inc",    1, { R32,              }, GP4,  (F_OPCODE_REG),									              NO_VEX, NO_EVEX, 1, 1, { 0x40, 0x00, 0x00 }, 4,  0, NO_MOD,      0, 0, 0,                 (X16 | X32 | X64), REG_DST,  NO_PREFIX,  NO_IMM,      NO_MEM,     P_86,  0, NULL },
{ "inc",    1, { R16_AX,           }, GP0,  (F_OPCODE2_REG),									            NO_VEX, NO_EVEX, 1, 2, { 0xff, 0xc0, 0x00 }, 2,  0, NO_MOD,      0, OP_SIZE_OVERRIDE, 0,  (X16 | X32 | X64), REG_DST,  NO_PREFIX,  NO_IMM,      NO_MEM,     P_86,  0, NULL },
{ "inc",    1, { R16,              }, GP0,  (F_OPCODE2_REG),									            NO_VEX, NO_EVEX, 1, 2, { 0xff, 0xc0, 0x00 }, 2,  0, NO_MOD,      0, OP_SIZE_OVERRIDE, 0,  (X16 | X32 | X64), REG_DST,  NO_PREFIX,  NO_IMM,      NO_MEM,     P_86,  0, NULL },
{ "inc",    1, { R16E,             }, GP3,  (F_OPCODE2_REG),									            NO_VEX, NO_EVEX, 1, 2, { 0xff, 0xc0, 0x00 }, 2,  0, NO_MOD,      0, OP_SIZE_OVERRIDE, 0,  (X16 | X32 | X64), REG_DST,  NO_PREFIX,  NO_IMM,      NO_MEM,     P_64,  0, NULL },
{ "inc",    1, { R32_EAX,          }, GP0,  (F_OPCODE2_REG),									            NO_VEX, NO_EVEX, 1, 2, { 0xff, 0xc0, 0x00 }, 4,  0, NO_MOD,      0, 0, 0,                 (X16 | X32 | X64), REG_DST,  NO_PREFIX,  NO_IMM,      NO_MEM,     P_86,  0, NULL },
{ "inc",    1, { R32,              }, GP0,  (F_OPCODE2_REG),									            NO_VEX, NO_EVEX, 1, 2, { 0xff, 0xc0, 0x00 }, 4,  0, NO_MOD,      0, 0, 0,                 (X16 | X32 | X64), REG_DST,  NO_PREFIX,  NO_IMM,      NO_MEM,     P_86,  0, NULL },
{ "inc",    1, { R32E,             }, GP3,  (REX | REXB) | (F_OPCODE2_REG),						    NO_VEX, NO_EVEX, 1, 2, { 0xff, 0xc0, 0x00 }, 4,  0, NO_MOD,      0, 0, 0,                 (X16 | X32 | X64), REG_DST,  NO_PREFIX,  NO_IMM,      NO_MEM,     P_64,  0, NULL },
{ "inc",    1, { R8_AL,            }, GP0,  (F_OPCODE2_REG),									            NO_VEX, NO_EVEX, 1, 2, { 0xfe, 0xc0, 0x00 }, 1,  0, NO_MOD,      0, 0, 0,                 (X16 | X32 | X64), REG_DST,  NO_PREFIX,  NO_IMM,      NO_MEM,     P_86,  0, NULL },
{ "inc",    1, { R8_CL,            }, GP0,  (F_OPCODE2_REG),									            NO_VEX, NO_EVEX, 1, 2, { 0xfe, 0xc0, 0x00 }, 1,  0, NO_MOD,      0, 0, 0,                 (X16 | X32 | X64), REG_DST,  NO_PREFIX,  NO_IMM,      NO_MEM,     P_86,  0, NULL },
{ "inc",    1, { R8,               }, GP0,  (F_OPCODE2_REG),									            NO_VEX, NO_EVEX, 1, 2, { 0xfe, 0xc0, 0x00 }, 1,  0, NO_MOD,      0, 0, 0,                 (X16 | X32 | X64), REG_DST,  NO_PREFIX,  NO_IMM,      NO_MEM,     P_86,  0, NULL },
{ "inc",    1, { R8E,              }, GP3,  (REX | REXB) | (F_OPCODE2_REG),			          NO_VEX, NO_EVEX, 1, 2, { 0xfe, 0xc0, 0x00 }, 1,  0, NO_MOD,      0, 0, 0,                 (X16 | X32 | X64), REG_DST,  NO_PREFIX,  NO_IMM,      NO_MEM,     P_64,  0, NULL },
{ "inc",    1, { R8U,              }, GP3,  (REX) | (F_OPCODE2_REG),							        NO_VEX, NO_EVEX, 1, 2, { 0xfe, 0xc0, 0x00 }, 1,  0, NO_MOD,      0, 0, 0,                 (X16 | X32 | X64), REG_DST,  NO_PREFIX,  NO_IMM,      NO_MEM,     P_64,  0, NULL },
{ "inc",    1, { R16_AX,           }, GP0,  (F_OPCODE2_REG),									            NO_VEX, NO_EVEX, 1, 2, { 0xff, 0xc0, 0x00 }, 2,  0, NO_MOD,      0, OP_SIZE_OVERRIDE, 0,  (X16 | X32 | X64), REG_DST,  NO_PREFIX,  NO_IMM,      NO_MEM,     P_86,  0, NULL },
{ "inc",    1, { R16,              }, GP0,  (F_OPCODE2_REG),									            NO_VEX, NO_EVEX, 1, 2, { 0xff, 0xc0, 0x00 }, 2,  0, NO_MOD,      0, OP_SIZE_OVERRIDE, 0,  (X16 | X32 | X64), REG_DST,  NO_PREFIX,  NO_IMM,      NO_MEM,     P_86,  0, NULL },
{ "inc",    1, { R16E,             }, GP3,  (F_OPCODE2_REG),									            NO_VEX, NO_EVEX, 1, 2, { 0xff, 0xc0, 0x00 }, 2,  0, NO_MOD,      0, OP_SIZE_OVERRIDE, 0,  (X16 | X32 | X64), REG_DST,  NO_PREFIX,  NO_IMM,      NO_MEM,     P_64,  0, NULL },
{ "inc",    1, { R32_EAX,          }, GP0,  (F_OPCODE2_REG),									            NO_VEX, NO_EVEX, 1, 2, { 0xff, 0xc0, 0x00 }, 4,  0, NO_MOD,      0, 0, 0,                 (X16 | X32 | X64), REG_DST,  NO_PREFIX,  NO_IMM,      NO_MEM,     P_86,  0, NULL },
{ "inc",    1, { R32,              }, GP0,  (F_OPCODE2_REG),									            NO_VEX, NO_EVEX, 1, 2, { 0xff, 0xc0, 0x00 }, 4,  0, NO_MOD,      0, 0, 0,                 (X16 | X32 | X64), REG_DST,  NO_PREFIX,  NO_IMM,      NO_MEM,     P_86,  0, NULL },
{ "inc",    1, { R32E,             }, GP3,  (REX | REXB) | (F_OPCODE2_REG),						    NO_VEX, NO_EVEX, 1, 2, { 0xff, 0xc0, 0x00 }, 4,  0, NO_MOD,      0, 0, 0,                 (X16 | X32 | X64), REG_DST,  NO_PREFIX,  NO_IMM,      NO_MEM,     P_64,  0, NULL },
{ "inc",    1, { R64_RAX,          }, GP3,  (REX | REXW) | (F_OPCODE2_REG),		            NO_VEX, NO_EVEX, 1, 2, { 0xff, 0xc0, 0x00 }, 8,  0, NO_MOD,      0, 0, 0,                 (X16 | X32 | X64), REG_DST,  NO_PREFIX,  NO_IMM,      NO_MEM,     P_64,  0, NULL },
{ "inc",    1, { R64,              }, GP3,  (REX | REXW) | (F_OPCODE2_REG),		            NO_VEX, NO_EVEX, 1, 2, { 0xff, 0xc0, 0x00 }, 8,  0, NO_MOD,      0, 0, 0,                 (X16 | X32 | X64), REG_DST,  NO_PREFIX,  NO_IMM,      NO_MEM,     P_64,  0, NULL },
{ "inc",    1, { R64E,             }, GP3,  (REX | REXW | REXB) | (F_OPCODE2_REG),		    NO_VEX, NO_EVEX, 1, 2, { 0xff, 0xc0, 0x00 }, 8,  0, NO_MOD,      0, 0, 0,                 (X16 | X32 | X64), REG_DST,  NO_PREFIX,  NO_IMM,      NO_MEM,     P_64,  0, NULL },
{ "inc",    1, { M8,               }, GP0,   ALLOW_SEG | (F_MODRM | F_MODRM_REG),                 NO_VEX, NO_EVEX, 1, 1, { 0xfe, 0x00, 0x00 }, 1,  0, 0x00,        0, 0, 0,                       (X32 | X64), NO_DST,   NO_PREFIX,  NO_IMM,      MEM_OPND_0, P_486, 0, NULL },
{ "inc",    1, { M16,              }, GP2,   ALLOW_SEG | (F_MODRM | F_MODRM_REG),                 NO_VEX, NO_EVEX, 1, 1, { 0xff, 0x00, 0x00 }, 2,  0, 0x00,        0, OP_SIZE_OVERRIDE, 0,        (X32 | X64), NO_DST,   NO_PREFIX,  NO_IMM,      MEM_OPND_0, P_486, 0, NULL },
{ "inc",    1, { M32,              }, GP2,   ALLOW_SEG | (F_MODRM | F_MODRM_REG),                 NO_VEX, NO_EVEX, 1, 1, { 0xff, 0x00, 0x00 }, 4,  0, 0x00,        0, 0, ADDR_SIZE_OVERRIDE,      (X32 | X64), NO_DST,   NO_PREFIX,  NO_IMM,      MEM_OPND_0, P_486, 0, NULL },
{ "inc",    1, { M64,              }, GP3,   ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_REG),  NO_VEX, NO_EVEX, 1, 1, { 0xff, 0x00, 0x00 }, 8,  0, 0x00,        0, 0, ADDR_SIZE_OVERRIDE,      (X32 | X64), NO_DST,   NO_PREFIX,  NO_IMM,      MEM_OPND_0, P_64,  0, NULL },

/* ----------------------------------------------------------------------------------------------- */
//DEC r/m8    FE /1         
//DEC r/m8*   REX + FE /1   
//DEC r/m16   FF /1         
//DEC r/m32   FF /1         
//DEC r/m64   REX.W + FF /1 
//DEC r16    48+ rw**      
//DEC r32    48+ rd        
/* ----------------------------------------------------------------------------------------------- */
//{ "dec",    1, { R16_AX,           }, GP0,  (F_OPCODE_REG),									              NO_VEX, NO_EVEX, 1, 1, { 0x48, 0x00, 0x00 }, 2,  0, NO_MOD,      0, OP_SIZE_OVERRIDE, 0,  (X16 | X32 | X64), REG_DST,  NO_PREFIX,  NO_IMM,      NO_MEM,     P_86,  0, NULL },
//{ "dec",    1, { R16,              }, GP0,  (F_OPCODE_REG),									              NO_VEX, NO_EVEX, 1, 1, { 0x48, 0x00, 0x00 }, 2,  0, NO_MOD,      0, OP_SIZE_OVERRIDE, 0,  (X16 | X32 | X64), REG_DST,  NO_PREFIX,  NO_IMM,      NO_MEM,     P_86,  0, NULL },
//{ "dec",    1, { R32_EAX,          }, GP0,  (F_OPCODE_REG),									              NO_VEX, NO_EVEX, 1, 1, { 0x48, 0x00, 0x00 }, 4,  0, NO_MOD,      0, 0, 0,                 (X16 | X32 | X64), REG_DST,  NO_PREFIX,  NO_IMM,      NO_MEM,     P_86,  0, NULL },
//{ "dec",    1, { R32,              }, GP0,  (F_OPCODE_REG),									              NO_VEX, NO_EVEX, 1, 1, { 0x48, 0x00, 0x00 }, 4,  0, NO_MOD,      0, 0, 0,                 (X16 | X32 | X64), REG_DST,  NO_PREFIX,  NO_IMM,      NO_MEM,     P_86,  0, NULL },
/* ----------------------------------------------------------------------------------------------- */
{ "dec",    1, { R8_AL,            }, GP0,  (F_OPCODE2_REG),									            NO_VEX, NO_EVEX, 1, 2, { 0xfe, 0xc8, 0x00 }, 1,  0, NO_MOD,      0, 0, 0,                 (X16 | X32 | X64), REG_DST,  NO_PREFIX,  NO_IMM,      NO_MEM,     P_86,  0, NULL },
{ "dec",    1, { R8_CL,            }, GP0,  (F_OPCODE2_REG),									            NO_VEX, NO_EVEX, 1, 2, { 0xfe, 0xc8, 0x00 }, 1,  0, NO_MOD,      0, 0, 0,                 (X16 | X32 | X64), REG_DST,  NO_PREFIX,  NO_IMM,      NO_MEM,     P_86,  0, NULL },
{ "dec",    1, { R8,               }, GP0,  (F_OPCODE2_REG),									            NO_VEX, NO_EVEX, 1, 2, { 0xfe, 0xc8, 0x00 }, 1,  0, NO_MOD,      0, 0, 0,                 (X16 | X32 | X64), REG_DST,  NO_PREFIX,  NO_IMM,      NO_MEM,     P_86,  0, NULL },
{ "dec",    1, { R8E,              }, GP3,  (REX | REXB) | (F_OPCODE2_REG),			          NO_VEX, NO_EVEX, 1, 2, { 0xfe, 0xc8, 0x00 }, 1,  0, NO_MOD,      0, 0, 0,                 (X16 | X32 | X64), REG_DST,  NO_PREFIX,  NO_IMM,      NO_MEM,     P_64,  0, NULL },
{ "dec",    1, { R8U,              }, GP3,  (REX) | (F_OPCODE2_REG),							        NO_VEX, NO_EVEX, 1, 2, { 0xfe, 0xc8, 0x00 }, 1,  0, NO_MOD,      0, 0, 0,                 (X16 | X32 | X64), REG_DST,  NO_PREFIX,  NO_IMM,      NO_MEM,     P_64,  0, NULL },
{ "dec",    1, { R16_AX,           }, GP0,  (F_OPCODE2_REG),									            NO_VEX, NO_EVEX, 1, 2, { 0xff, 0xc8, 0x00 }, 2,  0, NO_MOD,      0, OP_SIZE_OVERRIDE, 0,  (X16 | X32 | X64), REG_DST,  NO_PREFIX,  NO_IMM,      NO_MEM,     P_86,  0, NULL },
{ "dec",    1, { R16,              }, GP0,  (F_OPCODE2_REG),									            NO_VEX, NO_EVEX, 1, 2, { 0xff, 0xc8, 0x00 }, 2,  0, NO_MOD,      0, OP_SIZE_OVERRIDE, 0,  (X16 | X32 | X64), REG_DST,  NO_PREFIX,  NO_IMM,      NO_MEM,     P_86,  0, NULL },
{ "dec",    1, { R16E,             }, GP3,  (F_OPCODE2_REG),									            NO_VEX, NO_EVEX, 1, 2, { 0xff, 0xc8, 0x00 }, 2,  0, NO_MOD,      0, OP_SIZE_OVERRIDE, 0,  (X16 | X32 | X64), REG_DST,  NO_PREFIX,  NO_IMM,      NO_MEM,     P_64,  0, NULL },
{ "dec",    1, { R32_EAX,          }, GP0,  (F_OPCODE2_REG),									            NO_VEX, NO_EVEX, 1, 2, { 0xff, 0xc8, 0x00 }, 4,  0, NO_MOD,      0, 0, 0,                 (X16 | X32 | X64), REG_DST,  NO_PREFIX,  NO_IMM,      NO_MEM,     P_86,  0, NULL },
{ "dec",    1, { R32,              }, GP0,  (F_OPCODE2_REG),									            NO_VEX, NO_EVEX, 1, 2, { 0xff, 0xc8, 0x00 }, 4,  0, NO_MOD,      0, 0, 0,                 (X16 | X32 | X64), REG_DST,  NO_PREFIX,  NO_IMM,      NO_MEM,     P_86,  0, NULL },
{ "dec",    1, { R32E,             }, GP3,  (REX | REXB) | (F_OPCODE2_REG),						    NO_VEX, NO_EVEX, 1, 2, { 0xff, 0xc8, 0x00 }, 4,  0, NO_MOD,      0, 0, 0,                 (X16 | X32 | X64), REG_DST,  NO_PREFIX,  NO_IMM,      NO_MEM,     P_64,  0, NULL },
{ "dec",    1, { R64_RAX,          }, GP3,  (REX | REXW) | (F_OPCODE2_REG),		            NO_VEX, NO_EVEX, 1, 2, { 0xff, 0xc8, 0x00 }, 8,  0, NO_MOD,      0, 0, 0,                 (X16 | X32 | X64), REG_DST,  NO_PREFIX,  NO_IMM,      NO_MEM,     P_64,  0, NULL },
{ "dec",    1, { R64,              }, GP3,  (REX | REXW) | (F_OPCODE2_REG),		            NO_VEX, NO_EVEX, 1, 2, { 0xff, 0xc8, 0x00 }, 8,  0, NO_MOD,      0, 0, 0,                 (X16 | X32 | X64), REG_DST,  NO_PREFIX,  NO_IMM,      NO_MEM,     P_64,  0, NULL },
{ "dec",    1, { R64E,             }, GP3,  (REX | REXW | REXB) | (F_OPCODE2_REG),		    NO_VEX, NO_EVEX, 1, 2, { 0xff, 0xc8, 0x00 }, 8,  0, NO_MOD,      0, 0, 0,                 (X16 | X32 | X64), REG_DST,  NO_PREFIX,  NO_IMM,      NO_MEM,     P_64,  0, NULL },
{ "dec",    1, { M8,               }, GP0,   ALLOW_SEG | (F_MODRM | F_MODRM_REG),                 NO_VEX, NO_EVEX, 1, 1, { 0xfe, 0x00, 0x00 }, 1,  0, 0x08,        0, 0, 0,                       (X32 | X64), NO_DST,   NO_PREFIX,  NO_IMM,      MEM_OPND_0, P_486, 0, NULL },
{ "dec",    1, { M16,              }, GP2,   ALLOW_SEG | (F_MODRM | F_MODRM_REG),                 NO_VEX, NO_EVEX, 1, 1, { 0xff, 0x00, 0x00 }, 2,  0, 0x08,        0, OP_SIZE_OVERRIDE, 0,        (X32 | X64), NO_DST,   NO_PREFIX,  NO_IMM,      MEM_OPND_0, P_486, 0, NULL },
{ "dec",    1, { M32,              }, GP2,   ALLOW_SEG | (F_MODRM | F_MODRM_REG),                 NO_VEX, NO_EVEX, 1, 1, { 0xff, 0x00, 0x00 }, 4,  0, 0x08,        0, 0, ADDR_SIZE_OVERRIDE,      (X32 | X64), NO_DST,   NO_PREFIX,  NO_IMM,      MEM_OPND_0, P_486, 0, NULL },
{ "dec",    1, { M64,              }, GP3,   ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_REG),  NO_VEX, NO_EVEX, 1, 1, { 0xff, 0x00, 0x00 }, 8,  0, 0x08,        0, 0, ADDR_SIZE_OVERRIDE,      (X32 | X64), NO_DST,   NO_PREFIX,  NO_IMM,      MEM_OPND_0, P_64,  0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//PUSH r / m16    FF / 6     M   Valid     Valid Push r / m16.
//PUSH r / m32    FF / 6     M   N.E.      Valid Push r / m32.
//PUSH r / m64    FF / 6     M   Valid       N.E.Push r / m64.
//PUSH r16        50 + rw    O   Valid     Valid Push r16.
//PUSH r32        50 + rd    O   N.E.      Valid Push r32.
//PUSH r64        50 + rd    O   Valid       N.E.Push r64.
//PUSH imm8       6A ib      I   Valid     Valid Push imm8.
//PUSH imm16      68 iw      I   Valid     Valid Push imm16.
//PUSH imm32      68 id      I   Valid     Valid Push imm32.
//PUSH CS         0E         ZO  Invalid   Valid Push CS.         
//PUSH SS         16         ZO  Invalid   Valid Push SS.
//PUSH DS         1E         ZO  Invalid   Valid Push DS.
//PUSH ES         06         ZO  Invalid   Valid Push ES.
//PUSH FS         0F A0      ZO  Valid     Valid Push FS.
//PUSH GS         0F A8      ZO  Valid     Valid Push GS.
/* ----------------------------------------------------------------------------------------------- */
{ "push",    1, { R32_EAX,          }, GP4,  (F_OPCODE_REG),									              NO_VEX, NO_EVEX, 1, 1, { 0x50, 0x00, 0x00 }, 4,  0, NO_MOD,      0, 0, 0,                       (X16 | X32), REG_DST,  NO_PREFIX,  NO_IMM,      NO_MEM,     P_86,  0, NULL },
{ "push",    1, { R32,              }, GP4,  (F_OPCODE_REG),									              NO_VEX, NO_EVEX, 1, 1, { 0x50, 0x00, 0x00 }, 4,  0, NO_MOD,      0, 0, 0,                       (X16 | X32), REG_DST,  NO_PREFIX,  NO_IMM,      NO_MEM,     P_86,  0, NULL },
{ "push",    1, { R_SEG,            }, GP4,  (F_OPCODE_REG),							                  NO_VEX, NO_EVEX, 1, 1, { 0x06, 0x00, 0x00 }, 1,  0, NO_MOD,      0, 0, 0,                       (X16 | X32), REG_DST,  NO_PREFIX,  NO_IMM,      NO_MEM,     P_86,  0, NULL },
{ "push",    1, { M32,              }, GP4,   ALLOW_SEG,                                    NO_VEX, NO_EVEX, 1, 1, { 0xff, 0x00, 0x00 }, 4,  0, 0x30, 0, 0, ADDR_SIZE_OVERRIDE,             (X16 | X32), RM_DST,   NO_PREFIX,  NO_IMM,      MEM_OPND_0, P_86,  0, NULL },
{ "push",    1, { M_ANY,            }, GP4,   ALLOW_SEG,                                    NO_VEX, NO_EVEX, 1, 1, { 0xff, 0x00, 0x00 }, 4,  0, 0x30, 0, 0, ADDR_SIZE_OVERRIDE,             (X16 | X32), RM_DST,   NO_PREFIX,  NO_IMM,      MEM_OPND_0, P_86,  0, NULL },
{ "push",    1, { R_SEGE,           }, GP3,  (F_OPCODE_REG),							                  NO_VEX, NO_EVEX, 1, 1, { 0x80, 0x00, 0x00 }, 1,  0, NO_MOD,      0, 0, 0,                             (X64), REG_DST,  PFX_0xF,    NO_IMM,      NO_MEM,     P_64,  0, NULL },
{ "push",    1, { R16_AX,           }, GP0,  (F_OPCODE_REG),									              NO_VEX, NO_EVEX, 1, 1, { 0x50, 0x00, 0x00 }, 2,  0, NO_MOD,      0, OP_SIZE_OVERRIDE, 0,  (X16 | X32 | X64), REG_DST,  NO_PREFIX,  NO_IMM,      NO_MEM,     P_86,  0, NULL },
{ "push",    1, { R16,              }, GP0,  (F_OPCODE_REG),									              NO_VEX, NO_EVEX, 1, 1, { 0x50, 0x00, 0x00 }, 2,  0, NO_MOD,      0, OP_SIZE_OVERRIDE, 0,  (X16 | X32 | X64), REG_DST,  NO_PREFIX,  NO_IMM,      NO_MEM,     P_86,  0, NULL },
{ "push",    1, { R16E,             }, GP3,  (REX | REXB) | (F_OPCODE_REG),								  NO_VEX, NO_EVEX, 1, 1, { 0x50, 0x00, 0x00 }, 2,  0, NO_MOD,      0, OP_SIZE_OVERRIDE, 0,  (X16 | X32 | X64), REG_DST,  NO_PREFIX,  NO_IMM,      NO_MEM,     P_86,  0, NULL },
{ "push",    1, { M16,              }, GP0,   ALLOW_SEG,                                    NO_VEX, NO_EVEX, 1, 1, { 0xff, 0x00, 0x00 }, 2,  0, 0x30,        0, OP_SIZE_OVERRIDE, 0,  (X16 | X32 | X64), RM_DST,   NO_PREFIX,  NO_IMM,      MEM_OPND_0, P_486, 0, NULL },
{ "push",    1, { R64_RAX,          }, GP0,  (F_OPCODE_REG),		                            NO_VEX, NO_EVEX, 1, 1, { 0x50, 0x00, 0x00 }, 8,  0, NO_MOD,      0, 0, 0,                             (X64), REG_DST,  NO_PREFIX,  NO_IMM,      NO_MEM,     P_64,  0, NULL },
{ "push",    1, { R64,              }, GP0,  (F_OPCODE_REG),		                            NO_VEX, NO_EVEX, 1, 1, { 0x50, 0x00, 0x00 }, 8,  0, NO_MOD,      0, 0, 0,                             (X64), REG_DST,  NO_PREFIX,  NO_IMM,      NO_MEM,     P_64,  0, NULL },
{ "push",    1, { R64E,             }, GP3,  (REX | REXB) | (F_OPCODE_REG),		              NO_VEX, NO_EVEX, 1, 1, { 0x50, 0x00, 0x00 }, 8,  0, NO_MOD,      0, 0, 0,                             (X64), REG_DST,  NO_PREFIX,  NO_IMM,      NO_MEM,     P_64,  0, NULL },
{ "push",    1, { M64,              }, GP3,   ALLOW_SEG,                                    NO_VEX, NO_EVEX, 1, 1, { 0xff, 0x00, 0x00 }, 8,  0, 0x30,        0, 0, ADDR_SIZE_OVERRIDE,            (X64), RM_DST,   NO_PREFIX,  NO_IMM,      MEM_OPND_0, P_64,  0, NULL },
{ "push",    1, { M_ANY,            }, GP3,   ALLOW_SEG,                                    NO_VEX, NO_EVEX, 1, 1, { 0xff, 0x00, 0x00 }, 8,  0, 0x30,        0, 0, ADDR_SIZE_OVERRIDE,            (X64), RM_DST,   NO_PREFIX,  NO_IMM,      MEM_OPND_0, P_64,  0, NULL },
{ "push",    1, { IMM8,             }, GP0, 0,		                                          NO_VEX, NO_EVEX, 1, 1, { 0x6a, 0x00, 0x00 }, 1,  0, MOD_MEM_IMM, 0, 0, 0,                 (X16 | X32 | X64), NO_DST,   NO_PREFIX, IMM_OPND_0,   NO_MEM,     P_86,  0, NULL },
{ "push",    1, { IMM16,            }, GP0, 0,		                                          NO_VEX, NO_EVEX, 1, 1, { 0x68, 0x00, 0x00 }, 2,  0, MOD_MEM_IMM, 0, OP_SIZE_OVERRIDE, 0,  (X16 | X32 | X64), NO_DST,   NO_PREFIX, IMM_OPND_0,   NO_MEM, P_86,  0, NULL },
{ "push",    1, { IMM32,            }, GP0, 0,		                                          NO_VEX, NO_EVEX, 1, 1, { 0x68, 0x00, 0x00 }, 4,  0, MOD_MEM_IMM, 0, 0, 0,                       (X32 | X64), NO_DST,   NO_PREFIX, IMM_OPND_0,   NO_MEM,     P_386, 0, NULL },
{ "pushw",   1, { IMM8,             }, GP0, 0,		                                          NO_VEX, NO_EVEX, 1, 1, { 0x6a, 0x00, 0x00 }, 1,  0, MOD_MEM_IMM, 0, OP_SIZE_OVERRIDE, 0,  (X16 | X32 | X64), NO_DST,   NO_PREFIX, IMM_OPND_0,   NO_MEM,     P_86,  0, NULL },
{ "pushw",   1, { IMM16,            }, GP0, 0,		                                          NO_VEX, NO_EVEX, 1, 1, { 0x68, 0x00, 0x00 }, 2,  0, MOD_MEM_IMM, 0, OP_SIZE_OVERRIDE, 0,  (X16 | X32 | X64), NO_DST,   NO_PREFIX, IMM_OPND_0,   NO_MEM, P_86,  0, NULL },
{ "pushq",   0, { OP_N,   OP_N }, GP3, (REX | REXW) | ALLOW_REP,                            NO_VEX, NO_EVEX, 8, 1, { 0x9c, 0x00, 0x00 }, 1, 0, NO_MOD, 0, 0, 0,                                       (X64),       NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_64, 0, NULL },
{ "cqo",     0, { OP_N,   OP_N }, GP3, (REX | REXW) | ALLOW_REP,                            NO_VEX, NO_EVEX, 8, 1, { 0x99, 0x00, 0x00 }, 1, 0, NO_MOD, 0, 0, 0,                                       (X64),       NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_64, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//POP r/m16 M   Valid   Valid    8F /0 
//POP r/m32 M   N.E.    Valid    8F /0 
//POP r/m64 M   Valid   N.E.     8F /0 
//POP r16   O   Valid   Valid    58+ rw
//POP r32   O   N.E.    Valid    58+ rd
//POP r64   O   Valid   N.E.     58+ rd
//POP DS   ZO   Invalid Valid    1F    
//POP ES   ZO   Invalid Valid    07    
//POP SS   ZO   Invalid Valid    17    
//POP FS   ZO   Valid   Valid    0F A1 
//POP FS   ZO   N.E.    Valid    0F A1 
//POP FS   ZO   Valid   N.E.     0F A1 
//POP GS   ZO   Valid   Valid    0F A9 
//POP GS   ZO   N.E.    Valid    0F A9 
//POP GS   ZO   Valid   N.E.     0F A9 
/* ----------------------------------------------------------------------------------------------- */
{ "pop",    1,  { R32_EAX,          }, GP4,  (F_OPCODE_REG),									              NO_VEX, NO_EVEX, 1, 1, { 0x58, 0x00, 0x00 }, 4,  0, NO_MOD,      0, 0, 0,                       (X16 | X32), REG_DST,  NO_PREFIX,  NO_IMM,      NO_MEM,     P_86,  0, NULL },
{ "pop",    1,  { R32,              }, GP4,  (F_OPCODE_REG),									              NO_VEX, NO_EVEX, 1, 1, { 0x58, 0x00, 0x00 }, 4,  0, NO_MOD,      0, 0, 0,                       (X16 | X32), REG_DST,  NO_PREFIX,  NO_IMM,      NO_MEM,     P_86,  0, NULL },
{ "pop",    1,  { R_SEG,            }, GP4,  (F_OPCODE_REG),							                  NO_VEX, NO_EVEX, 1, 1, { 0x07, 0x00, 0x00 }, 1,  0, NO_MOD,      0, 0, 0,                       (X16 | X32), REG_DST,  NO_PREFIX,  NO_IMM,      NO_MEM,     P_86,  0, NULL },
{ "pop",    1,  { M32,              }, GP4,   ALLOW_SEG,                                    NO_VEX, NO_EVEX, 1, 1, { 0x8f, 0x00, 0x00 }, 8,  0, 0x00, 0, 0, ADDR_SIZE_OVERRIDE,             (X16 | X32), RM_DST,   NO_PREFIX,  NO_IMM,      MEM_OPND_0, P_86,  0, NULL },
{ "pop",    1,  { M_ANY,            }, GP4,   ALLOW_SEG,                                    NO_VEX, NO_EVEX, 1, 1, { 0x8f, 0x00, 0x00 }, 8,  0, 0x00, 0, 0, ADDR_SIZE_OVERRIDE,             (X16 | X32), RM_DST,   NO_PREFIX,  NO_IMM,      MEM_OPND_0, P_86,  0, NULL },
{ "pop",    1,  { R_SEGE,           }, GP3,  (F_OPCODE_REG),							                  NO_VEX, NO_EVEX, 1, 1, { 0x81, 0x00, 0x00 }, 1,  0, NO_MOD,      0, 0, 0,                             (X64), REG_DST,  PFX_0xF,    NO_IMM,      NO_MEM,     P_64,  0, NULL },
{ "pop",    1,  { R16_AX,           }, GP0,  (F_OPCODE_REG),									              NO_VEX, NO_EVEX, 1, 1, { 0x58, 0x00, 0x00 }, 2,  0, NO_MOD,      0, OP_SIZE_OVERRIDE, 0,  (X16 | X32 | X64), REG_DST,  NO_PREFIX,  NO_IMM,      NO_MEM,     P_86,  0, NULL },
{ "pop",    1,  { R16,              }, GP0,  (F_OPCODE_REG),									              NO_VEX, NO_EVEX, 1, 1, { 0x58, 0x00, 0x00 }, 2,  0, NO_MOD,      0, OP_SIZE_OVERRIDE, 0,  (X16 | X32 | X64), REG_DST,  NO_PREFIX,  NO_IMM,      NO_MEM,     P_86,  0, NULL },
{ "pop",    1,  { R16E,             }, GP3,  (REX | REXB) | (F_OPCODE_REG),								  NO_VEX, NO_EVEX, 1, 1, { 0x58, 0x00, 0x00 }, 2,  0, NO_MOD,      0, OP_SIZE_OVERRIDE, 0,  (X16 | X32 | X64), REG_DST,  NO_PREFIX,  NO_IMM,      NO_MEM,     P_86,  0, NULL },
{ "pop",    1,  { M16,              }, GP0,   ALLOW_SEG,                                    NO_VEX, NO_EVEX, 1, 1, { 0x8f, 0x00, 0x00 }, 2,  0, 0x00,        0, OP_SIZE_OVERRIDE, 0,  (X16 | X32 | X64), RM_DST,   NO_PREFIX,  NO_IMM,      MEM_OPND_0, P_486, 0, NULL },
{ "pop",    1,  { R64_RAX,          }, GP0,  (F_OPCODE_REG),		                            NO_VEX, NO_EVEX, 1, 1, { 0x58, 0x00, 0x00 }, 8,  0, NO_MOD,      0, 0, 0,                             (X64), REG_DST,  NO_PREFIX,  NO_IMM,      NO_MEM,     P_64,  0, NULL },
{ "pop",    1,  { R64,              }, GP0,  (F_OPCODE_REG),		                            NO_VEX, NO_EVEX, 1, 1, { 0x58, 0x00, 0x00 }, 8,  0, NO_MOD,      0, 0, 0,                             (X64), REG_DST,  NO_PREFIX,  NO_IMM,      NO_MEM,     P_64,  0, NULL },
{ "pop",    1,  { R64E,             }, GP3,  (REX | REXB) | (F_OPCODE_REG),		              NO_VEX, NO_EVEX, 1, 1, { 0x58, 0x00, 0x00 }, 8,  0, NO_MOD,      0, 0, 0,                             (X64), REG_DST,  NO_PREFIX,  NO_IMM,      NO_MEM,     P_64,  0, NULL },
{ "pop",    1,  { M64,              }, GP3,   ALLOW_SEG,                                    NO_VEX, NO_EVEX, 1, 1, { 0x8f, 0x00, 0x00 }, 8,  0, 0x00,        0, 0, ADDR_SIZE_OVERRIDE,            (X64), RM_DST,   NO_PREFIX,  NO_IMM,      MEM_OPND_0, P_64,  0, NULL },
{ "pop",    1,  { M_ANY,            }, GP3,   ALLOW_SEG,                                    NO_VEX, NO_EVEX, 1, 1, { 0x8f, 0x00, 0x00 }, 8,  0, 0x00,        0, 0, ADDR_SIZE_OVERRIDE,            (X64), RM_DST,   NO_PREFIX,  NO_IMM,      MEM_OPND_0, P_64,  0, NULL },
{ "popfq",  0,  { OP_N,   OP_N      }, GP3, (REX | REXW) | ALLOW_REP,                       NO_VEX, NO_EVEX, 8, 1, { 0x9d, 0x00, 0x00 }, 1, 0, NO_MOD, 0, 0, 0,                                       (X64),       NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_64, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//SCAS m8  ZO Valid Valid   AE          
//SCAS m16 ZO Valid Valid   AF          
//SCAS m32 ZO Valid Valid   AF          
//SCAS m64 ZO Valid N.E.    REX.W + AF  
//SCASB    ZO Valid Valid   AE          
//SCASW    ZO Valid Valid   AF          
//SCASD    ZO Valid Valid   AF          
//SCASQ    ZO Valid N.E.    REX.W + AF  
/* ----------------------------------------------------------------------------------------------- */
{ "scas",  1,  { M8,     OP_N }, GP1, (NO_FLAGS) | ALLOW_REP,                     NO_VEX, NO_EVEX, 1, 1, { 0xae, 0x00, 0x00 }, 1, 0, NO_MOD, 0, 0, 0,                                 (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
{ "scas",  1,  { M16,    OP_N }, GP2, (NO_FLAGS) | ALLOW_REP,                     NO_VEX, NO_EVEX, 1, 1, { 0xaf, 0x00, 0x00 }, 2, 0, NO_MOD, 0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
{ "scas",  1,  { M32,    OP_N }, GP2, (NO_FLAGS) | ALLOW_REP,                     NO_VEX, NO_EVEX, 1, 1, { 0xaf, 0x00, 0x00 }, 4, 0, NO_MOD, 0, 0, ADDR_SIZE_OVERRIDE,                (X32 | X64),       NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
{ "scas",  1,  { M64,    OP_N }, GP3, (REX | REXW) | ALLOW_REP,                   NO_VEX, NO_EVEX, 1, 1, { 0xaf, 0x00, 0x00 }, 8, 0, NO_MOD, 0, 0, 0,                                       (X64),       NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_64, 0, NULL },
{ "scasb", 0,  { OP_N,   OP_N }, GP1, (NO_FLAGS) | ALLOW_REP,                     NO_VEX, NO_EVEX, 1, 1, { 0xae, 0x00, 0x00 }, 1, 0, NO_MOD, 0, 0, 0,                                 (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
{ "scasw", 0,  { OP_N,   OP_N }, GP2, (NO_FLAGS) | ALLOW_REP,                     NO_VEX, NO_EVEX, 1, 1, { 0xaf, 0x00, 0x00 }, 2, 0, NO_MOD, 0, OP_SIZE_OVERRIDE, 0,                  (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
{ "scasd", 0,  { OP_N,   OP_N }, GP2, (NO_FLAGS) | ALLOW_REP,                     NO_VEX, NO_EVEX, 1, 1, { 0xaf, 0x00, 0x00 }, 4, 0, NO_MOD, 0, 0, ADDR_SIZE_OVERRIDE,                (X32 | X64),       NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
{ "scasq", 0,  { OP_N,   OP_N }, GP3, (REX | REXW) | ALLOW_REP,                   NO_VEX, NO_EVEX, 1, 1, { 0xaf, 0x00, 0x00 }, 8, 0, NO_MOD, 0, 0, 0,                                       (X64),       NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_64, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//STOS m8  NA Valid Valid   AA          
//STOS m16 NA Valid Valid   AB          
//STOS m32 NA Valid Valid   AB          
//STOS m64 NA Valid N.E.    REX.W + AB  
//STOSB    NA Valid Valid   AA          
//STOSW    NA Valid Valid   AB          
//STOSD    NA Valid Valid   AB          
//STOSQ    NA Valid N.E.    REX.W + AB  
/* ----------------------------------------------------------------------------------------------- */
{ "stos",  1,  { M8,     OP_N }, GP1, (NO_FLAGS) | ALLOW_REP,                     NO_VEX, NO_EVEX, 1, 1, { 0xaa, 0x00, 0x00 }, 1, 0, NO_MOD, 0, 0, 0,                                 (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
{ "stos",  1,  { M16,    OP_N }, GP2, (NO_FLAGS) | ALLOW_REP,                     NO_VEX, NO_EVEX, 1, 1, { 0xab, 0x00, 0x00 }, 2, 0, NO_MOD, 0, OP_SIZE_OVERRIDE, ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
{ "stos",  1,  { M32,    OP_N }, GP2, (NO_FLAGS) | ALLOW_REP,                     NO_VEX, NO_EVEX, 1, 1, { 0xab, 0x00, 0x00 }, 4, 0, NO_MOD, 0, 0, ADDR_SIZE_OVERRIDE,                (X32 | X64),       NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
{ "stos",  1,  { M64,    OP_N }, GP3, (REX | REXW) | ALLOW_REP,                   NO_VEX, NO_EVEX, 1, 1, { 0xab, 0x00, 0x00 }, 8, 0, NO_MOD, 0, 0, 0,                                       (X64),       NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_64, 0, NULL },
{ "stosb", 0,  { OP_N,   OP_N }, GP1, (NO_FLAGS) | ALLOW_REP,                     NO_VEX, NO_EVEX, 1, 1, { 0xaa, 0x00, 0x00 }, 1, 0, NO_MOD, 0, 0, 0,                                 (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
{ "stosw", 0,  { OP_N,   OP_N }, GP2, (NO_FLAGS) | ALLOW_REP,                     NO_VEX, NO_EVEX, 1, 1, { 0xab, 0x00, 0x00 }, 2, 0, NO_MOD, 0, OP_SIZE_OVERRIDE, ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
{ "stosd", 0,  { OP_N,   OP_N }, GP2, (NO_FLAGS) | ALLOW_REP,                     NO_VEX, NO_EVEX, 1, 1, { 0xab, 0x00, 0x00 }, 4, 0, NO_MOD, 0, 0, ADDR_SIZE_OVERRIDE,                (X32 | X64),       NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
{ "stosq", 0,  { OP_N,   OP_N }, GP3, (REX | REXW) | ALLOW_REP,                   NO_VEX, NO_EVEX, 1, 1, { 0xab, 0x00, 0x00 }, 8, 0, NO_MOD, 0, 0, 0,                                       (X64),       NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_64, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//LODS m8  ZO Valid Valid  AC          
//LODS m16 ZO Valid Valid  AD          
//LODS m32 ZO Valid Valid  AD          
//LODS m64 ZO Valid N.E.   REX.W + AD  
//LODSB    ZO Valid Valid  AC          
//LODSW    ZO Valid Valid  AD          
//LODSD    ZO Valid Valid  AD          
//LODSQ    ZO Valid N.E.   REX.W + AD  
/* ----------------------------------------------------------------------------------------------- */
{ "lods",  1,  { M8,     OP_N }, GP1, (NO_FLAGS) | ALLOW_REP,                     NO_VEX, NO_EVEX, 1, 1, { 0xac, 0x00, 0x00 }, 1, 0, NO_MOD, 0, 0, 0,                                 (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
{ "lods",  1,  { M16,    OP_N }, GP2, (NO_FLAGS) | ALLOW_REP,                     NO_VEX, NO_EVEX, 1, 1, { 0xad, 0x00, 0x00 }, 2, 0, NO_MOD, 0, OP_SIZE_OVERRIDE, ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
{ "lods",  1,  { M32,    OP_N }, GP2, (NO_FLAGS) | ALLOW_REP,                     NO_VEX, NO_EVEX, 1, 1, { 0xad, 0x00, 0x00 }, 4, 0, NO_MOD, 0, 0, ADDR_SIZE_OVERRIDE,                (X32 | X64),       NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
{ "lods",  1,  { M64,    OP_N }, GP3, (REX | REXW) | ALLOW_REP,                   NO_VEX, NO_EVEX, 1, 1, { 0xad, 0x00, 0x00 }, 8, 0, NO_MOD, 0, 0, 0,                                       (X64),       NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_64, 0, NULL },
{ "lodsb", 0,  { OP_N,   OP_N }, GP1, (NO_FLAGS) | ALLOW_REP,                     NO_VEX, NO_EVEX, 1, 1, { 0xac, 0x00, 0x00 }, 1, 0, NO_MOD, 0, 0, 0,                                 (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
{ "lodsw", 0,  { OP_N,   OP_N }, GP2, (NO_FLAGS) | ALLOW_REP,                     NO_VEX, NO_EVEX, 1, 1, { 0xad, 0x00, 0x00 }, 2, 0, NO_MOD, 0, OP_SIZE_OVERRIDE, ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
{ "lodsd", 0,  { OP_N,   OP_N }, GP2, (NO_FLAGS) | ALLOW_REP,                     NO_VEX, NO_EVEX, 1, 1, { 0xad, 0x00, 0x00 }, 4, 0, NO_MOD, 0, 0, ADDR_SIZE_OVERRIDE,                (X32 | X64),       NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_86, 0, NULL },
{ "lodsq", 0,  { OP_N,   OP_N }, GP3, (REX | REXW) | ALLOW_REP,                   NO_VEX, NO_EVEX, 1, 1, { 0xad, 0x00, 0x00 }, 8, 0, NO_MOD, 0, 0, 0,                                       (X64),       NO_DST, NO_PREFIX, NO_IMM, NO_MEM, P_64, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//LOOP rel8   D Valid Valid  E2 cb 
//LOOPE rel8  D Valid Valid  E1 cb 
//LOOPNE rel8 D Valid Valid  E0 cb 
/* ----------------------------------------------------------------------------------------------- */
{ "loop",       1, { IMM8,        }, GP0, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0xe2, 0x00, 0x00 }, 1, 0, MOD_REG_IMM, 0, 0, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, IMM_OPND_0, NO_MEM, P_86,  0, NULL },
{ "loope",      1, { IMM8,        }, GP0, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0xe1, 0x00, 0x00 }, 1, 0, MOD_REG_IMM, 0, 0, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, IMM_OPND_0, NO_MEM, P_86,  0, NULL },
{ "loopz",      1, { IMM8,        }, GP0, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0xe1, 0x00, 0x00 }, 1, 0, MOD_REG_IMM, 0, 0, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, IMM_OPND_0, NO_MEM, P_86,  0, NULL },
{ "loopne",     1, { IMM8,        }, GP0, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0xe0, 0x00, 0x00 }, 1, 0, MOD_REG_IMM, 0, 0, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, IMM_OPND_0, NO_MEM, P_86,  0, NULL },
{ "loopnz",     1, { IMM8,        }, GP0, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0xe0, 0x00, 0x00 }, 1, 0, MOD_REG_IMM, 0, 0, 0,                  (X16 | X32 | X64), NO_DST,  NO_PREFIX, IMM_OPND_0, NO_MEM, P_86,  0, NULL },
{ "loopd",      1, { IMM8,        }, GP0, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0xe2, 0x00, 0x00 }, 1, 0, MOD_REG_IMM, 0, 0, ADDR_SIZE_OVERRIDE, (X16 | X32),       NO_DST,  NO_PREFIX, IMM_OPND_0, NO_MEM, P_386, 0, NULL },
{ "looped",     1, { IMM8,        }, GP0, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0xe1, 0x00, 0x00 }, 1, 0, MOD_REG_IMM, 0, 0, ADDR_SIZE_OVERRIDE, (X16 | X32),       NO_DST,  NO_PREFIX, IMM_OPND_0, NO_MEM, P_386, 0, NULL },
{ "loopzd",     1, { IMM8,        }, GP0, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0xe1, 0x00, 0x00 }, 1, 0, MOD_REG_IMM, 0, 0, ADDR_SIZE_OVERRIDE, (X16 | X32),       NO_DST,  NO_PREFIX, IMM_OPND_0, NO_MEM, P_386, 0, NULL },
{ "loopned",    1, { IMM8,        }, GP0, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0xe0, 0x00, 0x00 }, 1, 0, MOD_REG_IMM, 0, 0, ADDR_SIZE_OVERRIDE, (X16 | X32),       NO_DST,  NO_PREFIX, IMM_OPND_0, NO_MEM, P_386, 0, NULL },
{ "loopnzd",    1, { IMM8,        }, GP0, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0xe0, 0x00, 0x00 }, 1, 0, MOD_REG_IMM, 0, 0, ADDR_SIZE_OVERRIDE, (X16 | X32),       NO_DST,  NO_PREFIX, IMM_OPND_0, NO_MEM, P_386, 0, NULL },
{ "loopw",      1, { IMM8,        }, GP0, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0xe2, 0x00, 0x00 }, 1, 0, MOD_REG_IMM, 0, 0, ADDR_SIZE_OVERRIDE, (X16 | X32),       NO_DST,  NO_PREFIX, IMM_OPND_0, NO_MEM, P_86,  0, NULL },
{ "loopew",     1, { IMM8,        }, GP0, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0xe1, 0x00, 0x00 }, 1, 0, MOD_REG_IMM, 0, 0, ADDR_SIZE_OVERRIDE, (X16 | X32),       NO_DST,  NO_PREFIX, IMM_OPND_0, NO_MEM, P_86,  0, NULL },
{ "loopzw",     1, { IMM8,        }, GP0, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0xe1, 0x00, 0x00 }, 1, 0, MOD_REG_IMM, 0, 0, ADDR_SIZE_OVERRIDE, (X16 | X32),       NO_DST,  NO_PREFIX, IMM_OPND_0, NO_MEM, P_86,  0, NULL },
{ "loopnew",    1, { IMM8,        }, GP0, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0xe0, 0x00, 0x00 }, 1, 0, MOD_REG_IMM, 0, 0, ADDR_SIZE_OVERRIDE, (X16 | X32),       NO_DST,  NO_PREFIX, IMM_OPND_0, NO_MEM, P_86,  0, NULL },
{ "loopnzw",    1, { IMM8,        }, GP0, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0xe0, 0x00, 0x00 }, 1, 0, MOD_REG_IMM, 0, 0, ADDR_SIZE_OVERRIDE, (X16 | X32),       NO_DST,  NO_PREFIX, IMM_OPND_0, NO_MEM, P_86,  0, NULL },
{ "jcxz",       1, { IMM8,        }, GP0, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0xe3, 0x00, 0x00 }, 1, 0, MOD_REG_IMM, 0, 0, ADDR_SIZE_OVERRIDE,       (X16 | X32), NO_DST,  NO_PREFIX, IMM_OPND_0, NO_MEM, P_86,  0, NULL },
{ "jecxz",      1, { IMM8,        }, GP0, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0xe3, 0x00, 0x00 }, 1, 0, MOD_REG_IMM, 0, 0, ADDR_SIZE_OVERRIDE,       (X32 | X64), NO_DST,  NO_PREFIX, IMM_OPND_0, NO_MEM, P_86,  0, NULL },
{ "jrcxz",      1, { IMM8,        }, GP0, 0,		                                                                  NO_VEX, NO_EVEX, 1, 1, { 0xe3, 0x00, 0x00 }, 1, 0, MOD_REG_IMM, 0, 0, 0,                        (X32 | X64), NO_DST,  NO_PREFIX, IMM_OPND_0, NO_MEM, P_64,  0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//ARPL r/m16, r16  63 /r  ZO N. E. Valid
/* ----------------------------------------------------------------------------------------------- */
{ "arpl",    2, { R16,      R16     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                  NO_VEX, NO_EVEX, 1, 1, { 0x63, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                   (X16 | X32), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "arpl",    2, { R16_AX,   R16     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                  NO_VEX, NO_EVEX, 1, 1, { 0x63, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                   (X16 | X32), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "arpl",    2, { R16,      R16_AX  }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                  NO_VEX, NO_EVEX, 1, 1, { 0x63, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                   (X16 | X32), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "arpl",    2, { M_ANY,    R16     }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                        NO_VEX, NO_EVEX, 1, 1, { 0x63, 0x00, 0x00 }, 2, 0, MOD_MEM_REG, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32), RM_DST,   NO_PREFIX, NO_IMM,     MEM_OPND_0, P_86,  0, NULL },
{ "arpl",    2, { M_ANY,    R16_AX  }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                        NO_VEX, NO_EVEX, 1, 1, { 0x63, 0x00, 0x00 }, 2, 0, MOD_MEM_REG, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32), RM_DST,   NO_PREFIX, NO_IMM,     MEM_OPND_0, P_86,  0, NULL },
/* ----------------------------------------------------------------------------------------------- */
{ "lldt",    1, { R16_AX,           }, GP0,  (F_OPCODE2_REG),									             NO_VEX, NO_EVEX, 1, 2, { 0x00, 0xd0, 0x00 }, 2,  0, NO_MOD,      0, 0, 0,  (X16 | X32), REG_DST,  PFX_0xF,  NO_IMM,      NO_MEM,     P_86, 0, NULL },
{ "lldt",    1, { R16,              }, GP0,  (F_OPCODE2_REG),									             NO_VEX, NO_EVEX, 1, 2, { 0x00, 0xd0, 0x00 }, 2,  0, NO_MOD,      0, 0, 0,  (X16 | X32), REG_DST,  PFX_0xF,  NO_IMM,      NO_MEM,     P_86, 0, NULL },
{ "lldt",    1, { M_ANY,            }, GP0,   ALLOW_SEG,                                   NO_VEX, NO_EVEX, 1, 1, { 0x00, 0x00, 0x00 }, 2,  0, 0x10,        0, 0, 0,  (X16 | X32), RM_DST,   PFX_0xF,  NO_IMM,      MEM_OPND_0, P_86, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
{ "lmsw",    1, { R16_AX,           }, GP0,  (F_OPCODE2_REG),									             NO_VEX, NO_EVEX, 1, 2, { 0x01, 0xf0, 0x00 }, 2,  0, NO_MOD,      0, 0, 0,  (X16 | X32), REG_DST,  PFX_0xF,  NO_IMM,      NO_MEM,     P_86, 0, NULL },
{ "lmsw",    1, { R16,              }, GP0,  (F_OPCODE2_REG),									             NO_VEX, NO_EVEX, 1, 2, { 0x01, 0xf0, 0x00 }, 2,  0, NO_MOD,      0, 0, 0,  (X16 | X32), REG_DST,  PFX_0xF,  NO_IMM,      NO_MEM,     P_86, 0, NULL },
{ "lmsw",    1, { M_ANY,            }, GP0,   ALLOW_SEG,                                   NO_VEX, NO_EVEX, 1, 1, { 0x01, 0x00, 0x00 }, 2,  0, 0x30,        0, 0, 0,  (X16 | X32), RM_DST,   PFX_0xF,  NO_IMM,      MEM_OPND_0, P_86, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
{ "ltr",    1, { R16_AX,           }, GP0,  (F_OPCODE2_REG),									             NO_VEX, NO_EVEX, 1, 2, { 0x00, 0xd8, 0x00 }, 2,  0, NO_MOD,      0, 0, 0,  (X16 | X32), REG_DST,  PFX_0xF,  NO_IMM,      NO_MEM,     P_86, 0, NULL },
{ "ltr",    1, { R16,              }, GP0,  (F_OPCODE2_REG),									             NO_VEX, NO_EVEX, 1, 2, { 0x00, 0xd8, 0x00 }, 2,  0, NO_MOD,      0, 0, 0,  (X16 | X32), REG_DST,  PFX_0xF,  NO_IMM,      NO_MEM,     P_86, 0, NULL },
{ "ltr",    1, { M_ANY,            }, GP0,   ALLOW_SEG,                                    NO_VEX, NO_EVEX, 1, 1, { 0x00, 0x00, 0x00 }, 2,  0, 0x18,        0, 0, 0,  (X16 | X32), RM_DST,   PFX_0xF,  NO_IMM,      MEM_OPND_0, P_86, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
{ "sldt",    1, { R16_AX,           }, GP0,  (F_OPCODE2_REG),									             NO_VEX, NO_EVEX, 1, 2, { 0x00, 0xc0, 0x00 }, 2,  0, NO_MOD,      0, 0, 0,  (X16 | X32), REG_DST,  PFX_0xF,  NO_IMM,      NO_MEM,     P_86, 0, NULL },
{ "sldt",    1, { R16,              }, GP0,  (F_OPCODE2_REG),									             NO_VEX, NO_EVEX, 1, 2, { 0x00, 0xc0, 0x00 }, 2,  0, NO_MOD,      0, 0, 0,  (X16 | X32), REG_DST,  PFX_0xF,  NO_IMM,      NO_MEM,     P_86, 0, NULL },
{ "sldt",    1, { M_ANY,            }, GP0,   ALLOW_SEG,                                   NO_VEX, NO_EVEX, 1, 1, { 0x00, 0x00, 0x00 }, 2,  0, 0x00,        0, 0, 0,  (X16 | X32), RM_DST,   PFX_0xF,  NO_IMM,      MEM_OPND_0, P_86, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
{ "smsw",    1, { R16_AX,           }, GP0,  (F_OPCODE2_REG),									             NO_VEX, NO_EVEX, 1, 2, { 0x01, 0xe0, 0x00 }, 2,  0, NO_MOD,      0, 0, 0,  (X16 | X32), REG_DST,  PFX_0xF,  NO_IMM,      NO_MEM,     P_86, 0, NULL },
{ "smsw",    1, { R16,              }, GP0,  (F_OPCODE2_REG),									             NO_VEX, NO_EVEX, 1, 2, { 0x01, 0xe0, 0x00 }, 2,  0, NO_MOD,      0, 0, 0,  (X16 | X32), REG_DST,  PFX_0xF,  NO_IMM,      NO_MEM,     P_86, 0, NULL },
{ "smsw",    1, { M_ANY,            }, GP0,   ALLOW_SEG,                                   NO_VEX, NO_EVEX, 1, 1, { 0x01, 0x00, 0x00 }, 2,  0, 0x20,        0, 0, 0,  (X16 | X32), RM_DST,   PFX_0xF,  NO_IMM,      MEM_OPND_0, P_86, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
{ "str",    1, { R16_AX,           }, GP0,  (F_OPCODE2_REG),									             NO_VEX, NO_EVEX, 1, 2, { 0x00, 0xc8, 0x00 }, 2,  0, NO_MOD,      0, 0, 0,  (X16 | X32), REG_DST,  PFX_0xF,  NO_IMM,      NO_MEM,     P_86, 0, NULL },
{ "str",    1, { R16,              }, GP0,  (F_OPCODE2_REG),									             NO_VEX, NO_EVEX, 1, 2, { 0x00, 0xc8, 0x00 }, 2,  0, NO_MOD,      0, 0, 0,  (X16 | X32), REG_DST,  PFX_0xF,  NO_IMM,      NO_MEM,     P_86, 0, NULL },
{ "str",    1, { M_ANY,            }, GP0,   ALLOW_SEG,                                    NO_VEX, NO_EVEX, 1, 1, { 0x00, 0x00, 0x00 }, 2,  0, 0x08,        0, 0, 0,  (X16 | X32), RM_DST,   PFX_0xF,  NO_IMM,      MEM_OPND_0, P_86, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
{ "verr",    1, { R16_AX,           }, GP0,  (F_OPCODE2_REG),									             NO_VEX, NO_EVEX, 1, 2, { 0x00, 0xe0, 0x00 }, 2,  0, NO_MOD,      0, 0, 0,  (X16 | X32), REG_DST,  PFX_0xF,  NO_IMM,      NO_MEM,     P_86, 0, NULL },
{ "verr",    1, { R16,              }, GP0,  (F_OPCODE2_REG),									             NO_VEX, NO_EVEX, 1, 2, { 0x00, 0xe0, 0x00 }, 2,  0, NO_MOD,      0, 0, 0,  (X16 | X32), REG_DST,  PFX_0xF,  NO_IMM,      NO_MEM,     P_86, 0, NULL },
{ "verr",    1, { M_ANY,            }, GP0,   ALLOW_SEG,                                   NO_VEX, NO_EVEX, 1, 1, { 0x00, 0x00, 0x00 }, 2,  0, 0x20,        0, 0, 0,  (X16 | X32), RM_DST,   PFX_0xF,  NO_IMM,      MEM_OPND_0, P_86, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
{ "verw",    1, { R16_AX,           }, GP0,  (F_OPCODE2_REG),									             NO_VEX, NO_EVEX, 1, 2, { 0x00, 0xe8, 0x00 }, 2,  0, NO_MOD,      0, 0, 0,  (X16 | X32), REG_DST,  PFX_0xF,  NO_IMM,      NO_MEM,     P_86, 0, NULL },
{ "verw",    1, { R16,              }, GP0,  (F_OPCODE2_REG),									             NO_VEX, NO_EVEX, 1, 2, { 0x00, 0xe8, 0x00 }, 2,  0, NO_MOD,      0, 0, 0,  (X16 | X32), REG_DST,  PFX_0xF,  NO_IMM,      NO_MEM,     P_86, 0, NULL },
{ "verw",    1, { M_ANY,            }, GP0,   ALLOW_SEG,                                   NO_VEX, NO_EVEX, 1, 1, { 0x00, 0x00, 0x00 }, 2,  0, 0x28,        0, 0, 0,  (X16 | X32), RM_DST,   PFX_0xF,  NO_IMM,      MEM_OPND_0, P_86, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//MOVBE r16, m16 RM Valid Valid    0F 38 F0 / r          
//MOVBE r32, m32 RM Valid Valid    0F 38 F0 / r          
//MOVBE r64, m64 RM Valid N.E.     REX.W + 0F 38 F0 / r  
//MOVBE m16, r16 MR Valid Valid    0F 38 F1 / r          
//MOVBE m32, r32 MR Valid Valid    0F 38 F1 / r          
//MOVBE m64, r64 MR Valid N.E.     REX.W + 0F 38 F1 / r  
/* ----------------------------------------------------------------------------------------------- */
{ "movbe",    2, { R16,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),	                              NO_VEX, NO_EVEX, 1, 3, { 0x0f, 0x38, 0xf0 }, 2, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST, NO_PREFIX, NO_IMM, MEM_OPND_1, P_86,  0, NULL },
{ "movbe",    2, { R16E,     M_ANY   }, GP3, ALLOW_SEG | (REX | REXR) | (F_MODRM | F_MODRM_REG),	              NO_VEX, NO_EVEX, 1, 3, { 0x0f, 0x38, 0xf0 }, 2, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE,             (X64), REG_DST, NO_PREFIX, NO_IMM, MEM_OPND_1, P_64,  0, NULL },
{ "movbe",    2, { R32,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                        NO_VEX, NO_EVEX, 1, 3, { 0x0f, 0x38, 0xf0 }, 4, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST, NO_PREFIX, NO_IMM, MEM_OPND_1, P_86,  0, NULL },
{ "movbe",    2, { R32E,     M_ANY   }, GP3, ALLOW_SEG | (REX | REXR) | (F_MODRM | F_MODRM_REG),	              NO_VEX, NO_EVEX, 1, 3, { 0x0f, 0x38, 0xf0 }, 4, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE,             (X64), REG_DST, NO_PREFIX, NO_IMM, MEM_OPND_1, P_64,  0, NULL },
{ "movbe",    2, { R64,      M_ANY   }, GP3, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_REG),				        NO_VEX, NO_EVEX, 1, 3, { 0x0f, 0x38, 0xf0 }, 8, 0, MOD_REG_MEM, 0, 0,				ADDR_SIZE_OVERRIDE,           (X16 | X32 | X64), REG_DST, NO_PREFIX, NO_IMM, MEM_OPND_1, P_64,  0, NULL },
{ "movbe",    2, { R64E,     M_ANY   }, GP3, ALLOW_SEG | (REX | REXW | REXR) | (F_MODRM | F_MODRM_REG),	        NO_VEX, NO_EVEX, 1, 3, { 0x0f, 0x38, 0xf0 }, 8, 0, MOD_REG_MEM, 0, 0,				ADDR_SIZE_OVERRIDE,                       (X64), REG_DST, NO_PREFIX, NO_IMM, MEM_OPND_1, P_64,  0, NULL },
{ "movbe",    2, { M_ANY,    R16     }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                        NO_VEX, NO_EVEX, 1, 3, { 0x0f, 0x38, 0xf1 }, 2, 0, MOD_MEM_REG, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_86,  0, NULL },
{ "movbe",    2, { M_ANY,    R16E    }, GP3, ALLOW_SEG | (REX | REXR) | (F_MODRM | F_MODRM_REG),	              NO_VEX, NO_EVEX, 1, 3, { 0x0f, 0x38, 0xf1 }, 2, 0, MOD_MEM_REG, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE,             (X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_64,  0, NULL },
{ "movbe",    2, { M_ANY,    R32     }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                        NO_VEX, NO_EVEX, 1, 3, { 0x0f, 0x38, 0xf1 }, 4, 0, MOD_MEM_REG, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_86,  0, NULL },
{ "movbe",    2, { M_ANY,    R32E    }, GP3, ALLOW_SEG | (REX | REXR) | (F_MODRM | F_MODRM_REG),	              NO_VEX, NO_EVEX, 1, 3, { 0x0f, 0x38, 0xf1 }, 4, 0, MOD_MEM_REG, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE,             (X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_64,  0, NULL },
{ "movbe",    2, { M_ANY,    R64     }, GP0, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_REG),			          NO_VEX, NO_EVEX, 1, 3, { 0x0f, 0x38, 0xf1 }, 8, 0, MOD_MEM_REG, 0, 0,				ADDR_SIZE_OVERRIDE,                       (X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_64,  0, NULL },
{ "movbe",    2, { M_ANY,    R64E    }, GP3, ALLOW_SEG | (REX | REXW | REXR) | (F_MODRM | F_MODRM_REG),	        NO_VEX, NO_EVEX, 1, 3, { 0x0f, 0x38, 0xf1 }, 8, 0, MOD_MEM_REG, 0, 0,				ADDR_SIZE_OVERRIDE,                       (X64), RM_DST,  NO_PREFIX, NO_IMM, MEM_OPND_0, P_64,  0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//LAR r16, r16 / m16   RM Valid Valid   0F 02 / r
//LAR reg, r32 / m16   RM Valid Valid   0F 02 / r
/* ----------------------------------------------------------------------------------------------- */
{ "lar",    2, { R16,      R16     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x02, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                   (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "lar",    2, { R16E,     R16E    }, GP3, (REX | REXB | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		    NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x02, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "lar",    2, { R16E,     R16     }, GP3, (REX | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				        NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x02, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "lar",    2, { R16,      R16E    }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				        NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x02, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "lar",    2, { R32,      R32     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                NO_VEX, NO_EVEX, 2, 2, { 0x0f, 0x02, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                   (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "lar",    2, { R32E,     R32E    }, GP3, (REX | REXB | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		    NO_VEX, NO_EVEX, 2, 2, { 0x0f, 0x02, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "lar",    2, { R32E,     R32     }, GP3, (REX | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				        NO_VEX, NO_EVEX, 2, 2, { 0x0f, 0x02, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "lar",    2, { R32,      R32E    }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				        NO_VEX, NO_EVEX, 2, 2, { 0x0f, 0x02, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "lar",    2, { R64,      R64     }, GP3, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		            NO_VEX, NO_EVEX, 4, 2, { 0x0f, 0x02, 0x00 }, 2, 0, MOD_REG_REG, 0, 0,                0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "lar",    2, { R64E,     R64E    }, GP3, (REX | REXR | REXB | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM), NO_VEX, NO_EVEX, 4, 2, { 0x0f, 0x02, 0x00 }, 2, 0, MOD_REG_REG, 0, 0,                0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "lar",    2, { R64,      R64E    }, GP3, (REX | REXB | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		    NO_VEX, NO_EVEX, 4, 2, { 0x0f, 0x02, 0x00 }, 2, 0, MOD_REG_REG, 0, 0,                0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "lar",    2, { R64E,     R64     }, GP3, (REX | REXR | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		    NO_VEX, NO_EVEX, 4, 2, { 0x0f, 0x02, 0x00 }, 2, 0, MOD_REG_REG, 0, 0,                0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "lar",    2, { R16,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),	                              NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x02, 0x00 }, 2, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_86,  0, NULL },
{ "lar",    2, { R16E,     M_ANY   }, GP3, ALLOW_SEG | (REX | REXR) | (F_MODRM | F_MODRM_REG),	              NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x02, 0x00 }, 2, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE,             (X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_64,  0, NULL },
{ "lar",    2, { R32,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                        NO_VEX, NO_EVEX, 2, 2, { 0x0f, 0x02, 0x00 }, 2, 0, MOD_REG_MEM, 0, 0,	                ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_86,  0, NULL },
{ "lar",    2, { R32E,     M_ANY   }, GP3, ALLOW_SEG | (REX | REXR) | (F_MODRM | F_MODRM_REG),	              NO_VEX, NO_EVEX, 2, 2, { 0x0f, 0x02, 0x00 }, 2, 0, MOD_REG_MEM, 0, 0,	                ADDR_SIZE_OVERRIDE,             (X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_64,  0, NULL },
{ "lar",    2, { R64,      M_ANY   }, GP3, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_REG),				        NO_VEX, NO_EVEX, 4, 2, { 0x0f, 0x02, 0x00 }, 8, 0, MOD_REG_MEM, 0, 0,				          ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_64,  0, NULL },
{ "lar",    2, { R64E,     M_ANY   }, GP3, ALLOW_SEG | (REX | REXW | REXR) | (F_MODRM | F_MODRM_REG),	        NO_VEX, NO_EVEX, 4, 2, { 0x0f, 0x02, 0x00 }, 8, 0, MOD_REG_MEM, 0, 0,				          ADDR_SIZE_OVERRIDE,             (X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_64,  0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//LSL r16, r16 / m16 RM Valid Valid     0F 03 / r
//LSL r32, r32 / m16 * RM Valid Valid   0F 03 / r
//LSL r64, r32 / m16 * RM Valid Valid   REX.W + 0F 03 / r
/* ----------------------------------------------------------------------------------------------- */
{ "lsl",    2, { R16,      R16     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x03, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                   (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "lsl",    2, { R16E,     R16E    }, GP3, (REX | REXB | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		    NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x03, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "lsl",    2, { R16E,     R16     }, GP3, (REX | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				        NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x03, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "lsl",    2, { R16,      R16E    }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				        NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x03, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "lsl",    2, { R32,      R32     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                NO_VEX, NO_EVEX, 2, 2, { 0x0f, 0x03, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                   (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "lsl",    2, { R32E,     R32E    }, GP3, (REX | REXB | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		    NO_VEX, NO_EVEX, 2, 2, { 0x0f, 0x03, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "lsl",    2, { R32E,     R32     }, GP3, (REX | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				        NO_VEX, NO_EVEX, 2, 2, { 0x0f, 0x03, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "lsl",    2, { R32,      R32E    }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				        NO_VEX, NO_EVEX, 2, 2, { 0x0f, 0x03, 0x00 }, 2, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "lsl",    2, { R64,      R64     }, GP3, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		            NO_VEX, NO_EVEX, 4, 2, { 0x0f, 0x03, 0x00 }, 2, 0, MOD_REG_REG, 0, 0,                0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "lsl",    2, { R64E,     R64E    }, GP3, (REX | REXR | REXB | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM), NO_VEX, NO_EVEX, 4, 2, { 0x0f, 0x03, 0x00 }, 2, 0, MOD_REG_REG, 0, 0,                0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "lsl",    2, { R64,      R64E    }, GP3, (REX | REXB | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		    NO_VEX, NO_EVEX, 4, 2, { 0x0f, 0x03, 0x00 }, 2, 0, MOD_REG_REG, 0, 0,                0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "lsl",    2, { R64E,     R64     }, GP3, (REX | REXR | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),		    NO_VEX, NO_EVEX, 4, 2, { 0x0f, 0x03, 0x00 }, 2, 0, MOD_REG_REG, 0, 0,                0,                               (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "lsl",    2, { R16,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),	                              NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x03, 0x00 }, 2, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_86,  0, NULL },
{ "lsl",    2, { R16E,     M_ANY   }, GP3, ALLOW_SEG | (REX | REXR) | (F_MODRM | F_MODRM_REG),	              NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x03, 0x00 }, 2, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE,             (X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_64,  0, NULL },
{ "lsl",    2, { R32,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                        NO_VEX, NO_EVEX, 2, 2, { 0x0f, 0x03, 0x00 }, 2, 0, MOD_REG_MEM, 0, 0,	                ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_86,  0, NULL },
{ "lsl",    2, { R32E,     M_ANY   }, GP3, ALLOW_SEG | (REX | REXR) | (F_MODRM | F_MODRM_REG),	              NO_VEX, NO_EVEX, 2, 2, { 0x0f, 0x03, 0x00 }, 2, 0, MOD_REG_MEM, 0, 0,	                ADDR_SIZE_OVERRIDE,             (X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_64,  0, NULL },
{ "lsl",    2, { R64,      M_ANY   }, GP3, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_REG),				        NO_VEX, NO_EVEX, 4, 2, { 0x0f, 0x03, 0x00 }, 8, 0, MOD_REG_MEM, 0, 0,				          ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_64,  0, NULL },
{ "lsl",    2, { R64E,     M_ANY   }, GP3, ALLOW_SEG | (REX | REXW | REXR) | (F_MODRM | F_MODRM_REG),	        NO_VEX, NO_EVEX, 4, 2, { 0x0f, 0x03, 0x00 }, 8, 0, MOD_REG_MEM, 0, 0,				          ADDR_SIZE_OVERRIDE,             (X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_64,  0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//LEA r16, m RM Valid Valid   8D / r          
//LEA r32, m RM Valid Valid   8D / r          
//LEA r64, m RM Valid N.E.    REX.W + 8D / r  
/* ----------------------------------------------------------------------------------------------- */
{ "lea",    2, { R16,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),	                              NO_VEX, NO_EVEX, 1, 1, { 0x8d, 0x00, 0x00 }, 2, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_86,  0, NULL },
{ "lea",    2, { R16E,     M_ANY   }, GP3, ALLOW_SEG | (REX | REXR) | (F_MODRM | F_MODRM_REG),	              NO_VEX, NO_EVEX, 1, 1, { 0x8d, 0x00, 0x00 }, 2, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE,             (X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_64,  0, NULL },
{ "lea",    2, { R32,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                        NO_VEX, NO_EVEX, 2, 1, { 0x8d, 0x00, 0x00 }, 4, 0, MOD_REG_MEM, 0, 0,	                ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_86,  0, NULL },
{ "lea",    2, { R32E,     M_ANY   }, GP3, ALLOW_SEG | (REX | REXR) | (F_MODRM | F_MODRM_REG),	              NO_VEX, NO_EVEX, 2, 1, { 0x8d, 0x00, 0x00 }, 4, 0, MOD_REG_MEM, 0, 0,	                ADDR_SIZE_OVERRIDE,             (X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_64,  0, NULL },
{ "lea",    2, { R64,      M_ANY   }, GP3, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_REG),				        NO_VEX, NO_EVEX, 4, 1, { 0x8d, 0x00, 0x00 }, 8, 0, MOD_REG_MEM, 0, 0,				          ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_64,  0, NULL },
{ "lea",    2, { R64E,     M_ANY   }, GP3, ALLOW_SEG | (REX | REXW | REXR) | (F_MODRM | F_MODRM_REG),	        NO_VEX, NO_EVEX, 4, 1, { 0x8d, 0x00, 0x00 }, 8, 0, MOD_REG_MEM, 0, 0,				          ADDR_SIZE_OVERRIDE,             (X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_64,  0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//LDS r16,m16:16 RM Invalid Valid     C5 /r           
//LDS r32,m16:32 RM Invalid Valid     C5 /r           
/* ----------------------------------------------------------------------------------------------- */
{ "lds",    2, { R16,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),	                              NO_VEX, NO_EVEX, 1, 1, { 0xc5, 0x00, 0x00 }, 2,   0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_86,  0, NULL },
{ "lds",    2, { R32,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                        NO_VEX, NO_EVEX, 1, 1, { 0xc5, 0x00, 0x00 }, 4,   0, MOD_REG_MEM, 0, 0,	                0, (X16 | X32), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_86,  0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//LES r16,m16:16 RM Invalid Valid     C4 /r           
//LES r32,m16:32 RM Invalid Valid     C4 /r           
/* ----------------------------------------------------------------------------------------------- */
{ "les",    2, { R16,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),	                              NO_VEX, NO_EVEX, 1, 1, { 0xc4, 0x00, 0x00 }, 2,   0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_86,  0, NULL },
{ "les",    2, { R32,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                        NO_VEX, NO_EVEX, 1, 1, { 0xc4, 0x00, 0x00 }, 4,   0, MOD_REG_MEM, 0, 0,	                0, (X16 | X32), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_86,  0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//LFS r16,m16:16 RM Valid   Valid     0F B4 /r        
//LFS r32,m16:32 RM Valid   Valid     0F B4 /r        
//LFS r64,m16:64 RM Valid   N.E.      REX + 0F B4 /r  
/* ----------------------------------------------------------------------------------------------- */
{ "lfs",    2, { R16,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),	                              NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0xb4, 0x00 }, 2,   0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_86,  0, NULL },
{ "lfs",    2, { R16E,     M_ANY   }, GP3, ALLOW_SEG | (REX | REXR) | (F_MODRM | F_MODRM_REG),	              NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0xb4, 0x00 }, 2,   0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE,             (X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_64,  0, NULL },
{ "lfs",    2, { R32,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                        NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0xb4, 0x00 }, 4,   0, MOD_REG_MEM, 0, 0,	                ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_86,  0, NULL },
{ "lfs",    2, { R32E,     M_ANY   }, GP3, ALLOW_SEG | (REX | REXR) | (F_MODRM | F_MODRM_REG),	              NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0xb4, 0x00 }, 4,   0, MOD_REG_MEM, 0, 0,	                ADDR_SIZE_OVERRIDE,             (X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_64,  0, NULL },
{ "lfs",    2, { R64,      M_ANY   }, GP3, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_REG),				        NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0xb4, 0x00 }, 8,   0, MOD_REG_MEM, 0, 0,				          ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_64,  0, NULL },
{ "lfs",    2, { R64E,     M_ANY   }, GP3, ALLOW_SEG | (REX | REXW | REXR) | (F_MODRM | F_MODRM_REG),	        NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0xb4, 0x00 }, 8,   0, MOD_REG_MEM, 0, 0,				          ADDR_SIZE_OVERRIDE,             (X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_64,  0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//LGS r16,m16:16 RM Valid   Valid     0F B5 /r        
//LGS r32,m16:32 RM Valid   Valid     0F B5 /r        
//LGS r64,m16:64 RM Valid   N.E.      REX + 0F B5 /r  
/* ----------------------------------------------------------------------------------------------- */
{ "lgs",    2, { R16,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),	                              NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0xb5, 0x00 }, 2,   0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_86,  0, NULL },
{ "lgs",    2, { R16E,     M_ANY   }, GP3, ALLOW_SEG | (REX | REXR) | (F_MODRM | F_MODRM_REG),	              NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0xb5, 0x00 }, 2,   0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE,             (X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_64,  0, NULL },
{ "lgs",    2, { R32,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                        NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0xb5, 0x00 }, 4,   0, MOD_REG_MEM, 0, 0,	                ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_86,  0, NULL },
{ "lgs",    2, { R32E,     M_ANY   }, GP3, ALLOW_SEG | (REX | REXR) | (F_MODRM | F_MODRM_REG),	              NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0xb5, 0x00 }, 4,   0, MOD_REG_MEM, 0, 0,	                ADDR_SIZE_OVERRIDE,             (X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_64,  0, NULL },
{ "lgs",    2, { R64,      M_ANY   }, GP3, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_REG),				        NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0xb5, 0x00 }, 8,   0, MOD_REG_MEM, 0, 0,				          ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_64,  0, NULL },
{ "lgs",    2, { R64E,     M_ANY   }, GP3, ALLOW_SEG | (REX | REXW | REXR) | (F_MODRM | F_MODRM_REG),	        NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0xb5, 0x00 }, 8,   0, MOD_REG_MEM, 0, 0,				          ADDR_SIZE_OVERRIDE,             (X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_64,  0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//LSS r16,m16:16 RM Valid   Valid     0F B2 /r        
//LSS r32,m16:32 RM Valid   Valid     0F B2 /r        
//LSS r64,m16:64 RM Valid   N.E.      REX + 0F B2 /r  
/* ----------------------------------------------------------------------------------------------- */
{ "lss",    2, { R16,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),	                              NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0xb2, 0x00 }, 2,   0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_86,  0, NULL },
{ "lss",    2, { R16E,     M_ANY   }, GP3, ALLOW_SEG | (REX | REXR) | (F_MODRM | F_MODRM_REG),	              NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0xb2, 0x00 }, 2,   0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE,             (X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_64,  0, NULL },
{ "lss",    2, { R32,      M_ANY   }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                        NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0xb2, 0x00 }, 4,   0, MOD_REG_MEM, 0, 0,	                ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_86,  0, NULL },
{ "lss",    2, { R32E,     M_ANY   }, GP3, ALLOW_SEG | (REX | REXR) | (F_MODRM | F_MODRM_REG),	              NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0xb2, 0x00 }, 4,   0, MOD_REG_MEM, 0, 0,	                ADDR_SIZE_OVERRIDE,             (X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_64,  0, NULL },
{ "lss",    2, { R64,      M_ANY   }, GP3, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_REG),				        NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0xb2, 0x00 }, 8,  0, MOD_REG_MEM, 0, 0,				          ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_64,  0, NULL },
{ "lss",    2, { R64E,     M_ANY   }, GP3, ALLOW_SEG | (REX | REXW | REXR) | (F_MODRM | F_MODRM_REG),	        NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0xb2, 0x00 }, 8,  0, MOD_REG_MEM, 0, 0,				          ADDR_SIZE_OVERRIDE,             (X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_64,  0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//LGDT m16 & 32 M N.E.Valid    0F 01 / 2        Load m into GDTR.
//LIDT m16 & 32 M N.E.Valid    0F 01 / 3        Load m into IDTR.
//LGDT m16 & 64 M Valid N.E.   0F 01 / 2        Load m into GDTR.
//LIDT m16 & 64 M Valid N.E.   0F 01 / 3        Load m into IDTR.
/* ----------------------------------------------------------------------------------------------- */
{ "lgdt",    1, { M_ANY,          }, GP2, ALLOW_SEG | (F_MODRM | F_MODRM_RM | OPCODE_EXT),                         NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x01, 0x00 }, 2, 1, 0x14, 0, OP_SIZE_OVERRIDE, ADDR_SIZE_OVERRIDE, (X16 | X32), RM_DST, NO_PREFIX, NO_IMM, MEM_OPND_0, P_86, 0, NULL },
{ "lgdt",    1, { M_ANY,          }, GP2, ALLOW_SEG | (F_MODRM | F_MODRM_RM | OPCODE_EXT),                         NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x01, 0x00 }, 4, 1, 0x14, 0, 0, 0,                                 (X16 | X32), RM_DST, NO_PREFIX, NO_IMM, MEM_OPND_0, P_86, 0, NULL },
{ "lidt",    1, { M_ANY,          }, GP2, ALLOW_SEG | (F_MODRM | F_MODRM_RM | OPCODE_EXT),                         NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x01, 0x00 }, 2, 1, 0x1c, 0, OP_SIZE_OVERRIDE, ADDR_SIZE_OVERRIDE, (X16 | X32), RM_DST, NO_PREFIX, NO_IMM, MEM_OPND_0, P_86, 0, NULL },
{ "lidt",    1, { M_ANY,          }, GP2, ALLOW_SEG | (F_MODRM | F_MODRM_RM | OPCODE_EXT),                         NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x01, 0x00 }, 4, 1, 0x1c, 0, 0, 0,                                 (X16 | X32), RM_DST, NO_PREFIX, NO_IMM, MEM_OPND_0, P_86, 0, NULL },
{ "lgdt",    1, { M_ANY,          }, GP3, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_RM | OPCODE_EXT),          NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x01, 0x00 }, 8, 1, 0x14, 0, 0, 0,                                       (X64), RM_DST, NO_PREFIX, NO_IMM, MEM_OPND_0, P_64, 0, NULL },
{ "lidt",    1, { M_ANY,          }, GP3, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_RM | OPCODE_EXT),          NO_VEX, NO_EVEX, 1, 2, { 0x0f, 0x01, 0x00 }, 8, 1, 0x1c, 0, 0, 0,                                       (X64), RM_DST, NO_PREFIX, NO_IMM, MEM_OPND_0, P_64, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//MOVS m8, m8    A4
//MOVS m16, m16  A5
//MOVS m32, m32  A5
//MOVS m64, m64 REX.W + A5 
/* ----------------------------------------------------------------------------------------------- */
{ "movs", 2, { M8,    M8       }, GP0,  ALLOW_REP,													                                            NO_VEX, NO_EVEX,  1, 1, { 0xa4, 0x00, 0x00 }, 1,  2, NO_MOD,      0, 0, ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), NO_DST,  NO_PREFIX,  NO_IMM,     MEM_OPND_0,     P_386,           0, NULL },
{ "movs", 2, { M16,   M16      }, GP2,  ALLOW_REP,													                                            NO_VEX, NO_EVEX,  1, 1, { 0xa5, 0x00, 0x00 }, 2,  2, NO_MOD,      0, OP_SIZE_OVERRIDE,   0, (X16 | X32 | X64), NO_DST,  NO_PREFIX,  NO_IMM,     MEM_OPND_0,     P_386,           0, NULL },
{ "movs", 2, { M32,   M32      }, GP2,  ALLOW_REP,													                                            NO_VEX, NO_EVEX,  1, 1, { 0xa5, 0x00, 0x00 }, 4,  2, NO_MOD,      0, 0, ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), NO_DST,  NO_PREFIX,  NO_IMM,     MEM_OPND_0,     P_386,           0, NULL },
{ "movs", 2, { M64,   M64      }, GP3,  (REX | REXW) | ALLOW_REP,													                              NO_VEX, NO_EVEX,  1, 1, { 0xa5, 0x00, 0x00 }, 8,  2, NO_MOD,      0, 0,                  0,             (X64), NO_DST,  NO_PREFIX,  NO_IMM,     MEM_OPND_0,     P_64,            0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//MOVSB          A4   
/* ----------------------------------------------------------------------------------------------- */
{ "movsb", 0, { OP_N,     OP_N        }, GP1,  ALLOW_REP,													                                      NO_VEX, NO_EVEX,  1, 1, { 0xa4, 0x00, 0x00 }, 1,  0, NO_MOD,      0, 0, 0, (X16 | X32 | X64), NO_DST,  NO_PREFIX,  NO_IMM,     NO_MEM,     P_86,           0, NULL },
{ "movsb", 2, { M_ANY,    M_ANY       }, GP2,  ALLOW_REP,													                                      NO_VEX, NO_EVEX,  1, 1, { 0xa4, 0x00, 0x00 }, 1,  2, NO_MOD,      0, 0, ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), NO_DST,  NO_PREFIX,  NO_IMM,     MEM_OPND_0,     P_386,           0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//MOVSW          A5 
{ "movsw", 0, { OP_N,     OP_N        }, GP1,  ALLOW_REP,													                                      NO_VEX, NO_EVEX,  1, 1, { 0xa5, 0x00, 0x00 }, 2,  0, NO_MOD,      0, 0, 0, (X16 | X32 | X64), NO_DST,  NO_PREFIX,  NO_IMM,     NO_MEM,     P_86,           0, NULL },
{ "movsw", 2, { M_ANY,    M_ANY       }, GP2,  ALLOW_REP,													                                      NO_VEX, NO_EVEX,  1, 1, { 0xa5, 0x00, 0x00 }, 2,  2, NO_MOD,      0, OP_SIZE_OVERRIDE, 0, (X16 | X32 | X64), NO_DST,  NO_PREFIX,  NO_IMM,     MEM_OPND_0,     P_386,           0, NULL },
/* ----------------------------------------------------------------------------------------------- */
  //MOVSD xmm1, xmm2        F2 0F 10 / r
  //MOVSD xmm1, m64         F2 0F 10 / r
  //MOVSD xmm1 / m64, xmm2  F2 0F 11 / r
/* ----------------------------------------------------------------------------------------------- */
{ "movsd", 0, { OP_N,     OP_N        }, GP1,  ALLOW_REP,													                                      NO_VEX, NO_EVEX,  1, 1, { 0xa5, 0x00, 0x00 }, 1,  0, NO_MOD,      0, 0, 0, (X16 | X32 | X64), NO_DST,  NO_PREFIX,  NO_IMM,     NO_MEM,     P_86,           0, NULL },
{ "movsd", 2, { M_ANY,    M_ANY       }, GP2,  ALLOW_REP,													                                      NO_VEX, NO_EVEX,  1, 1, { 0xa5, 0x00, 0x00 }, 4,  2, NO_MOD,      0, 0, ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), NO_DST,  NO_PREFIX,  NO_IMM,     MEM_OPND_0,     P_386,           0, NULL },
{ "movsd", 2, { R_XMM,    R_XMM       }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),	                          NO_VEX, NO_EVEX,  1, 1, { 0x10, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF20F, NO_IMM,     NO_MEM,     P_686 | P_SSE2, 0, NULL },
{ "movsd", 2, { M_ANY,    R_XMM       }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),	                                      NO_VEX, NO_EVEX,  2, 1, { 0x11, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), RM_DST,  PFX_0xF20F, NO_IMM,     MEM_OPND_0, P_686 | P_SSE2, 0, NULL },
{ "movsd", 2, { R_XMM,    M_ANY       }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),	                                      NO_VEX, NO_EVEX,  2, 1, { 0x10, 0x00, 0x00 }, 16, 1, MOD_MEM_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF20F, NO_IMM,     MEM_OPND_1, P_686 | P_SSE2, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//MOVSQ REX.W +  A5 
/* ----------------------------------------------------------------------------------------------- */
{ "movsq", 0, { OP_N,     OP_N       }, GP3,  (REX | REXW) | ALLOW_REP,													                        NO_VEX, NO_EVEX,  1, 1, { 0xa5, 0x00, 0x00 }, 1,  0, NO_MOD,      0, 0, 0, (X64), NO_DST,  NO_PREFIX,  NO_IMM,     NO_MEM,         P_64,           0, NULL },
{ "movsq", 2, { M_ANY,    M_ANY      }, GP3,  (REX | REXW) | ALLOW_REP,													                        NO_VEX, NO_EVEX,  1, 1, { 0xa5, 0x00, 0x00 }, 8,  2, NO_MOD,      0, 0, 0, (X64), NO_DST,  NO_PREFIX,  NO_IMM,     MEM_OPND_0,     P_64,           0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//MOVSX   r16, r / m8   RM Valid Valid 0F BE / r            
//MOVSX   r32, r / m8   RM Valid Valid 0F BE / r         
//MOVSX   r64, r / m8   RM Valid N.E.  REX.W + 0F BE / r 
//MOVSX   r32, r / m16  RM Valid Valid 0F BF / r           REX  = 40
//MOVSX   r64, r / m16  RM Valid N.E.  REX.W + 0F BF / r   REXB =  1
//MOVSXD  r16, r / m16  RM Valid Valid 63 / r *            REXX =  2
//MOVSXD  r32, r / m32  RM Valid Valid 63 / r *            REXR =  4
//MOVSXD  r64, r / m32  RM Valid N.E.  REX.W + 63 / r      REXW =  8
/* ----------------------------------------------------------------------------------------------- */
{ "movsx",     2, { R16,      R8_AL   }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                        NO_VEX, NO_EVEX, 2, 1, { 0xbe, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                   (X16 | X32 | X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "movsx",     2, { R16,      R8_CL   }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                        NO_VEX, NO_EVEX, 2, 1, { 0xbe, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                   (X16 | X32 | X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "movsx",     2, { R16,      R8      }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                        NO_VEX, NO_EVEX, 2, 1, { 0xbe, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                   (X16 | X32 | X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "movsx",     2, { R16_AX,   R8      }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                        NO_VEX, NO_EVEX, 2, 1, { 0xbe, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                   (X16 | X32 | X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "movsx",     2, { R16_AX,   R8_CL   }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                        NO_VEX, NO_EVEX, 2, 1, { 0xbe, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                   (X16 | X32 | X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "movsx",     2, { R16_AX,   R8U     }, GP3, (REX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				                      NO_VEX, NO_EVEX, 2, 1, { 0xbe, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                               (X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "movsx",     2, { R16,      R8U     }, GP3, (REX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				                      NO_VEX, NO_EVEX, 2, 1, { 0xbe, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                               (X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "movsx",     2, { R16_AX,   R8E     }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				              NO_VEX, NO_EVEX, 2, 1, { 0xbe, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                               (X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "movsx",     2, { R16E,     R8      }, GP3, (REX | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),                      NO_VEX, NO_EVEX, 2, 1, { 0xbe, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                               (X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "movsx",     2, { R16E,     R8U     }, GP3, (REX | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),                      NO_VEX, NO_EVEX, 2, 1, { 0xbe, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                               (X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "movsx",     2, { R16E,     R8E     }, GP3, (REX | REXB | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),               NO_VEX, NO_EVEX, 2, 1, { 0xbe, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                               (X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "movsx",     2, { R32,      R8_AL   }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                        NO_VEX, NO_EVEX, 4, 1, { 0xbe, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                   (X16 | X32 | X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "movsx",     2, { R32,      R8_CL   }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                        NO_VEX, NO_EVEX, 4, 1, { 0xbe, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                   (X16 | X32 | X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "movsx",     2, { R32,      R8      }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                        NO_VEX, NO_EVEX, 4, 1, { 0xbe, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                   (X16 | X32 | X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "movsx",     2, { R32_EAX,  R8      }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                        NO_VEX, NO_EVEX, 4, 1, { 0xbe, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                   (X16 | X32 | X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "movsx",     2, { R32_EAX,  R8_CL   }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                        NO_VEX, NO_EVEX, 4, 1, { 0xbe, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                   (X16 | X32 | X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "movsx",     2, { R32_EAX,  R8U     }, GP3, (REX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				                      NO_VEX, NO_EVEX, 4, 1, { 0xbe, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                               (X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "movsx",     2, { R32,      R8U     }, GP3, (REX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				                      NO_VEX, NO_EVEX, 4, 1, { 0xbe, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                               (X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "movsx",     2, { R32_EAX,  R8E     }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				              NO_VEX, NO_EVEX, 4, 1, { 0xbe, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                               (X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "movsx",     2, { R32E,     R8      }, GP3, (REX | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),                      NO_VEX, NO_EVEX, 4, 1, { 0xbe, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                               (X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "movsx",     2, { R32E,     R8U     }, GP3, (REX | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),                      NO_VEX, NO_EVEX, 4, 1, { 0xbe, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                               (X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "movsx",     2, { R32E,     R8E     }, GP3, (REX | REXB | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),               NO_VEX, NO_EVEX, 4, 1, { 0xbe, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                               (X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "movsx",     2, { R64,      R8_AL   }, GP0, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),							        NO_VEX, NO_EVEX, 8, 1, { 0xbe, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                   (X16 | X32 | X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "movsx",     2, { R64,      R8_CL   }, GP0, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),							        NO_VEX, NO_EVEX, 8, 1, { 0xbe, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                   (X16 | X32 | X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "movsx",     2, { R64,      R8      }, GP0, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),							        NO_VEX, NO_EVEX, 8, 1, { 0xbe, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                   (X16 | X32 | X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "movsx",     2, { R64_RAX,  R8      }, GP0, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),							        NO_VEX, NO_EVEX, 8, 1, { 0xbe, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                   (X16 | X32 | X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "movsx",     2, { R64_RAX,  R8_CL   }, GP0, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),							        NO_VEX, NO_EVEX, 8, 1, { 0xbe, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                   (X16 | X32 | X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "movsx",     2, { R64_RAX,  R8U     }, GP3, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				              NO_VEX, NO_EVEX, 8, 1, { 0xbe, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                               (X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "movsx",     2, { R64,      R8U     }, GP3, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				              NO_VEX, NO_EVEX, 8, 1, { 0xbe, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                               (X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "movsx",     2, { R64_RAX,  R8E     }, GP3, (REX | REXW | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				        NO_VEX, NO_EVEX, 8, 1, { 0xbe, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                               (X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "movsx",     2, { R64E,     R8      }, GP3, (REX | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),                      NO_VEX, NO_EVEX, 8, 1, { 0xbe, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                               (X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "movsx",     2, { R64E,     R8U     }, GP3, (REX | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),                      NO_VEX, NO_EVEX, 8, 1, { 0xbe, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                               (X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "movsx",     2, { R64E,     R8E     }, GP3, (REX | REXB | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),               NO_VEX, NO_EVEX, 8, 1, { 0xbe, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                               (X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "movsx",     2, { R16,      M8      }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                              NO_VEX, NO_EVEX, 2, 1, { 0xbe, 0x00, 0x00 }, 2, 0, MOD_REG_MEM, 0, 0, 0,                   (X16 | X32 | X64), REG_DST,  PFX_0xF, NO_IMM,     MEM_OPND_1, P_86,  0, NULL },
{ "movsx",     2, { R16_AX,   M8      }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                              NO_VEX, NO_EVEX, 2, 1, { 0xbe, 0x00, 0x00 }, 2, 0, MOD_REG_MEM, 0, 0, 0,                   (X16 | X32 | X64), REG_DST,  PFX_0xF, NO_IMM,     MEM_OPND_1, P_86,  0, NULL },
{ "movsx",     2, { R16E,     M8      }, GP3, ALLOW_SEG | (REX | REXR) | (F_MODRM | F_MODRM_REG),	                      NO_VEX, NO_EVEX, 2, 1, { 0xbe, 0x00, 0x00 }, 2, 0, MOD_REG_MEM, 0, 0,	ADDR_SIZE_OVERRIDE,             (X64), REG_DST,  PFX_0xF, NO_IMM,     MEM_OPND_1, P_64,  0, NULL },
{ "movsx",     2, { R32,      M8      }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                              NO_VEX, NO_EVEX, 4, 1, { 0xbe, 0x00, 0x00 }, 4, 0, MOD_REG_MEM, 0, 0,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST,  PFX_0xF, NO_IMM,     MEM_OPND_1, P_86,  0, NULL },
{ "movsx",     2, { R32_EAX,  M8      }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                              NO_VEX, NO_EVEX, 4, 1, { 0xbe, 0x00, 0x00 }, 4, 0, MOD_REG_MEM, 0, 0,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST,  PFX_0xF, NO_IMM,     MEM_OPND_1, P_86,  0, NULL },
{ "movsx",     2, { R32E,     M8      }, GP3, ALLOW_SEG | (REX | REXR) | (F_MODRM | F_MODRM_REG),	                      NO_VEX, NO_EVEX, 4, 1, { 0xbe, 0x00, 0x00 }, 4, 0, MOD_REG_MEM, 0, 0,	ADDR_SIZE_OVERRIDE,             (X64), REG_DST,  PFX_0xF, NO_IMM,     MEM_OPND_1, P_64,  0, NULL },
{ "movsx",     2, { R64,      M8      }, GP3, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_REG),				                NO_VEX, NO_EVEX, 8, 1, { 0xbe, 0x00, 0x00 }, 8, 0, MOD_REG_MEM, 0, 0,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST,  PFX_0xF, NO_IMM,     MEM_OPND_1, P_64,  0, NULL },
{ "movsx",     2, { R64_RAX,  M8      }, GP3, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_REG),				                NO_VEX, NO_EVEX, 8, 1, { 0xbe, 0x00, 0x00 }, 8, 0, MOD_REG_MEM, 0, 0,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST,  PFX_0xF, NO_IMM,     MEM_OPND_1, P_64,  0, NULL },
{ "movsx",     2, { R64E,     M8      }, GP3, ALLOW_SEG | (REX | REXW | REXR) | (F_MODRM | F_MODRM_REG),	              NO_VEX, NO_EVEX, 8, 1, { 0xbe, 0x00, 0x00 }, 8, 0, MOD_REG_MEM, 0, 0,	ADDR_SIZE_OVERRIDE,             (X64), REG_DST,  PFX_0xF, NO_IMM,     MEM_OPND_1, P_64,  0, NULL },
/* ----------------------------------------------------------------------------------------------- */
{ "movsx",     2, { R32,      R16     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                        NO_VEX, NO_EVEX, 1, 1, { 0xbf, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, 0, 0,                   (X16 | X32 | X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "movsx",     2, { R32_EAX,  R16     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                        NO_VEX, NO_EVEX, 1, 1, { 0xbf, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, 0, 0,                   (X16 | X32 | X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "movsx",     2, { R32_EAX,  R16E    }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				              NO_VEX, NO_EVEX, 1, 1, { 0xbf, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, 0, 0,                               (X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "movsx",     2, { R32E,     R16     }, GP3, (REX | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),                      NO_VEX, NO_EVEX, 1, 1, { 0xbf, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, 0, 0,                               (X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "movsx",     2, { R32E,     R16E    }, GP3, (REX | REXB | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),               NO_VEX, NO_EVEX, 1, 1, { 0xbf, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, 0, 0,                               (X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "movsx",     2, { R64,      R16     }, GP0, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),							        NO_VEX, NO_EVEX, 4, 1, { 0xbf, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, 0, 0,                   (X16 | X32 | X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "movsx",     2, { R64_RAX,  R16     }, GP0, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),							        NO_VEX, NO_EVEX, 4, 1, { 0xbf, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, 0, 0,                   (X16 | X32 | X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "movsx",     2, { R64_RAX,  R16E    }, GP3, (REX | REXW | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				        NO_VEX, NO_EVEX, 4, 1, { 0xbf, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, 0, 0,                               (X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "movsx",     2, { R64E,     R16     }, GP3, (REX | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),                      NO_VEX, NO_EVEX, 4, 1, { 0xbf, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, 0, 0,                               (X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "movsx",     2, { R64E,     R16E    }, GP3, (REX | REXB | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),               NO_VEX, NO_EVEX, 4, 1, { 0xbf, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, 0, 0,                               (X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "movsx",     2, { R32,      M16     }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                              NO_VEX, NO_EVEX, 2, 1, { 0xbf, 0x00, 0x00 }, 4, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST,  PFX_0xF,   NO_IMM,     MEM_OPND_1, P_86,  0, NULL },
{ "movsx",     2, { R32_EAX,  M16     }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                              NO_VEX, NO_EVEX, 2, 1, { 0xbf, 0x00, 0x00 }, 4, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST,  PFX_0xF,   NO_IMM,     MEM_OPND_1, P_86,  0, NULL },
{ "movsx",     2, { R32E,     M16     }, GP3, ALLOW_SEG | (REX | REXR) | (F_MODRM | F_MODRM_REG),	                      NO_VEX, NO_EVEX, 2, 1, { 0xbf, 0x00, 0x00 }, 4, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE,             (X64), REG_DST,  PFX_0xF,   NO_IMM,     MEM_OPND_1, P_64,  0, NULL },
{ "movsx",     2, { R64,      M16     }, GP3, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_REG),				                NO_VEX, NO_EVEX, 4, 1, { 0xbf, 0x00, 0x00 }, 8, 0, MOD_REG_MEM, 0, 0,				          ADDR_SIZE_OVERRIDE,             (X64), REG_DST,  PFX_0xF,   NO_IMM,     MEM_OPND_1, P_64,  0, NULL },
{ "movsx",     2, { R64_RAX,  M16     }, GP3, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_REG),				                NO_VEX, NO_EVEX, 4, 1, { 0xbf, 0x00, 0x00 }, 8, 0, MOD_REG_MEM, 0, 0,				          ADDR_SIZE_OVERRIDE,             (X64), REG_DST,  PFX_0xF,   NO_IMM,     MEM_OPND_1, P_64,  0, NULL },
{ "movsx",     2, { R64E,     M16     }, GP3, ALLOW_SEG | (REX | REXW | REXR) | (F_MODRM | F_MODRM_REG),	              NO_VEX, NO_EVEX, 4, 1, { 0xbf, 0x00, 0x00 }, 8, 0, MOD_REG_MEM, 0, 0,				          ADDR_SIZE_OVERRIDE,             (X64), REG_DST,  PFX_0xF,   NO_IMM,     MEM_OPND_1, P_64,  0, NULL },
{ "movsxd",    2, { R64,      R32     }, GP0, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),							        NO_VEX, NO_EVEX, 4, 1, { 0x63, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, 0, 0,                                              (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "movsxd",    2, { R64_RAX,  R32     }, GP0, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),							        NO_VEX, NO_EVEX, 4, 1, { 0x63, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, 0, 0,                                              (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "movsxd",    2, { R64_RAX,  R32E    }, GP3, (REX | REXW | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				        NO_VEX, NO_EVEX, 4, 1, { 0x63, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, 0, 0,                                              (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "movsxd",    2, { R64E,     R32     }, GP3, (REX | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),                      NO_VEX, NO_EVEX, 4, 1, { 0x63, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, 0, 0,                                              (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "movsxd",    2, { R64E,     R32E    }, GP3, (REX | REXB | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),               NO_VEX, NO_EVEX, 4, 1, { 0x63, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, 0, 0,                                              (X64), REG_DST,  NO_PREFIX, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "movsxd",    2, { R64,      M_ANY   }, GP3, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_REG),				                NO_VEX, NO_EVEX, 2, 1, { 0x63, 0x00, 0x00 }, 8, 0, MOD_REG_MEM, 0, 0,				          ADDR_SIZE_OVERRIDE,             (X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_64,  0, NULL },
{ "movsxd",    2, { R64_RAX,  M_ANY   }, GP3, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_REG),				                NO_VEX, NO_EVEX, 2, 1, { 0x63, 0x00, 0x00 }, 8, 0, MOD_REG_MEM, 0, 0,				          ADDR_SIZE_OVERRIDE,             (X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_64,  0, NULL },
{ "movsxd",    2, { R64E,     M_ANY   }, GP3, ALLOW_SEG | (REX | REXW | REXR) | (F_MODRM | F_MODRM_REG),	              NO_VEX, NO_EVEX, 2, 1, { 0x63, 0x00, 0x00 }, 8, 0, MOD_REG_MEM, 0, 0,				          ADDR_SIZE_OVERRIDE,             (X64), REG_DST,  NO_PREFIX, NO_IMM,     MEM_OPND_1, P_64,  0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//MOVZX r16, r / m8   RM Valid Valid          0F B6 / r          
//MOVZX r32, r / m8   RM Valid Valid          0F B6 / r
//MOVZX r64, r / m8 * RM Valid N.E.   REX.W + 0F B6 / r
//MOVZX r32, r / m16  RM Valid Valid          0F B7 / r
//MOVZX r64, r / m16  RM Valid N.E.   REX.W + 0F B7 / r
/* ----------------------------------------------------------------------------------------------- */
{ "movzx",     2, { R16,      R8_AL   }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                        NO_VEX, NO_EVEX, 2, 1, { 0xb6, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                   (X16 | X32 | X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "movzx",     2, { R16,      R8_CL   }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                        NO_VEX, NO_EVEX, 2, 1, { 0xb6, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                   (X16 | X32 | X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "movzx",     2, { R16,      R8      }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                        NO_VEX, NO_EVEX, 2, 1, { 0xb6, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                   (X16 | X32 | X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "movzx",     2, { R16_AX,   R8      }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                        NO_VEX, NO_EVEX, 2, 1, { 0xb6, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                   (X16 | X32 | X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "movzx",     2, { R16_AX,   R8_CL   }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                        NO_VEX, NO_EVEX, 2, 1, { 0xb6, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                   (X16 | X32 | X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "movzx",     2, { R16_AX,   R8U     }, GP3, (REX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				                      NO_VEX, NO_EVEX, 2, 1, { 0xb6, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                               (X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "movzx",     2, { R16_AX,   R8E     }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				              NO_VEX, NO_EVEX, 2, 1, { 0xb6, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                               (X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "movzx",     2, { R16E,     R8      }, GP3, (REX | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),                      NO_VEX, NO_EVEX, 2, 1, { 0xb6, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                               (X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "movzx",     2, { R16E,     R8U     }, GP3, (REX | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),                      NO_VEX, NO_EVEX, 2, 1, { 0xb6, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                               (X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "movzx",     2, { R16E,     R8E     }, GP3, (REX | REXB | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),               NO_VEX, NO_EVEX, 2, 1, { 0xb6, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                               (X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "movzx",     2, { R32,      R8_AL   }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                        NO_VEX, NO_EVEX, 4, 1, { 0xb6, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                   (X16 | X32 | X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "movzx",     2, { R32,      R8_CL   }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                        NO_VEX, NO_EVEX, 4, 1, { 0xb6, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                   (X16 | X32 | X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "movzx",     2, { R32,      R8      }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                        NO_VEX, NO_EVEX, 4, 1, { 0xb6, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                   (X16 | X32 | X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "movzx",     2, { R32_EAX,  R8      }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                        NO_VEX, NO_EVEX, 4, 1, { 0xb6, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                   (X16 | X32 | X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "movzx",     2, { R32_EAX,  R8_CL   }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                        NO_VEX, NO_EVEX, 4, 1, { 0xb6, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                   (X16 | X32 | X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "movzx",     2, { R32_EAX,  R8U     }, GP3, (REX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				                      NO_VEX, NO_EVEX, 4, 1, { 0xb6, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                               (X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "movzx",     2, { R32_EAX,  R8E     }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				              NO_VEX, NO_EVEX, 4, 1, { 0xb6, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                               (X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "movzx",     2, { R32E,     R8      }, GP3, (REX | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),                      NO_VEX, NO_EVEX, 4, 1, { 0xb6, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                               (X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "movzx",     2, { R32E,     R8U     }, GP3, (REX | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),                      NO_VEX, NO_EVEX, 4, 1, { 0xb6, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                               (X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "movzx",     2, { R32E,     R8E     }, GP3, (REX | REXB | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),               NO_VEX, NO_EVEX, 4, 1, { 0xb6, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                               (X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "movzx",     2, { R64,      R8_AL   }, GP0, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),							        NO_VEX, NO_EVEX, 8, 1, { 0xb6, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                   (X16 | X32 | X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "movzx",     2, { R64,      R8_CL   }, GP0, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),							        NO_VEX, NO_EVEX, 8, 1, { 0xb6, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                   (X16 | X32 | X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "movzx",     2, { R64,      R8      }, GP0, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),							        NO_VEX, NO_EVEX, 8, 1, { 0xb6, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                   (X16 | X32 | X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "movzx",     2, { R64_RAX,  R8      }, GP0, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),							        NO_VEX, NO_EVEX, 8, 1, { 0xb6, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                   (X16 | X32 | X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "movzx",     2, { R64_RAX,  R8_CL   }, GP0, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),							        NO_VEX, NO_EVEX, 8, 1, { 0xb6, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                   (X16 | X32 | X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "movzx",     2, { R64_RAX,  R8U     }, GP3, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				              NO_VEX, NO_EVEX, 8, 1, { 0xb6, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                               (X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "movzx",     2, { R64_RAX,  R8E     }, GP3, (REX | REXW | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				        NO_VEX, NO_EVEX, 8, 1, { 0xb6, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                               (X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "movzx",     2, { R64E,     R8      }, GP3, (REX | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),                      NO_VEX, NO_EVEX, 8, 1, { 0xb6, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                               (X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "movzx",     2, { R64E,     R8U     }, GP3, (REX | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),                      NO_VEX, NO_EVEX, 8, 1, { 0xb6, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                               (X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "movzx",     2, { R64E,     R8E     }, GP3, (REX | REXB | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),               NO_VEX, NO_EVEX, 8, 1, { 0xb6, 0x00, 0x00 }, 1, 0, MOD_REG_REG, 0, OP_SIZE_OVERRIDE, 0,                               (X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "movzx",     2, { R16,      M8      }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                              NO_VEX, NO_EVEX, 2, 1, { 0xb6, 0x00, 0x00 }, 2, 0, MOD_REG_MEM, 0, 0, 0,                   (X16 | X32 | X64), REG_DST,  PFX_0xF, NO_IMM,     MEM_OPND_1, P_86,  0, NULL },
{ "movzx",     2, { R16_AX,   M8      }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                              NO_VEX, NO_EVEX, 2, 1, { 0xb6, 0x00, 0x00 }, 2, 0, MOD_REG_MEM, 0, 0, 0,                   (X16 | X32 | X64), REG_DST,  PFX_0xF, NO_IMM,     MEM_OPND_1, P_86,  0, NULL },
{ "movzx",     2, { R16E,     M8      }, GP3, ALLOW_SEG | (REX | REXR) | (F_MODRM | F_MODRM_REG),	                      NO_VEX, NO_EVEX, 2, 1, { 0xb6, 0x00, 0x00 }, 2, 0, MOD_REG_MEM, 0, 0,	ADDR_SIZE_OVERRIDE,             (X64), REG_DST,  PFX_0xF, NO_IMM,     MEM_OPND_1, P_64,  0, NULL },
{ "movzx",     2, { R32,      M8      }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                              NO_VEX, NO_EVEX, 4, 1, { 0xb6, 0x00, 0x00 }, 4, 0, MOD_REG_MEM, 0, 0,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST,  PFX_0xF, NO_IMM,     MEM_OPND_1, P_86,  0, NULL },
{ "movzx",     2, { R32_EAX,  M8      }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                              NO_VEX, NO_EVEX, 4, 1, { 0xb6, 0x00, 0x00 }, 4, 0, MOD_REG_MEM, 0, 0,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST,  PFX_0xF, NO_IMM,     MEM_OPND_1, P_86,  0, NULL },
{ "movzx",     2, { R32E,     M8      }, GP3, ALLOW_SEG | (REX | REXR) | (F_MODRM | F_MODRM_REG),	                      NO_VEX, NO_EVEX, 4, 1, { 0xb6, 0x00, 0x00 }, 4, 0, MOD_REG_MEM, 0, 0,	ADDR_SIZE_OVERRIDE,             (X64), REG_DST,  PFX_0xF, NO_IMM,     MEM_OPND_1, P_64,  0, NULL },
{ "movzx",     2, { R64,      M8      }, GP3, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_REG),				                NO_VEX, NO_EVEX, 8, 1, { 0xb6, 0x00, 0x00 }, 8, 0, MOD_REG_MEM, 0, 0,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST,  PFX_0xF, NO_IMM,     MEM_OPND_1, P_64,  0, NULL },
{ "movzx",     2, { R64_RAX,  M8      }, GP3, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_REG),				                NO_VEX, NO_EVEX, 8, 1, { 0xb6, 0x00, 0x00 }, 8, 0, MOD_REG_MEM, 0, 0,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST,  PFX_0xF, NO_IMM,     MEM_OPND_1, P_64,  0, NULL },
{ "movzx",     2, { R64E,     M8      }, GP3, ALLOW_SEG | (REX | REXW | REXR) | (F_MODRM | F_MODRM_REG),	              NO_VEX, NO_EVEX, 8, 1, { 0xb6, 0x00, 0x00 }, 8, 0, MOD_REG_MEM, 0, 0,	ADDR_SIZE_OVERRIDE,             (X64), REG_DST,  PFX_0xF, NO_IMM,     MEM_OPND_1, P_64,  0, NULL },
/* ----------------------------------------------------------------------------------------------- */
{ "movzx",     2, { R32,      R16     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                        NO_VEX, NO_EVEX, 1, 1, { 0xb7, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, 0, 0,                   (X16 | X32 | X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "movzx",     2, { R32_EAX,  R16     }, GP0, (F_MODRM | F_MODRM_REG | F_MODRM_RM),							                        NO_VEX, NO_EVEX, 1, 1, { 0xb7, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, 0, 0,                   (X16 | X32 | X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "movzx",     2, { R32_EAX,  R16E    }, GP3, (REX | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				              NO_VEX, NO_EVEX, 1, 1, { 0xb7, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, 0, 0,                               (X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "movzx",     2, { R32E,     R16     }, GP3, (REX | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),                      NO_VEX, NO_EVEX, 1, 1, { 0xb7, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, 0, 0,                               (X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "movzx",     2, { R32E,     R16E    }, GP3, (REX | REXB | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),               NO_VEX, NO_EVEX, 1, 1, { 0xb7, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, 0, 0,                               (X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "movzx",     2, { R64,      R16     }, GP0, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),							        NO_VEX, NO_EVEX, 4, 1, { 0xb7, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, 0, 0,                   (X16 | X32 | X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "movzx",     2, { R64_RAX,  R16     }, GP0, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),							        NO_VEX, NO_EVEX, 4, 1, { 0xb7, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, 0, 0,                   (X16 | X32 | X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_86,  0, NULL },
{ "movzx",     2, { R64_RAX,  R16E    }, GP3, (REX | REXW | REXB) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),				        NO_VEX, NO_EVEX, 4, 1, { 0xb7, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, 0, 0,                               (X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "movzx",     2, { R64E,     R16     }, GP3, (REX | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),                      NO_VEX, NO_EVEX, 4, 1, { 0xb7, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, 0, 0,                               (X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "movzx",     2, { R64E,     R16E    }, GP3, (REX | REXB | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),               NO_VEX, NO_EVEX, 4, 1, { 0xb7, 0x00, 0x00 }, 2, 0, MOD_REG_REG, 0, 0, 0,                               (X64), REG_DST,  PFX_0xF, NO_IMM,     NO_MEM,     P_64,  0, NULL },
{ "movzx",     2, { R32,      M16     }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                              NO_VEX, NO_EVEX, 2, 1, { 0xb7, 0x00, 0x00 }, 4, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST,  PFX_0xF,   NO_IMM,     MEM_OPND_1, P_86,  0, NULL },
{ "movzx",     2, { R32_EAX,  M16     }, GP0, ALLOW_SEG | (F_MODRM | F_MODRM_REG),				                              NO_VEX, NO_EVEX, 2, 1, { 0xb7, 0x00, 0x00 }, 4, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE, (X16 | X32 | X64), REG_DST,  PFX_0xF,   NO_IMM,     MEM_OPND_1, P_86,  0, NULL },
{ "movzx",     2, { R32E,     M16     }, GP3, ALLOW_SEG | (REX | REXR) | (F_MODRM | F_MODRM_REG),	                      NO_VEX, NO_EVEX, 2, 1, { 0xb7, 0x00, 0x00 }, 4, 0, MOD_REG_MEM, 0, OP_SIZE_OVERRIDE,	ADDR_SIZE_OVERRIDE,             (X64), REG_DST,  PFX_0xF,   NO_IMM,     MEM_OPND_1, P_64,  0, NULL },
{ "movzx",     2, { R64,      M16     }, GP3, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_REG),				                NO_VEX, NO_EVEX, 4, 1, { 0xb7, 0x00, 0x00 }, 8, 0, MOD_REG_MEM, 0, 0,				          ADDR_SIZE_OVERRIDE,             (X64), REG_DST,  PFX_0xF,   NO_IMM,     MEM_OPND_1, P_64,  0, NULL },
{ "movzx",     2, { R64_RAX,  M16     }, GP3, ALLOW_SEG | (REX | REXW) | (F_MODRM | F_MODRM_REG),				                NO_VEX, NO_EVEX, 4, 1, { 0xb7, 0x00, 0x00 }, 8, 0, MOD_REG_MEM, 0, 0,				          ADDR_SIZE_OVERRIDE,             (X64), REG_DST,  PFX_0xF,   NO_IMM,     MEM_OPND_1, P_64,  0, NULL },
{ "movzx",     2, { R64E,     M16     }, GP3, ALLOW_SEG | (REX | REXW | REXR) | (F_MODRM | F_MODRM_REG),	              NO_VEX, NO_EVEX, 4, 1, { 0xb7, 0x00, 0x00 }, 8, 0, MOD_REG_MEM, 0, 0,				          ADDR_SIZE_OVERRIDE,             (X64), REG_DST,  PFX_0xF,   NO_IMM,     MEM_OPND_1, P_64,  0, NULL },
/* ----------------------------------------------------------------------------------------------- */

//MOVSS xmm1, xmm2  F3 0F 10 / r
//MOVSS xmm1,  m32  F3 0F 10 / r
/* ----------------------------------------------------------------------------------------------- */
{ "movss", 2, { R_XMM,    R_XMM       }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),	                          NO_VEX, NO_EVEX,  1, 1, { 0x10, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF30F, NO_IMM,     NO_MEM,     P_686 | P_SSE2, 0, NULL },
{ "movss", 2, { R_XMM,    M_ANY       }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),	                                      NO_VEX, NO_EVEX,  4, 1, { 0x10, 0x00, 0x00 }, 16, 1, MOD_MEM_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF30F, NO_IMM,     MEM_OPND_1, P_686 | P_SSE2, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//PACKSSWB mm1, mm2 / m64        	   NP 0F 63 / r1              A V / V MMX
//PACKSSWB xmm1, xmm2 / m128     	   66 0F 63 / r               A V / V SSE2
/* ----------------------------------------------------------------------------------------------- */
{ "packsswb",     2, { MMX64,   MMX64        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),	                  NO_VEX, NO_EVEX, 1, 1, { 0x63, 0x00, 0x00 }, 8,  1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     NO_MEM,       P_586 | P_MMX,  0, NULL },
{ "packsswb",     2, { MMX64,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),		                              NO_VEX, NO_EVEX, 1, 1, { 0x63, 0x00, 0x00 }, 8,  1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     MEM_OPND_1,   P_586 | P_MMX,  0, NULL },
{ "packsswb",     2, { R_XMM,   R_XMM        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),                    NO_VEX, NO_EVEX, 1, 1, { 0x63, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  NO_IMM,     NO_MEM,       P_686 | P_SSE2, 0, NULL },
{ "packsswb",     2, { R_XMM,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),						                      NO_VEX, NO_EVEX, 1, 1, { 0x63, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  NO_IMM,     MEM_OPND_1,   P_686 | P_SSE2, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//PACKSSDW mm1, mm2 / m64        	   NP 0F 6B / r1              A V / V MMX
//PACKSSDW xmm1, xmm2 / m128     	   66 0F 6B / r               A V / V SSE2
/* ----------------------------------------------------------------------------------------------- */
{ "packssdw",     2, { MMX64,   MMX64        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),	                  NO_VEX, NO_EVEX, 1, 1, { 0x6b, 0x00, 0x00 }, 8,  1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     NO_MEM,       P_586 | P_MMX,  0, NULL },
{ "packssdw",     2, { MMX64,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),		                              NO_VEX, NO_EVEX, 1, 1, { 0x6b, 0x00, 0x00 }, 8,  1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     MEM_OPND_1,   P_586 | P_MMX,  0, NULL },
{ "packssdw",     2, { R_XMM,   R_XMM        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),                    NO_VEX, NO_EVEX, 1, 1, { 0x6b, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  NO_IMM,     NO_MEM,       P_686 | P_SSE2, 0, NULL },
{ "packssdw",     2, { R_XMM,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),						                      NO_VEX, NO_EVEX, 1, 1, { 0x6b, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  NO_IMM,     MEM_OPND_1,   P_686 | P_SSE2, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//PACKUSWB mm, mm / m64                     NP 0F 67 / r1               A V / V MMX
//PACKUSWB xmm1, xmm2 / m128                66 0F 67 / r                A V / V SSE2
{ "packuswb",     2, { MMX64,   MMX64        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),	                  NO_VEX, NO_EVEX, 1, 1, { 0x67, 0x00, 0x00 }, 8,  1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     NO_MEM,       P_586 | P_MMX,  0, NULL },
{ "packuswb",     2, { MMX64,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),		                              NO_VEX, NO_EVEX, 1, 1, { 0x67, 0x00, 0x00 }, 8,  1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     MEM_OPND_1,   P_586 | P_MMX,  0, NULL },
{ "packuswb",     2, { R_XMM,   R_XMM        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),                    NO_VEX, NO_EVEX, 1, 1, { 0x67, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  NO_IMM,     NO_MEM,       P_686 | P_SSE2, 0, NULL },
{ "packuswb",     2, { R_XMM,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),						                      NO_VEX, NO_EVEX, 1, 1, { 0x67, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  NO_IMM,     MEM_OPND_1,   P_686 | P_SSE2, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//PADDB mm, mm / m64     NP 0F FC / r1  A V / V MMX   Add packed byte integers from mm / m64 and mm.
//PADDW mm, mm / m64     NP 0F FD / r1  A V / V MMX   Add packed word integers from mm / m64 and mm.
//PADDD mm, mm / m64     NP 0F FE / r1  A V / V MMX   Add packed doubleword integers from mm / m64 and mm.
//PADDQ mm, mm / m64     NP 0F D4 / r1  A V / V MMX   Add packed quadword integers from mm / m64 and mm.
/* ----------------------------------------------------------------------------------------------- */
{ "paddb",     2, { MMX64,   MMX64        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),	                      NO_VEX, NO_EVEX, 1, 1, { 0xfc, 0x00, 0x00 }, 8,  1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     NO_MEM,       P_586 | P_MMX,  0, NULL },
{ "paddb",     2, { MMX64,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),		                                NO_VEX, NO_EVEX, 1, 1, { 0xfc, 0x00, 0x00 }, 8,  1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     MEM_OPND_1,   P_586 | P_MMX,  0, NULL },
{ "paddw",     2, { MMX64,   MMX64        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),	                      NO_VEX, NO_EVEX, 1, 1, { 0xfd, 0x00, 0x00 }, 8,  1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     NO_MEM,       P_586 | P_MMX,  0, NULL },
{ "paddw",     2, { MMX64,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),		                                NO_VEX, NO_EVEX, 1, 1, { 0xfd, 0x00, 0x00 }, 8,  1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     MEM_OPND_1,   P_586 | P_MMX,  0, NULL },
{ "paddd",     2, { MMX64,   MMX64        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),	                      NO_VEX, NO_EVEX, 1, 1, { 0xff, 0x00, 0x00 }, 8,  1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     NO_MEM,       P_586 | P_MMX,  0, NULL },
{ "paddd",     2, { MMX64,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),		                                NO_VEX, NO_EVEX, 1, 1, { 0xff, 0x00, 0x00 }, 8,  1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     MEM_OPND_1,   P_586 | P_MMX,  0, NULL },
{ "paddq",     2, { MMX64,   MMX64        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),	                      NO_VEX, NO_EVEX, 1, 1, { 0xd4, 0x00, 0x00 }, 8,  1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     NO_MEM,       P_586 | P_MMX,  0, NULL },
{ "paddq",     2, { MMX64,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),		                                NO_VEX, NO_EVEX, 1, 1, { 0xd4, 0x00, 0x00 }, 8,  1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     MEM_OPND_1,   P_586 | P_MMX,  0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//PADDB xmm1, xmm2 / m128  66 0F FC / r  A V / V SSE2  Add packed byte integers from xmm2 / m128 and xmm1.
//PADDW xmm1, xmm2 / m128  66 0F FD / r  A V / V SSE2  Add packed word integers from xmm2 / m128 and xmm1.
//PADDD xmm1, xmm2 / m128  66 0F FE / r  A V / V SSE2  Add packed doubleword integers from xmm2 / m128 and xmm1.
//PADDQ xmm1, xmm2 / m128  66 0F D4 / r  A V / V SSE2  Add packed quadword integers from xmm2 / m128 and xmm1.
/* ----------------------------------------------------------------------------------------------- */
{ "paddb",     2, { R_XMM,   R_XMM        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),                       NO_VEX, NO_EVEX, 1, 1, { 0xfc, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  NO_IMM,     NO_MEM,       P_686 | P_SSE2, 0, NULL },
{ "paddb",     2, { R_XMM,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),						                        NO_VEX, NO_EVEX, 1, 1, { 0xfc, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  NO_IMM,     MEM_OPND_1,   P_686 | P_SSE2, 0, NULL },
{ "paddw",     2, { R_XMM,   R_XMM        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),                       NO_VEX, NO_EVEX, 1, 1, { 0xfd, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  NO_IMM,     NO_MEM,       P_686 | P_SSE2, 0, NULL },
{ "paddw",     2, { R_XMM,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),						                        NO_VEX, NO_EVEX, 1, 1, { 0xfd, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  NO_IMM,     MEM_OPND_1,   P_686 | P_SSE2, 0, NULL },
{ "paddd",     2, { R_XMM,   R_XMM        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),                       NO_VEX, NO_EVEX, 1, 1, { 0xff, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  NO_IMM,     NO_MEM,       P_686 | P_SSE2, 0, NULL },
{ "paddd",     2, { R_XMM,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),						                        NO_VEX, NO_EVEX, 1, 1, { 0xff, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  NO_IMM,     MEM_OPND_1,   P_686 | P_SSE2, 0, NULL },
{ "paddq",     2, { R_XMM,   R_XMM        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),                       NO_VEX, NO_EVEX, 1, 1, { 0xd4, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  NO_IMM,     NO_MEM,       P_686 | P_SSE2, 0, NULL },
{ "paddq",     2, { R_XMM,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),						                        NO_VEX, NO_EVEX, 1, 1, { 0xd4, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  NO_IMM,     MEM_OPND_1,   P_686 | P_SSE2, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//PADDSB mm, mm/m64                        NP 0F EC /r1                A V/V MMX              
//PADDSW mm, mm/m64                        NP 0F ED /r1                A V/V MMX              
{ "paddsb",     2, { MMX64,   MMX64        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),	                      NO_VEX, NO_EVEX, 1, 1, { 0xec, 0x00, 0x00 }, 8,  1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     NO_MEM,       P_586 | P_MMX,  0, NULL },
{ "paddsb",     2, { MMX64,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),		                                NO_VEX, NO_EVEX, 1, 1, { 0xec, 0x00, 0x00 }, 8,  1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     MEM_OPND_1,   P_586 | P_MMX,  0, NULL },
{ "paddsw",     2, { MMX64,   MMX64        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),	                      NO_VEX, NO_EVEX, 1, 1, { 0xed, 0x00, 0x00 }, 8,  1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     NO_MEM,       P_586 | P_MMX,  0, NULL },
{ "paddsw",     2, { MMX64,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),		                                NO_VEX, NO_EVEX, 1, 1, { 0xed, 0x00, 0x00 }, 8,  1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     MEM_OPND_1,   P_586 | P_MMX,  0, NULL },
//PADDSB xmm1, xmm2/m128                   66 0F EC /r                 A V/V SSE2             
//PADDSW xmm1, xmm2/m128                   66 0F ED /r                 A V/V SSE2             
{ "paddsb",     2, { R_XMM,   R_XMM        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),                       NO_VEX, NO_EVEX, 1, 1, { 0xec, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  NO_IMM,     NO_MEM,       P_686 | P_SSE2, 0, NULL },
{ "paddsb",     2, { R_XMM,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),						                         NO_VEX, NO_EVEX, 1, 1, { 0xec, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  NO_IMM,     MEM_OPND_1,   P_686 | P_SSE2, 0, NULL },
{ "paddsw",     2, { R_XMM,   R_XMM        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),                       NO_VEX, NO_EVEX, 1, 1, { 0xed, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  NO_IMM,     NO_MEM,       P_686 | P_SSE2, 0, NULL },
{ "paddsw",     2, { R_XMM,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),						                         NO_VEX, NO_EVEX, 1, 1, { 0xed, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  NO_IMM,     MEM_OPND_1,   P_686 | P_SSE2, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//PADDUSB mm, mm / m64      NP 0F DC / r1  A V / V MMX
//PADDUSW mm, mm / m64      NP 0F DD / r1  A V / V MMX
{ "paddusb",     2, { MMX64,   MMX64        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),	                      NO_VEX, NO_EVEX, 1, 1, { 0xdc, 0x00, 0x00 }, 8,  1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     NO_MEM,       P_586 | P_MMX,  0, NULL },
{ "paddusb",     2, { MMX64,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),		                                NO_VEX, NO_EVEX, 1, 1, { 0xdc, 0x00, 0x00 }, 8,  1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     MEM_OPND_1,   P_586 | P_MMX,  0, NULL },
{ "paddusw",     2, { MMX64,   MMX64        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),	                      NO_VEX, NO_EVEX, 1, 1, { 0xdd, 0x00, 0x00 }, 8,  1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     NO_MEM,       P_586 | P_MMX,  0, NULL },
{ "paddusw",     2, { MMX64,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),		                                NO_VEX, NO_EVEX, 1, 1, { 0xdd, 0x00, 0x00 }, 8,  1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     MEM_OPND_1,   P_586 | P_MMX,  0, NULL },
//PADDUSB xmm1, xmm2 / m128 66 0F DC / r   A V / V SSE2
//PADDUSW xmm1, xmm2 / m128 66 0F DD / r   A V / V SSE2
{ "paddusb",     2, { R_XMM,   R_XMM        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),                       NO_VEX, NO_EVEX, 1, 1, { 0xdc, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  NO_IMM,     NO_MEM,       P_686 | P_SSE2, 0, NULL },
{ "paddusb",     2, { R_XMM,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),						                        NO_VEX, NO_EVEX, 1, 1, { 0xdc, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  NO_IMM,     MEM_OPND_1,   P_686 | P_SSE2, 0, NULL },
{ "paddusw",     2, { R_XMM,   R_XMM        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),                       NO_VEX, NO_EVEX, 1, 1, { 0xdd, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  NO_IMM,     NO_MEM,       P_686 | P_SSE2, 0, NULL },
{ "paddusw",     2, { R_XMM,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),						                        NO_VEX, NO_EVEX, 1, 1, { 0xdd, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  NO_IMM,     MEM_OPND_1,   P_686 | P_SSE2, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//PAND mm, mm/m64        NP 0F DB /r1  A V/V MMX             
/* ----------------------------------------------------------------------------------------------- */
{ "pand",     2, { MMX64,   MMX64        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),	                      NO_VEX, NO_EVEX, 1, 1, { 0xdb, 0x00, 0x00 }, 8,  1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     NO_MEM,       P_586 | P_MMX,  0, NULL },
{ "pand",     2, { MMX64,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),		                                  NO_VEX, NO_EVEX, 1, 1, { 0xdb, 0x00, 0x00 }, 8,  1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     MEM_OPND_1,   P_586 | P_MMX,  0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//PAND xmm1, xmm2/m128   66 0F DB /r   A V/V SSE2            
/* ----------------------------------------------------------------------------------------------- */
{ "pand",     2, { R_XMM,   R_XMM        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),                        NO_VEX, NO_EVEX, 1, 1, { 0xdb, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  NO_IMM,     NO_MEM,       P_686 | P_SSE2, 0, NULL },
{ "pand",     2, { R_XMM,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),						                          NO_VEX, NO_EVEX, 1, 1, { 0xdb, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  NO_IMM,     MEM_OPND_1,   P_686 | P_SSE2, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//PANDN mm, mm / m64 NP 0F DF / r1     A V / V MMX            
/* ----------------------------------------------------------------------------------------------- */
{ "pandn",     2, { MMX64,   MMX64        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),	                      NO_VEX, NO_EVEX, 1, 1, { 0xdf, 0x00, 0x00 }, 8,  1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     NO_MEM,       P_586 | P_MMX,  0, NULL },
{ "pandn",     2, { MMX64,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),		                                NO_VEX, NO_EVEX, 1, 1, { 0xdf, 0x00, 0x00 }, 8,  1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     MEM_OPND_1,   P_586 | P_MMX,  0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//PANDN xmm1, xmm2 / m128 66 0F DF / r A V / V SSE2       
/* ----------------------------------------------------------------------------------------------- */
{ "pandn",     2, { R_XMM,   R_XMM        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),                       NO_VEX, NO_EVEX, 1, 1, { 0xdf, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  NO_IMM,     NO_MEM,       P_686 | P_SSE2, 0, NULL },
{ "pandn",     2, { R_XMM,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),						                        NO_VEX, NO_EVEX, 1, 1, { 0xdf, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  NO_IMM,     MEM_OPND_1,   P_686 | P_SSE2, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//PAVGB mm1, mm2/m64                        NP 0F E0 /r1                 A V/V SSE              
//PAVGB xmm1, xmm2/m128                     66 0F E0, /r                 A V/V SSE2             
/* ----------------------------------------------------------------------------------------------- */
{ "pavgb",     2, { MMX64,   MMX64        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),	                      NO_VEX, NO_EVEX, 1, 1, { 0xe0, 0x00, 0x00 }, 8,  1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     NO_MEM,       P_586 | P_MMX,  0, NULL },
{ "pavgb",     2, { MMX64,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),		                                NO_VEX, NO_EVEX, 1, 1, { 0xe0, 0x00, 0x00 }, 8,  1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     MEM_OPND_1,   P_586 | P_MMX,  0, NULL },
{ "pavgb",     2, { R_XMM,   R_XMM        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),                       NO_VEX, NO_EVEX, 1, 1, { 0xe0, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  NO_IMM,     NO_MEM,       P_686 | P_SSE2, 0, NULL },
{ "pavgb",     2, { R_XMM,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),						                        NO_VEX, NO_EVEX, 1, 1, { 0xe0, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  NO_IMM,     MEM_OPND_1,   P_686 | P_SSE2, 0, NULL },
//PAVGW mm1, mm2/m64                        NP 0F E3 /r1                 A V/V SSE              
//PAVGW xmm1, xmm2/m128                     66 0F E3 /r                  A V/V SSE2             
/* ----------------------------------------------------------------------------------------------- */
{ "pavgw",     2, { MMX64,   MMX64        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),	                      NO_VEX, NO_EVEX, 1, 1, { 0xe3, 0x00, 0x00 }, 8,  1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     NO_MEM,       P_586 | P_MMX,  0, NULL },
{ "pavgw",     2, { MMX64,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),		                                NO_VEX, NO_EVEX, 1, 1, { 0xe3, 0x00, 0x00 }, 8,  1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     MEM_OPND_1,   P_586 | P_MMX,  0, NULL },
{ "pavgw",     2, { R_XMM,   R_XMM        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),                       NO_VEX, NO_EVEX, 1, 1, { 0xe3, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  NO_IMM,     NO_MEM,       P_686 | P_SSE2, 0, NULL },
{ "pavgw",     2, { R_XMM,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),						                        NO_VEX, NO_EVEX, 1, 1, { 0xe3, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  NO_IMM,     MEM_OPND_1,   P_686 | P_SSE2, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//PCMPEQB mm, mm/m64               NP 0F 74 /r1      A V/V MMX        
//PCMPEQB xmm1, xmm2/m128          66 0F 74 /r       A V/V SSE2       
/* ----------------------------------------------------------------------------------------------- */
{ "pcmpeqb",     2, { MMX64,   MMX64        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),	                      NO_VEX, NO_EVEX, 1, 1, { 0x74, 0x00, 0x00 }, 8,  1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     NO_MEM,       P_586 | P_MMX,  0, NULL },
{ "pcmpeqb",     2, { MMX64,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),		                                NO_VEX, NO_EVEX, 1, 1, { 0x74, 0x00, 0x00 }, 8,  1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     MEM_OPND_1,   P_586 | P_MMX,  0, NULL },
{ "pcmpeqb",     2, { R_XMM,   R_XMM        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),                       NO_VEX, NO_EVEX, 1, 1, { 0x74, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  NO_IMM,     NO_MEM,       P_686 | P_SSE2, 0, NULL },
{ "pcmpeqb",     2, { R_XMM,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),						                        NO_VEX, NO_EVEX, 1, 1, { 0x74, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  NO_IMM,     MEM_OPND_1,   P_686 | P_SSE2, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//PCMPEQW mm, mm/m64               NP 0F 75 /r1      A V/V MMX        
//PCMPEQW xmm1, xmm2/m128          66 0F 75 /r       A V/V SSE2       
/* ----------------------------------------------------------------------------------------------- */
{ "pcmpeqw",     2, { MMX64,   MMX64        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),	                      NO_VEX, NO_EVEX, 1, 1, { 0x75, 0x00, 0x00 }, 8,  1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     NO_MEM,       P_586 | P_MMX,  0, NULL },
{ "pcmpeqw",     2, { MMX64,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),		                                NO_VEX, NO_EVEX, 1, 1, { 0x75, 0x00, 0x00 }, 8,  1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     MEM_OPND_1,   P_586 | P_MMX,  0, NULL },
{ "pcmpeqw",     2, { R_XMM,   R_XMM        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),                       NO_VEX, NO_EVEX, 1, 1, { 0x75, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  NO_IMM,     NO_MEM,       P_686 | P_SSE2, 0, NULL },
{ "pcmpeqw",     2, { R_XMM,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),						                        NO_VEX, NO_EVEX, 1, 1, { 0x75, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  NO_IMM,     MEM_OPND_1,   P_686 | P_SSE2, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//PCMPEQD mm, mm/m64               NP 0F 76 /r1      A V/V MMX        
//PCMPEQD xmm1, xmm2/m128          66 0F 76 /r       A V/V SSE2       
/* ----------------------------------------------------------------------------------------------- */
{ "pcmpeqd",     2, { MMX64,   MMX64        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),	                      NO_VEX, NO_EVEX, 1, 1, { 0x76, 0x00, 0x00 }, 8,  1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     NO_MEM,       P_586 | P_MMX,  0, NULL },
{ "pcmpeqd",     2, { MMX64,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),		                                NO_VEX, NO_EVEX, 1, 1, { 0x76, 0x00, 0x00 }, 8,  1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     MEM_OPND_1,   P_586 | P_MMX,  0, NULL },
{ "pcmpeqd",     2, { R_XMM,   R_XMM        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),                       NO_VEX, NO_EVEX, 1, 1, { 0x76, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  NO_IMM,     NO_MEM,       P_686 | P_SSE2, 0, NULL },
{ "pcmpeqd",     2, { R_XMM,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),						                        NO_VEX, NO_EVEX, 1, 1, { 0x76, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  NO_IMM,     MEM_OPND_1,   P_686 | P_SSE2, 0, NULL },
//PEXTRW reg, mm, imm8       NP 0F C5 / r ib1                  A V / V SSE
//PEXTRW reg, xmm, imm8      66 0F C5 / r ib                   A V / V SSE2
//PEXTRW reg / m16, xmm, imm8 66 0F 3A 15 / r ib               B V / V SSE4_1
{ "pextrw",    3, { R32,   MMX64,  IMM8 }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM) | IMM8_ONLY,               NO_VEX, NO_EVEX, 4, 1, { 0xc5, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,   IMM_OPND_2, NO_MEM,       P_686 | P_SSE2, 0, NULL },
{ "pextrw",    3, { R32E,  MMX64,  IMM8 }, SSE0, (REX | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM) | IMM8_ONLY,         NO_VEX, NO_EVEX, 4, 1, { 0xc5, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,   IMM_OPND_2, NO_MEM,       P_686 | P_SSE2, 0, NULL },
{ "pextrw",    3, { R64,   MMX64,  IMM8 }, SSE0, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM) | IMM8_ONLY,         NO_VEX, NO_EVEX, 4, 1, { 0xc5, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,   IMM_OPND_2, NO_MEM,       P_686 | P_SSE2, 0, NULL },
{ "pextrw",    3, { R64E,  MMX64,  IMM8 }, SSE0, (REX | REXW | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM) | IMM8_ONLY,  NO_VEX, NO_EVEX, 4, 1, { 0xc5, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,   IMM_OPND_2, NO_MEM,       P_686 | P_SSE2, 0, NULL },
{ "pextrw",    3, { R32,   R_XMM,  IMM8 }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM) | IMM8_ONLY,               NO_VEX, NO_EVEX, 4, 1, { 0xc5, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F, IMM_OPND_2, NO_MEM,       P_686 | P_SSE2, 0, NULL },
{ "pextrw",    3, { R32E,  R_XMM,  IMM8 }, SSE0, (REX | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM) | IMM8_ONLY,         NO_VEX, NO_EVEX, 4, 1, { 0xc5, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F, IMM_OPND_2, NO_MEM,       P_686 | P_SSE2, 0, NULL },
{ "pextrw",    3, { R64,   R_XMM,  IMM8 }, SSE0, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM) | IMM8_ONLY,         NO_VEX, NO_EVEX, 4, 1, { 0xc5, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F, IMM_OPND_2, NO_MEM,       P_686 | P_SSE2, 0, NULL },
{ "pextrw",    3, { R64E,  R_XMM,  IMM8 }, SSE0, (REX | REXW | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM) | IMM8_ONLY,  NO_VEX, NO_EVEX, 4, 1, { 0xc5, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F, IMM_OPND_2, NO_MEM,       P_686 | P_SSE2, 0, NULL },
{ "pextrw",    3, { M_ANY, R_XMM,  IMM8 }, SSE0, (EREX) | ALLOW_SEG | (F_MODRM | F_MODRM_REG) | IMM8_ONLY,	              NO_VEX, NO_EVEX, 4, 1, { 0x15, 0x00, 0x00 }, 16, 1, MOD_MEM_REG, 0, 0, 0, (X32 | X64), RM_DST, PFX_0x66F3A,IMM_OPND_2, MEM_OPND_0,   P_686 | P_SSE4, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//PEXTRB reg / m8, xmm2, imm8     66 0F 3A 14/ r ib
/* ----------------------------------------------------------------------------------------------- */
{ "pextrb",    3, { R32,   R_XMM,  IMM8 }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM) | IMM8_ONLY,               NO_VEX, NO_EVEX, 16, 1, { 0x14, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), RM_DST, PFX_0x66F3A, IMM_OPND_2, NO_MEM,      P_686 | P_SSE2, 0, NULL },
{ "pextrb",    3, { R32E,  R_XMM,  IMM8 }, SSE0, (REX | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM) | IMM8_ONLY,         NO_VEX, NO_EVEX, 16, 1, { 0x14, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), RM_DST, PFX_0x66F3A, IMM_OPND_2, NO_MEM,      P_686 | P_SSE2, 0, NULL },
{ "pextrb",    3, { R64,   R_XMM,  IMM8 }, SSE0, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM) | IMM8_ONLY,         NO_VEX, NO_EVEX, 16, 1, { 0x14, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), RM_DST, PFX_0x66F3A, IMM_OPND_2, NO_MEM,      P_686 | P_SSE2, 0, NULL },
{ "pextrb",    3, { R64E,  R_XMM,  IMM8 }, SSE0, (REX | REXW | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM) | IMM8_ONLY,  NO_VEX, NO_EVEX, 16, 1, { 0x14, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), RM_DST, PFX_0x66F3A, IMM_OPND_2, NO_MEM,      P_686 | P_SSE2, 0, NULL },
{ "pextrb",    3, { M_ANY, R_XMM,  IMM8 }, SSE0, (EREX) | ALLOW_SEG | (F_MODRM | F_MODRM_REG) | IMM8_ONLY,	              NO_VEX, NO_EVEX, 16, 1, { 0x14, 0x00, 0x00 }, 16, 1, MOD_MEM_REG, 0, 0, 0, (X32 | X64), RM_DST, PFX_0x66F3A,IMM_OPND_2, MEM_OPND_0,   P_686 | P_SSE4, 0, NULL },
//PEXTRD r / m32, xmm2, imm8      66 0F 3A 16 / r ib
{ "pextrd",    3, { R32,   R_XMM,  IMM8 }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM) | IMM8_ONLY,               NO_VEX, NO_EVEX, 4, 1, { 0x16, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), RM_DST, PFX_0x66F3A, IMM_OPND_2, NO_MEM,       P_686 | P_SSE2, 0, NULL },
{ "pextrd",    3, { R32E,  R_XMM,  IMM8 }, SSE0, (REX | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM) | IMM8_ONLY,         NO_VEX, NO_EVEX, 4, 1, { 0x16, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), RM_DST, PFX_0x66F3A, IMM_OPND_2, NO_MEM,       P_686 | P_SSE2, 0, NULL },
{ "pextrd",    3, { M_ANY, R_XMM,  IMM8 }, SSE0, (EREX) | ALLOW_SEG | (F_MODRM | F_MODRM_REG) | IMM8_ONLY,	              NO_VEX, NO_EVEX, 4, 1, { 0x16, 0x00, 0x00 }, 16, 1, MOD_MEM_REG, 0, 0, 0, (X32 | X64), RM_DST, PFX_0x66F3A,IMM_OPND_2, MEM_OPND_0,    P_686 | P_SSE4, 0, NULL },
//PEXTRQ r / m64, xmm2, imm8      66 REX.W 0F 3A 16 / r ib
{ "pextrq",    3, { R64,   R_XMM,  IMM8 }, SSE0, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM) | IMM8_ONLY,         NO_VEX, NO_EVEX, 2, 1, { 0x16, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), RM_DST, PFX_0x66F3A, IMM_OPND_2, NO_MEM,       P_686 | P_SSE2, 0, NULL },
{ "pextrq",    3, { R64E,  R_XMM,  IMM8 }, SSE0, (REX | REXW | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM) | IMM8_ONLY,  NO_VEX, NO_EVEX, 2, 1, { 0x16, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), RM_DST, PFX_0x66F3A, IMM_OPND_2, NO_MEM,       P_686 | P_SSE2, 0, NULL },
{ "pextrq",    3, { M_ANY, R_XMM,  IMM8 }, SSE0, (EREX) | ALLOW_SEG | (F_MODRM | F_MODRM_REG) | IMM8_ONLY,	              NO_VEX, NO_EVEX, 2, 1, { 0x16, 0x00, 0x00 }, 16, 1, MOD_MEM_REG, 0, 0, 0, (X32 | X64), RM_DST, PFX_0x66F3A,IMM_OPND_2, MEM_OPND_0,    P_686 | P_SSE4, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//PINSRB xmm1, r32 / m8, imm8  66 0F 3A 20 / r ib                    A V / V SSE4_1
/* ----------------------------------------------------------------------------------------------- */
{ "pinsrb",    3, { R_XMM,  R32,   IMM8 }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM) | IMM8_ONLY,               NO_VEX, NO_EVEX, 16, 1, { 0x20, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F3A, IMM_OPND_2, NO_MEM,      P_686 | P_SSE4, 0, NULL },
{ "pinsrb",    3, { R_XMM,  R32E,  IMM8 }, SSE0, (REX | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM) | IMM8_ONLY,         NO_VEX, NO_EVEX, 16, 1, { 0x20, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F3A, IMM_OPND_2, NO_MEM,      P_686 | P_SSE4, 0, NULL },
{ "pinsrb",    3, { R_XMM,  R64,   IMM8 }, SSE0, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM) | IMM8_ONLY,         NO_VEX, NO_EVEX, 16, 1, { 0x20, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F3A, IMM_OPND_2, NO_MEM,      P_686 | P_SSE4, 0, NULL },
{ "pinsrb",    3, { R_XMM,  R64E,  IMM8 }, SSE0, (REX | REXW | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM) | IMM8_ONLY,  NO_VEX, NO_EVEX, 16, 1, { 0x20, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F3A, IMM_OPND_2, NO_MEM,      P_686 | P_SSE4, 0, NULL },
{ "pinsrb",    3, { R_XMM,  M_ANY, IMM8 }, SSE0, (EREX) | ALLOW_SEG | (F_MODRM | F_MODRM_REG) | IMM8_ONLY,	              NO_VEX, NO_EVEX, 16, 1, { 0x20, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), RM_DST, PFX_0x66F3A,IMM_OPND_2, MEM_OPND_1,    P_686 | P_SSE4, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//PINSRD xmm1, r / m32, imm8   66 0F 3A 22 / r ib                    A V / V SSE4_1
/* ----------------------------------------------------------------------------------------------- */
{ "pinsrd",    3, { R_XMM,  R32,   IMM8 }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM) | IMM8_ONLY,               NO_VEX, NO_EVEX, 16, 1, { 0x20, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F3A, IMM_OPND_2, NO_MEM,      P_686 | P_SSE4, 0, NULL },
{ "pinsrd",    3, { R_XMM,  R32E,  IMM8 }, SSE0, (REX | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM) | IMM8_ONLY,         NO_VEX, NO_EVEX, 16, 1, { 0x20, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F3A, IMM_OPND_2, NO_MEM,      P_686 | P_SSE4, 0, NULL },
{ "pinsrd",    3, { R_XMM,  R64,   IMM8 }, SSE0, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM) | IMM8_ONLY,         NO_VEX, NO_EVEX, 16, 1, { 0x20, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F3A, IMM_OPND_2, NO_MEM,      P_686 | P_SSE4, 0, NULL },
{ "pinsrd",    3, { R_XMM,  R64E,  IMM8 }, SSE0, (REX | REXW | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM) | IMM8_ONLY,  NO_VEX, NO_EVEX, 16, 1, { 0x20, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F3A, IMM_OPND_2, NO_MEM,      P_686 | P_SSE4, 0, NULL },
{ "pinsrd",    3, { R_XMM,  M_ANY, IMM8 }, SSE0, (EREX) | ALLOW_SEG | (F_MODRM | F_MODRM_REG) | IMM8_ONLY,	              NO_VEX, NO_EVEX, 16, 1, { 0x20, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), RM_DST, PFX_0x66F3A,IMM_OPND_2, MEM_OPND_1,    P_686 | P_SSE4, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//PINSRQ xmm1, r / m64, imm8   66 REX.W 0F 3A 22 / r ib              A V / N.E.SSE4_1
/* ----------------------------------------------------------------------------------------------- */
{ "pinsrq",    3, { R_XMM,  R32,   IMM8 }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM) | IMM8_ONLY,               NO_VEX, NO_EVEX, 16, 1, { 0x20, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F3A, IMM_OPND_2, NO_MEM,      P_686 | P_SSE4, 0, NULL },
{ "pinsrq",    3, { R_XMM,  R32E,  IMM8 }, SSE0, (REX | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM) | IMM8_ONLY,         NO_VEX, NO_EVEX, 16, 1, { 0x20, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F3A, IMM_OPND_2, NO_MEM,      P_686 | P_SSE4, 0, NULL },
{ "pinsrq",    3, { R_XMM,  R64,   IMM8 }, SSE0, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM) | IMM8_ONLY,         NO_VEX, NO_EVEX, 16, 1, { 0x20, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F3A, IMM_OPND_2, NO_MEM,      P_686 | P_SSE4, 0, NULL },
{ "pinsrq",    3, { R_XMM,  R64E,  IMM8 }, SSE0, (REX | REXW | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM) | IMM8_ONLY,  NO_VEX, NO_EVEX, 16, 1, { 0x20, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F3A, IMM_OPND_2, NO_MEM,      P_686 | P_SSE4, 0, NULL },
{ "pinsrq",    3, { R_XMM,  M_ANY, IMM8 }, SSE0, (EREX) | ALLOW_SEG | (F_MODRM | F_MODRM_REG) | IMM8_ONLY,	              NO_VEX, NO_EVEX, 16, 1, { 0x20, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), RM_DST, PFX_0x66F3A,IMM_OPND_2, MEM_OPND_1,    P_686 | P_SSE4, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//PINSRW mm, r32 / m16, imm8  NP 0F C4 / r ib1
//PINSRW xmm, r32 / m16, imm8 66 0F C4 / r ib
/* ----------------------------------------------------------------------------------------------- */
{ "pinsrw",    3, { MMX64,  R32,   IMM8 }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM) | IMM8_ONLY,               NO_VEX, NO_EVEX, 4, 1, { 0xc4, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,   IMM_OPND_2, NO_MEM,       P_686 | P_SSE2, 0, NULL },
{ "pinsrw",    3, { MMX64,  R32E,  IMM8 }, SSE0, (REX | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM) | IMM8_ONLY,         NO_VEX, NO_EVEX, 4, 1, { 0xc4, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,   IMM_OPND_2, NO_MEM,       P_686 | P_SSE2, 0, NULL },
{ "pinsrw",    3, { MMX64,  R64,   IMM8 }, SSE0, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM) | IMM8_ONLY,         NO_VEX, NO_EVEX, 4, 1, { 0xc4, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,   IMM_OPND_2, NO_MEM,       P_686 | P_SSE2, 0, NULL },
{ "pinsrw",    3, { MMX64,  R64E,  IMM8 }, SSE0, (REX | REXW | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM) | IMM8_ONLY,  NO_VEX, NO_EVEX, 4, 1, { 0xc4, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,   IMM_OPND_2, NO_MEM,       P_686 | P_SSE2, 0, NULL },
{ "pinsrw",    3, { MMX64,  M_ANY, IMM8 }, SSE0, (EREX) | ALLOW_SEG | (F_MODRM | F_MODRM_REG) | IMM8_ONLY,	              NO_VEX, NO_EVEX, 4, 1, { 0xc4, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,   IMM_OPND_2, MEM_OPND_1,   P_686 | P_SSE2, 0, NULL },
{ "pinsrw",    3, { R_XMM,  R32,   IMM8 }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM) | IMM8_ONLY,               NO_VEX, NO_EVEX, 4, 1, { 0xc4, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F, IMM_OPND_2, NO_MEM,       P_686 | P_SSE2, 0, NULL },
{ "pinsrw",    3, { R_XMM,  R32E,  IMM8 }, SSE0, (REX | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM) | IMM8_ONLY,         NO_VEX, NO_EVEX, 4, 1, { 0xc4, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F, IMM_OPND_2, NO_MEM,       P_686 | P_SSE2, 0, NULL },
{ "pinsrw",    3, { R_XMM,  R64,   IMM8 }, SSE0, (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM) | IMM8_ONLY,         NO_VEX, NO_EVEX, 4, 1, { 0xc4, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F, IMM_OPND_2, NO_MEM,       P_686 | P_SSE2, 0, NULL },
{ "pinsrw",    3, { R_XMM,  R64E,  IMM8 }, SSE0, (REX | REXW | REXR) | (F_MODRM | F_MODRM_REG | F_MODRM_RM) | IMM8_ONLY,  NO_VEX, NO_EVEX, 4, 1, { 0xc4, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F, IMM_OPND_2, NO_MEM,       P_686 | P_SSE2, 0, NULL },
{ "pinsrw",    3, { R_XMM,  M_ANY, IMM8 }, SSE0, (EREX) | ALLOW_SEG | (F_MODRM | F_MODRM_REG) | IMM8_ONLY,	              NO_VEX, NO_EVEX, 4, 1, { 0xc4, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F, IMM_OPND_2, MEM_OPND_1,   P_686 | P_SSE2, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//PMADDWD mm, mm / m64      NP 0F F5 / r1      A V / V MMX
//PMADDWD xmm1, xmm2 / m128 66 0F F5 / r       A V / V SSE2
{ "pmaddwd",     2, { MMX64,   MMX64        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),	                      NO_VEX, NO_EVEX, 1, 1, { 0xf5, 0x00, 0x00 }, 8,  1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     NO_MEM,       P_586 | P_MMX,  0, NULL },
{ "pmaddwd",     2, { MMX64,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),		                                NO_VEX, NO_EVEX, 1, 1, { 0xf5, 0x00, 0x00 }, 8,  1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     MEM_OPND_1,   P_586 | P_MMX,  0, NULL },
{ "pmaddwd",     2, { R_XMM,   R_XMM        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),                       NO_VEX, NO_EVEX, 1, 1, { 0xf5, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  NO_IMM,     NO_MEM,       P_686 | P_SSE2, 0, NULL },
{ "pmaddwd",     2, { R_XMM,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),						                        NO_VEX, NO_EVEX, 1, 1, { 0xf5, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  NO_IMM,     MEM_OPND_1,   P_686 | P_SSE2, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//PMAXSW mm1, mm2 / m64                               NP 0F EE / r1                 A V / V SSE
//PMAXSW xmm1, xmm2 / m128                            66 0F EE / r                  A V / V SSE2
/* ----------------------------------------------------------------------------------------------- */
{ "pmaxsw",      2, { MMX64,   MMX64        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),	                      NO_VEX, NO_EVEX, 1, 1, { 0xee, 0x00, 0x00 }, 8,  1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     NO_MEM,       P_586 | P_MMX,  0, NULL },
{ "pmaxsw",      2, { MMX64,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),		                                NO_VEX, NO_EVEX, 1, 1, { 0xee, 0x00, 0x00 }, 8,  1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     MEM_OPND_1,   P_586 | P_MMX,  0, NULL },
{ "pmaxsw",      2, { R_XMM,   R_XMM        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),                       NO_VEX, NO_EVEX, 1, 1, { 0xee, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  NO_IMM,     NO_MEM,       P_686 | P_SSE2, 0, NULL },
{ "pmaxsw",      2, { R_XMM,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),						                        NO_VEX, NO_EVEX, 1, 1, { 0xee, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  NO_IMM,     MEM_OPND_1,   P_686 | P_SSE2, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//PMAXSB xmm1, xmm2 / m128                            66 0F 38 3C / r               A V / V SSE4_1
/* ----------------------------------------------------------------------------------------------- */
{ "pmaxsb",      2, { R_XMM,   R_XMM        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),                       NO_VEX, NO_EVEX, 1, 1, { 0x3c, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F38,  NO_IMM,     NO_MEM,       P_686 | P_SSE4, 0, NULL },
{ "pmaxsb",      2, { R_XMM,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),						                        NO_VEX, NO_EVEX, 1, 1, { 0x3c, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F38,  NO_IMM,     MEM_OPND_1,   P_686 | P_SSE4, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//PMAXSD xmm1, xmm2 / m128                            66 0F 38 3D / r               A V / V SSE4_1
/* ----------------------------------------------------------------------------------------------- */
{ "pmaxsd",      2, { R_XMM,   R_XMM        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),                       NO_VEX, NO_EVEX, 1, 1, { 0x3d, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F38,  NO_IMM,     NO_MEM,       P_686 | P_SSE4, 0, NULL },
{ "pmaxsd",      2, { R_XMM,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),						                        NO_VEX, NO_EVEX, 1, 1, { 0x3d, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F38,  NO_IMM,     MEM_OPND_1,   P_686 | P_SSE4, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//PMAXUB mm1, mm2 / m64       NP 0F DE / r1                            A V / V SSE
//PMAXUB xmm1, xmm2 / m128    66 0F DE / r                             A V / V SSE2
/* ----------------------------------------------------------------------------------------------- */
{ "pmaxub",      2, { MMX64,   MMX64        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),	                      NO_VEX, NO_EVEX, 1, 1, { 0xde, 0x00, 0x00 }, 8,  1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     NO_MEM,       P_586 | P_MMX,  0, NULL },
{ "pmaxub",      2, { MMX64,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),		                                NO_VEX, NO_EVEX, 1, 1, { 0xde, 0x00, 0x00 }, 8,  1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     MEM_OPND_1,   P_586 | P_MMX,  0, NULL },
{ "pmaxub",      2, { R_XMM,   R_XMM        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),                       NO_VEX, NO_EVEX, 1, 1, { 0xde, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  NO_IMM,     NO_MEM,       P_686 | P_SSE2, 0, NULL },
{ "pmaxub",      2, { R_XMM,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),						                        NO_VEX, NO_EVEX, 1, 1, { 0xde, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  NO_IMM,     MEM_OPND_1,   P_686 | P_SSE2, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//PMAXUW xmm1, xmm2 / m128    66 0F 38 3E / r                          A V / V SSE4_1
/* ----------------------------------------------------------------------------------------------- */
{ "pmaxuw",      2, { R_XMM,   R_XMM        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),                       NO_VEX, NO_EVEX, 1, 1, { 0x3e, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F38,  NO_IMM,     NO_MEM,       P_686 | P_SSE4, 0, NULL },
{ "pmaxuw",      2, { R_XMM,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),						                        NO_VEX, NO_EVEX, 1, 1, { 0x3e, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F38,  NO_IMM,     MEM_OPND_1,   P_686 | P_SSE4, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//PMAXUD xmm1, xmm2 / m12866 0F 38 3F / r
/* ----------------------------------------------------------------------------------------------- */
{ "pmaxud",      2, { R_XMM,   R_XMM        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),                       NO_VEX, NO_EVEX, 1, 1, { 0x3f, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F38,  NO_IMM,     NO_MEM,       P_686 | P_SSE4, 0, NULL },
{ "pmaxud",      2, { R_XMM,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),						                        NO_VEX, NO_EVEX, 1, 1, { 0x3f, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F38,  NO_IMM,     MEM_OPND_1,   P_686 | P_SSE4, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//PMINUB mm1, mm2 / m64     NP 0F DA / r1   SSE
//PMINUB xmm1, xmm2 / m128  66 0F DA / r    SSE2
/* ----------------------------------------------------------------------------------------------- */
{ "pminub",      2, { MMX64,   MMX64        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),	                      NO_VEX, NO_EVEX, 1, 1, { 0xda, 0x00, 0x00 }, 8,  1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     NO_MEM,       P_586 | P_MMX,  0, NULL },
{ "pminub",      2, { MMX64,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),		                                NO_VEX, NO_EVEX, 1, 1, { 0xda, 0x00, 0x00 }, 8,  1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     MEM_OPND_1,   P_586 | P_MMX,  0, NULL },
{ "pminub",      2, { R_XMM,   R_XMM        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),                       NO_VEX, NO_EVEX, 1, 1, { 0xda, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  NO_IMM,     NO_MEM,       P_686 | P_SSE2, 0, NULL },
{ "pminub",      2, { R_XMM,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),						                        NO_VEX, NO_EVEX, 1, 1, { 0xda, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  NO_IMM,     MEM_OPND_1,   P_686 | P_SSE2, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//PMINUW xmm1, xmm2 / m128  66 0F 38 3A / r SSE4_1
/* ----------------------------------------------------------------------------------------------- */
{ "pminuw",      2, { R_XMM,   R_XMM        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),                       NO_VEX, NO_EVEX, 1, 1, { 0x3a, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F38,  NO_IMM,     NO_MEM,       P_686 | P_SSE4, 0, NULL },
{ "pminuw",      2, { R_XMM,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),						                        NO_VEX, NO_EVEX, 1, 1, { 0x3a, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F38,  NO_IMM,     MEM_OPND_1,   P_686 | P_SSE4, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//PMINUD xmm1, xmm2 / m128 66 0F 38 3B / r   SSE4_1
/* ----------------------------------------------------------------------------------------------- */
{ "pminud",      2, { R_XMM,   R_XMM        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),                       NO_VEX, NO_EVEX, 1, 1, { 0x3b, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F38,  NO_IMM,     NO_MEM,       P_686 | P_SSE4, 0, NULL },
{ "pminud",      2, { R_XMM,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),						                        NO_VEX, NO_EVEX, 1, 1, { 0x3b, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F38,  NO_IMM,     MEM_OPND_1,   P_686 | P_SSE4, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//PMINSW mm1, mm2 / m64    NP 0F EA / r1
//PMINSW xmm1, xmm2 / m128 66 0F EA / r
/* ----------------------------------------------------------------------------------------------- */
{ "pminsw",      2, { MMX64,   MMX64        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),	                      NO_VEX, NO_EVEX, 1, 1, { 0xea, 0x00, 0x00 }, 8,  1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     NO_MEM,       P_586 | P_MMX,  0, NULL },
{ "pminsw",      2, { MMX64,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),		                                NO_VEX, NO_EVEX, 1, 1, { 0xea, 0x00, 0x00 }, 8,  1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     MEM_OPND_1,   P_586 | P_MMX,  0, NULL },
{ "pminsw",      2, { R_XMM,   R_XMM        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),                       NO_VEX, NO_EVEX, 1, 1, { 0xea, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  NO_IMM,     NO_MEM,       P_686 | P_SSE2, 0, NULL },
{ "pminsw",      2, { R_XMM,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),						                        NO_VEX, NO_EVEX, 1, 1, { 0xea, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  NO_IMM,     MEM_OPND_1,   P_686 | P_SSE2, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//PMINSB xmm1, xmm2 / m128 66 0F 38 38 / r
/* ----------------------------------------------------------------------------------------------- */
{ "pminsb",      2, { R_XMM,   R_XMM        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),                       NO_VEX, NO_EVEX, 1, 1, { 0x38, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F38,  NO_IMM,     NO_MEM,       P_686 | P_SSE4, 0, NULL },
{ "pminsb",      2, { R_XMM,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),						                        NO_VEX, NO_EVEX, 1, 1, { 0x38, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F38,  NO_IMM,     MEM_OPND_1,   P_686 | P_SSE4, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//PMINSD xmm1, xmm2/m128 66 0F 38 39 /r
/* ----------------------------------------------------------------------------------------------- */
{ "pminsd",      2, { R_XMM,   R_XMM        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),                       NO_VEX, NO_EVEX, 1, 1, { 0x39, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F38,  NO_IMM,     NO_MEM,       P_686 | P_SSE4, 0, NULL },
{ "pminsd",      2, { R_XMM,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),						                        NO_VEX, NO_EVEX, 1, 1, { 0x39, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F38,  NO_IMM,     MEM_OPND_1,   P_686 | P_SSE4, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//PMOVMSKB reg, mm  NP 0F D7 / r1
//PMOVMSKB reg, xmm 66 0F D7 / r
{ "pmovmskb", 2, { R32,      MMX64       }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),	                        NO_VEX, NO_EVEX,  2, 1, { 0xd7, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     NO_MEM,    P_686 | P_MMX, 0, NULL },
{ "pmovmskb", 2, { R32E,     MMX64       }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),	                        NO_VEX, NO_EVEX,  2, 1, { 0xd7, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     NO_MEM,    P_686 | P_MMX, 0, NULL },
{ "pmovmskb", 2, { R32,      R_XMM       }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),	                        NO_VEX, NO_EVEX,  2, 1, { 0xd7, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF20F,  NO_IMM,     NO_MEM,    P_686 | P_SSE2, 0, NULL },
{ "pmovmskb", 2, { R32E,     R_XMM       }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),	                        NO_VEX, NO_EVEX,  2, 1, { 0xd7, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF20F,  NO_IMM,     NO_MEM,    P_686 | P_SSE2, 0, NULL },
{ "pmovmskb", 2, { R64,      R_XMM       }, SSE0, (EREX) | (REX | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),	          NO_VEX, NO_EVEX,  2, 1, { 0xd7, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF20F,  NO_IMM,     NO_MEM,    P_686 | P_SSE2, 0, NULL },
{ "pmovmskb", 2, { R64E,     R_XMM       }, SSE0, (REX | REXR | REXW) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),	            NO_VEX, NO_EVEX,  2, 1, { 0xd7, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF20F,  NO_IMM,     NO_MEM,    P_686 | P_SSE2, 0, NULL },
//pmulhuw mm1, mm2 / m64    NP 0F E4 / r1
//PMULHUW xmm1, xmm2 / m128 66 0F E4 / r
/* ----------------------------------------------------------------------------------------------- */
{ "pmulhuw",  2, { MMX64,   MMX64        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),	                      NO_VEX, NO_EVEX, 1, 1, { 0xe4, 0x00, 0x00 }, 8,  1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     NO_MEM,       P_586 | P_MMX,  0, NULL },
{ "pmulhuw",  2, { MMX64,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),		                                  NO_VEX, NO_EVEX, 1, 1, { 0xe4, 0x00, 0x00 }, 8,  1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     MEM_OPND_1,   P_586 | P_MMX,  0, NULL },
{ "pmulhuw",  2, { R_XMM,   R_XMM        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),                        NO_VEX, NO_EVEX, 1, 1, { 0xe4, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  NO_IMM,     NO_MEM,       P_686 | P_SSE2, 0, NULL },
{ "pmulhuw",  2, { R_XMM,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),						                          NO_VEX, NO_EVEX, 1, 1, { 0xe4, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  NO_IMM,     MEM_OPND_1,   P_686 | P_SSE2, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//PMULHW mm, mm / m64      NP 0F E5 / r1
//PMULHW xmm1, xmm2 / m128 66 0F E5 / r
/* ----------------------------------------------------------------------------------------------- */
{ "pmulhw",   2, { MMX64,   MMX64        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),	                      NO_VEX, NO_EVEX, 1, 1, { 0xe5, 0x00, 0x00 }, 8,  1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     NO_MEM,       P_586 | P_MMX,  0, NULL },
{ "pmulhw",   2, { MMX64,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),		                                  NO_VEX, NO_EVEX, 1, 1, { 0xe5, 0x00, 0x00 }, 8,  1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     MEM_OPND_1,   P_586 | P_MMX,  0, NULL },
{ "pmulhw",   2, { R_XMM,   R_XMM        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),                        NO_VEX, NO_EVEX, 1, 1, { 0xe5, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  NO_IMM,     NO_MEM,       P_686 | P_SSE2, 0, NULL },
{ "pmulhw",   2, { R_XMM,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),						                          NO_VEX, NO_EVEX, 1, 1, { 0xe5, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  NO_IMM,     MEM_OPND_1,   P_686 | P_SSE2, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//PMULLW mm, mm / m64      NP 0F D5 / r1
//PMULLW xmm1, xmm2 / m128 66 0F D5 / r
/* ----------------------------------------------------------------------------------------------- */
{ "pmullw",   2, { MMX64,   MMX64        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),	                      NO_VEX, NO_EVEX, 1, 1, { 0xd5, 0x00, 0x00 }, 8,  1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     NO_MEM,       P_586 | P_MMX,  0, NULL },
{ "pmullw",   2, { MMX64,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),		                                  NO_VEX, NO_EVEX, 1, 1, { 0xd5, 0x00, 0x00 }, 8,  1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     MEM_OPND_1,   P_586 | P_MMX,  0, NULL },
{ "pmullw",   2, { R_XMM,   R_XMM        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),                        NO_VEX, NO_EVEX, 1, 1, { 0xd5, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  NO_IMM,     NO_MEM,       P_686 | P_SSE2, 0, NULL },
{ "pmullw",   2, { R_XMM,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),						                          NO_VEX, NO_EVEX, 1, 1, { 0xd5, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  NO_IMM,     MEM_OPND_1,   P_686 | P_SSE2, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//PMULUDQ mm1, mm2 / m64NP 0F F4 / r1
//PMULUDQ xmm1, xmm2 / m12866 0F F4 / r
/* ----------------------------------------------------------------------------------------------- */
{ "pmuludq",   2, { MMX64,   MMX64        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),	                      NO_VEX, NO_EVEX, 1, 1, { 0xf4, 0x00, 0x00 }, 8,  1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     NO_MEM,       P_586 | P_MMX,  0, NULL },
{ "pmuludq",   2, { MMX64,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),		                                NO_VEX, NO_EVEX, 1, 1, { 0xf4, 0x00, 0x00 }, 8,  1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     MEM_OPND_1,   P_586 | P_MMX,  0, NULL },
{ "pmuludq",   2, { R_XMM,   R_XMM        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),                       NO_VEX, NO_EVEX, 1, 1, { 0xf4, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  NO_IMM,     NO_MEM,       P_686 | P_SSE2, 0, NULL },
{ "pmuludq",   2, { R_XMM,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),						                        NO_VEX, NO_EVEX, 1, 1, { 0xf4, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  NO_IMM,     MEM_OPND_1,   P_686 | P_SSE2, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//POR mm, mm / m64      NP 0F EB / r1
//POR xmm1, xmm2 / m128 66 0F EB / r
/* ----------------------------------------------------------------------------------------------- */
{ "por",   2, { MMX64,   MMX64        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),	                          NO_VEX, NO_EVEX, 1, 1, { 0xeb, 0x00, 0x00 }, 8,  1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     NO_MEM,       P_586 | P_MMX,  0, NULL },
{ "por",   2, { MMX64,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),		                                    NO_VEX, NO_EVEX, 1, 1, { 0xeb, 0x00, 0x00 }, 8,  1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     MEM_OPND_1,   P_586 | P_MMX,  0, NULL },
{ "por",   2, { R_XMM,   R_XMM        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),                           NO_VEX, NO_EVEX, 1, 1, { 0xeb, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  NO_IMM,     NO_MEM,       P_686 | P_SSE2, 0, NULL },
{ "por",   2, { R_XMM,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),						                            NO_VEX, NO_EVEX, 1, 1, { 0xeb, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  NO_IMM,     MEM_OPND_1,   P_686 | P_SSE2, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//PXOR mm, mm / m64      NP 0F EF / r1
//PXOR xmm1, xmm2 / m128 66 0F EF / r
/* ----------------------------------------------------------------------------------------------- */
{ "pxor",   2, { MMX64,   MMX64        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),	                        NO_VEX, NO_EVEX, 1, 1, { 0xef, 0x00, 0x00 }, 8,  1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     NO_MEM,       P_586 | P_MMX,  0, NULL },
{ "pxor",   2, { MMX64,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),		                                    NO_VEX, NO_EVEX, 1, 1, { 0xef, 0x00, 0x00 }, 8,  1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     MEM_OPND_1,   P_586 | P_MMX,  0, NULL },
{ "pxor",   2, { R_XMM,   R_XMM        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),                          NO_VEX, NO_EVEX, 1, 1, { 0xef, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  NO_IMM,     NO_MEM,       P_686 | P_SSE2, 0, NULL },
{ "pxor",   2, { R_XMM,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),						                            NO_VEX, NO_EVEX, 1, 1, { 0xef, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  NO_IMM,     MEM_OPND_1,   P_686 | P_SSE2, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//PSADBW mm1, mm2 / m64    NP 0F F6 / r1    A V / V SSE
//PSADBW xmm1, xmm2 / m128 66 0F F6 / r     A V / V SSE2
/* ----------------------------------------------------------------------------------------------- */
{ "psadbw",   2, { MMX64,   MMX64        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),	                      NO_VEX, NO_EVEX, 1, 1, { 0xf6, 0x00, 0x00 }, 8,  1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     NO_MEM,       P_586 | P_MMX,  0, NULL },
{ "psadbw",   2, { MMX64,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),		                                  NO_VEX, NO_EVEX, 1, 1, { 0xf6, 0x00, 0x00 }, 8,  1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     MEM_OPND_1,   P_586 | P_MMX,  0, NULL },
{ "psadbw",   2, { R_XMM,   R_XMM        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),                        NO_VEX, NO_EVEX, 1, 1, { 0xf6, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  NO_IMM,     NO_MEM,       P_686 | P_SSE2, 0, NULL },
{ "psadbw",   2, { R_XMM,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),						                          NO_VEX, NO_EVEX, 1, 1, { 0xf6, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  NO_IMM,     MEM_OPND_1,   P_686 | P_SSE2, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//PSLLW mm, mm / m64        NP 0F F1 / r1
//PSLLW xmm1, xmm2 / m128   66 0F F1 / r
/* ----------------------------------------------------------------------------------------------- */
{ "psllw",   2, { MMX64,   MMX64        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),	                        NO_VEX, NO_EVEX, 1, 1, { 0xf1, 0x00, 0x00 }, 8,  1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     NO_MEM,       P_586 | P_MMX,  0, NULL },
{ "psllw",   2, { MMX64,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),		                                  NO_VEX, NO_EVEX, 1, 1, { 0xf1, 0x00, 0x00 }, 8,  1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     MEM_OPND_1,   P_586 | P_MMX,  0, NULL },
{ "psllw",   2, { R_XMM,   R_XMM        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),                         NO_VEX, NO_EVEX, 1, 1, { 0xf1, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  NO_IMM,     NO_MEM,       P_686 | P_SSE2, 0, NULL },
{ "psllw",   2, { R_XMM,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),						                          NO_VEX, NO_EVEX, 1, 1, { 0xf1, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  NO_IMM,     MEM_OPND_1,   P_686 | P_SSE2, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//PSLLW mm1, imm8           NP 0F 71 / 6 ib
//PSLLW xmm1, imm8          66 0F 71 / 6 ib
{ "psllw",    2, { MMX64,   IMM8        }, SSE0, (EREX) | (F_OPCODE2_REG) | IMM8_ONLY,             NO_VEX, NO_EVEX, 4, 2, { 0x71, 0xf0, 0x00 }, 8,  0, MOD_REG_IMM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,   IMM_OPND_1, NO_MEM,       P_686 | P_MMX, 0, NULL },
{ "psllw",    2, { R_XMM,   IMM8        }, SSE0, (EREX) | (F_OPCODE2_REG) | IMM8_ONLY,             NO_VEX, NO_EVEX, 4, 2, { 0x71, 0xf0, 0x00 }, 16, 0, MOD_REG_IMM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,   IMM_OPND_1, NO_MEM,     P_686 | P_SSE2, 0, NULL },
//PSLLD mm, mm / m64        NP 0F F2 / r1
//PSLLD xmm1, xmm2 / m128   66 0F F2 / r
{ "pslld",   2, { MMX64,   MMX64        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),	                        NO_VEX, NO_EVEX, 1, 1, { 0xf2, 0x00, 0x00 }, 8,  1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     NO_MEM,       P_586 | P_MMX,  0, NULL },
{ "pslld",   2, { MMX64,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),		                                  NO_VEX, NO_EVEX, 1, 1, { 0xf2, 0x00, 0x00 }, 8,  1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     MEM_OPND_1,   P_586 | P_MMX,  0, NULL },
{ "pslld",   2, { R_XMM,   R_XMM        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),                         NO_VEX, NO_EVEX, 1, 1, { 0xf2, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  NO_IMM,     NO_MEM,       P_686 | P_SSE2, 0, NULL },
{ "pslld",   2, { R_XMM,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),						                          NO_VEX, NO_EVEX, 1, 1, { 0xf2, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  NO_IMM,     MEM_OPND_1,   P_686 | P_SSE2, 0, NULL },
//PSLLD mm, imm8            NP 0F 72 / 6 ib1
//PSLLD xmm1, imm8          66 0F 72 / 6 ib
{ "pslld",    2, { MMX64,   IMM8        }, SSE0, (EREX) | (F_OPCODE2_REG) | IMM8_ONLY,             NO_VEX, NO_EVEX, 4, 1, { 0x72, 0xf0, 0x00 }, 8,  0, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,   IMM_OPND_1, NO_MEM,       P_686 | P_MMX, 0, NULL },
{ "pslld",    2, { R_XMM,   IMM8        }, SSE0, (EREX) | (F_OPCODE2_REG) | IMM8_ONLY,             NO_VEX, NO_EVEX, 4, 1, { 0x72, 0xf0, 0x00 }, 16, 0, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,   IMM_OPND_1, NO_MEM,     P_686 | P_SSE2, 0, NULL },
//PSLLQ mm, mm / m64        NP 0F F3 / r1
//PSLLQ xmm1, xmm2 / m128   66 0F F3 / r
{ "psllq",   2, { MMX64,   MMX64        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),	                        NO_VEX, NO_EVEX, 1, 1, { 0xf3, 0x00, 0x00 }, 8,  1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     NO_MEM,       P_586 | P_MMX,  0, NULL },
{ "psllq",   2, { MMX64,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),		                                  NO_VEX, NO_EVEX, 1, 1, { 0xf3, 0x00, 0x00 }, 8,  1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     MEM_OPND_1,   P_586 | P_MMX,  0, NULL },
{ "psllq",   2, { R_XMM,   R_XMM        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),                         NO_VEX, NO_EVEX, 1, 1, { 0xf3, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  NO_IMM,     NO_MEM,       P_686 | P_SSE2, 0, NULL },
{ "psllq",   2, { R_XMM,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),						                          NO_VEX, NO_EVEX, 1, 1, { 0xf3, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  NO_IMM,     MEM_OPND_1,   P_686 | P_SSE2, 0, NULL },
//PSLLQ mm, imm8            NP 0F 73 / 6 ib1
//PSLLQ xmm1, imm8          66 0F 73 / 6 ib
{ "psllq",    2, { MMX64,   IMM8        }, SSE0, (EREX) | (F_OPCODE2_REG) | IMM8_ONLY,             NO_VEX, NO_EVEX, 4, 1, { 0x73, 0xf0, 0x00 }, 16, 0, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,   IMM_OPND_1, NO_MEM,       P_686 | P_MMX, 0, NULL },
{ "psllq",    2, { R_XMM,   IMM8        }, SSE0, (EREX) | (F_OPCODE2_REG) | IMM8_ONLY,             NO_VEX, NO_EVEX, 4, 1, { 0x73, 0xf0, 0x00 }, 16, 0, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,   IMM_OPND_1, NO_MEM,     P_686 | P_SSE2, 0, NULL },
//PSLLDQ xmm1, imm8 66 0F 73 / 7 ib
{ "pslldq",    2, { R_XMM,   IMM8       }, SSE0, (EREX) | (F_OPCODE2_REG) | IMM8_ONLY,             NO_VEX, NO_EVEX, 4, 1, { 0x73, 0xf8, 0x00 }, 16, 0, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,   IMM_OPND_1, NO_MEM,     P_686 | P_SSE2, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//PSRLDQ xmm1, imm8 66 0F 73 / 3 ib
{ "psrldq",    2, { R_XMM,   IMM8       }, SSE0, (EREX) | (F_OPCODE2_REG) | IMM8_ONLY,             NO_VEX, NO_EVEX, 4, 1, { 0x73, 0xd8, 0x00 }, 16, 0, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,   IMM_OPND_1, NO_MEM,     P_686 | P_SSE2, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//PSRAW mm, mm / m64      NP 0F E1 / r1
//PSRAW xmm1, xmm2 / m128 66 0F E1 / r
/* ----------------------------------------------------------------------------------------------- */
{ "psraw",   2, { MMX64,   MMX64        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),	                        NO_VEX, NO_EVEX, 1, 1, { 0xe1, 0x00, 0x00 }, 8,  1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     NO_MEM,       P_586 | P_MMX,  0, NULL },
{ "psraw",   2, { MMX64,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),		                                  NO_VEX, NO_EVEX, 1, 1, { 0xe1, 0x00, 0x00 }, 8,  1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     MEM_OPND_1,   P_586 | P_MMX,  0, NULL },
{ "psraw",   2, { R_XMM,   R_XMM        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),                         NO_VEX, NO_EVEX, 1, 1, { 0xe1, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  NO_IMM,     NO_MEM,       P_686 | P_SSE2, 0, NULL },
{ "psraw",   2, { R_XMM,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),						                          NO_VEX, NO_EVEX, 1, 1, { 0xe1, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  NO_IMM,     MEM_OPND_1,   P_686 | P_SSE2, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//PSRAW mm, imm8     NP 0F 71 / 4 ib1
//PSRAW xmm1, imm8 66 0F 71 / 4 ib
/* ----------------------------------------------------------------------------------------------- */
{ "psraw",    2, { MMX64,   IMM8        }, SSE0, (EREX) | (F_OPCODE2_REG) | IMM8_ONLY,             NO_VEX, NO_EVEX, 4, 2, { 0x71, 0xe0, 0x00 }, 8,  0, MOD_REG_IMM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,   IMM_OPND_1, NO_MEM,       P_686 | P_MMX, 0, NULL },
{ "psraw",    2, { R_XMM,   IMM8        }, SSE0, (EREX) | (F_OPCODE2_REG) | IMM8_ONLY,             NO_VEX, NO_EVEX, 4, 2, { 0x71, 0xe0, 0x00 }, 16, 0, MOD_REG_IMM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,   IMM_OPND_1, NO_MEM,     P_686 | P_SSE2, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//PSRAD mm, mm / m64NP 0F E2 / r1
//PSRAD xmm1, xmm2 / m12866 0F E2 / r
/* ----------------------------------------------------------------------------------------------- */
{ "psrad",   2, { MMX64,   MMX64        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),	                        NO_VEX, NO_EVEX, 1, 1, { 0xe2, 0x00, 0x00 }, 8,  1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     NO_MEM,       P_586 | P_MMX,  0, NULL },
{ "psrad",   2, { MMX64,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),		                                  NO_VEX, NO_EVEX, 1, 1, { 0xe2, 0x00, 0x00 }, 8,  1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     MEM_OPND_1,   P_586 | P_MMX,  0, NULL },
{ "psrad",   2, { R_XMM,   R_XMM        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),                         NO_VEX, NO_EVEX, 1, 1, { 0xe2, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  NO_IMM,     NO_MEM,       P_686 | P_SSE2, 0, NULL },
{ "psrad",   2, { R_XMM,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),						                          NO_VEX, NO_EVEX, 1, 1, { 0xe2, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  NO_IMM,     MEM_OPND_1,   P_686 | P_SSE2, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//PSRAD mm, imm8NP 0F 72 / 4 ib1
//PSRAD xmm1, imm866 0F 72 / 4 ib
/* ----------------------------------------------------------------------------------------------- */
{ "psrad",    2, { MMX64,   IMM8        }, SSE0, (EREX) | (F_OPCODE2_REG) | IMM8_ONLY,             NO_VEX, NO_EVEX, 4, 1, { 0x72, 0xe0, 0x00 }, 8,  0, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,   IMM_OPND_1, NO_MEM,       P_686 | P_MMX, 0, NULL },
{ "psrad",    2, { R_XMM,   IMM8        }, SSE0, (EREX) | (F_OPCODE2_REG) | IMM8_ONLY,             NO_VEX, NO_EVEX, 4, 1, { 0x72, 0xe0, 0x00 }, 16, 0, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,   IMM_OPND_1, NO_MEM,     P_686 | P_SSE2, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//PSRLW mm, mm / m64NP 0F D1 / r1
//PSRLW xmm1, xmm2 / m12866 0F D1 / r
/* ----------------------------------------------------------------------------------------------- */
{ "psrlw",   2, { MMX64,   MMX64        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),	                        NO_VEX, NO_EVEX, 1, 1, { 0xd1, 0x00, 0x00 }, 8,  1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     NO_MEM,       P_586 | P_MMX,  0, NULL },
{ "psrlw",   2, { MMX64,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),		                                  NO_VEX, NO_EVEX, 1, 1, { 0xd1, 0x00, 0x00 }, 8,  1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     MEM_OPND_1,   P_586 | P_MMX,  0, NULL },
{ "psrlw",   2, { R_XMM,   R_XMM        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),                         NO_VEX, NO_EVEX, 1, 1, { 0xd1, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  NO_IMM,     NO_MEM,       P_686 | P_SSE2, 0, NULL },
{ "psrlw",   2, { R_XMM,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),						                          NO_VEX, NO_EVEX, 1, 1, { 0xd1, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  NO_IMM,     MEM_OPND_1,   P_686 | P_SSE2, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//PSRLW mm, imm8    NP 0F 71 / 2 ib1
//PSRLW xmm1, imm8  66 0F 71 / 2 ib
{ "psrlw",    2, { MMX64,   IMM8        }, SSE0, (EREX) | (F_OPCODE2_REG) | IMM8_ONLY,             NO_VEX, NO_EVEX, 4, 2, { 0x71, 0xe0, 0x00 }, 8,  0, MOD_REG_IMM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,   IMM_OPND_1, NO_MEM,       P_686 | P_MMX, 0, NULL },
{ "psrlw",    2, { R_XMM,   IMM8        }, SSE0, (EREX) | (F_OPCODE2_REG) | IMM8_ONLY,             NO_VEX, NO_EVEX, 4, 2, { 0x71, 0xe0, 0x00 }, 16, 0, MOD_REG_IMM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,   IMM_OPND_1, NO_MEM,     P_686 | P_SSE2, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//PSRLD mm, mm / m64NP 0F D2 / r1
//PSRLD xmm1, xmm2 / m12866 0F D2 / r
/* ----------------------------------------------------------------------------------------------- */
{ "psrld",   2, { MMX64,   MMX64        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),	                        NO_VEX, NO_EVEX, 1, 1, { 0xd2, 0x00, 0x00 }, 8,  1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     NO_MEM,       P_586 | P_MMX,  0, NULL },
{ "psrld",   2, { MMX64,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),		                                  NO_VEX, NO_EVEX, 1, 1, { 0xd2, 0x00, 0x00 }, 8,  1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     MEM_OPND_1,   P_586 | P_MMX,  0, NULL },
{ "psrld",   2, { R_XMM,   R_XMM        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),                         NO_VEX, NO_EVEX, 1, 1, { 0xd2, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  NO_IMM,     NO_MEM,       P_686 | P_SSE2, 0, NULL },
{ "psrld",   2, { R_XMM,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),						                          NO_VEX, NO_EVEX, 1, 1, { 0xd2, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  NO_IMM,     MEM_OPND_1,   P_686 | P_SSE2, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//PSRLD mm, imm8 NP 0F 72 / 2 ib1
//PSRLD xmm1, imm8 66 0F 72 / 2 ib
/* ----------------------------------------------------------------------------------------------- */
{ "psrld",    2, { MMX64,   IMM8        }, SSE0, (EREX) | (F_OPCODE2_REG) | IMM8_ONLY,             NO_VEX, NO_EVEX, 4, 1, { 0x72, 0xe0, 0x00 }, 8,  0, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,   IMM_OPND_1, NO_MEM,       P_686 | P_MMX, 0, NULL },
{ "psrld",    2, { R_XMM,   IMM8        }, SSE0, (EREX) | (F_OPCODE2_REG) | IMM8_ONLY,             NO_VEX, NO_EVEX, 4, 1, { 0x72, 0xe0, 0x00 }, 16, 0, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,   IMM_OPND_1, NO_MEM,     P_686 | P_SSE2, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//PSRLQ mm, mm / m64NP 0F D3 / r1
//PSRLQ xmm1, xmm2 / m12866 0F D3 / r
{ "psrlq",   2, { MMX64,   MMX64        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),	                        NO_VEX, NO_EVEX, 1, 1, { 0xd3, 0x00, 0x00 }, 8,  1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     NO_MEM,       P_586 | P_MMX,  0, NULL },
{ "psrlq",   2, { MMX64,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),		                                  NO_VEX, NO_EVEX, 1, 1, { 0xd3, 0x00, 0x00 }, 8,  1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     MEM_OPND_1,   P_586 | P_MMX,  0, NULL },
{ "psrlq",   2, { R_XMM,   R_XMM        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),                         NO_VEX, NO_EVEX, 1, 1, { 0xd3, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  NO_IMM,     NO_MEM,       P_686 | P_SSE2, 0, NULL },
{ "psrlq",   2, { R_XMM,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),						                          NO_VEX, NO_EVEX, 1, 1, { 0xd3, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  NO_IMM,     MEM_OPND_1,   P_686 | P_SSE2, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//PSRLQ mm, imm8   NP 0F 73 / 2 ib1
//PSRLQ xmm1, imm8 66 0F 73 / 2 ib
/* ----------------------------------------------------------------------------------------------- */
{ "psrlq",    2, { MMX64,   IMM8        }, SSE0, (EREX) | (F_OPCODE2_REG) | IMM8_ONLY,             NO_VEX, NO_EVEX, 4, 1, { 0x73, 0xe0, 0x00 }, 16, 0, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,   IMM_OPND_1, NO_MEM,       P_686 | P_MMX, 0, NULL },
{ "psrlq",    2, { R_XMM,   IMM8        }, SSE0, (EREX) | (F_OPCODE2_REG) | IMM8_ONLY,             NO_VEX, NO_EVEX, 4, 1, { 0x73, 0xe0, 0x00 }, 16, 0, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,   IMM_OPND_1, NO_MEM,     P_686 | P_SSE2, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//PSUBB mm, mm / m64      NP 0F F8 / r1
//PSUBB xmm1, xmm2 / m128 66 0F F8 / r
/* ----------------------------------------------------------------------------------------------- */
{ "psubb",   2, { MMX64,   MMX64        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),	                        NO_VEX, NO_EVEX, 1, 1, { 0xf8, 0x00, 0x00 }, 8,  1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     NO_MEM,       P_586 | P_MMX,  0, NULL },
{ "psubb",   2, { MMX64,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),		                                  NO_VEX, NO_EVEX, 1, 1, { 0xf8, 0x00, 0x00 }, 8,  1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     MEM_OPND_1,   P_586 | P_MMX,  0, NULL },
{ "psubb",   2, { R_XMM,   R_XMM        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),                         NO_VEX, NO_EVEX, 1, 1, { 0xf8, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  NO_IMM,     NO_MEM,       P_686 | P_SSE2, 0, NULL },
{ "psubb",   2, { R_XMM,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),						                          NO_VEX, NO_EVEX, 1, 1, { 0xf8, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  NO_IMM,     MEM_OPND_1,   P_686 | P_SSE2, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//PSUBW mm, mm / m64      NP 0F F9 / r1
//PSUBW xmm1, xmm2 / m128 66 0F F9 / r
/* ----------------------------------------------------------------------------------------------- */
{ "psubw",   2, { MMX64,   MMX64        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),	                        NO_VEX, NO_EVEX, 1, 1, { 0xf9, 0x00, 0x00 }, 8,  1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     NO_MEM,       P_586 | P_MMX,  0, NULL },
{ "psubw",   2, { MMX64,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),		                                  NO_VEX, NO_EVEX, 1, 1, { 0xf9, 0x00, 0x00 }, 8,  1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     MEM_OPND_1,   P_586 | P_MMX,  0, NULL },
{ "psubw",   2, { R_XMM,   R_XMM        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),                         NO_VEX, NO_EVEX, 1, 1, { 0xf9, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  NO_IMM,     NO_MEM,       P_686 | P_SSE2, 0, NULL },
{ "psubw",   2, { R_XMM,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),						                          NO_VEX, NO_EVEX, 1, 1, { 0xf9, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  NO_IMM,     MEM_OPND_1,   P_686 | P_SSE2, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//PSUBD mm, mm / m64       NP 0F FA / r1
//PSUBD xmm1, xmm2 / m128  66 0F FA / r
/* ----------------------------------------------------------------------------------------------- */
{ "psubd",   2, { MMX64,   MMX64        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),	                        NO_VEX, NO_EVEX, 1, 1, { 0xfa, 0x00, 0x00 }, 8,  1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     NO_MEM,       P_586 | P_MMX,  0, NULL },
{ "psubd",   2, { MMX64,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),		                                  NO_VEX, NO_EVEX, 1, 1, { 0xfa, 0x00, 0x00 }, 8,  1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     MEM_OPND_1,   P_586 | P_MMX,  0, NULL },
{ "psubd",   2, { R_XMM,   R_XMM        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),                         NO_VEX, NO_EVEX, 1, 1, { 0xfa, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  NO_IMM,     NO_MEM,       P_686 | P_SSE2, 0, NULL },
{ "psubd",   2, { R_XMM,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),						                          NO_VEX, NO_EVEX, 1, 1, { 0xfa, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  NO_IMM,     MEM_OPND_1,   P_686 | P_SSE2, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//PSUBQ mm1, mm2 / m64    NP 0F FB / r1
//PSUBQ xmm1, xmm2 / m128 66 0F FB / r
/* ----------------------------------------------------------------------------------------------- */
{ "psubq",   2, { MMX64,   MMX64        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),	                        NO_VEX, NO_EVEX, 1, 1, { 0xfb, 0x00, 0x00 }, 8,  1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     NO_MEM,       P_586 | P_MMX,  0, NULL },
{ "psubq",   2, { MMX64,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),		                                  NO_VEX, NO_EVEX, 1, 1, { 0xfb, 0x00, 0x00 }, 8,  1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     MEM_OPND_1,   P_586 | P_MMX,  0, NULL },
{ "psubq",   2, { R_XMM,   R_XMM        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),                         NO_VEX, NO_EVEX, 1, 1, { 0xfb, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  NO_IMM,     NO_MEM,       P_686 | P_SSE2, 0, NULL },
{ "psubq",   2, { R_XMM,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),						                          NO_VEX, NO_EVEX, 1, 1, { 0xfb, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  NO_IMM,     MEM_OPND_1,   P_686 | P_SSE2, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//PSUBSB mm, mm / m64NP 0F E8 / r1
//PSUBSB xmm1, xmm2 / m12866 0F E8 / r
/* ----------------------------------------------------------------------------------------------- */
{ "psubsb",   2, { MMX64,   MMX64        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),	                      NO_VEX, NO_EVEX, 1, 1, { 0xe8, 0x00, 0x00 }, 8,  1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     NO_MEM,       P_586 | P_MMX,  0, NULL },
{ "psubsb",   2, { MMX64,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),		                                  NO_VEX, NO_EVEX, 1, 1, { 0xe8, 0x00, 0x00 }, 8,  1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     MEM_OPND_1,   P_586 | P_MMX,  0, NULL },
{ "psubsb",   2, { R_XMM,   R_XMM        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),                        NO_VEX, NO_EVEX, 1, 1, { 0xe8, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  NO_IMM,     NO_MEM,       P_686 | P_SSE2, 0, NULL },
{ "psubsb",   2, { R_XMM,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),						                          NO_VEX, NO_EVEX, 1, 1, { 0xe8, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  NO_IMM,     MEM_OPND_1,   P_686 | P_SSE2, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//PSUBSW mm, mm / m64NP 0F E9 / r1
//PSUBSW xmm1, xmm2 / m12866 0F E9 / r
/* ----------------------------------------------------------------------------------------------- */
{ "psubsw",   2, { MMX64,   MMX64        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),	                      NO_VEX, NO_EVEX, 1, 1, { 0xe9, 0x00, 0x00 }, 8,  1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     NO_MEM,       P_586 | P_MMX,  0, NULL },
{ "psubsw",   2, { MMX64,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),		                                  NO_VEX, NO_EVEX, 1, 1, { 0xe9, 0x00, 0x00 }, 8,  1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     MEM_OPND_1,   P_586 | P_MMX,  0, NULL },
{ "psubsw",   2, { R_XMM,   R_XMM        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),                        NO_VEX, NO_EVEX, 1, 1, { 0xe9, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  NO_IMM,     NO_MEM,       P_686 | P_SSE2, 0, NULL },
{ "psubsw",   2, { R_XMM,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),						                          NO_VEX, NO_EVEX, 1, 1, { 0xe9, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  NO_IMM,     MEM_OPND_1,   P_686 | P_SSE2, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//PSUBUSB mm, mm / m64NP 0F D8 / r1
//psubusb xmm1, xmm2 / m12866 0F D8 / r
/* ----------------------------------------------------------------------------------------------- */
{ "psubusb",   2, { MMX64,   MMX64        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),	                      NO_VEX, NO_EVEX, 1, 1, { 0xd8, 0x00, 0x00 }, 8,  1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     NO_MEM,       P_586 | P_MMX,  0, NULL },
{ "psubusb",   2, { MMX64,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),		                                NO_VEX, NO_EVEX, 1, 1, { 0xd8, 0x00, 0x00 }, 8,  1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     MEM_OPND_1,   P_586 | P_MMX,  0, NULL },
{ "psubusb",   2, { R_XMM,   R_XMM        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),                       NO_VEX, NO_EVEX, 1, 1, { 0xd8, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  NO_IMM,     NO_MEM,       P_686 | P_SSE2, 0, NULL },
{ "psubusb",   2, { R_XMM,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),						                        NO_VEX, NO_EVEX, 1, 1, { 0xd8, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  NO_IMM,     MEM_OPND_1,   P_686 | P_SSE2, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//PSUBUSW mm, mm / m64NP 0F D9 / r1
//psubusw xmm1, xmm2 / m12866 0F D9 / r
/* ----------------------------------------------------------------------------------------------- */
{ "psubusw",   2, { MMX64,   MMX64        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),	                      NO_VEX, NO_EVEX, 1, 1, { 0xd9, 0x00, 0x00 }, 8,  1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     NO_MEM,       P_586 | P_MMX,  0, NULL },
{ "psubusw",   2, { MMX64,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),		                                NO_VEX, NO_EVEX, 1, 1, { 0xd9, 0x00, 0x00 }, 8,  1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     MEM_OPND_1,   P_586 | P_MMX,  0, NULL },
{ "psubusw",   2, { R_XMM,   R_XMM        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),                       NO_VEX, NO_EVEX, 1, 1, { 0xd9, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  NO_IMM,     NO_MEM,       P_686 | P_SSE2, 0, NULL },
{ "psubusw",   2, { R_XMM,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),						                        NO_VEX, NO_EVEX, 1, 1, { 0xd9, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  NO_IMM,     MEM_OPND_1,   P_686 | P_SSE2, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//PUNPCKHBW mm, mm / m64      NP 0F 68 / r1
//punpckhbw xmm1, xmm2 / m128 66 0F 68 / r
/* ----------------------------------------------------------------------------------------------- */
{ "punpckhbw",   2, { MMX64,   MMX64        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),	                      NO_VEX, NO_EVEX, 1, 1, { 0x68, 0x00, 0x00 }, 8,  1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     NO_MEM,       P_586 | P_MMX,  0, NULL },
{ "punpckhbw",   2, { MMX64,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),		                                NO_VEX, NO_EVEX, 1, 1, { 0x68, 0x00, 0x00 }, 8,  1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     MEM_OPND_1,   P_586 | P_MMX,  0, NULL },
{ "punpckhbw",   2, { R_XMM,   R_XMM        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),                       NO_VEX, NO_EVEX, 1, 1, { 0x68, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  NO_IMM,     NO_MEM,       P_686 | P_SSE2, 0, NULL },
{ "punpckhbw",   2, { R_XMM,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),						                        NO_VEX, NO_EVEX, 1, 1, { 0x68, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  NO_IMM,     MEM_OPND_1,   P_686 | P_SSE2, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//PUNPCKHWD mm, mm / m64NP 0F 69 / r1
//punpckhwd xmm1, xmm2 / m12866 0F 69 / r
/* ----------------------------------------------------------------------------------------------- */
{ "punpckhwd",   2, { MMX64,   MMX64        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),	                      NO_VEX, NO_EVEX, 1, 1, { 0x69, 0x00, 0x00 }, 8,  1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     NO_MEM,       P_586 | P_MMX,  0, NULL },
{ "punpckhwd",   2, { MMX64,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),		                                NO_VEX, NO_EVEX, 1, 1, { 0x69, 0x00, 0x00 }, 8,  1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     MEM_OPND_1,   P_586 | P_MMX,  0, NULL },
{ "punpckhwd",   2, { R_XMM,   R_XMM        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),                       NO_VEX, NO_EVEX, 1, 1, { 0x69, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  NO_IMM,     NO_MEM,       P_686 | P_SSE2, 0, NULL },
{ "punpckhwd",   2, { R_XMM,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),						                        NO_VEX, NO_EVEX, 1, 1, { 0x69, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  NO_IMM,     MEM_OPND_1,   P_686 | P_SSE2, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//PUNPCKHDQ mm, mm / m64NP 0F 6A / r1
//punpckhdq xmm1, xmm2 / m12866 0F 6A / r
/* ----------------------------------------------------------------------------------------------- */
{ "punpckhdq",   2, { MMX64,   MMX64        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),	                      NO_VEX, NO_EVEX, 1, 1, { 0x6a, 0x00, 0x00 }, 8,  1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     NO_MEM,       P_586 | P_MMX,  0, NULL },
{ "punpckhdq",   2, { MMX64,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),		                                NO_VEX, NO_EVEX, 1, 1, { 0x6a, 0x00, 0x00 }, 8,  1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     MEM_OPND_1,   P_586 | P_MMX,  0, NULL },
{ "punpckhdq",   2, { R_XMM,   R_XMM        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),                       NO_VEX, NO_EVEX, 1, 1, { 0x6a, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  NO_IMM,     NO_MEM,       P_686 | P_SSE2, 0, NULL },
{ "punpckhdq",   2, { R_XMM,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),						                        NO_VEX, NO_EVEX, 1, 1, { 0x6a, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  NO_IMM,     MEM_OPND_1,   P_686 | P_SSE2, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//PUNPCKHQDQ xmm1, xmm2 / m12866 0F 6D / r
/* ----------------------------------------------------------------------------------------------- */
{ "punpckhqdq",   2, { R_XMM,   R_XMM       }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),                       NO_VEX, NO_EVEX, 1, 1, { 0x6d, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  NO_IMM,     NO_MEM,       P_686 | P_SSE2, 0, NULL },
{ "punpckhqdq",   2, { R_XMM,   M_ANY       }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),						                        NO_VEX, NO_EVEX, 1, 1, { 0x6d, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  NO_IMM,     MEM_OPND_1,   P_686 | P_SSE2, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//PUNPCKLBW mm, mm / m32NP 0F 60 / r1
//PUNPCKLBW xmm1, xmm2 / m12866 0F 60 / r
/* ----------------------------------------------------------------------------------------------- */
{ "punpcklbw",   2, { MMX64,   MMX64        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),	                      NO_VEX, NO_EVEX, 1, 1, { 0x60, 0x00, 0x00 }, 8,  1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     NO_MEM,       P_586 | P_MMX,  0, NULL },
{ "punpcklbw",   2, { MMX64,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),		                                NO_VEX, NO_EVEX, 1, 1, { 0x60, 0x00, 0x00 }, 8,  1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     MEM_OPND_1,   P_586 | P_MMX,  0, NULL },
{ "punpcklbw",   2, { R_XMM,   R_XMM        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),                       NO_VEX, NO_EVEX, 1, 1, { 0x60, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  NO_IMM,     NO_MEM,       P_686 | P_SSE2, 0, NULL },
{ "punpcklbw",   2, { R_XMM,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),						                        NO_VEX, NO_EVEX, 1, 1, { 0x60, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  NO_IMM,     MEM_OPND_1,   P_686 | P_SSE2, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//PUNPCKLWD mm, mm / m32NP 0F 61 / r1
//PUNPCKLWD xmm1, xmm2 / m12866 0F 61 / r
/* ----------------------------------------------------------------------------------------------- */
{ "punpcklwd",   2, { MMX64,   MMX64        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),	                      NO_VEX, NO_EVEX, 1, 1, { 0x61, 0x00, 0x00 }, 8,  1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     NO_MEM,       P_586 | P_MMX,  0, NULL },
{ "punpcklwd",   2, { MMX64,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),		                                NO_VEX, NO_EVEX, 1, 1, { 0x61, 0x00, 0x00 }, 8,  1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     MEM_OPND_1,   P_586 | P_MMX,  0, NULL },
{ "punpcklwd",   2, { R_XMM,   R_XMM        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),                       NO_VEX, NO_EVEX, 1, 1, { 0x61, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  NO_IMM,     NO_MEM,       P_686 | P_SSE2, 0, NULL },
{ "punpcklwd",   2, { R_XMM,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),						                        NO_VEX, NO_EVEX, 1, 1, { 0x61, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  NO_IMM,     MEM_OPND_1,   P_686 | P_SSE2, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//PUNPCKLDQ mm, mm / m32NP 0F 62 / r1
//PUNPCKLDQ xmm1, xmm2 / m12866 0F 62 / r
/* ----------------------------------------------------------------------------------------------- */
{ "punpckldq",   2, { MMX64,   MMX64        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),	                      NO_VEX, NO_EVEX, 1, 1, { 0x62, 0x00, 0x00 }, 8,  1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     NO_MEM,       P_586 | P_MMX,  0, NULL },
{ "punpckldq",   2, { MMX64,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),		                                NO_VEX, NO_EVEX, 1, 1, { 0x62, 0x00, 0x00 }, 8,  1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     MEM_OPND_1,   P_586 | P_MMX,  0, NULL },
{ "punpckldq",   2, { R_XMM,   R_XMM        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),                       NO_VEX, NO_EVEX, 1, 1, { 0x62, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  NO_IMM,     NO_MEM,       P_686 | P_SSE2, 0, NULL },
{ "punpckldq",   2, { R_XMM,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),						                        NO_VEX, NO_EVEX, 1, 1, { 0x62, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  NO_IMM,     MEM_OPND_1,   P_686 | P_SSE2, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//PUNPCKLQDQ xmm1, xmm2 / m12866 0F 6C / r
/* ----------------------------------------------------------------------------------------------- */
{ "punpcklqdq",   2, { R_XMM,   R_XMM       }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),                       NO_VEX, NO_EVEX, 1, 1, { 0x6c, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  NO_IMM,     NO_MEM,       P_686 | P_SSE2, 0, NULL },
{ "punpcklqdq",   2, { R_XMM,   M_ANY       }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),						                        NO_VEX, NO_EVEX, 1, 1, { 0x6c, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  NO_IMM,     MEM_OPND_1,   P_686 | P_SSE2, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//RCPPS xmm1, xmm2 / m128NP 0F 53 / r
/* ----------------------------------------------------------------------------------------------- */
{ "rcpps",   2, { R_XMM,   R_XMM        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),                           NO_VEX, NO_EVEX, 1, 1, { 0x53, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,  NO_IMM,     NO_MEM,       P_686 | P_SSE2, 0, NULL },
{ "rcpps",   2, { R_XMM,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),						                            NO_VEX, NO_EVEX, 1, 1, { 0x53, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,  NO_IMM,     MEM_OPND_1,   P_686 | P_SSE2, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//RCPSS xmm1, xmm2 / m32F3 0F 53 / r
/* ----------------------------------------------------------------------------------------------- */
{ "rcpss",   2, { R_XMM,   R_XMM        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),                           NO_VEX, NO_EVEX, 1, 1, { 0x53, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF30F,  NO_IMM,     NO_MEM,       P_686 | P_SSE2, 0, NULL },
{ "rcpss",   2, { R_XMM,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),						                            NO_VEX, NO_EVEX, 1, 1, { 0x53, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF30F,  NO_IMM,     MEM_OPND_1,   P_686 | P_SSE2, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//RSQRTPS xmm1, xmm2 / m128 NP 0F 52 / r
/* ----------------------------------------------------------------------------------------------- */
{ "rsqrtps",   2, { R_XMM,   R_XMM        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),                         NO_VEX, NO_EVEX, 1, 1, { 0x52, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,  NO_IMM,     NO_MEM,       P_686 | P_SSE2, 0, NULL },
{ "rsqrtps",   2, { R_XMM,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),						                          NO_VEX, NO_EVEX, 1, 1, { 0x52, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,  NO_IMM,     MEM_OPND_1,   P_686 | P_SSE2, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//RSQRTSS xmm1, xmm2 / m32    F3 0F 52 / r
/* ----------------------------------------------------------------------------------------------- */
{ "rsqrtss",   2, { R_XMM,   R_XMM        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),                         NO_VEX, NO_EVEX, 1, 1, { 0x52, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF30F,  NO_IMM,     NO_MEM,       P_686 | P_SSE2, 0, NULL },
{ "rsqrtss",   2, { R_XMM,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),						                          NO_VEX, NO_EVEX, 1, 1, { 0x52, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF30F,  NO_IMM,     MEM_OPND_1,   P_686 | P_SSE2, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//SHUFPD xmm1, xmm2 / m128, imm8    66 0F C6 / r ib
/* ----------------------------------------------------------------------------------------------- */
{ "shufpd",   2, { R_XMM,   R_XMM,   IMM8  }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),                        NO_VEX, NO_EVEX, 1, 1, { 0x6c, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  IMM_OPND_2,     NO_MEM,       P_686 | P_SSE2, 0, NULL },
{ "shufpd",   2, { R_XMM,   M_ANY,   IMM8  }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),						                          NO_VEX, NO_EVEX, 1, 1, { 0x6c, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  IMM_OPND_2,     MEM_OPND_1,   P_686 | P_SSE2, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//SHUFPS xmm1, xmm3 / m128, imm8    NP 0F C6 / r ib
/* ----------------------------------------------------------------------------------------------- */
{ "shufps",   2, { R_XMM,   R_XMM,   IMM8  }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),                        NO_VEX, NO_EVEX, 1, 1, { 0x6c, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,  IMM_OPND_2,     NO_MEM,       P_686 | P_SSE2, 0, NULL },
{ "shufps",   2, { R_XMM,   M_ANY,   IMM8  }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),						                          NO_VEX, NO_EVEX, 1, 1, { 0x6c, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,  IMM_OPND_2,     MEM_OPND_1,   P_686 | P_SSE2, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//UCOMISD xmm1, xmm2 / m64 66 0F 2E / r
{ "ucomisd",   2, { R_XMM,    R_XMM       }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),	                        NO_VEX, NO_EVEX, 2,  1, { 0x2e, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F, NO_IMM,     NO_MEM,     P_686 | P_SSE2, 0, NULL },
{ "ucomisd",   2, { R_XMM,    M_ANY       }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),						                          NO_VEX, NO_EVEX, 2,  1, { 0x2e, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F, NO_IMM,     MEM_OPND_1, P_686 | P_SSE2, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//UCOMISS xmm1, xmm2/m32 NP 0F 2E /r
/* ----------------------------------------------------------------------------------------------- */
{ "ucomiss",   2, { R_XMM,    R_XMM       }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),	                        NO_VEX, NO_EVEX, 4,  1, { 0x2e, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF, NO_IMM,     NO_MEM,     P_686 | P_SSE2, 0, NULL },
{ "ucomiss",   2, { R_XMM,    M_ANY       }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),						                            NO_VEX, NO_EVEX, 4,  1, { 0x2e, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF, NO_IMM,     MEM_OPND_1, P_686 | P_SSE2, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//UNPCKHPD xmm1, xmm2/m12866 0F 15 /r
{ "unpckhpd",   2, { R_XMM,    R_XMM       }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),	                      NO_VEX, NO_EVEX, 1,  1, { 0x15, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F, NO_IMM,     NO_MEM,     P_686 | P_SSE2, 0, NULL },
{ "unpckhpd",   2, { R_XMM,    M_ANY       }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),						                          NO_VEX, NO_EVEX, 1,  1, { 0x15, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F, NO_IMM,     MEM_OPND_1, P_686 | P_SSE2, 0, NULL },
//UNPCKHPS xmm1, xmm2/m128NP 0F 15 /r
{ "unpckhps",   2, { R_XMM,    R_XMM       }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),	                      NO_VEX, NO_EVEX, 1,  1, { 0x15, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF, NO_IMM,     NO_MEM,     P_686 | P_SSE2, 0, NULL },
{ "unpckhps",   2, { R_XMM,    M_ANY       }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),						                          NO_VEX, NO_EVEX, 1,  1, { 0x15, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF, NO_IMM,     MEM_OPND_1, P_686 | P_SSE2, 0, NULL },
//UNPCKLPD xmm1, xmm2/m12866 0F 14 /r
{ "unpcklpd",   2, { R_XMM,    R_XMM       }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),	                      NO_VEX, NO_EVEX, 1,  1, { 0x14, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F, NO_IMM,     NO_MEM,     P_686 | P_SSE2, 0, NULL },
{ "unpcklpd",   2, { R_XMM,    M_ANY       }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),						                          NO_VEX, NO_EVEX, 1,  1, { 0x14, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F, NO_IMM,     MEM_OPND_1, P_686 | P_SSE2, 0, NULL },
//UNPCKLPS xmm1, xmm2 / m128NP 0F 14 / r
{ "unpcklps",   2, { R_XMM,    R_XMM       }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),	                      NO_VEX, NO_EVEX, 1,  1, { 0x14, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF, NO_IMM,     NO_MEM,     P_686 | P_SSE2, 0, NULL },
{ "unpcklps",   2, { R_XMM,    M_ANY       }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),						                          NO_VEX, NO_EVEX, 1,  1, { 0x14, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF, NO_IMM,     MEM_OPND_1, P_686 | P_SSE2, 0, NULL },



//MULPS xmm1, xmm2 / m128 NP 0F 59 / r A V / V SSE
/* ----------------------------------------------------------------------------------------------- */
{ "mulps",     2, { R_XMM,   R_XMM        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),                       NO_VEX, NO_EVEX, 1, 1, { 0x59, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     NO_MEM,       P_686 | P_SSE1, 0, NULL },
{ "mulps",     2, { R_XMM,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),						                        NO_VEX, NO_EVEX, 1, 1, { 0x59, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    NO_IMM,     MEM_OPND_1,   P_686 | P_SSE1, 0, NULL },
{ "mulpd",     2, { R_XMM,   R_XMM        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),	                      NO_VEX, NO_EVEX, 1, 1, { 0x59, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  NO_IMM,     NO_MEM,       P_686 | P_SSE1, 0, NULL },
{ "mulpd",     2, { R_XMM,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),						                        NO_VEX, NO_EVEX, 1, 1, { 0x59, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F,  NO_IMM,     MEM_OPND_1,   P_686 | P_SSE1, 0, NULL },
{ "mulsd",     2, { R_XMM,   R_XMM        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),	                      NO_VEX, NO_EVEX, 2, 1, { 0x59, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF20F, NO_IMM,     NO_MEM,       P_686 | P_SSE1, 0, NULL },
{ "mulsd",     2, { R_XMM,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),						                        NO_VEX, NO_EVEX, 2, 1, { 0x59, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF20F, NO_IMM,     MEM_OPND_1,   P_686 | P_SSE1, 0, NULL },
{ "mulss",     2, { R_XMM,   R_XMM        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),	                      NO_VEX, NO_EVEX, 4, 1, { 0x59, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF30F, NO_IMM,     NO_MEM,       P_686 | P_SSE1, 0, NULL },
{ "mulss",     2, { R_XMM,   M_ANY        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),						                        NO_VEX, NO_EVEX, 4, 1, { 0x59, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF30F, NO_IMM,     MEM_OPND_1,   P_686 | P_SSE1, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
//PSHUFD xmm1, xmm2 / m128, imm8 66 0F 70 / r ib
{ "pshufw",    3, { R_XMM,   R_XMM,  IMM8 }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM) | IMM8_ONLY,           NO_VEX, NO_EVEX, 1, 1, { 0x70, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F, IMM_OPND_2, NO_MEM,    P_686 | P_SSE1, 0, NULL },
{ "pshufw",    3, { R_XMM,   M_ANY,  IMM8 }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG) | IMM8_ONLY,	                      NO_VEX, NO_EVEX, 1, 1, { 0x70, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F, IMM_OPND_2, MEM_OPND_1,P_686 | P_SSE1, 0, NULL },
//PSHUFHW xmm1, xmm2 / m128, imm8 F3 0F 70 / r ib
{ "pshufw",    3, { R_XMM,   R_XMM,  IMM8 }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM) | IMM8_ONLY,           NO_VEX, NO_EVEX, 1, 1, { 0x70, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF30F, IMM_OPND_2, NO_MEM,    P_686 | P_SSE1, 0, NULL },
{ "pshufw",    3, { R_XMM,   M_ANY,  IMM8 }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG) | IMM8_ONLY,	                      NO_VEX, NO_EVEX, 1, 1, { 0x70, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF30F, IMM_OPND_2, MEM_OPND_1,P_686 | P_SSE1, 0, NULL },
//PSHUFW mm1, mm2 / m64, imm8 NP 0F 70 / r ib                                                                                            
{ "pshufw",    3, { MMX64,   MMX64,  IMM8 }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM) | IMM8_ONLY,           NO_VEX, NO_EVEX, 1, 1, { 0x70, 0x00, 0x00 }, 8,  1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    IMM_OPND_2, NO_MEM,    P_686 | P_SSE1, 0, NULL },
{ "pshufw",    3, { MMX64,   M_ANY,  IMM8 }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG) | IMM8_ONLY,	                      NO_VEX, NO_EVEX, 1, 1, { 0x70, 0x00, 0x00 }, 8,  1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF,    IMM_OPND_2, MEM_OPND_1,P_686 | P_SSE1, 0, NULL },
//PSHUFHW xmm1, xmm2 / m128, imm8 F3 0F 70 / r ib
{ "pshufhw",   3, { R_XMM,   R_XMM,  IMM8 }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM) | IMM8_ONLY,           NO_VEX, NO_EVEX, 1, 1, { 0x70, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF30F, IMM_OPND_2, NO_MEM,    P_686 | P_SSE1, 0, NULL },
{ "pshufhw",   3, { R_XMM,   M_ANY,  IMM8 }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG) | IMM8_ONLY,	                      NO_VEX, NO_EVEX, 1, 1, { 0x70, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF30F, IMM_OPND_2, MEM_OPND_1,P_686 | P_SSE1, 0, NULL },
//PSHUFLW xmm1, xmm2 / m128, imm8 F2 0F 70 / r ib                                                                                        
{ "pshuflw",   3, { R_XMM,   R_XMM,  IMM8 }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM) | IMM8_ONLY,           NO_VEX, NO_EVEX, 1, 1, { 0x70, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF20F, IMM_OPND_2, NO_MEM,    P_686 | P_SSE1, 0, NULL },
{ "pshuflw",   3, { R_XMM,   M_ANY,  IMM8 }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG) | IMM8_ONLY,                        NO_VEX, NO_EVEX, 1, 1, { 0x70, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF20F, IMM_OPND_2, MEM_OPND_1,P_686 | P_SSE1, 0, NULL },
//PSHUFB xmm1, xmm2 / m12866 0F 38 00 / r
{ "pshufb",    2, { R_XMM,   R_XMM        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),	                      NO_VEX, NO_EVEX, 1, 1, { 0x00, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F38, NO_IMM, NO_MEM,       P_686 | P_SSE3, 0, NULL },
{ "pshufb",    2, { R_XMM,   M128         }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),		                                NO_VEX, NO_EVEX, 1, 1, { 0x00, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F38, NO_IMM, MEM_OPND_1,   P_686 | P_SSE3, 0, NULL },
//PSHUFB mm1, mm2 / m64 NP 0F 38 00 / r1
{ "pshufb",    2, { MMX64,   MMX64        }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),	                      NO_VEX, NO_EVEX, 1, 1, { 0x00, 0x00, 0x00 }, 8,  1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x0F38,  NO_IMM, NO_MEM,       P_686 | P_SSE3, 0, NULL },
{ "pshufb",    2, { MMX64,   M64          }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),		                                NO_VEX, NO_EVEX, 1, 1, { 0x00, 0x00, 0x00 }, 8,  1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x0F38,  NO_IMM, MEM_OPND_1,   P_686 | P_SSE3, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
/* ADDPD xmm1, xmm2 / m128 66 0F 58 / r  */
/* ----------------------------------------------------------------------------------------------- */
{ "addpd",   2, { R_XMM,    R_XMM       }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),	                        NO_VEX, NO_EVEX,  1,  1, { 0x58, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F  , NO_IMM,     NO_MEM,    P_686 | P_SSE2, 0, NULL },
{ "addpd",   2, { R_XMM,    M_ANY       }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),						                          NO_VEX, NO_EVEX,  1,  1, { 0x58, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F  , NO_IMM,     MEM_OPND_1,P_686 | P_SSE2, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
/* ADDPS xmm1, xmm2 / m128 NP 0F 58 /r */
/* ----------------------------------------------------------------------------------------------- */
{ "addps",  2, { R_XMM,  R_XMM          }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),	                        NO_VEX, NO_EVEX,  1,  1, { 0x58, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, NO_PREFIX | PFX_0xF, NO_IMM,     NO_MEM,     P_686 | P_SSE2, 0, NULL },
{ "addps",  2, { R_XMM,  M_ANY          }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),						                          NO_VEX, NO_EVEX,  1,  1, { 0x58, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, NO_PREFIX | PFX_0xF, NO_IMM,     MEM_OPND_1, P_686 | P_SSE2, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
/* ADDSD xmm1, xmm2 / m128 F2 0F 58 /r   */
/* ----------------------------------------------------------------------------------------------- */
{ "addsd",   2, { R_XMM,    R_XMM       }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),	                        NO_VEX, NO_EVEX,  1,  1, { 0x58, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF20F  , NO_IMM,     NO_MEM,    P_686 | P_SSE2, 0, NULL },
{ "addsd",   2, { R_XMM,    M_ANY       }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),						                          NO_VEX, NO_EVEX,  1,  1, { 0x58, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF20F  , NO_IMM,     MEM_OPND_1,P_686 | P_SSE2, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
/* ADDSS xmm1, xmm2 / m128 F3 0F 58 /r */
/* ----------------------------------------------------------------------------------------------- */
{ "addss",  2, { R_XMM,  R_XMM          }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),	NO_VEX,                 NO_EVEX,          1,  1, { 0x58, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF30F, NO_IMM,     NO_MEM,     P_686 | P_SSE2, 0, NULL },
{ "addss",  2, { R_XMM,  M_ANY          }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),						  NO_VEX,                 NO_EVEX,          1,  1, { 0x58, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0xF30F, NO_IMM,     MEM_OPND_1, P_686 | P_SSE2, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
/* HADDPD xmm1, xmm2 / m128 66 0F 7C / r */
/* ----------------------------------------------------------------------------------------------- */
{ "haddpd",   2, { R_XMM,    R_XMM       }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG | F_MODRM_RM),	                      NO_VEX, NO_EVEX,  1,  1, { 0x7c, 0x00, 0x00 }, 16, 1, MOD_REG_REG, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F  , NO_IMM,     NO_MEM,    P_686 | P_SSE2, 0, NULL },
{ "haddpd",   2, { R_XMM,    M_ANY       }, SSE0, (EREX) | (F_MODRM | F_MODRM_REG),						                          NO_VEX, NO_EVEX,  1,  1, { 0x7c, 0x00, 0x00 }, 16, 1, MOD_REG_MEM, 0, 0, 0, (X32 | X64), REG_DST, PFX_0x66F  , NO_IMM,     MEM_OPND_1,P_686 | P_SSE2, 0, NULL },
/* ----------------------------------------------------------------------------------------------- */
/* HADDPS xmm1, xmm2 / m128 F2 0F 7C / r  */
/* --------------------------------