/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.gridfs;

import com.mongodb.BasicDBObject;
import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.DBObject;
import com.mongodb.MongoException;
import com.mongodb.gridfs.GridFSFile;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class GridFSDBFile
extends GridFSFile {
    public InputStream getInputStream() {
        return new MyInputStream();
    }

    public long writeTo(String filename) throws IOException {
        return this.writeTo(new File(filename));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long writeTo(File f) throws IOException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(f);
            long l = this.writeTo(out);
            return l;
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    public long writeTo(OutputStream out) throws IOException {
        int nc = this.numChunks();
        for (int i = 0; i < nc; ++i) {
            out.write(this.getChunk(i));
        }
        return this._length;
    }

    byte[] getChunk(int i) {
        if (this._fs == null) {
            throw new RuntimeException("no gridfs!");
        }
        DBObject chunk = this._fs._chunkCollection.findOne(BasicDBObjectBuilder.start("files_id", this._id).add("n", i).get());
        if (chunk == null) {
            throw new MongoException("can't find a chunk!  file id: " + this._id + " chunk: " + i);
        }
        return (byte[])chunk.get("data");
    }

    void remove() {
        this._fs._filesCollection.remove(new BasicDBObject("_id", this._id));
        this._fs._chunkCollection.remove(new BasicDBObject("files_id", this._id));
    }

    class MyInputStream
    extends InputStream {
        final int _numChunks;
        int _currentChunkIdx = -1;
        int _offset = 0;
        byte[] _data = null;

        MyInputStream() {
            this._numChunks = GridFSDBFile.this.numChunks();
        }

        public int available() {
            if (this._data == null) {
                return 0;
            }
            return this._data.length - this._offset;
        }

        public void close() {
        }

        public void mark(int readlimit) {
            throw new RuntimeException("mark not supported");
        }

        public void reset() {
            throw new RuntimeException("mark not supported");
        }

        public boolean markSupported() {
            return false;
        }

        public int read() {
            byte[] b = new byte[1];
            int res = this.read(b);
            if (res < 0) {
                return -1;
            }
            return b[0] & 0xFF;
        }

        public int read(byte[] b) {
            return this.read(b, 0, b.length);
        }

        public int read(byte[] b, int off, int len) {
            if (this._data == null || this._offset >= this._data.length) {
                if (this._currentChunkIdx + 1 >= this._numChunks) {
                    return -1;
                }
                this._data = GridFSDBFile.this.getChunk(++this._currentChunkIdx);
                this._offset = 0;
            }
            int r = Math.min(len, this._data.length - this._offset);
            System.arraycopy(this._data, this._offset, b, off, r);
            this._offset += r;
            return r;
        }

        public long skip(long numBytesToSkip) throws IOException {
            if (numBytesToSkip <= 0L) {
                return 0L;
            }
            if (this._currentChunkIdx == this._numChunks) {
                return 0L;
            }
            long offsetInFile = 0L;
            if (this._currentChunkIdx >= 0) {
                offsetInFile = (long)this._currentChunkIdx * GridFSDBFile.this._chunkSize + (long)this._offset;
            }
            if (numBytesToSkip + offsetInFile >= GridFSDBFile.this._length) {
                this._currentChunkIdx = this._numChunks;
                this._data = null;
                return GridFSDBFile.this._length - offsetInFile;
            }
            int temp = this._currentChunkIdx;
            this._currentChunkIdx = (int)((numBytesToSkip + offsetInFile) / GridFSDBFile.this._chunkSize);
            if (temp != this._currentChunkIdx) {
                this._data = GridFSDBFile.this.getChunk(this._currentChunkIdx);
            }
            this._offset = (int)((numBytesToSkip + offsetInFile) % GridFSDBFile.this._chunkSize);
            return numBytesToSkip;
        }
    }
}

