﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/budgets/Budgets_EXPORTS.h>
#include <aws/budgets/model/Notification.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace Budgets {
namespace Model {

/**
 * <p> The budget name and associated notifications for an account. </p><p><h3>See
 * Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/budgets-2016-10-20/BudgetNotificationsForAccount">AWS
 * API Reference</a></p>
 */
class BudgetNotificationsForAccount {
 public:
  AWS_BUDGETS_API BudgetNotificationsForAccount() = default;
  AWS_BUDGETS_API BudgetNotificationsForAccount(Aws::Utils::Json::JsonView jsonValue);
  AWS_BUDGETS_API BudgetNotificationsForAccount& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_BUDGETS_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{

  inline const Aws::Vector<Notification>& GetNotifications() const { return m_notifications; }
  inline bool NotificationsHasBeenSet() const { return m_notificationsHasBeenSet; }
  template <typename NotificationsT = Aws::Vector<Notification>>
  void SetNotifications(NotificationsT&& value) {
    m_notificationsHasBeenSet = true;
    m_notifications = std::forward<NotificationsT>(value);
  }
  template <typename NotificationsT = Aws::Vector<Notification>>
  BudgetNotificationsForAccount& WithNotifications(NotificationsT&& value) {
    SetNotifications(std::forward<NotificationsT>(value));
    return *this;
  }
  template <typename NotificationsT = Notification>
  BudgetNotificationsForAccount& AddNotifications(NotificationsT&& value) {
    m_notificationsHasBeenSet = true;
    m_notifications.emplace_back(std::forward<NotificationsT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetBudgetName() const { return m_budgetName; }
  inline bool BudgetNameHasBeenSet() const { return m_budgetNameHasBeenSet; }
  template <typename BudgetNameT = Aws::String>
  void SetBudgetName(BudgetNameT&& value) {
    m_budgetNameHasBeenSet = true;
    m_budgetName = std::forward<BudgetNameT>(value);
  }
  template <typename BudgetNameT = Aws::String>
  BudgetNotificationsForAccount& WithBudgetName(BudgetNameT&& value) {
    SetBudgetName(std::forward<BudgetNameT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<Notification> m_notifications;
  bool m_notificationsHasBeenSet = false;

  Aws::String m_budgetName;
  bool m_budgetNameHasBeenSet = false;
};

}  // namespace Model
}  // namespace Budgets
}  // namespace Aws
