﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/budgets/model/HealthStatus.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace Budgets {
namespace Model {

HealthStatus::HealthStatus(JsonView jsonValue) { *this = jsonValue; }

HealthStatus& HealthStatus::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("Status")) {
    m_status = HealthStatusValueMapper::GetHealthStatusValueForName(jsonValue.GetString("Status"));
    m_statusHasBeenSet = true;
  }
  if (jsonValue.ValueExists("StatusReason")) {
    m_statusReason = HealthStatusReasonMapper::GetHealthStatusReasonForName(jsonValue.GetString("StatusReason"));
    m_statusReasonHasBeenSet = true;
  }
  if (jsonValue.ValueExists("LastUpdatedTime")) {
    m_lastUpdatedTime = jsonValue.GetDouble("LastUpdatedTime");
    m_lastUpdatedTimeHasBeenSet = true;
  }
  return *this;
}

JsonValue HealthStatus::Jsonize() const {
  JsonValue payload;

  if (m_statusHasBeenSet) {
    payload.WithString("Status", HealthStatusValueMapper::GetNameForHealthStatusValue(m_status));
  }

  if (m_statusReasonHasBeenSet) {
    payload.WithString("StatusReason", HealthStatusReasonMapper::GetNameForHealthStatusReason(m_statusReason));
  }

  if (m_lastUpdatedTimeHasBeenSet) {
    payload.WithDouble("LastUpdatedTime", m_lastUpdatedTime.SecondsWithMSPrecision());
  }

  return payload;
}

}  // namespace Model
}  // namespace Budgets
}  // namespace Aws
