﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/clouddirectory/model/AttachObjectRequest.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>

#include <utility>

using namespace Aws::CloudDirectory::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String AttachObjectRequest::SerializePayload() const {
  JsonValue payload;

  if (m_parentReferenceHasBeenSet) {
    payload.WithObject("ParentReference", m_parentReference.Jsonize());
  }

  if (m_childReferenceHasBeenSet) {
    payload.WithObject("ChildReference", m_childReference.Jsonize());
  }

  if (m_linkNameHasBeenSet) {
    payload.WithString("LinkName", m_linkName);
  }

  return payload.View().WriteReadable();
}

Aws::Http::HeaderValueCollection AttachObjectRequest::GetRequestSpecificHeaders() const {
  Aws::Http::HeaderValueCollection headers;
  Aws::StringStream ss;
  if (m_directoryArnHasBeenSet) {
    ss << m_directoryArn;
    headers.emplace("x-amz-data-partition", ss.str());
    ss.str("");
  }

  return headers;
}
