﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/cloudtrail/model/UpdateTrailRequest.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::CloudTrail::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String UpdateTrailRequest::SerializePayload() const {
  JsonValue payload;

  if (m_nameHasBeenSet) {
    payload.WithString("Name", m_name);
  }

  if (m_s3BucketNameHasBeenSet) {
    payload.WithString("S3BucketName", m_s3BucketName);
  }

  if (m_s3KeyPrefixHasBeenSet) {
    payload.WithString("S3KeyPrefix", m_s3KeyPrefix);
  }

  if (m_snsTopicNameHasBeenSet) {
    payload.WithString("SnsTopicName", m_snsTopicName);
  }

  if (m_includeGlobalServiceEventsHasBeenSet) {
    payload.WithBool("IncludeGlobalServiceEvents", m_includeGlobalServiceEvents);
  }

  if (m_isMultiRegionTrailHasBeenSet) {
    payload.WithBool("IsMultiRegionTrail", m_isMultiRegionTrail);
  }

  if (m_enableLogFileValidationHasBeenSet) {
    payload.WithBool("EnableLogFileValidation", m_enableLogFileValidation);
  }

  if (m_cloudWatchLogsLogGroupArnHasBeenSet) {
    payload.WithString("CloudWatchLogsLogGroupArn", m_cloudWatchLogsLogGroupArn);
  }

  if (m_cloudWatchLogsRoleArnHasBeenSet) {
    payload.WithString("CloudWatchLogsRoleArn", m_cloudWatchLogsRoleArn);
  }

  if (m_kmsKeyIdHasBeenSet) {
    payload.WithString("KmsKeyId", m_kmsKeyId);
  }

  if (m_isOrganizationTrailHasBeenSet) {
    payload.WithBool("IsOrganizationTrail", m_isOrganizationTrail);
  }

  return payload.View().WriteReadable();
}

Aws::Http::HeaderValueCollection UpdateTrailRequest::GetRequestSpecificHeaders() const {
  Aws::Http::HeaderValueCollection headers;
  headers.insert(Aws::Http::HeaderValuePair("X-Amz-Target", "com.amazonaws.cloudtrail.v20131101.CloudTrail_20131101.UpdateTrail"));
  return headers;
}
