﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/codeartifact/model/ListSubPackageGroupsResult.h>
#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>

#include <utility>

using namespace Aws::CodeArtifact::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

ListSubPackageGroupsResult::ListSubPackageGroupsResult(const Aws::AmazonWebServiceResult<JsonValue>& result) { *this = result; }

ListSubPackageGroupsResult& ListSubPackageGroupsResult::operator=(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("packageGroups")) {
    Aws::Utils::Array<JsonView> packageGroupsJsonList = jsonValue.GetArray("packageGroups");
    for (unsigned packageGroupsIndex = 0; packageGroupsIndex < packageGroupsJsonList.GetLength(); ++packageGroupsIndex) {
      m_packageGroups.push_back(packageGroupsJsonList[packageGroupsIndex].AsObject());
    }
    m_packageGroupsHasBeenSet = true;
  }
  if (jsonValue.ValueExists("nextToken")) {
    m_nextToken = jsonValue.GetString("nextToken");
    m_nextTokenHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
