<!-- Copyright (c) 2017-2023 Hartmut Kaiser                                       -->
<!--                                                                              -->
<!-- SPDX-License-Identifier: BSL-1.0                                             -->
<!-- Distributed under the Boost Software License, Version 1.0. (See accompanying -->
<!-- file LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)        -->

## Support for deploying and using HPX

Welcome to [HPX](http://stellar-group.org/libraries/hpx/)! We use GitHub for
[tracking bugs and feature requests](https://github.com/STEllAR-GROUP/hpx/issues).
Please see for the resources below if you are looking for the right place to
get support for using HPX.

### Documentation

* [User Documentation](https://hpx-docs.stellar-group.org/latest/html/index.html)

### Reporting security issues and vulnerabilities

Please send us an [email](info@stellar-group.org) describing the issue. See our
[security policy](https://github.com/STEllAR-GROUP/hpx/blob/master/.github/SECURITY.md)
for details.

### Chat

* #ste||ar on [Discord](https://discord.gg/Tn9QuzVjvy): this is the best option
  to get in contact with us as most of the developers are available on this
  channel.
* Slack ([registration](https://cpplang.now.sh/)): The
  [`#hpx`](https://cpplang.slack.com/messages/C68QLPZB3) channel is another
  place where people usually offer support.

### Mailing Lists/Groups

* [hpx-users group](mailto:hpx-users@stellar-group.org), see
  [here](https://www.mail-archive.com/hpx-users@stellar-group.org) for past
  conversations. This is the main mailing list for user questions and HPX
  announcements.
* [hpx-devel group](mailto:hpx-devel@stellar-group.org), see
  [here](https://www.mail-archive.com/hpx-devel@stellar-group.org) for past
  conversations. This is the main mailing list for development discussion
  and voting.
* [hpx-pmc group](mailto:hpx-pmc@stellar-group.org). The project management
  committee (PMC) can be reached at this address.

### Latest News

* For latest news and announcements please see our
  [blog](http://hpx.stellar-group.org/blog/).

### Stack Overflow

The HPX Community is active on Stack Overflow, you can post your questions there:

* [HPX on Stack Overflow](http://stackoverflow.com/questions/tagged/hpx)

  * Here are some tips for
    [about how to ask good questions](http://stackoverflow.com/help/how-to-ask).
  * Don't forget to check to see
    [what's on topic](http://stackoverflow.com/help/on-topic).
