SYD-SEC(1)

# NAME

*syd-sec* - Print secure bits or run command with secure bits set

# SYNOPSIS

*syd-sec* _[-ahikprsxAIKPRSX]_ _{command [args...]}_

# DESCRIPTION

Given no arguments, print information on process secure bits in compact JSON.

Given no command, one or more of the secure bit options _[-aikprsx]_ may
be given to test for secure bits. Use capital letter options,
_[-AIKPRSX]_, to test for locked versions of respective secure bits.

Given a command and arguments, with at least one of the secure bit
options _[-aikprsxAIKRSX]_ set the specified securebits, execute the
command and exit with the same status.

# OPTIONS

|[ *-h*
:< Display help and exit.

|[ *-p, -P*
:< Set/test process no_new_privs attribute.

|[ *-r, -R*
:< Set/test secure bit SECBIT_NOROOT.

|[ *-s, -S*
:< Set/test secure bit SECBIT_NO_SETUID_FIXUP.

|[ *-k, -K*
:< Set/test secure bit SECBIT_KEEP_CAPS.

|[ *-a, -A*
:< Set/test secure bit SECBIT_NO_CAP_AMBIENT_RAISE.

|[ *-x, -X*
:< Set/test secure bit SECBIT_EXEC_RESTRICT_FILE.

|[ *-i, -I*
:< Set/test secure bit SECBIT_EXEC_DENY_INTERACTIVE.

# SECURE BITS

[< *Securebit*
:< *Description*
:< *CAP_SETPCAP required?*
|  NO_NEW_PRIVS
:  When set, _execve_(2) will not grant new privileges (e.g., set-user-ID/set-group-ID
   mode bits and file capabilities are ignored). Inherited across _fork_(2),
   _clone_(2), and _execve_(2); once set, cannot be unset.
:  No
|  NOROOT
:  Disable special handling of UID 0 for gaining capabilities on exec/setuid.
   NOROOT_LOCKED is lock for NOROOT (prevents further changes; irreversible).
:  Yes
|  NO_SETUID_FIXUP
:  Stop kernel adjustments to permitted/effective/ambient capability sets when
   effective/filesystem UIDs toggle between 0 and nonzero. NO_SETUID_FIXUP_LOCKED
   is lock for NO_SETUID_FIXUP (prevents further changes; irreversible).
:  Yes
|  KEEP_CAPS
:  Allow retaining permitted capabilities when switching all UIDs from 0 to nonzero;
   always cleared on _execve_(2). KEEP_CAPS_LOCKED is lock for KEEP_CAPS (prevents
   further changes; irreversible).
:  Yes
|  NO_CAP_AMBIENT_RAISE
:  Disallow raising ambient capabilities via _prctl(PR_CAP_AMBIENT_RAISE)_.
   NO_CAP_AMBIENT_RAISE_LOCKED is lock for NO_CAP_AMBIENT_RAISE (prevents
   further changes; irreversible).
:  Yes
|  EXEC_RESTRICT_FILE
:  Interpreter/dynamic linker should execute a file only if _execveat_(2) with
   AT_EXECVE_CHECK on the related file descriptor succeeds. EXEC_RESTRICT_FILE_LOCKED
   is lock for EXEC_RESTRICT_FILE (prevents further changes; irreversible).
:  No
|  EXEC_DENY_INTERACTIVE
:  Interpreter should not accept interactive user commands; content via a file descriptor
   is allowed only if _execveat_(2) with AT_EXECVE_CHECK succeeds. EXEC_DENY_INTERACTIVE_LOCKED
   is lock for EXEC_DENY_INTERACTIVE (prevents further changes; irreversible).
:  No

# EXIT STATUS

When querying secure bits, *syd-sec* exits with success if all the
specified secure bits are set in process secure bits. When running a
command, *syd-sec* exits with the same code as the child process. If
_PR_SET_SECUREBITS_(2const) _prctl_(2) operation fails prior to command
execution, *syd-sec* exits with _errno_(3).

# SEE ALSO

_syd_(1), _syd_(2), _syd_(5), _syd-lock_(1), _syd-mdwe_(1), _syd-ofd_(1), _syd-pds_(1), _PR_GET_SECUREBITS_(2const), _PR_SET_SECUREBITS_(2const)

*syd* homepage: https://sydbox.exherbo.org/

# AUTHORS

Maintained by Ali Polatel. Up-to-date sources can be found at
https://gitlab.exherbo.org/sydbox/sydbox.git and bugs/patches can be
submitted to https://gitlab.exherbo.org/groups/sydbox/-/issues. Discuss
in #sydbox on Libera Chat or in #sydbox:mailstation.de on Matrix.
