#!/bin/bash

KS_BAT_COMMAND="$1"

if [ -z "$KS_BAT_COMMAND" ]; then
	echo "Usage: ./Setup-wine.sh <command>"
	echo "Commands:"
	echo "all   - build everything"
	echo "setup - build installer for Windows"
	echo "test  - compile and run"
	exit 1
fi

# win32 - Qt 5-based for 32/64-bit Windows 7/8/10+
# win64 - Qt 6-based for 64-bit Windows 10+
KS_ARCH=win32
#KS_ARCH=win64

if [ $KS_ARCH == "win32" ]; then
	KS_BAT_SCRIPT=Setup-qt5.bat
	export WINEARCH=win32
	export WINEPREFIX=~/.wine32-kshutdown
else
	KS_BAT_SCRIPT=Setup-qt6.bat
	export WINEARCH=win64
	export WINEPREFIX=~/.wine64-kshutdown
fi

KS_APP_VERSION=$(sed 1!d VERSION)

pushd "$WINEPREFIX/drive_c/kshutdown"
wineconsole "$KS_BAT_SCRIPT" "$KS_APP_VERSION" "$KS_BAT_COMMAND"
popd

rm -f kshutdown-portable/kshutdown.ini
7zz a "kshutdown-portable-${KS_APP_VERSION}-win32.7z" kshutdown-portable
