# Print an optspec for argparse to handle cmd's options that are independent of any subcommand.
function __fish_bite_global_optspecs
	string join \n v/verbose q/quiet h/help V/version
end

function __fish_bite_needs_command
	# Figure out if the current invocation already has a command.
	set -l cmd (commandline -opc)
	set -e cmd[1]
	argparse -s (__fish_bite_global_optspecs) -- $cmd 2>/dev/null
	or return
	if set -q argv[1]
		# Also print the command, so this can be used to figure out what it is.
		echo $argv[1]
		return 1
	end
	return 0
end

function __fish_bite_using_subcommand
	set -l cmd (__fish_bite_needs_command)
	test -z "$cmd"
	and return 1
	contains -- $cmd[1] $argv
end

complete -c bite -n "__fish_bite_needs_command" -s v -l verbose -d 'Increase logging verbosity'
complete -c bite -n "__fish_bite_needs_command" -s q -l quiet -d 'Decrease logging verbosity'
complete -c bite -n "__fish_bite_needs_command" -s h -l help -d 'Print help'
complete -c bite -n "__fish_bite_needs_command" -s V -l version -d 'Print version'
complete -c bite -n "__fish_bite_needs_command" -f -a "bugzilla" -d 'bugzilla service support'
complete -c bite -n "__fish_bite_needs_command" -f -a "github" -d 'github service support'
complete -c bite -n "__fish_bite_needs_command" -f -a "redmine" -d 'redmine service support'
complete -c bite -n "__fish_bite_needs_command" -f -a "completion" -d 'generate shell completion'
complete -c bite -n "__fish_bite_needs_command" -f -a "show" -d 'show service information'
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and not __fish_seen_subcommand_from attachment a comment create c fields get g history search s update u version" -s c -l connection -d 'service connection' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and not __fish_seen_subcommand_from attachment a comment create c fields get g history search s update u version" -s C -l concurrent -d 'concurrent requests limit' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and not __fish_seen_subcommand_from attachment a comment create c fields get g history search s update u version" -l certificate -d 'custom root certificate' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and not __fish_seen_subcommand_from attachment a comment create c fields get g history search s update u version" -l proxy -d 'custom proxy' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and not __fish_seen_subcommand_from attachment a comment create c fields get g history search s update u version" -s t -l timeout -d 'request timeout in seconds' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and not __fish_seen_subcommand_from attachment a comment create c fields get g history search s update u version" -s k -l key -d 'API key' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and not __fish_seen_subcommand_from attachment a comment create c fields get g history search s update u version" -s u -l user -d 'username' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and not __fish_seen_subcommand_from attachment a comment create c fields get g history search s update u version" -s p -l password -d 'password' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and not __fish_seen_subcommand_from attachment a comment create c fields get g history search s update u version" -l insecure -d 'ignore invalid service certificates'
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and not __fish_seen_subcommand_from attachment a comment create c fields get g history search s update u version" -s v -l verbose -d 'Increase logging verbosity'
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and not __fish_seen_subcommand_from attachment a comment create c fields get g history search s update u version" -s q -l quiet -d 'Decrease logging verbosity'
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and not __fish_seen_subcommand_from attachment a comment create c fields get g history search s update u version" -s h -l help -d 'Print help'
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and not __fish_seen_subcommand_from attachment a comment create c fields get g history search s update u version" -f -a "attachment" -d 'Attachment commands'
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and not __fish_seen_subcommand_from attachment a comment create c fields get g history search s update u version" -f -a "a" -d 'Attachment commands'
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and not __fish_seen_subcommand_from attachment a comment create c fields get g history search s update u version" -f -a "comment" -d 'Get bug comments'
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and not __fish_seen_subcommand_from attachment a comment create c fields get g history search s update u version" -f -a "create" -d 'Create bug'
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and not __fish_seen_subcommand_from attachment a comment create c fields get g history search s update u version" -f -a "c" -d 'Create bug'
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and not __fish_seen_subcommand_from attachment a comment create c fields get g history search s update u version" -f -a "fields" -d 'Get bugzilla fields'
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and not __fish_seen_subcommand_from attachment a comment create c fields get g history search s update u version" -f -a "get" -d 'Get bugs'
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and not __fish_seen_subcommand_from attachment a comment create c fields get g history search s update u version" -f -a "g" -d 'Get bugs'
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and not __fish_seen_subcommand_from attachment a comment create c fields get g history search s update u version" -f -a "history" -d 'Get bug changes'
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and not __fish_seen_subcommand_from attachment a comment create c fields get g history search s update u version" -f -a "search" -d 'Search bugs'
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and not __fish_seen_subcommand_from attachment a comment create c fields get g history search s update u version" -f -a "s" -d 'Search bugs'
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and not __fish_seen_subcommand_from attachment a comment create c fields get g history search s update u version" -f -a "update" -d 'Update bugs'
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and not __fish_seen_subcommand_from attachment a comment create c fields get g history search s update u version" -f -a "u" -d 'Update bugs'
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and not __fish_seen_subcommand_from attachment a comment create c fields get g history search s update u version" -f -a "version" -d 'Get bugzilla version'
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from attachment" -s v -l verbose -d 'Increase logging verbosity'
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from attachment" -s q -l quiet -d 'Decrease logging verbosity'
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from attachment" -s h -l help -d 'Print help'
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from attachment" -f -a "create" -d 'Create attachments'
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from attachment" -f -a "c" -d 'Create attachments'
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from attachment" -f -a "get" -d 'Get attachments'
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from attachment" -f -a "g" -d 'Get attachments'
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from attachment" -f -a "update" -d 'Update attachments'
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from attachment" -f -a "u" -d 'Update attachments'
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from a" -s v -l verbose -d 'Increase logging verbosity'
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from a" -s q -l quiet -d 'Decrease logging verbosity'
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from a" -s h -l help -d 'Print help'
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from a" -f -a "create" -d 'Create attachments'
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from a" -f -a "c" -d 'Create attachments'
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from a" -f -a "get" -d 'Get attachments'
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from a" -f -a "g" -d 'Get attachments'
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from a" -f -a "update" -d 'Update attachments'
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from a" -f -a "u" -d 'Update attachments'
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from comment" -s a -l attachment -d 'comment includes attachment' -r -f -a "true\t''
false\t''"
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from comment" -s c -l created -d 'comment created at this time or later' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from comment" -s R -l creator -d 'user who commented' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from comment" -s v -l verbose -d 'Increase logging verbosity'
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from comment" -s q -l quiet -d 'Decrease logging verbosity'
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from comment" -s h -l help -d 'Print help'
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from create" -l from-bug -d 'read attributes from an existing bug' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from create" -l from -d 'read attributes from templates' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from create" -l to -d 'write attributes to template' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from create" -s A -l alias -d 'set aliases' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from create" -s a -l assignee -d 'set assignee' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from create" -s b -l blocks -d 'set blockers' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from create" -l cc -d 'set CC users' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from create" -s C -l component -d 'set component' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from create" -l cf -d 'set custom field' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from create" -s d -l depends -d 'set dependencies' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from create" -s D -l description -d 'set description' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from create" -s F -l flags -d 'set flags' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from create" -s g -l groups -d 'set groups' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from create" -s k -l keywords -d 'set keywords' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from create" -l os -d 'set operating system' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from create" -l platform -d 'set platform' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from create" -l priority -d 'set priority' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from create" -s p -l product -d 'set product' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from create" -l qa -d 'set QA contact' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from create" -s r -l resolution -d 'set resolution' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from create" -s U -l see-also -d 'set external bug URLs' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from create" -l severity -d 'set severity' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from create" -s s -l status -d 'set status' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from create" -s S -l summary -d 'set summary' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from create" -s T -l target -d 'set target milestone' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from create" -s u -l url -d 'set URL' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from create" -s V -l version -d 'set version' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from create" -s w -l whiteboard -d 'set whiteboard' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from create" -s n -l dry-run -d 'skip service interaction'
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from create" -s v -l verbose -d 'Increase logging verbosity'
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from create" -s q -l quiet -d 'Decrease logging verbosity'
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from create" -s h -l help -d 'Print help'
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from c" -l from-bug -d 'read attributes from an existing bug' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from c" -l from -d 'read attributes from templates' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from c" -l to -d 'write attributes to template' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from c" -s A -l alias -d 'set aliases' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from c" -s a -l assignee -d 'set assignee' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from c" -s b -l blocks -d 'set blockers' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from c" -l cc -d 'set CC users' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from c" -s C -l component -d 'set component' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from c" -l cf -d 'set custom field' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from c" -s d -l depends -d 'set dependencies' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from c" -s D -l description -d 'set description' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from c" -s F -l flags -d 'set flags' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from c" -s g -l groups -d 'set groups' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from c" -s k -l keywords -d 'set keywords' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from c" -l os -d 'set operating system' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from c" -l platform -d 'set platform' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from c" -l priority -d 'set priority' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from c" -s p -l product -d 'set product' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from c" -l qa -d 'set QA contact' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from c" -s r -l resolution -d 'set resolution' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from c" -s U -l see-also -d 'set external bug URLs' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from c" -l severity -d 'set severity' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from c" -s s -l status -d 'set status' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from c" -s S -l summary -d 'set summary' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from c" -s T -l target -d 'set target milestone' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from c" -s u -l url -d 'set URL' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from c" -s V -l version -d 'set version' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from c" -s w -l whiteboard -d 'set whiteboard' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from c" -s n -l dry-run -d 'skip service interaction'
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from c" -s v -l verbose -d 'Increase logging verbosity'
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from c" -s q -l quiet -d 'Decrease logging verbosity'
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from c" -s h -l help -d 'Print help'
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from fields" -s v -l verbose -d 'Increase logging verbosity'
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from fields" -s q -l quiet -d 'Decrease logging verbosity'
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from fields" -s h -l help -d 'Print help'
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from get" -s A -l no-attachments -d 'disable attachments'
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from get" -s C -l no-comments -d 'disable comments'
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from get" -s H -l no-history -d 'disable history'
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from get" -s b -l browser -d 'open in browser'
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from get" -s v -l verbose -d 'Increase logging verbosity'
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from get" -s q -l quiet -d 'Decrease logging verbosity'
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from get" -s h -l help -d 'Print help'
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from g" -s A -l no-attachments -d 'disable attachments'
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from g" -s C -l no-comments -d 'disable comments'
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from g" -s H -l no-history -d 'disable history'
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from g" -s b -l browser -d 'open in browser'
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from g" -s v -l verbose -d 'Increase logging verbosity'
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from g" -s q -l quiet -d 'Decrease logging verbosity'
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from g" -s h -l help -d 'Print help'
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from history" -s c -l created -d 'event occurred at this time or later' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from history" -s R -l creator -d 'user who made change' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from history" -s v -l verbose -d 'Increase logging verbosity'
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from history" -s q -l quiet -d 'Decrease logging verbosity'
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from history" -s h -l help -d 'Print help'
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from search" -l from -d 'read attributes from templates' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from search" -l to -d 'write attributes to template' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from search" -s f -l fields -d 'fields to output' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from search" -s l -l limit -d 'limit result count' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from search" -s O -l offset -d 'result starting position' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from search" -s o -l order -d 'order query results' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from search" -s S -l quicksearch -d 'search using quicksearch syntax' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from search" -s A -l alias -d 'restrict by alias' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from search" -s @ -l attachments -d 'restrict by attachments' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from search" -s B -l blocks -d 'restrict by blockers' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from search" -s C -l component -d 'restrict by component' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from search" -l cf -d 'restrict by custom field' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from search" -s D -l depends -d 'restrict by dependencies' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from search" -s F -l flags -d 'restrict by flag' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from search" -s g -l groups -d 'restrict by group' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from search" -l id -d 'restrict by ID' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from search" -s k -l keywords -d 'restrict by keyword' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from search" -l os -d 'restrict by operating system' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from search" -l platform -d 'restrict by platform' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from search" -l priority -d 'restrict by priority' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from search" -s p -l product -d 'restrict by product' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from search" -s r -l resolution -d 'restrict by resolution' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from search" -s U -l see-also -d 'restrict by tracker URLs' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from search" -l severity -d 'restrict by severity' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from search" -s s -l status -d 'restrict by status' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from search" -s t -l tags -d 'restrict by personal tags' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from search" -s T -l target -d 'restrict by target milestone' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from search" -l url -d 'restrict by URL' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from search" -s V -l version -d 'restrict by version' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from search" -s w -l whiteboard -d 'restrict by whiteboard' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from search" -l attachment-description -d 'restrict by description' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from search" -l attachment-filename -d 'restrict by file name' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from search" -l attachment-mime -d 'restrict by MIME type' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from search" -l attachment-is-obsolete -d 'restrict by obsolete status' -r -f -a "true\t''
false\t''"
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from search" -l attachment-is-patch -d 'restrict by patch status' -r -f -a "true\t''
false\t''"
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from search" -l attachment-is-private -d 'restrict by private status' -r -f -a "true\t''
false\t''"
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from search" -l comments -d 'restrict by comment count' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from search" -l votes -d 'restrict by vote count' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from search" -l changed -d 'fields changed within time interval' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from search" -l changed-by -d 'fields changed by users' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from search" -l changed-from -d 'fields changed from value' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from search" -l changed-to -d 'fields changed to value' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from search" -s c -l created -d 'restrict by creation time' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from search" -s u -l updated -d 'restrict by update time' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from search" -l closed -d 'restrict by closed time' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from search" -s a -l assignee -d 'user is assignee' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from search" -l attacher -d 'user created attachment' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from search" -l cc -d 'user in CC list' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from search" -l commenter -d 'user who commented' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from search" -l flagger -d 'user who set flag' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from search" -l qa -d 'user is QA contact' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from search" -s R -l reporter -d 'user who reported' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from search" -l comment -d 'restrict by comment content' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from search" -l comment-is-private -d 'restrict by private status' -r -f -a "true\t''
false\t''"
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from search" -l comment-tag -d 'restrict by tag' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from search" -s b -l browser -d 'open in browser'
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from search" -l json -d 'output in JSON format'
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from search" -s n -l dry-run -d 'skip service interaction'
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from search" -l paged -d 'enable paging support'
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from search" -s v -l verbose -d 'Increase logging verbosity'
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from search" -s q -l quiet -d 'Decrease logging verbosity'
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from search" -s h -l help -d 'Print help'
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from s" -l from -d 'read attributes from templates' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from s" -l to -d 'write attributes to template' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from s" -s f -l fields -d 'fields to output' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from s" -s l -l limit -d 'limit result count' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from s" -s O -l offset -d 'result starting position' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from s" -s o -l order -d 'order query results' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from s" -s S -l quicksearch -d 'search using quicksearch syntax' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from s" -s A -l alias -d 'restrict by alias' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from s" -s @ -l attachments -d 'restrict by attachments' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from s" -s B -l blocks -d 'restrict by blockers' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from s" -s C -l component -d 'restrict by component' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from s" -l cf -d 'restrict by custom field' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from s" -s D -l depends -d 'restrict by dependencies' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from s" -s F -l flags -d 'restrict by flag' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from s" -s g -l groups -d 'restrict by group' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from s" -l id -d 'restrict by ID' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from s" -s k -l keywords -d 'restrict by keyword' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from s" -l os -d 'restrict by operating system' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from s" -l platform -d 'restrict by platform' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from s" -l priority -d 'restrict by priority' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from s" -s p -l product -d 'restrict by product' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from s" -s r -l resolution -d 'restrict by resolution' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from s" -s U -l see-also -d 'restrict by tracker URLs' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from s" -l severity -d 'restrict by severity' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from s" -s s -l status -d 'restrict by status' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from s" -s t -l tags -d 'restrict by personal tags' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from s" -s T -l target -d 'restrict by target milestone' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from s" -l url -d 'restrict by URL' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from s" -s V -l version -d 'restrict by version' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from s" -s w -l whiteboard -d 'restrict by whiteboard' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from s" -l attachment-description -d 'restrict by description' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from s" -l attachment-filename -d 'restrict by file name' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from s" -l attachment-mime -d 'restrict by MIME type' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from s" -l attachment-is-obsolete -d 'restrict by obsolete status' -r -f -a "true\t''
false\t''"
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from s" -l attachment-is-patch -d 'restrict by patch status' -r -f -a "true\t''
false\t''"
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from s" -l attachment-is-private -d 'restrict by private status' -r -f -a "true\t''
false\t''"
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from s" -l comments -d 'restrict by comment count' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from s" -l votes -d 'restrict by vote count' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from s" -l changed -d 'fields changed within time interval' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from s" -l changed-by -d 'fields changed by users' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from s" -l changed-from -d 'fields changed from value' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from s" -l changed-to -d 'fields changed to value' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from s" -s c -l created -d 'restrict by creation time' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from s" -s u -l updated -d 'restrict by update time' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from s" -l closed -d 'restrict by closed time' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from s" -s a -l assignee -d 'user is assignee' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from s" -l attacher -d 'user created attachment' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from s" -l cc -d 'user in CC list' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from s" -l commenter -d 'user who commented' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from s" -l flagger -d 'user who set flag' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from s" -l qa -d 'user is QA contact' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from s" -s R -l reporter -d 'user who reported' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from s" -l comment -d 'restrict by comment content' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from s" -l comment-is-private -d 'restrict by private status' -r -f -a "true\t''
false\t''"
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from s" -l comment-tag -d 'restrict by tag' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from s" -s b -l browser -d 'open in browser'
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from s" -l json -d 'output in JSON format'
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from s" -s n -l dry-run -d 'skip service interaction'
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from s" -l paged -d 'enable paging support'
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from s" -s v -l verbose -d 'Increase logging verbosity'
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from s" -s q -l quiet -d 'Decrease logging verbosity'
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from s" -s h -l help -d 'Print help'
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from update" -s R -l reply -d 'reply to specific comments' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from update" -l from -d 'read attributes from templates' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from update" -l to -d 'write attributes to template' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from update" -s A -l alias -d 'add/remove/set aliases' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from update" -s a -l assignee -d 'update assignee' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from update" -s b -l blocks -d 'add/remove/set blockers' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from update" -l cc -d 'add/remove CC users' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from update" -s c -l comment -d 'add comment' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from update" -s F -l comment-from -d 'add comment from file' -r -F
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from update" -l comment-privacy -d 'update comment privacy' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from update" -s C -l component -d 'update component' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from update" -l cf -d 'update custom field' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from update" -s d -l depends -d 'add/remove/set dependencies' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from update" -s D -l duplicate-of -d 'mark bug as duplicate' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from update" -s f -l flags -d 'add/remove flags' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from update" -s g -l groups -d 'add/remove groups' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from update" -s k -l keywords -d 'add/remove/set keywords' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from update" -l os -d 'update operating system' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from update" -l platform -d 'update platform' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from update" -l priority -d 'update priority' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from update" -s p -l product -d 'update product' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from update" -l qa -d 'update QA contact' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from update" -s r -l resolution -d 'update resolution' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from update" -s U -l see-also -d 'add/remove bug URLs' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from update" -l severity -d 'update severity' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from update" -s s -l status -d 'update status' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from update" -s S -l summary -d 'update summary' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from update" -s T -l target -d 'update target milestone' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from update" -s u -l url -d 'update URL' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from update" -s V -l version -d 'update version' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from update" -s w -l whiteboard -d 'update whiteboard' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from update" -s n -l dry-run -d 'skip service interaction'
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from update" -s P -l comment-is-private -d 'enable comment privacy'
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from update" -s v -l verbose -d 'Increase logging verbosity'
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from update" -s q -l quiet -d 'Decrease logging verbosity'
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from update" -s h -l help -d 'Print help'
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from u" -s R -l reply -d 'reply to specific comments' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from u" -l from -d 'read attributes from templates' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from u" -l to -d 'write attributes to template' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from u" -s A -l alias -d 'add/remove/set aliases' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from u" -s a -l assignee -d 'update assignee' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from u" -s b -l blocks -d 'add/remove/set blockers' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from u" -l cc -d 'add/remove CC users' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from u" -s c -l comment -d 'add comment' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from u" -s F -l comment-from -d 'add comment from file' -r -F
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from u" -l comment-privacy -d 'update comment privacy' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from u" -s C -l component -d 'update component' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from u" -l cf -d 'update custom field' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from u" -s d -l depends -d 'add/remove/set dependencies' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from u" -s D -l duplicate-of -d 'mark bug as duplicate' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from u" -s f -l flags -d 'add/remove flags' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from u" -s g -l groups -d 'add/remove groups' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from u" -s k -l keywords -d 'add/remove/set keywords' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from u" -l os -d 'update operating system' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from u" -l platform -d 'update platform' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from u" -l priority -d 'update priority' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from u" -s p -l product -d 'update product' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from u" -l qa -d 'update QA contact' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from u" -s r -l resolution -d 'update resolution' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from u" -s U -l see-also -d 'add/remove bug URLs' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from u" -l severity -d 'update severity' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from u" -s s -l status -d 'update status' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from u" -s S -l summary -d 'update summary' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from u" -s T -l target -d 'update target milestone' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from u" -s u -l url -d 'update URL' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from u" -s V -l version -d 'update version' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from u" -s w -l whiteboard -d 'update whiteboard' -r
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from u" -s n -l dry-run -d 'skip service interaction'
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from u" -s P -l comment-is-private -d 'enable comment privacy'
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from u" -s v -l verbose -d 'Increase logging verbosity'
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from u" -s q -l quiet -d 'Decrease logging verbosity'
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from u" -s h -l help -d 'Print help'
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from version" -s v -l verbose -d 'Increase logging verbosity'
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from version" -s q -l quiet -d 'Decrease logging verbosity'
complete -c bite -n "__fish_bite_using_subcommand bugzilla; and __fish_seen_subcommand_from version" -s h -l help -d 'Print help'
complete -c bite -n "__fish_bite_using_subcommand github; and not __fish_seen_subcommand_from get g search s" -s c -l connection -d 'service connection' -r
complete -c bite -n "__fish_bite_using_subcommand github; and not __fish_seen_subcommand_from get g search s" -s C -l concurrent -d 'concurrent requests limit' -r
complete -c bite -n "__fish_bite_using_subcommand github; and not __fish_seen_subcommand_from get g search s" -l certificate -d 'custom root certificate' -r
complete -c bite -n "__fish_bite_using_subcommand github; and not __fish_seen_subcommand_from get g search s" -l proxy -d 'custom proxy' -r
complete -c bite -n "__fish_bite_using_subcommand github; and not __fish_seen_subcommand_from get g search s" -s t -l timeout -d 'request timeout in seconds' -r
complete -c bite -n "__fish_bite_using_subcommand github; and not __fish_seen_subcommand_from get g search s" -s k -l key -d 'GitHub personal access token' -r
complete -c bite -n "__fish_bite_using_subcommand github; and not __fish_seen_subcommand_from get g search s" -s u -l user -d 'username' -r
complete -c bite -n "__fish_bite_using_subcommand github; and not __fish_seen_subcommand_from get g search s" -l insecure -d 'ignore invalid service certificates'
complete -c bite -n "__fish_bite_using_subcommand github; and not __fish_seen_subcommand_from get g search s" -s v -l verbose -d 'Increase logging verbosity'
complete -c bite -n "__fish_bite_using_subcommand github; and not __fish_seen_subcommand_from get g search s" -s q -l quiet -d 'Decrease logging verbosity'
complete -c bite -n "__fish_bite_using_subcommand github; and not __fish_seen_subcommand_from get g search s" -s h -l help -d 'Print help'
complete -c bite -n "__fish_bite_using_subcommand github; and not __fish_seen_subcommand_from get g search s" -f -a "get" -d 'Get issues'
complete -c bite -n "__fish_bite_using_subcommand github; and not __fish_seen_subcommand_from get g search s" -f -a "g" -d 'Get issues'
complete -c bite -n "__fish_bite_using_subcommand github; and not __fish_seen_subcommand_from get g search s" -f -a "search" -d 'Search issues'
complete -c bite -n "__fish_bite_using_subcommand github; and not __fish_seen_subcommand_from get g search s" -f -a "s" -d 'Search issues'
complete -c bite -n "__fish_bite_using_subcommand github; and __fish_seen_subcommand_from get" -s b -l browser -d 'open in browser'
complete -c bite -n "__fish_bite_using_subcommand github; and __fish_seen_subcommand_from get" -s v -l verbose -d 'Increase logging verbosity'
complete -c bite -n "__fish_bite_using_subcommand github; and __fish_seen_subcommand_from get" -s q -l quiet -d 'Decrease logging verbosity'
complete -c bite -n "__fish_bite_using_subcommand github; and __fish_seen_subcommand_from get" -s h -l help -d 'Print help'
complete -c bite -n "__fish_bite_using_subcommand github; and __fish_seen_subcommand_from g" -s b -l browser -d 'open in browser'
complete -c bite -n "__fish_bite_using_subcommand github; and __fish_seen_subcommand_from g" -s v -l verbose -d 'Increase logging verbosity'
complete -c bite -n "__fish_bite_using_subcommand github; and __fish_seen_subcommand_from g" -s q -l quiet -d 'Decrease logging verbosity'
complete -c bite -n "__fish_bite_using_subcommand github; and __fish_seen_subcommand_from g" -s h -l help -d 'Print help'
complete -c bite -n "__fish_bite_using_subcommand github; and __fish_seen_subcommand_from search" -s F -l fields -d 'fields to output' -r
complete -c bite -n "__fish_bite_using_subcommand github; and __fish_seen_subcommand_from search" -s S -l order -d 'sorting order for search query' -r
complete -c bite -n "__fish_bite_using_subcommand github; and __fish_seen_subcommand_from search" -s v -l verbose -d 'Increase logging verbosity'
complete -c bite -n "__fish_bite_using_subcommand github; and __fish_seen_subcommand_from search" -s q -l quiet -d 'Decrease logging verbosity'
complete -c bite -n "__fish_bite_using_subcommand github; and __fish_seen_subcommand_from search" -s h -l help -d 'Print help'
complete -c bite -n "__fish_bite_using_subcommand github; and __fish_seen_subcommand_from s" -s F -l fields -d 'fields to output' -r
complete -c bite -n "__fish_bite_using_subcommand github; and __fish_seen_subcommand_from s" -s S -l order -d 'sorting order for search query' -r
complete -c bite -n "__fish_bite_using_subcommand github; and __fish_seen_subcommand_from s" -s v -l verbose -d 'Increase logging verbosity'
complete -c bite -n "__fish_bite_using_subcommand github; and __fish_seen_subcommand_from s" -s q -l quiet -d 'Decrease logging verbosity'
complete -c bite -n "__fish_bite_using_subcommand github; and __fish_seen_subcommand_from s" -s h -l help -d 'Print help'
complete -c bite -n "__fish_bite_using_subcommand redmine; and not __fish_seen_subcommand_from get g search s" -s c -l connection -d 'service connection' -r
complete -c bite -n "__fish_bite_using_subcommand redmine; and not __fish_seen_subcommand_from get g search s" -s C -l concurrent -d 'concurrent requests limit' -r
complete -c bite -n "__fish_bite_using_subcommand redmine; and not __fish_seen_subcommand_from get g search s" -l certificate -d 'custom root certificate' -r
complete -c bite -n "__fish_bite_using_subcommand redmine; and not __fish_seen_subcommand_from get g search s" -l proxy -d 'custom proxy' -r
complete -c bite -n "__fish_bite_using_subcommand redmine; and not __fish_seen_subcommand_from get g search s" -s t -l timeout -d 'request timeout in seconds' -r
complete -c bite -n "__fish_bite_using_subcommand redmine; and not __fish_seen_subcommand_from get g search s" -s k -l key -d 'API key' -r
complete -c bite -n "__fish_bite_using_subcommand redmine; and not __fish_seen_subcommand_from get g search s" -s u -l user -d 'username' -r
complete -c bite -n "__fish_bite_using_subcommand redmine; and not __fish_seen_subcommand_from get g search s" -s p -l password -d 'password' -r
complete -c bite -n "__fish_bite_using_subcommand redmine; and not __fish_seen_subcommand_from get g search s" -l insecure -d 'ignore invalid service certificates'
complete -c bite -n "__fish_bite_using_subcommand redmine; and not __fish_seen_subcommand_from get g search s" -s v -l verbose -d 'Increase logging verbosity'
complete -c bite -n "__fish_bite_using_subcommand redmine; and not __fish_seen_subcommand_from get g search s" -s q -l quiet -d 'Decrease logging verbosity'
complete -c bite -n "__fish_bite_using_subcommand redmine; and not __fish_seen_subcommand_from get g search s" -s h -l help -d 'Print help'
complete -c bite -n "__fish_bite_using_subcommand redmine; and not __fish_seen_subcommand_from get g search s" -f -a "get" -d 'Get issues'
complete -c bite -n "__fish_bite_using_subcommand redmine; and not __fish_seen_subcommand_from get g search s" -f -a "g" -d 'Get issues'
complete -c bite -n "__fish_bite_using_subcommand redmine; and not __fish_seen_subcommand_from get g search s" -f -a "search" -d 'Search issues'
complete -c bite -n "__fish_bite_using_subcommand redmine; and not __fish_seen_subcommand_from get g search s" -f -a "s" -d 'Search issues'
complete -c bite -n "__fish_bite_using_subcommand redmine; and __fish_seen_subcommand_from get" -s C -l no-comments -d 'disable comments'
complete -c bite -n "__fish_bite_using_subcommand redmine; and __fish_seen_subcommand_from get" -s b -l browser -d 'open in browser'
complete -c bite -n "__fish_bite_using_subcommand redmine; and __fish_seen_subcommand_from get" -s v -l verbose -d 'Increase logging verbosity'
complete -c bite -n "__fish_bite_using_subcommand redmine; and __fish_seen_subcommand_from get" -s q -l quiet -d 'Decrease logging verbosity'
complete -c bite -n "__fish_bite_using_subcommand redmine; and __fish_seen_subcommand_from get" -s h -l help -d 'Print help'
complete -c bite -n "__fish_bite_using_subcommand redmine; and __fish_seen_subcommand_from g" -s C -l no-comments -d 'disable comments'
complete -c bite -n "__fish_bite_using_subcommand redmine; and __fish_seen_subcommand_from g" -s b -l browser -d 'open in browser'
complete -c bite -n "__fish_bite_using_subcommand redmine; and __fish_seen_subcommand_from g" -s v -l verbose -d 'Increase logging verbosity'
complete -c bite -n "__fish_bite_using_subcommand redmine; and __fish_seen_subcommand_from g" -s q -l quiet -d 'Decrease logging verbosity'
complete -c bite -n "__fish_bite_using_subcommand redmine; and __fish_seen_subcommand_from g" -s h -l help -d 'Print help'
complete -c bite -n "__fish_bite_using_subcommand redmine; and __fish_seen_subcommand_from search" -l from -d 'read attributes from templates' -r
complete -c bite -n "__fish_bite_using_subcommand redmine; and __fish_seen_subcommand_from search" -l to -d 'write attributes to template' -r
complete -c bite -n "__fish_bite_using_subcommand redmine; and __fish_seen_subcommand_from search" -s f -l fields -d 'fields to output' -r
complete -c bite -n "__fish_bite_using_subcommand redmine; and __fish_seen_subcommand_from search" -s l -l limit -d 'limit result count' -r
complete -c bite -n "__fish_bite_using_subcommand redmine; and __fish_seen_subcommand_from search" -s O -l offset -d 'result starting position' -r
complete -c bite -n "__fish_bite_using_subcommand redmine; and __fish_seen_subcommand_from search" -s o -l order -d 'order query results' -r
complete -c bite -n "__fish_bite_using_subcommand redmine; and __fish_seen_subcommand_from search" -l paged -d 'enable paging support' -r -f -a "true\t''
false\t''"
complete -c bite -n "__fish_bite_using_subcommand redmine; and __fish_seen_subcommand_from search" -s a -l assignee -d 'restrict by assignee status' -r -f -a "true\t''
false\t''"
complete -c bite -n "__fish_bite_using_subcommand redmine; and __fish_seen_subcommand_from search" -s @ -l attachments -d 'restrict by attachments' -r
complete -c bite -n "__fish_bite_using_subcommand redmine; and __fish_seen_subcommand_from search" -s B -l blocks -d 'restrict by blockers' -r
complete -c bite -n "__fish_bite_using_subcommand redmine; and __fish_seen_subcommand_from search" -s D -l blocked -d 'restrict by dependencies' -r
complete -c bite -n "__fish_bite_using_subcommand redmine; and __fish_seen_subcommand_from search" -s R -l relates -d 'restrict by relations' -r
complete -c bite -n "__fish_bite_using_subcommand redmine; and __fish_seen_subcommand_from search" -l id -d 'restrict by ID' -r
complete -c bite -n "__fish_bite_using_subcommand redmine; and __fish_seen_subcommand_from search" -s s -l status -d 'restrict by status' -r -f -a "@open\t''
@closed\t''
@any\t''"
complete -c bite -n "__fish_bite_using_subcommand redmine; and __fish_seen_subcommand_from search" -s c -l created -d 'restrict by creation time' -r
complete -c bite -n "__fish_bite_using_subcommand redmine; and __fish_seen_subcommand_from search" -s u -l updated -d 'restrict by update time' -r
complete -c bite -n "__fish_bite_using_subcommand redmine; and __fish_seen_subcommand_from search" -s C -l closed -d 'restrict by closed time' -r
complete -c bite -n "__fish_bite_using_subcommand redmine; and __fish_seen_subcommand_from search" -s b -l browser -d 'open in browser'
complete -c bite -n "__fish_bite_using_subcommand redmine; and __fish_seen_subcommand_from search" -l json -d 'output in JSON format'
complete -c bite -n "__fish_bite_using_subcommand redmine; and __fish_seen_subcommand_from search" -s n -l dry-run -d 'skip service interaction'
complete -c bite -n "__fish_bite_using_subcommand redmine; and __fish_seen_subcommand_from search" -s v -l verbose -d 'Increase logging verbosity'
complete -c bite -n "__fish_bite_using_subcommand redmine; and __fish_seen_subcommand_from search" -s q -l quiet -d 'Decrease logging verbosity'
complete -c bite -n "__fish_bite_using_subcommand redmine; and __fish_seen_subcommand_from search" -s h -l help -d 'Print help'
complete -c bite -n "__fish_bite_using_subcommand redmine; and __fish_seen_subcommand_from s" -l from -d 'read attributes from templates' -r
complete -c bite -n "__fish_bite_using_subcommand redmine; and __fish_seen_subcommand_from s" -l to -d 'write attributes to template' -r
complete -c bite -n "__fish_bite_using_subcommand redmine; and __fish_seen_subcommand_from s" -s f -l fields -d 'fields to output' -r
complete -c bite -n "__fish_bite_using_subcommand redmine; and __fish_seen_subcommand_from s" -s l -l limit -d 'limit result count' -r
complete -c bite -n "__fish_bite_using_subcommand redmine; and __fish_seen_subcommand_from s" -s O -l offset -d 'result starting position' -r
complete -c bite -n "__fish_bite_using_subcommand redmine; and __fish_seen_subcommand_from s" -s o -l order -d 'order query results' -r
complete -c bite -n "__fish_bite_using_subcommand redmine; and __fish_seen_subcommand_from s" -l paged -d 'enable paging support' -r -f -a "true\t''
false\t''"
complete -c bite -n "__fish_bite_using_subcommand redmine; and __fish_seen_subcommand_from s" -s a -l assignee -d 'restrict by assignee status' -r -f -a "true\t''
false\t''"
complete -c bite -n "__fish_bite_using_subcommand redmine; and __fish_seen_subcommand_from s" -s @ -l attachments -d 'restrict by attachments' -r
complete -c bite -n "__fish_bite_using_subcommand redmine; and __fish_seen_subcommand_from s" -s B -l blocks -d 'restrict by blockers' -r
complete -c bite -n "__fish_bite_using_subcommand redmine; and __fish_seen_subcommand_from s" -s D -l blocked -d 'restrict by dependencies' -r
complete -c bite -n "__fish_bite_using_subcommand redmine; and __fish_seen_subcommand_from s" -s R -l relates -d 'restrict by relations' -r
complete -c bite -n "__fish_bite_using_subcommand redmine; and __fish_seen_subcommand_from s" -l id -d 'restrict by ID' -r
complete -c bite -n "__fish_bite_using_subcommand redmine; and __fish_seen_subcommand_from s" -s s -l status -d 'restrict by status' -r -f -a "@open\t''
@closed\t''
@any\t''"
complete -c bite -n "__fish_bite_using_subcommand redmine; and __fish_seen_subcommand_from s" -s c -l created -d 'restrict by creation time' -r
complete -c bite -n "__fish_bite_using_subcommand redmine; and __fish_seen_subcommand_from s" -s u -l updated -d 'restrict by update time' -r
complete -c bite -n "__fish_bite_using_subcommand redmine; and __fish_seen_subcommand_from s" -s C -l closed -d 'restrict by closed time' -r
complete -c bite -n "__fish_bite_using_subcommand redmine; and __fish_seen_subcommand_from s" -s b -l browser -d 'open in browser'
complete -c bite -n "__fish_bite_using_subcommand redmine; and __fish_seen_subcommand_from s" -l json -d 'output in JSON format'
complete -c bite -n "__fish_bite_using_subcommand redmine; and __fish_seen_subcommand_from s" -s n -l dry-run -d 'skip service interaction'
complete -c bite -n "__fish_bite_using_subcommand redmine; and __fish_seen_subcommand_from s" -s v -l verbose -d 'Increase logging verbosity'
complete -c bite -n "__fish_bite_using_subcommand redmine; and __fish_seen_subcommand_from s" -s q -l quiet -d 'Decrease logging verbosity'
complete -c bite -n "__fish_bite_using_subcommand redmine; and __fish_seen_subcommand_from s" -s h -l help -d 'Print help'
complete -c bite -n "__fish_bite_using_subcommand completion" -s d -l dir -d 'Target directory for completion files' -r
complete -c bite -n "__fish_bite_using_subcommand completion" -s v -l verbose -d 'Increase logging verbosity'
complete -c bite -n "__fish_bite_using_subcommand completion" -s q -l quiet -d 'Decrease logging verbosity'
complete -c bite -n "__fish_bite_using_subcommand completion" -s h -l help -d 'Print help'
complete -c bite -n "__fish_bite_using_subcommand show; and not __fish_seen_subcommand_from connections services" -s v -l verbose -d 'Increase logging verbosity'
complete -c bite -n "__fish_bite_using_subcommand show; and not __fish_seen_subcommand_from connections services" -s q -l quiet -d 'Decrease logging verbosity'
complete -c bite -n "__fish_bite_using_subcommand show; and not __fish_seen_subcommand_from connections services" -s h -l help -d 'Print help'
complete -c bite -n "__fish_bite_using_subcommand show; and not __fish_seen_subcommand_from connections services" -f -a "connections" -d 'Show available connections'
complete -c bite -n "__fish_bite_using_subcommand show; and not __fish_seen_subcommand_from connections services" -f -a "services" -d 'Show available services'
complete -c bite -n "__fish_bite_using_subcommand show; and __fish_seen_subcommand_from connections" -s v -l verbose -d 'Increase logging verbosity'
complete -c bite -n "__fish_bite_using_subcommand show; and __fish_seen_subcommand_from connections" -s q -l quiet -d 'Decrease logging verbosity'
complete -c bite -n "__fish_bite_using_subcommand show; and __fish_seen_subcommand_from connections" -s h -l help -d 'Print help'
complete -c bite -n "__fish_bite_using_subcommand show; and __fish_seen_subcommand_from services" -s v -l verbose -d 'Increase logging verbosity'
complete -c bite -n "__fish_bite_using_subcommand show; and __fish_seen_subcommand_from services" -s q -l quiet -d 'Decrease logging verbosity'
complete -c bite -n "__fish_bite_using_subcommand show; and __fish_seen_subcommand_from services" -s h -l help -d 'Print help'
