/*
Copyright The KubeVirt Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	"context"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	gentype "k8s.io/client-go/gentype"
	v1alpha1 "kubevirt.io/api/instancetype/v1alpha1"
	scheme "kubevirt.io/client-go/kubevirt/scheme"
)

// VirtualMachinePreferencesGetter has a method to return a VirtualMachinePreferenceInterface.
// A group's client should implement this interface.
type VirtualMachinePreferencesGetter interface {
	VirtualMachinePreferences(namespace string) VirtualMachinePreferenceInterface
}

// VirtualMachinePreferenceInterface has methods to work with VirtualMachinePreference resources.
type VirtualMachinePreferenceInterface interface {
	Create(ctx context.Context, virtualMachinePreference *v1alpha1.VirtualMachinePreference, opts v1.CreateOptions) (*v1alpha1.VirtualMachinePreference, error)
	Update(ctx context.Context, virtualMachinePreference *v1alpha1.VirtualMachinePreference, opts v1.UpdateOptions) (*v1alpha1.VirtualMachinePreference, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*v1alpha1.VirtualMachinePreference, error)
	List(ctx context.Context, opts v1.ListOptions) (*v1alpha1.VirtualMachinePreferenceList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.VirtualMachinePreference, err error)
	VirtualMachinePreferenceExpansion
}

// virtualMachinePreferences implements VirtualMachinePreferenceInterface
type virtualMachinePreferences struct {
	*gentype.ClientWithList[*v1alpha1.VirtualMachinePreference, *v1alpha1.VirtualMachinePreferenceList]
}

// newVirtualMachinePreferences returns a VirtualMachinePreferences
func newVirtualMachinePreferences(c *InstancetypeV1alpha1Client, namespace string) *virtualMachinePreferences {
	return &virtualMachinePreferences{
		gentype.NewClientWithList[*v1alpha1.VirtualMachinePreference, *v1alpha1.VirtualMachinePreferenceList](
			"virtualmachinepreferences",
			c.RESTClient(),
			scheme.ParameterCodec,
			namespace,
			func() *v1alpha1.VirtualMachinePreference { return &v1alpha1.VirtualMachinePreference{} },
			func() *v1alpha1.VirtualMachinePreferenceList { return &v1alpha1.VirtualMachinePreferenceList{} }),
	}
}
