/*
 * Copyright (C) 2012 Oracle.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see http://www.gnu.org/copyleft/gpl.txt
 */

/*
 * Store the states at the start of the function because this is something that
 * is used in a couple places.
 *
 */

#include "smatch.h"
#include "smatch_slist.h"

static int my_id;

static struct stree *start_states;
static void save_start_states(struct statement *stmt)
{
	start_states = clone_stree(__get_cur_stree());
}

static void match_end_func(void)
{
	free_stree(&start_states);
}

struct stree *get_start_states(void)
{
	return start_states;
}

void register_start_states(int id)
{
	my_id = id;

	add_hook(&save_start_states, AFTER_DEF_HOOK);
	add_function_data((unsigned long *)&start_states);
	add_hook(&match_end_func, AFTER_FUNC_HOOK);
}

