/*
MIT License

Copyright (c) 2019 - 2024 Advanced Micro Devices, Inc.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
*/

#ifndef RPP_RNG_SEED_STREAM_H
#define RPP_RNG_SEED_STREAM_H

#include <rppdefs.h>
#define SEED_STREAM_MAX_SIZE 4050

alignas(64) Rpp32u rngSeedStream4050[SEED_STREAM_MAX_SIZE] = {
764129, 618740, 582752, 692507, 789955, 785851, 112601, 380578, 896709, 549581, 965817, 162355, 338288, 502799, 447091, 144368, 163130, 717741, 150842, 376320, 241741, 177798, 584469, 620725, 812482,
125948, 712195, 171647, 734259, 318909, 530081, 752344, 134681, 976179, 596526, 768118, 926256, 586994, 583726, 931896, 164391, 257965, 194286, 344998, 859147, 928669, 765093, 514952, 375650, 573219,
316707, 254968, 946657, 111935, 170126, 710776, 386138, 165523, 260376, 872164, 303180, 137553, 767258, 149950, 208631, 762140, 381674, 723139, 474377, 609227, 251119, 861729, 993061, 869503, 666490,
654374, 165281, 993562, 697408, 173261, 470527, 913834, 115657, 237411, 822412, 641444, 520964, 257480, 316895, 417680, 194095, 959682, 720996, 429463, 536770, 410526, 149233, 261533, 637888, 942188,
459507, 147323, 399338, 123803, 392809, 759636, 475405, 492850, 210111, 381734, 562751, 380557, 378296, 921788, 695272, 699281, 116171, 167887, 911615, 627320, 876768, 498707, 123213, 904096, 108813,
874764, 452787, 411222, 612006, 778359, 961528, 748196, 314769, 761324, 677344, 748118, 404033, 808820, 714517, 944048, 516198, 291780, 437928, 185870, 206478, 800148, 805348, 196541, 481659, 524442,
423634, 569045, 796278, 155563, 998450, 842799, 971867, 252645, 142292, 455544, 154569, 423928, 946575, 872640, 828501, 971702, 199042, 232227, 888972, 708740, 538460, 717819, 212202, 564106, 536613,
539694, 892686, 868448, 743274, 497277, 179610, 999952, 389584, 687160, 637134, 233594, 622243, 136717, 185923, 379930, 151323, 463493, 100662, 192639, 559123, 287705, 823098, 113425, 870338, 463965,
450246, 849407, 609176, 584330, 243828, 986133, 453738, 120506, 782485, 135091, 771512, 581505, 131005, 165693, 639547, 849907, 222565, 340381, 117417, 653591, 385082, 829484, 899801, 310610, 261151,
424453, 568121, 302971, 870990, 346606, 214659, 164298, 134062, 818679, 293046, 469916, 712286, 140999, 121266, 187182, 105621, 196841, 371930, 590182, 947656, 826214, 588790, 466174, 242101, 758380,
832662, 448306, 710146, 783259, 246540, 160560, 154771, 378883, 699197, 682211, 776611, 173348, 705510, 782967, 743801, 316936, 870965, 675957, 376881, 316931, 142351, 209981, 892744, 770240, 689539,
910637, 136733, 689799, 198802, 220902, 141347, 817997, 190097, 604758, 521225, 118382, 132954, 997296, 697366, 180657, 599342, 462421, 367816, 561311, 213273, 783978, 140743, 329477, 145124, 370273,
239196, 864665, 638664, 482919, 211713, 394554, 549134, 736707, 440259, 111891, 351716, 813629, 352143, 782810, 189811, 468221, 193666, 749547, 452946, 342215, 128911, 280719, 592140, 456465, 817490,
188540, 128426, 725242, 424715, 141495, 273419, 957534, 182778, 584666, 374026, 332653, 694917, 876196, 595225, 772161, 956875, 889297, 538697, 881928, 234488, 349866, 820027, 439337, 401767, 239152,
847123, 369760, 759293, 137184, 517884, 455010, 987064, 468751, 681995, 960391, 951384, 675350, 551841, 443074, 501863, 797254, 226648, 610055, 673622, 381909, 671453, 375547, 319080, 970243, 224374,
178947, 687094, 131062, 625115, 147859, 339027, 705421, 846699, 896041, 581345, 843181, 920732, 878596, 153017, 388494, 886625, 656803, 148402, 646494, 206063, 639794, 416591, 133064, 267413, 375626,
726472, 517883, 401477, 264005, 238217, 226511, 381352, 920109, 445032, 127327, 514632, 282155, 187843, 480946, 679684, 516142, 167963, 746581, 982369, 749385, 250246, 337104, 999847, 796276, 235526,
111472, 937545, 870705, 873880, 251498, 637940, 191464, 481922, 612217, 941969, 548678, 888637, 909629, 432685, 193208, 873237, 979822, 850235, 665314, 498965, 794487, 706007, 234928, 465306, 465383,
124505, 483329, 732181, 153959, 672759, 132079, 283208, 401419, 224223, 418861, 677499, 735601, 885451, 196476, 967539, 502359, 126480, 165751, 967047, 406036, 330543, 821585, 233089, 781809, 256015,
390416, 818175, 195623, 269481, 449381, 175123, 844696, 193940, 948436, 898589, 536788, 580232, 895613, 665002, 574929, 475300, 220037, 464336, 499076, 184634, 264618, 694015, 134793, 532972, 735539,
584888, 859658, 864620, 822371, 206536, 999877, 660385, 804965, 878916, 287040, 640139, 582121, 596398, 599637, 871742, 758295, 982333, 434162, 370566, 176544, 483909, 932850, 744780, 266063, 201400,
243564, 263376, 246011, 646636, 128567, 585735, 533811, 155628, 795817, 615405, 220712, 950938, 442064, 604577, 256350, 180199, 671469, 795450, 628940, 696812, 341492, 810693, 387106, 252441, 263112,
811418, 488129, 454385, 939530, 247754, 874763, 798895, 898224, 678545, 393750, 841916, 806420, 722285, 896621, 967275, 829032, 847905, 553432, 368540, 664521, 136912, 445979, 181384, 265439, 141693,
577229, 952886, 492731, 372235, 966352, 905508, 197629, 562360, 321192, 869324, 369220, 229618, 130587, 580492, 553183, 776046, 668640, 957108, 188175, 945913, 414555, 441831, 159957, 369122, 745321,
198861, 201457, 139385, 785877, 393227, 418888, 793250, 323629, 930363, 311175, 487622, 455711, 976631, 924147, 160401, 822074, 484996, 579391, 889471, 185830, 183727, 277089, 752821, 960839, 200539,
990404, 326896, 167280, 141657, 449819, 327105, 533662, 187137, 994898, 524113, 981429, 999256, 268406, 184814, 605390, 554459, 685783, 295024, 353881, 661753, 736202, 827672, 183856, 144669, 731690,
235950, 613125, 771626, 138051, 193371, 104606, 493023, 560025, 755672, 202539, 331146, 334282, 258621, 354260, 174620, 527980, 297545, 459212, 152038, 715657, 130254, 599957, 602065, 199225, 244970,
300851, 740187, 516263, 912646, 500417, 269116, 904709, 558086, 923066, 362784, 875109, 265879, 128912, 135847, 162403, 380705, 654753, 476715, 351285, 171539, 708554, 127259, 459719, 829666, 353577,
940417, 365915, 924067, 430762, 264481, 335811, 394593, 883508, 340319, 307918, 438307, 975295, 371684, 259482, 153971, 640702, 205070, 954178, 453241, 616218, 311338, 189191, 889409, 932894, 141420,
384172, 652573, 974231, 869359, 177541, 850459, 241345, 692741, 787630, 430516, 148298, 679906, 108753, 607951, 154005, 838078, 919121, 557982, 322940, 296497, 270213, 164168, 163139, 740461, 593150,
920871, 125539, 704715, 407065, 748563, 267437, 946001, 403301, 776503, 737195, 304580, 979099, 480723, 988279, 480564, 235901, 186810, 954069, 283393, 365676, 863995, 172174, 262548, 865352, 933548,
525212, 634544, 160981, 448187, 694345, 701817, 146993, 844359, 987821, 685623, 976382, 671345, 291830, 654154, 135981, 954772, 520984, 511062, 680849, 411704, 637362, 793463, 469747, 711776, 933768,
386098, 703628, 402418, 996691, 627358, 820156, 780806, 566048, 102294, 818125, 362062, 835635, 716759, 151493, 358227, 484261, 639065, 455880, 802040, 511970, 275813, 154308, 756167, 563051, 633076,
373674, 156888, 154542, 668998, 711011, 956002, 532901, 400399, 551992, 446304, 351616, 453130, 851432, 307985, 454027, 109801, 635832, 421516, 814426, 887738, 167330, 572965, 872022, 778151, 276873,
615540, 186333, 245918, 289502, 523671, 296312, 203391, 322212, 915196, 143783, 272686, 837232, 695675, 218720, 856307, 570289, 600118, 160262, 389832, 226220, 579348, 348832, 874658, 130660, 182111,
901350, 140238, 342789, 260450, 767381, 904059, 768140, 718757, 155621, 612372, 512412, 563784, 466959, 293646, 878957, 758333, 421164, 156301, 977123, 620693, 985540, 273218, 360192, 884109, 591289,
184816, 623566, 693673, 756175, 863187, 693584, 559798, 830908, 916212, 803258, 133884, 727594, 313152, 679403, 596263, 932460, 187507, 835189, 801260, 266366, 384216, 144285, 662398, 369912, 944883,
543623, 368522, 103154, 664001, 759178, 185409, 200980, 116890, 391109, 463220, 913576, 406359, 615704, 928919, 499324, 632993, 248325, 185807, 957172, 218936, 492119, 882310, 739647, 437878, 715943,
925116, 907352, 152812, 284281, 628949, 497771, 929163, 147237, 159260, 510684, 305285, 323160, 297822, 231434, 731776, 760909, 306698, 805734, 130406, 519508, 877243, 173893, 299661, 647131, 939155,
520663, 813678, 228527, 561960, 759020, 196971, 108992, 101876, 918305, 944188, 801124, 818012, 807766, 340657, 163116, 479100, 149344, 181023, 759455, 724335, 821958, 864754, 498391, 755873, 110965,
771802, 458693, 103725, 939599, 333066, 154985, 116616, 115870, 786657, 605738, 148214, 870715, 132397, 121254, 581734, 327286, 703986, 365737, 549833, 165237, 871311, 788226, 470364, 219024, 248069,
896531, 559713, 635131, 440656, 594895, 818300, 141843, 865730, 408448, 453211, 533847, 731463, 813871, 666991, 445012, 738080, 816199, 504627, 303779, 987307, 989631, 480984, 876354, 177853, 217193,
161500, 513068, 293928, 324020, 189750, 672008, 411682, 287572, 529989, 244909, 193023, 121342, 113495, 908597, 697465, 763633, 246571, 151056, 275182, 934618, 512147, 787366, 435831, 662402, 440356,
304576, 749407, 468807, 494955, 909927, 516181, 287086, 666234, 117845, 731154, 529674, 683886, 289636, 864144, 212770, 529362, 573006, 293678, 497229, 113721, 657263, 357807, 138017, 784307, 959030,
380278, 135494, 354491, 607219, 199269, 277224, 946076, 907730, 251388, 488950, 509540, 157229, 706415, 807510, 644909, 853585, 597832, 119594, 595759, 403080, 390806, 607918, 163490, 959515, 748473,
833203, 173040, 817840, 428331, 883373, 657053, 567597, 121221, 417821, 958063, 611308, 698997, 693887, 177630, 163865, 169392, 682807, 436406, 696464, 766873, 464927, 683678, 527327, 522463, 963317,
177693, 214670, 438126, 902310, 677318, 130133, 649502, 260824, 493831, 231577, 309950, 110613, 586759, 153112, 312559, 715649, 126861, 170361, 678451, 130435, 505569, 464607, 149915, 102129, 748677,
540158, 990943, 763726, 155978, 715211, 951828, 994307, 675003, 112881, 524735, 672892, 224106, 594061, 252174, 606921, 632514, 199989, 606017, 654030, 771659, 520261, 179060, 267168, 129495, 582706,
865982, 194709, 839026, 821023, 369021, 137790, 166954, 833411, 337256, 659932, 506966, 188299, 678382, 939655, 674267, 228396, 758269, 271264, 706067, 133204, 413644, 420531, 808544, 144102, 924416,
988444, 570508, 506820, 145938, 383403, 279031, 744097, 192523, 146628, 666309, 524385, 122156, 629099, 167944, 701712, 579455, 827429, 238577, 915291, 301658, 612573, 897155, 374211, 218060, 551620,
730424, 298898, 120616, 792035, 314876, 211506, 593977, 242681, 119456, 726002, 744102, 461960, 722951, 103178, 525795, 585591, 169677, 204377, 404545, 843997, 950516, 341178, 784136, 707408, 430859,
593067, 171204, 262935, 142606, 521182, 967688, 129547, 148885, 175527, 275456, 481266, 112475, 953770, 518759, 119265, 445049, 689125, 485586, 845763, 149706, 221971, 508740, 908844, 174527, 996875,
153245, 591302, 807177, 121563, 857215, 894590, 570899, 614774, 502350, 859761, 686974, 159076, 847344, 269425, 491629, 855090, 221333, 823578, 884545, 594434, 456182, 916491, 731403, 531277, 958731,
700329, 316508, 292245, 788007, 842674, 935176, 944433, 963062, 125306, 614090, 885749, 138103, 691665, 453020, 142179, 778443, 726829, 709160, 267958, 156335, 144790, 408416, 146710, 962314, 406025,
246257, 187062, 942325, 170919, 665602, 193613, 294852, 751919, 366222, 195050, 872501, 897016, 710270, 549153, 281948, 875429, 423243, 732341, 492278, 108268, 664988, 353986, 193962, 934063, 627246,
498792, 746054, 665101, 110592, 545908, 471775, 273426, 757867, 694576, 422037, 641192, 768366, 752071, 128563, 922632, 881291, 374732, 191888, 145412, 964068, 187132, 118504, 866487, 353126, 706987,
761381, 540608, 743294, 830088, 778409, 950353, 498490, 942130, 150587, 292486, 827972, 402429, 122611, 898216, 397343, 806873, 374764, 206467, 937717, 625292, 642383, 899989, 310147, 250875, 942684,
969306, 384783, 203413, 379083, 559399, 293802, 688420, 936415, 966899, 913217, 654108, 139194, 153342, 105091, 770405, 260287, 618968, 161166, 249104, 399941, 399138, 836880, 509405, 987503, 232011,
828009, 413460, 375385, 270815, 395773, 679224, 787322, 576171, 676478, 364944, 249008, 908542, 440234, 168084, 283573, 813925, 621771, 390218, 149885, 106122, 621107, 153871, 691708, 973126, 412527,
601107, 117445, 667074, 764790, 286971, 330675, 723269, 951495, 110698, 895926, 729549, 182705, 431153, 373942, 680364, 377896, 205910, 679651, 713545, 252853, 217482, 768730, 683849, 884458, 668414,
938108, 631756, 194096, 871407, 806954, 804391, 999554, 328337, 311214, 159282, 656816, 327983, 742913, 432628, 149991, 144052, 170004, 212436, 564973, 548769, 935974, 515916, 532654, 119652, 544870,
278090, 932677, 437141, 872208, 156412, 407725, 162209, 599695, 127055, 311624, 227274, 885786, 964444, 174269, 237591, 735832, 548276, 392333, 524217, 503842, 136533, 112545, 268212, 100432, 445592,
161655, 925432, 126054, 297398, 697781, 247781, 533058, 382367, 867724, 298340, 601921, 983053, 519096, 497291, 270603, 551725, 661294, 174269, 167786, 838981, 464971, 933784, 519692, 268643, 549924,
823943, 887923, 935565, 114082, 938578, 702068, 955285, 175324, 119107, 709121, 113691, 666291, 226988, 512641, 246852, 190795, 101158, 849633, 537950, 238696, 818120, 286040, 463364, 776202, 177097,
192162, 310766, 878748, 180579, 220235, 533859, 787118, 311870, 513194, 456717, 763155, 150750, 163447, 525929, 727766, 168729, 790552, 956026, 443475, 464899, 264464, 626567, 642162, 452033, 765579,
404620, 271216, 770829, 502744, 199398, 224207, 150510, 417041, 155334, 202178, 765659, 570815, 390650, 813814, 892180, 335035, 712594, 764460, 273148, 376266, 983058, 794383, 195965, 103155, 180898,
163791, 938275, 588291, 813538, 212113, 495327, 517653, 789128, 322645, 168344, 819404, 969761, 271251, 783153, 176553, 878413, 914267, 528381, 632840, 481117, 839548, 924651, 388279, 457325, 857408,
683396, 193889, 870686, 337118, 780562, 483532, 745297, 411862, 585175, 820855, 102211, 634407, 717196, 942220, 238349, 164127, 175403, 185119, 295182, 535011, 628046, 132705, 369527, 101790, 700360,
540213, 488289, 355236, 208942, 221384, 977926, 716029, 242300, 887624, 612480, 594504, 105930, 215356, 150168, 737925, 148583, 963576, 881468, 858232, 704250, 132790, 873561, 377387, 115365, 611108,
332829, 562448, 908615, 676628, 890735, 855139, 365138, 396915, 274738, 226526, 169942, 248204, 843182, 817337, 936120, 853655, 595754, 539265, 552422, 422192, 871887, 687339, 157114, 104845, 973792,
140159, 223326, 126780, 665908, 548741, 234649, 822897, 830819, 198461, 600630, 118854, 378227, 377327, 961947, 126669, 229221, 108477, 866014, 172368, 490499, 975569, 370362, 980591, 902213, 633465,
436348, 656964, 156733, 564301, 401439, 182721, 403535, 448123, 750056, 984127, 147973, 351584, 306777, 333290, 180419, 978402, 351572, 215769, 520807, 554406, 919198, 715488, 111120, 180387, 236368,
279610, 558900, 464317, 644953, 983819, 816216, 846099, 709866, 275311, 120364, 425710, 756464, 602825, 454599, 960273, 379403, 371623, 390915, 725086, 149023, 779965, 976939, 167426, 499070, 388826,
627901, 633954, 533811, 119183, 126760, 262002, 166245, 217473, 784609, 382942, 523550, 295012, 229554, 808530, 257507, 992763, 919022, 368382, 564790, 129755, 191615, 152236, 956911, 215485, 492276,
308722, 313890, 435841, 812323, 984926, 475043, 105732, 146096, 605986, 881163, 479757, 374835, 620299, 733722, 141587, 293458, 565844, 187652, 712243, 104503, 265446, 896251, 729634, 111679, 352275,
712867, 782746, 302733, 675478, 620119, 535421, 108071, 561342, 620394, 513303, 911315, 155279, 115194, 820663, 971213, 537708, 762011, 439266, 312264, 315367, 174412, 686155, 822953, 310860, 125379,
860995, 384652, 830640, 638893, 189948, 433515, 228372, 977626, 834943, 810166, 367722, 630553, 311297, 447931, 298670, 728059, 144885, 904770, 121118, 974303, 160856, 134694, 149996, 565692, 880278,
385573, 871408, 288822, 174546, 530095, 597121, 134762, 185090, 697180, 160814, 427645, 506760, 143287, 559798, 883090, 118574, 199345, 659791, 735697, 822247, 582626, 241003, 436240, 139736, 517025,
382413, 938417, 315497, 918238, 490694, 316738, 276690, 112580, 645531, 734740, 802526, 483223, 145104, 606952, 798098, 555376, 602168, 311996, 132066, 446289, 918021, 924134, 452273, 552156, 636943,
952925, 270899, 139490, 536144, 873166, 785637, 897518, 199809, 452709, 527791, 230972, 460682, 621844, 134420, 745136, 151078, 907570, 538734, 358389, 505602, 810274, 647164, 281825, 812017, 509829,
467375, 715491, 773234, 748855, 699495, 303667, 226068, 380333, 131770, 735361, 178304, 958643, 429318, 673975, 334356, 245762, 995486, 650325, 764152, 657402, 146996, 581637, 188594, 193776, 322326,
764326, 881880, 134943, 169625, 968188, 116269, 482703, 426433, 599158, 731501, 993069, 798133, 512719, 124683, 120413, 273178, 126304, 889171, 229159, 312669, 323385, 950328, 131758, 788691, 974429,
176795, 563729, 561281, 329656, 401580, 257943, 840782, 136650, 338142, 821861, 153000, 403359, 247523, 164565, 457974, 609828, 132193, 646831, 601879, 937006, 294185, 412705, 801400, 601035, 195438,
717362, 298056, 514477, 476188, 746853, 229904, 956949, 862914, 671100, 773227, 213354, 277977, 727491, 490102, 520588, 660932, 112076, 194916, 382011, 414958, 414016, 197922, 735807, 404558, 890809,
203300, 887964, 151880, 470567, 677688, 812359, 337763, 108656, 178070, 644705, 393388, 185886, 793235, 885726, 124135, 621054, 823906, 772742, 129996, 773204, 527802, 115094, 487732, 125518, 178094,
922222, 839807, 492030, 924731, 154634, 336689, 745956, 332550, 277299, 418365, 262773, 220033, 104756, 579419, 655720, 117200, 158773, 166672, 350195, 249485, 850346, 858571, 566508, 657087, 972167,
112482, 192242, 430093, 249662, 273006, 857650, 104360, 808551, 976500, 123980, 666396, 110110, 295385, 603643, 875112, 536438, 826261, 890852, 990365, 415607, 112444, 362780, 438218, 108523, 886203,
539858, 638762, 114424, 434761, 313202, 171394, 118473, 744342, 718548, 190600, 790747, 740188, 579392, 206169, 128147, 356704, 831401, 218851, 263490, 208061, 821400, 701290, 753878, 347080, 996262,
244443, 416258, 915814, 807866, 271641, 397576, 184563, 889205, 985054, 984362, 439193, 764470, 506471, 221721, 642428, 530309, 487706, 143098, 141779, 238563, 945228, 308635, 182802, 788655, 140624,
109918, 145154, 399653, 902864, 306501, 344265, 352841, 611175, 278942, 916791, 665778, 274314, 349600, 522216, 592205, 375207, 799843, 186616, 396130, 195855, 326450, 338525, 131929, 120846, 491946,
816417, 104278, 307775, 796045, 252588, 632888, 953490, 880952, 184584, 685041, 958215, 826569, 621169, 876434, 120923, 342186, 734313, 675880, 256953, 885084, 835941, 167508, 229499, 634461, 530769,
153061, 275284, 385705, 904155, 191160, 971526, 967109, 449589, 546246, 573202, 733956, 965223, 462645, 916056, 448884, 620326, 905264, 186190, 386283, 160070, 725233, 919111, 743613, 327264, 504541,
159386, 464298, 350362, 251744, 156850, 169310, 105515, 582127, 747410, 559723, 262272, 510047, 578337, 855428, 783579, 150842, 680763, 100765, 190175, 672120, 294172, 457394, 857940, 577530, 561015,
851707, 630761, 777833, 186171, 130969, 754970, 242933, 159003, 971516, 922007, 676842, 100252, 899228, 405137, 195519, 767151, 820025, 299536, 870966, 822706, 715914, 492688, 161315, 321235, 506006,
215277, 370485, 401802, 146057, 676761, 458785, 189137, 487604, 173478, 545164, 617754, 880764, 784184, 850329, 564502, 547452, 713454, 558159, 727435, 561197, 577225, 576315, 396637, 972347, 499045,
460179, 488939, 115647, 541857, 929336, 651252, 770880, 174214, 158556, 575504, 186838, 107908, 776264, 137753, 184321, 305057, 870512, 663257, 981935, 496909, 599219, 455249, 871299, 146376, 534155,
164746, 481165, 831355, 102369, 476918, 321517, 892836, 127121, 953316, 503013, 221843, 192613, 186010, 183168, 505280, 942515, 229701, 330266, 993408, 341082, 834037, 435451, 154287, 523397, 352215,
516493, 597248, 546448, 117761, 707799, 246611, 864989, 204764, 351519, 164990, 352323, 998578, 351578, 204500, 483466, 186138, 866647, 343321, 112737, 921079, 141166, 416697, 852146, 273650, 681632,
801368, 877393, 912591, 303144, 801940, 292919, 851939, 334812, 794979, 126146, 439021, 898008, 250481, 893367, 939454, 452724, 208521, 887310, 810428, 192288, 289621, 890151, 147374, 776937, 150646,
602964, 193797, 489771, 688334, 638750, 722571, 182337, 534091, 764660, 685450, 405752, 559054, 199118, 871862, 725542, 471660, 215597, 360019, 307455, 598538, 478296, 375468, 422391, 347740, 814206,
382078, 856922, 171558, 542305, 773768, 154462, 144966, 384068, 827642, 196454, 566336, 614548, 859959, 877348, 641024, 107391, 436997, 216014, 302584, 290489, 126825, 501009, 956749, 372850, 793353,
595694, 129205, 855670, 791601, 247122, 424546, 304427, 746440, 817327, 575281, 564022, 584645, 662827, 125600, 767282, 134294, 311585, 372777, 557666, 441095, 434580, 632491, 736390, 278703, 383008,
169398, 983063, 761825, 757710, 192685, 360445, 711356, 485559, 722324, 431781, 922926, 496838, 234482, 319136, 128143, 324780, 162857, 126455, 748844, 264053, 513329, 717043, 136318, 961580, 950393,
612311, 573985, 147359, 187779, 540927, 340715, 681316, 267903, 156953, 105015, 422659, 299391, 208283, 761097, 929887, 136765, 899134, 452379, 763354, 886538, 500831, 141569, 239321, 379255, 301936,
158055, 142972, 481936, 897045, 401610, 678764, 461350, 769636, 177371, 488194, 896330, 904663, 424140, 632835, 790039, 844741, 289516, 820180, 178165, 211580, 523825, 988981, 698618, 267320, 853074,
560097, 433736, 118050, 613400, 194028, 399924, 102842, 295049, 172769, 736860, 381706, 473983, 260644, 738860, 398581, 101352, 552196, 220192, 141401, 486952, 646174, 939548, 349172, 900384, 121819,
999544, 101587, 171288, 697038, 605565, 261808, 100879, 859352, 141684, 655941, 452603, 240435, 624154, 826522, 137084, 220145, 809431, 942203, 885916, 828537, 139053, 394344, 970326, 373249, 616224,
368404, 392420, 741837, 128123, 590996, 498552, 262547, 188598, 252494, 307818, 417303, 583932, 976617, 868325, 322216, 483080, 699405, 153661, 279857, 126370, 155432, 873186, 789509, 717282, 440564,
960209, 727245, 690726, 523791, 470553, 915346, 356894, 179521, 125318, 399954, 132341, 420717, 395118, 237344, 105410, 147217, 711107, 181546, 711178, 175071, 258865, 563995, 459209, 642714, 222633,
579883, 834502, 848689, 714153, 781677, 896790, 452872, 510467, 792886, 697378, 885414, 599084, 157486, 313467, 668983, 908257, 293705, 241085, 476649, 262546, 203666, 460275, 825398, 936599, 914330,
849659, 101298, 146831, 795622, 897668, 605899, 235101, 269829, 676566, 688797, 209427, 200461, 116476, 769878, 810665, 533611, 163814, 116322, 253828, 517933, 203444, 504573, 971107, 948891, 950591,
565541, 885450, 159795, 157432, 468033, 223381, 863116, 451230, 451280, 855408, 271179, 111716, 715385, 334642, 957542, 288284, 840279, 428616, 808292, 844538, 248368, 604640, 177874, 360033, 196175,
122073, 843838, 894377, 269183, 724078, 675772, 556103, 667779, 870957, 316495, 121330, 153941, 161843, 745810, 433558, 368554, 111173, 838509, 849707, 181060, 222512, 127587, 699981, 598918, 108537,
896244, 243556, 393579, 771007, 439718, 182525, 138556, 751721, 111795, 139924, 159124, 891576, 148266, 575205, 541162, 174363, 836166, 700696, 454647, 363995, 704927, 159075, 785941, 861685, 136965,
607815, 818720, 129311, 134349, 333839, 160640, 196168, 442216, 905086, 295858, 953273, 243998, 469198, 215217, 709065, 111803, 249068, 673068, 931535, 731955, 520360, 958366, 592040, 464737, 740965,
988440, 547852, 876820, 431573, 855384, 333131, 341206, 583763, 273444, 801847, 790053, 447442, 888410, 105585, 534045, 313799, 113908, 999442, 545331, 103594, 537141, 749066, 150593, 182523, 208217,
493561, 512897, 434034, 130391, 484514, 808175, 588537, 353451, 671990, 429808, 689807, 140033, 276719, 930451, 401437, 429082, 371707, 270656, 742687, 166751, 134662, 265257, 408978, 339944, 425867,
144314, 623992, 877661, 188948, 531248, 814501, 197122, 541829, 169071, 730755, 425205, 132794, 189586, 863272, 144734, 832395, 939031, 174143, 841795, 858976, 606894, 981644, 587701, 810212, 225982,
235100, 214765, 155171, 278445, 492867, 133091, 202093, 480157, 193273, 823999, 222780, 293267, 778107, 396878, 161517, 252429, 754403, 952078, 592387, 326679, 914860, 290264, 464510, 373611, 215530,
159469, 203835, 862844, 719645, 950156, 332694, 612970, 592612, 504663, 129771, 146581, 984838, 141251, 356368, 125631, 245735, 123884, 625318, 670239, 743985, 438894, 906199, 178807, 256848, 394892,
162857, 125258, 748136, 156962, 500040, 109089, 530421, 421629, 280045, 410988, 965172, 181747, 683723, 111385, 199222, 268658, 301578, 123968, 227857, 945173, 890420, 465262, 346146, 917352, 991544,
946233, 145626, 342794, 992274, 378190, 626704, 306187, 764911, 232224, 364544, 486046, 154770, 995193, 104574, 805310, 518597, 189110, 356394, 813725, 813153, 808087, 407556, 129005, 297787, 871170,
187985, 135177, 863587, 958712, 478496, 125165, 576727, 725237, 256604, 557689, 755703, 195457, 949118, 451629, 146612, 264897, 953635, 287909, 292285, 214919, 759460, 163810, 103763, 783878, 474758,
634368, 175382, 481945, 879868, 186937, 528807, 680602, 423113, 165786, 960666, 436955, 637612, 528941, 468365, 370244, 817151, 872598, 188077, 377716, 459744, 883273, 189518, 603649, 626200, 158288,
754181, 578286, 270210, 154708, 199848, 765162, 846368, 195053, 555608, 686005, 991730, 635328, 383119, 281183, 469916, 491733, 142213, 857939, 123985, 239947, 404351, 414218, 708187, 921984, 163283,
901487, 944429, 104091, 899745, 351137, 171763, 606765, 713970, 147077, 350467, 702219, 722280, 272655, 291962, 871595, 103608, 183556, 758290, 584697, 342309, 332852, 862010, 768246, 167881, 314663,
222022, 601905, 454880, 775674, 868042, 941314, 216160, 870409, 839950, 287776, 189231, 795729, 549414, 113527, 749924, 890606, 379324, 503775, 204342, 307273, 196846, 529974, 583383, 629383, 466634,
141901, 922004, 707731, 825318, 267046, 181006, 985190, 772479, 288227, 638171, 933360, 581128, 965554, 968014, 528648, 488945, 710509, 843187, 164810, 364009, 697060, 550053, 695721, 931265, 895405,
690963, 446424, 640698, 814459, 246597, 409256, 560825, 746438, 430509, 347049, 522879, 220132, 587800, 868988, 908031, 120501, 466260, 470846, 879634, 330667, 393472, 252472, 352977, 371034, 664765,
922715, 194509, 968129, 814848, 159823, 665882, 665543, 785435, 280518, 595695, 650494, 966190, 362573, 396723, 382114, 282063, 274796, 265507, 848418, 290960, 524414, 306135, 704690, 427925, 116931,
177802, 717773, 809192, 685325, 148828, 575132, 810273, 523010, 214416, 886766, 344530, 162768, 258820, 337283, 133024, 771869, 181866, 786927, 537593, 632394, 178779, 544416, 958814, 748377, 149175,
112022, 792024, 802419, 907996, 675143, 326424, 993525, 135764, 595453, 139749, 121812, 951417, 224185, 684411, 258640, 522948, 168872, 981822, 150206, 820397, 367275, 489050, 423214, 822948, 977773,
170218, 118546, 669557, 895274, 195672, 106416, 375653, 164472, 489364, 414617, 788443, 886994, 545836, 199271, 813248, 354914, 397105, 288179, 377679, 765805, 441407, 342641, 529845, 242705, 423575,
910806, 687020, 337221, 720641, 496944, 484144, 780985, 589734, 702550, 993177, 304005, 863377, 409063, 796548, 180812, 773390, 147875, 588751, 636275, 334391, 107285, 306653, 603645, 344170, 352236,
405184, 703920, 573645, 354873, 754645, 816212, 665968, 186445, 461565, 344929, 555821, 820787, 405745, 948153, 992141, 167055, 629333, 142714, 584609, 484384, 456204, 268759, 458317, 364861, 987013,
974429, 972314, 766983, 188268, 970551, 666967, 498584, 290774, 269093, 140291, 631893, 613564, 180832, 219185, 637582, 348972, 758977, 148285, 143947, 613744, 105326, 606884, 753908, 756398, 978856,
676034, 179400, 199932, 400749, 803858, 530592, 151830, 130396, 177503, 224199, 564948, 706671, 935831, 480731, 811895, 344689, 138656, 473253, 585829, 589654, 537388, 407398, 640001, 518749, 204522,
110734, 197169, 937434, 606436, 337977, 732881, 986843, 638240, 471603, 676918, 226529, 939749, 511419, 556885, 123244, 161099, 885431, 166337, 157443, 409172, 986643, 180801, 499304, 629370, 471982,
724705, 526925, 347577, 126379, 647712, 118389, 148185, 528031, 452965, 319011, 738614, 208890, 397350, 365761, 771579, 284606, 780307, 264693, 540565, 405819, 223477, 168175, 572026, 208629, 713124,
502549, 899159, 137962, 753002, 196323, 240546, 943731, 367752, 760159, 399626, 908009, 985731, 470826, 656320, 707308, 509869, 626394, 384863, 462558, 526018, 597259, 675846, 670329, 345832, 418101,
188517, 271667, 487937, 604196, 191324, 738547, 778516, 516187, 925802, 464425, 823714, 936160, 619170, 457764, 435142, 968919, 942599, 695746, 541047, 666660, 948978, 671853, 567567, 269098, 978840,
120984, 566454, 176108, 179008, 451957, 157800, 259975, 487181, 601578, 875895, 480160, 460595, 194523, 328561, 746632, 699273, 812350, 964835, 646277, 543203, 865616, 858644, 844526, 286926, 904911,
568513, 793660, 424978, 712688, 222744, 716223, 149689, 595470, 642889, 179680, 844194, 165244, 635198, 225450, 550500, 420883, 405227, 530066, 881099, 777234, 921328, 379520, 931717, 353956, 940098,
146219, 476004, 420373, 167080, 252804, 585564, 280055, 251916, 710344, 808453, 732145, 177180, 551391, 361601, 369071, 234895, 589563, 854241, 700211, 909538, 858376, 161249, 175657, 919253, 170255,
209398, 308728, 848534, 726579, 128696, 391849, 385570, 934820, 488015, 492630, 672715, 997556, 242063, 985755, 163438, 916394, 913373, 929629, 107373, 118331, 604470, 196601, 384057, 187521, 778367,
682026, 371558, 187553, 606895, 592123, 281790, 526485, 219655, 178181, 389823, 961663, 921727, 453179, 544143, 902954, 866573, 387040, 220220, 102410, 679247, 601666, 343792, 519010, 117756, 197587,
141286, 340985, 174469, 404983, 715330, 182001, 461580, 759469, 374819, 976362, 178607, 273631, 134016, 150910, 998201, 259587, 219475, 195221, 192458, 428279, 103009, 792192, 599044, 129060, 109780,
565122, 218912, 174581, 196530, 344741, 228066, 152552, 207187, 661837, 641858, 481710, 412472, 899531, 611904, 804070, 413828, 579413, 121217, 926830, 958460, 233749, 122945, 442811, 116950, 609635,
787973, 384577, 866458, 126662, 337845, 813330, 951269, 458065, 430145, 281077, 914761, 118870, 118758, 543997, 103119, 151890, 623045, 287276, 390815, 912083, 746546, 369251, 498572, 436475, 731575,
467335, 880680, 550970, 101179, 354007, 206907, 294659, 269960, 390099, 847256, 572100, 527174, 897499, 356447, 222243, 770882, 498668, 415504, 981412, 459041, 489495, 263604, 442372, 183142, 312301,
310171, 839561, 402933, 405053, 674727, 579473, 160523, 778354, 652371, 113083, 161188, 396032, 524845, 227135, 933566, 560288, 153120, 160999, 761551, 125900, 146991, 383414, 839055, 909592, 442128,
189475, 892829, 937923, 180717, 548304, 896337, 603797, 708338, 965674, 788503, 151747, 966881, 314313, 514023, 612578, 774008, 937090, 647423, 113452, 110740, 481173, 204790, 996663, 255529, 212060,
253106, 194450, 856201, 193931, 110041, 546492, 413970, 186401, 723026, 248096, 195236, 372531, 930979, 846335, 188331, 261509, 131754, 182146, 184919, 642664, 815748, 261083, 916165, 134566, 382777,
780349, 798391, 715996, 224934, 980428, 156734, 187955, 156677, 773302, 249917, 125113, 639087, 202505, 311563, 672347, 426212, 362505, 743621, 987095, 842631, 188314, 362879, 660800, 229360, 177005,
823421, 142148, 401458, 573307, 902485, 187445, 745262, 646020, 264540, 718913, 888389, 425034, 202593, 730165, 823966, 167154, 279338, 981778, 204504, 943552, 624664, 152453, 276996, 949596, 146852,
393163, 521221, 730615, 300406, 983918, 480434, 203775, 202217, 192421, 244059, 600289, 790584, 626339, 953715, 221773, 164676, 536715, 461364, 188559, 871765, 535738, 162355, 266215, 198835, 478630,
155259, 764716, 235733, 481317, 306885, 732218, 115590, 917449, 723326, 324296, 878162, 805300, 865740, 830788, 319344, 297076, 630370, 386384, 780253, 100584, 731605, 134795, 820104, 121115, 514356,
123256, 400428, 446013, 151280, 916043, 345287, 379787, 129565, 947156, 974294, 707583, 910553, 130917, 981660, 146049, 793212, 651934, 537031, 168055, 823490, 806687, 503217, 471696, 593786, 102956,
558731, 276764, 643359, 289622, 957489, 619223, 651677, 191795, 283771, 155046, 186852, 310593, 121445, 343704, 153587, 293532, 380375, 321084, 595166, 161268, 944827, 542115, 316626, 428468, 130162,
684777, 542142, 998308, 150446, 575299, 340353, 977809, 837318, 734692, 613815, 214647, 462703, 226586, 863995, 563267, 734383, 573703, 891686, 973411, 879183, 590344, 150313, 747737, 968821, 200808,
589146, 231348, 533529, 575375, 256785, 403840, 775818, 939712, 618134, 539406, 267952, 176201, 267510, 414783, 177672, 152609, 702173, 198224, 547158, 469752, 507664, 911999, 449574, 894131, 720221,
446580, 120735, 231717, 980608, 850706, 132276, 944840, 590995, 582994, 761474, 957166, 239989, 309587, 190973, 836071, 381133, 124200, 711759, 334858, 495950, 590018, 362332, 615438, 179266, 9505798
};

#endif //RPP_RNG_SEED_STREAM_H