// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package ec2instanceconnectiface provides an interface to enable mocking the AWS EC2 Instance Connect service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package ec2instanceconnectiface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/ec2instanceconnect"
)

// EC2InstanceConnectAPI provides an interface to enable mocking the
// ec2instanceconnect.EC2InstanceConnect service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//	// myFunc uses an SDK service client to make a request to
//	// AWS EC2 Instance Connect.
//	func myFunc(svc ec2instanceconnectiface.EC2InstanceConnectAPI) bool {
//	    // Make svc.SendSSHPublicKey request
//	}
//
//	func main() {
//	    sess := session.New()
//	    svc := ec2instanceconnect.New(sess)
//
//	    myFunc(svc)
//	}
//
// In your _test.go file:
//
//	// Define a mock struct to be used in your unit tests of myFunc.
//	type mockEC2InstanceConnectClient struct {
//	    ec2instanceconnectiface.EC2InstanceConnectAPI
//	}
//	func (m *mockEC2InstanceConnectClient) SendSSHPublicKey(input *ec2instanceconnect.SendSSHPublicKeyInput) (*ec2instanceconnect.SendSSHPublicKeyOutput, error) {
//	    // mock response/functionality
//	}
//
//	func TestMyFunc(t *testing.T) {
//	    // Setup Test
//	    mockSvc := &mockEC2InstanceConnectClient{}
//
//	    myfunc(mockSvc)
//
//	    // Verify myFunc's functionality
//	}
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type EC2InstanceConnectAPI interface {
	SendSSHPublicKey(*ec2instanceconnect.SendSSHPublicKeyInput) (*ec2instanceconnect.SendSSHPublicKeyOutput, error)
	SendSSHPublicKeyWithContext(aws.Context, *ec2instanceconnect.SendSSHPublicKeyInput, ...request.Option) (*ec2instanceconnect.SendSSHPublicKeyOutput, error)
	SendSSHPublicKeyRequest(*ec2instanceconnect.SendSSHPublicKeyInput) (*request.Request, *ec2instanceconnect.SendSSHPublicKeyOutput)

	SendSerialConsoleSSHPublicKey(*ec2instanceconnect.SendSerialConsoleSSHPublicKeyInput) (*ec2instanceconnect.SendSerialConsoleSSHPublicKeyOutput, error)
	SendSerialConsoleSSHPublicKeyWithContext(aws.Context, *ec2instanceconnect.SendSerialConsoleSSHPublicKeyInput, ...request.Option) (*ec2instanceconnect.SendSerialConsoleSSHPublicKeyOutput, error)
	SendSerialConsoleSSHPublicKeyRequest(*ec2instanceconnect.SendSerialConsoleSSHPublicKeyInput) (*request.Request, *ec2instanceconnect.SendSerialConsoleSSHPublicKeyOutput)
}

var _ EC2InstanceConnectAPI = (*ec2instanceconnect.EC2InstanceConnect)(nil)
