/**
 * librouteros - src/routeros_version.h
 * Copyright (C) 2009  Florian octo Forster
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; only version 2 of the License is applicable.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 *
 * Authors:
 *   Florian octo Forster <octo at verplant.org>
 **/

#ifndef ROUTEROS_VERSION_H
#define ROUTEROS_VERSION_H 1

#ifdef __cplusplus
extern "C" {
#endif

#define ROS_VERSION_MAJOR 1
#define ROS_VERSION_MINOR 1
#define ROS_VERSION_PATCH 3

#define ROS_VERSION_STRING "1.1.3"

#define ROS_VERSION_ENCODE(major, minor, patch) \
	((major) * 10000 + (minor) * 100 + (patch))

#define ROS_VERSION \
	ROS_VERSION_ENCODE(ROS_VERSION_MAJOR, ROS_VERSION_MINOR, ROS_VERSION_PATCH)

int ros_version (void);
const char *ros_version_string (void);

#ifdef __cplusplus
}
#endif

#endif /* ROUTEROS_VERSION_H */
