/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Container;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.sort.IntHashMap;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.functions.StandardFunction;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SequenceType;

public class SystemFunctionLibrary
implements FunctionLibrary {
    private int functionSet;
    private static IntHashMap<SystemFunctionLibrary> THE_INSTANCES = new IntHashMap(3);

    public static SystemFunctionLibrary getSystemFunctionLibrary(int functionSet) {
        if (THE_INSTANCES.get(functionSet) == null) {
            THE_INSTANCES.put(functionSet, new SystemFunctionLibrary(functionSet));
        }
        return THE_INSTANCES.get(functionSet);
    }

    private SystemFunctionLibrary(int functionSet) {
        this.functionSet = functionSet;
    }

    public SequenceType[] getFunctionSignature(StructuredQName functionName, int arity) {
        String uri = functionName.getNamespaceURI();
        String local = functionName.getLocalName();
        if (uri.equals("http://www.w3.org/2005/xpath-functions")) {
            StandardFunction.Entry entry = StandardFunction.getFunction(local, arity);
            if (entry == null) {
                return null;
            }
            if (arity != -1 && (arity < entry.minArguments || arity > entry.maxArguments)) {
                return null;
            }
            if ((this.functionSet & entry.applicability) == 0) {
                return null;
            }
            SequenceType[] sig = new SequenceType[arity + 1];
            if (arity >= 0) {
                sig[0] = entry.itemType == StandardFunction.SAME_AS_FIRST_ARGUMENT ? entry.argumentTypes[0] : SequenceType.makeSequenceType(entry.itemType, entry.cardinality);
                for (int i = 0; i < arity; ++i) {
                    sig[i + 1] = i < entry.argumentTypes.length ? entry.argumentTypes[i] : entry.argumentTypes[0];
                }
            }
            return sig;
        }
        return null;
    }

    public Expression bind(StructuredQName functionName, Expression[] staticArgs, StaticContext env, Container container) throws XPathException {
        String uri = functionName.getNamespaceURI();
        if (uri.equals("http://www.w3.org/2005/xpath-functions")) {
            SystemFunction f;
            String local = functionName.getLocalName();
            StandardFunction.Entry entry = StandardFunction.getFunction(local, staticArgs.length);
            if (entry == null) {
                if (StandardFunction.getFunction(local, -1) == null) {
                    XPathException err = new XPathException("Unknown system function " + local + "()");
                    err.setErrorCode("XPST0017");
                    err.setIsStaticError(true);
                    throw err;
                }
                XPathException err = new XPathException("System function " + local + "#" + staticArgs.length + " cannot be called with " + SystemFunctionLibrary.pluralArguments(staticArgs.length));
                err.setErrorCode("XPST0017");
                err.setIsStaticError(true);
                throw err;
            }
            if ((this.functionSet & entry.applicability) == 0) {
                XPathException err = new XPathException("System function " + local + "#" + staticArgs.length + " is not available with this host language");
                err.setErrorCode("XPST0017");
                err.setIsStaticError(true);
                throw err;
            }
            Class functionClass = entry.implementationClass;
            try {
                f = (SystemFunction)functionClass.newInstance();
            }
            catch (Exception err) {
                throw new AssertionError((Object)("Failed to load system function: " + err.getMessage()));
            }
            f.setDetails(entry);
            f.setFunctionName(functionName);
            f.setArguments(staticArgs);
            f.setContainer(container);
            this.checkArgumentCount(staticArgs.length, entry.minArguments, entry.maxArguments, local);
            return f;
        }
        return null;
    }

    private int checkArgumentCount(int numArgs, int min, int max, String local) throws XPathException {
        if (min == max && numArgs != min) {
            throw new XPathException("Function " + Err.wrap(local, 3) + " must have " + min + SystemFunctionLibrary.pluralArguments(min));
        }
        if (numArgs < min) {
            throw new XPathException("Function " + Err.wrap(local, 3) + " must have at least " + min + SystemFunctionLibrary.pluralArguments(min));
        }
        if (numArgs > max) {
            throw new XPathException("Function " + Err.wrap(local, 3) + " must have no more than " + max + SystemFunctionLibrary.pluralArguments(max));
        }
        return numArgs;
    }

    private static String pluralArguments(int num) {
        if (num == 1) {
            return " argument";
        }
        return " arguments";
    }

    public FunctionLibrary copy() {
        return this;
    }
}

