/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import java.util.ArrayList;
import java.util.Stack;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.Container;
import net.sf.saxon.expr.ErrorExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.instruct.Bindery;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.expr.instruct.GeneralVariable;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.query.XQueryFunction;
import net.sf.saxon.query.XQueryFunctionLibrary;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.tree.iter.UnfailingIterator;
import net.sf.saxon.value.SingletonClosure;
import net.sf.saxon.value.Value;

public class GlobalVariable
extends GeneralVariable
implements Container {
    private Executable executable;
    private SlotManager stackFrameMap = null;
    private boolean indexed;

    public Executable getExecutable() {
        return this.executable;
    }

    public void setExecutable(Executable executable) {
        this.executable = executable;
    }

    public int getHostLanguage() {
        return this.executable.getHostLanguage();
    }

    public void setIndexedVariable() {
        this.indexed = true;
    }

    public boolean isIndexedVariable() {
        return this.indexed;
    }

    public int getContainerGranularity() {
        return 2;
    }

    public void setContainsLocals(SlotManager map) {
        this.stackFrameMap = map;
    }

    public boolean isGlobal() {
        return true;
    }

    public void lookForCycles(Stack referees, XQueryFunctionLibrary globalFunctionLibrary) throws XPathException {
        if (referees.contains(this)) {
            int s = referees.indexOf(this);
            referees.push(this);
            String message = "Circular definition of global variable. $" + this.getVariableQName().getDisplayName();
            for (int i = s; i < referees.size() - 1; ++i) {
                Container next;
                if (i != s) {
                    message = message + ", which";
                }
                if (referees.get(i + 1) instanceof GlobalVariable) {
                    next = (GlobalVariable)referees.get(i + 1);
                    message = message + " uses $" + ((GeneralVariable)((Object)next)).getVariableQName().getDisplayName();
                    continue;
                }
                if (!(referees.get(i + 1) instanceof XQueryFunction)) continue;
                next = (XQueryFunction)referees.get(i + 1);
                message = message + " calls " + ((XQueryFunction)next).getFunctionName().getDisplayName() + "#" + ((XQueryFunction)next).getNumberOfArguments() + "()";
            }
            message = message + '.';
            XPathException err = new XPathException(message);
            err.setErrorCode("XQST0054");
            err.setIsStaticError(true);
            err.setLocator(this);
            throw err;
        }
        if (this.select != null) {
            int i;
            referees.push(this);
            ArrayList list = new ArrayList(10);
            ExpressionTool.gatherReferencedVariables(this.select, list);
            for (i = 0; i < list.size(); ++i) {
                Binding b = (Binding)list.get(i);
                if (!(b instanceof GlobalVariable)) continue;
                ((GlobalVariable)b).lookForCycles(referees, globalFunctionLibrary);
            }
            list.clear();
            ExpressionTool.gatherCalledFunctionNames(this.select, list);
            for (i = 0; i < list.size(); ++i) {
                XQueryFunction f = globalFunctionLibrary.getDeclarationByKey((String)list.get(i));
                if (referees.contains(f)) continue;
                GlobalVariable.lookForFunctionCycles(f, referees, globalFunctionLibrary);
            }
            referees.pop();
        }
    }

    private static void lookForFunctionCycles(XQueryFunction f, Stack referees, XQueryFunctionLibrary globalFunctionLibrary) throws XPathException {
        int i;
        Expression body = f.getBody();
        referees.push(f);
        ArrayList list = new ArrayList(10);
        ExpressionTool.gatherReferencedVariables(body, list);
        for (i = 0; i < list.size(); ++i) {
            Binding b = (Binding)list.get(i);
            if (!(b instanceof GlobalVariable)) continue;
            ((GlobalVariable)b).lookForCycles(referees, globalFunctionLibrary);
        }
        list.clear();
        ExpressionTool.gatherCalledFunctionNames(body, list);
        for (i = 0; i < list.size(); ++i) {
            XQueryFunction qf = globalFunctionLibrary.getDeclarationByKey((String)list.get(i));
            if (referees.contains(qf)) continue;
            GlobalVariable.lookForFunctionCycles(qf, referees, globalFunctionLibrary);
        }
        referees.pop();
    }

    public TailCall processLeavingTail(XPathContext context) throws XPathException {
        return null;
    }

    public ValueRepresentation getSelectValue(XPathContext context) throws XPathException {
        if (this.select == null) {
            throw new AssertionError((Object)("*** No select expression for global variable $" + this.getVariableQName().getDisplayName() + "!!"));
        }
        try {
            XPathContextMajor c2 = context.newCleanContext();
            c2.setOrigin(this);
            UnfailingIterator initialNode = SingletonIterator.makeIterator(c2.getController().getContextForGlobalVariables());
            initialNode.next();
            c2.setCurrentIterator(initialNode);
            if (this.stackFrameMap != null) {
                c2.openStackFrame(this.stackFrameMap);
            }
            return ExpressionTool.evaluate(this.select, this.evaluationMode, c2, this.referenceCount);
        }
        catch (XPathException e) {
            if (!this.getVariableQName().getNamespaceURI().equals("http://saxon.sf.net/generated-global-variable")) {
                e.setIsGlobalError(true);
            }
            throw e;
        }
    }

    public ValueRepresentation evaluateVariable(XPathContext context) throws XPathException {
        Controller controller = context.getController();
        Bindery b = controller.getBindery();
        ValueRepresentation v = b.getGlobalVariable(this.getSlotNumber());
        if (v != null) {
            return v;
        }
        return this.actuallyEvaluate(context);
    }

    protected ValueRepresentation actuallyEvaluate(XPathContext context) throws XPathException {
        Controller controller = context.getController();
        Bindery b = controller.getBindery();
        try {
            GlobalVariable.setDependencies(b, this, context);
            boolean go = b.setExecuting(this);
            if (!go) {
                return b.getGlobalVariable(this.getSlotNumber());
            }
            ValueRepresentation value = this.getSelectValue(context);
            if (this.indexed) {
                value = controller.getConfiguration().getOptimizer().makeIndexedValue(Value.asIterator(value));
            }
            return b.saveGlobalVariableValue(this, value);
        }
        catch (XPathException err) {
            b.setNotExecuting(this);
            if (err instanceof XPathException.Circularity) {
                err.setErrorCode(this.isXSLT() ? "XTDE0640" : "XQST0054");
                err.setXPathContext(context);
                SingletonClosure closure = new SingletonClosure(new ErrorExpression(err), context);
                b.defineGlobalVariable(this, closure);
                err.setLocator(this);
                throw err;
            }
            throw err;
        }
    }

    protected static void setDependencies(Bindery bindery, GlobalVariable var, XPathContext context) throws XPathException {
        do {
            if (!(context.getOrigin() instanceof GlobalVariable)) continue;
            bindery.registerDependency((GlobalVariable)context.getOrigin(), var);
            return;
        } while ((context = context.getCaller()) != null);
    }
}

