/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.inifile;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.antcontrib.inifile.IniPart;
import net.sf.antcontrib.inifile.IniProperty;

public class IniSection
implements IniPart {
    private String name;
    private List properties;
    private Map propertyMap = new HashMap();

    public IniSection() {
        this.properties = new ArrayList();
    }

    public IniSection(String name) {
        this();
        this.name = name;
    }

    public List getProperties() {
        return this.properties;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public IniProperty getProperty(String name) {
        return (IniProperty)this.propertyMap.get(name);
    }

    public void setProperty(IniProperty property) {
        IniProperty prop = (IniProperty)this.propertyMap.get(property.getName());
        if (prop != null) {
            int idx = this.properties.indexOf(prop);
            this.properties.set(idx, property);
        } else {
            this.properties.add(property);
        }
        this.propertyMap.put(property.getName(), property);
    }

    public void removeProperty(String name) {
        IniProperty prop = (IniProperty)this.propertyMap.get(name);
        if (prop != null) {
            int idx = this.properties.indexOf(prop);
            this.properties.remove(idx);
            this.propertyMap.remove(name);
        }
    }

    public void write(Writer writer) throws IOException {
        writer.write("[" + this.name + "]");
        writer.write(System.getProperty("line.separator"));
        Iterator it = this.properties.iterator();
        IniProperty prop = null;
        while (it.hasNext()) {
            prop = (IniProperty)it.next();
            prop.write(writer);
            writer.write(System.getProperty("line.separator"));
        }
    }
}

