# Copyright 2024-2025 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

# Autogenerated by pycargoebuild 0.13.3

EAPI=8

CRATES=""

inherit cargo

DESCRIPTION="Audit Cargo.lock for crates with security vulnerabilities"
HOMEPAGE="https://rustsec.org https://github.com/rustsec/cargo-audit"
SRC_URI="
	https://github.com/RustSec/rustsec/archive/refs/tags/${PN}/v${PV}.tar.gz -> ${P}.tar.gz
	${CARGO_CRATE_URIS}
	https://dev.gentoo.org/~arthurzam/distfiles/dev-util/${PN}/${P}-crates.tar.xz
"
S="${WORKDIR}/rustsec-${PN}-v${PV}"

LICENSE="|| ( Apache-2.0 MIT )"
# Dependent crate licenses
LICENSE+="
	Apache-2.0 Apache-2.0-with-LLVM-exceptions BSD-2 BSD ISC MIT MPL-2.0
	Unicode-3.0 Unicode-DFS-2016
"
SLOT="0"
KEYWORDS="~amd64 ~ppc64"
IUSE="fix"

RDEPEND="dev-libs/openssl:="
DEPEND="${RDEPEND}"

QA_FLAGS_IGNORED="usr/bin/${PN}"

# requires checkout of vuln db/network
PROPERTIES="test_network"
RESTRICT="test"

src_configure() {
	local myfeatures=(
		$(usev fix)
	)

	cargo_src_configure
}

src_compile() {
	# normally we can pass --bin cargo-audit
	# to build single workspace member, but we need to cd
	# for tests to be discovered properly
	cd cargo-audit || die
	cargo_src_compile
}

src_install() {
	cargo_src_install --path cargo-audit
	local DOCS=( cargo-audit/{README.md,audit.toml.example} )
	einstalldocs
}
