# Copyright 1999-2024 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

inherit edos2unix

DESCRIPTION="Anti-spam bayesian filter"
HOMEPAGE="https://getpopfile.org"
SRC_URI="https://getpopfile.org/downloads/${P}.zip"
S="${WORKDIR}"

LICENSE="GPL-2"
SLOT="0"
KEYWORDS="amd64 x86"
IUSE="cjk ipv6 mysql ssl xmlrpc"

RDEPEND="virtual/perl-Digest-MD5
	virtual/perl-MIME-Base64
	dev-perl/DBD-SQLite
	dev-perl/HTML-Tagset
	dev-perl/HTML-Template
	dev-perl/TimeDate
	dev-perl/DBI
	virtual/perl-Digest
	cjk? ( dev-perl/Encode-compat
		dev-perl/Text-Kakasi )
	mysql? ( dev-perl/DBD-mysql	)
	ipv6? ( dev-perl/IO-Socket-INET6 )
	ssl? ( dev-libs/openssl:0
		dev-perl/IO-Socket-SSL
		dev-perl/Net-SSLeay )
	xmlrpc? ( dev-perl/PlRPC )"
BDEPEND="app-arch/unzip"

src_prepare() {
	default
	local f
	for f in $(find ./ -type f || die); do
		edos2unix "${f}"
	done
}

src_install() {
	dodoc *.change*
	rm -r *.change* license || die

	insinto /usr/share/${PN}
	doins -r *

	fperms 755 /usr/share/${PN}/{popfile,insert,pipe,bayes}.pl

	dosbin "${FILESDIR}"/${PN}
}
