.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991, 1994, 1996 X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991 by
.\" Digital Equipment Corporation
.\"
.\" Portions Copyright \(co 1990, 1991 by
.\" Tektronix, Inc.
.\"
.\" Permission to use, copy, modify and distribute this documentation for
.\" any purpose and without fee is hereby granted, provided that the above
.\" copyright notice appears in all copies and that both that copyright notice
.\" and this permission notice appear in all copies, and that the names of
.\" Digital and Tektronix not be used in in advertising or publicity pertaining
.\" to this documentation without specific, written prior permission.
.\" Digital and Tektronix makes no representations about the suitability
.\" of this documentation for any purpose.
.\" It is provided ``as is'' without express or implied warranty.
.\" 
.\" $XFree86: xc/doc/man/X11/XOpenIM.man,v 1.2 2001/01/27 18:20:02 dawes Exp $
.\"
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xW Athena X Widgets \- C Language X Toolkit Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.na
.de Ds
.nf
.\\$1D \\$2 \\$1
.ft 1
.\".ps \\n(PS
.\".if \\n(VS>=40 .vs \\n(VSu
.\".if \\n(VS<=39 .vs \\n(VSp
..
.de De
.ce 0
.if \\n(BD .DF
.nr BD 0
.in \\n(OIu
.if \\n(TM .ls 2
.sp \\n(DDu
.fi
..
.de FD
.LP
.KS
.TA .5i 3i
.ta .5i 3i
.nf
..
.de FN
.fi
.KE
.LP
..
.de IN		\" send an index entry to the stderr
..
.de C{
.KS
.nf
.D
.\"
.\"	choose appropriate monospace font
.\"	the imagen conditional, 480,
.\"	may be changed to L if LB is too
.\"	heavy for your eyes...
.\"
.ie "\\*(.T"480" .ft L
.el .ie "\\*(.T"300" .ft L
.el .ie "\\*(.T"202" .ft PO
.el .ie "\\*(.T"aps" .ft CW
.el .ft R
.ps \\n(PS
.ie \\n(VS>40 .vs \\n(VSu
.el .vs \\n(VSp
..
.de C}
.DE
.R
..
.de Pn
.ie t \\$1\fB\^\\$2\^\fR\\$3
.el \\$1\fI\^\\$2\^\fP\\$3
..
.de ZN
.ie t \fB\^\\$1\^\fR\\$2
.el \fI\^\\$1\^\fP\\$2
..
.de hN
.ie t <\fB\\$1\fR>\\$2
.el <\fI\\$1\fP>\\$2
..
.de NT
.ne 7
.ds NO Note
.if \\n(.$>$1 .if !'\\$2'C' .ds NO \\$2
.if \\n(.$ .if !'\\$1'C' .ds NO \\$1
.ie n .sp
.el .sp 10p
.TB
.ce
\\*(NO
.ie n .sp
.el .sp 5p
.if '\\$1'C' .ce 99
.if '\\$2'C' .ce 99
.in +5n
.ll -5n
.R
..
.		\" Note End -- doug kraft 3/85
.de NE
.ce 0
.in -5n
.ll +5n
.ie n .sp
.el .sp 10p
..
.ny0
.TH XOpenIM __libmansuffix__ __xorgversion__ "XLIB FUNCTIONS"
.SH NAME
XOpenIM, XCloseIM, XSetIMValues, XGetIMValues, XDisplayOfIM, XLocaleOfIM, XRegisterIMInstantiateCallback, XUnregisterIMInstantiateCallback \- open, close, and obtain input method information
.SH SYNTAX
.HP
XIM XOpenIM\^(\^Display *\fIdisplay\fP\^, XrmDatabase \fIdb\fP\^, char
*\fIres_name\fP\^, char *\fIres_class\fP\^); 
.HP
Status XCloseIM\^(\^XIM \fIim\fP\^); 
.HP
char *XSetIMValues\^(\^XIM \fIim\fP\^, ...); 
.HP
char *XGetIMValues\^(\^XIM \fIim\fP\^, ...); 
.HP
Display *XDisplayOfIM\^(\^XIM \fIim\fP\^); 
.HP
char *XLocaleOfIM\^(\^XIM \fIim\fP\^); 
.HP
Bool XRegisterIMInstantiateCallback\^(\^Display *\fIdisplay\fP\^, XrmDatabase
\fIdb\fP\^, char *\fIres_name\fP\^, char *\fIres_class\fP\^, XIDProc
\fIcallback\fP\^, XPointer \fIclient_data\fP\^); 
.HP
Bool XUnregisterIMInstantiateCallback\^(\^Display *\fIdisplay\fP\^,
XrmDatabase \fIdb\fP\^, char *\fIres_name\fP\^, char *\fIres_class\fP\^,
XIDProc \fIcallback\fP\^, XPointer \fIclient_data\fP\^); 
.LP
.SH ARGUMENTS
.IP \fIcallback\fP 1i
Specifies a pointer to the input method instantiate callback.
.IP \fIclient_data\fP 1i
Specifies the additional client data.
.IP \fIdb\fP 1i
Specifies a pointer to the resource database.
.IP \fIdisplay\fP 1i
Specifies the connection to the X server.
.IP \fIim\fP 1i
Specifies the input method.
.IP \fIres_class\fP 1i
Specifies the full class name of the application.
.IP \fIres_name\fP 1i
Specifies the full resource name of the application.
.ds Al \ to set or get XIM values
.IP ... 1i
Specifies the variable length argument list\*(Al.
.SH DESCRIPTION
The
.ZN XOpenIM
function opens an input method, 
matching the current locale and modifiers specification.
Current locale and modifiers are bound to the input method at opening time.
The locale associated with an input method cannot be changed dynamically.
This implies that the strings returned by
.ZN XmbLookupString
or
.ZN XwcLookupString ,
for any input context affiliated with a given input method
will be encoded in the locale current at the time the input method is opened.
.LP
The specific input method to which this call will be routed
is identified on the basis of the current locale. 
.ZN XOpenIM
will identify a default input method corresponding to the
current locale.
That default can be modified using 
.ZN XSetLocaleModifiers
for the input method modifier.
.LP
The db argument is the resource database to be used by the input method
for looking up resources that are private to the input method.
It is not intended that this database be used to look
up values that can be set as IC values in an input context.
If db is NULL,
no database is passed to the input method.
.LP
The res_name and res_class arguments specify the resource name 
and class of the application. 
They are intended to be used as prefixes by the input method
when looking up resources that are common to all input contexts
that may be created for this input method.
The characters used for resource names and classes must be in the
X Portable Character Set.
The resources looked up are not fully specified
if res_name or res_class is NULL.
.LP
The res_name and res_class arguments are not assumed to exist beyond
the call to
.ZN XOpenIM .
The specified resource database is assumed to exist for the lifetime
of the input method.
.LP
.ZN XOpenIM
returns NULL if no input method could be opened.
.LP
The
.ZN XCloseIM
function closes the specified input method.
.LP
The
.ZN XSetIMValues
function presents a variable argument list programming interface
for setting attributes of the specified input method.
It returns NULL if it succeeds;
otherwise,
it returns the name of the first argument that could not be set.
Xlib does not attempt to set arguments from the supplied list that
follow the failed argument;
all arguments in the list preceding the failed argument have been set
correctly.
.LP
The
.ZN XGetIMValues
function presents a variable argument list programming interface
for querying properties or features of the specified input method.
This function returns NULL if it succeeds;
otherwise,
it returns the name of the first argument that could not be obtained.
.LP
Each XIM value argument (following a name) must point to
a location where the XIM value is to be stored.
That is, if the XIM value is of type T,
the argument must be of type T*.
If T itself is a pointer type,
then
.ZN XGetIMValues
allocates memory to store the actual data,
and the client is responsible for freeing this data by calling
.ZN XFree
with the returned pointer.
.LP
The
.ZN XDisplayOfIM
function returns the display associated with the specified input method.
.LP
The
.ZN XLocaleOfIM
function returns the locale associated with the specified input method.
.LP
The
.ZN XRegisterIMInstantiateCallback
function registers a callback to be invoked whenever a new input method
becomes available for the specified display that matches the current
locale and modifiers.
.LP
The function returns 
.ZN True
if it succeeds; otherwise, it returns 
.ZN False .
.LP
The
.ZN XUnregisterIMInstantiateCallback
function removes an input method instantiation callback previously
registered.
The function returns
.ZN True
if it succeeds; otherwise, it returns 
.ZN False .
.SH "SEE ALSO"
XCreateIC(3X11),
XSetICFocus(3X11),
XSetICValues(3X11),
XmbResetIC(3X11)
.br
\fI\*(xL\fP
