/*
 *  gladexfce4 - glade module for libxfcegui4
 *
 *  Copyright (c) 2007 Brian Tarricone <bjt23@cornell.edu>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 of the License ONLY.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

/* Portions based on glade-gtk.c, which is Copyright (c) 2001 Ximian, Inc.,
   and is released under the GNU GPL as well. */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifdef HAVE_STRING_H
#include <string.h>
#endif

#include <gtk/gtk.h>

#include <gladeui/glade.h>

void
glade_xfce_titled_dialog_post_create(GladeWidgetAdaptor *adaptor,
                                     GObject *object, 
                                     GladeCreateReason reason)
{
    GtkDialog *dialog = GTK_DIALOG(object);
    GladeWidget *widget, *vbox_widget, *actionarea_widget;
    
    g_return_if_fail(GTK_IS_DIALOG(dialog));
    
    widget = glade_widget_get_from_gobject(GTK_WIDGET(dialog));
    if(!widget)
        return;
    
    if(reason == GLADE_CREATE_USER) {
        /* HIG compliant border-width defaults on dialogs */
        glade_widget_property_set(widget, "border-width", 5);
    }
    
    vbox_widget = glade_widget_adaptor_create_internal(widget,
                                                       G_OBJECT(dialog->vbox),
                                                       "vbox", "dialog",
                                                       FALSE, reason);
    
    actionarea_widget = glade_widget_adaptor_create_internal(vbox_widget, 
                                                             G_OBJECT(dialog->action_area),
                                                             "action_area",
                                                             "dialog", FALSE,
                                                             reason);
    
    /* These properties are controlled by the GtkDialog style properties:
     * "content-area-border", "button-spacing" and "action-area-border",
     * so we must disable thier use.
     */
    glade_widget_remove_property(vbox_widget, "border-width");
    glade_widget_remove_property(actionarea_widget, "border-width");
    glade_widget_remove_property(actionarea_widget, "spacing");
    
    /* Only set these on the original create. */
    if(reason == GLADE_CREATE_USER) {
        /* HIG compliant spacing defaults on dialogs */
        glade_widget_property_set(vbox_widget, "spacing", 2);
        glade_widget_property_set(vbox_widget, "size", 2);
        glade_widget_property_set(actionarea_widget, "size", 2);
        glade_widget_property_set(actionarea_widget, "layout-style",
                                  GTK_BUTTONBOX_END);
    }
}

GtkWidget *
glade_xfce_titled_dialog_get_internal_child(GladeWidgetAdaptor *adaptor,
                                            GtkDialog *dialog,
                                            const gchar *name)
{
    GtkWidget *child = NULL;
    
    g_return_val_if_fail(GTK_IS_DIALOG(dialog), NULL);
    
    if(!strcmp("vbox", name))
        child = dialog->vbox;
    else if(!strcmp("action_area", name))
        child = dialog->action_area;
    
    return child;
}

GList *
glade_xfce_titled_dialog_get_children(GladeWidgetAdaptor *adaptor,
                                      GtkDialog *dialog)
{
    g_return_val_if_fail(GTK_IS_DIALOG(dialog), NULL);
    return g_list_prepend(NULL, dialog->vbox);
}
