/* provider-dict.c generated by valac 0.56.18, the Vala compiler
 * generated from provider-dict.vala, do not modify */

/* enchant: ProviderDict
 * Copyright (C) 2003, 2004 Dom Lachowicz
 * Copyright (C) 2016-2025 Reuben Thomas <rrt@sc3d.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along along with this program; if not, see
 * <https://www.gnu.org/licenses/>.
 *
 * In addition, as a special exception, the copyright holders
 * give permission to link the code of this program with
 * non-LGPL Spelling Provider libraries (eg: a MSFT Office
 * spell checker backend) and distribute linked combinations including
 * the two.  You must obey the GNU Lesser General Public License in all
 * respects for all of the code used other than said providers.  If you modify
 * this file, you may extend this exception to your version of the
 * file, but you are not obligated to do so.  If you do not wish to
 * do so, delete this exception statement from your version.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <gmodule.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_ENCHANT_PROVIDER_DICT (enchant_provider_dict_get_type ())
#define ENCHANT_PROVIDER_DICT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ENCHANT_PROVIDER_DICT, EnchantProviderDict))
#define ENCHANT_PROVIDER_DICT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ENCHANT_PROVIDER_DICT, EnchantProviderDictClass))
#define IS_ENCHANT_PROVIDER_DICT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ENCHANT_PROVIDER_DICT))
#define IS_ENCHANT_PROVIDER_DICT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ENCHANT_PROVIDER_DICT))
#define ENCHANT_PROVIDER_DICT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ENCHANT_PROVIDER_DICT, EnchantProviderDictClass))

typedef struct _EnchantProviderDict EnchantProviderDict;
typedef struct _EnchantProviderDictClass EnchantProviderDictClass;
typedef gint (*DictCheck) (EnchantProviderDict* me, const gchar* word, size_t len);
typedef gchar** (*DictSuggest) (EnchantProviderDict* me, const gchar* word, size_t len, size_t* result_length1);
typedef void (*DictAddToSession) (EnchantProviderDict* me, const gchar* word, size_t len);
typedef void (*DictRemoveFromSession) (EnchantProviderDict* me, const gchar* word, size_t len);
typedef const gchar* (*DictGetExtraWordCharacters) (EnchantProviderDict* me);
typedef gint (*DictIsWordCharacter) (EnchantProviderDict* me, guint32 uc_in, size_t n);
typedef struct _EnchantProviderDictPrivate EnchantProviderDictPrivate;

#define TYPE_ENCHANT_PROVIDER (enchant_provider_get_type ())
#define ENCHANT_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ENCHANT_PROVIDER, EnchantProvider))
#define ENCHANT_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ENCHANT_PROVIDER, EnchantProviderClass))
#define IS_ENCHANT_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ENCHANT_PROVIDER))
#define IS_ENCHANT_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ENCHANT_PROVIDER))
#define ENCHANT_PROVIDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ENCHANT_PROVIDER, EnchantProviderClass))

typedef struct _EnchantProvider EnchantProvider;
typedef struct _EnchantProviderClass EnchantProviderClass;
typedef struct _EnchantProviderPrivate EnchantProviderPrivate;
typedef struct _EnchantBroker EnchantBroker;
typedef void (*ProviderDispose) (EnchantProvider* me);
typedef EnchantProviderDict* (*ProviderRequestDict) (EnchantProvider* me, const gchar* tag);
typedef void (*ProviderDisposeDict) (EnchantProvider* me, EnchantProviderDict* dict);
typedef gint (*ProviderDictionaryExists) (EnchantProvider* me, const gchar* tag);
typedef const gchar* (*ProviderIdentify) (EnchantProvider* me);
typedef const gchar* (*ProviderDescribe) (EnchantProvider* me);
typedef gchar** (*ProviderListDicts) (EnchantProvider* me, size_t* result_length1);
#define _enchant_provider_unref0(var) ((var == NULL) ? NULL : (var = (enchant_provider_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ParamSpecEnchantProviderDict ParamSpecEnchantProviderDict;

struct _EnchantProviderDict {
	GTypeInstance parent_instance;
	volatile int ref_count;
	EnchantProviderDictPrivate * priv;
	void* user_data;
	EnchantProvider* provider;
	gchar* language_tag;
	gchar* error;
	DictCheck check_method;
	DictSuggest suggest_method;
	DictAddToSession add_to_session_method;
	DictRemoveFromSession remove_from_session_method;
	DictGetExtraWordCharacters get_extra_word_characters_method;
	DictIsWordCharacter is_word_character_method;
};

struct _EnchantProviderDictClass {
	GTypeClass parent_class;
	void (*finalize) (EnchantProviderDict *self);
};

struct _EnchantProvider {
	GTypeInstance parent_instance;
	volatile int ref_count;
	EnchantProviderPrivate * priv;
	void* user_data;
	GModule* module;
	EnchantBroker* owner;
	ProviderDispose dispose;
	ProviderRequestDict request_dict;
	ProviderDisposeDict dispose_dict;
	ProviderDictionaryExists dictionary_exists;
	ProviderIdentify identify;
	ProviderDescribe describe;
	ProviderListDicts list_dicts;
};

struct _EnchantProviderClass {
	GTypeClass parent_class;
	void (*finalize) (EnchantProvider *self);
};

struct _ParamSpecEnchantProviderDict {
	GParamSpec parent_instance;
};

static gpointer enchant_provider_dict_parent_class = NULL;

VALA_EXTERN gpointer enchant_provider_dict_ref (gpointer instance);
VALA_EXTERN void enchant_provider_dict_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_enchant_provider_dict (const gchar* name,
                                              const gchar* nick,
                                              const gchar* blurb,
                                              GType object_type,
                                              GParamFlags flags);
VALA_EXTERN void value_set_enchant_provider_dict (GValue* value,
                                      gpointer v_object);
VALA_EXTERN void value_take_enchant_provider_dict (GValue* value,
                                       gpointer v_object);
VALA_EXTERN gpointer value_get_enchant_provider_dict (const GValue* value);
VALA_EXTERN GType enchant_provider_dict_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (EnchantProviderDict, enchant_provider_dict_unref)
VALA_EXTERN gpointer enchant_provider_ref (gpointer instance);
VALA_EXTERN void enchant_provider_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_enchant_provider (const gchar* name,
                                         const gchar* nick,
                                         const gchar* blurb,
                                         GType object_type,
                                         GParamFlags flags);
VALA_EXTERN void value_set_enchant_provider (GValue* value,
                                 gpointer v_object);
VALA_EXTERN void value_take_enchant_provider (GValue* value,
                                  gpointer v_object);
VALA_EXTERN gpointer value_get_enchant_provider (const GValue* value);
VALA_EXTERN GType enchant_provider_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (EnchantProvider, enchant_provider_unref)
VALA_EXTERN void enchant_broker_free (EnchantBroker * self);
G_DEFINE_AUTOPTR_CLEANUP_FUNC (EnchantBroker, enchant_broker_free)
VALA_EXTERN EnchantProviderDict* enchant_provider_dict_new (EnchantProvider* provider,
                                                const gchar* tag);
VALA_EXTERN EnchantProviderDict* enchant_provider_dict_construct (GType object_type,
                                                      EnchantProvider* provider,
                                                      const gchar* tag);
VALA_EXTERN void enchant_provider_dict_set_error (EnchantProviderDict* self,
                                      const gchar* err);
static void enchant_provider_dict_finalize (EnchantProviderDict * obj);
static GType enchant_provider_dict_get_type_once (void);

static gpointer
_enchant_provider_ref0 (gpointer self)
{
#line 60 "provider-dict.vala"
	return self ? enchant_provider_ref (self) : NULL;
#line 192 "provider-dict.c"
}

EnchantProviderDict*
enchant_provider_dict_construct (GType object_type,
                                 EnchantProvider* provider,
                                 const gchar* tag)
{
	EnchantProviderDict* self = NULL;
	EnchantProvider* _tmp0_;
	gchar* _tmp1_;
#line 59 "provider-dict.vala"
	g_return_val_if_fail (tag != NULL, NULL);
#line 59 "provider-dict.vala"
	self = (EnchantProviderDict*) g_type_create_instance (object_type);
#line 60 "provider-dict.vala"
	_tmp0_ = _enchant_provider_ref0 (provider);
#line 60 "provider-dict.vala"
	_enchant_provider_unref0 (self->provider);
#line 60 "provider-dict.vala"
	self->provider = _tmp0_;
#line 61 "provider-dict.vala"
	_tmp1_ = g_strdup (tag);
#line 61 "provider-dict.vala"
	_g_free0 (self->language_tag);
#line 61 "provider-dict.vala"
	self->language_tag = _tmp1_;
#line 62 "provider-dict.vala"
	_g_free0 (self->error);
#line 62 "provider-dict.vala"
	self->error = NULL;
#line 59 "provider-dict.vala"
	return self;
#line 225 "provider-dict.c"
}

EnchantProviderDict*
enchant_provider_dict_new (EnchantProvider* provider,
                           const gchar* tag)
{
#line 59 "provider-dict.vala"
	return enchant_provider_dict_construct (TYPE_ENCHANT_PROVIDER_DICT, provider, tag);
#line 234 "provider-dict.c"
}

void
enchant_provider_dict_set_error (EnchantProviderDict* self,
                                 const gchar* err)
{
	gchar* _tmp0_;
#line 70 "provider-dict.vala"
	g_return_if_fail (self != NULL);
#line 70 "provider-dict.vala"
	g_return_if_fail (err != NULL);
#line 71 "provider-dict.vala"
	g_debug ("provider-dict.vala:71: enchant_provider_dict_set_error: %s", err);
#line 72 "provider-dict.vala"
	_tmp0_ = g_strdup (err);
#line 72 "provider-dict.vala"
	_g_free0 (self->error);
#line 72 "provider-dict.vala"
	self->error = _tmp0_;
#line 254 "provider-dict.c"
}

static void
value_enchant_provider_dict_init (GValue* value)
{
#line 45 "provider-dict.vala"
	value->data[0].v_pointer = NULL;
#line 262 "provider-dict.c"
}

static void
value_enchant_provider_dict_free_value (GValue* value)
{
#line 45 "provider-dict.vala"
	if (value->data[0].v_pointer) {
#line 45 "provider-dict.vala"
		enchant_provider_dict_unref (value->data[0].v_pointer);
#line 272 "provider-dict.c"
	}
}

static void
value_enchant_provider_dict_copy_value (const GValue* src_value,
                                        GValue* dest_value)
{
#line 45 "provider-dict.vala"
	if (src_value->data[0].v_pointer) {
#line 45 "provider-dict.vala"
		dest_value->data[0].v_pointer = enchant_provider_dict_ref (src_value->data[0].v_pointer);
#line 284 "provider-dict.c"
	} else {
#line 45 "provider-dict.vala"
		dest_value->data[0].v_pointer = NULL;
#line 288 "provider-dict.c"
	}
}

static gpointer
value_enchant_provider_dict_peek_pointer (const GValue* value)
{
#line 45 "provider-dict.vala"
	return value->data[0].v_pointer;
#line 297 "provider-dict.c"
}

static gchar*
value_enchant_provider_dict_collect_value (GValue* value,
                                           guint n_collect_values,
                                           GTypeCValue* collect_values,
                                           guint collect_flags)
{
#line 45 "provider-dict.vala"
	if (collect_values[0].v_pointer) {
#line 308 "provider-dict.c"
		EnchantProviderDict * object;
		object = collect_values[0].v_pointer;
#line 45 "provider-dict.vala"
		if (object->parent_instance.g_class == NULL) {
#line 45 "provider-dict.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 315 "provider-dict.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 45 "provider-dict.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 319 "provider-dict.c"
		}
#line 45 "provider-dict.vala"
		value->data[0].v_pointer = enchant_provider_dict_ref (object);
#line 323 "provider-dict.c"
	} else {
#line 45 "provider-dict.vala"
		value->data[0].v_pointer = NULL;
#line 327 "provider-dict.c"
	}
#line 45 "provider-dict.vala"
	return NULL;
#line 331 "provider-dict.c"
}

static gchar*
value_enchant_provider_dict_lcopy_value (const GValue* value,
                                         guint n_collect_values,
                                         GTypeCValue* collect_values,
                                         guint collect_flags)
{
	EnchantProviderDict ** object_p;
	object_p = collect_values[0].v_pointer;
#line 45 "provider-dict.vala"
	if (!object_p) {
#line 45 "provider-dict.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 346 "provider-dict.c"
	}
#line 45 "provider-dict.vala"
	if (!value->data[0].v_pointer) {
#line 45 "provider-dict.vala"
		*object_p = NULL;
#line 352 "provider-dict.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 45 "provider-dict.vala"
		*object_p = value->data[0].v_pointer;
#line 356 "provider-dict.c"
	} else {
#line 45 "provider-dict.vala"
		*object_p = enchant_provider_dict_ref (value->data[0].v_pointer);
#line 360 "provider-dict.c"
	}
#line 45 "provider-dict.vala"
	return NULL;
#line 364 "provider-dict.c"
}

GParamSpec*
param_spec_enchant_provider_dict (const gchar* name,
                                  const gchar* nick,
                                  const gchar* blurb,
                                  GType object_type,
                                  GParamFlags flags)
{
	ParamSpecEnchantProviderDict* spec;
#line 45 "provider-dict.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_ENCHANT_PROVIDER_DICT), NULL);
#line 45 "provider-dict.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 45 "provider-dict.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 45 "provider-dict.vala"
	return G_PARAM_SPEC (spec);
#line 383 "provider-dict.c"
}

gpointer
value_get_enchant_provider_dict (const GValue* value)
{
#line 45 "provider-dict.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_ENCHANT_PROVIDER_DICT), NULL);
#line 45 "provider-dict.vala"
	return value->data[0].v_pointer;
#line 393 "provider-dict.c"
}

void
value_set_enchant_provider_dict (GValue* value,
                                 gpointer v_object)
{
	EnchantProviderDict * old;
#line 45 "provider-dict.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_ENCHANT_PROVIDER_DICT));
#line 45 "provider-dict.vala"
	old = value->data[0].v_pointer;
#line 45 "provider-dict.vala"
	if (v_object) {
#line 45 "provider-dict.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_ENCHANT_PROVIDER_DICT));
#line 45 "provider-dict.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 45 "provider-dict.vala"
		value->data[0].v_pointer = v_object;
#line 45 "provider-dict.vala"
		enchant_provider_dict_ref (value->data[0].v_pointer);
#line 415 "provider-dict.c"
	} else {
#line 45 "provider-dict.vala"
		value->data[0].v_pointer = NULL;
#line 419 "provider-dict.c"
	}
#line 45 "provider-dict.vala"
	if (old) {
#line 45 "provider-dict.vala"
		enchant_provider_dict_unref (old);
#line 425 "provider-dict.c"
	}
}

void
value_take_enchant_provider_dict (GValue* value,
                                  gpointer v_object)
{
	EnchantProviderDict * old;
#line 45 "provider-dict.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_ENCHANT_PROVIDER_DICT));
#line 45 "provider-dict.vala"
	old = value->data[0].v_pointer;
#line 45 "provider-dict.vala"
	if (v_object) {
#line 45 "provider-dict.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_ENCHANT_PROVIDER_DICT));
#line 45 "provider-dict.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 45 "provider-dict.vala"
		value->data[0].v_pointer = v_object;
#line 446 "provider-dict.c"
	} else {
#line 45 "provider-dict.vala"
		value->data[0].v_pointer = NULL;
#line 450 "provider-dict.c"
	}
#line 45 "provider-dict.vala"
	if (old) {
#line 45 "provider-dict.vala"
		enchant_provider_dict_unref (old);
#line 456 "provider-dict.c"
	}
}

static void
enchant_provider_dict_class_init (EnchantProviderDictClass * klass,
                                  gpointer klass_data)
{
#line 45 "provider-dict.vala"
	enchant_provider_dict_parent_class = g_type_class_peek_parent (klass);
#line 45 "provider-dict.vala"
	((EnchantProviderDictClass *) klass)->finalize = enchant_provider_dict_finalize;
#line 468 "provider-dict.c"
}

static void
enchant_provider_dict_instance_init (EnchantProviderDict * self,
                                     gpointer klass)
{
#line 45 "provider-dict.vala"
	self->ref_count = 1;
#line 477 "provider-dict.c"
}

static void
enchant_provider_dict_finalize (EnchantProviderDict * obj)
{
	EnchantProviderDict * self;
	EnchantProvider* _tmp0_;
#line 45 "provider-dict.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ENCHANT_PROVIDER_DICT, EnchantProviderDict);
#line 45 "provider-dict.vala"
	g_signal_handlers_destroy (self);
#line 66 "provider-dict.vala"
	_tmp0_ = self->provider;
#line 66 "provider-dict.vala"
	if (_tmp0_ != NULL) {
#line 493 "provider-dict.c"
		EnchantProvider* _tmp1_;
		ProviderDisposeDict _tmp2_;
		EnchantProvider* _tmp3_;
#line 67 "provider-dict.vala"
		_tmp1_ = self->provider;
#line 67 "provider-dict.vala"
		_tmp2_ = _tmp1_->dispose_dict;
#line 67 "provider-dict.vala"
		_tmp3_ = self->provider;
#line 67 "provider-dict.vala"
		_tmp2_ (_tmp3_, self);
#line 505 "provider-dict.c"
	}
#line 47 "provider-dict.vala"
	_enchant_provider_unref0 (self->provider);
#line 48 "provider-dict.vala"
	_g_free0 (self->language_tag);
#line 49 "provider-dict.vala"
	_g_free0 (self->error);
#line 513 "provider-dict.c"
}

static GType
enchant_provider_dict_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_enchant_provider_dict_init, value_enchant_provider_dict_free_value, value_enchant_provider_dict_copy_value, value_enchant_provider_dict_peek_pointer, "p", value_enchant_provider_dict_collect_value, "p", value_enchant_provider_dict_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (EnchantProviderDictClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) enchant_provider_dict_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EnchantProviderDict), 0, (GInstanceInitFunc) enchant_provider_dict_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType enchant_provider_dict_type_id;
	enchant_provider_dict_type_id = g_type_register_fundamental (g_type_fundamental_next (), "EnchantProviderDict", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return enchant_provider_dict_type_id;
}

GType
enchant_provider_dict_get_type (void)
{
	static volatile gsize enchant_provider_dict_type_id__once = 0;
	if (g_once_init_enter (&enchant_provider_dict_type_id__once)) {
		GType enchant_provider_dict_type_id;
		enchant_provider_dict_type_id = enchant_provider_dict_get_type_once ();
		g_once_init_leave (&enchant_provider_dict_type_id__once, enchant_provider_dict_type_id);
	}
	return enchant_provider_dict_type_id__once;
}

gpointer
enchant_provider_dict_ref (gpointer instance)
{
	EnchantProviderDict * self;
	self = instance;
#line 45 "provider-dict.vala"
	g_atomic_int_inc (&self->ref_count);
#line 45 "provider-dict.vala"
	return instance;
#line 548 "provider-dict.c"
}

void
enchant_provider_dict_unref (gpointer instance)
{
	EnchantProviderDict * self;
	self = instance;
#line 45 "provider-dict.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 45 "provider-dict.vala"
		ENCHANT_PROVIDER_DICT_GET_CLASS (self)->finalize (self);
#line 45 "provider-dict.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 562 "provider-dict.c"
	}
}

