//
// Copyright (c) 2017 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//

// ProgramPipeline.cpp: Implements the gl::ProgramPipeline class.
// Implements GL program pipeline objects and related functionality.
// [OpenGL ES 3.1] section 7.4 page 105.

#include "libANGLE/ProgramPipeline.h"

#include "libANGLE/angletypes.h"
#include "libANGLE/renderer/GLImplFactory.h"
#include "libANGLE/renderer/ProgramPipelineImpl.h"

namespace gl
{

ProgramPipelineState::ProgramPipelineState() : mLabel()
{
}

ProgramPipelineState::~ProgramPipelineState()
{
}

const std::string &ProgramPipelineState::getLabel() const
{
    return mLabel;
}

ProgramPipeline::ProgramPipeline(rx::GLImplFactory *factory, GLuint handle)
    : RefCountObject(handle),
      mProgramPipeline(factory->createProgramPipeline(mState))
{
    ASSERT(mProgramPipeline);
}

ProgramPipeline::~ProgramPipeline()
{
    mProgramPipeline.release();
}

void ProgramPipeline::setLabel(const std::string &label)
{
    mState.mLabel = label;
}

const std::string &ProgramPipeline::getLabel() const
{
    return mState.mLabel;
}

rx::ProgramPipelineImpl *ProgramPipeline::getImplementation() const
{
    return mProgramPipeline.get();
}

}  // namespace gl
