/*	$NetBSD: imx7_gpcreg.h,v 1.2 2016/10/17 09:21:51 ryo Exp $	*/

/*
 * Copyright (c) 2015 Internet Initiative Japan, Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _ARM_IMX_IMX7_GPCREG_H_
#define _ARM_IMX_IMX7_GPCREG_H_

#include <sys/cdefs.h>

/* General Power Controller (AIPS1_GPC_BASE:0x303a0000) */
#define GPC_LPCR_A7_BSC					0x00000000
#define  GPC_LPCR_A7_BSC_IRQ_SRC_A7_WUP			__BIT(30)
#define GPC_LPCR_A7_AD					0x00000004
#define GPC_LPCR_M4					0x00000008
#define GPC_SLPCR					0x00000014
#define  GPC_SLPCR_EN_DSM				__BIT(31)
#define  GPC_SLPCR_RBC_EN				__BIT(30)
#define  GPC_SLPCR_REG_BYPASS_COUNT			__BITS(29, 24)
#define  GPC_SLPCR_DISABLE_A7_IS_DSM			__BIT(23)
#define  GPC_SLPCR_EN_M4_FASTWUP_STOP_MODE		__BIT(19)
#define  GPC_SLPCR_EN_M4_FASTWUP_WAIT_MODE		__BIT(18)
#define  GPC_SLPCR_EN_A7_FASTWUP_STOP_MODE		__BIT(17)
#define  GPC_SLPCR_EN_A7_FASTWUP_WAIT_MODE		__BIT(16)
#define  GPC_SLPCR_OSCCNT				__BITS(15, 8)
#define  GPC_SLPCR_COSC_EN				__BIT(7)
#define  GPC_SLPCR_COSC_PWRDOWN				__BIT(6)
#define  GPC_SLPCR_STBY_COUNT				__BITS(5, 3)
#define  GPC_SLPCR_VSTBY				__BIT(2)
#define  GPC_SLPCR_SBYOS				__BIT(1)
#define  GPC_SLPCR_BYPASS_PMIC_READY			__BIT(0)
#define GPC_MLPCR					0x00000020
#define  GPC_MLPCR_MEMLP_CTL_DIS			__BIT(0)

#define GPC_PGC_ACK_SEL_A7				0x00000024
#define  GPC_PGC_ACK_SEL_A7_A7_PGC_PUP_ACK		__BIT(31)
#define  GPC_PGC_ACK_SEL_A7_A7_PGC_PDN_ACK		__BIT(15)
#define GPC_PGC_ACK_SEL_M4				0x00000028
#define  GPC_PGC_ACK_SEL_M4_M4_DUMMY_PGC_PUP_ACK	__BIT(31)
#define  GPC_PGC_ACK_SEL_M4_M4_DUMMY_PGC_PDN_ACK	__BIT(15)
#define GPC_MISC					0x0000002c
#define GPC_IMR1_CORE0_A7				0x00000030
#define GPC_IMR2_CORE0_A7				0x00000034
#define GPC_IMR3_CORE0_A7				0x00000038
#define GPC_IMR4_CORE0_A7				0x0000003c
#define GPC_IMR1_CORE1_A7				0x00000040
#define GPC_IMR2_CORE1_A7				0x00000044
#define GPC_IMR3_CORE1_A7				0x00000048
#define GPC_IMR4_CORE1_A7				0x0000004c
#define GPC_IMR1_M4					0x00000050
#define GPC_IMR2_M4					0x00000054
#define GPC_IMR3_M4					0x00000058
#define GPC_IMR4_M4					0x0000005c
#define GPC_ISR1_A7					0x00000070
#define GPC_ISR2_A7					0x00000074
#define GPC_ISR3_A7					0x00000078
#define GPC_ISR4_A7					0x0000007c
#define GPC_ISR1_M4					0x00000080
#define GPC_ISR2_M4					0x00000084
#define GPC_ISR3_M4					0x00000088
#define GPC_ISR4_M4					0x0000008c
#define GPC_SLT0_CFG					0x000000b0
#define GPC_SLT1_CFG					0x000000b4
#define GPC_SLT2_CFG					0x000000b8
#define GPC_SLT3_CFG					0x000000bc
#define GPC_SLT4_CFG					0x000000c0
#define GPC_SLT5_CFG					0x000000c4
#define GPC_SLT6_CFG					0x000000c8
#define GPC_SLT7_CFG					0x000000cc
#define GPC_SLT8_CFG					0x000000d0
#define GPC_SLT9_CFG					0x000000d4
#define GPC_PGC_CPU_MAPPING				0x000000ec
#define  GPC_PGC_CPU_MAPPING_FASTMEGA_A7_DOMAIN		__BIT(0)
#define  GPC_PGC_CPU_MAPPING_FASTMEGA_M4_DOMAIN		__BIT(8)
#define GPC_CPU_PGC_SW_PUP_REQ				0x000000f0
#define GPC_PU_PGC_SW_PUP_REQ				0x000000f8
#define GPC_CPU_PGC_SW_PDN_REQ				0x000000fc
#define GPC_PU_PGC_SW_PDN_REQ				0x00000104
#define GPC_LPS_A7					0x00000110
#define GPC_LPS_M4					0x00000114
#define GPC_GPC_GPR					0x00000120
#define GPC_GTOR					0x00000124
#define GPC_DEBUG_ADDR1					0x00000128
#define GPC_DEBUG_ADDR2					0x0000012c
#define GPC_CPU_PGC_PUP_STATUS1				0x00000130
#define GPC_A7_PU_PGC_PUP_STATUS0			0x00000134
#define GPC_A7_PU_PGC_PUP_STATUS1			0x00000138
#define GPC_M4_PU_PGC_PUP_STATUS0			0x00000138
#define GPC_A7_PU_PGC_PUP_STATUS2			0x0000013c
#define GPC_M4_PU_PGC_PUP_STATUS1			0x0000013c
#define GPC_M4_PU_PGC_PUP_STATUS2			0x00000140
#define GPC_CPU_PGC_PDN_STATUS1				0x00000170
#define GPC_A7_PU_PGC_PDN_STATUS0			0x0000018c
#define GPC_A7_PU_PGC_PDN_STATUS1			0x00000190
#define GPC_A7_PU_PGC_PDN_STATUS2			0x00000194
#define GPC_M4_PU_PGC_PDN_STATUS0			0x00000198
#define GPC_M4_PU_PGC_PDN_STATUS1			0x0000019c
#define GPC_M4_PU_PGC_PDN_STATUS2			0x000001a0
#define GPC_A7_MIX_PDN_FLG				0x000001b0
#define GPC_A7_PU_PDN_FLG				0x000001b4
#define GPC_M4_MIX_PDN_FLG				0x000001b8
#define GPC_M4_PU_PDN_FLG				0x000001bc
#define GPC_PGC_A7CORE0_CTRL				0x00000800
#define GPC_PGC_A7CORE0_PUPSCR				0x00000804
#define GPC_PGC_A7CORE0_PDNSCR				0x00000808
#define GPC_PGC_A7CORE0_SR				0x0000080c
#define GPC_PGC_A7CORE1_CTRL				0x00000840
#define GPC_PGC_A7CORE1_PUPSCR				0x00000844
#define GPC_PGC_A7CORE1_PDNSCR				0x00000848
#define GPC_PGC_A7CORE1_SR				0x0000084c
#define GPC_PGC_A7SCU_CTRL				0x00000880
#define GPC_PGC_A7SCU_PUPSCR				0x00000884
#define GPC_PGC_A7SCU_PDNSCR				0x00000888
#define GPC_PGC_A7SCU_SR				0x0000088c
#define GPC_PGC_SCU_AUXSW				0x00000890
#define  GPC_PGC_SCU_AUXSW_MEMPWR_TRC1_TMC		__BITS(29, 20)
#define  GPC_PGC_SCU_AUXSW_L2RETN_TRC1_TMC_TMR		__BITS(19, 10)
#define  GPC_PGC_SCU_AUXSW_DFTRAM_TRC1_TMC_TMR_TCD2	__BITS(9, 0)
#define GPC_PGC_MIX_CTRL				0x000008c0
#define GPC_PGC_MIX_PUPSCR				0x000008c4
#define GPC_PGC_MIX_PDNSCR				0x000008c8
#define GPC_PGC_MIX_SR					0x000008cc
#define GPC_PGC_MIPI_CTRL				0x00000900
#define GPC_PGC_MIPI_PUPSCR				0x00000904
#define GPC_PGC_MIPI_PDNSCR				0x00000908
#define GPC_PGC_MIPI_SR					0x0000090c
#define GPC_PGC_PCIE_CTRL				0x00000940
#define GPC_PGC_PCIE_PUPSCR				0x00000944
#define GPC_PGC_PCIE_PDNSCR				0x00000948
#define GPC_PGC_PCIE_SR					0x0000094c
#define GPC_PGC_MIPI_AUXSW				0x00000c10
#define GPC_PGC_PCIE_AUXSW				0x00000c50
#define GPC_PGC_HSIC_CTRL				0x00000d00
#define GPC_PGC_HSIC_PUPSCR				0x00000d04
#define GPC_PGC_HSIC_PDNSCR				0x00000d08
#define GPC_PGC_HSIC_SR					0x00000d0c

#define AIPS1_GPC_SIZE					0x00001000

#endif /* _ARM_IMX_IMX7_GPCREG_H_ */
