/* $NetBSD: tegra_hdmireg.h,v 1.5 2015/11/10 00:33:46 jmcneill Exp $ */

/*-
 * Copyright (c) 2015 Jared D. McNeill <jmcneill@invisible.ca>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef _ARM_TEGRA_HDMIREG_H
#define _ARM_TEGRA_HDMIREG_H

/*
 * HDMI Registers
 */
#define HDMI_CTXSW_REG						0x000

#define HDMI_NV_PDISP_SOR_STATE0_REG				0x004
#define HDMI_NV_PDISP_SOR_STATE0_UPDATE				__BIT(0)

#define HDMI_NV_PDISP_SOR_STATE1_REG				0x008
#define HDMI_NV_PDISP_SOR_STATE1_ARM_SHOW_VGA			__BIT(4)
#define HDMI_NV_PDISP_SOR_STATE1_ATTACHED			__BIT(3)
#define HDMI_NV_PDISP_SOR_STATE1_ASY_ORMODE			__BIT(2)
#define HDMI_NV_PDISP_SOR_STATE1_ASY_HEAD_OPMODE		__BITS(1,0)
#define HDMI_NV_PDISP_SOR_STATE1_ASY_HEAD_OPMODE_SLEEP		0
#define HDMI_NV_PDISP_SOR_STATE1_ASY_HEAD_OPMODE_SNOOZE		1
#define HDMI_NV_PDISP_SOR_STATE1_ASY_HEAD_OPMODE_AWAKE		2

#define HDMI_NV_PDISP_SOR_STATE2_REG				0x00c
#define HDMI_NV_PDISP_SOR_STATE2_ASY_DEPOL			__BIT(14)
#define HDMI_NV_PDISP_SOR_STATE2_ASY_VSYNCPOL			__BIT(13)
#define HDMI_NV_PDISP_SOR_STATE2_ASY_HSYNCPOL			__BIT(12)
#define HDMI_NV_PDISP_SOR_STATE2_ASY_PROTOCOL			__BITS(11,8)
#define HDMI_NV_PDISP_SOR_STATE2_ASY_CRCMODE			__BITS(7,6)
#define HDMI_NV_PDISP_SOR_STATE2_ASY_SUBOWNER			__BITS(5,4)
#define HDMI_NV_PDISP_SOR_STATE2_ASY_OWNER			__BITS(3,0)

#define HDMI_NV_PDISP_HDMI_AUDIO_EMU0_REG			0x068
#define HDMI_NV_PDISP_HDMI_AUDIO_EMU_RDATA0_REG			0x06c
#define HDMI_NV_PDISP_HDMI_AUDIO_EMU1_REG			0x070
#define HDMI_NV_PDISP_HDMI_AUDIO_EMU2_REG			0x074

#define HDMI_NV_PDISP_HDMI_AUDIO_INFOFRAME_CTRL_REG		0x078
#define HDMI_NV_PDISP_HDMI_AUDIO_INFOFRAME_CTRL_CHKSUM_HW	__BIT(9)
#define HDMI_NV_PDISP_HDMI_AUDIO_INFOFRAME_CTRL_SINGLE		__BIT(8)
#define HDMI_NV_PDISP_HDMI_AUDIO_INFOFRAME_CTRL_OTHER		__BIT(4)
#define HDMI_NV_PDISP_HDMI_AUDIO_INFOFRAME_CTRL_ENABLE		__BIT(0)

#define HDMI_NV_PDISP_HDMI_AUDIO_INFOFRAME_STATUS_REG		0x07c
#define HDMI_NV_PDISP_HDMI_AUDIO_INFOFRAME_HEADER_REG		0x080
#define HDMI_NV_PDISP_HDMI_AUDIO_INFOFRAME_SUBPACK0_LOW_REG	0x084
#define HDMI_NV_PDISP_HDMI_AUDIO_INFOFRAME_SUBPACK0_HIGH_REG	0x088

#define HDMI_NV_PDISP_HDMI_AVI_INFOFRAME_CTRL_REG		0x08c
#define HDMI_NV_PDISP_HDMI_AVI_INFOFRAME_CTRL_CHKSUM_HW	__BIT(9)
#define HDMI_NV_PDISP_HDMI_AVI_INFOFRAME_CTRL_SINGLE		__BIT(8)
#define HDMI_NV_PDISP_HDMI_AVI_INFOFRAME_CTRL_OTHER		__BIT(4)
#define HDMI_NV_PDISP_HDMI_AVI_INFOFRAME_CTRL_ENABLE		__BIT(0)

#define HDMI_NV_PDISP_HDMI_AVI_INFOFRAME_STATUS_REG		0x090
#define HDMI_NV_PDISP_HDMI_AVI_INFOFRAME_HEADER_REG		0x094
#define HDMI_NV_PDISP_HDMI_AVI_INFOFRAME_SUBPACK0_LOW_REG	0x098
#define HDMI_NV_PDISP_HDMI_AVI_INFOFRAME_SUBPACK0_HIGH_REG	0x09c
#define HDMI_NV_PDISP_HDMI_AVI_INFOFRAME_SUBPACK1_LOW_REG	0x0a0
#define HDMI_NV_PDISP_HDMI_AVI_INFOFRAME_SUBPACK1_HIGH_REG	0x0a4

#define HDMI_NV_PDISP_HDMI_GENERIC_CTRL_REG			0x0a8
#define HDMI_NV_PDISP_HDMI_GENERIC_CTRL_AUDIO			__BIT(16)
#define HDMI_NV_PDISP_HDMI_GENERIC_CTRL_HBLANK			__BIT(12)
#define HDMI_NV_PDISP_HDMI_GENERIC_CTRL_SINGLE			__BIT(8)
#define HDMI_NV_PDISP_HDMI_GENERIC_CTRL_OTHER			__BIT(4)
#define HDMI_NV_PDISP_HDMI_GENERIC_CTRL_ENABLE			__BIT(0)

#define HDMI_NV_PDISP_HDMI_GENERIC_STATUS_REG			0x0ac
#define HDMI_NV_PDISP_HDMI_GENERIC_HEADER_REG			0x0b0
#define HDMI_NV_PDISP_HDMI_GENERIC_INFOFRAME_SUBPACK0_LOW_REG	0x0b4
#define HDMI_NV_PDISP_HDMI_GENERIC_INFOFRAME_SUBPACK0_HIGH_REG	0x0b8
#define HDMI_NV_PDISP_HDMI_GENERIC_INFOFRAME_SUBPACK1_LOW_REG	0x0bc
#define HDMI_NV_PDISP_HDMI_GENERIC_INFOFRAME_SUBPACK1_HIGH_REG	0x0c0
#define HDMI_NV_PDISP_HDMI_GENERIC_INFOFRAME_SUBPACK2_LOW_REG	0x0c4
#define HDMI_NV_PDISP_HDMI_GENERIC_INFOFRAME_SUBPACK2_HIGH_REG	0x0c8
#define HDMI_NV_PDISP_HDMI_GENERIC_INFOFRAME_SUBPACK3_LOW_REG	0x0cc
#define HDMI_NV_PDISP_HDMI_GENERIC_INFOFRAME_SUBPACK3_HIGH_REG	0x0d0
#define HDMI_NV_PDISP_HDMI_ACR_CTRL_REG				0x0d4
#define HDMI_NV_PDISP_HDMI_ACR_0320_SUBPACK_LOW_REG		0x0d8
#define HDMI_NV_PDISP_HDMI_ACR_0320_SUBPACK_HIGH_REG		0x0dc
#define HDMI_NV_PDISP_HDMI_ACR_0441_SUBPACK_LOW_REG		0x0e0
#define HDMI_NV_PDISP_HDMI_ACR_0441_SUBPACK_HIGH_REG		0x0e4
#define HDMI_NV_PDISP_HDMI_ACR_0882_SUBPACK_LOW_REG		0x0e8
#define HDMI_NV_PDISP_HDMI_ACR_0882_SUBPACK_HIGH_REG		0x0ec
#define HDMI_NV_PDISP_HDMI_ACR_1764_SUBPACK_LOW_REG		0x0f0
#define HDMI_NV_PDISP_HDMI_ACR_1764_SUBPACK_HIGH_REG		0x0f4
#define HDMI_NV_PDISP_HDMI_ACR_0480_SUBPACK_LOW_REG		0x0f8
#define HDMI_NV_PDISP_HDMI_ACR_0480_SUBPACK_HIGH_REG		0x0fc
#define HDMI_NV_PDISP_HDMI_ACR_0960_SUBPACK_LOW_REG		0x100
#define HDMI_NV_PDISP_HDMI_ACR_0960_SUBPACK_HIGH_REG		0x104
#define HDMI_NV_PDISP_HDMI_ACR_1920_SUBPACK_LOW_REG		0x108
#define HDMI_NV_PDISP_HDMI_ACR_1920_SUBPACK_HIGH_REG		0x10c

#define HDMI_NV_PDISP_HDMI_CTRL_REG				0x110
#define HDMI_NV_PDISP_HDMI_CTRL_ENABLE				__BIT(30)
#define HDMI_NV_PDISP_HDMI_CTRL_CA_SELECT			__BIT(28)
#define HDMI_NV_PDISP_HDMI_CTRL_SS_SELECT			__BIT(27)
#define HDMI_NV_PDISP_HDMI_CTRL_SF_SELECT			__BIT(26)
#define HDMI_NV_PDISP_HDMI_CTRL_CC_SELECT			__BIT(25)
#define HDMI_NV_PDISP_HDMI_CTRL_CT_SELECT			__BIT(24)
#define HDMI_NV_PDISP_HDMI_CTRL_MAX_AC_PACKET			__BITS(20,16)
#define HDMI_NV_PDISP_HDMI_CTRL_SAMPLE_FLAT			__BIT(12)
#define HDMI_NV_PDISP_HDMI_CTRL_AUDIO_LAYOUT_SELECT		__BIT(10)
#define HDMI_NV_PDISP_HDMI_CTRL_AUDIO_LAYOUT			__BIT(8)
#define HDMI_NV_PDISP_HDMI_CTRL_REKEY				__BITS(6,0)

#define HDMI_NV_PDISP_HDMI_VSYNC_KEEPOUT_REG			0x114
#define HDMI_NV_PDISP_HDMI_VSYNC_WINDOW_REG			0x118
#define HDMI_NV_PDISP_HDMI_GCP_CTRL_REG				0x11c
#define HDMI_NV_PDISP_HDMI_GCP_STATUS_REG			0x120
#define HDMI_NV_PDISP_HDMI_GCP_SUBPACK_REG			0x124
#define HDMI_NV_PDISP_HDMI_CHANNEL_STATUS1_REG			0x128
#define HDMI_NV_PDISP_HDMI_CHANNEL_STATUS2_REG			0x12c
#define HDMI_NV_PDISP_HDMI_EMU0_REG				0x130
#define HDMI_NV_PDISP_HDMI_EMU1_REG				0x134
#define HDMI_NV_PDISP_HDMI_EMU1_RDATA_REG			0x138

#define HDMI_NV_PDISP_HDMI_SPARE_REG				0x13c
#define HDMI_NV_PDISP_HDMI_SPARE_HW_CTS				__BIT(0)
#define HDMI_NV_PDISP_HDMI_SPARE_FORCE_SW_CTS			__BIT(1)
#define HDMI_NV_PDISP_HDMI_SPARE_CTS_RESET_VAL			__BITS(18,16)

#define HDMI_NV_PDISP_HDMI_SPDIF_CHN_STATUS1_REG		0x140
#define HDMI_NV_PDISP_HDMI_SPDIF_CHN_STAUTS2_REG		0x144
#define HDMI_NV_PDISP_CRC_CONTROL_REG				0x258

#define HDMI_NV_PDISP_INPUT_CONTROL_REG				0x25c
#define HDMI_NV_PDISP_INPUT_CONTROL_ARM_VIDEO_RANGE		__BIT(1)
#define HDMI_NV_PDISP_INPUT_CONTROL_HDMI_SRC_SELECT		__BIT(0)

#define HDMI_NV_PDISP_SCRATCH_REG				0x260
#define HDMI_NV_PDISP_PE_CURRENT_REG				0x264
#define HDMI_NV_PDISP_KEY_CTRL_REG				0x268
#define HDMI_NV_PDISP_KEY_DEBUG0_REG				0x26c
#define HDMI_NV_PDISP_KEY_DEBUG1_REG				0x270
#define HDMI_NV_PDISP_KEY_DEBUG2_REG				0x274
#define HDMI_NV_PDISP_KEY_HDCP_KEY_0_REG			0x278
#define HDMI_NV_PDISP_KEY_HDCP_KEY_1_REG			0x27c
#define HDMI_NV_PDISP_KEY_HDCP_KEY_2_REG			0x280
#define HDMI_NV_PDISP_KEY_HDCP_KEY_3_REG			0x284
#define HDMI_NV_PDISP_KEY_HDCP_KEY_TRIG_REG			0x288
#define HDMI_NV_PDISP_KEY_SKEY_INDEX_REG			0x28c
#define HDMI_NV_PDISP_INT_STATUS_REG				0x330
#define HDMI_NV_PDISP_INT_MASK_REG				0x334
#define HDMI_NV_PDISP_INT_ENABLE_REG				0x338
#define HDMI_NV_PDISP_HDMI_VSI_INFOFRAME_CTRL_REG		0x358
#define HDMI_NV_PDISP_HDMI_VSI_INFOFRAME_STATUS_REG		0x35c
#define HDMI_NV_PDISP_HDMI_VSI_INFOFRAME_HEADER_REG		0x360
#define HDMI_NV_PDISP_HDMI_VSI_INFOFRAME_SUBPACK0_LOW_REG	0x364
#define HDMI_NV_PDISP_HDMI_VSI_INFOFRAME_SUBPACK0_HIGH_REG	0x368
#define HDMI_NV_PDISP_HDMI_VSI_INFOFRAME_SUBPACK1_LOW_REG	0x36c
#define HDMI_NV_PDISP_HDMI_VSI_INFOFRAME_SUBPACK1_HIGH_REG	0x370
#define HDMI_NV_PDISP_HDMI_VSI_INFOFRAME_SUBPACK2_LOW_REG	0x374
#define HDMI_NV_PDISP_HDMI_VSI_INFOFRAME_SUBPACK2_HIGH_REG	0x378
#define HDMI_NV_PDISP_HDMI_VSI_INFOFRAME_SUBPACK3_LOW_REG	0x37c
#define HDMI_NV_PDISP_HDMI_VSI_INFOFRAME_SUBPACK3_HIGH_REG	0x380

/*
 * Serial Output Resource Registers
 */
#define HDMI_NV_PDISP_SOR_PWR_REG				0x154
#define HDMI_NV_PDISP_SOR_PWR_SETTING_NEW			__BIT(31)
#define HDMI_NV_PDISP_SOR_PWR_MODE				__BIT(28)
#define HDMI_NV_PDISP_SOR_PWR_HALT_DELAY			__BIT(24)
#define HDMI_NV_PDISP_SOR_PWR_SAFE_START			__BIT(17)
#define HDMI_NV_PDISP_SOR_PWR_SAFE_STATE			__BIT(16)
#define HDMI_NV_PDISP_SOR_PWR_NORMAL_START			__BIT(1)
#define HDMI_NV_PDISP_SOR_PWR_NORMAL_STATE			__BIT(0)

#define HDMI_NV_PDISP_SOR_TEST_REG				0x158

#define HDMI_NV_PDISP_SOR_PLL0_REG				0x15c
#define HDMI_NV_PDISP_SOR_PLL0_TX_REG_LOAD			__BITS(29,28)
#define HDMI_NV_PDISP_SOR_PLL0_ICHPMP				__BITS(27,24)
#define HDMI_NV_PDISP_SOR_PLL0_FILTER				__BITS(19,16)
#define HDMI_NV_PDISP_SOR_PLL0_BG_V17_S				__BITS(15,12)
#define HDMI_NV_PDISP_SOR_PLL0_VCOCAP				__BITS(11,8)
#define HDMI_NV_PDISP_SOR_PLL0_PULLDOWN				__BIT(5)
#define HDMI_NV_PDISP_SOR_PLL0_RESISTORSEL			__BIT(4)
#define HDMI_NV_PDISP_SOR_PLL0_PDPORT				__BIT(3)
#define HDMI_NV_PDISP_SOR_PLL0_VCOPD				__BIT(2)
#define HDMI_NV_PDISP_SOR_PLL0_PDBG				__BIT(1)
#define HDMI_NV_PDISP_SOR_PLL0_PWR				__BIT(0)

#define HDMI_NV_PDISP_SOR_PLL1_REG				0x160
#define HDMI_NV_PDISP_SOR_PLL2_REG				0x164

#define HDMI_NV_PDISP_SOR_CSTM_REG				0x168
#define HDMI_NV_PDISP_SOR_CSTM_ROTDAT				__BITS(30,28)
#define HDMI_NV_PDISP_SOR_CSTM_ROTCLK				__BITS(27,24)
#define HDMI_NV_PDISP_SOR_CSTM_PLLDIV				__BIT(21)
#define HDMI_NV_PDISP_SOR_CSTM_BALANCED				__BIT(19)
#define HDMI_NV_PDISP_SOR_CSTM_NEW_MODE				__BIT(18)
#define HDMI_NV_PDISP_SOR_CSTM_DUP_SYNC				__BIT(17)
#define HDMI_NV_PDISP_SOR_CSTM_LVDS_EN				__BIT(16)
#define HDMI_NV_PDISP_SOR_CSTM_LINKACTB				__BIT(15)
#define HDMI_NV_PDISP_SOR_CSTM_LINKACTA				__BIT(14)
#define HDMI_NV_PDISP_SOR_CSTM_MODE				__BITS(13,12)
#define HDMI_NV_PDISP_SOR_CSTM_MODE_LVDS			0
#define HDMI_NV_PDISP_SOR_CSTM_MODE_TMDS			1
#define HDMI_NV_PDISP_SOR_CSTM_UPPER				__BIT(11)
#define HDMI_NV_PDISP_SOR_CSTM_PD_TXCB				__BIT(9)
#define HDMI_NV_PDISP_SOR_CSTM_PD_TXCA				__BIT(8)
#define HDMI_NV_PDISP_SOR_CSTM_PD_TXDB_3			__BIT(7)
#define HDMI_NV_PDISP_SOR_CSTM_PD_TXDB_2			__BIT(6)
#define HDMI_NV_PDISP_SOR_CSTM_PD_TXDB_1			__BIT(5)
#define HDMI_NV_PDISP_SOR_CSTM_PD_TXDB_0			__BIT(4)
#define HDMI_NV_PDISP_SOR_CSTM_PD_TXDA_3			__BIT(3)
#define HDMI_NV_PDISP_SOR_CSTM_PD_TXDA_2			__BIT(2)
#define HDMI_NV_PDISP_SOR_CSTM_PD_TXDA_1			__BIT(1)
#define HDMI_NV_PDISP_SOR_CSTM_PD_TXDA_0			__BIT(0)

#define HDMI_NV_PDISP_SOR_LVDS_REG				0x16c
#define HDMI_NV_PDISP_SOR_CRCA_REG				0x170
#define HDMI_NV_PDISP_SOR_CRCB_REG				0x174

#define HDMI_NV_PDISP_SOR_BLANK_REG				0x178
#define HDMI_NV_PDISP_SOR_BLANK_STATUS				__BIT(2)
#define HDMI_NV_PDISP_SOR_BLANK_TRANSITION			__BIT(1)
#define HDMI_NV_PDISP_SOR_BLANK_OVERRIDE			__BIT(0)

#define HDMI_NV_PDISP_SOR_SEQ_CTL_REG				0x17c
#define HDMI_NV_PDISP_SOR_SEQ_CTL_SWITCH			__BIT(30)
#define HDMI_NV_PDISP_SOR_SEQ_CTL_STATUS			__BIT(28)
#define HDMI_NV_PDISP_SOR_SEQ_CTL_PC				__BITS(19,16)
#define HDMI_NV_PDISP_SOR_SEQ_CTL_PD_PC_ALT			__BITS(15,12)
#define HDMI_NV_PDISP_SOR_SEQ_CTL_PD_PC				__BITS(11,8)
#define HDMI_NV_PDISP_SOR_SEQ_CTL_PU_PC_ALT			__BITS(7,4)
#define HDMI_NV_PDISP_SOR_SEQ_CTL_PU_PC				__BITS(3,0)

#define HDMI_NV_PDISP_SOR_SEQ_INST0_REG				0x180
#define HDMI_NV_PDISP_SOR_SEQ_INST1_REG				0x184
#define HDMI_NV_PDISP_SOR_SEQ_INST2_REG				0x188
#define HDMI_NV_PDISP_SOR_SEQ_INST3_REG				0x18c
#define HDMI_NV_PDISP_SOR_SEQ_INST4_REG				0x190
#define HDMI_NV_PDISP_SOR_SEQ_INST5_REG				0x194
#define HDMI_NV_PDISP_SOR_SEQ_INST6_REG				0x198
#define HDMI_NV_PDISP_SOR_SEQ_INST7_REG				0x19c
#define HDMI_NV_PDISP_SOR_SEQ_INST8_REG				0x1a0
#define HDMI_NV_PDISP_SOR_SEQ_INST9_REG				0x1a4
#define HDMI_NV_PDISP_SOR_SEQ_INSTA_REG				0x1a8
#define HDMI_NV_PDISP_SOR_SEQ_INSTB_REG				0x1ac
#define HDMI_NV_PDISP_SOR_SEQ_INSTC_REG				0x1b0
#define HDMI_NV_PDISP_SOR_SEQ_INSTD_REG				0x1b4
#define HDMI_NV_PDISP_SOR_SEQ_INSTE_REG				0x1b8
#define HDMI_NV_PDISP_SOR_SEQ_INSTF_REG				0x1bc
#define HDMI_NV_PDISP_SOR_SEQ_INST_PLL_PULLDOWN			__BIT(31)
#define HDMI_NV_PDISP_SOR_SEQ_INST_POWERDOWN_MACRO		__BIT(30)
#define HDMI_NV_PDISP_SOR_SEQ_INST_ASSERT_PLL_RESETV		__BIT(29)
#define HDMI_NV_PDISP_SOR_SEQ_INST_BLANK_V			__BIT(28)
#define HDMI_NV_PDISP_SOR_SEQ_INST_BLANK_H			__BIT(27)
#define HDMI_NV_PDISP_SOR_SEQ_INST_BLANK_DE			__BIT(26)
#define HDMI_NV_PDISP_SOR_SEQ_INST_BLACK_DATA			__BIT(25)
#define HDMI_NV_PDISP_SOR_SEQ_INST_TRISTATE_IOS			__BIT(24)
#define HDMI_NV_PDISP_SOR_SEQ_INST_DRIVE_PWM_OUT_LO		__BIT(23)
#define HDMI_NV_PDISP_SOR_SEQ_INST_PIN_B			__BIT(22)
#define HDMI_NV_PDISP_SOR_SEQ_INST_PIN_A			__BIT(21)
#define HDMI_NV_PDISP_SOR_SEQ_INST_HALT				__BIT(15)
#define HDMI_NV_PDISP_SOR_SEQ_INST_WAIT_UNITS			__BITS(13,12)
#define HDMI_NV_PDISP_SOR_SEQ_INST_WAIT_TIME			__BITS(9,0)

#define HDMI_NV_PDISP_SOR_LANE_DRIVE_CURRENT_REG		0x1f8

#define HDMI_NV_PDISP_SOR_REFCLK_REG				0x254
#define HDMI_NV_PDISP_SOR_REFCLK_DIV_INT			__BITS(15,8)
#define HDMI_NV_PDISP_SOR_REFCLK_DIV_FRAC			__BITS(7,6)

#define HDMI_NV_PDISP_SOR_IO_PEAK_CURRENT_REG			0x344
#define HDMI_NV_PDISP_SOR_PAD_CTLS0_REG				0x348
#define HDMI_NV_PDISP_SOR_PAD_CTLS1_REG				0x34c

/*
 * Audio Registers
 */
#define HDMI_NV_PDISP_AUDIO_N_REG				0x230
#define HDMI_NV_PDISP_AUDIO_N_LOOKUP				__BIT(28)
#define HDMI_NV_PDISP_AUDIO_N_GENERATE				__BIT(24)
#define HDMI_NV_PDISP_AUDIO_N_RESETF				__BIT(20)
#define HDMI_NV_PDISP_AUDIO_N_VALUE				__BITS(19,0)

#define HDMI_NV_PDISP_SOR_AUDIO_CNTRL0_REG			0x2b0
#define HDMI_NV_PDISP_SOR_AUDIO_CNTRL0_INPUT_MODE		__BIT(31)
#define HDMI_NV_PDISP_SOR_AUDIO_CNTRL0_INJECT_NULLSMPL		__BIT(29)
#define HDMI_NV_PDISP_SOR_AUDIO_CNTRL0_SOURCE_SELECT		__BITS(21,20)
#define HDMI_NV_PDISP_SOR_AUDIO_CNTRL0_SOURCE_SELECT_AUTO	0
#define HDMI_NV_PDISP_SOR_AUDIO_CNTRL0_SOURCE_SELECT_SPDIF	1
#define HDMI_NV_PDISP_SOR_AUDIO_CNTRL0_SOURCE_SELECT_HDAL	2
#define HDMI_NV_PDISP_SOR_AUDIO_CNTRL0_SAMPLING_FREQ		__BITS(19,16)
#define HDMI_NV_PDISP_SOR_AUDIO_CNTRL0_SAMPLING_FREQ_32_0KHZ	3
#define HDMI_NV_PDISP_SOR_AUDIO_CNTRL0_SAMPLING_FREQ_44_1KHZ	0
#define HDMI_NV_PDISP_SOR_AUDIO_CNTRL0_SAMPLING_FREQ_88_2KHZ	8
#define HDMI_NV_PDISP_SOR_AUDIO_CNTRL0_SAMPLING_FREQ_176_4KHZ	12
#define HDMI_NV_PDISP_SOR_AUDIO_CNTRL0_SAMPLING_FREQ_48_0KHZ	2
#define HDMI_NV_PDISP_SOR_AUDIO_CNTRL0_SAMPLING_FREQ_96_0KHZ	10
#define HDMI_NV_PDISP_SOR_AUDIO_CNTRL0_SAMPLING_FREQ_192_0KHZ	14
#define HDMI_NV_PDISP_SOR_AUDIO_CNTRL0_SAMPLING_FREQ_UNKNOWN	1
#define HDMI_NV_PDISP_SOR_AUDIO_CNTRL0_AFIFO_FLUSH		__BIT(12)
#define HDMI_NV_PDISP_SOR_AUDIO_CNTRL0_PORT_CONNECTIVITY	__BIT(0)

#define HDMI_NV_PDISP_SOR_AUDIO_DEBUG_REG			0x2b4
#define HDMI_NV_PDISP_SOR_AUDIO_SPARE0_REG			0x2b8
#define HDMI_NV_PDISP_SOR_AUDIO_NVAL_0320_REG			0x2bc
#define HDMI_NV_PDISP_SOR_AUDIO_NVAL_0441_REG			0x2c0
#define HDMI_NV_PDISP_SOR_AUDIO_NVAL_0882_REG			0x2c4
#define HDMI_NV_PDISP_SOR_AUDIO_NVAL_1764_REG			0x2c8
#define HDMI_NV_PDISP_SOR_AUDIO_NVAL_0480_REG			0x2cc
#define HDMI_NV_PDISP_SOR_AUDIO_NVAL_0960_REG			0x2d0
#define HDMI_NV_PDISP_SOR_AUDIO_NVAL_1920_REG			0x2d4
#define HDMI_NV_PDISP_SOR_AUDIO_HDA_SCRATCH0_REG		0x2d8
#define HDMI_NV_PDISP_SOR_AUDIO_HDA_SCRATCH1_REG		0x2dc
#define HDMI_NV_PDISP_SOR_AUDIO_HDA_SCRATCH2_REG		0x2e0
#define HDMI_NV_PDISP_SOR_AUDIO_HDA_SCRATCH3_REG		0x2e4
#define HDMI_NV_PDISP_SOR_AUDIO_HDA_CODEC_SCRATCH0_REG		0x2e8
#define HDMI_NV_PDISP_SOR_AUDIO_HDA_CODEC_SCRATCH1_REG		0x2ec
#define HDMI_NV_PDISP_SOR_AUDIO_HDA_ELF_BUFWR_REG		0x2f0
#define HDMI_NV_PDISP_SOR_AUDIO_HDA_PRESENSE_REG		0x2f4
#define HDMI_NV_PDISP_SOR_AUDIO_HDA_CP_REG			0x2f8
#define HDMI_NV_PDISP_SOR_AUDIO_AVAL_0320_REG			0x2fc
#define HDMI_NV_PDISP_SOR_AUDIO_AVAL_0441_REG			0x300
#define HDMI_NV_PDISP_SOR_AUDIO_AVAL_0882_REG			0x304
#define HDMI_NV_PDISP_SOR_AUDIO_AVAL_1764_REG			0x308
#define HDMI_NV_PDISP_SOR_AUDIO_AVAL_0480_REG			0x30c
#define HDMI_NV_PDISP_SOR_AUDIO_AVAL_0960_REG			0x310
#define HDMI_NV_PDISP_SOR_AUDIO_AVAL_1920_REG			0x314
#define HDMI_NV_PDISP_SOR_AUDIO_AVAL_DEFAULT_REG		0x318
#define HDMI_NV_PDISP_SOR_AUDIO_GEN_CTRL_REG			0x31c
#define HDMI_NV_HDACODEC_AUDIO_GEN_CTL_REG			0x354

#endif /* _ARM_TEGRA_HDMIREG_H */
