/*	$NetBSD: rk3588_cru.h,v 1.3 2024/02/07 04:20:27 msaitoh Exp $	*/

/*-
 * Copyright (c) 2022 Ryo Shimizu
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
#ifndef _RK3588_CRU_H_
#define _RK3588_CRU_H_

#define RK3588_PLL_B0PLL			0
#define RK3588_PLL_B1PLL			1
#define RK3588_PLL_LPLL				2
#define RK3588_PLL_V0PLL			3
#define RK3588_PLL_AUPLL			4
#define RK3588_PLL_CPLL				5
#define RK3588_PLL_GPLL				6
#define RK3588_PLL_NPLL				7
#define RK3588_PLL_PPLL				8
#define RK3588_ARMCLK_L				9
#define RK3588_ARMCLK_B01			10
#define RK3588_ARMCLK_B23			11
#define RK3588_PCLK_BIGCORE0_ROOT		12
#define RK3588_PCLK_BIGCORE0_PVTM		13
#define RK3588_PCLK_BIGCORE1_ROOT		14
#define RK3588_PCLK_BIGCORE1_PVTM		15
#define RK3588_PCLK_DSU_S_ROOT			16
#define RK3588_PCLK_DSU_ROOT			17
#define RK3588_PCLK_DSU_NS_ROOT			18
#define RK3588_PCLK_LITCORE_PVTM		19
#define RK3588_PCLK_DBG				20
#define RK3588_PCLK_DSU				21
#define RK3588_PCLK_S_DAPLITE			22
#define RK3588_PCLK_M_DAPLITE			23
#define RK3588_MBIST_MCLK_PDM1			24
#define RK3588_MBIST_CLK_ACDCDIG		25
#define RK3588_HCLK_I2S2_2CH			26
#define RK3588_HCLK_I2S3_2CH			27
#define RK3588_CLK_I2S2_2CH_SRC			28
#define RK3588_CLK_I2S2_2CH_FRAC		29
#define RK3588_CLK_I2S2_2CH			30
#define RK3588_MCLK_I2S2_2CH			31
#define RK3588_I2S2_2CH_MCLKOUT			32
#define RK3588_CLK_DAC_ACDCDIG			33
#define RK3588_CLK_I2S3_2CH_SRC			34
#define RK3588_CLK_I2S3_2CH_FRAC		35
#define RK3588_CLK_I2S3_2CH			36
#define RK3588_MCLK_I2S3_2CH			37
#define RK3588_I2S3_2CH_MCLKOUT			38
#define RK3588_PCLK_ACDCDIG			39
#define RK3588_HCLK_I2S0_8CH			40
#define RK3588_CLK_I2S0_8CH_TX_SRC		41
#define RK3588_CLK_I2S0_8CH_TX_FRAC		42
#define RK3588_MCLK_I2S0_8CH_TX			43
#define RK3588_CLK_I2S0_8CH_TX			44
#define RK3588_CLK_I2S0_8CH_RX_SRC		45
#define RK3588_CLK_I2S0_8CH_RX_FRAC		46
#define RK3588_MCLK_I2S0_8CH_RX			47
#define RK3588_CLK_I2S0_8CH_RX			48
#define RK3588_I2S0_8CH_MCLKOUT			49
#define RK3588_HCLK_PDM1			50
#define RK3588_MCLK_PDM1			51
#define RK3588_HCLK_AUDIO_ROOT			52
#define RK3588_PCLK_AUDIO_ROOT			53
#define RK3588_HCLK_SPDIF0			54
#define RK3588_CLK_SPDIF0_SRC			55
#define RK3588_CLK_SPDIF0_FRAC			56
#define RK3588_MCLK_SPDIF0			57
#define RK3588_CLK_SPDIF0			58
#define RK3588_CLK_SPDIF1			59
#define RK3588_HCLK_SPDIF1			60
#define RK3588_CLK_SPDIF1_SRC			61
#define RK3588_CLK_SPDIF1_FRAC			62
#define RK3588_MCLK_SPDIF1			63
#define RK3588_ACLK_AV1_ROOT			64
#define RK3588_ACLK_AV1				65
#define RK3588_PCLK_AV1_ROOT			66
#define RK3588_PCLK_AV1				67
#define RK3588_PCLK_MAILBOX0			68
#define RK3588_PCLK_MAILBOX1			69
#define RK3588_PCLK_MAILBOX2			70
#define RK3588_PCLK_PMU2			71
#define RK3588_PCLK_PMUCM0_INTMUX		72
#define RK3588_PCLK_DDRCM0_INTMUX		73
#define RK3588_PCLK_TOP				74
#define RK3588_PCLK_PWM1			75
#define RK3588_CLK_PWM1				76
#define RK3588_CLK_PWM1_CAPTURE			77
#define RK3588_PCLK_PWM2			78
#define RK3588_CLK_PWM2				79
#define RK3588_CLK_PWM2_CAPTURE			80
#define RK3588_PCLK_PWM3			81
#define RK3588_CLK_PWM3				82
#define RK3588_CLK_PWM3_CAPTURE			83
#define RK3588_PCLK_BUSTIMER0			84
#define RK3588_PCLK_BUSTIMER1			85
#define RK3588_CLK_BUS_TIMER_ROOT		86
#define RK3588_CLK_BUSTIMER0			87
#define RK3588_CLK_BUSTIMER1			88
#define RK3588_CLK_BUSTIMER2			89
#define RK3588_CLK_BUSTIMER3			90
#define RK3588_CLK_BUSTIMER4			91
#define RK3588_CLK_BUSTIMER5			92
#define RK3588_CLK_BUSTIMER6			93
#define RK3588_CLK_BUSTIMER7			94
#define RK3588_CLK_BUSTIMER8			95
#define RK3588_CLK_BUSTIMER9			96
#define RK3588_CLK_BUSTIMER10			97
#define RK3588_CLK_BUSTIMER11			98
#define RK3588_PCLK_WDT0			99
#define RK3588_TCLK_WDT0			100
#define RK3588_PCLK_CAN0			101
#define RK3588_CLK_CAN0				102
#define RK3588_PCLK_CAN1			103
#define RK3588_CLK_CAN1				104
#define RK3588_PCLK_CAN2			105
#define RK3588_CLK_CAN2				106
#define RK3588_ACLK_DECOM			107
#define RK3588_PCLK_DECOM			108
#define RK3588_DCLK_DECOM			109
#define RK3588_ACLK_DMAC0			110
#define RK3588_ACLK_DMAC1			111
#define RK3588_ACLK_DMAC2			112
#define RK3588_ACLK_BUS_ROOT			113
#define RK3588_ACLK_GIC				114
#define RK3588_PCLK_GPIO1			115
#define RK3588_DBCLK_GPIO1			116
#define RK3588_PCLK_GPIO2			117
#define RK3588_DBCLK_GPIO2			118
#define RK3588_PCLK_GPIO3			119
#define RK3588_DBCLK_GPIO3			120
#define RK3588_PCLK_GPIO4			121
#define RK3588_DBCLK_GPIO4			122
#define RK3588_PCLK_I2C1			123
#define RK3588_PCLK_I2C2			124
#define RK3588_PCLK_I2C3			125
#define RK3588_PCLK_I2C4			126
#define RK3588_PCLK_I2C5			127
#define RK3588_PCLK_I2C6			128
#define RK3588_PCLK_I2C7			129
#define RK3588_PCLK_I2C8			130
#define RK3588_CLK_I2C1				131
#define RK3588_CLK_I2C2				132
#define RK3588_CLK_I2C3				133
#define RK3588_CLK_I2C4				134
#define RK3588_CLK_I2C5				135
#define RK3588_CLK_I2C6				136
#define RK3588_CLK_I2C7				137
#define RK3588_CLK_I2C8				138
#define RK3588_PCLK_OTPC_NS			139
#define RK3588_CLK_OTPC_NS			140
#define RK3588_CLK_OTPC_ARB			141
#define RK3588_CLK_OTPC_AUTO_RD_G		142
#define RK3588_CLK_OTP_PHY_G			143
#define RK3588_PCLK_SARADC			144
#define RK3588_CLK_SARADC			145
#define RK3588_PCLK_SPI0			146
#define RK3588_PCLK_SPI1			147
#define RK3588_PCLK_SPI2			148
#define RK3588_PCLK_SPI3			149
#define RK3588_PCLK_SPI4			150
#define RK3588_CLK_SPI0				151
#define RK3588_CLK_SPI1				152
#define RK3588_CLK_SPI2				153
#define RK3588_CLK_SPI3				154
#define RK3588_CLK_SPI4				155
#define RK3588_ACLK_SPINLOCK			156
#define RK3588_PCLK_TSADC			157
#define RK3588_CLK_TSADC			158
#define RK3588_PCLK_UART1			159
#define RK3588_PCLK_UART2			160
#define RK3588_PCLK_UART3			161
#define RK3588_PCLK_UART4			162
#define RK3588_PCLK_UART5			163
#define RK3588_PCLK_UART6			164
#define RK3588_PCLK_UART7			165
#define RK3588_PCLK_UART8			166
#define RK3588_PCLK_UART9			167
#define RK3588_CLK_UART1_SRC			168
#define RK3588_CLK_UART1_FRAC			169
#define RK3588_CLK_UART1			170
#define RK3588_SCLK_UART1			171
#define RK3588_CLK_UART2_SRC			172
#define RK3588_CLK_UART2_FRAC			173
#define RK3588_CLK_UART2			174
#define RK3588_SCLK_UART2			175
#define RK3588_CLK_UART3_SRC			176
#define RK3588_CLK_UART3_FRAC			177
#define RK3588_CLK_UART3			178
#define RK3588_SCLK_UART3			179
#define RK3588_CLK_UART4_SRC			180
#define RK3588_CLK_UART4_FRAC			181
#define RK3588_CLK_UART4			182
#define RK3588_SCLK_UART4			183
#define RK3588_CLK_UART5_SRC			184
#define RK3588_CLK_UART5_FRAC			185
#define RK3588_CLK_UART5			186
#define RK3588_SCLK_UART5			187
#define RK3588_CLK_UART6_SRC			188
#define RK3588_CLK_UART6_FRAC			189
#define RK3588_CLK_UART6			190
#define RK3588_SCLK_UART6			191
#define RK3588_CLK_UART7_SRC			192
#define RK3588_CLK_UART7_FRAC			193
#define RK3588_CLK_UART7			194
#define RK3588_SCLK_UART7			195
#define RK3588_CLK_UART8_SRC			196
#define RK3588_CLK_UART8_FRAC			197
#define RK3588_CLK_UART8			198
#define RK3588_SCLK_UART8			199
#define RK3588_CLK_UART9_SRC			200
#define RK3588_CLK_UART9_FRAC			201
#define RK3588_CLK_UART9			202
#define RK3588_SCLK_UART9			203
#define RK3588_ACLK_CENTER_ROOT			204
#define RK3588_ACLK_CENTER_LOW_ROOT		205
#define RK3588_HCLK_CENTER_ROOT			206
#define RK3588_PCLK_CENTER_ROOT			207
#define RK3588_ACLK_DMA2DDR			208
#define RK3588_ACLK_DDR_SHAREMEM		209
#define RK3588_ACLK_CENTER_S200_ROOT		210
#define RK3588_ACLK_CENTER_S400_ROOT		211
#define RK3588_FCLK_DDR_CM0_CORE		212
#define RK3588_CLK_DDR_TIMER_ROOT		213
#define RK3588_CLK_DDR_TIMER0			214
#define RK3588_CLK_DDR_TIMER1			215
#define RK3588_TCLK_WDT_DDR			216
#define RK3588_CLK_DDR_CM0_RTC			217
#define RK3588_PCLK_WDT				218
#define RK3588_PCLK_TIMER			219
#define RK3588_PCLK_DMA2DDR			220
#define RK3588_PCLK_SHAREMEM			221
#define RK3588_CLK_50M_SRC			222
#define RK3588_CLK_100M_SRC			223
#define RK3588_CLK_150M_SRC			224
#define RK3588_CLK_200M_SRC			225
#define RK3588_CLK_250M_SRC			226
#define RK3588_CLK_300M_SRC			227
#define RK3588_CLK_350M_SRC			228
#define RK3588_CLK_400M_SRC			229
#define RK3588_CLK_450M_SRC			230
#define RK3588_CLK_500M_SRC			231
#define RK3588_CLK_600M_SRC			232
#define RK3588_CLK_650M_SRC			233
#define RK3588_CLK_700M_SRC			234
#define RK3588_CLK_800M_SRC			235
#define RK3588_CLK_1000M_SRC			236
#define RK3588_CLK_1200M_SRC			237
#define RK3588_ACLK_TOP_M300_ROOT		238
#define RK3588_ACLK_TOP_M500_ROOT		239
#define RK3588_ACLK_TOP_M400_ROOT		240
#define RK3588_ACLK_TOP_S200_ROOT		241
#define RK3588_ACLK_TOP_S400_ROOT		242
#define RK3588_CLK_MIPI_CAMARAOUT_M0		243
#define RK3588_CLK_MIPI_CAMARAOUT_M1		244
#define RK3588_CLK_MIPI_CAMARAOUT_M2		245
#define RK3588_CLK_MIPI_CAMARAOUT_M3		246
#define RK3588_CLK_MIPI_CAMARAOUT_M4		247
#define RK3588_MCLK_GMAC0_OUT			248
#define RK3588_REFCLKO25M_ETH0_OUT		249
#define RK3588_REFCLKO25M_ETH1_OUT		250
#define RK3588_CLK_CIFOUT_OUT			251
#define RK3588_PCLK_MIPI_DCPHY0			252
#define RK3588_PCLK_MIPI_DCPHY1			253
#define RK3588_PCLK_CSIPHY0			254
#define RK3588_PCLK_CSIPHY1			255
#define RK3588_ACLK_TOP_ROOT			256
#define RK3588_PCLK_TOP_ROOT			257
#define RK3588_ACLK_LOW_TOP_ROOT		258
#define RK3588_PCLK_CRU				259
#define RK3588_PCLK_GPU_ROOT			260
#define RK3588_CLK_GPU_SRC			261
#define RK3588_CLK_GPU				262
#define RK3588_CLK_GPU_COREGROUP		263
#define RK3588_CLK_GPU_STACKS			264
#define RK3588_PCLK_GPU_PVTM			265
#define RK3588_CLK_GPU_PVTM			266
#define RK3588_CLK_CORE_GPU_PVTM		267
#define RK3588_PCLK_GPU_GRF			268
#define RK3588_ACLK_ISP1_ROOT			269
#define RK3588_HCLK_ISP1_ROOT			270
#define RK3588_CLK_ISP1_CORE			271
#define RK3588_CLK_ISP1_CORE_MARVIN		272
#define RK3588_CLK_ISP1_CORE_VICAP		273
#define RK3588_ACLK_ISP1			274
#define RK3588_HCLK_ISP1			275
#define RK3588_ACLK_NPU1			276
#define RK3588_HCLK_NPU1			277
#define RK3588_ACLK_NPU2			278
#define RK3588_HCLK_NPU2			279
#define RK3588_HCLK_NPU_CM0_ROOT		280
#define RK3588_FCLK_NPU_CM0_CORE		281
#define RK3588_CLK_NPU_CM0_RTC			282
#define RK3588_PCLK_NPU_PVTM			283
#define RK3588_PCLK_NPU_GRF			284
#define RK3588_CLK_NPU_PVTM			285
#define RK3588_CLK_CORE_NPU_PVTM		286
#define RK3588_ACLK_NPU0			287
#define RK3588_HCLK_NPU0			288
#define RK3588_HCLK_NPU_ROOT			289
#define RK3588_CLK_NPU_DSU0			290
#define RK3588_PCLK_NPU_ROOT			291
#define RK3588_PCLK_NPU_TIMER			292
#define RK3588_CLK_NPUTIMER_ROOT		293
#define RK3588_CLK_NPUTIMER0			294
#define RK3588_CLK_NPUTIMER1			295
#define RK3588_PCLK_NPU_WDT			296
#define RK3588_TCLK_NPU_WDT			297
#define RK3588_HCLK_EMMC			298
#define RK3588_ACLK_EMMC			299
#define RK3588_CCLK_EMMC			300
#define RK3588_BCLK_EMMC			301
#define RK3588_TMCLK_EMMC			302
#define RK3588_SCLK_SFC				303
#define RK3588_HCLK_SFC				304
#define RK3588_HCLK_SFC_XIP			305
#define RK3588_HCLK_NVM_ROOT			306
#define RK3588_ACLK_NVM_ROOT			307
#define RK3588_CLK_GMAC0_PTP_REF		308
#define RK3588_CLK_GMAC1_PTP_REF		309
#define RK3588_CLK_GMAC_125M			310
#define RK3588_CLK_GMAC_50M			311
#define RK3588_ACLK_PHP_GIC_ITS			312
#define RK3588_ACLK_MMU_PCIE			313
#define RK3588_ACLK_MMU_PHP			314
#define RK3588_ACLK_PCIE_4L_DBI			315
#define RK3588_ACLK_PCIE_2L_DBI			316
#define RK3588_ACLK_PCIE_1L0_DBI		317
#define RK3588_ACLK_PCIE_1L1_DBI		318
#define RK3588_ACLK_PCIE_1L2_DBI		319
#define RK3588_ACLK_PCIE_4L_MSTR		320
#define RK3588_ACLK_PCIE_2L_MSTR		321
#define RK3588_ACLK_PCIE_1L0_MSTR		322
#define RK3588_ACLK_PCIE_1L1_MSTR		323
#define RK3588_ACLK_PCIE_1L2_MSTR		324
#define RK3588_ACLK_PCIE_4L_SLV			325
#define RK3588_ACLK_PCIE_2L_SLV			326
#define RK3588_ACLK_PCIE_1L0_SLV		327
#define RK3588_ACLK_PCIE_1L1_SLV		328
#define RK3588_ACLK_PCIE_1L2_SLV		329
#define RK3588_PCLK_PCIE_4L			330
#define RK3588_PCLK_PCIE_2L			331
#define RK3588_PCLK_PCIE_1L0			332
#define RK3588_PCLK_PCIE_1L1			333
#define RK3588_PCLK_PCIE_1L2			334
#define RK3588_CLK_PCIE_AUX0			335
#define RK3588_CLK_PCIE_AUX1			336
#define RK3588_CLK_PCIE_AUX2			337
#define RK3588_CLK_PCIE_AUX3			338
#define RK3588_CLK_PCIE_AUX4			339
#define RK3588_CLK_PIPEPHY0_REF			340
#define RK3588_CLK_PIPEPHY1_REF			341
#define RK3588_CLK_PIPEPHY2_REF			342
#define RK3588_PCLK_PHP_ROOT			343
#define RK3588_PCLK_GMAC0			344
#define RK3588_PCLK_GMAC1			345
#define RK3588_ACLK_PCIE_ROOT			346
#define RK3588_ACLK_PHP_ROOT			347
#define RK3588_ACLK_PCIE_BRIDGE			348
#define RK3588_ACLK_GMAC0			349
#define RK3588_ACLK_GMAC1			350
#define RK3588_CLK_PMALIVE0			351
#define RK3588_CLK_PMALIVE1			352
#define RK3588_CLK_PMALIVE2			353
#define RK3588_ACLK_SATA0			354
#define RK3588_ACLK_SATA1			355
#define RK3588_ACLK_SATA2			356
#define RK3588_CLK_RXOOB0			357
#define RK3588_CLK_RXOOB1			358
#define RK3588_CLK_RXOOB2			359
#define RK3588_ACLK_USB3OTG2			360
#define RK3588_SUSPEND_CLK_USB3OTG2		361
#define RK3588_REF_CLK_USB3OTG2			362
#define RK3588_CLK_UTMI_OTG2			363
#define RK3588_CLK_PIPEPHY0_PIPE_G		364
#define RK3588_CLK_PIPEPHY1_PIPE_G		365
#define RK3588_CLK_PIPEPHY2_PIPE_G		366
#define RK3588_CLK_PIPEPHY0_PIPE_ASIC_G		367
#define RK3588_CLK_PIPEPHY1_PIPE_ASIC_G		368
#define RK3588_CLK_PIPEPHY2_PIPE_ASIC_G		369
#define RK3588_CLK_PIPEPHY2_PIPE_U3_G		370
#define RK3588_CLK_PCIE1L2_PIPE			371
#define RK3588_CLK_PCIE4L_PIPE			372
#define RK3588_CLK_PCIE2L_PIPE			373
#define RK3588_PCLK_PCIE_COMBO_PIPE_PHY0	374
#define RK3588_PCLK_PCIE_COMBO_PIPE_PHY1	375
#define RK3588_PCLK_PCIE_COMBO_PIPE_PHY2	376
#define RK3588_PCLK_PCIE_COMBO_PIPE_PHY		377
#define RK3588_HCLK_RGA3_1			378
#define RK3588_ACLK_RGA3_1			379
#define RK3588_CLK_RGA3_1_CORE			380
#define RK3588_ACLK_RGA3_ROOT			381
#define RK3588_HCLK_RGA3_ROOT			382
#define RK3588_ACLK_RKVDEC_CCU			383
#define RK3588_HCLK_RKVDEC0			384
#define RK3588_ACLK_RKVDEC0			385
#define RK3588_CLK_RKVDEC0_CA			386
#define RK3588_CLK_RKVDEC0_HEVC_CA		387
#define RK3588_CLK_RKVDEC0_CORE			388
#define RK3588_HCLK_RKVDEC1			389
#define RK3588_ACLK_RKVDEC1			390
#define RK3588_CLK_RKVDEC1_CA			391
#define RK3588_CLK_RKVDEC1_HEVC_CA		392
#define RK3588_CLK_RKVDEC1_CORE			393
#define RK3588_HCLK_SDIO			394
#define RK3588_CCLK_SRC_SDIO			395
#define RK3588_ACLK_USB_ROOT			396
#define RK3588_HCLK_USB_ROOT			397
#define RK3588_HCLK_HOST0			398
#define RK3588_HCLK_HOST_ARB0			399
#define RK3588_HCLK_HOST1			400
#define RK3588_HCLK_HOST_ARB1			401
#define RK3588_ACLK_USB3OTG0			402
#define RK3588_SUSPEND_CLK_USB3OTG0		403
#define RK3588_REF_CLK_USB3OTG0			404
#define RK3588_ACLK_USB3OTG1			405
#define RK3588_SUSPEND_CLK_USB3OTG1		406
#define RK3588_REF_CLK_USB3OTG1			407
#define RK3588_UTMI_OHCI_CLK48_HOST0		408
#define RK3588_UTMI_OHCI_CLK48_HOST1		409
#define RK3588_HCLK_IEP2P0			410
#define RK3588_ACLK_IEP2P0			411
#define RK3588_CLK_IEP2P0_CORE			412
#define RK3588_ACLK_JPEG_ENCODER0		413
#define RK3588_HCLK_JPEG_ENCODER0		414
#define RK3588_ACLK_JPEG_ENCODER1		415
#define RK3588_HCLK_JPEG_ENCODER1		416
#define RK3588_ACLK_JPEG_ENCODER2		417
#define RK3588_HCLK_JPEG_ENCODER2		418
#define RK3588_ACLK_JPEG_ENCODER3		419
#define RK3588_HCLK_JPEG_ENCODER3		420
#define RK3588_ACLK_JPEG_DECODER		421
#define RK3588_HCLK_JPEG_DECODER		422
#define RK3588_HCLK_RGA2			423
#define RK3588_ACLK_RGA2			424
#define RK3588_CLK_RGA2_CORE			425
#define RK3588_HCLK_RGA3_0			426
#define RK3588_ACLK_RGA3_0			427
#define RK3588_CLK_RGA3_0_CORE			428
#define RK3588_ACLK_VDPU_ROOT			429
#define RK3588_ACLK_VDPU_LOW_ROOT		430
#define RK3588_HCLK_VDPU_ROOT			431
#define RK3588_ACLK_JPEG_DECODER_ROOT		432
#define RK3588_ACLK_VPU				433
#define RK3588_HCLK_VPU				434
#define RK3588_HCLK_RKVENC0_ROOT		435
#define RK3588_ACLK_RKVENC0_ROOT		436
#define RK3588_HCLK_RKVENC0			437
#define RK3588_ACLK_RKVENC0			438
#define RK3588_CLK_RKVENC0_CORE			439
#define RK3588_HCLK_RKVENC1_ROOT		440
#define RK3588_ACLK_RKVENC1_ROOT		441
#define RK3588_HCLK_RKVENC1			442
#define RK3588_ACLK_RKVENC1			443
#define RK3588_CLK_RKVENC1_CORE			444
#define RK3588_ICLK_CSIHOST01			445
#define RK3588_ICLK_CSIHOST0			446
#define RK3588_ICLK_CSIHOST1			447
#define RK3588_PCLK_CSI_HOST_0			448
#define RK3588_PCLK_CSI_HOST_1			449
#define RK3588_PCLK_CSI_HOST_2			450
#define RK3588_PCLK_CSI_HOST_3			451
#define RK3588_PCLK_CSI_HOST_4			452
#define RK3588_PCLK_CSI_HOST_5			453
#define RK3588_ACLK_FISHEYE0			454
#define RK3588_HCLK_FISHEYE0			455
#define RK3588_CLK_FISHEYE0_CORE		456
#define RK3588_ACLK_FISHEYE1			457
#define RK3588_HCLK_FISHEYE1			458
#define RK3588_CLK_FISHEYE1_CORE		459
#define RK3588_CLK_ISP0_CORE			460
#define RK3588_CLK_ISP0_CORE_MARVIN		461
#define RK3588_CLK_ISP0_CORE_VICAP		462
#define RK3588_ACLK_ISP0			463
#define RK3588_HCLK_ISP0			464
#define RK3588_ACLK_VI_ROOT			465
#define RK3588_HCLK_VI_ROOT			466
#define RK3588_PCLK_VI_ROOT			467
#define RK3588_DCLK_VICAP			468
#define RK3588_ACLK_VICAP			469
#define RK3588_HCLK_VICAP			470
#define RK3588_PCLK_DP0				471
#define RK3588_PCLK_DP1				472
#define RK3588_PCLK_S_DP0			473
#define RK3588_PCLK_S_DP1			474
#define RK3588_CLK_DP0				475
#define RK3588_CLK_DP1				476
#define RK3588_HCLK_HDCP_KEY0			477
#define RK3588_ACLK_HDCP0			478
#define RK3588_HCLK_HDCP0			479
#define RK3588_PCLK_HDCP0			480
#define RK3588_HCLK_I2S4_8CH			481
#define RK3588_ACLK_TRNG0			482
#define RK3588_PCLK_TRNG0			483
#define RK3588_ACLK_VO0_ROOT			484
#define RK3588_HCLK_VO0_ROOT			485
#define RK3588_HCLK_VO0_S_ROOT			486
#define RK3588_PCLK_VO0_ROOT			487
#define RK3588_PCLK_VO0_S_ROOT			488
#define RK3588_PCLK_VO0GRF			489
#define RK3588_CLK_I2S4_8CH_TX_SRC		490
#define RK3588_CLK_I2S4_8CH_TX_FRAC		491
#define RK3588_MCLK_I2S4_8CH_TX			492
#define RK3588_CLK_I2S4_8CH_TX			493
#define RK3588_HCLK_I2S8_8CH			494
#define RK3588_CLK_I2S8_8CH_TX_SRC		495
#define RK3588_CLK_I2S8_8CH_TX_FRAC		496
#define RK3588_MCLK_I2S8_8CH_TX			497
#define RK3588_CLK_I2S8_8CH_TX			498
#define RK3588_HCLK_SPDIF2_DP0			499
#define RK3588_CLK_SPDIF2_DP0_SRC		500
#define RK3588_CLK_SPDIF2_DP0_FRAC		501
#define RK3588_MCLK_SPDIF2_DP0			502
#define RK3588_CLK_SPDIF2_DP0			503
#define RK3588_MCLK_SPDIF2			504
#define RK3588_HCLK_SPDIF5_DP1			505
#define RK3588_CLK_SPDIF5_DP1_SRC		506
#define RK3588_CLK_SPDIF5_DP1_FRAC		507
#define RK3588_MCLK_SPDIF5_DP1			508
#define RK3588_CLK_SPDIF5_DP1			509
#define RK3588_MCLK_SPDIF5			510
#define RK3588_PCLK_EDP0			511
#define RK3588_CLK_EDP0_24M			512
#define RK3588_CLK_EDP0_200M			513
#define RK3588_PCLK_EDP1			514
#define RK3588_CLK_EDP1_24M			515
#define RK3588_CLK_EDP1_200M			516
#define RK3588_HCLK_HDCP_KEY1			517
#define RK3588_ACLK_HDCP1			518
#define RK3588_HCLK_HDCP1			519
#define RK3588_PCLK_HDCP1			520
#define RK3588_ACLK_HDMIRX			521
#define RK3588_PCLK_HDMIRX			522
#define RK3588_CLK_HDMIRX_REF			523
#define RK3588_CLK_HDMIRX_AUD_SRC		524
#define RK3588_CLK_HDMIRX_AUD_FRAC		525
#define RK3588_CLK_HDMIRX_AUD			526
#define RK3588_CLK_HDMIRX_AUD_P_MUX		527
#define RK3588_PCLK_HDMITX0			528
#define RK3588_CLK_HDMITX0_EARC			529
#define RK3588_CLK_HDMITX0_REF			530
#define RK3588_PCLK_HDMITX1			531
#define RK3588_CLK_HDMITX1_EARC			532
#define RK3588_CLK_HDMITX1_REF			533
#define RK3588_CLK_HDMITRX_REFSRC		534
#define RK3588_ACLK_TRNG1			535
#define RK3588_PCLK_TRNG1			536
#define RK3588_ACLK_HDCP1_ROOT			537
#define RK3588_ACLK_HDMIRX_ROOT			538
#define RK3588_HCLK_VO1_ROOT			539
#define RK3588_HCLK_VO1_S_ROOT			540
#define RK3588_PCLK_VO1_ROOT			541
#define RK3588_PCLK_VO1_S_ROOT			542
#define RK3588_PCLK_S_EDP0			543
#define RK3588_PCLK_S_EDP1			544
#define RK3588_PCLK_S_HDMIRX			545
#define RK3588_HCLK_I2S10_8CH			546
#define RK3588_CLK_I2S10_8CH_RX_SRC		547
#define RK3588_CLK_I2S10_8CH_RX_FRAC		548
#define RK3588_CLK_I2S10_8CH_RX			549
#define RK3588_MCLK_I2S10_8CH_RX		550
#define RK3588_HCLK_I2S7_8CH			551
#define RK3588_CLK_I2S7_8CH_RX_SRC		552
#define RK3588_CLK_I2S7_8CH_RX_FRAC		553
#define RK3588_CLK_I2S7_8CH_RX			554
#define RK3588_MCLK_I2S7_8CH_RX			555
#define RK3588_HCLK_I2S9_8CH			556
#define RK3588_CLK_I2S9_8CH_RX_SRC		557
#define RK3588_CLK_I2S9_8CH_RX_FRAC		558
#define RK3588_CLK_I2S9_8CH_RX			559
#define RK3588_MCLK_I2S9_8CH_RX			560
#define RK3588_CLK_I2S5_8CH_TX_SRC		561
#define RK3588_CLK_I2S5_8CH_TX_FRAC		562
#define RK3588_CLK_I2S5_8CH_TX			563
#define RK3588_MCLK_I2S5_8CH_TX			564
#define RK3588_HCLK_I2S5_8CH			565
#define RK3588_CLK_I2S6_8CH_TX_SRC		566
#define RK3588_CLK_I2S6_8CH_TX_FRAC		567
#define RK3588_CLK_I2S6_8CH_TX			568
#define RK3588_MCLK_I2S6_8CH_TX			569
#define RK3588_CLK_I2S6_8CH_RX_SRC		570
#define RK3588_CLK_I2S6_8CH_RX_FRAC		571
#define RK3588_CLK_I2S6_8CH_RX			572
#define RK3588_MCLK_I2S6_8CH_RX			573
#define RK3588_I2S6_8CH_MCLKOUT			574
#define RK3588_HCLK_I2S6_8CH			575
#define RK3588_HCLK_SPDIF3			576
#define RK3588_CLK_SPDIF3_SRC			577
#define RK3588_CLK_SPDIF3_FRAC			578
#define RK3588_CLK_SPDIF3			579
#define RK3588_MCLK_SPDIF3			580
#define RK3588_HCLK_SPDIF4			581
#define RK3588_CLK_SPDIF4_SRC			582
#define RK3588_CLK_SPDIF4_FRAC			583
#define RK3588_CLK_SPDIF4			584
#define RK3588_MCLK_SPDIF4			585
#define RK3588_HCLK_SPDIFRX0			586
#define RK3588_MCLK_SPDIFRX0			587
#define RK3588_HCLK_SPDIFRX1			588
#define RK3588_MCLK_SPDIFRX1			589
#define RK3588_HCLK_SPDIFRX2			590
#define RK3588_MCLK_SPDIFRX2			591
#define RK3588_ACLK_VO1USB_TOP_ROOT		592
#define RK3588_HCLK_VO1USB_TOP_ROOT		593
#define RK3588_CLK_HDMIHDP0			594
#define RK3588_CLK_HDMIHDP1			595
#define RK3588_PCLK_HDPTX0			596
#define RK3588_PCLK_HDPTX1			597
#define RK3588_PCLK_USBDPPHY0			598
#define RK3588_PCLK_USBDPPHY1			599
#define RK3588_ACLK_VOP_ROOT			600
#define RK3588_ACLK_VOP_LOW_ROOT		601
#define RK3588_HCLK_VOP_ROOT			602
#define RK3588_PCLK_VOP_ROOT			603
#define RK3588_HCLK_VOP				604
#define RK3588_ACLK_VOP				605
#define RK3588_DCLK_VOP0_SRC			606
#define RK3588_DCLK_VOP1_SRC			607
#define RK3588_DCLK_VOP2_SRC			608
#define RK3588_DCLK_VOP0			609
#define RK3588_DCLK_VOP1			610
#define RK3588_DCLK_VOP2			611
#define RK3588_DCLK_VOP3			612
#define RK3588_PCLK_DSIHOST0			613
#define RK3588_PCLK_DSIHOST1			614
#define RK3588_CLK_DSIHOST0			615
#define RK3588_CLK_DSIHOST1			616
#define RK3588_CLK_VOP_PMU			617
#define RK3588_ACLK_VOP_DOBY			618
#define RK3588_ACLK_VOP_SUB_SRC			619
#define RK3588_CLK_USBDP_PHY0_IMMORTAL		620
#define RK3588_CLK_USBDP_PHY1_IMMORTAL		621
#define RK3588_CLK_PMU0				622
#define RK3588_PCLK_PMU0			623
#define RK3588_PCLK_PMU0IOC			624
#define RK3588_PCLK_GPIO0			625
#define RK3588_DBCLK_GPIO0			626
#define RK3588_PCLK_I2C0			627
#define RK3588_CLK_I2C0				628
#define RK3588_HCLK_I2S1_8CH			629
#define RK3588_CLK_I2S1_8CH_TX_SRC		630
#define RK3588_CLK_I2S1_8CH_TX_FRAC		631
#define RK3588_CLK_I2S1_8CH_TX			632
#define RK3588_MCLK_I2S1_8CH_TX			633
#define RK3588_CLK_I2S1_8CH_RX_SRC		634
#define RK3588_CLK_I2S1_8CH_RX_FRAC		635
#define RK3588_CLK_I2S1_8CH_RX			636
#define RK3588_MCLK_I2S1_8CH_RX			637
#define RK3588_I2S1_8CH_MCLKOUT			638
#define RK3588_CLK_PMU1_50M_SRC			639
#define RK3588_CLK_PMU1_100M_SRC		640
#define RK3588_CLK_PMU1_200M_SRC		641
#define RK3588_CLK_PMU1_300M_SRC		642
#define RK3588_CLK_PMU1_400M_SRC		643
#define RK3588_HCLK_PMU1_ROOT			644
#define RK3588_PCLK_PMU1_ROOT			645
#define RK3588_PCLK_PMU0_ROOT			646
#define RK3588_HCLK_PMU_CM0_ROOT		647
#define RK3588_PCLK_PMU1			648
#define RK3588_CLK_DDR_FAIL_SAFE		649
#define RK3588_CLK_PMU1				650
#define RK3588_HCLK_PDM0			651
#define RK3588_MCLK_PDM0			652
#define RK3588_HCLK_VAD				653
#define RK3588_FCLK_PMU_CM0_CORE		654
#define RK3588_CLK_PMU_CM0_RTC			655
#define RK3588_PCLK_PMU1_IOC			656
#define RK3588_PCLK_PMU1PWM			657
#define RK3588_CLK_PMU1PWM			658
#define RK3588_CLK_PMU1PWM_CAPTURE		659
#define RK3588_PCLK_PMU1TIMER			660
#define RK3588_CLK_PMU1TIMER_ROOT		661
#define RK3588_CLK_PMU1TIMER0			662
#define RK3588_CLK_PMU1TIMER1			663
#define RK3588_CLK_UART0_SRC			664
#define RK3588_CLK_UART0_FRAC			665
#define RK3588_CLK_UART0			666
#define RK3588_SCLK_UART0			667
#define RK3588_PCLK_UART0			668
#define RK3588_PCLK_PMU1WDT			669
#define RK3588_TCLK_PMU1WDT			670
#define RK3588_CLK_CR_PARA			671
#define RK3588_CLK_USB2PHY_HDPTXRXPHY_REF	672
#define RK3588_CLK_USBDPPHY_MIPIDCPPHY_REF	673
#define RK3588_CLK_REF_PIPE_PHY0_OSC_SRC	674
#define RK3588_CLK_REF_PIPE_PHY1_OSC_SRC	675
#define RK3588_CLK_REF_PIPE_PHY2_OSC_SRC	676
#define RK3588_CLK_REF_PIPE_PHY0_PLL_SRC	677
#define RK3588_CLK_REF_PIPE_PHY1_PLL_SRC	678
#define RK3588_CLK_REF_PIPE_PHY2_PLL_SRC	679
#define RK3588_CLK_REF_PIPE_PHY0		680
#define RK3588_CLK_REF_PIPE_PHY1		681
#define RK3588_CLK_REF_PIPE_PHY2		682
#define RK3588_SCLK_SDIO_DRV			683
#define RK3588_SCLK_SDIO_SAMPLE			684
#define RK3588_SCLK_SDMMC_DRV			685
#define RK3588_SCLK_SDMMC_SAMPLE		686
#define RK3588_CLK_PCIE1L0_PIPE			687
#define RK3588_CLK_PCIE1L1_PIPE			688
#define RK3588_CLK_BIGCORE0_PVTM		689
#define RK3588_CLK_CORE_BIGCORE0_PVTM		690
#define RK3588_CLK_BIGCORE1_PVTM		691
#define RK3588_CLK_CORE_BIGCORE1_PVTM		692
#define RK3588_CLK_LITCORE_PVTM			693
#define RK3588_CLK_CORE_LITCORE_PVTM		694
#define RK3588_CLK_AUX16M_0			695
#define RK3588_CLK_AUX16M_1			696
#define RK3588_CLK_PHY0_REF_ALT_P		697
#define RK3588_CLK_PHY0_REF_ALT_M		698
#define RK3588_CLK_PHY1_REF_ALT_P		699
#define RK3588_CLK_PHY1_REF_ALT_M		700
#define RK3588_ACLK_ISP1_PRE			701
#define RK3588_HCLK_ISP1_PRE			702
#define RK3588_HCLK_NVM				703
#define RK3588_ACLK_USB				704
#define RK3588_HCLK_USB				705
#define RK3588_ACLK_JPEG_DECODER_PRE		706
#define RK3588_ACLK_VDPU_LOW_PRE		707
#define RK3588_ACLK_RKVENC1_PRE			708
#define RK3588_HCLK_RKVENC1_PRE			709
#define RK3588_HCLK_RKVDEC0_PRE			710
#define RK3588_ACLK_RKVDEC0_PRE			711
#define RK3588_HCLK_RKVDEC1_PRE			712
#define RK3588_ACLK_RKVDEC1_PRE			713
#define RK3588_ACLK_HDCP0_PRE			714
#define RK3588_HCLK_VO0				715
#define RK3588_ACLK_HDCP1_PRE			716
#define RK3588_HCLK_VO1				717
#define RK3588_ACLK_AV1_PRE			718
#define RK3588_PCLK_AV1_PRE			719
#define RK3588_HCLK_SDIO_PRE			720

#endif /* _#define RK3588_CRU_H_ */
