/* Automatically generated by amd/registers/makeregheader.py */


/*
 * Copyright 2015-2019 Advanced Micro Devices, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * on the rights to use, copy, modify, merge, publish, distribute, sub
 * license, and/or sell copies of the Software, and to permit persons to whom
 * the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHOR(S) AND/OR THEIR SUPPLIERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
 * USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 */

#ifndef AMDGFXREGS_H
#define AMDGFXREGS_H

#define R_000028_SQ_WAVE_ACTIVE                                         0x000028 /* >= gfx103 */
#define   S_000028_WAVE_SLOT(x)                                       (((unsigned)(x) & 0xFFFFF) << 0)
#define   G_000028_WAVE_SLOT(x)                                       (((x) >> 0) & 0xFFFFF)
#define   C_000028_WAVE_SLOT                                          0xFFF00000
#define R_00002C_SQ_WAVE_VALID_AND_IDLE                                 0x00002C /* >= gfx103 */
#define   S_00002C_WAVE_SLOT(x)                                       (((unsigned)(x) & 0xFFFFF) << 0)
#define   G_00002C_WAVE_SLOT(x)                                       (((x) >> 0) & 0xFFFFF)
#define   C_00002C_WAVE_SLOT                                          0xFFF00000
#define R_000044_SQ_WAVE_MODE                                           0x000044 /* <= gfx9 */
#define   S_000044_FP_ROUND(x)                                        (((unsigned)(x) & 0xF) << 0)
#define   G_000044_FP_ROUND(x)                                        (((x) >> 0) & 0xF)
#define   C_000044_FP_ROUND                                           0xFFFFFFF0
#define   S_000044_FP_DENORM(x)                                       (((unsigned)(x) & 0xF) << 4)
#define   G_000044_FP_DENORM(x)                                       (((x) >> 4) & 0xF)
#define   C_000044_FP_DENORM                                          0xFFFFFF0F
#define   S_000044_DX10_CLAMP(x)                                      (((unsigned)(x) & 0x1) << 8)
#define   G_000044_DX10_CLAMP(x)                                      (((x) >> 8) & 0x1)
#define   C_000044_DX10_CLAMP                                         0xFFFFFEFF
#define   S_000044_IEEE(x)                                            (((unsigned)(x) & 0x1) << 9)
#define   G_000044_IEEE(x)                                            (((x) >> 9) & 0x1)
#define   C_000044_IEEE                                               0xFFFFFDFF
#define   S_000044_LOD_CLAMPED(x)                                     (((unsigned)(x) & 0x1) << 10)
#define   G_000044_LOD_CLAMPED(x)                                     (((x) >> 10) & 0x1)
#define   C_000044_LOD_CLAMPED                                        0xFFFFFBFF
#define   S_000044_DEBUG_EN(x)                                        (((unsigned)(x) & 0x1) << 11)
#define   G_000044_DEBUG_EN(x)                                        (((x) >> 11) & 0x1)
#define   C_000044_DEBUG_EN                                           0xFFFFF7FF
#define   S_000044_EXCP_EN(x)                                         (((unsigned)(x) & 0x1FF) << 12)
#define   G_000044_EXCP_EN(x)                                         (((x) >> 12) & 0x1FF)
#define   C_000044_EXCP_EN                                            0xFFE00FFF
#define     V_000044_INVALID                                        1
#define     V_000044_INPUT_DENORMAL                                 2
#define     V_000044_DIVIDE_BY_ZERO                                 4
#define     V_000044_OVERFLOW                                       8
#define     V_000044_UNDERFLOW                                      16
#define     V_000044_INEXACT                                        32
#define     V_000044_INT_DIVIDE_BY_ZERO                             64
#define     V_000044_ADDRESS_WATCH                                  128
#define     V_000044_MEMORY_VIOLATION                               256
#define   S_000044_FP16_OVFL(x)                                       (((unsigned)(x) & 0x1) << 23) /* gfx9 */
#define   G_000044_FP16_OVFL(x)                                       (((x) >> 23) & 0x1)
#define   C_000044_FP16_OVFL                                          0xFF7FFFFF
#define   S_000044_POPS_PACKER0(x)                                    (((unsigned)(x) & 0x1) << 24) /* gfx9 */
#define   G_000044_POPS_PACKER0(x)                                    (((x) >> 24) & 0x1)
#define   C_000044_POPS_PACKER0                                       0xFEFFFFFF
#define   S_000044_POPS_PACKER1(x)                                    (((unsigned)(x) & 0x1) << 25) /* gfx9 */
#define   G_000044_POPS_PACKER1(x)                                    (((x) >> 25) & 0x1)
#define   C_000044_POPS_PACKER1                                       0xFDFFFFFF
#define   S_000044_DISABLE_PERF(x)                                    (((unsigned)(x) & 0x1) << 26) /* gfx9 */
#define   G_000044_DISABLE_PERF(x)                                    (((x) >> 26) & 0x1)
#define   C_000044_DISABLE_PERF                                       0xFBFFFFFF
#define   S_000044_GPR_IDX_EN(x)                                      (((unsigned)(x) & 0x1) << 27) /* gfx8, gfx81, gfx9 */
#define   G_000044_GPR_IDX_EN(x)                                      (((x) >> 27) & 0x1)
#define   C_000044_GPR_IDX_EN                                         0xF7FFFFFF
#define   S_000044_VSKIP(x)                                           (((unsigned)(x) & 0x1) << 28)
#define   G_000044_VSKIP(x)                                           (((x) >> 28) & 0x1)
#define   C_000044_VSKIP                                              0xEFFFFFFF
#define   S_000044_CSP(x)                                             (((unsigned)(x) & 0x7) << 29)
#define   G_000044_CSP(x)                                             (((x) >> 29) & 0x7)
#define   C_000044_CSP                                                0x1FFFFFFF
#define R_000048_SQ_WAVE_STATUS                                         0x000048 /* <= gfx9 */
#define   S_000048_SCC(x)                                             (((unsigned)(x) & 0x1) << 0)
#define   G_000048_SCC(x)                                             (((x) >> 0) & 0x1)
#define   C_000048_SCC                                                0xFFFFFFFE
#define   S_000048_SPI_PRIO(x)                                        (((unsigned)(x) & 0x3) << 1)
#define   G_000048_SPI_PRIO(x)                                        (((x) >> 1) & 0x3)
#define   C_000048_SPI_PRIO                                           0xFFFFFFF9
#define   S_000048_USER_PRIO(x)                                       (((unsigned)(x) & 0x3) << 3) /* gfx8, gfx81, gfx9 */
#define   G_000048_USER_PRIO(x)                                       (((x) >> 3) & 0x3)
#define   C_000048_USER_PRIO                                          0xFFFFFFE7
#define   S_000048_WAVE_PRIO(x)                                       (((unsigned)(x) & 0x3) << 3) /* <= gfx7 */
#define   G_000048_WAVE_PRIO(x)                                       (((x) >> 3) & 0x3)
#define   C_000048_WAVE_PRIO                                          0xFFFFFFE7
#define   S_000048_PRIV(x)                                            (((unsigned)(x) & 0x1) << 5)
#define   G_000048_PRIV(x)                                            (((x) >> 5) & 0x1)
#define   C_000048_PRIV                                               0xFFFFFFDF
#define   S_000048_TRAP_EN(x)                                         (((unsigned)(x) & 0x1) << 6)
#define   G_000048_TRAP_EN(x)                                         (((x) >> 6) & 0x1)
#define   C_000048_TRAP_EN                                            0xFFFFFFBF
#define   S_000048_TTRACE_EN(x)                                       (((unsigned)(x) & 0x1) << 7)
#define   G_000048_TTRACE_EN(x)                                       (((x) >> 7) & 0x1)
#define   C_000048_TTRACE_EN                                          0xFFFFFF7F
#define   S_000048_EXPORT_RDY(x)                                      (((unsigned)(x) & 0x1) << 8)
#define   G_000048_EXPORT_RDY(x)                                      (((x) >> 8) & 0x1)
#define   C_000048_EXPORT_RDY                                         0xFFFFFEFF
#define   S_000048_EXECZ(x)                                           (((unsigned)(x) & 0x1) << 9)
#define   G_000048_EXECZ(x)                                           (((x) >> 9) & 0x1)
#define   C_000048_EXECZ                                              0xFFFFFDFF
#define   S_000048_VCCZ(x)                                            (((unsigned)(x) & 0x1) << 10)
#define   G_000048_VCCZ(x)                                            (((x) >> 10) & 0x1)
#define   C_000048_VCCZ                                               0xFFFFFBFF
#define   S_000048_IN_TG(x)                                           (((unsigned)(x) & 0x1) << 11)
#define   G_000048_IN_TG(x)                                           (((x) >> 11) & 0x1)
#define   C_000048_IN_TG                                              0xFFFFF7FF
#define   S_000048_IN_BARRIER(x)                                      (((unsigned)(x) & 0x1) << 12)
#define   G_000048_IN_BARRIER(x)                                      (((x) >> 12) & 0x1)
#define   C_000048_IN_BARRIER                                         0xFFFFEFFF
#define   S_000048_HALT(x)                                            (((unsigned)(x) & 0x1) << 13)
#define   G_000048_HALT(x)                                            (((x) >> 13) & 0x1)
#define   C_000048_HALT                                               0xFFFFDFFF
#define   S_000048_TRAP(x)                                            (((unsigned)(x) & 0x1) << 14)
#define   G_000048_TRAP(x)                                            (((x) >> 14) & 0x1)
#define   C_000048_TRAP                                               0xFFFFBFFF
#define   S_000048_TTRACE_CU_EN(x)                                    (((unsigned)(x) & 0x1) << 15)
#define   G_000048_TTRACE_CU_EN(x)                                    (((x) >> 15) & 0x1)
#define   C_000048_TTRACE_CU_EN                                       0xFFFF7FFF
#define   S_000048_VALID(x)                                           (((unsigned)(x) & 0x1) << 16)
#define   G_000048_VALID(x)                                           (((x) >> 16) & 0x1)
#define   C_000048_VALID                                              0xFFFEFFFF
#define   S_000048_ECC_ERR(x)                                         (((unsigned)(x) & 0x1) << 17)
#define   G_000048_ECC_ERR(x)                                         (((x) >> 17) & 0x1)
#define   C_000048_ECC_ERR                                            0xFFFDFFFF
#define   S_000048_SKIP_EXPORT(x)                                     (((unsigned)(x) & 0x1) << 18)
#define   G_000048_SKIP_EXPORT(x)                                     (((x) >> 18) & 0x1)
#define   C_000048_SKIP_EXPORT                                        0xFFFBFFFF
#define   S_000048_PERF_EN(x)                                         (((unsigned)(x) & 0x1) << 19)
#define   G_000048_PERF_EN(x)                                         (((x) >> 19) & 0x1)
#define   C_000048_PERF_EN                                            0xFFF7FFFF
#define   S_000048_COND_DBG_USER(x)                                   (((unsigned)(x) & 0x1) << 20)
#define   G_000048_COND_DBG_USER(x)                                   (((x) >> 20) & 0x1)
#define   C_000048_COND_DBG_USER                                      0xFFEFFFFF
#define   S_000048_COND_DBG_SYS(x)                                    (((unsigned)(x) & 0x1) << 21)
#define   G_000048_COND_DBG_SYS(x)                                    (((x) >> 21) & 0x1)
#define   C_000048_COND_DBG_SYS                                       0xFFDFFFFF
#define   S_000048_ALLOW_REPLAY(x)                                    (((unsigned)(x) & 0x1) << 22) /* gfx8, gfx81, gfx9 */
#define   G_000048_ALLOW_REPLAY(x)                                    (((x) >> 22) & 0x1)
#define   C_000048_ALLOW_REPLAY                                       0xFFBFFFFF
#define   S_000048_DATA_ATC(x)                                        (((unsigned)(x) & 0x1) << 22) /* <= gfx7 */
#define   G_000048_DATA_ATC(x)                                        (((x) >> 22) & 0x1)
#define   C_000048_DATA_ATC                                           0xFFBFFFFF
#define   S_000048_FATAL_HALT(x)                                      (((unsigned)(x) & 0x1) << 23) /* gfx9 */
#define   G_000048_FATAL_HALT(x)                                      (((x) >> 23) & 0x1)
#define   C_000048_FATAL_HALT                                         0xFF7FFFFF
#define   S_000048_INST_ATC(x)                                        (((unsigned)(x) & 0x1) << 23) /* <= gfx81 */
#define   G_000048_INST_ATC(x)                                        (((x) >> 23) & 0x1)
#define   C_000048_INST_ATC                                           0xFF7FFFFF
#define   S_000048_DISPATCH_CACHE_CTRL(x)                             (((unsigned)(x) & 0x7) << 24) /* <= gfx7 */
#define   G_000048_DISPATCH_CACHE_CTRL(x)                             (((x) >> 24) & 0x7)
#define   C_000048_DISPATCH_CACHE_CTRL                                0xF8FFFFFF
#define   S_000048_MUST_EXPORT(x)                                     (((unsigned)(x) & 0x1) << 27)
#define   G_000048_MUST_EXPORT(x)                                     (((x) >> 27) & 0x1)
#define   C_000048_MUST_EXPORT                                        0xF7FFFFFF
#define R_00004C_SQ_WAVE_TRAPSTS                                        0x00004C /* <= gfx9 */
#define   S_00004C_EXCP(x)                                            (((unsigned)(x) & 0x1FF) << 0)
#define   G_00004C_EXCP(x)                                            (((x) >> 0) & 0x1FF)
#define   C_00004C_EXCP                                               0xFFFFFE00
#define     V_00004C_INVALID                                        1
#define     V_00004C_INPUT_DENORMAL                                 2
#define     V_00004C_DIVIDE_BY_ZERO                                 4
#define     V_00004C_OVERFLOW                                       8
#define     V_00004C_UNDERFLOW                                      16
#define     V_00004C_INEXACT                                        32
#define     V_00004C_INT_DIVIDE_BY_ZERO                             64
#define     V_00004C_ADDRESS_WATCH                                  128
#define     V_00004C_MEMORY_VIOLATION                               256
#define   S_00004C_SAVECTX(x)                                         (((unsigned)(x) & 0x1) << 10) /* gfx8, gfx81, gfx9 */
#define   G_00004C_SAVECTX(x)                                         (((x) >> 10) & 0x1)
#define   C_00004C_SAVECTX                                            0xFFFFFBFF
#define   S_00004C_ILLEGAL_INST(x)                                    (((unsigned)(x) & 0x1) << 11) /* gfx9 */
#define   G_00004C_ILLEGAL_INST(x)                                    (((x) >> 11) & 0x1)
#define   C_00004C_ILLEGAL_INST                                       0xFFFFF7FF
#define   S_00004C_EXCP_HI(x)                                         (((unsigned)(x) & 0x7) << 12) /* gfx9 */
#define   G_00004C_EXCP_HI(x)                                         (((x) >> 12) & 0x7)
#define   C_00004C_EXCP_HI                                            0xFFFF8FFF
#define   S_00004C_EXCP_CYCLE(x)                                      (((unsigned)(x) & 0x3F) << 16)
#define   G_00004C_EXCP_CYCLE(x)                                      (((x) >> 16) & 0x3F)
#define   C_00004C_EXCP_CYCLE                                         0xFFC0FFFF
#define   S_00004C_XNACK_ERROR(x)                                     (((unsigned)(x) & 0x1) << 28) /* gfx9 */
#define   G_00004C_XNACK_ERROR(x)                                     (((x) >> 28) & 0x1)
#define   C_00004C_XNACK_ERROR                                        0xEFFFFFFF
#define   S_00004C_DP_RATE(x)                                         (((unsigned)(x) & 0x7) << 29)
#define   G_00004C_DP_RATE(x)                                         (((x) >> 29) & 0x7)
#define   C_00004C_DP_RATE                                            0x1FFFFFFF
#define R_000050_SQ_WAVE_HW_ID                                          0x000050 /* <= gfx9 */
#define   S_000050_WAVE_ID(x)                                         (((unsigned)(x) & 0xF) << 0)
#define   G_000050_WAVE_ID(x)                                         (((x) >> 0) & 0xF)
#define   C_000050_WAVE_ID                                            0xFFFFFFF0
#define   S_000050_SIMD_ID(x)                                         (((unsigned)(x) & 0x3) << 4)
#define   G_000050_SIMD_ID(x)                                         (((x) >> 4) & 0x3)
#define   C_000050_SIMD_ID                                            0xFFFFFFCF
#define   S_000050_PIPE_ID(x)                                         (((unsigned)(x) & 0x3) << 6)
#define   G_000050_PIPE_ID(x)                                         (((x) >> 6) & 0x3)
#define   C_000050_PIPE_ID                                            0xFFFFFF3F
#define   S_000050_CU_ID(x)                                           (((unsigned)(x) & 0xF) << 8)
#define   G_000050_CU_ID(x)                                           (((x) >> 8) & 0xF)
#define   C_000050_CU_ID                                              0xFFFFF0FF
#define   S_000050_SH_ID(x)                                           (((unsigned)(x) & 0x1) << 12)
#define   G_000050_SH_ID(x)                                           (((x) >> 12) & 0x1)
#define   C_000050_SH_ID                                              0xFFFFEFFF
#define   S_000050_SE_ID(x)                                           (((unsigned)(x) & 0x3) << 13)
#define   G_000050_SE_ID(x)                                           (((x) >> 13) & 0x3)
#define   C_000050_SE_ID                                              0xFFFF9FFF
#define   S_000050_TG_ID(x)                                           (((unsigned)(x) & 0xF) << 16)
#define   G_000050_TG_ID(x)                                           (((x) >> 16) & 0xF)
#define   C_000050_TG_ID                                              0xFFF0FFFF
#define   S_000050_VM_ID(x)                                           (((unsigned)(x) & 0xF) << 20)
#define   G_000050_VM_ID(x)                                           (((x) >> 20) & 0xF)
#define   C_000050_VM_ID                                              0xFF0FFFFF
#define   S_000050_QUEUE_ID(x)                                        (((unsigned)(x) & 0x7) << 24)
#define   G_000050_QUEUE_ID(x)                                        (((x) >> 24) & 0x7)
#define   C_000050_QUEUE_ID                                           0xF8FFFFFF
#define   S_000050_STATE_ID(x)                                        (((unsigned)(x) & 0x7) << 27)
#define   G_000050_STATE_ID(x)                                        (((x) >> 27) & 0x7)
#define   C_000050_STATE_ID                                           0xC7FFFFFF
#define   S_000050_ME_ID(x)                                           (((unsigned)(x) & 0x3) << 30)
#define   G_000050_ME_ID(x)                                           (((x) >> 30) & 0x3)
#define   C_000050_ME_ID                                              0x3FFFFFFF
#define R_000054_SQ_WAVE_GPR_ALLOC                                      0x000054 /* <= gfx9 */
#define   S_000054_VGPR_BASE(x)                                       (((unsigned)(x) & 0x3F) << 0)
#define   G_000054_VGPR_BASE(x)                                       (((x) >> 0) & 0x3F)
#define   C_000054_VGPR_BASE                                          0xFFFFFFC0
#define   S_000054_VGPR_SIZE(x)                                       (((unsigned)(x) & 0x3F) << 8)
#define   G_000054_VGPR_SIZE(x)                                       (((x) >> 8) & 0x3F)
#define   C_000054_VGPR_SIZE                                          0xFFFFC0FF
#define   S_000054_SGPR_BASE(x)                                       (((unsigned)(x) & 0x3F) << 16)
#define   G_000054_SGPR_BASE(x)                                       (((x) >> 16) & 0x3F)
#define   C_000054_SGPR_BASE                                          0xFFC0FFFF
#define   S_000054_SGPR_SIZE(x)                                       (((unsigned)(x) & 0xF) << 24)
#define   G_000054_SGPR_SIZE(x)                                       (((x) >> 24) & 0xF)
#define   C_000054_SGPR_SIZE                                          0xF0FFFFFF
#define R_000058_SQ_WAVE_LDS_ALLOC                                      0x000058 /* <= gfx9 */
#define   S_000058_LDS_BASE(x)                                        (((unsigned)(x) & 0xFF) << 0)
#define   G_000058_LDS_BASE(x)                                        (((x) >> 0) & 0xFF)
#define   C_000058_LDS_BASE                                           0xFFFFFF00
#define   S_000058_LDS_SIZE(x)                                        (((unsigned)(x) & 0x1FF) << 12)
#define   G_000058_LDS_SIZE(x)                                        (((x) >> 12) & 0x1FF)
#define   C_000058_LDS_SIZE                                           0xFFE00FFF
#define R_00005C_SQ_WAVE_IB_STS                                         0x00005C /* <= gfx9 */
#define   S_00005C_VM_CNT(x)                                          (((unsigned)(x) & 0xF) << 0)
#define   G_00005C_VM_CNT(x)                                          (((x) >> 0) & 0xF)
#define   C_00005C_VM_CNT                                             0xFFFFFFF0
#define   S_00005C_EXP_CNT(x)                                         (((unsigned)(x) & 0x7) << 4)
#define   G_00005C_EXP_CNT(x)                                         (((x) >> 4) & 0x7)
#define   C_00005C_EXP_CNT                                            0xFFFFFF8F
#define   S_00005C_LGKM_CNT_GFX6(x)                                   (((unsigned)(x) & 0x1F) << 8) /* <= gfx6 */
#define   G_00005C_LGKM_CNT_GFX6(x)                                   (((x) >> 8) & 0x1F)
#define   C_00005C_LGKM_CNT_GFX6                                      0xFFFFE0FF
#define   S_00005C_LGKM_CNT_GFX7(x)                                   (((unsigned)(x) & 0xF) << 8) /* gfx7, gfx8, gfx81, gfx9 */
#define   G_00005C_LGKM_CNT_GFX7(x)                                   (((x) >> 8) & 0xF)
#define   C_00005C_LGKM_CNT_GFX7                                      0xFFFFF0FF
#define   S_00005C_VALU_CNT_GFX7(x)                                   (((unsigned)(x) & 0x7) << 12) /* gfx7, gfx8, gfx81, gfx9 */
#define   G_00005C_VALU_CNT_GFX7(x)                                   (((x) >> 12) & 0x7)
#define   C_00005C_VALU_CNT_GFX7                                      0xFFFF8FFF
#define   S_00005C_VALU_CNT_GFX6(x)                                   (((unsigned)(x) & 0x7) << 13) /* <= gfx6 */
#define   G_00005C_VALU_CNT_GFX6(x)                                   (((x) >> 13) & 0x7)
#define   C_00005C_VALU_CNT_GFX6                                      0xFFFF1FFF
#define   S_00005C_FIRST_REPLAY(x)                                    (((unsigned)(x) & 0x1) << 15) /* gfx8, gfx81, gfx9 */
#define   G_00005C_FIRST_REPLAY(x)                                    (((x) >> 15) & 0x1)
#define   C_00005C_FIRST_REPLAY                                       0xFFFF7FFF
#define   S_00005C_RCNT(x)                                            (((unsigned)(x) & 0x1F) << 16) /* gfx8, gfx81, gfx9 */
#define   G_00005C_RCNT(x)                                            (((x) >> 16) & 0x1F)
#define   C_00005C_RCNT                                               0xFFE0FFFF
#define   S_00005C_VM_CNT_HI(x)                                       (((unsigned)(x) & 0x3) << 22) /* gfx9 */
#define   G_00005C_VM_CNT_HI(x)                                       (((x) >> 22) & 0x3)
#define   C_00005C_VM_CNT_HI                                          0xFF3FFFFF
#define R_000060_SQ_WAVE_PC_LO                                          0x000060 /* <= gfx9 */
#define R_000064_SQ_WAVE_PC_HI                                          0x000064 /* <= gfx9 */
#define   S_000064_PC_HI(x)                                           (((unsigned)(x) & 0xFFFF) << 0)
#define   G_000064_PC_HI(x)                                           (((x) >> 0) & 0xFFFF)
#define   C_000064_PC_HI                                              0xFFFF0000
#define R_000068_SQ_WAVE_INST_DW0                                       0x000068 /* <= gfx9 */
#define R_00006C_SQ_WAVE_INST_DW1                                       0x00006C /* <= gfx9 */
#define R_000070_SQ_WAVE_IB_DBG0                                        0x000070 /* <= gfx9 */
#define   S_000070_IBUF_ST(x)                                         (((unsigned)(x) & 0x7) << 0)
#define   G_000070_IBUF_ST(x)                                         (((x) >> 0) & 0x7)
#define   C_000070_IBUF_ST                                            0xFFFFFFF8
#define   S_000070_PC_INVALID(x)                                      (((unsigned)(x) & 0x1) << 3)
#define   G_000070_PC_INVALID(x)                                      (((x) >> 3) & 0x1)
#define   C_000070_PC_INVALID                                         0xFFFFFFF7
#define   S_000070_NEED_NEXT_DW(x)                                    (((unsigned)(x) & 0x1) << 4)
#define   G_000070_NEED_NEXT_DW(x)                                    (((x) >> 4) & 0x1)
#define   C_000070_NEED_NEXT_DW                                       0xFFFFFFEF
#define   S_000070_NO_PREFETCH_CNT(x)                                 (((unsigned)(x) & 0x7) << 5)
#define   G_000070_NO_PREFETCH_CNT(x)                                 (((x) >> 5) & 0x7)
#define   C_000070_NO_PREFETCH_CNT                                    0xFFFFFF1F
#define   S_000070_IBUF_RPTR(x)                                       (((unsigned)(x) & 0x3) << 8)
#define   G_000070_IBUF_RPTR(x)                                       (((x) >> 8) & 0x3)
#define   C_000070_IBUF_RPTR                                          0xFFFFFCFF
#define   S_000070_IBUF_WPTR(x)                                       (((unsigned)(x) & 0x3) << 10)
#define   G_000070_IBUF_WPTR(x)                                       (((x) >> 10) & 0x3)
#define   C_000070_IBUF_WPTR                                          0xFFFFF3FF
#define   S_000070_INST_STR_ST_GFX6(x)                                (((unsigned)(x) & 0x7) << 16) /* <= gfx7 */
#define   G_000070_INST_STR_ST_GFX6(x)                                (((x) >> 16) & 0x7)
#define   C_000070_INST_STR_ST_GFX6                                   0xFFF8FFFF
#define   S_000070_INST_STR_ST_GFX8(x)                                (((unsigned)(x) & 0xF) << 16) /* gfx8, gfx81, gfx9 */
#define   G_000070_INST_STR_ST_GFX8(x)                                (((x) >> 16) & 0xF)
#define   C_000070_INST_STR_ST_GFX8                                   0xFFF0FFFF
#define   S_000070_MISC_CNT_GFX6(x)                                   (((unsigned)(x) & 0x7) << 19) /* <= gfx7 */
#define   G_000070_MISC_CNT_GFX6(x)                                   (((x) >> 19) & 0x7)
#define   C_000070_MISC_CNT_GFX6                                      0xFFC7FFFF
#define   S_000070_MISC_CNT_GFX8(x)                                   (((unsigned)(x) & 0xF) << 20) /* gfx8, gfx81 */
#define   G_000070_MISC_CNT_GFX8(x)                                   (((x) >> 20) & 0xF)
#define   C_000070_MISC_CNT_GFX8                                      0xFF0FFFFF
#define   S_000070_ECC_ST_GFX6(x)                                     (((unsigned)(x) & 0x3) << 22) /* <= gfx7 */
#define   G_000070_ECC_ST_GFX6(x)                                     (((x) >> 22) & 0x3)
#define   C_000070_ECC_ST_GFX6                                        0xFF3FFFFF
#define   S_000070_ECC_ST_GFX8(x)                                     (((unsigned)(x) & 0x3) << 24) /* gfx8, gfx81, gfx9 */
#define   G_000070_ECC_ST_GFX8(x)                                     (((x) >> 24) & 0x3)
#define   C_000070_ECC_ST_GFX8                                        0xFCFFFFFF
#define   S_000070_IS_HYB_GFX6(x)                                     (((unsigned)(x) & 0x1) << 24) /* <= gfx7 */
#define   G_000070_IS_HYB_GFX6(x)                                     (((x) >> 24) & 0x1)
#define   C_000070_IS_HYB_GFX6                                        0xFEFFFFFF
#define   S_000070_HYB_CNT_GFX6(x)                                    (((unsigned)(x) & 0x3) << 25) /* <= gfx7 */
#define   G_000070_HYB_CNT_GFX6(x)                                    (((x) >> 25) & 0x3)
#define   C_000070_HYB_CNT_GFX6                                       0xF9FFFFFF
#define   S_000070_IS_HYB_GFX8(x)                                     (((unsigned)(x) & 0x1) << 26) /* gfx8, gfx81, gfx9 */
#define   G_000070_IS_HYB_GFX8(x)                                     (((x) >> 26) & 0x1)
#define   C_000070_IS_HYB_GFX8                                        0xFBFFFFFF
#define   S_000070_HYB_CNT_GFX8(x)                                    (((unsigned)(x) & 0x3) << 27) /* gfx8, gfx81, gfx9 */
#define   G_000070_HYB_CNT_GFX8(x)                                    (((x) >> 27) & 0x3)
#define   C_000070_HYB_CNT_GFX8                                       0xE7FFFFFF
#define   S_000070_KILL_GFX6(x)                                       (((unsigned)(x) & 0x1) << 27) /* <= gfx7 */
#define   G_000070_KILL_GFX6(x)                                       (((x) >> 27) & 0x1)
#define   C_000070_KILL_GFX6                                          0xF7FFFFFF
#define   S_000070_NEED_KILL_IFETCH_GFX6(x)                           (((unsigned)(x) & 0x1) << 28) /* <= gfx7 */
#define   G_000070_NEED_KILL_IFETCH_GFX6(x)                           (((x) >> 28) & 0x1)
#define   C_000070_NEED_KILL_IFETCH_GFX6                              0xEFFFFFFF
#define   S_000070_KILL_GFX8(x)                                       (((unsigned)(x) & 0x1) << 29) /* gfx8, gfx81, gfx9 */
#define   G_000070_KILL_GFX8(x)                                       (((x) >> 29) & 0x1)
#define   C_000070_KILL_GFX8                                          0xDFFFFFFF
#define   S_000070_NEED_KILL_IFETCH_GFX8(x)                           (((unsigned)(x) & 0x1) << 30) /* gfx8, gfx81, gfx9 */
#define   G_000070_NEED_KILL_IFETCH_GFX8(x)                           (((x) >> 30) & 0x1)
#define   C_000070_NEED_KILL_IFETCH_GFX8                              0xBFFFFFFF
#define   S_000070_NO_PREFETCH_CNT_HI(x)                              (((unsigned)(x) & 0x1) << 31) /* gfx9 */
#define   G_000070_NO_PREFETCH_CNT_HI(x)                              (((x) >> 31) & 0x1)
#define   C_000070_NO_PREFETCH_CNT_HI                                 0x7FFFFFFF
#define R_000074_SQ_WAVE_IB_DBG1                                        0x000074 /* gfx8, gfx81, gfx9 */
#define   S_000074_IXNACK(x)                                          (((unsigned)(x) & 0x1) << 0)
#define   G_000074_IXNACK(x)                                          (((x) >> 0) & 0x1)
#define   C_000074_IXNACK                                             0xFFFFFFFE
#define   S_000074_XNACK(x)                                           (((unsigned)(x) & 0x1) << 1)
#define   G_000074_XNACK(x)                                           (((x) >> 1) & 0x1)
#define   C_000074_XNACK                                              0xFFFFFFFD
#define   S_000074_TA_NEED_RESET(x)                                   (((unsigned)(x) & 0x1) << 2)
#define   G_000074_TA_NEED_RESET(x)                                   (((x) >> 2) & 0x1)
#define   C_000074_TA_NEED_RESET                                      0xFFFFFFFB
#define   S_000074_XCNT_GFX8(x)                                       (((unsigned)(x) & 0xF) << 4) /* gfx8, gfx81 */
#define   G_000074_XCNT_GFX8(x)                                       (((x) >> 4) & 0xF)
#define   C_000074_XCNT_GFX8                                          0xFFFFFF0F
#define   S_000074_XCNT_GFX9(x)                                       (((unsigned)(x) & 0x1F) << 4) /* gfx9 */
#define   G_000074_XCNT_GFX9(x)                                       (((x) >> 4) & 0x1F)
#define   C_000074_XCNT_GFX9                                          0xFFFFFE0F
#define   S_000074_QCNT_GFX8(x)                                       (((unsigned)(x) & 0xF) << 8) /* gfx8, gfx81 */
#define   G_000074_QCNT_GFX8(x)                                       (((x) >> 8) & 0xF)
#define   C_000074_QCNT_GFX8                                          0xFFFFF0FF
#define   S_000074_QCNT_GFX9(x)                                       (((unsigned)(x) & 0x1F) << 11) /* gfx9 */
#define   G_000074_QCNT_GFX9(x)                                       (((x) >> 11) & 0x1F)
#define   C_000074_QCNT_GFX9                                          0xFFFF07FF
#define   S_000074_RCNT(x)                                            (((unsigned)(x) & 0x1F) << 18) /* gfx9 */
#define   G_000074_RCNT(x)                                            (((x) >> 18) & 0x1F)
#define   C_000074_RCNT                                               0xFF83FFFF
#define   S_000074_MISC_CNT(x)                                        (((unsigned)(x) & 0x7F) << 25) /* gfx9 */
#define   G_000074_MISC_CNT(x)                                        (((x) >> 25) & 0x7F)
#define   C_000074_MISC_CNT                                           0x01FFFFFF
#define R_000078_SQ_WAVE_FLUSH_IB                                       0x000078 /* gfx9 */
#define R_370_CONTROL                                                   0x370
#define   S_370_DST_SEL(x)                                            (((unsigned)(x) & 0xF) << 8)
#define   G_370_DST_SEL(x)                                            (((x) >> 8) & 0xF)
#define   C_370_DST_SEL                                               0xFFFFF0FF
#define     V_370_MEM_MAPPED_REGISTER                               0
#define     V_370_MEM_GRBM                                          1
#define     V_370_TC_L2                                             2
#define     V_370_GDS                                               3
#define     V_370_RESERVED                                          4
#define     V_370_MEM                                               5 /* >= gfx7 */
#define   S_370_WR_ONE_ADDR(x)                                        (((unsigned)(x) & 0x1) << 16)
#define   G_370_WR_ONE_ADDR(x)                                        (((x) >> 16) & 0x1)
#define   C_370_WR_ONE_ADDR                                           0xFFFEFFFF
#define   S_370_WR_CONFIRM(x)                                         (((unsigned)(x) & 0x1) << 20)
#define   G_370_WR_CONFIRM(x)                                         (((x) >> 20) & 0x1)
#define   C_370_WR_CONFIRM                                            0xFFEFFFFF
#define   S_370_ENGINE_SEL(x)                                         (((unsigned)(x) & 0x3) << 30)
#define   G_370_ENGINE_SEL(x)                                         (((x) >> 30) & 0x3)
#define   C_370_ENGINE_SEL                                            0x3FFFFFFF
#define     V_370_ME                                                0
#define     V_370_PFP                                               1
#define     V_370_CE                                                2
#define     V_370_DE                                                3
#define R_371_DST_ADDR_LO                                               0x371
#define R_372_DST_ADDR_HI                                               0x372
#define R_3F0_IB_BASE_LO                                                0x3F0
#define R_3F1_IB_BASE_HI                                                0x3F1
#define R_3F2_IB_CONTROL                                                0x3F2
#define   S_3F2_IB_SIZE(x)                                            (((unsigned)(x) & 0xFFFFF) << 0)
#define   G_3F2_IB_SIZE(x)                                            (((x) >> 0) & 0xFFFFF)
#define   C_3F2_IB_SIZE                                               0xFFF00000
#define   S_3F2_CHAIN(x)                                              (((unsigned)(x) & 0x1) << 20)
#define   G_3F2_CHAIN(x)                                              (((x) >> 20) & 0x1)
#define   C_3F2_CHAIN                                                 0xFFEFFFFF
#define   S_3F2_VALID(x)                                              (((unsigned)(x) & 0x1) << 23)
#define   G_3F2_VALID(x)                                              (((x) >> 23) & 0x1)
#define   C_3F2_VALID                                                 0xFF7FFFFF
#define R_000404_SQ_WAVE_MODE                                           0x000404 /* >= gfx10 */
#define   S_000404_FP_ROUND(x)                                        (((unsigned)(x) & 0xF) << 0)
#define   G_000404_FP_ROUND(x)                                        (((x) >> 0) & 0xF)
#define   C_000404_FP_ROUND                                           0xFFFFFFF0
#define   S_000404_FP_DENORM(x)                                       (((unsigned)(x) & 0xF) << 4)
#define   G_000404_FP_DENORM(x)                                       (((x) >> 4) & 0xF)
#define   C_000404_FP_DENORM                                          0xFFFFFF0F
#define   S_000404_DX10_CLAMP(x)                                      (((unsigned)(x) & 0x1) << 8)
#define   G_000404_DX10_CLAMP(x)                                      (((x) >> 8) & 0x1)
#define   C_000404_DX10_CLAMP                                         0xFFFFFEFF
#define   S_000404_IEEE(x)                                            (((unsigned)(x) & 0x1) << 9)
#define   G_000404_IEEE(x)                                            (((x) >> 9) & 0x1)
#define   C_000404_IEEE                                               0xFFFFFDFF
#define   S_000404_LOD_CLAMPED(x)                                     (((unsigned)(x) & 0x1) << 10)
#define   G_000404_LOD_CLAMPED(x)                                     (((x) >> 10) & 0x1)
#define   C_000404_LOD_CLAMPED                                        0xFFFFFBFF
#define   S_000404_EXCP_EN(x)                                         (((unsigned)(x) & 0x1FF) << 12)
#define   G_000404_EXCP_EN(x)                                         (((x) >> 12) & 0x1FF)
#define   C_000404_EXCP_EN                                            0xFFE00FFF
#define     V_000404_INVALID                                        1
#define     V_000404_INPUT_DENORMAL                                 2
#define     V_000404_DIVIDE_BY_ZERO                                 4
#define     V_000404_OVERFLOW                                       8
#define     V_000404_UNDERFLOW                                      16
#define     V_000404_INEXACT                                        32
#define     V_000404_INT_DIVIDE_BY_ZERO                             64
#define     V_000404_ADDRESS_WATCH                                  128
#define     V_000404_MEMORY_VIOLATION                               256
#define   S_000404_FP16_OVFL(x)                                       (((unsigned)(x) & 0x1) << 23)
#define   G_000404_FP16_OVFL(x)                                       (((x) >> 23) & 0x1)
#define   C_000404_FP16_OVFL                                          0xFF7FFFFF
#define   S_000404_DISABLE_PERF(x)                                    (((unsigned)(x) & 0x1) << 27)
#define   G_000404_DISABLE_PERF(x)                                    (((x) >> 27) & 0x1)
#define   C_000404_DISABLE_PERF                                       0xF7FFFFFF
#define   S_000404_VSKIP(x)                                           (((unsigned)(x) & 0x1) << 28) /* gfx10 */
#define   G_000404_VSKIP(x)                                           (((x) >> 28) & 0x1)
#define   C_000404_VSKIP                                              0xEFFFFFFF
#define   S_000404_CSP(x)                                             (((unsigned)(x) & 0x7) << 29) /* gfx10 */
#define   G_000404_CSP(x)                                             (((x) >> 29) & 0x7)
#define   C_000404_CSP                                                0x1FFFFFFF
#define R_000408_SQ_WAVE_STATUS                                         0x000408 /* >= gfx10 */
#define   S_000408_SCC(x)                                             (((unsigned)(x) & 0x1) << 0)
#define   G_000408_SCC(x)                                             (((x) >> 0) & 0x1)
#define   C_000408_SCC                                                0xFFFFFFFE
#define   S_000408_SPI_PRIO(x)                                        (((unsigned)(x) & 0x3) << 1)
#define   G_000408_SPI_PRIO(x)                                        (((x) >> 1) & 0x3)
#define   C_000408_SPI_PRIO                                           0xFFFFFFF9
#define   S_000408_USER_PRIO(x)                                       (((unsigned)(x) & 0x3) << 3)
#define   G_000408_USER_PRIO(x)                                       (((x) >> 3) & 0x3)
#define   C_000408_USER_PRIO                                          0xFFFFFFE7
#define   S_000408_PRIV(x)                                            (((unsigned)(x) & 0x1) << 5)
#define   G_000408_PRIV(x)                                            (((x) >> 5) & 0x1)
#define   C_000408_PRIV                                               0xFFFFFFDF
#define   S_000408_TRAP_EN(x)                                         (((unsigned)(x) & 0x1) << 6)
#define   G_000408_TRAP_EN(x)                                         (((x) >> 6) & 0x1)
#define   C_000408_TRAP_EN                                            0xFFFFFFBF
#define   S_000408_TTRACE_EN(x)                                       (((unsigned)(x) & 0x1) << 7)
#define   G_000408_TTRACE_EN(x)                                       (((x) >> 7) & 0x1)
#define   C_000408_TTRACE_EN                                          0xFFFFFF7F
#define   S_000408_EXPORT_RDY(x)                                      (((unsigned)(x) & 0x1) << 8)
#define   G_000408_EXPORT_RDY(x)                                      (((x) >> 8) & 0x1)
#define   C_000408_EXPORT_RDY                                         0xFFFFFEFF
#define   S_000408_EXECZ(x)                                           (((unsigned)(x) & 0x1) << 9)
#define   G_000408_EXECZ(x)                                           (((x) >> 9) & 0x1)
#define   C_000408_EXECZ                                              0xFFFFFDFF
#define   S_000408_VCCZ(x)                                            (((unsigned)(x) & 0x1) << 10)
#define   G_000408_VCCZ(x)                                            (((x) >> 10) & 0x1)
#define   C_000408_VCCZ                                               0xFFFFFBFF
#define   S_000408_IN_TG(x)                                           (((unsigned)(x) & 0x1) << 11)
#define   G_000408_IN_TG(x)                                           (((x) >> 11) & 0x1)
#define   C_000408_IN_TG                                              0xFFFFF7FF
#define   S_000408_IN_BARRIER(x)                                      (((unsigned)(x) & 0x1) << 12)
#define   G_000408_IN_BARRIER(x)                                      (((x) >> 12) & 0x1)
#define   C_000408_IN_BARRIER                                         0xFFFFEFFF
#define   S_000408_HALT(x)                                            (((unsigned)(x) & 0x1) << 13)
#define   G_000408_HALT(x)                                            (((x) >> 13) & 0x1)
#define   C_000408_HALT                                               0xFFFFDFFF
#define   S_000408_TRAP(x)                                            (((unsigned)(x) & 0x1) << 14)
#define   G_000408_TRAP(x)                                            (((x) >> 14) & 0x1)
#define   C_000408_TRAP                                               0xFFFFBFFF
#define   S_000408_TTRACE_SIMD_EN(x)                                  (((unsigned)(x) & 0x1) << 15)
#define   G_000408_TTRACE_SIMD_EN(x)                                  (((x) >> 15) & 0x1)
#define   C_000408_TTRACE_SIMD_EN                                     0xFFFF7FFF
#define   S_000408_VALID(x)                                           (((unsigned)(x) & 0x1) << 16)
#define   G_000408_VALID(x)                                           (((x) >> 16) & 0x1)
#define   C_000408_VALID                                              0xFFFEFFFF
#define   S_000408_ECC_ERR(x)                                         (((unsigned)(x) & 0x1) << 17)
#define   G_000408_ECC_ERR(x)                                         (((x) >> 17) & 0x1)
#define   C_000408_ECC_ERR                                            0xFFFDFFFF
#define   S_000408_SKIP_EXPORT(x)                                     (((unsigned)(x) & 0x1) << 18)
#define   G_000408_SKIP_EXPORT(x)                                     (((x) >> 18) & 0x1)
#define   C_000408_SKIP_EXPORT                                        0xFFFBFFFF
#define   S_000408_PERF_EN(x)                                         (((unsigned)(x) & 0x1) << 19)
#define   G_000408_PERF_EN(x)                                         (((x) >> 19) & 0x1)
#define   C_000408_PERF_EN                                            0xFFF7FFFF
#define   S_000408_FATAL_HALT(x)                                      (((unsigned)(x) & 0x1) << 23)
#define   G_000408_FATAL_HALT(x)                                      (((x) >> 23) & 0x1)
#define   C_000408_FATAL_HALT                                         0xFF7FFFFF
#define   S_000408_MUST_EXPORT(x)                                     (((unsigned)(x) & 0x1) << 27)
#define   G_000408_MUST_EXPORT(x)                                     (((x) >> 27) & 0x1)
#define   C_000408_MUST_EXPORT                                        0xF7FFFFFF
#define R_00040C_SQ_WAVE_TRAPSTS                                        0x00040C /* >= gfx10 */
#define   S_00040C_EXCP(x)                                            (((unsigned)(x) & 0x1FF) << 0)
#define   G_00040C_EXCP(x)                                            (((x) >> 0) & 0x1FF)
#define   C_00040C_EXCP                                               0xFFFFFE00
#define     V_00040C_INVALID                                        1
#define     V_00040C_INPUT_DENORMAL                                 2
#define     V_00040C_DIVIDE_BY_ZERO                                 4
#define     V_00040C_OVERFLOW                                       8
#define     V_00040C_UNDERFLOW                                      16
#define     V_00040C_INEXACT                                        32
#define     V_00040C_INT_DIVIDE_BY_ZERO                             64
#define     V_00040C_ADDRESS_WATCH                                  128
#define     V_00040C_MEMORY_VIOLATION                               256
#define   S_00040C_SAVECTX(x)                                         (((unsigned)(x) & 0x1) << 10)
#define   G_00040C_SAVECTX(x)                                         (((x) >> 10) & 0x1)
#define   C_00040C_SAVECTX                                            0xFFFFFBFF
#define   S_00040C_ILLEGAL_INST(x)                                    (((unsigned)(x) & 0x1) << 11)
#define   G_00040C_ILLEGAL_INST(x)                                    (((x) >> 11) & 0x1)
#define   C_00040C_ILLEGAL_INST                                       0xFFFFF7FF
#define   S_00040C_EXCP_HI(x)                                         (((unsigned)(x) & 0x7) << 12)
#define   G_00040C_EXCP_HI(x)                                         (((x) >> 12) & 0x7)
#define   C_00040C_EXCP_HI                                            0xFFFF8FFF
#define   S_00040C_BUFFER_OOB(x)                                      (((unsigned)(x) & 0x1) << 15)
#define   G_00040C_BUFFER_OOB(x)                                      (((x) >> 15) & 0x1)
#define   C_00040C_BUFFER_OOB                                         0xFFFF7FFF
#define   S_00040C_EXCP_CYCLE(x)                                      (((unsigned)(x) & 0xF) << 16)
#define   G_00040C_EXCP_CYCLE(x)                                      (((x) >> 16) & 0xF)
#define   C_00040C_EXCP_CYCLE                                         0xFFF0FFFF
#define   S_00040C_EXCP_GROUP_MASK(x)                                 (((unsigned)(x) & 0xF) << 20)
#define   G_00040C_EXCP_GROUP_MASK(x)                                 (((x) >> 20) & 0xF)
#define   C_00040C_EXCP_GROUP_MASK                                    0xFF0FFFFF
#define   S_00040C_EXCP_WAVE64HI(x)                                   (((unsigned)(x) & 0x1) << 24)
#define   G_00040C_EXCP_WAVE64HI(x)                                   (((x) >> 24) & 0x1)
#define   C_00040C_EXCP_WAVE64HI                                      0xFEFFFFFF
#define   S_00040C_UTC_ERROR(x)                                       (((unsigned)(x) & 0x1) << 28) /* >= gfx103 */
#define   G_00040C_UTC_ERROR(x)                                       (((x) >> 28) & 0x1)
#define   C_00040C_UTC_ERROR                                          0xEFFFFFFF
#define   S_00040C_XNACK_ERROR(x)                                     (((unsigned)(x) & 0x1) << 28) /* gfx10 */
#define   G_00040C_XNACK_ERROR(x)                                     (((x) >> 28) & 0x1)
#define   C_00040C_XNACK_ERROR                                        0xEFFFFFFF
#define   S_00040C_DP_RATE(x)                                         (((unsigned)(x) & 0x7) << 29)
#define   G_00040C_DP_RATE(x)                                         (((x) >> 29) & 0x7)
#define   C_00040C_DP_RATE                                            0x1FFFFFFF
#define R_410_CP_DMA_WORD0                                              0x410
#define   S_410_SRC_ADDR_LO(x)                                        (((unsigned)(x) & 0xFFFFFFFF) << 0)
#define   G_410_SRC_ADDR_LO(x)                                        (((x) >> 0) & 0xFFFFFFFF)
#define   C_410_SRC_ADDR_LO                                           0x00000000
#define R_000410_SQ_WAVE_HW_ID_LEGACY                                   0x000410 /* >= gfx10 */
#define   S_000410_WAVE_ID(x)                                         (((unsigned)(x) & 0xF) << 0)
#define   G_000410_WAVE_ID(x)                                         (((x) >> 0) & 0xF)
#define   C_000410_WAVE_ID                                            0xFFFFFFF0
#define   S_000410_SIMD_ID(x)                                         (((unsigned)(x) & 0x3) << 4)
#define   G_000410_SIMD_ID(x)                                         (((x) >> 4) & 0x3)
#define   C_000410_SIMD_ID                                            0xFFFFFFCF
#define   S_000410_PIPE_ID(x)                                         (((unsigned)(x) & 0x3) << 6)
#define   G_000410_PIPE_ID(x)                                         (((x) >> 6) & 0x3)
#define   C_000410_PIPE_ID                                            0xFFFFFF3F
#define   S_000410_CU_ID(x)                                           (((unsigned)(x) & 0xF) << 8)
#define   G_000410_CU_ID(x)                                           (((x) >> 8) & 0xF)
#define   C_000410_CU_ID                                              0xFFFFF0FF
#define   S_000410_SH_ID(x)                                           (((unsigned)(x) & 0x1) << 12)
#define   G_000410_SH_ID(x)                                           (((x) >> 12) & 0x1)
#define   C_000410_SH_ID                                              0xFFFFEFFF
#define   S_000410_SE_ID(x)                                           (((unsigned)(x) & 0x3) << 13)
#define   G_000410_SE_ID(x)                                           (((x) >> 13) & 0x3)
#define   C_000410_SE_ID                                              0xFFFF9FFF
#define   S_000410_WAVE_ID_MSB(x)                                     (((unsigned)(x) & 0x1) << 15)
#define   G_000410_WAVE_ID_MSB(x)                                     (((x) >> 15) & 0x1)
#define   C_000410_WAVE_ID_MSB                                        0xFFFF7FFF
#define   S_000410_TG_ID(x)                                           (((unsigned)(x) & 0xF) << 16)
#define   G_000410_TG_ID(x)                                           (((x) >> 16) & 0xF)
#define   C_000410_TG_ID                                              0xFFF0FFFF
#define   S_000410_VM_ID(x)                                           (((unsigned)(x) & 0xF) << 20)
#define   G_000410_VM_ID(x)                                           (((x) >> 20) & 0xF)
#define   C_000410_VM_ID                                              0xFF0FFFFF
#define   S_000410_QUEUE_ID(x)                                        (((unsigned)(x) & 0x7) << 24)
#define   G_000410_QUEUE_ID(x)                                        (((x) >> 24) & 0x7)
#define   C_000410_QUEUE_ID                                           0xF8FFFFFF
#define   S_000410_STATE_ID(x)                                        (((unsigned)(x) & 0x7) << 27)
#define   G_000410_STATE_ID(x)                                        (((x) >> 27) & 0x7)
#define   C_000410_STATE_ID                                           0xC7FFFFFF
#define   S_000410_ME_ID(x)                                           (((unsigned)(x) & 0x3) << 30)
#define   G_000410_ME_ID(x)                                           (((x) >> 30) & 0x3)
#define   C_000410_ME_ID                                              0x3FFFFFFF
#define R_411_CP_DMA_WORD1                                              0x411
#define   S_411_SRC_ADDR_HI(x)                                        (((unsigned)(x) & 0xFFFF) << 0)
#define   G_411_SRC_ADDR_HI(x)                                        (((x) >> 0) & 0xFFFF)
#define   C_411_SRC_ADDR_HI                                           0xFFFF0000
#define   S_411_DST_SEL(x)                                            (((unsigned)(x) & 0x3) << 20)
#define   G_411_DST_SEL(x)                                            (((x) >> 20) & 0x3)
#define   C_411_DST_SEL                                               0xFFCFFFFF
#define     V_411_DST_ADDR                                          0
#define     V_411_GDS                                               1
#define     V_411_NOWHERE                                           2 /* >= gfx9 */
#define     V_411_DST_ADDR_TC_L2                                    3 /* >= gfx7 */
#define   S_411_ENGINE(x)                                             (((unsigned)(x) & 0x1) << 27)
#define   G_411_ENGINE(x)                                             (((x) >> 27) & 0x1)
#define   C_411_ENGINE                                                0xF7FFFFFF
#define     V_411_ME                                                0
#define     V_411_PFP                                               1
#define   S_411_SRC_SEL(x)                                            (((unsigned)(x) & 0x3) << 29)
#define   G_411_SRC_SEL(x)                                            (((x) >> 29) & 0x3)
#define   C_411_SRC_SEL                                               0x9FFFFFFF
#define     V_411_SRC_ADDR                                          0
#define     V_411_DATA                                              2
#define     V_411_SRC_ADDR_TC_L2                                    3 /* >= gfx7 */
#define   S_411_CP_SYNC(x)                                            (((unsigned)(x) & 0x1) << 31)
#define   G_411_CP_SYNC(x)                                            (((x) >> 31) & 0x1)
#define   C_411_CP_SYNC                                               0x7FFFFFFF
#define R_412_CP_DMA_WORD2                                              0x412
#define   S_412_DST_ADDR_LO(x)                                        (((unsigned)(x) & 0xFFFFFFFF) << 0)
#define   G_412_DST_ADDR_LO(x)                                        (((x) >> 0) & 0xFFFFFFFF)
#define   C_412_DST_ADDR_LO                                           0x00000000
#define R_413_CP_DMA_WORD3                                              0x413
#define   S_413_DST_ADDR_HI(x)                                        (((unsigned)(x) & 0xFFFF) << 0)
#define   G_413_DST_ADDR_HI(x)                                        (((x) >> 0) & 0xFFFF)
#define   C_413_DST_ADDR_HI                                           0xFFFF0000
#define R_000414_SQ_WAVE_GPR_ALLOC                                      0x000414 /* >= gfx10 */
#define   S_000414_VGPR_BASE(x)                                       (((unsigned)(x) & 0xFF) << 0)
#define   G_000414_VGPR_BASE(x)                                       (((x) >> 0) & 0xFF)
#define   C_000414_VGPR_BASE                                          0xFFFFFF00
#define   S_000414_VGPR_SIZE(x)                                       (((unsigned)(x) & 0xFF) << 8)
#define   G_000414_VGPR_SIZE(x)                                       (((x) >> 8) & 0xFF)
#define   C_000414_VGPR_SIZE                                          0xFFFF00FF
#define   S_000414_SGPR_BASE(x)                                       (((unsigned)(x) & 0xFF) << 16)
#define   G_000414_SGPR_BASE(x)                                       (((x) >> 16) & 0xFF)
#define   C_000414_SGPR_BASE                                          0xFF00FFFF
#define   S_000414_SGPR_SIZE(x)                                       (((unsigned)(x) & 0xF) << 24)
#define   G_000414_SGPR_SIZE(x)                                       (((x) >> 24) & 0xF)
#define   C_000414_SGPR_SIZE                                          0xF0FFFFFF
#define R_415_COMMAND                                                   0x415
#define   S_415_BYTE_COUNT_GFX6(x)                                    (((unsigned)(x) & 0x1FFFFF) << 0) /* <= gfx81 */
#define   G_415_BYTE_COUNT_GFX6(x)                                    (((x) >> 0) & 0x1FFFFF)
#define   C_415_BYTE_COUNT_GFX6                                       0xFFE00000
#define   S_415_BYTE_COUNT_GFX9(x)                                    (((unsigned)(x) & 0x3FFFFFF) << 0) /* >= gfx9 */
#define   G_415_BYTE_COUNT_GFX9(x)                                    (((x) >> 0) & 0x3FFFFFF)
#define   C_415_BYTE_COUNT_GFX9                                       0xFC000000
#define   S_415_DISABLE_WR_CONFIRM_GFX6(x)                            (((unsigned)(x) & 0x1) << 21) /* <= gfx81 */
#define   G_415_DISABLE_WR_CONFIRM_GFX6(x)                            (((x) >> 21) & 0x1)
#define   C_415_DISABLE_WR_CONFIRM_GFX6                               0xFFDFFFFF
#define   S_415_SRC_SWAP(x)                                           (((unsigned)(x) & 0x3) << 22) /* <= gfx81 */
#define   G_415_SRC_SWAP(x)                                           (((x) >> 22) & 0x3)
#define   C_415_SRC_SWAP                                              0xFF3FFFFF
#define     V_415_NONE                                              0
#define     V_415_8_IN_16                                           1
#define     V_415_8_IN_32                                           2
#define     V_415_8_IN_64                                           3
#define   S_415_DST_SWAP(x)                                           (((unsigned)(x) & 0x3) << 24) /* <= gfx81 */
#define   G_415_DST_SWAP(x)                                           (((x) >> 24) & 0x3)
#define   C_415_DST_SWAP                                              0xFCFFFFFF
#define   S_415_SAS(x)                                                (((unsigned)(x) & 0x1) << 26)
#define   G_415_SAS(x)                                                (((x) >> 26) & 0x1)
#define   C_415_SAS                                                   0xFBFFFFFF
#define     V_415_MEMORY                                            0
#define     V_415_REGISTER                                          1
#define   S_415_DAS(x)                                                (((unsigned)(x) & 0x1) << 27)
#define   G_415_DAS(x)                                                (((x) >> 27) & 0x1)
#define   C_415_DAS                                                   0xF7FFFFFF
#define   S_415_SAIC(x)                                               (((unsigned)(x) & 0x1) << 28)
#define   G_415_SAIC(x)                                               (((x) >> 28) & 0x1)
#define   C_415_SAIC                                                  0xEFFFFFFF
#define     V_415_INCREMENT                                         0
#define     V_415_NO_INCREMENT                                      1
#define   S_415_DAIC(x)                                               (((unsigned)(x) & 0x1) << 29)
#define   G_415_DAIC(x)                                               (((x) >> 29) & 0x1)
#define   C_415_DAIC                                                  0xDFFFFFFF
#define   S_415_RAW_WAIT(x)                                           (((unsigned)(x) & 0x1) << 30)
#define   G_415_RAW_WAIT(x)                                           (((x) >> 30) & 0x1)
#define   C_415_RAW_WAIT                                              0xBFFFFFFF
#define   S_415_DISABLE_WR_CONFIRM_GFX9(x)                            (((unsigned)(x) & 0x1) << 31) /* >= gfx9 */
#define   G_415_DISABLE_WR_CONFIRM_GFX9(x)                            (((x) >> 31) & 0x1)
#define   C_415_DISABLE_WR_CONFIRM_GFX9                               0x7FFFFFFF
#define R_000418_SQ_WAVE_LDS_ALLOC                                      0x000418 /* >= gfx10 */
#define   S_000418_LDS_BASE(x)                                        (((unsigned)(x) & 0x1FF) << 0)
#define   G_000418_LDS_BASE(x)                                        (((x) >> 0) & 0x1FF)
#define   C_000418_LDS_BASE                                           0xFFFFFE00
#define   S_000418_LDS_SIZE(x)                                        (((unsigned)(x) & 0x1FF) << 12)
#define   G_000418_LDS_SIZE(x)                                        (((x) >> 12) & 0x1FF)
#define   C_000418_LDS_SIZE                                           0xFFE00FFF
#define   S_000418_VGPR_SHARED_SIZE(x)                                (((unsigned)(x) & 0xF) << 24)
#define   G_000418_VGPR_SHARED_SIZE(x)                                (((x) >> 24) & 0xF)
#define   C_000418_VGPR_SHARED_SIZE                                   0xF0FFFFFF
#define R_00041C_SQ_WAVE_IB_STS                                         0x00041C /* >= gfx10 */
#define   S_00041C_VM_CNT(x)                                          (((unsigned)(x) & 0xF) << 0)
#define   G_00041C_VM_CNT(x)                                          (((x) >> 0) & 0xF)
#define   C_00041C_VM_CNT                                             0xFFFFFFF0
#define   S_00041C_EXP_CNT(x)                                         (((unsigned)(x) & 0x7) << 4)
#define   G_00041C_EXP_CNT(x)                                         (((x) >> 4) & 0x7)
#define   C_00041C_EXP_CNT                                            0xFFFFFF8F
#define   S_00041C_LGKM_CNT_BIT4(x)                                   (((unsigned)(x) & 0x1) << 7)
#define   G_00041C_LGKM_CNT_BIT4(x)                                   (((x) >> 7) & 0x1)
#define   C_00041C_LGKM_CNT_BIT4                                      0xFFFFFF7F
#define   S_00041C_LGKM_CNT(x)                                        (((unsigned)(x) & 0xF) << 8)
#define   G_00041C_LGKM_CNT(x)                                        (((x) >> 8) & 0xF)
#define   C_00041C_LGKM_CNT                                           0xFFFFF0FF
#define   S_00041C_VALU_CNT(x)                                        (((unsigned)(x) & 0x7) << 12)
#define   G_00041C_VALU_CNT(x)                                        (((x) >> 12) & 0x7)
#define   C_00041C_VALU_CNT                                           0xFFFF8FFF
#define   S_00041C_FIRST_REPLAY(x)                                    (((unsigned)(x) & 0x1) << 15) /* gfx10 */
#define   G_00041C_FIRST_REPLAY(x)                                    (((x) >> 15) & 0x1)
#define   C_00041C_FIRST_REPLAY                                       0xFFFF7FFF
#define   S_00041C_RCNT(x)                                            (((unsigned)(x) & 0x3F) << 16) /* gfx10 */
#define   G_00041C_RCNT(x)                                            (((x) >> 16) & 0x3F)
#define   C_00041C_RCNT                                               0xFFC0FFFF
#define   S_00041C_VM_CNT_HI(x)                                       (((unsigned)(x) & 0x3) << 22)
#define   G_00041C_VM_CNT_HI(x)                                       (((x) >> 22) & 0x3)
#define   C_00041C_VM_CNT_HI                                          0xFF3FFFFF
#define   S_00041C_LGKM_CNT_BIT5(x)                                   (((unsigned)(x) & 0x1) << 24)
#define   G_00041C_LGKM_CNT_BIT5(x)                                   (((x) >> 24) & 0x1)
#define   C_00041C_LGKM_CNT_BIT5                                      0xFEFFFFFF
#define   S_00041C_REPLAY_W64H(x)                                     (((unsigned)(x) & 0x1) << 25) /* gfx10 */
#define   G_00041C_REPLAY_W64H(x)                                     (((x) >> 25) & 0x1)
#define   C_00041C_REPLAY_W64H                                        0xFDFFFFFF
#define   S_00041C_VS_CNT(x)                                          (((unsigned)(x) & 0x3F) << 26)
#define   G_00041C_VS_CNT(x)                                          (((x) >> 26) & 0x3F)
#define   C_00041C_VS_CNT                                             0x03FFFFFF
#define R_000420_SQ_WAVE_PC_LO                                          0x000420 /* >= gfx10 */
#define R_000424_SQ_WAVE_PC_HI                                          0x000424 /* >= gfx10 */
#define   S_000424_PC_HI(x)                                           (((unsigned)(x) & 0xFFFF) << 0)
#define   G_000424_PC_HI(x)                                           (((x) >> 0) & 0xFFFF)
#define   C_000424_PC_HI                                              0xFFFF0000
#define R_000428_SQ_WAVE_INST_DW0                                       0x000428 /* >= gfx10 */
#define R_000434_SQ_WAVE_IB_DBG1                                        0x000434 /* >= gfx10 */
#define   S_000434_XNACK_ERROR(x)                                     (((unsigned)(x) & 0x1) << 0) /* gfx10 */
#define   G_000434_XNACK_ERROR(x)                                     (((x) >> 0) & 0x1)
#define   C_000434_XNACK_ERROR                                        0xFFFFFFFE
#define   S_000434_XNACK(x)                                           (((unsigned)(x) & 0x1) << 1) /* gfx10 */
#define   G_000434_XNACK(x)                                           (((x) >> 1) & 0x1)
#define   C_000434_XNACK                                              0xFFFFFFFD
#define   S_000434_TA_NEED_RESET(x)                                   (((unsigned)(x) & 0x1) << 2) /* gfx10 */
#define   G_000434_TA_NEED_RESET(x)                                   (((x) >> 2) & 0x1)
#define   C_000434_TA_NEED_RESET                                      0xFFFFFFFB
#define   S_000434_XNACK_OVERRIDE(x)                                  (((unsigned)(x) & 0x1) << 3) /* gfx10 */
#define   G_000434_XNACK_OVERRIDE(x)                                  (((x) >> 3) & 0x1)
#define   C_000434_XNACK_OVERRIDE                                     0xFFFFFFF7
#define   S_000434_XCNT(x)                                            (((unsigned)(x) & 0x3F) << 4) /* gfx10 */
#define   G_000434_XCNT(x)                                            (((x) >> 4) & 0x3F)
#define   C_000434_XCNT                                               0xFFFFFC0F
#define   S_000434_QCNT(x)                                            (((unsigned)(x) & 0x3F) << 11) /* gfx10 */
#define   G_000434_QCNT(x)                                            (((x) >> 11) & 0x3F)
#define   C_000434_QCNT                                               0xFFFE07FF
#define   S_000434_RCNT(x)                                            (((unsigned)(x) & 0x3F) << 18) /* gfx10 */
#define   G_000434_RCNT(x)                                            (((x) >> 18) & 0x3F)
#define   C_000434_RCNT                                               0xFF03FFFF
#define   S_000434_WAVE_IDLE(x)                                       (((unsigned)(x) & 0x1) << 24)
#define   G_000434_WAVE_IDLE(x)                                       (((x) >> 24) & 0x1)
#define   C_000434_WAVE_IDLE                                          0xFEFFFFFF
#define   S_000434_MISC_CNT(x)                                        (((unsigned)(x) & 0x7F) << 25)
#define   G_000434_MISC_CNT(x)                                        (((x) >> 25) & 0x7F)
#define   C_000434_MISC_CNT                                           0x01FFFFFF
#define R_000438_SQ_WAVE_FLUSH_IB                                       0x000438 /* >= gfx10 */
#define R_000450_SQ_WAVE_FLAT_SCRATCH_LO                                0x000450 /* >= gfx103 */
#define R_000454_SQ_WAVE_FLAT_SCRATCH_HI                                0x000454 /* >= gfx103 */
#define R_00045C_SQ_WAVE_HW_ID1                                         0x00045C /* >= gfx10 */
#define   S_00045C_WAVE_ID(x)                                         (((unsigned)(x) & 0x1F) << 0)
#define   G_00045C_WAVE_ID(x)                                         (((x) >> 0) & 0x1F)
#define   C_00045C_WAVE_ID                                            0xFFFFFFE0
#define   S_00045C_SIMD_ID(x)                                         (((unsigned)(x) & 0x3) << 8)
#define   G_00045C_SIMD_ID(x)                                         (((x) >> 8) & 0x3)
#define   C_00045C_SIMD_ID                                            0xFFFFFCFF
#define   S_00045C_WGP_ID(x)                                          (((unsigned)(x) & 0xF) << 10)
#define   G_00045C_WGP_ID(x)                                          (((x) >> 10) & 0xF)
#define   C_00045C_WGP_ID                                             0xFFFFC3FF
#define   S_00045C_SA_ID(x)                                           (((unsigned)(x) & 0x1) << 16)
#define   G_00045C_SA_ID(x)                                           (((x) >> 16) & 0x1)
#define   C_00045C_SA_ID                                              0xFFFEFFFF
#define   S_00045C_SE_ID(x)                                           (((unsigned)(x) & 0x3) << 18)
#define   G_00045C_SE_ID(x)                                           (((x) >> 18) & 0x3)
#define   C_00045C_SE_ID                                              0xFFF3FFFF
#define R_000460_SQ_WAVE_HW_ID2                                         0x000460 /* >= gfx10 */
#define   S_000460_QUEUE_ID(x)                                        (((unsigned)(x) & 0xF) << 0)
#define   G_000460_QUEUE_ID(x)                                        (((x) >> 0) & 0xF)
#define   C_000460_QUEUE_ID                                           0xFFFFFFF0
#define   S_000460_PIPE_ID(x)                                         (((unsigned)(x) & 0x3) << 4)
#define   G_000460_PIPE_ID(x)                                         (((x) >> 4) & 0x3)
#define   C_000460_PIPE_ID                                            0xFFFFFFCF
#define   S_000460_ME_ID(x)                                           (((unsigned)(x) & 0x3) << 8)
#define   G_000460_ME_ID(x)                                           (((x) >> 8) & 0x3)
#define   C_000460_ME_ID                                              0xFFFFFCFF
#define   S_000460_STATE_ID(x)                                        (((unsigned)(x) & 0x7) << 12)
#define   G_000460_STATE_ID(x)                                        (((x) >> 12) & 0x7)
#define   C_000460_STATE_ID                                           0xFFFF8FFF
#define   S_000460_WG_ID(x)                                           (((unsigned)(x) & 0x1F) << 16)
#define   G_000460_WG_ID(x)                                           (((x) >> 16) & 0x1F)
#define   C_000460_WG_ID                                              0xFFE0FFFF
#define   S_000460_VM_ID(x)                                           (((unsigned)(x) & 0xF) << 24)
#define   G_000460_VM_ID(x)                                           (((x) >> 24) & 0xF)
#define   C_000460_VM_ID                                              0xF0FFFFFF
#define   S_000460_COMPAT_LEVEL(x)                                    (((unsigned)(x) & 0x3) << 29) /* gfx10 */
#define   G_000460_COMPAT_LEVEL(x)                                    (((x) >> 29) & 0x3)
#define   C_000460_COMPAT_LEVEL                                       0x9FFFFFFF
#define R_000464_SQ_WAVE_POPS_PACKER                                    0x000464 /* >= gfx10 */
#define   S_000464_POPS_EN(x)                                         (((unsigned)(x) & 0x1) << 0)
#define   G_000464_POPS_EN(x)                                         (((x) >> 0) & 0x1)
#define   C_000464_POPS_EN                                            0xFFFFFFFE
#define   S_000464_POPS_PACKER_ID(x)                                  (((unsigned)(x) & 0x3) << 1)
#define   G_000464_POPS_PACKER_ID(x)                                  (((x) >> 1) & 0x3)
#define   C_000464_POPS_PACKER_ID                                     0xFFFFFFF9
#define R_000468_SQ_WAVE_SCHED_MODE                                     0x000468 /* >= gfx10 */
#define   S_000468_DEP_MODE(x)                                        (((unsigned)(x) & 0x3) << 0)
#define   G_000468_DEP_MODE(x)                                        (((x) >> 0) & 0x3)
#define   C_000468_DEP_MODE                                           0xFFFFFFFC
#define R_00046C_SQ_WAVE_VGPR_OFFSET                                    0x00046C /* >= gfx10 */
#define   S_00046C_SRC0(x)                                            (((unsigned)(x) & 0x3F) << 0)
#define   G_00046C_SRC0(x)                                            (((x) >> 0) & 0x3F)
#define   C_00046C_SRC0                                               0xFFFFFFC0
#define   S_00046C_SRC1(x)                                            (((unsigned)(x) & 0x3F) << 6)
#define   G_00046C_SRC1(x)                                            (((x) >> 6) & 0x3F)
#define   C_00046C_SRC1                                               0xFFFFF03F
#define   S_00046C_SRC2(x)                                            (((unsigned)(x) & 0x3F) << 12)
#define   G_00046C_SRC2(x)                                            (((x) >> 12) & 0x3F)
#define   C_00046C_SRC2                                               0xFFFC0FFF
#define   S_00046C_DST(x)                                             (((unsigned)(x) & 0x3F) << 18)
#define   G_00046C_DST(x)                                             (((x) >> 18) & 0x3F)
#define   C_00046C_DST                                                0xFF03FFFF
#define R_000470_SQ_WAVE_IB_STS2                                        0x000470 /* >= gfx10 */
#define   S_000470_INST_PREFETCH(x)                                   (((unsigned)(x) & 0x3) << 0)
#define   G_000470_INST_PREFETCH(x)                                   (((x) >> 0) & 0x3)
#define   C_000470_INST_PREFETCH                                      0xFFFFFFFC
#define   S_000470_RESOURCE_OVERRIDE(x)                               (((unsigned)(x) & 0x1) << 7)
#define   G_000470_RESOURCE_OVERRIDE(x)                               (((x) >> 7) & 0x1)
#define   C_000470_RESOURCE_OVERRIDE                                  0xFFFFFF7F
#define   S_000470_MEM_ORDER(x)                                       (((unsigned)(x) & 0x3) << 8)
#define   G_000470_MEM_ORDER(x)                                       (((x) >> 8) & 0x3)
#define   C_000470_MEM_ORDER                                          0xFFFFFCFF
#define   S_000470_FWD_PROGRESS(x)                                    (((unsigned)(x) & 0x1) << 10)
#define   G_000470_FWD_PROGRESS(x)                                    (((x) >> 10) & 0x1)
#define   C_000470_FWD_PROGRESS                                       0xFFFFFBFF
#define   S_000470_WAVE64(x)                                          (((unsigned)(x) & 0x1) << 11)
#define   G_000470_WAVE64(x)                                          (((x) >> 11) & 0x1)
#define   C_000470_WAVE64                                             0xFFFFF7FF
#define   S_000470_WAVE64HI(x)                                        (((unsigned)(x) & 0x1) << 12) /* gfx10 */
#define   G_000470_WAVE64HI(x)                                        (((x) >> 12) & 0x1)
#define   C_000470_WAVE64HI                                           0xFFFFEFFF
#define   S_000470_SUBV_LOOP(x)                                       (((unsigned)(x) & 0x1) << 13) /* gfx10 */
#define   G_000470_SUBV_LOOP(x)                                       (((x) >> 13) & 0x1)
#define   C_000470_SUBV_LOOP                                          0xFFFFDFFF
#define R_000474_SQ_WAVE_SHADER_CYCLES                                  0x000474 /* >= gfx103 */
#define   S_000474_CYCLES(x)                                          (((unsigned)(x) & 0xFFFFF) << 0)
#define   G_000474_CYCLES(x)                                          (((x) >> 0) & 0xFFFFF)
#define   C_000474_CYCLES                                             0xFFF00000
#define R_490_RELEASE_MEM_OP                                            0x490 /* >= gfx10 */
#define   S_490_EVENT_TYPE(x)                                         (((unsigned)(x) & 0x3F) << 0)
#define   G_490_EVENT_TYPE(x)                                         (((x) >> 0) & 0x3F)
#define   C_490_EVENT_TYPE                                            0xFFFFFFC0
#define   S_490_EVENT_INDEX(x)                                        (((unsigned)(x) & 0xF) << 8)
#define   G_490_EVENT_INDEX(x)                                        (((x) >> 8) & 0xF)
#define   C_490_EVENT_INDEX                                           0xFFFFF0FF
#define   S_490_GLM_WB(x)                                             (((unsigned)(x) & 0x1) << 12)
#define   G_490_GLM_WB(x)                                             (((x) >> 12) & 0x1)
#define   C_490_GLM_WB                                                0xFFFFEFFF
#define   S_490_GLM_INV(x)                                            (((unsigned)(x) & 0x1) << 13)
#define   G_490_GLM_INV(x)                                            (((x) >> 13) & 0x1)
#define   C_490_GLM_INV                                               0xFFFFDFFF
#define   S_490_GLV_INV(x)                                            (((unsigned)(x) & 0x1) << 14)
#define   G_490_GLV_INV(x)                                            (((x) >> 14) & 0x1)
#define   C_490_GLV_INV                                               0xFFFFBFFF
#define   S_490_GL1_INV(x)                                            (((unsigned)(x) & 0x1) << 15)
#define   G_490_GL1_INV(x)                                            (((x) >> 15) & 0x1)
#define   C_490_GL1_INV                                               0xFFFF7FFF
#define   S_490_GL2_US(x)                                             (((unsigned)(x) & 0x1) << 16)
#define   G_490_GL2_US(x)                                             (((x) >> 16) & 0x1)
#define   C_490_GL2_US                                                0xFFFEFFFF
#define   S_490_GL2_RANGE(x)                                          (((unsigned)(x) & 0x3) << 17)
#define   G_490_GL2_RANGE(x)                                          (((x) >> 17) & 0x3)
#define   C_490_GL2_RANGE                                             0xFFF9FFFF
#define     V_490_GL2_ALL                                           0
#define     V_490_GL2_VOL                                           1
#define     V_490_GL2_RANGE                                         2
#define     V_490_GL2_FIRST_LAST                                    3
#define   S_490_GL2_DISCARD(x)                                        (((unsigned)(x) & 0x1) << 19)
#define   G_490_GL2_DISCARD(x)                                        (((x) >> 19) & 0x1)
#define   C_490_GL2_DISCARD                                           0xFFF7FFFF
#define   S_490_GL2_INV(x)                                            (((unsigned)(x) & 0x1) << 20)
#define   G_490_GL2_INV(x)                                            (((x) >> 20) & 0x1)
#define   C_490_GL2_INV                                               0xFFEFFFFF
#define   S_490_GL2_WB(x)                                             (((unsigned)(x) & 0x1) << 21)
#define   G_490_GL2_WB(x)                                             (((x) >> 21) & 0x1)
#define   C_490_GL2_WB                                                0xFFDFFFFF
#define   S_490_SEQ(x)                                                (((unsigned)(x) & 0x3) << 22)
#define   G_490_SEQ(x)                                                (((x) >> 22) & 0x3)
#define   C_490_SEQ                                                   0xFF3FFFFF
#define     V_490_SEQ_PARALLEL                                      0
#define     V_490_SEQ_FORWARD                                       1
#define     V_490_SEQ_REVERSE                                       2
#define R_500_DMA_DATA_WORD0                                            0x500
#define   S_500_ENGINE(x)                                             (((unsigned)(x) & 0x1) << 0)
#define   G_500_ENGINE(x)                                             (((x) >> 0) & 0x1)
#define   C_500_ENGINE                                                0xFFFFFFFE
#define     V_500_ME                                                0
#define     V_500_PFP                                               1
#define   S_500_SRC_CACHE_POLICY(x)                                   (((unsigned)(x) & 0x3) << 13) /* >= gfx7 */
#define   G_500_SRC_CACHE_POLICY(x)                                   (((x) >> 13) & 0x3)
#define   C_500_SRC_CACHE_POLICY                                      0xFFFF9FFF
#define   S_500_DST_SEL(x)                                            (((unsigned)(x) & 0x3) << 20)
#define   G_500_DST_SEL(x)                                            (((x) >> 20) & 0x3)
#define   C_500_DST_SEL                                               0xFFCFFFFF
#define     V_500_DST_ADDR                                          0
#define     V_500_GDS                                               1
#define     V_500_NOWHERE                                           2 /* >= gfx9 */
#define     V_500_DST_ADDR_TC_L2                                    3 /* >= gfx7 */
#define   S_500_DST_CACHE_POLICY(x)                                   (((unsigned)(x) & 0x3) << 25) /* >= gfx7 */
#define   G_500_DST_CACHE_POLICY(x)                                   (((x) >> 25) & 0x3)
#define   C_500_DST_CACHE_POLICY                                      0xF9FFFFFF
#define   S_500_SRC_SEL(x)                                            (((unsigned)(x) & 0x3) << 29)
#define   G_500_SRC_SEL(x)                                            (((x) >> 29) & 0x3)
#define   C_500_SRC_SEL                                               0x9FFFFFFF
#define     V_500_SRC_ADDR                                          0
#define     V_500_DATA                                              2
#define     V_500_SRC_ADDR_TC_L2                                    3 /* >= gfx7 */
#define   S_500_CP_SYNC(x)                                            (((unsigned)(x) & 0x1) << 31)
#define   G_500_CP_SYNC(x)                                            (((x) >> 31) & 0x1)
#define   C_500_CP_SYNC                                               0x7FFFFFFF
#define R_501_SRC_ADDR_LO                                               0x501
#define R_502_SRC_ADDR_HI                                               0x502
#define R_503_DST_ADDR_LO                                               0x503
#define R_504_DST_ADDR_HI                                               0x504
#define R_586_GCR_CNTL                                                  0x586 /* >= gfx10 */
#define   S_586_GLI_INV(x)                                            (((unsigned)(x) & 0x3) << 0)
#define   G_586_GLI_INV(x)                                            (((x) >> 0) & 0x3)
#define   C_586_GLI_INV                                               0xFFFFFFFC
#define     V_586_GLI_NOP                                           0
#define     V_586_GLI_ALL                                           1
#define     V_586_GLI_RANGE                                         2
#define     V_586_GLI_FIRST_LAST                                    3
#define   S_586_GL1_RANGE(x)                                          (((unsigned)(x) & 0x3) << 2)
#define   G_586_GL1_RANGE(x)                                          (((x) >> 2) & 0x3)
#define   C_586_GL1_RANGE                                             0xFFFFFFF3
#define     V_586_GL1_ALL                                           0
#define     V_586_GL1_RANGE                                         2
#define     V_586_GL1_FIRST_LAST                                    3
#define   S_586_GLM_WB(x)                                             (((unsigned)(x) & 0x1) << 4)
#define   G_586_GLM_WB(x)                                             (((x) >> 4) & 0x1)
#define   C_586_GLM_WB                                                0xFFFFFFEF
#define   S_586_GLM_INV(x)                                            (((unsigned)(x) & 0x1) << 5)
#define   G_586_GLM_INV(x)                                            (((x) >> 5) & 0x1)
#define   C_586_GLM_INV                                               0xFFFFFFDF
#define   S_586_GLK_WB(x)                                             (((unsigned)(x) & 0x1) << 6)
#define   G_586_GLK_WB(x)                                             (((x) >> 6) & 0x1)
#define   C_586_GLK_WB                                                0xFFFFFFBF
#define   S_586_GLK_INV(x)                                            (((unsigned)(x) & 0x1) << 7)
#define   G_586_GLK_INV(x)                                            (((x) >> 7) & 0x1)
#define   C_586_GLK_INV                                               0xFFFFFF7F
#define   S_586_GLV_INV(x)                                            (((unsigned)(x) & 0x1) << 8)
#define   G_586_GLV_INV(x)                                            (((x) >> 8) & 0x1)
#define   C_586_GLV_INV                                               0xFFFFFEFF
#define   S_586_GL1_INV(x)                                            (((unsigned)(x) & 0x1) << 9)
#define   G_586_GL1_INV(x)                                            (((x) >> 9) & 0x1)
#define   C_586_GL1_INV                                               0xFFFFFDFF
#define   S_586_GL2_US(x)                                             (((unsigned)(x) & 0x1) << 10)
#define   G_586_GL2_US(x)                                             (((x) >> 10) & 0x1)
#define   C_586_GL2_US                                                0xFFFFFBFF
#define   S_586_GL2_RANGE(x)                                          (((unsigned)(x) & 0x3) << 11)
#define   G_586_GL2_RANGE(x)                                          (((x) >> 11) & 0x3)
#define   C_586_GL2_RANGE                                             0xFFFFE7FF
#define     V_586_GL2_ALL                                           0
#define     V_586_GL2_VOL                                           1
#define     V_586_GL2_RANGE                                         2
#define     V_586_GL2_FIRST_LAST                                    3
#define   S_586_GL2_DISCARD(x)                                        (((unsigned)(x) & 0x1) << 13)
#define   G_586_GL2_DISCARD(x)                                        (((x) >> 13) & 0x1)
#define   C_586_GL2_DISCARD                                           0xFFFFDFFF
#define   S_586_GL2_INV(x)                                            (((unsigned)(x) & 0x1) << 14)
#define   G_586_GL2_INV(x)                                            (((x) >> 14) & 0x1)
#define   C_586_GL2_INV                                               0xFFFFBFFF
#define   S_586_GL2_WB(x)                                             (((unsigned)(x) & 0x1) << 15)
#define   G_586_GL2_WB(x)                                             (((x) >> 15) & 0x1)
#define   C_586_GL2_WB                                                0xFFFF7FFF
#define   S_586_SEQ(x)                                                (((unsigned)(x) & 0x3) << 16)
#define   G_586_SEQ(x)                                                (((x) >> 16) & 0x3)
#define   C_586_SEQ                                                   0xFFFCFFFF
#define     V_586_SEQ_PARALLEL                                      0
#define     V_586_SEQ_FORWARD                                       1
#define     V_586_SEQ_REVERSE                                       2
#define   S_586_RANGE_IS_PA(x)                                        (((unsigned)(x) & 0x1) << 18)
#define   G_586_RANGE_IS_PA(x)                                        (((x) >> 18) & 0x1)
#define   C_586_RANGE_IS_PA                                           0xFFFBFFFF
#define R_0009B0_SQ_WAVE_TBA_LO                                         0x0009B0 /* <= gfx81 */
#define R_0009B0_SQ_WAVE_TTMP0                                          0x0009B0 /* >= gfx9 */
#define R_0009B4_SQ_WAVE_TBA_HI                                         0x0009B4 /* <= gfx81 */
#define   S_0009B4_ADDR_HI(x)                                         (((unsigned)(x) & 0xFF) << 0)
#define   G_0009B4_ADDR_HI(x)                                         (((x) >> 0) & 0xFF)
#define   C_0009B4_ADDR_HI                                            0xFFFFFF00
#define R_0009B4_SQ_WAVE_TTMP1                                          0x0009B4 /* >= gfx9 */
#define R_0009B8_SQ_WAVE_TMA_LO                                         0x0009B8 /* <= gfx81 */
#define R_0009B8_SQ_WAVE_TTMP2                                          0x0009B8 /* >= gfx9 */
#define R_0009BC_SQ_WAVE_TMA_HI                                         0x0009BC /* <= gfx81 */
#define   S_0009BC_ADDR_HI(x)                                         (((unsigned)(x) & 0xFF) << 0)
#define   G_0009BC_ADDR_HI(x)                                         (((x) >> 0) & 0xFF)
#define   C_0009BC_ADDR_HI                                            0xFFFFFF00
#define R_0009BC_SQ_WAVE_TTMP3                                          0x0009BC /* >= gfx9 */
#define R_0009C0_SQ_WAVE_TTMP0                                          0x0009C0 /* <= gfx81 */
#define R_0009C0_SQ_WAVE_TTMP4                                          0x0009C0 /* >= gfx9 */
#define R_0009C4_SQ_WAVE_TTMP1                                          0x0009C4 /* <= gfx81 */
#define R_0009C4_SQ_WAVE_TTMP5                                          0x0009C4 /* >= gfx9 */
#define R_0009C8_SQ_WAVE_TTMP2                                          0x0009C8 /* <= gfx81 */
#define R_0009C8_SQ_WAVE_TTMP6                                          0x0009C8 /* >= gfx9 */
#define R_0009CC_SQ_WAVE_TTMP3                                          0x0009CC /* <= gfx81 */
#define R_0009CC_SQ_WAVE_TTMP7                                          0x0009CC /* >= gfx9 */
#define R_0009D0_SQ_WAVE_TTMP4                                          0x0009D0 /* <= gfx81 */
#define R_0009D0_SQ_WAVE_TTMP8                                          0x0009D0 /* >= gfx9 */
#define R_0009D4_SQ_WAVE_TTMP5                                          0x0009D4 /* <= gfx81 */
#define R_0009D4_SQ_WAVE_TTMP9                                          0x0009D4 /* >= gfx9 */
#define R_0009D8_SQ_WAVE_TTMP10                                         0x0009D8 /* >= gfx9 */
#define R_0009D8_SQ_WAVE_TTMP6                                          0x0009D8 /* <= gfx81 */
#define R_0009DC_SQ_WAVE_TTMP11                                         0x0009DC /* >= gfx9 */
#define R_0009DC_SQ_WAVE_TTMP7                                          0x0009DC /* <= gfx81 */
#define R_0009E0_SQ_WAVE_TTMP12                                         0x0009E0 /* >= gfx9 */
#define R_0009E0_SQ_WAVE_TTMP8                                          0x0009E0 /* <= gfx81 */
#define R_0009E4_SQ_WAVE_TTMP13                                         0x0009E4 /* >= gfx9 */
#define R_0009E4_SQ_WAVE_TTMP9                                          0x0009E4 /* <= gfx81 */
#define R_0009E8_SQ_WAVE_TTMP10                                         0x0009E8 /* <= gfx81 */
#define R_0009E8_SQ_WAVE_TTMP14                                         0x0009E8 /* >= gfx9 */
#define R_0009EC_SQ_WAVE_TTMP11                                         0x0009EC /* <= gfx81 */
#define R_0009EC_SQ_WAVE_TTMP15                                         0x0009EC /* >= gfx9 */
#define R_0009F0_SQ_WAVE_M0                                             0x0009F0
#define R_0009F8_SQ_WAVE_EXEC_LO                                        0x0009F8
#define R_0009FC_SQ_WAVE_EXEC_HI                                        0x0009FC
#define R_000A00_SQ_WAVE_FLAT_SCRATCH_LO                                0x000A00 /* gfx10 */
#define R_000A04_SQ_WAVE_FLAT_SCRATCH_HI                                0x000A04 /* gfx10 */
#define R_000A08_SQ_WAVE_FLAT_XNACK_MASK                                0x000A08 /* gfx10 */
#define R_000E4C_SRBM_STATUS2                                           0x000E4C /* <= gfx81 */
#define   S_000E4C_SDMA_RQ_PENDING(x)                                 (((unsigned)(x) & 0x1) << 0)
#define   G_000E4C_SDMA_RQ_PENDING(x)                                 (((x) >> 0) & 0x1)
#define   C_000E4C_SDMA_RQ_PENDING                                    0xFFFFFFFE
#define   S_000E4C_TST_RQ_PENDING(x)                                  (((unsigned)(x) & 0x1) << 1)
#define   G_000E4C_TST_RQ_PENDING(x)                                  (((x) >> 1) & 0x1)
#define   C_000E4C_TST_RQ_PENDING                                     0xFFFFFFFD
#define   S_000E4C_SDMA1_RQ_PENDING(x)                                (((unsigned)(x) & 0x1) << 2)
#define   G_000E4C_SDMA1_RQ_PENDING(x)                                (((x) >> 2) & 0x1)
#define   C_000E4C_SDMA1_RQ_PENDING                                   0xFFFFFFFB
#define   S_000E4C_VCE0_RQ_PENDING(x)                                 (((unsigned)(x) & 0x1) << 3)
#define   G_000E4C_VCE0_RQ_PENDING(x)                                 (((x) >> 3) & 0x1)
#define   C_000E4C_VCE0_RQ_PENDING                                    0xFFFFFFF7
#define   S_000E4C_VP8_BUSY(x)                                        (((unsigned)(x) & 0x1) << 4)
#define   G_000E4C_VP8_BUSY(x)                                        (((x) >> 4) & 0x1)
#define   C_000E4C_VP8_BUSY                                           0xFFFFFFEF
#define   S_000E4C_SDMA_BUSY(x)                                       (((unsigned)(x) & 0x1) << 5)
#define   G_000E4C_SDMA_BUSY(x)                                       (((x) >> 5) & 0x1)
#define   C_000E4C_SDMA_BUSY                                          0xFFFFFFDF
#define   S_000E4C_SDMA1_BUSY(x)                                      (((unsigned)(x) & 0x1) << 6)
#define   G_000E4C_SDMA1_BUSY(x)                                      (((x) >> 6) & 0x1)
#define   C_000E4C_SDMA1_BUSY                                         0xFFFFFFBF
#define   S_000E4C_VCE0_BUSY(x)                                       (((unsigned)(x) & 0x1) << 7)
#define   G_000E4C_VCE0_BUSY(x)                                       (((x) >> 7) & 0x1)
#define   C_000E4C_VCE0_BUSY                                          0xFFFFFF7F
#define   S_000E4C_XDMA_BUSY(x)                                       (((unsigned)(x) & 0x1) << 8)
#define   G_000E4C_XDMA_BUSY(x)                                       (((x) >> 8) & 0x1)
#define   C_000E4C_XDMA_BUSY                                          0xFFFFFEFF
#define   S_000E4C_CHUB_BUSY(x)                                       (((unsigned)(x) & 0x1) << 9)
#define   G_000E4C_CHUB_BUSY(x)                                       (((x) >> 9) & 0x1)
#define   C_000E4C_CHUB_BUSY                                          0xFFFFFDFF
#define   S_000E4C_SDMA2_BUSY(x)                                      (((unsigned)(x) & 0x1) << 10)
#define   G_000E4C_SDMA2_BUSY(x)                                      (((x) >> 10) & 0x1)
#define   C_000E4C_SDMA2_BUSY                                         0xFFFFFBFF
#define   S_000E4C_SDMA3_BUSY(x)                                      (((unsigned)(x) & 0x1) << 11)
#define   G_000E4C_SDMA3_BUSY(x)                                      (((x) >> 11) & 0x1)
#define   C_000E4C_SDMA3_BUSY                                         0xFFFFF7FF
#define   S_000E4C_SAMSCP_BUSY(x)                                     (((unsigned)(x) & 0x1) << 12)
#define   G_000E4C_SAMSCP_BUSY(x)                                     (((x) >> 12) & 0x1)
#define   C_000E4C_SAMSCP_BUSY                                        0xFFFFEFFF
#define   S_000E4C_ISP_BUSY(x)                                        (((unsigned)(x) & 0x1) << 13)
#define   G_000E4C_ISP_BUSY(x)                                        (((x) >> 13) & 0x1)
#define   C_000E4C_ISP_BUSY                                           0xFFFFDFFF
#define   S_000E4C_VCE1_BUSY(x)                                       (((unsigned)(x) & 0x1) << 14)
#define   G_000E4C_VCE1_BUSY(x)                                       (((x) >> 14) & 0x1)
#define   C_000E4C_VCE1_BUSY                                          0xFFFFBFFF
#define   S_000E4C_ODE_BUSY(x)                                        (((unsigned)(x) & 0x1) << 15)
#define   G_000E4C_ODE_BUSY(x)                                        (((x) >> 15) & 0x1)
#define   C_000E4C_ODE_BUSY                                           0xFFFF7FFF
#define   S_000E4C_SDMA2_RQ_PENDING(x)                                (((unsigned)(x) & 0x1) << 16)
#define   G_000E4C_SDMA2_RQ_PENDING(x)                                (((x) >> 16) & 0x1)
#define   C_000E4C_SDMA2_RQ_PENDING                                   0xFFFEFFFF
#define   S_000E4C_SDMA3_RQ_PENDING(x)                                (((unsigned)(x) & 0x1) << 17)
#define   G_000E4C_SDMA3_RQ_PENDING(x)                                (((x) >> 17) & 0x1)
#define   C_000E4C_SDMA3_RQ_PENDING                                   0xFFFDFFFF
#define   S_000E4C_SAMSCP_RQ_PENDING(x)                               (((unsigned)(x) & 0x1) << 18)
#define   G_000E4C_SAMSCP_RQ_PENDING(x)                               (((x) >> 18) & 0x1)
#define   C_000E4C_SAMSCP_RQ_PENDING                                  0xFFFBFFFF
#define   S_000E4C_ISP_RQ_PENDING(x)                                  (((unsigned)(x) & 0x1) << 19)
#define   G_000E4C_ISP_RQ_PENDING(x)                                  (((x) >> 19) & 0x1)
#define   C_000E4C_ISP_RQ_PENDING                                     0xFFF7FFFF
#define   S_000E4C_VCE1_RQ_PENDING(x)                                 (((unsigned)(x) & 0x1) << 20)
#define   G_000E4C_VCE1_RQ_PENDING(x)                                 (((x) >> 20) & 0x1)
#define   C_000E4C_VCE1_RQ_PENDING                                    0xFFEFFFFF
#define R_000E50_SRBM_STATUS                                            0x000E50 /* <= gfx81 */
#define   S_000E50_UVD_RQ_PENDING(x)                                  (((unsigned)(x) & 0x1) << 1)
#define   G_000E50_UVD_RQ_PENDING(x)                                  (((x) >> 1) & 0x1)
#define   C_000E50_UVD_RQ_PENDING                                     0xFFFFFFFD
#define   S_000E50_SAMMSP_RQ_PENDING(x)                               (((unsigned)(x) & 0x1) << 2)
#define   G_000E50_SAMMSP_RQ_PENDING(x)                               (((x) >> 2) & 0x1)
#define   C_000E50_SAMMSP_RQ_PENDING                                  0xFFFFFFFB
#define   S_000E50_ACP_RQ_PENDING(x)                                  (((unsigned)(x) & 0x1) << 3)
#define   G_000E50_ACP_RQ_PENDING(x)                                  (((x) >> 3) & 0x1)
#define   C_000E50_ACP_RQ_PENDING                                     0xFFFFFFF7
#define   S_000E50_SMU_RQ_PENDING(x)                                  (((unsigned)(x) & 0x1) << 4)
#define   G_000E50_SMU_RQ_PENDING(x)                                  (((x) >> 4) & 0x1)
#define   C_000E50_SMU_RQ_PENDING                                     0xFFFFFFEF
#define   S_000E50_GRBM_RQ_PENDING(x)                                 (((unsigned)(x) & 0x1) << 5)
#define   G_000E50_GRBM_RQ_PENDING(x)                                 (((x) >> 5) & 0x1)
#define   C_000E50_GRBM_RQ_PENDING                                    0xFFFFFFDF
#define   S_000E50_HI_RQ_PENDING(x)                                   (((unsigned)(x) & 0x1) << 6)
#define   G_000E50_HI_RQ_PENDING(x)                                   (((x) >> 6) & 0x1)
#define   C_000E50_HI_RQ_PENDING                                      0xFFFFFFBF
#define   S_000E50_VMC_BUSY(x)                                        (((unsigned)(x) & 0x1) << 8)
#define   G_000E50_VMC_BUSY(x)                                        (((x) >> 8) & 0x1)
#define   C_000E50_VMC_BUSY                                           0xFFFFFEFF
#define   S_000E50_MCB_BUSY(x)                                        (((unsigned)(x) & 0x1) << 9)
#define   G_000E50_MCB_BUSY(x)                                        (((x) >> 9) & 0x1)
#define   C_000E50_MCB_BUSY                                           0xFFFFFDFF
#define   S_000E50_MCB_NON_DISPLAY_BUSY(x)                            (((unsigned)(x) & 0x1) << 10)
#define   G_000E50_MCB_NON_DISPLAY_BUSY(x)                            (((x) >> 10) & 0x1)
#define   C_000E50_MCB_NON_DISPLAY_BUSY                               0xFFFFFBFF
#define   S_000E50_MCC_BUSY(x)                                        (((unsigned)(x) & 0x1) << 11)
#define   G_000E50_MCC_BUSY(x)                                        (((x) >> 11) & 0x1)
#define   C_000E50_MCC_BUSY                                           0xFFFFF7FF
#define   S_000E50_MCD_BUSY(x)                                        (((unsigned)(x) & 0x1) << 12)
#define   G_000E50_MCD_BUSY(x)                                        (((x) >> 12) & 0x1)
#define   C_000E50_MCD_BUSY                                           0xFFFFEFFF
#define   S_000E50_VMC1_BUSY(x)                                       (((unsigned)(x) & 0x1) << 13)
#define   G_000E50_VMC1_BUSY(x)                                       (((x) >> 13) & 0x1)
#define   C_000E50_VMC1_BUSY                                          0xFFFFDFFF
#define   S_000E50_SEM_BUSY(x)                                        (((unsigned)(x) & 0x1) << 14)
#define   G_000E50_SEM_BUSY(x)                                        (((x) >> 14) & 0x1)
#define   C_000E50_SEM_BUSY                                           0xFFFFBFFF
#define   S_000E50_ACP_BUSY(x)                                        (((unsigned)(x) & 0x1) << 16)
#define   G_000E50_ACP_BUSY(x)                                        (((x) >> 16) & 0x1)
#define   C_000E50_ACP_BUSY                                           0xFFFEFFFF
#define   S_000E50_IH_BUSY(x)                                         (((unsigned)(x) & 0x1) << 17)
#define   G_000E50_IH_BUSY(x)                                         (((x) >> 17) & 0x1)
#define   C_000E50_IH_BUSY                                            0xFFFDFFFF
#define   S_000E50_UVD_BUSY(x)                                        (((unsigned)(x) & 0x1) << 19)
#define   G_000E50_UVD_BUSY(x)                                        (((x) >> 19) & 0x1)
#define   C_000E50_UVD_BUSY                                           0xFFF7FFFF
#define   S_000E50_SAMMSP_BUSY(x)                                     (((unsigned)(x) & 0x1) << 20)
#define   G_000E50_SAMMSP_BUSY(x)                                     (((x) >> 20) & 0x1)
#define   C_000E50_SAMMSP_BUSY                                        0xFFEFFFFF
#define   S_000E50_GCATCL2_BUSY(x)                                    (((unsigned)(x) & 0x1) << 21)
#define   G_000E50_GCATCL2_BUSY(x)                                    (((x) >> 21) & 0x1)
#define   C_000E50_GCATCL2_BUSY                                       0xFFDFFFFF
#define   S_000E50_OSATCL2_BUSY(x)                                    (((unsigned)(x) & 0x1) << 22)
#define   G_000E50_OSATCL2_BUSY(x)                                    (((x) >> 22) & 0x1)
#define   C_000E50_OSATCL2_BUSY                                       0xFFBFFFFF
#define   S_000E50_BIF_BUSY(x)                                        (((unsigned)(x) & 0x1) << 29)
#define   G_000E50_BIF_BUSY(x)                                        (((x) >> 29) & 0x1)
#define   C_000E50_BIF_BUSY                                           0xDFFFFFFF
#define R_000E54_SRBM_STATUS3                                           0x000E54 /* <= gfx81 */
#define   S_000E54_MCC0_BUSY(x)                                       (((unsigned)(x) & 0x1) << 0)
#define   G_000E54_MCC0_BUSY(x)                                       (((x) >> 0) & 0x1)
#define   C_000E54_MCC0_BUSY                                          0xFFFFFFFE
#define   S_000E54_MCC1_BUSY(x)                                       (((unsigned)(x) & 0x1) << 1)
#define   G_000E54_MCC1_BUSY(x)                                       (((x) >> 1) & 0x1)
#define   C_000E54_MCC1_BUSY                                          0xFFFFFFFD
#define   S_000E54_MCC2_BUSY(x)                                       (((unsigned)(x) & 0x1) << 2)
#define   G_000E54_MCC2_BUSY(x)                                       (((x) >> 2) & 0x1)
#define   C_000E54_MCC2_BUSY                                          0xFFFFFFFB
#define   S_000E54_MCC3_BUSY(x)                                       (((unsigned)(x) & 0x1) << 3)
#define   G_000E54_MCC3_BUSY(x)                                       (((x) >> 3) & 0x1)
#define   C_000E54_MCC3_BUSY                                          0xFFFFFFF7
#define   S_000E54_MCC4_BUSY(x)                                       (((unsigned)(x) & 0x1) << 4)
#define   G_000E54_MCC4_BUSY(x)                                       (((x) >> 4) & 0x1)
#define   C_000E54_MCC4_BUSY                                          0xFFFFFFEF
#define   S_000E54_MCC5_BUSY(x)                                       (((unsigned)(x) & 0x1) << 5)
#define   G_000E54_MCC5_BUSY(x)                                       (((x) >> 5) & 0x1)
#define   C_000E54_MCC5_BUSY                                          0xFFFFFFDF
#define   S_000E54_MCC6_BUSY(x)                                       (((unsigned)(x) & 0x1) << 6)
#define   G_000E54_MCC6_BUSY(x)                                       (((x) >> 6) & 0x1)
#define   C_000E54_MCC6_BUSY                                          0xFFFFFFBF
#define   S_000E54_MCC7_BUSY(x)                                       (((unsigned)(x) & 0x1) << 7)
#define   G_000E54_MCC7_BUSY(x)                                       (((x) >> 7) & 0x1)
#define   C_000E54_MCC7_BUSY                                          0xFFFFFF7F
#define   S_000E54_MCD0_BUSY(x)                                       (((unsigned)(x) & 0x1) << 8)
#define   G_000E54_MCD0_BUSY(x)                                       (((x) >> 8) & 0x1)
#define   C_000E54_MCD0_BUSY                                          0xFFFFFEFF
#define   S_000E54_MCD1_BUSY(x)                                       (((unsigned)(x) & 0x1) << 9)
#define   G_000E54_MCD1_BUSY(x)                                       (((x) >> 9) & 0x1)
#define   C_000E54_MCD1_BUSY                                          0xFFFFFDFF
#define   S_000E54_MCD2_BUSY(x)                                       (((unsigned)(x) & 0x1) << 10)
#define   G_000E54_MCD2_BUSY(x)                                       (((x) >> 10) & 0x1)
#define   C_000E54_MCD2_BUSY                                          0xFFFFFBFF
#define   S_000E54_MCD3_BUSY(x)                                       (((unsigned)(x) & 0x1) << 11)
#define   G_000E54_MCD3_BUSY(x)                                       (((x) >> 11) & 0x1)
#define   C_000E54_MCD3_BUSY                                          0xFFFFF7FF
#define   S_000E54_MCD4_BUSY(x)                                       (((unsigned)(x) & 0x1) << 12)
#define   G_000E54_MCD4_BUSY(x)                                       (((x) >> 12) & 0x1)
#define   C_000E54_MCD4_BUSY                                          0xFFFFEFFF
#define   S_000E54_MCD5_BUSY(x)                                       (((unsigned)(x) & 0x1) << 13)
#define   G_000E54_MCD5_BUSY(x)                                       (((x) >> 13) & 0x1)
#define   C_000E54_MCD5_BUSY                                          0xFFFFDFFF
#define   S_000E54_MCD6_BUSY(x)                                       (((unsigned)(x) & 0x1) << 14)
#define   G_000E54_MCD6_BUSY(x)                                       (((x) >> 14) & 0x1)
#define   C_000E54_MCD6_BUSY                                          0xFFFFBFFF
#define   S_000E54_MCD7_BUSY(x)                                       (((unsigned)(x) & 0x1) << 15)
#define   G_000E54_MCD7_BUSY(x)                                       (((x) >> 15) & 0x1)
#define   C_000E54_MCD7_BUSY                                          0xFFFF7FFF
#define R_008000_GRBM_CNTL                                              0x008000 /* <= gfx6 */
#define   S_008000_READ_TIMEOUT(x)                                    (((unsigned)(x) & 0xFF) << 0)
#define   G_008000_READ_TIMEOUT(x)                                    (((x) >> 0) & 0xFF)
#define   C_008000_READ_TIMEOUT                                       0xFFFFFF00
#define R_008004_GRBM_SKEW_CNTL                                         0x008004 /* <= gfx6 */
#define   S_008004_SKEW_TOP_THRESHOLD(x)                              (((unsigned)(x) & 0x3F) << 0)
#define   G_008004_SKEW_TOP_THRESHOLD(x)                              (((x) >> 0) & 0x3F)
#define   C_008004_SKEW_TOP_THRESHOLD                                 0xFFFFFFC0
#define   S_008004_SKEW_COUNT(x)                                      (((unsigned)(x) & 0x3F) << 6)
#define   G_008004_SKEW_COUNT(x)                                      (((x) >> 6) & 0x3F)
#define   C_008004_SKEW_COUNT                                         0xFFFFF03F
#define R_008008_GRBM_STATUS2                                           0x008008
#define   S_008008_ME0PIPE1_CMDFIFO_AVAIL(x)                          (((unsigned)(x) & 0xF) << 0)
#define   G_008008_ME0PIPE1_CMDFIFO_AVAIL(x)                          (((x) >> 0) & 0xF)
#define   C_008008_ME0PIPE1_CMDFIFO_AVAIL                             0xFFFFFFF0
#define   S_008008_RLC_RQ_PENDING_GFX6(x)                             (((unsigned)(x) & 0x1) << 0) /* <= gfx6 */
#define   G_008008_RLC_RQ_PENDING_GFX6(x)                             (((x) >> 0) & 0x1)
#define   C_008008_RLC_RQ_PENDING_GFX6                                0xFFFFFFFE
#define   S_008008_ME0PIPE1_CF_RQ_PENDING(x)                          (((unsigned)(x) & 0x1) << 4)
#define   G_008008_ME0PIPE1_CF_RQ_PENDING(x)                          (((x) >> 4) & 0x1)
#define   C_008008_ME0PIPE1_CF_RQ_PENDING                             0xFFFFFFEF
#define   S_008008_ME0PIPE1_PF_RQ_PENDING(x)                          (((unsigned)(x) & 0x1) << 5)
#define   G_008008_ME0PIPE1_PF_RQ_PENDING(x)                          (((x) >> 5) & 0x1)
#define   C_008008_ME0PIPE1_PF_RQ_PENDING                             0xFFFFFFDF
#define   S_008008_ME1PIPE0_RQ_PENDING(x)                             (((unsigned)(x) & 0x1) << 6)
#define   G_008008_ME1PIPE0_RQ_PENDING(x)                             (((x) >> 6) & 0x1)
#define   C_008008_ME1PIPE0_RQ_PENDING                                0xFFFFFFBF
#define   S_008008_ME1PIPE1_RQ_PENDING(x)                             (((unsigned)(x) & 0x1) << 7)
#define   G_008008_ME1PIPE1_RQ_PENDING(x)                             (((x) >> 7) & 0x1)
#define   C_008008_ME1PIPE1_RQ_PENDING                                0xFFFFFF7F
#define   S_008008_ME1PIPE2_RQ_PENDING(x)                             (((unsigned)(x) & 0x1) << 8)
#define   G_008008_ME1PIPE2_RQ_PENDING(x)                             (((x) >> 8) & 0x1)
#define   C_008008_ME1PIPE2_RQ_PENDING                                0xFFFFFEFF
#define   S_008008_RLC_BUSY_GFX6(x)                                   (((unsigned)(x) & 0x1) << 8) /* <= gfx6 */
#define   G_008008_RLC_BUSY_GFX6(x)                                   (((x) >> 8) & 0x1)
#define   C_008008_RLC_BUSY_GFX6                                      0xFFFFFEFF
#define   S_008008_ME1PIPE3_RQ_PENDING(x)                             (((unsigned)(x) & 0x1) << 9)
#define   G_008008_ME1PIPE3_RQ_PENDING(x)                             (((x) >> 9) & 0x1)
#define   C_008008_ME1PIPE3_RQ_PENDING                                0xFFFFFDFF
#define   S_008008_TC_BUSY_GFX6(x)                                    (((unsigned)(x) & 0x1) << 9) /* <= gfx6 */
#define   G_008008_TC_BUSY_GFX6(x)                                    (((x) >> 9) & 0x1)
#define   C_008008_TC_BUSY_GFX6                                       0xFFFFFDFF
#define   S_008008_ME2PIPE0_RQ_PENDING(x)                             (((unsigned)(x) & 0x1) << 10)
#define   G_008008_ME2PIPE0_RQ_PENDING(x)                             (((x) >> 10) & 0x1)
#define   C_008008_ME2PIPE0_RQ_PENDING                                0xFFFFFBFF
#define   S_008008_ME2PIPE1_RQ_PENDING(x)                             (((unsigned)(x) & 0x1) << 11)
#define   G_008008_ME2PIPE1_RQ_PENDING(x)                             (((x) >> 11) & 0x1)
#define   C_008008_ME2PIPE1_RQ_PENDING                                0xFFFFF7FF
#define   S_008008_ME2PIPE2_RQ_PENDING(x)                             (((unsigned)(x) & 0x1) << 12)
#define   G_008008_ME2PIPE2_RQ_PENDING(x)                             (((x) >> 12) & 0x1)
#define   C_008008_ME2PIPE2_RQ_PENDING                                0xFFFFEFFF
#define   S_008008_ME2PIPE3_RQ_PENDING(x)                             (((unsigned)(x) & 0x1) << 13)
#define   G_008008_ME2PIPE3_RQ_PENDING(x)                             (((x) >> 13) & 0x1)
#define   C_008008_ME2PIPE3_RQ_PENDING                                0xFFFFDFFF
#define   S_008008_RLC_RQ_PENDING_GFX7(x)                             (((unsigned)(x) & 0x1) << 14) /* >= gfx7 */
#define   G_008008_RLC_RQ_PENDING_GFX7(x)                             (((x) >> 14) & 0x1)
#define   C_008008_RLC_RQ_PENDING_GFX7                                0xFFFFBFFF
#define   S_008008_UTCL2_BUSY(x)                                      (((unsigned)(x) & 0x1) << 15) /* >= gfx9 */
#define   G_008008_UTCL2_BUSY(x)                                      (((x) >> 15) & 0x1)
#define   C_008008_UTCL2_BUSY                                         0xFFFF7FFF
#define   S_008008_EA_BUSY(x)                                         (((unsigned)(x) & 0x1) << 16) /* >= gfx9 */
#define   G_008008_EA_BUSY(x)                                         (((x) >> 16) & 0x1)
#define   C_008008_EA_BUSY                                            0xFFFEFFFF
#define   S_008008_RMI_BUSY(x)                                        (((unsigned)(x) & 0x1) << 17) /* >= gfx9 */
#define   G_008008_RMI_BUSY(x)                                        (((x) >> 17) & 0x1)
#define   C_008008_RMI_BUSY                                           0xFFFDFFFF
#define   S_008008_UTCL2_RQ_PENDING(x)                                (((unsigned)(x) & 0x1) << 18) /* >= gfx9 */
#define   G_008008_UTCL2_RQ_PENDING(x)                                (((x) >> 18) & 0x1)
#define   C_008008_UTCL2_RQ_PENDING                                   0xFFFBFFFF
#define   S_008008_CPF_RQ_PENDING(x)                                  (((unsigned)(x) & 0x1) << 19) /* gfx9, gfx10 */
#define   G_008008_CPF_RQ_PENDING(x)                                  (((x) >> 19) & 0x1)
#define   C_008008_CPF_RQ_PENDING                                     0xFFF7FFFF
#define   S_008008_SDMA_SCH_RQ_PENDING(x)                             (((unsigned)(x) & 0x1) << 19) /* >= gfx103 */
#define   G_008008_SDMA_SCH_RQ_PENDING(x)                             (((x) >> 19) & 0x1)
#define   C_008008_SDMA_SCH_RQ_PENDING                                0xFFF7FFFF
#define   S_008008_EA_LINK_BUSY(x)                                    (((unsigned)(x) & 0x1) << 20) /* >= gfx9 */
#define   G_008008_EA_LINK_BUSY(x)                                    (((x) >> 20) & 0x1)
#define   C_008008_EA_LINK_BUSY                                       0xFFEFFFFF
#define   S_008008_SDMA_BUSY(x)                                       (((unsigned)(x) & 0x1) << 21) /* >= gfx10 */
#define   G_008008_SDMA_BUSY(x)                                       (((x) >> 21) & 0x1)
#define   C_008008_SDMA_BUSY                                          0xFFDFFFFF
#define   S_008008_SDMA0_RQ_PENDING(x)                                (((unsigned)(x) & 0x1) << 22) /* >= gfx10 */
#define   G_008008_SDMA0_RQ_PENDING(x)                                (((x) >> 22) & 0x1)
#define   C_008008_SDMA0_RQ_PENDING                                   0xFFBFFFFF
#define   S_008008_SDMA1_RQ_PENDING(x)                                (((unsigned)(x) & 0x1) << 23) /* >= gfx10 */
#define   G_008008_SDMA1_RQ_PENDING(x)                                (((x) >> 23) & 0x1)
#define   C_008008_SDMA1_RQ_PENDING                                   0xFF7FFFFF
#define   S_008008_RLC_BUSY_GFX7(x)                                   (((unsigned)(x) & 0x1) << 24) /* gfx7, gfx8, gfx81, gfx9, gfx10 */
#define   G_008008_RLC_BUSY_GFX7(x)                                   (((x) >> 24) & 0x1)
#define   C_008008_RLC_BUSY_GFX7                                      0xFEFFFFFF
#define   S_008008_SDMA2_RQ_PENDING(x)                                (((unsigned)(x) & 0x1) << 24) /* >= gfx103 */
#define   G_008008_SDMA2_RQ_PENDING(x)                                (((x) >> 24) & 0x1)
#define   C_008008_SDMA2_RQ_PENDING                                   0xFEFFFFFF
#define   S_008008_SDMA3_RQ_PENDING(x)                                (((unsigned)(x) & 0x1) << 25) /* >= gfx103 */
#define   G_008008_SDMA3_RQ_PENDING(x)                                (((x) >> 25) & 0x1)
#define   C_008008_SDMA3_RQ_PENDING                                   0xFDFFFFFF
#define   S_008008_TCP_BUSY_GFX10(x)                                  (((unsigned)(x) & 0x1) << 25) /* gfx10 */
#define   G_008008_TCP_BUSY_GFX10(x)                                  (((x) >> 25) & 0x1)
#define   C_008008_TCP_BUSY_GFX10                                     0xFDFFFFFF
#define   S_008008_TC_BUSY_GFX7(x)                                    (((unsigned)(x) & 0x1) << 25) /* gfx7, gfx8, gfx81, gfx9 */
#define   G_008008_TC_BUSY_GFX7(x)                                    (((x) >> 25) & 0x1)
#define   C_008008_TC_BUSY_GFX7                                       0xFDFFFFFF
#define   S_008008_RLC_BUSY_GFX103(x)                                 (((unsigned)(x) & 0x1) << 26) /* >= gfx103 */
#define   G_008008_RLC_BUSY_GFX103(x)                                 (((x) >> 26) & 0x1)
#define   C_008008_RLC_BUSY_GFX103                                    0xFBFFFFFF
#define   S_008008_TCC_CC_RESIDENT(x)                                 (((unsigned)(x) & 0x1) << 26) /* gfx8, gfx81, gfx9 */
#define   G_008008_TCC_CC_RESIDENT(x)                                 (((x) >> 26) & 0x1)
#define   C_008008_TCC_CC_RESIDENT                                    0xFBFFFFFF
#define   S_008008_TCP_BUSY_GFX103(x)                                 (((unsigned)(x) & 0x1) << 27) /* >= gfx103 */
#define   G_008008_TCP_BUSY_GFX103(x)                                 (((x) >> 27) & 0x1)
#define   C_008008_TCP_BUSY_GFX103                                    0xF7FFFFFF
#define   S_008008_CPF_BUSY(x)                                        (((unsigned)(x) & 0x1) << 28)
#define   G_008008_CPF_BUSY(x)                                        (((x) >> 28) & 0x1)
#define   C_008008_CPF_BUSY                                           0xEFFFFFFF
#define   S_008008_CPC_BUSY(x)                                        (((unsigned)(x) & 0x1) << 29)
#define   G_008008_CPC_BUSY(x)                                        (((x) >> 29) & 0x1)
#define   C_008008_CPC_BUSY                                           0xDFFFFFFF
#define   S_008008_CPG_BUSY(x)                                        (((unsigned)(x) & 0x1) << 30)
#define   G_008008_CPG_BUSY(x)                                        (((x) >> 30) & 0x1)
#define   C_008008_CPG_BUSY                                           0xBFFFFFFF
#define   S_008008_CPAXI_BUSY(x)                                      (((unsigned)(x) & 0x1) << 31) /* >= gfx9 */
#define   G_008008_CPAXI_BUSY(x)                                      (((x) >> 31) & 0x1)
#define   C_008008_CPAXI_BUSY                                         0x7FFFFFFF
#define R_00800C_GRBM_PWR_CNTL                                          0x00800C /* <= gfx6 */
#define   S_00800C_REQ_TYPE(x)                                        (((unsigned)(x) & 0xF) << 0)
#define   G_00800C_REQ_TYPE(x)                                        (((x) >> 0) & 0xF)
#define   C_00800C_REQ_TYPE                                           0xFFFFFFF0
#define   S_00800C_RSP_TYPE(x)                                        (((unsigned)(x) & 0xF) << 4)
#define   G_00800C_RSP_TYPE(x)                                        (((x) >> 4) & 0xF)
#define   C_00800C_RSP_TYPE                                           0xFFFFFF0F
#define R_008010_GRBM_STATUS                                            0x008010
#define   S_008010_ME0PIPE0_CMDFIFO_AVAIL(x)                          (((unsigned)(x) & 0xF) << 0)
#define   G_008010_ME0PIPE0_CMDFIFO_AVAIL(x)                          (((x) >> 0) & 0xF)
#define   C_008010_ME0PIPE0_CMDFIFO_AVAIL                             0xFFFFFFF0
#define   S_008010_RSMU_RQ_PENDING(x)                                 (((unsigned)(x) & 0x1) << 5) /* gfx9, gfx10 */
#define   G_008010_RSMU_RQ_PENDING(x)                                 (((x) >> 5) & 0x1)
#define   C_008010_RSMU_RQ_PENDING                                    0xFFFFFFDF
#define   S_008010_SRBM_RQ_PENDING(x)                                 (((unsigned)(x) & 0x1) << 5) /* <= gfx81 */
#define   G_008010_SRBM_RQ_PENDING(x)                                 (((x) >> 5) & 0x1)
#define   C_008010_SRBM_RQ_PENDING                                    0xFFFFFFDF
#define   S_008010_ME0PIPE0_CF_RQ_PENDING(x)                          (((unsigned)(x) & 0x1) << 7)
#define   G_008010_ME0PIPE0_CF_RQ_PENDING(x)                          (((x) >> 7) & 0x1)
#define   C_008010_ME0PIPE0_CF_RQ_PENDING                             0xFFFFFF7F
#define   S_008010_ME0PIPE0_PF_RQ_PENDING(x)                          (((unsigned)(x) & 0x1) << 8)
#define   G_008010_ME0PIPE0_PF_RQ_PENDING(x)                          (((x) >> 8) & 0x1)
#define   C_008010_ME0PIPE0_PF_RQ_PENDING                             0xFFFFFEFF
#define   S_008010_GDS_DMA_RQ_PENDING(x)                              (((unsigned)(x) & 0x1) << 9)
#define   G_008010_GDS_DMA_RQ_PENDING(x)                              (((x) >> 9) & 0x1)
#define   C_008010_GDS_DMA_RQ_PENDING                                 0xFFFFFDFF
#define   S_008010_DB_CLEAN(x)                                        (((unsigned)(x) & 0x1) << 12)
#define   G_008010_DB_CLEAN(x)                                        (((x) >> 12) & 0x1)
#define   C_008010_DB_CLEAN                                           0xFFFFEFFF
#define   S_008010_CB_CLEAN(x)                                        (((unsigned)(x) & 0x1) << 13)
#define   G_008010_CB_CLEAN(x)                                        (((x) >> 13) & 0x1)
#define   C_008010_CB_CLEAN                                           0xFFFFDFFF
#define   S_008010_TA_BUSY(x)                                         (((unsigned)(x) & 0x1) << 14)
#define   G_008010_TA_BUSY(x)                                         (((x) >> 14) & 0x1)
#define   C_008010_TA_BUSY                                            0xFFFFBFFF
#define   S_008010_GDS_BUSY(x)                                        (((unsigned)(x) & 0x1) << 15)
#define   G_008010_GDS_BUSY(x)                                        (((x) >> 15) & 0x1)
#define   C_008010_GDS_BUSY                                           0xFFFF7FFF
#define   S_008010_GE_BUSY_NO_DMA(x)                                  (((unsigned)(x) & 0x1) << 16) /* >= gfx10 */
#define   G_008010_GE_BUSY_NO_DMA(x)                                  (((x) >> 16) & 0x1)
#define   C_008010_GE_BUSY_NO_DMA                                     0xFFFEFFFF
#define   S_008010_WD_BUSY_NO_DMA(x)                                  (((unsigned)(x) & 0x1) << 16) /* <= gfx9 */
#define   G_008010_WD_BUSY_NO_DMA(x)                                  (((x) >> 16) & 0x1)
#define   C_008010_WD_BUSY_NO_DMA                                     0xFFFEFFFF
#define   S_008010_VGT_BUSY(x)                                        (((unsigned)(x) & 0x1) << 17) /* <= gfx9 */
#define   G_008010_VGT_BUSY(x)                                        (((x) >> 17) & 0x1)
#define   C_008010_VGT_BUSY                                           0xFFFDFFFF
#define   S_008010_IA_BUSY_NO_DMA(x)                                  (((unsigned)(x) & 0x1) << 18) /* <= gfx9 */
#define   G_008010_IA_BUSY_NO_DMA(x)                                  (((x) >> 18) & 0x1)
#define   C_008010_IA_BUSY_NO_DMA                                     0xFFFBFFFF
#define   S_008010_IA_BUSY(x)                                         (((unsigned)(x) & 0x1) << 19) /* <= gfx9 */
#define   G_008010_IA_BUSY(x)                                         (((x) >> 19) & 0x1)
#define   C_008010_IA_BUSY                                            0xFFF7FFFF
#define   S_008010_SX_BUSY(x)                                         (((unsigned)(x) & 0x1) << 20)
#define   G_008010_SX_BUSY(x)                                         (((x) >> 20) & 0x1)
#define   C_008010_SX_BUSY                                            0xFFEFFFFF
#define   S_008010_GE_BUSY(x)                                         (((unsigned)(x) & 0x1) << 21) /* >= gfx10 */
#define   G_008010_GE_BUSY(x)                                         (((x) >> 21) & 0x1)
#define   C_008010_GE_BUSY                                            0xFFDFFFFF
#define   S_008010_WD_BUSY(x)                                         (((unsigned)(x) & 0x1) << 21) /* <= gfx9 */
#define   G_008010_WD_BUSY(x)                                         (((x) >> 21) & 0x1)
#define   C_008010_WD_BUSY                                            0xFFDFFFFF
#define   S_008010_SPI_BUSY(x)                                        (((unsigned)(x) & 0x1) << 22)
#define   G_008010_SPI_BUSY(x)                                        (((x) >> 22) & 0x1)
#define   C_008010_SPI_BUSY                                           0xFFBFFFFF
#define   S_008010_BCI_BUSY(x)                                        (((unsigned)(x) & 0x1) << 23)
#define   G_008010_BCI_BUSY(x)                                        (((x) >> 23) & 0x1)
#define   C_008010_BCI_BUSY                                           0xFF7FFFFF
#define   S_008010_SC_BUSY(x)                                         (((unsigned)(x) & 0x1) << 24)
#define   G_008010_SC_BUSY(x)                                         (((x) >> 24) & 0x1)
#define   C_008010_SC_BUSY                                            0xFEFFFFFF
#define   S_008010_PA_BUSY(x)                                         (((unsigned)(x) & 0x1) << 25)
#define   G_008010_PA_BUSY(x)                                         (((x) >> 25) & 0x1)
#define   C_008010_PA_BUSY                                            0xFDFFFFFF
#define   S_008010_DB_BUSY(x)                                         (((unsigned)(x) & 0x1) << 26)
#define   G_008010_DB_BUSY(x)                                         (((x) >> 26) & 0x1)
#define   C_008010_DB_BUSY                                            0xFBFFFFFF
#define   S_008010_CP_COHERENCY_BUSY(x)                               (((unsigned)(x) & 0x1) << 28)
#define   G_008010_CP_COHERENCY_BUSY(x)                               (((x) >> 28) & 0x1)
#define   C_008010_CP_COHERENCY_BUSY                                  0xEFFFFFFF
#define   S_008010_CP_BUSY(x)                                         (((unsigned)(x) & 0x1) << 29)
#define   G_008010_CP_BUSY(x)                                         (((x) >> 29) & 0x1)
#define   C_008010_CP_BUSY                                            0xDFFFFFFF
#define   S_008010_CB_BUSY(x)                                         (((unsigned)(x) & 0x1) << 30)
#define   G_008010_CB_BUSY(x)                                         (((x) >> 30) & 0x1)
#define   C_008010_CB_BUSY                                            0xBFFFFFFF
#define   S_008010_GUI_ACTIVE(x)                                      (((unsigned)(x) & 0x1) << 31)
#define   G_008010_GUI_ACTIVE(x)                                      (((x) >> 31) & 0x1)
#define   C_008010_GUI_ACTIVE                                         0x7FFFFFFF
#define R_008014_GRBM_STATUS_SE0                                        0x008014
#define   S_008014_DB_CLEAN(x)                                        (((unsigned)(x) & 0x1) << 1)
#define   G_008014_DB_CLEAN(x)                                        (((x) >> 1) & 0x1)
#define   C_008014_DB_CLEAN                                           0xFFFFFFFD
#define   S_008014_CB_CLEAN(x)                                        (((unsigned)(x) & 0x1) << 2)
#define   G_008014_CB_CLEAN(x)                                        (((x) >> 2) & 0x1)
#define   C_008014_CB_CLEAN                                           0xFFFFFFFB
#define   S_008014_UTCL1_BUSY(x)                                      (((unsigned)(x) & 0x1) << 3) /* >= gfx10 */
#define   G_008014_UTCL1_BUSY(x)                                      (((x) >> 3) & 0x1)
#define   C_008014_UTCL1_BUSY                                         0xFFFFFFF7
#define   S_008014_TCP_BUSY(x)                                        (((unsigned)(x) & 0x1) << 4) /* >= gfx10 */
#define   G_008014_TCP_BUSY(x)                                        (((x) >> 4) & 0x1)
#define   C_008014_TCP_BUSY                                           0xFFFFFFEF
#define   S_008014_GL1CC_BUSY(x)                                      (((unsigned)(x) & 0x1) << 5) /* >= gfx10 */
#define   G_008014_GL1CC_BUSY(x)                                      (((x) >> 5) & 0x1)
#define   C_008014_GL1CC_BUSY                                         0xFFFFFFDF
#define   S_008014_RMI_BUSY(x)                                        (((unsigned)(x) & 0x1) << 21) /* >= gfx9 */
#define   G_008014_RMI_BUSY(x)                                        (((x) >> 21) & 0x1)
#define   C_008014_RMI_BUSY                                           0xFFDFFFFF
#define   S_008014_BCI_BUSY(x)                                        (((unsigned)(x) & 0x1) << 22)
#define   G_008014_BCI_BUSY(x)                                        (((x) >> 22) & 0x1)
#define   C_008014_BCI_BUSY                                           0xFFBFFFFF
#define   S_008014_VGT_BUSY(x)                                        (((unsigned)(x) & 0x1) << 23) /* <= gfx9 */
#define   G_008014_VGT_BUSY(x)                                        (((x) >> 23) & 0x1)
#define   C_008014_VGT_BUSY                                           0xFF7FFFFF
#define   S_008014_PA_BUSY(x)                                         (((unsigned)(x) & 0x1) << 24)
#define   G_008014_PA_BUSY(x)                                         (((x) >> 24) & 0x1)
#define   C_008014_PA_BUSY                                            0xFEFFFFFF
#define   S_008014_TA_BUSY(x)                                         (((unsigned)(x) & 0x1) << 25)
#define   G_008014_TA_BUSY(x)                                         (((x) >> 25) & 0x1)
#define   C_008014_TA_BUSY                                            0xFDFFFFFF
#define   S_008014_SX_BUSY(x)                                         (((unsigned)(x) & 0x1) << 26)
#define   G_008014_SX_BUSY(x)                                         (((x) >> 26) & 0x1)
#define   C_008014_SX_BUSY                                            0xFBFFFFFF
#define   S_008014_SPI_BUSY(x)                                        (((unsigned)(x) & 0x1) << 27)
#define   G_008014_SPI_BUSY(x)                                        (((x) >> 27) & 0x1)
#define   C_008014_SPI_BUSY                                           0xF7FFFFFF
#define   S_008014_SC_BUSY(x)                                         (((unsigned)(x) & 0x1) << 29)
#define   G_008014_SC_BUSY(x)                                         (((x) >> 29) & 0x1)
#define   C_008014_SC_BUSY                                            0xDFFFFFFF
#define   S_008014_DB_BUSY(x)                                         (((unsigned)(x) & 0x1) << 30)
#define   G_008014_DB_BUSY(x)                                         (((x) >> 30) & 0x1)
#define   C_008014_DB_BUSY                                            0xBFFFFFFF
#define   S_008014_CB_BUSY(x)                                         (((unsigned)(x) & 0x1) << 31)
#define   G_008014_CB_BUSY(x)                                         (((x) >> 31) & 0x1)
#define   C_008014_CB_BUSY                                            0x7FFFFFFF
#define R_008018_GRBM_STATUS_SE1                                        0x008018
#define R_00801C_GRBM_STATUS3                                           0x00801C /* >= gfx10 */
#define   S_00801C_GRBM_RLC_INTR_CREDIT_PENDING(x)                    (((unsigned)(x) & 0x1) << 5)
#define   G_00801C_GRBM_RLC_INTR_CREDIT_PENDING(x)                    (((x) >> 5) & 0x1)
#define   C_00801C_GRBM_RLC_INTR_CREDIT_PENDING                       0xFFFFFFDF
#define   S_00801C_GRBM_UTCL2_INTR_CREDIT_PENDING(x)                  (((unsigned)(x) & 0x1) << 6)
#define   G_00801C_GRBM_UTCL2_INTR_CREDIT_PENDING(x)                  (((x) >> 6) & 0x1)
#define   C_00801C_GRBM_UTCL2_INTR_CREDIT_PENDING                     0xFFFFFFBF
#define   S_00801C_GRBM_CPF_INTR_CREDIT_PENDING(x)                    (((unsigned)(x) & 0x1) << 7)
#define   G_00801C_GRBM_CPF_INTR_CREDIT_PENDING(x)                    (((x) >> 7) & 0x1)
#define   C_00801C_GRBM_CPF_INTR_CREDIT_PENDING                       0xFFFFFF7F
#define   S_00801C_MESPIPE0_RQ_PENDING(x)                             (((unsigned)(x) & 0x1) << 8)
#define   G_00801C_MESPIPE0_RQ_PENDING(x)                             (((x) >> 8) & 0x1)
#define   C_00801C_MESPIPE0_RQ_PENDING                                0xFFFFFEFF
#define   S_00801C_MESPIPE1_RQ_PENDING(x)                             (((unsigned)(x) & 0x1) << 9)
#define   G_00801C_MESPIPE1_RQ_PENDING(x)                             (((x) >> 9) & 0x1)
#define   C_00801C_MESPIPE1_RQ_PENDING                                0xFFFFFDFF
#define   S_00801C_MESPIPE2_RQ_PENDING(x)                             (((unsigned)(x) & 0x1) << 10)
#define   G_00801C_MESPIPE2_RQ_PENDING(x)                             (((x) >> 10) & 0x1)
#define   C_00801C_MESPIPE2_RQ_PENDING                                0xFFFFFBFF
#define   S_00801C_MESPIPE3_RQ_PENDING(x)                             (((unsigned)(x) & 0x1) << 11)
#define   G_00801C_MESPIPE3_RQ_PENDING(x)                             (((x) >> 11) & 0x1)
#define   C_00801C_MESPIPE3_RQ_PENDING                                0xFFFFF7FF
#define   S_00801C_PH_BUSY(x)                                         (((unsigned)(x) & 0x1) << 13)
#define   G_00801C_PH_BUSY(x)                                         (((x) >> 13) & 0x1)
#define   C_00801C_PH_BUSY                                            0xFFFFDFFF
#define   S_00801C_CH_BUSY(x)                                         (((unsigned)(x) & 0x1) << 14)
#define   G_00801C_CH_BUSY(x)                                         (((x) >> 14) & 0x1)
#define   C_00801C_CH_BUSY                                            0xFFFFBFFF
#define   S_00801C_GL2CC_BUSY(x)                                      (((unsigned)(x) & 0x1) << 15)
#define   G_00801C_GL2CC_BUSY(x)                                      (((x) >> 15) & 0x1)
#define   C_00801C_GL2CC_BUSY                                         0xFFFF7FFF
#define   S_00801C_GL1CC_BUSY(x)                                      (((unsigned)(x) & 0x1) << 16)
#define   G_00801C_GL1CC_BUSY(x)                                      (((x) >> 16) & 0x1)
#define   C_00801C_GL1CC_BUSY                                         0xFFFEFFFF
#define   S_00801C_GUS_LINK_BUSY(x)                                   (((unsigned)(x) & 0x1) << 28)
#define   G_00801C_GUS_LINK_BUSY(x)                                   (((x) >> 28) & 0x1)
#define   C_00801C_GUS_LINK_BUSY                                      0xEFFFFFFF
#define   S_00801C_GUS_BUSY(x)                                        (((unsigned)(x) & 0x1) << 29)
#define   G_00801C_GUS_BUSY(x)                                        (((x) >> 29) & 0x1)
#define   C_00801C_GUS_BUSY                                           0xDFFFFFFF
#define   S_00801C_UTCL1_BUSY(x)                                      (((unsigned)(x) & 0x1) << 30)
#define   G_00801C_UTCL1_BUSY(x)                                      (((x) >> 30) & 0x1)
#define   C_00801C_UTCL1_BUSY                                         0xBFFFFFFF
#define   S_00801C_PMM_BUSY(x)                                        (((unsigned)(x) & 0x1) << 31)
#define   G_00801C_PMM_BUSY(x)                                        (((x) >> 31) & 0x1)
#define   C_00801C_PMM_BUSY                                           0x7FFFFFFF
#define R_008020_GRBM_SOFT_RESET                                        0x008020 /* <= gfx6 */
#define   S_008020_SOFT_RESET_CP(x)                                   (((unsigned)(x) & 0x1) << 0)
#define   G_008020_SOFT_RESET_CP(x)                                   (((x) >> 0) & 0x1)
#define   C_008020_SOFT_RESET_CP                                      0xFFFFFFFE
#define   S_008020_SOFT_RESET_RLC(x)                                  (((unsigned)(x) & 0x1) << 2)
#define   G_008020_SOFT_RESET_RLC(x)                                  (((x) >> 2) & 0x1)
#define   C_008020_SOFT_RESET_RLC                                     0xFFFFFFFB
#define   S_008020_SOFT_RESET_GFX(x)                                  (((unsigned)(x) & 0x1) << 16)
#define   G_008020_SOFT_RESET_GFX(x)                                  (((x) >> 16) & 0x1)
#define   C_008020_SOFT_RESET_GFX                                     0xFFFEFFFF
#define   S_008020_SOFT_RESET_CPF(x)                                  (((unsigned)(x) & 0x1) << 17)
#define   G_008020_SOFT_RESET_CPF(x)                                  (((x) >> 17) & 0x1)
#define   C_008020_SOFT_RESET_CPF                                     0xFFFDFFFF
#define   S_008020_SOFT_RESET_CPC(x)                                  (((unsigned)(x) & 0x1) << 18)
#define   G_008020_SOFT_RESET_CPC(x)                                  (((x) >> 18) & 0x1)
#define   C_008020_SOFT_RESET_CPC                                     0xFFFBFFFF
#define   S_008020_SOFT_RESET_CPG(x)                                  (((unsigned)(x) & 0x1) << 19)
#define   G_008020_SOFT_RESET_CPG(x)                                  (((x) >> 19) & 0x1)
#define   C_008020_SOFT_RESET_CPG                                     0xFFF7FFFF
#define R_008024_GRBM_DEBUG_CNTL                                        0x008024 /* <= gfx6 */
#define   S_008024_GRBM_DEBUG_INDEX(x)                                (((unsigned)(x) & 0x3F) << 0)
#define   G_008024_GRBM_DEBUG_INDEX(x)                                (((x) >> 0) & 0x3F)
#define   C_008024_GRBM_DEBUG_INDEX                                   0xFFFFFFC0
#define R_008028_GRBM_DEBUG_DATA                                        0x008028 /* <= gfx6 */
#define R_00802C_GRBM_GFX_INDEX                                         0x00802C /* <= gfx6 */
#define   S_00802C_INSTANCE_INDEX(x)                                  (((unsigned)(x) & 0xFF) << 0)
#define   G_00802C_INSTANCE_INDEX(x)                                  (((x) >> 0) & 0xFF)
#define   C_00802C_INSTANCE_INDEX                                     0xFFFFFF00
#define   S_00802C_SH_INDEX(x)                                        (((unsigned)(x) & 0xFF) << 8)
#define   G_00802C_SH_INDEX(x)                                        (((x) >> 8) & 0xFF)
#define   C_00802C_SH_INDEX                                           0xFFFF00FF
#define   S_00802C_SE_INDEX(x)                                        (((unsigned)(x) & 0xFF) << 16)
#define   G_00802C_SE_INDEX(x)                                        (((x) >> 16) & 0xFF)
#define   C_00802C_SE_INDEX                                           0xFF00FFFF
#define   S_00802C_SH_BROADCAST_WRITES(x)                             (((unsigned)(x) & 0x1) << 29)
#define   G_00802C_SH_BROADCAST_WRITES(x)                             (((x) >> 29) & 0x1)
#define   C_00802C_SH_BROADCAST_WRITES                                0xDFFFFFFF
#define   S_00802C_INSTANCE_BROADCAST_WRITES(x)                       (((unsigned)(x) & 0x1) << 30)
#define   G_00802C_INSTANCE_BROADCAST_WRITES(x)                       (((x) >> 30) & 0x1)
#define   C_00802C_INSTANCE_BROADCAST_WRITES                          0xBFFFFFFF
#define   S_00802C_SE_BROADCAST_WRITES(x)                             (((unsigned)(x) & 0x1) << 31)
#define   G_00802C_SE_BROADCAST_WRITES(x)                             (((x) >> 31) & 0x1)
#define   C_00802C_SE_BROADCAST_WRITES                                0x7FFFFFFF
#define R_008030_GRBM_GFX_CLKEN_CNTL                                    0x008030 /* <= gfx6 */
#define   S_008030_PREFIX_DELAY_CNT(x)                                (((unsigned)(x) & 0xF) << 0)
#define   G_008030_PREFIX_DELAY_CNT(x)                                (((x) >> 0) & 0xF)
#define   C_008030_PREFIX_DELAY_CNT                                   0xFFFFFFF0
#define   S_008030_POST_DELAY_CNT(x)                                  (((unsigned)(x) & 0x1F) << 8)
#define   G_008030_POST_DELAY_CNT(x)                                  (((x) >> 8) & 0x1F)
#define   C_008030_POST_DELAY_CNT                                     0xFFFFE0FF
#define R_008034_GRBM_WAIT_IDLE_CLOCKS                                  0x008034 /* <= gfx6 */
#define   S_008034_WAIT_IDLE_CLOCKS(x)                                (((unsigned)(x) & 0xFF) << 0)
#define   G_008034_WAIT_IDLE_CLOCKS(x)                                (((x) >> 0) & 0xFF)
#define   C_008034_WAIT_IDLE_CLOCKS                                   0xFFFFFF00
#define R_008038_GRBM_STATUS_SE2                                        0x008038 /* >= gfx7 */
#define R_00803C_GRBM_STATUS_SE3                                        0x00803C /* >= gfx7 */
#define R_008050_GRBM_DEBUG                                             0x008050 /* <= gfx6 */
#define   S_008050_IGNORE_RDY(x)                                      (((unsigned)(x) & 0x1) << 1)
#define   G_008050_IGNORE_RDY(x)                                      (((x) >> 1) & 0x1)
#define   C_008050_IGNORE_RDY                                         0xFFFFFFFD
#define   S_008050_IGNORE_FAO(x)                                      (((unsigned)(x) & 0x1) << 5)
#define   G_008050_IGNORE_FAO(x)                                      (((x) >> 5) & 0x1)
#define   C_008050_IGNORE_FAO                                         0xFFFFFFDF
#define   S_008050_DISABLE_READ_TIMEOUT(x)                            (((unsigned)(x) & 0x1) << 6)
#define   G_008050_DISABLE_READ_TIMEOUT(x)                            (((x) >> 6) & 0x1)
#define   C_008050_DISABLE_READ_TIMEOUT                               0xFFFFFFBF
#define   S_008050_SNAPSHOT_FREE_CNTRS(x)                             (((unsigned)(x) & 0x1) << 7)
#define   G_008050_SNAPSHOT_FREE_CNTRS(x)                             (((x) >> 7) & 0x1)
#define   C_008050_SNAPSHOT_FREE_CNTRS                                0xFFFFFF7F
#define   S_008050_HYSTERESIS_GUI_ACTIVE(x)                           (((unsigned)(x) & 0xF) << 8)
#define   G_008050_HYSTERESIS_GUI_ACTIVE(x)                           (((x) >> 8) & 0xF)
#define   C_008050_HYSTERESIS_GUI_ACTIVE                              0xFFFFF0FF
#define   S_008050_GFX_CLOCK_DOMAIN_OVERRIDE(x)                       (((unsigned)(x) & 0x1) << 12)
#define   G_008050_GFX_CLOCK_DOMAIN_OVERRIDE(x)                       (((x) >> 12) & 0x1)
#define   C_008050_GFX_CLOCK_DOMAIN_OVERRIDE                          0xFFFFEFFF
#define R_008054_GRBM_DEBUG_SNAPSHOT                                    0x008054 /* <= gfx6 */
#define   S_008054_CPF_RDY(x)                                         (((unsigned)(x) & 0x1) << 0)
#define   G_008054_CPF_RDY(x)                                         (((x) >> 0) & 0x1)
#define   C_008054_CPF_RDY                                            0xFFFFFFFE
#define   S_008054_CPG_RDY(x)                                         (((unsigned)(x) & 0x1) << 1)
#define   G_008054_CPG_RDY(x)                                         (((x) >> 1) & 0x1)
#define   C_008054_CPG_RDY                                            0xFFFFFFFD
#define   S_008054_SRBM_RDY(x)                                        (((unsigned)(x) & 0x1) << 1)
#define   G_008054_SRBM_RDY(x)                                        (((x) >> 1) & 0x1)
#define   C_008054_SRBM_RDY                                           0xFFFFFFFD
#define   S_008054_WD_ME0PIPE0_RDY(x)                                 (((unsigned)(x) & 0x1) << 3)
#define   G_008054_WD_ME0PIPE0_RDY(x)                                 (((x) >> 3) & 0x1)
#define   C_008054_WD_ME0PIPE0_RDY                                    0xFFFFFFF7
#define   S_008054_WD_ME0PIPE1_RDY(x)                                 (((unsigned)(x) & 0x1) << 4)
#define   G_008054_WD_ME0PIPE1_RDY(x)                                 (((x) >> 4) & 0x1)
#define   C_008054_WD_ME0PIPE1_RDY                                    0xFFFFFFEF
#define   S_008054_SE0SPI_ME0PIPE0_RDY0(x)                            (((unsigned)(x) & 0x1) << 6)
#define   G_008054_SE0SPI_ME0PIPE0_RDY0(x)                            (((x) >> 6) & 0x1)
#define   C_008054_SE0SPI_ME0PIPE0_RDY0                               0xFFFFFFBF
#define   S_008054_SE0SPI_ME0PIPE1_RDY0(x)                            (((unsigned)(x) & 0x1) << 7)
#define   G_008054_SE0SPI_ME0PIPE1_RDY0(x)                            (((x) >> 7) & 0x1)
#define   C_008054_SE0SPI_ME0PIPE1_RDY0                               0xFFFFFF7F
#define   S_008054_SE1SPI_ME0PIPE0_RDY0(x)                            (((unsigned)(x) & 0x1) << 8)
#define   G_008054_SE1SPI_ME0PIPE0_RDY0(x)                            (((x) >> 8) & 0x1)
#define   C_008054_SE1SPI_ME0PIPE0_RDY0                               0xFFFFFEFF
#define   S_008054_GDS_RDY(x)                                         (((unsigned)(x) & 0x1) << 9)
#define   G_008054_GDS_RDY(x)                                         (((x) >> 9) & 0x1)
#define   C_008054_GDS_RDY                                            0xFFFFFDFF
#define   S_008054_SE1SPI_ME0PIPE1_RDY0(x)                            (((unsigned)(x) & 0x1) << 9)
#define   G_008054_SE1SPI_ME0PIPE1_RDY0(x)                            (((x) >> 9) & 0x1)
#define   C_008054_SE1SPI_ME0PIPE1_RDY0                               0xFFFFFDFF
#define   S_008054_SE2SPI_ME0PIPE0_RDY0(x)                            (((unsigned)(x) & 0x1) << 10)
#define   G_008054_SE2SPI_ME0PIPE0_RDY0(x)                            (((x) >> 10) & 0x1)
#define   C_008054_SE2SPI_ME0PIPE0_RDY0                               0xFFFFFBFF
#define   S_008054_SE2SPI_ME0PIPE1_RDY0(x)                            (((unsigned)(x) & 0x1) << 11)
#define   G_008054_SE2SPI_ME0PIPE1_RDY0(x)                            (((x) >> 11) & 0x1)
#define   C_008054_SE2SPI_ME0PIPE1_RDY0                               0xFFFFF7FF
#define   S_008054_SE3SPI_ME0PIPE0_RDY0(x)                            (((unsigned)(x) & 0x1) << 12)
#define   G_008054_SE3SPI_ME0PIPE0_RDY0(x)                            (((x) >> 12) & 0x1)
#define   C_008054_SE3SPI_ME0PIPE0_RDY0                               0xFFFFEFFF
#define   S_008054_SE3SPI_ME0PIPE1_RDY0(x)                            (((unsigned)(x) & 0x1) << 13)
#define   G_008054_SE3SPI_ME0PIPE1_RDY0(x)                            (((x) >> 13) & 0x1)
#define   C_008054_SE3SPI_ME0PIPE1_RDY0                               0xFFFFDFFF
#define   S_008054_SE0SPI_ME0PIPE0_RDY1(x)                            (((unsigned)(x) & 0x1) << 14)
#define   G_008054_SE0SPI_ME0PIPE0_RDY1(x)                            (((x) >> 14) & 0x1)
#define   C_008054_SE0SPI_ME0PIPE0_RDY1                               0xFFFFBFFF
#define   S_008054_SE0SPI_ME0PIPE1_RDY1(x)                            (((unsigned)(x) & 0x1) << 15)
#define   G_008054_SE0SPI_ME0PIPE1_RDY1(x)                            (((x) >> 15) & 0x1)
#define   C_008054_SE0SPI_ME0PIPE1_RDY1                               0xFFFF7FFF
#define   S_008054_SE1SPI_ME0PIPE0_RDY1(x)                            (((unsigned)(x) & 0x1) << 16)
#define   G_008054_SE1SPI_ME0PIPE0_RDY1(x)                            (((x) >> 16) & 0x1)
#define   C_008054_SE1SPI_ME0PIPE0_RDY1                               0xFFFEFFFF
#define   S_008054_SE1SPI_ME0PIPE1_RDY1(x)                            (((unsigned)(x) & 0x1) << 17)
#define   G_008054_SE1SPI_ME0PIPE1_RDY1(x)                            (((x) >> 17) & 0x1)
#define   C_008054_SE1SPI_ME0PIPE1_RDY1                               0xFFFDFFFF
#define   S_008054_SE2SPI_ME0PIPE0_RDY1(x)                            (((unsigned)(x) & 0x1) << 18)
#define   G_008054_SE2SPI_ME0PIPE0_RDY1(x)                            (((x) >> 18) & 0x1)
#define   C_008054_SE2SPI_ME0PIPE0_RDY1                               0xFFFBFFFF
#define   S_008054_SE2SPI_ME0PIPE1_RDY1(x)                            (((unsigned)(x) & 0x1) << 19)
#define   G_008054_SE2SPI_ME0PIPE1_RDY1(x)                            (((x) >> 19) & 0x1)
#define   C_008054_SE2SPI_ME0PIPE1_RDY1                               0xFFF7FFFF
#define   S_008054_SE3SPI_ME0PIPE0_RDY1(x)                            (((unsigned)(x) & 0x1) << 20)
#define   G_008054_SE3SPI_ME0PIPE0_RDY1(x)                            (((x) >> 20) & 0x1)
#define   C_008054_SE3SPI_ME0PIPE0_RDY1                               0xFFEFFFFF
#define   S_008054_SE3SPI_ME0PIPE1_RDY1(x)                            (((unsigned)(x) & 0x1) << 21)
#define   G_008054_SE3SPI_ME0PIPE1_RDY1(x)                            (((x) >> 21) & 0x1)
#define   C_008054_SE3SPI_ME0PIPE1_RDY1                               0xFFDFFFFF
#define R_008058_GRBM_READ_ERROR                                        0x008058 /* <= gfx6 */
#define   S_008058_READ_ADDRESS(x)                                    (((unsigned)(x) & 0xFFFF) << 2)
#define   G_008058_READ_ADDRESS(x)                                    (((x) >> 2) & 0xFFFF)
#define   C_008058_READ_ADDRESS                                       0xFFFC0003
#define   S_008058_READ_PIPEID(x)                                     (((unsigned)(x) & 0x3) << 20)
#define   G_008058_READ_PIPEID(x)                                     (((x) >> 20) & 0x3)
#define   C_008058_READ_PIPEID                                        0xFFCFFFFF
#define   S_008058_READ_MEID(x)                                       (((unsigned)(x) & 0x3) << 22)
#define   G_008058_READ_MEID(x)                                       (((x) >> 22) & 0x3)
#define   C_008058_READ_MEID                                          0xFF3FFFFF
#define   S_008058_READ_ERROR(x)                                      (((unsigned)(x) & 0x1) << 31)
#define   G_008058_READ_ERROR(x)                                      (((x) >> 31) & 0x1)
#define   C_008058_READ_ERROR                                         0x7FFFFFFF
#define R_008060_GRBM_INT_CNTL                                          0x008060 /* <= gfx6 */
#define   S_008060_RDERR_INT_ENABLE(x)                                (((unsigned)(x) & 0x1) << 0)
#define   G_008060_RDERR_INT_ENABLE(x)                                (((x) >> 0) & 0x1)
#define   C_008060_RDERR_INT_ENABLE                                   0xFFFFFFFE
#define   S_008060_GUI_IDLE_INT_ENABLE(x)                             (((unsigned)(x) & 0x1) << 19)
#define   G_008060_GUI_IDLE_INT_ENABLE(x)                             (((x) >> 19) & 0x1)
#define   C_008060_GUI_IDLE_INT_ENABLE                                0xFFF7FFFF
#define R_008070_GRBM_PERFCOUNTER0_SELECT                               0x008070 /* <= gfx6 */
#define   S_008070_PERF_SEL(x)                                        (((unsigned)(x) & 0x3F) << 0)
#define   G_008070_PERF_SEL(x)                                        (((x) >> 0) & 0x3F)
#define   C_008070_PERF_SEL                                           0xFFFFFFC0
#define   S_008070_DB_CLEAN_USER_DEFINED_MASK(x)                      (((unsigned)(x) & 0x1) << 10)
#define   G_008070_DB_CLEAN_USER_DEFINED_MASK(x)                      (((x) >> 10) & 0x1)
#define   C_008070_DB_CLEAN_USER_DEFINED_MASK                         0xFFFFFBFF
#define   S_008070_CB_CLEAN_USER_DEFINED_MASK(x)                      (((unsigned)(x) & 0x1) << 11)
#define   G_008070_CB_CLEAN_USER_DEFINED_MASK(x)                      (((x) >> 11) & 0x1)
#define   C_008070_CB_CLEAN_USER_DEFINED_MASK                         0xFFFFF7FF
#define   S_008070_VGT_BUSY_USER_DEFINED_MASK(x)                      (((unsigned)(x) & 0x1) << 12)
#define   G_008070_VGT_BUSY_USER_DEFINED_MASK(x)                      (((x) >> 12) & 0x1)
#define   C_008070_VGT_BUSY_USER_DEFINED_MASK                         0xFFFFEFFF
#define   S_008070_TA_BUSY_USER_DEFINED_MASK(x)                       (((unsigned)(x) & 0x1) << 13)
#define   G_008070_TA_BUSY_USER_DEFINED_MASK(x)                       (((x) >> 13) & 0x1)
#define   C_008070_TA_BUSY_USER_DEFINED_MASK                          0xFFFFDFFF
#define   S_008070_SX_BUSY_USER_DEFINED_MASK(x)                       (((unsigned)(x) & 0x1) << 14)
#define   G_008070_SX_BUSY_USER_DEFINED_MASK(x)                       (((x) >> 14) & 0x1)
#define   C_008070_SX_BUSY_USER_DEFINED_MASK                          0xFFFFBFFF
#define   S_008070_SPI_BUSY_USER_DEFINED_MASK(x)                      (((unsigned)(x) & 0x1) << 16)
#define   G_008070_SPI_BUSY_USER_DEFINED_MASK(x)                      (((x) >> 16) & 0x1)
#define   C_008070_SPI_BUSY_USER_DEFINED_MASK                         0xFFFEFFFF
#define   S_008070_SC_BUSY_USER_DEFINED_MASK(x)                       (((unsigned)(x) & 0x1) << 17)
#define   G_008070_SC_BUSY_USER_DEFINED_MASK(x)                       (((x) >> 17) & 0x1)
#define   C_008070_SC_BUSY_USER_DEFINED_MASK                          0xFFFDFFFF
#define   S_008070_PA_BUSY_USER_DEFINED_MASK(x)                       (((unsigned)(x) & 0x1) << 18)
#define   G_008070_PA_BUSY_USER_DEFINED_MASK(x)                       (((x) >> 18) & 0x1)
#define   C_008070_PA_BUSY_USER_DEFINED_MASK                          0xFFFBFFFF
#define   S_008070_GRBM_BUSY_USER_DEFINED_MASK(x)                     (((unsigned)(x) & 0x1) << 19)
#define   G_008070_GRBM_BUSY_USER_DEFINED_MASK(x)                     (((x) >> 19) & 0x1)
#define   C_008070_GRBM_BUSY_USER_DEFINED_MASK                        0xFFF7FFFF
#define   S_008070_DB_BUSY_USER_DEFINED_MASK(x)                       (((unsigned)(x) & 0x1) << 20)
#define   G_008070_DB_BUSY_USER_DEFINED_MASK(x)                       (((x) >> 20) & 0x1)
#define   C_008070_DB_BUSY_USER_DEFINED_MASK                          0xFFEFFFFF
#define   S_008070_CB_BUSY_USER_DEFINED_MASK(x)                       (((unsigned)(x) & 0x1) << 21)
#define   G_008070_CB_BUSY_USER_DEFINED_MASK(x)                       (((x) >> 21) & 0x1)
#define   C_008070_CB_BUSY_USER_DEFINED_MASK                          0xFFDFFFFF
#define   S_008070_CP_BUSY_USER_DEFINED_MASK(x)                       (((unsigned)(x) & 0x1) << 22)
#define   G_008070_CP_BUSY_USER_DEFINED_MASK(x)                       (((x) >> 22) & 0x1)
#define   C_008070_CP_BUSY_USER_DEFINED_MASK                          0xFFBFFFFF
#define   S_008070_IA_BUSY_USER_DEFINED_MASK(x)                       (((unsigned)(x) & 0x1) << 23)
#define   G_008070_IA_BUSY_USER_DEFINED_MASK(x)                       (((x) >> 23) & 0x1)
#define   C_008070_IA_BUSY_USER_DEFINED_MASK                          0xFF7FFFFF
#define   S_008070_GDS_BUSY_USER_DEFINED_MASK(x)                      (((unsigned)(x) & 0x1) << 24)
#define   G_008070_GDS_BUSY_USER_DEFINED_MASK(x)                      (((x) >> 24) & 0x1)
#define   C_008070_GDS_BUSY_USER_DEFINED_MASK                         0xFEFFFFFF
#define   S_008070_BCI_BUSY_USER_DEFINED_MASK(x)                      (((unsigned)(x) & 0x1) << 25)
#define   G_008070_BCI_BUSY_USER_DEFINED_MASK(x)                      (((x) >> 25) & 0x1)
#define   C_008070_BCI_BUSY_USER_DEFINED_MASK                         0xFDFFFFFF
#define   S_008070_RLC_BUSY_USER_DEFINED_MASK(x)                      (((unsigned)(x) & 0x1) << 26)
#define   G_008070_RLC_BUSY_USER_DEFINED_MASK(x)                      (((x) >> 26) & 0x1)
#define   C_008070_RLC_BUSY_USER_DEFINED_MASK                         0xFBFFFFFF
#define   S_008070_TC_BUSY_USER_DEFINED_MASK(x)                       (((unsigned)(x) & 0x1) << 27)
#define   G_008070_TC_BUSY_USER_DEFINED_MASK(x)                       (((x) >> 27) & 0x1)
#define   C_008070_TC_BUSY_USER_DEFINED_MASK                          0xF7FFFFFF
#define   S_008070_WD_BUSY_USER_DEFINED_MASK(x)                       (((unsigned)(x) & 0x1) << 28)
#define   G_008070_WD_BUSY_USER_DEFINED_MASK(x)                       (((x) >> 28) & 0x1)
#define   C_008070_WD_BUSY_USER_DEFINED_MASK                          0xEFFFFFFF
#define R_008074_GRBM_PERFCOUNTER1_SELECT                               0x008074 /* <= gfx6 */
#define R_008078_GRBM_PERFCOUNTER0_LO                                   0x008078 /* <= gfx6 */
#define R_00807C_GRBM_PERFCOUNTER0_HI                                   0x00807C /* <= gfx6 */
#define R_008080_GRBM_PERFCOUNTER1_LO                                   0x008080 /* <= gfx6 */
#define R_008084_GRBM_PERFCOUNTER1_HI                                   0x008084 /* <= gfx6 */
#define R_008098_GRBM_SE0_PERFCOUNTER_SELECT                            0x008098 /* <= gfx6 */
#define   S_008098_PERF_SEL(x)                                        (((unsigned)(x) & 0x3F) << 0)
#define   G_008098_PERF_SEL(x)                                        (((x) >> 0) & 0x3F)
#define   C_008098_PERF_SEL                                           0xFFFFFFC0
#define   S_008098_DB_CLEAN_USER_DEFINED_MASK(x)                      (((unsigned)(x) & 0x1) << 10)
#define   G_008098_DB_CLEAN_USER_DEFINED_MASK(x)                      (((x) >> 10) & 0x1)
#define   C_008098_DB_CLEAN_USER_DEFINED_MASK                         0xFFFFFBFF
#define   S_008098_CB_CLEAN_USER_DEFINED_MASK(x)                      (((unsigned)(x) & 0x1) << 11)
#define   G_008098_CB_CLEAN_USER_DEFINED_MASK(x)                      (((x) >> 11) & 0x1)
#define   C_008098_CB_CLEAN_USER_DEFINED_MASK                         0xFFFFF7FF
#define   S_008098_TA_BUSY_USER_DEFINED_MASK(x)                       (((unsigned)(x) & 0x1) << 12)
#define   G_008098_TA_BUSY_USER_DEFINED_MASK(x)                       (((x) >> 12) & 0x1)
#define   C_008098_TA_BUSY_USER_DEFINED_MASK                          0xFFFFEFFF
#define   S_008098_SX_BUSY_USER_DEFINED_MASK(x)                       (((unsigned)(x) & 0x1) << 13)
#define   G_008098_SX_BUSY_USER_DEFINED_MASK(x)                       (((x) >> 13) & 0x1)
#define   C_008098_SX_BUSY_USER_DEFINED_MASK                          0xFFFFDFFF
#define   S_008098_SPI_BUSY_USER_DEFINED_MASK(x)                      (((unsigned)(x) & 0x1) << 15)
#define   G_008098_SPI_BUSY_USER_DEFINED_MASK(x)                      (((x) >> 15) & 0x1)
#define   C_008098_SPI_BUSY_USER_DEFINED_MASK                         0xFFFF7FFF
#define   S_008098_SC_BUSY_USER_DEFINED_MASK(x)                       (((unsigned)(x) & 0x1) << 16)
#define   G_008098_SC_BUSY_USER_DEFINED_MASK(x)                       (((x) >> 16) & 0x1)
#define   C_008098_SC_BUSY_USER_DEFINED_MASK                          0xFFFEFFFF
#define   S_008098_DB_BUSY_USER_DEFINED_MASK(x)                       (((unsigned)(x) & 0x1) << 17)
#define   G_008098_DB_BUSY_USER_DEFINED_MASK(x)                       (((x) >> 17) & 0x1)
#define   C_008098_DB_BUSY_USER_DEFINED_MASK                          0xFFFDFFFF
#define   S_008098_CB_BUSY_USER_DEFINED_MASK(x)                       (((unsigned)(x) & 0x1) << 18)
#define   G_008098_CB_BUSY_USER_DEFINED_MASK(x)                       (((x) >> 18) & 0x1)
#define   C_008098_CB_BUSY_USER_DEFINED_MASK                          0xFFFBFFFF
#define   S_008098_VGT_BUSY_USER_DEFINED_MASK(x)                      (((unsigned)(x) & 0x1) << 19)
#define   G_008098_VGT_BUSY_USER_DEFINED_MASK(x)                      (((x) >> 19) & 0x1)
#define   C_008098_VGT_BUSY_USER_DEFINED_MASK                         0xFFF7FFFF
#define   S_008098_PA_BUSY_USER_DEFINED_MASK(x)                       (((unsigned)(x) & 0x1) << 20)
#define   G_008098_PA_BUSY_USER_DEFINED_MASK(x)                       (((x) >> 20) & 0x1)
#define   C_008098_PA_BUSY_USER_DEFINED_MASK                          0xFFEFFFFF
#define   S_008098_BCI_BUSY_USER_DEFINED_MASK(x)                      (((unsigned)(x) & 0x1) << 21)
#define   G_008098_BCI_BUSY_USER_DEFINED_MASK(x)                      (((x) >> 21) & 0x1)
#define   C_008098_BCI_BUSY_USER_DEFINED_MASK                         0xFFDFFFFF
#define R_00809C_GRBM_SE1_PERFCOUNTER_SELECT                            0x00809C /* <= gfx6 */
#define R_0080A8_GRBM_SE0_PERFCOUNTER_LO                                0x0080A8 /* <= gfx6 */
#define R_0080AC_GRBM_SE0_PERFCOUNTER_HI                                0x0080AC /* <= gfx6 */
#define R_0080B0_GRBM_SE1_PERFCOUNTER_LO                                0x0080B0 /* <= gfx6 */
#define R_0080B4_GRBM_SE1_PERFCOUNTER_HI                                0x0080B4 /* <= gfx6 */
#define R_0080F0_DEBUG_INDEX                                            0x0080F0 /* <= gfx6 */
#define   S_0080F0_DEBUG_INDEX(x)                                     (((unsigned)(x) & 0x3FFFF) << 0)
#define   G_0080F0_DEBUG_INDEX(x)                                     (((x) >> 0) & 0x3FFFF)
#define   C_0080F0_DEBUG_INDEX                                        0xFFFC0000
#define R_0080F4_DEBUG_DATA                                             0x0080F4 /* <= gfx6 */
#define R_0080FC_GRBM_NOWHERE                                           0x0080FC /* <= gfx6 */
#define R_008100_GRBM_SCRATCH_REG0                                      0x008100 /* <= gfx6 */
#define R_008104_GRBM_SCRATCH_REG1                                      0x008104 /* <= gfx6 */
#define R_008108_GRBM_SCRATCH_REG2                                      0x008108 /* <= gfx6 */
#define R_00810C_GRBM_SCRATCH_REG3                                      0x00810C /* <= gfx6 */
#define R_008110_GRBM_SCRATCH_REG4                                      0x008110 /* <= gfx6 */
#define R_008114_GRBM_SCRATCH_REG5                                      0x008114 /* <= gfx6 */
#define R_008118_GRBM_SCRATCH_REG6                                      0x008118 /* <= gfx6 */
#define R_00811C_GRBM_SCRATCH_REG7                                      0x00811C /* <= gfx6 */
#define R_008210_CP_CPC_STATUS                                          0x008210 /* >= gfx7 */
#define   S_008210_MEC1_BUSY(x)                                       (((unsigned)(x) & 0x1) << 0)
#define   G_008210_MEC1_BUSY(x)                                       (((x) >> 0) & 0x1)
#define   C_008210_MEC1_BUSY                                          0xFFFFFFFE
#define   S_008210_MEC2_BUSY(x)                                       (((unsigned)(x) & 0x1) << 1)
#define   G_008210_MEC2_BUSY(x)                                       (((x) >> 1) & 0x1)
#define   C_008210_MEC2_BUSY                                          0xFFFFFFFD
#define   S_008210_DC0_BUSY(x)                                        (((unsigned)(x) & 0x1) << 2)
#define   G_008210_DC0_BUSY(x)                                        (((x) >> 2) & 0x1)
#define   C_008210_DC0_BUSY                                           0xFFFFFFFB
#define   S_008210_DC1_BUSY(x)                                        (((unsigned)(x) & 0x1) << 3)
#define   G_008210_DC1_BUSY(x)                                        (((x) >> 3) & 0x1)
#define   C_008210_DC1_BUSY                                           0xFFFFFFF7
#define   S_008210_RCIU1_BUSY(x)                                      (((unsigned)(x) & 0x1) << 4)
#define   G_008210_RCIU1_BUSY(x)                                      (((x) >> 4) & 0x1)
#define   C_008210_RCIU1_BUSY                                         0xFFFFFFEF
#define   S_008210_RCIU2_BUSY(x)                                      (((unsigned)(x) & 0x1) << 5)
#define   G_008210_RCIU2_BUSY(x)                                      (((x) >> 5) & 0x1)
#define   C_008210_RCIU2_BUSY                                         0xFFFFFFDF
#define   S_008210_ROQ1_BUSY(x)                                       (((unsigned)(x) & 0x1) << 6)
#define   G_008210_ROQ1_BUSY(x)                                       (((x) >> 6) & 0x1)
#define   C_008210_ROQ1_BUSY                                          0xFFFFFFBF
#define   S_008210_ROQ2_BUSY(x)                                       (((unsigned)(x) & 0x1) << 7)
#define   G_008210_ROQ2_BUSY(x)                                       (((x) >> 7) & 0x1)
#define   C_008210_ROQ2_BUSY                                          0xFFFFFF7F
#define   S_008210_MIU_RDREQ_BUSY(x)                                  (((unsigned)(x) & 0x1) << 8) /* gfx7 */
#define   G_008210_MIU_RDREQ_BUSY(x)                                  (((x) >> 8) & 0x1)
#define   C_008210_MIU_RDREQ_BUSY                                     0xFFFFFEFF
#define   S_008210_MIU_WRREQ_BUSY(x)                                  (((unsigned)(x) & 0x1) << 9) /* gfx7 */
#define   G_008210_MIU_WRREQ_BUSY(x)                                  (((x) >> 9) & 0x1)
#define   C_008210_MIU_WRREQ_BUSY                                     0xFFFFFDFF
#define   S_008210_TCIU_BUSY(x)                                       (((unsigned)(x) & 0x1) << 10)
#define   G_008210_TCIU_BUSY(x)                                       (((x) >> 10) & 0x1)
#define   C_008210_TCIU_BUSY                                          0xFFFFFBFF
#define   S_008210_SCRATCH_RAM_BUSY(x)                                (((unsigned)(x) & 0x1) << 11)
#define   G_008210_SCRATCH_RAM_BUSY(x)                                (((x) >> 11) & 0x1)
#define   C_008210_SCRATCH_RAM_BUSY                                   0xFFFFF7FF
#define   S_008210_QU_BUSY(x)                                         (((unsigned)(x) & 0x1) << 12)
#define   G_008210_QU_BUSY(x)                                         (((x) >> 12) & 0x1)
#define   C_008210_QU_BUSY                                            0xFFFFEFFF
#define   S_008210_ATCL2IU_BUSY(x)                                    (((unsigned)(x) & 0x1) << 13) /* gfx8, gfx81 */
#define   G_008210_ATCL2IU_BUSY(x)                                    (((x) >> 13) & 0x1)
#define   C_008210_ATCL2IU_BUSY                                       0xFFFFDFFF
#define   S_008210_UTCL2IU_BUSY(x)                                    (((unsigned)(x) & 0x1) << 13) /* >= gfx9 */
#define   G_008210_UTCL2IU_BUSY(x)                                    (((x) >> 13) & 0x1)
#define   C_008210_UTCL2IU_BUSY                                       0xFFFFDFFF
#define   S_008210_SAVE_RESTORE_BUSY(x)                               (((unsigned)(x) & 0x1) << 14) /* >= gfx9 */
#define   G_008210_SAVE_RESTORE_BUSY(x)                               (((x) >> 14) & 0x1)
#define   C_008210_SAVE_RESTORE_BUSY                                  0xFFFFBFFF
#define   S_008210_GCRIU_BUSY(x)                                      (((unsigned)(x) & 0x1) << 15) /* >= gfx10 */
#define   G_008210_GCRIU_BUSY(x)                                      (((x) >> 15) & 0x1)
#define   C_008210_GCRIU_BUSY                                         0xFFFF7FFF
#define   S_008210_MES_BUSY(x)                                        (((unsigned)(x) & 0x1) << 16) /* >= gfx10 */
#define   G_008210_MES_BUSY(x)                                        (((x) >> 16) & 0x1)
#define   C_008210_MES_BUSY                                           0xFFFEFFFF
#define   S_008210_MES_SCRATCH_RAM_BUSY(x)                            (((unsigned)(x) & 0x1) << 17) /* >= gfx10 */
#define   G_008210_MES_SCRATCH_RAM_BUSY(x)                            (((x) >> 17) & 0x1)
#define   C_008210_MES_SCRATCH_RAM_BUSY                               0xFFFDFFFF
#define   S_008210_RCIU3_BUSY(x)                                      (((unsigned)(x) & 0x1) << 18) /* >= gfx10 */
#define   G_008210_RCIU3_BUSY(x)                                      (((x) >> 18) & 0x1)
#define   C_008210_RCIU3_BUSY                                         0xFFFBFFFF
#define   S_008210_MES_INSTRUCTION_CACHE_BUSY(x)                      (((unsigned)(x) & 0x1) << 19) /* >= gfx10 */
#define   G_008210_MES_INSTRUCTION_CACHE_BUSY(x)                      (((x) >> 19) & 0x1)
#define   C_008210_MES_INSTRUCTION_CACHE_BUSY                         0xFFF7FFFF
#define   S_008210_CPG_CPC_BUSY(x)                                    (((unsigned)(x) & 0x1) << 29)
#define   G_008210_CPG_CPC_BUSY(x)                                    (((x) >> 29) & 0x1)
#define   C_008210_CPG_CPC_BUSY                                       0xDFFFFFFF
#define   S_008210_CPF_CPC_BUSY(x)                                    (((unsigned)(x) & 0x1) << 30)
#define   G_008210_CPF_CPC_BUSY(x)                                    (((x) >> 30) & 0x1)
#define   C_008210_CPF_CPC_BUSY                                       0xBFFFFFFF
#define   S_008210_CPC_BUSY(x)                                        (((unsigned)(x) & 0x1) << 31)
#define   G_008210_CPC_BUSY(x)                                        (((x) >> 31) & 0x1)
#define   C_008210_CPC_BUSY                                           0x7FFFFFFF
#define R_008214_CP_CPC_BUSY_STAT                                       0x008214 /* >= gfx7 */
#define   S_008214_MEC1_LOAD_BUSY(x)                                  (((unsigned)(x) & 0x1) << 0)
#define   G_008214_MEC1_LOAD_BUSY(x)                                  (((x) >> 0) & 0x1)
#define   C_008214_MEC1_LOAD_BUSY                                     0xFFFFFFFE
#define   S_008214_MEC1_SEMAPOHRE_BUSY(x)                             (((unsigned)(x) & 0x1) << 1)
#define   G_008214_MEC1_SEMAPOHRE_BUSY(x)                             (((x) >> 1) & 0x1)
#define   C_008214_MEC1_SEMAPOHRE_BUSY                                0xFFFFFFFD
#define   S_008214_MEC1_MUTEX_BUSY(x)                                 (((unsigned)(x) & 0x1) << 2)
#define   G_008214_MEC1_MUTEX_BUSY(x)                                 (((x) >> 2) & 0x1)
#define   C_008214_MEC1_MUTEX_BUSY                                    0xFFFFFFFB
#define   S_008214_MEC1_MESSAGE_BUSY(x)                               (((unsigned)(x) & 0x1) << 3)
#define   G_008214_MEC1_MESSAGE_BUSY(x)                               (((x) >> 3) & 0x1)
#define   C_008214_MEC1_MESSAGE_BUSY                                  0xFFFFFFF7
#define   S_008214_MEC1_EOP_QUEUE_BUSY(x)                             (((unsigned)(x) & 0x1) << 4)
#define   G_008214_MEC1_EOP_QUEUE_BUSY(x)                             (((x) >> 4) & 0x1)
#define   C_008214_MEC1_EOP_QUEUE_BUSY                                0xFFFFFFEF
#define   S_008214_MEC1_IQ_QUEUE_BUSY(x)                              (((unsigned)(x) & 0x1) << 5)
#define   G_008214_MEC1_IQ_QUEUE_BUSY(x)                              (((x) >> 5) & 0x1)
#define   C_008214_MEC1_IQ_QUEUE_BUSY                                 0xFFFFFFDF
#define   S_008214_MEC1_IB_QUEUE_BUSY(x)                              (((unsigned)(x) & 0x1) << 6)
#define   G_008214_MEC1_IB_QUEUE_BUSY(x)                              (((x) >> 6) & 0x1)
#define   C_008214_MEC1_IB_QUEUE_BUSY                                 0xFFFFFFBF
#define   S_008214_MEC1_TC_BUSY(x)                                    (((unsigned)(x) & 0x1) << 7)
#define   G_008214_MEC1_TC_BUSY(x)                                    (((x) >> 7) & 0x1)
#define   C_008214_MEC1_TC_BUSY                                       0xFFFFFF7F
#define   S_008214_MEC1_DMA_BUSY(x)                                   (((unsigned)(x) & 0x1) << 8)
#define   G_008214_MEC1_DMA_BUSY(x)                                   (((x) >> 8) & 0x1)
#define   C_008214_MEC1_DMA_BUSY                                      0xFFFFFEFF
#define   S_008214_MEC1_PARTIAL_FLUSH_BUSY(x)                         (((unsigned)(x) & 0x1) << 9)
#define   G_008214_MEC1_PARTIAL_FLUSH_BUSY(x)                         (((x) >> 9) & 0x1)
#define   C_008214_MEC1_PARTIAL_FLUSH_BUSY                            0xFFFFFDFF
#define   S_008214_MEC1_PIPE0_BUSY(x)                                 (((unsigned)(x) & 0x1) << 10)
#define   G_008214_MEC1_PIPE0_BUSY(x)                                 (((x) >> 10) & 0x1)
#define   C_008214_MEC1_PIPE0_BUSY                                    0xFFFFFBFF
#define   S_008214_MEC1_PIPE1_BUSY(x)                                 (((unsigned)(x) & 0x1) << 11)
#define   G_008214_MEC1_PIPE1_BUSY(x)                                 (((x) >> 11) & 0x1)
#define   C_008214_MEC1_PIPE1_BUSY                                    0xFFFFF7FF
#define   S_008214_MEC1_PIPE2_BUSY(x)                                 (((unsigned)(x) & 0x1) << 12)
#define   G_008214_MEC1_PIPE2_BUSY(x)                                 (((x) >> 12) & 0x1)
#define   C_008214_MEC1_PIPE2_BUSY                                    0xFFFFEFFF
#define   S_008214_MEC1_PIPE3_BUSY(x)                                 (((unsigned)(x) & 0x1) << 13)
#define   G_008214_MEC1_PIPE3_BUSY(x)                                 (((x) >> 13) & 0x1)
#define   C_008214_MEC1_PIPE3_BUSY                                    0xFFFFDFFF
#define   S_008214_MEC2_LOAD_BUSY(x)                                  (((unsigned)(x) & 0x1) << 16)
#define   G_008214_MEC2_LOAD_BUSY(x)                                  (((x) >> 16) & 0x1)
#define   C_008214_MEC2_LOAD_BUSY                                     0xFFFEFFFF
#define   S_008214_MEC2_SEMAPOHRE_BUSY(x)                             (((unsigned)(x) & 0x1) << 17)
#define   G_008214_MEC2_SEMAPOHRE_BUSY(x)                             (((x) >> 17) & 0x1)
#define   C_008214_MEC2_SEMAPOHRE_BUSY                                0xFFFDFFFF
#define   S_008214_MEC2_MUTEX_BUSY(x)                                 (((unsigned)(x) & 0x1) << 18)
#define   G_008214_MEC2_MUTEX_BUSY(x)                                 (((x) >> 18) & 0x1)
#define   C_008214_MEC2_MUTEX_BUSY                                    0xFFFBFFFF
#define   S_008214_MEC2_MESSAGE_BUSY(x)                               (((unsigned)(x) & 0x1) << 19)
#define   G_008214_MEC2_MESSAGE_BUSY(x)                               (((x) >> 19) & 0x1)
#define   C_008214_MEC2_MESSAGE_BUSY                                  0xFFF7FFFF
#define   S_008214_MEC2_EOP_QUEUE_BUSY(x)                             (((unsigned)(x) & 0x1) << 20)
#define   G_008214_MEC2_EOP_QUEUE_BUSY(x)                             (((x) >> 20) & 0x1)
#define   C_008214_MEC2_EOP_QUEUE_BUSY                                0xFFEFFFFF
#define   S_008214_MEC2_IQ_QUEUE_BUSY(x)                              (((unsigned)(x) & 0x1) << 21)
#define   G_008214_MEC2_IQ_QUEUE_BUSY(x)                              (((x) >> 21) & 0x1)
#define   C_008214_MEC2_IQ_QUEUE_BUSY                                 0xFFDFFFFF
#define   S_008214_MEC2_IB_QUEUE_BUSY(x)                              (((unsigned)(x) & 0x1) << 22)
#define   G_008214_MEC2_IB_QUEUE_BUSY(x)                              (((x) >> 22) & 0x1)
#define   C_008214_MEC2_IB_QUEUE_BUSY                                 0xFFBFFFFF
#define   S_008214_MEC2_TC_BUSY(x)                                    (((unsigned)(x) & 0x1) << 23)
#define   G_008214_MEC2_TC_BUSY(x)                                    (((x) >> 23) & 0x1)
#define   C_008214_MEC2_TC_BUSY                                       0xFF7FFFFF
#define   S_008214_MEC2_DMA_BUSY(x)                                   (((unsigned)(x) & 0x1) << 24)
#define   G_008214_MEC2_DMA_BUSY(x)                                   (((x) >> 24) & 0x1)
#define   C_008214_MEC2_DMA_BUSY                                      0xFEFFFFFF
#define   S_008214_MEC2_PARTIAL_FLUSH_BUSY(x)                         (((unsigned)(x) & 0x1) << 25)
#define   G_008214_MEC2_PARTIAL_FLUSH_BUSY(x)                         (((x) >> 25) & 0x1)
#define   C_008214_MEC2_PARTIAL_FLUSH_BUSY                            0xFDFFFFFF
#define   S_008214_MEC2_PIPE0_BUSY(x)                                 (((unsigned)(x) & 0x1) << 26)
#define   G_008214_MEC2_PIPE0_BUSY(x)                                 (((x) >> 26) & 0x1)
#define   C_008214_MEC2_PIPE0_BUSY                                    0xFBFFFFFF
#define   S_008214_MEC2_PIPE1_BUSY(x)                                 (((unsigned)(x) & 0x1) << 27)
#define   G_008214_MEC2_PIPE1_BUSY(x)                                 (((x) >> 27) & 0x1)
#define   C_008214_MEC2_PIPE1_BUSY                                    0xF7FFFFFF
#define   S_008214_MEC2_PIPE2_BUSY(x)                                 (((unsigned)(x) & 0x1) << 28)
#define   G_008214_MEC2_PIPE2_BUSY(x)                                 (((x) >> 28) & 0x1)
#define   C_008214_MEC2_PIPE2_BUSY                                    0xEFFFFFFF
#define   S_008214_MEC2_PIPE3_BUSY(x)                                 (((unsigned)(x) & 0x1) << 29)
#define   G_008214_MEC2_PIPE3_BUSY(x)                                 (((x) >> 29) & 0x1)
#define   C_008214_MEC2_PIPE3_BUSY                                    0xDFFFFFFF
#define R_008218_CP_CPC_STALLED_STAT1                                   0x008218 /* >= gfx7 */
#define   S_008218_MIU_RDREQ_FREE_STALL(x)                            (((unsigned)(x) & 0x1) << 0) /* gfx7 */
#define   G_008218_MIU_RDREQ_FREE_STALL(x)                            (((x) >> 0) & 0x1)
#define   C_008218_MIU_RDREQ_FREE_STALL                               0xFFFFFFFE
#define   S_008218_MIU_WRREQ_FREE_STALL(x)                            (((unsigned)(x) & 0x1) << 1) /* gfx7 */
#define   G_008218_MIU_WRREQ_FREE_STALL(x)                            (((x) >> 1) & 0x1)
#define   C_008218_MIU_WRREQ_FREE_STALL                               0xFFFFFFFD
#define   S_008218_RCIU_TX_FREE_STALL(x)                              (((unsigned)(x) & 0x1) << 3)
#define   G_008218_RCIU_TX_FREE_STALL(x)                              (((x) >> 3) & 0x1)
#define   C_008218_RCIU_TX_FREE_STALL                                 0xFFFFFFF7
#define   S_008218_RCIU_PRIV_VIOLATION(x)                             (((unsigned)(x) & 0x1) << 4)
#define   G_008218_RCIU_PRIV_VIOLATION(x)                             (((x) >> 4) & 0x1)
#define   C_008218_RCIU_PRIV_VIOLATION                                0xFFFFFFEF
#define   S_008218_TCIU_TX_FREE_STALL(x)                              (((unsigned)(x) & 0x1) << 6)
#define   G_008218_TCIU_TX_FREE_STALL(x)                              (((x) >> 6) & 0x1)
#define   C_008218_TCIU_TX_FREE_STALL                                 0xFFFFFFBF
#define   S_008218_MEC1_DECODING_PACKET(x)                            (((unsigned)(x) & 0x1) << 8)
#define   G_008218_MEC1_DECODING_PACKET(x)                            (((x) >> 8) & 0x1)
#define   C_008218_MEC1_DECODING_PACKET                               0xFFFFFEFF
#define   S_008218_MEC1_WAIT_ON_RCIU(x)                               (((unsigned)(x) & 0x1) << 9)
#define   G_008218_MEC1_WAIT_ON_RCIU(x)                               (((x) >> 9) & 0x1)
#define   C_008218_MEC1_WAIT_ON_RCIU                                  0xFFFFFDFF
#define   S_008218_MEC1_WAIT_ON_RCIU_READ(x)                          (((unsigned)(x) & 0x1) << 10)
#define   G_008218_MEC1_WAIT_ON_RCIU_READ(x)                          (((x) >> 10) & 0x1)
#define   C_008218_MEC1_WAIT_ON_RCIU_READ                             0xFFFFFBFF
#define   S_008218_MEC1_WAIT_ON_MC_READ(x)                            (((unsigned)(x) & 0x1) << 11) /* gfx7 */
#define   G_008218_MEC1_WAIT_ON_MC_READ(x)                            (((x) >> 11) & 0x1)
#define   C_008218_MEC1_WAIT_ON_MC_READ                               0xFFFFF7FF
#define   S_008218_MEC1_WAIT_ON_MC_WR_ACK(x)                          (((unsigned)(x) & 0x1) << 12) /* gfx7 */
#define   G_008218_MEC1_WAIT_ON_MC_WR_ACK(x)                          (((x) >> 12) & 0x1)
#define   C_008218_MEC1_WAIT_ON_MC_WR_ACK                             0xFFFFEFFF
#define   S_008218_MEC1_WAIT_ON_ROQ_DATA(x)                           (((unsigned)(x) & 0x1) << 13)
#define   G_008218_MEC1_WAIT_ON_ROQ_DATA(x)                           (((x) >> 13) & 0x1)
#define   C_008218_MEC1_WAIT_ON_ROQ_DATA                              0xFFFFDFFF
#define   S_008218_MEC2_DECODING_PACKET(x)                            (((unsigned)(x) & 0x1) << 16)
#define   G_008218_MEC2_DECODING_PACKET(x)                            (((x) >> 16) & 0x1)
#define   C_008218_MEC2_DECODING_PACKET                               0xFFFEFFFF
#define   S_008218_MEC2_WAIT_ON_RCIU(x)                               (((unsigned)(x) & 0x1) << 17)
#define   G_008218_MEC2_WAIT_ON_RCIU(x)                               (((x) >> 17) & 0x1)
#define   C_008218_MEC2_WAIT_ON_RCIU                                  0xFFFDFFFF
#define   S_008218_MEC2_WAIT_ON_RCIU_READ(x)                          (((unsigned)(x) & 0x1) << 18)
#define   G_008218_MEC2_WAIT_ON_RCIU_READ(x)                          (((x) >> 18) & 0x1)
#define   C_008218_MEC2_WAIT_ON_RCIU_READ                             0xFFFBFFFF
#define   S_008218_MEC2_WAIT_ON_MC_READ(x)                            (((unsigned)(x) & 0x1) << 19) /* gfx7 */
#define   G_008218_MEC2_WAIT_ON_MC_READ(x)                            (((x) >> 19) & 0x1)
#define   C_008218_MEC2_WAIT_ON_MC_READ                               0xFFF7FFFF
#define   S_008218_MEC2_WAIT_ON_MC_WR_ACK(x)                          (((unsigned)(x) & 0x1) << 20) /* gfx7 */
#define   G_008218_MEC2_WAIT_ON_MC_WR_ACK(x)                          (((x) >> 20) & 0x1)
#define   C_008218_MEC2_WAIT_ON_MC_WR_ACK                             0xFFEFFFFF
#define   S_008218_MEC2_WAIT_ON_ROQ_DATA(x)                           (((unsigned)(x) & 0x1) << 21)
#define   G_008218_MEC2_WAIT_ON_ROQ_DATA(x)                           (((x) >> 21) & 0x1)
#define   C_008218_MEC2_WAIT_ON_ROQ_DATA                              0xFFDFFFFF
#define   S_008218_ATCL2IU_WAITING_ON_FREE(x)                         (((unsigned)(x) & 0x1) << 22) /* gfx8, gfx81 */
#define   G_008218_ATCL2IU_WAITING_ON_FREE(x)                         (((x) >> 22) & 0x1)
#define   C_008218_ATCL2IU_WAITING_ON_FREE                            0xFFBFFFFF
#define   S_008218_UTCL2IU_WAITING_ON_FREE(x)                         (((unsigned)(x) & 0x1) << 22) /* >= gfx9 */
#define   G_008218_UTCL2IU_WAITING_ON_FREE(x)                         (((x) >> 22) & 0x1)
#define   C_008218_UTCL2IU_WAITING_ON_FREE                            0xFFBFFFFF
#define   S_008218_ATCL2IU_WAITING_ON_TAGS(x)                         (((unsigned)(x) & 0x1) << 23) /* gfx8, gfx81 */
#define   G_008218_ATCL2IU_WAITING_ON_TAGS(x)                         (((x) >> 23) & 0x1)
#define   C_008218_ATCL2IU_WAITING_ON_TAGS                            0xFF7FFFFF
#define   S_008218_UTCL2IU_WAITING_ON_TAGS(x)                         (((unsigned)(x) & 0x1) << 23) /* >= gfx9 */
#define   G_008218_UTCL2IU_WAITING_ON_TAGS(x)                         (((x) >> 23) & 0x1)
#define   C_008218_UTCL2IU_WAITING_ON_TAGS                            0xFF7FFFFF
#define   S_008218_ATCL1_WAITING_ON_TRANS(x)                          (((unsigned)(x) & 0x1) << 24) /* gfx8, gfx81 */
#define   G_008218_ATCL1_WAITING_ON_TRANS(x)                          (((x) >> 24) & 0x1)
#define   C_008218_ATCL1_WAITING_ON_TRANS                             0xFEFFFFFF
#define   S_008218_UTCL1_WAITING_ON_TRANS(x)                          (((unsigned)(x) & 0x1) << 24) /* >= gfx9 */
#define   G_008218_UTCL1_WAITING_ON_TRANS(x)                          (((x) >> 24) & 0x1)
#define   C_008218_UTCL1_WAITING_ON_TRANS                             0xFEFFFFFF
#define   S_008218_GCRIU_WAITING_ON_FREE(x)                           (((unsigned)(x) & 0x1) << 25) /* >= gfx10 */
#define   G_008218_GCRIU_WAITING_ON_FREE(x)                           (((x) >> 25) & 0x1)
#define   C_008218_GCRIU_WAITING_ON_FREE                              0xFDFFFFFF
#define R_00821C_CP_CPF_STATUS                                          0x00821C /* >= gfx7 */
#define   S_00821C_POST_WPTR_GFX_BUSY(x)                              (((unsigned)(x) & 0x1) << 0)
#define   G_00821C_POST_WPTR_GFX_BUSY(x)                              (((x) >> 0) & 0x1)
#define   C_00821C_POST_WPTR_GFX_BUSY                                 0xFFFFFFFE
#define   S_00821C_CSF_BUSY(x)                                        (((unsigned)(x) & 0x1) << 1)
#define   G_00821C_CSF_BUSY(x)                                        (((x) >> 1) & 0x1)
#define   C_00821C_CSF_BUSY                                           0xFFFFFFFD
#define   S_00821C_MIU_RDREQ_BUSY(x)                                  (((unsigned)(x) & 0x1) << 2) /* gfx7 */
#define   G_00821C_MIU_RDREQ_BUSY(x)                                  (((x) >> 2) & 0x1)
#define   C_00821C_MIU_RDREQ_BUSY                                     0xFFFFFFFB
#define   S_00821C_MIU_WRREQ_BUSY(x)                                  (((unsigned)(x) & 0x1) << 3) /* gfx7 */
#define   G_00821C_MIU_WRREQ_BUSY(x)                                  (((x) >> 3) & 0x1)
#define   C_00821C_MIU_WRREQ_BUSY                                     0xFFFFFFF7
#define   S_00821C_ROQ_ALIGN_BUSY(x)                                  (((unsigned)(x) & 0x1) << 4)
#define   G_00821C_ROQ_ALIGN_BUSY(x)                                  (((x) >> 4) & 0x1)
#define   C_00821C_ROQ_ALIGN_BUSY                                     0xFFFFFFEF
#define   S_00821C_ROQ_RING_BUSY(x)                                   (((unsigned)(x) & 0x1) << 5)
#define   G_00821C_ROQ_RING_BUSY(x)                                   (((x) >> 5) & 0x1)
#define   C_00821C_ROQ_RING_BUSY                                      0xFFFFFFDF
#define   S_00821C_ROQ_INDIRECT1_BUSY(x)                              (((unsigned)(x) & 0x1) << 6)
#define   G_00821C_ROQ_INDIRECT1_BUSY(x)                              (((x) >> 6) & 0x1)
#define   C_00821C_ROQ_INDIRECT1_BUSY                                 0xFFFFFFBF
#define   S_00821C_ROQ_INDIRECT2_BUSY(x)                              (((unsigned)(x) & 0x1) << 7)
#define   G_00821C_ROQ_INDIRECT2_BUSY(x)                              (((x) >> 7) & 0x1)
#define   C_00821C_ROQ_INDIRECT2_BUSY                                 0xFFFFFF7F
#define   S_00821C_ROQ_STATE_BUSY(x)                                  (((unsigned)(x) & 0x1) << 8)
#define   G_00821C_ROQ_STATE_BUSY(x)                                  (((x) >> 8) & 0x1)
#define   C_00821C_ROQ_STATE_BUSY                                     0xFFFFFEFF
#define   S_00821C_ROQ_CE_RING_BUSY(x)                                (((unsigned)(x) & 0x1) << 9)
#define   G_00821C_ROQ_CE_RING_BUSY(x)                                (((x) >> 9) & 0x1)
#define   C_00821C_ROQ_CE_RING_BUSY                                   0xFFFFFDFF
#define   S_00821C_ROQ_CE_INDIRECT1_BUSY(x)                           (((unsigned)(x) & 0x1) << 10)
#define   G_00821C_ROQ_CE_INDIRECT1_BUSY(x)                           (((x) >> 10) & 0x1)
#define   C_00821C_ROQ_CE_INDIRECT1_BUSY                              0xFFFFFBFF
#define   S_00821C_ROQ_CE_INDIRECT2_BUSY(x)                           (((unsigned)(x) & 0x1) << 11)
#define   G_00821C_ROQ_CE_INDIRECT2_BUSY(x)                           (((x) >> 11) & 0x1)
#define   C_00821C_ROQ_CE_INDIRECT2_BUSY                              0xFFFFF7FF
#define   S_00821C_SEMAPHORE_BUSY(x)                                  (((unsigned)(x) & 0x1) << 12)
#define   G_00821C_SEMAPHORE_BUSY(x)                                  (((x) >> 12) & 0x1)
#define   C_00821C_SEMAPHORE_BUSY                                     0xFFFFEFFF
#define   S_00821C_INTERRUPT_BUSY(x)                                  (((unsigned)(x) & 0x1) << 13)
#define   G_00821C_INTERRUPT_BUSY(x)                                  (((x) >> 13) & 0x1)
#define   C_00821C_INTERRUPT_BUSY                                     0xFFFFDFFF
#define   S_00821C_TCIU_BUSY(x)                                       (((unsigned)(x) & 0x1) << 14)
#define   G_00821C_TCIU_BUSY(x)                                       (((x) >> 14) & 0x1)
#define   C_00821C_TCIU_BUSY                                          0xFFFFBFFF
#define   S_00821C_HQD_BUSY(x)                                        (((unsigned)(x) & 0x1) << 15)
#define   G_00821C_HQD_BUSY(x)                                        (((x) >> 15) & 0x1)
#define   C_00821C_HQD_BUSY                                           0xFFFF7FFF
#define   S_00821C_PRT_BUSY(x)                                        (((unsigned)(x) & 0x1) << 16) /* >= gfx8 */
#define   G_00821C_PRT_BUSY(x)                                        (((x) >> 16) & 0x1)
#define   C_00821C_PRT_BUSY                                           0xFFFEFFFF
#define   S_00821C_ATCL2IU_BUSY(x)                                    (((unsigned)(x) & 0x1) << 17) /* gfx8, gfx81 */
#define   G_00821C_ATCL2IU_BUSY(x)                                    (((x) >> 17) & 0x1)
#define   C_00821C_ATCL2IU_BUSY                                       0xFFFDFFFF
#define   S_00821C_UTCL2IU_BUSY(x)                                    (((unsigned)(x) & 0x1) << 17) /* >= gfx9 */
#define   G_00821C_UTCL2IU_BUSY(x)                                    (((x) >> 17) & 0x1)
#define   C_00821C_UTCL2IU_BUSY                                       0xFFFDFFFF
#define   S_00821C_RCIU_BUSY(x)                                       (((unsigned)(x) & 0x1) << 18) /* >= gfx10 */
#define   G_00821C_RCIU_BUSY(x)                                       (((x) >> 18) & 0x1)
#define   C_00821C_RCIU_BUSY                                          0xFFFBFFFF
#define   S_00821C_RCIU_GFX_BUSY(x)                                   (((unsigned)(x) & 0x1) << 19) /* >= gfx10 */
#define   G_00821C_RCIU_GFX_BUSY(x)                                   (((x) >> 19) & 0x1)
#define   C_00821C_RCIU_GFX_BUSY                                      0xFFF7FFFF
#define   S_00821C_RCIU_CMP_BUSY(x)                                   (((unsigned)(x) & 0x1) << 20) /* >= gfx10 */
#define   G_00821C_RCIU_CMP_BUSY(x)                                   (((x) >> 20) & 0x1)
#define   C_00821C_RCIU_CMP_BUSY                                      0xFFEFFFFF
#define   S_00821C_ROQ_DATA_BUSY(x)                                   (((unsigned)(x) & 0x1) << 21) /* >= gfx10 */
#define   G_00821C_ROQ_DATA_BUSY(x)                                   (((x) >> 21) & 0x1)
#define   C_00821C_ROQ_DATA_BUSY                                      0xFFDFFFFF
#define   S_00821C_ROQ_CE_DATA_BUSY(x)                                (((unsigned)(x) & 0x1) << 22) /* >= gfx10 */
#define   G_00821C_ROQ_CE_DATA_BUSY(x)                                (((x) >> 22) & 0x1)
#define   C_00821C_ROQ_CE_DATA_BUSY                                   0xFFBFFFFF
#define   S_00821C_GCRIU_BUSY(x)                                      (((unsigned)(x) & 0x1) << 23) /* >= gfx10 */
#define   G_00821C_GCRIU_BUSY(x)                                      (((x) >> 23) & 0x1)
#define   C_00821C_GCRIU_BUSY                                         0xFF7FFFFF
#define   S_00821C_MES_HQD_BUSY(x)                                    (((unsigned)(x) & 0x1) << 24) /* >= gfx10 */
#define   G_00821C_MES_HQD_BUSY(x)                                    (((x) >> 24) & 0x1)
#define   C_00821C_MES_HQD_BUSY                                       0xFEFFFFFF
#define   S_00821C_CPF_GFX_BUSY(x)                                    (((unsigned)(x) & 0x1) << 26) /* >= gfx8 */
#define   G_00821C_CPF_GFX_BUSY(x)                                    (((x) >> 26) & 0x1)
#define   C_00821C_CPF_GFX_BUSY                                       0xFBFFFFFF
#define   S_00821C_CPF_CMP_BUSY(x)                                    (((unsigned)(x) & 0x1) << 27) /* >= gfx8 */
#define   G_00821C_CPF_CMP_BUSY(x)                                    (((x) >> 27) & 0x1)
#define   C_00821C_CPF_CMP_BUSY                                       0xF7FFFFFF
#define   S_00821C_GRBM_CPF_STAT_BUSY(x)                              (((unsigned)(x) & 0x3) << 28) /* >= gfx8 */
#define   G_00821C_GRBM_CPF_STAT_BUSY(x)                              (((x) >> 28) & 0x3)
#define   C_00821C_GRBM_CPF_STAT_BUSY                                 0xCFFFFFFF
#define   S_00821C_CPC_CPF_BUSY(x)                                    (((unsigned)(x) & 0x1) << 30)
#define   G_00821C_CPC_CPF_BUSY(x)                                    (((x) >> 30) & 0x1)
#define   C_00821C_CPC_CPF_BUSY                                       0xBFFFFFFF
#define   S_00821C_CPF_BUSY(x)                                        (((unsigned)(x) & 0x1) << 31)
#define   G_00821C_CPF_BUSY(x)                                        (((x) >> 31) & 0x1)
#define   C_00821C_CPF_BUSY                                           0x7FFFFFFF
#define R_008220_CP_CPF_BUSY_STAT                                       0x008220 /* >= gfx7 */
#define   S_008220_REG_BUS_FIFO_BUSY(x)                               (((unsigned)(x) & 0x1) << 0)
#define   G_008220_REG_BUS_FIFO_BUSY(x)                               (((x) >> 0) & 0x1)
#define   C_008220_REG_BUS_FIFO_BUSY                                  0xFFFFFFFE
#define   S_008220_CSF_RING_BUSY(x)                                   (((unsigned)(x) & 0x1) << 1)
#define   G_008220_CSF_RING_BUSY(x)                                   (((x) >> 1) & 0x1)
#define   C_008220_CSF_RING_BUSY                                      0xFFFFFFFD
#define   S_008220_CSF_INDIRECT1_BUSY(x)                              (((unsigned)(x) & 0x1) << 2)
#define   G_008220_CSF_INDIRECT1_BUSY(x)                              (((x) >> 2) & 0x1)
#define   C_008220_CSF_INDIRECT1_BUSY                                 0xFFFFFFFB
#define   S_008220_CSF_INDIRECT2_BUSY(x)                              (((unsigned)(x) & 0x1) << 3)
#define   G_008220_CSF_INDIRECT2_BUSY(x)                              (((x) >> 3) & 0x1)
#define   C_008220_CSF_INDIRECT2_BUSY                                 0xFFFFFFF7
#define   S_008220_CSF_STATE_BUSY(x)                                  (((unsigned)(x) & 0x1) << 4)
#define   G_008220_CSF_STATE_BUSY(x)                                  (((x) >> 4) & 0x1)
#define   C_008220_CSF_STATE_BUSY                                     0xFFFFFFEF
#define   S_008220_CSF_CE_INDR1_BUSY(x)                               (((unsigned)(x) & 0x1) << 5)
#define   G_008220_CSF_CE_INDR1_BUSY(x)                               (((x) >> 5) & 0x1)
#define   C_008220_CSF_CE_INDR1_BUSY                                  0xFFFFFFDF
#define   S_008220_CSF_CE_INDR2_BUSY(x)                               (((unsigned)(x) & 0x1) << 6)
#define   G_008220_CSF_CE_INDR2_BUSY(x)                               (((x) >> 6) & 0x1)
#define   C_008220_CSF_CE_INDR2_BUSY                                  0xFFFFFFBF
#define   S_008220_CSF_ARBITER_BUSY(x)                                (((unsigned)(x) & 0x1) << 7)
#define   G_008220_CSF_ARBITER_BUSY(x)                                (((x) >> 7) & 0x1)
#define   C_008220_CSF_ARBITER_BUSY                                   0xFFFFFF7F
#define   S_008220_CSF_INPUT_BUSY(x)                                  (((unsigned)(x) & 0x1) << 8)
#define   G_008220_CSF_INPUT_BUSY(x)                                  (((x) >> 8) & 0x1)
#define   C_008220_CSF_INPUT_BUSY                                     0xFFFFFEFF
#define   S_008220_CSF_DATA_BUSY(x)                                   (((unsigned)(x) & 0x1) << 9) /* >= gfx10 */
#define   G_008220_CSF_DATA_BUSY(x)                                   (((x) >> 9) & 0x1)
#define   C_008220_CSF_DATA_BUSY                                      0xFFFFFDFF
#define   S_008220_OUTSTANDING_READ_TAGS(x)                           (((unsigned)(x) & 0x1) << 9) /* gfx7, gfx8, gfx81, gfx9 */
#define   G_008220_OUTSTANDING_READ_TAGS(x)                           (((x) >> 9) & 0x1)
#define   C_008220_OUTSTANDING_READ_TAGS                              0xFFFFFDFF
#define   S_008220_CSF_CE_DATA_BUSY(x)                                (((unsigned)(x) & 0x1) << 10) /* >= gfx10 */
#define   G_008220_CSF_CE_DATA_BUSY(x)                                (((x) >> 10) & 0x1)
#define   C_008220_CSF_CE_DATA_BUSY                                   0xFFFFFBFF
#define   S_008220_HPD_PROCESSING_EOP_BUSY(x)                         (((unsigned)(x) & 0x1) << 11)
#define   G_008220_HPD_PROCESSING_EOP_BUSY(x)                         (((x) >> 11) & 0x1)
#define   C_008220_HPD_PROCESSING_EOP_BUSY                            0xFFFFF7FF
#define   S_008220_HQD_DISPATCH_BUSY(x)                               (((unsigned)(x) & 0x1) << 12)
#define   G_008220_HQD_DISPATCH_BUSY(x)                               (((x) >> 12) & 0x1)
#define   C_008220_HQD_DISPATCH_BUSY                                  0xFFFFEFFF
#define   S_008220_HQD_IQ_TIMER_BUSY(x)                               (((unsigned)(x) & 0x1) << 13)
#define   G_008220_HQD_IQ_TIMER_BUSY(x)                               (((x) >> 13) & 0x1)
#define   C_008220_HQD_IQ_TIMER_BUSY                                  0xFFFFDFFF
#define   S_008220_HQD_DMA_OFFLOAD_BUSY(x)                            (((unsigned)(x) & 0x1) << 14)
#define   G_008220_HQD_DMA_OFFLOAD_BUSY(x)                            (((x) >> 14) & 0x1)
#define   C_008220_HQD_DMA_OFFLOAD_BUSY                               0xFFFFBFFF
#define   S_008220_HQD_WAIT_SEMAPHORE_BUSY(x)                         (((unsigned)(x) & 0x1) << 15)
#define   G_008220_HQD_WAIT_SEMAPHORE_BUSY(x)                         (((x) >> 15) & 0x1)
#define   C_008220_HQD_WAIT_SEMAPHORE_BUSY                            0xFFFF7FFF
#define   S_008220_HQD_SIGNAL_SEMAPHORE_BUSY(x)                       (((unsigned)(x) & 0x1) << 16)
#define   G_008220_HQD_SIGNAL_SEMAPHORE_BUSY(x)                       (((x) >> 16) & 0x1)
#define   C_008220_HQD_SIGNAL_SEMAPHORE_BUSY                          0xFFFEFFFF
#define   S_008220_HQD_MESSAGE_BUSY(x)                                (((unsigned)(x) & 0x1) << 17)
#define   G_008220_HQD_MESSAGE_BUSY(x)                                (((x) >> 17) & 0x1)
#define   C_008220_HQD_MESSAGE_BUSY                                   0xFFFDFFFF
#define   S_008220_HQD_PQ_FETCHER_BUSY(x)                             (((unsigned)(x) & 0x1) << 18)
#define   G_008220_HQD_PQ_FETCHER_BUSY(x)                             (((x) >> 18) & 0x1)
#define   C_008220_HQD_PQ_FETCHER_BUSY                                0xFFFBFFFF
#define   S_008220_HQD_IB_FETCHER_BUSY(x)                             (((unsigned)(x) & 0x1) << 19)
#define   G_008220_HQD_IB_FETCHER_BUSY(x)                             (((x) >> 19) & 0x1)
#define   C_008220_HQD_IB_FETCHER_BUSY                                0xFFF7FFFF
#define   S_008220_HQD_IQ_FETCHER_BUSY(x)                             (((unsigned)(x) & 0x1) << 20)
#define   G_008220_HQD_IQ_FETCHER_BUSY(x)                             (((x) >> 20) & 0x1)
#define   C_008220_HQD_IQ_FETCHER_BUSY                                0xFFEFFFFF
#define   S_008220_HQD_EOP_FETCHER_BUSY(x)                            (((unsigned)(x) & 0x1) << 21)
#define   G_008220_HQD_EOP_FETCHER_BUSY(x)                            (((x) >> 21) & 0x1)
#define   C_008220_HQD_EOP_FETCHER_BUSY                               0xFFDFFFFF
#define   S_008220_HQD_CONSUMED_RPTR_BUSY(x)                          (((unsigned)(x) & 0x1) << 22)
#define   G_008220_HQD_CONSUMED_RPTR_BUSY(x)                          (((x) >> 22) & 0x1)
#define   C_008220_HQD_CONSUMED_RPTR_BUSY                             0xFFBFFFFF
#define   S_008220_HQD_FETCHER_ARB_BUSY(x)                            (((unsigned)(x) & 0x1) << 23)
#define   G_008220_HQD_FETCHER_ARB_BUSY(x)                            (((x) >> 23) & 0x1)
#define   C_008220_HQD_FETCHER_ARB_BUSY                               0xFF7FFFFF
#define   S_008220_HQD_ROQ_ALIGN_BUSY(x)                              (((unsigned)(x) & 0x1) << 24)
#define   G_008220_HQD_ROQ_ALIGN_BUSY(x)                              (((x) >> 24) & 0x1)
#define   C_008220_HQD_ROQ_ALIGN_BUSY                                 0xFEFFFFFF
#define   S_008220_HQD_ROQ_EOP_BUSY(x)                                (((unsigned)(x) & 0x1) << 25)
#define   G_008220_HQD_ROQ_EOP_BUSY(x)                                (((x) >> 25) & 0x1)
#define   C_008220_HQD_ROQ_EOP_BUSY                                   0xFDFFFFFF
#define   S_008220_HQD_ROQ_IQ_BUSY(x)                                 (((unsigned)(x) & 0x1) << 26)
#define   G_008220_HQD_ROQ_IQ_BUSY(x)                                 (((x) >> 26) & 0x1)
#define   C_008220_HQD_ROQ_IQ_BUSY                                    0xFBFFFFFF
#define   S_008220_HQD_ROQ_PQ_BUSY(x)                                 (((unsigned)(x) & 0x1) << 27)
#define   G_008220_HQD_ROQ_PQ_BUSY(x)                                 (((x) >> 27) & 0x1)
#define   C_008220_HQD_ROQ_PQ_BUSY                                    0xF7FFFFFF
#define   S_008220_HQD_ROQ_IB_BUSY(x)                                 (((unsigned)(x) & 0x1) << 28)
#define   G_008220_HQD_ROQ_IB_BUSY(x)                                 (((x) >> 28) & 0x1)
#define   C_008220_HQD_ROQ_IB_BUSY                                    0xEFFFFFFF
#define   S_008220_HQD_WPTR_POLL_BUSY(x)                              (((unsigned)(x) & 0x1) << 29)
#define   G_008220_HQD_WPTR_POLL_BUSY(x)                              (((x) >> 29) & 0x1)
#define   C_008220_HQD_WPTR_POLL_BUSY                                 0xDFFFFFFF
#define   S_008220_HQD_PQ_BUSY(x)                                     (((unsigned)(x) & 0x1) << 30)
#define   G_008220_HQD_PQ_BUSY(x)                                     (((x) >> 30) & 0x1)
#define   C_008220_HQD_PQ_BUSY                                        0xBFFFFFFF
#define   S_008220_HQD_IB_BUSY(x)                                     (((unsigned)(x) & 0x1) << 31)
#define   G_008220_HQD_IB_BUSY(x)                                     (((x) >> 31) & 0x1)
#define   C_008220_HQD_IB_BUSY                                        0x7FFFFFFF
#define R_008224_CP_CPF_STALLED_STAT1                                   0x008224 /* >= gfx7 */
#define   S_008224_RING_FETCHING_DATA(x)                              (((unsigned)(x) & 0x1) << 0)
#define   G_008224_RING_FETCHING_DATA(x)                              (((x) >> 0) & 0x1)
#define   C_008224_RING_FETCHING_DATA                                 0xFFFFFFFE
#define   S_008224_INDR1_FETCHING_DATA(x)                             (((unsigned)(x) & 0x1) << 1)
#define   G_008224_INDR1_FETCHING_DATA(x)                             (((x) >> 1) & 0x1)
#define   C_008224_INDR1_FETCHING_DATA                                0xFFFFFFFD
#define   S_008224_INDR2_FETCHING_DATA(x)                             (((unsigned)(x) & 0x1) << 2)
#define   G_008224_INDR2_FETCHING_DATA(x)                             (((x) >> 2) & 0x1)
#define   C_008224_INDR2_FETCHING_DATA                                0xFFFFFFFB
#define   S_008224_STATE_FETCHING_DATA(x)                             (((unsigned)(x) & 0x1) << 3)
#define   G_008224_STATE_FETCHING_DATA(x)                             (((x) >> 3) & 0x1)
#define   C_008224_STATE_FETCHING_DATA                                0xFFFFFFF7
#define   S_008224_MIU_WAITING_ON_RDREQ_FREE(x)                       (((unsigned)(x) & 0x1) << 4) /* gfx7 */
#define   G_008224_MIU_WAITING_ON_RDREQ_FREE(x)                       (((x) >> 4) & 0x1)
#define   C_008224_MIU_WAITING_ON_RDREQ_FREE                          0xFFFFFFEF
#define   S_008224_TCIU_WAITING_ON_FREE(x)                            (((unsigned)(x) & 0x1) << 5)
#define   G_008224_TCIU_WAITING_ON_FREE(x)                            (((x) >> 5) & 0x1)
#define   C_008224_TCIU_WAITING_ON_FREE                               0xFFFFFFDF
#define   S_008224_TCIU_WAITING_ON_TAGS(x)                            (((unsigned)(x) & 0x1) << 6)
#define   G_008224_TCIU_WAITING_ON_TAGS(x)                            (((x) >> 6) & 0x1)
#define   C_008224_TCIU_WAITING_ON_TAGS                               0xFFFFFFBF
#define   S_008224_ATCL2IU_WAITING_ON_FREE(x)                         (((unsigned)(x) & 0x1) << 7) /* gfx8, gfx81 */
#define   G_008224_ATCL2IU_WAITING_ON_FREE(x)                         (((x) >> 7) & 0x1)
#define   C_008224_ATCL2IU_WAITING_ON_FREE                            0xFFFFFF7F
#define   S_008224_UTCL2IU_WAITING_ON_FREE(x)                         (((unsigned)(x) & 0x1) << 7) /* >= gfx9 */
#define   G_008224_UTCL2IU_WAITING_ON_FREE(x)                         (((x) >> 7) & 0x1)
#define   C_008224_UTCL2IU_WAITING_ON_FREE                            0xFFFFFF7F
#define   S_008224_ATCL2IU_WAITING_ON_TAGS(x)                         (((unsigned)(x) & 0x1) << 8) /* gfx8, gfx81 */
#define   G_008224_ATCL2IU_WAITING_ON_TAGS(x)                         (((x) >> 8) & 0x1)
#define   C_008224_ATCL2IU_WAITING_ON_TAGS                            0xFFFFFEFF
#define   S_008224_UTCL2IU_WAITING_ON_TAGS(x)                         (((unsigned)(x) & 0x1) << 8) /* >= gfx9 */
#define   G_008224_UTCL2IU_WAITING_ON_TAGS(x)                         (((x) >> 8) & 0x1)
#define   C_008224_UTCL2IU_WAITING_ON_TAGS                            0xFFFFFEFF
#define   S_008224_ATCL1_WAITING_ON_TRANS(x)                          (((unsigned)(x) & 0x1) << 9) /* gfx8, gfx81 */
#define   G_008224_ATCL1_WAITING_ON_TRANS(x)                          (((x) >> 9) & 0x1)
#define   C_008224_ATCL1_WAITING_ON_TRANS                             0xFFFFFDFF
#define   S_008224_GFX_UTCL1_WAITING_ON_TRANS(x)                      (((unsigned)(x) & 0x1) << 9) /* >= gfx9 */
#define   G_008224_GFX_UTCL1_WAITING_ON_TRANS(x)                      (((x) >> 9) & 0x1)
#define   C_008224_GFX_UTCL1_WAITING_ON_TRANS                         0xFFFFFDFF
#define   S_008224_CMP_UTCL1_WAITING_ON_TRANS(x)                      (((unsigned)(x) & 0x1) << 10) /* >= gfx9 */
#define   G_008224_CMP_UTCL1_WAITING_ON_TRANS(x)                      (((x) >> 10) & 0x1)
#define   C_008224_CMP_UTCL1_WAITING_ON_TRANS                         0xFFFFFBFF
#define   S_008224_RCIU_WAITING_ON_FREE(x)                            (((unsigned)(x) & 0x1) << 11) /* >= gfx9 */
#define   G_008224_RCIU_WAITING_ON_FREE(x)                            (((x) >> 11) & 0x1)
#define   C_008224_RCIU_WAITING_ON_FREE                               0xFFFFF7FF
#define   S_008224_DATA_FETCHING_DATA(x)                              (((unsigned)(x) & 0x1) << 12) /* >= gfx10 */
#define   G_008224_DATA_FETCHING_DATA(x)                              (((x) >> 12) & 0x1)
#define   C_008224_DATA_FETCHING_DATA                                 0xFFFFEFFF
#define   S_008224_GCRIU_WAIT_ON_FREE(x)                              (((unsigned)(x) & 0x1) << 13) /* >= gfx10 */
#define   G_008224_GCRIU_WAIT_ON_FREE(x)                              (((x) >> 13) & 0x1)
#define   C_008224_GCRIU_WAIT_ON_FREE                                 0xFFFFDFFF
#define R_008228_CP_CPC_BUSY_STAT2                                      0x008228 /* >= gfx10 */
#define   S_008228_MES_LOAD_BUSY(x)                                   (((unsigned)(x) & 0x1) << 0)
#define   G_008228_MES_LOAD_BUSY(x)                                   (((x) >> 0) & 0x1)
#define   C_008228_MES_LOAD_BUSY                                      0xFFFFFFFE
#define   S_008228_MES_MUTEX_BUSY(x)                                  (((unsigned)(x) & 0x1) << 2)
#define   G_008228_MES_MUTEX_BUSY(x)                                  (((x) >> 2) & 0x1)
#define   C_008228_MES_MUTEX_BUSY                                     0xFFFFFFFB
#define   S_008228_MES_MESSAGE_BUSY(x)                                (((unsigned)(x) & 0x1) << 3)
#define   G_008228_MES_MESSAGE_BUSY(x)                                (((x) >> 3) & 0x1)
#define   C_008228_MES_MESSAGE_BUSY                                   0xFFFFFFF7
#define   S_008228_MES_TC_BUSY(x)                                     (((unsigned)(x) & 0x1) << 7)
#define   G_008228_MES_TC_BUSY(x)                                     (((x) >> 7) & 0x1)
#define   C_008228_MES_TC_BUSY                                        0xFFFFFF7F
#define   S_008228_MES_DMA_BUSY(x)                                    (((unsigned)(x) & 0x1) << 8)
#define   G_008228_MES_DMA_BUSY(x)                                    (((x) >> 8) & 0x1)
#define   C_008228_MES_DMA_BUSY                                       0xFFFFFEFF
#define   S_008228_MES_PIPE0_BUSY(x)                                  (((unsigned)(x) & 0x1) << 10)
#define   G_008228_MES_PIPE0_BUSY(x)                                  (((x) >> 10) & 0x1)
#define   C_008228_MES_PIPE0_BUSY                                     0xFFFFFBFF
#define   S_008228_MES_PIPE1_BUSY(x)                                  (((unsigned)(x) & 0x1) << 11)
#define   G_008228_MES_PIPE1_BUSY(x)                                  (((x) >> 11) & 0x1)
#define   C_008228_MES_PIPE1_BUSY                                     0xFFFFF7FF
#define   S_008228_MES_PIPE2_BUSY(x)                                  (((unsigned)(x) & 0x1) << 12)
#define   G_008228_MES_PIPE2_BUSY(x)                                  (((x) >> 12) & 0x1)
#define   C_008228_MES_PIPE2_BUSY                                     0xFFFFEFFF
#define   S_008228_MES_PIPE3_BUSY(x)                                  (((unsigned)(x) & 0x1) << 13)
#define   G_008228_MES_PIPE3_BUSY(x)                                  (((x) >> 13) & 0x1)
#define   C_008228_MES_PIPE3_BUSY                                     0xFFFFDFFF
#define R_008228_CP_CPC_MC_CNTL                                         0x008228 /* gfx7 */
#define   S_008228_PACK_DELAY_CNT(x)                                  (((unsigned)(x) & 0x1F) << 0)
#define   G_008228_PACK_DELAY_CNT(x)                                  (((x) >> 0) & 0x1F)
#define   C_008228_PACK_DELAY_CNT                                     0xFFFFFFE0
#define R_00822C_CP_CPC_GRBM_FREE_COUNT                                 0x00822C /* >= gfx7 */
#define   S_00822C_FREE_COUNT(x)                                      (((unsigned)(x) & 0x3F) << 0)
#define   G_00822C_FREE_COUNT(x)                                      (((x) >> 0) & 0x3F)
#define   C_00822C_FREE_COUNT                                         0xFFFFFFC0
#define R_008230_CP_CPC_PRIV_VIOLATION_ADDR                             0x008230 /* >= gfx103 */
#define   S_008230_PRIV_VIOLATION_ADDR(x)                             (((unsigned)(x) & 0xFFFF) << 0)
#define   G_008230_PRIV_VIOLATION_ADDR(x)                             (((x) >> 0) & 0xFFFF)
#define   C_008230_PRIV_VIOLATION_ADDR                                0xFFFF0000
#define R_008240_CP_CPC_SCRATCH_INDEX                                   0x008240 /* >= gfx7 */
#define   S_008240_SCRATCH_INDEX(x)                                   (((unsigned)(x) & 0x1FF) << 0)
#define   G_008240_SCRATCH_INDEX(x)                                   (((x) >> 0) & 0x1FF)
#define   C_008240_SCRATCH_INDEX                                      0xFFFFFE00
#define   S_008240_SCRATCH_INDEX_64BIT_MODE(x)                        (((unsigned)(x) & 0x1) << 31) /* >= gfx10 */
#define   G_008240_SCRATCH_INDEX_64BIT_MODE(x)                        (((x) >> 31) & 0x1)
#define   C_008240_SCRATCH_INDEX_64BIT_MODE                           0x7FFFFFFF
#define R_008244_CP_CPC_SCRATCH_DATA                                    0x008244 /* >= gfx7 */
#define R_008248_CP_CPF_GRBM_FREE_COUNT                                 0x008248 /* >= gfx9 */
#define   S_008248_FREE_COUNT(x)                                      (((unsigned)(x) & 0x7) << 0)
#define   G_008248_FREE_COUNT(x)                                      (((x) >> 0) & 0x7)
#define   C_008248_FREE_COUNT                                         0xFFFFFFF8
#define R_00824C_CP_CPF_BUSY_STAT2                                      0x00824C /* >= gfx10 */
#define   S_00824C_MES_HQD_DISPATCH_BUSY(x)                           (((unsigned)(x) & 0x1) << 12)
#define   G_00824C_MES_HQD_DISPATCH_BUSY(x)                           (((x) >> 12) & 0x1)
#define   C_00824C_MES_HQD_DISPATCH_BUSY                              0xFFFFEFFF
#define   S_00824C_MES_HQD_DMA_OFFLOAD_BUSY(x)                        (((unsigned)(x) & 0x1) << 14)
#define   G_00824C_MES_HQD_DMA_OFFLOAD_BUSY(x)                        (((x) >> 14) & 0x1)
#define   C_00824C_MES_HQD_DMA_OFFLOAD_BUSY                           0xFFFFBFFF
#define   S_00824C_MES_HQD_MESSAGE_BUSY(x)                            (((unsigned)(x) & 0x1) << 17)
#define   G_00824C_MES_HQD_MESSAGE_BUSY(x)                            (((x) >> 17) & 0x1)
#define   C_00824C_MES_HQD_MESSAGE_BUSY                               0xFFFDFFFF
#define   S_00824C_MES_HQD_PQ_FETCHER_BUSY(x)                         (((unsigned)(x) & 0x1) << 18)
#define   G_00824C_MES_HQD_PQ_FETCHER_BUSY(x)                         (((x) >> 18) & 0x1)
#define   C_00824C_MES_HQD_PQ_FETCHER_BUSY                            0xFFFBFFFF
#define   S_00824C_MES_HQD_CONSUMED_RPTR_BUSY(x)                      (((unsigned)(x) & 0x1) << 22)
#define   G_00824C_MES_HQD_CONSUMED_RPTR_BUSY(x)                      (((x) >> 22) & 0x1)
#define   C_00824C_MES_HQD_CONSUMED_RPTR_BUSY                         0xFFBFFFFF
#define   S_00824C_MES_HQD_FETCHER_ARB_BUSY(x)                        (((unsigned)(x) & 0x1) << 23)
#define   G_00824C_MES_HQD_FETCHER_ARB_BUSY(x)                        (((x) >> 23) & 0x1)
#define   C_00824C_MES_HQD_FETCHER_ARB_BUSY                           0xFF7FFFFF
#define   S_00824C_MES_HQD_ROQ_ALIGN_BUSY(x)                          (((unsigned)(x) & 0x1) << 24)
#define   G_00824C_MES_HQD_ROQ_ALIGN_BUSY(x)                          (((x) >> 24) & 0x1)
#define   C_00824C_MES_HQD_ROQ_ALIGN_BUSY                             0xFEFFFFFF
#define   S_00824C_MES_HQD_ROQ_PQ_BUSY(x)                             (((unsigned)(x) & 0x1) << 27)
#define   G_00824C_MES_HQD_ROQ_PQ_BUSY(x)                             (((x) >> 27) & 0x1)
#define   C_00824C_MES_HQD_ROQ_PQ_BUSY                                0xF7FFFFFF
#define   S_00824C_MES_HQD_PQ_BUSY(x)                                 (((unsigned)(x) & 0x1) << 30)
#define   G_00824C_MES_HQD_PQ_BUSY(x)                                 (((x) >> 30) & 0x1)
#define   C_00824C_MES_HQD_PQ_BUSY                                    0xBFFFFFFF
#define R_00829C_CP_CPC_HALT_HYST_COUNT                                 0x00829C /* >= gfx7 */
#define   S_00829C_COUNT(x)                                           (((unsigned)(x) & 0xF) << 0)
#define   G_00829C_COUNT(x)                                           (((x) >> 0) & 0xF)
#define   C_00829C_COUNT                                              0xFFFFFFF0
#define R_008300_SQ_INTERRUPT_WORD_AUTO                                 0x008300 /* <= gfx6 */
#define   S_008300_THREAD_TRACE(x)                                    (((unsigned)(x) & 0x1) << 0)
#define   G_008300_THREAD_TRACE(x)                                    (((x) >> 0) & 0x1)
#define   C_008300_THREAD_TRACE                                       0xFFFFFFFE
#define   S_008300_WLT(x)                                             (((unsigned)(x) & 0x1) << 1)
#define   G_008300_WLT(x)                                             (((x) >> 1) & 0x1)
#define   C_008300_WLT                                                0xFFFFFFFD
#define   S_008300_THREAD_TRACE_BUF_FULL(x)                           (((unsigned)(x) & 0x1) << 2)
#define   G_008300_THREAD_TRACE_BUF_FULL(x)                           (((x) >> 2) & 0x1)
#define   C_008300_THREAD_TRACE_BUF_FULL                              0xFFFFFFFB
#define   S_008300_REG_TIMESTAMP(x)                                   (((unsigned)(x) & 0x1) << 3)
#define   G_008300_REG_TIMESTAMP(x)                                   (((x) >> 3) & 0x1)
#define   C_008300_REG_TIMESTAMP                                      0xFFFFFFF7
#define   S_008300_CMD_TIMESTAMP(x)                                   (((unsigned)(x) & 0x1) << 4)
#define   G_008300_CMD_TIMESTAMP(x)                                   (((x) >> 4) & 0x1)
#define   C_008300_CMD_TIMESTAMP                                      0xFFFFFFEF
#define   S_008300_HOST_CMD_OVERFLOW(x)                               (((unsigned)(x) & 0x1) << 5)
#define   G_008300_HOST_CMD_OVERFLOW(x)                               (((x) >> 5) & 0x1)
#define   C_008300_HOST_CMD_OVERFLOW                                  0xFFFFFFDF
#define   S_008300_HOST_REG_OVERFLOW(x)                               (((unsigned)(x) & 0x1) << 6)
#define   G_008300_HOST_REG_OVERFLOW(x)                               (((x) >> 6) & 0x1)
#define   C_008300_HOST_REG_OVERFLOW                                  0xFFFFFFBF
#define   S_008300_IMMED_OVERFLOW(x)                                  (((unsigned)(x) & 0x1) << 7)
#define   G_008300_IMMED_OVERFLOW(x)                                  (((x) >> 7) & 0x1)
#define   C_008300_IMMED_OVERFLOW                                     0xFFFFFF7F
#define   S_008300_SE_ID(x)                                           (((unsigned)(x) & 0x1) << 25)
#define   G_008300_SE_ID(x)                                           (((x) >> 25) & 0x1)
#define   C_008300_SE_ID                                              0xFDFFFFFF
#define   S_008300_ENCODING(x)                                        (((unsigned)(x) & 0x3) << 26)
#define   G_008300_ENCODING(x)                                        (((x) >> 26) & 0x3)
#define   C_008300_ENCODING                                           0xF3FFFFFF
#define R_008400_CP_EOP_DONE_ADDR_LO                                    0x008400 /* <= gfx6 */
#define   S_008400_ADDR_SWAP(x)                                       (((unsigned)(x) & 0x3) << 0)
#define   G_008400_ADDR_SWAP(x)                                       (((x) >> 0) & 0x3)
#define   C_008400_ADDR_SWAP                                          0xFFFFFFFC
#define   S_008400_ADDR_LO(x)                                         (((unsigned)(x) & 0x3FFFFFFF) << 2)
#define   G_008400_ADDR_LO(x)                                         (((x) >> 2) & 0x3FFFFFFF)
#define   C_008400_ADDR_LO                                            0x00000003
#define R_008404_CP_EOP_DONE_ADDR_HI                                    0x008404 /* <= gfx6 */
#define   S_008404_ADDR_HI(x)                                         (((unsigned)(x) & 0xFFFF) << 0)
#define   G_008404_ADDR_HI(x)                                         (((x) >> 0) & 0xFFFF)
#define   C_008404_ADDR_HI                                            0xFFFF0000
#define R_008408_CP_EOP_DONE_DATA_LO                                    0x008408 /* <= gfx6 */
#define R_00840C_CP_EOP_DONE_DATA_HI                                    0x00840C /* <= gfx6 */
#define R_008410_CP_EOP_LAST_FENCE_LO                                   0x008410 /* <= gfx6 */
#define R_008414_CP_EOP_LAST_FENCE_HI                                   0x008414 /* <= gfx6 */
#define R_008418_CP_STREAM_OUT_ADDR_LO                                  0x008418 /* <= gfx6 */
#define   S_008418_STREAM_OUT_ADDR_SWAP(x)                            (((unsigned)(x) & 0x3) << 0)
#define   G_008418_STREAM_OUT_ADDR_SWAP(x)                            (((x) >> 0) & 0x3)
#define   C_008418_STREAM_OUT_ADDR_SWAP                               0xFFFFFFFC
#define   S_008418_STREAM_OUT_ADDR_LO(x)                              (((unsigned)(x) & 0x3FFFFFFF) << 2)
#define   G_008418_STREAM_OUT_ADDR_LO(x)                              (((x) >> 2) & 0x3FFFFFFF)
#define   C_008418_STREAM_OUT_ADDR_LO                                 0x00000003
#define R_00841C_CP_STREAM_OUT_ADDR_HI                                  0x00841C /* <= gfx6 */
#define R_008420_CP_NUM_PRIM_WRITTEN_COUNT0_LO                          0x008420 /* <= gfx6 */
#define R_008424_CP_NUM_PRIM_WRITTEN_COUNT0_HI                          0x008424 /* <= gfx6 */
#define R_008428_CP_NUM_PRIM_NEEDED_COUNT0_LO                           0x008428 /* <= gfx6 */
#define R_00842C_CP_NUM_PRIM_NEEDED_COUNT0_HI                           0x00842C /* <= gfx6 */
#define R_008430_CP_NUM_PRIM_WRITTEN_COUNT1_LO                          0x008430 /* <= gfx6 */
#define R_008434_CP_NUM_PRIM_WRITTEN_COUNT1_HI                          0x008434 /* <= gfx6 */
#define R_008438_CP_NUM_PRIM_NEEDED_COUNT1_LO                           0x008438 /* <= gfx6 */
#define R_00843C_CP_NUM_PRIM_NEEDED_COUNT1_HI                           0x00843C /* <= gfx6 */
#define R_008440_CP_NUM_PRIM_WRITTEN_COUNT2_LO                          0x008440 /* <= gfx6 */
#define R_008444_CP_NUM_PRIM_WRITTEN_COUNT2_HI                          0x008444 /* <= gfx6 */
#define R_008448_CP_NUM_PRIM_NEEDED_COUNT2_LO                           0x008448 /* <= gfx6 */
#define R_00844C_CP_NUM_PRIM_NEEDED_COUNT2_HI                           0x00844C /* <= gfx6 */
#define R_008450_CP_NUM_PRIM_WRITTEN_COUNT3_LO                          0x008450 /* <= gfx6 */
#define R_008454_CP_NUM_PRIM_WRITTEN_COUNT3_HI                          0x008454 /* <= gfx6 */
#define R_008458_CP_NUM_PRIM_NEEDED_COUNT3_LO                           0x008458 /* <= gfx6 */
#define R_00845C_CP_NUM_PRIM_NEEDED_COUNT3_HI                           0x00845C /* <= gfx6 */
#define R_008460_CP_PIPE_STATS_ADDR_LO                                  0x008460 /* <= gfx6 */
#define   S_008460_PIPE_STATS_ADDR_SWAP(x)                            (((unsigned)(x) & 0x3) << 0)
#define   G_008460_PIPE_STATS_ADDR_SWAP(x)                            (((x) >> 0) & 0x3)
#define   C_008460_PIPE_STATS_ADDR_SWAP                               0xFFFFFFFC
#define   S_008460_PIPE_STATS_ADDR_LO(x)                              (((unsigned)(x) & 0x3FFFFFFF) << 2)
#define   G_008460_PIPE_STATS_ADDR_LO(x)                              (((x) >> 2) & 0x3FFFFFFF)
#define   C_008460_PIPE_STATS_ADDR_LO                                 0x00000003
#define R_008464_CP_PIPE_STATS_ADDR_HI                                  0x008464 /* <= gfx6 */
#define R_008468_CP_VGT_IAVERT_COUNT_LO                                 0x008468 /* <= gfx6 */
#define R_00846C_CP_VGT_IAVERT_COUNT_HI                                 0x00846C /* <= gfx6 */
#define R_008470_CP_VGT_IAPRIM_COUNT_LO                                 0x008470 /* <= gfx6 */
#define R_008474_CP_VGT_IAPRIM_COUNT_HI                                 0x008474 /* <= gfx6 */
#define R_008478_CP_VGT_GSPRIM_COUNT_LO                                 0x008478 /* <= gfx6 */
#define R_00847C_CP_VGT_GSPRIM_COUNT_HI                                 0x00847C /* <= gfx6 */
#define R_008480_CP_VGT_VSINVOC_COUNT_LO                                0x008480 /* <= gfx6 */
#define R_008484_CP_VGT_VSINVOC_COUNT_HI                                0x008484 /* <= gfx6 */
#define R_008488_CP_VGT_GSINVOC_COUNT_LO                                0x008488 /* <= gfx6 */
#define R_00848C_CP_VGT_GSINVOC_COUNT_HI                                0x00848C /* <= gfx6 */
#define R_008490_CP_VGT_HSINVOC_COUNT_LO                                0x008490 /* <= gfx6 */
#define R_008494_CP_VGT_HSINVOC_COUNT_HI                                0x008494 /* <= gfx6 */
#define R_008498_CP_VGT_DSINVOC_COUNT_LO                                0x008498 /* <= gfx6 */
#define R_00849C_CP_VGT_DSINVOC_COUNT_HI                                0x00849C /* <= gfx6 */
#define R_0084A0_CP_PA_CINVOC_COUNT_LO                                  0x0084A0 /* <= gfx6 */
#define R_0084A4_CP_PA_CINVOC_COUNT_HI                                  0x0084A4 /* <= gfx6 */
#define R_0084A8_CP_PA_CPRIM_COUNT_LO                                   0x0084A8 /* <= gfx6 */
#define R_0084AC_CP_PA_CPRIM_COUNT_HI                                   0x0084AC /* <= gfx6 */
#define R_0084B0_CP_SC_PSINVOC_COUNT0_LO                                0x0084B0 /* <= gfx6 */
#define R_0084B4_CP_SC_PSINVOC_COUNT0_HI                                0x0084B4 /* <= gfx6 */
#define R_0084B8_CP_SC_PSINVOC_COUNT1_LO                                0x0084B8 /* <= gfx6 */
#define R_0084BC_CP_SC_PSINVOC_COUNT1_HI                                0x0084BC /* <= gfx6 */
#define R_0084C0_CP_VGT_CSINVOC_COUNT_LO                                0x0084C0 /* <= gfx6 */
#define R_0084C4_CP_VGT_CSINVOC_COUNT_HI                                0x0084C4 /* <= gfx6 */
#define R_0084FC_CP_STRMOUT_CNTL                                        0x0084FC /* <= gfx6 */
#define   S_0084FC_OFFSET_UPDATE_DONE(x)                              (((unsigned)(x) & 0x1) << 0)
#define   G_0084FC_OFFSET_UPDATE_DONE(x)                              (((x) >> 0) & 0x1)
#define   C_0084FC_OFFSET_UPDATE_DONE                                 0xFFFFFFFE
#define R_008500_SCRATCH_REG0                                           0x008500 /* <= gfx6 */
#define R_008504_SCRATCH_REG1                                           0x008504 /* <= gfx6 */
#define R_008508_SCRATCH_REG2                                           0x008508 /* <= gfx6 */
#define R_00850C_SCRATCH_REG3                                           0x00850C /* <= gfx6 */
#define R_008510_SCRATCH_REG4                                           0x008510 /* <= gfx6 */
#define R_008514_SCRATCH_REG5                                           0x008514 /* <= gfx6 */
#define R_008518_SCRATCH_REG6                                           0x008518 /* <= gfx6 */
#define R_00851C_SCRATCH_REG7                                           0x00851C /* <= gfx6 */
#define R_008540_SCRATCH_UMSK                                           0x008540 /* <= gfx6 */
#define   S_008540_OBSOLETE_UMSK(x)                                   (((unsigned)(x) & 0xFF) << 0)
#define   G_008540_OBSOLETE_UMSK(x)                                   (((x) >> 0) & 0xFF)
#define   C_008540_OBSOLETE_UMSK                                      0xFFFFFF00
#define   S_008540_OBSOLETE_SWAP(x)                                   (((unsigned)(x) & 0x3) << 16)
#define   G_008540_OBSOLETE_SWAP(x)                                   (((x) >> 16) & 0x3)
#define   C_008540_OBSOLETE_SWAP                                      0xFFFCFFFF
#define R_008544_SCRATCH_ADDR                                           0x008544 /* <= gfx6 */
#define R_008560_CP_APPEND_ADDR_LO                                      0x008560 /* <= gfx6 */
#define   S_008560_MEM_ADDR_LO(x)                                     (((unsigned)(x) & 0x3FFFFFFF) << 2)
#define   G_008560_MEM_ADDR_LO(x)                                     (((x) >> 2) & 0x3FFFFFFF)
#define   C_008560_MEM_ADDR_LO                                        0x00000003
#define R_008564_CP_APPEND_ADDR_HI                                      0x008564 /* <= gfx6 */
#define   S_008564_MEM_ADDR_HI(x)                                     (((unsigned)(x) & 0xFF) << 0)
#define   G_008564_MEM_ADDR_HI(x)                                     (((x) >> 0) & 0xFF)
#define   C_008564_MEM_ADDR_HI                                        0xFFFFFF00
#define   S_008564_CS_PS_SEL(x)                                       (((unsigned)(x) & 0x3) << 16)
#define   G_008564_CS_PS_SEL(x)                                       (((x) >> 16) & 0x3)
#define   C_008564_CS_PS_SEL                                          0xFFFCFFFF
#define   S_008564_COMMAND(x)                                         (((unsigned)(x) & 0x7) << 29)
#define   G_008564_COMMAND(x)                                         (((x) >> 29) & 0x7)
#define   C_008564_COMMAND                                            0x1FFFFFFF
#define R_008568_CP_APPEND_DATA                                         0x008568 /* <= gfx6 */
#define R_00856C_CP_APPEND_LAST_CS_FENCE                                0x00856C /* <= gfx6 */
#define R_008570_CP_APPEND_LAST_PS_FENCE                                0x008570 /* <= gfx6 */
#define R_008574_CP_ATOMIC_PREOP_LO                                     0x008574 /* <= gfx6 */
#define R_008578_CP_ATOMIC_PREOP_HI                                     0x008578 /* <= gfx6 */
#define R_00857C_CP_GDS_ATOMIC0_PREOP_LO                                0x00857C /* <= gfx6 */
#define R_008580_CP_GDS_ATOMIC0_PREOP_HI                                0x008580 /* <= gfx6 */
#define R_008584_CP_GDS_ATOMIC1_PREOP_LO                                0x008584 /* <= gfx6 */
#define R_008588_CP_GDS_ATOMIC1_PREOP_HI                                0x008588 /* <= gfx6 */
#define R_0085A4_CP_ME_MC_WADDR_LO                                      0x0085A4 /* <= gfx6 */
#define   S_0085A4_ME_MC_WADDR_SWAP(x)                                (((unsigned)(x) & 0x3) << 0)
#define   G_0085A4_ME_MC_WADDR_SWAP(x)                                (((x) >> 0) & 0x3)
#define   C_0085A4_ME_MC_WADDR_SWAP                                   0xFFFFFFFC
#define   S_0085A4_ME_MC_WADDR_LO(x)                                  (((unsigned)(x) & 0x3FFFFFFF) << 2)
#define   G_0085A4_ME_MC_WADDR_LO(x)                                  (((x) >> 2) & 0x3FFFFFFF)
#define   C_0085A4_ME_MC_WADDR_LO                                     0x00000003
#define R_0085A8_CP_ME_MC_WADDR_HI                                      0x0085A8 /* <= gfx6 */
#define   S_0085A8_ME_MC_WADDR_HI(x)                                  (((unsigned)(x) & 0xFF) << 0)
#define   G_0085A8_ME_MC_WADDR_HI(x)                                  (((x) >> 0) & 0xFF)
#define   C_0085A8_ME_MC_WADDR_HI                                     0xFFFFFF00
#define R_0085AC_CP_ME_MC_WDATA_LO                                      0x0085AC /* <= gfx6 */
#define R_0085B0_CP_ME_MC_WDATA_HI                                      0x0085B0 /* <= gfx6 */
#define R_0085B4_CP_ME_MC_RADDR_LO                                      0x0085B4 /* <= gfx6 */
#define   S_0085B4_ME_MC_RADDR_SWAP(x)                                (((unsigned)(x) & 0x3) << 0)
#define   G_0085B4_ME_MC_RADDR_SWAP(x)                                (((x) >> 0) & 0x3)
#define   C_0085B4_ME_MC_RADDR_SWAP                                   0xFFFFFFFC
#define   S_0085B4_ME_MC_RADDR_LO(x)                                  (((unsigned)(x) & 0x3FFFFFFF) << 2)
#define   G_0085B4_ME_MC_RADDR_LO(x)                                  (((x) >> 2) & 0x3FFFFFFF)
#define   C_0085B4_ME_MC_RADDR_LO                                     0x00000003
#define R_0085B8_CP_ME_MC_RADDR_HI                                      0x0085B8 /* <= gfx6 */
#define   S_0085B8_ME_MC_RADDR_HI(x)                                  (((unsigned)(x) & 0xFF) << 0)
#define   G_0085B8_ME_MC_RADDR_HI(x)                                  (((x) >> 0) & 0xFF)
#define   C_0085B8_ME_MC_RADDR_HI                                     0xFFFFFF00
#define R_0085BC_CP_SEM_WAIT_TIMER                                      0x0085BC /* <= gfx6 */
#define R_0085C0_CP_SIG_SEM_ADDR_LO                                     0x0085C0 /* <= gfx6 */
#define   S_0085C0_SEM_ADDR_SWAP(x)                                   (((unsigned)(x) & 0x3) << 0)
#define   G_0085C0_SEM_ADDR_SWAP(x)                                   (((x) >> 0) & 0x3)
#define   C_0085C0_SEM_ADDR_SWAP                                      0xFFFFFFFC
#define   S_0085C0_SEM_ADDR_LO(x)                                     (((unsigned)(x) & 0x1FFFFFFF) << 3)
#define   G_0085C0_SEM_ADDR_LO(x)                                     (((x) >> 3) & 0x1FFFFFFF)
#define   C_0085C0_SEM_ADDR_LO                                        0x00000007
#define R_0085C4_CP_SIG_SEM_ADDR_HI                                     0x0085C4 /* <= gfx6 */
#define   S_0085C4_SEM_ADDR_HI(x)                                     (((unsigned)(x) & 0xFF) << 0)
#define   G_0085C4_SEM_ADDR_HI(x)                                     (((x) >> 0) & 0xFF)
#define   C_0085C4_SEM_ADDR_HI                                        0xFFFFFF00
#define   S_0085C4_SEM_USE_MAILBOX(x)                                 (((unsigned)(x) & 0x1) << 16)
#define   G_0085C4_SEM_USE_MAILBOX(x)                                 (((x) >> 16) & 0x1)
#define   C_0085C4_SEM_USE_MAILBOX                                    0xFFFEFFFF
#define   S_0085C4_SEM_SIGNAL_TYPE(x)                                 (((unsigned)(x) & 0x1) << 20)
#define   G_0085C4_SEM_SIGNAL_TYPE(x)                                 (((x) >> 20) & 0x1)
#define   C_0085C4_SEM_SIGNAL_TYPE                                    0xFFEFFFFF
#define   S_0085C4_SEM_CLIENT_CODE(x)                                 (((unsigned)(x) & 0x3) << 24)
#define   G_0085C4_SEM_CLIENT_CODE(x)                                 (((x) >> 24) & 0x3)
#define   C_0085C4_SEM_CLIENT_CODE                                    0xFCFFFFFF
#define   S_0085C4_SEM_SELECT(x)                                      (((unsigned)(x) & 0x7) << 29)
#define   G_0085C4_SEM_SELECT(x)                                      (((x) >> 29) & 0x7)
#define   C_0085C4_SEM_SELECT                                         0x1FFFFFFF
#define R_0085D0_CP_WAIT_REG_MEM_TIMEOUT                                0x0085D0 /* <= gfx6 */
#define R_0085D4_CP_WAIT_SEM_ADDR_LO                                    0x0085D4 /* <= gfx6 */
#define   S_0085D4_SEM_ADDR_SWAP(x)                                   (((unsigned)(x) & 0x3) << 0)
#define   G_0085D4_SEM_ADDR_SWAP(x)                                   (((x) >> 0) & 0x3)
#define   C_0085D4_SEM_ADDR_SWAP                                      0xFFFFFFFC
#define   S_0085D4_SEM_ADDR_LO(x)                                     (((unsigned)(x) & 0x1FFFFFFF) << 3)
#define   G_0085D4_SEM_ADDR_LO(x)                                     (((x) >> 3) & 0x1FFFFFFF)
#define   C_0085D4_SEM_ADDR_LO                                        0x00000007
#define R_0085D8_CP_WAIT_SEM_ADDR_HI                                    0x0085D8 /* <= gfx6 */
#define   S_0085D8_SEM_ADDR_HI(x)                                     (((unsigned)(x) & 0xFF) << 0)
#define   G_0085D8_SEM_ADDR_HI(x)                                     (((x) >> 0) & 0xFF)
#define   C_0085D8_SEM_ADDR_HI                                        0xFFFFFF00
#define   S_0085D8_SEM_USE_MAILBOX(x)                                 (((unsigned)(x) & 0x1) << 16)
#define   G_0085D8_SEM_USE_MAILBOX(x)                                 (((x) >> 16) & 0x1)
#define   C_0085D8_SEM_USE_MAILBOX                                    0xFFFEFFFF
#define   S_0085D8_SEM_SIGNAL_TYPE(x)                                 (((unsigned)(x) & 0x1) << 20)
#define   G_0085D8_SEM_SIGNAL_TYPE(x)                                 (((x) >> 20) & 0x1)
#define   C_0085D8_SEM_SIGNAL_TYPE                                    0xFFEFFFFF
#define   S_0085D8_SEM_CLIENT_CODE(x)                                 (((unsigned)(x) & 0x3) << 24)
#define   G_0085D8_SEM_CLIENT_CODE(x)                                 (((x) >> 24) & 0x3)
#define   C_0085D8_SEM_CLIENT_CODE                                    0xFCFFFFFF
#define   S_0085D8_SEM_SELECT(x)                                      (((unsigned)(x) & 0x7) << 29)
#define   G_0085D8_SEM_SELECT(x)                                      (((x) >> 29) & 0x7)
#define   C_0085D8_SEM_SELECT                                         0x1FFFFFFF
#define R_0085EC_CP_COHER_START_DELAY                                   0x0085EC /* <= gfx6 */
#define   S_0085EC_START_DELAY_COUNT(x)                               (((unsigned)(x) & 0x3F) << 0)
#define   G_0085EC_START_DELAY_COUNT(x)                               (((x) >> 0) & 0x3F)
#define   C_0085EC_START_DELAY_COUNT                                  0xFFFFFFC0
#define R_0085F0_CP_COHER_CNTL                                          0x0085F0 /* <= gfx6 */
#define   S_0085F0_DEST_BASE_0_ENA(x)                                 (((unsigned)(x) & 0x1) << 0)
#define   G_0085F0_DEST_BASE_0_ENA(x)                                 (((x) >> 0) & 0x1)
#define   C_0085F0_DEST_BASE_0_ENA                                    0xFFFFFFFE
#define   S_0085F0_DEST_BASE_1_ENA(x)                                 (((unsigned)(x) & 0x1) << 1)
#define   G_0085F0_DEST_BASE_1_ENA(x)                                 (((x) >> 1) & 0x1)
#define   C_0085F0_DEST_BASE_1_ENA                                    0xFFFFFFFD
#define   S_0085F0_CB0_DEST_BASE_ENA(x)                               (((unsigned)(x) & 0x1) << 6)
#define   G_0085F0_CB0_DEST_BASE_ENA(x)                               (((x) >> 6) & 0x1)
#define   C_0085F0_CB0_DEST_BASE_ENA                                  0xFFFFFFBF
#define   S_0085F0_CB1_DEST_BASE_ENA(x)                               (((unsigned)(x) & 0x1) << 7)
#define   G_0085F0_CB1_DEST_BASE_ENA(x)                               (((x) >> 7) & 0x1)
#define   C_0085F0_CB1_DEST_BASE_ENA                                  0xFFFFFF7F
#define   S_0085F0_CB2_DEST_BASE_ENA(x)                               (((unsigned)(x) & 0x1) << 8)
#define   G_0085F0_CB2_DEST_BASE_ENA(x)                               (((x) >> 8) & 0x1)
#define   C_0085F0_CB2_DEST_BASE_ENA                                  0xFFFFFEFF
#define   S_0085F0_CB3_DEST_BASE_ENA(x)                               (((unsigned)(x) & 0x1) << 9)
#define   G_0085F0_CB3_DEST_BASE_ENA(x)                               (((x) >> 9) & 0x1)
#define   C_0085F0_CB3_DEST_BASE_ENA                                  0xFFFFFDFF
#define   S_0085F0_CB4_DEST_BASE_ENA(x)                               (((unsigned)(x) & 0x1) << 10)
#define   G_0085F0_CB4_DEST_BASE_ENA(x)                               (((x) >> 10) & 0x1)
#define   C_0085F0_CB4_DEST_BASE_ENA                                  0xFFFFFBFF
#define   S_0085F0_CB5_DEST_BASE_ENA(x)                               (((unsigned)(x) & 0x1) << 11)
#define   G_0085F0_CB5_DEST_BASE_ENA(x)                               (((x) >> 11) & 0x1)
#define   C_0085F0_CB5_DEST_BASE_ENA                                  0xFFFFF7FF
#define   S_0085F0_CB6_DEST_BASE_ENA(x)                               (((unsigned)(x) & 0x1) << 12)
#define   G_0085F0_CB6_DEST_BASE_ENA(x)                               (((x) >> 12) & 0x1)
#define   C_0085F0_CB6_DEST_BASE_ENA                                  0xFFFFEFFF
#define   S_0085F0_CB7_DEST_BASE_ENA(x)                               (((unsigned)(x) & 0x1) << 13)
#define   G_0085F0_CB7_DEST_BASE_ENA(x)                               (((x) >> 13) & 0x1)
#define   C_0085F0_CB7_DEST_BASE_ENA                                  0xFFFFDFFF
#define   S_0085F0_DB_DEST_BASE_ENA(x)                                (((unsigned)(x) & 0x1) << 14)
#define   G_0085F0_DB_DEST_BASE_ENA(x)                                (((x) >> 14) & 0x1)
#define   C_0085F0_DB_DEST_BASE_ENA                                   0xFFFFBFFF
#define   S_0085F0_TCL1_VOL_ACTION_ENA(x)                             (((unsigned)(x) & 0x1) << 15)
#define   G_0085F0_TCL1_VOL_ACTION_ENA(x)                             (((x) >> 15) & 0x1)
#define   C_0085F0_TCL1_VOL_ACTION_ENA                                0xFFFF7FFF
#define   S_0085F0_TC_VOL_ACTION_ENA(x)                               (((unsigned)(x) & 0x1) << 16)
#define   G_0085F0_TC_VOL_ACTION_ENA(x)                               (((x) >> 16) & 0x1)
#define   C_0085F0_TC_VOL_ACTION_ENA                                  0xFFFEFFFF
#define   S_0085F0_TC_WB_ACTION_ENA(x)                                (((unsigned)(x) & 0x1) << 18)
#define   G_0085F0_TC_WB_ACTION_ENA(x)                                (((x) >> 18) & 0x1)
#define   C_0085F0_TC_WB_ACTION_ENA                                   0xFFFBFFFF
#define   S_0085F0_DEST_BASE_2_ENA(x)                                 (((unsigned)(x) & 0x1) << 19)
#define   G_0085F0_DEST_BASE_2_ENA(x)                                 (((x) >> 19) & 0x1)
#define   C_0085F0_DEST_BASE_2_ENA                                    0xFFF7FFFF
#define   S_0085F0_DEST_BASE_3_ENA(x)                                 (((unsigned)(x) & 0x1) << 21)
#define   G_0085F0_DEST_BASE_3_ENA(x)                                 (((x) >> 21) & 0x1)
#define   C_0085F0_DEST_BASE_3_ENA                                    0xFFDFFFFF
#define   S_0085F0_TCL1_ACTION_ENA(x)                                 (((unsigned)(x) & 0x1) << 22)
#define   G_0085F0_TCL1_ACTION_ENA(x)                                 (((x) >> 22) & 0x1)
#define   C_0085F0_TCL1_ACTION_ENA                                    0xFFBFFFFF
#define   S_0085F0_TC_ACTION_ENA(x)                                   (((unsigned)(x) & 0x1) << 23)
#define   G_0085F0_TC_ACTION_ENA(x)                                   (((x) >> 23) & 0x1)
#define   C_0085F0_TC_ACTION_ENA                                      0xFF7FFFFF
#define   S_0085F0_CB_ACTION_ENA(x)                                   (((unsigned)(x) & 0x1) << 25)
#define   G_0085F0_CB_ACTION_ENA(x)                                   (((x) >> 25) & 0x1)
#define   C_0085F0_CB_ACTION_ENA                                      0xFDFFFFFF
#define   S_0085F0_DB_ACTION_ENA(x)                                   (((unsigned)(x) & 0x1) << 26)
#define   G_0085F0_DB_ACTION_ENA(x)                                   (((x) >> 26) & 0x1)
#define   C_0085F0_DB_ACTION_ENA                                      0xFBFFFFFF
#define   S_0085F0_SH_KCACHE_ACTION_ENA(x)                            (((unsigned)(x) & 0x1) << 27)
#define   G_0085F0_SH_KCACHE_ACTION_ENA(x)                            (((x) >> 27) & 0x1)
#define   C_0085F0_SH_KCACHE_ACTION_ENA                               0xF7FFFFFF
#define   S_0085F0_SH_KCACHE_VOL_ACTION_ENA(x)                        (((unsigned)(x) & 0x1) << 28)
#define   G_0085F0_SH_KCACHE_VOL_ACTION_ENA(x)                        (((x) >> 28) & 0x1)
#define   C_0085F0_SH_KCACHE_VOL_ACTION_ENA                           0xEFFFFFFF
#define   S_0085F0_SH_ICACHE_ACTION_ENA(x)                            (((unsigned)(x) & 0x1) << 29)
#define   G_0085F0_SH_ICACHE_ACTION_ENA(x)                            (((x) >> 29) & 0x1)
#define   C_0085F0_SH_ICACHE_ACTION_ENA                               0xDFFFFFFF
#define R_0085F4_CP_COHER_SIZE                                          0x0085F4 /* <= gfx6 */
#define R_0085F8_CP_COHER_BASE                                          0x0085F8 /* <= gfx6 */
#define R_0085FC_CP_COHER_STATUS                                        0x0085FC /* <= gfx6 */
#define   S_0085FC_MATCHING_GFX_CNTX(x)                               (((unsigned)(x) & 0xFF) << 0)
#define   G_0085FC_MATCHING_GFX_CNTX(x)                               (((x) >> 0) & 0xFF)
#define   C_0085FC_MATCHING_GFX_CNTX                                  0xFFFFFF00
#define   S_0085FC_MEID(x)                                            (((unsigned)(x) & 0x3) << 24)
#define   G_0085FC_MEID(x)                                            (((x) >> 24) & 0x3)
#define   C_0085FC_MEID                                               0xFCFFFFFF
#define   S_0085FC_PHASE1_STATUS(x)                                   (((unsigned)(x) & 0x1) << 30)
#define   G_0085FC_PHASE1_STATUS(x)                                   (((x) >> 30) & 0x1)
#define   C_0085FC_PHASE1_STATUS                                      0xBFFFFFFF
#define   S_0085FC_STATUS(x)                                          (((unsigned)(x) & 0x1) << 31)
#define   G_0085FC_STATUS(x)                                          (((x) >> 31) & 0x1)
#define   C_0085FC_STATUS                                             0x7FFFFFFF
#define R_008600_CP_DMA_ME_SRC_ADDR                                     0x008600 /* <= gfx6 */
#define R_008604_CP_DMA_ME_SRC_ADDR_HI                                  0x008604 /* <= gfx6 */
#define   S_008604_SRC_ADDR_HI(x)                                     (((unsigned)(x) & 0xFF) << 0)
#define   G_008604_SRC_ADDR_HI(x)                                     (((x) >> 0) & 0xFF)
#define   C_008604_SRC_ADDR_HI                                        0xFFFFFF00
#define R_008608_CP_DMA_ME_DST_ADDR                                     0x008608 /* <= gfx6 */
#define R_00860C_CP_DMA_ME_DST_ADDR_HI                                  0x00860C /* <= gfx6 */
#define   S_00860C_DST_ADDR_HI(x)                                     (((unsigned)(x) & 0xFF) << 0)
#define   G_00860C_DST_ADDR_HI(x)                                     (((x) >> 0) & 0xFF)
#define   C_00860C_DST_ADDR_HI                                        0xFFFFFF00
#define R_008610_CP_DMA_ME_COMMAND                                      0x008610 /* <= gfx6 */
#define   S_008610_BYTE_COUNT(x)                                      (((unsigned)(x) & 0x1FFFFF) << 0)
#define   G_008610_BYTE_COUNT(x)                                      (((x) >> 0) & 0x1FFFFF)
#define   C_008610_BYTE_COUNT                                         0xFFE00000
#define   S_008610_DIS_WC(x)                                          (((unsigned)(x) & 0x1) << 21)
#define   G_008610_DIS_WC(x)                                          (((x) >> 21) & 0x1)
#define   C_008610_DIS_WC                                             0xFFDFFFFF
#define   S_008610_SRC_SWAP(x)                                        (((unsigned)(x) & 0x3) << 22)
#define   G_008610_SRC_SWAP(x)                                        (((x) >> 22) & 0x3)
#define   C_008610_SRC_SWAP                                           0xFF3FFFFF
#define   S_008610_DST_SWAP(x)                                        (((unsigned)(x) & 0x3) << 24)
#define   G_008610_DST_SWAP(x)                                        (((x) >> 24) & 0x3)
#define   C_008610_DST_SWAP                                           0xFCFFFFFF
#define   S_008610_SAS(x)                                             (((unsigned)(x) & 0x1) << 26)
#define   G_008610_SAS(x)                                             (((x) >> 26) & 0x1)
#define   C_008610_SAS                                                0xFBFFFFFF
#define   S_008610_DAS(x)                                             (((unsigned)(x) & 0x1) << 27)
#define   G_008610_DAS(x)                                             (((x) >> 27) & 0x1)
#define   C_008610_DAS                                                0xF7FFFFFF
#define   S_008610_SAIC(x)                                            (((unsigned)(x) & 0x1) << 28)
#define   G_008610_SAIC(x)                                            (((x) >> 28) & 0x1)
#define   C_008610_SAIC                                               0xEFFFFFFF
#define   S_008610_DAIC(x)                                            (((unsigned)(x) & 0x1) << 29)
#define   G_008610_DAIC(x)                                            (((x) >> 29) & 0x1)
#define   C_008610_DAIC                                               0xDFFFFFFF
#define   S_008610_RAW_WAIT(x)                                        (((unsigned)(x) & 0x1) << 30)
#define   G_008610_RAW_WAIT(x)                                        (((x) >> 30) & 0x1)
#define   C_008610_RAW_WAIT                                           0xBFFFFFFF
#define R_008614_CP_DMA_PFP_SRC_ADDR                                    0x008614 /* <= gfx6 */
#define R_008618_CP_DMA_PFP_SRC_ADDR_HI                                 0x008618 /* <= gfx6 */
#define   S_008618_SRC_ADDR_HI(x)                                     (((unsigned)(x) & 0xFF) << 0)
#define   G_008618_SRC_ADDR_HI(x)                                     (((x) >> 0) & 0xFF)
#define   C_008618_SRC_ADDR_HI                                        0xFFFFFF00
#define R_00861C_CP_DMA_PFP_DST_ADDR                                    0x00861C /* <= gfx6 */
#define R_008620_CP_DMA_PFP_DST_ADDR_HI                                 0x008620 /* <= gfx6 */
#define   S_008620_DST_ADDR_HI(x)                                     (((unsigned)(x) & 0xFF) << 0)
#define   G_008620_DST_ADDR_HI(x)                                     (((x) >> 0) & 0xFF)
#define   C_008620_DST_ADDR_HI                                        0xFFFFFF00
#define R_008624_CP_DMA_PFP_COMMAND                                     0x008624 /* <= gfx6 */
#define   S_008624_BYTE_COUNT(x)                                      (((unsigned)(x) & 0x1FFFFF) << 0)
#define   G_008624_BYTE_COUNT(x)                                      (((x) >> 0) & 0x1FFFFF)
#define   C_008624_BYTE_COUNT                                         0xFFE00000
#define   S_008624_DIS_WC(x)                                          (((unsigned)(x) & 0x1) << 21)
#define   G_008624_DIS_WC(x)                                          (((x) >> 21) & 0x1)
#define   C_008624_DIS_WC                                             0xFFDFFFFF
#define   S_008624_SRC_SWAP(x)                                        (((unsigned)(x) & 0x3) << 22)
#define   G_008624_SRC_SWAP(x)                                        (((x) >> 22) & 0x3)
#define   C_008624_SRC_SWAP                                           0xFF3FFFFF
#define   S_008624_DST_SWAP(x)                                        (((unsigned)(x) & 0x3) << 24)
#define   G_008624_DST_SWAP(x)                                        (((x) >> 24) & 0x3)
#define   C_008624_DST_SWAP                                           0xFCFFFFFF
#define   S_008624_SAS(x)                                             (((unsigned)(x) & 0x1) << 26)
#define   G_008624_SAS(x)                                             (((x) >> 26) & 0x1)
#define   C_008624_SAS                                                0xFBFFFFFF
#define   S_008624_DAS(x)                                             (((unsigned)(x) & 0x1) << 27)
#define   G_008624_DAS(x)                                             (((x) >> 27) & 0x1)
#define   C_008624_DAS                                                0xF7FFFFFF
#define   S_008624_SAIC(x)                                            (((unsigned)(x) & 0x1) << 28)
#define   G_008624_SAIC(x)                                            (((x) >> 28) & 0x1)
#define   C_008624_SAIC                                               0xEFFFFFFF
#define   S_008624_DAIC(x)                                            (((unsigned)(x) & 0x1) << 29)
#define   G_008624_DAIC(x)                                            (((x) >> 29) & 0x1)
#define   C_008624_DAIC                                               0xDFFFFFFF
#define   S_008624_RAW_WAIT(x)                                        (((unsigned)(x) & 0x1) << 30)
#define   G_008624_RAW_WAIT(x)                                        (((x) >> 30) & 0x1)
#define   C_008624_RAW_WAIT                                           0xBFFFFFFF
#define R_008628_CP_DMA_CNTL                                            0x008628 /* <= gfx6 */
#define   S_008628_MIN_AVAILSZ(x)                                     (((unsigned)(x) & 0x3) << 4)
#define   G_008628_MIN_AVAILSZ(x)                                     (((x) >> 4) & 0x3)
#define   C_008628_MIN_AVAILSZ                                        0xFFFFFFCF
#define   S_008628_BUFFER_DEPTH(x)                                    (((unsigned)(x) & 0xF) << 16)
#define   G_008628_BUFFER_DEPTH(x)                                    (((x) >> 16) & 0xF)
#define   C_008628_BUFFER_DEPTH                                       0xFFF0FFFF
#define   S_008628_PIO_FIFO_EMPTY(x)                                  (((unsigned)(x) & 0x1) << 28)
#define   G_008628_PIO_FIFO_EMPTY(x)                                  (((x) >> 28) & 0x1)
#define   C_008628_PIO_FIFO_EMPTY                                     0xEFFFFFFF
#define   S_008628_PIO_FIFO_FULL(x)                                   (((unsigned)(x) & 0x1) << 29)
#define   G_008628_PIO_FIFO_FULL(x)                                   (((x) >> 29) & 0x1)
#define   C_008628_PIO_FIFO_FULL                                      0xDFFFFFFF
#define   S_008628_PIO_COUNT(x)                                       (((unsigned)(x) & 0x3) << 30)
#define   G_008628_PIO_COUNT(x)                                       (((x) >> 30) & 0x3)
#define   C_008628_PIO_COUNT                                          0x3FFFFFFF
#define R_00862C_CP_DMA_READ_TAGS                                       0x00862C /* <= gfx6 */
#define   S_00862C_DMA_READ_TAG(x)                                    (((unsigned)(x) & 0x3FFFFFF) << 0)
#define   G_00862C_DMA_READ_TAG(x)                                    (((x) >> 0) & 0x3FFFFFF)
#define   C_00862C_DMA_READ_TAG                                       0xFC000000
#define   S_00862C_DMA_READ_TAG_VALID(x)                              (((unsigned)(x) & 0x1) << 28)
#define   G_00862C_DMA_READ_TAG_VALID(x)                              (((x) >> 28) & 0x1)
#define   C_00862C_DMA_READ_TAG_VALID                                 0xEFFFFFFF
#define R_008634_CP_PFP_IB_CONTROL                                      0x008634 /* <= gfx6 */
#define   S_008634_IB_EN(x)                                           (((unsigned)(x) & 0x1) << 0)
#define   G_008634_IB_EN(x)                                           (((x) >> 0) & 0x1)
#define   C_008634_IB_EN                                              0xFFFFFFFE
#define R_008638_CP_PFP_LOAD_CONTROL                                    0x008638 /* <= gfx6 */
#define   S_008638_CONFIG_REG_EN(x)                                   (((unsigned)(x) & 0x1) << 0)
#define   G_008638_CONFIG_REG_EN(x)                                   (((x) >> 0) & 0x1)
#define   C_008638_CONFIG_REG_EN                                      0xFFFFFFFE
#define   S_008638_CNTX_REG_EN(x)                                     (((unsigned)(x) & 0x1) << 1)
#define   G_008638_CNTX_REG_EN(x)                                     (((x) >> 1) & 0x1)
#define   C_008638_CNTX_REG_EN                                        0xFFFFFFFD
#define   S_008638_UCONFIG_REG_EN(x)                                  (((unsigned)(x) & 0x1) << 15)
#define   G_008638_UCONFIG_REG_EN(x)                                  (((x) >> 15) & 0x1)
#define   C_008638_UCONFIG_REG_EN                                     0xFFFF7FFF
#define   S_008638_SH_GFX_REG_EN(x)                                   (((unsigned)(x) & 0x1) << 16)
#define   G_008638_SH_GFX_REG_EN(x)                                   (((x) >> 16) & 0x1)
#define   C_008638_SH_GFX_REG_EN                                      0xFFFEFFFF
#define   S_008638_SH_CS_REG_EN(x)                                    (((unsigned)(x) & 0x1) << 24)
#define   G_008638_SH_CS_REG_EN(x)                                    (((x) >> 24) & 0x1)
#define   C_008638_SH_CS_REG_EN                                       0xFEFFFFFF
#define R_00863C_CP_SCRATCH_INDEX                                       0x00863C /* <= gfx6 */
#define   S_00863C_SCRATCH_INDEX(x)                                   (((unsigned)(x) & 0xFF) << 0)
#define   G_00863C_SCRATCH_INDEX(x)                                   (((x) >> 0) & 0xFF)
#define   C_00863C_SCRATCH_INDEX                                      0xFFFFFF00
#define R_008640_CP_SCRATCH_DATA                                        0x008640 /* <= gfx6 */
#define R_008644_CP_RB_OFFSET                                           0x008644 /* <= gfx6 */
#define   S_008644_RB_OFFSET(x)                                       (((unsigned)(x) & 0xFFFFF) << 0)
#define   G_008644_RB_OFFSET(x)                                       (((x) >> 0) & 0xFFFFF)
#define   C_008644_RB_OFFSET                                          0xFFF00000
#define R_008648_CP_IB1_OFFSET                                          0x008648 /* <= gfx6 */
#define   S_008648_IB1_OFFSET(x)                                      (((unsigned)(x) & 0xFFFFF) << 0)
#define   G_008648_IB1_OFFSET(x)                                      (((x) >> 0) & 0xFFFFF)
#define   C_008648_IB1_OFFSET                                         0xFFF00000
#define R_00864C_CP_IB2_OFFSET                                          0x00864C /* <= gfx6 */
#define   S_00864C_IB2_OFFSET(x)                                      (((unsigned)(x) & 0xFFFFF) << 0)
#define   G_00864C_IB2_OFFSET(x)                                      (((x) >> 0) & 0xFFFFF)
#define   C_00864C_IB2_OFFSET                                         0xFFF00000
#define R_008650_CP_IB1_PREAMBLE_BEGIN                                  0x008650 /* <= gfx6 */
#define   S_008650_IB1_PREAMBLE_BEGIN(x)                              (((unsigned)(x) & 0xFFFFF) << 0)
#define   G_008650_IB1_PREAMBLE_BEGIN(x)                              (((x) >> 0) & 0xFFFFF)
#define   C_008650_IB1_PREAMBLE_BEGIN                                 0xFFF00000
#define R_008654_CP_IB1_PREAMBLE_END                                    0x008654 /* <= gfx6 */
#define   S_008654_IB1_PREAMBLE_END(x)                                (((unsigned)(x) & 0xFFFFF) << 0)
#define   G_008654_IB1_PREAMBLE_END(x)                                (((x) >> 0) & 0xFFFFF)
#define   C_008654_IB1_PREAMBLE_END                                   0xFFF00000
#define R_008658_CP_IB2_PREAMBLE_BEGIN                                  0x008658 /* <= gfx6 */
#define   S_008658_IB2_PREAMBLE_BEGIN(x)                              (((unsigned)(x) & 0xFFFFF) << 0)
#define   G_008658_IB2_PREAMBLE_BEGIN(x)                              (((x) >> 0) & 0xFFFFF)
#define   C_008658_IB2_PREAMBLE_BEGIN                                 0xFFF00000
#define R_00865C_CP_IB2_PREAMBLE_END                                    0x00865C /* <= gfx6 */
#define   S_00865C_IB2_PREAMBLE_END(x)                                (((unsigned)(x) & 0xFFFFF) << 0)
#define   G_00865C_IB2_PREAMBLE_END(x)                                (((x) >> 0) & 0xFFFFF)
#define   C_00865C_IB2_PREAMBLE_END                                   0xFFF00000
#define R_008670_CP_STALLED_STAT3                                       0x008670 /* <= gfx6 */
#define   S_008670_CE_TO_CSF_NOT_RDY_TO_RCV(x)                        (((unsigned)(x) & 0x1) << 0)
#define   G_008670_CE_TO_CSF_NOT_RDY_TO_RCV(x)                        (((x) >> 0) & 0x1)
#define   C_008670_CE_TO_CSF_NOT_RDY_TO_RCV                           0xFFFFFFFE
#define   S_008670_CE_TO_RAM_INIT_FETCHER_NOT_RDY_TO_RCV(x)           (((unsigned)(x) & 0x1) << 1)
#define   G_008670_CE_TO_RAM_INIT_FETCHER_NOT_RDY_TO_RCV(x)           (((x) >> 1) & 0x1)
#define   C_008670_CE_TO_RAM_INIT_FETCHER_NOT_RDY_TO_RCV              0xFFFFFFFD
#define   S_008670_CE_WAITING_ON_DATA_FROM_RAM_INIT_FETCHER(x)        (((unsigned)(x) & 0x1) << 2)
#define   G_008670_CE_WAITING_ON_DATA_FROM_RAM_INIT_FETCHER(x)        (((x) >> 2) & 0x1)
#define   C_008670_CE_WAITING_ON_DATA_FROM_RAM_INIT_FETCHER           0xFFFFFFFB
#define   S_008670_CE_TO_RAM_INIT_NOT_RDY(x)                          (((unsigned)(x) & 0x1) << 3)
#define   G_008670_CE_TO_RAM_INIT_NOT_RDY(x)                          (((x) >> 3) & 0x1)
#define   C_008670_CE_TO_RAM_INIT_NOT_RDY                             0xFFFFFFF7
#define   S_008670_CE_TO_RAM_DUMP_NOT_RDY(x)                          (((unsigned)(x) & 0x1) << 4)
#define   G_008670_CE_TO_RAM_DUMP_NOT_RDY(x)                          (((x) >> 4) & 0x1)
#define   C_008670_CE_TO_RAM_DUMP_NOT_RDY                             0xFFFFFFEF
#define   S_008670_CE_TO_RAM_WRITE_NOT_RDY(x)                         (((unsigned)(x) & 0x1) << 5)
#define   G_008670_CE_TO_RAM_WRITE_NOT_RDY(x)                         (((x) >> 5) & 0x1)
#define   C_008670_CE_TO_RAM_WRITE_NOT_RDY                            0xFFFFFFDF
#define   S_008670_CE_TO_INC_FIFO_NOT_RDY_TO_RCV(x)                   (((unsigned)(x) & 0x1) << 6)
#define   G_008670_CE_TO_INC_FIFO_NOT_RDY_TO_RCV(x)                   (((x) >> 6) & 0x1)
#define   C_008670_CE_TO_INC_FIFO_NOT_RDY_TO_RCV                      0xFFFFFFBF
#define   S_008670_CE_TO_WR_FIFO_NOT_RDY_TO_RCV(x)                    (((unsigned)(x) & 0x1) << 7)
#define   G_008670_CE_TO_WR_FIFO_NOT_RDY_TO_RCV(x)                    (((x) >> 7) & 0x1)
#define   C_008670_CE_TO_WR_FIFO_NOT_RDY_TO_RCV                       0xFFFFFF7F
#define   S_008670_CE_TO_MIU_WRITE_NOT_RDY_TO_RCV(x)                  (((unsigned)(x) & 0x1) << 8)
#define   G_008670_CE_TO_MIU_WRITE_NOT_RDY_TO_RCV(x)                  (((x) >> 8) & 0x1)
#define   C_008670_CE_TO_MIU_WRITE_NOT_RDY_TO_RCV                     0xFFFFFEFF
#define   S_008670_CE_WAITING_ON_BUFFER_DATA(x)                       (((unsigned)(x) & 0x1) << 10)
#define   G_008670_CE_WAITING_ON_BUFFER_DATA(x)                       (((x) >> 10) & 0x1)
#define   C_008670_CE_WAITING_ON_BUFFER_DATA                          0xFFFFFBFF
#define   S_008670_CE_WAITING_ON_CE_BUFFER_FLAG(x)                    (((unsigned)(x) & 0x1) << 11)
#define   G_008670_CE_WAITING_ON_CE_BUFFER_FLAG(x)                    (((x) >> 11) & 0x1)
#define   C_008670_CE_WAITING_ON_CE_BUFFER_FLAG                       0xFFFFF7FF
#define   S_008670_CE_WAITING_ON_DE_COUNTER(x)                        (((unsigned)(x) & 0x1) << 12)
#define   G_008670_CE_WAITING_ON_DE_COUNTER(x)                        (((x) >> 12) & 0x1)
#define   C_008670_CE_WAITING_ON_DE_COUNTER                           0xFFFFEFFF
#define   S_008670_CE_WAITING_ON_DE_COUNTER_UNDERFLOW(x)              (((unsigned)(x) & 0x1) << 13)
#define   G_008670_CE_WAITING_ON_DE_COUNTER_UNDERFLOW(x)              (((x) >> 13) & 0x1)
#define   C_008670_CE_WAITING_ON_DE_COUNTER_UNDERFLOW                 0xFFFFDFFF
#define   S_008670_TCIU_WAITING_ON_FREE(x)                            (((unsigned)(x) & 0x1) << 14)
#define   G_008670_TCIU_WAITING_ON_FREE(x)                            (((x) >> 14) & 0x1)
#define   C_008670_TCIU_WAITING_ON_FREE                               0xFFFFBFFF
#define   S_008670_TCIU_WAITING_ON_TAGS(x)                            (((unsigned)(x) & 0x1) << 15)
#define   G_008670_TCIU_WAITING_ON_TAGS(x)                            (((x) >> 15) & 0x1)
#define   C_008670_TCIU_WAITING_ON_TAGS                               0xFFFF7FFF
#define R_008674_CP_STALLED_STAT1                                       0x008674 /* <= gfx6 */
#define   S_008674_RBIU_TO_DMA_NOT_RDY_TO_RCV(x)                      (((unsigned)(x) & 0x1) << 0)
#define   G_008674_RBIU_TO_DMA_NOT_RDY_TO_RCV(x)                      (((x) >> 0) & 0x1)
#define   C_008674_RBIU_TO_DMA_NOT_RDY_TO_RCV                         0xFFFFFFFE
#define   S_008674_RBIU_TO_SEM_NOT_RDY_TO_RCV(x)                      (((unsigned)(x) & 0x1) << 2)
#define   G_008674_RBIU_TO_SEM_NOT_RDY_TO_RCV(x)                      (((x) >> 2) & 0x1)
#define   C_008674_RBIU_TO_SEM_NOT_RDY_TO_RCV                         0xFFFFFFFB
#define   S_008674_RBIU_TO_MEMWR_NOT_RDY_TO_RCV(x)                    (((unsigned)(x) & 0x1) << 4)
#define   G_008674_RBIU_TO_MEMWR_NOT_RDY_TO_RCV(x)                    (((x) >> 4) & 0x1)
#define   C_008674_RBIU_TO_MEMWR_NOT_RDY_TO_RCV                       0xFFFFFFEF
#define   S_008674_ME_HAS_ACTIVE_CE_BUFFER_FLAG(x)                    (((unsigned)(x) & 0x1) << 10)
#define   G_008674_ME_HAS_ACTIVE_CE_BUFFER_FLAG(x)                    (((x) >> 10) & 0x1)
#define   C_008674_ME_HAS_ACTIVE_CE_BUFFER_FLAG                       0xFFFFFBFF
#define   S_008674_ME_HAS_ACTIVE_DE_BUFFER_FLAG(x)                    (((unsigned)(x) & 0x1) << 11)
#define   G_008674_ME_HAS_ACTIVE_DE_BUFFER_FLAG(x)                    (((x) >> 11) & 0x1)
#define   C_008674_ME_HAS_ACTIVE_DE_BUFFER_FLAG                       0xFFFFF7FF
#define   S_008674_ME_STALLED_ON_TC_WR_CONFIRM(x)                     (((unsigned)(x) & 0x1) << 12)
#define   G_008674_ME_STALLED_ON_TC_WR_CONFIRM(x)                     (((x) >> 12) & 0x1)
#define   C_008674_ME_STALLED_ON_TC_WR_CONFIRM                        0xFFFFEFFF
#define   S_008674_ME_STALLED_ON_ATOMIC_RTN_DATA(x)                   (((unsigned)(x) & 0x1) << 13)
#define   G_008674_ME_STALLED_ON_ATOMIC_RTN_DATA(x)                   (((x) >> 13) & 0x1)
#define   C_008674_ME_STALLED_ON_ATOMIC_RTN_DATA                      0xFFFFDFFF
#define   S_008674_ME_WAITING_ON_MC_READ_DATA(x)                      (((unsigned)(x) & 0x1) << 14)
#define   G_008674_ME_WAITING_ON_MC_READ_DATA(x)                      (((x) >> 14) & 0x1)
#define   C_008674_ME_WAITING_ON_MC_READ_DATA                         0xFFFFBFFF
#define   S_008674_ME_WAITING_ON_REG_READ_DATA(x)                     (((unsigned)(x) & 0x1) << 15)
#define   G_008674_ME_WAITING_ON_REG_READ_DATA(x)                     (((x) >> 15) & 0x1)
#define   C_008674_ME_WAITING_ON_REG_READ_DATA                        0xFFFF7FFF
#define   S_008674_MIU_WAITING_ON_RDREQ_FREE(x)                       (((unsigned)(x) & 0x1) << 16)
#define   G_008674_MIU_WAITING_ON_RDREQ_FREE(x)                       (((x) >> 16) & 0x1)
#define   C_008674_MIU_WAITING_ON_RDREQ_FREE                          0xFFFEFFFF
#define   S_008674_MIU_WAITING_ON_WRREQ_FREE(x)                       (((unsigned)(x) & 0x1) << 17)
#define   G_008674_MIU_WAITING_ON_WRREQ_FREE(x)                       (((x) >> 17) & 0x1)
#define   C_008674_MIU_WAITING_ON_WRREQ_FREE                          0xFFFDFFFF
#define   S_008674_RCIU_WAITING_ON_GDS_FREE(x)                        (((unsigned)(x) & 0x1) << 23)
#define   G_008674_RCIU_WAITING_ON_GDS_FREE(x)                        (((x) >> 23) & 0x1)
#define   C_008674_RCIU_WAITING_ON_GDS_FREE                           0xFF7FFFFF
#define   S_008674_RCIU_WAITING_ON_GRBM_FREE(x)                       (((unsigned)(x) & 0x1) << 24)
#define   G_008674_RCIU_WAITING_ON_GRBM_FREE(x)                       (((x) >> 24) & 0x1)
#define   C_008674_RCIU_WAITING_ON_GRBM_FREE                          0xFEFFFFFF
#define   S_008674_RCIU_WAITING_ON_VGT_FREE(x)                        (((unsigned)(x) & 0x1) << 25)
#define   G_008674_RCIU_WAITING_ON_VGT_FREE(x)                        (((x) >> 25) & 0x1)
#define   C_008674_RCIU_WAITING_ON_VGT_FREE                           0xFDFFFFFF
#define   S_008674_RCIU_STALLED_ON_ME_READ(x)                         (((unsigned)(x) & 0x1) << 26)
#define   G_008674_RCIU_STALLED_ON_ME_READ(x)                         (((x) >> 26) & 0x1)
#define   C_008674_RCIU_STALLED_ON_ME_READ                            0xFBFFFFFF
#define   S_008674_RCIU_STALLED_ON_DMA_READ(x)                        (((unsigned)(x) & 0x1) << 27)
#define   G_008674_RCIU_STALLED_ON_DMA_READ(x)                        (((x) >> 27) & 0x1)
#define   C_008674_RCIU_STALLED_ON_DMA_READ                           0xF7FFFFFF
#define   S_008674_RCIU_HALTED_BY_REG_VIOLATION(x)                    (((unsigned)(x) & 0x1) << 28)
#define   G_008674_RCIU_HALTED_BY_REG_VIOLATION(x)                    (((x) >> 28) & 0x1)
#define   C_008674_RCIU_HALTED_BY_REG_VIOLATION                       0xEFFFFFFF
#define   S_008674_RCIU_STALLED_ON_APPEND_READ(x)                     (((unsigned)(x) & 0x1) << 28)
#define   G_008674_RCIU_STALLED_ON_APPEND_READ(x)                     (((x) >> 28) & 0x1)
#define   C_008674_RCIU_STALLED_ON_APPEND_READ                        0xEFFFFFFF
#define R_008678_CP_STALLED_STAT2                                       0x008678 /* <= gfx6 */
#define   S_008678_PFP_TO_CSF_NOT_RDY_TO_RCV(x)                       (((unsigned)(x) & 0x1) << 0)
#define   G_008678_PFP_TO_CSF_NOT_RDY_TO_RCV(x)                       (((x) >> 0) & 0x1)
#define   C_008678_PFP_TO_CSF_NOT_RDY_TO_RCV                          0xFFFFFFFE
#define   S_008678_PFP_TO_MEQ_NOT_RDY_TO_RCV(x)                       (((unsigned)(x) & 0x1) << 1)
#define   G_008678_PFP_TO_MEQ_NOT_RDY_TO_RCV(x)                       (((x) >> 1) & 0x1)
#define   C_008678_PFP_TO_MEQ_NOT_RDY_TO_RCV                          0xFFFFFFFD
#define   S_008678_PFP_TO_RCIU_NOT_RDY_TO_RCV(x)                      (((unsigned)(x) & 0x1) << 2)
#define   G_008678_PFP_TO_RCIU_NOT_RDY_TO_RCV(x)                      (((x) >> 2) & 0x1)
#define   C_008678_PFP_TO_RCIU_NOT_RDY_TO_RCV                         0xFFFFFFFB
#define   S_008678_PFP_TO_VGT_WRITES_PENDING(x)                       (((unsigned)(x) & 0x1) << 4)
#define   G_008678_PFP_TO_VGT_WRITES_PENDING(x)                       (((x) >> 4) & 0x1)
#define   C_008678_PFP_TO_VGT_WRITES_PENDING                          0xFFFFFFEF
#define   S_008678_PFP_RCIU_READ_PENDING(x)                           (((unsigned)(x) & 0x1) << 5)
#define   G_008678_PFP_RCIU_READ_PENDING(x)                           (((x) >> 5) & 0x1)
#define   C_008678_PFP_RCIU_READ_PENDING                              0xFFFFFFDF
#define   S_008678_PFP_MIU_READ_PENDING(x)                            (((unsigned)(x) & 0x1) << 6)
#define   G_008678_PFP_MIU_READ_PENDING(x)                            (((x) >> 6) & 0x1)
#define   C_008678_PFP_MIU_READ_PENDING                               0xFFFFFFBF
#define   S_008678_PFP_TO_MIU_WRITE_NOT_RDY_TO_RCV(x)                 (((unsigned)(x) & 0x1) << 7)
#define   G_008678_PFP_TO_MIU_WRITE_NOT_RDY_TO_RCV(x)                 (((x) >> 7) & 0x1)
#define   C_008678_PFP_TO_MIU_WRITE_NOT_RDY_TO_RCV                    0xFFFFFF7F
#define   S_008678_PFP_WAITING_ON_BUFFER_DATA(x)                      (((unsigned)(x) & 0x1) << 8)
#define   G_008678_PFP_WAITING_ON_BUFFER_DATA(x)                      (((x) >> 8) & 0x1)
#define   C_008678_PFP_WAITING_ON_BUFFER_DATA                         0xFFFFFEFF
#define   S_008678_ME_WAIT_ON_CE_COUNTER(x)                           (((unsigned)(x) & 0x1) << 9)
#define   G_008678_ME_WAIT_ON_CE_COUNTER(x)                           (((x) >> 9) & 0x1)
#define   C_008678_ME_WAIT_ON_CE_COUNTER                              0xFFFFFDFF
#define   S_008678_ME_WAIT_ON_AVAIL_BUFFER(x)                         (((unsigned)(x) & 0x1) << 10)
#define   G_008678_ME_WAIT_ON_AVAIL_BUFFER(x)                         (((x) >> 10) & 0x1)
#define   C_008678_ME_WAIT_ON_AVAIL_BUFFER                            0xFFFFFBFF
#define   S_008678_GFX_CNTX_NOT_AVAIL_TO_ME(x)                        (((unsigned)(x) & 0x1) << 11)
#define   G_008678_GFX_CNTX_NOT_AVAIL_TO_ME(x)                        (((x) >> 11) & 0x1)
#define   C_008678_GFX_CNTX_NOT_AVAIL_TO_ME                           0xFFFFF7FF
#define   S_008678_ME_RCIU_NOT_RDY_TO_RCV(x)                          (((unsigned)(x) & 0x1) << 12)
#define   G_008678_ME_RCIU_NOT_RDY_TO_RCV(x)                          (((x) >> 12) & 0x1)
#define   C_008678_ME_RCIU_NOT_RDY_TO_RCV                             0xFFFFEFFF
#define   S_008678_ME_TO_CONST_NOT_RDY_TO_RCV(x)                      (((unsigned)(x) & 0x1) << 13)
#define   G_008678_ME_TO_CONST_NOT_RDY_TO_RCV(x)                      (((x) >> 13) & 0x1)
#define   C_008678_ME_TO_CONST_NOT_RDY_TO_RCV                         0xFFFFDFFF
#define   S_008678_ME_WAITING_DATA_FROM_PFP(x)                        (((unsigned)(x) & 0x1) << 14)
#define   G_008678_ME_WAITING_DATA_FROM_PFP(x)                        (((x) >> 14) & 0x1)
#define   C_008678_ME_WAITING_DATA_FROM_PFP                           0xFFFFBFFF
#define   S_008678_ME_WAITING_ON_PARTIAL_FLUSH(x)                     (((unsigned)(x) & 0x1) << 15)
#define   G_008678_ME_WAITING_ON_PARTIAL_FLUSH(x)                     (((x) >> 15) & 0x1)
#define   C_008678_ME_WAITING_ON_PARTIAL_FLUSH                        0xFFFF7FFF
#define   S_008678_MEQ_TO_ME_NOT_RDY_TO_RCV(x)                        (((unsigned)(x) & 0x1) << 16)
#define   G_008678_MEQ_TO_ME_NOT_RDY_TO_RCV(x)                        (((x) >> 16) & 0x1)
#define   C_008678_MEQ_TO_ME_NOT_RDY_TO_RCV                           0xFFFEFFFF
#define   S_008678_STQ_TO_ME_NOT_RDY_TO_RCV(x)                        (((unsigned)(x) & 0x1) << 17)
#define   G_008678_STQ_TO_ME_NOT_RDY_TO_RCV(x)                        (((x) >> 17) & 0x1)
#define   C_008678_STQ_TO_ME_NOT_RDY_TO_RCV                           0xFFFDFFFF
#define   S_008678_ME_WAITING_DATA_FROM_STQ(x)                        (((unsigned)(x) & 0x1) << 18)
#define   G_008678_ME_WAITING_DATA_FROM_STQ(x)                        (((x) >> 18) & 0x1)
#define   C_008678_ME_WAITING_DATA_FROM_STQ                           0xFFFBFFFF
#define   S_008678_PFP_STALLED_ON_TC_WR_CONFIRM(x)                    (((unsigned)(x) & 0x1) << 19)
#define   G_008678_PFP_STALLED_ON_TC_WR_CONFIRM(x)                    (((x) >> 19) & 0x1)
#define   C_008678_PFP_STALLED_ON_TC_WR_CONFIRM                       0xFFF7FFFF
#define   S_008678_PFP_STALLED_ON_ATOMIC_RTN_DATA(x)                  (((unsigned)(x) & 0x1) << 20)
#define   G_008678_PFP_STALLED_ON_ATOMIC_RTN_DATA(x)                  (((x) >> 20) & 0x1)
#define   C_008678_PFP_STALLED_ON_ATOMIC_RTN_DATA                     0xFFEFFFFF
#define   S_008678_EOPD_FIFO_NEEDS_SC_EOP_DONE(x)                     (((unsigned)(x) & 0x1) << 21)
#define   G_008678_EOPD_FIFO_NEEDS_SC_EOP_DONE(x)                     (((x) >> 21) & 0x1)
#define   C_008678_EOPD_FIFO_NEEDS_SC_EOP_DONE                        0xFFDFFFFF
#define   S_008678_EOPD_FIFO_NEEDS_WR_CONFIRM(x)                      (((unsigned)(x) & 0x1) << 22)
#define   G_008678_EOPD_FIFO_NEEDS_WR_CONFIRM(x)                      (((x) >> 22) & 0x1)
#define   C_008678_EOPD_FIFO_NEEDS_WR_CONFIRM                         0xFFBFFFFF
#define   S_008678_STRMO_WR_OF_PRIM_DATA_PENDING(x)                   (((unsigned)(x) & 0x1) << 23)
#define   G_008678_STRMO_WR_OF_PRIM_DATA_PENDING(x)                   (((x) >> 23) & 0x1)
#define   C_008678_STRMO_WR_OF_PRIM_DATA_PENDING                      0xFF7FFFFF
#define   S_008678_PIPE_STATS_WR_DATA_PENDING(x)                      (((unsigned)(x) & 0x1) << 24)
#define   G_008678_PIPE_STATS_WR_DATA_PENDING(x)                      (((x) >> 24) & 0x1)
#define   C_008678_PIPE_STATS_WR_DATA_PENDING                         0xFEFFFFFF
#define   S_008678_APPEND_RDY_WAIT_ON_CS_DONE(x)                      (((unsigned)(x) & 0x1) << 25)
#define   G_008678_APPEND_RDY_WAIT_ON_CS_DONE(x)                      (((x) >> 25) & 0x1)
#define   C_008678_APPEND_RDY_WAIT_ON_CS_DONE                         0xFDFFFFFF
#define   S_008678_APPEND_RDY_WAIT_ON_PS_DONE(x)                      (((unsigned)(x) & 0x1) << 26)
#define   G_008678_APPEND_RDY_WAIT_ON_PS_DONE(x)                      (((x) >> 26) & 0x1)
#define   C_008678_APPEND_RDY_WAIT_ON_PS_DONE                         0xFBFFFFFF
#define   S_008678_APPEND_WAIT_ON_WR_CONFIRM(x)                       (((unsigned)(x) & 0x1) << 27)
#define   G_008678_APPEND_WAIT_ON_WR_CONFIRM(x)                       (((x) >> 27) & 0x1)
#define   C_008678_APPEND_WAIT_ON_WR_CONFIRM                          0xF7FFFFFF
#define   S_008678_APPEND_ACTIVE_PARTITION(x)                         (((unsigned)(x) & 0x1) << 28)
#define   G_008678_APPEND_ACTIVE_PARTITION(x)                         (((x) >> 28) & 0x1)
#define   C_008678_APPEND_ACTIVE_PARTITION                            0xEFFFFFFF
#define   S_008678_APPEND_WAITING_TO_SEND_MEMWRITE(x)                 (((unsigned)(x) & 0x1) << 29)
#define   G_008678_APPEND_WAITING_TO_SEND_MEMWRITE(x)                 (((x) >> 29) & 0x1)
#define   C_008678_APPEND_WAITING_TO_SEND_MEMWRITE                    0xDFFFFFFF
#define   S_008678_SURF_SYNC_NEEDS_IDLE_CNTXS(x)                      (((unsigned)(x) & 0x1) << 30)
#define   G_008678_SURF_SYNC_NEEDS_IDLE_CNTXS(x)                      (((x) >> 30) & 0x1)
#define   C_008678_SURF_SYNC_NEEDS_IDLE_CNTXS                         0xBFFFFFFF
#define   S_008678_SURF_SYNC_NEEDS_ALL_CLEAN(x)                       (((unsigned)(x) & 0x1) << 31)
#define   G_008678_SURF_SYNC_NEEDS_ALL_CLEAN(x)                       (((x) >> 31) & 0x1)
#define   C_008678_SURF_SYNC_NEEDS_ALL_CLEAN                          0x7FFFFFFF
#define R_00867C_CP_BUSY_STAT                                           0x00867C /* <= gfx6 */
#define   S_00867C_REG_BUS_FIFO_BUSY(x)                               (((unsigned)(x) & 0x1) << 0)
#define   G_00867C_REG_BUS_FIFO_BUSY(x)                               (((x) >> 0) & 0x1)
#define   C_00867C_REG_BUS_FIFO_BUSY                                  0xFFFFFFFE
#define   S_00867C_COHER_CNT_NEQ_ZERO(x)                              (((unsigned)(x) & 0x1) << 6)
#define   G_00867C_COHER_CNT_NEQ_ZERO(x)                              (((x) >> 6) & 0x1)
#define   C_00867C_COHER_CNT_NEQ_ZERO                                 0xFFFFFFBF
#define   S_00867C_PFP_PARSING_PACKETS(x)                             (((unsigned)(x) & 0x1) << 7)
#define   G_00867C_PFP_PARSING_PACKETS(x)                             (((x) >> 7) & 0x1)
#define   C_00867C_PFP_PARSING_PACKETS                                0xFFFFFF7F
#define   S_00867C_ME_PARSING_PACKETS(x)                              (((unsigned)(x) & 0x1) << 8)
#define   G_00867C_ME_PARSING_PACKETS(x)                              (((x) >> 8) & 0x1)
#define   C_00867C_ME_PARSING_PACKETS                                 0xFFFFFEFF
#define   S_00867C_RCIU_PFP_BUSY(x)                                   (((unsigned)(x) & 0x1) << 9)
#define   G_00867C_RCIU_PFP_BUSY(x)                                   (((x) >> 9) & 0x1)
#define   C_00867C_RCIU_PFP_BUSY                                      0xFFFFFDFF
#define   S_00867C_RCIU_ME_BUSY(x)                                    (((unsigned)(x) & 0x1) << 10)
#define   G_00867C_RCIU_ME_BUSY(x)                                    (((x) >> 10) & 0x1)
#define   C_00867C_RCIU_ME_BUSY                                       0xFFFFFBFF
#define   S_00867C_SEM_CMDFIFO_NOT_EMPTY(x)                           (((unsigned)(x) & 0x1) << 12)
#define   G_00867C_SEM_CMDFIFO_NOT_EMPTY(x)                           (((x) >> 12) & 0x1)
#define   C_00867C_SEM_CMDFIFO_NOT_EMPTY                              0xFFFFEFFF
#define   S_00867C_SEM_FAILED_AND_HOLDING(x)                          (((unsigned)(x) & 0x1) << 13)
#define   G_00867C_SEM_FAILED_AND_HOLDING(x)                          (((x) >> 13) & 0x1)
#define   C_00867C_SEM_FAILED_AND_HOLDING                             0xFFFFDFFF
#define   S_00867C_SEM_POLLING_FOR_PASS(x)                            (((unsigned)(x) & 0x1) << 14)
#define   G_00867C_SEM_POLLING_FOR_PASS(x)                            (((x) >> 14) & 0x1)
#define   C_00867C_SEM_POLLING_FOR_PASS                               0xFFFFBFFF
#define   S_00867C_GFX_CONTEXT_BUSY(x)                                (((unsigned)(x) & 0x1) << 15)
#define   G_00867C_GFX_CONTEXT_BUSY(x)                                (((x) >> 15) & 0x1)
#define   C_00867C_GFX_CONTEXT_BUSY                                   0xFFFF7FFF
#define   S_00867C_ME_PARSER_BUSY(x)                                  (((unsigned)(x) & 0x1) << 17)
#define   G_00867C_ME_PARSER_BUSY(x)                                  (((x) >> 17) & 0x1)
#define   C_00867C_ME_PARSER_BUSY                                     0xFFFDFFFF
#define   S_00867C_EOP_DONE_BUSY(x)                                   (((unsigned)(x) & 0x1) << 18)
#define   G_00867C_EOP_DONE_BUSY(x)                                   (((x) >> 18) & 0x1)
#define   C_00867C_EOP_DONE_BUSY                                      0xFFFBFFFF
#define   S_00867C_STRM_OUT_BUSY(x)                                   (((unsigned)(x) & 0x1) << 19)
#define   G_00867C_STRM_OUT_BUSY(x)                                   (((x) >> 19) & 0x1)
#define   C_00867C_STRM_OUT_BUSY                                      0xFFF7FFFF
#define   S_00867C_PIPE_STATS_BUSY(x)                                 (((unsigned)(x) & 0x1) << 20)
#define   G_00867C_PIPE_STATS_BUSY(x)                                 (((x) >> 20) & 0x1)
#define   C_00867C_PIPE_STATS_BUSY                                    0xFFEFFFFF
#define   S_00867C_RCIU_CE_BUSY(x)                                    (((unsigned)(x) & 0x1) << 21)
#define   G_00867C_RCIU_CE_BUSY(x)                                    (((x) >> 21) & 0x1)
#define   C_00867C_RCIU_CE_BUSY                                       0xFFDFFFFF
#define   S_00867C_CE_PARSING_PACKETS(x)                              (((unsigned)(x) & 0x1) << 22)
#define   G_00867C_CE_PARSING_PACKETS(x)                              (((x) >> 22) & 0x1)
#define   C_00867C_CE_PARSING_PACKETS                                 0xFFBFFFFF
#define R_008680_CP_STAT                                                0x008680 /* <= gfx6 */
#define   S_008680_MIU_RDREQ_BUSY(x)                                  (((unsigned)(x) & 0x1) << 7)
#define   G_008680_MIU_RDREQ_BUSY(x)                                  (((x) >> 7) & 0x1)
#define   C_008680_MIU_RDREQ_BUSY                                     0xFFFFFF7F
#define   S_008680_MIU_WRREQ_BUSY(x)                                  (((unsigned)(x) & 0x1) << 8)
#define   G_008680_MIU_WRREQ_BUSY(x)                                  (((x) >> 8) & 0x1)
#define   C_008680_MIU_WRREQ_BUSY                                     0xFFFFFEFF
#define   S_008680_ROQ_RING_BUSY(x)                                   (((unsigned)(x) & 0x1) << 9)
#define   G_008680_ROQ_RING_BUSY(x)                                   (((x) >> 9) & 0x1)
#define   C_008680_ROQ_RING_BUSY                                      0xFFFFFDFF
#define   S_008680_ROQ_INDIRECT1_BUSY(x)                              (((unsigned)(x) & 0x1) << 10)
#define   G_008680_ROQ_INDIRECT1_BUSY(x)                              (((x) >> 10) & 0x1)
#define   C_008680_ROQ_INDIRECT1_BUSY                                 0xFFFFFBFF
#define   S_008680_ROQ_INDIRECT2_BUSY(x)                              (((unsigned)(x) & 0x1) << 11)
#define   G_008680_ROQ_INDIRECT2_BUSY(x)                              (((x) >> 11) & 0x1)
#define   C_008680_ROQ_INDIRECT2_BUSY                                 0xFFFFF7FF
#define   S_008680_ROQ_STATE_BUSY(x)                                  (((unsigned)(x) & 0x1) << 12)
#define   G_008680_ROQ_STATE_BUSY(x)                                  (((x) >> 12) & 0x1)
#define   C_008680_ROQ_STATE_BUSY                                     0xFFFFEFFF
#define   S_008680_DC_BUSY(x)                                         (((unsigned)(x) & 0x1) << 13)
#define   G_008680_DC_BUSY(x)                                         (((x) >> 13) & 0x1)
#define   C_008680_DC_BUSY                                            0xFFFFDFFF
#define   S_008680_PFP_BUSY(x)                                        (((unsigned)(x) & 0x1) << 15)
#define   G_008680_PFP_BUSY(x)                                        (((x) >> 15) & 0x1)
#define   C_008680_PFP_BUSY                                           0xFFFF7FFF
#define   S_008680_MEQ_BUSY(x)                                        (((unsigned)(x) & 0x1) << 16)
#define   G_008680_MEQ_BUSY(x)                                        (((x) >> 16) & 0x1)
#define   C_008680_MEQ_BUSY                                           0xFFFEFFFF
#define   S_008680_ME_BUSY(x)                                         (((unsigned)(x) & 0x1) << 17)
#define   G_008680_ME_BUSY(x)                                         (((x) >> 17) & 0x1)
#define   C_008680_ME_BUSY                                            0xFFFDFFFF
#define   S_008680_QUERY_BUSY(x)                                      (((unsigned)(x) & 0x1) << 18)
#define   G_008680_QUERY_BUSY(x)                                      (((x) >> 18) & 0x1)
#define   C_008680_QUERY_BUSY                                         0xFFFBFFFF
#define   S_008680_SEMAPHORE_BUSY(x)                                  (((unsigned)(x) & 0x1) << 19)
#define   G_008680_SEMAPHORE_BUSY(x)                                  (((x) >> 19) & 0x1)
#define   C_008680_SEMAPHORE_BUSY                                     0xFFF7FFFF
#define   S_008680_INTERRUPT_BUSY(x)                                  (((unsigned)(x) & 0x1) << 20)
#define   G_008680_INTERRUPT_BUSY(x)                                  (((x) >> 20) & 0x1)
#define   C_008680_INTERRUPT_BUSY                                     0xFFEFFFFF
#define   S_008680_SURFACE_SYNC_BUSY(x)                               (((unsigned)(x) & 0x1) << 21)
#define   G_008680_SURFACE_SYNC_BUSY(x)                               (((x) >> 21) & 0x1)
#define   C_008680_SURFACE_SYNC_BUSY                                  0xFFDFFFFF
#define   S_008680_DMA_BUSY(x)                                        (((unsigned)(x) & 0x1) << 22)
#define   G_008680_DMA_BUSY(x)                                        (((x) >> 22) & 0x1)
#define   C_008680_DMA_BUSY                                           0xFFBFFFFF
#define   S_008680_RCIU_BUSY(x)                                       (((unsigned)(x) & 0x1) << 23)
#define   G_008680_RCIU_BUSY(x)                                       (((x) >> 23) & 0x1)
#define   C_008680_RCIU_BUSY                                          0xFF7FFFFF
#define   S_008680_SCRATCH_RAM_BUSY(x)                                (((unsigned)(x) & 0x1) << 24)
#define   G_008680_SCRATCH_RAM_BUSY(x)                                (((x) >> 24) & 0x1)
#define   C_008680_SCRATCH_RAM_BUSY                                   0xFEFFFFFF
#define   S_008680_CPC_CPG_BUSY(x)                                    (((unsigned)(x) & 0x1) << 25)
#define   G_008680_CPC_CPG_BUSY(x)                                    (((x) >> 25) & 0x1)
#define   C_008680_CPC_CPG_BUSY                                       0xFDFFFFFF
#define   S_008680_CE_BUSY(x)                                         (((unsigned)(x) & 0x1) << 26)
#define   G_008680_CE_BUSY(x)                                         (((x) >> 26) & 0x1)
#define   C_008680_CE_BUSY                                            0xFBFFFFFF
#define   S_008680_TCIU_BUSY(x)                                       (((unsigned)(x) & 0x1) << 27)
#define   G_008680_TCIU_BUSY(x)                                       (((x) >> 27) & 0x1)
#define   C_008680_TCIU_BUSY                                          0xF7FFFFFF
#define   S_008680_ROQ_CE_RING_BUSY(x)                                (((unsigned)(x) & 0x1) << 28)
#define   G_008680_ROQ_CE_RING_BUSY(x)                                (((x) >> 28) & 0x1)
#define   C_008680_ROQ_CE_RING_BUSY                                   0xEFFFFFFF
#define   S_008680_ROQ_CE_INDIRECT1_BUSY(x)                           (((unsigned)(x) & 0x1) << 29)
#define   G_008680_ROQ_CE_INDIRECT1_BUSY(x)                           (((x) >> 29) & 0x1)
#define   C_008680_ROQ_CE_INDIRECT1_BUSY                              0xDFFFFFFF
#define   S_008680_ROQ_CE_INDIRECT2_BUSY(x)                           (((unsigned)(x) & 0x1) << 30)
#define   G_008680_ROQ_CE_INDIRECT2_BUSY(x)                           (((x) >> 30) & 0x1)
#define   C_008680_ROQ_CE_INDIRECT2_BUSY                              0xBFFFFFFF
#define   S_008680_CP_BUSY(x)                                         (((unsigned)(x) & 0x1) << 31)
#define   G_008680_CP_BUSY(x)                                         (((x) >> 31) & 0x1)
#define   C_008680_CP_BUSY                                            0x7FFFFFFF
#define R_008684_CP_ME_HEADER_DUMP                                      0x008684 /* <= gfx6 */
#define R_008688_CP_PFP_HEADER_DUMP                                     0x008688 /* <= gfx6 */
#define R_00868C_CP_GRBM_FREE_COUNT                                     0x00868C /* <= gfx6 */
#define   S_00868C_FREE_COUNT(x)                                      (((unsigned)(x) & 0x3F) << 0)
#define   G_00868C_FREE_COUNT(x)                                      (((x) >> 0) & 0x3F)
#define   C_00868C_FREE_COUNT                                         0xFFFFFFC0
#define   S_00868C_FREE_COUNT_GDS(x)                                  (((unsigned)(x) & 0x3F) << 8)
#define   G_00868C_FREE_COUNT_GDS(x)                                  (((x) >> 8) & 0x3F)
#define   C_00868C_FREE_COUNT_GDS                                     0xFFFFC0FF
#define   S_00868C_FREE_COUNT_PFP(x)                                  (((unsigned)(x) & 0x3F) << 16)
#define   G_00868C_FREE_COUNT_PFP(x)                                  (((x) >> 16) & 0x3F)
#define   C_00868C_FREE_COUNT_PFP                                     0xFFC0FFFF
#define R_008690_CP_CE_HEADER_DUMP                                      0x008690 /* <= gfx6 */
#define R_00869C_CP_MC_PACK_DELAY_CNT                                   0x00869C /* <= gfx6 */
#define   S_00869C_PACK_DELAY_CNT(x)                                  (((unsigned)(x) & 0x1F) << 0)
#define   G_00869C_PACK_DELAY_CNT(x)                                  (((x) >> 0) & 0x1F)
#define   C_00869C_PACK_DELAY_CNT                                     0xFFFFFFE0
#define R_0086D0_CP_CSF_STAT                                            0x0086D0 /* <= gfx6 */
#define   S_0086D0_BUFFER_SLOTS_ALLOCATED(x)                          (((unsigned)(x) & 0xF) << 0)
#define   G_0086D0_BUFFER_SLOTS_ALLOCATED(x)                          (((x) >> 0) & 0xF)
#define   C_0086D0_BUFFER_SLOTS_ALLOCATED                             0xFFFFFFF0
#define   S_0086D0_BUFFER_REQUEST_COUNT(x)                            (((unsigned)(x) & 0x3F) << 8)
#define   G_0086D0_BUFFER_REQUEST_COUNT(x)                            (((x) >> 8) & 0x3F)
#define   C_0086D0_BUFFER_REQUEST_COUNT                               0xFFFFC0FF
#define R_0086D4_CP_CSF_CNTL                                            0x0086D4 /* <= gfx6 */
#define   S_0086D4_FETCH_BUFFER_DEPTH(x)                              (((unsigned)(x) & 0xF) << 0)
#define   G_0086D4_FETCH_BUFFER_DEPTH(x)                              (((x) >> 0) & 0xF)
#define   C_0086D4_FETCH_BUFFER_DEPTH                                 0xFFFFFFF0
#define R_0086D8_CP_ME_CNTL                                             0x0086D8 /* <= gfx6 */
#define   S_0086D8_CE_INVALIDATE_ICACHE(x)                            (((unsigned)(x) & 0x1) << 4)
#define   G_0086D8_CE_INVALIDATE_ICACHE(x)                            (((x) >> 4) & 0x1)
#define   C_0086D8_CE_INVALIDATE_ICACHE                               0xFFFFFFEF
#define   S_0086D8_PFP_INVALIDATE_ICACHE(x)                           (((unsigned)(x) & 0x1) << 6)
#define   G_0086D8_PFP_INVALIDATE_ICACHE(x)                           (((x) >> 6) & 0x1)
#define   C_0086D8_PFP_INVALIDATE_ICACHE                              0xFFFFFFBF
#define   S_0086D8_ME_INVALIDATE_ICACHE(x)                            (((unsigned)(x) & 0x1) << 8)
#define   G_0086D8_ME_INVALIDATE_ICACHE(x)                            (((x) >> 8) & 0x1)
#define   C_0086D8_ME_INVALIDATE_ICACHE                               0xFFFFFEFF
#define   S_0086D8_CE_HALT(x)                                         (((unsigned)(x) & 0x1) << 24)
#define   G_0086D8_CE_HALT(x)                                         (((x) >> 24) & 0x1)
#define   C_0086D8_CE_HALT                                            0xFEFFFFFF
#define   S_0086D8_CE_STEP(x)                                         (((unsigned)(x) & 0x1) << 25)
#define   G_0086D8_CE_STEP(x)                                         (((x) >> 25) & 0x1)
#define   C_0086D8_CE_STEP                                            0xFDFFFFFF
#define   S_0086D8_PFP_HALT(x)                                        (((unsigned)(x) & 0x1) << 26)
#define   G_0086D8_PFP_HALT(x)                                        (((x) >> 26) & 0x1)
#define   C_0086D8_PFP_HALT                                           0xFBFFFFFF
#define   S_0086D8_PFP_STEP(x)                                        (((unsigned)(x) & 0x1) << 27)
#define   G_0086D8_PFP_STEP(x)                                        (((x) >> 27) & 0x1)
#define   C_0086D8_PFP_STEP                                           0xF7FFFFFF
#define   S_0086D8_ME_HALT(x)                                         (((unsigned)(x) & 0x1) << 28)
#define   G_0086D8_ME_HALT(x)                                         (((x) >> 28) & 0x1)
#define   C_0086D8_ME_HALT                                            0xEFFFFFFF
#define   S_0086D8_ME_STEP(x)                                         (((unsigned)(x) & 0x1) << 29)
#define   G_0086D8_ME_STEP(x)                                         (((x) >> 29) & 0x1)
#define   C_0086D8_ME_STEP                                            0xDFFFFFFF
#define R_0086E0_CP_CNTX_STAT                                           0x0086E0 /* <= gfx6 */
#define   S_0086E0_ACTIVE_HP3D_CONTEXTS(x)                            (((unsigned)(x) & 0xFF) << 0)
#define   G_0086E0_ACTIVE_HP3D_CONTEXTS(x)                            (((x) >> 0) & 0xFF)
#define   C_0086E0_ACTIVE_HP3D_CONTEXTS                               0xFFFFFF00
#define   S_0086E0_CURRENT_HP3D_CONTEXT(x)                            (((unsigned)(x) & 0x7) << 8)
#define   G_0086E0_CURRENT_HP3D_CONTEXT(x)                            (((x) >> 8) & 0x7)
#define   C_0086E0_CURRENT_HP3D_CONTEXT                               0xFFFFF8FF
#define   S_0086E0_ACTIVE_GFX_CONTEXTS(x)                             (((unsigned)(x) & 0xFF) << 20)
#define   G_0086E0_ACTIVE_GFX_CONTEXTS(x)                             (((x) >> 20) & 0xFF)
#define   C_0086E0_ACTIVE_GFX_CONTEXTS                                0xF00FFFFF
#define   S_0086E0_CURRENT_GFX_CONTEXT(x)                             (((unsigned)(x) & 0x7) << 28)
#define   G_0086E0_CURRENT_GFX_CONTEXT(x)                             (((x) >> 28) & 0x7)
#define   C_0086E0_CURRENT_GFX_CONTEXT                                0x8FFFFFFF
#define R_0086E4_CP_ME_PREEMPTION                                       0x0086E4 /* <= gfx6 */
#define   S_0086E4_ME_CNTXSW_PREEMPTION(x)                            (((unsigned)(x) & 0x1) << 0)
#define   G_0086E4_ME_CNTXSW_PREEMPTION(x)                            (((x) >> 0) & 0x1)
#define   C_0086E4_ME_CNTXSW_PREEMPTION                               0xFFFFFFFE
#define R_0086F8_CP_RB2_RPTR                                            0x0086F8 /* <= gfx6 */
#define   S_0086F8_RB_RPTR(x)                                         (((unsigned)(x) & 0xFFFFF) << 0)
#define   G_0086F8_RB_RPTR(x)                                         (((x) >> 0) & 0xFFFFF)
#define   C_0086F8_RB_RPTR                                            0xFFF00000
#define R_0086FC_CP_RB1_RPTR                                            0x0086FC /* <= gfx6 */
#define R_008700_CP_RB0_RPTR                                            0x008700 /* <= gfx6 */
#define R_008704_CP_RB_WPTR_DELAY                                       0x008704 /* <= gfx6 */
#define   S_008704_PRE_WRITE_TIMER(x)                                 (((unsigned)(x) & 0xFFFFFFF) << 0)
#define   G_008704_PRE_WRITE_TIMER(x)                                 (((x) >> 0) & 0xFFFFFFF)
#define   C_008704_PRE_WRITE_TIMER                                    0xF0000000
#define   S_008704_PRE_WRITE_LIMIT(x)                                 (((unsigned)(x) & 0xF) << 28)
#define   G_008704_PRE_WRITE_LIMIT(x)                                 (((x) >> 28) & 0xF)
#define   C_008704_PRE_WRITE_LIMIT                                    0x0FFFFFFF
#define R_008708_CP_RB_WPTR_POLL_CNTL                                   0x008708 /* <= gfx6 */
#define   S_008708_POLL_FREQUENCY(x)                                  (((unsigned)(x) & 0xFFFF) << 0)
#define   G_008708_POLL_FREQUENCY(x)                                  (((x) >> 0) & 0xFFFF)
#define   C_008708_POLL_FREQUENCY                                     0xFFFF0000
#define   S_008708_IDLE_POLL_COUNT(x)                                 (((unsigned)(x) & 0xFFFF) << 16)
#define   G_008708_IDLE_POLL_COUNT(x)                                 (((x) >> 16) & 0xFFFF)
#define   C_008708_IDLE_POLL_COUNT                                    0x0000FFFF
#define R_00870C_CP_CE_INIT_BASE_LO                                     0x00870C /* <= gfx6 */
#define   S_00870C_INIT_BASE_LO(x)                                    (((unsigned)(x) & 0x7FFFFFF) << 5)
#define   G_00870C_INIT_BASE_LO(x)                                    (((x) >> 5) & 0x7FFFFFF)
#define   C_00870C_INIT_BASE_LO                                       0x0000001F
#define R_008710_CP_CE_INIT_BASE_HI                                     0x008710 /* <= gfx6 */
#define   S_008710_INIT_BASE_HI(x)                                    (((unsigned)(x) & 0xFF) << 0)
#define   G_008710_INIT_BASE_HI(x)                                    (((x) >> 0) & 0xFF)
#define   C_008710_INIT_BASE_HI                                       0xFFFFFF00
#define R_008714_CP_CE_INIT_BUFSZ                                       0x008714 /* <= gfx6 */
#define   S_008714_INIT_BUFSZ(x)                                      (((unsigned)(x) & 0xFFF) << 0)
#define   G_008714_INIT_BUFSZ(x)                                      (((x) >> 0) & 0xFFF)
#define   C_008714_INIT_BUFSZ                                         0xFFFFF000
#define R_008718_CP_CE_IB1_BASE_LO                                      0x008718 /* <= gfx6 */
#define   S_008718_IB1_BASE_LO(x)                                     (((unsigned)(x) & 0x3FFFFFFF) << 2)
#define   G_008718_IB1_BASE_LO(x)                                     (((x) >> 2) & 0x3FFFFFFF)
#define   C_008718_IB1_BASE_LO                                        0x00000003
#define R_00871C_CP_CE_IB1_BASE_HI                                      0x00871C /* <= gfx6 */
#define   S_00871C_IB1_BASE_HI(x)                                     (((unsigned)(x) & 0xFF) << 0)
#define   G_00871C_IB1_BASE_HI(x)                                     (((x) >> 0) & 0xFF)
#define   C_00871C_IB1_BASE_HI                                        0xFFFFFF00
#define R_008720_CP_CE_IB1_BUFSZ                                        0x008720 /* <= gfx6 */
#define   S_008720_IB1_BUFSZ(x)                                       (((unsigned)(x) & 0xFFFFF) << 0)
#define   G_008720_IB1_BUFSZ(x)                                       (((x) >> 0) & 0xFFFFF)
#define   C_008720_IB1_BUFSZ                                          0xFFF00000
#define R_008724_CP_CE_IB2_BASE_LO                                      0x008724 /* <= gfx6 */
#define   S_008724_IB2_BASE_LO(x)                                     (((unsigned)(x) & 0x3FFFFFFF) << 2)
#define   G_008724_IB2_BASE_LO(x)                                     (((x) >> 2) & 0x3FFFFFFF)
#define   C_008724_IB2_BASE_LO                                        0x00000003
#define R_008728_CP_CE_IB2_BASE_HI                                      0x008728 /* <= gfx6 */
#define   S_008728_IB2_BASE_HI(x)                                     (((unsigned)(x) & 0xFF) << 0)
#define   G_008728_IB2_BASE_HI(x)                                     (((x) >> 0) & 0xFF)
#define   C_008728_IB2_BASE_HI                                        0xFFFFFF00
#define R_00872C_CP_CE_IB2_BUFSZ                                        0x00872C /* <= gfx6 */
#define   S_00872C_IB2_BUFSZ(x)                                       (((unsigned)(x) & 0xFFFFF) << 0)
#define   G_00872C_IB2_BUFSZ(x)                                       (((x) >> 0) & 0xFFFFF)
#define   C_00872C_IB2_BUFSZ                                          0xFFF00000
#define R_008730_CP_IB1_BASE_LO                                         0x008730 /* <= gfx6 */
#define   S_008730_IB1_BASE_LO(x)                                     (((unsigned)(x) & 0x3FFFFFFF) << 2)
#define   G_008730_IB1_BASE_LO(x)                                     (((x) >> 2) & 0x3FFFFFFF)
#define   C_008730_IB1_BASE_LO                                        0x00000003
#define R_008734_CP_IB1_BASE_HI                                         0x008734 /* <= gfx6 */
#define   S_008734_IB1_BASE_HI(x)                                     (((unsigned)(x) & 0xFF) << 0)
#define   G_008734_IB1_BASE_HI(x)                                     (((x) >> 0) & 0xFF)
#define   C_008734_IB1_BASE_HI                                        0xFFFFFF00
#define R_008738_CP_IB1_BUFSZ                                           0x008738 /* <= gfx6 */
#define   S_008738_IB1_BUFSZ(x)                                       (((unsigned)(x) & 0xFFFFF) << 0)
#define   G_008738_IB1_BUFSZ(x)                                       (((x) >> 0) & 0xFFFFF)
#define   C_008738_IB1_BUFSZ                                          0xFFF00000
#define R_00873C_CP_IB2_BASE_LO                                         0x00873C /* <= gfx6 */
#define   S_00873C_IB2_BASE_LO(x)                                     (((unsigned)(x) & 0x3FFFFFFF) << 2)
#define   G_00873C_IB2_BASE_LO(x)                                     (((x) >> 2) & 0x3FFFFFFF)
#define   C_00873C_IB2_BASE_LO                                        0x00000003
#define R_008740_CP_IB2_BASE_HI                                         0x008740 /* <= gfx6 */
#define   S_008740_IB2_BASE_HI(x)                                     (((unsigned)(x) & 0xFF) << 0)
#define   G_008740_IB2_BASE_HI(x)                                     (((x) >> 0) & 0xFF)
#define   C_008740_IB2_BASE_HI                                        0xFFFFFF00
#define R_008744_CP_IB2_BUFSZ                                           0x008744 /* <= gfx6 */
#define   S_008744_IB2_BUFSZ(x)                                       (((unsigned)(x) & 0xFFFFF) << 0)
#define   G_008744_IB2_BUFSZ(x)                                       (((x) >> 0) & 0xFFFFF)
#define   C_008744_IB2_BUFSZ                                          0xFFF00000
#define R_008748_CP_ST_BASE_LO                                          0x008748 /* <= gfx6 */
#define   S_008748_ST_BASE_LO(x)                                      (((unsigned)(x) & 0x3FFFFFFF) << 2)
#define   G_008748_ST_BASE_LO(x)                                      (((x) >> 2) & 0x3FFFFFFF)
#define   C_008748_ST_BASE_LO                                         0x00000003
#define R_00874C_CP_ST_BASE_HI                                          0x00874C /* <= gfx6 */
#define   S_00874C_ST_BASE_HI(x)                                      (((unsigned)(x) & 0xFF) << 0)
#define   G_00874C_ST_BASE_HI(x)                                      (((x) >> 0) & 0xFF)
#define   C_00874C_ST_BASE_HI                                         0xFFFFFF00
#define R_008750_CP_ST_BUFSZ                                            0x008750 /* <= gfx6 */
#define   S_008750_ST_BUFSZ(x)                                        (((unsigned)(x) & 0xFFFFF) << 0)
#define   G_008750_ST_BUFSZ(x)                                        (((x) >> 0) & 0xFFFFF)
#define   C_008750_ST_BUFSZ                                           0xFFF00000
#define R_008754_CP_ROQ1_THRESHOLDS                                     0x008754 /* <= gfx6 */
#define   S_008754_RB1_START(x)                                       (((unsigned)(x) & 0xFF) << 0)
#define   G_008754_RB1_START(x)                                       (((x) >> 0) & 0xFF)
#define   C_008754_RB1_START                                          0xFFFFFF00
#define   S_008754_RB2_START(x)                                       (((unsigned)(x) & 0xFF) << 8)
#define   G_008754_RB2_START(x)                                       (((x) >> 8) & 0xFF)
#define   C_008754_RB2_START                                          0xFFFF00FF
#define   S_008754_R0_IB1_START(x)                                    (((unsigned)(x) & 0xFF) << 16)
#define   G_008754_R0_IB1_START(x)                                    (((x) >> 16) & 0xFF)
#define   C_008754_R0_IB1_START                                       0xFF00FFFF
#define   S_008754_R1_IB1_START(x)                                    (((unsigned)(x) & 0xFF) << 24)
#define   G_008754_R1_IB1_START(x)                                    (((x) >> 24) & 0xFF)
#define   C_008754_R1_IB1_START                                       0x00FFFFFF
#define R_008758_CP_ROQ2_THRESHOLDS                                     0x008758 /* <= gfx6 */
#define   S_008758_R2_IB1_START(x)                                    (((unsigned)(x) & 0xFF) << 0)
#define   G_008758_R2_IB1_START(x)                                    (((x) >> 0) & 0xFF)
#define   C_008758_R2_IB1_START                                       0xFFFFFF00
#define   S_008758_R0_IB2_START(x)                                    (((unsigned)(x) & 0xFF) << 8)
#define   G_008758_R0_IB2_START(x)                                    (((x) >> 8) & 0xFF)
#define   C_008758_R0_IB2_START                                       0xFFFF00FF
#define   S_008758_R1_IB2_START(x)                                    (((unsigned)(x) & 0xFF) << 16)
#define   G_008758_R1_IB2_START(x)                                    (((x) >> 16) & 0xFF)
#define   C_008758_R1_IB2_START                                       0xFF00FFFF
#define   S_008758_R2_IB2_START(x)                                    (((unsigned)(x) & 0xFF) << 24)
#define   G_008758_R2_IB2_START(x)                                    (((x) >> 24) & 0xFF)
#define   C_008758_R2_IB2_START                                       0x00FFFFFF
#define R_00875C_CP_STQ_THRESHOLDS                                      0x00875C /* <= gfx6 */
#define   S_00875C_STQ0_START(x)                                      (((unsigned)(x) & 0xFF) << 0)
#define   G_00875C_STQ0_START(x)                                      (((x) >> 0) & 0xFF)
#define   C_00875C_STQ0_START                                         0xFFFFFF00
#define   S_00875C_STQ1_START(x)                                      (((unsigned)(x) & 0xFF) << 8)
#define   G_00875C_STQ1_START(x)                                      (((x) >> 8) & 0xFF)
#define   C_00875C_STQ1_START                                         0xFFFF00FF
#define   S_00875C_STQ2_START(x)                                      (((unsigned)(x) & 0xFF) << 16)
#define   G_00875C_STQ2_START(x)                                      (((x) >> 16) & 0xFF)
#define   C_00875C_STQ2_START                                         0xFF00FFFF
#define R_008760_CP_QUEUE_THRESHOLDS                                    0x008760 /* <= gfx6 */
#define   S_008760_ROQ_IB1_START(x)                                   (((unsigned)(x) & 0x3F) << 0)
#define   G_008760_ROQ_IB1_START(x)                                   (((x) >> 0) & 0x3F)
#define   C_008760_ROQ_IB1_START                                      0xFFFFFFC0
#define   S_008760_ROQ_IB2_START(x)                                   (((unsigned)(x) & 0x3F) << 8)
#define   G_008760_ROQ_IB2_START(x)                                   (((x) >> 8) & 0x3F)
#define   C_008760_ROQ_IB2_START                                      0xFFFFC0FF
#define R_008764_CP_MEQ_THRESHOLDS                                      0x008764 /* <= gfx6 */
#define   S_008764_MEQ1_START(x)                                      (((unsigned)(x) & 0xFF) << 0)
#define   G_008764_MEQ1_START(x)                                      (((x) >> 0) & 0xFF)
#define   C_008764_MEQ1_START                                         0xFFFFFF00
#define   S_008764_MEQ2_START(x)                                      (((unsigned)(x) & 0xFF) << 8)
#define   G_008764_MEQ2_START(x)                                      (((x) >> 8) & 0xFF)
#define   C_008764_MEQ2_START                                         0xFFFF00FF
#define R_008768_CP_ROQ_AVAIL                                           0x008768 /* <= gfx6 */
#define   S_008768_ROQ_CNT_RING(x)                                    (((unsigned)(x) & 0x7FF) << 0)
#define   G_008768_ROQ_CNT_RING(x)                                    (((x) >> 0) & 0x7FF)
#define   C_008768_ROQ_CNT_RING                                       0xFFFFF800
#define   S_008768_ROQ_CNT_IB1(x)                                     (((unsigned)(x) & 0x7FF) << 16)
#define   G_008768_ROQ_CNT_IB1(x)                                     (((x) >> 16) & 0x7FF)
#define   C_008768_ROQ_CNT_IB1                                        0xF800FFFF
#define R_00876C_CP_STQ_AVAIL                                           0x00876C /* <= gfx6 */
#define   S_00876C_STQ_CNT(x)                                         (((unsigned)(x) & 0x1FF) << 0)
#define   G_00876C_STQ_CNT(x)                                         (((x) >> 0) & 0x1FF)
#define   C_00876C_STQ_CNT                                            0xFFFFFE00
#define R_008770_CP_ROQ2_AVAIL                                          0x008770 /* <= gfx6 */
#define   S_008770_ROQ_CNT_IB2(x)                                     (((unsigned)(x) & 0x7FF) << 0)
#define   G_008770_ROQ_CNT_IB2(x)                                     (((x) >> 0) & 0x7FF)
#define   C_008770_ROQ_CNT_IB2                                        0xFFFFF800
#define R_008774_CP_MEQ_AVAIL                                           0x008774 /* <= gfx6 */
#define   S_008774_MEQ_CNT(x)                                         (((unsigned)(x) & 0x3FF) << 0)
#define   G_008774_MEQ_CNT(x)                                         (((x) >> 0) & 0x3FF)
#define   C_008774_MEQ_CNT                                            0xFFFFFC00
#define R_008778_CP_CMD_INDEX                                           0x008778 /* <= gfx6 */
#define   S_008778_CMD_INDEX(x)                                       (((unsigned)(x) & 0x7FF) << 0)
#define   G_008778_CMD_INDEX(x)                                       (((x) >> 0) & 0x7FF)
#define   C_008778_CMD_INDEX                                          0xFFFFF800
#define   S_008778_CMD_ME_SEL(x)                                      (((unsigned)(x) & 0x3) << 12)
#define   G_008778_CMD_ME_SEL(x)                                      (((x) >> 12) & 0x3)
#define   C_008778_CMD_ME_SEL                                         0xFFFFCFFF
#define   S_008778_CMD_QUEUE_SEL(x)                                   (((unsigned)(x) & 0x3) << 16)
#define   G_008778_CMD_QUEUE_SEL(x)                                   (((x) >> 16) & 0x3)
#define   C_008778_CMD_QUEUE_SEL                                      0xFFFCFFFF
#define R_00877C_CP_CMD_DATA                                            0x00877C /* <= gfx6 */
#define R_008780_CP_ROQ_RB_STAT                                         0x008780 /* <= gfx6 */
#define   S_008780_ROQ_RPTR_PRIMARY(x)                                (((unsigned)(x) & 0x3FF) << 0)
#define   G_008780_ROQ_RPTR_PRIMARY(x)                                (((x) >> 0) & 0x3FF)
#define   C_008780_ROQ_RPTR_PRIMARY                                   0xFFFFFC00
#define   S_008780_ROQ_WPTR_PRIMARY(x)                                (((unsigned)(x) & 0x3FF) << 16)
#define   G_008780_ROQ_WPTR_PRIMARY(x)                                (((x) >> 16) & 0x3FF)
#define   C_008780_ROQ_WPTR_PRIMARY                                   0xFC00FFFF
#define R_008784_CP_ROQ_IB1_STAT                                        0x008784 /* <= gfx6 */
#define   S_008784_ROQ_RPTR_INDIRECT1(x)                              (((unsigned)(x) & 0x3FF) << 0)
#define   G_008784_ROQ_RPTR_INDIRECT1(x)                              (((x) >> 0) & 0x3FF)
#define   C_008784_ROQ_RPTR_INDIRECT1                                 0xFFFFFC00
#define   S_008784_ROQ_WPTR_INDIRECT1(x)                              (((unsigned)(x) & 0x3FF) << 16)
#define   G_008784_ROQ_WPTR_INDIRECT1(x)                              (((x) >> 16) & 0x3FF)
#define   C_008784_ROQ_WPTR_INDIRECT1                                 0xFC00FFFF
#define R_008788_CP_ROQ_IB2_STAT                                        0x008788 /* <= gfx6 */
#define   S_008788_ROQ_RPTR_INDIRECT2(x)                              (((unsigned)(x) & 0x3FF) << 0)
#define   G_008788_ROQ_RPTR_INDIRECT2(x)                              (((x) >> 0) & 0x3FF)
#define   C_008788_ROQ_RPTR_INDIRECT2                                 0xFFFFFC00
#define   S_008788_ROQ_WPTR_INDIRECT2(x)                              (((unsigned)(x) & 0x3FF) << 16)
#define   G_008788_ROQ_WPTR_INDIRECT2(x)                              (((x) >> 16) & 0x3FF)
#define   C_008788_ROQ_WPTR_INDIRECT2                                 0xFC00FFFF
#define R_00878C_CP_STQ_STAT                                            0x00878C /* <= gfx6 */
#define   S_00878C_STQ_RPTR(x)                                        (((unsigned)(x) & 0x3FF) << 0)
#define   G_00878C_STQ_RPTR(x)                                        (((x) >> 0) & 0x3FF)
#define   C_00878C_STQ_RPTR                                           0xFFFFFC00
#define R_008794_CP_MEQ_STAT                                            0x008794 /* <= gfx6 */
#define   S_008794_MEQ_RPTR(x)                                        (((unsigned)(x) & 0x3FF) << 0)
#define   G_008794_MEQ_RPTR(x)                                        (((x) >> 0) & 0x3FF)
#define   C_008794_MEQ_RPTR                                           0xFFFFFC00
#define   S_008794_MEQ_WPTR(x)                                        (((unsigned)(x) & 0x3FF) << 16)
#define   G_008794_MEQ_WPTR(x)                                        (((x) >> 16) & 0x3FF)
#define   C_008794_MEQ_WPTR                                           0xFC00FFFF
#define R_008798_CP_CEQ1_AVAIL                                          0x008798 /* <= gfx6 */
#define   S_008798_CEQ_CNT_RING(x)                                    (((unsigned)(x) & 0x7FF) << 0)
#define   G_008798_CEQ_CNT_RING(x)                                    (((x) >> 0) & 0x7FF)
#define   C_008798_CEQ_CNT_RING                                       0xFFFFF800
#define   S_008798_CEQ_CNT_IB1(x)                                     (((unsigned)(x) & 0x7FF) << 16)
#define   G_008798_CEQ_CNT_IB1(x)                                     (((x) >> 16) & 0x7FF)
#define   C_008798_CEQ_CNT_IB1                                        0xF800FFFF
#define R_00879C_CP_CEQ2_AVAIL                                          0x00879C /* <= gfx6 */
#define   S_00879C_CEQ_CNT_IB2(x)                                     (((unsigned)(x) & 0x7FF) << 0)
#define   G_00879C_CEQ_CNT_IB2(x)                                     (((x) >> 0) & 0x7FF)
#define   C_00879C_CEQ_CNT_IB2                                        0xFFFFF800
#define R_0087A0_CP_CE_ROQ_RB_STAT                                      0x0087A0 /* <= gfx6 */
#define   S_0087A0_CEQ_RPTR_PRIMARY(x)                                (((unsigned)(x) & 0x3FF) << 0)
#define   G_0087A0_CEQ_RPTR_PRIMARY(x)                                (((x) >> 0) & 0x3FF)
#define   C_0087A0_CEQ_RPTR_PRIMARY                                   0xFFFFFC00
#define   S_0087A0_CEQ_WPTR_PRIMARY(x)                                (((unsigned)(x) & 0x3FF) << 16)
#define   G_0087A0_CEQ_WPTR_PRIMARY(x)                                (((x) >> 16) & 0x3FF)
#define   C_0087A0_CEQ_WPTR_PRIMARY                                   0xFC00FFFF
#define R_0087A4_CP_CE_ROQ_IB1_STAT                                     0x0087A4 /* <= gfx6 */
#define   S_0087A4_CEQ_RPTR_INDIRECT1(x)                              (((unsigned)(x) & 0x3FF) << 0)
#define   G_0087A4_CEQ_RPTR_INDIRECT1(x)                              (((x) >> 0) & 0x3FF)
#define   C_0087A4_CEQ_RPTR_INDIRECT1                                 0xFFFFFC00
#define   S_0087A4_CEQ_WPTR_INDIRECT1(x)                              (((unsigned)(x) & 0x3FF) << 16)
#define   G_0087A4_CEQ_WPTR_INDIRECT1(x)                              (((x) >> 16) & 0x3FF)
#define   C_0087A4_CEQ_WPTR_INDIRECT1                                 0xFC00FFFF
#define R_0087A8_CP_CE_ROQ_IB2_STAT                                     0x0087A8 /* <= gfx6 */
#define   S_0087A8_CEQ_RPTR_INDIRECT2(x)                              (((unsigned)(x) & 0x3FF) << 0)
#define   G_0087A8_CEQ_RPTR_INDIRECT2(x)                              (((x) >> 0) & 0x3FF)
#define   C_0087A8_CEQ_RPTR_INDIRECT2                                 0xFFFFFC00
#define   S_0087A8_CEQ_WPTR_INDIRECT2(x)                              (((unsigned)(x) & 0x3FF) << 16)
#define   G_0087A8_CEQ_WPTR_INDIRECT2(x)                              (((x) >> 16) & 0x3FF)
#define   C_0087A8_CEQ_WPTR_INDIRECT2                                 0xFC00FFFF
#define R_0087DC_CP_INT_STAT_DEBUG                                      0x0087DC /* <= gfx6 */
#define   S_0087DC_CP_ECC_ERROR_INT_ASSERTED(x)                       (((unsigned)(x) & 0x1) << 14)
#define   G_0087DC_CP_ECC_ERROR_INT_ASSERTED(x)                       (((x) >> 14) & 0x1)
#define   C_0087DC_CP_ECC_ERROR_INT_ASSERTED                          0xFFFFBFFF
#define   S_0087DC_WRM_POLL_TIMEOUT_INT_ASSERTED(x)                   (((unsigned)(x) & 0x1) << 17)
#define   G_0087DC_WRM_POLL_TIMEOUT_INT_ASSERTED(x)                   (((x) >> 17) & 0x1)
#define   C_0087DC_WRM_POLL_TIMEOUT_INT_ASSERTED                      0xFFFDFFFF
#define   S_0087DC_CNTX_BUSY_INT_ASSERTED(x)                          (((unsigned)(x) & 0x1) << 19)
#define   G_0087DC_CNTX_BUSY_INT_ASSERTED(x)                          (((x) >> 19) & 0x1)
#define   C_0087DC_CNTX_BUSY_INT_ASSERTED                             0xFFF7FFFF
#define   S_0087DC_CNTX_EMPTY_INT_ASSERTED(x)                         (((unsigned)(x) & 0x1) << 20)
#define   G_0087DC_CNTX_EMPTY_INT_ASSERTED(x)                         (((x) >> 20) & 0x1)
#define   C_0087DC_CNTX_EMPTY_INT_ASSERTED                            0xFFEFFFFF
#define   S_0087DC_PRIV_INSTR_INT_ASSERTED(x)                         (((unsigned)(x) & 0x1) << 22)
#define   G_0087DC_PRIV_INSTR_INT_ASSERTED(x)                         (((x) >> 22) & 0x1)
#define   C_0087DC_PRIV_INSTR_INT_ASSERTED                            0xFFBFFFFF
#define   S_0087DC_PRIV_REG_INT_ASSERTED(x)                           (((unsigned)(x) & 0x1) << 23)
#define   G_0087DC_PRIV_REG_INT_ASSERTED(x)                           (((x) >> 23) & 0x1)
#define   C_0087DC_PRIV_REG_INT_ASSERTED                              0xFF7FFFFF
#define   S_0087DC_OPCODE_ERROR_INT_ASSERTED(x)                       (((unsigned)(x) & 0x1) << 24)
#define   G_0087DC_OPCODE_ERROR_INT_ASSERTED(x)                       (((x) >> 24) & 0x1)
#define   C_0087DC_OPCODE_ERROR_INT_ASSERTED                          0xFEFFFFFF
#define   S_0087DC_TIME_STAMP_INT_ASSERTED(x)                         (((unsigned)(x) & 0x1) << 26)
#define   G_0087DC_TIME_STAMP_INT_ASSERTED(x)                         (((x) >> 26) & 0x1)
#define   C_0087DC_TIME_STAMP_INT_ASSERTED                            0xFBFFFFFF
#define   S_0087DC_RESERVED_BIT_ERROR_INT_ASSERTED(x)                 (((unsigned)(x) & 0x1) << 27)
#define   G_0087DC_RESERVED_BIT_ERROR_INT_ASSERTED(x)                 (((x) >> 27) & 0x1)
#define   C_0087DC_RESERVED_BIT_ERROR_INT_ASSERTED                    0xF7FFFFFF
#define   S_0087DC_GENERIC2_INT_ASSERTED(x)                           (((unsigned)(x) & 0x1) << 29)
#define   G_0087DC_GENERIC2_INT_ASSERTED(x)                           (((x) >> 29) & 0x1)
#define   C_0087DC_GENERIC2_INT_ASSERTED                              0xDFFFFFFF
#define   S_0087DC_GENERIC1_INT_ASSERTED(x)                           (((unsigned)(x) & 0x1) << 30)
#define   G_0087DC_GENERIC1_INT_ASSERTED(x)                           (((x) >> 30) & 0x1)
#define   C_0087DC_GENERIC1_INT_ASSERTED                              0xBFFFFFFF
#define   S_0087DC_GENERIC0_INT_ASSERTED(x)                           (((unsigned)(x) & 0x1) << 31)
#define   G_0087DC_GENERIC0_INT_ASSERTED(x)                           (((x) >> 31) & 0x1)
#define   C_0087DC_GENERIC0_INT_ASSERTED                              0x7FFFFFFF
#define R_0087FC_CP_PERFMON_CNTL                                        0x0087FC /* <= gfx6 */
#define   S_0087FC_PERFMON_STATE(x)                                   (((unsigned)(x) & 0xF) << 0)
#define   G_0087FC_PERFMON_STATE(x)                                   (((x) >> 0) & 0xF)
#define   C_0087FC_PERFMON_STATE                                      0xFFFFFFF0
#define     V_0087FC_CP_PERFMON_STATE_DISABLE_AND_RESET             0
#define     V_0087FC_CP_PERFMON_STATE_START_COUNTING                1
#define     V_0087FC_CP_PERFMON_STATE_STOP_COUNTING                 2
#define     V_0087FC_CP_PERFMON_STATE_RESERVED_3                    3
#define     V_0087FC_CP_PERFMON_STATE_DISABLE_AND_RESET_PHANTOM     4
#define     V_0087FC_CP_PERFMON_STATE_COUNT_AND_DUMP_PHANTOM        5
#define   S_0087FC_SPM_PERFMON_STATE(x)                               (((unsigned)(x) & 0xF) << 4)
#define   G_0087FC_SPM_PERFMON_STATE(x)                               (((x) >> 4) & 0xF)
#define   C_0087FC_SPM_PERFMON_STATE                                  0xFFFFFF0F
#define     V_0087FC_STRM_PERFMON_STATE_DISABLE_AND_RESET           0
#define     V_0087FC_STRM_PERFMON_STATE_START_COUNTING              1
#define     V_0087FC_STRM_PERFMON_STATE_STOP_COUNTING               2
#define     V_0087FC_STRM_PERFMON_STATE_RESERVED_3                  3
#define     V_0087FC_STRM_PERFMON_STATE_DISABLE_AND_RESET_PHANTOM   4
#define     V_0087FC_STRM_PERFMON_STATE_COUNT_AND_DUMP_PHANTOM      5
#define   S_0087FC_PERFMON_ENABLE_MODE(x)                             (((unsigned)(x) & 0x3) << 8)
#define   G_0087FC_PERFMON_ENABLE_MODE(x)                             (((x) >> 8) & 0x3)
#define   C_0087FC_PERFMON_ENABLE_MODE                                0xFFFFFCFF
#define     V_0087FC_CP_PERFMON_ENABLE_MODE_ALWAYS_COUNT            0
#define     V_0087FC_CP_PERFMON_ENABLE_MODE_RESERVED_1              1
#define     V_0087FC_CP_PERFMON_ENABLE_MODE_COUNT_CONTEXT_TRUE      2
#define     V_0087FC_CP_PERFMON_ENABLE_MODE_COUNT_CONTEXT_FALSE     3
#define   S_0087FC_PERFMON_SAMPLE_ENABLE(x)                           (((unsigned)(x) & 0x1) << 10)
#define   G_0087FC_PERFMON_SAMPLE_ENABLE(x)                           (((x) >> 10) & 0x1)
#define   C_0087FC_PERFMON_SAMPLE_ENABLE                              0xFFFFFBFF
#define R_008880_IA_PERFCOUNTER0_SELECT                                 0x008880 /* <= gfx6 */
#define   S_008880_PERF_SEL(x)                                        (((unsigned)(x) & 0xFF) << 0)
#define   G_008880_PERF_SEL(x)                                        (((x) >> 0) & 0xFF)
#define   C_008880_PERF_SEL                                           0xFFFFFF00
#define   S_008880_PERF_SEL1(x)                                       (((unsigned)(x) & 0x3FF) << 10)
#define   G_008880_PERF_SEL1(x)                                       (((x) >> 10) & 0x3FF)
#define   C_008880_PERF_SEL1                                          0xFFF003FF
#define   S_008880_CNTR_MODE(x)                                       (((unsigned)(x) & 0xF) << 20)
#define   G_008880_CNTR_MODE(x)                                       (((x) >> 20) & 0xF)
#define   C_008880_CNTR_MODE                                          0xFF0FFFFF
#define   S_008880_PERF_MODE1(x)                                      (((unsigned)(x) & 0xF) << 24)
#define   G_008880_PERF_MODE1(x)                                      (((x) >> 24) & 0xF)
#define   C_008880_PERF_MODE1                                         0xF0FFFFFF
#define   S_008880_PERF_MODE(x)                                       (((unsigned)(x) & 0xF) << 28)
#define   G_008880_PERF_MODE(x)                                       (((x) >> 28) & 0xF)
#define   C_008880_PERF_MODE                                          0x0FFFFFFF
#define R_008884_IA_PERFCOUNTER1_SELECT                                 0x008884 /* <= gfx6 */
#define   S_008884_PERF_SEL(x)                                        (((unsigned)(x) & 0xFF) << 0)
#define   G_008884_PERF_SEL(x)                                        (((x) >> 0) & 0xFF)
#define   C_008884_PERF_SEL                                           0xFFFFFF00
#define   S_008884_PERF_MODE(x)                                       (((unsigned)(x) & 0xF) << 28)
#define   G_008884_PERF_MODE(x)                                       (((x) >> 28) & 0xF)
#define   C_008884_PERF_MODE                                          0x0FFFFFFF
#define R_008888_IA_PERFCOUNTER2_SELECT                                 0x008888 /* <= gfx6 */
#define R_00888C_IA_PERFCOUNTER3_SELECT                                 0x00888C /* <= gfx6 */
#define R_008890_IA_PERFCOUNTER0_LO                                     0x008890 /* <= gfx6 */
#define R_008894_IA_PERFCOUNTER0_HI                                     0x008894 /* <= gfx6 */
#define R_008898_IA_PERFCOUNTER1_LO                                     0x008898 /* <= gfx6 */
#define R_00889C_IA_PERFCOUNTER1_HI                                     0x00889C /* <= gfx6 */
#define R_0088A0_IA_PERFCOUNTER2_LO                                     0x0088A0 /* <= gfx6 */
#define R_0088A4_IA_PERFCOUNTER2_HI                                     0x0088A4 /* <= gfx6 */
#define R_0088A8_IA_PERFCOUNTER3_LO                                     0x0088A8 /* <= gfx6 */
#define R_0088AC_IA_PERFCOUNTER3_HI                                     0x0088AC /* <= gfx6 */
#define R_0088B0_VGT_VTX_VECT_EJECT_REG                                 0x0088B0 /* <= gfx6 */
#define   S_0088B0_PRIM_COUNT(x)                                      (((unsigned)(x) & 0x3FF) << 0)
#define   G_0088B0_PRIM_COUNT(x)                                      (((x) >> 0) & 0x3FF)
#define   C_0088B0_PRIM_COUNT                                         0xFFFFFC00
#define R_0088B4_VGT_DMA_DATA_FIFO_DEPTH                                0x0088B4 /* <= gfx6 */
#define   S_0088B4_DMA_DATA_FIFO_DEPTH(x)                             (((unsigned)(x) & 0x1FF) << 0)
#define   G_0088B4_DMA_DATA_FIFO_DEPTH(x)                             (((x) >> 0) & 0x1FF)
#define   C_0088B4_DMA_DATA_FIFO_DEPTH                                0xFFFFFE00
#define R_0088B8_VGT_DMA_REQ_FIFO_DEPTH                                 0x0088B8 /* <= gfx6 */
#define   S_0088B8_DMA_REQ_FIFO_DEPTH(x)                              (((unsigned)(x) & 0x3F) << 0)
#define   G_0088B8_DMA_REQ_FIFO_DEPTH(x)                              (((x) >> 0) & 0x3F)
#define   C_0088B8_DMA_REQ_FIFO_DEPTH                                 0xFFFFFFC0
#define R_0088BC_VGT_DRAW_INIT_FIFO_DEPTH                               0x0088BC /* <= gfx6 */
#define   S_0088BC_DRAW_INIT_FIFO_DEPTH(x)                            (((unsigned)(x) & 0x3F) << 0)
#define   G_0088BC_DRAW_INIT_FIFO_DEPTH(x)                            (((x) >> 0) & 0x3F)
#define   C_0088BC_DRAW_INIT_FIFO_DEPTH                               0xFFFFFFC0
#define R_0088C0_VGT_LAST_COPY_STATE                                    0x0088C0 /* <= gfx6 */
#define   S_0088C0_SRC_STATE_ID(x)                                    (((unsigned)(x) & 0x7) << 0)
#define   G_0088C0_SRC_STATE_ID(x)                                    (((x) >> 0) & 0x7)
#define   C_0088C0_SRC_STATE_ID                                       0xFFFFFFF8
#define   S_0088C0_DST_STATE_ID(x)                                    (((unsigned)(x) & 0x7) << 16)
#define   G_0088C0_DST_STATE_ID(x)                                    (((x) >> 16) & 0x7)
#define   C_0088C0_DST_STATE_ID                                       0xFFF8FFFF
#define R_0088C4_VGT_CACHE_INVALIDATION                                 0x0088C4 /* <= gfx6 */
#define   S_0088C4_CACHE_INVALIDATION(x)                              (((unsigned)(x) & 0x3) << 0)
#define   G_0088C4_CACHE_INVALIDATION(x)                              (((x) >> 0) & 0x3)
#define   C_0088C4_CACHE_INVALIDATION                                 0xFFFFFFFC
#define   S_0088C4_VS_NO_EXTRA_BUFFER(x)                              (((unsigned)(x) & 0x1) << 5)
#define   G_0088C4_VS_NO_EXTRA_BUFFER(x)                              (((x) >> 5) & 0x1)
#define   C_0088C4_VS_NO_EXTRA_BUFFER                                 0xFFFFFFDF
#define   S_0088C4_AUTO_INVLD_EN(x)                                   (((unsigned)(x) & 0x3) << 6)
#define   G_0088C4_AUTO_INVLD_EN(x)                                   (((x) >> 6) & 0x3)
#define   C_0088C4_AUTO_INVLD_EN                                      0xFFFFFF3F
#define   S_0088C4_USE_GS_DONE(x)                                     (((unsigned)(x) & 0x1) << 9)
#define   G_0088C4_USE_GS_DONE(x)                                     (((x) >> 9) & 0x1)
#define   C_0088C4_USE_GS_DONE                                        0xFFFFFDFF
#define   S_0088C4_DIS_RANGE_FULL_INVLD(x)                            (((unsigned)(x) & 0x1) << 11)
#define   G_0088C4_DIS_RANGE_FULL_INVLD(x)                            (((x) >> 11) & 0x1)
#define   C_0088C4_DIS_RANGE_FULL_INVLD                               0xFFFFF7FF
#define   S_0088C4_GS_LATE_ALLOC_EN(x)                                (((unsigned)(x) & 0x1) << 12)
#define   G_0088C4_GS_LATE_ALLOC_EN(x)                                (((x) >> 12) & 0x1)
#define   C_0088C4_GS_LATE_ALLOC_EN                                   0xFFFFEFFF
#define   S_0088C4_STREAMOUT_FULL_FLUSH(x)                            (((unsigned)(x) & 0x1) << 13)
#define   G_0088C4_STREAMOUT_FULL_FLUSH(x)                            (((x) >> 13) & 0x1)
#define   C_0088C4_STREAMOUT_FULL_FLUSH                               0xFFFFDFFF
#define   S_0088C4_ES_LIMIT(x)                                        (((unsigned)(x) & 0x1F) << 16)
#define   G_0088C4_ES_LIMIT(x)                                        (((x) >> 16) & 0x1F)
#define   C_0088C4_ES_LIMIT                                           0xFFE0FFFF
#define R_0088C8_VGT_ESGS_RING_SIZE                                     0x0088C8 /* <= gfx6 */
#define R_0088CC_VGT_GSVS_RING_SIZE                                     0x0088CC /* <= gfx6 */
#define R_0088D0_VGT_FIFO_DEPTHS                                        0x0088D0 /* <= gfx6 */
#define   S_0088D0_VS_DEALLOC_TBL_DEPTH(x)                            (((unsigned)(x) & 0x7F) << 0)
#define   G_0088D0_VS_DEALLOC_TBL_DEPTH(x)                            (((x) >> 0) & 0x7F)
#define   C_0088D0_VS_DEALLOC_TBL_DEPTH                               0xFFFFFF80
#define   S_0088D0_RESERVED_0(x)                                      (((unsigned)(x) & 0x1) << 7)
#define   G_0088D0_RESERVED_0(x)                                      (((x) >> 7) & 0x1)
#define   C_0088D0_RESERVED_0                                         0xFFFFFF7F
#define   S_0088D0_CLIPP_FIFO_DEPTH(x)                                (((unsigned)(x) & 0x3FFF) << 8)
#define   G_0088D0_CLIPP_FIFO_DEPTH(x)                                (((x) >> 8) & 0x3FFF)
#define   C_0088D0_CLIPP_FIFO_DEPTH                                   0xFFC000FF
#define   S_0088D0_RESERVED_1(x)                                      (((unsigned)(x) & 0x3FF) << 22)
#define   G_0088D0_RESERVED_1(x)                                      (((x) >> 22) & 0x3FF)
#define   C_0088D0_RESERVED_1                                         0x003FFFFF
#define R_0088D4_VGT_GS_VERTEX_REUSE                                    0x0088D4 /* <= gfx6 */
#define   S_0088D4_VERT_REUSE(x)                                      (((unsigned)(x) & 0x1F) << 0)
#define   G_0088D4_VERT_REUSE(x)                                      (((x) >> 0) & 0x1F)
#define   C_0088D4_VERT_REUSE                                         0xFFFFFFE0
#define R_0088D8_VGT_MC_LAT_CNTL                                        0x0088D8 /* <= gfx6 */
#define   S_0088D8_MC_TIME_STAMP_RES(x)                               (((unsigned)(x) & 0x3) << 0)
#define   G_0088D8_MC_TIME_STAMP_RES(x)                               (((x) >> 0) & 0x3)
#define   C_0088D8_MC_TIME_STAMP_RES                                  0xFFFFFFFC
#define R_0088DC_IA_CNTL_STATUS                                         0x0088DC /* <= gfx6 */
#define   S_0088DC_IA_BUSY(x)                                         (((unsigned)(x) & 0x1) << 0)
#define   G_0088DC_IA_BUSY(x)                                         (((x) >> 0) & 0x1)
#define   C_0088DC_IA_BUSY                                            0xFFFFFFFE
#define   S_0088DC_IA_DMA_BUSY(x)                                     (((unsigned)(x) & 0x1) << 1)
#define   G_0088DC_IA_DMA_BUSY(x)                                     (((x) >> 1) & 0x1)
#define   C_0088DC_IA_DMA_BUSY                                        0xFFFFFFFD
#define   S_0088DC_IA_DMA_REQ_BUSY(x)                                 (((unsigned)(x) & 0x1) << 2)
#define   G_0088DC_IA_DMA_REQ_BUSY(x)                                 (((x) >> 2) & 0x1)
#define   C_0088DC_IA_DMA_REQ_BUSY                                    0xFFFFFFFB
#define   S_0088DC_IA_GRP_BUSY(x)                                     (((unsigned)(x) & 0x1) << 3)
#define   G_0088DC_IA_GRP_BUSY(x)                                     (((x) >> 3) & 0x1)
#define   C_0088DC_IA_GRP_BUSY                                        0xFFFFFFF7
#define   S_0088DC_IA_ADC_BUSY(x)                                     (((unsigned)(x) & 0x1) << 4)
#define   G_0088DC_IA_ADC_BUSY(x)                                     (((x) >> 4) & 0x1)
#define   C_0088DC_IA_ADC_BUSY                                        0xFFFFFFEF
#define R_0088E0_VGT_DEBUG_CNTL                                         0x0088E0 /* <= gfx6 */
#define   S_0088E0_VGT_DEBUG_INDX(x)                                  (((unsigned)(x) & 0x3F) << 0)
#define   G_0088E0_VGT_DEBUG_INDX(x)                                  (((x) >> 0) & 0x3F)
#define   C_0088E0_VGT_DEBUG_INDX                                     0xFFFFFFC0
#define   S_0088E0_VGT_DEBUG_SEL_BUS_B(x)                             (((unsigned)(x) & 0x1) << 6)
#define   G_0088E0_VGT_DEBUG_SEL_BUS_B(x)                             (((x) >> 6) & 0x1)
#define   C_0088E0_VGT_DEBUG_SEL_BUS_B                                0xFFFFFFBF
#define R_0088E4_VGT_DEBUG_DATA                                         0x0088E4 /* <= gfx6 */
#define R_0088E8_IA_DEBUG_CNTL                                          0x0088E8 /* <= gfx6 */
#define   S_0088E8_IA_DEBUG_INDX(x)                                   (((unsigned)(x) & 0x3F) << 0)
#define   G_0088E8_IA_DEBUG_INDX(x)                                   (((x) >> 0) & 0x3F)
#define   C_0088E8_IA_DEBUG_INDX                                      0xFFFFFFC0
#define   S_0088E8_IA_DEBUG_SEL_BUS_B(x)                              (((unsigned)(x) & 0x1) << 6)
#define   G_0088E8_IA_DEBUG_SEL_BUS_B(x)                              (((x) >> 6) & 0x1)
#define   C_0088E8_IA_DEBUG_SEL_BUS_B                                 0xFFFFFFBF
#define R_0088EC_IA_DEBUG_DATA                                          0x0088EC /* <= gfx6 */
#define R_0088F0_VGT_CNTL_STATUS                                        0x0088F0 /* <= gfx6 */
#define   S_0088F0_VGT_BUSY(x)                                        (((unsigned)(x) & 0x1) << 0)
#define   G_0088F0_VGT_BUSY(x)                                        (((x) >> 0) & 0x1)
#define   C_0088F0_VGT_BUSY                                           0xFFFFFFFE
#define   S_0088F0_VGT_OUT_INDX_BUSY(x)                               (((unsigned)(x) & 0x1) << 1)
#define   G_0088F0_VGT_OUT_INDX_BUSY(x)                               (((x) >> 1) & 0x1)
#define   C_0088F0_VGT_OUT_INDX_BUSY                                  0xFFFFFFFD
#define   S_0088F0_VGT_OUT_BUSY(x)                                    (((unsigned)(x) & 0x1) << 2)
#define   G_0088F0_VGT_OUT_BUSY(x)                                    (((x) >> 2) & 0x1)
#define   C_0088F0_VGT_OUT_BUSY                                       0xFFFFFFFB
#define   S_0088F0_VGT_PT_BUSY(x)                                     (((unsigned)(x) & 0x1) << 3)
#define   G_0088F0_VGT_PT_BUSY(x)                                     (((x) >> 3) & 0x1)
#define   C_0088F0_VGT_PT_BUSY                                        0xFFFFFFF7
#define   S_0088F0_VGT_TE_BUSY(x)                                     (((unsigned)(x) & 0x1) << 4)
#define   G_0088F0_VGT_TE_BUSY(x)                                     (((x) >> 4) & 0x1)
#define   C_0088F0_VGT_TE_BUSY                                        0xFFFFFFEF
#define   S_0088F0_VGT_VR_BUSY(x)                                     (((unsigned)(x) & 0x1) << 5)
#define   G_0088F0_VGT_VR_BUSY(x)                                     (((x) >> 5) & 0x1)
#define   C_0088F0_VGT_VR_BUSY                                        0xFFFFFFDF
#define   S_0088F0_VGT_PI_BUSY(x)                                     (((unsigned)(x) & 0x1) << 6)
#define   G_0088F0_VGT_PI_BUSY(x)                                     (((x) >> 6) & 0x1)
#define   C_0088F0_VGT_PI_BUSY                                        0xFFFFFFBF
#define   S_0088F0_VGT_GS_BUSY(x)                                     (((unsigned)(x) & 0x1) << 7)
#define   G_0088F0_VGT_GS_BUSY(x)                                     (((x) >> 7) & 0x1)
#define   C_0088F0_VGT_GS_BUSY                                        0xFFFFFF7F
#define   S_0088F0_VGT_HS_BUSY(x)                                     (((unsigned)(x) & 0x1) << 8)
#define   G_0088F0_VGT_HS_BUSY(x)                                     (((x) >> 8) & 0x1)
#define   C_0088F0_VGT_HS_BUSY                                        0xFFFFFEFF
#define   S_0088F0_VGT_TE11_BUSY(x)                                   (((unsigned)(x) & 0x1) << 9)
#define   G_0088F0_VGT_TE11_BUSY(x)                                   (((x) >> 9) & 0x1)
#define   C_0088F0_VGT_TE11_BUSY                                      0xFFFFFDFF
#define R_00891C_VGT_PERFCOUNTER_SEID_MASK                              0x00891C /* <= gfx6 */
#define   S_00891C_PERF_SEID_IGNORE_MASK(x)                           (((unsigned)(x) & 0xFF) << 0)
#define   G_00891C_PERF_SEID_IGNORE_MASK(x)                           (((x) >> 0) & 0xFF)
#define   C_00891C_PERF_SEID_IGNORE_MASK                              0xFFFFFF00
#define R_008920_VGT_PERFCOUNTER0_SELECT                                0x008920 /* <= gfx6 */
#define   S_008920_PERF_SEL(x)                                        (((unsigned)(x) & 0xFF) << 0)
#define   G_008920_PERF_SEL(x)                                        (((x) >> 0) & 0xFF)
#define   C_008920_PERF_SEL                                           0xFFFFFF00
#define   S_008920_PERF_SEL1(x)                                       (((unsigned)(x) & 0x3FF) << 10)
#define   G_008920_PERF_SEL1(x)                                       (((x) >> 10) & 0x3FF)
#define   C_008920_PERF_SEL1                                          0xFFF003FF
#define   S_008920_CNTR_MODE(x)                                       (((unsigned)(x) & 0xF) << 20)
#define   G_008920_CNTR_MODE(x)                                       (((x) >> 20) & 0xF)
#define   C_008920_CNTR_MODE                                          0xFF0FFFFF
#define   S_008920_PERF_MODE1(x)                                      (((unsigned)(x) & 0xF) << 24)
#define   G_008920_PERF_MODE1(x)                                      (((x) >> 24) & 0xF)
#define   C_008920_PERF_MODE1                                         0xF0FFFFFF
#define   S_008920_PERF_MODE(x)                                       (((unsigned)(x) & 0xF) << 28)
#define   G_008920_PERF_MODE(x)                                       (((x) >> 28) & 0xF)
#define   C_008920_PERF_MODE                                          0x0FFFFFFF
#define R_008924_VGT_PERFCOUNTER1_SELECT                                0x008924 /* <= gfx6 */
#define R_008928_VGT_PERFCOUNTER2_SELECT                                0x008928 /* <= gfx6 */
#define   S_008928_PERF_SEL(x)                                        (((unsigned)(x) & 0xFF) << 0)
#define   G_008928_PERF_SEL(x)                                        (((x) >> 0) & 0xFF)
#define   C_008928_PERF_SEL                                           0xFFFFFF00
#define   S_008928_PERF_MODE(x)                                       (((unsigned)(x) & 0xF) << 28)
#define   G_008928_PERF_MODE(x)                                       (((x) >> 28) & 0xF)
#define   C_008928_PERF_MODE                                          0x0FFFFFFF
#define R_00892C_VGT_PERFCOUNTER3_SELECT                                0x00892C /* <= gfx6 */
#define R_008930_VGT_PERFCOUNTER0_LO                                    0x008930 /* <= gfx6 */
#define R_008934_VGT_PERFCOUNTER0_HI                                    0x008934 /* <= gfx6 */
#define R_008938_VGT_PERFCOUNTER1_LO                                    0x008938 /* <= gfx6 */
#define R_00893C_VGT_PERFCOUNTER1_HI                                    0x00893C /* <= gfx6 */
#define R_008940_VGT_PERFCOUNTER2_LO                                    0x008940 /* <= gfx6 */
#define R_008944_VGT_PERFCOUNTER2_HI                                    0x008944 /* <= gfx6 */
#define R_008948_VGT_PERFCOUNTER3_LO                                    0x008948 /* <= gfx6 */
#define R_00894C_VGT_PERFCOUNTER3_HI                                    0x00894C /* <= gfx6 */
#define R_008958_VGT_PRIMITIVE_TYPE                                     0x008958 /* <= gfx6 */
#define   S_008958_PRIM_TYPE(x)                                       (((unsigned)(x) & 0x3F) << 0)
#define   G_008958_PRIM_TYPE(x)                                       (((x) >> 0) & 0x3F)
#define   C_008958_PRIM_TYPE                                          0xFFFFFFC0
#define     V_008958_DI_PT_NONE                                     0
#define     V_008958_DI_PT_POINTLIST                                1
#define     V_008958_DI_PT_LINELIST                                 2
#define     V_008958_DI_PT_LINESTRIP                                3
#define     V_008958_DI_PT_TRILIST                                  4
#define     V_008958_DI_PT_TRIFAN                                   5
#define     V_008958_DI_PT_TRISTRIP                                 6
#define     V_008958_DI_PT_UNUSED_0                                 7
#define     V_008958_DI_PT_UNUSED_1                                 8
#define     V_008958_DI_PT_PATCH                                    9
#define     V_008958_DI_PT_LINELIST_ADJ                             10
#define     V_008958_DI_PT_LINESTRIP_ADJ                            11
#define     V_008958_DI_PT_TRILIST_ADJ                              12
#define     V_008958_DI_PT_TRISTRIP_ADJ                             13
#define     V_008958_DI_PT_UNUSED_3                                 14
#define     V_008958_DI_PT_UNUSED_4                                 15
#define     V_008958_DI_PT_TRI_WITH_WFLAGS                          16
#define     V_008958_DI_PT_RECTLIST                                 17
#define     V_008958_DI_PT_LINELOOP                                 18
#define     V_008958_DI_PT_QUADLIST                                 19
#define     V_008958_DI_PT_QUADSTRIP                                20
#define     V_008958_DI_PT_POLYGON                                  21
#define     V_008958_DI_PT_2D_COPY_RECT_LIST_V0                     22
#define     V_008958_DI_PT_2D_COPY_RECT_LIST_V1                     23
#define     V_008958_DI_PT_2D_COPY_RECT_LIST_V2                     24
#define     V_008958_DI_PT_2D_COPY_RECT_LIST_V3                     25
#define     V_008958_DI_PT_2D_FILL_RECT_LIST                        26
#define     V_008958_DI_PT_2D_LINE_STRIP                            27
#define     V_008958_DI_PT_2D_TRI_STRIP                             28
#define R_00895C_VGT_INDEX_TYPE                                         0x00895C /* <= gfx6 */
#define   S_00895C_INDEX_TYPE(x)                                      (((unsigned)(x) & 0x3) << 0)
#define   G_00895C_INDEX_TYPE(x)                                      (((x) >> 0) & 0x3)
#define   C_00895C_INDEX_TYPE                                         0xFFFFFFFC
#define     V_00895C_VGT_INDEX_16                                   0
#define     V_00895C_VGT_INDEX_32                                   1
#define R_008960_VGT_STRMOUT_BUFFER_FILLED_SIZE_0                       0x008960 /* <= gfx6 */
#define R_008964_VGT_STRMOUT_BUFFER_FILLED_SIZE_1                       0x008964 /* <= gfx6 */
#define R_008968_VGT_STRMOUT_BUFFER_FILLED_SIZE_2                       0x008968 /* <= gfx6 */
#define R_00896C_VGT_STRMOUT_BUFFER_FILLED_SIZE_3                       0x00896C /* <= gfx6 */
#define R_008970_VGT_NUM_INDICES                                        0x008970 /* <= gfx6 */
#define R_008974_VGT_NUM_INSTANCES                                      0x008974 /* <= gfx6 */
#define R_00897C_CGTT_VGT_CLK_CTRL                                      0x00897C /* <= gfx6 */
#define   S_00897C_ON_DELAY(x)                                        (((unsigned)(x) & 0xF) << 0)
#define   G_00897C_ON_DELAY(x)                                        (((x) >> 0) & 0xF)
#define   C_00897C_ON_DELAY                                           0xFFFFFFF0
#define   S_00897C_OFF_HYSTERESIS(x)                                  (((unsigned)(x) & 0xFF) << 4)
#define   G_00897C_OFF_HYSTERESIS(x)                                  (((x) >> 4) & 0xFF)
#define   C_00897C_OFF_HYSTERESIS                                     0xFFFFF00F
#define   S_00897C_SOFT_OVERRIDE7(x)                                  (((unsigned)(x) & 0x1) << 24)
#define   G_00897C_SOFT_OVERRIDE7(x)                                  (((x) >> 24) & 0x1)
#define   C_00897C_SOFT_OVERRIDE7                                     0xFEFFFFFF
#define   S_00897C_PERF_ENABLE(x)                                     (((unsigned)(x) & 0x1) << 25)
#define   G_00897C_PERF_ENABLE(x)                                     (((x) >> 25) & 0x1)
#define   C_00897C_PERF_ENABLE                                        0xFDFFFFFF
#define   S_00897C_DBG_ENABLE(x)                                      (((unsigned)(x) & 0x1) << 26)
#define   G_00897C_DBG_ENABLE(x)                                      (((x) >> 26) & 0x1)
#define   C_00897C_DBG_ENABLE                                         0xFBFFFFFF
#define   S_00897C_SOFT_OVERRIDE4(x)                                  (((unsigned)(x) & 0x1) << 27)
#define   G_00897C_SOFT_OVERRIDE4(x)                                  (((x) >> 27) & 0x1)
#define   C_00897C_SOFT_OVERRIDE4                                     0xF7FFFFFF
#define   S_00897C_SOFT_OVERRIDE3(x)                                  (((unsigned)(x) & 0x1) << 28)
#define   G_00897C_SOFT_OVERRIDE3(x)                                  (((x) >> 28) & 0x1)
#define   C_00897C_SOFT_OVERRIDE3                                     0xEFFFFFFF
#define   S_00897C_GS_OVERRIDE(x)                                     (((unsigned)(x) & 0x1) << 29)
#define   G_00897C_GS_OVERRIDE(x)                                     (((x) >> 29) & 0x1)
#define   C_00897C_GS_OVERRIDE                                        0xDFFFFFFF
#define   S_00897C_CORE_OVERRIDE(x)                                   (((unsigned)(x) & 0x1) << 30)
#define   G_00897C_CORE_OVERRIDE(x)                                   (((x) >> 30) & 0x1)
#define   C_00897C_CORE_OVERRIDE                                      0xBFFFFFFF
#define   S_00897C_REG_OVERRIDE(x)                                    (((unsigned)(x) & 0x1) << 31)
#define   G_00897C_REG_OVERRIDE(x)                                    (((x) >> 31) & 0x1)
#define   C_00897C_REG_OVERRIDE                                       0x7FFFFFFF
#define R_008980_IA_VMID_OVERRIDE                                       0x008980 /* <= gfx6 */
#define   S_008980_ENABLE(x)                                          (((unsigned)(x) & 0x1) << 0)
#define   G_008980_ENABLE(x)                                          (((x) >> 0) & 0x1)
#define   C_008980_ENABLE                                             0xFFFFFFFE
#define   S_008980_VMID(x)                                            (((unsigned)(x) & 0xF) << 1)
#define   G_008980_VMID(x)                                            (((x) >> 1) & 0xF)
#define   C_008980_VMID                                               0xFFFFFFE1
#define R_008984_CGTT_IA_CLK_CTRL                                       0x008984 /* <= gfx6 */
#define   S_008984_ON_DELAY(x)                                        (((unsigned)(x) & 0xF) << 0)
#define   G_008984_ON_DELAY(x)                                        (((x) >> 0) & 0xF)
#define   C_008984_ON_DELAY                                           0xFFFFFFF0
#define   S_008984_OFF_HYSTERESIS(x)                                  (((unsigned)(x) & 0xFF) << 4)
#define   G_008984_OFF_HYSTERESIS(x)                                  (((x) >> 4) & 0xFF)
#define   C_008984_OFF_HYSTERESIS                                     0xFFFFF00F
#define   S_008984_SOFT_OVERRIDE7(x)                                  (((unsigned)(x) & 0x1) << 24)
#define   G_008984_SOFT_OVERRIDE7(x)                                  (((x) >> 24) & 0x1)
#define   C_008984_SOFT_OVERRIDE7                                     0xFEFFFFFF
#define   S_008984_PERF_ENABLE(x)                                     (((unsigned)(x) & 0x1) << 25)
#define   G_008984_PERF_ENABLE(x)                                     (((x) >> 25) & 0x1)
#define   C_008984_PERF_ENABLE                                        0xFDFFFFFF
#define   S_008984_DBG_ENABLE(x)                                      (((unsigned)(x) & 0x1) << 26)
#define   G_008984_DBG_ENABLE(x)                                      (((x) >> 26) & 0x1)
#define   C_008984_DBG_ENABLE                                         0xFBFFFFFF
#define   S_008984_SOFT_OVERRIDE4(x)                                  (((unsigned)(x) & 0x1) << 27)
#define   G_008984_SOFT_OVERRIDE4(x)                                  (((x) >> 27) & 0x1)
#define   C_008984_SOFT_OVERRIDE4                                     0xF7FFFFFF
#define   S_008984_SOFT_OVERRIDE3(x)                                  (((unsigned)(x) & 0x1) << 28)
#define   G_008984_SOFT_OVERRIDE3(x)                                  (((x) >> 28) & 0x1)
#define   C_008984_SOFT_OVERRIDE3                                     0xEFFFFFFF
#define   S_008984_CORE_OVERRIDE(x)                                   (((unsigned)(x) & 0x1) << 29)
#define   G_008984_CORE_OVERRIDE(x)                                   (((x) >> 29) & 0x1)
#define   C_008984_CORE_OVERRIDE                                      0xDFFFFFFF
#define   S_008984_SOFT_OVERRIDE2(x)                                  (((unsigned)(x) & 0x1) << 29)
#define   G_008984_SOFT_OVERRIDE2(x)                                  (((x) >> 29) & 0x1)
#define   C_008984_SOFT_OVERRIDE2                                     0xDFFFFFFF
#define   S_008984_REG_OVERRIDE(x)                                    (((unsigned)(x) & 0x1) << 31)
#define   G_008984_REG_OVERRIDE(x)                                    (((x) >> 31) & 0x1)
#define   C_008984_REG_OVERRIDE                                       0x7FFFFFFF
#define R_008988_VGT_TF_RING_SIZE                                       0x008988 /* <= gfx6 */
#define   S_008988_SIZE(x)                                            (((unsigned)(x) & 0xFFFF) << 0)
#define   G_008988_SIZE(x)                                            (((x) >> 0) & 0xFFFF)
#define   C_008988_SIZE                                               0xFFFF0000
#define R_00898C_VGT_SYS_CONFIG                                         0x00898C /* <= gfx6 */
#define   S_00898C_DUAL_CORE_EN(x)                                    (((unsigned)(x) & 0x1) << 0)
#define   G_00898C_DUAL_CORE_EN(x)                                    (((x) >> 0) & 0x1)
#define   C_00898C_DUAL_CORE_EN                                       0xFFFFFFFE
#define   S_00898C_MAX_LS_HS_THDGRP(x)                                (((unsigned)(x) & 0x3F) << 1)
#define   G_00898C_MAX_LS_HS_THDGRP(x)                                (((x) >> 1) & 0x3F)
#define   C_00898C_MAX_LS_HS_THDGRP                                   0xFFFFFF81
#define   S_00898C_ADC_EVENT_FILTER_DISABLE(x)                        (((unsigned)(x) & 0x1) << 7)
#define   G_00898C_ADC_EVENT_FILTER_DISABLE(x)                        (((x) >> 7) & 0x1)
#define   C_00898C_ADC_EVENT_FILTER_DISABLE                           0xFFFFFF7F
#define R_0089B0_VGT_HS_OFFCHIP_PARAM                                   0x0089B0 /* <= gfx6 */
#define   S_0089B0_OFFCHIP_BUFFERING(x)                               (((unsigned)(x) & 0x7F) << 0)
#define   G_0089B0_OFFCHIP_BUFFERING(x)                               (((x) >> 0) & 0x7F)
#define   C_0089B0_OFFCHIP_BUFFERING                                  0xFFFFFF80
#define   S_0089B0_OFFCHIP_GRANULARITY(x)                             (((unsigned)(x) & 0x3) << 9)
#define   G_0089B0_OFFCHIP_GRANULARITY(x)                             (((x) >> 9) & 0x3)
#define   C_0089B0_OFFCHIP_GRANULARITY                                0xFFFFF9FF
#define     V_0089B0_X_8K_DWORDS                                    0
#define     V_0089B0_X_4K_DWORDS                                    1
#define     V_0089B0_X_2K_DWORDS                                    2
#define     V_0089B0_X_1K_DWORDS                                    3
#define R_0089B8_VGT_TF_MEMORY_BASE                                     0x0089B8 /* <= gfx6 */
#define R_0089BC_CC_GC_SHADER_ARRAY_CONFIG                              0x0089BC /* <= gfx6 */
#define   S_0089BC_DPFP_RATE(x)                                       (((unsigned)(x) & 0x3) << 1)
#define   G_0089BC_DPFP_RATE(x)                                       (((x) >> 1) & 0x3)
#define   C_0089BC_DPFP_RATE                                          0xFFFFFFF9
#define   S_0089BC_SQC_BALANCE_DISABLE(x)                             (((unsigned)(x) & 0x1) << 3)
#define   G_0089BC_SQC_BALANCE_DISABLE(x)                             (((x) >> 3) & 0x1)
#define   C_0089BC_SQC_BALANCE_DISABLE                                0xFFFFFFF7
#define   S_0089BC_HALF_LDS(x)                                        (((unsigned)(x) & 0x1) << 4)
#define   G_0089BC_HALF_LDS(x)                                        (((x) >> 4) & 0x1)
#define   C_0089BC_HALF_LDS                                           0xFFFFFFEF
#define   S_0089BC_INACTIVE_CUS(x)                                    (((unsigned)(x) & 0xFFFF) << 16)
#define   G_0089BC_INACTIVE_CUS(x)                                    (((x) >> 16) & 0xFFFF)
#define   C_0089BC_INACTIVE_CUS                                       0x0000FFFF
#define R_0089C0_GC_USER_SHADER_ARRAY_CONFIG                            0x0089C0 /* <= gfx6 */
#define   S_0089C0_DPFP_RATE(x)                                       (((unsigned)(x) & 0x3) << 1)
#define   G_0089C0_DPFP_RATE(x)                                       (((x) >> 1) & 0x3)
#define   C_0089C0_DPFP_RATE                                          0xFFFFFFF9
#define   S_0089C0_SQC_BALANCE_DISABLE(x)                             (((unsigned)(x) & 0x1) << 3)
#define   G_0089C0_SQC_BALANCE_DISABLE(x)                             (((x) >> 3) & 0x1)
#define   C_0089C0_SQC_BALANCE_DISABLE                                0xFFFFFFF7
#define   S_0089C0_HALF_LDS(x)                                        (((unsigned)(x) & 0x1) << 4)
#define   G_0089C0_HALF_LDS(x)                                        (((x) >> 4) & 0x1)
#define   C_0089C0_HALF_LDS                                           0xFFFFFFEF
#define   S_0089C0_INACTIVE_CUS(x)                                    (((unsigned)(x) & 0xFFFF) << 16)
#define   G_0089C0_INACTIVE_CUS(x)                                    (((x) >> 16) & 0xFFFF)
#define   C_0089C0_INACTIVE_CUS                                       0x0000FFFF
#define R_008A00_PA_SU_DEBUG_CNTL                                       0x008A00 /* <= gfx6 */
#define   S_008A00_SU_DEBUG_INDX(x)                                   (((unsigned)(x) & 0x1F) << 0)
#define   G_008A00_SU_DEBUG_INDX(x)                                   (((x) >> 0) & 0x1F)
#define   C_008A00_SU_DEBUG_INDX                                      0xFFFFFFE0
#define R_008A04_PA_SU_DEBUG_DATA                                       0x008A04 /* <= gfx6 */
#define R_008A10_PA_CL_CNTL_STATUS                                      0x008A10 /* <= gfx6 */
#define   S_008A10_CL_BUSY(x)                                         (((unsigned)(x) & 0x1) << 31)
#define   G_008A10_CL_BUSY(x)                                         (((x) >> 31) & 0x1)
#define   C_008A10_CL_BUSY                                            0x7FFFFFFF
#define R_008A14_PA_CL_ENHANCE                                          0x008A14 /* <= gfx6 */
#define   S_008A14_CLIP_VTX_REORDER_ENA(x)                            (((unsigned)(x) & 0x1) << 0)
#define   G_008A14_CLIP_VTX_REORDER_ENA(x)                            (((x) >> 0) & 0x1)
#define   C_008A14_CLIP_VTX_REORDER_ENA                               0xFFFFFFFE
#define   S_008A14_NUM_CLIP_SEQ(x)                                    (((unsigned)(x) & 0x3) << 1)
#define   G_008A14_NUM_CLIP_SEQ(x)                                    (((x) >> 1) & 0x3)
#define   C_008A14_NUM_CLIP_SEQ                                       0xFFFFFFF9
#define   S_008A14_CLIPPED_PRIM_SEQ_STALL(x)                          (((unsigned)(x) & 0x1) << 3)
#define   G_008A14_CLIPPED_PRIM_SEQ_STALL(x)                          (((x) >> 3) & 0x1)
#define   C_008A14_CLIPPED_PRIM_SEQ_STALL                             0xFFFFFFF7
#define   S_008A14_VE_NAN_PROC_DISABLE(x)                             (((unsigned)(x) & 0x1) << 4)
#define   G_008A14_VE_NAN_PROC_DISABLE(x)                             (((x) >> 4) & 0x1)
#define   C_008A14_VE_NAN_PROC_DISABLE                                0xFFFFFFEF
#define   S_008A14_XTRA_DEBUG_REG_SEL(x)                              (((unsigned)(x) & 0x1) << 5)
#define   G_008A14_XTRA_DEBUG_REG_SEL(x)                              (((x) >> 5) & 0x1)
#define   C_008A14_XTRA_DEBUG_REG_SEL                                 0xFFFFFFDF
#define   S_008A14_ECO_SPARE3(x)                                      (((unsigned)(x) & 0x1) << 28)
#define   G_008A14_ECO_SPARE3(x)                                      (((x) >> 28) & 0x1)
#define   C_008A14_ECO_SPARE3                                         0xEFFFFFFF
#define   S_008A14_ECO_SPARE2(x)                                      (((unsigned)(x) & 0x1) << 29)
#define   G_008A14_ECO_SPARE2(x)                                      (((x) >> 29) & 0x1)
#define   C_008A14_ECO_SPARE2                                         0xDFFFFFFF
#define   S_008A14_ECO_SPARE1(x)                                      (((unsigned)(x) & 0x1) << 30)
#define   G_008A14_ECO_SPARE1(x)                                      (((x) >> 30) & 0x1)
#define   C_008A14_ECO_SPARE1                                         0xBFFFFFFF
#define   S_008A14_ECO_SPARE0(x)                                      (((unsigned)(x) & 0x1) << 31)
#define   G_008A14_ECO_SPARE0(x)                                      (((x) >> 31) & 0x1)
#define   C_008A14_ECO_SPARE0                                         0x7FFFFFFF
#define R_008A18_CGTT_PA_CLK_CTRL                                       0x008A18 /* <= gfx6 */
#define   S_008A18_ON_DELAY(x)                                        (((unsigned)(x) & 0xF) << 0)
#define   G_008A18_ON_DELAY(x)                                        (((x) >> 0) & 0xF)
#define   C_008A18_ON_DELAY                                           0xFFFFFFF0
#define   S_008A18_OFF_HYSTERESIS(x)                                  (((unsigned)(x) & 0xFF) << 4)
#define   G_008A18_OFF_HYSTERESIS(x)                                  (((x) >> 4) & 0xFF)
#define   C_008A18_OFF_HYSTERESIS                                     0xFFFFF00F
#define   S_008A18_SOFT_OVERRIDE7(x)                                  (((unsigned)(x) & 0x1) << 24)
#define   G_008A18_SOFT_OVERRIDE7(x)                                  (((x) >> 24) & 0x1)
#define   C_008A18_SOFT_OVERRIDE7                                     0xFEFFFFFF
#define   S_008A18_SOFT_OVERRIDE6(x)                                  (((unsigned)(x) & 0x1) << 25)
#define   G_008A18_SOFT_OVERRIDE6(x)                                  (((x) >> 25) & 0x1)
#define   C_008A18_SOFT_OVERRIDE6                                     0xFDFFFFFF
#define   S_008A18_SOFT_OVERRIDE5(x)                                  (((unsigned)(x) & 0x1) << 26)
#define   G_008A18_SOFT_OVERRIDE5(x)                                  (((x) >> 26) & 0x1)
#define   C_008A18_SOFT_OVERRIDE5                                     0xFBFFFFFF
#define   S_008A18_SOFT_OVERRIDE4(x)                                  (((unsigned)(x) & 0x1) << 27)
#define   G_008A18_SOFT_OVERRIDE4(x)                                  (((x) >> 27) & 0x1)
#define   C_008A18_SOFT_OVERRIDE4                                     0xF7FFFFFF
#define   S_008A18_SOFT_OVERRIDE3(x)                                  (((unsigned)(x) & 0x1) << 28)
#define   G_008A18_SOFT_OVERRIDE3(x)                                  (((x) >> 28) & 0x1)
#define   C_008A18_SOFT_OVERRIDE3                                     0xEFFFFFFF
#define   S_008A18_SU_CLK_OVERRIDE(x)                                 (((unsigned)(x) & 0x1) << 29)
#define   G_008A18_SU_CLK_OVERRIDE(x)                                 (((x) >> 29) & 0x1)
#define   C_008A18_SU_CLK_OVERRIDE                                    0xDFFFFFFF
#define   S_008A18_CL_CLK_OVERRIDE(x)                                 (((unsigned)(x) & 0x1) << 30)
#define   G_008A18_CL_CLK_OVERRIDE(x)                                 (((x) >> 30) & 0x1)
#define   C_008A18_CL_CLK_OVERRIDE                                    0xBFFFFFFF
#define   S_008A18_REG_CLK_OVERRIDE(x)                                (((unsigned)(x) & 0x1) << 31)
#define   G_008A18_REG_CLK_OVERRIDE(x)                                (((x) >> 31) & 0x1)
#define   C_008A18_REG_CLK_OVERRIDE                                   0x7FFFFFFF
#define R_008A20_PA_SU_PERFCOUNTER0_SELECT                              0x008A20 /* <= gfx6 */
#define   S_008A20_PERF_SEL(x)                                        (((unsigned)(x) & 0xFF) << 0)
#define   G_008A20_PERF_SEL(x)                                        (((x) >> 0) & 0xFF)
#define   C_008A20_PERF_SEL                                           0xFFFFFF00
#define   S_008A20_PERF_SEL1(x)                                       (((unsigned)(x) & 0x3FF) << 10)
#define   G_008A20_PERF_SEL1(x)                                       (((x) >> 10) & 0x3FF)
#define   C_008A20_PERF_SEL1                                          0xFFF003FF
#define   S_008A20_CNTR_MODE(x)                                       (((unsigned)(x) & 0xF) << 20)
#define   G_008A20_CNTR_MODE(x)                                       (((x) >> 20) & 0xF)
#define   C_008A20_CNTR_MODE                                          0xFF0FFFFF
#define R_008A24_PA_SU_PERFCOUNTER1_SELECT                              0x008A24 /* <= gfx6 */
#define R_008A28_PA_SU_PERFCOUNTER2_SELECT                              0x008A28 /* <= gfx6 */
#define   S_008A28_PERF_SEL(x)                                        (((unsigned)(x) & 0xFF) << 0)
#define   G_008A28_PERF_SEL(x)                                        (((x) >> 0) & 0xFF)
#define   C_008A28_PERF_SEL                                           0xFFFFFF00
#define   S_008A28_CNTR_MODE(x)                                       (((unsigned)(x) & 0xF) << 20)
#define   G_008A28_CNTR_MODE(x)                                       (((x) >> 20) & 0xF)
#define   C_008A28_CNTR_MODE                                          0xFF0FFFFF
#define R_008A2C_PA_SU_PERFCOUNTER3_SELECT                              0x008A2C /* <= gfx6 */
#define R_008A30_PA_SU_PERFCOUNTER0_LO                                  0x008A30 /* <= gfx6 */
#define R_008A34_PA_SU_PERFCOUNTER0_HI                                  0x008A34 /* <= gfx6 */
#define   S_008A34_PERFCOUNTER_HI(x)                                  (((unsigned)(x) & 0xFFFF) << 0)
#define   G_008A34_PERFCOUNTER_HI(x)                                  (((x) >> 0) & 0xFFFF)
#define   C_008A34_PERFCOUNTER_HI                                     0xFFFF0000
#define R_008A38_PA_SU_PERFCOUNTER1_LO                                  0x008A38 /* <= gfx6 */
#define R_008A3C_PA_SU_PERFCOUNTER1_HI                                  0x008A3C /* <= gfx6 */
#define R_008A40_PA_SU_PERFCOUNTER2_LO                                  0x008A40 /* <= gfx6 */
#define R_008A44_PA_SU_PERFCOUNTER2_HI                                  0x008A44 /* <= gfx6 */
#define R_008A48_PA_SU_PERFCOUNTER3_LO                                  0x008A48 /* <= gfx6 */
#define R_008A4C_PA_SU_PERFCOUNTER3_HI                                  0x008A4C /* <= gfx6 */
#define R_008A50_PA_SU_CNTL_STATUS                                      0x008A50 /* <= gfx6 */
#define   S_008A50_SU_BUSY(x)                                         (((unsigned)(x) & 0x1) << 31)
#define   G_008A50_SU_BUSY(x)                                         (((x) >> 31) & 0x1)
#define   C_008A50_SU_BUSY                                            0x7FFFFFFF
#define R_008A54_PA_SC_FIFO_DEPTH_CNTL                                  0x008A54 /* <= gfx6 */
#define   S_008A54_DEPTH(x)                                           (((unsigned)(x) & 0xFF) << 0)
#define   G_008A54_DEPTH(x)                                           (((x) >> 0) & 0xFF)
#define   C_008A54_DEPTH                                              0xFFFFFF00
#define R_008A60_PA_SU_LINE_STIPPLE_VALUE                               0x008A60 /* <= gfx6 */
#define   S_008A60_LINE_STIPPLE_VALUE(x)                              (((unsigned)(x) & 0xFFFFFF) << 0)
#define   G_008A60_LINE_STIPPLE_VALUE(x)                              (((x) >> 0) & 0xFFFFFF)
#define   C_008A60_LINE_STIPPLE_VALUE                                 0xFF000000
#define R_008A80_PA_SC_PERFCOUNTER0_SELECT                              0x008A80 /* <= gfx6 */
#define   S_008A80_PERF_SEL(x)                                        (((unsigned)(x) & 0x1FF) << 0)
#define   G_008A80_PERF_SEL(x)                                        (((x) >> 0) & 0x1FF)
#define   C_008A80_PERF_SEL                                           0xFFFFFE00
#define   S_008A80_PERF_SEL1(x)                                       (((unsigned)(x) & 0x3FF) << 10)
#define   G_008A80_PERF_SEL1(x)                                       (((x) >> 10) & 0x3FF)
#define   C_008A80_PERF_SEL1                                          0xFFF003FF
#define   S_008A80_CNTR_MODE(x)                                       (((unsigned)(x) & 0xF) << 20)
#define   G_008A80_CNTR_MODE(x)                                       (((x) >> 20) & 0xF)
#define   C_008A80_CNTR_MODE                                          0xFF0FFFFF
#define R_008A84_PA_SC_PERFCOUNTER1_SELECT                              0x008A84 /* <= gfx6 */
#define   S_008A84_PERF_SEL(x)                                        (((unsigned)(x) & 0x1FF) << 0)
#define   G_008A84_PERF_SEL(x)                                        (((x) >> 0) & 0x1FF)
#define   C_008A84_PERF_SEL                                           0xFFFFFE00
#define R_008A88_PA_SC_PERFCOUNTER2_SELECT                              0x008A88 /* <= gfx6 */
#define R_008A8C_PA_SC_PERFCOUNTER3_SELECT                              0x008A8C /* <= gfx6 */
#define R_008A90_PA_SC_PERFCOUNTER4_SELECT                              0x008A90 /* <= gfx6 */
#define R_008A94_PA_SC_PERFCOUNTER5_SELECT                              0x008A94 /* <= gfx6 */
#define R_008A98_PA_SC_PERFCOUNTER6_SELECT                              0x008A98 /* <= gfx6 */
#define R_008A9C_PA_SC_PERFCOUNTER7_SELECT                              0x008A9C /* <= gfx6 */
#define R_008AA0_PA_SC_PERFCOUNTER0_LO                                  0x008AA0 /* <= gfx6 */
#define R_008AA4_PA_SC_PERFCOUNTER0_HI                                  0x008AA4 /* <= gfx6 */
#define R_008AA8_PA_SC_PERFCOUNTER1_LO                                  0x008AA8 /* <= gfx6 */
#define R_008AAC_PA_SC_PERFCOUNTER1_HI                                  0x008AAC /* <= gfx6 */
#define R_008AB0_PA_SC_PERFCOUNTER2_LO                                  0x008AB0 /* <= gfx6 */
#define R_008AB4_PA_SC_PERFCOUNTER2_HI                                  0x008AB4 /* <= gfx6 */
#define R_008AB8_PA_SC_PERFCOUNTER3_LO                                  0x008AB8 /* <= gfx6 */
#define R_008ABC_PA_SC_PERFCOUNTER3_HI                                  0x008ABC /* <= gfx6 */
#define R_008AC0_PA_SC_PERFCOUNTER4_LO                                  0x008AC0 /* <= gfx6 */
#define R_008AC4_PA_SC_PERFCOUNTER4_HI                                  0x008AC4 /* <= gfx6 */
#define R_008AC8_PA_SC_PERFCOUNTER5_LO                                  0x008AC8 /* <= gfx6 */
#define R_008ACC_PA_SC_PERFCOUNTER5_HI                                  0x008ACC /* <= gfx6 */
#define R_008AD0_PA_SC_PERFCOUNTER6_LO                                  0x008AD0 /* <= gfx6 */
#define R_008AD4_PA_SC_PERFCOUNTER6_HI                                  0x008AD4 /* <= gfx6 */
#define R_008AD8_PA_SC_PERFCOUNTER7_LO                                  0x008AD8 /* <= gfx6 */
#define R_008ADC_PA_SC_PERFCOUNTER7_HI                                  0x008ADC /* <= gfx6 */
#define R_008B10_PA_SC_LINE_STIPPLE_STATE                               0x008B10 /* <= gfx6 */
#define   S_008B10_CURRENT_PTR(x)                                     (((unsigned)(x) & 0xF) << 0)
#define   G_008B10_CURRENT_PTR(x)                                     (((x) >> 0) & 0xF)
#define   C_008B10_CURRENT_PTR                                        0xFFFFFFF0
#define   S_008B10_CURRENT_COUNT(x)                                   (((unsigned)(x) & 0xFF) << 8)
#define   G_008B10_CURRENT_COUNT(x)                                   (((x) >> 8) & 0xFF)
#define   C_008B10_CURRENT_COUNT                                      0xFFFF00FF
#define R_008B24_PA_SC_FORCE_EOV_MAX_CNTS                               0x008B24 /* <= gfx6 */
#define   S_008B24_FORCE_EOV_MAX_CLK_CNT(x)                           (((unsigned)(x) & 0xFFFF) << 0)
#define   G_008B24_FORCE_EOV_MAX_CLK_CNT(x)                           (((x) >> 0) & 0xFFFF)
#define   C_008B24_FORCE_EOV_MAX_CLK_CNT                              0xFFFF0000
#define   S_008B24_FORCE_EOV_MAX_REZ_CNT(x)                           (((unsigned)(x) & 0xFFFF) << 16)
#define   G_008B24_FORCE_EOV_MAX_REZ_CNT(x)                           (((x) >> 16) & 0xFFFF)
#define   C_008B24_FORCE_EOV_MAX_REZ_CNT                              0x0000FFFF
#define R_008B28_CGTT_SC_CLK_CTRL                                       0x008B28 /* <= gfx6 */
#define   S_008B28_ON_DELAY(x)                                        (((unsigned)(x) & 0xF) << 0)
#define   G_008B28_ON_DELAY(x)                                        (((x) >> 0) & 0xF)
#define   C_008B28_ON_DELAY                                           0xFFFFFFF0
#define   S_008B28_OFF_HYSTERESIS(x)                                  (((unsigned)(x) & 0xFF) << 4)
#define   G_008B28_OFF_HYSTERESIS(x)                                  (((x) >> 4) & 0xFF)
#define   C_008B28_OFF_HYSTERESIS                                     0xFFFFF00F
#define   S_008B28_SOFT_OVERRIDE7(x)                                  (((unsigned)(x) & 0x1) << 24)
#define   G_008B28_SOFT_OVERRIDE7(x)                                  (((x) >> 24) & 0x1)
#define   C_008B28_SOFT_OVERRIDE7                                     0xFEFFFFFF
#define   S_008B28_SOFT_OVERRIDE6(x)                                  (((unsigned)(x) & 0x1) << 25)
#define   G_008B28_SOFT_OVERRIDE6(x)                                  (((x) >> 25) & 0x1)
#define   C_008B28_SOFT_OVERRIDE6                                     0xFDFFFFFF
#define   S_008B28_SOFT_OVERRIDE5(x)                                  (((unsigned)(x) & 0x1) << 26)
#define   G_008B28_SOFT_OVERRIDE5(x)                                  (((x) >> 26) & 0x1)
#define   C_008B28_SOFT_OVERRIDE5                                     0xFBFFFFFF
#define   S_008B28_SOFT_OVERRIDE4(x)                                  (((unsigned)(x) & 0x1) << 27)
#define   G_008B28_SOFT_OVERRIDE4(x)                                  (((x) >> 27) & 0x1)
#define   C_008B28_SOFT_OVERRIDE4                                     0xF7FFFFFF
#define   S_008B28_SOFT_OVERRIDE3(x)                                  (((unsigned)(x) & 0x1) << 28)
#define   G_008B28_SOFT_OVERRIDE3(x)                                  (((x) >> 28) & 0x1)
#define   C_008B28_SOFT_OVERRIDE3                                     0xEFFFFFFF
#define   S_008B28_SOFT_OVERRIDE2(x)                                  (((unsigned)(x) & 0x1) << 29)
#define   G_008B28_SOFT_OVERRIDE2(x)                                  (((x) >> 29) & 0x1)
#define   C_008B28_SOFT_OVERRIDE2                                     0xDFFFFFFF
#define   S_008B28_SOFT_OVERRIDE1(x)                                  (((unsigned)(x) & 0x1) << 30)
#define   G_008B28_SOFT_OVERRIDE1(x)                                  (((x) >> 30) & 0x1)
#define   C_008B28_SOFT_OVERRIDE1                                     0xBFFFFFFF
#define   S_008B28_SOFT_OVERRIDE0(x)                                  (((unsigned)(x) & 0x1) << 31)
#define   G_008B28_SOFT_OVERRIDE0(x)                                  (((x) >> 31) & 0x1)
#define   C_008B28_SOFT_OVERRIDE0                                     0x7FFFFFFF
#define R_008BCC_PA_SC_FIFO_SIZE                                        0x008BCC /* <= gfx6 */
#define   S_008BCC_SC_FRONTEND_PRIM_FIFO_SIZE(x)                      (((unsigned)(x) & 0x3F) << 0)
#define   G_008BCC_SC_FRONTEND_PRIM_FIFO_SIZE(x)                      (((x) >> 0) & 0x3F)
#define   C_008BCC_SC_FRONTEND_PRIM_FIFO_SIZE                         0xFFFFFFC0
#define   S_008BCC_SC_BACKEND_PRIM_FIFO_SIZE(x)                       (((unsigned)(x) & 0x1FF) << 6)
#define   G_008BCC_SC_BACKEND_PRIM_FIFO_SIZE(x)                       (((x) >> 6) & 0x1FF)
#define   C_008BCC_SC_BACKEND_PRIM_FIFO_SIZE                          0xFFFF803F
#define   S_008BCC_SC_HIZ_TILE_FIFO_SIZE(x)                           (((unsigned)(x) & 0x3F) << 15)
#define   G_008BCC_SC_HIZ_TILE_FIFO_SIZE(x)                           (((x) >> 15) & 0x3F)
#define   C_008BCC_SC_HIZ_TILE_FIFO_SIZE                              0xFFE07FFF
#define   S_008BCC_SC_EARLYZ_TILE_FIFO_SIZE(x)                        (((unsigned)(x) & 0x1FF) << 23)
#define   G_008BCC_SC_EARLYZ_TILE_FIFO_SIZE(x)                        (((x) >> 23) & 0x1FF)
#define   C_008BCC_SC_EARLYZ_TILE_FIFO_SIZE                           0x007FFFFF
#define R_008BD4_PA_SC_IF_FIFO_SIZE                                     0x008BD4 /* <= gfx6 */
#define   S_008BD4_SC_DB_TILE_IF_FIFO_SIZE(x)                         (((unsigned)(x) & 0x3F) << 0)
#define   G_008BD4_SC_DB_TILE_IF_FIFO_SIZE(x)                         (((x) >> 0) & 0x3F)
#define   C_008BD4_SC_DB_TILE_IF_FIFO_SIZE                            0xFFFFFFC0
#define   S_008BD4_SC_DB_QUAD_IF_FIFO_SIZE(x)                         (((unsigned)(x) & 0x3F) << 6)
#define   G_008BD4_SC_DB_QUAD_IF_FIFO_SIZE(x)                         (((x) >> 6) & 0x3F)
#define   C_008BD4_SC_DB_QUAD_IF_FIFO_SIZE                            0xFFFFF03F
#define   S_008BD4_SC_SPI_IF_FIFO_SIZE(x)                             (((unsigned)(x) & 0x3F) << 12)
#define   G_008BD4_SC_SPI_IF_FIFO_SIZE(x)                             (((x) >> 12) & 0x3F)
#define   C_008BD4_SC_SPI_IF_FIFO_SIZE                                0xFFFC0FFF
#define   S_008BD4_SC_BCI_IF_FIFO_SIZE(x)                             (((unsigned)(x) & 0x3F) << 18)
#define   G_008BD4_SC_BCI_IF_FIFO_SIZE(x)                             (((x) >> 18) & 0x3F)
#define   C_008BD4_SC_BCI_IF_FIFO_SIZE                                0xFF03FFFF
#define R_008BD8_PA_SC_DEBUG_CNTL                                       0x008BD8 /* <= gfx6 */
#define   S_008BD8_SC_DEBUG_INDX(x)                                   (((unsigned)(x) & 0x3F) << 0)
#define   G_008BD8_SC_DEBUG_INDX(x)                                   (((x) >> 0) & 0x3F)
#define   C_008BD8_SC_DEBUG_INDX                                      0xFFFFFFC0
#define R_008BDC_PA_SC_DEBUG_DATA                                       0x008BDC /* <= gfx6 */
#define R_008BF0_PA_SC_ENHANCE                                          0x008BF0 /* <= gfx6 */
#define   S_008BF0_ENABLE_PA_SC_OUT_OF_ORDER(x)                       (((unsigned)(x) & 0x1) << 0)
#define   G_008BF0_ENABLE_PA_SC_OUT_OF_ORDER(x)                       (((x) >> 0) & 0x1)
#define   C_008BF0_ENABLE_PA_SC_OUT_OF_ORDER                          0xFFFFFFFE
#define   S_008BF0_DISABLE_SC_DB_TILE_FIX(x)                          (((unsigned)(x) & 0x1) << 1)
#define   G_008BF0_DISABLE_SC_DB_TILE_FIX(x)                          (((x) >> 1) & 0x1)
#define   C_008BF0_DISABLE_SC_DB_TILE_FIX                             0xFFFFFFFD
#define   S_008BF0_DISABLE_AA_MASK_FULL_FIX(x)                        (((unsigned)(x) & 0x1) << 2)
#define   G_008BF0_DISABLE_AA_MASK_FULL_FIX(x)                        (((x) >> 2) & 0x1)
#define   C_008BF0_DISABLE_AA_MASK_FULL_FIX                           0xFFFFFFFB
#define   S_008BF0_ENABLE_1XMSAA_SAMPLE_LOCATIONS(x)                  (((unsigned)(x) & 0x1) << 3)
#define   G_008BF0_ENABLE_1XMSAA_SAMPLE_LOCATIONS(x)                  (((x) >> 3) & 0x1)
#define   C_008BF0_ENABLE_1XMSAA_SAMPLE_LOCATIONS                     0xFFFFFFF7
#define   S_008BF0_ENABLE_1XMSAA_SAMPLE_LOC_CENTROID(x)               (((unsigned)(x) & 0x1) << 4)
#define   G_008BF0_ENABLE_1XMSAA_SAMPLE_LOC_CENTROID(x)               (((x) >> 4) & 0x1)
#define   C_008BF0_ENABLE_1XMSAA_SAMPLE_LOC_CENTROID                  0xFFFFFFEF
#define   S_008BF0_DISABLE_SCISSOR_FIX(x)                             (((unsigned)(x) & 0x1) << 5)
#define   G_008BF0_DISABLE_SCISSOR_FIX(x)                             (((x) >> 5) & 0x1)
#define   C_008BF0_DISABLE_SCISSOR_FIX                                0xFFFFFFDF
#define   S_008BF0_DISABLE_PW_BUBBLE_COLLAPSE(x)                      (((unsigned)(x) & 0x3) << 6)
#define   G_008BF0_DISABLE_PW_BUBBLE_COLLAPSE(x)                      (((x) >> 6) & 0x3)
#define   C_008BF0_DISABLE_PW_BUBBLE_COLLAPSE                         0xFFFFFF3F
#define   S_008BF0_SEND_UNLIT_STILES_TO_PACKER(x)                     (((unsigned)(x) & 0x1) << 8)
#define   G_008BF0_SEND_UNLIT_STILES_TO_PACKER(x)                     (((x) >> 8) & 0x1)
#define   C_008BF0_SEND_UNLIT_STILES_TO_PACKER                        0xFFFFFEFF
#define   S_008BF0_DISABLE_DUALGRAD_PERF_OPTIMIZATION(x)              (((unsigned)(x) & 0x1) << 9)
#define   G_008BF0_DISABLE_DUALGRAD_PERF_OPTIMIZATION(x)              (((x) >> 9) & 0x1)
#define   C_008BF0_DISABLE_DUALGRAD_PERF_OPTIMIZATION                 0xFFFFFDFF
#define   S_008BF0_DISABLE_SC_PROCESS_RESET_PRIM(x)                   (((unsigned)(x) & 0x1) << 10)
#define   G_008BF0_DISABLE_SC_PROCESS_RESET_PRIM(x)                   (((x) >> 10) & 0x1)
#define   C_008BF0_DISABLE_SC_PROCESS_RESET_PRIM                      0xFFFFFBFF
#define   S_008BF0_DISABLE_SC_PROCESS_RESET_SUPERTILE(x)              (((unsigned)(x) & 0x1) << 11)
#define   G_008BF0_DISABLE_SC_PROCESS_RESET_SUPERTILE(x)              (((x) >> 11) & 0x1)
#define   C_008BF0_DISABLE_SC_PROCESS_RESET_SUPERTILE                 0xFFFFF7FF
#define   S_008BF0_DISABLE_SC_PROCESS_RESET_TILE(x)                   (((unsigned)(x) & 0x1) << 12)
#define   G_008BF0_DISABLE_SC_PROCESS_RESET_TILE(x)                   (((x) >> 12) & 0x1)
#define   C_008BF0_DISABLE_SC_PROCESS_RESET_TILE                      0xFFFFEFFF
#define   S_008BF0_DISABLE_PA_SC_GUIDANCE(x)                          (((unsigned)(x) & 0x1) << 13)
#define   G_008BF0_DISABLE_PA_SC_GUIDANCE(x)                          (((x) >> 13) & 0x1)
#define   C_008BF0_DISABLE_PA_SC_GUIDANCE                             0xFFFFDFFF
#define   S_008BF0_DISABLE_EOV_ALL_CTRL_ONLY_COMBINATIONS(x)          (((unsigned)(x) & 0x1) << 14)
#define   G_008BF0_DISABLE_EOV_ALL_CTRL_ONLY_COMBINATIONS(x)          (((x) >> 14) & 0x1)
#define   C_008BF0_DISABLE_EOV_ALL_CTRL_ONLY_COMBINATIONS             0xFFFFBFFF
#define   S_008BF0_ENABLE_MULTICYCLE_BUBBLE_FREEZE(x)                 (((unsigned)(x) & 0x1) << 15)
#define   G_008BF0_ENABLE_MULTICYCLE_BUBBLE_FREEZE(x)                 (((x) >> 15) & 0x1)
#define   C_008BF0_ENABLE_MULTICYCLE_BUBBLE_FREEZE                    0xFFFF7FFF
#define   S_008BF0_DISABLE_OUT_OF_ORDER_PA_SC_GUIDANCE(x)             (((unsigned)(x) & 0x1) << 16)
#define   G_008BF0_DISABLE_OUT_OF_ORDER_PA_SC_GUIDANCE(x)             (((x) >> 16) & 0x1)
#define   C_008BF0_DISABLE_OUT_OF_ORDER_PA_SC_GUIDANCE                0xFFFEFFFF
#define   S_008BF0_ENABLE_OUT_OF_ORDER_POLY_MODE(x)                   (((unsigned)(x) & 0x1) << 17)
#define   G_008BF0_ENABLE_OUT_OF_ORDER_POLY_MODE(x)                   (((x) >> 17) & 0x1)
#define   C_008BF0_ENABLE_OUT_OF_ORDER_POLY_MODE                      0xFFFDFFFF
#define   S_008BF0_DISABLE_OUT_OF_ORDER_EOP_SYNC_NULL_PRIMS_LAST(x)   (((unsigned)(x) & 0x1) << 18)
#define   G_008BF0_DISABLE_OUT_OF_ORDER_EOP_SYNC_NULL_PRIMS_LAST(x)   (((x) >> 18) & 0x1)
#define   C_008BF0_DISABLE_OUT_OF_ORDER_EOP_SYNC_NULL_PRIMS_LAST      0xFFFBFFFF
#define   S_008BF0_DISABLE_OUT_OF_ORDER_THRESHOLD_SWITCHING(x)        (((unsigned)(x) & 0x1) << 19)
#define   G_008BF0_DISABLE_OUT_OF_ORDER_THRESHOLD_SWITCHING(x)        (((x) >> 19) & 0x1)
#define   C_008BF0_DISABLE_OUT_OF_ORDER_THRESHOLD_SWITCHING           0xFFF7FFFF
#define   S_008BF0_ENABLE_OUT_OF_ORDER_THRESHOLD_SWITCH_AT_EOPG_ONLY(x) (((unsigned)(x) & 0x1) << 20)
#define   G_008BF0_ENABLE_OUT_OF_ORDER_THRESHOLD_SWITCH_AT_EOPG_ONLY(x) (((x) >> 20) & 0x1)
#define   C_008BF0_ENABLE_OUT_OF_ORDER_THRESHOLD_SWITCH_AT_EOPG_ONLY  0xFFEFFFFF
#define   S_008BF0_DISABLE_OUT_OF_ORDER_DESIRED_FIFO_EMPTY_SWITCHING(x) (((unsigned)(x) & 0x1) << 21)
#define   G_008BF0_DISABLE_OUT_OF_ORDER_DESIRED_FIFO_EMPTY_SWITCHING(x) (((x) >> 21) & 0x1)
#define   C_008BF0_DISABLE_OUT_OF_ORDER_DESIRED_FIFO_EMPTY_SWITCHING  0xFFDFFFFF
#define   S_008BF0_DISABLE_OUT_OF_ORDER_SELECTED_FIFO_EMPTY_SWITCHING(x) (((unsigned)(x) & 0x1) << 22)
#define   G_008BF0_DISABLE_OUT_OF_ORDER_SELECTED_FIFO_EMPTY_SWITCHING(x) (((x) >> 22) & 0x1)
#define   C_008BF0_DISABLE_OUT_OF_ORDER_SELECTED_FIFO_EMPTY_SWITCHING 0xFFBFFFFF
#define   S_008BF0_DISABLE_OUT_OF_ORDER_EMPTY_SWITCHING_HYSTERYSIS(x) (((unsigned)(x) & 0x1) << 23)
#define   G_008BF0_DISABLE_OUT_OF_ORDER_EMPTY_SWITCHING_HYSTERYSIS(x) (((x) >> 23) & 0x1)
#define   C_008BF0_DISABLE_OUT_OF_ORDER_EMPTY_SWITCHING_HYSTERYSIS    0xFF7FFFFF
#define   S_008BF0_ENABLE_OUT_OF_ORDER_DESIRED_FIFO_IS_NEXT_FEID(x)   (((unsigned)(x) & 0x1) << 24)
#define   G_008BF0_ENABLE_OUT_OF_ORDER_DESIRED_FIFO_IS_NEXT_FEID(x)   (((x) >> 24) & 0x1)
#define   C_008BF0_ENABLE_OUT_OF_ORDER_DESIRED_FIFO_IS_NEXT_FEID      0xFEFFFFFF
#define   S_008BF0_ECO_SPARE1(x)                                      (((unsigned)(x) & 0x1) << 30)
#define   G_008BF0_ECO_SPARE1(x)                                      (((x) >> 30) & 0x1)
#define   C_008BF0_ECO_SPARE1                                         0xBFFFFFFF
#define   S_008BF0_ECO_SPARE0(x)                                      (((unsigned)(x) & 0x1) << 31)
#define   G_008BF0_ECO_SPARE0(x)                                      (((x) >> 31) & 0x1)
#define   C_008BF0_ECO_SPARE0                                         0x7FFFFFFF
#define R_008C00_SQ_CONFIG                                              0x008C00 /* <= gfx6 */
#define   S_008C00_UNUSED(x)                                          (((unsigned)(x) & 0xFF) << 0)
#define   G_008C00_UNUSED(x)                                          (((x) >> 0) & 0xFF)
#define   C_008C00_UNUSED                                             0xFFFFFF00
#define   S_008C00_DEBUG_EN(x)                                        (((unsigned)(x) & 0x1) << 8)
#define   G_008C00_DEBUG_EN(x)                                        (((x) >> 8) & 0x1)
#define   C_008C00_DEBUG_EN                                           0xFFFFFEFF
#define   S_008C00_DISABLE_SCA_BYPASS(x)                              (((unsigned)(x) & 0x1) << 9)
#define   G_008C00_DISABLE_SCA_BYPASS(x)                              (((x) >> 9) & 0x1)
#define   C_008C00_DISABLE_SCA_BYPASS                                 0xFFFFFDFF
#define   S_008C00_DISABLE_IB_DEP_CHECK(x)                            (((unsigned)(x) & 0x1) << 10)
#define   G_008C00_DISABLE_IB_DEP_CHECK(x)                            (((x) >> 10) & 0x1)
#define   C_008C00_DISABLE_IB_DEP_CHECK                               0xFFFFFBFF
#define   S_008C00_ENABLE_SOFT_CLAUSE(x)                              (((unsigned)(x) & 0x1) << 11)
#define   G_008C00_ENABLE_SOFT_CLAUSE(x)                              (((x) >> 11) & 0x1)
#define   C_008C00_ENABLE_SOFT_CLAUSE                                 0xFFFFF7FF
#define   S_008C00_EARLY_TA_DONE_DISABLE(x)                           (((unsigned)(x) & 0x1) << 12)
#define   G_008C00_EARLY_TA_DONE_DISABLE(x)                           (((x) >> 12) & 0x1)
#define   C_008C00_EARLY_TA_DONE_DISABLE                              0xFFFFEFFF
#define   S_008C00_DUA_FLAT_LOCK_ENABLE(x)                            (((unsigned)(x) & 0x1) << 13)
#define   G_008C00_DUA_FLAT_LOCK_ENABLE(x)                            (((x) >> 13) & 0x1)
#define   C_008C00_DUA_FLAT_LOCK_ENABLE                               0xFFFFDFFF
#define   S_008C00_DUA_LDS_BYPASS_DISABLE(x)                          (((unsigned)(x) & 0x1) << 14)
#define   G_008C00_DUA_LDS_BYPASS_DISABLE(x)                          (((x) >> 14) & 0x1)
#define   C_008C00_DUA_LDS_BYPASS_DISABLE                             0xFFFFBFFF
#define   S_008C00_DUA_FLAT_LDS_PINGPONG_DISABLE(x)                   (((unsigned)(x) & 0x1) << 15)
#define   G_008C00_DUA_FLAT_LDS_PINGPONG_DISABLE(x)                   (((x) >> 15) & 0x1)
#define   C_008C00_DUA_FLAT_LDS_PINGPONG_DISABLE                      0xFFFF7FFF
#define R_008C04_SQC_CONFIG                                             0x008C04 /* <= gfx6 */
#define   S_008C04_INST_CACHE_SIZE(x)                                 (((unsigned)(x) & 0x3) << 0)
#define   G_008C04_INST_CACHE_SIZE(x)                                 (((x) >> 0) & 0x3)
#define   C_008C04_INST_CACHE_SIZE                                    0xFFFFFFFC
#define   S_008C04_DATA_CACHE_SIZE(x)                                 (((unsigned)(x) & 0x3) << 2)
#define   G_008C04_DATA_CACHE_SIZE(x)                                 (((x) >> 2) & 0x3)
#define   C_008C04_DATA_CACHE_SIZE                                    0xFFFFFFF3
#define   S_008C04_MISS_FIFO_DEPTH(x)                                 (((unsigned)(x) & 0x3) << 4)
#define   G_008C04_MISS_FIFO_DEPTH(x)                                 (((x) >> 4) & 0x3)
#define   C_008C04_MISS_FIFO_DEPTH                                    0xFFFFFFCF
#define   S_008C04_HIT_FIFO_DEPTH(x)                                  (((unsigned)(x) & 0x1) << 6)
#define   G_008C04_HIT_FIFO_DEPTH(x)                                  (((x) >> 6) & 0x1)
#define   C_008C04_HIT_FIFO_DEPTH                                     0xFFFFFFBF
#define   S_008C04_FORCE_ALWAYS_MISS(x)                               (((unsigned)(x) & 0x1) << 7)
#define   G_008C04_FORCE_ALWAYS_MISS(x)                               (((x) >> 7) & 0x1)
#define   C_008C04_FORCE_ALWAYS_MISS                                  0xFFFFFF7F
#define   S_008C04_FORCE_IN_ORDER(x)                                  (((unsigned)(x) & 0x1) << 8)
#define   G_008C04_FORCE_IN_ORDER(x)                                  (((x) >> 8) & 0x1)
#define   C_008C04_FORCE_IN_ORDER                                     0xFFFFFEFF
#define   S_008C04_IDENTITY_HASH_BANK(x)                              (((unsigned)(x) & 0x1) << 9)
#define   G_008C04_IDENTITY_HASH_BANK(x)                              (((x) >> 9) & 0x1)
#define   C_008C04_IDENTITY_HASH_BANK                                 0xFFFFFDFF
#define   S_008C04_IDENTITY_HASH_SET(x)                               (((unsigned)(x) & 0x1) << 10)
#define   G_008C04_IDENTITY_HASH_SET(x)                               (((x) >> 10) & 0x1)
#define   C_008C04_IDENTITY_HASH_SET                                  0xFFFFFBFF
#define   S_008C04_PER_VMID_INV_DISABLE(x)                            (((unsigned)(x) & 0x1) << 11)
#define   G_008C04_PER_VMID_INV_DISABLE(x)                            (((x) >> 11) & 0x1)
#define   C_008C04_PER_VMID_INV_DISABLE                               0xFFFFF7FF
#define R_008C08_SQC_CACHES                                             0x008C08 /* <= gfx6 */
#define   S_008C08_INST_INVALIDATE(x)                                 (((unsigned)(x) & 0x1) << 0)
#define   G_008C08_INST_INVALIDATE(x)                                 (((x) >> 0) & 0x1)
#define   C_008C08_INST_INVALIDATE                                    0xFFFFFFFE
#define   S_008C08_DATA_INVALIDATE(x)                                 (((unsigned)(x) & 0x1) << 1)
#define   G_008C08_DATA_INVALIDATE(x)                                 (((x) >> 1) & 0x1)
#define   C_008C08_DATA_INVALIDATE                                    0xFFFFFFFD
#define   S_008C08_INVALIDATE_VOLATILE(x)                             (((unsigned)(x) & 0x1) << 2)
#define   G_008C08_INVALIDATE_VOLATILE(x)                             (((x) >> 2) & 0x1)
#define   C_008C08_INVALIDATE_VOLATILE                                0xFFFFFFFB
#define R_008C0C_SQ_RANDOM_WAVE_PRI                                     0x008C0C /* <= gfx6 */
#define   S_008C0C_RET(x)                                             (((unsigned)(x) & 0x7F) << 0)
#define   G_008C0C_RET(x)                                             (((x) >> 0) & 0x7F)
#define   C_008C0C_RET                                                0xFFFFFF80
#define   S_008C0C_RUI(x)                                             (((unsigned)(x) & 0x7) << 7)
#define   G_008C0C_RUI(x)                                             (((x) >> 7) & 0x7)
#define   C_008C0C_RUI                                                0xFFFFFC7F
#define   S_008C0C_RNG(x)                                             (((unsigned)(x) & 0x7FF) << 10)
#define   G_008C0C_RNG(x)                                             (((x) >> 10) & 0x7FF)
#define   C_008C0C_RNG                                                0xFFE003FF
#define R_008C10_SQ_REG_CREDITS                                         0x008C10 /* <= gfx6 */
#define   S_008C10_SRBM_CREDITS(x)                                    (((unsigned)(x) & 0x3F) << 0)
#define   G_008C10_SRBM_CREDITS(x)                                    (((x) >> 0) & 0x3F)
#define   C_008C10_SRBM_CREDITS                                       0xFFFFFFC0
#define   S_008C10_CMD_CREDITS(x)                                     (((unsigned)(x) & 0xF) << 8)
#define   G_008C10_CMD_CREDITS(x)                                     (((x) >> 8) & 0xF)
#define   C_008C10_CMD_CREDITS                                        0xFFFFF0FF
#define   S_008C10_REG_BUSY(x)                                        (((unsigned)(x) & 0x1) << 28)
#define   G_008C10_REG_BUSY(x)                                        (((x) >> 28) & 0x1)
#define   C_008C10_REG_BUSY                                           0xEFFFFFFF
#define   S_008C10_SRBM_OVERFLOW(x)                                   (((unsigned)(x) & 0x1) << 29)
#define   G_008C10_SRBM_OVERFLOW(x)                                   (((x) >> 29) & 0x1)
#define   C_008C10_SRBM_OVERFLOW                                      0xDFFFFFFF
#define   S_008C10_IMMED_OVERFLOW(x)                                  (((unsigned)(x) & 0x1) << 30)
#define   G_008C10_IMMED_OVERFLOW(x)                                  (((x) >> 30) & 0x1)
#define   C_008C10_IMMED_OVERFLOW                                     0xBFFFFFFF
#define   S_008C10_CMD_OVERFLOW(x)                                    (((unsigned)(x) & 0x1) << 31)
#define   G_008C10_CMD_OVERFLOW(x)                                    (((x) >> 31) & 0x1)
#define   C_008C10_CMD_OVERFLOW                                       0x7FFFFFFF
#define R_008C14_SQ_FIFO_SIZES                                          0x008C14 /* <= gfx6 */
#define   S_008C14_INTERRUPT_FIFO_SIZE(x)                             (((unsigned)(x) & 0xF) << 0)
#define   G_008C14_INTERRUPT_FIFO_SIZE(x)                             (((x) >> 0) & 0xF)
#define   C_008C14_INTERRUPT_FIFO_SIZE                                0xFFFFFFF0
#define   S_008C14_TTRACE_FIFO_SIZE(x)                                (((unsigned)(x) & 0xF) << 8)
#define   G_008C14_TTRACE_FIFO_SIZE(x)                                (((x) >> 8) & 0xF)
#define   C_008C14_TTRACE_FIFO_SIZE                                   0xFFFFF0FF
#define   S_008C14_EXPORT_BUF_SIZE(x)                                 (((unsigned)(x) & 0x3) << 16)
#define   G_008C14_EXPORT_BUF_SIZE(x)                                 (((x) >> 16) & 0x3)
#define   C_008C14_EXPORT_BUF_SIZE                                    0xFFFCFFFF
#define   S_008C14_VMEM_DATA_FIFO_SIZE(x)                             (((unsigned)(x) & 0x3) << 18)
#define   G_008C14_VMEM_DATA_FIFO_SIZE(x)                             (((x) >> 18) & 0x3)
#define   C_008C14_VMEM_DATA_FIFO_SIZE                                0xFFF3FFFF
#define R_008C18_SQ_PERFCOUNTER_CTRL                                    0x008C18 /* <= gfx6 */
#define   S_008C18_PS_EN(x)                                           (((unsigned)(x) & 0x1) << 0)
#define   G_008C18_PS_EN(x)                                           (((x) >> 0) & 0x1)
#define   C_008C18_PS_EN                                              0xFFFFFFFE
#define   S_008C18_VS_EN(x)                                           (((unsigned)(x) & 0x1) << 1)
#define   G_008C18_VS_EN(x)                                           (((x) >> 1) & 0x1)
#define   C_008C18_VS_EN                                              0xFFFFFFFD
#define     V_008C18_VS_STAGE_REAL                                  0
#define     V_008C18_VS_STAGE_DS                                    1
#define     V_008C18_VS_STAGE_COPY_SHADER                           2
#define     V_008C18_RESERVED_VS                                    3
#define   S_008C18_GS_EN(x)                                           (((unsigned)(x) & 0x1) << 2)
#define   G_008C18_GS_EN(x)                                           (((x) >> 2) & 0x1)
#define   C_008C18_GS_EN                                              0xFFFFFFFB
#define     V_008C18_GS_STAGE_OFF                                   0
#define     V_008C18_GS_STAGE_ON                                    1
#define   S_008C18_ES_EN(x)                                           (((unsigned)(x) & 0x1) << 3)
#define   G_008C18_ES_EN(x)                                           (((x) >> 3) & 0x1)
#define   C_008C18_ES_EN                                              0xFFFFFFF7
#define     V_008C18_ES_STAGE_OFF                                   0
#define     V_008C18_ES_STAGE_DS                                    1
#define     V_008C18_ES_STAGE_REAL                                  2
#define     V_008C18_RESERVED_ES                                    3
#define   S_008C18_HS_EN(x)                                           (((unsigned)(x) & 0x1) << 4)
#define   G_008C18_HS_EN(x)                                           (((x) >> 4) & 0x1)
#define   C_008C18_HS_EN                                              0xFFFFFFEF
#define     V_008C18_HS_STAGE_OFF                                   0
#define     V_008C18_HS_STAGE_ON                                    1
#define   S_008C18_LS_EN(x)                                           (((unsigned)(x) & 0x1) << 5)
#define   G_008C18_LS_EN(x)                                           (((x) >> 5) & 0x1)
#define   C_008C18_LS_EN                                              0xFFFFFFDF
#define     V_008C18_LS_STAGE_OFF                                   0
#define     V_008C18_LS_STAGE_ON                                    1
#define     V_008C18_CS_STAGE_ON                                    2
#define     V_008C18_RESERVED_LS                                    3
#define   S_008C18_CS_EN(x)                                           (((unsigned)(x) & 0x1) << 6)
#define   G_008C18_CS_EN(x)                                           (((x) >> 6) & 0x1)
#define   C_008C18_CS_EN                                              0xFFFFFFBF
#define   S_008C18_CNTR_RATE(x)                                       (((unsigned)(x) & 0x1F) << 8)
#define   G_008C18_CNTR_RATE(x)                                       (((x) >> 8) & 0x1F)
#define   C_008C18_CNTR_RATE                                          0xFFFFE0FF
#define   S_008C18_DISABLE_FLUSH(x)                                   (((unsigned)(x) & 0x1) << 13)
#define   G_008C18_DISABLE_FLUSH(x)                                   (((x) >> 13) & 0x1)
#define   C_008C18_DISABLE_FLUSH                                      0xFFFFDFFF
#define R_008C1C_CC_SQC_BANK_DISABLE                                    0x008C1C /* <= gfx6 */
#define   S_008C1C_SQC0_BANK_DISABLE(x)                               (((unsigned)(x) & 0xF) << 16)
#define   G_008C1C_SQC0_BANK_DISABLE(x)                               (((x) >> 16) & 0xF)
#define   C_008C1C_SQC0_BANK_DISABLE                                  0xFFF0FFFF
#define   S_008C1C_SQC1_BANK_DISABLE(x)                               (((unsigned)(x) & 0xF) << 20)
#define   G_008C1C_SQC1_BANK_DISABLE(x)                               (((x) >> 20) & 0xF)
#define   C_008C1C_SQC1_BANK_DISABLE                                  0xFF0FFFFF
#define   S_008C1C_SQC2_BANK_DISABLE(x)                               (((unsigned)(x) & 0xF) << 24)
#define   G_008C1C_SQC2_BANK_DISABLE(x)                               (((x) >> 24) & 0xF)
#define   C_008C1C_SQC2_BANK_DISABLE                                  0xF0FFFFFF
#define   S_008C1C_SQC3_BANK_DISABLE(x)                               (((unsigned)(x) & 0xF) << 28)
#define   G_008C1C_SQC3_BANK_DISABLE(x)                               (((x) >> 28) & 0xF)
#define   C_008C1C_SQC3_BANK_DISABLE                                  0x0FFFFFFF
#define R_008C20_USER_SQC_BANK_DISABLE                                  0x008C20 /* <= gfx6 */
#define   S_008C20_SQC0_BANK_DISABLE(x)                               (((unsigned)(x) & 0xF) << 16)
#define   G_008C20_SQC0_BANK_DISABLE(x)                               (((x) >> 16) & 0xF)
#define   C_008C20_SQC0_BANK_DISABLE                                  0xFFF0FFFF
#define   S_008C20_SQC1_BANK_DISABLE(x)                               (((unsigned)(x) & 0xF) << 20)
#define   G_008C20_SQC1_BANK_DISABLE(x)                               (((x) >> 20) & 0xF)
#define   C_008C20_SQC1_BANK_DISABLE                                  0xFF0FFFFF
#define   S_008C20_SQC2_BANK_DISABLE(x)                               (((unsigned)(x) & 0xF) << 24)
#define   G_008C20_SQC2_BANK_DISABLE(x)                               (((x) >> 24) & 0xF)
#define   C_008C20_SQC2_BANK_DISABLE                                  0xF0FFFFFF
#define   S_008C20_SQC3_BANK_DISABLE(x)                               (((unsigned)(x) & 0xF) << 28)
#define   G_008C20_SQC3_BANK_DISABLE(x)                               (((x) >> 28) & 0xF)
#define   C_008C20_SQC3_BANK_DISABLE                                  0x0FFFFFFF
#define R_008C24_SQ_DEBUG_STS_GLOBAL                                    0x008C24 /* <= gfx6 */
#define   S_008C24_BUSY(x)                                            (((unsigned)(x) & 0x1) << 0)
#define   G_008C24_BUSY(x)                                            (((x) >> 0) & 0x1)
#define   C_008C24_BUSY                                               0xFFFFFFFE
#define   S_008C24_INTERRUPT_MSG_BUSY(x)                              (((unsigned)(x) & 0x1) << 1)
#define   G_008C24_INTERRUPT_MSG_BUSY(x)                              (((x) >> 1) & 0x1)
#define   C_008C24_INTERRUPT_MSG_BUSY                                 0xFFFFFFFD
#define   S_008C24_WAVE_LEVEL_SH0(x)                                  (((unsigned)(x) & 0xFFF) << 4)
#define   G_008C24_WAVE_LEVEL_SH0(x)                                  (((x) >> 4) & 0xFFF)
#define   C_008C24_WAVE_LEVEL_SH0                                     0xFFFF000F
#define   S_008C24_WAVE_LEVEL_SH1(x)                                  (((unsigned)(x) & 0xFFF) << 16)
#define   G_008C24_WAVE_LEVEL_SH1(x)                                  (((x) >> 16) & 0xFFF)
#define   C_008C24_WAVE_LEVEL_SH1                                     0xF000FFFF
#define R_008C80_SQ_PERFCOUNTER0_LO                                     0x008C80 /* <= gfx6 */
#define R_008C84_SQ_PERFCOUNTER0_HI                                     0x008C84 /* <= gfx6 */
#define R_008C88_SQ_PERFCOUNTER1_LO                                     0x008C88 /* <= gfx6 */
#define R_008C8C_SQ_PERFCOUNTER1_HI                                     0x008C8C /* <= gfx6 */
#define R_008C90_SQ_PERFCOUNTER2_LO                                     0x008C90 /* <= gfx6 */
#define R_008C94_SQ_PERFCOUNTER2_HI                                     0x008C94 /* <= gfx6 */
#define R_008C98_SQ_PERFCOUNTER3_LO                                     0x008C98 /* <= gfx6 */
#define R_008C9C_SQ_PERFCOUNTER3_HI                                     0x008C9C /* <= gfx6 */
#define R_008CA0_SQ_PERFCOUNTER4_LO                                     0x008CA0 /* <= gfx6 */
#define R_008CA4_SQ_PERFCOUNTER4_HI                                     0x008CA4 /* <= gfx6 */
#define R_008CA8_SQ_PERFCOUNTER5_LO                                     0x008CA8 /* <= gfx6 */
#define R_008CAC_SQ_PERFCOUNTER5_HI                                     0x008CAC /* <= gfx6 */
#define R_008CB0_SQ_PERFCOUNTER6_LO                                     0x008CB0 /* <= gfx6 */
#define R_008CB4_SQ_PERFCOUNTER6_HI                                     0x008CB4 /* <= gfx6 */
#define R_008CB8_SQ_PERFCOUNTER7_LO                                     0x008CB8 /* <= gfx6 */
#define R_008CBC_SQ_PERFCOUNTER7_HI                                     0x008CBC /* <= gfx6 */
#define R_008CC0_SQ_PERFCOUNTER8_LO                                     0x008CC0 /* <= gfx6 */
#define R_008CC4_SQ_PERFCOUNTER8_HI                                     0x008CC4 /* <= gfx6 */
#define R_008CC8_SQ_PERFCOUNTER9_LO                                     0x008CC8 /* <= gfx6 */
#define R_008CCC_SQ_PERFCOUNTER9_HI                                     0x008CCC /* <= gfx6 */
#define R_008CD0_SQ_PERFCOUNTER10_LO                                    0x008CD0 /* <= gfx6 */
#define R_008CD4_SQ_PERFCOUNTER10_HI                                    0x008CD4 /* <= gfx6 */
#define R_008CD8_SQ_PERFCOUNTER11_LO                                    0x008CD8 /* <= gfx6 */
#define R_008CDC_SQ_PERFCOUNTER11_HI                                    0x008CDC /* <= gfx6 */
#define R_008CE0_SQ_PERFCOUNTER12_LO                                    0x008CE0 /* <= gfx6 */
#define R_008CE4_SQ_PERFCOUNTER12_HI                                    0x008CE4 /* <= gfx6 */
#define R_008CE8_SQ_PERFCOUNTER13_LO                                    0x008CE8 /* <= gfx6 */
#define R_008CEC_SQ_PERFCOUNTER13_HI                                    0x008CEC /* <= gfx6 */
#define R_008CF0_SQ_PERFCOUNTER14_LO                                    0x008CF0 /* <= gfx6 */
#define R_008CF4_SQ_PERFCOUNTER14_HI                                    0x008CF4 /* <= gfx6 */
#define R_008CF8_SQ_PERFCOUNTER15_LO                                    0x008CF8 /* <= gfx6 */
#define R_008CFC_SQ_PERFCOUNTER15_HI                                    0x008CFC /* <= gfx6 */
#define R_008D00_SQ_PERFCOUNTER0_SELECT                                 0x008D00 /* <= gfx6 */
#define   S_008D00_PERF_SEL(x)                                        (((unsigned)(x) & 0x1FF) << 0)
#define   G_008D00_PERF_SEL(x)                                        (((x) >> 0) & 0x1FF)
#define   C_008D00_PERF_SEL                                           0xFFFFFE00
#define   S_008D00_SQC_BANK_MASK(x)                                   (((unsigned)(x) & 0xF) << 12)
#define   G_008D00_SQC_BANK_MASK(x)                                   (((x) >> 12) & 0xF)
#define   C_008D00_SQC_BANK_MASK                                      0xFFFF0FFF
#define   S_008D00_SQC_CLIENT_MASK(x)                                 (((unsigned)(x) & 0xF) << 16)
#define   G_008D00_SQC_CLIENT_MASK(x)                                 (((x) >> 16) & 0xF)
#define   C_008D00_SQC_CLIENT_MASK                                    0xFFF0FFFF
#define   S_008D00_SPM_MODE(x)                                        (((unsigned)(x) & 0xF) << 20)
#define   G_008D00_SPM_MODE(x)                                        (((x) >> 20) & 0xF)
#define   C_008D00_SPM_MODE                                           0xFF0FFFFF
#define   S_008D00_SIMD_MASK(x)                                       (((unsigned)(x) & 0xF) << 24)
#define   G_008D00_SIMD_MASK(x)                                       (((x) >> 24) & 0xF)
#define   C_008D00_SIMD_MASK                                          0xF0FFFFFF
#define   S_008D00_PERF_MODE(x)                                       (((unsigned)(x) & 0xF) << 28)
#define   G_008D00_PERF_MODE(x)                                       (((x) >> 28) & 0xF)
#define   C_008D00_PERF_MODE                                          0x0FFFFFFF
#define R_008D00_SQ_THREAD_TRACE_BUF0_BASE                              0x008D00 /* >= gfx10 */
#define R_008D04_SQ_PERFCOUNTER1_SELECT                                 0x008D04 /* <= gfx6 */
#define R_008D04_SQ_THREAD_TRACE_BUF0_SIZE                              0x008D04 /* >= gfx10 */
#define   S_008D04_BASE_HI(x)                                         (((unsigned)(x) & 0xF) << 0)
#define   G_008D04_BASE_HI(x)                                         (((x) >> 0) & 0xF)
#define   C_008D04_BASE_HI                                            0xFFFFFFF0
#define   S_008D04_SIZE(x)                                            (((unsigned)(x) & 0x3FFFFF) << 8)
#define   G_008D04_SIZE(x)                                            (((x) >> 8) & 0x3FFFFF)
#define   C_008D04_SIZE                                               0xC00000FF
#define R_008D08_SQ_PERFCOUNTER2_SELECT                                 0x008D08 /* <= gfx6 */
#define R_008D08_SQ_THREAD_TRACE_BUF1_BASE                              0x008D08 /* >= gfx10 */
#define R_008D0C_SQ_PERFCOUNTER3_SELECT                                 0x008D0C /* <= gfx6 */
#define R_008D0C_SQ_THREAD_TRACE_BUF1_SIZE                              0x008D0C /* >= gfx10 */
#define R_008D10_SQ_PERFCOUNTER4_SELECT                                 0x008D10 /* <= gfx6 */
#define R_008D10_SQ_THREAD_TRACE_WPTR                                   0x008D10 /* >= gfx10 */
#define   S_008D10_OFFSET(x)                                          (((unsigned)(x) & 0x1FFFFFFF) << 0)
#define   G_008D10_OFFSET(x)                                          (((x) >> 0) & 0x1FFFFFFF)
#define   C_008D10_OFFSET                                             0xE0000000
#define   S_008D10_BUFFER_ID(x)                                       (((unsigned)(x) & 0x1) << 31)
#define   G_008D10_BUFFER_ID(x)                                       (((x) >> 31) & 0x1)
#define   C_008D10_BUFFER_ID                                          0x7FFFFFFF
#define R_008D14_SQ_PERFCOUNTER5_SELECT                                 0x008D14 /* <= gfx6 */
#define R_008D14_SQ_THREAD_TRACE_MASK                                   0x008D14 /* >= gfx10 */
#define   S_008D14_SIMD_SEL(x)                                        (((unsigned)(x) & 0x3) << 0)
#define   G_008D14_SIMD_SEL(x)                                        (((x) >> 0) & 0x3)
#define   C_008D14_SIMD_SEL                                           0xFFFFFFFC
#define   S_008D14_WGP_SEL(x)                                         (((unsigned)(x) & 0xF) << 4)
#define   G_008D14_WGP_SEL(x)                                         (((x) >> 4) & 0xF)
#define   C_008D14_WGP_SEL                                            0xFFFFFF0F
#define   S_008D14_SA_SEL(x)                                          (((unsigned)(x) & 0x1) << 9)
#define   G_008D14_SA_SEL(x)                                          (((x) >> 9) & 0x1)
#define   C_008D14_SA_SEL                                             0xFFFFFDFF
#define   S_008D14_WTYPE_INCLUDE(x)                                   (((unsigned)(x) & 0x7F) << 10)
#define   G_008D14_WTYPE_INCLUDE(x)                                   (((x) >> 10) & 0x7F)
#define   C_008D14_WTYPE_INCLUDE                                      0xFFFE03FF
#define R_008D18_SQ_PERFCOUNTER6_SELECT                                 0x008D18 /* <= gfx6 */
#define R_008D18_SQ_THREAD_TRACE_TOKEN_MASK                             0x008D18 /* >= gfx10 */
#define   S_008D18_TOKEN_EXCLUDE(x)                                   (((unsigned)(x) & 0xFFF) << 0)
#define   G_008D18_TOKEN_EXCLUDE(x)                                   (((x) >> 0) & 0xFFF)
#define   C_008D18_TOKEN_EXCLUDE                                      0xFFFFF000
#define     V_008D18_TOKEN_EXCLUDE_VMEMEXEC                         1
#define     V_008D18_TOKEN_EXCLUDE_ALUEXEC                          2
#define     V_008D18_TOKEN_EXCLUDE_VALUINST                         4
#define     V_008D18_TOKEN_EXCLUDE_WAVERDY                          8
#define     V_008D18_TOKEN_EXCLUDE_IMMED1                           16
#define     V_008D18_TOKEN_EXCLUDE_IMMEDIATE                        32
#define     V_008D18_TOKEN_EXCLUDE_REG                              64
#define     V_008D18_TOKEN_EXCLUDE_EVENT                            128
#define     V_008D18_TOKEN_EXCLUDE_INST                             256
#define     V_008D18_TOKEN_EXCLUDE_UTILCTR                          512
#define     V_008D18_TOKEN_EXCLUDE_WAVEALLOC                        1024
#define     V_008D18_TOKEN_EXCLUDE_PERF                             2048
#define   S_008D18_BOP_EVENTS_TOKEN_INCLUDE(x)                        (((unsigned)(x) & 0x1) << 12) /* >= gfx103 */
#define   G_008D18_BOP_EVENTS_TOKEN_INCLUDE(x)                        (((x) >> 12) & 0x1)
#define   C_008D18_BOP_EVENTS_TOKEN_INCLUDE                           0xFFFFEFFF
#define   S_008D18_REG_INCLUDE(x)                                     (((unsigned)(x) & 0xFF) << 16)
#define   G_008D18_REG_INCLUDE(x)                                     (((x) >> 16) & 0xFF)
#define   C_008D18_REG_INCLUDE                                        0xFF00FFFF
#define     V_008D18_REG_INCLUDE_SQDEC                              1
#define     V_008D18_REG_INCLUDE_SHDEC                              2
#define     V_008D18_REG_INCLUDE_GFXUDEC                            4
#define     V_008D18_REG_INCLUDE_COMP                               8
#define     V_008D18_REG_INCLUDE_CONTEXT                            16
#define     V_008D18_REG_INCLUDE_CONFIG                             32
#define     V_008D18_REG_INCLUDE_OTHER                              64
#define     V_008D18_REG_INCLUDE_READS                              128
#define   S_008D18_INST_EXCLUDE(x)                                    (((unsigned)(x) & 0x3) << 24)
#define   G_008D18_INST_EXCLUDE(x)                                    (((x) >> 24) & 0x3)
#define   C_008D18_INST_EXCLUDE                                       0xFCFFFFFF
#define   S_008D18_REG_EXCLUDE(x)                                     (((unsigned)(x) & 0x7) << 26) /* >= gfx103 */
#define   G_008D18_REG_EXCLUDE(x)                                     (((x) >> 26) & 0x7)
#define   C_008D18_REG_EXCLUDE                                        0xE3FFFFFF
#define   S_008D18_REG_DETAIL_ALL(x)                                  (((unsigned)(x) & 0x1) << 31)
#define   G_008D18_REG_DETAIL_ALL(x)                                  (((x) >> 31) & 0x1)
#define   C_008D18_REG_DETAIL_ALL                                     0x7FFFFFFF
#define R_008D1C_SQ_PERFCOUNTER7_SELECT                                 0x008D1C /* <= gfx6 */
#define R_008D1C_SQ_THREAD_TRACE_CTRL                                   0x008D1C /* >= gfx10 */
#define   S_008D1C_MODE(x)                                            (((unsigned)(x) & 0x3) << 0)
#define   G_008D1C_MODE(x)                                            (((x) >> 0) & 0x3)
#define   C_008D1C_MODE                                               0xFFFFFFFC
#define   S_008D1C_ALL_VMID(x)                                        (((unsigned)(x) & 0x1) << 2)
#define   G_008D1C_ALL_VMID(x)                                        (((x) >> 2) & 0x1)
#define   C_008D1C_ALL_VMID                                           0xFFFFFFFB
#define   S_008D1C_CH_PERF_EN(x)                                      (((unsigned)(x) & 0x1) << 3)
#define   G_008D1C_CH_PERF_EN(x)                                      (((x) >> 3) & 0x1)
#define   C_008D1C_CH_PERF_EN                                         0xFFFFFFF7
#define   S_008D1C_INTERRUPT_EN(x)                                    (((unsigned)(x) & 0x1) << 4)
#define   G_008D1C_INTERRUPT_EN(x)                                    (((x) >> 4) & 0x1)
#define   C_008D1C_INTERRUPT_EN                                       0xFFFFFFEF
#define   S_008D1C_DOUBLE_BUFFER(x)                                   (((unsigned)(x) & 0x1) << 5)
#define   G_008D1C_DOUBLE_BUFFER(x)                                   (((x) >> 5) & 0x1)
#define   C_008D1C_DOUBLE_BUFFER                                      0xFFFFFFDF
#define   S_008D1C_HIWATER(x)                                         (((unsigned)(x) & 0x7) << 6)
#define   G_008D1C_HIWATER(x)                                         (((x) >> 6) & 0x7)
#define   C_008D1C_HIWATER                                            0xFFFFFE3F
#define   S_008D1C_REG_STALL_EN(x)                                    (((unsigned)(x) & 0x1) << 9)
#define   G_008D1C_REG_STALL_EN(x)                                    (((x) >> 9) & 0x1)
#define   C_008D1C_REG_STALL_EN                                       0xFFFFFDFF
#define   S_008D1C_SPI_STALL_EN(x)                                    (((unsigned)(x) & 0x1) << 10)
#define   G_008D1C_SPI_STALL_EN(x)                                    (((x) >> 10) & 0x1)
#define   C_008D1C_SPI_STALL_EN                                       0xFFFFFBFF
#define   S_008D1C_SQ_STALL_EN(x)                                     (((unsigned)(x) & 0x1) << 11)
#define   G_008D1C_SQ_STALL_EN(x)                                     (((x) >> 11) & 0x1)
#define   C_008D1C_SQ_STALL_EN                                        0xFFFFF7FF
#define   S_008D1C_REG_DROP_ON_STALL(x)                               (((unsigned)(x) & 0x1) << 12)
#define   G_008D1C_REG_DROP_ON_STALL(x)                               (((x) >> 12) & 0x1)
#define   C_008D1C_REG_DROP_ON_STALL                                  0xFFFFEFFF
#define   S_008D1C_UTIL_TIMER(x)                                      (((unsigned)(x) & 0x1) << 13)
#define   G_008D1C_UTIL_TIMER(x)                                      (((x) >> 13) & 0x1)
#define   C_008D1C_UTIL_TIMER                                         0xFFFFDFFF
#define   S_008D1C_WAVESTART_MODE(x)                                  (((unsigned)(x) & 0x3) << 14)
#define   G_008D1C_WAVESTART_MODE(x)                                  (((x) >> 14) & 0x3)
#define   C_008D1C_WAVESTART_MODE                                     0xFFFF3FFF
#define   S_008D1C_RT_FREQ(x)                                         (((unsigned)(x) & 0x3) << 16)
#define   G_008D1C_RT_FREQ(x)                                         (((x) >> 16) & 0x3)
#define   C_008D1C_RT_FREQ                                            0xFFFCFFFF
#define   S_008D1C_SYNC_COUNT_MARKERS(x)                              (((unsigned)(x) & 0x1) << 18)
#define   G_008D1C_SYNC_COUNT_MARKERS(x)                              (((x) >> 18) & 0x1)
#define   C_008D1C_SYNC_COUNT_MARKERS                                 0xFFFBFFFF
#define   S_008D1C_SYNC_COUNT_DRAWS(x)                                (((unsigned)(x) & 0x1) << 19)
#define   G_008D1C_SYNC_COUNT_DRAWS(x)                                (((x) >> 19) & 0x1)
#define   C_008D1C_SYNC_COUNT_DRAWS                                   0xFFF7FFFF
#define   S_008D1C_LOWATER_OFFSET(x)                                  (((unsigned)(x) & 0x7) << 20) /* >= gfx103 */
#define   G_008D1C_LOWATER_OFFSET(x)                                  (((x) >> 20) & 0x7)
#define   C_008D1C_LOWATER_OFFSET                                     0xFF8FFFFF
#define   S_008D1C_AUTO_FLUSH_PADDING_DIS(x)                          (((unsigned)(x) & 0x1) << 28) /* >= gfx103 */
#define   G_008D1C_AUTO_FLUSH_PADDING_DIS(x)                          (((x) >> 28) & 0x1)
#define   C_008D1C_AUTO_FLUSH_PADDING_DIS                             0xEFFFFFFF
#define   S_008D1C_AUTO_FLUSH_MODE(x)                                 (((unsigned)(x) & 0x1) << 29) /* >= gfx103 */
#define   G_008D1C_AUTO_FLUSH_MODE(x)                                 (((x) >> 29) & 0x1)
#define   C_008D1C_AUTO_FLUSH_MODE                                    0xDFFFFFFF
#define   S_008D1C_CAPTURE_ALL(x)                                     (((unsigned)(x) & 0x1) << 30)
#define   G_008D1C_CAPTURE_ALL(x)                                     (((x) >> 30) & 0x1)
#define   C_008D1C_CAPTURE_ALL                                        0xBFFFFFFF
#define   S_008D1C_DRAW_EVENT_EN(x)                                   (((unsigned)(x) & 0x1) << 31)
#define   G_008D1C_DRAW_EVENT_EN(x)                                   (((x) >> 31) & 0x1)
#define   C_008D1C_DRAW_EVENT_EN                                      0x7FFFFFFF
#define R_008D20_SQ_PERFCOUNTER8_SELECT                                 0x008D20 /* <= gfx6 */
#define R_008D20_SQ_THREAD_TRACE_STATUS                                 0x008D20 /* >= gfx10 */
#define   S_008D20_FINISH_PENDING(x)                                  (((unsigned)(x) & 0xFFF) << 0)
#define   G_008D20_FINISH_PENDING(x)                                  (((x) >> 0) & 0xFFF)
#define   C_008D20_FINISH_PENDING                                     0xFFFFF000
#define   S_008D20_FINISH_DONE(x)                                     (((unsigned)(x) & 0xFFF) << 12)
#define   G_008D20_FINISH_DONE(x)                                     (((x) >> 12) & 0xFFF)
#define   C_008D20_FINISH_DONE                                        0xFF000FFF
#define   S_008D20_UTC_ERR(x)                                         (((unsigned)(x) & 0x1) << 24)
#define   G_008D20_UTC_ERR(x)                                         (((x) >> 24) & 0x1)
#define   C_008D20_UTC_ERR                                            0xFEFFFFFF
#define   S_008D20_BUSY(x)                                            (((unsigned)(x) & 0x1) << 25)
#define   G_008D20_BUSY(x)                                            (((x) >> 25) & 0x1)
#define   C_008D20_BUSY                                               0xFDFFFFFF
#define   S_008D20_EVENT_CNTR_OVERFLOW(x)                             (((unsigned)(x) & 0x1) << 26)
#define   G_008D20_EVENT_CNTR_OVERFLOW(x)                             (((x) >> 26) & 0x1)
#define   C_008D20_EVENT_CNTR_OVERFLOW                                0xFBFFFFFF
#define   S_008D20_EVENT_CNTR_STALL(x)                                (((unsigned)(x) & 0x1) << 27)
#define   G_008D20_EVENT_CNTR_STALL(x)                                (((x) >> 27) & 0x1)
#define   C_008D20_EVENT_CNTR_STALL                                   0xF7FFFFFF
#define   S_008D20_OWNER_VMID(x)                                      (((unsigned)(x) & 0xF) << 28) /* >= gfx103 */
#define   G_008D20_OWNER_VMID(x)                                      (((x) >> 28) & 0xF)
#define   C_008D20_OWNER_VMID                                         0x0FFFFFFF
#define R_008D24_SQ_PERFCOUNTER9_SELECT                                 0x008D24 /* <= gfx6 */
#define R_008D24_SQ_THREAD_TRACE_DROPPED_CNTR                           0x008D24 /* >= gfx10 */
#define R_008D28_SQ_PERFCOUNTER10_SELECT                                0x008D28 /* <= gfx6 */
#define R_008D2C_SQ_PERFCOUNTER11_SELECT                                0x008D2C /* <= gfx6 */
#define R_008D2C_SQ_THREAD_TRACE_GFX_DRAW_CNTR                          0x008D2C /* >= gfx10 */
#define R_008D30_SQ_PERFCOUNTER12_SELECT                                0x008D30 /* <= gfx6 */
#define R_008D30_SQ_THREAD_TRACE_GFX_MARKER_CNTR                        0x008D30 /* >= gfx10 */
#define R_008D34_SQ_PERFCOUNTER13_SELECT                                0x008D34 /* <= gfx6 */
#define R_008D34_SQ_THREAD_TRACE_HP3D_DRAW_CNTR                         0x008D34 /* >= gfx10 */
#define R_008D38_SQ_PERFCOUNTER14_SELECT                                0x008D38 /* <= gfx6 */
#define R_008D38_SQ_THREAD_TRACE_HP3D_MARKER_CNTR                       0x008D38 /* >= gfx10 */
#define R_008D3C_SQ_PERFCOUNTER15_SELECT                                0x008D3C /* <= gfx6 */
#define R_008D3C_SQ_THREAD_TRACE_STATUS2                                0x008D3C /* >= gfx103 */
#define   S_008D3C_BUF0_FULL(x)                                       (((unsigned)(x) & 0x1) << 0)
#define   G_008D3C_BUF0_FULL(x)                                       (((x) >> 0) & 0x1)
#define   C_008D3C_BUF0_FULL                                          0xFFFFFFFE
#define   S_008D3C_BUF1_FULL(x)                                       (((unsigned)(x) & 0x1) << 1)
#define   G_008D3C_BUF1_FULL(x)                                       (((x) >> 1) & 0x1)
#define   C_008D3C_BUF1_FULL                                          0xFFFFFFFD
#define   S_008D3C_PACKET_LOST_BUF_NO_LOCKDOWN(x)                     (((unsigned)(x) & 0x1) << 4)
#define   G_008D3C_PACKET_LOST_BUF_NO_LOCKDOWN(x)                     (((x) >> 4) & 0x1)
#define   C_008D3C_PACKET_LOST_BUF_NO_LOCKDOWN                        0xFFFFFFEF
#define R_008D80_SQ_ALU_CLK_CTRL                                        0x008D80 /* <= gfx6 */
#define   S_008D80_FORCE_CU_ON_SH0(x)                                 (((unsigned)(x) & 0xFFFF) << 0)
#define   G_008D80_FORCE_CU_ON_SH0(x)                                 (((x) >> 0) & 0xFFFF)
#define   C_008D80_FORCE_CU_ON_SH0                                    0xFFFF0000
#define   S_008D80_FORCE_CU_ON_SH1(x)                                 (((unsigned)(x) & 0xFFFF) << 16)
#define   G_008D80_FORCE_CU_ON_SH1(x)                                 (((x) >> 16) & 0xFFFF)
#define   C_008D80_FORCE_CU_ON_SH1                                    0x0000FFFF
#define R_008D84_SQ_TEX_CLK_CTRL                                        0x008D84 /* <= gfx6 */
#define   S_008D84_FORCE_CU_ON_SH0(x)                                 (((unsigned)(x) & 0xFFFF) << 0)
#define   G_008D84_FORCE_CU_ON_SH0(x)                                 (((x) >> 0) & 0xFFFF)
#define   C_008D84_FORCE_CU_ON_SH0                                    0xFFFF0000
#define   S_008D84_FORCE_CU_ON_SH1(x)                                 (((unsigned)(x) & 0xFFFF) << 16)
#define   G_008D84_FORCE_CU_ON_SH1(x)                                 (((x) >> 16) & 0xFFFF)
#define   C_008D84_FORCE_CU_ON_SH1                                    0x0000FFFF
#define R_008D88_CGTT_SQ_CLK_CTRL                                       0x008D88 /* <= gfx6 */
#define   S_008D88_ON_DELAY(x)                                        (((unsigned)(x) & 0xF) << 0)
#define   G_008D88_ON_DELAY(x)                                        (((x) >> 0) & 0xF)
#define   C_008D88_ON_DELAY                                           0xFFFFFFF0
#define   S_008D88_OFF_HYSTERESIS(x)                                  (((unsigned)(x) & 0xFF) << 4)
#define   G_008D88_OFF_HYSTERESIS(x)                                  (((x) >> 4) & 0xFF)
#define   C_008D88_OFF_HYSTERESIS                                     0xFFFFF00F
#define   S_008D88_CORE_OVERRIDE(x)                                   (((unsigned)(x) & 0x1) << 30)
#define   G_008D88_CORE_OVERRIDE(x)                                   (((x) >> 30) & 0x1)
#define   C_008D88_CORE_OVERRIDE                                      0xBFFFFFFF
#define   S_008D88_REG_OVERRIDE(x)                                    (((unsigned)(x) & 0x1) << 31)
#define   G_008D88_REG_OVERRIDE(x)                                    (((x) >> 31) & 0x1)
#define   C_008D88_REG_OVERRIDE                                       0x7FFFFFFF
#define R_008D8C_CGTT_SQG_CLK_CTRL                                      0x008D8C /* <= gfx6 */
#define   S_008D8C_ON_DELAY(x)                                        (((unsigned)(x) & 0xF) << 0)
#define   G_008D8C_ON_DELAY(x)                                        (((x) >> 0) & 0xF)
#define   C_008D8C_ON_DELAY                                           0xFFFFFFF0
#define   S_008D8C_OFF_HYSTERESIS(x)                                  (((unsigned)(x) & 0xFF) << 4)
#define   G_008D8C_OFF_HYSTERESIS(x)                                  (((x) >> 4) & 0xFF)
#define   C_008D8C_OFF_HYSTERESIS                                     0xFFFFF00F
#define   S_008D8C_CORE_OVERRIDE(x)                                   (((unsigned)(x) & 0x1) << 30)
#define   G_008D8C_CORE_OVERRIDE(x)                                   (((x) >> 30) & 0x1)
#define   C_008D8C_CORE_OVERRIDE                                      0xBFFFFFFF
#define   S_008D8C_REG_OVERRIDE(x)                                    (((unsigned)(x) & 0x1) << 31)
#define   G_008D8C_REG_OVERRIDE(x)                                    (((x) >> 31) & 0x1)
#define   C_008D8C_REG_OVERRIDE                                       0x7FFFFFFF
#define R_008DE0_SQ_IND_INDEX                                           0x008DE0 /* <= gfx6 */
#define   S_008DE0_WAVE_ID(x)                                         (((unsigned)(x) & 0xF) << 0)
#define   G_008DE0_WAVE_ID(x)                                         (((x) >> 0) & 0xF)
#define   C_008DE0_WAVE_ID                                            0xFFFFFFF0
#define   S_008DE0_SIMD_ID(x)                                         (((unsigned)(x) & 0x3) << 4)
#define   G_008DE0_SIMD_ID(x)                                         (((x) >> 4) & 0x3)
#define   C_008DE0_SIMD_ID                                            0xFFFFFFCF
#define   S_008DE0_THREAD_ID(x)                                       (((unsigned)(x) & 0x3F) << 6)
#define   G_008DE0_THREAD_ID(x)                                       (((x) >> 6) & 0x3F)
#define   C_008DE0_THREAD_ID                                          0xFFFFF03F
#define   S_008DE0_AUTO_INCR(x)                                       (((unsigned)(x) & 0x1) << 12)
#define   G_008DE0_AUTO_INCR(x)                                       (((x) >> 12) & 0x1)
#define   C_008DE0_AUTO_INCR                                          0xFFFFEFFF
#define   S_008DE0_FORCE_READ(x)                                      (((unsigned)(x) & 0x1) << 13)
#define   G_008DE0_FORCE_READ(x)                                      (((x) >> 13) & 0x1)
#define   C_008DE0_FORCE_READ                                         0xFFFFDFFF
#define   S_008DE0_READ_TIMEOUT(x)                                    (((unsigned)(x) & 0x1) << 14)
#define   G_008DE0_READ_TIMEOUT(x)                                    (((x) >> 14) & 0x1)
#define   C_008DE0_READ_TIMEOUT                                       0xFFFFBFFF
#define   S_008DE0_UNINDEXED(x)                                       (((unsigned)(x) & 0x1) << 15)
#define   G_008DE0_UNINDEXED(x)                                       (((x) >> 15) & 0x1)
#define   C_008DE0_UNINDEXED                                          0xFFFF7FFF
#define   S_008DE0_INDEX(x)                                           (((unsigned)(x) & 0xFFFF) << 16)
#define   G_008DE0_INDEX(x)                                           (((x) >> 16) & 0xFFFF)
#define   C_008DE0_INDEX                                              0x0000FFFF
#define R_008DE4_SQ_IND_DATA                                            0x008DE4 /* <= gfx6 */
#define R_008DF0_SQ_TIME_HI                                             0x008DF0 /* <= gfx6 */
#define R_008DF4_SQ_TIME_LO                                             0x008DF4 /* <= gfx6 */
#define R_008DFC_SQ_EXP_0                                               0x008DFC /* >= gfx10 */
#define   S_008DFC_EN(x)                                              (((unsigned)(x) & 0xF) << 0)
#define   G_008DFC_EN(x)                                              (((x) >> 0) & 0xF)
#define   C_008DFC_EN                                                 0xFFFFFFF0
#define   S_008DFC_TGT(x)                                             (((unsigned)(x) & 0x3F) << 4)
#define   G_008DFC_TGT(x)                                             (((x) >> 4) & 0x3F)
#define   C_008DFC_TGT                                                0xFFFFFC0F
#define     V_008DFC_SQ_EXP_MRT                                     0
#define     V_008DFC_SQ_EXP_MRTZ                                    8
#define     V_008DFC_SQ_EXP_NULL                                    9
#define     V_008DFC_SQ_EXP_POS                                     12
#define     V_008DFC_SQ_EXP_PRIM                                    20
#define     V_008DFC_SQ_EXP_PARAM                                   32
#define   S_008DFC_COMPR(x)                                           (((unsigned)(x) & 0x1) << 10)
#define   G_008DFC_COMPR(x)                                           (((x) >> 10) & 0x1)
#define   C_008DFC_COMPR                                              0xFFFFFBFF
#define   S_008DFC_DONE(x)                                            (((unsigned)(x) & 0x1) << 11)
#define   G_008DFC_DONE(x)                                            (((x) >> 11) & 0x1)
#define   C_008DFC_DONE                                               0xFFFFF7FF
#define   S_008DFC_VM(x)                                              (((unsigned)(x) & 0x1) << 12)
#define   G_008DFC_VM(x)                                              (((x) >> 12) & 0x1)
#define   C_008DFC_VM                                                 0xFFFFEFFF
#define R_008E00_SQ_THREAD_TRACE_BASE                                   0x008E00 /* <= gfx7 */
#define R_008E04_SQ_THREAD_TRACE_SIZE                                   0x008E04 /* <= gfx7 */
#define   S_008E04_SIZE(x)                                            (((unsigned)(x) & 0x3FFFFF) << 0)
#define   G_008E04_SIZE(x)                                            (((x) >> 0) & 0x3FFFFF)
#define   C_008E04_SIZE                                               0xFFC00000
#define R_008E08_SQ_THREAD_TRACE_MASK                                   0x008E08 /* <= gfx7 */
#define   S_008E08_CU_SEL(x)                                          (((unsigned)(x) & 0x1F) << 0)
#define   G_008E08_CU_SEL(x)                                          (((x) >> 0) & 0x1F)
#define   C_008E08_CU_SEL                                             0xFFFFFFE0
#define   S_008E08_SH_SEL(x)                                          (((unsigned)(x) & 0x1) << 5)
#define   G_008E08_SH_SEL(x)                                          (((x) >> 5) & 0x1)
#define   C_008E08_SH_SEL                                             0xFFFFFFDF
#define   S_008E08_REG_STALL_EN(x)                                    (((unsigned)(x) & 0x1) << 7)
#define   G_008E08_REG_STALL_EN(x)                                    (((x) >> 7) & 0x1)
#define   C_008E08_REG_STALL_EN                                       0xFFFFFF7F
#define   S_008E08_SIMD_EN(x)                                         (((unsigned)(x) & 0xF) << 8) /* gfx7 */
#define   G_008E08_SIMD_EN(x)                                         (((x) >> 8) & 0xF)
#define   C_008E08_SIMD_EN                                            0xFFFFF0FF
#define   S_008E08_VM_ID_MASK(x)                                      (((unsigned)(x) & 0x3) << 12)
#define   G_008E08_VM_ID_MASK(x)                                      (((x) >> 12) & 0x3)
#define   C_008E08_VM_ID_MASK                                         0xFFFFCFFF
#define   S_008E08_SPI_STALL_EN(x)                                    (((unsigned)(x) & 0x1) << 14)
#define   G_008E08_SPI_STALL_EN(x)                                    (((x) >> 14) & 0x1)
#define   C_008E08_SPI_STALL_EN                                       0xFFFFBFFF
#define   S_008E08_SQ_STALL_EN(x)                                     (((unsigned)(x) & 0x1) << 15)
#define   G_008E08_SQ_STALL_EN(x)                                     (((x) >> 15) & 0x1)
#define   C_008E08_SQ_STALL_EN                                        0xFFFF7FFF
#define   S_008E08_RANDOM_SEED(x)                                     (((unsigned)(x) & 0xFFFF) << 16)
#define   G_008E08_RANDOM_SEED(x)                                     (((x) >> 16) & 0xFFFF)
#define   C_008E08_RANDOM_SEED                                        0x0000FFFF
#define R_008E0C_SQ_THREAD_TRACE_TOKEN_MASK                             0x008E0C /* <= gfx7 */
#define   S_008E0C_TOKEN_MASK(x)                                      (((unsigned)(x) & 0xFFFF) << 0)
#define   G_008E0C_TOKEN_MASK(x)                                      (((x) >> 0) & 0xFFFF)
#define   C_008E0C_TOKEN_MASK                                         0xFFFF0000
#define   S_008E0C_REG_MASK(x)                                        (((unsigned)(x) & 0xFF) << 16)
#define   G_008E0C_REG_MASK(x)                                        (((x) >> 16) & 0xFF)
#define   C_008E0C_REG_MASK                                           0xFF00FFFF
#define   S_008E0C_REG_DROP_ON_STALL(x)                               (((unsigned)(x) & 0x1) << 24)
#define   G_008E0C_REG_DROP_ON_STALL(x)                               (((x) >> 24) & 0x1)
#define   C_008E0C_REG_DROP_ON_STALL                                  0xFEFFFFFF
#define R_008E10_SQ_THREAD_TRACE_PERF_MASK                              0x008E10 /* <= gfx7 */
#define   S_008E10_SH0_MASK(x)                                        (((unsigned)(x) & 0xFFFF) << 0)
#define   G_008E10_SH0_MASK(x)                                        (((x) >> 0) & 0xFFFF)
#define   C_008E10_SH0_MASK                                           0xFFFF0000
#define   S_008E10_SH1_MASK(x)                                        (((unsigned)(x) & 0xFFFF) << 16)
#define   G_008E10_SH1_MASK(x)                                        (((x) >> 16) & 0xFFFF)
#define   C_008E10_SH1_MASK                                           0x0000FFFF
#define R_008E14_SQ_THREAD_TRACE_BASE2                                  0x008E14 /* gfx7 */
#define   S_008E14_ADDR_HI(x)                                         (((unsigned)(x) & 0xF) << 0)
#define   G_008E14_ADDR_HI(x)                                         (((x) >> 0) & 0xF)
#define   C_008E14_ADDR_HI                                            0xFFFFFFF0
#define   S_008E14_ATC(x)                                             (((unsigned)(x) & 0x1) << 4)
#define   G_008E14_ATC(x)                                             (((x) >> 4) & 0x1)
#define   C_008E14_ATC                                                0xFFFFFFEF
#define R_008E18_SQ_THREAD_TRACE_TOKEN_MASK2                            0x008E18 /* gfx7 */
#define   S_008E18_INST_MASK(x)                                       (((unsigned)(x) & 0xFFFF) << 0)
#define   G_008E18_INST_MASK(x)                                       (((x) >> 0) & 0xFFFF)
#define   C_008E18_INST_MASK                                          0xFFFF0000
#define R_008E20_SQ_THREAD_TRACE_USERDATA_0                             0x008E20 /* <= gfx6 */
#define R_008E24_SQ_THREAD_TRACE_USERDATA_1                             0x008E24 /* <= gfx6 */
#define R_008E28_SQ_THREAD_TRACE_USERDATA_2                             0x008E28 /* <= gfx6 */
#define R_008E2C_SQ_THREAD_TRACE_USERDATA_3                             0x008E2C /* <= gfx6 */
#define R_008E30_SQ_THREAD_TRACE_WPTR                                   0x008E30 /* <= gfx7 */
#define   S_008E30_WPTR(x)                                            (((unsigned)(x) & 0x3FFFFFFF) << 0)
#define   G_008E30_WPTR(x)                                            (((x) >> 0) & 0x3FFFFFFF)
#define   C_008E30_WPTR                                               0xC0000000
#define   S_008E30_READ_OFFSET(x)                                     (((unsigned)(x) & 0x3) << 30)
#define   G_008E30_READ_OFFSET(x)                                     (((x) >> 30) & 0x3)
#define   C_008E30_READ_OFFSET                                        0x3FFFFFFF
#define R_008E34_SQ_THREAD_TRACE_STATUS                                 0x008E34 /* <= gfx7 */
#define   S_008E34_FINISH_PENDING(x)                                  (((unsigned)(x) & 0x3FF) << 0)
#define   G_008E34_FINISH_PENDING(x)                                  (((x) >> 0) & 0x3FF)
#define   C_008E34_FINISH_PENDING                                     0xFFFFFC00
#define   S_008E34_FINISH_DONE(x)                                     (((unsigned)(x) & 0x3FF) << 16)
#define   G_008E34_FINISH_DONE(x)                                     (((x) >> 16) & 0x3FF)
#define   C_008E34_FINISH_DONE                                        0xFC00FFFF
#define   S_008E34_NEW_BUF(x)                                         (((unsigned)(x) & 0x1) << 29)
#define   G_008E34_NEW_BUF(x)                                         (((x) >> 29) & 0x1)
#define   C_008E34_NEW_BUF                                            0xDFFFFFFF
#define   S_008E34_BUSY(x)                                            (((unsigned)(x) & 0x1) << 30)
#define   G_008E34_BUSY(x)                                            (((x) >> 30) & 0x1)
#define   C_008E34_BUSY                                               0xBFFFFFFF
#define   S_008E34_FULL(x)                                            (((unsigned)(x) & 0x1) << 31)
#define   G_008E34_FULL(x)                                            (((x) >> 31) & 0x1)
#define   C_008E34_FULL                                               0x7FFFFFFF
#define R_008E38_SQ_THREAD_TRACE_MODE                                   0x008E38 /* <= gfx7 */
#define   S_008E38_MASK_PS(x)                                         (((unsigned)(x) & 0x7) << 0)
#define   G_008E38_MASK_PS(x)                                         (((x) >> 0) & 0x7)
#define   C_008E38_MASK_PS                                            0xFFFFFFF8
#define   S_008E38_MASK_VS(x)                                         (((unsigned)(x) & 0x7) << 3)
#define   G_008E38_MASK_VS(x)                                         (((x) >> 3) & 0x7)
#define   C_008E38_MASK_VS                                            0xFFFFFFC7
#define   S_008E38_MASK_GS(x)                                         (((unsigned)(x) & 0x7) << 6)
#define   G_008E38_MASK_GS(x)                                         (((x) >> 6) & 0x7)
#define   C_008E38_MASK_GS                                            0xFFFFFE3F
#define   S_008E38_MASK_ES(x)                                         (((unsigned)(x) & 0x7) << 9)
#define   G_008E38_MASK_ES(x)                                         (((x) >> 9) & 0x7)
#define   C_008E38_MASK_ES                                            0xFFFFF1FF
#define   S_008E38_MASK_HS(x)                                         (((unsigned)(x) & 0x7) << 12)
#define   G_008E38_MASK_HS(x)                                         (((x) >> 12) & 0x7)
#define   C_008E38_MASK_HS                                            0xFFFF8FFF
#define   S_008E38_MASK_LS(x)                                         (((unsigned)(x) & 0x7) << 15)
#define   G_008E38_MASK_LS(x)                                         (((x) >> 15) & 0x7)
#define   C_008E38_MASK_LS                                            0xFFFC7FFF
#define   S_008E38_MASK_CS(x)                                         (((unsigned)(x) & 0x7) << 18)
#define   G_008E38_MASK_CS(x)                                         (((x) >> 18) & 0x7)
#define   C_008E38_MASK_CS                                            0xFFE3FFFF
#define   S_008E38_MODE(x)                                            (((unsigned)(x) & 0x3) << 21)
#define   G_008E38_MODE(x)                                            (((x) >> 21) & 0x3)
#define   C_008E38_MODE                                               0xFF9FFFFF
#define   S_008E38_CAPTURE_MODE(x)                                    (((unsigned)(x) & 0x3) << 23)
#define   G_008E38_CAPTURE_MODE(x)                                    (((x) >> 23) & 0x3)
#define   C_008E38_CAPTURE_MODE                                       0xFE7FFFFF
#define   S_008E38_AUTOFLUSH_EN(x)                                    (((unsigned)(x) & 0x1) << 25)
#define   G_008E38_AUTOFLUSH_EN(x)                                    (((x) >> 25) & 0x1)
#define   C_008E38_AUTOFLUSH_EN                                       0xFDFFFFFF
#define   S_008E38_PRIV(x)                                            (((unsigned)(x) & 0x1) << 26)
#define   G_008E38_PRIV(x)                                            (((x) >> 26) & 0x1)
#define   C_008E38_PRIV                                               0xFBFFFFFF
#define   S_008E38_ISSUE_MASK(x)                                      (((unsigned)(x) & 0x3) << 27)
#define   G_008E38_ISSUE_MASK(x)                                      (((x) >> 27) & 0x3)
#define   C_008E38_ISSUE_MASK                                         0xE7FFFFFF
#define   S_008E38_TEST_MODE(x)                                       (((unsigned)(x) & 0x1) << 29)
#define   G_008E38_TEST_MODE(x)                                       (((x) >> 29) & 0x1)
#define   C_008E38_TEST_MODE                                          0xDFFFFFFF
#define   S_008E38_INTERRUPT_EN(x)                                    (((unsigned)(x) & 0x1) << 30)
#define   G_008E38_INTERRUPT_EN(x)                                    (((x) >> 30) & 0x1)
#define   C_008E38_INTERRUPT_EN                                       0xBFFFFFFF
#define   S_008E38_WRAP(x)                                            (((unsigned)(x) & 0x1) << 31)
#define   G_008E38_WRAP(x)                                            (((x) >> 31) & 0x1)
#define   C_008E38_WRAP                                               0x7FFFFFFF
#define R_008E3C_SQ_THREAD_TRACE_CTRL                                   0x008E3C /* <= gfx7 */
#define   S_008E3C_RESET_BUFFER(x)                                    (((unsigned)(x) & 0x1) << 31)
#define   G_008E3C_RESET_BUFFER(x)                                    (((x) >> 31) & 0x1)
#define   C_008E3C_RESET_BUFFER                                       0x7FFFFFFF
#define R_008E40_SQ_THREAD_TRACE_CNTR                                   0x008E40 /* <= gfx81 */
#define R_008E48_SQ_THREAD_TRACE_HIWATER                                0x008E48 /* <= gfx7 */
#define   S_008E48_HIWATER(x)                                         (((unsigned)(x) & 0x7) << 0)
#define   G_008E48_HIWATER(x)                                         (((x) >> 0) & 0x7)
#define   C_008E48_HIWATER                                            0xFFFFFFF8
#define R_008E58_SQ_POWER_THROTTLE                                      0x008E58 /* <= gfx6 */
#define   S_008E58_MIN_POWER(x)                                       (((unsigned)(x) & 0x3FFF) << 0)
#define   G_008E58_MIN_POWER(x)                                       (((x) >> 0) & 0x3FFF)
#define   C_008E58_MIN_POWER                                          0xFFFFC000
#define   S_008E58_MAX_POWER(x)                                       (((unsigned)(x) & 0x3FFF) << 16)
#define   G_008E58_MAX_POWER(x)                                       (((x) >> 16) & 0x3FFF)
#define   C_008E58_MAX_POWER                                          0xC000FFFF
#define   S_008E58_PHASE_OFFSET(x)                                    (((unsigned)(x) & 0x3) << 30)
#define   G_008E58_PHASE_OFFSET(x)                                    (((x) >> 30) & 0x3)
#define   C_008E58_PHASE_OFFSET                                       0x3FFFFFFF
#define R_008E5C_SQ_POWER_THROTTLE2                                     0x008E5C /* <= gfx6 */
#define   S_008E5C_MAX_POWER_DELTA(x)                                 (((unsigned)(x) & 0x3FFF) << 0)
#define   G_008E5C_MAX_POWER_DELTA(x)                                 (((x) >> 0) & 0x3FFF)
#define   C_008E5C_MAX_POWER_DELTA                                    0xFFFFC000
#define   S_008E5C_SHORT_TERM_INTERVAL_SIZE(x)                        (((unsigned)(x) & 0x3FF) << 16)
#define   G_008E5C_SHORT_TERM_INTERVAL_SIZE(x)                        (((x) >> 16) & 0x3FF)
#define   C_008E5C_SHORT_TERM_INTERVAL_SIZE                           0xFC00FFFF
#define   S_008E5C_LONG_TERM_INTERVAL_RATIO(x)                        (((unsigned)(x) & 0xF) << 27)
#define   G_008E5C_LONG_TERM_INTERVAL_RATIO(x)                        (((x) >> 27) & 0xF)
#define   C_008E5C_LONG_TERM_INTERVAL_RATIO                           0x87FFFFFF
#define   S_008E5C_USE_REF_CLOCK(x)                                   (((unsigned)(x) & 0x1) << 31)
#define   G_008E5C_USE_REF_CLOCK(x)                                   (((x) >> 31) & 0x1)
#define   C_008E5C_USE_REF_CLOCK                                      0x7FFFFFFF
#define R_008E60_SQ_LB_CTR_CTRL                                         0x008E60 /* <= gfx6 */
#define   S_008E60_START(x)                                           (((unsigned)(x) & 0x1) << 0)
#define   G_008E60_START(x)                                           (((x) >> 0) & 0x1)
#define   C_008E60_START                                              0xFFFFFFFE
#define   S_008E60_LOAD(x)                                            (((unsigned)(x) & 0x1) << 1)
#define   G_008E60_LOAD(x)                                            (((x) >> 1) & 0x1)
#define   C_008E60_LOAD                                               0xFFFFFFFD
#define   S_008E60_CLEAR(x)                                           (((unsigned)(x) & 0x1) << 2)
#define   G_008E60_CLEAR(x)                                           (((x) >> 2) & 0x1)
#define   C_008E60_CLEAR                                              0xFFFFFFFB
#define R_008E64_SQ_LB_DATA_ALU_CYCLES                                  0x008E64 /* <= gfx6 */
#define R_008E68_SQ_LB_DATA_TEX_CYCLES                                  0x008E68 /* <= gfx6 */
#define R_008E6C_SQ_LB_DATA_ALU_STALLS                                  0x008E6C /* <= gfx6 */
#define R_008E70_SQ_LB_DATA_TEX_STALLS                                  0x008E70 /* <= gfx6 */
#define R_008E80_SQC_SECDED_CNT                                         0x008E80 /* <= gfx6 */
#define   S_008E80_INST_SEC(x)                                        (((unsigned)(x) & 0xFF) << 0)
#define   G_008E80_INST_SEC(x)                                        (((x) >> 0) & 0xFF)
#define   C_008E80_INST_SEC                                           0xFFFFFF00
#define   S_008E80_INST_DED(x)                                        (((unsigned)(x) & 0xFF) << 8)
#define   G_008E80_INST_DED(x)                                        (((x) >> 8) & 0xFF)
#define   C_008E80_INST_DED                                           0xFFFF00FF
#define   S_008E80_DATA_SEC(x)                                        (((unsigned)(x) & 0xFF) << 16)
#define   G_008E80_DATA_SEC(x)                                        (((x) >> 16) & 0xFF)
#define   C_008E80_DATA_SEC                                           0xFF00FFFF
#define   S_008E80_DATA_DED(x)                                        (((unsigned)(x) & 0xFF) << 24)
#define   G_008E80_DATA_DED(x)                                        (((x) >> 24) & 0xFF)
#define   C_008E80_DATA_DED                                           0x00FFFFFF
#define R_008E84_SQ_SEC_CNT                                             0x008E84 /* <= gfx6 */
#define   S_008E84_LDS_SEC(x)                                         (((unsigned)(x) & 0x3F) << 0)
#define   G_008E84_LDS_SEC(x)                                         (((x) >> 0) & 0x3F)
#define   C_008E84_LDS_SEC                                            0xFFFFFFC0
#define   S_008E84_SGPR_SEC(x)                                        (((unsigned)(x) & 0x1F) << 8)
#define   G_008E84_SGPR_SEC(x)                                        (((x) >> 8) & 0x1F)
#define   C_008E84_SGPR_SEC                                           0xFFFFE0FF
#define   S_008E84_VGPR_SEC(x)                                        (((unsigned)(x) & 0x1FF) << 16)
#define   G_008E84_VGPR_SEC(x)                                        (((x) >> 16) & 0x1FF)
#define   C_008E84_VGPR_SEC                                           0xFE00FFFF
#define R_008E88_SQ_DED_CNT                                             0x008E88 /* <= gfx6 */
#define   S_008E88_LDS_DED(x)                                         (((unsigned)(x) & 0x3F) << 0)
#define   G_008E88_LDS_DED(x)                                         (((x) >> 0) & 0x3F)
#define   C_008E88_LDS_DED                                            0xFFFFFFC0
#define   S_008E88_SGPR_DED(x)                                        (((unsigned)(x) & 0x1F) << 8)
#define   G_008E88_SGPR_DED(x)                                        (((x) >> 8) & 0x1F)
#define   C_008E88_SGPR_DED                                           0xFFFFE0FF
#define   S_008E88_VGPR_DED(x)                                        (((unsigned)(x) & 0x1FF) << 16)
#define   G_008E88_VGPR_DED(x)                                        (((x) >> 16) & 0x1FF)
#define   C_008E88_VGPR_DED                                           0xFE00FFFF
#define R_008E8C_SQ_DED_INFO                                            0x008E8C /* <= gfx6 */
#define   S_008E8C_WAVE_ID(x)                                         (((unsigned)(x) & 0xF) << 0)
#define   G_008E8C_WAVE_ID(x)                                         (((x) >> 0) & 0xF)
#define   C_008E8C_WAVE_ID                                            0xFFFFFFF0
#define   S_008E8C_SIMD_ID(x)                                         (((unsigned)(x) & 0x3) << 4)
#define   G_008E8C_SIMD_ID(x)                                         (((x) >> 4) & 0x3)
#define   C_008E8C_SIMD_ID                                            0xFFFFFFCF
#define   S_008E8C_SOURCE(x)                                          (((unsigned)(x) & 0x7) << 6)
#define   G_008E8C_SOURCE(x)                                          (((x) >> 6) & 0x7)
#define   C_008E8C_SOURCE                                             0xFFFFFE3F
#define   S_008E8C_VM_ID(x)                                           (((unsigned)(x) & 0xF) << 9)
#define   G_008E8C_VM_ID(x)                                           (((x) >> 9) & 0xF)
#define   C_008E8C_VM_ID                                              0xFFFFE1FF
#define R_008F00_SQ_BUF_RSRC_WORD0                                      0x008F00
#define R_008F04_SQ_BUF_RSRC_WORD1                                      0x008F04
#define   S_008F04_BASE_ADDRESS_HI(x)                                 (((unsigned)(x) & 0xFFFF) << 0)
#define   G_008F04_BASE_ADDRESS_HI(x)                                 (((x) >> 0) & 0xFFFF)
#define   C_008F04_BASE_ADDRESS_HI                                    0xFFFF0000
#define   S_008F04_STRIDE(x)                                          (((unsigned)(x) & 0x3FFF) << 16)
#define   G_008F04_STRIDE(x)                                          (((x) >> 16) & 0x3FFF)
#define   C_008F04_STRIDE                                             0xC000FFFF
#define   S_008F04_CACHE_SWIZZLE(x)                                   (((unsigned)(x) & 0x1) << 30)
#define   G_008F04_CACHE_SWIZZLE(x)                                   (((x) >> 30) & 0x1)
#define   C_008F04_CACHE_SWIZZLE                                      0xBFFFFFFF
#define   S_008F04_SWIZZLE_ENABLE(x)                                  (((unsigned)(x) & 0x1) << 31)
#define   G_008F04_SWIZZLE_ENABLE(x)                                  (((x) >> 31) & 0x1)
#define   C_008F04_SWIZZLE_ENABLE                                     0x7FFFFFFF
#define R_008F08_SQ_BUF_RSRC_WORD2                                      0x008F08
#define R_008F0C_SQ_BUF_RSRC_WORD3                                      0x008F0C
#define   S_008F0C_DST_SEL_X(x)                                       (((unsigned)(x) & 0x7) << 0)
#define   G_008F0C_DST_SEL_X(x)                                       (((x) >> 0) & 0x7)
#define   C_008F0C_DST_SEL_X                                          0xFFFFFFF8
#define     V_008F0C_SQ_SEL_0                                       0 /* <= gfx9 */
#define     V_008F0C_SQ_SEL_1                                       1 /* <= gfx9 */
#define     V_008F0C_SQ_SEL_RESERVED_0                              2 /* <= gfx9 */
#define     V_008F0C_SQ_SEL_RESERVED_1                              3 /* <= gfx9 */
#define     V_008F0C_SQ_SEL_X                                       4 /* <= gfx9 */
#define     V_008F0C_SQ_SEL_Y                                       5 /* <= gfx9 */
#define     V_008F0C_SQ_SEL_Z                                       6 /* <= gfx9 */
#define     V_008F0C_SQ_SEL_W                                       7 /* <= gfx9 */
#define   S_008F0C_DST_SEL_Y(x)                                       (((unsigned)(x) & 0x7) << 3)
#define   G_008F0C_DST_SEL_Y(x)                                       (((x) >> 3) & 0x7)
#define   C_008F0C_DST_SEL_Y                                          0xFFFFFFC7
#define   S_008F0C_DST_SEL_Z(x)                                       (((unsigned)(x) & 0x7) << 6)
#define   G_008F0C_DST_SEL_Z(x)                                       (((x) >> 6) & 0x7)
#define   C_008F0C_DST_SEL_Z                                          0xFFFFFE3F
#define   S_008F0C_DST_SEL_W(x)                                       (((unsigned)(x) & 0x7) << 9)
#define   G_008F0C_DST_SEL_W(x)                                       (((x) >> 9) & 0x7)
#define   C_008F0C_DST_SEL_W                                          0xFFFFF1FF
#define   S_008F0C_FORMAT(x)                                          (((unsigned)(x) & 0x7F) << 12) /* >= gfx10 */
#define   G_008F0C_FORMAT(x)                                          (((x) >> 12) & 0x7F)
#define   C_008F0C_FORMAT                                             0xFFF80FFF
#define     V_008F0C_GFX10_FORMAT_INVALID                           0
#define     V_008F0C_GFX10_FORMAT_8_UNORM                           1
#define     V_008F0C_GFX10_FORMAT_8_SNORM                           2
#define     V_008F0C_GFX10_FORMAT_8_USCALED                         3
#define     V_008F0C_GFX10_FORMAT_8_SSCALED                         4
#define     V_008F0C_GFX10_FORMAT_8_UINT                            5
#define     V_008F0C_GFX10_FORMAT_8_SINT                            6
#define     V_008F0C_GFX10_FORMAT_16_UNORM                          7
#define     V_008F0C_GFX10_FORMAT_16_SNORM                          8
#define     V_008F0C_GFX10_FORMAT_16_USCALED                        9
#define     V_008F0C_GFX10_FORMAT_16_SSCALED                        10
#define     V_008F0C_GFX10_FORMAT_16_UINT                           11
#define     V_008F0C_GFX10_FORMAT_16_SINT                           12
#define     V_008F0C_GFX10_FORMAT_16_FLOAT                          13
#define     V_008F0C_GFX10_FORMAT_8_8_UNORM                         14
#define     V_008F0C_GFX10_FORMAT_8_8_SNORM                         15
#define     V_008F0C_GFX10_FORMAT_8_8_USCALED                       16
#define     V_008F0C_GFX10_FORMAT_8_8_SSCALED                       17
#define     V_008F0C_GFX10_FORMAT_8_8_UINT                          18
#define     V_008F0C_GFX10_FORMAT_8_8_SINT                          19
#define     V_008F0C_GFX10_FORMAT_32_UINT                           20
#define     V_008F0C_GFX10_FORMAT_32_SINT                           21
#define     V_008F0C_GFX10_FORMAT_32_FLOAT                          22
#define     V_008F0C_GFX10_FORMAT_16_16_UNORM                       23
#define     V_008F0C_GFX10_FORMAT_16_16_SNORM                       24
#define     V_008F0C_GFX10_FORMAT_16_16_USCALED                     25
#define     V_008F0C_GFX10_FORMAT_16_16_SSCALED                     26
#define     V_008F0C_GFX10_FORMAT_16_16_UINT                        27
#define     V_008F0C_GFX10_FORMAT_16_16_SINT                        28
#define     V_008F0C_GFX10_FORMAT_16_16_FLOAT                       29
#define     V_008F0C_GFX10_FORMAT_10_11_11_UNORM                    30
#define     V_008F0C_GFX10_FORMAT_10_11_11_SNORM                    31
#define     V_008F0C_GFX10_FORMAT_10_11_11_USCALED                  32
#define     V_008F0C_GFX10_FORMAT_10_11_11_SSCALED                  33
#define     V_008F0C_GFX10_FORMAT_10_11_11_UINT                     34
#define     V_008F0C_GFX10_FORMAT_10_11_11_SINT                     35
#define     V_008F0C_GFX10_FORMAT_10_11_11_FLOAT                    36
#define     V_008F0C_GFX10_FORMAT_11_11_10_UNORM                    37
#define     V_008F0C_GFX10_FORMAT_11_11_10_SNORM                    38
#define     V_008F0C_GFX10_FORMAT_11_11_10_USCALED                  39
#define     V_008F0C_GFX10_FORMAT_11_11_10_SSCALED                  40
#define     V_008F0C_GFX10_FORMAT_11_11_10_UINT                     41
#define     V_008F0C_GFX10_FORMAT_11_11_10_SINT                     42
#define     V_008F0C_GFX10_FORMAT_11_11_10_FLOAT                    43
#define     V_008F0C_GFX10_FORMAT_10_10_10_2_UNORM                  44
#define     V_008F0C_GFX10_FORMAT_10_10_10_2_SNORM                  45
#define     V_008F0C_GFX10_FORMAT_10_10_10_2_USCALED                46
#define     V_008F0C_GFX10_FORMAT_10_10_10_2_SSCALED                47
#define     V_008F0C_GFX10_FORMAT_10_10_10_2_UINT                   48
#define     V_008F0C_GFX10_FORMAT_10_10_10_2_SINT                   49
#define     V_008F0C_GFX10_FORMAT_2_10_10_10_UNORM                  50
#define     V_008F0C_GFX10_FORMAT_2_10_10_10_SNORM                  51
#define     V_008F0C_GFX10_FORMAT_2_10_10_10_USCALED                52
#define     V_008F0C_GFX10_FORMAT_2_10_10_10_SSCALED                53
#define     V_008F0C_GFX10_FORMAT_2_10_10_10_UINT                   54
#define     V_008F0C_GFX10_FORMAT_2_10_10_10_SINT                   55
#define     V_008F0C_GFX10_FORMAT_8_8_8_8_UNORM                     56
#define     V_008F0C_GFX10_FORMAT_8_8_8_8_SNORM                     57
#define     V_008F0C_GFX10_FORMAT_8_8_8_8_USCALED                   58
#define     V_008F0C_GFX10_FORMAT_8_8_8_8_SSCALED                   59
#define     V_008F0C_GFX10_FORMAT_8_8_8_8_UINT                      60
#define     V_008F0C_GFX10_FORMAT_8_8_8_8_SINT                      61
#define     V_008F0C_GFX10_FORMAT_32_32_UINT                        62
#define     V_008F0C_GFX10_FORMAT_32_32_SINT                        63
#define     V_008F0C_GFX10_FORMAT_32_32_FLOAT                       64
#define     V_008F0C_GFX10_FORMAT_16_16_16_16_UNORM                 65
#define     V_008F0C_GFX10_FORMAT_16_16_16_16_SNORM                 66
#define     V_008F0C_GFX10_FORMAT_16_16_16_16_USCALED               67
#define     V_008F0C_GFX10_FORMAT_16_16_16_16_SSCALED               68
#define     V_008F0C_GFX10_FORMAT_16_16_16_16_UINT                  69
#define     V_008F0C_GFX10_FORMAT_16_16_16_16_SINT                  70
#define     V_008F0C_GFX10_FORMAT_16_16_16_16_FLOAT                 71
#define     V_008F0C_GFX10_FORMAT_32_32_32_UINT                     72
#define     V_008F0C_GFX10_FORMAT_32_32_32_SINT                     73
#define     V_008F0C_GFX10_FORMAT_32_32_32_FLOAT                    74
#define     V_008F0C_GFX10_FORMAT_32_32_32_32_UINT                  75
#define     V_008F0C_GFX10_FORMAT_32_32_32_32_SINT                  76
#define     V_008F0C_GFX10_FORMAT_32_32_32_32_FLOAT                 77
#define     V_008F0C_GFX10_FORMAT_8_SRGB                            128
#define     V_008F0C_GFX10_FORMAT_8_8_SRGB                          129
#define     V_008F0C_GFX10_FORMAT_8_8_8_8_SRGB                      130
#define     V_008F0C_GFX10_FORMAT_6E4_FLOAT                         131
#define     V_008F0C_GFX10_FORMAT_5_9_9_9_FLOAT                     132
#define     V_008F0C_GFX10_FORMAT_5_6_5_UNORM                       133
#define     V_008F0C_GFX10_FORMAT_1_5_5_5_UNORM                     134
#define     V_008F0C_GFX10_FORMAT_5_5_5_1_UNORM                     135
#define     V_008F0C_GFX10_FORMAT_4_4_4_4_UNORM                     136
#define     V_008F0C_GFX10_FORMAT_4_4_UNORM                         137
#define     V_008F0C_GFX10_FORMAT_1_UNORM                           138
#define     V_008F0C_GFX10_FORMAT_1_REVERSED_UNORM                  139
#define     V_008F0C_GFX10_FORMAT_32_FLOAT_CLAMP                    140
#define     V_008F0C_GFX10_FORMAT_8_24_UNORM                        141
#define     V_008F0C_GFX10_FORMAT_8_24_UINT                         142
#define     V_008F0C_GFX10_FORMAT_24_8_UNORM                        143
#define     V_008F0C_GFX10_FORMAT_24_8_UINT                         144
#define     V_008F0C_GFX10_FORMAT_X24_8_32_UINT                     145
#define     V_008F0C_GFX10_FORMAT_X24_8_32_FLOAT                    146
#define     V_008F0C_GFX10_FORMAT_GB_GR_UNORM                       147
#define     V_008F0C_GFX10_FORMAT_GB_GR_SNORM                       148
#define     V_008F0C_GFX10_FORMAT_GB_GR_UINT                        149
#define     V_008F0C_GFX10_FORMAT_GB_GR_SRGB                        150
#define     V_008F0C_GFX10_FORMAT_BG_RG_UNORM                       151
#define     V_008F0C_GFX10_FORMAT_BG_RG_SNORM                       152
#define     V_008F0C_GFX10_FORMAT_BG_RG_UINT                        153
#define     V_008F0C_GFX10_FORMAT_BG_RG_SRGB                        154
#define     V_008F0C_GFX10_FORMAT_FMASK8_S2_F1                      156
#define     V_008F0C_GFX10_FORMAT_FMASK8_S4_F1                      157
#define     V_008F0C_GFX10_FORMAT_FMASK8_S8_F1                      158
#define     V_008F0C_GFX10_FORMAT_FMASK8_S2_F2                      159
#define     V_008F0C_GFX10_FORMAT_FMASK8_S4_F2                      160
#define     V_008F0C_GFX10_FORMAT_FMASK8_S4_F4                      161
#define     V_008F0C_GFX10_FORMAT_FMASK16_S16_F1                    162
#define     V_008F0C_GFX10_FORMAT_FMASK16_S8_F2                     163
#define     V_008F0C_GFX10_FORMAT_FMASK32_S16_F2                    164
#define     V_008F0C_GFX10_FORMAT_FMASK32_S8_F4                     165
#define     V_008F0C_GFX10_FORMAT_FMASK32_S8_F8                     166
#define     V_008F0C_GFX10_FORMAT_FMASK64_S16_F4                    167
#define     V_008F0C_GFX10_FORMAT_FMASK64_S16_F8                    168
#define     V_008F0C_GFX10_FORMAT_BC1_UNORM                         169
#define     V_008F0C_GFX10_FORMAT_BC1_SRGB                          170
#define     V_008F0C_GFX10_FORMAT_BC2_UNORM                         171
#define     V_008F0C_GFX10_FORMAT_BC2_SRGB                          172
#define     V_008F0C_GFX10_FORMAT_BC3_UNORM                         173
#define     V_008F0C_GFX10_FORMAT_BC3_SRGB                          174
#define     V_008F0C_GFX10_FORMAT_BC4_UNORM                         175
#define     V_008F0C_GFX10_FORMAT_BC4_SNORM                         176
#define     V_008F0C_GFX10_FORMAT_BC5_UNORM                         177
#define     V_008F0C_GFX10_FORMAT_BC5_SNORM                         178
#define     V_008F0C_GFX10_FORMAT_BC6_UFLOAT                        179
#define     V_008F0C_GFX10_FORMAT_BC6_SFLOAT                        180
#define     V_008F0C_GFX10_FORMAT_BC7_UNORM                         181
#define     V_008F0C_GFX10_FORMAT_BC7_SRGB                          182
#define     V_008F0C_GFX10_FORMAT_MM_8_UNORM                        265
#define     V_008F0C_GFX10_FORMAT_MM_8_UINT                         266
#define     V_008F0C_GFX10_FORMAT_MM_8_8_UNORM                      267
#define     V_008F0C_GFX10_FORMAT_MM_8_8_UINT                       268
#define     V_008F0C_GFX10_FORMAT_MM_8_8_8_8_UNORM                  269
#define     V_008F0C_GFX10_FORMAT_MM_8_8_8_8_UINT                   270
#define     V_008F0C_GFX10_FORMAT_MM_VYUY8_UNORM                    271
#define     V_008F0C_GFX10_FORMAT_MM_VYUY8_UINT                     272
#define     V_008F0C_GFX10_FORMAT_MM_10_11_11_UNORM                 273
#define     V_008F0C_GFX10_FORMAT_MM_10_11_11_UINT                  274
#define     V_008F0C_GFX10_FORMAT_MM_2_10_10_10_UNORM               275
#define     V_008F0C_GFX10_FORMAT_MM_2_10_10_10_UINT                276
#define     V_008F0C_GFX10_FORMAT_MM_16_16_16_16_UNORM              277
#define     V_008F0C_GFX10_FORMAT_MM_16_16_16_16_UINT               278
#define     V_008F0C_GFX10_FORMAT_MM_10_IN_16_UNORM                 279
#define     V_008F0C_GFX10_FORMAT_MM_10_IN_16_UINT                  280
#define     V_008F0C_GFX10_FORMAT_MM_10_IN_16_16_UNORM              281
#define     V_008F0C_GFX10_FORMAT_MM_10_IN_16_16_UINT               282
#define     V_008F0C_GFX10_FORMAT_MM_10_IN_16_16_16_16_UNORM        283
#define     V_008F0C_GFX10_FORMAT_MM_10_IN_16_16_16_16_UINT         284
#define     V_008F0C_GFX10_FORMAT_7E3_FLOAT                         285
#define     V_008F0C_GFX10_FORMAT_YCBCR_UNORM                       286
#define     V_008F0C_GFX10_FORMAT_YCBCR_SNORM                       287
#define     V_008F0C_GFX10_FORMAT_YCBCR_USCALED                     288
#define     V_008F0C_GFX10_FORMAT_YCBCR_SSCALED                     289
#define     V_008F0C_GFX10_FORMAT_YCBCR_UINT                        290
#define     V_008F0C_GFX10_FORMAT_YCBCR_SINT                        291
#define     V_008F0C_GFX10_FORMAT_YCBCR_SRGB                        292
#define   S_008F0C_NUM_FORMAT(x)                                      (((unsigned)(x) & 0x7) << 12) /* <= gfx9 */
#define   G_008F0C_NUM_FORMAT(x)                                      (((x) >> 12) & 0x7)
#define   C_008F0C_NUM_FORMAT                                         0xFFFF8FFF
#define     V_008F0C_BUF_NUM_FORMAT_UNORM                           0
#define     V_008F0C_BUF_NUM_FORMAT_SNORM                           1
#define     V_008F0C_BUF_NUM_FORMAT_USCALED                         2
#define     V_008F0C_BUF_NUM_FORMAT_SSCALED                         3
#define     V_008F0C_BUF_NUM_FORMAT_UINT                            4
#define     V_008F0C_BUF_NUM_FORMAT_SINT                            5
#define     V_008F0C_BUF_NUM_FORMAT_RESERVED_6                      6 /* gfx8, gfx81 */
#define     V_008F0C_BUF_NUM_FORMAT_SNORM_OGL                       6 /* <= gfx7 */
#define     V_008F0C_BUF_NUM_FORMAT_UNORM_UINT                      6 /* gfx9 */
#define     V_008F0C_BUF_NUM_FORMAT_FLOAT                           7
#define   S_008F0C_DATA_FORMAT(x)                                     (((unsigned)(x) & 0xF) << 15) /* <= gfx9 */
#define   G_008F0C_DATA_FORMAT(x)                                     (((x) >> 15) & 0xF)
#define   C_008F0C_DATA_FORMAT                                        0xFFF87FFF
#define     V_008F0C_BUF_DATA_FORMAT_INVALID                        0
#define     V_008F0C_BUF_DATA_FORMAT_8                              1
#define     V_008F0C_BUF_DATA_FORMAT_16                             2
#define     V_008F0C_BUF_DATA_FORMAT_8_8                            3
#define     V_008F0C_BUF_DATA_FORMAT_32                             4
#define     V_008F0C_BUF_DATA_FORMAT_16_16                          5
#define     V_008F0C_BUF_DATA_FORMAT_10_11_11                       6
#define     V_008F0C_BUF_DATA_FORMAT_11_11_10                       7
#define     V_008F0C_BUF_DATA_FORMAT_10_10_10_2                     8
#define     V_008F0C_BUF_DATA_FORMAT_2_10_10_10                     9
#define     V_008F0C_BUF_DATA_FORMAT_8_8_8_8                        10
#define     V_008F0C_BUF_DATA_FORMAT_32_32                          11
#define     V_008F0C_BUF_DATA_FORMAT_16_16_16_16                    12
#define     V_008F0C_BUF_DATA_FORMAT_32_32_32                       13
#define     V_008F0C_BUF_DATA_FORMAT_32_32_32_32                    14
#define     V_008F0C_BUF_DATA_FORMAT_RESERVED_15                    15
#define   S_008F0C_ELEMENT_SIZE(x)                                    (((unsigned)(x) & 0x3) << 19) /* <= gfx81 */
#define   G_008F0C_ELEMENT_SIZE(x)                                    (((x) >> 19) & 0x3)
#define   C_008F0C_ELEMENT_SIZE                                       0xFFE7FFFF
#define   S_008F0C_USER_VM_ENABLE(x)                                  (((unsigned)(x) & 0x1) << 19) /* gfx9 */
#define   G_008F0C_USER_VM_ENABLE(x)                                  (((x) >> 19) & 0x1)
#define   C_008F0C_USER_VM_ENABLE                                     0xFFF7FFFF
#define   S_008F0C_USER_VM_MODE(x)                                    (((unsigned)(x) & 0x1) << 20) /* gfx9 */
#define   G_008F0C_USER_VM_MODE(x)                                    (((x) >> 20) & 0x1)
#define   C_008F0C_USER_VM_MODE                                       0xFFEFFFFF
#define   S_008F0C_INDEX_STRIDE(x)                                    (((unsigned)(x) & 0x3) << 21)
#define   G_008F0C_INDEX_STRIDE(x)                                    (((x) >> 21) & 0x3)
#define   C_008F0C_INDEX_STRIDE                                       0xFF9FFFFF
#define   S_008F0C_ADD_TID_ENABLE(x)                                  (((unsigned)(x) & 0x1) << 23)
#define   G_008F0C_ADD_TID_ENABLE(x)                                  (((x) >> 23) & 0x1)
#define   C_008F0C_ADD_TID_ENABLE                                     0xFF7FFFFF
#define   S_008F0C_ATC(x)                                             (((unsigned)(x) & 0x1) << 24) /* <= gfx81 */
#define   G_008F0C_ATC(x)                                             (((x) >> 24) & 0x1)
#define   C_008F0C_ATC                                                0xFEFFFFFF
#define   S_008F0C_RESOURCE_LEVEL(x)                                  (((unsigned)(x) & 0x1) << 24) /* >= gfx10 */
#define   G_008F0C_RESOURCE_LEVEL(x)                                  (((x) >> 24) & 0x1)
#define   C_008F0C_RESOURCE_LEVEL                                     0xFEFFFFFF
#define   S_008F0C_HASH_ENABLE(x)                                     (((unsigned)(x) & 0x1) << 25) /* <= gfx81 */
#define   G_008F0C_HASH_ENABLE(x)                                     (((x) >> 25) & 0x1)
#define   C_008F0C_HASH_ENABLE                                        0xFDFFFFFF
#define   S_008F0C_HEAP(x)                                            (((unsigned)(x) & 0x1) << 26) /* <= gfx81 */
#define   G_008F0C_HEAP(x)                                            (((x) >> 26) & 0x1)
#define   C_008F0C_HEAP                                               0xFBFFFFFF
#define   S_008F0C_LLC_NOALLOC(x)                                     (((unsigned)(x) & 0x3) << 26) /* >= gfx103 */
#define   G_008F0C_LLC_NOALLOC(x)                                     (((x) >> 26) & 0x3)
#define   C_008F0C_LLC_NOALLOC                                        0xF3FFFFFF
#define   S_008F0C_MTYPE(x)                                           (((unsigned)(x) & 0x7) << 27) /* <= gfx81 */
#define   G_008F0C_MTYPE(x)                                           (((x) >> 27) & 0x7)
#define   C_008F0C_MTYPE                                              0xC7FFFFFF
#define   S_008F0C_NV(x)                                              (((unsigned)(x) & 0x1) << 27) /* gfx9 */
#define   G_008F0C_NV(x)                                              (((x) >> 27) & 0x1)
#define   C_008F0C_NV                                                 0xF7FFFFFF
#define   S_008F0C_OOB_SELECT(x)                                      (((unsigned)(x) & 0x3) << 28) /* >= gfx10 */
#define   G_008F0C_OOB_SELECT(x)                                      (((x) >> 28) & 0x3)
#define   C_008F0C_OOB_SELECT                                         0xCFFFFFFF
#define     V_008F0C_OOB_SELECT_STRUCTURED_WITH_OFFSET              0
#define     V_008F0C_OOB_SELECT_STRUCTURED                          1
#define     V_008F0C_OOB_SELECT_DISABLED                            2
#define     V_008F0C_OOB_SELECT_RAW                                 3
#define   S_008F0C_TYPE(x)                                            (((unsigned)(x) & 0x3) << 30)
#define   G_008F0C_TYPE(x)                                            (((x) >> 30) & 0x3)
#define   C_008F0C_TYPE                                               0x3FFFFFFF
#define     V_008F0C_SQ_RSRC_BUF                                    0 /* <= gfx9 */
#define     V_008F0C_SQ_RSRC_BUF_RSVD_1                             1 /* <= gfx9 */
#define     V_008F0C_SQ_RSRC_BUF_RSVD_2                             2 /* <= gfx9 */
#define     V_008F0C_SQ_RSRC_BUF_RSVD_3                             3 /* <= gfx9 */
#define R_008F10_SQ_IMG_RSRC_WORD0                                      0x008F10 /* <= gfx9 */
#define R_008F14_SQ_IMG_RSRC_WORD1                                      0x008F14 /* <= gfx9 */
#define   S_008F14_BASE_ADDRESS_HI(x)                                 (((unsigned)(x) & 0xFF) << 0)
#define   G_008F14_BASE_ADDRESS_HI(x)                                 (((x) >> 0) & 0xFF)
#define   C_008F14_BASE_ADDRESS_HI                                    0xFFFFFF00
#define   S_008F14_MIN_LOD(x)                                         (((unsigned)(x) & 0xFFF) << 8)
#define   G_008F14_MIN_LOD(x)                                         (((x) >> 8) & 0xFFF)
#define   C_008F14_MIN_LOD                                            0xFFF000FF
#define   S_008F14_DATA_FORMAT(x)                                     (((unsigned)(x) & 0x3F) << 20)
#define   G_008F14_DATA_FORMAT(x)                                     (((x) >> 20) & 0x3F)
#define   C_008F14_DATA_FORMAT                                        0xFC0FFFFF
#define     V_008F14_IMG_DATA_FORMAT_INVALID                        0
#define     V_008F14_IMG_DATA_FORMAT_8                              1
#define     V_008F14_IMG_DATA_FORMAT_16                             2
#define     V_008F14_IMG_DATA_FORMAT_8_8                            3
#define     V_008F14_IMG_DATA_FORMAT_32                             4
#define     V_008F14_IMG_DATA_FORMAT_16_16                          5
#define     V_008F14_IMG_DATA_FORMAT_10_11_11                       6
#define     V_008F14_IMG_DATA_FORMAT_11_11_10                       7
#define     V_008F14_IMG_DATA_FORMAT_10_10_10_2                     8
#define     V_008F14_IMG_DATA_FORMAT_2_10_10_10                     9
#define     V_008F14_IMG_DATA_FORMAT_8_8_8_8                        10
#define     V_008F14_IMG_DATA_FORMAT_32_32                          11
#define     V_008F14_IMG_DATA_FORMAT_16_16_16_16                    12
#define     V_008F14_IMG_DATA_FORMAT_32_32_32                       13
#define     V_008F14_IMG_DATA_FORMAT_32_32_32_32                    14
#define     V_008F14_IMG_DATA_FORMAT_16_AS_32_32_GFX81              15 /* gfx81 */
#define     V_008F14_IMG_DATA_FORMAT_RESERVED_15                    15 /* <= gfx8, gfx9 */
#define     V_008F14_IMG_DATA_FORMAT_5_6_5                          16
#define     V_008F14_IMG_DATA_FORMAT_1_5_5_5                        17
#define     V_008F14_IMG_DATA_FORMAT_5_5_5_1                        18
#define     V_008F14_IMG_DATA_FORMAT_4_4_4_4                        19
#define     V_008F14_IMG_DATA_FORMAT_8_24                           20
#define     V_008F14_IMG_DATA_FORMAT_24_8                           21
#define     V_008F14_IMG_DATA_FORMAT_X24_8_32                       22
#define     V_008F14_IMG_DATA_FORMAT_8_AS_8_8_8_8                   23 /* gfx81, gfx9 */
#define     V_008F14_IMG_DATA_FORMAT_RESERVED_23                    23 /* <= gfx8 */
#define     V_008F14_IMG_DATA_FORMAT_ETC2_RGB                       24 /* gfx81, gfx9 */
#define     V_008F14_IMG_DATA_FORMAT_RESERVED_24                    24 /* <= gfx8 */
#define     V_008F14_IMG_DATA_FORMAT_ETC2_RGBA                      25 /* gfx81, gfx9 */
#define     V_008F14_IMG_DATA_FORMAT_RESERVED_25                    25 /* <= gfx8 */
#define     V_008F14_IMG_DATA_FORMAT_ETC2_R                         26 /* gfx81, gfx9 */
#define     V_008F14_IMG_DATA_FORMAT_RESERVED_26                    26 /* <= gfx8 */
#define     V_008F14_IMG_DATA_FORMAT_ETC2_RG                        27 /* gfx81, gfx9 */
#define     V_008F14_IMG_DATA_FORMAT_RESERVED_27                    27 /* <= gfx8 */
#define     V_008F14_IMG_DATA_FORMAT_ETC2_RGBA1                     28 /* gfx81, gfx9 */
#define     V_008F14_IMG_DATA_FORMAT_RESERVED_28                    28 /* <= gfx8 */
#define     V_008F14_IMG_DATA_FORMAT_RESERVED_29                    29
#define     V_008F14_IMG_DATA_FORMAT_RESERVED_30                    30
#define     V_008F14_IMG_DATA_FORMAT_6E4                            31 /* gfx9 */
#define     V_008F14_IMG_DATA_FORMAT_RESERVED_31                    31 /* <= gfx81 */
#define     V_008F14_IMG_DATA_FORMAT_GB_GR                          32
#define     V_008F14_IMG_DATA_FORMAT_BG_RG                          33
#define     V_008F14_IMG_DATA_FORMAT_5_9_9_9                        34
#define     V_008F14_IMG_DATA_FORMAT_BC1                            35
#define     V_008F14_IMG_DATA_FORMAT_BC2                            36
#define     V_008F14_IMG_DATA_FORMAT_BC3                            37
#define     V_008F14_IMG_DATA_FORMAT_BC4                            38
#define     V_008F14_IMG_DATA_FORMAT_BC5                            39
#define     V_008F14_IMG_DATA_FORMAT_BC6                            40
#define     V_008F14_IMG_DATA_FORMAT_BC7                            41
#define     V_008F14_IMG_DATA_FORMAT_16_AS_16_16_16_16_GFX81        42 /* gfx81 */
#define     V_008F14_IMG_DATA_FORMAT_16_AS_32_32_GFX9               42 /* gfx9 */
#define     V_008F14_IMG_DATA_FORMAT_RESERVED_42                    42 /* <= gfx8 */
#define     V_008F14_IMG_DATA_FORMAT_16_AS_16_16_16_16_GFX9         43 /* gfx9 */
#define     V_008F14_IMG_DATA_FORMAT_16_AS_32_32_32_32_GFX81        43 /* gfx81 */
#define     V_008F14_IMG_DATA_FORMAT_RESERVED_43                    43 /* <= gfx8 */
#define     V_008F14_IMG_DATA_FORMAT_16_AS_32_32_32_32_GFX9         44 /* gfx9 */
#define     V_008F14_IMG_DATA_FORMAT_FMASK8_S2_F1                   44 /* <= gfx81 */
#define     V_008F14_IMG_DATA_FORMAT_FMASK                          45 /* gfx9 */
#define     V_008F14_IMG_DATA_FORMAT_FMASK8_S4_F1                   45 /* <= gfx81 */
#define     V_008F14_IMG_DATA_FORMAT_ASTC_2D_LDR                    46 /* gfx9 */
#define     V_008F14_IMG_DATA_FORMAT_FMASK8_S8_F1                   46 /* <= gfx81 */
#define     V_008F14_IMG_DATA_FORMAT_ASTC_2D_HDR                    47 /* gfx9 */
#define     V_008F14_IMG_DATA_FORMAT_FMASK8_S2_F2                   47 /* <= gfx81 */
#define     V_008F14_IMG_DATA_FORMAT_ASTC_2D_LDR_SRGB               48 /* gfx9 */
#define     V_008F14_IMG_DATA_FORMAT_FMASK8_S4_F2                   48 /* <= gfx81 */
#define     V_008F14_IMG_DATA_FORMAT_ASTC_3D_LDR                    49 /* gfx9 */
#define     V_008F14_IMG_DATA_FORMAT_FMASK8_S4_F4                   49 /* <= gfx81 */
#define     V_008F14_IMG_DATA_FORMAT_ASTC_3D_HDR                    50 /* gfx9 */
#define     V_008F14_IMG_DATA_FORMAT_FMASK16_S16_F1                 50 /* <= gfx81 */
#define     V_008F14_IMG_DATA_FORMAT_ASTC_3D_LDR_SRGB               51 /* gfx9 */
#define     V_008F14_IMG_DATA_FORMAT_FMASK16_S8_F2                  51 /* <= gfx81 */
#define     V_008F14_IMG_DATA_FORMAT_FMASK32_S16_F2                 52 /* <= gfx81 */
#define     V_008F14_IMG_DATA_FORMAT_N_IN_16                        52 /* gfx9 */
#define     V_008F14_IMG_DATA_FORMAT_FMASK32_S8_F4                  53 /* <= gfx81 */
#define     V_008F14_IMG_DATA_FORMAT_N_IN_16_16                     53 /* gfx9 */
#define     V_008F14_IMG_DATA_FORMAT_FMASK32_S8_F8                  54 /* <= gfx81 */
#define     V_008F14_IMG_DATA_FORMAT_N_IN_16_16_16_16               54 /* gfx9 */
#define     V_008F14_IMG_DATA_FORMAT_FMASK64_S16_F4                 55 /* <= gfx81 */
#define     V_008F14_IMG_DATA_FORMAT_N_IN_16_AS_16_16_16_16         55 /* gfx9 */
#define     V_008F14_IMG_DATA_FORMAT_FMASK64_S16_F8                 56 /* <= gfx81 */
#define     V_008F14_IMG_DATA_FORMAT_RESERVED_56                    56 /* gfx9 */
#define     V_008F14_IMG_DATA_FORMAT_4_4                            57
#define     V_008F14_IMG_DATA_FORMAT_6_5_5                          58
#define     V_008F14_IMG_DATA_FORMAT_1                              59 /* <= gfx81 */
#define     V_008F14_IMG_DATA_FORMAT_RESERVED_59                    59 /* gfx9 */
#define     V_008F14_IMG_DATA_FORMAT_1_REVERSED                     60 /* <= gfx81 */
#define     V_008F14_IMG_DATA_FORMAT_RESERVED_60                    60 /* gfx9 */
#define     V_008F14_IMG_DATA_FORMAT_32_AS_8                        61 /* <= gfx8 */
#define     V_008F14_IMG_DATA_FORMAT_8_AS_32                        61 /* gfx81, gfx9 */
#define     V_008F14_IMG_DATA_FORMAT_32_AS_8_8                      62 /* <= gfx8 */
#define     V_008F14_IMG_DATA_FORMAT_8_AS_32_32                     62 /* gfx81, gfx9 */
#define     V_008F14_IMG_DATA_FORMAT_32_AS_32_32_32_32              63
#define   S_008F14_DATA_FORMAT_STENCIL(x)                             (((unsigned)(x) & 0x3F) << 20) /* gfx9 */
#define   G_008F14_DATA_FORMAT_STENCIL(x)                             (((x) >> 20) & 0x3F)
#define   C_008F14_DATA_FORMAT_STENCIL                                0xFC0FFFFF
#define     V_008F14_IMG_DATA_FORMAT_S8_16                          59
#define     V_008F14_IMG_DATA_FORMAT_S8_32                          60
#define   S_008F14_NUM_FORMAT(x)                                      (((unsigned)(x) & 0xF) << 26)
#define   G_008F14_NUM_FORMAT(x)                                      (((x) >> 26) & 0xF)
#define   C_008F14_NUM_FORMAT                                         0xC3FFFFFF
#define     V_008F14_IMG_NUM_FORMAT_UNORM                           0
#define     V_008F14_IMG_NUM_FORMAT_SNORM                           1
#define     V_008F14_IMG_NUM_FORMAT_USCALED                         2
#define     V_008F14_IMG_NUM_FORMAT_SSCALED                         3
#define     V_008F14_IMG_NUM_FORMAT_UINT                            4
#define     V_008F14_IMG_NUM_FORMAT_SINT                            5
#define     V_008F14_IMG_NUM_FORMAT_RESERVED_6                      6 /* gfx8, gfx81 */
#define     V_008F14_IMG_NUM_FORMAT_SNORM_OGL                       6 /* <= gfx7 */
#define     V_008F14_IMG_NUM_FORMAT_UNORM_UINT                      6 /* gfx9 */
#define     V_008F14_IMG_NUM_FORMAT_FLOAT                           7
#define     V_008F14_IMG_NUM_FORMAT_RESERVED_8                      8
#define     V_008F14_IMG_NUM_FORMAT_SRGB                            9
#define     V_008F14_IMG_NUM_FORMAT_RESERVED_10                     10 /* gfx8, gfx81, gfx9 */
#define     V_008F14_IMG_NUM_FORMAT_UBNORM                          10 /* <= gfx7 */
#define     V_008F14_IMG_NUM_FORMAT_RESERVED_11                     11 /* gfx8, gfx81, gfx9 */
#define     V_008F14_IMG_NUM_FORMAT_UBNORM_OGL                      11 /* <= gfx7 */
#define     V_008F14_IMG_NUM_FORMAT_RESERVED_12                     12 /* gfx8, gfx81, gfx9 */
#define     V_008F14_IMG_NUM_FORMAT_UBINT                           12 /* <= gfx7 */
#define     V_008F14_IMG_NUM_FORMAT_RESERVED_13                     13 /* gfx8, gfx81, gfx9 */
#define     V_008F14_IMG_NUM_FORMAT_UBSCALED                        13 /* <= gfx7 */
#define     V_008F14_IMG_NUM_FORMAT_RESERVED_14                     14
#define     V_008F14_IMG_NUM_FORMAT_RESERVED_15                     15
#define   S_008F14_NUM_FORMAT_FMASK(x)                                (((unsigned)(x) & 0xF) << 26) /* gfx9 */
#define   G_008F14_NUM_FORMAT_FMASK(x)                                (((x) >> 26) & 0xF)
#define   C_008F14_NUM_FORMAT_FMASK                                   0xC3FFFFFF
#define     V_008F14_IMG_NUM_FORMAT_FMASK_8_2_1                     0
#define     V_008F14_IMG_NUM_FORMAT_FMASK_8_4_1                     1
#define     V_008F14_IMG_NUM_FORMAT_FMASK_8_8_1                     2
#define     V_008F14_IMG_NUM_FORMAT_FMASK_8_2_2                     3
#define     V_008F14_IMG_NUM_FORMAT_FMASK_8_4_2                     4
#define     V_008F14_IMG_NUM_FORMAT_FMASK_8_4_4                     5
#define     V_008F14_IMG_NUM_FORMAT_FMASK_16_16_1                   6
#define     V_008F14_IMG_NUM_FORMAT_FMASK_16_8_2                    7
#define     V_008F14_IMG_NUM_FORMAT_FMASK_32_16_2                   8
#define     V_008F14_IMG_NUM_FORMAT_FMASK_32_8_4                    9
#define     V_008F14_IMG_NUM_FORMAT_FMASK_32_8_8                    10
#define     V_008F14_IMG_NUM_FORMAT_FMASK_64_16_4                   11
#define     V_008F14_IMG_NUM_FORMAT_FMASK_64_16_8                   12
#define     V_008F14_IMG_NUM_FORMAT_FMASK_RESERVED_13               13
#define     V_008F14_IMG_NUM_FORMAT_FMASK_RESERVED_14               14
#define     V_008F14_IMG_NUM_FORMAT_FMASK_RESERVED_15               15
#define   S_008F14_MTYPE(x)                                           (((unsigned)(x) & 0x3) << 30) /* <= gfx81 */
#define   G_008F14_MTYPE(x)                                           (((x) >> 30) & 0x3)
#define   C_008F14_MTYPE                                              0x3FFFFFFF
#define   S_008F14_NV(x)                                              (((unsigned)(x) & 0x1) << 30) /* gfx9 */
#define   G_008F14_NV(x)                                              (((x) >> 30) & 0x1)
#define   C_008F14_NV                                                 0xBFFFFFFF
#define   S_008F14_META_DIRECT(x)                                     (((unsigned)(x) & 0x1) << 31) /* gfx9 */
#define   G_008F14_META_DIRECT(x)                                     (((x) >> 31) & 0x1)
#define   C_008F14_META_DIRECT                                        0x7FFFFFFF
#define R_008F18_SQ_IMG_RSRC_WORD2                                      0x008F18 /* <= gfx9 */
#define   S_008F18_WIDTH(x)                                           (((unsigned)(x) & 0x3FFF) << 0)
#define   G_008F18_WIDTH(x)                                           (((x) >> 0) & 0x3FFF)
#define   C_008F18_WIDTH                                              0xFFFFC000
#define   S_008F18_HEIGHT(x)                                          (((unsigned)(x) & 0x3FFF) << 14)
#define   G_008F18_HEIGHT(x)                                          (((x) >> 14) & 0x3FFF)
#define   C_008F18_HEIGHT                                             0xF0003FFF
#define   S_008F18_PERF_MOD(x)                                        (((unsigned)(x) & 0x7) << 28)
#define   G_008F18_PERF_MOD(x)                                        (((x) >> 28) & 0x7)
#define   C_008F18_PERF_MOD                                           0x8FFFFFFF
#define   S_008F18_INTERLACED(x)                                      (((unsigned)(x) & 0x1) << 31) /* <= gfx81 */
#define   G_008F18_INTERLACED(x)                                      (((x) >> 31) & 0x1)
#define   C_008F18_INTERLACED                                         0x7FFFFFFF
#define R_008F1C_SQ_IMG_RSRC_WORD3                                      0x008F1C /* <= gfx9 */
#define   S_008F1C_DST_SEL_X(x)                                       (((unsigned)(x) & 0x7) << 0)
#define   G_008F1C_DST_SEL_X(x)                                       (((x) >> 0) & 0x7)
#define   C_008F1C_DST_SEL_X                                          0xFFFFFFF8
#define     V_008F1C_SQ_SEL_0                                       0
#define     V_008F1C_SQ_SEL_1                                       1
#define     V_008F1C_SQ_SEL_RESERVED_0                              2
#define     V_008F1C_SQ_SEL_RESERVED_1                              3
#define     V_008F1C_SQ_SEL_X                                       4
#define     V_008F1C_SQ_SEL_Y                                       5
#define     V_008F1C_SQ_SEL_Z                                       6
#define     V_008F1C_SQ_SEL_W                                       7
#define   S_008F1C_DST_SEL_Y(x)                                       (((unsigned)(x) & 0x7) << 3)
#define   G_008F1C_DST_SEL_Y(x)                                       (((x) >> 3) & 0x7)
#define   C_008F1C_DST_SEL_Y                                          0xFFFFFFC7
#define   S_008F1C_DST_SEL_Z(x)                                       (((unsigned)(x) & 0x7) << 6)
#define   G_008F1C_DST_SEL_Z(x)                                       (((x) >> 6) & 0x7)
#define   C_008F1C_DST_SEL_Z                                          0xFFFFFE3F
#define   S_008F1C_DST_SEL_W(x)                                       (((unsigned)(x) & 0x7) << 9)
#define   G_008F1C_DST_SEL_W(x)                                       (((x) >> 9) & 0x7)
#define   C_008F1C_DST_SEL_W                                          0xFFFFF1FF
#define   S_008F1C_BASE_LEVEL(x)                                      (((unsigned)(x) & 0xF) << 12)
#define   G_008F1C_BASE_LEVEL(x)                                      (((x) >> 12) & 0xF)
#define   C_008F1C_BASE_LEVEL                                         0xFFFF0FFF
#define   S_008F1C_LAST_LEVEL(x)                                      (((unsigned)(x) & 0xF) << 16)
#define   G_008F1C_LAST_LEVEL(x)                                      (((x) >> 16) & 0xF)
#define   C_008F1C_LAST_LEVEL                                         0xFFF0FFFF
#define   S_008F1C_SW_MODE(x)                                         (((unsigned)(x) & 0x1F) << 20) /* gfx9 */
#define   G_008F1C_SW_MODE(x)                                         (((x) >> 20) & 0x1F)
#define   C_008F1C_SW_MODE                                            0xFE0FFFFF
#define   S_008F1C_TILING_INDEX(x)                                    (((unsigned)(x) & 0x1F) << 20) /* <= gfx81 */
#define   G_008F1C_TILING_INDEX(x)                                    (((x) >> 20) & 0x1F)
#define   C_008F1C_TILING_INDEX                                       0xFE0FFFFF
#define   S_008F1C_POW2_PAD(x)                                        (((unsigned)(x) & 0x1) << 25) /* <= gfx81 */
#define   G_008F1C_POW2_PAD(x)                                        (((x) >> 25) & 0x1)
#define   C_008F1C_POW2_PAD                                           0xFDFFFFFF
#define   S_008F1C_MTYPE(x)                                           (((unsigned)(x) & 0x1) << 26) /* <= gfx81 */
#define   G_008F1C_MTYPE(x)                                           (((x) >> 26) & 0x1)
#define   C_008F1C_MTYPE                                              0xFBFFFFFF
#define   S_008F1C_ATC(x)                                             (((unsigned)(x) & 0x1) << 27) /* <= gfx81 */
#define   G_008F1C_ATC(x)                                             (((x) >> 27) & 0x1)
#define   C_008F1C_ATC                                                0xF7FFFFFF
#define   S_008F1C_TYPE(x)                                            (((unsigned)(x) & 0xF) << 28)
#define   G_008F1C_TYPE(x)                                            (((x) >> 28) & 0xF)
#define   C_008F1C_TYPE                                               0x0FFFFFFF
#define     V_008F1C_SQ_RSRC_IMG_RSVD_0                             0
#define     V_008F1C_SQ_RSRC_IMG_RSVD_1                             1
#define     V_008F1C_SQ_RSRC_IMG_RSVD_2                             2
#define     V_008F1C_SQ_RSRC_IMG_RSVD_3                             3
#define     V_008F1C_SQ_RSRC_IMG_RSVD_4                             4
#define     V_008F1C_SQ_RSRC_IMG_RSVD_5                             5
#define     V_008F1C_SQ_RSRC_IMG_RSVD_6                             6
#define     V_008F1C_SQ_RSRC_IMG_RSVD_7                             7
#define     V_008F1C_SQ_RSRC_IMG_1D                                 8
#define     V_008F1C_SQ_RSRC_IMG_2D                                 9
#define     V_008F1C_SQ_RSRC_IMG_3D                                 10
#define     V_008F1C_SQ_RSRC_IMG_CUBE                               11
#define     V_008F1C_SQ_RSRC_IMG_1D_ARRAY                           12
#define     V_008F1C_SQ_RSRC_IMG_2D_ARRAY                           13
#define     V_008F1C_SQ_RSRC_IMG_2D_MSAA                            14
#define     V_008F1C_SQ_RSRC_IMG_2D_MSAA_ARRAY                      15
#define R_008F20_SQ_IMG_RSRC_WORD4                                      0x008F20 /* <= gfx9 */
#define   S_008F20_DEPTH(x)                                           (((unsigned)(x) & 0x1FFF) << 0)
#define   G_008F20_DEPTH(x)                                           (((x) >> 0) & 0x1FFF)
#define   C_008F20_DEPTH                                              0xFFFFE000
#define   S_008F20_PITCH(x)                                           (((unsigned)(x) & 0xFFFF) << 13)
#define   G_008F20_PITCH(x)                                           (((x) >> 13) & 0xFFFF)
#define   C_008F20_PITCH                                              0xE0001FFF
#define   S_008F20_BC_SWIZZLE(x)                                      (((unsigned)(x) & 0x7) << 29) /* gfx9 */
#define   G_008F20_BC_SWIZZLE(x)                                      (((x) >> 29) & 0x7)
#define   C_008F20_BC_SWIZZLE                                         0x1FFFFFFF
#define     V_008F20_BC_SWIZZLE_XYZW                                0
#define     V_008F20_BC_SWIZZLE_XWYZ                                1
#define     V_008F20_BC_SWIZZLE_WZYX                                2
#define     V_008F20_BC_SWIZZLE_WXYZ                                3
#define     V_008F20_BC_SWIZZLE_ZYXW                                4
#define     V_008F20_BC_SWIZZLE_YXWZ                                5
#define R_008F24_SQ_IMG_RSRC_WORD5                                      0x008F24 /* <= gfx9 */
#define   S_008F24_BASE_ARRAY(x)                                      (((unsigned)(x) & 0x1FFF) << 0)
#define   G_008F24_BASE_ARRAY(x)                                      (((x) >> 0) & 0x1FFF)
#define   C_008F24_BASE_ARRAY                                         0xFFFFE000
#define   S_008F24_ARRAY_PITCH(x)                                     (((unsigned)(x) & 0xF) << 13) /* gfx9 */
#define   G_008F24_ARRAY_PITCH(x)                                     (((x) >> 13) & 0xF)
#define   C_008F24_ARRAY_PITCH                                        0xFFFE1FFF
#define   S_008F24_LAST_ARRAY(x)                                      (((unsigned)(x) & 0x1FFF) << 13) /* <= gfx81 */
#define   G_008F24_LAST_ARRAY(x)                                      (((x) >> 13) & 0x1FFF)
#define   C_008F24_LAST_ARRAY                                         0xFC001FFF
#define   S_008F24_META_DATA_ADDRESS(x)                               (((unsigned)(x) & 0xFF) << 17) /* gfx9 */
#define   G_008F24_META_DATA_ADDRESS(x)                               (((x) >> 17) & 0xFF)
#define   C_008F24_META_DATA_ADDRESS                                  0xFE01FFFF
#define   S_008F24_META_LINEAR(x)                                     (((unsigned)(x) & 0x1) << 25) /* gfx9 */
#define   G_008F24_META_LINEAR(x)                                     (((x) >> 25) & 0x1)
#define   C_008F24_META_LINEAR                                        0xFDFFFFFF
#define   S_008F24_META_PIPE_ALIGNED(x)                               (((unsigned)(x) & 0x1) << 26) /* gfx9 */
#define   G_008F24_META_PIPE_ALIGNED(x)                               (((x) >> 26) & 0x1)
#define   C_008F24_META_PIPE_ALIGNED                                  0xFBFFFFFF
#define   S_008F24_META_RB_ALIGNED(x)                                 (((unsigned)(x) & 0x1) << 27) /* gfx9 */
#define   G_008F24_META_RB_ALIGNED(x)                                 (((x) >> 27) & 0x1)
#define   C_008F24_META_RB_ALIGNED                                    0xF7FFFFFF
#define   S_008F24_MAX_MIP(x)                                         (((unsigned)(x) & 0xF) << 28) /* gfx9 */
#define   G_008F24_MAX_MIP(x)                                         (((x) >> 28) & 0xF)
#define   C_008F24_MAX_MIP                                            0x0FFFFFFF
#define R_008F28_SQ_IMG_RSRC_WORD6                                      0x008F28 /* <= gfx9 */
#define   S_008F28_MIN_LOD_WARN(x)                                    (((unsigned)(x) & 0xFFF) << 0)
#define   G_008F28_MIN_LOD_WARN(x)                                    (((x) >> 0) & 0xFFF)
#define   C_008F28_MIN_LOD_WARN                                       0xFFFFF000
#define   S_008F28_COUNTER_BANK_ID(x)                                 (((unsigned)(x) & 0xFF) << 12)
#define   G_008F28_COUNTER_BANK_ID(x)                                 (((x) >> 12) & 0xFF)
#define   C_008F28_COUNTER_BANK_ID                                    0xFFF00FFF
#define   S_008F28_LOD_HDW_CNT_EN(x)                                  (((unsigned)(x) & 0x1) << 20)
#define   G_008F28_LOD_HDW_CNT_EN(x)                                  (((x) >> 20) & 0x1)
#define   C_008F28_LOD_HDW_CNT_EN                                     0xFFEFFFFF
#define   S_008F28_COMPRESSION_EN(x)                                  (((unsigned)(x) & 0x1) << 21) /* gfx8, gfx81, gfx9 */
#define   G_008F28_COMPRESSION_EN(x)                                  (((x) >> 21) & 0x1)
#define   C_008F28_COMPRESSION_EN                                     0xFFDFFFFF
#define   S_008F28_UNUNSED(x)                                         (((unsigned)(x) & 0x7FF) << 21) /* <= gfx7 */
#define   G_008F28_UNUNSED(x)                                         (((x) >> 21) & 0x7FF)
#define   C_008F28_UNUNSED                                            0x001FFFFF
#define   S_008F28_ALPHA_IS_ON_MSB(x)                                 (((unsigned)(x) & 0x1) << 22) /* gfx8, gfx81, gfx9 */
#define   G_008F28_ALPHA_IS_ON_MSB(x)                                 (((x) >> 22) & 0x1)
#define   C_008F28_ALPHA_IS_ON_MSB                                    0xFFBFFFFF
#define   S_008F28_COLOR_TRANSFORM(x)                                 (((unsigned)(x) & 0x1) << 23) /* gfx8, gfx81, gfx9 */
#define   G_008F28_COLOR_TRANSFORM(x)                                 (((x) >> 23) & 0x1)
#define   C_008F28_COLOR_TRANSFORM                                    0xFF7FFFFF
#define   S_008F28_LOST_ALPHA_BITS(x)                                 (((unsigned)(x) & 0xF) << 24) /* gfx8, gfx81, gfx9 */
#define   G_008F28_LOST_ALPHA_BITS(x)                                 (((x) >> 24) & 0xF)
#define   C_008F28_LOST_ALPHA_BITS                                    0xF0FFFFFF
#define   S_008F28_LOST_COLOR_BITS(x)                                 (((unsigned)(x) & 0xF) << 28) /* gfx8, gfx81, gfx9 */
#define   G_008F28_LOST_COLOR_BITS(x)                                 (((x) >> 28) & 0xF)
#define   C_008F28_LOST_COLOR_BITS                                    0x0FFFFFFF
#define R_008F2C_SQ_IMG_RSRC_WORD7                                      0x008F2C /* <= gfx9 */
#define R_008F30_SQ_IMG_SAMP_WORD0                                      0x008F30
#define   S_008F30_CLAMP_X(x)                                         (((unsigned)(x) & 0x7) << 0)
#define   G_008F30_CLAMP_X(x)                                         (((x) >> 0) & 0x7)
#define   C_008F30_CLAMP_X                                            0xFFFFFFF8
#define     V_008F30_SQ_TEX_WRAP                                    0 /* <= gfx9 */
#define     V_008F30_SQ_TEX_MIRROR                                  1 /* <= gfx9 */
#define     V_008F30_SQ_TEX_CLAMP_LAST_TEXEL                        2 /* <= gfx9 */
#define     V_008F30_SQ_TEX_MIRROR_ONCE_LAST_TEXEL                  3 /* <= gfx9 */
#define     V_008F30_SQ_TEX_CLAMP_HALF_BORDER                       4 /* <= gfx9 */
#define     V_008F30_SQ_TEX_MIRROR_ONCE_HALF_BORDER                 5 /* <= gfx9 */
#define     V_008F30_SQ_TEX_CLAMP_BORDER                            6 /* <= gfx9 */
#define     V_008F30_SQ_TEX_MIRROR_ONCE_BORDER                      7 /* <= gfx9 */
#define   S_008F30_CLAMP_Y(x)                                         (((unsigned)(x) & 0x7) << 3)
#define   G_008F30_CLAMP_Y(x)                                         (((x) >> 3) & 0x7)
#define   C_008F30_CLAMP_Y                                            0xFFFFFFC7
#define   S_008F30_CLAMP_Z(x)                                         (((unsigned)(x) & 0x7) << 6)
#define   G_008F30_CLAMP_Z(x)                                         (((x) >> 6) & 0x7)
#define   C_008F30_CLAMP_Z                                            0xFFFFFE3F
#define   S_008F30_MAX_ANISO_RATIO(x)                                 (((unsigned)(x) & 0x7) << 9)
#define   G_008F30_MAX_ANISO_RATIO(x)                                 (((x) >> 9) & 0x7)
#define   C_008F30_MAX_ANISO_RATIO                                    0xFFFFF1FF
#define   S_008F30_DEPTH_COMPARE_FUNC(x)                              (((unsigned)(x) & 0x7) << 12)
#define   G_008F30_DEPTH_COMPARE_FUNC(x)                              (((x) >> 12) & 0x7)
#define   C_008F30_DEPTH_COMPARE_FUNC                                 0xFFFF8FFF
#define     V_008F30_SQ_TEX_DEPTH_COMPARE_NEVER                     0 /* <= gfx9 */
#define     V_008F30_SQ_TEX_DEPTH_COMPARE_LESS                      1 /* <= gfx9 */
#define     V_008F30_SQ_TEX_DEPTH_COMPARE_EQUAL                     2 /* <= gfx9 */
#define     V_008F30_SQ_TEX_DEPTH_COMPARE_LESSEQUAL                 3 /* <= gfx9 */
#define     V_008F30_SQ_TEX_DEPTH_COMPARE_GREATER                   4 /* <= gfx9 */
#define     V_008F30_SQ_TEX_DEPTH_COMPARE_NOTEQUAL                  5 /* <= gfx9 */
#define     V_008F30_SQ_TEX_DEPTH_COMPARE_GREATEREQUAL              6 /* <= gfx9 */
#define     V_008F30_SQ_TEX_DEPTH_COMPARE_ALWAYS                    7 /* <= gfx9 */
#define   S_008F30_FORCE_UNNORMALIZED(x)                              (((unsigned)(x) & 0x1) << 15)
#define   G_008F30_FORCE_UNNORMALIZED(x)                              (((x) >> 15) & 0x1)
#define   C_008F30_FORCE_UNNORMALIZED                                 0xFFFF7FFF
#define   S_008F30_ANISO_THRESHOLD(x)                                 (((unsigned)(x) & 0x7) << 16)
#define   G_008F30_ANISO_THRESHOLD(x)                                 (((x) >> 16) & 0x7)
#define   C_008F30_ANISO_THRESHOLD                                    0xFFF8FFFF
#define   S_008F30_MC_COORD_TRUNC(x)                                  (((unsigned)(x) & 0x1) << 19)
#define   G_008F30_MC_COORD_TRUNC(x)                                  (((x) >> 19) & 0x1)
#define   C_008F30_MC_COORD_TRUNC                                     0xFFF7FFFF
#define   S_008F30_FORCE_DEGAMMA(x)                                   (((unsigned)(x) & 0x1) << 20)
#define   G_008F30_FORCE_DEGAMMA(x)                                   (((x) >> 20) & 0x1)
#define   C_008F30_FORCE_DEGAMMA                                      0xFFEFFFFF
#define   S_008F30_ANISO_BIAS(x)                                      (((unsigned)(x) & 0x3F) << 21)
#define   G_008F30_ANISO_BIAS(x)                                      (((x) >> 21) & 0x3F)
#define   C_008F30_ANISO_BIAS                                         0xF81FFFFF
#define   S_008F30_TRUNC_COORD(x)                                     (((unsigned)(x) & 0x1) << 27)
#define   G_008F30_TRUNC_COORD(x)                                     (((x) >> 27) & 0x1)
#define   C_008F30_TRUNC_COORD                                        0xF7FFFFFF
#define   S_008F30_DISABLE_CUBE_WRAP(x)                               (((unsigned)(x) & 0x1) << 28)
#define   G_008F30_DISABLE_CUBE_WRAP(x)                               (((x) >> 28) & 0x1)
#define   C_008F30_DISABLE_CUBE_WRAP                                  0xEFFFFFFF
#define   S_008F30_FILTER_MODE(x)                                     (((unsigned)(x) & 0x3) << 29)
#define   G_008F30_FILTER_MODE(x)                                     (((x) >> 29) & 0x3)
#define   C_008F30_FILTER_MODE                                        0x9FFFFFFF
#define     V_008F30_SQ_IMG_FILTER_MODE_BLEND                       0 /* <= gfx9 */
#define     V_008F30_SQ_IMG_FILTER_MODE_MIN                         1 /* <= gfx9 */
#define     V_008F30_SQ_IMG_FILTER_MODE_MAX                         2 /* <= gfx9 */
#define   S_008F30_COMPAT_MODE(x)                                     (((unsigned)(x) & 0x1) << 31) /* gfx8, gfx81, gfx9 */
#define   G_008F30_COMPAT_MODE(x)                                     (((x) >> 31) & 0x1)
#define   C_008F30_COMPAT_MODE                                        0x7FFFFFFF
#define   S_008F30_SKIP_DEGAMMA(x)                                    (((unsigned)(x) & 0x1) << 31) /* >= gfx10 */
#define   G_008F30_SKIP_DEGAMMA(x)                                    (((x) >> 31) & 0x1)
#define   C_008F30_SKIP_DEGAMMA                                       0x7FFFFFFF
#define R_008F34_SQ_IMG_SAMP_WORD1                                      0x008F34
#define   S_008F34_MIN_LOD(x)                                         (((unsigned)(x) & 0xFFF) << 0)
#define   G_008F34_MIN_LOD(x)                                         (((x) >> 0) & 0xFFF)
#define   C_008F34_MIN_LOD                                            0xFFFFF000
#define   S_008F34_MAX_LOD(x)                                         (((unsigned)(x) & 0xFFF) << 12)
#define   G_008F34_MAX_LOD(x)                                         (((x) >> 12) & 0xFFF)
#define   C_008F34_MAX_LOD                                            0xFF000FFF
#define   S_008F34_PERF_MIP(x)                                        (((unsigned)(x) & 0xF) << 24)
#define   G_008F34_PERF_MIP(x)                                        (((x) >> 24) & 0xF)
#define   C_008F34_PERF_MIP                                           0xF0FFFFFF
#define   S_008F34_PERF_Z(x)                                          (((unsigned)(x) & 0xF) << 28)
#define   G_008F34_PERF_Z(x)                                          (((x) >> 28) & 0xF)
#define   C_008F34_PERF_Z                                             0x0FFFFFFF
#define R_008F38_SQ_IMG_SAMP_WORD2                                      0x008F38
#define   S_008F38_BORDER_COLOR_PTR(x)                                (((unsigned)(x) & 0xFFF) << 0) /* >= gfx10 */
#define   G_008F38_BORDER_COLOR_PTR(x)                                (((x) >> 0) & 0xFFF)
#define   C_008F38_BORDER_COLOR_PTR                                   0xFFFFF000
#define   S_008F38_LOD_BIAS(x)                                        (((unsigned)(x) & 0x3FFF) << 0)
#define   G_008F38_LOD_BIAS(x)                                        (((x) >> 0) & 0x3FFF)
#define   C_008F38_LOD_BIAS                                           0xFFFFC000
#define   S_008F38_BORDER_COLOR_TYPE(x)                               (((unsigned)(x) & 0x3) << 12) /* >= gfx10 */
#define   G_008F38_BORDER_COLOR_TYPE(x)                               (((x) >> 12) & 0x3)
#define   C_008F38_BORDER_COLOR_TYPE                                  0xFFFFCFFF
#define   S_008F38_LOD_BIAS_SEC(x)                                    (((unsigned)(x) & 0x3F) << 14)
#define   G_008F38_LOD_BIAS_SEC(x)                                    (((x) >> 14) & 0x3F)
#define   C_008F38_LOD_BIAS_SEC                                       0xFFF03FFF
#define   S_008F38_XY_MAG_FILTER(x)                                   (((unsigned)(x) & 0x3) << 20)
#define   G_008F38_XY_MAG_FILTER(x)                                   (((x) >> 20) & 0x3)
#define   C_008F38_XY_MAG_FILTER                                      0xFFCFFFFF
#define     V_008F38_SQ_TEX_XY_FILTER_POINT                         0 /* <= gfx9 */
#define     V_008F38_SQ_TEX_XY_FILTER_BILINEAR                      1 /* <= gfx9 */
#define     V_008F38_SQ_TEX_XY_FILTER_ANISO_POINT                   2 /* <= gfx9 */
#define     V_008F38_SQ_TEX_XY_FILTER_ANISO_BILINEAR                3 /* <= gfx9 */
#define   S_008F38_XY_MIN_FILTER(x)                                   (((unsigned)(x) & 0x3) << 22)
#define   G_008F38_XY_MIN_FILTER(x)                                   (((x) >> 22) & 0x3)
#define   C_008F38_XY_MIN_FILTER                                      0xFF3FFFFF
#define   S_008F38_Z_FILTER(x)                                        (((unsigned)(x) & 0x3) << 24)
#define   G_008F38_Z_FILTER(x)                                        (((x) >> 24) & 0x3)
#define   C_008F38_Z_FILTER                                           0xFCFFFFFF
#define     V_008F38_SQ_TEX_Z_FILTER_NONE                           0 /* <= gfx9 */
#define     V_008F38_SQ_TEX_Z_FILTER_POINT                          1 /* <= gfx9 */
#define     V_008F38_SQ_TEX_Z_FILTER_LINEAR                         2 /* <= gfx9 */
#define   S_008F38_MIP_FILTER(x)                                      (((unsigned)(x) & 0x3) << 26)
#define   G_008F38_MIP_FILTER(x)                                      (((x) >> 26) & 0x3)
#define   C_008F38_MIP_FILTER                                         0xF3FFFFFF
#define     V_008F38_SQ_TEX_MIP_FILTER_NONE                         0 /* <= gfx9 */
#define     V_008F38_SQ_TEX_MIP_FILTER_POINT                        1 /* <= gfx9 */
#define     V_008F38_SQ_TEX_MIP_FILTER_LINEAR                       2 /* <= gfx9 */
#define     V_008F38_SQ_TEX_MIP_FILTER_POINT_ANISO_ADJ              3 /* gfx8, gfx81, gfx9 */
#define   S_008F38_MIP_POINT_PRECLAMP(x)                              (((unsigned)(x) & 0x1) << 28)
#define   G_008F38_MIP_POINT_PRECLAMP(x)                              (((x) >> 28) & 0x1)
#define   C_008F38_MIP_POINT_PRECLAMP                                 0xEFFFFFFF
#define   S_008F38_ANISO_OVERRIDE_GFX10(x)                            (((unsigned)(x) & 0x1) << 29) /* >= gfx10 */
#define   G_008F38_ANISO_OVERRIDE_GFX10(x)                            (((x) >> 29) & 0x1)
#define   C_008F38_ANISO_OVERRIDE_GFX10                               0xDFFFFFFF
#define   S_008F38_BLEND_ZERO_PRT_GFX9(x)                             (((unsigned)(x) & 0x1) << 29) /* gfx9 */
#define   G_008F38_BLEND_ZERO_PRT_GFX9(x)                             (((x) >> 29) & 0x1)
#define   C_008F38_BLEND_ZERO_PRT_GFX9                                0xDFFFFFFF
#define   S_008F38_DISABLE_LSB_CEIL(x)                                (((unsigned)(x) & 0x1) << 29) /* <= gfx81 */
#define   G_008F38_DISABLE_LSB_CEIL(x)                                (((x) >> 29) & 0x1)
#define   C_008F38_DISABLE_LSB_CEIL                                   0xDFFFFFFF
#define   S_008F38_BLEND_ZERO_PRT_GFX10(x)                            (((unsigned)(x) & 0x1) << 30) /* >= gfx10 */
#define   G_008F38_BLEND_ZERO_PRT_GFX10(x)                            (((x) >> 30) & 0x1)
#define   C_008F38_BLEND_ZERO_PRT_GFX10                               0xBFFFFFFF
#define   S_008F38_FILTER_PREC_FIX(x)                                 (((unsigned)(x) & 0x1) << 30) /* <= gfx9 */
#define   G_008F38_FILTER_PREC_FIX(x)                                 (((x) >> 30) & 0x1)
#define   C_008F38_FILTER_PREC_FIX                                    0xBFFFFFFF
#define   S_008F38_ANISO_OVERRIDE_GFX8(x)                             (((unsigned)(x) & 0x1) << 31) /* gfx8, gfx81, gfx9 */
#define   G_008F38_ANISO_OVERRIDE_GFX8(x)                             (((x) >> 31) & 0x1)
#define   C_008F38_ANISO_OVERRIDE_GFX8                                0x7FFFFFFF
#define   S_008F38_DERIV_ADJUST_EN(x)                                 (((unsigned)(x) & 0x1) << 31) /* >= gfx10 */
#define   G_008F38_DERIV_ADJUST_EN(x)                                 (((x) >> 31) & 0x1)
#define   C_008F38_DERIV_ADJUST_EN                                    0x7FFFFFFF
#define R_008F3C_SQ_IMG_SAMP_WORD3                                      0x008F3C
#define   S_008F3C_BORDER_COLOR_PTR(x)                                (((unsigned)(x) & 0xFFF) << 0)
#define   G_008F3C_BORDER_COLOR_PTR(x)                                (((x) >> 0) & 0xFFF)
#define   C_008F3C_BORDER_COLOR_PTR                                   0xFFFFF000
#define   S_008F3C_SKIP_DEGAMMA(x)                                    (((unsigned)(x) & 0x1) << 12) /* gfx9 */
#define   G_008F3C_SKIP_DEGAMMA(x)                                    (((x) >> 12) & 0x1)
#define   C_008F3C_SKIP_DEGAMMA                                       0xFFFFEFFF
#define   S_008F3C_UPGRADED_DEPTH(x)                                  (((unsigned)(x) & 0x1) << 29) /* <= gfx81 */
#define   G_008F3C_UPGRADED_DEPTH(x)                                  (((x) >> 29) & 0x1)
#define   C_008F3C_UPGRADED_DEPTH                                     0xDFFFFFFF
#define   S_008F3C_BORDER_COLOR_TYPE(x)                               (((unsigned)(x) & 0x3) << 30)
#define   G_008F3C_BORDER_COLOR_TYPE(x)                               (((x) >> 30) & 0x3)
#define   C_008F3C_BORDER_COLOR_TYPE                                  0x3FFFFFFF
#define     V_008F3C_SQ_TEX_BORDER_COLOR_TRANS_BLACK                0 /* <= gfx9 */
#define     V_008F3C_SQ_TEX_BORDER_COLOR_OPAQUE_BLACK               1 /* <= gfx9 */
#define     V_008F3C_SQ_TEX_BORDER_COLOR_OPAQUE_WHITE               2 /* <= gfx9 */
#define     V_008F3C_SQ_TEX_BORDER_COLOR_REGISTER                   3 /* <= gfx9 */
#define R_009100_SPI_CONFIG_CNTL                                        0x009100 /* <= gfx81, gfx10 */
#define   S_009100_GPR_WRITE_PRIORITY(x)                              (((unsigned)(x) & 0x1FFFFF) << 0)
#define   G_009100_GPR_WRITE_PRIORITY(x)                              (((x) >> 0) & 0x1FFFFF)
#define   C_009100_GPR_WRITE_PRIORITY                                 0xFFE00000
#define   S_009100_EXP_PRIORITY_ORDER(x)                              (((unsigned)(x) & 0x7) << 21)
#define   G_009100_EXP_PRIORITY_ORDER(x)                              (((x) >> 21) & 0x7)
#define   C_009100_EXP_PRIORITY_ORDER                                 0xFF1FFFFF
#define   S_009100_ENABLE_SQG_TOP_EVENTS(x)                           (((unsigned)(x) & 0x1) << 24)
#define   G_009100_ENABLE_SQG_TOP_EVENTS(x)                           (((x) >> 24) & 0x1)
#define   C_009100_ENABLE_SQG_TOP_EVENTS                              0xFEFFFFFF
#define   S_009100_ENABLE_SQG_BOP_EVENTS(x)                           (((unsigned)(x) & 0x1) << 25)
#define   G_009100_ENABLE_SQG_BOP_EVENTS(x)                           (((x) >> 25) & 0x1)
#define   C_009100_ENABLE_SQG_BOP_EVENTS                              0xFDFFFFFF
#define   S_009100_RSRC_MGMT_RESET(x)                                 (((unsigned)(x) & 0x1) << 26)
#define   G_009100_RSRC_MGMT_RESET(x)                                 (((x) >> 26) & 0x1)
#define   C_009100_RSRC_MGMT_RESET                                    0xFBFFFFFF
#define   S_009100_TTRACE_STALL_ALL(x)                                (((unsigned)(x) & 0x1) << 27)
#define   G_009100_TTRACE_STALL_ALL(x)                                (((x) >> 27) & 0x1)
#define   C_009100_TTRACE_STALL_ALL                                   0xF7FFFFFF
#define   S_009100_ALLOC_ARB_LRU_ENA(x)                               (((unsigned)(x) & 0x1) << 28) /* gfx10 */
#define   G_009100_ALLOC_ARB_LRU_ENA(x)                               (((x) >> 28) & 0x1)
#define   C_009100_ALLOC_ARB_LRU_ENA                                  0xEFFFFFFF
#define   S_009100_EXP_ARB_LRU_ENA(x)                                 (((unsigned)(x) & 0x1) << 29) /* gfx10 */
#define   G_009100_EXP_ARB_LRU_ENA(x)                                 (((x) >> 29) & 0x1)
#define   C_009100_EXP_ARB_LRU_ENA                                    0xDFFFFFFF
#define   S_009100_PS_PKR_PRIORITY_CNTL(x)                            (((unsigned)(x) & 0x3) << 30) /* gfx10 */
#define   G_009100_PS_PKR_PRIORITY_CNTL(x)                            (((x) >> 30) & 0x3)
#define   C_009100_PS_PKR_PRIORITY_CNTL                               0x3FFFFFFF
#define R_009130_SPI_CONFIG_CNTL                                        0x009130 /* >= gfx103 */
#define   S_009130_GPR_WRITE_PRIORITY(x)                              (((unsigned)(x) & 0x1FFFFF) << 0)
#define   G_009130_GPR_WRITE_PRIORITY(x)                              (((x) >> 0) & 0x1FFFFF)
#define   C_009130_GPR_WRITE_PRIORITY                                 0xFFE00000
#define   S_009130_EXP_PRIORITY_ORDER(x)                              (((unsigned)(x) & 0x7) << 21)
#define   G_009130_EXP_PRIORITY_ORDER(x)                              (((x) >> 21) & 0x7)
#define   C_009130_EXP_PRIORITY_ORDER                                 0xFF1FFFFF
#define   S_009130_ENABLE_SQG_TOP_EVENTS(x)                           (((unsigned)(x) & 0x1) << 24)
#define   G_009130_ENABLE_SQG_TOP_EVENTS(x)                           (((x) >> 24) & 0x1)
#define   C_009130_ENABLE_SQG_TOP_EVENTS                              0xFEFFFFFF
#define   S_009130_ENABLE_SQG_BOP_EVENTS(x)                           (((unsigned)(x) & 0x1) << 25)
#define   G_009130_ENABLE_SQG_BOP_EVENTS(x)                           (((x) >> 25) & 0x1)
#define   C_009130_ENABLE_SQG_BOP_EVENTS                              0xFDFFFFFF
#define   S_009130_FORCE_HALF_RATE_PC_EXP(x)                          (((unsigned)(x) & 0x1) << 26)
#define   G_009130_FORCE_HALF_RATE_PC_EXP(x)                          (((x) >> 26) & 0x1)
#define   C_009130_FORCE_HALF_RATE_PC_EXP                             0xFBFFFFFF
#define   S_009130_TTRACE_STALL_ALL(x)                                (((unsigned)(x) & 0x1) << 27)
#define   G_009130_TTRACE_STALL_ALL(x)                                (((x) >> 27) & 0x1)
#define   C_009130_TTRACE_STALL_ALL                                   0xF7FFFFFF
#define   S_009130_ALLOC_ARB_LRU_ENA(x)                               (((unsigned)(x) & 0x1) << 28)
#define   G_009130_ALLOC_ARB_LRU_ENA(x)                               (((x) >> 28) & 0x1)
#define   C_009130_ALLOC_ARB_LRU_ENA                                  0xEFFFFFFF
#define   S_009130_EXP_ARB_LRU_ENA(x)                                 (((unsigned)(x) & 0x1) << 29)
#define   G_009130_EXP_ARB_LRU_ENA(x)                                 (((x) >> 29) & 0x1)
#define   C_009130_EXP_ARB_LRU_ENA                                    0xDFFFFFFF
#define   S_009130_PS_PKR_PRIORITY_CNTL(x)                            (((unsigned)(x) & 0x3) << 30)
#define   G_009130_PS_PKR_PRIORITY_CNTL(x)                            (((x) >> 30) & 0x3)
#define   C_009130_PS_PKR_PRIORITY_CNTL                               0x3FFFFFFF
#define R_00950C_TA_CS_BC_BASE_ADDR                                     0x00950C /* <= gfx6 */
#define R_0098F8_GB_ADDR_CONFIG                                         0x0098F8
#define   S_0098F8_NUM_PIPES(x)                                       (((unsigned)(x) & 0x7) << 0)
#define   G_0098F8_NUM_PIPES(x)                                       (((x) >> 0) & 0x7)
#define   C_0098F8_NUM_PIPES                                          0xFFFFFFF8
#define   S_0098F8_PIPE_INTERLEAVE_SIZE_GFX9(x)                       (((unsigned)(x) & 0x7) << 3) /* >= gfx9 */
#define   G_0098F8_PIPE_INTERLEAVE_SIZE_GFX9(x)                       (((x) >> 3) & 0x7)
#define   C_0098F8_PIPE_INTERLEAVE_SIZE_GFX9                          0xFFFFFFC7
#define   S_0098F8_PIPE_INTERLEAVE_SIZE_GFX6(x)                       (((unsigned)(x) & 0x7) << 4) /* <= gfx81 */
#define   G_0098F8_PIPE_INTERLEAVE_SIZE_GFX6(x)                       (((x) >> 4) & 0x7)
#define   C_0098F8_PIPE_INTERLEAVE_SIZE_GFX6                          0xFFFFFF8F
#define   S_0098F8_MAX_COMPRESSED_FRAGS(x)                            (((unsigned)(x) & 0x3) << 6) /* >= gfx9 */
#define   G_0098F8_MAX_COMPRESSED_FRAGS(x)                            (((x) >> 6) & 0x3)
#define   C_0098F8_MAX_COMPRESSED_FRAGS                               0xFFFFFF3F
#define   S_0098F8_BANK_INTERLEAVE_SIZE(x)                            (((unsigned)(x) & 0x7) << 8) /* <= gfx9 */
#define   G_0098F8_BANK_INTERLEAVE_SIZE(x)                            (((x) >> 8) & 0x7)
#define   C_0098F8_BANK_INTERLEAVE_SIZE                               0xFFFFF8FF
#define   S_0098F8_NUM_PKRS(x)                                        (((unsigned)(x) & 0x7) << 8) /* >= gfx103 */
#define   G_0098F8_NUM_PKRS(x)                                        (((x) >> 8) & 0x7)
#define   C_0098F8_NUM_PKRS                                           0xFFFFF8FF
#define   S_0098F8_NUM_BANKS(x)                                       (((unsigned)(x) & 0x7) << 12) /* gfx9 */
#define   G_0098F8_NUM_BANKS(x)                                       (((x) >> 12) & 0x7)
#define   C_0098F8_NUM_BANKS                                          0xFFFF8FFF
#define     V_0098F8_ADDR_SURF_2_BANK                               0
#define     V_0098F8_ADDR_SURF_4_BANK                               1
#define     V_0098F8_ADDR_SURF_8_BANK                               2
#define     V_0098F8_ADDR_SURF_16_BANK                              3
#define   S_0098F8_NUM_SHADER_ENGINES_GFX6(x)                         (((unsigned)(x) & 0x3) << 12) /* <= gfx81 */
#define   G_0098F8_NUM_SHADER_ENGINES_GFX6(x)                         (((x) >> 12) & 0x3)
#define   C_0098F8_NUM_SHADER_ENGINES_GFX6                            0xFFFFCFFF
#define   S_0098F8_SHADER_ENGINE_TILE_SIZE(x)                         (((unsigned)(x) & 0x7) << 16) /* <= gfx9 */
#define   G_0098F8_SHADER_ENGINE_TILE_SIZE(x)                         (((x) >> 16) & 0x7)
#define   C_0098F8_SHADER_ENGINE_TILE_SIZE                            0xFFF8FFFF
#define   S_0098F8_NUM_SHADER_ENGINES_GFX9(x)                         (((unsigned)(x) & 0x3) << 19) /* >= gfx9 */
#define   G_0098F8_NUM_SHADER_ENGINES_GFX9(x)                         (((x) >> 19) & 0x3)
#define   C_0098F8_NUM_SHADER_ENGINES_GFX9                            0xFFE7FFFF
#define   S_0098F8_NUM_GPUS_GFX6(x)                                   (((unsigned)(x) & 0x7) << 20) /* <= gfx81 */
#define   G_0098F8_NUM_GPUS_GFX6(x)                                   (((x) >> 20) & 0x7)
#define   C_0098F8_NUM_GPUS_GFX6                                      0xFF8FFFFF
#define   S_0098F8_NUM_GPUS_GFX9(x)                                   (((unsigned)(x) & 0x7) << 21) /* gfx9 */
#define   G_0098F8_NUM_GPUS_GFX9(x)                                   (((x) >> 21) & 0x7)
#define   C_0098F8_NUM_GPUS_GFX9                                      0xFF1FFFFF
#define   S_0098F8_MULTI_GPU_TILE_SIZE(x)                             (((unsigned)(x) & 0x3) << 24) /* <= gfx9 */
#define   G_0098F8_MULTI_GPU_TILE_SIZE(x)                             (((x) >> 24) & 0x3)
#define   C_0098F8_MULTI_GPU_TILE_SIZE                                0xFCFFFFFF
#define   S_0098F8_NUM_RB_PER_SE(x)                                   (((unsigned)(x) & 0x3) << 26) /* >= gfx9 */
#define   G_0098F8_NUM_RB_PER_SE(x)                                   (((x) >> 26) & 0x3)
#define   C_0098F8_NUM_RB_PER_SE                                      0xF3FFFFFF
#define   S_0098F8_ROW_SIZE(x)                                        (((unsigned)(x) & 0x3) << 28) /* <= gfx9 */
#define   G_0098F8_ROW_SIZE(x)                                        (((x) >> 28) & 0x3)
#define   C_0098F8_ROW_SIZE                                           0xCFFFFFFF
#define   S_0098F8_NUM_LOWER_PIPES(x)                                 (((unsigned)(x) & 0x1) << 30) /* <= gfx9 */
#define   G_0098F8_NUM_LOWER_PIPES(x)                                 (((x) >> 30) & 0x1)
#define   C_0098F8_NUM_LOWER_PIPES                                    0xBFFFFFFF
#define   S_0098F8_SE_ENABLE(x)                                       (((unsigned)(x) & 0x1) << 31) /* gfx9 */
#define   G_0098F8_SE_ENABLE(x)                                       (((x) >> 31) & 0x1)
#define   C_0098F8_SE_ENABLE                                          0x7FFFFFFF
#define R_009910_GB_TILE_MODE0                                          0x009910 /* <= gfx10 */
#define   S_009910_MICRO_TILE_MODE(x)                                 (((unsigned)(x) & 0x3) << 0) /* <= gfx6 */
#define   G_009910_MICRO_TILE_MODE(x)                                 (((x) >> 0) & 0x3)
#define   C_009910_MICRO_TILE_MODE                                    0xFFFFFFFC
#define     V_009910_ADDR_SURF_DISPLAY_MICRO_TILING                 0
#define     V_009910_ADDR_SURF_THIN_MICRO_TILING                    1
#define     V_009910_ADDR_SURF_DEPTH_MICRO_TILING                   2
#define     V_009910_ADDR_SURF_THICK_MICRO_TILING_GFX6              3
#define   S_009910_ARRAY_MODE(x)                                      (((unsigned)(x) & 0xF) << 2)
#define   G_009910_ARRAY_MODE(x)                                      (((x) >> 2) & 0xF)
#define   C_009910_ARRAY_MODE                                         0xFFFFFFC3
#define     V_009910_ARRAY_LINEAR_GENERAL                           0
#define     V_009910_ARRAY_LINEAR_ALIGNED                           1
#define     V_009910_ARRAY_1D_TILED_THIN1                           2
#define     V_009910_ARRAY_1D_TILED_THICK                           3
#define     V_009910_ARRAY_2D_TILED_THIN1                           4
#define     V_009910_ARRAY_PRT_TILED_THIN1                          5
#define     V_009910_ARRAY_PRT_2D_TILED_THIN1                       6
#define     V_009910_ARRAY_2D_TILED_THICK                           7
#define     V_009910_ARRAY_2D_TILED_XTHICK                          8
#define     V_009910_ARRAY_PRT_TILED_THICK                          9
#define     V_009910_ARRAY_PRT_2D_TILED_THICK                       10
#define     V_009910_ARRAY_PRT_3D_TILED_THIN1                       11
#define     V_009910_ARRAY_3D_TILED_THIN1                           12
#define     V_009910_ARRAY_3D_TILED_THICK                           13
#define     V_009910_ARRAY_3D_TILED_XTHICK                          14
#define     V_009910_ARRAY_PRT_3D_TILED_THICK                       15
#define   S_009910_PIPE_CONFIG(x)                                     (((unsigned)(x) & 0x1F) << 6)
#define   G_009910_PIPE_CONFIG(x)                                     (((x) >> 6) & 0x1F)
#define   C_009910_PIPE_CONFIG                                        0xFFFFF83F
#define     V_009910_ADDR_SURF_P2                                   0
#define     V_009910_ADDR_SURF_P2_RESERVED0                         1
#define     V_009910_ADDR_SURF_P2_RESERVED1                         2
#define     V_009910_ADDR_SURF_P2_RESERVED2                         3
#define     V_009910_ADDR_SURF_P4_8x16                              4
#define     V_009910_ADDR_SURF_P4_16x16                             5
#define     V_009910_ADDR_SURF_P4_16x32                             6
#define     V_009910_ADDR_SURF_P4_32x32                             7
#define     V_009910_ADDR_SURF_P8_16x16_8x16                        8
#define     V_009910_ADDR_SURF_P8_16x32_8x16                        9
#define     V_009910_ADDR_SURF_P8_32x32_8x16                        10
#define     V_009910_ADDR_SURF_P8_16x32_16x16                       11
#define     V_009910_ADDR_SURF_P8_32x32_16x16                       12
#define     V_009910_ADDR_SURF_P8_32x32_16x32                       13
#define     V_009910_ADDR_SURF_P8_32x64_32x32                       14
#define     V_009910_ADDR_SURF_P8_RESERVED0                         15
#define     V_009910_ADDR_SURF_P16_32x32_8x16                       16
#define     V_009910_ADDR_SURF_P16_32x32_16x16                      17
#define     V_009910_ADDR_SURF_P16                                  18 /* gfx10 */
#define   S_009910_TILE_SPLIT(x)                                      (((unsigned)(x) & 0x7) << 11)
#define   G_009910_TILE_SPLIT(x)                                      (((x) >> 11) & 0x7)
#define   C_009910_TILE_SPLIT                                         0xFFFFC7FF
#define     V_009910_ADDR_SURF_TILE_SPLIT_64B                       0
#define     V_009910_ADDR_SURF_TILE_SPLIT_128B                      1
#define     V_009910_ADDR_SURF_TILE_SPLIT_256B                      2
#define     V_009910_ADDR_SURF_TILE_SPLIT_512B                      3
#define     V_009910_ADDR_SURF_TILE_SPLIT_1KB                       4
#define     V_009910_ADDR_SURF_TILE_SPLIT_2KB                       5
#define     V_009910_ADDR_SURF_TILE_SPLIT_4KB                       6
#define   S_009910_MICRO_TILE_MODE_NEW(x)                             (((unsigned)(x) & 0x7) << 22)
#define   G_009910_MICRO_TILE_MODE_NEW(x)                             (((x) >> 22) & 0x7)
#define   C_009910_MICRO_TILE_MODE_NEW                                0xFE3FFFFF
#define     V_009910_ADDR_SURF_ROTATED_MICRO_TILING                 3
#define     V_009910_ADDR_SURF_THICK_MICRO_TILING                   4
#define   S_009910_SAMPLE_SPLIT(x)                                    (((unsigned)(x) & 0x3) << 25)
#define   G_009910_SAMPLE_SPLIT(x)                                    (((x) >> 25) & 0x3)
#define   C_009910_SAMPLE_SPLIT                                       0xF9FFFFFF
#define R_009914_GB_TILE_MODE1                                          0x009914 /* <= gfx10 */
#define R_009918_GB_TILE_MODE2                                          0x009918 /* <= gfx10 */
#define R_00991C_GB_TILE_MODE3                                          0x00991C /* <= gfx10 */
#define R_009920_GB_TILE_MODE4                                          0x009920 /* <= gfx10 */
#define R_009924_GB_TILE_MODE5                                          0x009924 /* <= gfx10 */
#define R_009928_GB_TILE_MODE6                                          0x009928 /* <= gfx10 */
#define R_00992C_GB_TILE_MODE7                                          0x00992C /* <= gfx10 */
#define R_009930_GB_TILE_MODE8                                          0x009930 /* <= gfx10 */
#define R_009934_GB_TILE_MODE9                                          0x009934 /* <= gfx10 */
#define R_009938_GB_TILE_MODE10                                         0x009938 /* <= gfx10 */
#define R_00993C_GB_TILE_MODE11                                         0x00993C /* <= gfx10 */
#define R_009940_GB_TILE_MODE12                                         0x009940 /* <= gfx10 */
#define R_009944_GB_TILE_MODE13                                         0x009944 /* <= gfx10 */
#define R_009948_GB_TILE_MODE14                                         0x009948 /* <= gfx10 */
#define R_00994C_GB_TILE_MODE15                                         0x00994C /* <= gfx10 */
#define R_009950_GB_TILE_MODE16                                         0x009950 /* <= gfx10 */
#define R_009954_GB_TILE_MODE17                                         0x009954 /* <= gfx10 */
#define R_009958_GB_TILE_MODE18                                         0x009958 /* <= gfx10 */
#define R_00995C_GB_TILE_MODE19                                         0x00995C /* <= gfx10 */
#define R_009960_GB_TILE_MODE20                                         0x009960 /* <= gfx10 */
#define R_009964_GB_TILE_MODE21                                         0x009964 /* <= gfx10 */
#define R_009968_GB_TILE_MODE22                                         0x009968 /* <= gfx10 */
#define R_00996C_GB_TILE_MODE23                                         0x00996C /* <= gfx10 */
#define R_009970_GB_TILE_MODE24                                         0x009970 /* <= gfx10 */
#define R_009974_GB_TILE_MODE25                                         0x009974 /* <= gfx10 */
#define R_009978_GB_TILE_MODE26                                         0x009978 /* <= gfx10 */
#define R_00997C_GB_TILE_MODE27                                         0x00997C /* <= gfx10 */
#define R_009980_GB_TILE_MODE28                                         0x009980 /* <= gfx10 */
#define R_009984_GB_TILE_MODE29                                         0x009984 /* <= gfx10 */
#define R_009988_GB_TILE_MODE30                                         0x009988 /* <= gfx10 */
#define R_00998C_GB_TILE_MODE31                                         0x00998C /* <= gfx10 */
#define R_009990_GB_MACROTILE_MODE0                                     0x009990 /* gfx7, gfx8, gfx81, gfx9, gfx10 */
#define   S_009990_BANK_WIDTH(x)                                      (((unsigned)(x) & 0x3) << 0)
#define   G_009990_BANK_WIDTH(x)                                      (((x) >> 0) & 0x3)
#define   C_009990_BANK_WIDTH                                         0xFFFFFFFC
#define     V_009990_ADDR_SURF_BANK_WIDTH_1                         0
#define     V_009990_ADDR_SURF_BANK_WIDTH_2                         1
#define     V_009990_ADDR_SURF_BANK_WIDTH_4                         2
#define     V_009990_ADDR_SURF_BANK_WIDTH_8                         3
#define   S_009990_BANK_HEIGHT(x)                                     (((unsigned)(x) & 0x3) << 2)
#define   G_009990_BANK_HEIGHT(x)                                     (((x) >> 2) & 0x3)
#define   C_009990_BANK_HEIGHT                                        0xFFFFFFF3
#define     V_009990_ADDR_SURF_BANK_HEIGHT_1                        0
#define     V_009990_ADDR_SURF_BANK_HEIGHT_2                        1
#define     V_009990_ADDR_SURF_BANK_HEIGHT_4                        2
#define     V_009990_ADDR_SURF_BANK_HEIGHT_8                        3
#define   S_009990_MACRO_TILE_ASPECT(x)                               (((unsigned)(x) & 0x3) << 4)
#define   G_009990_MACRO_TILE_ASPECT(x)                               (((x) >> 4) & 0x3)
#define   C_009990_MACRO_TILE_ASPECT                                  0xFFFFFFCF
#define     V_009990_ADDR_SURF_MACRO_ASPECT_1                       0
#define     V_009990_ADDR_SURF_MACRO_ASPECT_2                       1
#define     V_009990_ADDR_SURF_MACRO_ASPECT_4                       2
#define     V_009990_ADDR_SURF_MACRO_ASPECT_8                       3
#define   S_009990_NUM_BANKS(x)                                       (((unsigned)(x) & 0x3) << 6)
#define   G_009990_NUM_BANKS(x)                                       (((x) >> 6) & 0x3)
#define   C_009990_NUM_BANKS                                          0xFFFFFF3F
#define     V_009990_ADDR_SURF_2_BANK                               0
#define     V_009990_ADDR_SURF_4_BANK                               1
#define     V_009990_ADDR_SURF_8_BANK                               2
#define     V_009990_ADDR_SURF_16_BANK                              3
#define R_009994_GB_MACROTILE_MODE1                                     0x009994 /* gfx7, gfx8, gfx81, gfx9, gfx10 */
#define R_009998_GB_MACROTILE_MODE2                                     0x009998 /* gfx7, gfx8, gfx81, gfx9, gfx10 */
#define R_00999C_GB_MACROTILE_MODE3                                     0x00999C /* gfx7, gfx8, gfx81, gfx9, gfx10 */
#define R_0099A0_GB_MACROTILE_MODE4                                     0x0099A0 /* gfx7, gfx8, gfx81, gfx9, gfx10 */
#define R_0099A4_GB_MACROTILE_MODE5                                     0x0099A4 /* gfx7, gfx8, gfx81, gfx9, gfx10 */
#define R_0099A8_GB_MACROTILE_MODE6                                     0x0099A8 /* gfx7, gfx8, gfx81, gfx9, gfx10 */
#define R_0099AC_GB_MACROTILE_MODE7                                     0x0099AC /* gfx7, gfx8, gfx81, gfx9, gfx10 */
#define R_0099B0_GB_MACROTILE_MODE8                                     0x0099B0 /* gfx7, gfx8, gfx81, gfx9, gfx10 */
#define R_0099B4_GB_MACROTILE_MODE9                                     0x0099B4 /* gfx7, gfx8, gfx81, gfx9, gfx10 */
#define R_0099B8_GB_MACROTILE_MODE10                                    0x0099B8 /* gfx7, gfx8, gfx81, gfx9, gfx10 */
#define R_0099BC_GB_MACROTILE_MODE11                                    0x0099BC /* gfx7, gfx8, gfx81, gfx9, gfx10 */
#define R_0099C0_GB_MACROTILE_MODE12                                    0x0099C0 /* gfx7, gfx8, gfx81, gfx9, gfx10 */
#define R_0099C4_GB_MACROTILE_MODE13                                    0x0099C4 /* gfx7, gfx8, gfx81, gfx9, gfx10 */
#define R_0099C8_GB_MACROTILE_MODE14                                    0x0099C8 /* gfx7, gfx8, gfx81, gfx9, gfx10 */
#define R_0099CC_GB_MACROTILE_MODE15                                    0x0099CC /* gfx7, gfx8, gfx81, gfx9, gfx10 */
#define R_00A000_SQ_IMG_RSRC_WORD0                                      0x00A000 /* >= gfx10 */
#define R_00A004_SQ_IMG_RSRC_WORD1                                      0x00A004 /* >= gfx10 */
#define   S_00A004_BASE_ADDRESS_HI(x)                                 (((unsigned)(x) & 0xFF) << 0)
#define   G_00A004_BASE_ADDRESS_HI(x)                                 (((x) >> 0) & 0xFF)
#define   C_00A004_BASE_ADDRESS_HI                                    0xFFFFFF00
#define   S_00A004_MIN_LOD(x)                                         (((unsigned)(x) & 0xFFF) << 8)
#define   G_00A004_MIN_LOD(x)                                         (((x) >> 8) & 0xFFF)
#define   C_00A004_MIN_LOD                                            0xFFF000FF
#define   S_00A004_FORMAT(x)                                          (((unsigned)(x) & 0x1FF) << 20)
#define   G_00A004_FORMAT(x)                                          (((x) >> 20) & 0x1FF)
#define   C_00A004_FORMAT                                             0xE00FFFFF
#define     V_00A004_GFX10_FORMAT_INVALID                           0
#define     V_00A004_GFX10_FORMAT_8_UNORM                           1
#define     V_00A004_GFX10_FORMAT_8_SNORM                           2
#define     V_00A004_GFX10_FORMAT_8_USCALED                         3
#define     V_00A004_GFX10_FORMAT_8_SSCALED                         4
#define     V_00A004_GFX10_FORMAT_8_UINT                            5
#define     V_00A004_GFX10_FORMAT_8_SINT                            6
#define     V_00A004_GFX10_FORMAT_16_UNORM                          7
#define     V_00A004_GFX10_FORMAT_16_SNORM                          8
#define     V_00A004_GFX10_FORMAT_16_USCALED                        9
#define     V_00A004_GFX10_FORMAT_16_SSCALED                        10
#define     V_00A004_GFX10_FORMAT_16_UINT                           11
#define     V_00A004_GFX10_FORMAT_16_SINT                           12
#define     V_00A004_GFX10_FORMAT_16_FLOAT                          13
#define     V_00A004_GFX10_FORMAT_8_8_UNORM                         14
#define     V_00A004_GFX10_FORMAT_8_8_SNORM                         15
#define     V_00A004_GFX10_FORMAT_8_8_USCALED                       16
#define     V_00A004_GFX10_FORMAT_8_8_SSCALED                       17
#define     V_00A004_GFX10_FORMAT_8_8_UINT                          18
#define     V_00A004_GFX10_FORMAT_8_8_SINT                          19
#define     V_00A004_GFX10_FORMAT_32_UINT                           20
#define     V_00A004_GFX10_FORMAT_32_SINT                           21
#define     V_00A004_GFX10_FORMAT_32_FLOAT                          22
#define     V_00A004_GFX10_FORMAT_16_16_UNORM                       23
#define     V_00A004_GFX10_FORMAT_16_16_SNORM                       24
#define     V_00A004_GFX10_FORMAT_16_16_USCALED                     25
#define     V_00A004_GFX10_FORMAT_16_16_SSCALED                     26
#define     V_00A004_GFX10_FORMAT_16_16_UINT                        27
#define     V_00A004_GFX10_FORMAT_16_16_SINT                        28
#define     V_00A004_GFX10_FORMAT_16_16_FLOAT                       29
#define     V_00A004_GFX10_FORMAT_10_11_11_UNORM                    30
#define     V_00A004_GFX10_FORMAT_10_11_11_SNORM                    31
#define     V_00A004_GFX10_FORMAT_10_11_11_USCALED                  32
#define     V_00A004_GFX10_FORMAT_10_11_11_SSCALED                  33
#define     V_00A004_GFX10_FORMAT_10_11_11_UINT                     34
#define     V_00A004_GFX10_FORMAT_10_11_11_SINT                     35
#define     V_00A004_GFX10_FORMAT_10_11_11_FLOAT                    36
#define     V_00A004_GFX10_FORMAT_11_11_10_UNORM                    37
#define     V_00A004_GFX10_FORMAT_11_11_10_SNORM                    38
#define     V_00A004_GFX10_FORMAT_11_11_10_USCALED                  39
#define     V_00A004_GFX10_FORMAT_11_11_10_SSCALED                  40
#define     V_00A004_GFX10_FORMAT_11_11_10_UINT                     41
#define     V_00A004_GFX10_FORMAT_11_11_10_SINT                     42
#define     V_00A004_GFX10_FORMAT_11_11_10_FLOAT                    43
#define     V_00A004_GFX10_FORMAT_10_10_10_2_UNORM                  44
#define     V_00A004_GFX10_FORMAT_10_10_10_2_SNORM                  45
#define     V_00A004_GFX10_FORMAT_10_10_10_2_USCALED                46
#define     V_00A004_GFX10_FORMAT_10_10_10_2_SSCALED                47
#define     V_00A004_GFX10_FORMAT_10_10_10_2_UINT                   48
#define     V_00A004_GFX10_FORMAT_10_10_10_2_SINT                   49
#define     V_00A004_GFX10_FORMAT_2_10_10_10_UNORM                  50
#define     V_00A004_GFX10_FORMAT_2_10_10_10_SNORM                  51
#define     V_00A004_GFX10_FORMAT_2_10_10_10_USCALED                52
#define     V_00A004_GFX10_FORMAT_2_10_10_10_SSCALED                53
#define     V_00A004_GFX10_FORMAT_2_10_10_10_UINT                   54
#define     V_00A004_GFX10_FORMAT_2_10_10_10_SINT                   55
#define     V_00A004_GFX10_FORMAT_8_8_8_8_UNORM                     56
#define     V_00A004_GFX10_FORMAT_8_8_8_8_SNORM                     57
#define     V_00A004_GFX10_FORMAT_8_8_8_8_USCALED                   58
#define     V_00A004_GFX10_FORMAT_8_8_8_8_SSCALED                   59
#define     V_00A004_GFX10_FORMAT_8_8_8_8_UINT                      60
#define     V_00A004_GFX10_FORMAT_8_8_8_8_SINT                      61
#define     V_00A004_GFX10_FORMAT_32_32_UINT                        62
#define     V_00A004_GFX10_FORMAT_32_32_SINT                        63
#define     V_00A004_GFX10_FORMAT_32_32_FLOAT                       64
#define     V_00A004_GFX10_FORMAT_16_16_16_16_UNORM                 65
#define     V_00A004_GFX10_FORMAT_16_16_16_16_SNORM                 66
#define     V_00A004_GFX10_FORMAT_16_16_16_16_USCALED               67
#define     V_00A004_GFX10_FORMAT_16_16_16_16_SSCALED               68
#define     V_00A004_GFX10_FORMAT_16_16_16_16_UINT                  69
#define     V_00A004_GFX10_FORMAT_16_16_16_16_SINT                  70
#define     V_00A004_GFX10_FORMAT_16_16_16_16_FLOAT                 71
#define     V_00A004_GFX10_FORMAT_32_32_32_UINT                     72
#define     V_00A004_GFX10_FORMAT_32_32_32_SINT                     73
#define     V_00A004_GFX10_FORMAT_32_32_32_FLOAT                    74
#define     V_00A004_GFX10_FORMAT_32_32_32_32_UINT                  75
#define     V_00A004_GFX10_FORMAT_32_32_32_32_SINT                  76
#define     V_00A004_GFX10_FORMAT_32_32_32_32_FLOAT                 77
#define     V_00A004_GFX10_FORMAT_8_SRGB                            128
#define     V_00A004_GFX10_FORMAT_8_8_SRGB                          129
#define     V_00A004_GFX10_FORMAT_8_8_8_8_SRGB                      130
#define     V_00A004_GFX10_FORMAT_6E4_FLOAT                         131
#define     V_00A004_GFX10_FORMAT_5_9_9_9_FLOAT                     132
#define     V_00A004_GFX10_FORMAT_5_6_5_UNORM                       133
#define     V_00A004_GFX10_FORMAT_1_5_5_5_UNORM                     134
#define     V_00A004_GFX10_FORMAT_5_5_5_1_UNORM                     135
#define     V_00A004_GFX10_FORMAT_4_4_4_4_UNORM                     136
#define     V_00A004_GFX10_FORMAT_4_4_UNORM                         137
#define     V_00A004_GFX10_FORMAT_1_UNORM                           138
#define     V_00A004_GFX10_FORMAT_1_REVERSED_UNORM                  139
#define     V_00A004_GFX10_FORMAT_32_FLOAT_CLAMP                    140
#define     V_00A004_GFX10_FORMAT_8_24_UNORM                        141
#define     V_00A004_GFX10_FORMAT_8_24_UINT                         142
#define     V_00A004_GFX10_FORMAT_24_8_UNORM                        143
#define     V_00A004_GFX10_FORMAT_24_8_UINT                         144
#define     V_00A004_GFX10_FORMAT_X24_8_32_UINT                     145
#define     V_00A004_GFX10_FORMAT_X24_8_32_FLOAT                    146
#define     V_00A004_GFX10_FORMAT_GB_GR_UNORM                       147
#define     V_00A004_GFX10_FORMAT_GB_GR_SNORM                       148
#define     V_00A004_GFX10_FORMAT_GB_GR_UINT                        149
#define     V_00A004_GFX10_FORMAT_GB_GR_SRGB                        150
#define     V_00A004_GFX10_FORMAT_BG_RG_UNORM                       151
#define     V_00A004_GFX10_FORMAT_BG_RG_SNORM                       152
#define     V_00A004_GFX10_FORMAT_BG_RG_UINT                        153
#define     V_00A004_GFX10_FORMAT_BG_RG_SRGB                        154
#define     V_00A004_GFX10_FORMAT_FMASK8_S2_F1                      156
#define     V_00A004_GFX10_FORMAT_FMASK8_S4_F1                      157
#define     V_00A004_GFX10_FORMAT_FMASK8_S8_F1                      158
#define     V_00A004_GFX10_FORMAT_FMASK8_S2_F2                      159
#define     V_00A004_GFX10_FORMAT_FMASK8_S4_F2                      160
#define     V_00A004_GFX10_FORMAT_FMASK8_S4_F4                      161
#define     V_00A004_GFX10_FORMAT_FMASK16_S16_F1                    162
#define     V_00A004_GFX10_FORMAT_FMASK16_S8_F2                     163
#define     V_00A004_GFX10_FORMAT_FMASK32_S16_F2                    164
#define     V_00A004_GFX10_FORMAT_FMASK32_S8_F4                     165
#define     V_00A004_GFX10_FORMAT_FMASK32_S8_F8                     166
#define     V_00A004_GFX10_FORMAT_FMASK64_S16_F4                    167
#define     V_00A004_GFX10_FORMAT_FMASK64_S16_F8                    168
#define     V_00A004_GFX10_FORMAT_BC1_UNORM                         169
#define     V_00A004_GFX10_FORMAT_BC1_SRGB                          170
#define     V_00A004_GFX10_FORMAT_BC2_UNORM                         171
#define     V_00A004_GFX10_FORMAT_BC2_SRGB                          172
#define     V_00A004_GFX10_FORMAT_BC3_UNORM                         173
#define     V_00A004_GFX10_FORMAT_BC3_SRGB                          174
#define     V_00A004_GFX10_FORMAT_BC4_UNORM                         175
#define     V_00A004_GFX10_FORMAT_BC4_SNORM                         176
#define     V_00A004_GFX10_FORMAT_BC5_UNORM                         177
#define     V_00A004_GFX10_FORMAT_BC5_SNORM                         178
#define     V_00A004_GFX10_FORMAT_BC6_UFLOAT                        179
#define     V_00A004_GFX10_FORMAT_BC6_SFLOAT                        180
#define     V_00A004_GFX10_FORMAT_BC7_UNORM                         181
#define     V_00A004_GFX10_FORMAT_BC7_SRGB                          182
#define     V_00A004_GFX10_FORMAT_MM_8_UNORM                        265
#define     V_00A004_GFX10_FORMAT_MM_8_UINT                         266
#define     V_00A004_GFX10_FORMAT_MM_8_8_UNORM                      267
#define     V_00A004_GFX10_FORMAT_MM_8_8_UINT                       268
#define     V_00A004_GFX10_FORMAT_MM_8_8_8_8_UNORM                  269
#define     V_00A004_GFX10_FORMAT_MM_8_8_8_8_UINT                   270
#define     V_00A004_GFX10_FORMAT_MM_VYUY8_UNORM                    271
#define     V_00A004_GFX10_FORMAT_MM_VYUY8_UINT                     272
#define     V_00A004_GFX10_FORMAT_MM_10_11_11_UNORM                 273
#define     V_00A004_GFX10_FORMAT_MM_10_11_11_UINT                  274
#define     V_00A004_GFX10_FORMAT_MM_2_10_10_10_UNORM               275
#define     V_00A004_GFX10_FORMAT_MM_2_10_10_10_UINT                276
#define     V_00A004_GFX10_FORMAT_MM_16_16_16_16_UNORM              277
#define     V_00A004_GFX10_FORMAT_MM_16_16_16_16_UINT               278
#define     V_00A004_GFX10_FORMAT_MM_10_IN_16_UNORM                 279
#define     V_00A004_GFX10_FORMAT_MM_10_IN_16_UINT                  280
#define     V_00A004_GFX10_FORMAT_MM_10_IN_16_16_UNORM              281
#define     V_00A004_GFX10_FORMAT_MM_10_IN_16_16_UINT               282
#define     V_00A004_GFX10_FORMAT_MM_10_IN_16_16_16_16_UNORM        283
#define     V_00A004_GFX10_FORMAT_MM_10_IN_16_16_16_16_UINT         284
#define     V_00A004_GFX10_FORMAT_7E3_FLOAT                         285
#define     V_00A004_GFX10_FORMAT_YCBCR_UNORM                       286
#define     V_00A004_GFX10_FORMAT_YCBCR_SNORM                       287
#define     V_00A004_GFX10_FORMAT_YCBCR_USCALED                     288
#define     V_00A004_GFX10_FORMAT_YCBCR_SSCALED                     289
#define     V_00A004_GFX10_FORMAT_YCBCR_UINT                        290
#define     V_00A004_GFX10_FORMAT_YCBCR_SINT                        291
#define     V_00A004_GFX10_FORMAT_YCBCR_SRGB                        292
#define   S_00A004_WIDTH_LO(x)                                        (((unsigned)(x) & 0x3) << 30)
#define   G_00A004_WIDTH_LO(x)                                        (((x) >> 30) & 0x3)
#define   C_00A004_WIDTH_LO                                           0x3FFFFFFF
#define R_00A008_SQ_IMG_RSRC_WORD2                                      0x00A008 /* >= gfx10 */
#define   S_00A008_WIDTH_HI(x)                                        (((unsigned)(x) & 0xFFF) << 0)
#define   G_00A008_WIDTH_HI(x)                                        (((x) >> 0) & 0xFFF)
#define   C_00A008_WIDTH_HI                                           0xFFFFF000
#define   S_00A008_HEIGHT(x)                                          (((unsigned)(x) & 0x3FFF) << 14)
#define   G_00A008_HEIGHT(x)                                          (((x) >> 14) & 0x3FFF)
#define   C_00A008_HEIGHT                                             0xF0003FFF
#define   S_00A008_RESOURCE_LEVEL(x)                                  (((unsigned)(x) & 0x1) << 31)
#define   G_00A008_RESOURCE_LEVEL(x)                                  (((x) >> 31) & 0x1)
#define   C_00A008_RESOURCE_LEVEL                                     0x7FFFFFFF
#define R_00A00C_SQ_IMG_RSRC_WORD3                                      0x00A00C /* >= gfx10 */
#define   S_00A00C_DST_SEL_X(x)                                       (((unsigned)(x) & 0x7) << 0)
#define   G_00A00C_DST_SEL_X(x)                                       (((x) >> 0) & 0x7)
#define   C_00A00C_DST_SEL_X                                          0xFFFFFFF8
#define   S_00A00C_DST_SEL_Y(x)                                       (((unsigned)(x) & 0x7) << 3)
#define   G_00A00C_DST_SEL_Y(x)                                       (((x) >> 3) & 0x7)
#define   C_00A00C_DST_SEL_Y                                          0xFFFFFFC7
#define   S_00A00C_DST_SEL_Z(x)                                       (((unsigned)(x) & 0x7) << 6)
#define   G_00A00C_DST_SEL_Z(x)                                       (((x) >> 6) & 0x7)
#define   C_00A00C_DST_SEL_Z                                          0xFFFFFE3F
#define   S_00A00C_DST_SEL_W(x)                                       (((unsigned)(x) & 0x7) << 9)
#define   G_00A00C_DST_SEL_W(x)                                       (((x) >> 9) & 0x7)
#define   C_00A00C_DST_SEL_W                                          0xFFFFF1FF
#define   S_00A00C_BASE_LEVEL(x)                                      (((unsigned)(x) & 0xF) << 12)
#define   G_00A00C_BASE_LEVEL(x)                                      (((x) >> 12) & 0xF)
#define   C_00A00C_BASE_LEVEL                                         0xFFFF0FFF
#define   S_00A00C_LAST_LEVEL(x)                                      (((unsigned)(x) & 0xF) << 16)
#define   G_00A00C_LAST_LEVEL(x)                                      (((x) >> 16) & 0xF)
#define   C_00A00C_LAST_LEVEL                                         0xFFF0FFFF
#define   S_00A00C_SW_MODE(x)                                         (((unsigned)(x) & 0x1F) << 20)
#define   G_00A00C_SW_MODE(x)                                         (((x) >> 20) & 0x1F)
#define   C_00A00C_SW_MODE                                            0xFE0FFFFF
#define   S_00A00C_BC_SWIZZLE(x)                                      (((unsigned)(x) & 0x7) << 25)
#define   G_00A00C_BC_SWIZZLE(x)                                      (((x) >> 25) & 0x7)
#define   C_00A00C_BC_SWIZZLE                                         0xF1FFFFFF
#define     V_00A00C_BC_SWIZZLE_XYZW                                0
#define     V_00A00C_BC_SWIZZLE_XWYZ                                1
#define     V_00A00C_BC_SWIZZLE_WZYX                                2
#define     V_00A00C_BC_SWIZZLE_WXYZ                                3
#define     V_00A00C_BC_SWIZZLE_ZYXW                                4
#define     V_00A00C_BC_SWIZZLE_YXWZ                                5
#define   S_00A00C_TYPE(x)                                            (((unsigned)(x) & 0xF) << 28)
#define   G_00A00C_TYPE(x)                                            (((x) >> 28) & 0xF)
#define   C_00A00C_TYPE                                               0x0FFFFFFF
#define R_00A010_SQ_IMG_RSRC_WORD4                                      0x00A010 /* >= gfx10 */
#define   S_00A010_DEPTH(x)                                           (((unsigned)(x) & 0x1FFF) << 0)
#define   G_00A010_DEPTH(x)                                           (((x) >> 0) & 0x1FFF)
#define   C_00A010_DEPTH                                              0xFFFFE000
#define   S_00A010_PITCH(x)                                           (((unsigned)(x) & 0x3FFF) << 0) /* >= gfx103 */
#define   G_00A010_PITCH(x)                                           (((x) >> 0) & 0x3FFF)
#define   C_00A010_PITCH                                              0xFFFFC000
#define   S_00A010_BASE_ARRAY(x)                                      (((unsigned)(x) & 0x1FFF) << 16)
#define   G_00A010_BASE_ARRAY(x)                                      (((x) >> 16) & 0x1FFF)
#define   C_00A010_BASE_ARRAY                                         0xE000FFFF
#define R_00A014_SQ_IMG_RSRC_WORD5                                      0x00A014 /* >= gfx10 */
#define   S_00A014_ARRAY_PITCH(x)                                     (((unsigned)(x) & 0xF) << 0)
#define   G_00A014_ARRAY_PITCH(x)                                     (((x) >> 0) & 0xF)
#define   C_00A014_ARRAY_PITCH                                        0xFFFFFFF0
#define   S_00A014_MAX_MIP(x)                                         (((unsigned)(x) & 0xF) << 4)
#define   G_00A014_MAX_MIP(x)                                         (((x) >> 4) & 0xF)
#define   C_00A014_MAX_MIP                                            0xFFFFFF0F
#define   S_00A014_MIN_LOD_WARN(x)                                    (((unsigned)(x) & 0xFFF) << 8)
#define   G_00A014_MIN_LOD_WARN(x)                                    (((x) >> 8) & 0xFFF)
#define   C_00A014_MIN_LOD_WARN                                       0xFFF000FF
#define   S_00A014_PERF_MOD(x)                                        (((unsigned)(x) & 0x7) << 20)
#define   G_00A014_PERF_MOD(x)                                        (((x) >> 20) & 0x7)
#define   C_00A014_PERF_MOD                                           0xFF8FFFFF
#define   S_00A014_CORNER_SAMPLES(x)                                  (((unsigned)(x) & 0x1) << 23)
#define   G_00A014_CORNER_SAMPLES(x)                                  (((x) >> 23) & 0x1)
#define   C_00A014_CORNER_SAMPLES                                     0xFF7FFFFF
#define   S_00A014_LOD_HDW_CNT_EN(x)                                  (((unsigned)(x) & 0x1) << 25)
#define   G_00A014_LOD_HDW_CNT_EN(x)                                  (((x) >> 25) & 0x1)
#define   C_00A014_LOD_HDW_CNT_EN                                     0xFDFFFFFF
#define   S_00A014_PRT_DEFAULT(x)                                     (((unsigned)(x) & 0x1) << 26)
#define   G_00A014_PRT_DEFAULT(x)                                     (((x) >> 26) & 0x1)
#define   C_00A014_PRT_DEFAULT                                        0xFBFFFFFF
#define   S_00A014_BIG_PAGE(x)                                        (((unsigned)(x) & 0x1) << 31) /* >= gfx103 */
#define   G_00A014_BIG_PAGE(x)                                        (((x) >> 31) & 0x1)
#define   C_00A014_BIG_PAGE                                           0x7FFFFFFF
#define R_00A018_SQ_IMG_RSRC_WORD6                                      0x00A018 /* >= gfx10 */
#define   S_00A018_COUNTER_BANK_ID(x)                                 (((unsigned)(x) & 0xFF) << 0)
#define   G_00A018_COUNTER_BANK_ID(x)                                 (((x) >> 0) & 0xFF)
#define   C_00A018_COUNTER_BANK_ID                                    0xFFFFFF00
#define   S_00A018_LLC_NOALLOC(x)                                     (((unsigned)(x) & 0x3) << 8) /* >= gfx103 */
#define   G_00A018_LLC_NOALLOC(x)                                     (((x) >> 8) & 0x3)
#define   C_00A018_LLC_NOALLOC                                        0xFFFFFCFF
#define   S_00A018_ITERATE_256(x)                                     (((unsigned)(x) & 0x1) << 10)
#define   G_00A018_ITERATE_256(x)                                     (((x) >> 10) & 0x1)
#define   C_00A018_ITERATE_256                                        0xFFFFFBFF
#define   S_00A018_MAX_UNCOMPRESSED_BLOCK_SIZE(x)                     (((unsigned)(x) & 0x3) << 15)
#define   G_00A018_MAX_UNCOMPRESSED_BLOCK_SIZE(x)                     (((x) >> 15) & 0x3)
#define   C_00A018_MAX_UNCOMPRESSED_BLOCK_SIZE                        0xFFFE7FFF
#define   S_00A018_MAX_COMPRESSED_BLOCK_SIZE(x)                       (((unsigned)(x) & 0x3) << 17)
#define   G_00A018_MAX_COMPRESSED_BLOCK_SIZE(x)                       (((x) >> 17) & 0x3)
#define   C_00A018_MAX_COMPRESSED_BLOCK_SIZE                          0xFFF9FFFF
#define   S_00A018_META_PIPE_ALIGNED(x)                               (((unsigned)(x) & 0x1) << 19)
#define   G_00A018_META_PIPE_ALIGNED(x)                               (((x) >> 19) & 0x1)
#define   C_00A018_META_PIPE_ALIGNED                                  0xFFF7FFFF
#define   S_00A018_WRITE_COMPRESS_ENABLE(x)                           (((unsigned)(x) & 0x1) << 20)
#define   G_00A018_WRITE_COMPRESS_ENABLE(x)                           (((x) >> 20) & 0x1)
#define   C_00A018_WRITE_COMPRESS_ENABLE                              0xFFEFFFFF
#define   S_00A018_COMPRESSION_EN(x)                                  (((unsigned)(x) & 0x1) << 21)
#define   G_00A018_COMPRESSION_EN(x)                                  (((x) >> 21) & 0x1)
#define   C_00A018_COMPRESSION_EN                                     0xFFDFFFFF
#define   S_00A018_ALPHA_IS_ON_MSB(x)                                 (((unsigned)(x) & 0x1) << 22)
#define   G_00A018_ALPHA_IS_ON_MSB(x)                                 (((x) >> 22) & 0x1)
#define   C_00A018_ALPHA_IS_ON_MSB                                    0xFFBFFFFF
#define   S_00A018_COLOR_TRANSFORM(x)                                 (((unsigned)(x) & 0x1) << 23)
#define   G_00A018_COLOR_TRANSFORM(x)                                 (((x) >> 23) & 0x1)
#define   C_00A018_COLOR_TRANSFORM                                    0xFF7FFFFF
#define   S_00A018_META_DATA_ADDRESS_LO(x)                            (((unsigned)(x) & 0xFF) << 24)
#define   G_00A018_META_DATA_ADDRESS_LO(x)                            (((x) >> 24) & 0xFF)
#define   C_00A018_META_DATA_ADDRESS_LO                               0x00FFFFFF
#define R_00A01C_SQ_IMG_RSRC_WORD7                                      0x00A01C /* >= gfx10 */
#define R_00B000_SPI_SHADER_TBA_LO_PS                                   0x00B000 /* <= gfx81 */
#define R_00B004_SPI_SHADER_PGM_RSRC4_PS                                0x00B004 /* >= gfx10 */
#define   S_00B004_CU_EN(x)                                           (((unsigned)(x) & 0xFFFF) << 0)
#define   G_00B004_CU_EN(x)                                           (((x) >> 0) & 0xFFFF)
#define   C_00B004_CU_EN                                              0xFFFF0000
#define R_00B004_SPI_SHADER_TBA_HI_PS                                   0x00B004 /* <= gfx81 */
#define   S_00B004_MEM_BASE(x)                                        (((unsigned)(x) & 0xFF) << 0)
#define   G_00B004_MEM_BASE(x)                                        (((x) >> 0) & 0xFF)
#define   C_00B004_MEM_BASE                                           0xFFFFFF00
#define R_00B008_SPI_SHADER_TMA_LO_PS                                   0x00B008 /* <= gfx81 */
#define R_00B00C_SPI_SHADER_TMA_HI_PS                                   0x00B00C /* <= gfx81 */
#define   S_00B00C_MEM_BASE(x)                                        (((unsigned)(x) & 0xFF) << 0)
#define   G_00B00C_MEM_BASE(x)                                        (((x) >> 0) & 0xFF)
#define   C_00B00C_MEM_BASE                                           0xFFFFFF00
#define R_00B018_SPI_SHADER_PGM_CHKSUM_PS                               0x00B018 /* >= gfx10 */
#define R_00B01C_SPI_SHADER_PGM_RSRC3_PS                                0x00B01C /* >= gfx7 */
#define   S_00B01C_CU_EN(x)                                           (((unsigned)(x) & 0xFFFF) << 0)
#define   G_00B01C_CU_EN(x)                                           (((x) >> 0) & 0xFFFF)
#define   C_00B01C_CU_EN                                              0xFFFF0000
#define   S_00B01C_WAVE_LIMIT(x)                                      (((unsigned)(x) & 0x3F) << 16)
#define   G_00B01C_WAVE_LIMIT(x)                                      (((x) >> 16) & 0x3F)
#define   C_00B01C_WAVE_LIMIT                                         0xFFC0FFFF
#define   S_00B01C_LOCK_LOW_THRESHOLD(x)                              (((unsigned)(x) & 0xF) << 22)
#define   G_00B01C_LOCK_LOW_THRESHOLD(x)                              (((x) >> 22) & 0xF)
#define   C_00B01C_LOCK_LOW_THRESHOLD                                 0xFC3FFFFF
#define   S_00B01C_SIMD_DISABLE(x)                                    (((unsigned)(x) & 0xF) << 26) /* gfx9 */
#define   G_00B01C_SIMD_DISABLE(x)                                    (((x) >> 26) & 0xF)
#define   C_00B01C_SIMD_DISABLE                                       0xC3FFFFFF
#define R_00B020_SPI_SHADER_PGM_LO_PS                                   0x00B020
#define R_00B024_SPI_SHADER_PGM_HI_PS                                   0x00B024
#define   S_00B024_MEM_BASE(x)                                        (((unsigned)(x) & 0xFF) << 0)
#define   G_00B024_MEM_BASE(x)                                        (((x) >> 0) & 0xFF)
#define   C_00B024_MEM_BASE                                           0xFFFFFF00
#define R_00B028_SPI_SHADER_PGM_RSRC1_PS                                0x00B028
#define   S_00B028_VGPRS(x)                                           (((unsigned)(x) & 0x3F) << 0)
#define   G_00B028_VGPRS(x)                                           (((x) >> 0) & 0x3F)
#define   C_00B028_VGPRS                                              0xFFFFFFC0
#define   S_00B028_SGPRS(x)                                           (((unsigned)(x) & 0xF) << 6)
#define   G_00B028_SGPRS(x)                                           (((x) >> 6) & 0xF)
#define   C_00B028_SGPRS                                              0xFFFFFC3F
#define   S_00B028_PRIORITY(x)                                        (((unsigned)(x) & 0x3) << 10)
#define   G_00B028_PRIORITY(x)                                        (((x) >> 10) & 0x3)
#define   C_00B028_PRIORITY                                           0xFFFFF3FF
#define   S_00B028_FLOAT_MODE(x)                                      (((unsigned)(x) & 0xFF) << 12)
#define   G_00B028_FLOAT_MODE(x)                                      (((x) >> 12) & 0xFF)
#define   C_00B028_FLOAT_MODE                                         0xFFF00FFF
#define     V_00B028_FP_32_DENORMS                                  48
#define     V_00B028_FP_64_DENORMS                                  192
#define     V_00B028_FP_ALL_DENORMS                                 240
#define   S_00B028_PRIV(x)                                            (((unsigned)(x) & 0x1) << 20)
#define   G_00B028_PRIV(x)                                            (((x) >> 20) & 0x1)
#define   C_00B028_PRIV                                               0xFFEFFFFF
#define   S_00B028_DX10_CLAMP(x)                                      (((unsigned)(x) & 0x1) << 21)
#define   G_00B028_DX10_CLAMP(x)                                      (((x) >> 21) & 0x1)
#define   C_00B028_DX10_CLAMP                                         0xFFDFFFFF
#define   S_00B028_DEBUG_MODE(x)                                      (((unsigned)(x) & 0x1) << 22) /* <= gfx9 */
#define   G_00B028_DEBUG_MODE(x)                                      (((x) >> 22) & 0x1)
#define   C_00B028_DEBUG_MODE                                         0xFFBFFFFF
#define   S_00B028_IEEE_MODE(x)                                       (((unsigned)(x) & 0x1) << 23)
#define   G_00B028_IEEE_MODE(x)                                       (((x) >> 23) & 0x1)
#define   C_00B028_IEEE_MODE                                          0xFF7FFFFF
#define   S_00B028_CU_GROUP_DISABLE(x)                                (((unsigned)(x) & 0x1) << 24)
#define   G_00B028_CU_GROUP_DISABLE(x)                                (((x) >> 24) & 0x1)
#define   C_00B028_CU_GROUP_DISABLE                                   0xFEFFFFFF
#define   S_00B028_CACHE_CTL(x)                                       (((unsigned)(x) & 0x7) << 25) /* <= gfx81 */
#define   G_00B028_CACHE_CTL(x)                                       (((x) >> 25) & 0x7)
#define   C_00B028_CACHE_CTL                                          0xF1FFFFFF
#define   S_00B028_MEM_ORDERED(x)                                     (((unsigned)(x) & 0x1) << 25) /* >= gfx10 */
#define   G_00B028_MEM_ORDERED(x)                                     (((x) >> 25) & 0x1)
#define   C_00B028_MEM_ORDERED                                        0xFDFFFFFF
#define   S_00B028_FWD_PROGRESS(x)                                    (((unsigned)(x) & 0x1) << 26) /* >= gfx10 */
#define   G_00B028_FWD_PROGRESS(x)                                    (((x) >> 26) & 0x1)
#define   C_00B028_FWD_PROGRESS                                       0xFBFFFFFF
#define   S_00B028_LOAD_PROVOKING_VTX(x)                              (((unsigned)(x) & 0x1) << 27) /* >= gfx103 */
#define   G_00B028_LOAD_PROVOKING_VTX(x)                              (((x) >> 27) & 0x1)
#define   C_00B028_LOAD_PROVOKING_VTX                                 0xF7FFFFFF
#define   S_00B028_CDBG_USER(x)                                       (((unsigned)(x) & 0x1) << 28) /* <= gfx9 */
#define   G_00B028_CDBG_USER(x)                                       (((x) >> 28) & 0x1)
#define   C_00B028_CDBG_USER                                          0xEFFFFFFF
#define   S_00B028_FP16_OVFL(x)                                       (((unsigned)(x) & 0x1) << 29) /* >= gfx9 */
#define   G_00B028_FP16_OVFL(x)                                       (((x) >> 29) & 0x1)
#define   C_00B028_FP16_OVFL                                          0xDFFFFFFF
#define R_00B02C_SPI_SHADER_PGM_RSRC2_PS                                0x00B02C
#define   S_00B02C_SCRATCH_EN(x)                                      (((unsigned)(x) & 0x1) << 0)
#define   G_00B02C_SCRATCH_EN(x)                                      (((x) >> 0) & 0x1)
#define   C_00B02C_SCRATCH_EN                                         0xFFFFFFFE
#define   S_00B02C_USER_SGPR(x)                                       (((unsigned)(x) & 0x1F) << 1)
#define   G_00B02C_USER_SGPR(x)                                       (((x) >> 1) & 0x1F)
#define   C_00B02C_USER_SGPR                                          0xFFFFFFC1
#define   S_00B02C_TRAP_PRESENT(x)                                    (((unsigned)(x) & 0x1) << 6)
#define   G_00B02C_TRAP_PRESENT(x)                                    (((x) >> 6) & 0x1)
#define   C_00B02C_TRAP_PRESENT                                       0xFFFFFFBF
#define   S_00B02C_WAVE_CNT_EN(x)                                     (((unsigned)(x) & 0x1) << 7)
#define   G_00B02C_WAVE_CNT_EN(x)                                     (((x) >> 7) & 0x1)
#define   C_00B02C_WAVE_CNT_EN                                        0xFFFFFF7F
#define   S_00B02C_EXTRA_LDS_SIZE(x)                                  (((unsigned)(x) & 0xFF) << 8)
#define   G_00B02C_EXTRA_LDS_SIZE(x)                                  (((x) >> 8) & 0xFF)
#define   C_00B02C_EXTRA_LDS_SIZE                                     0xFFFF00FF
#define   S_00B02C_EXCP_EN(x)                                         (((unsigned)(x) & 0x1FF) << 16)
#define   G_00B02C_EXCP_EN(x)                                         (((x) >> 16) & 0x1FF)
#define   C_00B02C_EXCP_EN                                            0xFE00FFFF
#define     V_00B02C_INVALID                                        1
#define     V_00B02C_INPUT_DENORMAL                                 2
#define     V_00B02C_DIVIDE_BY_ZERO                                 4
#define     V_00B02C_OVERFLOW                                       8
#define     V_00B02C_UNDERFLOW                                      16
#define     V_00B02C_INEXACT                                        32
#define     V_00B02C_INT_DIVIDE_BY_ZERO                             64
#define     V_00B02C_ADDRESS_WATCH                                  128
#define     V_00B02C_MEMORY_VIOLATION                               256
#define   S_00B02C_LOAD_COLLISION_WAVEID(x)                           (((unsigned)(x) & 0x1) << 25) /* >= gfx9 */
#define   G_00B02C_LOAD_COLLISION_WAVEID(x)                           (((x) >> 25) & 0x1)
#define   C_00B02C_LOAD_COLLISION_WAVEID                              0xFDFFFFFF
#define   S_00B02C_LOAD_INTRAWAVE_COLLISION(x)                        (((unsigned)(x) & 0x1) << 26) /* >= gfx9 */
#define   G_00B02C_LOAD_INTRAWAVE_COLLISION(x)                        (((x) >> 26) & 0x1)
#define   C_00B02C_LOAD_INTRAWAVE_COLLISION                           0xFBFFFFFF
#define   S_00B02C_SKIP_USGPR0(x)                                     (((unsigned)(x) & 0x1) << 27) /* gfx9 */
#define   G_00B02C_SKIP_USGPR0(x)                                     (((x) >> 27) & 0x1)
#define   C_00B02C_SKIP_USGPR0                                        0xF7FFFFFF
#define   S_00B02C_USER_SGPR_MSB_GFX10(x)                             (((unsigned)(x) & 0x1) << 27) /* >= gfx10 */
#define   G_00B02C_USER_SGPR_MSB_GFX10(x)                             (((x) >> 27) & 0x1)
#define   C_00B02C_USER_SGPR_MSB_GFX10                                0xF7FFFFFF
#define   S_00B02C_SHARED_VGPR_CNT(x)                                 (((unsigned)(x) & 0xF) << 28) /* >= gfx10 */
#define   G_00B02C_SHARED_VGPR_CNT(x)                                 (((x) >> 28) & 0xF)
#define   C_00B02C_SHARED_VGPR_CNT                                    0x0FFFFFFF
#define   S_00B02C_USER_SGPR_MSB_GFX9(x)                              (((unsigned)(x) & 0x1) << 28) /* gfx9 */
#define   G_00B02C_USER_SGPR_MSB_GFX9(x)                              (((x) >> 28) & 0x1)
#define   C_00B02C_USER_SGPR_MSB_GFX9                                 0xEFFFFFFF
#define R_00B030_SPI_SHADER_USER_DATA_PS_0                              0x00B030
#define R_00B034_SPI_SHADER_USER_DATA_PS_1                              0x00B034
#define R_00B038_SPI_SHADER_USER_DATA_PS_2                              0x00B038
#define R_00B03C_SPI_SHADER_USER_DATA_PS_3                              0x00B03C
#define R_00B040_SPI_SHADER_USER_DATA_PS_4                              0x00B040
#define R_00B044_SPI_SHADER_USER_DATA_PS_5                              0x00B044
#define R_00B048_SPI_SHADER_USER_DATA_PS_6                              0x00B048
#define R_00B04C_SPI_SHADER_USER_DATA_PS_7                              0x00B04C
#define R_00B050_SPI_SHADER_USER_DATA_PS_8                              0x00B050
#define R_00B054_SPI_SHADER_USER_DATA_PS_9                              0x00B054
#define R_00B058_SPI_SHADER_USER_DATA_PS_10                             0x00B058
#define R_00B05C_SPI_SHADER_USER_DATA_PS_11                             0x00B05C
#define R_00B060_SPI_SHADER_USER_DATA_PS_12                             0x00B060
#define R_00B064_SPI_SHADER_USER_DATA_PS_13                             0x00B064
#define R_00B068_SPI_SHADER_USER_DATA_PS_14                             0x00B068
#define R_00B06C_SPI_SHADER_USER_DATA_PS_15                             0x00B06C
#define R_00B070_SPI_SHADER_USER_DATA_PS_16                             0x00B070 /* >= gfx9 */
#define R_00B074_SPI_SHADER_USER_DATA_PS_17                             0x00B074 /* >= gfx9 */
#define R_00B078_SPI_SHADER_USER_DATA_PS_18                             0x00B078 /* >= gfx9 */
#define R_00B07C_SPI_SHADER_USER_DATA_PS_19                             0x00B07C /* >= gfx9 */
#define R_00B080_SPI_SHADER_USER_DATA_PS_20                             0x00B080 /* >= gfx9 */
#define R_00B084_SPI_SHADER_USER_DATA_PS_21                             0x00B084 /* >= gfx9 */
#define R_00B088_SPI_SHADER_USER_DATA_PS_22                             0x00B088 /* >= gfx9 */
#define R_00B08C_SPI_SHADER_USER_DATA_PS_23                             0x00B08C /* >= gfx9 */
#define R_00B090_SPI_SHADER_USER_DATA_PS_24                             0x00B090 /* >= gfx9 */
#define R_00B094_SPI_SHADER_USER_DATA_PS_25                             0x00B094 /* >= gfx9 */
#define R_00B098_SPI_SHADER_USER_DATA_PS_26                             0x00B098 /* >= gfx9 */
#define R_00B09C_SPI_SHADER_USER_DATA_PS_27                             0x00B09C /* >= gfx9 */
#define R_00B0A0_SPI_SHADER_USER_DATA_PS_28                             0x00B0A0 /* >= gfx9 */
#define R_00B0A4_SPI_SHADER_USER_DATA_PS_29                             0x00B0A4 /* >= gfx9 */
#define R_00B0A8_SPI_SHADER_USER_DATA_PS_30                             0x00B0A8 /* >= gfx9 */
#define R_00B0AC_SPI_SHADER_USER_DATA_PS_31                             0x00B0AC /* >= gfx9 */
#define R_00B0C0_SPI_SHADER_REQ_CTRL_PS                                 0x00B0C0 /* >= gfx10 */
#define   S_00B0C0_SOFT_GROUPING_EN(x)                                (((unsigned)(x) & 0x1) << 0)
#define   G_00B0C0_SOFT_GROUPING_EN(x)                                (((x) >> 0) & 0x1)
#define   C_00B0C0_SOFT_GROUPING_EN                                   0xFFFFFFFE
#define   S_00B0C0_NUMBER_OF_REQUESTS_PER_CU(x)                       (((unsigned)(x) & 0xF) << 1)
#define   G_00B0C0_NUMBER_OF_REQUESTS_PER_CU(x)                       (((x) >> 1) & 0xF)
#define   C_00B0C0_NUMBER_OF_REQUESTS_PER_CU                          0xFFFFFFE1
#define   S_00B0C0_SOFT_GROUPING_ALLOCATION_TIMEOUT(x)                (((unsigned)(x) & 0xF) << 5)
#define   G_00B0C0_SOFT_GROUPING_ALLOCATION_TIMEOUT(x)                (((x) >> 5) & 0xF)
#define   C_00B0C0_SOFT_GROUPING_ALLOCATION_TIMEOUT                   0xFFFFFE1F
#define   S_00B0C0_HARD_LOCK_HYSTERESIS(x)                            (((unsigned)(x) & 0x1) << 9)
#define   G_00B0C0_HARD_LOCK_HYSTERESIS(x)                            (((x) >> 9) & 0x1)
#define   C_00B0C0_HARD_LOCK_HYSTERESIS                               0xFFFFFDFF
#define   S_00B0C0_HARD_LOCK_LOW_THRESHOLD(x)                         (((unsigned)(x) & 0x1F) << 10)
#define   G_00B0C0_HARD_LOCK_LOW_THRESHOLD(x)                         (((x) >> 10) & 0x1F)
#define   C_00B0C0_HARD_LOCK_LOW_THRESHOLD                            0xFFFF83FF
#define   S_00B0C0_PRODUCER_REQUEST_LOCKOUT(x)                        (((unsigned)(x) & 0x1) << 15)
#define   G_00B0C0_PRODUCER_REQUEST_LOCKOUT(x)                        (((x) >> 15) & 0x1)
#define   C_00B0C0_PRODUCER_REQUEST_LOCKOUT                           0xFFFF7FFF
#define   S_00B0C0_GLOBAL_SCANNING_EN(x)                              (((unsigned)(x) & 0x1) << 16)
#define   G_00B0C0_GLOBAL_SCANNING_EN(x)                              (((x) >> 16) & 0x1)
#define   C_00B0C0_GLOBAL_SCANNING_EN                                 0xFFFEFFFF
#define   S_00B0C0_ALLOCATION_RATE_THROTTLING_THRESHOLD(x)            (((unsigned)(x) & 0x7) << 17)
#define   G_00B0C0_ALLOCATION_RATE_THROTTLING_THRESHOLD(x)            (((x) >> 17) & 0x7)
#define   C_00B0C0_ALLOCATION_RATE_THROTTLING_THRESHOLD               0xFFF1FFFF
#define R_00B0C4_SPI_SHADER_PREF_PRI_CNTR_CTRL_PS                       0x00B0C4 /* gfx10 */
#define   S_00B0C4_TOTAL_WAVE_COUNT_HIER_SELECT(x)                    (((unsigned)(x) & 0x7) << 0)
#define   G_00B0C4_TOTAL_WAVE_COUNT_HIER_SELECT(x)                    (((x) >> 0) & 0x7)
#define   C_00B0C4_TOTAL_WAVE_COUNT_HIER_SELECT                       0xFFFFFFF8
#define   S_00B0C4_PER_TYPE_WAVE_COUNT_HIER_SELECT(x)                 (((unsigned)(x) & 0x7) << 3)
#define   G_00B0C4_PER_TYPE_WAVE_COUNT_HIER_SELECT(x)                 (((x) >> 3) & 0x7)
#define   C_00B0C4_PER_TYPE_WAVE_COUNT_HIER_SELECT                    0xFFFFFFC7
#define   S_00B0C4_GROUP_UPDATE_EN(x)                                 (((unsigned)(x) & 0x1) << 6)
#define   G_00B0C4_GROUP_UPDATE_EN(x)                                 (((x) >> 6) & 0x1)
#define   C_00B0C4_GROUP_UPDATE_EN                                    0xFFFFFFBF
#define   S_00B0C4_TOTAL_WAVE_COUNT_COEFFICIENT(x)                    (((unsigned)(x) & 0xFF) << 8)
#define   G_00B0C4_TOTAL_WAVE_COUNT_COEFFICIENT(x)                    (((x) >> 8) & 0xFF)
#define   C_00B0C4_TOTAL_WAVE_COUNT_COEFFICIENT                       0xFFFF00FF
#define   S_00B0C4_PER_TYPE_WAVE_COUNT_COEFFICIENT(x)                 (((unsigned)(x) & 0xFF) << 16)
#define   G_00B0C4_PER_TYPE_WAVE_COUNT_COEFFICIENT(x)                 (((x) >> 16) & 0xFF)
#define   C_00B0C4_PER_TYPE_WAVE_COUNT_COEFFICIENT                    0xFF00FFFF
#define R_00B0C8_SPI_SHADER_USER_ACCUM_PS_0                             0x00B0C8 /* >= gfx10 */
#define   S_00B0C8_CONTRIBUTION(x)                                    (((unsigned)(x) & 0x7F) << 0)
#define   G_00B0C8_CONTRIBUTION(x)                                    (((x) >> 0) & 0x7F)
#define   C_00B0C8_CONTRIBUTION                                       0xFFFFFF80
#define R_00B0CC_SPI_SHADER_USER_ACCUM_PS_1                             0x00B0CC /* >= gfx10 */
#define R_00B0D0_SPI_SHADER_USER_ACCUM_PS_2                             0x00B0D0 /* >= gfx10 */
#define R_00B0D4_SPI_SHADER_USER_ACCUM_PS_3                             0x00B0D4 /* >= gfx10 */
#define R_00B100_SPI_SHADER_TBA_LO_VS                                   0x00B100 /* <= gfx81 */
#define R_00B104_SPI_SHADER_PGM_RSRC4_VS                                0x00B104 /* >= gfx10 */
#define   S_00B104_CU_EN(x)                                           (((unsigned)(x) & 0xFFFF) << 0)
#define   G_00B104_CU_EN(x)                                           (((x) >> 0) & 0xFFFF)
#define   C_00B104_CU_EN                                              0xFFFF0000
#define R_00B104_SPI_SHADER_TBA_HI_VS                                   0x00B104 /* <= gfx81 */
#define   S_00B104_MEM_BASE(x)                                        (((unsigned)(x) & 0xFF) << 0)
#define   G_00B104_MEM_BASE(x)                                        (((x) >> 0) & 0xFF)
#define   C_00B104_MEM_BASE                                           0xFFFFFF00
#define R_00B108_SPI_SHADER_TMA_LO_VS                                   0x00B108 /* <= gfx81 */
#define R_00B10C_SPI_SHADER_TMA_HI_VS                                   0x00B10C /* <= gfx81 */
#define   S_00B10C_MEM_BASE(x)                                        (((unsigned)(x) & 0xFF) << 0)
#define   G_00B10C_MEM_BASE(x)                                        (((x) >> 0) & 0xFF)
#define   C_00B10C_MEM_BASE                                           0xFFFFFF00
#define R_00B114_SPI_SHADER_PGM_CHKSUM_VS                               0x00B114 /* >= gfx10 */
#define R_00B118_SPI_SHADER_PGM_RSRC3_VS                                0x00B118 /* >= gfx7 */
#define   S_00B118_CU_EN(x)                                           (((unsigned)(x) & 0xFFFF) << 0)
#define   G_00B118_CU_EN(x)                                           (((x) >> 0) & 0xFFFF)
#define   C_00B118_CU_EN                                              0xFFFF0000
#define   S_00B118_WAVE_LIMIT(x)                                      (((unsigned)(x) & 0x3F) << 16)
#define   G_00B118_WAVE_LIMIT(x)                                      (((x) >> 16) & 0x3F)
#define   C_00B118_WAVE_LIMIT                                         0xFFC0FFFF
#define   S_00B118_LOCK_LOW_THRESHOLD(x)                              (((unsigned)(x) & 0xF) << 22)
#define   G_00B118_LOCK_LOW_THRESHOLD(x)                              (((x) >> 22) & 0xF)
#define   C_00B118_LOCK_LOW_THRESHOLD                                 0xFC3FFFFF
#define   S_00B118_SIMD_DISABLE(x)                                    (((unsigned)(x) & 0xF) << 26) /* gfx9 */
#define   G_00B118_SIMD_DISABLE(x)                                    (((x) >> 26) & 0xF)
#define   C_00B118_SIMD_DISABLE                                       0xC3FFFFFF
#define R_00B11C_SPI_SHADER_LATE_ALLOC_VS                               0x00B11C /* >= gfx7 */
#define   S_00B11C_LIMIT(x)                                           (((unsigned)(x) & 0x3F) << 0)
#define   G_00B11C_LIMIT(x)                                           (((x) >> 0) & 0x3F)
#define   C_00B11C_LIMIT                                              0xFFFFFFC0
#define R_00B120_SPI_SHADER_PGM_LO_VS                                   0x00B120
#define R_00B124_SPI_SHADER_PGM_HI_VS                                   0x00B124
#define   S_00B124_MEM_BASE(x)                                        (((unsigned)(x) & 0xFF) << 0)
#define   G_00B124_MEM_BASE(x)                                        (((x) >> 0) & 0xFF)
#define   C_00B124_MEM_BASE                                           0xFFFFFF00
#define R_00B128_SPI_SHADER_PGM_RSRC1_VS                                0x00B128
#define   S_00B128_VGPRS(x)                                           (((unsigned)(x) & 0x3F) << 0)
#define   G_00B128_VGPRS(x)                                           (((x) >> 0) & 0x3F)
#define   C_00B128_VGPRS                                              0xFFFFFFC0
#define   S_00B128_SGPRS(x)                                           (((unsigned)(x) & 0xF) << 6)
#define   G_00B128_SGPRS(x)                                           (((x) >> 6) & 0xF)
#define   C_00B128_SGPRS                                              0xFFFFFC3F
#define   S_00B128_PRIORITY(x)                                        (((unsigned)(x) & 0x3) << 10)
#define   G_00B128_PRIORITY(x)                                        (((x) >> 10) & 0x3)
#define   C_00B128_PRIORITY                                           0xFFFFF3FF
#define   S_00B128_FLOAT_MODE(x)                                      (((unsigned)(x) & 0xFF) << 12)
#define   G_00B128_FLOAT_MODE(x)                                      (((x) >> 12) & 0xFF)
#define   C_00B128_FLOAT_MODE                                         0xFFF00FFF
#define     V_00B128_FP_32_DENORMS                                  48
#define     V_00B128_FP_64_DENORMS                                  192
#define     V_00B128_FP_ALL_DENORMS                                 240
#define   S_00B128_PRIV(x)                                            (((unsigned)(x) & 0x1) << 20)
#define   G_00B128_PRIV(x)                                            (((x) >> 20) & 0x1)
#define   C_00B128_PRIV                                               0xFFEFFFFF
#define   S_00B128_DX10_CLAMP(x)                                      (((unsigned)(x) & 0x1) << 21)
#define   G_00B128_DX10_CLAMP(x)                                      (((x) >> 21) & 0x1)
#define   C_00B128_DX10_CLAMP                                         0xFFDFFFFF
#define   S_00B128_DEBUG_MODE(x)                                      (((unsigned)(x) & 0x1) << 22) /* <= gfx9 */
#define   G_00B128_DEBUG_MODE(x)                                      (((x) >> 22) & 0x1)
#define   C_00B128_DEBUG_MODE                                         0xFFBFFFFF
#define   S_00B128_IEEE_MODE(x)                                       (((unsigned)(x) & 0x1) << 23)
#define   G_00B128_IEEE_MODE(x)                                       (((x) >> 23) & 0x1)
#define   C_00B128_IEEE_MODE                                          0xFF7FFFFF
#define   S_00B128_VGPR_COMP_CNT(x)                                   (((unsigned)(x) & 0x3) << 24)
#define   G_00B128_VGPR_COMP_CNT(x)                                   (((x) >> 24) & 0x3)
#define   C_00B128_VGPR_COMP_CNT                                      0xFCFFFFFF
#define   S_00B128_CU_GROUP_ENABLE(x)                                 (((unsigned)(x) & 0x1) << 26)
#define   G_00B128_CU_GROUP_ENABLE(x)                                 (((x) >> 26) & 0x1)
#define   C_00B128_CU_GROUP_ENABLE                                    0xFBFFFFFF
#define   S_00B128_CACHE_CTL(x)                                       (((unsigned)(x) & 0x7) << 27) /* <= gfx81 */
#define   G_00B128_CACHE_CTL(x)                                       (((x) >> 27) & 0x7)
#define   C_00B128_CACHE_CTL                                          0xC7FFFFFF
#define   S_00B128_MEM_ORDERED(x)                                     (((unsigned)(x) & 0x1) << 27) /* >= gfx10 */
#define   G_00B128_MEM_ORDERED(x)                                     (((x) >> 27) & 0x1)
#define   C_00B128_MEM_ORDERED                                        0xF7FFFFFF
#define   S_00B128_FWD_PROGRESS(x)                                    (((unsigned)(x) & 0x1) << 28) /* >= gfx10 */
#define   G_00B128_FWD_PROGRESS(x)                                    (((x) >> 28) & 0x1)
#define   C_00B128_FWD_PROGRESS                                       0xEFFFFFFF
#define   S_00B128_CDBG_USER(x)                                       (((unsigned)(x) & 0x1) << 30) /* <= gfx9 */
#define   G_00B128_CDBG_USER(x)                                       (((x) >> 30) & 0x1)
#define   C_00B128_CDBG_USER                                          0xBFFFFFFF
#define   S_00B128_FP16_OVFL(x)                                       (((unsigned)(x) & 0x1) << 31) /* >= gfx9 */
#define   G_00B128_FP16_OVFL(x)                                       (((x) >> 31) & 0x1)
#define   C_00B128_FP16_OVFL                                          0x7FFFFFFF
#define R_00B12C_SPI_SHADER_PGM_RSRC2_VS                                0x00B12C
#define   S_00B12C_SCRATCH_EN(x)                                      (((unsigned)(x) & 0x1) << 0)
#define   G_00B12C_SCRATCH_EN(x)                                      (((x) >> 0) & 0x1)
#define   C_00B12C_SCRATCH_EN                                         0xFFFFFFFE
#define   S_00B12C_USER_SGPR(x)                                       (((unsigned)(x) & 0x1F) << 1)
#define   G_00B12C_USER_SGPR(x)                                       (((x) >> 1) & 0x1F)
#define   C_00B12C_USER_SGPR                                          0xFFFFFFC1
#define   S_00B12C_TRAP_PRESENT(x)                                    (((unsigned)(x) & 0x1) << 6)
#define   G_00B12C_TRAP_PRESENT(x)                                    (((x) >> 6) & 0x1)
#define   C_00B12C_TRAP_PRESENT                                       0xFFFFFFBF
#define   S_00B12C_OC_LDS_EN(x)                                       (((unsigned)(x) & 0x1) << 7)
#define   G_00B12C_OC_LDS_EN(x)                                       (((x) >> 7) & 0x1)
#define   C_00B12C_OC_LDS_EN                                          0xFFFFFF7F
#define   S_00B12C_SO_BASE0_EN(x)                                     (((unsigned)(x) & 0x1) << 8)
#define   G_00B12C_SO_BASE0_EN(x)                                     (((x) >> 8) & 0x1)
#define   C_00B12C_SO_BASE0_EN                                        0xFFFFFEFF
#define   S_00B12C_SO_BASE1_EN(x)                                     (((unsigned)(x) & 0x1) << 9)
#define   G_00B12C_SO_BASE1_EN(x)                                     (((x) >> 9) & 0x1)
#define   C_00B12C_SO_BASE1_EN                                        0xFFFFFDFF
#define   S_00B12C_SO_BASE2_EN(x)                                     (((unsigned)(x) & 0x1) << 10)
#define   G_00B12C_SO_BASE2_EN(x)                                     (((x) >> 10) & 0x1)
#define   C_00B12C_SO_BASE2_EN                                        0xFFFFFBFF
#define   S_00B12C_SO_BASE3_EN(x)                                     (((unsigned)(x) & 0x1) << 11)
#define   G_00B12C_SO_BASE3_EN(x)                                     (((x) >> 11) & 0x1)
#define   C_00B12C_SO_BASE3_EN                                        0xFFFFF7FF
#define   S_00B12C_SO_EN(x)                                           (((unsigned)(x) & 0x1) << 12)
#define   G_00B12C_SO_EN(x)                                           (((x) >> 12) & 0x1)
#define   C_00B12C_SO_EN                                              0xFFFFEFFF
#define   S_00B12C_EXCP_EN(x)                                         (((unsigned)(x) & 0x1FF) << 13)
#define   G_00B12C_EXCP_EN(x)                                         (((x) >> 13) & 0x1FF)
#define   C_00B12C_EXCP_EN                                            0xFFC01FFF
#define     V_00B12C_INVALID                                        1
#define     V_00B12C_INPUT_DENORMAL                                 2
#define     V_00B12C_DIVIDE_BY_ZERO                                 4
#define     V_00B12C_OVERFLOW                                       8
#define     V_00B12C_UNDERFLOW                                      16
#define     V_00B12C_INEXACT                                        32
#define     V_00B12C_INT_DIVIDE_BY_ZERO                             64
#define     V_00B12C_ADDRESS_WATCH                                  128
#define     V_00B12C_MEMORY_VIOLATION                               256
#define   S_00B12C_PC_BASE_EN(x)                                      (((unsigned)(x) & 0x1) << 22) /* >= gfx9 */
#define   G_00B12C_PC_BASE_EN(x)                                      (((x) >> 22) & 0x1)
#define   C_00B12C_PC_BASE_EN                                         0xFFBFFFFF
#define   S_00B12C_DISPATCH_DRAW_EN(x)                                (((unsigned)(x) & 0x1) << 24) /* >= gfx8 */
#define   G_00B12C_DISPATCH_DRAW_EN(x)                                (((x) >> 24) & 0x1)
#define   C_00B12C_DISPATCH_DRAW_EN                                   0xFEFFFFFF
#define   S_00B12C_SKIP_USGPR0(x)                                     (((unsigned)(x) & 0x1) << 27) /* gfx9 */
#define   G_00B12C_SKIP_USGPR0(x)                                     (((x) >> 27) & 0x1)
#define   C_00B12C_SKIP_USGPR0                                        0xF7FFFFFF
#define   S_00B12C_USER_SGPR_MSB_GFX10(x)                             (((unsigned)(x) & 0x1) << 27) /* >= gfx10 */
#define   G_00B12C_USER_SGPR_MSB_GFX10(x)                             (((x) >> 27) & 0x1)
#define   C_00B12C_USER_SGPR_MSB_GFX10                                0xF7FFFFFF
#define   S_00B12C_SHARED_VGPR_CNT(x)                                 (((unsigned)(x) & 0xF) << 28) /* >= gfx10 */
#define   G_00B12C_SHARED_VGPR_CNT(x)                                 (((x) >> 28) & 0xF)
#define   C_00B12C_SHARED_VGPR_CNT                                    0x0FFFFFFF
#define   S_00B12C_USER_SGPR_MSB_GFX9(x)                              (((unsigned)(x) & 0x1) << 28) /* gfx9 */
#define   G_00B12C_USER_SGPR_MSB_GFX9(x)                              (((x) >> 28) & 0x1)
#define   C_00B12C_USER_SGPR_MSB_GFX9                                 0xEFFFFFFF
#define R_00B130_SPI_SHADER_USER_DATA_VS_0                              0x00B130
#define R_00B134_SPI_SHADER_USER_DATA_VS_1                              0x00B134
#define R_00B138_SPI_SHADER_USER_DATA_VS_2                              0x00B138
#define R_00B13C_SPI_SHADER_USER_DATA_VS_3                              0x00B13C
#define R_00B140_SPI_SHADER_USER_DATA_VS_4                              0x00B140
#define R_00B144_SPI_SHADER_USER_DATA_VS_5                              0x00B144
#define R_00B148_SPI_SHADER_USER_DATA_VS_6                              0x00B148
#define R_00B14C_SPI_SHADER_USER_DATA_VS_7                              0x00B14C
#define R_00B150_SPI_SHADER_USER_DATA_VS_8                              0x00B150
#define R_00B154_SPI_SHADER_USER_DATA_VS_9                              0x00B154
#define R_00B158_SPI_SHADER_USER_DATA_VS_10                             0x00B158
#define R_00B15C_SPI_SHADER_USER_DATA_VS_11                             0x00B15C
#define R_00B160_SPI_SHADER_USER_DATA_VS_12                             0x00B160
#define R_00B164_SPI_SHADER_USER_DATA_VS_13                             0x00B164
#define R_00B168_SPI_SHADER_USER_DATA_VS_14                             0x00B168
#define R_00B16C_SPI_SHADER_USER_DATA_VS_15                             0x00B16C
#define R_00B170_SPI_SHADER_USER_DATA_VS_16                             0x00B170 /* >= gfx9 */
#define R_00B174_SPI_SHADER_USER_DATA_VS_17                             0x00B174 /* >= gfx9 */
#define R_00B178_SPI_SHADER_USER_DATA_VS_18                             0x00B178 /* >= gfx9 */
#define R_00B17C_SPI_SHADER_USER_DATA_VS_19                             0x00B17C /* >= gfx9 */
#define R_00B180_SPI_SHADER_USER_DATA_VS_20                             0x00B180 /* >= gfx9 */
#define R_00B184_SPI_SHADER_USER_DATA_VS_21                             0x00B184 /* >= gfx9 */
#define R_00B188_SPI_SHADER_USER_DATA_VS_22                             0x00B188 /* >= gfx9 */
#define R_00B18C_SPI_SHADER_USER_DATA_VS_23                             0x00B18C /* >= gfx9 */
#define R_00B190_SPI_SHADER_USER_DATA_VS_24                             0x00B190 /* >= gfx9 */
#define R_00B194_SPI_SHADER_USER_DATA_VS_25                             0x00B194 /* >= gfx9 */
#define R_00B198_SPI_SHADER_USER_DATA_VS_26                             0x00B198 /* >= gfx9 */
#define R_00B19C_SPI_SHADER_USER_DATA_VS_27                             0x00B19C /* >= gfx9 */
#define R_00B1A0_SPI_SHADER_USER_DATA_VS_28                             0x00B1A0 /* >= gfx9 */
#define R_00B1A4_SPI_SHADER_USER_DATA_VS_29                             0x00B1A4 /* >= gfx9 */
#define R_00B1A8_SPI_SHADER_USER_DATA_VS_30                             0x00B1A8 /* >= gfx9 */
#define R_00B1AC_SPI_SHADER_USER_DATA_VS_31                             0x00B1AC /* >= gfx9 */
#define R_00B1C0_SPI_SHADER_REQ_CTRL_VS                                 0x00B1C0 /* >= gfx10 */
#define   S_00B1C0_SOFT_GROUPING_EN(x)                                (((unsigned)(x) & 0x1) << 0)
#define   G_00B1C0_SOFT_GROUPING_EN(x)                                (((x) >> 0) & 0x1)
#define   C_00B1C0_SOFT_GROUPING_EN                                   0xFFFFFFFE
#define   S_00B1C0_NUMBER_OF_REQUESTS_PER_CU(x)                       (((unsigned)(x) & 0xF) << 1)
#define   G_00B1C0_NUMBER_OF_REQUESTS_PER_CU(x)                       (((x) >> 1) & 0xF)
#define   C_00B1C0_NUMBER_OF_REQUESTS_PER_CU                          0xFFFFFFE1
#define   S_00B1C0_SOFT_GROUPING_ALLOCATION_TIMEOUT(x)                (((unsigned)(x) & 0xF) << 5)
#define   G_00B1C0_SOFT_GROUPING_ALLOCATION_TIMEOUT(x)                (((x) >> 5) & 0xF)
#define   C_00B1C0_SOFT_GROUPING_ALLOCATION_TIMEOUT                   0xFFFFFE1F
#define   S_00B1C0_HARD_LOCK_HYSTERESIS(x)                            (((unsigned)(x) & 0x1) << 9)
#define   G_00B1C0_HARD_LOCK_HYSTERESIS(x)                            (((x) >> 9) & 0x1)
#define   C_00B1C0_HARD_LOCK_HYSTERESIS                               0xFFFFFDFF
#define   S_00B1C0_HARD_LOCK_LOW_THRESHOLD(x)                         (((unsigned)(x) & 0x1F) << 10)
#define   G_00B1C0_HARD_LOCK_LOW_THRESHOLD(x)                         (((x) >> 10) & 0x1F)
#define   C_00B1C0_HARD_LOCK_LOW_THRESHOLD                            0xFFFF83FF
#define   S_00B1C0_PRODUCER_REQUEST_LOCKOUT(x)                        (((unsigned)(x) & 0x1) << 15)
#define   G_00B1C0_PRODUCER_REQUEST_LOCKOUT(x)                        (((x) >> 15) & 0x1)
#define   C_00B1C0_PRODUCER_REQUEST_LOCKOUT                           0xFFFF7FFF
#define   S_00B1C0_GLOBAL_SCANNING_EN(x)                              (((unsigned)(x) & 0x1) << 16)
#define   G_00B1C0_GLOBAL_SCANNING_EN(x)                              (((x) >> 16) & 0x1)
#define   C_00B1C0_GLOBAL_SCANNING_EN                                 0xFFFEFFFF
#define   S_00B1C0_ALLOCATION_RATE_THROTTLING_THRESHOLD(x)            (((unsigned)(x) & 0x7) << 17)
#define   G_00B1C0_ALLOCATION_RATE_THROTTLING_THRESHOLD(x)            (((x) >> 17) & 0x7)
#define   C_00B1C0_ALLOCATION_RATE_THROTTLING_THRESHOLD               0xFFF1FFFF
#define R_00B1C4_SPI_SHADER_PREF_PRI_CNTR_CTRL_VS                       0x00B1C4 /* gfx10 */
#define   S_00B1C4_TOTAL_WAVE_COUNT_HIER_SELECT(x)                    (((unsigned)(x) & 0x7) << 0)
#define   G_00B1C4_TOTAL_WAVE_COUNT_HIER_SELECT(x)                    (((x) >> 0) & 0x7)
#define   C_00B1C4_TOTAL_WAVE_COUNT_HIER_SELECT                       0xFFFFFFF8
#define   S_00B1C4_PER_TYPE_WAVE_COUNT_HIER_SELECT(x)                 (((unsigned)(x) & 0x7) << 3)
#define   G_00B1C4_PER_TYPE_WAVE_COUNT_HIER_SELECT(x)                 (((x) >> 3) & 0x7)
#define   C_00B1C4_PER_TYPE_WAVE_COUNT_HIER_SELECT                    0xFFFFFFC7
#define   S_00B1C4_GROUP_UPDATE_EN(x)                                 (((unsigned)(x) & 0x1) << 6)
#define   G_00B1C4_GROUP_UPDATE_EN(x)                                 (((x) >> 6) & 0x1)
#define   C_00B1C4_GROUP_UPDATE_EN                                    0xFFFFFFBF
#define   S_00B1C4_TOTAL_WAVE_COUNT_COEFFICIENT(x)                    (((unsigned)(x) & 0xFF) << 8)
#define   G_00B1C4_TOTAL_WAVE_COUNT_COEFFICIENT(x)                    (((x) >> 8) & 0xFF)
#define   C_00B1C4_TOTAL_WAVE_COUNT_COEFFICIENT                       0xFFFF00FF
#define   S_00B1C4_PER_TYPE_WAVE_COUNT_COEFFICIENT(x)                 (((unsigned)(x) & 0xFF) << 16)
#define   G_00B1C4_PER_TYPE_WAVE_COUNT_COEFFICIENT(x)                 (((x) >> 16) & 0xFF)
#define   C_00B1C4_PER_TYPE_WAVE_COUNT_COEFFICIENT                    0xFF00FFFF
#define R_00B1C8_SPI_SHADER_USER_ACCUM_VS_0                             0x00B1C8 /* >= gfx10 */
#define   S_00B1C8_CONTRIBUTION(x)                                    (((unsigned)(x) & 0x7F) << 0)
#define   G_00B1C8_CONTRIBUTION(x)                                    (((x) >> 0) & 0x7F)
#define   C_00B1C8_CONTRIBUTION                                       0xFFFFFF80
#define R_00B1CC_SPI_SHADER_USER_ACCUM_VS_1                             0x00B1CC /* >= gfx10 */
#define R_00B1D0_SPI_SHADER_USER_ACCUM_VS_2                             0x00B1D0 /* >= gfx10 */
#define R_00B1D4_SPI_SHADER_USER_ACCUM_VS_3                             0x00B1D4 /* >= gfx10 */
#define R_00B1EC_SPI_SHADER_PGM_RSRC2_GS_VS                             0x00B1EC /* >= gfx10 */
#define   S_00B1EC_SCRATCH_EN(x)                                      (((unsigned)(x) & 0x1) << 0)
#define   G_00B1EC_SCRATCH_EN(x)                                      (((x) >> 0) & 0x1)
#define   C_00B1EC_SCRATCH_EN                                         0xFFFFFFFE
#define   S_00B1EC_USER_SGPR(x)                                       (((unsigned)(x) & 0x1F) << 1)
#define   G_00B1EC_USER_SGPR(x)                                       (((x) >> 1) & 0x1F)
#define   C_00B1EC_USER_SGPR                                          0xFFFFFFC1
#define   S_00B1EC_TRAP_PRESENT(x)                                    (((unsigned)(x) & 0x1) << 6)
#define   G_00B1EC_TRAP_PRESENT(x)                                    (((x) >> 6) & 0x1)
#define   C_00B1EC_TRAP_PRESENT                                       0xFFFFFFBF
#define   S_00B1EC_EXCP_EN(x)                                         (((unsigned)(x) & 0x1FF) << 7)
#define   G_00B1EC_EXCP_EN(x)                                         (((x) >> 7) & 0x1FF)
#define   C_00B1EC_EXCP_EN                                            0xFFFF007F
#define     V_00B1EC_INVALID                                        1
#define     V_00B1EC_INPUT_DENORMAL                                 2
#define     V_00B1EC_DIVIDE_BY_ZERO                                 4
#define     V_00B1EC_OVERFLOW                                       8
#define     V_00B1EC_UNDERFLOW                                      16
#define     V_00B1EC_INEXACT                                        32
#define     V_00B1EC_INT_DIVIDE_BY_ZERO                             64
#define     V_00B1EC_ADDRESS_WATCH                                  128
#define     V_00B1EC_MEMORY_VIOLATION                               256
#define   S_00B1EC_VGPR_COMP_CNT(x)                                   (((unsigned)(x) & 0x3) << 16)
#define   G_00B1EC_VGPR_COMP_CNT(x)                                   (((x) >> 16) & 0x3)
#define   C_00B1EC_VGPR_COMP_CNT                                      0xFFFCFFFF
#define   S_00B1EC_OC_LDS_EN(x)                                       (((unsigned)(x) & 0x1) << 18)
#define   G_00B1EC_OC_LDS_EN(x)                                       (((x) >> 18) & 0x1)
#define   C_00B1EC_OC_LDS_EN                                          0xFFFBFFFF
#define   S_00B1EC_LDS_SIZE(x)                                        (((unsigned)(x) & 0xFF) << 19)
#define   G_00B1EC_LDS_SIZE(x)                                        (((x) >> 19) & 0xFF)
#define   C_00B1EC_LDS_SIZE                                           0xF807FFFF
#define   S_00B1EC_SKIP_USGPR0(x)                                     (((unsigned)(x) & 0x1) << 27)
#define   G_00B1EC_SKIP_USGPR0(x)                                     (((x) >> 27) & 0x1)
#define   C_00B1EC_SKIP_USGPR0                                        0xF7FFFFFF
#define   S_00B1EC_USER_SGPR_MSB(x)                                   (((unsigned)(x) & 0x1) << 28)
#define   G_00B1EC_USER_SGPR_MSB(x)                                   (((x) >> 28) & 0x1)
#define   C_00B1EC_USER_SGPR_MSB                                      0xEFFFFFFF
#define R_00B1F0_SPI_SHADER_PGM_RSRC2_ES_VS                             0x00B1F0 /* gfx7, gfx8, gfx81, gfx10 */
#define   S_00B1F0_SCRATCH_EN(x)                                      (((unsigned)(x) & 0x1) << 0)
#define   G_00B1F0_SCRATCH_EN(x)                                      (((x) >> 0) & 0x1)
#define   C_00B1F0_SCRATCH_EN                                         0xFFFFFFFE
#define   S_00B1F0_USER_SGPR(x)                                       (((unsigned)(x) & 0x1F) << 1)
#define   G_00B1F0_USER_SGPR(x)                                       (((x) >> 1) & 0x1F)
#define   C_00B1F0_USER_SGPR                                          0xFFFFFFC1
#define   S_00B1F0_TRAP_PRESENT(x)                                    (((unsigned)(x) & 0x1) << 6)
#define   G_00B1F0_TRAP_PRESENT(x)                                    (((x) >> 6) & 0x1)
#define   C_00B1F0_TRAP_PRESENT                                       0xFFFFFFBF
#define   S_00B1F0_OC_LDS_EN_GFX7(x)                                  (((unsigned)(x) & 0x1) << 7)
#define   G_00B1F0_OC_LDS_EN_GFX7(x)                                  (((x) >> 7) & 0x1)
#define   C_00B1F0_OC_LDS_EN_GFX7                                     0xFFFFFF7F
#define   S_00B1F0_EXCP_EN_GFX7(x)                                    (((unsigned)(x) & 0x1FF) << 8)
#define   G_00B1F0_EXCP_EN_GFX7(x)                                    (((x) >> 8) & 0x1FF)
#define   C_00B1F0_EXCP_EN_GFX7                                       0xFFFE00FF
#define     V_00B1F0_INVALID                                        1
#define     V_00B1F0_INPUT_DENORMAL                                 2
#define     V_00B1F0_DIVIDE_BY_ZERO                                 4
#define     V_00B1F0_OVERFLOW                                       8
#define     V_00B1F0_UNDERFLOW                                      16
#define     V_00B1F0_INEXACT                                        32
#define     V_00B1F0_INT_DIVIDE_BY_ZERO                             64
#define     V_00B1F0_ADDRESS_WATCH                                  128
#define     V_00B1F0_MEMORY_VIOLATION                               256
#define   S_00B1F0_LDS_SIZE_GFX7(x)                                   (((unsigned)(x) & 0x1FF) << 20)
#define   G_00B1F0_LDS_SIZE_GFX7(x)                                   (((x) >> 20) & 0x1FF)
#define   C_00B1F0_LDS_SIZE_GFX7                                      0xE00FFFFF
#define R_00B1F0_SPI_SHADER_PGM_RSRC2_GS_VS                             0x00B1F0 /* gfx9 */
#define   S_00B1F0_EXCP_EN_GFX9(x)                                    (((unsigned)(x) & 0x1FF) << 7)
#define   G_00B1F0_EXCP_EN_GFX9(x)                                    (((x) >> 7) & 0x1FF)
#define   C_00B1F0_EXCP_EN_GFX9                                       0xFFFF007F
#define   S_00B1F0_VGPR_COMP_CNT(x)                                   (((unsigned)(x) & 0x3) << 16)
#define   G_00B1F0_VGPR_COMP_CNT(x)                                   (((x) >> 16) & 0x3)
#define   C_00B1F0_VGPR_COMP_CNT                                      0xFFFCFFFF
#define   S_00B1F0_OC_LDS_EN_GFX9(x)                                  (((unsigned)(x) & 0x1) << 18)
#define   G_00B1F0_OC_LDS_EN_GFX9(x)                                  (((x) >> 18) & 0x1)
#define   C_00B1F0_OC_LDS_EN_GFX9                                     0xFFFBFFFF
#define   S_00B1F0_LDS_SIZE_GFX9(x)                                   (((unsigned)(x) & 0xFF) << 19)
#define   G_00B1F0_LDS_SIZE_GFX9(x)                                   (((x) >> 19) & 0xFF)
#define   C_00B1F0_LDS_SIZE_GFX9                                      0xF807FFFF
#define   S_00B1F0_SKIP_USGPR0(x)                                     (((unsigned)(x) & 0x1) << 27)
#define   G_00B1F0_SKIP_USGPR0(x)                                     (((x) >> 27) & 0x1)
#define   C_00B1F0_SKIP_USGPR0                                        0xF7FFFFFF
#define   S_00B1F0_USER_SGPR_MSB(x)                                   (((unsigned)(x) & 0x1) << 28)
#define   G_00B1F0_USER_SGPR_MSB(x)                                   (((x) >> 28) & 0x1)
#define   C_00B1F0_USER_SGPR_MSB                                      0xEFFFFFFF
#define R_00B1F4_SPI_SHADER_PGM_RSRC2_LS_VS                             0x00B1F4 /* gfx7, gfx8, gfx81, gfx10 */
#define   S_00B1F4_SCRATCH_EN(x)                                      (((unsigned)(x) & 0x1) << 0)
#define   G_00B1F4_SCRATCH_EN(x)                                      (((x) >> 0) & 0x1)
#define   C_00B1F4_SCRATCH_EN                                         0xFFFFFFFE
#define   S_00B1F4_USER_SGPR(x)                                       (((unsigned)(x) & 0x1F) << 1)
#define   G_00B1F4_USER_SGPR(x)                                       (((x) >> 1) & 0x1F)
#define   C_00B1F4_USER_SGPR                                          0xFFFFFFC1
#define   S_00B1F4_TRAP_PRESENT(x)                                    (((unsigned)(x) & 0x1) << 6)
#define   G_00B1F4_TRAP_PRESENT(x)                                    (((x) >> 6) & 0x1)
#define   C_00B1F4_TRAP_PRESENT                                       0xFFFFFFBF
#define   S_00B1F4_LDS_SIZE(x)                                        (((unsigned)(x) & 0x1FF) << 7)
#define   G_00B1F4_LDS_SIZE(x)                                        (((x) >> 7) & 0x1FF)
#define   C_00B1F4_LDS_SIZE                                           0xFFFF007F
#define   S_00B1F4_EXCP_EN(x)                                         (((unsigned)(x) & 0x1FF) << 16)
#define   G_00B1F4_EXCP_EN(x)                                         (((x) >> 16) & 0x1FF)
#define   C_00B1F4_EXCP_EN                                            0xFE00FFFF
#define     V_00B1F4_INVALID                                        1
#define     V_00B1F4_INPUT_DENORMAL                                 2
#define     V_00B1F4_DIVIDE_BY_ZERO                                 4
#define     V_00B1F4_OVERFLOW                                       8
#define     V_00B1F4_UNDERFLOW                                      16
#define     V_00B1F4_INEXACT                                        32
#define     V_00B1F4_INT_DIVIDE_BY_ZERO                             64
#define     V_00B1F4_ADDRESS_WATCH                                  128
#define     V_00B1F4_MEMORY_VIOLATION                               256
#define R_00B200_SPI_SHADER_PGM_CHKSUM_GS                               0x00B200 /* >= gfx10 */
#define R_00B200_SPI_SHADER_TBA_LO_GS                                   0x00B200 /* <= gfx81 */
#define R_00B204_SPI_SHADER_PGM_RSRC4_GS                                0x00B204 /* >= gfx9 */
#define   S_00B204_CU_EN(x)                                           (((unsigned)(x) & 0xFFFF) << 0) /* >= gfx10 */
#define   G_00B204_CU_EN(x)                                           (((x) >> 0) & 0xFFFF)
#define   C_00B204_CU_EN                                              0xFFFF0000
#define   S_00B204_GROUP_FIFO_DEPTH(x)                                (((unsigned)(x) & 0x7F) << 0) /* gfx9 */
#define   G_00B204_GROUP_FIFO_DEPTH(x)                                (((x) >> 0) & 0x7F)
#define   C_00B204_GROUP_FIFO_DEPTH                                   0xFFFFFF80
#define   S_00B204_SPI_SHADER_LATE_ALLOC_GS_GFX9(x)                   (((unsigned)(x) & 0x7F) << 7) /* gfx9 */
#define   G_00B204_SPI_SHADER_LATE_ALLOC_GS_GFX9(x)                   (((x) >> 7) & 0x7F)
#define   C_00B204_SPI_SHADER_LATE_ALLOC_GS_GFX9                      0xFFFFC07F
#define   S_00B204_SPI_SHADER_LATE_ALLOC_GS_GFX10(x)                  (((unsigned)(x) & 0x7F) << 16) /* >= gfx10 */
#define   G_00B204_SPI_SHADER_LATE_ALLOC_GS_GFX10(x)                  (((x) >> 16) & 0x7F)
#define   C_00B204_SPI_SHADER_LATE_ALLOC_GS_GFX10                     0xFF80FFFF
#define R_00B204_SPI_SHADER_TBA_HI_GS                                   0x00B204 /* <= gfx81 */
#define   S_00B204_MEM_BASE(x)                                        (((unsigned)(x) & 0xFF) << 0)
#define   G_00B204_MEM_BASE(x)                                        (((x) >> 0) & 0xFF)
#define   C_00B204_MEM_BASE                                           0xFFFFFF00
#define R_00B208_SPI_SHADER_TMA_LO_GS                                   0x00B208 /* <= gfx81 */
#define R_00B208_SPI_SHADER_USER_DATA_ADDR_LO_GS                        0x00B208 /* >= gfx9 */
#define R_00B20C_SPI_SHADER_TMA_HI_GS                                   0x00B20C /* <= gfx81 */
#define   S_00B20C_MEM_BASE(x)                                        (((unsigned)(x) & 0xFF) << 0)
#define   G_00B20C_MEM_BASE(x)                                        (((x) >> 0) & 0xFF)
#define   C_00B20C_MEM_BASE                                           0xFFFFFF00
#define R_00B20C_SPI_SHADER_USER_DATA_ADDR_HI_GS                        0x00B20C /* >= gfx9 */
#define R_00B210_SPI_SHADER_PGM_LO_ES                                   0x00B210 /* gfx9 */
#define R_00B210_SPI_SHADER_PGM_LO_ES_GS                                0x00B210 /* >= gfx10 */
#define R_00B214_SPI_SHADER_PGM_HI_ES                                   0x00B214 /* gfx9 */
#define   S_00B214_MEM_BASE(x)                                        (((unsigned)(x) & 0xFF) << 0)
#define   G_00B214_MEM_BASE(x)                                        (((x) >> 0) & 0xFF)
#define   C_00B214_MEM_BASE                                           0xFFFFFF00
#define R_00B214_SPI_SHADER_PGM_HI_ES_GS                                0x00B214 /* >= gfx10 */
#define R_00B21C_SPI_SHADER_PGM_RSRC3_GS                                0x00B21C /* >= gfx7 */
#define   S_00B21C_CU_EN(x)                                           (((unsigned)(x) & 0xFFFF) << 0)
#define   G_00B21C_CU_EN(x)                                           (((x) >> 0) & 0xFFFF)
#define   C_00B21C_CU_EN                                              0xFFFF0000
#define   S_00B21C_WAVE_LIMIT(x)                                      (((unsigned)(x) & 0x3F) << 16)
#define   G_00B21C_WAVE_LIMIT(x)                                      (((x) >> 16) & 0x3F)
#define   C_00B21C_WAVE_LIMIT                                         0xFFC0FFFF
#define   S_00B21C_LOCK_LOW_THRESHOLD(x)                              (((unsigned)(x) & 0xF) << 22)
#define   G_00B21C_LOCK_LOW_THRESHOLD(x)                              (((x) >> 22) & 0xF)
#define   C_00B21C_LOCK_LOW_THRESHOLD                                 0xFC3FFFFF
#define   S_00B21C_GROUP_FIFO_DEPTH(x)                                (((unsigned)(x) & 0x3F) << 26) /* gfx8, gfx81, >= gfx10 */
#define   G_00B21C_GROUP_FIFO_DEPTH(x)                                (((x) >> 26) & 0x3F)
#define   C_00B21C_GROUP_FIFO_DEPTH                                   0x03FFFFFF
#define   S_00B21C_SIMD_DISABLE(x)                                    (((unsigned)(x) & 0xF) << 26) /* gfx9 */
#define   G_00B21C_SIMD_DISABLE(x)                                    (((x) >> 26) & 0xF)
#define   C_00B21C_SIMD_DISABLE                                       0xC3FFFFFF
#define R_00B220_SPI_SHADER_PGM_LO_GS                                   0x00B220
#define R_00B224_SPI_SHADER_PGM_HI_GS                                   0x00B224
#define   S_00B224_MEM_BASE(x)                                        (((unsigned)(x) & 0xFF) << 0)
#define   G_00B224_MEM_BASE(x)                                        (((x) >> 0) & 0xFF)
#define   C_00B224_MEM_BASE                                           0xFFFFFF00
#define R_00B228_SPI_SHADER_PGM_RSRC1_GS                                0x00B228
#define   S_00B228_VGPRS(x)                                           (((unsigned)(x) & 0x3F) << 0)
#define   G_00B228_VGPRS(x)                                           (((x) >> 0) & 0x3F)
#define   C_00B228_VGPRS                                              0xFFFFFFC0
#define   S_00B228_SGPRS(x)                                           (((unsigned)(x) & 0xF) << 6)
#define   G_00B228_SGPRS(x)                                           (((x) >> 6) & 0xF)
#define   C_00B228_SGPRS                                              0xFFFFFC3F
#define   S_00B228_PRIORITY(x)                                        (((unsigned)(x) & 0x3) << 10)
#define   G_00B228_PRIORITY(x)                                        (((x) >> 10) & 0x3)
#define   C_00B228_PRIORITY                                           0xFFFFF3FF
#define   S_00B228_FLOAT_MODE(x)                                      (((unsigned)(x) & 0xFF) << 12)
#define   G_00B228_FLOAT_MODE(x)                                      (((x) >> 12) & 0xFF)
#define   C_00B228_FLOAT_MODE                                         0xFFF00FFF
#define     V_00B228_FP_32_DENORMS                                  48
#define     V_00B228_FP_64_DENORMS                                  192
#define     V_00B228_FP_ALL_DENORMS                                 240
#define   S_00B228_PRIV(x)                                            (((unsigned)(x) & 0x1) << 20)
#define   G_00B228_PRIV(x)                                            (((x) >> 20) & 0x1)
#define   C_00B228_PRIV                                               0xFFEFFFFF
#define   S_00B228_DX10_CLAMP(x)                                      (((unsigned)(x) & 0x1) << 21)
#define   G_00B228_DX10_CLAMP(x)                                      (((x) >> 21) & 0x1)
#define   C_00B228_DX10_CLAMP                                         0xFFDFFFFF
#define   S_00B228_DEBUG_MODE(x)                                      (((unsigned)(x) & 0x1) << 22) /* <= gfx9 */
#define   G_00B228_DEBUG_MODE(x)                                      (((x) >> 22) & 0x1)
#define   C_00B228_DEBUG_MODE                                         0xFFBFFFFF
#define   S_00B228_IEEE_MODE(x)                                       (((unsigned)(x) & 0x1) << 23)
#define   G_00B228_IEEE_MODE(x)                                       (((x) >> 23) & 0x1)
#define   C_00B228_IEEE_MODE                                          0xFF7FFFFF
#define   S_00B228_CU_GROUP_ENABLE(x)                                 (((unsigned)(x) & 0x1) << 24)
#define   G_00B228_CU_GROUP_ENABLE(x)                                 (((x) >> 24) & 0x1)
#define   C_00B228_CU_GROUP_ENABLE                                    0xFEFFFFFF
#define   S_00B228_CACHE_CTL(x)                                       (((unsigned)(x) & 0x7) << 25) /* <= gfx81 */
#define   G_00B228_CACHE_CTL(x)                                       (((x) >> 25) & 0x7)
#define   C_00B228_CACHE_CTL                                          0xF1FFFFFF
#define   S_00B228_MEM_ORDERED(x)                                     (((unsigned)(x) & 0x1) << 25) /* >= gfx10 */
#define   G_00B228_MEM_ORDERED(x)                                     (((x) >> 25) & 0x1)
#define   C_00B228_MEM_ORDERED                                        0xFDFFFFFF
#define   S_00B228_FWD_PROGRESS(x)                                    (((unsigned)(x) & 0x1) << 26) /* >= gfx10 */
#define   G_00B228_FWD_PROGRESS(x)                                    (((x) >> 26) & 0x1)
#define   C_00B228_FWD_PROGRESS                                       0xFBFFFFFF
#define   S_00B228_WGP_MODE(x)                                        (((unsigned)(x) & 0x1) << 27) /* >= gfx10 */
#define   G_00B228_WGP_MODE(x)                                        (((x) >> 27) & 0x1)
#define   C_00B228_WGP_MODE                                           0xF7FFFFFF
#define   S_00B228_CDBG_USER(x)                                       (((unsigned)(x) & 0x1) << 28) /* <= gfx9 */
#define   G_00B228_CDBG_USER(x)                                       (((x) >> 28) & 0x1)
#define   C_00B228_CDBG_USER                                          0xEFFFFFFF
#define   S_00B228_GS_VGPR_COMP_CNT(x)                                (((unsigned)(x) & 0x3) << 29) /* >= gfx9 */
#define   G_00B228_GS_VGPR_COMP_CNT(x)                                (((x) >> 29) & 0x3)
#define   C_00B228_GS_VGPR_COMP_CNT                                   0x9FFFFFFF
#define   S_00B228_FP16_OVFL(x)                                       (((unsigned)(x) & 0x1) << 31) /* >= gfx9 */
#define   G_00B228_FP16_OVFL(x)                                       (((x) >> 31) & 0x1)
#define   C_00B228_FP16_OVFL                                          0x7FFFFFFF
#define R_00B22C_SPI_SHADER_PGM_RSRC2_GS                                0x00B22C
#define   S_00B22C_SCRATCH_EN(x)                                      (((unsigned)(x) & 0x1) << 0)
#define   G_00B22C_SCRATCH_EN(x)                                      (((x) >> 0) & 0x1)
#define   C_00B22C_SCRATCH_EN                                         0xFFFFFFFE
#define   S_00B22C_USER_SGPR(x)                                       (((unsigned)(x) & 0x1F) << 1)
#define   G_00B22C_USER_SGPR(x)                                       (((x) >> 1) & 0x1F)
#define   C_00B22C_USER_SGPR                                          0xFFFFFFC1
#define   S_00B22C_TRAP_PRESENT(x)                                    (((unsigned)(x) & 0x1) << 6)
#define   G_00B22C_TRAP_PRESENT(x)                                    (((x) >> 6) & 0x1)
#define   C_00B22C_TRAP_PRESENT                                       0xFFFFFFBF
#define   S_00B22C_EXCP_EN(x)                                         (((unsigned)(x) & 0x1FF) << 7)
#define   G_00B22C_EXCP_EN(x)                                         (((x) >> 7) & 0x1FF)
#define   C_00B22C_EXCP_EN                                            0xFFFF007F
#define     V_00B22C_INVALID                                        1
#define     V_00B22C_INPUT_DENORMAL                                 2
#define     V_00B22C_DIVIDE_BY_ZERO                                 4
#define     V_00B22C_OVERFLOW                                       8
#define     V_00B22C_UNDERFLOW                                      16
#define     V_00B22C_INEXACT                                        32
#define     V_00B22C_INT_DIVIDE_BY_ZERO                             64
#define     V_00B22C_ADDRESS_WATCH                                  128
#define     V_00B22C_MEMORY_VIOLATION                               256
#define   S_00B22C_ES_VGPR_COMP_CNT(x)                                (((unsigned)(x) & 0x3) << 16) /* >= gfx9 */
#define   G_00B22C_ES_VGPR_COMP_CNT(x)                                (((x) >> 16) & 0x3)
#define   C_00B22C_ES_VGPR_COMP_CNT                                   0xFFFCFFFF
#define   S_00B22C_OC_LDS_EN(x)                                       (((unsigned)(x) & 0x1) << 18) /* >= gfx9 */
#define   G_00B22C_OC_LDS_EN(x)                                       (((x) >> 18) & 0x1)
#define   C_00B22C_OC_LDS_EN                                          0xFFFBFFFF
#define   S_00B22C_LDS_SIZE(x)                                        (((unsigned)(x) & 0xFF) << 19) /* >= gfx9 */
#define   G_00B22C_LDS_SIZE(x)                                        (((x) >> 19) & 0xFF)
#define   C_00B22C_LDS_SIZE                                           0xF807FFFF
#define   S_00B22C_SKIP_USGPR0(x)                                     (((unsigned)(x) & 0x1) << 27) /* gfx9 */
#define   G_00B22C_SKIP_USGPR0(x)                                     (((x) >> 27) & 0x1)
#define   C_00B22C_SKIP_USGPR0                                        0xF7FFFFFF
#define   S_00B22C_USER_SGPR_MSB_GFX10(x)                             (((unsigned)(x) & 0x1) << 27) /* >= gfx10 */
#define   G_00B22C_USER_SGPR_MSB_GFX10(x)                             (((x) >> 27) & 0x1)
#define   C_00B22C_USER_SGPR_MSB_GFX10                                0xF7FFFFFF
#define   S_00B22C_SHARED_VGPR_CNT(x)                                 (((unsigned)(x) & 0xF) << 28) /* >= gfx10 */
#define   G_00B22C_SHARED_VGPR_CNT(x)                                 (((x) >> 28) & 0xF)
#define   C_00B22C_SHARED_VGPR_CNT                                    0x0FFFFFFF
#define   S_00B22C_USER_SGPR_MSB_GFX9(x)                              (((unsigned)(x) & 0x1) << 28) /* gfx9 */
#define   G_00B22C_USER_SGPR_MSB_GFX9(x)                              (((x) >> 28) & 0x1)
#define   C_00B22C_USER_SGPR_MSB_GFX9                                 0xEFFFFFFF
#define R_00B230_SPI_SHADER_USER_DATA_GS_0                              0x00B230 /* <= gfx81, >= gfx10 */
#define R_00B234_SPI_SHADER_USER_DATA_GS_1                              0x00B234 /* <= gfx81, >= gfx10 */
#define R_00B238_SPI_SHADER_USER_DATA_GS_2                              0x00B238 /* <= gfx81, >= gfx10 */
#define R_00B23C_SPI_SHADER_USER_DATA_GS_3                              0x00B23C /* <= gfx81, >= gfx10 */
#define R_00B240_SPI_SHADER_USER_DATA_GS_4                              0x00B240 /* <= gfx81, >= gfx10 */
#define R_00B244_SPI_SHADER_USER_DATA_GS_5                              0x00B244 /* <= gfx81, >= gfx10 */
#define R_00B248_SPI_SHADER_USER_DATA_GS_6                              0x00B248 /* <= gfx81, >= gfx10 */
#define R_00B24C_SPI_SHADER_USER_DATA_GS_7                              0x00B24C /* <= gfx81, >= gfx10 */
#define R_00B250_SPI_SHADER_USER_DATA_GS_8                              0x00B250 /* <= gfx81, >= gfx10 */
#define R_00B254_SPI_SHADER_USER_DATA_GS_9                              0x00B254 /* <= gfx81, >= gfx10 */
#define R_00B258_SPI_SHADER_USER_DATA_GS_10                             0x00B258 /* <= gfx81, >= gfx10 */
#define R_00B25C_SPI_SHADER_USER_DATA_GS_11                             0x00B25C /* <= gfx81, >= gfx10 */
#define R_00B260_SPI_SHADER_USER_DATA_GS_12                             0x00B260 /* <= gfx81, >= gfx10 */
#define R_00B264_SPI_SHADER_USER_DATA_GS_13                             0x00B264 /* <= gfx81, >= gfx10 */
#define R_00B268_SPI_SHADER_USER_DATA_GS_14                             0x00B268 /* <= gfx81, >= gfx10 */
#define R_00B26C_SPI_SHADER_USER_DATA_GS_15                             0x00B26C /* <= gfx81, >= gfx10 */
#define R_00B270_SPI_SHADER_USER_DATA_GS_16                             0x00B270 /* >= gfx10 */
#define R_00B274_SPI_SHADER_USER_DATA_GS_17                             0x00B274 /* >= gfx10 */
#define R_00B278_SPI_SHADER_USER_DATA_GS_18                             0x00B278 /* >= gfx10 */
#define R_00B27C_SPI_SHADER_USER_DATA_GS_19                             0x00B27C /* >= gfx10 */
#define R_00B280_SPI_SHADER_USER_DATA_GS_20                             0x00B280 /* >= gfx10 */
#define R_00B284_SPI_SHADER_USER_DATA_GS_21                             0x00B284 /* >= gfx10 */
#define R_00B288_SPI_SHADER_USER_DATA_GS_22                             0x00B288 /* >= gfx10 */
#define R_00B28C_SPI_SHADER_USER_DATA_GS_23                             0x00B28C /* >= gfx10 */
#define R_00B290_SPI_SHADER_USER_DATA_GS_24                             0x00B290 /* >= gfx10 */
#define R_00B294_SPI_SHADER_USER_DATA_GS_25                             0x00B294 /* >= gfx10 */
#define R_00B298_SPI_SHADER_USER_DATA_GS_26                             0x00B298 /* >= gfx10 */
#define R_00B29C_SPI_SHADER_USER_DATA_GS_27                             0x00B29C /* >= gfx10 */
#define R_00B2A0_SPI_SHADER_USER_DATA_GS_28                             0x00B2A0 /* >= gfx10 */
#define R_00B2A4_SPI_SHADER_USER_DATA_GS_29                             0x00B2A4 /* >= gfx10 */
#define R_00B2A8_SPI_SHADER_USER_DATA_GS_30                             0x00B2A8 /* >= gfx10 */
#define R_00B2AC_SPI_SHADER_USER_DATA_GS_31                             0x00B2AC /* >= gfx10 */
#define R_00B2C0_SPI_SHADER_REQ_CTRL_ESGS                               0x00B2C0 /* >= gfx10 */
#define   S_00B2C0_SOFT_GROUPING_EN(x)                                (((unsigned)(x) & 0x1) << 0)
#define   G_00B2C0_SOFT_GROUPING_EN(x)                                (((x) >> 0) & 0x1)
#define   C_00B2C0_SOFT_GROUPING_EN                                   0xFFFFFFFE
#define   S_00B2C0_NUMBER_OF_REQUESTS_PER_CU(x)                       (((unsigned)(x) & 0xF) << 1)
#define   G_00B2C0_NUMBER_OF_REQUESTS_PER_CU(x)                       (((x) >> 1) & 0xF)
#define   C_00B2C0_NUMBER_OF_REQUESTS_PER_CU                          0xFFFFFFE1
#define   S_00B2C0_SOFT_GROUPING_ALLOCATION_TIMEOUT(x)                (((unsigned)(x) & 0xF) << 5)
#define   G_00B2C0_SOFT_GROUPING_ALLOCATION_TIMEOUT(x)                (((x) >> 5) & 0xF)
#define   C_00B2C0_SOFT_GROUPING_ALLOCATION_TIMEOUT                   0xFFFFFE1F
#define   S_00B2C0_HARD_LOCK_HYSTERESIS(x)                            (((unsigned)(x) & 0x1) << 9)
#define   G_00B2C0_HARD_LOCK_HYSTERESIS(x)                            (((x) >> 9) & 0x1)
#define   C_00B2C0_HARD_LOCK_HYSTERESIS                               0xFFFFFDFF
#define   S_00B2C0_HARD_LOCK_LOW_THRESHOLD(x)                         (((unsigned)(x) & 0x1F) << 10)
#define   G_00B2C0_HARD_LOCK_LOW_THRESHOLD(x)                         (((x) >> 10) & 0x1F)
#define   C_00B2C0_HARD_LOCK_LOW_THRESHOLD                            0xFFFF83FF
#define   S_00B2C0_PRODUCER_REQUEST_LOCKOUT(x)                        (((unsigned)(x) & 0x1) << 15)
#define   G_00B2C0_PRODUCER_REQUEST_LOCKOUT(x)                        (((x) >> 15) & 0x1)
#define   C_00B2C0_PRODUCER_REQUEST_LOCKOUT                           0xFFFF7FFF
#define   S_00B2C0_GLOBAL_SCANNING_EN(x)                              (((unsigned)(x) & 0x1) << 16)
#define   G_00B2C0_GLOBAL_SCANNING_EN(x)                              (((x) >> 16) & 0x1)
#define   C_00B2C0_GLOBAL_SCANNING_EN                                 0xFFFEFFFF
#define   S_00B2C0_ALLOCATION_RATE_THROTTLING_THRESHOLD(x)            (((unsigned)(x) & 0x7) << 17)
#define   G_00B2C0_ALLOCATION_RATE_THROTTLING_THRESHOLD(x)            (((x) >> 17) & 0x7)
#define   C_00B2C0_ALLOCATION_RATE_THROTTLING_THRESHOLD               0xFFF1FFFF
#define R_00B2C4_SPI_SHADER_PREF_PRI_CNTR_CTRL_ESGS                     0x00B2C4 /* gfx10 */
#define   S_00B2C4_TOTAL_WAVE_COUNT_HIER_SELECT(x)                    (((unsigned)(x) & 0x7) << 0)
#define   G_00B2C4_TOTAL_WAVE_COUNT_HIER_SELECT(x)                    (((x) >> 0) & 0x7)
#define   C_00B2C4_TOTAL_WAVE_COUNT_HIER_SELECT                       0xFFFFFFF8
#define   S_00B2C4_PER_TYPE_WAVE_COUNT_HIER_SELECT(x)                 (((unsigned)(x) & 0x7) << 3)
#define   G_00B2C4_PER_TYPE_WAVE_COUNT_HIER_SELECT(x)                 (((x) >> 3) & 0x7)
#define   C_00B2C4_PER_TYPE_WAVE_COUNT_HIER_SELECT                    0xFFFFFFC7
#define   S_00B2C4_GROUP_UPDATE_EN(x)                                 (((unsigned)(x) & 0x1) << 6)
#define   G_00B2C4_GROUP_UPDATE_EN(x)                                 (((x) >> 6) & 0x1)
#define   C_00B2C4_GROUP_UPDATE_EN                                    0xFFFFFFBF
#define   S_00B2C4_TOTAL_WAVE_COUNT_COEFFICIENT(x)                    (((unsigned)(x) & 0xFF) << 8)
#define   G_00B2C4_TOTAL_WAVE_COUNT_COEFFICIENT(x)                    (((x) >> 8) & 0xFF)
#define   C_00B2C4_TOTAL_WAVE_COUNT_COEFFICIENT                       0xFFFF00FF
#define   S_00B2C4_PER_TYPE_WAVE_COUNT_COEFFICIENT(x)                 (((unsigned)(x) & 0xFF) << 16)
#define   G_00B2C4_PER_TYPE_WAVE_COUNT_COEFFICIENT(x)                 (((x) >> 16) & 0xFF)
#define   C_00B2C4_PER_TYPE_WAVE_COUNT_COEFFICIENT                    0xFF00FFFF
#define R_00B2C8_SPI_SHADER_USER_ACCUM_ESGS_0                           0x00B2C8 /* >= gfx10 */
#define   S_00B2C8_CONTRIBUTION(x)                                    (((unsigned)(x) & 0x7F) << 0)
#define   G_00B2C8_CONTRIBUTION(x)                                    (((x) >> 0) & 0x7F)
#define   C_00B2C8_CONTRIBUTION                                       0xFFFFFF80
#define R_00B2CC_SPI_SHADER_USER_ACCUM_ESGS_1                           0x00B2CC /* >= gfx10 */
#define R_00B2D0_SPI_SHADER_USER_ACCUM_ESGS_2                           0x00B2D0 /* >= gfx10 */
#define R_00B2D4_SPI_SHADER_USER_ACCUM_ESGS_3                           0x00B2D4 /* >= gfx10 */
#define R_00B2F0_SPI_SHADER_PGM_RSRC2_ES_GS                             0x00B2F0 /* gfx7, gfx8, gfx81, gfx10 */
#define   S_00B2F0_SCRATCH_EN(x)                                      (((unsigned)(x) & 0x1) << 0)
#define   G_00B2F0_SCRATCH_EN(x)                                      (((x) >> 0) & 0x1)
#define   C_00B2F0_SCRATCH_EN                                         0xFFFFFFFE
#define   S_00B2F0_USER_SGPR(x)                                       (((unsigned)(x) & 0x1F) << 1)
#define   G_00B2F0_USER_SGPR(x)                                       (((x) >> 1) & 0x1F)
#define   C_00B2F0_USER_SGPR                                          0xFFFFFFC1
#define   S_00B2F0_TRAP_PRESENT(x)                                    (((unsigned)(x) & 0x1) << 6)
#define   G_00B2F0_TRAP_PRESENT(x)                                    (((x) >> 6) & 0x1)
#define   C_00B2F0_TRAP_PRESENT                                       0xFFFFFFBF
#define   S_00B2F0_OC_LDS_EN(x)                                       (((unsigned)(x) & 0x1) << 7)
#define   G_00B2F0_OC_LDS_EN(x)                                       (((x) >> 7) & 0x1)
#define   C_00B2F0_OC_LDS_EN                                          0xFFFFFF7F
#define   S_00B2F0_EXCP_EN(x)                                         (((unsigned)(x) & 0x1FF) << 8)
#define   G_00B2F0_EXCP_EN(x)                                         (((x) >> 8) & 0x1FF)
#define   C_00B2F0_EXCP_EN                                            0xFFFE00FF
#define     V_00B2F0_INVALID                                        1
#define     V_00B2F0_INPUT_DENORMAL                                 2
#define     V_00B2F0_DIVIDE_BY_ZERO                                 4
#define     V_00B2F0_OVERFLOW                                       8
#define     V_00B2F0_UNDERFLOW                                      16
#define     V_00B2F0_INEXACT                                        32
#define     V_00B2F0_INT_DIVIDE_BY_ZERO                             64
#define     V_00B2F0_ADDRESS_WATCH                                  128
#define     V_00B2F0_MEMORY_VIOLATION                               256
#define   S_00B2F0_LDS_SIZE(x)                                        (((unsigned)(x) & 0x1FF) << 20)
#define   G_00B2F0_LDS_SIZE(x)                                        (((x) >> 20) & 0x1FF)
#define   C_00B2F0_LDS_SIZE                                           0xE00FFFFF
#define R_00B300_SPI_SHADER_TBA_LO_ES                                   0x00B300 /* <= gfx81 */
#define R_00B304_SPI_SHADER_TBA_HI_ES                                   0x00B304 /* <= gfx81 */
#define   S_00B304_MEM_BASE(x)                                        (((unsigned)(x) & 0xFF) << 0)
#define   G_00B304_MEM_BASE(x)                                        (((x) >> 0) & 0xFF)
#define   C_00B304_MEM_BASE                                           0xFFFFFF00
#define R_00B308_SPI_SHADER_TMA_LO_ES                                   0x00B308 /* <= gfx81 */
#define R_00B30C_SPI_SHADER_TMA_HI_ES                                   0x00B30C /* <= gfx81 */
#define   S_00B30C_MEM_BASE(x)                                        (((unsigned)(x) & 0xFF) << 0)
#define   G_00B30C_MEM_BASE(x)                                        (((x) >> 0) & 0xFF)
#define   C_00B30C_MEM_BASE                                           0xFFFFFF00
#define R_00B31C_SPI_SHADER_PGM_RSRC3_ES                                0x00B31C /* gfx7, gfx8, gfx81, gfx10 */
#define   S_00B31C_CU_EN(x)                                           (((unsigned)(x) & 0xFFFF) << 0)
#define   G_00B31C_CU_EN(x)                                           (((x) >> 0) & 0xFFFF)
#define   C_00B31C_CU_EN                                              0xFFFF0000
#define   S_00B31C_WAVE_LIMIT(x)                                      (((unsigned)(x) & 0x3F) << 16)
#define   G_00B31C_WAVE_LIMIT(x)                                      (((x) >> 16) & 0x3F)
#define   C_00B31C_WAVE_LIMIT                                         0xFFC0FFFF
#define   S_00B31C_LOCK_LOW_THRESHOLD(x)                              (((unsigned)(x) & 0xF) << 22)
#define   G_00B31C_LOCK_LOW_THRESHOLD(x)                              (((x) >> 22) & 0xF)
#define   C_00B31C_LOCK_LOW_THRESHOLD                                 0xFC3FFFFF
#define   S_00B31C_GROUP_FIFO_DEPTH(x)                                (((unsigned)(x) & 0x3F) << 26) /* gfx8, gfx81, gfx10 */
#define   G_00B31C_GROUP_FIFO_DEPTH(x)                                (((x) >> 26) & 0x3F)
#define   C_00B31C_GROUP_FIFO_DEPTH                                   0x03FFFFFF
#define R_00B320_SPI_SHADER_PGM_LO_ES                                   0x00B320 /* <= gfx81, >= gfx10 */
#define R_00B324_SPI_SHADER_PGM_HI_ES                                   0x00B324 /* <= gfx81, >= gfx10 */
#define   S_00B324_MEM_BASE(x)                                        (((unsigned)(x) & 0xFF) << 0)
#define   G_00B324_MEM_BASE(x)                                        (((x) >> 0) & 0xFF)
#define   C_00B324_MEM_BASE                                           0xFFFFFF00
#define R_00B328_SPI_SHADER_PGM_RSRC1_ES                                0x00B328 /* <= gfx81, gfx10 */
#define   S_00B328_VGPRS(x)                                           (((unsigned)(x) & 0x3F) << 0)
#define   G_00B328_VGPRS(x)                                           (((x) >> 0) & 0x3F)
#define   C_00B328_VGPRS                                              0xFFFFFFC0
#define   S_00B328_SGPRS(x)                                           (((unsigned)(x) & 0xF) << 6)
#define   G_00B328_SGPRS(x)                                           (((x) >> 6) & 0xF)
#define   C_00B328_SGPRS                                              0xFFFFFC3F
#define   S_00B328_PRIORITY(x)                                        (((unsigned)(x) & 0x3) << 10)
#define   G_00B328_PRIORITY(x)                                        (((x) >> 10) & 0x3)
#define   C_00B328_PRIORITY                                           0xFFFFF3FF
#define   S_00B328_FLOAT_MODE(x)                                      (((unsigned)(x) & 0xFF) << 12)
#define   G_00B328_FLOAT_MODE(x)                                      (((x) >> 12) & 0xFF)
#define   C_00B328_FLOAT_MODE                                         0xFFF00FFF
#define     V_00B328_FP_32_DENORMS                                  48
#define     V_00B328_FP_64_DENORMS                                  192
#define     V_00B328_FP_ALL_DENORMS                                 240
#define   S_00B328_PRIV(x)                                            (((unsigned)(x) & 0x1) << 20)
#define   G_00B328_PRIV(x)                                            (((x) >> 20) & 0x1)
#define   C_00B328_PRIV                                               0xFFEFFFFF
#define   S_00B328_DX10_CLAMP(x)                                      (((unsigned)(x) & 0x1) << 21)
#define   G_00B328_DX10_CLAMP(x)                                      (((x) >> 21) & 0x1)
#define   C_00B328_DX10_CLAMP                                         0xFFDFFFFF
#define   S_00B328_DEBUG_MODE(x)                                      (((unsigned)(x) & 0x1) << 22) /* <= gfx81 */
#define   G_00B328_DEBUG_MODE(x)                                      (((x) >> 22) & 0x1)
#define   C_00B328_DEBUG_MODE                                         0xFFBFFFFF
#define   S_00B328_IEEE_MODE(x)                                       (((unsigned)(x) & 0x1) << 23)
#define   G_00B328_IEEE_MODE(x)                                       (((x) >> 23) & 0x1)
#define   C_00B328_IEEE_MODE                                          0xFF7FFFFF
#define   S_00B328_VGPR_COMP_CNT(x)                                   (((unsigned)(x) & 0x3) << 24)
#define   G_00B328_VGPR_COMP_CNT(x)                                   (((x) >> 24) & 0x3)
#define   C_00B328_VGPR_COMP_CNT                                      0xFCFFFFFF
#define   S_00B328_CU_GROUP_ENABLE(x)                                 (((unsigned)(x) & 0x1) << 26)
#define   G_00B328_CU_GROUP_ENABLE(x)                                 (((x) >> 26) & 0x1)
#define   C_00B328_CU_GROUP_ENABLE                                    0xFBFFFFFF
#define   S_00B328_CACHE_CTL(x)                                       (((unsigned)(x) & 0x7) << 27) /* <= gfx81 */
#define   G_00B328_CACHE_CTL(x)                                       (((x) >> 27) & 0x7)
#define   C_00B328_CACHE_CTL                                          0xC7FFFFFF
#define   S_00B328_CDBG_USER(x)                                       (((unsigned)(x) & 0x1) << 30) /* <= gfx81 */
#define   G_00B328_CDBG_USER(x)                                       (((x) >> 30) & 0x1)
#define   C_00B328_CDBG_USER                                          0xBFFFFFFF
#define   S_00B328_FP16_OVFL(x)                                       (((unsigned)(x) & 0x1) << 31) /* gfx10 */
#define   G_00B328_FP16_OVFL(x)                                       (((x) >> 31) & 0x1)
#define   C_00B328_FP16_OVFL                                          0x7FFFFFFF
#define R_00B32C_SPI_SHADER_PGM_RSRC2_ES                                0x00B32C /* <= gfx81, gfx10 */
#define   S_00B32C_SCRATCH_EN(x)                                      (((unsigned)(x) & 0x1) << 0)
#define   G_00B32C_SCRATCH_EN(x)                                      (((x) >> 0) & 0x1)
#define   C_00B32C_SCRATCH_EN                                         0xFFFFFFFE
#define   S_00B32C_USER_SGPR(x)                                       (((unsigned)(x) & 0x1F) << 1)
#define   G_00B32C_USER_SGPR(x)                                       (((x) >> 1) & 0x1F)
#define   C_00B32C_USER_SGPR                                          0xFFFFFFC1
#define   S_00B32C_TRAP_PRESENT(x)                                    (((unsigned)(x) & 0x1) << 6)
#define   G_00B32C_TRAP_PRESENT(x)                                    (((x) >> 6) & 0x1)
#define   C_00B32C_TRAP_PRESENT                                       0xFFFFFFBF
#define   S_00B32C_OC_LDS_EN(x)                                       (((unsigned)(x) & 0x1) << 7)
#define   G_00B32C_OC_LDS_EN(x)                                       (((x) >> 7) & 0x1)
#define   C_00B32C_OC_LDS_EN                                          0xFFFFFF7F
#define   S_00B32C_EXCP_EN(x)                                         (((unsigned)(x) & 0x1FF) << 8)
#define   G_00B32C_EXCP_EN(x)                                         (((x) >> 8) & 0x1FF)
#define   C_00B32C_EXCP_EN                                            0xFFFE00FF
#define     V_00B32C_INVALID                                        1
#define     V_00B32C_INPUT_DENORMAL                                 2
#define     V_00B32C_DIVIDE_BY_ZERO                                 4
#define     V_00B32C_OVERFLOW                                       8
#define     V_00B32C_UNDERFLOW                                      16
#define     V_00B32C_INEXACT                                        32
#define     V_00B32C_INT_DIVIDE_BY_ZERO                             64
#define     V_00B32C_ADDRESS_WATCH                                  128
#define     V_00B32C_MEMORY_VIOLATION                               256
#define   S_00B32C_LDS_SIZE(x)                                        (((unsigned)(x) & 0x1FF) << 20)
#define   G_00B32C_LDS_SIZE(x)                                        (((x) >> 20) & 0x1FF)
#define   C_00B32C_LDS_SIZE                                           0xE00FFFFF
#define R_00B330_SPI_SHADER_USER_DATA_ES_0                              0x00B330 /* <= gfx10 */
#define R_00B334_SPI_SHADER_USER_DATA_ES_1                              0x00B334 /* <= gfx10 */
#define R_00B338_SPI_SHADER_USER_DATA_ES_2                              0x00B338 /* <= gfx10 */
#define R_00B33C_SPI_SHADER_USER_DATA_ES_3                              0x00B33C /* <= gfx10 */
#define R_00B340_SPI_SHADER_USER_DATA_ES_4                              0x00B340 /* <= gfx10 */
#define R_00B344_SPI_SHADER_USER_DATA_ES_5                              0x00B344 /* <= gfx10 */
#define R_00B348_SPI_SHADER_USER_DATA_ES_6                              0x00B348 /* <= gfx10 */
#define R_00B34C_SPI_SHADER_USER_DATA_ES_7                              0x00B34C /* <= gfx10 */
#define R_00B350_SPI_SHADER_USER_DATA_ES_8                              0x00B350 /* <= gfx10 */
#define R_00B354_SPI_SHADER_USER_DATA_ES_9                              0x00B354 /* <= gfx10 */
#define R_00B358_SPI_SHADER_USER_DATA_ES_10                             0x00B358 /* <= gfx10 */
#define R_00B35C_SPI_SHADER_USER_DATA_ES_11                             0x00B35C /* <= gfx10 */
#define R_00B360_SPI_SHADER_USER_DATA_ES_12                             0x00B360 /* <= gfx10 */
#define R_00B364_SPI_SHADER_USER_DATA_ES_13                             0x00B364 /* <= gfx10 */
#define R_00B368_SPI_SHADER_USER_DATA_ES_14                             0x00B368 /* <= gfx10 */
#define R_00B36C_SPI_SHADER_USER_DATA_ES_15                             0x00B36C /* <= gfx10 */
#define R_00B370_SPI_SHADER_USER_DATA_ES_16                             0x00B370 /* gfx9 */
#define R_00B374_SPI_SHADER_USER_DATA_ES_17                             0x00B374 /* gfx9 */
#define R_00B378_SPI_SHADER_USER_DATA_ES_18                             0x00B378 /* gfx9 */
#define R_00B37C_SPI_SHADER_USER_DATA_ES_19                             0x00B37C /* gfx9 */
#define R_00B380_SPI_SHADER_USER_DATA_ES_20                             0x00B380 /* gfx9 */
#define R_00B384_SPI_SHADER_USER_DATA_ES_21                             0x00B384 /* gfx9 */
#define R_00B388_SPI_SHADER_USER_DATA_ES_22                             0x00B388 /* gfx9 */
#define R_00B38C_SPI_SHADER_USER_DATA_ES_23                             0x00B38C /* gfx9 */
#define R_00B390_SPI_SHADER_USER_DATA_ES_24                             0x00B390 /* gfx9 */
#define R_00B394_SPI_SHADER_USER_DATA_ES_25                             0x00B394 /* gfx9 */
#define R_00B398_SPI_SHADER_USER_DATA_ES_26                             0x00B398 /* gfx9 */
#define R_00B39C_SPI_SHADER_USER_DATA_ES_27                             0x00B39C /* gfx9 */
#define R_00B3A0_SPI_SHADER_USER_DATA_ES_28                             0x00B3A0 /* gfx9 */
#define R_00B3A4_SPI_SHADER_USER_DATA_ES_29                             0x00B3A4 /* gfx9 */
#define R_00B3A8_SPI_SHADER_USER_DATA_ES_30                             0x00B3A8 /* gfx9 */
#define R_00B3AC_SPI_SHADER_USER_DATA_ES_31                             0x00B3AC /* gfx9 */
#define R_00B3F4_SPI_SHADER_PGM_RSRC2_LS_ES                             0x00B3F4 /* gfx7, gfx8, gfx81, gfx10 */
#define   S_00B3F4_SCRATCH_EN(x)                                      (((unsigned)(x) & 0x1) << 0)
#define   G_00B3F4_SCRATCH_EN(x)                                      (((x) >> 0) & 0x1)
#define   C_00B3F4_SCRATCH_EN                                         0xFFFFFFFE
#define   S_00B3F4_USER_SGPR(x)                                       (((unsigned)(x) & 0x1F) << 1)
#define   G_00B3F4_USER_SGPR(x)                                       (((x) >> 1) & 0x1F)
#define   C_00B3F4_USER_SGPR                                          0xFFFFFFC1
#define   S_00B3F4_TRAP_PRESENT(x)                                    (((unsigned)(x) & 0x1) << 6)
#define   G_00B3F4_TRAP_PRESENT(x)                                    (((x) >> 6) & 0x1)
#define   C_00B3F4_TRAP_PRESENT                                       0xFFFFFFBF
#define   S_00B3F4_LDS_SIZE(x)                                        (((unsigned)(x) & 0x1FF) << 7)
#define   G_00B3F4_LDS_SIZE(x)                                        (((x) >> 7) & 0x1FF)
#define   C_00B3F4_LDS_SIZE                                           0xFFFF007F
#define   S_00B3F4_EXCP_EN(x)                                         (((unsigned)(x) & 0x1FF) << 16)
#define   G_00B3F4_EXCP_EN(x)                                         (((x) >> 16) & 0x1FF)
#define   C_00B3F4_EXCP_EN                                            0xFE00FFFF
#define     V_00B3F4_INVALID                                        1
#define     V_00B3F4_INPUT_DENORMAL                                 2
#define     V_00B3F4_DIVIDE_BY_ZERO                                 4
#define     V_00B3F4_OVERFLOW                                       8
#define     V_00B3F4_UNDERFLOW                                      16
#define     V_00B3F4_INEXACT                                        32
#define     V_00B3F4_INT_DIVIDE_BY_ZERO                             64
#define     V_00B3F4_ADDRESS_WATCH                                  128
#define     V_00B3F4_MEMORY_VIOLATION                               256
#define R_00B400_SPI_SHADER_PGM_CHKSUM_HS                               0x00B400 /* >= gfx10 */
#define R_00B400_SPI_SHADER_TBA_LO_HS                                   0x00B400 /* <= gfx81 */
#define R_00B404_SPI_SHADER_PGM_RSRC4_HS                                0x00B404 /* >= gfx9 */
#define   S_00B404_CU_EN(x)                                           (((unsigned)(x) & 0xFFFF) << 0) /* >= gfx10 */
#define   G_00B404_CU_EN(x)                                           (((x) >> 0) & 0xFFFF)
#define   C_00B404_CU_EN                                              0xFFFF0000
#define   S_00B404_GROUP_FIFO_DEPTH(x)                                (((unsigned)(x) & 0x7F) << 0) /* gfx9 */
#define   G_00B404_GROUP_FIFO_DEPTH(x)                                (((x) >> 0) & 0x7F)
#define   C_00B404_GROUP_FIFO_DEPTH                                   0xFFFFFF80
#define R_00B404_SPI_SHADER_TBA_HI_HS                                   0x00B404 /* <= gfx81 */
#define   S_00B404_MEM_BASE(x)                                        (((unsigned)(x) & 0xFF) << 0)
#define   G_00B404_MEM_BASE(x)                                        (((x) >> 0) & 0xFF)
#define   C_00B404_MEM_BASE                                           0xFFFFFF00
#define R_00B408_SPI_SHADER_TMA_LO_HS                                   0x00B408 /* <= gfx81 */
#define R_00B408_SPI_SHADER_USER_DATA_ADDR_LO_HS                        0x00B408 /* >= gfx9 */
#define R_00B40C_SPI_SHADER_TMA_HI_HS                                   0x00B40C /* <= gfx81 */
#define   S_00B40C_MEM_BASE(x)                                        (((unsigned)(x) & 0xFF) << 0)
#define   G_00B40C_MEM_BASE(x)                                        (((x) >> 0) & 0xFF)
#define   C_00B40C_MEM_BASE                                           0xFFFFFF00
#define R_00B40C_SPI_SHADER_USER_DATA_ADDR_HI_HS                        0x00B40C /* >= gfx9 */
#define R_00B410_SPI_SHADER_PGM_LO_LS                                   0x00B410 /* gfx9 */
#define R_00B410_SPI_SHADER_PGM_LO_LS_HS                                0x00B410 /* >= gfx10 */
#define R_00B414_SPI_SHADER_PGM_HI_LS                                   0x00B414 /* gfx9 */
#define   S_00B414_MEM_BASE(x)                                        (((unsigned)(x) & 0xFF) << 0)
#define   G_00B414_MEM_BASE(x)                                        (((x) >> 0) & 0xFF)
#define   C_00B414_MEM_BASE                                           0xFFFFFF00
#define R_00B414_SPI_SHADER_PGM_HI_LS_HS                                0x00B414 /* >= gfx10 */
#define R_00B41C_SPI_SHADER_PGM_RSRC3_HS                                0x00B41C /* >= gfx7 */
#define   S_00B41C_WAVE_LIMIT(x)                                      (((unsigned)(x) & 0x3F) << 0)
#define   G_00B41C_WAVE_LIMIT(x)                                      (((x) >> 0) & 0x3F)
#define   C_00B41C_WAVE_LIMIT                                         0xFFFFFFC0
#define   S_00B41C_LOCK_LOW_THRESHOLD(x)                              (((unsigned)(x) & 0xF) << 6)
#define   G_00B41C_LOCK_LOW_THRESHOLD(x)                              (((x) >> 6) & 0xF)
#define   C_00B41C_LOCK_LOW_THRESHOLD                                 0xFFFFFC3F
#define   S_00B41C_GROUP_FIFO_DEPTH(x)                                (((unsigned)(x) & 0x3F) << 10) /* gfx8, gfx81, >= gfx10 */
#define   G_00B41C_GROUP_FIFO_DEPTH(x)                                (((x) >> 10) & 0x3F)
#define   C_00B41C_GROUP_FIFO_DEPTH                                   0xFFFF03FF
#define   S_00B41C_SIMD_DISABLE(x)                                    (((unsigned)(x) & 0xF) << 10) /* gfx9 */
#define   G_00B41C_SIMD_DISABLE(x)                                    (((x) >> 10) & 0xF)
#define   C_00B41C_SIMD_DISABLE                                       0xFFFFC3FF
#define   S_00B41C_CU_EN(x)                                           (((unsigned)(x) & 0xFFFF) << 16) /* >= gfx9 */
#define   G_00B41C_CU_EN(x)                                           (((x) >> 16) & 0xFFFF)
#define   C_00B41C_CU_EN                                              0x0000FFFF
#define R_00B420_SPI_SHADER_PGM_LO_HS                                   0x00B420
#define R_00B424_SPI_SHADER_PGM_HI_HS                                   0x00B424
#define   S_00B424_MEM_BASE(x)                                        (((unsigned)(x) & 0xFF) << 0)
#define   G_00B424_MEM_BASE(x)                                        (((x) >> 0) & 0xFF)
#define   C_00B424_MEM_BASE                                           0xFFFFFF00
#define R_00B428_SPI_SHADER_PGM_RSRC1_HS                                0x00B428
#define   S_00B428_VGPRS(x)                                           (((unsigned)(x) & 0x3F) << 0)
#define   G_00B428_VGPRS(x)                                           (((x) >> 0) & 0x3F)
#define   C_00B428_VGPRS                                              0xFFFFFFC0
#define   S_00B428_SGPRS(x)                                           (((unsigned)(x) & 0xF) << 6)
#define   G_00B428_SGPRS(x)                                           (((x) >> 6) & 0xF)
#define   C_00B428_SGPRS                                              0xFFFFFC3F
#define   S_00B428_PRIORITY(x)                                        (((unsigned)(x) & 0x3) << 10)
#define   G_00B428_PRIORITY(x)                                        (((x) >> 10) & 0x3)
#define   C_00B428_PRIORITY                                           0xFFFFF3FF
#define   S_00B428_FLOAT_MODE(x)                                      (((unsigned)(x) & 0xFF) << 12)
#define   G_00B428_FLOAT_MODE(x)                                      (((x) >> 12) & 0xFF)
#define   C_00B428_FLOAT_MODE                                         0xFFF00FFF
#define     V_00B428_FP_32_DENORMS                                  48
#define     V_00B428_FP_64_DENORMS                                  192
#define     V_00B428_FP_ALL_DENORMS                                 240
#define   S_00B428_PRIV(x)                                            (((unsigned)(x) & 0x1) << 20)
#define   G_00B428_PRIV(x)                                            (((x) >> 20) & 0x1)
#define   C_00B428_PRIV                                               0xFFEFFFFF
#define   S_00B428_DX10_CLAMP(x)                                      (((unsigned)(x) & 0x1) << 21)
#define   G_00B428_DX10_CLAMP(x)                                      (((x) >> 21) & 0x1)
#define   C_00B428_DX10_CLAMP                                         0xFFDFFFFF
#define   S_00B428_DEBUG_MODE(x)                                      (((unsigned)(x) & 0x1) << 22) /* <= gfx9 */
#define   G_00B428_DEBUG_MODE(x)                                      (((x) >> 22) & 0x1)
#define   C_00B428_DEBUG_MODE                                         0xFFBFFFFF
#define   S_00B428_IEEE_MODE(x)                                       (((unsigned)(x) & 0x1) << 23)
#define   G_00B428_IEEE_MODE(x)                                       (((x) >> 23) & 0x1)
#define   C_00B428_IEEE_MODE                                          0xFF7FFFFF
#define   S_00B428_CACHE_CTL(x)                                       (((unsigned)(x) & 0x7) << 24) /* <= gfx81 */
#define   G_00B428_CACHE_CTL(x)                                       (((x) >> 24) & 0x7)
#define   C_00B428_CACHE_CTL                                          0xF8FFFFFF
#define   S_00B428_MEM_ORDERED(x)                                     (((unsigned)(x) & 0x1) << 24) /* >= gfx10 */
#define   G_00B428_MEM_ORDERED(x)                                     (((x) >> 24) & 0x1)
#define   C_00B428_MEM_ORDERED                                        0xFEFFFFFF
#define   S_00B428_FWD_PROGRESS(x)                                    (((unsigned)(x) & 0x1) << 25) /* >= gfx10 */
#define   G_00B428_FWD_PROGRESS(x)                                    (((x) >> 25) & 0x1)
#define   C_00B428_FWD_PROGRESS                                       0xFDFFFFFF
#define   S_00B428_WGP_MODE(x)                                        (((unsigned)(x) & 0x1) << 26) /* >= gfx10 */
#define   G_00B428_WGP_MODE(x)                                        (((x) >> 26) & 0x1)
#define   C_00B428_WGP_MODE                                           0xFBFFFFFF
#define   S_00B428_CDBG_USER(x)                                       (((unsigned)(x) & 0x1) << 27) /* <= gfx9 */
#define   G_00B428_CDBG_USER(x)                                       (((x) >> 27) & 0x1)
#define   C_00B428_CDBG_USER                                          0xF7FFFFFF
#define   S_00B428_LS_VGPR_COMP_CNT(x)                                (((unsigned)(x) & 0x3) << 28) /* >= gfx9 */
#define   G_00B428_LS_VGPR_COMP_CNT(x)                                (((x) >> 28) & 0x3)
#define   C_00B428_LS_VGPR_COMP_CNT                                   0xCFFFFFFF
#define   S_00B428_FP16_OVFL(x)                                       (((unsigned)(x) & 0x1) << 30) /* >= gfx9 */
#define   G_00B428_FP16_OVFL(x)                                       (((x) >> 30) & 0x1)
#define   C_00B428_FP16_OVFL                                          0xBFFFFFFF
#define R_00B42C_SPI_SHADER_PGM_RSRC2_HS                                0x00B42C
#define   S_00B42C_SCRATCH_EN(x)                                      (((unsigned)(x) & 0x1) << 0)
#define   G_00B42C_SCRATCH_EN(x)                                      (((x) >> 0) & 0x1)
#define   C_00B42C_SCRATCH_EN                                         0xFFFFFFFE
#define   S_00B42C_USER_SGPR(x)                                       (((unsigned)(x) & 0x1F) << 1)
#define   G_00B42C_USER_SGPR(x)                                       (((x) >> 1) & 0x1F)
#define   C_00B42C_USER_SGPR                                          0xFFFFFFC1
#define   S_00B42C_TRAP_PRESENT(x)                                    (((unsigned)(x) & 0x1) << 6)
#define   G_00B42C_TRAP_PRESENT(x)                                    (((x) >> 6) & 0x1)
#define   C_00B42C_TRAP_PRESENT                                       0xFFFFFFBF
#define   S_00B42C_EXCP_EN_GFX9(x)                                    (((unsigned)(x) & 0x1FF) << 7) /* gfx9 */
#define   G_00B42C_EXCP_EN_GFX9(x)                                    (((x) >> 7) & 0x1FF)
#define   C_00B42C_EXCP_EN_GFX9                                       0xFFFF007F
#define     V_00B42C_INVALID                                        1
#define     V_00B42C_INPUT_DENORMAL                                 2
#define     V_00B42C_DIVIDE_BY_ZERO                                 4
#define     V_00B42C_OVERFLOW                                       8
#define     V_00B42C_UNDERFLOW                                      16
#define     V_00B42C_INEXACT                                        32
#define     V_00B42C_INT_DIVIDE_BY_ZERO                             64
#define     V_00B42C_ADDRESS_WATCH                                  128
#define     V_00B42C_MEMORY_VIOLATION                               256
#define   S_00B42C_OC_LDS_EN(x)                                       (((unsigned)(x) & 0x1) << 7) /* <= gfx81, >= gfx10 */
#define   G_00B42C_OC_LDS_EN(x)                                       (((x) >> 7) & 0x1)
#define   C_00B42C_OC_LDS_EN                                          0xFFFFFF7F
#define   S_00B42C_TG_SIZE_EN(x)                                      (((unsigned)(x) & 0x1) << 8) /* <= gfx81, >= gfx10 */
#define   G_00B42C_TG_SIZE_EN(x)                                      (((x) >> 8) & 0x1)
#define   C_00B42C_TG_SIZE_EN                                         0xFFFFFEFF
#define   S_00B42C_EXCP_EN_GFX6(x)                                    (((unsigned)(x) & 0x1FF) << 9) /* <= gfx81, >= gfx10 */
#define   G_00B42C_EXCP_EN_GFX6(x)                                    (((x) >> 9) & 0x1FF)
#define   C_00B42C_EXCP_EN_GFX6                                       0xFFFC01FF
#define   S_00B42C_LDS_SIZE_GFX9(x)                                   (((unsigned)(x) & 0x1FF) << 16) /* gfx9 */
#define   G_00B42C_LDS_SIZE_GFX9(x)                                   (((x) >> 16) & 0x1FF)
#define   C_00B42C_LDS_SIZE_GFX9                                      0xFE00FFFF
#define   S_00B42C_LDS_SIZE_GFX10(x)                                  (((unsigned)(x) & 0x1FF) << 18) /* >= gfx10 */
#define   G_00B42C_LDS_SIZE_GFX10(x)                                  (((x) >> 18) & 0x1FF)
#define   C_00B42C_LDS_SIZE_GFX10                                     0xF803FFFF
#define   S_00B42C_SKIP_USGPR0(x)                                     (((unsigned)(x) & 0x1) << 27) /* gfx9 */
#define   G_00B42C_SKIP_USGPR0(x)                                     (((x) >> 27) & 0x1)
#define   C_00B42C_SKIP_USGPR0                                        0xF7FFFFFF
#define   S_00B42C_USER_SGPR_MSB_GFX10(x)                             (((unsigned)(x) & 0x1) << 27) /* >= gfx10 */
#define   G_00B42C_USER_SGPR_MSB_GFX10(x)                             (((x) >> 27) & 0x1)
#define   C_00B42C_USER_SGPR_MSB_GFX10                                0xF7FFFFFF
#define   S_00B42C_SHARED_VGPR_CNT(x)                                 (((unsigned)(x) & 0xF) << 28) /* >= gfx10 */
#define   G_00B42C_SHARED_VGPR_CNT(x)                                 (((x) >> 28) & 0xF)
#define   C_00B42C_SHARED_VGPR_CNT                                    0x0FFFFFFF
#define   S_00B42C_USER_SGPR_MSB_GFX9(x)                              (((unsigned)(x) & 0x1) << 28) /* gfx9 */
#define   G_00B42C_USER_SGPR_MSB_GFX9(x)                              (((x) >> 28) & 0x1)
#define   C_00B42C_USER_SGPR_MSB_GFX9                                 0xEFFFFFFF
#define R_00B430_SPI_SHADER_USER_DATA_HS_0                              0x00B430 /* <= gfx81, >= gfx10 */
#define R_00B430_SPI_SHADER_USER_DATA_LS_0                              0x00B430 /* gfx9 */
#define R_00B434_SPI_SHADER_USER_DATA_HS_1                              0x00B434 /* <= gfx81, >= gfx10 */
#define R_00B434_SPI_SHADER_USER_DATA_LS_1                              0x00B434 /* gfx9 */
#define R_00B438_SPI_SHADER_USER_DATA_HS_2                              0x00B438 /* <= gfx81, >= gfx10 */
#define R_00B438_SPI_SHADER_USER_DATA_LS_2                              0x00B438 /* gfx9 */
#define R_00B43C_SPI_SHADER_USER_DATA_HS_3                              0x00B43C /* <= gfx81, >= gfx10 */
#define R_00B43C_SPI_SHADER_USER_DATA_LS_3                              0x00B43C /* gfx9 */
#define R_00B440_SPI_SHADER_USER_DATA_HS_4                              0x00B440 /* <= gfx81, >= gfx10 */
#define R_00B440_SPI_SHADER_USER_DATA_LS_4                              0x00B440 /* gfx9 */
#define R_00B444_SPI_SHADER_USER_DATA_HS_5                              0x00B444 /* <= gfx81, >= gfx10 */
#define R_00B444_SPI_SHADER_USER_DATA_LS_5                              0x00B444 /* gfx9 */
#define R_00B448_SPI_SHADER_USER_DATA_HS_6                              0x00B448 /* <= gfx81, >= gfx10 */
#define R_00B448_SPI_SHADER_USER_DATA_LS_6                              0x00B448 /* gfx9 */
#define R_00B44C_SPI_SHADER_USER_DATA_HS_7                              0x00B44C /* <= gfx81, >= gfx10 */
#define R_00B44C_SPI_SHADER_USER_DATA_LS_7                              0x00B44C /* gfx9 */
#define R_00B450_SPI_SHADER_USER_DATA_HS_8                              0x00B450 /* <= gfx81, >= gfx10 */
#define R_00B450_SPI_SHADER_USER_DATA_LS_8                              0x00B450 /* gfx9 */
#define R_00B454_SPI_SHADER_USER_DATA_HS_9                              0x00B454 /* <= gfx81, >= gfx10 */
#define R_00B454_SPI_SHADER_USER_DATA_LS_9                              0x00B454 /* gfx9 */
#define R_00B458_SPI_SHADER_USER_DATA_HS_10                             0x00B458 /* <= gfx81, >= gfx10 */
#define R_00B458_SPI_SHADER_USER_DATA_LS_10                             0x00B458 /* gfx9 */
#define R_00B45C_SPI_SHADER_USER_DATA_HS_11                             0x00B45C /* <= gfx81, >= gfx10 */
#define R_00B45C_SPI_SHADER_USER_DATA_LS_11                             0x00B45C /* gfx9 */
#define R_00B460_SPI_SHADER_USER_DATA_HS_12                             0x00B460 /* <= gfx81, >= gfx10 */
#define R_00B460_SPI_SHADER_USER_DATA_LS_12                             0x00B460 /* gfx9 */
#define R_00B464_SPI_SHADER_USER_DATA_HS_13                             0x00B464 /* <= gfx81, >= gfx10 */
#define R_00B464_SPI_SHADER_USER_DATA_LS_13                             0x00B464 /* gfx9 */
#define R_00B468_SPI_SHADER_USER_DATA_HS_14                             0x00B468 /* <= gfx81, >= gfx10 */
#define R_00B468_SPI_SHADER_USER_DATA_LS_14                             0x00B468 /* gfx9 */
#define R_00B46C_SPI_SHADER_USER_DATA_HS_15                             0x00B46C /* <= gfx81, >= gfx10 */
#define R_00B46C_SPI_SHADER_USER_DATA_LS_15                             0x00B46C /* gfx9 */
#define R_00B470_SPI_SHADER_USER_DATA_HS_16                             0x00B470 /* >= gfx10 */
#define R_00B470_SPI_SHADER_USER_DATA_LS_16                             0x00B470 /* gfx9 */
#define R_00B474_SPI_SHADER_USER_DATA_HS_17                             0x00B474 /* >= gfx10 */
#define R_00B474_SPI_SHADER_USER_DATA_LS_17                             0x00B474 /* gfx9 */
#define R_00B478_SPI_SHADER_USER_DATA_HS_18                             0x00B478 /* >= gfx10 */
#define R_00B478_SPI_SHADER_USER_DATA_LS_18                             0x00B478 /* gfx9 */
#define R_00B47C_SPI_SHADER_USER_DATA_HS_19                             0x00B47C /* >= gfx10 */
#define R_00B47C_SPI_SHADER_USER_DATA_LS_19                             0x00B47C /* gfx9 */
#define R_00B480_SPI_SHADER_USER_DATA_HS_20                             0x00B480 /* >= gfx10 */
#define R_00B480_SPI_SHADER_USER_DATA_LS_20                             0x00B480 /* gfx9 */
#define R_00B484_SPI_SHADER_USER_DATA_HS_21                             0x00B484 /* >= gfx10 */
#define R_00B484_SPI_SHADER_USER_DATA_LS_21                             0x00B484 /* gfx9 */
#define R_00B488_SPI_SHADER_USER_DATA_HS_22                             0x00B488 /* >= gfx10 */
#define R_00B488_SPI_SHADER_USER_DATA_LS_22                             0x00B488 /* gfx9 */
#define R_00B48C_SPI_SHADER_USER_DATA_HS_23                             0x00B48C /* >= gfx10 */
#define R_00B48C_SPI_SHADER_USER_DATA_LS_23                             0x00B48C /* gfx9 */
#define R_00B490_SPI_SHADER_USER_DATA_HS_24                             0x00B490 /* >= gfx10 */
#define R_00B490_SPI_SHADER_USER_DATA_LS_24                             0x00B490 /* gfx9 */
#define R_00B494_SPI_SHADER_USER_DATA_HS_25                             0x00B494 /* >= gfx10 */
#define R_00B494_SPI_SHADER_USER_DATA_LS_25                             0x00B494 /* gfx9 */
#define R_00B498_SPI_SHADER_USER_DATA_HS_26                             0x00B498 /* >= gfx10 */
#define R_00B498_SPI_SHADER_USER_DATA_LS_26                             0x00B498 /* gfx9 */
#define R_00B49C_SPI_SHADER_USER_DATA_HS_27                             0x00B49C /* >= gfx10 */
#define R_00B49C_SPI_SHADER_USER_DATA_LS_27                             0x00B49C /* gfx9 */
#define R_00B4A0_SPI_SHADER_USER_DATA_HS_28                             0x00B4A0 /* >= gfx10 */
#define R_00B4A0_SPI_SHADER_USER_DATA_LS_28                             0x00B4A0 /* gfx9 */
#define R_00B4A4_SPI_SHADER_USER_DATA_HS_29                             0x00B4A4 /* >= gfx10 */
#define R_00B4A4_SPI_SHADER_USER_DATA_LS_29                             0x00B4A4 /* gfx9 */
#define R_00B4A8_SPI_SHADER_USER_DATA_HS_30                             0x00B4A8 /* >= gfx10 */
#define R_00B4A8_SPI_SHADER_USER_DATA_LS_30                             0x00B4A8 /* gfx9 */
#define R_00B4AC_SPI_SHADER_USER_DATA_HS_31                             0x00B4AC /* >= gfx10 */
#define R_00B4AC_SPI_SHADER_USER_DATA_LS_31                             0x00B4AC /* gfx9 */
#define R_00B4C0_SPI_SHADER_REQ_CTRL_LSHS                               0x00B4C0 /* >= gfx10 */
#define   S_00B4C0_SOFT_GROUPING_EN(x)                                (((unsigned)(x) & 0x1) << 0)
#define   G_00B4C0_SOFT_GROUPING_EN(x)                                (((x) >> 0) & 0x1)
#define   C_00B4C0_SOFT_GROUPING_EN                                   0xFFFFFFFE
#define   S_00B4C0_NUMBER_OF_REQUESTS_PER_CU(x)                       (((unsigned)(x) & 0xF) << 1)
#define   G_00B4C0_NUMBER_OF_REQUESTS_PER_CU(x)                       (((x) >> 1) & 0xF)
#define   C_00B4C0_NUMBER_OF_REQUESTS_PER_CU                          0xFFFFFFE1
#define   S_00B4C0_SOFT_GROUPING_ALLOCATION_TIMEOUT(x)                (((unsigned)(x) & 0xF) << 5)
#define   G_00B4C0_SOFT_GROUPING_ALLOCATION_TIMEOUT(x)                (((x) >> 5) & 0xF)
#define   C_00B4C0_SOFT_GROUPING_ALLOCATION_TIMEOUT                   0xFFFFFE1F
#define   S_00B4C0_HARD_LOCK_HYSTERESIS(x)                            (((unsigned)(x) & 0x1) << 9)
#define   G_00B4C0_HARD_LOCK_HYSTERESIS(x)                            (((x) >> 9) & 0x1)
#define   C_00B4C0_HARD_LOCK_HYSTERESIS                               0xFFFFFDFF
#define   S_00B4C0_HARD_LOCK_LOW_THRESHOLD(x)                         (((unsigned)(x) & 0x1F) << 10)
#define   G_00B4C0_HARD_LOCK_LOW_THRESHOLD(x)                         (((x) >> 10) & 0x1F)
#define   C_00B4C0_HARD_LOCK_LOW_THRESHOLD                            0xFFFF83FF
#define   S_00B4C0_PRODUCER_REQUEST_LOCKOUT(x)                        (((unsigned)(x) & 0x1) << 15)
#define   G_00B4C0_PRODUCER_REQUEST_LOCKOUT(x)                        (((x) >> 15) & 0x1)
#define   C_00B4C0_PRODUCER_REQUEST_LOCKOUT                           0xFFFF7FFF
#define   S_00B4C0_GLOBAL_SCANNING_EN(x)                              (((unsigned)(x) & 0x1) << 16)
#define   G_00B4C0_GLOBAL_SCANNING_EN(x)                              (((x) >> 16) & 0x1)
#define   C_00B4C0_GLOBAL_SCANNING_EN                                 0xFFFEFFFF
#define   S_00B4C0_ALLOCATION_RATE_THROTTLING_THRESHOLD(x)            (((unsigned)(x) & 0x7) << 17)
#define   G_00B4C0_ALLOCATION_RATE_THROTTLING_THRESHOLD(x)            (((x) >> 17) & 0x7)
#define   C_00B4C0_ALLOCATION_RATE_THROTTLING_THRESHOLD               0xFFF1FFFF
#define R_00B4C4_SPI_SHADER_PREF_PRI_CNTR_CTRL_LSHS                     0x00B4C4 /* gfx10 */
#define   S_00B4C4_TOTAL_WAVE_COUNT_HIER_SELECT(x)                    (((unsigned)(x) & 0x7) << 0)
#define   G_00B4C4_TOTAL_WAVE_COUNT_HIER_SELECT(x)                    (((x) >> 0) & 0x7)
#define   C_00B4C4_TOTAL_WAVE_COUNT_HIER_SELECT                       0xFFFFFFF8
#define   S_00B4C4_PER_TYPE_WAVE_COUNT_HIER_SELECT(x)                 (((unsigned)(x) & 0x7) << 3)
#define   G_00B4C4_PER_TYPE_WAVE_COUNT_HIER_SELECT(x)                 (((x) >> 3) & 0x7)
#define   C_00B4C4_PER_TYPE_WAVE_COUNT_HIER_SELECT                    0xFFFFFFC7
#define   S_00B4C4_GROUP_UPDATE_EN(x)                                 (((unsigned)(x) & 0x1) << 6)
#define   G_00B4C4_GROUP_UPDATE_EN(x)                                 (((x) >> 6) & 0x1)
#define   C_00B4C4_GROUP_UPDATE_EN                                    0xFFFFFFBF
#define   S_00B4C4_TOTAL_WAVE_COUNT_COEFFICIENT(x)                    (((unsigned)(x) & 0xFF) << 8)
#define   G_00B4C4_TOTAL_WAVE_COUNT_COEFFICIENT(x)                    (((x) >> 8) & 0xFF)
#define   C_00B4C4_TOTAL_WAVE_COUNT_COEFFICIENT                       0xFFFF00FF
#define   S_00B4C4_PER_TYPE_WAVE_COUNT_COEFFICIENT(x)                 (((unsigned)(x) & 0xFF) << 16)
#define   G_00B4C4_PER_TYPE_WAVE_COUNT_COEFFICIENT(x)                 (((x) >> 16) & 0xFF)
#define   C_00B4C4_PER_TYPE_WAVE_COUNT_COEFFICIENT                    0xFF00FFFF
#define R_00B4C8_SPI_SHADER_USER_ACCUM_LSHS_0                           0x00B4C8 /* >= gfx10 */
#define   S_00B4C8_CONTRIBUTION(x)                                    (((unsigned)(x) & 0x7F) << 0)
#define   G_00B4C8_CONTRIBUTION(x)                                    (((x) >> 0) & 0x7F)
#define   C_00B4C8_CONTRIBUTION                                       0xFFFFFF80
#define R_00B4CC_SPI_SHADER_USER_ACCUM_LSHS_1                           0x00B4CC /* >= gfx10 */
#define R_00B4D0_SPI_SHADER_USER_ACCUM_LSHS_2                           0x00B4D0 /* >= gfx10 */
#define R_00B4D4_SPI_SHADER_USER_ACCUM_LSHS_3                           0x00B4D4 /* >= gfx10 */
#define R_00B4F4_SPI_SHADER_PGM_RSRC2_LS_HS                             0x00B4F4 /* gfx7, gfx8, gfx81, gfx10 */
#define   S_00B4F4_SCRATCH_EN(x)                                      (((unsigned)(x) & 0x1) << 0)
#define   G_00B4F4_SCRATCH_EN(x)                                      (((x) >> 0) & 0x1)
#define   C_00B4F4_SCRATCH_EN                                         0xFFFFFFFE
#define   S_00B4F4_USER_SGPR(x)                                       (((unsigned)(x) & 0x1F) << 1)
#define   G_00B4F4_USER_SGPR(x)                                       (((x) >> 1) & 0x1F)
#define   C_00B4F4_USER_SGPR                                          0xFFFFFFC1
#define   S_00B4F4_TRAP_PRESENT(x)                                    (((unsigned)(x) & 0x1) << 6)
#define   G_00B4F4_TRAP_PRESENT(x)                                    (((x) >> 6) & 0x1)
#define   C_00B4F4_TRAP_PRESENT                                       0xFFFFFFBF
#define   S_00B4F4_LDS_SIZE(x)                                        (((unsigned)(x) & 0x1FF) << 7)
#define   G_00B4F4_LDS_SIZE(x)                                        (((x) >> 7) & 0x1FF)
#define   C_00B4F4_LDS_SIZE                                           0xFFFF007F
#define   S_00B4F4_EXCP_EN(x)                                         (((unsigned)(x) & 0x1FF) << 16)
#define   G_00B4F4_EXCP_EN(x)                                         (((x) >> 16) & 0x1FF)
#define   C_00B4F4_EXCP_EN                                            0xFE00FFFF
#define     V_00B4F4_INVALID                                        1
#define     V_00B4F4_INPUT_DENORMAL                                 2
#define     V_00B4F4_DIVIDE_BY_ZERO                                 4
#define     V_00B4F4_OVERFLOW                                       8
#define     V_00B4F4_UNDERFLOW                                      16
#define     V_00B4F4_INEXACT                                        32
#define     V_00B4F4_INT_DIVIDE_BY_ZERO                             64
#define     V_00B4F4_ADDRESS_WATCH                                  128
#define     V_00B4F4_MEMORY_VIOLATION                               256
#define R_00B500_SPI_SHADER_TBA_LO_LS                                   0x00B500 /* <= gfx81 */
#define R_00B504_SPI_SHADER_TBA_HI_LS                                   0x00B504 /* <= gfx81 */
#define   S_00B504_MEM_BASE(x)                                        (((unsigned)(x) & 0xFF) << 0)
#define   G_00B504_MEM_BASE(x)                                        (((x) >> 0) & 0xFF)
#define   C_00B504_MEM_BASE                                           0xFFFFFF00
#define R_00B508_SPI_SHADER_TMA_LO_LS                                   0x00B508 /* <= gfx81 */
#define R_00B50C_SPI_SHADER_TMA_HI_LS                                   0x00B50C /* <= gfx81 */
#define   S_00B50C_MEM_BASE(x)                                        (((unsigned)(x) & 0xFF) << 0)
#define   G_00B50C_MEM_BASE(x)                                        (((x) >> 0) & 0xFF)
#define   C_00B50C_MEM_BASE                                           0xFFFFFF00
#define R_00B51C_SPI_SHADER_PGM_RSRC3_LS                                0x00B51C /* gfx7, gfx8, gfx81, gfx10 */
#define   S_00B51C_CU_EN(x)                                           (((unsigned)(x) & 0xFFFF) << 0)
#define   G_00B51C_CU_EN(x)                                           (((x) >> 0) & 0xFFFF)
#define   C_00B51C_CU_EN                                              0xFFFF0000
#define   S_00B51C_WAVE_LIMIT(x)                                      (((unsigned)(x) & 0x3F) << 16)
#define   G_00B51C_WAVE_LIMIT(x)                                      (((x) >> 16) & 0x3F)
#define   C_00B51C_WAVE_LIMIT                                         0xFFC0FFFF
#define   S_00B51C_LOCK_LOW_THRESHOLD(x)                              (((unsigned)(x) & 0xF) << 22)
#define   G_00B51C_LOCK_LOW_THRESHOLD(x)                              (((x) >> 22) & 0xF)
#define   C_00B51C_LOCK_LOW_THRESHOLD                                 0xFC3FFFFF
#define   S_00B51C_GROUP_FIFO_DEPTH(x)                                (((unsigned)(x) & 0x3F) << 26) /* gfx8, gfx81, gfx10 */
#define   G_00B51C_GROUP_FIFO_DEPTH(x)                                (((x) >> 26) & 0x3F)
#define   C_00B51C_GROUP_FIFO_DEPTH                                   0x03FFFFFF
#define R_00B520_SPI_SHADER_PGM_LO_LS                                   0x00B520 /* <= gfx81, >= gfx10 */
#define R_00B524_SPI_SHADER_PGM_HI_LS                                   0x00B524 /* <= gfx81, >= gfx10 */
#define   S_00B524_MEM_BASE(x)                                        (((unsigned)(x) & 0xFF) << 0)
#define   G_00B524_MEM_BASE(x)                                        (((x) >> 0) & 0xFF)
#define   C_00B524_MEM_BASE                                           0xFFFFFF00
#define R_00B528_SPI_SHADER_PGM_RSRC1_LS                                0x00B528 /* <= gfx81, gfx10 */
#define   S_00B528_VGPRS(x)                                           (((unsigned)(x) & 0x3F) << 0)
#define   G_00B528_VGPRS(x)                                           (((x) >> 0) & 0x3F)
#define   C_00B528_VGPRS                                              0xFFFFFFC0
#define   S_00B528_SGPRS(x)                                           (((unsigned)(x) & 0xF) << 6)
#define   G_00B528_SGPRS(x)                                           (((x) >> 6) & 0xF)
#define   C_00B528_SGPRS                                              0xFFFFFC3F
#define   S_00B528_PRIORITY(x)                                        (((unsigned)(x) & 0x3) << 10)
#define   G_00B528_PRIORITY(x)                                        (((x) >> 10) & 0x3)
#define   C_00B528_PRIORITY                                           0xFFFFF3FF
#define   S_00B528_FLOAT_MODE(x)                                      (((unsigned)(x) & 0xFF) << 12)
#define   G_00B528_FLOAT_MODE(x)                                      (((x) >> 12) & 0xFF)
#define   C_00B528_FLOAT_MODE                                         0xFFF00FFF
#define     V_00B528_FP_32_DENORMS                                  48
#define     V_00B528_FP_64_DENORMS                                  192
#define     V_00B528_FP_ALL_DENORMS                                 240
#define   S_00B528_PRIV(x)                                            (((unsigned)(x) & 0x1) << 20)
#define   G_00B528_PRIV(x)                                            (((x) >> 20) & 0x1)
#define   C_00B528_PRIV                                               0xFFEFFFFF
#define   S_00B528_DX10_CLAMP(x)                                      (((unsigned)(x) & 0x1) << 21)
#define   G_00B528_DX10_CLAMP(x)                                      (((x) >> 21) & 0x1)
#define   C_00B528_DX10_CLAMP                                         0xFFDFFFFF
#define   S_00B528_DEBUG_MODE(x)                                      (((unsigned)(x) & 0x1) << 22) /* <= gfx81 */
#define   G_00B528_DEBUG_MODE(x)                                      (((x) >> 22) & 0x1)
#define   C_00B528_DEBUG_MODE                                         0xFFBFFFFF
#define   S_00B528_IEEE_MODE(x)                                       (((unsigned)(x) & 0x1) << 23)
#define   G_00B528_IEEE_MODE(x)                                       (((x) >> 23) & 0x1)
#define   C_00B528_IEEE_MODE                                          0xFF7FFFFF
#define   S_00B528_VGPR_COMP_CNT(x)                                   (((unsigned)(x) & 0x3) << 24)
#define   G_00B528_VGPR_COMP_CNT(x)                                   (((x) >> 24) & 0x3)
#define   C_00B528_VGPR_COMP_CNT                                      0xFCFFFFFF
#define   S_00B528_CACHE_CTL(x)                                       (((unsigned)(x) & 0x7) << 26) /* <= gfx81 */
#define   G_00B528_CACHE_CTL(x)                                       (((x) >> 26) & 0x7)
#define   C_00B528_CACHE_CTL                                          0xE3FFFFFF
#define   S_00B528_CDBG_USER(x)                                       (((unsigned)(x) & 0x1) << 29) /* <= gfx81 */
#define   G_00B528_CDBG_USER(x)                                       (((x) >> 29) & 0x1)
#define   C_00B528_CDBG_USER                                          0xDFFFFFFF
#define   S_00B528_FP16_OVFL(x)                                       (((unsigned)(x) & 0x1) << 30) /* gfx10 */
#define   G_00B528_FP16_OVFL(x)                                       (((x) >> 30) & 0x1)
#define   C_00B528_FP16_OVFL                                          0xBFFFFFFF
#define R_00B52C_SPI_SHADER_PGM_RSRC2_LS                                0x00B52C /* <= gfx81, gfx10 */
#define   S_00B52C_SCRATCH_EN(x)                                      (((unsigned)(x) & 0x1) << 0)
#define   G_00B52C_SCRATCH_EN(x)                                      (((x) >> 0) & 0x1)
#define   C_00B52C_SCRATCH_EN                                         0xFFFFFFFE
#define   S_00B52C_USER_SGPR(x)                                       (((unsigned)(x) & 0x1F) << 1)
#define   G_00B52C_USER_SGPR(x)                                       (((x) >> 1) & 0x1F)
#define   C_00B52C_USER_SGPR                                          0xFFFFFFC1
#define   S_00B52C_TRAP_PRESENT(x)                                    (((unsigned)(x) & 0x1) << 6)
#define   G_00B52C_TRAP_PRESENT(x)                                    (((x) >> 6) & 0x1)
#define   C_00B52C_TRAP_PRESENT                                       0xFFFFFFBF
#define   S_00B52C_LDS_SIZE(x)                                        (((unsigned)(x) & 0x1FF) << 7)
#define   G_00B52C_LDS_SIZE(x)                                        (((x) >> 7) & 0x1FF)
#define   C_00B52C_LDS_SIZE                                           0xFFFF007F
#define   S_00B52C_EXCP_EN(x)                                         (((unsigned)(x) & 0x1FF) << 16)
#define   G_00B52C_EXCP_EN(x)                                         (((x) >> 16) & 0x1FF)
#define   C_00B52C_EXCP_EN                                            0xFE00FFFF
#define     V_00B52C_INVALID                                        1
#define     V_00B52C_INPUT_DENORMAL                                 2
#define     V_00B52C_DIVIDE_BY_ZERO                                 4
#define     V_00B52C_OVERFLOW                                       8
#define     V_00B52C_UNDERFLOW                                      16
#define     V_00B52C_INEXACT                                        32
#define     V_00B52C_INT_DIVIDE_BY_ZERO                             64
#define     V_00B52C_ADDRESS_WATCH                                  128
#define     V_00B52C_MEMORY_VIOLATION                               256
#define R_00B530_SPI_SHADER_USER_DATA_COMMON_0                          0x00B530 /* gfx9 */
#define R_00B530_SPI_SHADER_USER_DATA_LS_0                              0x00B530 /* <= gfx81, gfx10 */
#define R_00B534_SPI_SHADER_USER_DATA_COMMON_1                          0x00B534 /* gfx9 */
#define R_00B534_SPI_SHADER_USER_DATA_LS_1                              0x00B534 /* <= gfx81, gfx10 */
#define R_00B538_SPI_SHADER_USER_DATA_COMMON_2                          0x00B538 /* gfx9 */
#define R_00B538_SPI_SHADER_USER_DATA_LS_2                              0x00B538 /* <= gfx81, gfx10 */
#define R_00B53C_SPI_SHADER_USER_DATA_COMMON_3                          0x00B53C /* gfx9 */
#define R_00B53C_SPI_SHADER_USER_DATA_LS_3                              0x00B53C /* <= gfx81, gfx10 */
#define R_00B540_SPI_SHADER_USER_DATA_COMMON_4                          0x00B540 /* gfx9 */
#define R_00B540_SPI_SHADER_USER_DATA_LS_4                              0x00B540 /* <= gfx81, gfx10 */
#define R_00B544_SPI_SHADER_USER_DATA_COMMON_5                          0x00B544 /* gfx9 */
#define R_00B544_SPI_SHADER_USER_DATA_LS_5                              0x00B544 /* <= gfx81, gfx10 */
#define R_00B548_SPI_SHADER_USER_DATA_COMMON_6                          0x00B548 /* gfx9 */
#define R_00B548_SPI_SHADER_USER_DATA_LS_6                              0x00B548 /* <= gfx81, gfx10 */
#define R_00B54C_SPI_SHADER_USER_DATA_COMMON_7                          0x00B54C /* gfx9 */
#define R_00B54C_SPI_SHADER_USER_DATA_LS_7                              0x00B54C /* <= gfx81, gfx10 */
#define R_00B550_SPI_SHADER_USER_DATA_COMMON_8                          0x00B550 /* gfx9 */
#define R_00B550_SPI_SHADER_USER_DATA_LS_8                              0x00B550 /* <= gfx81, gfx10 */
#define R_00B554_SPI_SHADER_USER_DATA_COMMON_9                          0x00B554 /* gfx9 */
#define R_00B554_SPI_SHADER_USER_DATA_LS_9                              0x00B554 /* <= gfx81, gfx10 */
#define R_00B558_SPI_SHADER_USER_DATA_COMMON_10                         0x00B558 /* gfx9 */
#define R_00B558_SPI_SHADER_USER_DATA_LS_10                             0x00B558 /* <= gfx81, gfx10 */
#define R_00B55C_SPI_SHADER_USER_DATA_COMMON_11                         0x00B55C /* gfx9 */
#define R_00B55C_SPI_SHADER_USER_DATA_LS_11                             0x00B55C /* <= gfx81, gfx10 */
#define R_00B560_SPI_SHADER_USER_DATA_COMMON_12                         0x00B560 /* gfx9 */
#define R_00B560_SPI_SHADER_USER_DATA_LS_12                             0x00B560 /* <= gfx81, gfx10 */
#define R_00B564_SPI_SHADER_USER_DATA_COMMON_13                         0x00B564 /* gfx9 */
#define R_00B564_SPI_SHADER_USER_DATA_LS_13                             0x00B564 /* <= gfx81, gfx10 */
#define R_00B568_SPI_SHADER_USER_DATA_COMMON_14                         0x00B568 /* gfx9 */
#define R_00B568_SPI_SHADER_USER_DATA_LS_14                             0x00B568 /* <= gfx81, gfx10 */
#define R_00B56C_SPI_SHADER_USER_DATA_COMMON_15                         0x00B56C /* gfx9 */
#define R_00B56C_SPI_SHADER_USER_DATA_LS_15                             0x00B56C /* <= gfx81, gfx10 */
#define R_00B570_SPI_SHADER_USER_DATA_COMMON_16                         0x00B570 /* gfx9 */
#define R_00B574_SPI_SHADER_USER_DATA_COMMON_17                         0x00B574 /* gfx9 */
#define R_00B578_SPI_SHADER_USER_DATA_COMMON_18                         0x00B578 /* gfx9 */
#define R_00B57C_SPI_SHADER_USER_DATA_COMMON_19                         0x00B57C /* gfx9 */
#define R_00B580_SPI_SHADER_USER_DATA_COMMON_20                         0x00B580 /* gfx9 */
#define R_00B584_SPI_SHADER_USER_DATA_COMMON_21                         0x00B584 /* gfx9 */
#define R_00B588_SPI_SHADER_USER_DATA_COMMON_22                         0x00B588 /* gfx9 */
#define R_00B58C_SPI_SHADER_USER_DATA_COMMON_23                         0x00B58C /* gfx9 */
#define R_00B590_SPI_SHADER_USER_DATA_COMMON_24                         0x00B590 /* gfx9 */
#define R_00B594_SPI_SHADER_USER_DATA_COMMON_25                         0x00B594 /* gfx9 */
#define R_00B598_SPI_SHADER_USER_DATA_COMMON_26                         0x00B598 /* gfx9 */
#define R_00B59C_SPI_SHADER_USER_DATA_COMMON_27                         0x00B59C /* gfx9 */
#define R_00B5A0_SPI_SHADER_USER_DATA_COMMON_28                         0x00B5A0 /* gfx9 */
#define R_00B5A4_SPI_SHADER_USER_DATA_COMMON_29                         0x00B5A4 /* gfx9 */
#define R_00B5A8_SPI_SHADER_USER_DATA_COMMON_30                         0x00B5A8 /* gfx9 */
#define R_00B5AC_SPI_SHADER_USER_DATA_COMMON_31                         0x00B5AC /* gfx9 */
#define R_00B800_COMPUTE_DISPATCH_INITIATOR                             0x00B800
#define   S_00B800_COMPUTE_SHADER_EN(x)                               (((unsigned)(x) & 0x1) << 0)
#define   G_00B800_COMPUTE_SHADER_EN(x)                               (((x) >> 0) & 0x1)
#define   C_00B800_COMPUTE_SHADER_EN                                  0xFFFFFFFE
#define   S_00B800_PARTIAL_TG_EN(x)                                   (((unsigned)(x) & 0x1) << 1)
#define   G_00B800_PARTIAL_TG_EN(x)                                   (((x) >> 1) & 0x1)
#define   C_00B800_PARTIAL_TG_EN                                      0xFFFFFFFD
#define   S_00B800_FORCE_START_AT_000(x)                              (((unsigned)(x) & 0x1) << 2)
#define   G_00B800_FORCE_START_AT_000(x)                              (((x) >> 2) & 0x1)
#define   C_00B800_FORCE_START_AT_000                                 0xFFFFFFFB
#define   S_00B800_ORDERED_APPEND_ENBL(x)                             (((unsigned)(x) & 0x1) << 3)
#define   G_00B800_ORDERED_APPEND_ENBL(x)                             (((x) >> 3) & 0x1)
#define   C_00B800_ORDERED_APPEND_ENBL                                0xFFFFFFF7
#define   S_00B800_ORDERED_APPEND_MODE(x)                             (((unsigned)(x) & 0x1) << 4)
#define   G_00B800_ORDERED_APPEND_MODE(x)                             (((x) >> 4) & 0x1)
#define   C_00B800_ORDERED_APPEND_MODE                                0xFFFFFFEF
#define   S_00B800_USE_THREAD_DIMENSIONS(x)                           (((unsigned)(x) & 0x1) << 5)
#define   G_00B800_USE_THREAD_DIMENSIONS(x)                           (((x) >> 5) & 0x1)
#define   C_00B800_USE_THREAD_DIMENSIONS                              0xFFFFFFDF
#define   S_00B800_ORDER_MODE(x)                                      (((unsigned)(x) & 0x1) << 6)
#define   G_00B800_ORDER_MODE(x)                                      (((x) >> 6) & 0x1)
#define   C_00B800_ORDER_MODE                                         0xFFFFFFBF
#define   S_00B800_DISPATCH_CACHE_CNTL(x)                             (((unsigned)(x) & 0x7) << 7) /* <= gfx81 */
#define   G_00B800_DISPATCH_CACHE_CNTL(x)                             (((x) >> 7) & 0x7)
#define   C_00B800_DISPATCH_CACHE_CNTL                                0xFFFFFC7F
#define   S_00B800_SCALAR_L1_INV_VOL(x)                               (((unsigned)(x) & 0x1) << 10)
#define   G_00B800_SCALAR_L1_INV_VOL(x)                               (((x) >> 10) & 0x1)
#define   C_00B800_SCALAR_L1_INV_VOL                                  0xFFFFFBFF
#define   S_00B800_VECTOR_L1_INV_VOL(x)                               (((unsigned)(x) & 0x1) << 11)
#define   G_00B800_VECTOR_L1_INV_VOL(x)                               (((x) >> 11) & 0x1)
#define   C_00B800_VECTOR_L1_INV_VOL                                  0xFFFFF7FF
#define   S_00B800_DATA_ATC(x)                                        (((unsigned)(x) & 0x1) << 12) /* <= gfx81 */
#define   G_00B800_DATA_ATC(x)                                        (((x) >> 12) & 0x1)
#define   C_00B800_DATA_ATC                                           0xFFFFEFFF
#define   S_00B800_TUNNEL_ENABLE(x)                                   (((unsigned)(x) & 0x1) << 13) /* >= gfx10 */
#define   G_00B800_TUNNEL_ENABLE(x)                                   (((x) >> 13) & 0x1)
#define   C_00B800_TUNNEL_ENABLE                                      0xFFFFDFFF
#define   S_00B800_RESTORE(x)                                         (((unsigned)(x) & 0x1) << 14)
#define   G_00B800_RESTORE(x)                                         (((x) >> 14) & 0x1)
#define   C_00B800_RESTORE                                            0xFFFFBFFF
#define   S_00B800_CS_W32_EN(x)                                       (((unsigned)(x) & 0x1) << 15) /* >= gfx10 */
#define   G_00B800_CS_W32_EN(x)                                       (((x) >> 15) & 0x1)
#define   C_00B800_CS_W32_EN                                          0xFFFF7FFF
#define R_00B804_COMPUTE_DIM_X                                          0x00B804
#define R_00B808_COMPUTE_DIM_Y                                          0x00B808
#define R_00B80C_COMPUTE_DIM_Z                                          0x00B80C
#define R_00B810_COMPUTE_START_X                                        0x00B810
#define R_00B814_COMPUTE_START_Y                                        0x00B814
#define R_00B818_COMPUTE_START_Z                                        0x00B818
#define R_00B81C_COMPUTE_NUM_THREAD_X                                   0x00B81C
#define   S_00B81C_NUM_THREAD_FULL(x)                                 (((unsigned)(x) & 0xFFFF) << 0)
#define   G_00B81C_NUM_THREAD_FULL(x)                                 (((x) >> 0) & 0xFFFF)
#define   C_00B81C_NUM_THREAD_FULL                                    0xFFFF0000
#define   S_00B81C_NUM_THREAD_PARTIAL(x)                              (((unsigned)(x) & 0xFFFF) << 16)
#define   G_00B81C_NUM_THREAD_PARTIAL(x)                              (((x) >> 16) & 0xFFFF)
#define   C_00B81C_NUM_THREAD_PARTIAL                                 0x0000FFFF
#define R_00B820_COMPUTE_NUM_THREAD_Y                                   0x00B820
#define   S_00B820_NUM_THREAD_FULL(x)                                 (((unsigned)(x) & 0xFFFF) << 0)
#define   G_00B820_NUM_THREAD_FULL(x)                                 (((x) >> 0) & 0xFFFF)
#define   C_00B820_NUM_THREAD_FULL                                    0xFFFF0000
#define   S_00B820_NUM_THREAD_PARTIAL(x)                              (((unsigned)(x) & 0xFFFF) << 16)
#define   G_00B820_NUM_THREAD_PARTIAL(x)                              (((x) >> 16) & 0xFFFF)
#define   C_00B820_NUM_THREAD_PARTIAL                                 0x0000FFFF
#define R_00B824_COMPUTE_NUM_THREAD_Z                                   0x00B824
#define   S_00B824_NUM_THREAD_FULL(x)                                 (((unsigned)(x) & 0xFFFF) << 0)
#define   G_00B824_NUM_THREAD_FULL(x)                                 (((x) >> 0) & 0xFFFF)
#define   C_00B824_NUM_THREAD_FULL                                    0xFFFF0000
#define   S_00B824_NUM_THREAD_PARTIAL(x)                              (((unsigned)(x) & 0xFFFF) << 16)
#define   G_00B824_NUM_THREAD_PARTIAL(x)                              (((x) >> 16) & 0xFFFF)
#define   C_00B824_NUM_THREAD_PARTIAL                                 0x0000FFFF
#define R_00B828_COMPUTE_PIPELINESTAT_ENABLE                            0x00B828 /* >= gfx7 */
#define   S_00B828_PIPELINESTAT_ENABLE(x)                             (((unsigned)(x) & 0x1) << 0)
#define   G_00B828_PIPELINESTAT_ENABLE(x)                             (((x) >> 0) & 0x1)
#define   C_00B828_PIPELINESTAT_ENABLE                                0xFFFFFFFE
#define R_00B82C_COMPUTE_MAX_WAVE_ID                                    0x00B82C /* <= gfx6 */
#define   S_00B82C_MAX_WAVE_ID(x)                                     (((unsigned)(x) & 0xFFF) << 0)
#define   G_00B82C_MAX_WAVE_ID(x)                                     (((x) >> 0) & 0xFFF)
#define   C_00B82C_MAX_WAVE_ID                                        0xFFFFF000
#define R_00B82C_COMPUTE_PERFCOUNT_ENABLE                               0x00B82C /* >= gfx7 */
#define   S_00B82C_PERFCOUNT_ENABLE(x)                                (((unsigned)(x) & 0x1) << 0)
#define   G_00B82C_PERFCOUNT_ENABLE(x)                                (((x) >> 0) & 0x1)
#define   C_00B82C_PERFCOUNT_ENABLE                                   0xFFFFFFFE
#define R_00B830_COMPUTE_PGM_LO                                         0x00B830
#define R_00B834_COMPUTE_PGM_HI                                         0x00B834
#define   S_00B834_DATA(x)                                            (((unsigned)(x) & 0xFF) << 0)
#define   G_00B834_DATA(x)                                            (((x) >> 0) & 0xFF)
#define   C_00B834_DATA                                               0xFFFFFF00
#define   S_00B834_INST_ATC(x)                                        (((unsigned)(x) & 0x1) << 8) /* <= gfx81 */
#define   G_00B834_INST_ATC(x)                                        (((x) >> 8) & 0x1)
#define   C_00B834_INST_ATC                                           0xFFFFFEFF
#define R_00B838_COMPUTE_DISPATCH_PKT_ADDR_LO                           0x00B838 /* >= gfx9 */
#define R_00B838_COMPUTE_TBA_LO                                         0x00B838 /* <= gfx81 */
#define R_00B83C_COMPUTE_DISPATCH_PKT_ADDR_HI                           0x00B83C /* >= gfx9 */
#define   S_00B83C_DATA(x)                                            (((unsigned)(x) & 0xFF) << 0)
#define   G_00B83C_DATA(x)                                            (((x) >> 0) & 0xFF)
#define   C_00B83C_DATA                                               0xFFFFFF00
#define R_00B83C_COMPUTE_TBA_HI                                         0x00B83C /* <= gfx81 */
#define R_00B840_COMPUTE_DISPATCH_SCRATCH_BASE_LO                       0x00B840 /* >= gfx9 */
#define R_00B840_COMPUTE_TMA_LO                                         0x00B840 /* <= gfx81 */
#define R_00B844_COMPUTE_DISPATCH_SCRATCH_BASE_HI                       0x00B844 /* >= gfx9 */
#define   S_00B844_DATA(x)                                            (((unsigned)(x) & 0xFF) << 0)
#define   G_00B844_DATA(x)                                            (((x) >> 0) & 0xFF)
#define   C_00B844_DATA                                               0xFFFFFF00
#define R_00B844_COMPUTE_TMA_HI                                         0x00B844 /* <= gfx81 */
#define R_00B848_COMPUTE_PGM_RSRC1                                      0x00B848
#define   S_00B848_VGPRS(x)                                           (((unsigned)(x) & 0x3F) << 0)
#define   G_00B848_VGPRS(x)                                           (((x) >> 0) & 0x3F)
#define   C_00B848_VGPRS                                              0xFFFFFFC0
#define   S_00B848_SGPRS(x)                                           (((unsigned)(x) & 0xF) << 6)
#define   G_00B848_SGPRS(x)                                           (((x) >> 6) & 0xF)
#define   C_00B848_SGPRS                                              0xFFFFFC3F
#define   S_00B848_PRIORITY(x)                                        (((unsigned)(x) & 0x3) << 10)
#define   G_00B848_PRIORITY(x)                                        (((x) >> 10) & 0x3)
#define   C_00B848_PRIORITY                                           0xFFFFF3FF
#define   S_00B848_FLOAT_MODE(x)                                      (((unsigned)(x) & 0xFF) << 12)
#define   G_00B848_FLOAT_MODE(x)                                      (((x) >> 12) & 0xFF)
#define   C_00B848_FLOAT_MODE                                         0xFFF00FFF
#define     V_00B848_FP_32_DENORMS                                  48
#define     V_00B848_FP_64_DENORMS                                  192
#define     V_00B848_FP_ALL_DENORMS                                 240
#define   S_00B848_PRIV(x)                                            (((unsigned)(x) & 0x1) << 20)
#define   G_00B848_PRIV(x)                                            (((x) >> 20) & 0x1)
#define   C_00B848_PRIV                                               0xFFEFFFFF
#define   S_00B848_DX10_CLAMP(x)                                      (((unsigned)(x) & 0x1) << 21)
#define   G_00B848_DX10_CLAMP(x)                                      (((x) >> 21) & 0x1)
#define   C_00B848_DX10_CLAMP                                         0xFFDFFFFF
#define   S_00B848_DEBUG_MODE(x)                                      (((unsigned)(x) & 0x1) << 22) /* <= gfx9 */
#define   G_00B848_DEBUG_MODE(x)                                      (((x) >> 22) & 0x1)
#define   C_00B848_DEBUG_MODE                                         0xFFBFFFFF
#define   S_00B848_IEEE_MODE(x)                                       (((unsigned)(x) & 0x1) << 23)
#define   G_00B848_IEEE_MODE(x)                                       (((x) >> 23) & 0x1)
#define   C_00B848_IEEE_MODE                                          0xFF7FFFFF
#define   S_00B848_BULKY(x)                                           (((unsigned)(x) & 0x1) << 24)
#define   G_00B848_BULKY(x)                                           (((x) >> 24) & 0x1)
#define   C_00B848_BULKY                                              0xFEFFFFFF
#define   S_00B848_CDBG_USER(x)                                       (((unsigned)(x) & 0x1) << 25) /* <= gfx9 */
#define   G_00B848_CDBG_USER(x)                                       (((x) >> 25) & 0x1)
#define   C_00B848_CDBG_USER                                          0xFDFFFFFF
#define   S_00B848_FP16_OVFL(x)                                       (((unsigned)(x) & 0x1) << 26) /* >= gfx9 */
#define   G_00B848_FP16_OVFL(x)                                       (((x) >> 26) & 0x1)
#define   C_00B848_FP16_OVFL                                          0xFBFFFFFF
#define   S_00B848_WGP_MODE(x)                                        (((unsigned)(x) & 0x1) << 29) /* >= gfx10 */
#define   G_00B848_WGP_MODE(x)                                        (((x) >> 29) & 0x1)
#define   C_00B848_WGP_MODE                                           0xDFFFFFFF
#define   S_00B848_MEM_ORDERED(x)                                     (((unsigned)(x) & 0x1) << 30) /* >= gfx10 */
#define   G_00B848_MEM_ORDERED(x)                                     (((x) >> 30) & 0x1)
#define   C_00B848_MEM_ORDERED                                        0xBFFFFFFF
#define   S_00B848_FWD_PROGRESS(x)                                    (((unsigned)(x) & 0x1) << 31) /* >= gfx10 */
#define   G_00B848_FWD_PROGRESS(x)                                    (((x) >> 31) & 0x1)
#define   C_00B848_FWD_PROGRESS                                       0x7FFFFFFF
#define R_00B84C_COMPUTE_PGM_RSRC2                                      0x00B84C
#define   S_00B84C_SCRATCH_EN(x)                                      (((unsigned)(x) & 0x1) << 0)
#define   G_00B84C_SCRATCH_EN(x)                                      (((x) >> 0) & 0x1)
#define   C_00B84C_SCRATCH_EN                                         0xFFFFFFFE
#define   S_00B84C_USER_SGPR(x)                                       (((unsigned)(x) & 0x1F) << 1)
#define   G_00B84C_USER_SGPR(x)                                       (((x) >> 1) & 0x1F)
#define   C_00B84C_USER_SGPR                                          0xFFFFFFC1
#define   S_00B84C_TRAP_PRESENT(x)                                    (((unsigned)(x) & 0x1) << 6)
#define   G_00B84C_TRAP_PRESENT(x)                                    (((x) >> 6) & 0x1)
#define   C_00B84C_TRAP_PRESENT                                       0xFFFFFFBF
#define   S_00B84C_TGID_X_EN(x)                                       (((unsigned)(x) & 0x1) << 7)
#define   G_00B84C_TGID_X_EN(x)                                       (((x) >> 7) & 0x1)
#define   C_00B84C_TGID_X_EN                                          0xFFFFFF7F
#define   S_00B84C_TGID_Y_EN(x)                                       (((unsigned)(x) & 0x1) << 8)
#define   G_00B84C_TGID_Y_EN(x)                                       (((x) >> 8) & 0x1)
#define   C_00B84C_TGID_Y_EN                                          0xFFFFFEFF
#define   S_00B84C_TGID_Z_EN(x)                                       (((unsigned)(x) & 0x1) << 9)
#define   G_00B84C_TGID_Z_EN(x)                                       (((x) >> 9) & 0x1)
#define   C_00B84C_TGID_Z_EN                                          0xFFFFFDFF
#define   S_00B84C_TG_SIZE_EN(x)                                      (((unsigned)(x) & 0x1) << 10)
#define   G_00B84C_TG_SIZE_EN(x)                                      (((x) >> 10) & 0x1)
#define   C_00B84C_TG_SIZE_EN                                         0xFFFFFBFF
#define   S_00B84C_TIDIG_COMP_CNT(x)                                  (((unsigned)(x) & 0x3) << 11)
#define   G_00B84C_TIDIG_COMP_CNT(x)                                  (((x) >> 11) & 0x3)
#define   C_00B84C_TIDIG_COMP_CNT                                     0xFFFFE7FF
#define   S_00B84C_EXCP_EN_MSB(x)                                     (((unsigned)(x) & 0x3) << 13)
#define   G_00B84C_EXCP_EN_MSB(x)                                     (((x) >> 13) & 0x3)
#define   C_00B84C_EXCP_EN_MSB                                        0xFFFF9FFF
#define   S_00B84C_LDS_SIZE(x)                                        (((unsigned)(x) & 0x1FF) << 15)
#define   G_00B84C_LDS_SIZE(x)                                        (((x) >> 15) & 0x1FF)
#define   C_00B84C_LDS_SIZE                                           0xFF007FFF
#define   S_00B84C_EXCP_EN(x)                                         (((unsigned)(x) & 0x7F) << 24)
#define   G_00B84C_EXCP_EN(x)                                         (((x) >> 24) & 0x7F)
#define   C_00B84C_EXCP_EN                                            0x80FFFFFF
#define     V_00B84C_INVALID                                        1
#define     V_00B84C_INPUT_DENORMAL                                 2
#define     V_00B84C_DIVIDE_BY_ZERO                                 4
#define     V_00B84C_OVERFLOW                                       8
#define     V_00B84C_UNDERFLOW                                      16
#define     V_00B84C_INEXACT                                        32
#define     V_00B84C_INT_DIVIDE_BY_ZERO                             64
#define     V_00B84C_ADDRESS_WATCH                                  128
#define     V_00B84C_MEMORY_VIOLATION                               256
#define   S_00B84C_SKIP_USGPR0(x)                                     (((unsigned)(x) & 0x1) << 31) /* gfx9 */
#define   G_00B84C_SKIP_USGPR0(x)                                     (((x) >> 31) & 0x1)
#define   C_00B84C_SKIP_USGPR0                                        0x7FFFFFFF
#define R_00B850_COMPUTE_VMID                                           0x00B850
#define   S_00B850_DATA(x)                                            (((unsigned)(x) & 0xF) << 0)
#define   G_00B850_DATA(x)                                            (((x) >> 0) & 0xF)
#define   C_00B850_DATA                                               0xFFFFFFF0
#define R_00B854_COMPUTE_RESOURCE_LIMITS                                0x00B854
#define   S_00B854_WAVES_PER_SH(x)                                    (((unsigned)(x) & 0x3FF) << 0)
#define   G_00B854_WAVES_PER_SH(x)                                    (((x) >> 0) & 0x3FF)
#define   C_00B854_WAVES_PER_SH                                       0xFFFFFC00
#define   S_00B854_WAVES_PER_SH_GFX6(x)                               (((unsigned)(x) & 0x3F) << 0) /* <= gfx6 */
#define   G_00B854_WAVES_PER_SH_GFX6(x)                               (((x) >> 0) & 0x3F)
#define   C_00B854_WAVES_PER_SH_GFX6                                  0xFFFFFFC0
#define   S_00B854_TG_PER_CU(x)                                       (((unsigned)(x) & 0xF) << 12)
#define   G_00B854_TG_PER_CU(x)                                       (((x) >> 12) & 0xF)
#define   C_00B854_TG_PER_CU                                          0xFFFF0FFF
#define   S_00B854_LOCK_THRESHOLD(x)                                  (((unsigned)(x) & 0x3F) << 16)
#define   G_00B854_LOCK_THRESHOLD(x)                                  (((x) >> 16) & 0x3F)
#define   C_00B854_LOCK_THRESHOLD                                     0xFFC0FFFF
#define   S_00B854_SIMD_DEST_CNTL(x)                                  (((unsigned)(x) & 0x1) << 22)
#define   G_00B854_SIMD_DEST_CNTL(x)                                  (((x) >> 22) & 0x1)
#define   C_00B854_SIMD_DEST_CNTL                                     0xFFBFFFFF
#define   S_00B854_FORCE_SIMD_DIST(x)                                 (((unsigned)(x) & 0x1) << 23)
#define   G_00B854_FORCE_SIMD_DIST(x)                                 (((x) >> 23) & 0x1)
#define   C_00B854_FORCE_SIMD_DIST                                    0xFF7FFFFF
#define   S_00B854_CU_GROUP_COUNT(x)                                  (((unsigned)(x) & 0x7) << 24)
#define   G_00B854_CU_GROUP_COUNT(x)                                  (((x) >> 24) & 0x7)
#define   C_00B854_CU_GROUP_COUNT                                     0xF8FFFFFF
#define   S_00B854_SIMD_DISABLE(x)                                    (((unsigned)(x) & 0xF) << 27) /* gfx9 */
#define   G_00B854_SIMD_DISABLE(x)                                    (((x) >> 27) & 0xF)
#define   C_00B854_SIMD_DISABLE                                       0x87FFFFFF
#define R_00B858_COMPUTE_DESTINATION_EN_SE0                             0x00B858 /* >= gfx10 */
#define R_00B858_COMPUTE_STATIC_THREAD_MGMT_SE0                         0x00B858 /* <= gfx9 */
#define   S_00B858_SH0_CU_EN(x)                                       (((unsigned)(x) & 0xFFFF) << 0)
#define   G_00B858_SH0_CU_EN(x)                                       (((x) >> 0) & 0xFFFF)
#define   C_00B858_SH0_CU_EN                                          0xFFFF0000
#define   S_00B858_SH1_CU_EN(x)                                       (((unsigned)(x) & 0xFFFF) << 16)
#define   G_00B858_SH1_CU_EN(x)                                       (((x) >> 16) & 0xFFFF)
#define   C_00B858_SH1_CU_EN                                          0x0000FFFF
#define R_00B85C_COMPUTE_DESTINATION_EN_SE1                             0x00B85C /* >= gfx10 */
#define R_00B85C_COMPUTE_STATIC_THREAD_MGMT_SE1                         0x00B85C /* <= gfx9 */
#define R_00B860_COMPUTE_TMPRING_SIZE                                   0x00B860
#define   S_00B860_WAVES(x)                                           (((unsigned)(x) & 0xFFF) << 0)
#define   G_00B860_WAVES(x)                                           (((x) >> 0) & 0xFFF)
#define   C_00B860_WAVES                                              0xFFFFF000
#define   S_00B860_WAVESIZE(x)                                        (((unsigned)(x) & 0x1FFF) << 12)
#define   G_00B860_WAVESIZE(x)                                        (((x) >> 12) & 0x1FFF)
#define   C_00B860_WAVESIZE                                           0xFE000FFF
#define R_00B864_COMPUTE_DESTINATION_EN_SE2                             0x00B864 /* >= gfx10 */
#define R_00B864_COMPUTE_STATIC_THREAD_MGMT_SE2                         0x00B864 /* gfx7, gfx8, gfx81, gfx9 */
#define R_00B868_COMPUTE_DESTINATION_EN_SE3                             0x00B868 /* >= gfx10 */
#define R_00B868_COMPUTE_STATIC_THREAD_MGMT_SE3                         0x00B868 /* gfx7, gfx8, gfx81, gfx9 */
#define R_00B86C_COMPUTE_RESTART_X                                      0x00B86C /* >= gfx7 */
#define R_00B870_COMPUTE_RESTART_Y                                      0x00B870 /* >= gfx7 */
#define R_00B874_COMPUTE_RESTART_Z                                      0x00B874 /* >= gfx7 */
#define R_00B878_COMPUTE_THREAD_TRACE_ENABLE                            0x00B878 /* >= gfx7 */
#define   S_00B878_THREAD_TRACE_ENABLE(x)                             (((unsigned)(x) & 0x1) << 0)
#define   G_00B878_THREAD_TRACE_ENABLE(x)                             (((x) >> 0) & 0x1)
#define   C_00B878_THREAD_TRACE_ENABLE                                0xFFFFFFFE
#define R_00B87C_COMPUTE_MISC_RESERVED                                  0x00B87C /* >= gfx7 */
#define   S_00B87C_SEND_SEID(x)                                       (((unsigned)(x) & 0x3) << 0)
#define   G_00B87C_SEND_SEID(x)                                       (((x) >> 0) & 0x3)
#define   C_00B87C_SEND_SEID                                          0xFFFFFFFC
#define   S_00B87C_RESERVED2(x)                                       (((unsigned)(x) & 0x1) << 2)
#define   G_00B87C_RESERVED2(x)                                       (((x) >> 2) & 0x1)
#define   C_00B87C_RESERVED2                                          0xFFFFFFFB
#define   S_00B87C_RESERVED3(x)                                       (((unsigned)(x) & 0x1) << 3)
#define   G_00B87C_RESERVED3(x)                                       (((x) >> 3) & 0x1)
#define   C_00B87C_RESERVED3                                          0xFFFFFFF7
#define   S_00B87C_RESERVED4(x)                                       (((unsigned)(x) & 0x1) << 4)
#define   G_00B87C_RESERVED4(x)                                       (((x) >> 4) & 0x1)
#define   C_00B87C_RESERVED4                                          0xFFFFFFEF
#define   S_00B87C_WAVE_ID_BASE(x)                                    (((unsigned)(x) & 0xFFF) << 5) /* >= gfx8 */
#define   G_00B87C_WAVE_ID_BASE(x)                                    (((x) >> 5) & 0xFFF)
#define   C_00B87C_WAVE_ID_BASE                                       0xFFFE001F
#define R_00B880_COMPUTE_DISPATCH_ID                                    0x00B880 /* >= gfx8 */
#define R_00B884_COMPUTE_THREADGROUP_ID                                 0x00B884 /* >= gfx8 */
#define R_00B888_COMPUTE_RELAUNCH                                       0x00B888 /* gfx8, gfx81, gfx9 */
#define   S_00B888_PAYLOAD(x)                                         (((unsigned)(x) & 0x3FFFFFFF) << 0)
#define   G_00B888_PAYLOAD(x)                                         (((x) >> 0) & 0x3FFFFFFF)
#define   C_00B888_PAYLOAD                                            0xC0000000
#define   S_00B888_IS_EVENT(x)                                        (((unsigned)(x) & 0x1) << 30)
#define   G_00B888_IS_EVENT(x)                                        (((x) >> 30) & 0x1)
#define   C_00B888_IS_EVENT                                           0xBFFFFFFF
#define   S_00B888_IS_STATE(x)                                        (((unsigned)(x) & 0x1) << 31)
#define   G_00B888_IS_STATE(x)                                        (((x) >> 31) & 0x1)
#define   C_00B888_IS_STATE                                           0x7FFFFFFF
#define R_00B888_COMPUTE_REQ_CTRL                                       0x00B888 /* >= gfx10 */
#define   S_00B888_SOFT_GROUPING_EN(x)                                (((unsigned)(x) & 0x1) << 0)
#define   G_00B888_SOFT_GROUPING_EN(x)                                (((x) >> 0) & 0x1)
#define   C_00B888_SOFT_GROUPING_EN                                   0xFFFFFFFE
#define   S_00B888_NUMBER_OF_REQUESTS_PER_CU(x)                       (((unsigned)(x) & 0xF) << 1)
#define   G_00B888_NUMBER_OF_REQUESTS_PER_CU(x)                       (((x) >> 1) & 0xF)
#define   C_00B888_NUMBER_OF_REQUESTS_PER_CU                          0xFFFFFFE1
#define   S_00B888_SOFT_GROUPING_ALLOCATION_TIMEOUT(x)                (((unsigned)(x) & 0xF) << 5)
#define   G_00B888_SOFT_GROUPING_ALLOCATION_TIMEOUT(x)                (((x) >> 5) & 0xF)
#define   C_00B888_SOFT_GROUPING_ALLOCATION_TIMEOUT                   0xFFFFFE1F
#define   S_00B888_HARD_LOCK_HYSTERESIS(x)                            (((unsigned)(x) & 0x1) << 9)
#define   G_00B888_HARD_LOCK_HYSTERESIS(x)                            (((x) >> 9) & 0x1)
#define   C_00B888_HARD_LOCK_HYSTERESIS                               0xFFFFFDFF
#define   S_00B888_HARD_LOCK_LOW_THRESHOLD(x)                         (((unsigned)(x) & 0x1F) << 10)
#define   G_00B888_HARD_LOCK_LOW_THRESHOLD(x)                         (((x) >> 10) & 0x1F)
#define   C_00B888_HARD_LOCK_LOW_THRESHOLD                            0xFFFF83FF
#define   S_00B888_PRODUCER_REQUEST_LOCKOUT(x)                        (((unsigned)(x) & 0x1) << 15)
#define   G_00B888_PRODUCER_REQUEST_LOCKOUT(x)                        (((x) >> 15) & 0x1)
#define   C_00B888_PRODUCER_REQUEST_LOCKOUT                           0xFFFF7FFF
#define   S_00B888_GLOBAL_SCANNING_EN(x)                              (((unsigned)(x) & 0x1) << 16)
#define   G_00B888_GLOBAL_SCANNING_EN(x)                              (((x) >> 16) & 0x1)
#define   C_00B888_GLOBAL_SCANNING_EN                                 0xFFFEFFFF
#define   S_00B888_ALLOCATION_RATE_THROTTLING_THRESHOLD(x)            (((unsigned)(x) & 0x7) << 17)
#define   G_00B888_ALLOCATION_RATE_THROTTLING_THRESHOLD(x)            (((x) >> 17) & 0x7)
#define   C_00B888_ALLOCATION_RATE_THROTTLING_THRESHOLD               0xFFF1FFFF
#define   S_00B888_DEDICATED_PREALLOCATION_BUFFER_LIMIT(x)            (((unsigned)(x) & 0x7F) << 20)
#define   G_00B888_DEDICATED_PREALLOCATION_BUFFER_LIMIT(x)            (((x) >> 20) & 0x7F)
#define   C_00B888_DEDICATED_PREALLOCATION_BUFFER_LIMIT               0xF80FFFFF
#define R_00B88C_COMPUTE_WAVE_RESTORE_ADDR_LO                           0x00B88C /* gfx8, gfx81, gfx9 */
#define R_00B890_COMPUTE_USER_ACCUM_0                                   0x00B890 /* >= gfx10 */
#define   S_00B890_CONTRIBUTION(x)                                    (((unsigned)(x) & 0x7F) << 0)
#define   G_00B890_CONTRIBUTION(x)                                    (((x) >> 0) & 0x7F)
#define   C_00B890_CONTRIBUTION                                       0xFFFFFF80
#define R_00B890_COMPUTE_WAVE_RESTORE_ADDR_HI                           0x00B890 /* gfx8, gfx81, gfx9 */
#define   S_00B890_ADDR(x)                                            (((unsigned)(x) & 0xFFFF) << 0)
#define   G_00B890_ADDR(x)                                            (((x) >> 0) & 0xFFFF)
#define   C_00B890_ADDR                                               0xFFFF0000
#define R_00B894_COMPUTE_SHADER_CHKSUM                                  0x00B894 /* gfx9 */
#define R_00B894_COMPUTE_USER_ACCUM_1                                   0x00B894 /* >= gfx10 */
#define R_00B894_COMPUTE_WAVE_RESTORE_CONTROL                           0x00B894 /* gfx8, gfx81 */
#define   S_00B894_ATC(x)                                             (((unsigned)(x) & 0x1) << 0)
#define   G_00B894_ATC(x)                                             (((x) >> 0) & 0x1)
#define   C_00B894_ATC                                                0xFFFFFFFE
#define   S_00B894_MTYPE(x)                                           (((unsigned)(x) & 0x3) << 1)
#define   G_00B894_MTYPE(x)                                           (((x) >> 1) & 0x3)
#define   C_00B894_MTYPE                                              0xFFFFFFF9
#define R_00B898_COMPUTE_USER_ACCUM_2                                   0x00B898 /* >= gfx10 */
#define R_00B89C_COMPUTE_USER_ACCUM_3                                   0x00B89C /* >= gfx10 */
#define R_00B8A0_COMPUTE_PGM_RSRC3                                      0x00B8A0 /* >= gfx10 */
#define   S_00B8A0_SHARED_VGPR_CNT(x)                                 (((unsigned)(x) & 0xF) << 0)
#define   G_00B8A0_SHARED_VGPR_CNT(x)                                 (((x) >> 0) & 0xF)
#define   C_00B8A0_SHARED_VGPR_CNT                                    0xFFFFFFF0
#define R_00B8A4_COMPUTE_DDID_INDEX                                     0x00B8A4 /* >= gfx10 */
#define   S_00B8A4_INDEX(x)                                           (((unsigned)(x) & 0x7FF) << 0)
#define   G_00B8A4_INDEX(x)                                           (((x) >> 0) & 0x7FF)
#define   C_00B8A4_INDEX                                              0xFFFFF800
#define R_00B8A8_COMPUTE_SHADER_CHKSUM                                  0x00B8A8 /* >= gfx10 */
#define R_00B8AC_COMPUTE_RELAUNCH                                       0x00B8AC /* >= gfx10 */
#define   S_00B8AC_PAYLOAD(x)                                         (((unsigned)(x) & 0x3FFFFFFF) << 0)
#define   G_00B8AC_PAYLOAD(x)                                         (((x) >> 0) & 0x3FFFFFFF)
#define   C_00B8AC_PAYLOAD                                            0xC0000000
#define   S_00B8AC_IS_EVENT(x)                                        (((unsigned)(x) & 0x1) << 30)
#define   G_00B8AC_IS_EVENT(x)                                        (((x) >> 30) & 0x1)
#define   C_00B8AC_IS_EVENT                                           0xBFFFFFFF
#define   S_00B8AC_IS_STATE(x)                                        (((unsigned)(x) & 0x1) << 31)
#define   G_00B8AC_IS_STATE(x)                                        (((x) >> 31) & 0x1)
#define   C_00B8AC_IS_STATE                                           0x7FFFFFFF
#define R_00B8B0_COMPUTE_WAVE_RESTORE_ADDR_LO                           0x00B8B0 /* >= gfx10 */
#define R_00B8B4_COMPUTE_WAVE_RESTORE_ADDR_HI                           0x00B8B4 /* >= gfx10 */
#define   S_00B8B4_ADDR(x)                                            (((unsigned)(x) & 0xFFFF) << 0)
#define   G_00B8B4_ADDR(x)                                            (((x) >> 0) & 0xFFFF)
#define   C_00B8B4_ADDR                                               0xFFFF0000
#define R_00B8B8_COMPUTE_RELAUNCH2                                      0x00B8B8 /* >= gfx10 */
#define R_00B900_COMPUTE_USER_DATA_0                                    0x00B900
#define R_00B904_COMPUTE_USER_DATA_1                                    0x00B904
#define R_00B908_COMPUTE_USER_DATA_2                                    0x00B908
#define R_00B90C_COMPUTE_USER_DATA_3                                    0x00B90C
#define R_00B910_COMPUTE_USER_DATA_4                                    0x00B910
#define R_00B914_COMPUTE_USER_DATA_5                                    0x00B914
#define R_00B918_COMPUTE_USER_DATA_6                                    0x00B918
#define R_00B91C_COMPUTE_USER_DATA_7                                    0x00B91C
#define R_00B920_COMPUTE_USER_DATA_8                                    0x00B920
#define R_00B924_COMPUTE_USER_DATA_9                                    0x00B924
#define R_00B928_COMPUTE_USER_DATA_10                                   0x00B928
#define R_00B92C_COMPUTE_USER_DATA_11                                   0x00B92C
#define R_00B930_COMPUTE_USER_DATA_12                                   0x00B930
#define R_00B934_COMPUTE_USER_DATA_13                                   0x00B934
#define R_00B938_COMPUTE_USER_DATA_14                                   0x00B938
#define R_00B93C_COMPUTE_USER_DATA_15                                   0x00B93C
#define R_00B9F4_COMPUTE_DISPATCH_TUNNEL                                0x00B9F4 /* >= gfx10 */
#define   S_00B9F4_OFF_DELAY(x)                                       (((unsigned)(x) & 0x3FF) << 0)
#define   G_00B9F4_OFF_DELAY(x)                                       (((x) >> 0) & 0x3FF)
#define   C_00B9F4_OFF_DELAY                                          0xFFFFFC00
#define   S_00B9F4_IMMEDIATE(x)                                       (((unsigned)(x) & 0x1) << 10)
#define   G_00B9F4_IMMEDIATE(x)                                       (((x) >> 10) & 0x1)
#define   C_00B9F4_IMMEDIATE                                          0xFFFFFBFF
#define R_00B9F8_COMPUTE_DISPATCH_END                                   0x00B9F8 /* >= gfx9 */
#define R_00B9FC_COMPUTE_NOWHERE                                        0x00B9FC /* >= gfx8 */
#define R_00BA00_SH_RESERVED_REG0                                       0x00BA00 /* >= gfx103 */
#define R_00BA04_SH_RESERVED_REG1                                       0x00BA04 /* >= gfx103 */
#define R_00D034_SDMA0_STATUS_REG                                       0x00D034 /* <= gfx81 */
#define   S_00D034_IDLE(x)                                            (((unsigned)(x) & 0x1) << 0)
#define   G_00D034_IDLE(x)                                            (((x) >> 0) & 0x1)
#define   C_00D034_IDLE                                               0xFFFFFFFE
#define   S_00D034_REG_IDLE(x)                                        (((unsigned)(x) & 0x1) << 1)
#define   G_00D034_REG_IDLE(x)                                        (((x) >> 1) & 0x1)
#define   C_00D034_REG_IDLE                                           0xFFFFFFFD
#define   S_00D034_RB_EMPTY(x)                                        (((unsigned)(x) & 0x1) << 2)
#define   G_00D034_RB_EMPTY(x)                                        (((x) >> 2) & 0x1)
#define   C_00D034_RB_EMPTY                                           0xFFFFFFFB
#define   S_00D034_RB_FULL(x)                                         (((unsigned)(x) & 0x1) << 3)
#define   G_00D034_RB_FULL(x)                                         (((x) >> 3) & 0x1)
#define   C_00D034_RB_FULL                                            0xFFFFFFF7
#define   S_00D034_RB_CMD_IDLE(x)                                     (((unsigned)(x) & 0x1) << 4)
#define   G_00D034_RB_CMD_IDLE(x)                                     (((x) >> 4) & 0x1)
#define   C_00D034_RB_CMD_IDLE                                        0xFFFFFFEF
#define   S_00D034_RB_CMD_FULL(x)                                     (((unsigned)(x) & 0x1) << 5)
#define   G_00D034_RB_CMD_FULL(x)                                     (((x) >> 5) & 0x1)
#define   C_00D034_RB_CMD_FULL                                        0xFFFFFFDF
#define   S_00D034_IB_CMD_IDLE(x)                                     (((unsigned)(x) & 0x1) << 6)
#define   G_00D034_IB_CMD_IDLE(x)                                     (((x) >> 6) & 0x1)
#define   C_00D034_IB_CMD_IDLE                                        0xFFFFFFBF
#define   S_00D034_IB_CMD_FULL(x)                                     (((unsigned)(x) & 0x1) << 7)
#define   G_00D034_IB_CMD_FULL(x)                                     (((x) >> 7) & 0x1)
#define   C_00D034_IB_CMD_FULL                                        0xFFFFFF7F
#define   S_00D034_BLOCK_IDLE(x)                                      (((unsigned)(x) & 0x1) << 8)
#define   G_00D034_BLOCK_IDLE(x)                                      (((x) >> 8) & 0x1)
#define   C_00D034_BLOCK_IDLE                                         0xFFFFFEFF
#define   S_00D034_INSIDE_IB(x)                                       (((unsigned)(x) & 0x1) << 9)
#define   G_00D034_INSIDE_IB(x)                                       (((x) >> 9) & 0x1)
#define   C_00D034_INSIDE_IB                                          0xFFFFFDFF
#define   S_00D034_EX_IDLE(x)                                         (((unsigned)(x) & 0x1) << 10)
#define   G_00D034_EX_IDLE(x)                                         (((x) >> 10) & 0x1)
#define   C_00D034_EX_IDLE                                            0xFFFFFBFF
#define   S_00D034_EX_IDLE_POLL_TIMER_EXPIRE(x)                       (((unsigned)(x) & 0x1) << 11)
#define   G_00D034_EX_IDLE_POLL_TIMER_EXPIRE(x)                       (((x) >> 11) & 0x1)
#define   C_00D034_EX_IDLE_POLL_TIMER_EXPIRE                          0xFFFFF7FF
#define   S_00D034_PACKET_READY(x)                                    (((unsigned)(x) & 0x1) << 12)
#define   G_00D034_PACKET_READY(x)                                    (((x) >> 12) & 0x1)
#define   C_00D034_PACKET_READY                                       0xFFFFEFFF
#define   S_00D034_MC_WR_IDLE(x)                                      (((unsigned)(x) & 0x1) << 13)
#define   G_00D034_MC_WR_IDLE(x)                                      (((x) >> 13) & 0x1)
#define   C_00D034_MC_WR_IDLE                                         0xFFFFDFFF
#define   S_00D034_SRBM_IDLE(x)                                       (((unsigned)(x) & 0x1) << 14)
#define   G_00D034_SRBM_IDLE(x)                                       (((x) >> 14) & 0x1)
#define   C_00D034_SRBM_IDLE                                          0xFFFFBFFF
#define   S_00D034_CONTEXT_EMPTY(x)                                   (((unsigned)(x) & 0x1) << 15)
#define   G_00D034_CONTEXT_EMPTY(x)                                   (((x) >> 15) & 0x1)
#define   C_00D034_CONTEXT_EMPTY                                      0xFFFF7FFF
#define   S_00D034_DELTA_RPTR_FULL(x)                                 (((unsigned)(x) & 0x1) << 16)
#define   G_00D034_DELTA_RPTR_FULL(x)                                 (((x) >> 16) & 0x1)
#define   C_00D034_DELTA_RPTR_FULL                                    0xFFFEFFFF
#define   S_00D034_RB_MC_RREQ_IDLE(x)                                 (((unsigned)(x) & 0x1) << 17)
#define   G_00D034_RB_MC_RREQ_IDLE(x)                                 (((x) >> 17) & 0x1)
#define   C_00D034_RB_MC_RREQ_IDLE                                    0xFFFDFFFF
#define   S_00D034_IB_MC_RREQ_IDLE(x)                                 (((unsigned)(x) & 0x1) << 18)
#define   G_00D034_IB_MC_RREQ_IDLE(x)                                 (((x) >> 18) & 0x1)
#define   C_00D034_IB_MC_RREQ_IDLE                                    0xFFFBFFFF
#define   S_00D034_MC_RD_IDLE(x)                                      (((unsigned)(x) & 0x1) << 19)
#define   G_00D034_MC_RD_IDLE(x)                                      (((x) >> 19) & 0x1)
#define   C_00D034_MC_RD_IDLE                                         0xFFF7FFFF
#define   S_00D034_DELTA_RPTR_EMPTY(x)                                (((unsigned)(x) & 0x1) << 20)
#define   G_00D034_DELTA_RPTR_EMPTY(x)                                (((x) >> 20) & 0x1)
#define   C_00D034_DELTA_RPTR_EMPTY                                   0xFFEFFFFF
#define   S_00D034_MC_RD_RET_STALL(x)                                 (((unsigned)(x) & 0x1) << 21)
#define   G_00D034_MC_RD_RET_STALL(x)                                 (((x) >> 21) & 0x1)
#define   C_00D034_MC_RD_RET_STALL                                    0xFFDFFFFF
#define   S_00D034_MC_RD_NO_POLL_IDLE(x)                              (((unsigned)(x) & 0x1) << 22)
#define   G_00D034_MC_RD_NO_POLL_IDLE(x)                              (((x) >> 22) & 0x1)
#define   C_00D034_MC_RD_NO_POLL_IDLE                                 0xFFBFFFFF
#define   S_00D034_PREV_CMD_IDLE(x)                                   (((unsigned)(x) & 0x1) << 25)
#define   G_00D034_PREV_CMD_IDLE(x)                                   (((x) >> 25) & 0x1)
#define   C_00D034_PREV_CMD_IDLE                                      0xFDFFFFFF
#define   S_00D034_SEM_IDLE(x)                                        (((unsigned)(x) & 0x1) << 26)
#define   G_00D034_SEM_IDLE(x)                                        (((x) >> 26) & 0x1)
#define   C_00D034_SEM_IDLE                                           0xFBFFFFFF
#define   S_00D034_SEM_REQ_STALL(x)                                   (((unsigned)(x) & 0x1) << 27)
#define   G_00D034_SEM_REQ_STALL(x)                                   (((x) >> 27) & 0x1)
#define   C_00D034_SEM_REQ_STALL                                      0xF7FFFFFF
#define   S_00D034_SEM_RESP_STATE(x)                                  (((unsigned)(x) & 0x3) << 28)
#define   G_00D034_SEM_RESP_STATE(x)                                  (((x) >> 28) & 0x3)
#define   C_00D034_SEM_RESP_STATE                                     0xCFFFFFFF
#define   S_00D034_INT_IDLE(x)                                        (((unsigned)(x) & 0x1) << 30)
#define   G_00D034_INT_IDLE(x)                                        (((x) >> 30) & 0x1)
#define   C_00D034_INT_IDLE                                           0xBFFFFFFF
#define   S_00D034_INT_REQ_STALL(x)                                   (((unsigned)(x) & 0x1) << 31)
#define   G_00D034_INT_REQ_STALL(x)                                   (((x) >> 31) & 0x1)
#define   C_00D034_INT_REQ_STALL                                      0x7FFFFFFF
#define R_00D834_SDMA1_STATUS_REG                                       0x00D834 /* <= gfx81 */
#define R_028000_DB_RENDER_CONTROL                                      0x028000
#define   S_028000_DEPTH_CLEAR_ENABLE(x)                              (((unsigned)(x) & 0x1) << 0)
#define   G_028000_DEPTH_CLEAR_ENABLE(x)                              (((x) >> 0) & 0x1)
#define   C_028000_DEPTH_CLEAR_ENABLE                                 0xFFFFFFFE
#define   S_028000_STENCIL_CLEAR_ENABLE(x)                            (((unsigned)(x) & 0x1) << 1)
#define   G_028000_STENCIL_CLEAR_ENABLE(x)                            (((x) >> 1) & 0x1)
#define   C_028000_STENCIL_CLEAR_ENABLE                               0xFFFFFFFD
#define   S_028000_DEPTH_COPY(x)                                      (((unsigned)(x) & 0x1) << 2)
#define   G_028000_DEPTH_COPY(x)                                      (((x) >> 2) & 0x1)
#define   C_028000_DEPTH_COPY                                         0xFFFFFFFB
#define   S_028000_STENCIL_COPY(x)                                    (((unsigned)(x) & 0x1) << 3)
#define   G_028000_STENCIL_COPY(x)                                    (((x) >> 3) & 0x1)
#define   C_028000_STENCIL_COPY                                       0xFFFFFFF7
#define   S_028000_RESUMMARIZE_ENABLE(x)                              (((unsigned)(x) & 0x1) << 4)
#define   G_028000_RESUMMARIZE_ENABLE(x)                              (((x) >> 4) & 0x1)
#define   C_028000_RESUMMARIZE_ENABLE                                 0xFFFFFFEF
#define   S_028000_STENCIL_COMPRESS_DISABLE(x)                        (((unsigned)(x) & 0x1) << 5)
#define   G_028000_STENCIL_COMPRESS_DISABLE(x)                        (((x) >> 5) & 0x1)
#define   C_028000_STENCIL_COMPRESS_DISABLE                           0xFFFFFFDF
#define   S_028000_DEPTH_COMPRESS_DISABLE(x)                          (((unsigned)(x) & 0x1) << 6)
#define   G_028000_DEPTH_COMPRESS_DISABLE(x)                          (((x) >> 6) & 0x1)
#define   C_028000_DEPTH_COMPRESS_DISABLE                             0xFFFFFFBF
#define   S_028000_COPY_CENTROID(x)                                   (((unsigned)(x) & 0x1) << 7)
#define   G_028000_COPY_CENTROID(x)                                   (((x) >> 7) & 0x1)
#define   C_028000_COPY_CENTROID                                      0xFFFFFF7F
#define   S_028000_COPY_SAMPLE(x)                                     (((unsigned)(x) & 0xF) << 8)
#define   G_028000_COPY_SAMPLE(x)                                     (((x) >> 8) & 0xF)
#define   C_028000_COPY_SAMPLE                                        0xFFFFF0FF
#define   S_028000_DECOMPRESS_ENABLE(x)                               (((unsigned)(x) & 0x1) << 12) /* >= gfx8 */
#define   G_028000_DECOMPRESS_ENABLE(x)                               (((x) >> 12) & 0x1)
#define   C_028000_DECOMPRESS_ENABLE                                  0xFFFFEFFF
#define   S_028000_PS_INVOKE_DISABLE(x)                               (((unsigned)(x) & 0x1) << 13) /* >= gfx103 */
#define   G_028000_PS_INVOKE_DISABLE(x)                               (((x) >> 13) & 0x1)
#define   C_028000_PS_INVOKE_DISABLE                                  0xFFFFDFFF
#define R_028004_DB_COUNT_CONTROL                                       0x028004
#define   S_028004_ZPASS_INCREMENT_DISABLE(x)                         (((unsigned)(x) & 0x1) << 0)
#define   G_028004_ZPASS_INCREMENT_DISABLE(x)                         (((x) >> 0) & 0x1)
#define   C_028004_ZPASS_INCREMENT_DISABLE                            0xFFFFFFFE
#define   S_028004_PERFECT_ZPASS_COUNTS(x)                            (((unsigned)(x) & 0x1) << 1)
#define   G_028004_PERFECT_ZPASS_COUNTS(x)                            (((x) >> 1) & 0x1)
#define   C_028004_PERFECT_ZPASS_COUNTS                               0xFFFFFFFD
#define   S_028004_DISABLE_CONSERVATIVE_ZPASS_COUNTS(x)               (((unsigned)(x) & 0x1) << 2) /* >= gfx10 */
#define   G_028004_DISABLE_CONSERVATIVE_ZPASS_COUNTS(x)               (((x) >> 2) & 0x1)
#define   C_028004_DISABLE_CONSERVATIVE_ZPASS_COUNTS                  0xFFFFFFFB
#define   S_028004_ENHANCED_CONSERVATIVE_ZPASS_COUNTS(x)              (((unsigned)(x) & 0x1) << 3) /* >= gfx10 */
#define   G_028004_ENHANCED_CONSERVATIVE_ZPASS_COUNTS(x)              (((x) >> 3) & 0x1)
#define   C_028004_ENHANCED_CONSERVATIVE_ZPASS_COUNTS                 0xFFFFFFF7
#define   S_028004_SAMPLE_RATE(x)                                     (((unsigned)(x) & 0x7) << 4)
#define   G_028004_SAMPLE_RATE(x)                                     (((x) >> 4) & 0x7)
#define   C_028004_SAMPLE_RATE                                        0xFFFFFF8F
#define   S_028004_ZPASS_ENABLE(x)                                    (((unsigned)(x) & 0xF) << 8)
#define   G_028004_ZPASS_ENABLE(x)                                    (((x) >> 8) & 0xF)
#define   C_028004_ZPASS_ENABLE                                       0xFFFFF0FF
#define   S_028004_ZFAIL_ENABLE(x)                                    (((unsigned)(x) & 0xF) << 12)
#define   G_028004_ZFAIL_ENABLE(x)                                    (((x) >> 12) & 0xF)
#define   C_028004_ZFAIL_ENABLE                                       0xFFFF0FFF
#define   S_028004_SFAIL_ENABLE(x)                                    (((unsigned)(x) & 0xF) << 16)
#define   G_028004_SFAIL_ENABLE(x)                                    (((x) >> 16) & 0xF)
#define   C_028004_SFAIL_ENABLE                                       0xFFF0FFFF
#define   S_028004_DBFAIL_ENABLE(x)                                   (((unsigned)(x) & 0xF) << 20)
#define   G_028004_DBFAIL_ENABLE(x)                                   (((x) >> 20) & 0xF)
#define   C_028004_DBFAIL_ENABLE                                      0xFF0FFFFF
#define   S_028004_SLICE_EVEN_ENABLE(x)                               (((unsigned)(x) & 0xF) << 24)
#define   G_028004_SLICE_EVEN_ENABLE(x)                               (((x) >> 24) & 0xF)
#define   C_028004_SLICE_EVEN_ENABLE                                  0xF0FFFFFF
#define   S_028004_SLICE_ODD_ENABLE(x)                                (((unsigned)(x) & 0xF) << 28)
#define   G_028004_SLICE_ODD_ENABLE(x)                                (((x) >> 28) & 0xF)
#define   C_028004_SLICE_ODD_ENABLE                                   0x0FFFFFFF
#define R_028008_DB_DEPTH_VIEW                                          0x028008
#define   S_028008_SLICE_START(x)                                     (((unsigned)(x) & 0x7FF) << 0)
#define   G_028008_SLICE_START(x)                                     (((x) >> 0) & 0x7FF)
#define   C_028008_SLICE_START                                        0xFFFFF800
#define   S_028008_SLICE_START_HI(x)                                  (((unsigned)(x) & 0x3) << 11) /* >= gfx10 */
#define   G_028008_SLICE_START_HI(x)                                  (((x) >> 11) & 0x3)
#define   C_028008_SLICE_START_HI                                     0xFFFFE7FF
#define   S_028008_SLICE_MAX(x)                                       (((unsigned)(x) & 0x7FF) << 13)
#define   G_028008_SLICE_MAX(x)                                       (((x) >> 13) & 0x7FF)
#define   C_028008_SLICE_MAX                                          0xFF001FFF
#define   S_028008_Z_READ_ONLY(x)                                     (((unsigned)(x) & 0x1) << 24)
#define   G_028008_Z_READ_ONLY(x)                                     (((x) >> 24) & 0x1)
#define   C_028008_Z_READ_ONLY                                        0xFEFFFFFF
#define   S_028008_STENCIL_READ_ONLY(x)                               (((unsigned)(x) & 0x1) << 25)
#define   G_028008_STENCIL_READ_ONLY(x)                               (((x) >> 25) & 0x1)
#define   C_028008_STENCIL_READ_ONLY                                  0xFDFFFFFF
#define   S_028008_MIPID(x)                                           (((unsigned)(x) & 0xF) << 26) /* >= gfx9 */
#define   G_028008_MIPID(x)                                           (((x) >> 26) & 0xF)
#define   C_028008_MIPID                                              0xC3FFFFFF
#define   S_028008_SLICE_MAX_HI(x)                                    (((unsigned)(x) & 0x3) << 30) /* >= gfx10 */
#define   G_028008_SLICE_MAX_HI(x)                                    (((x) >> 30) & 0x3)
#define   C_028008_SLICE_MAX_HI                                       0x3FFFFFFF
#define R_02800C_DB_RENDER_OVERRIDE                                     0x02800C
#define   S_02800C_FORCE_HIZ_ENABLE(x)                                (((unsigned)(x) & 0x3) << 0)
#define   G_02800C_FORCE_HIZ_ENABLE(x)                                (((x) >> 0) & 0x3)
#define   C_02800C_FORCE_HIZ_ENABLE                                   0xFFFFFFFC
#define     V_02800C_FORCE_OFF                                      0
#define     V_02800C_FORCE_ENABLE                                   1
#define     V_02800C_FORCE_DISABLE                                  2
#define     V_02800C_FORCE_RESERVED                                 3
#define   S_02800C_FORCE_HIS_ENABLE0(x)                               (((unsigned)(x) & 0x3) << 2)
#define   G_02800C_FORCE_HIS_ENABLE0(x)                               (((x) >> 2) & 0x3)
#define   C_02800C_FORCE_HIS_ENABLE0                                  0xFFFFFFF3
#define   S_02800C_FORCE_HIS_ENABLE1(x)                               (((unsigned)(x) & 0x3) << 4)
#define   G_02800C_FORCE_HIS_ENABLE1(x)                               (((x) >> 4) & 0x3)
#define   C_02800C_FORCE_HIS_ENABLE1                                  0xFFFFFFCF
#define   S_02800C_FORCE_SHADER_Z_ORDER(x)                            (((unsigned)(x) & 0x1) << 6)
#define   G_02800C_FORCE_SHADER_Z_ORDER(x)                            (((x) >> 6) & 0x1)
#define   C_02800C_FORCE_SHADER_Z_ORDER                               0xFFFFFFBF
#define   S_02800C_FAST_Z_DISABLE(x)                                  (((unsigned)(x) & 0x1) << 7)
#define   G_02800C_FAST_Z_DISABLE(x)                                  (((x) >> 7) & 0x1)
#define   C_02800C_FAST_Z_DISABLE                                     0xFFFFFF7F
#define   S_02800C_FAST_STENCIL_DISABLE(x)                            (((unsigned)(x) & 0x1) << 8)
#define   G_02800C_FAST_STENCIL_DISABLE(x)                            (((x) >> 8) & 0x1)
#define   C_02800C_FAST_STENCIL_DISABLE                               0xFFFFFEFF
#define   S_02800C_NOOP_CULL_DISABLE(x)                               (((unsigned)(x) & 0x1) << 9)
#define   G_02800C_NOOP_CULL_DISABLE(x)                               (((x) >> 9) & 0x1)
#define   C_02800C_NOOP_CULL_DISABLE                                  0xFFFFFDFF
#define   S_02800C_FORCE_COLOR_KILL(x)                                (((unsigned)(x) & 0x1) << 10)
#define   G_02800C_FORCE_COLOR_KILL(x)                                (((x) >> 10) & 0x1)
#define   C_02800C_FORCE_COLOR_KILL                                   0xFFFFFBFF
#define   S_02800C_FORCE_Z_READ(x)                                    (((unsigned)(x) & 0x1) << 11)
#define   G_02800C_FORCE_Z_READ(x)                                    (((x) >> 11) & 0x1)
#define   C_02800C_FORCE_Z_READ                                       0xFFFFF7FF
#define   S_02800C_FORCE_STENCIL_READ(x)                              (((unsigned)(x) & 0x1) << 12)
#define   G_02800C_FORCE_STENCIL_READ(x)                              (((x) >> 12) & 0x1)
#define   C_02800C_FORCE_STENCIL_READ                                 0xFFFFEFFF
#define   S_02800C_FORCE_FULL_Z_RANGE(x)                              (((unsigned)(x) & 0x3) << 13)
#define   G_02800C_FORCE_FULL_Z_RANGE(x)                              (((x) >> 13) & 0x3)
#define   C_02800C_FORCE_FULL_Z_RANGE                                 0xFFFF9FFF
#define   S_02800C_FORCE_QC_SMASK_CONFLICT(x)                         (((unsigned)(x) & 0x1) << 15)
#define   G_02800C_FORCE_QC_SMASK_CONFLICT(x)                         (((x) >> 15) & 0x1)
#define   C_02800C_FORCE_QC_SMASK_CONFLICT                            0xFFFF7FFF
#define   S_02800C_DISABLE_VIEWPORT_CLAMP(x)                          (((unsigned)(x) & 0x1) << 16)
#define   G_02800C_DISABLE_VIEWPORT_CLAMP(x)                          (((x) >> 16) & 0x1)
#define   C_02800C_DISABLE_VIEWPORT_CLAMP                             0xFFFEFFFF
#define   S_02800C_IGNORE_SC_ZRANGE(x)                                (((unsigned)(x) & 0x1) << 17)
#define   G_02800C_IGNORE_SC_ZRANGE(x)                                (((x) >> 17) & 0x1)
#define   C_02800C_IGNORE_SC_ZRANGE                                   0xFFFDFFFF
#define   S_02800C_DISABLE_FULLY_COVERED(x)                           (((unsigned)(x) & 0x1) << 18)
#define   G_02800C_DISABLE_FULLY_COVERED(x)                           (((x) >> 18) & 0x1)
#define   C_02800C_DISABLE_FULLY_COVERED                              0xFFFBFFFF
#define   S_02800C_FORCE_Z_LIMIT_SUMM(x)                              (((unsigned)(x) & 0x3) << 19)
#define   G_02800C_FORCE_Z_LIMIT_SUMM(x)                              (((x) >> 19) & 0x3)
#define   C_02800C_FORCE_Z_LIMIT_SUMM                                 0xFFE7FFFF
#define     V_02800C_FORCE_SUMM_OFF                                 0
#define     V_02800C_FORCE_SUMM_MINZ                                1
#define     V_02800C_FORCE_SUMM_MAXZ                                2
#define     V_02800C_FORCE_SUMM_BOTH                                3
#define   S_02800C_MAX_TILES_IN_DTT(x)                                (((unsigned)(x) & 0x1F) << 21)
#define   G_02800C_MAX_TILES_IN_DTT(x)                                (((x) >> 21) & 0x1F)
#define   C_02800C_MAX_TILES_IN_DTT                                   0xFC1FFFFF
#define   S_02800C_DISABLE_TILE_RATE_TILES(x)                         (((unsigned)(x) & 0x1) << 26)
#define   G_02800C_DISABLE_TILE_RATE_TILES(x)                         (((x) >> 26) & 0x1)
#define   C_02800C_DISABLE_TILE_RATE_TILES                            0xFBFFFFFF
#define   S_02800C_FORCE_Z_DIRTY(x)                                   (((unsigned)(x) & 0x1) << 27)
#define   G_02800C_FORCE_Z_DIRTY(x)                                   (((x) >> 27) & 0x1)
#define   C_02800C_FORCE_Z_DIRTY                                      0xF7FFFFFF
#define   S_02800C_FORCE_STENCIL_DIRTY(x)                             (((unsigned)(x) & 0x1) << 28)
#define   G_02800C_FORCE_STENCIL_DIRTY(x)                             (((x) >> 28) & 0x1)
#define   C_02800C_FORCE_STENCIL_DIRTY                                0xEFFFFFFF
#define   S_02800C_FORCE_Z_VALID(x)                                   (((unsigned)(x) & 0x1) << 29)
#define   G_02800C_FORCE_Z_VALID(x)                                   (((x) >> 29) & 0x1)
#define   C_02800C_FORCE_Z_VALID                                      0xDFFFFFFF
#define   S_02800C_FORCE_STENCIL_VALID(x)                             (((unsigned)(x) & 0x1) << 30)
#define   G_02800C_FORCE_STENCIL_VALID(x)                             (((x) >> 30) & 0x1)
#define   C_02800C_FORCE_STENCIL_VALID                                0xBFFFFFFF
#define   S_02800C_PRESERVE_COMPRESSION(x)                            (((unsigned)(x) & 0x1) << 31)
#define   G_02800C_PRESERVE_COMPRESSION(x)                            (((x) >> 31) & 0x1)
#define   C_02800C_PRESERVE_COMPRESSION                               0x7FFFFFFF
#define R_028010_DB_RENDER_OVERRIDE2                                    0x028010
#define   S_028010_PARTIAL_SQUAD_LAUNCH_CONTROL(x)                    (((unsigned)(x) & 0x3) << 0)
#define   G_028010_PARTIAL_SQUAD_LAUNCH_CONTROL(x)                    (((x) >> 0) & 0x3)
#define   C_028010_PARTIAL_SQUAD_LAUNCH_CONTROL                       0xFFFFFFFC
#define     V_028010_PSLC_AUTO                                      0
#define     V_028010_PSLC_ON_HANG_ONLY                              1
#define     V_028010_PSLC_ASAP                                      2
#define     V_028010_PSLC_COUNTDOWN                                 3
#define   S_028010_PARTIAL_SQUAD_LAUNCH_COUNTDOWN(x)                  (((unsigned)(x) & 0x7) << 2)
#define   G_028010_PARTIAL_SQUAD_LAUNCH_COUNTDOWN(x)                  (((x) >> 2) & 0x7)
#define   C_028010_PARTIAL_SQUAD_LAUNCH_COUNTDOWN                     0xFFFFFFE3
#define   S_028010_DISABLE_ZMASK_EXPCLEAR_OPTIMIZATION(x)             (((unsigned)(x) & 0x1) << 5)
#define   G_028010_DISABLE_ZMASK_EXPCLEAR_OPTIMIZATION(x)             (((x) >> 5) & 0x1)
#define   C_028010_DISABLE_ZMASK_EXPCLEAR_OPTIMIZATION                0xFFFFFFDF
#define   S_028010_DISABLE_SMEM_EXPCLEAR_OPTIMIZATION(x)              (((unsigned)(x) & 0x1) << 6)
#define   G_028010_DISABLE_SMEM_EXPCLEAR_OPTIMIZATION(x)              (((x) >> 6) & 0x1)
#define   C_028010_DISABLE_SMEM_EXPCLEAR_OPTIMIZATION                 0xFFFFFFBF
#define   S_028010_DISABLE_COLOR_ON_VALIDATION(x)                     (((unsigned)(x) & 0x1) << 7)
#define   G_028010_DISABLE_COLOR_ON_VALIDATION(x)                     (((x) >> 7) & 0x1)
#define   C_028010_DISABLE_COLOR_ON_VALIDATION                        0xFFFFFF7F
#define   S_028010_DECOMPRESS_Z_ON_FLUSH(x)                           (((unsigned)(x) & 0x1) << 8)
#define   G_028010_DECOMPRESS_Z_ON_FLUSH(x)                           (((x) >> 8) & 0x1)
#define   C_028010_DECOMPRESS_Z_ON_FLUSH                              0xFFFFFEFF
#define   S_028010_DISABLE_REG_SNOOP(x)                               (((unsigned)(x) & 0x1) << 9)
#define   G_028010_DISABLE_REG_SNOOP(x)                               (((x) >> 9) & 0x1)
#define   C_028010_DISABLE_REG_SNOOP                                  0xFFFFFDFF
#define   S_028010_DEPTH_BOUNDS_HIER_DEPTH_DISABLE(x)                 (((unsigned)(x) & 0x1) << 10)
#define   G_028010_DEPTH_BOUNDS_HIER_DEPTH_DISABLE(x)                 (((x) >> 10) & 0x1)
#define   C_028010_DEPTH_BOUNDS_HIER_DEPTH_DISABLE                    0xFFFFFBFF
#define   S_028010_SEPARATE_HIZS_FUNC_ENABLE(x)                       (((unsigned)(x) & 0x1) << 11)
#define   G_028010_SEPARATE_HIZS_FUNC_ENABLE(x)                       (((x) >> 11) & 0x1)
#define   C_028010_SEPARATE_HIZS_FUNC_ENABLE                          0xFFFFF7FF
#define   S_028010_HIZ_ZFUNC(x)                                       (((unsigned)(x) & 0x7) << 12)
#define   G_028010_HIZ_ZFUNC(x)                                       (((x) >> 12) & 0x7)
#define   C_028010_HIZ_ZFUNC                                          0xFFFF8FFF
#define     V_028010_FRAG_NEVER                                     0
#define     V_028010_FRAG_LESS                                      1
#define     V_028010_FRAG_EQUAL                                     2
#define     V_028010_FRAG_LEQUAL                                    3
#define     V_028010_FRAG_GREATER                                   4
#define     V_028010_FRAG_NOTEQUAL                                  5
#define     V_028010_FRAG_GEQUAL                                    6
#define     V_028010_FRAG_ALWAYS                                    7
#define   S_028010_HIS_SFUNC_FF(x)                                    (((unsigned)(x) & 0x7) << 15)
#define   G_028010_HIS_SFUNC_FF(x)                                    (((x) >> 15) & 0x7)
#define   C_028010_HIS_SFUNC_FF                                       0xFFFC7FFF
#define   S_028010_HIS_SFUNC_BF(x)                                    (((unsigned)(x) & 0x7) << 18)
#define   G_028010_HIS_SFUNC_BF(x)                                    (((x) >> 18) & 0x7)
#define   C_028010_HIS_SFUNC_BF                                       0xFFE3FFFF
#define   S_028010_PRESERVE_ZRANGE(x)                                 (((unsigned)(x) & 0x1) << 21)
#define   G_028010_PRESERVE_ZRANGE(x)                                 (((x) >> 21) & 0x1)
#define   C_028010_PRESERVE_ZRANGE                                    0xFFDFFFFF
#define   S_028010_PRESERVE_SRESULTS(x)                               (((unsigned)(x) & 0x1) << 22)
#define   G_028010_PRESERVE_SRESULTS(x)                               (((x) >> 22) & 0x1)
#define   C_028010_PRESERVE_SRESULTS                                  0xFFBFFFFF
#define   S_028010_DISABLE_FAST_PASS(x)                               (((unsigned)(x) & 0x1) << 23)
#define   G_028010_DISABLE_FAST_PASS(x)                               (((x) >> 23) & 0x1)
#define   C_028010_DISABLE_FAST_PASS                                  0xFF7FFFFF
#define   S_028010_ALLOW_PARTIAL_RES_HIER_KILL(x)                     (((unsigned)(x) & 0x1) << 25) /* >= gfx9 */
#define   G_028010_ALLOW_PARTIAL_RES_HIER_KILL(x)                     (((x) >> 25) & 0x1)
#define   C_028010_ALLOW_PARTIAL_RES_HIER_KILL                        0xFDFFFFFF
#define   S_028010_FORCE_VRS_RATE_FINE(x)                             (((unsigned)(x) & 0x1) << 26) /* >= gfx103 */
#define   G_028010_FORCE_VRS_RATE_FINE(x)                             (((x) >> 26) & 0x1)
#define   C_028010_FORCE_VRS_RATE_FINE                                0xFBFFFFFF
#define   S_028010_CENTROID_COMPUTATION_MODE(x)                       (((unsigned)(x) & 0x3) << 27) /* >= gfx103 */
#define   G_028010_CENTROID_COMPUTATION_MODE(x)                       (((x) >> 27) & 0x3)
#define   C_028010_CENTROID_COMPUTATION_MODE                          0xE7FFFFFF
#define R_028014_DB_HTILE_DATA_BASE                                     0x028014
#define R_028018_DB_HTILE_DATA_BASE_HI                                  0x028018 /* gfx9 */
#define   S_028018_BASE_HI(x)                                         (((unsigned)(x) & 0xFF) << 0)
#define   G_028018_BASE_HI(x)                                         (((x) >> 0) & 0xFF)
#define   C_028018_BASE_HI                                            0xFFFFFF00
#define R_02801C_DB_DEPTH_SIZE                                          0x02801C /* gfx9 */
#define   S_02801C_X_MAX(x)                                           (((unsigned)(x) & 0x3FFF) << 0)
#define   G_02801C_X_MAX(x)                                           (((x) >> 0) & 0x3FFF)
#define   C_02801C_X_MAX                                              0xFFFFC000
#define   S_02801C_Y_MAX(x)                                           (((unsigned)(x) & 0x3FFF) << 16)
#define   G_02801C_Y_MAX(x)                                           (((x) >> 16) & 0x3FFF)
#define   C_02801C_Y_MAX                                              0xC000FFFF
#define R_02801C_DB_DEPTH_SIZE_XY                                       0x02801C /* >= gfx10 */
#define R_028020_DB_DEPTH_BOUNDS_MIN                                    0x028020
#define R_028024_DB_DEPTH_BOUNDS_MAX                                    0x028024
#define R_028028_DB_STENCIL_CLEAR                                       0x028028
#define   S_028028_CLEAR(x)                                           (((unsigned)(x) & 0xFF) << 0)
#define   G_028028_CLEAR(x)                                           (((x) >> 0) & 0xFF)
#define   C_028028_CLEAR                                              0xFFFFFF00
#define R_02802C_DB_DEPTH_CLEAR                                         0x02802C
#define R_028030_PA_SC_SCREEN_SCISSOR_TL                                0x028030
#define   S_028030_TL_X(x)                                            (((unsigned)(x) & 0xFFFF) << 0)
#define   G_028030_TL_X(x)                                            (((x) >> 0) & 0xFFFF)
#define   C_028030_TL_X                                               0xFFFF0000
#define   S_028030_TL_Y(x)                                            (((unsigned)(x) & 0xFFFF) << 16)
#define   G_028030_TL_Y(x)                                            (((x) >> 16) & 0xFFFF)
#define   C_028030_TL_Y                                               0x0000FFFF
#define R_028034_PA_SC_SCREEN_SCISSOR_BR                                0x028034
#define   S_028034_BR_X(x)                                            (((unsigned)(x) & 0xFFFF) << 0)
#define   G_028034_BR_X(x)                                            (((x) >> 0) & 0xFFFF)
#define   C_028034_BR_X                                               0xFFFF0000
#define   S_028034_BR_Y(x)                                            (((unsigned)(x) & 0xFFFF) << 16)
#define   G_028034_BR_Y(x)                                            (((x) >> 16) & 0xFFFF)
#define   C_028034_BR_Y                                               0x0000FFFF
#define R_028038_DB_DFSM_CONTROL                                        0x028038 /* >= gfx10 */
#define   S_028038_PUNCHOUT_MODE(x)                                   (((unsigned)(x) & 0x3) << 0)
#define   G_028038_PUNCHOUT_MODE(x)                                   (((x) >> 0) & 0x3)
#define   C_028038_PUNCHOUT_MODE                                      0xFFFFFFFC
#define     V_028038_AUTO                                           0
#define     V_028038_FORCE_ON                                       1
#define     V_028038_FORCE_OFF                                      2
#define     V_028038_RESERVED                                       3
#define   S_028038_POPS_DRAIN_PS_ON_OVERLAP(x)                        (((unsigned)(x) & 0x1) << 2)
#define   G_028038_POPS_DRAIN_PS_ON_OVERLAP(x)                        (((x) >> 2) & 0x1)
#define   C_028038_POPS_DRAIN_PS_ON_OVERLAP                           0xFFFFFFFB
#define   S_028038_DISALLOW_OVERFLOW(x)                               (((unsigned)(x) & 0x1) << 3)
#define   G_028038_DISALLOW_OVERFLOW(x)                               (((x) >> 3) & 0x1)
#define   C_028038_DISALLOW_OVERFLOW                                  0xFFFFFFF7
#define R_028038_DB_Z_INFO                                              0x028038 /* gfx9 */
#define   S_028038_FORMAT(x)                                          (((unsigned)(x) & 0x3) << 0)
#define   G_028038_FORMAT(x)                                          (((x) >> 0) & 0x3)
#define   C_028038_FORMAT                                             0xFFFFFFFC
#define     V_028038_Z_INVALID                                      0
#define     V_028038_Z_16                                           1
#define     V_028038_Z_24                                           2
#define     V_028038_Z_32_FLOAT                                     3
#define   S_028038_NUM_SAMPLES(x)                                     (((unsigned)(x) & 0x3) << 2)
#define   G_028038_NUM_SAMPLES(x)                                     (((x) >> 2) & 0x3)
#define   C_028038_NUM_SAMPLES                                        0xFFFFFFF3
#define   S_028038_SW_MODE(x)                                         (((unsigned)(x) & 0x1F) << 4)
#define   G_028038_SW_MODE(x)                                         (((x) >> 4) & 0x1F)
#define   C_028038_SW_MODE                                            0xFFFFFE0F
#define   S_028038_PARTIALLY_RESIDENT(x)                              (((unsigned)(x) & 0x1) << 12)
#define   G_028038_PARTIALLY_RESIDENT(x)                              (((x) >> 12) & 0x1)
#define   C_028038_PARTIALLY_RESIDENT                                 0xFFFFEFFF
#define   S_028038_FAULT_BEHAVIOR(x)                                  (((unsigned)(x) & 0x3) << 13)
#define   G_028038_FAULT_BEHAVIOR(x)                                  (((x) >> 13) & 0x3)
#define   C_028038_FAULT_BEHAVIOR                                     0xFFFF9FFF
#define     V_028038_FAULT_ZERO                                     0
#define     V_028038_FAULT_ONE                                      1
#define     V_028038_FAULT_FAIL                                     2
#define     V_028038_FAULT_PASS                                     3
#define   S_028038_ITERATE_FLUSH(x)                                   (((unsigned)(x) & 0x1) << 15)
#define   G_028038_ITERATE_FLUSH(x)                                   (((x) >> 15) & 0x1)
#define   C_028038_ITERATE_FLUSH                                      0xFFFF7FFF
#define   S_028038_MAXMIP(x)                                          (((unsigned)(x) & 0xF) << 16)
#define   G_028038_MAXMIP(x)                                          (((x) >> 16) & 0xF)
#define   C_028038_MAXMIP                                             0xFFF0FFFF
#define   S_028038_DECOMPRESS_ON_N_ZPLANES(x)                         (((unsigned)(x) & 0xF) << 23)
#define   G_028038_DECOMPRESS_ON_N_ZPLANES(x)                         (((x) >> 23) & 0xF)
#define   C_028038_DECOMPRESS_ON_N_ZPLANES                            0xF87FFFFF
#define   S_028038_ALLOW_EXPCLEAR(x)                                  (((unsigned)(x) & 0x1) << 27)
#define   G_028038_ALLOW_EXPCLEAR(x)                                  (((x) >> 27) & 0x1)
#define   C_028038_ALLOW_EXPCLEAR                                     0xF7FFFFFF
#define   S_028038_READ_SIZE(x)                                       (((unsigned)(x) & 0x1) << 28)
#define   G_028038_READ_SIZE(x)                                       (((x) >> 28) & 0x1)
#define   C_028038_READ_SIZE                                          0xEFFFFFFF
#define   S_028038_TILE_SURFACE_ENABLE(x)                             (((unsigned)(x) & 0x1) << 29)
#define   G_028038_TILE_SURFACE_ENABLE(x)                             (((x) >> 29) & 0x1)
#define   C_028038_TILE_SURFACE_ENABLE                                0xDFFFFFFF
#define   S_028038_CLEAR_DISALLOWED(x)                                (((unsigned)(x) & 0x1) << 30)
#define   G_028038_CLEAR_DISALLOWED(x)                                (((x) >> 30) & 0x1)
#define   C_028038_CLEAR_DISALLOWED                                   0xBFFFFFFF
#define   S_028038_ZRANGE_PRECISION(x)                                (((unsigned)(x) & 0x1) << 31)
#define   G_028038_ZRANGE_PRECISION(x)                                (((x) >> 31) & 0x1)
#define   C_028038_ZRANGE_PRECISION                                   0x7FFFFFFF
#define R_02803C_DB_DEPTH_INFO                                          0x02803C /* <= gfx81 */
#define   S_02803C_ADDR5_SWIZZLE_MASK(x)                              (((unsigned)(x) & 0xF) << 0)
#define   G_02803C_ADDR5_SWIZZLE_MASK(x)                              (((x) >> 0) & 0xF)
#define   C_02803C_ADDR5_SWIZZLE_MASK                                 0xFFFFFFF0
#define   S_02803C_ARRAY_MODE(x)                                      (((unsigned)(x) & 0xF) << 4)
#define   G_02803C_ARRAY_MODE(x)                                      (((x) >> 4) & 0xF)
#define   C_02803C_ARRAY_MODE                                         0xFFFFFF0F
#define     V_02803C_ARRAY_LINEAR_GENERAL                           0
#define     V_02803C_ARRAY_LINEAR_ALIGNED                           1
#define     V_02803C_ARRAY_1D_TILED_THIN1                           2
#define     V_02803C_ARRAY_1D_TILED_THICK                           3
#define     V_02803C_ARRAY_2D_TILED_THIN1                           4
#define     V_02803C_ARRAY_PRT_TILED_THIN1                          5
#define     V_02803C_ARRAY_PRT_2D_TILED_THIN1                       6
#define     V_02803C_ARRAY_2D_TILED_THICK                           7
#define     V_02803C_ARRAY_2D_TILED_XTHICK                          8
#define     V_02803C_ARRAY_PRT_TILED_THICK                          9
#define     V_02803C_ARRAY_PRT_2D_TILED_THICK                       10
#define     V_02803C_ARRAY_PRT_3D_TILED_THIN1                       11
#define     V_02803C_ARRAY_3D_TILED_THIN1                           12
#define     V_02803C_ARRAY_3D_TILED_THICK                           13
#define     V_02803C_ARRAY_3D_TILED_XTHICK                          14
#define     V_02803C_ARRAY_PRT_3D_TILED_THICK                       15
#define   S_02803C_PIPE_CONFIG(x)                                     (((unsigned)(x) & 0x1F) << 8)
#define   G_02803C_PIPE_CONFIG(x)                                     (((x) >> 8) & 0x1F)
#define   C_02803C_PIPE_CONFIG                                        0xFFFFE0FF
#define     V_02803C_ADDR_SURF_P2                                   0
#define     V_02803C_ADDR_SURF_P2_RESERVED0                         1
#define     V_02803C_ADDR_SURF_P2_RESERVED1                         2
#define     V_02803C_ADDR_SURF_P2_RESERVED2                         3
#define     V_02803C_ADDR_SURF_P4_8x16                              4
#define     V_02803C_ADDR_SURF_P4_16x16                             5
#define     V_02803C_ADDR_SURF_P4_16x32                             6
#define     V_02803C_ADDR_SURF_P4_32x32                             7
#define     V_02803C_ADDR_SURF_P8_16x16_8x16                        8
#define     V_02803C_ADDR_SURF_P8_16x32_8x16                        9
#define     V_02803C_ADDR_SURF_P8_32x32_8x16                        10
#define     V_02803C_ADDR_SURF_P8_16x32_16x16                       11
#define     V_02803C_ADDR_SURF_P8_32x32_16x16                       12
#define     V_02803C_ADDR_SURF_P8_32x32_16x32                       13
#define     V_02803C_ADDR_SURF_P8_32x64_32x32                       14
#define     V_02803C_ADDR_SURF_P8_RESERVED0                         15
#define     V_02803C_ADDR_SURF_P16_32x32_8x16                       16
#define     V_02803C_ADDR_SURF_P16_32x32_16x16                      17
#define   S_02803C_BANK_WIDTH(x)                                      (((unsigned)(x) & 0x3) << 13)
#define   G_02803C_BANK_WIDTH(x)                                      (((x) >> 13) & 0x3)
#define   C_02803C_BANK_WIDTH                                         0xFFFF9FFF
#define     V_02803C_ADDR_SURF_BANK_WIDTH_1                         0
#define     V_02803C_ADDR_SURF_BANK_WIDTH_2                         1
#define     V_02803C_ADDR_SURF_BANK_WIDTH_4                         2
#define     V_02803C_ADDR_SURF_BANK_WIDTH_8                         3
#define   S_02803C_BANK_HEIGHT(x)                                     (((unsigned)(x) & 0x3) << 15)
#define   G_02803C_BANK_HEIGHT(x)                                     (((x) >> 15) & 0x3)
#define   C_02803C_BANK_HEIGHT                                        0xFFFE7FFF
#define     V_02803C_ADDR_SURF_BANK_HEIGHT_1                        0
#define     V_02803C_ADDR_SURF_BANK_HEIGHT_2                        1
#define     V_02803C_ADDR_SURF_BANK_HEIGHT_4                        2
#define     V_02803C_ADDR_SURF_BANK_HEIGHT_8                        3
#define   S_02803C_MACRO_TILE_ASPECT(x)                               (((unsigned)(x) & 0x3) << 17)
#define   G_02803C_MACRO_TILE_ASPECT(x)                               (((x) >> 17) & 0x3)
#define   C_02803C_MACRO_TILE_ASPECT                                  0xFFF9FFFF
#define     V_02803C_ADDR_SURF_MACRO_ASPECT_1                       0
#define     V_02803C_ADDR_SURF_MACRO_ASPECT_2                       1
#define     V_02803C_ADDR_SURF_MACRO_ASPECT_4                       2
#define     V_02803C_ADDR_SURF_MACRO_ASPECT_8                       3
#define   S_02803C_NUM_BANKS(x)                                       (((unsigned)(x) & 0x3) << 19)
#define   G_02803C_NUM_BANKS(x)                                       (((x) >> 19) & 0x3)
#define   C_02803C_NUM_BANKS                                          0xFFE7FFFF
#define     V_02803C_ADDR_SURF_2_BANK                               0
#define     V_02803C_ADDR_SURF_4_BANK                               1
#define     V_02803C_ADDR_SURF_8_BANK                               2
#define     V_02803C_ADDR_SURF_16_BANK                              3
#define R_02803C_DB_RESERVED_REG_2                                      0x02803C /* >= gfx10 */
#define   S_02803C_FIELD_1(x)                                         (((unsigned)(x) & 0xF) << 0)
#define   G_02803C_FIELD_1(x)                                         (((x) >> 0) & 0xF)
#define   C_02803C_FIELD_1                                            0xFFFFFFF0
#define   S_02803C_FIELD_2(x)                                         (((unsigned)(x) & 0xF) << 4)
#define   G_02803C_FIELD_2(x)                                         (((x) >> 4) & 0xF)
#define   C_02803C_FIELD_2                                            0xFFFFFF0F
#define   S_02803C_FIELD_3(x)                                         (((unsigned)(x) & 0x1F) << 8)
#define   G_02803C_FIELD_3(x)                                         (((x) >> 8) & 0x1F)
#define   C_02803C_FIELD_3                                            0xFFFFE0FF
#define   S_02803C_FIELD_4(x)                                         (((unsigned)(x) & 0x3) << 13)
#define   G_02803C_FIELD_4(x)                                         (((x) >> 13) & 0x3)
#define   C_02803C_FIELD_4                                            0xFFFF9FFF
#define   S_02803C_FIELD_5(x)                                         (((unsigned)(x) & 0x3) << 15)
#define   G_02803C_FIELD_5(x)                                         (((x) >> 15) & 0x3)
#define   C_02803C_FIELD_5                                            0xFFFE7FFF
#define   S_02803C_FIELD_6(x)                                         (((unsigned)(x) & 0x3) << 17)
#define   G_02803C_FIELD_6(x)                                         (((x) >> 17) & 0x3)
#define   C_02803C_FIELD_6                                            0xFFF9FFFF
#define   S_02803C_FIELD_7(x)                                         (((unsigned)(x) & 0x3) << 19)
#define   G_02803C_FIELD_7(x)                                         (((x) >> 19) & 0x3)
#define   C_02803C_FIELD_7                                            0xFFE7FFFF
#define   S_02803C_RESOURCE_LEVEL(x)                                  (((unsigned)(x) & 0xF) << 28)
#define   G_02803C_RESOURCE_LEVEL(x)                                  (((x) >> 28) & 0xF)
#define   C_02803C_RESOURCE_LEVEL                                     0x0FFFFFFF
#define R_02803C_DB_STENCIL_INFO                                        0x02803C /* gfx9 */
#define   S_02803C_FORMAT(x)                                          (((unsigned)(x) & 0x1) << 0)
#define   G_02803C_FORMAT(x)                                          (((x) >> 0) & 0x1)
#define   C_02803C_FORMAT                                             0xFFFFFFFE
#define     V_02803C_STENCIL_INVALID                                0
#define     V_02803C_STENCIL_8                                      1
#define   S_02803C_SW_MODE(x)                                         (((unsigned)(x) & 0x1F) << 4)
#define   G_02803C_SW_MODE(x)                                         (((x) >> 4) & 0x1F)
#define   C_02803C_SW_MODE                                            0xFFFFFE0F
#define   S_02803C_PARTIALLY_RESIDENT(x)                              (((unsigned)(x) & 0x1) << 12)
#define   G_02803C_PARTIALLY_RESIDENT(x)                              (((x) >> 12) & 0x1)
#define   C_02803C_PARTIALLY_RESIDENT                                 0xFFFFEFFF
#define   S_02803C_FAULT_BEHAVIOR(x)                                  (((unsigned)(x) & 0x3) << 13)
#define   G_02803C_FAULT_BEHAVIOR(x)                                  (((x) >> 13) & 0x3)
#define   C_02803C_FAULT_BEHAVIOR                                     0xFFFF9FFF
#define     V_02803C_FAULT_ZERO                                     0
#define     V_02803C_FAULT_ONE                                      1
#define     V_02803C_FAULT_FAIL                                     2
#define     V_02803C_FAULT_PASS                                     3
#define   S_02803C_ITERATE_FLUSH(x)                                   (((unsigned)(x) & 0x1) << 15)
#define   G_02803C_ITERATE_FLUSH(x)                                   (((x) >> 15) & 0x1)
#define   C_02803C_ITERATE_FLUSH                                      0xFFFF7FFF
#define   S_02803C_ALLOW_EXPCLEAR(x)                                  (((unsigned)(x) & 0x1) << 27)
#define   G_02803C_ALLOW_EXPCLEAR(x)                                  (((x) >> 27) & 0x1)
#define   C_02803C_ALLOW_EXPCLEAR                                     0xF7FFFFFF
#define   S_02803C_TILE_STENCIL_DISABLE(x)                            (((unsigned)(x) & 0x1) << 29)
#define   G_02803C_TILE_STENCIL_DISABLE(x)                            (((x) >> 29) & 0x1)
#define   C_02803C_TILE_STENCIL_DISABLE                               0xDFFFFFFF
#define   S_02803C_CLEAR_DISALLOWED(x)                                (((unsigned)(x) & 0x1) << 30)
#define   G_02803C_CLEAR_DISALLOWED(x)                                (((x) >> 30) & 0x1)
#define   C_02803C_CLEAR_DISALLOWED                                   0xBFFFFFFF
#define R_028040_DB_Z_INFO                                              0x028040 /* <= gfx81, >= gfx10 */
#define   S_028040_FORMAT(x)                                          (((unsigned)(x) & 0x3) << 0)
#define   G_028040_FORMAT(x)                                          (((x) >> 0) & 0x3)
#define   C_028040_FORMAT                                             0xFFFFFFFC
#define     V_028040_Z_INVALID                                      0
#define     V_028040_Z_16                                           1
#define     V_028040_Z_24                                           2
#define     V_028040_Z_32_FLOAT                                     3
#define   S_028040_NUM_SAMPLES(x)                                     (((unsigned)(x) & 0x3) << 2)
#define   G_028040_NUM_SAMPLES(x)                                     (((x) >> 2) & 0x3)
#define   C_028040_NUM_SAMPLES                                        0xFFFFFFF3
#define   S_028040_SW_MODE(x)                                         (((unsigned)(x) & 0x1F) << 4) /* >= gfx10 */
#define   G_028040_SW_MODE(x)                                         (((x) >> 4) & 0x1F)
#define   C_028040_SW_MODE                                            0xFFFFFE0F
#define   S_028040_FAULT_BEHAVIOR(x)                                  (((unsigned)(x) & 0x3) << 9) /* >= gfx10 */
#define   G_028040_FAULT_BEHAVIOR(x)                                  (((x) >> 9) & 0x3)
#define   C_028040_FAULT_BEHAVIOR                                     0xFFFFF9FF
#define     V_028040_FAULT_ZERO                                     0
#define     V_028040_FAULT_ONE                                      1
#define     V_028040_FAULT_FAIL                                     2
#define     V_028040_FAULT_PASS                                     3
#define   S_028040_ITERATE_FLUSH(x)                                   (((unsigned)(x) & 0x1) << 11) /* >= gfx10 */
#define   G_028040_ITERATE_FLUSH(x)                                   (((x) >> 11) & 0x1)
#define   C_028040_ITERATE_FLUSH                                      0xFFFFF7FF
#define   S_028040_PARTIALLY_RESIDENT(x)                              (((unsigned)(x) & 0x1) << 12) /* >= gfx10 */
#define   G_028040_PARTIALLY_RESIDENT(x)                              (((x) >> 12) & 0x1)
#define   C_028040_PARTIALLY_RESIDENT                                 0xFFFFEFFF
#define   S_028040_RESERVED_FIELD_1(x)                                (((unsigned)(x) & 0x7) << 13) /* >= gfx10 */
#define   G_028040_RESERVED_FIELD_1(x)                                (((x) >> 13) & 0x7)
#define   C_028040_RESERVED_FIELD_1                                   0xFFFF1FFF
#define   S_028040_TILE_SPLIT(x)                                      (((unsigned)(x) & 0x7) << 13) /* <= gfx81 */
#define   G_028040_TILE_SPLIT(x)                                      (((x) >> 13) & 0x7)
#define   C_028040_TILE_SPLIT                                         0xFFFF1FFF
#define     V_028040_ADDR_SURF_TILE_SPLIT_64B                       0
#define     V_028040_ADDR_SURF_TILE_SPLIT_128B                      1
#define     V_028040_ADDR_SURF_TILE_SPLIT_256B                      2
#define     V_028040_ADDR_SURF_TILE_SPLIT_512B                      3
#define     V_028040_ADDR_SURF_TILE_SPLIT_1KB                       4
#define     V_028040_ADDR_SURF_TILE_SPLIT_2KB                       5
#define     V_028040_ADDR_SURF_TILE_SPLIT_4KB                       6
#define   S_028040_MAXMIP(x)                                          (((unsigned)(x) & 0xF) << 16) /* >= gfx10 */
#define   G_028040_MAXMIP(x)                                          (((x) >> 16) & 0xF)
#define   C_028040_MAXMIP                                             0xFFF0FFFF
#define   S_028040_ITERATE_256(x)                                     (((unsigned)(x) & 0x1) << 20) /* >= gfx10 */
#define   G_028040_ITERATE_256(x)                                     (((x) >> 20) & 0x1)
#define   C_028040_ITERATE_256                                        0xFFEFFFFF
#define   S_028040_TILE_MODE_INDEX(x)                                 (((unsigned)(x) & 0x7) << 20) /* <= gfx81 */
#define   G_028040_TILE_MODE_INDEX(x)                                 (((x) >> 20) & 0x7)
#define   C_028040_TILE_MODE_INDEX                                    0xFF8FFFFF
#define   S_028040_DECOMPRESS_ON_N_ZPLANES(x)                         (((unsigned)(x) & 0xF) << 23) /* gfx8, gfx81, >= gfx10 */
#define   G_028040_DECOMPRESS_ON_N_ZPLANES(x)                         (((x) >> 23) & 0xF)
#define   C_028040_DECOMPRESS_ON_N_ZPLANES                            0xF87FFFFF
#define   S_028040_ALLOW_EXPCLEAR(x)                                  (((unsigned)(x) & 0x1) << 27)
#define   G_028040_ALLOW_EXPCLEAR(x)                                  (((x) >> 27) & 0x1)
#define   C_028040_ALLOW_EXPCLEAR                                     0xF7FFFFFF
#define   S_028040_READ_SIZE(x)                                       (((unsigned)(x) & 0x1) << 28)
#define   G_028040_READ_SIZE(x)                                       (((x) >> 28) & 0x1)
#define   C_028040_READ_SIZE                                          0xEFFFFFFF
#define   S_028040_TILE_SURFACE_ENABLE(x)                             (((unsigned)(x) & 0x1) << 29)
#define   G_028040_TILE_SURFACE_ENABLE(x)                             (((x) >> 29) & 0x1)
#define   C_028040_TILE_SURFACE_ENABLE                                0xDFFFFFFF
#define   S_028040_CLEAR_DISALLOWED(x)                                (((unsigned)(x) & 0x1) << 30) /* gfx8, gfx81 */
#define   G_028040_CLEAR_DISALLOWED(x)                                (((x) >> 30) & 0x1)
#define   C_028040_CLEAR_DISALLOWED                                   0xBFFFFFFF
#define   S_028040_ZRANGE_PRECISION(x)                                (((unsigned)(x) & 0x1) << 31)
#define   G_028040_ZRANGE_PRECISION(x)                                (((x) >> 31) & 0x1)
#define   C_028040_ZRANGE_PRECISION                                   0x7FFFFFFF
#define R_028040_DB_Z_READ_BASE                                         0x028040 /* gfx9 */
#define R_028044_DB_STENCIL_INFO                                        0x028044 /* <= gfx81, >= gfx10 */
#define   S_028044_FORMAT(x)                                          (((unsigned)(x) & 0x1) << 0)
#define   G_028044_FORMAT(x)                                          (((x) >> 0) & 0x1)
#define   C_028044_FORMAT                                             0xFFFFFFFE
#define     V_028044_STENCIL_INVALID                                0
#define     V_028044_STENCIL_8                                      1
#define   S_028044_SW_MODE(x)                                         (((unsigned)(x) & 0x1F) << 4) /* >= gfx10 */
#define   G_028044_SW_MODE(x)                                         (((x) >> 4) & 0x1F)
#define   C_028044_SW_MODE                                            0xFFFFFE0F
#define   S_028044_FAULT_BEHAVIOR(x)                                  (((unsigned)(x) & 0x3) << 9) /* >= gfx10 */
#define   G_028044_FAULT_BEHAVIOR(x)                                  (((x) >> 9) & 0x3)
#define   C_028044_FAULT_BEHAVIOR                                     0xFFFFF9FF
#define     V_028044_FAULT_ZERO                                     0
#define     V_028044_FAULT_ONE                                      1
#define     V_028044_FAULT_FAIL                                     2
#define     V_028044_FAULT_PASS                                     3
#define   S_028044_ITERATE_FLUSH(x)                                   (((unsigned)(x) & 0x1) << 11) /* >= gfx10 */
#define   G_028044_ITERATE_FLUSH(x)                                   (((x) >> 11) & 0x1)
#define   C_028044_ITERATE_FLUSH                                      0xFFFFF7FF
#define   S_028044_PARTIALLY_RESIDENT(x)                              (((unsigned)(x) & 0x1) << 12) /* >= gfx10 */
#define   G_028044_PARTIALLY_RESIDENT(x)                              (((x) >> 12) & 0x1)
#define   C_028044_PARTIALLY_RESIDENT                                 0xFFFFEFFF
#define   S_028044_RESERVED_FIELD_1(x)                                (((unsigned)(x) & 0x7) << 13) /* >= gfx10 */
#define   G_028044_RESERVED_FIELD_1(x)                                (((x) >> 13) & 0x7)
#define   C_028044_RESERVED_FIELD_1                                   0xFFFF1FFF
#define   S_028044_TILE_SPLIT(x)                                      (((unsigned)(x) & 0x7) << 13) /* <= gfx81 */
#define   G_028044_TILE_SPLIT(x)                                      (((x) >> 13) & 0x7)
#define   C_028044_TILE_SPLIT                                         0xFFFF1FFF
#define     V_028044_ADDR_SURF_TILE_SPLIT_64B                       0
#define     V_028044_ADDR_SURF_TILE_SPLIT_128B                      1
#define     V_028044_ADDR_SURF_TILE_SPLIT_256B                      2
#define     V_028044_ADDR_SURF_TILE_SPLIT_512B                      3
#define     V_028044_ADDR_SURF_TILE_SPLIT_1KB                       4
#define     V_028044_ADDR_SURF_TILE_SPLIT_2KB                       5
#define     V_028044_ADDR_SURF_TILE_SPLIT_4KB                       6
#define   S_028044_ITERATE_256(x)                                     (((unsigned)(x) & 0x1) << 20) /* >= gfx10 */
#define   G_028044_ITERATE_256(x)                                     (((x) >> 20) & 0x1)
#define   C_028044_ITERATE_256                                        0xFFEFFFFF
#define   S_028044_TILE_MODE_INDEX(x)                                 (((unsigned)(x) & 0x7) << 20) /* <= gfx81 */
#define   G_028044_TILE_MODE_INDEX(x)                                 (((x) >> 20) & 0x7)
#define   C_028044_TILE_MODE_INDEX                                    0xFF8FFFFF
#define   S_028044_ALLOW_EXPCLEAR(x)                                  (((unsigned)(x) & 0x1) << 27)
#define   G_028044_ALLOW_EXPCLEAR(x)                                  (((x) >> 27) & 0x1)
#define   C_028044_ALLOW_EXPCLEAR                                     0xF7FFFFFF
#define   S_028044_TILE_STENCIL_DISABLE(x)                            (((unsigned)(x) & 0x1) << 29)
#define   G_028044_TILE_STENCIL_DISABLE(x)                            (((x) >> 29) & 0x1)
#define   C_028044_TILE_STENCIL_DISABLE                               0xDFFFFFFF
#define   S_028044_CLEAR_DISALLOWED(x)                                (((unsigned)(x) & 0x1) << 30) /* gfx8, gfx81 */
#define   G_028044_CLEAR_DISALLOWED(x)                                (((x) >> 30) & 0x1)
#define   C_028044_CLEAR_DISALLOWED                                   0xBFFFFFFF
#define R_028044_DB_Z_READ_BASE_HI                                      0x028044 /* gfx9 */
#define   S_028044_BASE_HI(x)                                         (((unsigned)(x) & 0xFF) << 0)
#define   G_028044_BASE_HI(x)                                         (((x) >> 0) & 0xFF)
#define   C_028044_BASE_HI                                            0xFFFFFF00
#define R_028048_DB_STENCIL_READ_BASE                                   0x028048 /* gfx9 */
#define R_028048_DB_Z_READ_BASE                                         0x028048 /* <= gfx81, >= gfx10 */
#define R_02804C_DB_STENCIL_READ_BASE                                   0x02804C /* <= gfx81, >= gfx10 */
#define R_02804C_DB_STENCIL_READ_BASE_HI                                0x02804C /* gfx9 */
#define   S_02804C_BASE_HI(x)                                         (((unsigned)(x) & 0xFF) << 0)
#define   G_02804C_BASE_HI(x)                                         (((x) >> 0) & 0xFF)
#define   C_02804C_BASE_HI                                            0xFFFFFF00
#define R_028050_DB_Z_WRITE_BASE                                        0x028050
#define R_028054_DB_STENCIL_WRITE_BASE                                  0x028054 /* <= gfx81, >= gfx10 */
#define R_028054_DB_Z_WRITE_BASE_HI                                     0x028054 /* gfx9 */
#define   S_028054_BASE_HI(x)                                         (((unsigned)(x) & 0xFF) << 0)
#define   G_028054_BASE_HI(x)                                         (((x) >> 0) & 0xFF)
#define   C_028054_BASE_HI                                            0xFFFFFF00
#define R_028058_DB_DEPTH_SIZE                                          0x028058 /* <= gfx81 */
#define   S_028058_PITCH_TILE_MAX(x)                                  (((unsigned)(x) & 0x7FF) << 0)
#define   G_028058_PITCH_TILE_MAX(x)                                  (((x) >> 0) & 0x7FF)
#define   C_028058_PITCH_TILE_MAX                                     0xFFFFF800
#define   S_028058_HEIGHT_TILE_MAX(x)                                 (((unsigned)(x) & 0x7FF) << 11)
#define   G_028058_HEIGHT_TILE_MAX(x)                                 (((x) >> 11) & 0x7FF)
#define   C_028058_HEIGHT_TILE_MAX                                    0xFFC007FF
#define R_028058_DB_RESERVED_REG_1                                      0x028058 /* >= gfx10 */
#define   S_028058_FIELD_1(x)                                         (((unsigned)(x) & 0x7FF) << 0)
#define   G_028058_FIELD_1(x)                                         (((x) >> 0) & 0x7FF)
#define   C_028058_FIELD_1                                            0xFFFFF800
#define   S_028058_FIELD_2(x)                                         (((unsigned)(x) & 0x7FF) << 11)
#define   G_028058_FIELD_2(x)                                         (((x) >> 11) & 0x7FF)
#define   C_028058_FIELD_2                                            0xFFC007FF
#define R_028058_DB_STENCIL_WRITE_BASE                                  0x028058 /* gfx9 */
#define R_02805C_DB_DEPTH_SLICE                                         0x02805C /* <= gfx81 */
#define   S_02805C_SLICE_TILE_MAX(x)                                  (((unsigned)(x) & 0x3FFFFF) << 0)
#define   G_02805C_SLICE_TILE_MAX(x)                                  (((x) >> 0) & 0x3FFFFF)
#define   C_02805C_SLICE_TILE_MAX                                     0xFFC00000
#define R_02805C_DB_RESERVED_REG_3                                      0x02805C /* >= gfx10 */
#define   S_02805C_FIELD_1(x)                                         (((unsigned)(x) & 0x3FFFFF) << 0)
#define   G_02805C_FIELD_1(x)                                         (((x) >> 0) & 0x3FFFFF)
#define   C_02805C_FIELD_1                                            0xFFC00000
#define R_02805C_DB_STENCIL_WRITE_BASE_HI                               0x02805C /* gfx9 */
#define   S_02805C_BASE_HI(x)                                         (((unsigned)(x) & 0xFF) << 0)
#define   G_02805C_BASE_HI(x)                                         (((x) >> 0) & 0xFF)
#define   C_02805C_BASE_HI                                            0xFFFFFF00
#define R_028060_DB_DFSM_CONTROL                                        0x028060 /* gfx9 */
#define   S_028060_PUNCHOUT_MODE(x)                                   (((unsigned)(x) & 0x3) << 0)
#define   G_028060_PUNCHOUT_MODE(x)                                   (((x) >> 0) & 0x3)
#define   C_028060_PUNCHOUT_MODE                                      0xFFFFFFFC
#define     V_028060_AUTO                                           0
#define     V_028060_FORCE_ON                                       1
#define     V_028060_FORCE_OFF                                      2
#define     V_028060_RESERVED                                       3
#define   S_028060_POPS_DRAIN_PS_ON_OVERLAP(x)                        (((unsigned)(x) & 0x1) << 2)
#define   G_028060_POPS_DRAIN_PS_ON_OVERLAP(x)                        (((x) >> 2) & 0x1)
#define   C_028060_POPS_DRAIN_PS_ON_OVERLAP                           0xFFFFFFFB
#define   S_028060_DISALLOW_OVERFLOW(x)                               (((unsigned)(x) & 0x1) << 3)
#define   G_028060_DISALLOW_OVERFLOW(x)                               (((x) >> 3) & 0x1)
#define   C_028060_DISALLOW_OVERFLOW                                  0xFFFFFFF7
#define R_028064_DB_VRS_OVERRIDE_CNTL                                   0x028064 /* >= gfx103 */
#define   S_028064_VRS_OVERRIDE_RATE_COMBINER_MODE(x)                 (((unsigned)(x) & 0x7) << 0)
#define   G_028064_VRS_OVERRIDE_RATE_COMBINER_MODE(x)                 (((x) >> 0) & 0x7)
#define   C_028064_VRS_OVERRIDE_RATE_COMBINER_MODE                    0xFFFFFFF8
#define     V_028064_VRS_COMB_MODE_PASSTHRU                         0
#define     V_028064_VRS_COMB_MODE_OVERRIDE                         1
#define     V_028064_VRS_COMB_MODE_MIN                              2
#define     V_028064_VRS_COMB_MODE_MAX                              3
#define     V_028064_VRS_COMB_MODE_SATURATE                         4
#define   S_028064_VRS_OVERRIDE_RATE_X(x)                             (((unsigned)(x) & 0x3) << 4)
#define   G_028064_VRS_OVERRIDE_RATE_X(x)                             (((x) >> 4) & 0x3)
#define   C_028064_VRS_OVERRIDE_RATE_X                                0xFFFFFFCF
#define   S_028064_VRS_OVERRIDE_RATE_Y(x)                             (((unsigned)(x) & 0x3) << 6)
#define   G_028064_VRS_OVERRIDE_RATE_Y(x)                             (((x) >> 6) & 0x3)
#define   C_028064_VRS_OVERRIDE_RATE_Y                                0xFFFFFF3F
#define R_028068_DB_Z_INFO2                                             0x028068 /* gfx9 */
#define   S_028068_EPITCH(x)                                          (((unsigned)(x) & 0xFFFF) << 0)
#define   G_028068_EPITCH(x)                                          (((x) >> 0) & 0xFFFF)
#define   C_028068_EPITCH                                             0xFFFF0000
#define R_028068_DB_Z_READ_BASE_HI                                      0x028068 /* >= gfx10 */
#define   S_028068_BASE_HI(x)                                         (((unsigned)(x) & 0xFF) << 0)
#define   G_028068_BASE_HI(x)                                         (((x) >> 0) & 0xFF)
#define   C_028068_BASE_HI                                            0xFFFFFF00
#define R_02806C_DB_STENCIL_INFO2                                       0x02806C /* gfx9 */
#define   S_02806C_EPITCH(x)                                          (((unsigned)(x) & 0xFFFF) << 0)
#define   G_02806C_EPITCH(x)                                          (((x) >> 0) & 0xFFFF)
#define   C_02806C_EPITCH                                             0xFFFF0000
#define R_02806C_DB_STENCIL_READ_BASE_HI                                0x02806C /* >= gfx10 */
#define   S_02806C_BASE_HI(x)                                         (((unsigned)(x) & 0xFF) << 0)
#define   G_02806C_BASE_HI(x)                                         (((x) >> 0) & 0xFF)
#define   C_02806C_BASE_HI                                            0xFFFFFF00
#define R_028070_DB_Z_WRITE_BASE_HI                                     0x028070 /* >= gfx10 */
#define   S_028070_BASE_HI(x)                                         (((unsigned)(x) & 0xFF) << 0)
#define   G_028070_BASE_HI(x)                                         (((x) >> 0) & 0xFF)
#define   C_028070_BASE_HI                                            0xFFFFFF00
#define R_028074_DB_STENCIL_WRITE_BASE_HI                               0x028074 /* >= gfx10 */
#define   S_028074_BASE_HI(x)                                         (((unsigned)(x) & 0xFF) << 0)
#define   G_028074_BASE_HI(x)                                         (((x) >> 0) & 0xFF)
#define   C_028074_BASE_HI                                            0xFFFFFF00
#define R_028078_DB_HTILE_DATA_BASE_HI                                  0x028078 /* >= gfx10 */
#define   S_028078_BASE_HI(x)                                         (((unsigned)(x) & 0xFF) << 0)
#define   G_028078_BASE_HI(x)                                         (((x) >> 0) & 0xFF)
#define   C_028078_BASE_HI                                            0xFFFFFF00
#define R_02807C_DB_RMI_L2_CACHE_CONTROL                                0x02807C /* >= gfx10 */
#define   S_02807C_Z_WR_POLICY(x)                                     (((unsigned)(x) & 0x3) << 0)
#define   G_02807C_Z_WR_POLICY(x)                                     (((x) >> 0) & 0x3)
#define   C_02807C_Z_WR_POLICY                                        0xFFFFFFFC
#define     V_02807C_CACHE_LRU_WR                                   0
#define     V_02807C_CACHE_STREAM                                   1
#define     V_02807C_CACHE_BYPASS                                   2
#define     V_02807C_UNCACHED_WR                                    3
#define   S_02807C_S_WR_POLICY(x)                                     (((unsigned)(x) & 0x3) << 2)
#define   G_02807C_S_WR_POLICY(x)                                     (((x) >> 2) & 0x3)
#define   C_02807C_S_WR_POLICY                                        0xFFFFFFF3
#define   S_02807C_HTILE_WR_POLICY(x)                                 (((unsigned)(x) & 0x3) << 4)
#define   G_02807C_HTILE_WR_POLICY(x)                                 (((x) >> 4) & 0x3)
#define   C_02807C_HTILE_WR_POLICY                                    0xFFFFFFCF
#define   S_02807C_ZPCPSD_WR_POLICY(x)                                (((unsigned)(x) & 0x3) << 6)
#define   G_02807C_ZPCPSD_WR_POLICY(x)                                (((x) >> 6) & 0x3)
#define   C_02807C_ZPCPSD_WR_POLICY                                   0xFFFFFF3F
#define   S_02807C_Z_RD_POLICY(x)                                     (((unsigned)(x) & 0x3) << 16)
#define   G_02807C_Z_RD_POLICY(x)                                     (((x) >> 16) & 0x3)
#define   C_02807C_Z_RD_POLICY                                        0xFFFCFFFF
#define     V_02807C_CACHE_LRU_RD                                   0
#define     V_02807C_CACHE_NOA                                      1
#define     V_02807C_UNCACHED_RD                                    2
#define     V_02807C_RESERVED_RDPOLICY                              3
#define   S_02807C_S_RD_POLICY(x)                                     (((unsigned)(x) & 0x3) << 18)
#define   G_02807C_S_RD_POLICY(x)                                     (((x) >> 18) & 0x3)
#define   C_02807C_S_RD_POLICY                                        0xFFF3FFFF
#define   S_02807C_HTILE_RD_POLICY(x)                                 (((unsigned)(x) & 0x3) << 20)
#define   G_02807C_HTILE_RD_POLICY(x)                                 (((x) >> 20) & 0x3)
#define   C_02807C_HTILE_RD_POLICY                                    0xFFCFFFFF
#define   S_02807C_Z_BIG_PAGE(x)                                      (((unsigned)(x) & 0x1) << 24)
#define   G_02807C_Z_BIG_PAGE(x)                                      (((x) >> 24) & 0x1)
#define   C_02807C_Z_BIG_PAGE                                         0xFEFFFFFF
#define   S_02807C_S_BIG_PAGE(x)                                      (((unsigned)(x) & 0x1) << 25)
#define   G_02807C_S_BIG_PAGE(x)                                      (((x) >> 25) & 0x1)
#define   C_02807C_S_BIG_PAGE                                         0xFDFFFFFF
#define   S_02807C_Z_NOALLOC(x)                                       (((unsigned)(x) & 0x1) << 26) /* >= gfx103 */
#define   G_02807C_Z_NOALLOC(x)                                       (((x) >> 26) & 0x1)
#define   C_02807C_Z_NOALLOC                                          0xFBFFFFFF
#define   S_02807C_S_NOALLOC(x)                                       (((unsigned)(x) & 0x1) << 27) /* >= gfx103 */
#define   G_02807C_S_NOALLOC(x)                                       (((x) >> 27) & 0x1)
#define   C_02807C_S_NOALLOC                                          0xF7FFFFFF
#define   S_02807C_HTILE_NOALLOC(x)                                   (((unsigned)(x) & 0x1) << 28) /* >= gfx103 */
#define   G_02807C_HTILE_NOALLOC(x)                                   (((x) >> 28) & 0x1)
#define   C_02807C_HTILE_NOALLOC                                      0xEFFFFFFF
#define   S_02807C_ZPCPSD_NOALLOC(x)                                  (((unsigned)(x) & 0x1) << 29) /* >= gfx103 */
#define   G_02807C_ZPCPSD_NOALLOC(x)                                  (((x) >> 29) & 0x1)
#define   C_02807C_ZPCPSD_NOALLOC                                     0xDFFFFFFF
#define R_028080_TA_BC_BASE_ADDR                                        0x028080
#define R_028084_TA_BC_BASE_ADDR_HI                                     0x028084 /* >= gfx7 */
#define   S_028084_ADDRESS(x)                                         (((unsigned)(x) & 0xFF) << 0)
#define   G_028084_ADDRESS(x)                                         (((x) >> 0) & 0xFF)
#define   C_028084_ADDRESS                                            0xFFFFFF00
#define R_0281E8_COHER_DEST_BASE_HI_0                                   0x0281E8 /* >= gfx7 */
#define   S_0281E8_DEST_BASE_HI_256B(x)                               (((unsigned)(x) & 0xFF) << 0)
#define   G_0281E8_DEST_BASE_HI_256B(x)                               (((x) >> 0) & 0xFF)
#define   C_0281E8_DEST_BASE_HI_256B                                  0xFFFFFF00
#define R_0281EC_COHER_DEST_BASE_HI_1                                   0x0281EC /* >= gfx7 */
#define R_0281F0_COHER_DEST_BASE_HI_2                                   0x0281F0 /* >= gfx7 */
#define R_0281F4_COHER_DEST_BASE_HI_3                                   0x0281F4 /* >= gfx7 */
#define R_0281F8_COHER_DEST_BASE_2                                      0x0281F8
#define R_0281FC_COHER_DEST_BASE_3                                      0x0281FC
#define R_028200_PA_SC_WINDOW_OFFSET                                    0x028200
#define   S_028200_WINDOW_X_OFFSET(x)                                 (((unsigned)(x) & 0xFFFF) << 0)
#define   G_028200_WINDOW_X_OFFSET(x)                                 (((x) >> 0) & 0xFFFF)
#define   C_028200_WINDOW_X_OFFSET                                    0xFFFF0000
#define   S_028200_WINDOW_Y_OFFSET(x)                                 (((unsigned)(x) & 0xFFFF) << 16)
#define   G_028200_WINDOW_Y_OFFSET(x)                                 (((x) >> 16) & 0xFFFF)
#define   C_028200_WINDOW_Y_OFFSET                                    0x0000FFFF
#define R_028204_PA_SC_WINDOW_SCISSOR_TL                                0x028204
#define   S_028204_TL_X(x)                                            (((unsigned)(x) & 0x7FFF) << 0)
#define   G_028204_TL_X(x)                                            (((x) >> 0) & 0x7FFF)
#define   C_028204_TL_X                                               0xFFFF8000
#define   S_028204_TL_Y(x)                                            (((unsigned)(x) & 0x7FFF) << 16)
#define   G_028204_TL_Y(x)                                            (((x) >> 16) & 0x7FFF)
#define   C_028204_TL_Y                                               0x8000FFFF
#define   S_028204_WINDOW_OFFSET_DISABLE(x)                           (((unsigned)(x) & 0x1) << 31)
#define   G_028204_WINDOW_OFFSET_DISABLE(x)                           (((x) >> 31) & 0x1)
#define   C_028204_WINDOW_OFFSET_DISABLE                              0x7FFFFFFF
#define R_028208_PA_SC_WINDOW_SCISSOR_BR                                0x028208
#define   S_028208_BR_X(x)                                            (((unsigned)(x) & 0x7FFF) << 0)
#define   G_028208_BR_X(x)                                            (((x) >> 0) & 0x7FFF)
#define   C_028208_BR_X                                               0xFFFF8000
#define   S_028208_BR_Y(x)                                            (((unsigned)(x) & 0x7FFF) << 16)
#define   G_028208_BR_Y(x)                                            (((x) >> 16) & 0x7FFF)
#define   C_028208_BR_Y                                               0x8000FFFF
#define R_02820C_PA_SC_CLIPRECT_RULE                                    0x02820C
#define   S_02820C_CLIP_RULE(x)                                       (((unsigned)(x) & 0xFFFF) << 0)
#define   G_02820C_CLIP_RULE(x)                                       (((x) >> 0) & 0xFFFF)
#define   C_02820C_CLIP_RULE                                          0xFFFF0000
#define     V_02820C_OUT                                            1
#define     V_02820C_IN_0                                           2
#define     V_02820C_IN_1                                           4
#define     V_02820C_IN_10                                          8
#define     V_02820C_IN_2                                           16
#define     V_02820C_IN_20                                          32
#define     V_02820C_IN_21                                          64
#define     V_02820C_IN_210                                         128
#define     V_02820C_IN_3                                           256
#define     V_02820C_IN_30                                          512
#define     V_02820C_IN_31                                          1024
#define     V_02820C_IN_310                                         2048
#define     V_02820C_IN_32                                          4096
#define     V_02820C_IN_320                                         8192
#define     V_02820C_IN_321                                         16384
#define     V_02820C_IN_3210                                        32768
#define R_028210_PA_SC_CLIPRECT_0_TL                                    0x028210
#define   S_028210_TL_X(x)                                            (((unsigned)(x) & 0x7FFF) << 0)
#define   G_028210_TL_X(x)                                            (((x) >> 0) & 0x7FFF)
#define   C_028210_TL_X                                               0xFFFF8000
#define   S_028210_TL_Y(x)                                            (((unsigned)(x) & 0x7FFF) << 16)
#define   G_028210_TL_Y(x)                                            (((x) >> 16) & 0x7FFF)
#define   C_028210_TL_Y                                               0x8000FFFF
#define R_028214_PA_SC_CLIPRECT_0_BR                                    0x028214
#define   S_028214_BR_X(x)                                            (((unsigned)(x) & 0x7FFF) << 0)
#define   G_028214_BR_X(x)                                            (((x) >> 0) & 0x7FFF)
#define   C_028214_BR_X                                               0xFFFF8000
#define   S_028214_BR_Y(x)                                            (((unsigned)(x) & 0x7FFF) << 16)
#define   G_028214_BR_Y(x)                                            (((x) >> 16) & 0x7FFF)
#define   C_028214_BR_Y                                               0x8000FFFF
#define R_028218_PA_SC_CLIPRECT_1_TL                                    0x028218
#define R_02821C_PA_SC_CLIPRECT_1_BR                                    0x02821C
#define R_028220_PA_SC_CLIPRECT_2_TL                                    0x028220
#define R_028224_PA_SC_CLIPRECT_2_BR                                    0x028224
#define R_028228_PA_SC_CLIPRECT_3_TL                                    0x028228
#define R_02822C_PA_SC_CLIPRECT_3_BR                                    0x02822C
#define R_028230_PA_SC_EDGERULE                                         0x028230
#define   S_028230_ER_TRI(x)                                          (((unsigned)(x) & 0xF) << 0)
#define   G_028230_ER_TRI(x)                                          (((x) >> 0) & 0xF)
#define   C_028230_ER_TRI                                             0xFFFFFFF0
#define   S_028230_ER_POINT(x)                                        (((unsigned)(x) & 0xF) << 4)
#define   G_028230_ER_POINT(x)                                        (((x) >> 4) & 0xF)
#define   C_028230_ER_POINT                                           0xFFFFFF0F
#define   S_028230_ER_RECT(x)                                         (((unsigned)(x) & 0xF) << 8)
#define   G_028230_ER_RECT(x)                                         (((x) >> 8) & 0xF)
#define   C_028230_ER_RECT                                            0xFFFFF0FF
#define   S_028230_ER_LINE_LR(x)                                      (((unsigned)(x) & 0x3F) << 12)
#define   G_028230_ER_LINE_LR(x)                                      (((x) >> 12) & 0x3F)
#define   C_028230_ER_LINE_LR                                         0xFFFC0FFF
#define   S_028230_ER_LINE_RL(x)                                      (((unsigned)(x) & 0x3F) << 18)
#define   G_028230_ER_LINE_RL(x)                                      (((x) >> 18) & 0x3F)
#define   C_028230_ER_LINE_RL                                         0xFF03FFFF
#define   S_028230_ER_LINE_TB(x)                                      (((unsigned)(x) & 0xF) << 24)
#define   G_028230_ER_LINE_TB(x)                                      (((x) >> 24) & 0xF)
#define   C_028230_ER_LINE_TB                                         0xF0FFFFFF
#define   S_028230_ER_LINE_BT(x)                                      (((unsigned)(x) & 0xF) << 28)
#define   G_028230_ER_LINE_BT(x)                                      (((x) >> 28) & 0xF)
#define   C_028230_ER_LINE_BT                                         0x0FFFFFFF
#define R_028234_PA_SU_HARDWARE_SCREEN_OFFSET                           0x028234
#define   S_028234_HW_SCREEN_OFFSET_X(x)                              (((unsigned)(x) & 0x1FF) << 0)
#define   G_028234_HW_SCREEN_OFFSET_X(x)                              (((x) >> 0) & 0x1FF)
#define   C_028234_HW_SCREEN_OFFSET_X                                 0xFFFFFE00
#define   S_028234_HW_SCREEN_OFFSET_Y(x)                              (((unsigned)(x) & 0x1FF) << 16)
#define   G_028234_HW_SCREEN_OFFSET_Y(x)                              (((x) >> 16) & 0x1FF)
#define   C_028234_HW_SCREEN_OFFSET_Y                                 0xFE00FFFF
#define R_028238_CB_TARGET_MASK                                         0x028238
#define   S_028238_TARGET0_ENABLE(x)                                  (((unsigned)(x) & 0xF) << 0)
#define   G_028238_TARGET0_ENABLE(x)                                  (((x) >> 0) & 0xF)
#define   C_028238_TARGET0_ENABLE                                     0xFFFFFFF0
#define   S_028238_TARGET1_ENABLE(x)                                  (((unsigned)(x) & 0xF) << 4)
#define   G_028238_TARGET1_ENABLE(x)                                  (((x) >> 4) & 0xF)
#define   C_028238_TARGET1_ENABLE                                     0xFFFFFF0F
#define   S_028238_TARGET2_ENABLE(x)                                  (((unsigned)(x) & 0xF) << 8)
#define   G_028238_TARGET2_ENABLE(x)                                  (((x) >> 8) & 0xF)
#define   C_028238_TARGET2_ENABLE                                     0xFFFFF0FF
#define   S_028238_TARGET3_ENABLE(x)                                  (((unsigned)(x) & 0xF) << 12)
#define   G_028238_TARGET3_ENABLE(x)                                  (((x) >> 12) & 0xF)
#define   C_028238_TARGET3_ENABLE                                     0xFFFF0FFF
#define   S_028238_TARGET4_ENABLE(x)                                  (((unsigned)(x) & 0xF) << 16)
#define   G_028238_TARGET4_ENABLE(x)                                  (((x) >> 16) & 0xF)
#define   C_028238_TARGET4_ENABLE                                     0xFFF0FFFF
#define   S_028238_TARGET5_ENABLE(x)                                  (((unsigned)(x) & 0xF) << 20)
#define   G_028238_TARGET5_ENABLE(x)                                  (((x) >> 20) & 0xF)
#define   C_028238_TARGET5_ENABLE                                     0xFF0FFFFF
#define   S_028238_TARGET6_ENABLE(x)                                  (((unsigned)(x) & 0xF) << 24)
#define   G_028238_TARGET6_ENABLE(x)                                  (((x) >> 24) & 0xF)
#define   C_028238_TARGET6_ENABLE                                     0xF0FFFFFF
#define   S_028238_TARGET7_ENABLE(x)                                  (((unsigned)(x) & 0xF) << 28)
#define   G_028238_TARGET7_ENABLE(x)                                  (((x) >> 28) & 0xF)
#define   C_028238_TARGET7_ENABLE                                     0x0FFFFFFF
#define R_02823C_CB_SHADER_MASK                                         0x02823C
#define   S_02823C_OUTPUT0_ENABLE(x)                                  (((unsigned)(x) & 0xF) << 0)
#define   G_02823C_OUTPUT0_ENABLE(x)                                  (((x) >> 0) & 0xF)
#define   C_02823C_OUTPUT0_ENABLE                                     0xFFFFFFF0
#define   S_02823C_OUTPUT1_ENABLE(x)                                  (((unsigned)(x) & 0xF) << 4)
#define   G_02823C_OUTPUT1_ENABLE(x)                                  (((x) >> 4) & 0xF)
#define   C_02823C_OUTPUT1_ENABLE                                     0xFFFFFF0F
#define   S_02823C_OUTPUT2_ENABLE(x)                                  (((unsigned)(x) & 0xF) << 8)
#define   G_02823C_OUTPUT2_ENABLE(x)                                  (((x) >> 8) & 0xF)
#define   C_02823C_OUTPUT2_ENABLE                                     0xFFFFF0FF
#define   S_02823C_OUTPUT3_ENABLE(x)                                  (((unsigned)(x) & 0xF) << 12)
#define   G_02823C_OUTPUT3_ENABLE(x)                                  (((x) >> 12) & 0xF)
#define   C_02823C_OUTPUT3_ENABLE                                     0xFFFF0FFF
#define   S_02823C_OUTPUT4_ENABLE(x)                                  (((unsigned)(x) & 0xF) << 16)
#define   G_02823C_OUTPUT4_ENABLE(x)                                  (((x) >> 16) & 0xF)
#define   C_02823C_OUTPUT4_ENABLE                                     0xFFF0FFFF
#define   S_02823C_OUTPUT5_ENABLE(x)                                  (((unsigned)(x) & 0xF) << 20)
#define   G_02823C_OUTPUT5_ENABLE(x)                                  (((x) >> 20) & 0xF)
#define   C_02823C_OUTPUT5_ENABLE                                     0xFF0FFFFF
#define   S_02823C_OUTPUT6_ENABLE(x)                                  (((unsigned)(x) & 0xF) << 24)
#define   G_02823C_OUTPUT6_ENABLE(x)                                  (((x) >> 24) & 0xF)
#define   C_02823C_OUTPUT6_ENABLE                                     0xF0FFFFFF
#define   S_02823C_OUTPUT7_ENABLE(x)                                  (((unsigned)(x) & 0xF) << 28)
#define   G_02823C_OUTPUT7_ENABLE(x)                                  (((x) >> 28) & 0xF)
#define   C_02823C_OUTPUT7_ENABLE                                     0x0FFFFFFF
#define R_028240_PA_SC_GENERIC_SCISSOR_TL                               0x028240
#define   S_028240_TL_X(x)                                            (((unsigned)(x) & 0x7FFF) << 0)
#define   G_028240_TL_X(x)                                            (((x) >> 0) & 0x7FFF)
#define   C_028240_TL_X                                               0xFFFF8000
#define   S_028240_TL_Y(x)                                            (((unsigned)(x) & 0x7FFF) << 16)
#define   G_028240_TL_Y(x)                                            (((x) >> 16) & 0x7FFF)
#define   C_028240_TL_Y                                               0x8000FFFF
#define   S_028240_WINDOW_OFFSET_DISABLE(x)                           (((unsigned)(x) & 0x1) << 31)
#define   G_028240_WINDOW_OFFSET_DISABLE(x)                           (((x) >> 31) & 0x1)
#define   C_028240_WINDOW_OFFSET_DISABLE                              0x7FFFFFFF
#define R_028244_PA_SC_GENERIC_SCISSOR_BR                               0x028244
#define   S_028244_BR_X(x)                                            (((unsigned)(x) & 0x7FFF) << 0)
#define   G_028244_BR_X(x)                                            (((x) >> 0) & 0x7FFF)
#define   C_028244_BR_X                                               0xFFFF8000
#define   S_028244_BR_Y(x)                                            (((unsigned)(x) & 0x7FFF) << 16)
#define   G_028244_BR_Y(x)                                            (((x) >> 16) & 0x7FFF)
#define   C_028244_BR_Y                                               0x8000FFFF
#define R_028248_COHER_DEST_BASE_0                                      0x028248
#define R_02824C_COHER_DEST_BASE_1                                      0x02824C
#define R_028250_PA_SC_VPORT_SCISSOR_0_TL                               0x028250
#define   S_028250_TL_X(x)                                            (((unsigned)(x) & 0x7FFF) << 0)
#define   G_028250_TL_X(x)                                            (((x) >> 0) & 0x7FFF)
#define   C_028250_TL_X                                               0xFFFF8000
#define   S_028250_TL_Y(x)                                            (((unsigned)(x) & 0x7FFF) << 16)
#define   G_028250_TL_Y(x)                                            (((x) >> 16) & 0x7FFF)
#define   C_028250_TL_Y                                               0x8000FFFF
#define   S_028250_WINDOW_OFFSET_DISABLE(x)                           (((unsigned)(x) & 0x1) << 31)
#define   G_028250_WINDOW_OFFSET_DISABLE(x)                           (((x) >> 31) & 0x1)
#define   C_028250_WINDOW_OFFSET_DISABLE                              0x7FFFFFFF
#define R_028254_PA_SC_VPORT_SCISSOR_0_BR                               0x028254
#define   S_028254_BR_X(x)                                            (((unsigned)(x) & 0x7FFF) << 0)
#define   G_028254_BR_X(x)                                            (((x) >> 0) & 0x7FFF)
#define   C_028254_BR_X                                               0xFFFF8000
#define   S_028254_BR_Y(x)                                            (((unsigned)(x) & 0x7FFF) << 16)
#define   G_028254_BR_Y(x)                                            (((x) >> 16) & 0x7FFF)
#define   C_028254_BR_Y                                               0x8000FFFF
#define R_028258_PA_SC_VPORT_SCISSOR_1_TL                               0x028258
#define R_02825C_PA_SC_VPORT_SCISSOR_1_BR                               0x02825C
#define R_028260_PA_SC_VPORT_SCISSOR_2_TL                               0x028260
#define R_028264_PA_SC_VPORT_SCISSOR_2_BR                               0x028264
#define R_028268_PA_SC_VPORT_SCISSOR_3_TL                               0x028268
#define R_02826C_PA_SC_VPORT_SCISSOR_3_BR                               0x02826C
#define R_028270_PA_SC_VPORT_SCISSOR_4_TL                               0x028270
#define R_028274_PA_SC_VPORT_SCISSOR_4_BR                               0x028274
#define R_028278_PA_SC_VPORT_SCISSOR_5_TL                               0x028278
#define R_02827C_PA_SC_VPORT_SCISSOR_5_BR                               0x02827C
#define R_028280_PA_SC_VPORT_SCISSOR_6_TL                               0x028280
#define R_028284_PA_SC_VPORT_SCISSOR_6_BR                               0x028284
#define R_028288_PA_SC_VPORT_SCISSOR_7_TL                               0x028288
#define R_02828C_PA_SC_VPORT_SCISSOR_7_BR                               0x02828C
#define R_028290_PA_SC_VPORT_SCISSOR_8_TL                               0x028290
#define R_028294_PA_SC_VPORT_SCISSOR_8_BR                               0x028294
#define R_028298_PA_SC_VPORT_SCISSOR_9_TL                               0x028298
#define R_02829C_PA_SC_VPORT_SCISSOR_9_BR                               0x02829C
#define R_0282A0_PA_SC_VPORT_SCISSOR_10_TL                              0x0282A0
#define R_0282A4_PA_SC_VPORT_SCISSOR_10_BR                              0x0282A4
#define R_0282A8_PA_SC_VPORT_SCISSOR_11_TL                              0x0282A8
#define R_0282AC_PA_SC_VPORT_SCISSOR_11_BR                              0x0282AC
#define R_0282B0_PA_SC_VPORT_SCISSOR_12_TL                              0x0282B0
#define R_0282B4_PA_SC_VPORT_SCISSOR_12_BR                              0x0282B4
#define R_0282B8_PA_SC_VPORT_SCISSOR_13_TL                              0x0282B8
#define R_0282BC_PA_SC_VPORT_SCISSOR_13_BR                              0x0282BC
#define R_0282C0_PA_SC_VPORT_SCISSOR_14_TL                              0x0282C0
#define R_0282C4_PA_SC_VPORT_SCISSOR_14_BR                              0x0282C4
#define R_0282C8_PA_SC_VPORT_SCISSOR_15_TL                              0x0282C8
#define R_0282CC_PA_SC_VPORT_SCISSOR_15_BR                              0x0282CC
#define R_0282D0_PA_SC_VPORT_ZMIN_0                                     0x0282D0
#define R_0282D4_PA_SC_VPORT_ZMAX_0                                     0x0282D4
#define R_0282D8_PA_SC_VPORT_ZMIN_1                                     0x0282D8
#define R_0282DC_PA_SC_VPORT_ZMAX_1                                     0x0282DC
#define R_0282E0_PA_SC_VPORT_ZMIN_2                                     0x0282E0
#define R_0282E4_PA_SC_VPORT_ZMAX_2                                     0x0282E4
#define R_0282E8_PA_SC_VPORT_ZMIN_3                                     0x0282E8
#define R_0282EC_PA_SC_VPORT_ZMAX_3                                     0x0282EC
#define R_0282F0_PA_SC_VPORT_ZMIN_4                                     0x0282F0
#define R_0282F4_PA_SC_VPORT_ZMAX_4                                     0x0282F4
#define R_0282F8_PA_SC_VPORT_ZMIN_5                                     0x0282F8
#define R_0282FC_PA_SC_VPORT_ZMAX_5                                     0x0282FC
#define R_028300_PA_SC_VPORT_ZMIN_6                                     0x028300
#define R_028304_PA_SC_VPORT_ZMAX_6                                     0x028304
#define R_028308_PA_SC_VPORT_ZMIN_7                                     0x028308
#define R_02830C_PA_SC_VPORT_ZMAX_7                                     0x02830C
#define R_028310_PA_SC_VPORT_ZMIN_8                                     0x028310
#define R_028314_PA_SC_VPORT_ZMAX_8                                     0x028314
#define R_028318_PA_SC_VPORT_ZMIN_9                                     0x028318
#define R_02831C_PA_SC_VPORT_ZMAX_9                                     0x02831C
#define R_028320_PA_SC_VPORT_ZMIN_10                                    0x028320
#define R_028324_PA_SC_VPORT_ZMAX_10                                    0x028324
#define R_028328_PA_SC_VPORT_ZMIN_11                                    0x028328
#define R_02832C_PA_SC_VPORT_ZMAX_11                                    0x02832C
#define R_028330_PA_SC_VPORT_ZMIN_12                                    0x028330
#define R_028334_PA_SC_VPORT_ZMAX_12                                    0x028334
#define R_028338_PA_SC_VPORT_ZMIN_13                                    0x028338
#define R_02833C_PA_SC_VPORT_ZMAX_13                                    0x02833C
#define R_028340_PA_SC_VPORT_ZMIN_14                                    0x028340
#define R_028344_PA_SC_VPORT_ZMAX_14                                    0x028344
#define R_028348_PA_SC_VPORT_ZMIN_15                                    0x028348
#define R_02834C_PA_SC_VPORT_ZMAX_15                                    0x02834C
#define R_028350_PA_SC_RASTER_CONFIG                                    0x028350
#define   S_028350_RB_MAP_PKR0(x)                                     (((unsigned)(x) & 0x3) << 0)
#define   G_028350_RB_MAP_PKR0(x)                                     (((x) >> 0) & 0x3)
#define   C_028350_RB_MAP_PKR0                                        0xFFFFFFFC
#define     V_028350_RASTER_CONFIG_RB_MAP_0                         0
#define     V_028350_RASTER_CONFIG_RB_MAP_1                         1
#define     V_028350_RASTER_CONFIG_RB_MAP_2                         2
#define     V_028350_RASTER_CONFIG_RB_MAP_3                         3
#define   S_028350_RB_MAP_PKR1(x)                                     (((unsigned)(x) & 0x3) << 2)
#define   G_028350_RB_MAP_PKR1(x)                                     (((x) >> 2) & 0x3)
#define   C_028350_RB_MAP_PKR1                                        0xFFFFFFF3
#define   S_028350_RB_XSEL2(x)                                        (((unsigned)(x) & 0x3) << 4)
#define   G_028350_RB_XSEL2(x)                                        (((x) >> 4) & 0x3)
#define   C_028350_RB_XSEL2                                           0xFFFFFFCF
#define     V_028350_RASTER_CONFIG_RB_XSEL2_0                       0
#define     V_028350_RASTER_CONFIG_RB_XSEL2_1                       1
#define     V_028350_RASTER_CONFIG_RB_XSEL2_2                       2
#define     V_028350_RASTER_CONFIG_RB_XSEL2_3                       3
#define   S_028350_RB_XSEL(x)                                         (((unsigned)(x) & 0x1) << 6)
#define   G_028350_RB_XSEL(x)                                         (((x) >> 6) & 0x1)
#define   C_028350_RB_XSEL                                            0xFFFFFFBF
#define     V_028350_RASTER_CONFIG_RB_XSEL_0                        0
#define     V_028350_RASTER_CONFIG_RB_XSEL_1                        1
#define   S_028350_RB_YSEL(x)                                         (((unsigned)(x) & 0x1) << 7)
#define   G_028350_RB_YSEL(x)                                         (((x) >> 7) & 0x1)
#define   C_028350_RB_YSEL                                            0xFFFFFF7F
#define     V_028350_RASTER_CONFIG_RB_YSEL_0                        0
#define     V_028350_RASTER_CONFIG_RB_YSEL_1                        1
#define   S_028350_PKR_MAP(x)                                         (((unsigned)(x) & 0x3) << 8)
#define   G_028350_PKR_MAP(x)                                         (((x) >> 8) & 0x3)
#define   C_028350_PKR_MAP                                            0xFFFFFCFF
#define     V_028350_RASTER_CONFIG_PKR_MAP_0                        0
#define     V_028350_RASTER_CONFIG_PKR_MAP_1                        1
#define     V_028350_RASTER_CONFIG_PKR_MAP_2                        2
#define     V_028350_RASTER_CONFIG_PKR_MAP_3                        3
#define   S_028350_PKR_XSEL(x)                                        (((unsigned)(x) & 0x3) << 10)
#define   G_028350_PKR_XSEL(x)                                        (((x) >> 10) & 0x3)
#define   C_028350_PKR_XSEL                                           0xFFFFF3FF
#define     V_028350_RASTER_CONFIG_PKR_XSEL_0                       0
#define     V_028350_RASTER_CONFIG_PKR_XSEL_1                       1
#define     V_028350_RASTER_CONFIG_PKR_XSEL_2                       2
#define     V_028350_RASTER_CONFIG_PKR_XSEL_3                       3
#define   S_028350_PKR_YSEL(x)                                        (((unsigned)(x) & 0x3) << 12)
#define   G_028350_PKR_YSEL(x)                                        (((x) >> 12) & 0x3)
#define   C_028350_PKR_YSEL                                           0xFFFFCFFF
#define     V_028350_RASTER_CONFIG_PKR_YSEL_0                       0
#define     V_028350_RASTER_CONFIG_PKR_YSEL_1                       1
#define     V_028350_RASTER_CONFIG_PKR_YSEL_2                       2
#define     V_028350_RASTER_CONFIG_PKR_YSEL_3                       3
#define   S_028350_PKR_XSEL2(x)                                       (((unsigned)(x) & 0x3) << 14)
#define   G_028350_PKR_XSEL2(x)                                       (((x) >> 14) & 0x3)
#define   C_028350_PKR_XSEL2                                          0xFFFF3FFF
#define     V_028350_RASTER_CONFIG_PKR_XSEL2_0                      0
#define     V_028350_RASTER_CONFIG_PKR_XSEL2_1                      1
#define     V_028350_RASTER_CONFIG_PKR_XSEL2_2                      2
#define     V_028350_RASTER_CONFIG_PKR_XSEL2_3                      3
#define   S_028350_SC_MAP(x)                                          (((unsigned)(x) & 0x3) << 16)
#define   G_028350_SC_MAP(x)                                          (((x) >> 16) & 0x3)
#define   C_028350_SC_MAP                                             0xFFFCFFFF
#define     V_028350_RASTER_CONFIG_SC_MAP_0                         0
#define     V_028350_RASTER_CONFIG_SC_MAP_1                         1
#define     V_028350_RASTER_CONFIG_SC_MAP_2                         2
#define     V_028350_RASTER_CONFIG_SC_MAP_3                         3
#define   S_028350_SC_XSEL(x)                                         (((unsigned)(x) & 0x3) << 18)
#define   G_028350_SC_XSEL(x)                                         (((x) >> 18) & 0x3)
#define   C_028350_SC_XSEL                                            0xFFF3FFFF
#define     V_028350_RASTER_CONFIG_SC_XSEL_8_WIDE_TILE              0
#define     V_028350_RASTER_CONFIG_SC_XSEL_16_WIDE_TILE             1
#define     V_028350_RASTER_CONFIG_SC_XSEL_32_WIDE_TILE             2
#define     V_028350_RASTER_CONFIG_SC_XSEL_64_WIDE_TILE             3
#define   S_028350_SC_YSEL(x)                                         (((unsigned)(x) & 0x3) << 20)
#define   G_028350_SC_YSEL(x)                                         (((x) >> 20) & 0x3)
#define   C_028350_SC_YSEL                                            0xFFCFFFFF
#define     V_028350_RASTER_CONFIG_SC_YSEL_8_WIDE_TILE              0
#define     V_028350_RASTER_CONFIG_SC_YSEL_16_WIDE_TILE             1
#define     V_028350_RASTER_CONFIG_SC_YSEL_32_WIDE_TILE             2
#define     V_028350_RASTER_CONFIG_SC_YSEL_64_WIDE_TILE             3
#define   S_028350_SE_MAP(x)                                          (((unsigned)(x) & 0x3) << 24)
#define   G_028350_SE_MAP(x)                                          (((x) >> 24) & 0x3)
#define   C_028350_SE_MAP                                             0xFCFFFFFF
#define     V_028350_RASTER_CONFIG_SE_MAP_0                         0
#define     V_028350_RASTER_CONFIG_SE_MAP_1                         1
#define     V_028350_RASTER_CONFIG_SE_MAP_2                         2
#define     V_028350_RASTER_CONFIG_SE_MAP_3                         3
#define   S_028350_SE_XSEL_GFX6(x)                                    (((unsigned)(x) & 0x3) << 26) /* <= gfx81, >= gfx10 */
#define   G_028350_SE_XSEL_GFX6(x)                                    (((x) >> 26) & 0x3)
#define   C_028350_SE_XSEL_GFX6                                       0xF3FFFFFF
#define     V_028350_RASTER_CONFIG_SE_XSEL_8_WIDE_TILE              0
#define     V_028350_RASTER_CONFIG_SE_XSEL_16_WIDE_TILE             1
#define     V_028350_RASTER_CONFIG_SE_XSEL_32_WIDE_TILE             2
#define     V_028350_RASTER_CONFIG_SE_XSEL_64_WIDE_TILE             3
#define   S_028350_SE_XSEL_GFX9(x)                                    (((unsigned)(x) & 0x7) << 26) /* gfx9 */
#define   G_028350_SE_XSEL_GFX9(x)                                    (((x) >> 26) & 0x7)
#define   C_028350_SE_XSEL_GFX9                                       0xE3FFFFFF
#define     V_028350_RASTER_CONFIG_SE_XSEL_128_WIDE_TILE            4
#define   S_028350_SE_YSEL_GFX6(x)                                    (((unsigned)(x) & 0x3) << 28) /* <= gfx81, >= gfx10 */
#define   G_028350_SE_YSEL_GFX6(x)                                    (((x) >> 28) & 0x3)
#define   C_028350_SE_YSEL_GFX6                                       0xCFFFFFFF
#define     V_028350_RASTER_CONFIG_SE_YSEL_8_WIDE_TILE              0
#define     V_028350_RASTER_CONFIG_SE_YSEL_16_WIDE_TILE             1
#define     V_028350_RASTER_CONFIG_SE_YSEL_32_WIDE_TILE             2
#define     V_028350_RASTER_CONFIG_SE_YSEL_64_WIDE_TILE             3
#define   S_028350_SE_YSEL_GFX9(x)                                    (((unsigned)(x) & 0x7) << 29) /* gfx9 */
#define   G_028350_SE_YSEL_GFX9(x)                                    (((x) >> 29) & 0x7)
#define   C_028350_SE_YSEL_GFX9                                       0x1FFFFFFF
#define     V_028350_RASTER_CONFIG_SE_YSEL_128_WIDE_TILE            4
#define R_028354_PA_SC_RASTER_CONFIG_1                                  0x028354 /* >= gfx7 */
#define   S_028354_SE_PAIR_MAP(x)                                     (((unsigned)(x) & 0x3) << 0)
#define   G_028354_SE_PAIR_MAP(x)                                     (((x) >> 0) & 0x3)
#define   C_028354_SE_PAIR_MAP                                        0xFFFFFFFC
#define     V_028354_RASTER_CONFIG_SE_PAIR_MAP_0                    0
#define     V_028354_RASTER_CONFIG_SE_PAIR_MAP_1                    1
#define     V_028354_RASTER_CONFIG_SE_PAIR_MAP_2                    2
#define     V_028354_RASTER_CONFIG_SE_PAIR_MAP_3                    3
#define   S_028354_SE_PAIR_XSEL_GFX7(x)                               (((unsigned)(x) & 0x3) << 2) /* gfx7, gfx8, gfx81, >= gfx10 */
#define   G_028354_SE_PAIR_XSEL_GFX7(x)                               (((x) >> 2) & 0x3)
#define   C_028354_SE_PAIR_XSEL_GFX7                                  0xFFFFFFF3
#define     V_028354_RASTER_CONFIG_SE_PAIR_XSEL_8_WIDE_TILE         0
#define     V_028354_RASTER_CONFIG_SE_PAIR_XSEL_16_WIDE_TILE        1
#define     V_028354_RASTER_CONFIG_SE_PAIR_XSEL_32_WIDE_TILE        2
#define     V_028354_RASTER_CONFIG_SE_PAIR_XSEL_64_WIDE_TILE        3
#define   S_028354_SE_PAIR_XSEL_GFX9(x)                               (((unsigned)(x) & 0x7) << 2) /* gfx9 */
#define   G_028354_SE_PAIR_XSEL_GFX9(x)                               (((x) >> 2) & 0x7)
#define   C_028354_SE_PAIR_XSEL_GFX9                                  0xFFFFFFE3
#define     V_028354_RASTER_CONFIG_SE_PAIR_XSEL_128_WIDE_TILE       4
#define   S_028354_SE_PAIR_YSEL_GFX7(x)                               (((unsigned)(x) & 0x3) << 4) /* gfx7, gfx8, gfx81, >= gfx10 */
#define   G_028354_SE_PAIR_YSEL_GFX7(x)                               (((x) >> 4) & 0x3)
#define   C_028354_SE_PAIR_YSEL_GFX7                                  0xFFFFFFCF
#define     V_028354_RASTER_CONFIG_SE_PAIR_YSEL_8_WIDE_TILE         0
#define     V_028354_RASTER_CONFIG_SE_PAIR_YSEL_16_WIDE_TILE        1
#define     V_028354_RASTER_CONFIG_SE_PAIR_YSEL_32_WIDE_TILE        2
#define     V_028354_RASTER_CONFIG_SE_PAIR_YSEL_64_WIDE_TILE        3
#define   S_028354_SE_PAIR_YSEL_GFX9(x)                               (((unsigned)(x) & 0x7) << 5) /* gfx9 */
#define   G_028354_SE_PAIR_YSEL_GFX9(x)                               (((x) >> 5) & 0x7)
#define   C_028354_SE_PAIR_YSEL_GFX9                                  0xFFFFFF1F
#define     V_028354_RASTER_CONFIG_SE_PAIR_YSEL_128_WIDE_TILE       4
#define R_028358_PA_SC_SCREEN_EXTENT_CONTROL                            0x028358 /* >= gfx7 */
#define   S_028358_SLICE_EVEN_ENABLE(x)                               (((unsigned)(x) & 0x3) << 0)
#define   G_028358_SLICE_EVEN_ENABLE(x)                               (((x) >> 0) & 0x3)
#define   C_028358_SLICE_EVEN_ENABLE                                  0xFFFFFFFC
#define   S_028358_SLICE_ODD_ENABLE(x)                                (((unsigned)(x) & 0x3) << 2)
#define   G_028358_SLICE_ODD_ENABLE(x)                                (((x) >> 2) & 0x3)
#define   C_028358_SLICE_ODD_ENABLE                                   0xFFFFFFF3
#define R_02835C_PA_SC_TILE_STEERING_OVERRIDE                           0x02835C /* >= gfx9 */
#define   S_02835C_ENABLE(x)                                          (((unsigned)(x) & 0x1) << 0)
#define   G_02835C_ENABLE(x)                                          (((x) >> 0) & 0x1)
#define   C_02835C_ENABLE                                             0xFFFFFFFE
#define   S_02835C_NUM_SE(x)                                          (((unsigned)(x) & 0x3) << 1)
#define   G_02835C_NUM_SE(x)                                          (((x) >> 1) & 0x3)
#define   C_02835C_NUM_SE                                             0xFFFFFFF9
#define   S_02835C_NUM_RB_PER_SE(x)                                   (((unsigned)(x) & 0x3) << 5)
#define   G_02835C_NUM_RB_PER_SE(x)                                   (((x) >> 5) & 0x3)
#define   C_02835C_NUM_RB_PER_SE                                      0xFFFFFF9F
#define   S_02835C_DISABLE_SRBSL_DB_OPTIMIZED_PACKING(x)              (((unsigned)(x) & 0x1) << 8) /* gfx10 */
#define   G_02835C_DISABLE_SRBSL_DB_OPTIMIZED_PACKING(x)              (((x) >> 8) & 0x1)
#define   C_02835C_DISABLE_SRBSL_DB_OPTIMIZED_PACKING                 0xFFFFFEFF
#define   S_02835C_NUM_SC(x)                                          (((unsigned)(x) & 0x3) << 12) /* >= gfx10 */
#define   G_02835C_NUM_SC(x)                                          (((x) >> 12) & 0x3)
#define   C_02835C_NUM_SC                                             0xFFFFCFFF
#define   S_02835C_NUM_RB_PER_SC(x)                                   (((unsigned)(x) & 0x3) << 16) /* >= gfx10 */
#define   G_02835C_NUM_RB_PER_SC(x)                                   (((x) >> 16) & 0x3)
#define   C_02835C_NUM_RB_PER_SC                                      0xFFFCFFFF
#define   S_02835C_NUM_PACKER_PER_SC(x)                               (((unsigned)(x) & 0x3) << 20) /* >= gfx10 */
#define   G_02835C_NUM_PACKER_PER_SC(x)                               (((x) >> 20) & 0x3)
#define   C_02835C_NUM_PACKER_PER_SC                                  0xFFCFFFFF
#define R_028360_CP_PERFMON_CNTX_CNTL                                   0x028360
#define   S_028360_PERFMON_ENABLE(x)                                  (((unsigned)(x) & 0x1) << 31)
#define   G_028360_PERFMON_ENABLE(x)                                  (((x) >> 31) & 0x1)
#define   C_028360_PERFMON_ENABLE                                     0x7FFFFFFF
#define R_028364_CP_PIPEID                                              0x028364 /* >= gfx9 */
#define   S_028364_PIPE_ID(x)                                         (((unsigned)(x) & 0x3) << 0)
#define   G_028364_PIPE_ID(x)                                         (((x) >> 0) & 0x3)
#define   C_028364_PIPE_ID                                            0xFFFFFFFC
#define R_028364_CP_RINGID                                              0x028364 /* <= gfx81 */
#define   S_028364_RINGID(x)                                          (((unsigned)(x) & 0x3) << 0)
#define   G_028364_RINGID(x)                                          (((x) >> 0) & 0x3)
#define   C_028364_RINGID                                             0xFFFFFFFC
#define R_028368_CP_VMID                                                0x028368
#define   S_028368_VMID(x)                                            (((unsigned)(x) & 0xF) << 0)
#define   G_028368_VMID(x)                                            (((x) >> 0) & 0xF)
#define   C_028368_VMID                                               0xFFFFFFF0
#define R_02836C_CONTEXT_RESERVED_REG0                                  0x02836C /* >= gfx103 */
#define R_028370_CONTEXT_RESERVED_REG1                                  0x028370 /* >= gfx103 */
#define R_0283A0_PA_SC_RIGHT_VERT_GRID                                  0x0283A0 /* gfx9, gfx10 */
#define   S_0283A0_LEFT_QTR(x)                                        (((unsigned)(x) & 0xFF) << 0)
#define   G_0283A0_LEFT_QTR(x)                                        (((x) >> 0) & 0xFF)
#define   C_0283A0_LEFT_QTR                                           0xFFFFFF00
#define   S_0283A0_LEFT_HALF(x)                                       (((unsigned)(x) & 0xFF) << 8)
#define   G_0283A0_LEFT_HALF(x)                                       (((x) >> 8) & 0xFF)
#define   C_0283A0_LEFT_HALF                                          0xFFFF00FF
#define   S_0283A0_RIGHT_HALF(x)                                      (((unsigned)(x) & 0xFF) << 16)
#define   G_0283A0_RIGHT_HALF(x)                                      (((x) >> 16) & 0xFF)
#define   C_0283A0_RIGHT_HALF                                         0xFF00FFFF
#define   S_0283A0_RIGHT_QTR(x)                                       (((unsigned)(x) & 0xFF) << 24)
#define   G_0283A0_RIGHT_QTR(x)                                       (((x) >> 24) & 0xFF)
#define   C_0283A0_RIGHT_QTR                                          0x00FFFFFF
#define R_0283A4_PA_SC_LEFT_VERT_GRID                                   0x0283A4 /* gfx9, gfx10 */
#define   S_0283A4_LEFT_QTR(x)                                        (((unsigned)(x) & 0xFF) << 0)
#define   G_0283A4_LEFT_QTR(x)                                        (((x) >> 0) & 0xFF)
#define   C_0283A4_LEFT_QTR                                           0xFFFFFF00
#define   S_0283A4_LEFT_HALF(x)                                       (((unsigned)(x) & 0xFF) << 8)
#define   G_0283A4_LEFT_HALF(x)                                       (((x) >> 8) & 0xFF)
#define   C_0283A4_LEFT_HALF                                          0xFFFF00FF
#define   S_0283A4_RIGHT_HALF(x)                                      (((unsigned)(x) & 0xFF) << 16)
#define   G_0283A4_RIGHT_HALF(x)                                      (((x) >> 16) & 0xFF)
#define   C_0283A4_RIGHT_HALF                                         0xFF00FFFF
#define   S_0283A4_RIGHT_QTR(x)                                       (((unsigned)(x) & 0xFF) << 24)
#define   G_0283A4_RIGHT_QTR(x)                                       (((x) >> 24) & 0xFF)
#define   C_0283A4_RIGHT_QTR                                          0x00FFFFFF
#define R_0283A8_PA_SC_HORIZ_GRID                                       0x0283A8 /* gfx9, gfx10 */
#define   S_0283A8_TOP_QTR(x)                                         (((unsigned)(x) & 0xFF) << 0)
#define   G_0283A8_TOP_QTR(x)                                         (((x) >> 0) & 0xFF)
#define   C_0283A8_TOP_QTR                                            0xFFFFFF00
#define   S_0283A8_TOP_HALF(x)                                        (((unsigned)(x) & 0xFF) << 8)
#define   G_0283A8_TOP_HALF(x)                                        (((x) >> 8) & 0xFF)
#define   C_0283A8_TOP_HALF                                           0xFFFF00FF
#define   S_0283A8_BOT_HALF(x)                                        (((unsigned)(x) & 0xFF) << 16)
#define   G_0283A8_BOT_HALF(x)                                        (((x) >> 16) & 0xFF)
#define   C_0283A8_BOT_HALF                                           0xFF00FFFF
#define   S_0283A8_BOT_QTR(x)                                         (((unsigned)(x) & 0xFF) << 24)
#define   G_0283A8_BOT_QTR(x)                                         (((x) >> 24) & 0xFF)
#define   C_0283A8_BOT_QTR                                            0x00FFFFFF
#define R_028400_VGT_MAX_VTX_INDX                                       0x028400 /* <= gfx81, >= gfx10 */
#define R_028404_VGT_MIN_VTX_INDX                                       0x028404 /* <= gfx81, >= gfx10 */
#define R_028408_VGT_INDX_OFFSET                                        0x028408 /* <= gfx81, >= gfx10 */
#define R_02840C_VGT_MULTI_PRIM_IB_RESET_INDX                           0x02840C
#define R_028410_CB_RMI_GL2_CACHE_CONTROL                               0x028410 /* >= gfx10 */
#define   S_028410_CMASK_WR_POLICY(x)                                 (((unsigned)(x) & 0x3) << 0)
#define   G_028410_CMASK_WR_POLICY(x)                                 (((x) >> 0) & 0x3)
#define   C_028410_CMASK_WR_POLICY                                    0xFFFFFFFC
#define     V_028410_CACHE_LRU_WR                                   0
#define     V_028410_CACHE_STREAM                                   1
#define     V_028410_CACHE_BYPASS                                   2
#define     V_028410_UNCACHED_WR                                    3
#define   S_028410_FMASK_WR_POLICY(x)                                 (((unsigned)(x) & 0x3) << 2)
#define   G_028410_FMASK_WR_POLICY(x)                                 (((x) >> 2) & 0x3)
#define   C_028410_FMASK_WR_POLICY                                    0xFFFFFFF3
#define   S_028410_DCC_WR_POLICY(x)                                   (((unsigned)(x) & 0x3) << 4)
#define   G_028410_DCC_WR_POLICY(x)                                   (((x) >> 4) & 0x3)
#define   C_028410_DCC_WR_POLICY                                      0xFFFFFFCF
#define   S_028410_COLOR_WR_POLICY(x)                                 (((unsigned)(x) & 0x3) << 6)
#define   G_028410_COLOR_WR_POLICY(x)                                 (((x) >> 6) & 0x3)
#define   C_028410_COLOR_WR_POLICY                                    0xFFFFFF3F
#define   S_028410_CMASK_RD_POLICY(x)                                 (((unsigned)(x) & 0x3) << 16)
#define   G_028410_CMASK_RD_POLICY(x)                                 (((x) >> 16) & 0x3)
#define   C_028410_CMASK_RD_POLICY                                    0xFFFCFFFF
#define     V_028410_CACHE_LRU_RD                                   0
#define     V_028410_CACHE_NOA                                      1
#define     V_028410_UNCACHED_RD                                    2
#define     V_028410_RESERVED_RDPOLICY                              3
#define   S_028410_FMASK_RD_POLICY(x)                                 (((unsigned)(x) & 0x3) << 18)
#define   G_028410_FMASK_RD_POLICY(x)                                 (((x) >> 18) & 0x3)
#define   C_028410_FMASK_RD_POLICY                                    0xFFF3FFFF
#define   S_028410_DCC_RD_POLICY(x)                                   (((unsigned)(x) & 0x3) << 20)
#define   G_028410_DCC_RD_POLICY(x)                                   (((x) >> 20) & 0x3)
#define   C_028410_DCC_RD_POLICY                                      0xFFCFFFFF
#define   S_028410_COLOR_RD_POLICY(x)                                 (((unsigned)(x) & 0x3) << 22)
#define   G_028410_COLOR_RD_POLICY(x)                                 (((x) >> 22) & 0x3)
#define   C_028410_COLOR_RD_POLICY                                    0xFF3FFFFF
#define   S_028410_CMASK_L3_BYPASS(x)                                 (((unsigned)(x) & 0x1) << 24) /* >= gfx103 */
#define   G_028410_CMASK_L3_BYPASS(x)                                 (((x) >> 24) & 0x1)
#define   C_028410_CMASK_L3_BYPASS                                    0xFEFFFFFF
#define   S_028410_FMASK_L3_BYPASS(x)                                 (((unsigned)(x) & 0x1) << 25) /* >= gfx103 */
#define   G_028410_FMASK_L3_BYPASS(x)                                 (((x) >> 25) & 0x1)
#define   C_028410_FMASK_L3_BYPASS                                    0xFDFFFFFF
#define   S_028410_DCC_L3_BYPASS(x)                                   (((unsigned)(x) & 0x1) << 26) /* >= gfx103 */
#define   G_028410_DCC_L3_BYPASS(x)                                   (((x) >> 26) & 0x1)
#define   C_028410_DCC_L3_BYPASS                                      0xFBFFFFFF
#define   S_028410_COLOR_L3_BYPASS(x)                                 (((unsigned)(x) & 0x1) << 27) /* >= gfx103 */
#define   G_028410_COLOR_L3_BYPASS(x)                                 (((x) >> 27) & 0x1)
#define   C_028410_COLOR_L3_BYPASS                                    0xF7FFFFFF
#define   S_028410_FMASK_BIG_PAGE(x)                                  (((unsigned)(x) & 0x1) << 30)
#define   G_028410_FMASK_BIG_PAGE(x)                                  (((x) >> 30) & 0x1)
#define   C_028410_FMASK_BIG_PAGE                                     0xBFFFFFFF
#define   S_028410_COLOR_BIG_PAGE(x)                                  (((unsigned)(x) & 0x1) << 31)
#define   G_028410_COLOR_BIG_PAGE(x)                                  (((x) >> 31) & 0x1)
#define   C_028410_COLOR_BIG_PAGE                                     0x7FFFFFFF
#define R_028414_CB_BLEND_RED                                           0x028414
#define R_028418_CB_BLEND_GREEN                                         0x028418
#define R_02841C_CB_BLEND_BLUE                                          0x02841C
#define R_028420_CB_BLEND_ALPHA                                         0x028420
#define R_028424_CB_DCC_CONTROL                                         0x028424 /* >= gfx8 */
#define   S_028424_OVERWRITE_COMBINER_DISABLE(x)                      (((unsigned)(x) & 0x1) << 0)
#define   G_028424_OVERWRITE_COMBINER_DISABLE(x)                      (((x) >> 0) & 0x1)
#define   C_028424_OVERWRITE_COMBINER_DISABLE                         0xFFFFFFFE
#define   S_028424_OVERWRITE_COMBINER_MRT_SHARING_DISABLE(x)          (((unsigned)(x) & 0x1) << 1) /* gfx8, gfx81, gfx9 */
#define   G_028424_OVERWRITE_COMBINER_MRT_SHARING_DISABLE(x)          (((x) >> 1) & 0x1)
#define   C_028424_OVERWRITE_COMBINER_MRT_SHARING_DISABLE             0xFFFFFFFD
#define   S_028424_OVERWRITE_COMBINER_WATERMARK(x)                    (((unsigned)(x) & 0x1F) << 2)
#define   G_028424_OVERWRITE_COMBINER_WATERMARK(x)                    (((x) >> 2) & 0x1F)
#define   C_028424_OVERWRITE_COMBINER_WATERMARK                       0xFFFFFF83
#define   S_028424_DISABLE_CONSTANT_ENCODE_AC01(x)                    (((unsigned)(x) & 0x1) << 8) /* >= gfx9 */
#define   G_028424_DISABLE_CONSTANT_ENCODE_AC01(x)                    (((x) >> 8) & 0x1)
#define   C_028424_DISABLE_CONSTANT_ENCODE_AC01                       0xFFFFFEFF
#define   S_028424_DISABLE_CONSTANT_ENCODE_SINGLE(x)                  (((unsigned)(x) & 0x1) << 9) /* >= gfx9 */
#define   G_028424_DISABLE_CONSTANT_ENCODE_SINGLE(x)                  (((x) >> 9) & 0x1)
#define   C_028424_DISABLE_CONSTANT_ENCODE_SINGLE                     0xFFFFFDFF
#define   S_028424_DISABLE_CONSTANT_ENCODE_REG(x)                     (((unsigned)(x) & 0x1) << 10) /* >= gfx9 */
#define   G_028424_DISABLE_CONSTANT_ENCODE_REG(x)                     (((x) >> 10) & 0x1)
#define   C_028424_DISABLE_CONSTANT_ENCODE_REG                        0xFFFFFBFF
#define   S_028424_DISABLE_ELIMFC_SKIP_OF_AC01(x)                     (((unsigned)(x) & 0x1) << 12) /* >= gfx9 */
#define   G_028424_DISABLE_ELIMFC_SKIP_OF_AC01(x)                     (((x) >> 12) & 0x1)
#define   C_028424_DISABLE_ELIMFC_SKIP_OF_AC01                        0xFFFFEFFF
#define   S_028424_DISABLE_ELIMFC_SKIP_OF_SINGLE(x)                   (((unsigned)(x) & 0x1) << 13) /* >= gfx9 */
#define   G_028424_DISABLE_ELIMFC_SKIP_OF_SINGLE(x)                   (((x) >> 13) & 0x1)
#define   C_028424_DISABLE_ELIMFC_SKIP_OF_SINGLE                      0xFFFFDFFF
#define   S_028424_ENABLE_ELIMFC_SKIP_OF_REG(x)                       (((unsigned)(x) & 0x1) << 14) /* >= gfx9 */
#define   G_028424_ENABLE_ELIMFC_SKIP_OF_REG(x)                       (((x) >> 14) & 0x1)
#define   C_028424_ENABLE_ELIMFC_SKIP_OF_REG                          0xFFFFBFFF
#define R_028428_CB_COVERAGE_OUT_CONTROL                                0x028428 /* >= gfx10 */
#define   S_028428_COVERAGE_OUT_ENABLE(x)                             (((unsigned)(x) & 0x1) << 0)
#define   G_028428_COVERAGE_OUT_ENABLE(x)                             (((x) >> 0) & 0x1)
#define   C_028428_COVERAGE_OUT_ENABLE                                0xFFFFFFFE
#define   S_028428_COVERAGE_OUT_MRT(x)                                (((unsigned)(x) & 0x7) << 1)
#define   G_028428_COVERAGE_OUT_MRT(x)                                (((x) >> 1) & 0x7)
#define   C_028428_COVERAGE_OUT_MRT                                   0xFFFFFFF1
#define   S_028428_COVERAGE_OUT_CHANNEL(x)                            (((unsigned)(x) & 0x3) << 4)
#define   G_028428_COVERAGE_OUT_CHANNEL(x)                            (((x) >> 4) & 0x3)
#define   C_028428_COVERAGE_OUT_CHANNEL                               0xFFFFFFCF
#define   S_028428_COVERAGE_OUT_SAMPLES(x)                            (((unsigned)(x) & 0xF) << 8)
#define   G_028428_COVERAGE_OUT_SAMPLES(x)                            (((x) >> 8) & 0xF)
#define   C_028428_COVERAGE_OUT_SAMPLES                               0xFFFFF0FF
#define R_02842C_DB_STENCIL_CONTROL                                     0x02842C
#define   S_02842C_STENCILFAIL(x)                                     (((unsigned)(x) & 0xF) << 0)
#define   G_02842C_STENCILFAIL(x)                                     (((x) >> 0) & 0xF)
#define   C_02842C_STENCILFAIL                                        0xFFFFFFF0
#define     V_02842C_STENCIL_KEEP                                   0
#define     V_02842C_STENCIL_ZERO                                   1
#define     V_02842C_STENCIL_ONES                                   2
#define     V_02842C_STENCIL_REPLACE_TEST                           3
#define     V_02842C_STENCIL_REPLACE_OP                             4
#define     V_02842C_STENCIL_ADD_CLAMP                              5
#define     V_02842C_STENCIL_SUB_CLAMP                              6
#define     V_02842C_STENCIL_INVERT                                 7
#define     V_02842C_STENCIL_ADD_WRAP                               8
#define     V_02842C_STENCIL_SUB_WRAP                               9
#define     V_02842C_STENCIL_AND                                    10
#define     V_02842C_STENCIL_OR                                     11
#define     V_02842C_STENCIL_XOR                                    12
#define     V_02842C_STENCIL_NAND                                   13
#define     V_02842C_STENCIL_NOR                                    14
#define     V_02842C_STENCIL_XNOR                                   15
#define   S_02842C_STENCILZPASS(x)                                    (((unsigned)(x) & 0xF) << 4)
#define   G_02842C_STENCILZPASS(x)                                    (((x) >> 4) & 0xF)
#define   C_02842C_STENCILZPASS                                       0xFFFFFF0F
#define   S_02842C_STENCILZFAIL(x)                                    (((unsigned)(x) & 0xF) << 8)
#define   G_02842C_STENCILZFAIL(x)                                    (((x) >> 8) & 0xF)
#define   C_02842C_STENCILZFAIL                                       0xFFFFF0FF
#define   S_02842C_STENCILFAIL_BF(x)                                  (((unsigned)(x) & 0xF) << 12)
#define   G_02842C_STENCILFAIL_BF(x)                                  (((x) >> 12) & 0xF)
#define   C_02842C_STENCILFAIL_BF                                     0xFFFF0FFF
#define   S_02842C_STENCILZPASS_BF(x)                                 (((unsigned)(x) & 0xF) << 16)
#define   G_02842C_STENCILZPASS_BF(x)                                 (((x) >> 16) & 0xF)
#define   C_02842C_STENCILZPASS_BF                                    0xFFF0FFFF
#define   S_02842C_STENCILZFAIL_BF(x)                                 (((unsigned)(x) & 0xF) << 20)
#define   G_02842C_STENCILZFAIL_BF(x)                                 (((x) >> 20) & 0xF)
#define   C_02842C_STENCILZFAIL_BF                                    0xFF0FFFFF
#define R_028430_DB_STENCILREFMASK                                      0x028430
#define   S_028430_STENCILTESTVAL(x)                                  (((unsigned)(x) & 0xFF) << 0)
#define   G_028430_STENCILTESTVAL(x)                                  (((x) >> 0) & 0xFF)
#define   C_028430_STENCILTESTVAL                                     0xFFFFFF00
#define   S_028430_STENCILMASK(x)                                     (((unsigned)(x) & 0xFF) << 8)
#define   G_028430_STENCILMASK(x)                                     (((x) >> 8) & 0xFF)
#define   C_028430_STENCILMASK                                        0xFFFF00FF
#define   S_028430_STENCILWRITEMASK(x)                                (((unsigned)(x) & 0xFF) << 16)
#define   G_028430_STENCILWRITEMASK(x)                                (((x) >> 16) & 0xFF)
#define   C_028430_STENCILWRITEMASK                                   0xFF00FFFF
#define   S_028430_STENCILOPVAL(x)                                    (((unsigned)(x) & 0xFF) << 24)
#define   G_028430_STENCILOPVAL(x)                                    (((x) >> 24) & 0xFF)
#define   C_028430_STENCILOPVAL                                       0x00FFFFFF
#define R_028434_DB_STENCILREFMASK_BF                                   0x028434
#define   S_028434_STENCILTESTVAL_BF(x)                               (((unsigned)(x) & 0xFF) << 0)
#define   G_028434_STENCILTESTVAL_BF(x)                               (((x) >> 0) & 0xFF)
#define   C_028434_STENCILTESTVAL_BF                                  0xFFFFFF00
#define   S_028434_STENCILMASK_BF(x)                                  (((unsigned)(x) & 0xFF) << 8)
#define   G_028434_STENCILMASK_BF(x)                                  (((x) >> 8) & 0xFF)
#define   C_028434_STENCILMASK_BF                                     0xFFFF00FF
#define   S_028434_STENCILWRITEMASK_BF(x)                             (((unsigned)(x) & 0xFF) << 16)
#define   G_028434_STENCILWRITEMASK_BF(x)                             (((x) >> 16) & 0xFF)
#define   C_028434_STENCILWRITEMASK_BF                                0xFF00FFFF
#define   S_028434_STENCILOPVAL_BF(x)                                 (((unsigned)(x) & 0xFF) << 24)
#define   G_028434_STENCILOPVAL_BF(x)                                 (((x) >> 24) & 0xFF)
#define   C_028434_STENCILOPVAL_BF                                    0x00FFFFFF
#define R_02843C_PA_CL_VPORT_XSCALE                                     0x02843C
#define R_028440_PA_CL_VPORT_XOFFSET                                    0x028440
#define R_028444_PA_CL_VPORT_YSCALE                                     0x028444
#define R_028448_PA_CL_VPORT_YOFFSET                                    0x028448
#define R_02844C_PA_CL_VPORT_ZSCALE                                     0x02844C
#define R_028450_PA_CL_VPORT_ZOFFSET                                    0x028450
#define R_028454_PA_CL_VPORT_XSCALE_1                                   0x028454
#define R_028458_PA_CL_VPORT_XOFFSET_1                                  0x028458
#define R_02845C_PA_CL_VPORT_YSCALE_1                                   0x02845C
#define R_028460_PA_CL_VPORT_YOFFSET_1                                  0x028460
#define R_028464_PA_CL_VPORT_ZSCALE_1                                   0x028464
#define R_028468_PA_CL_VPORT_ZOFFSET_1                                  0x028468
#define R_02846C_PA_CL_VPORT_XSCALE_2                                   0x02846C
#define R_028470_PA_CL_VPORT_XOFFSET_2                                  0x028470
#define R_028474_PA_CL_VPORT_YSCALE_2                                   0x028474
#define R_028478_PA_CL_VPORT_YOFFSET_2                                  0x028478
#define R_02847C_PA_CL_VPORT_ZSCALE_2                                   0x02847C
#define R_028480_PA_CL_VPORT_ZOFFSET_2                                  0x028480
#define R_028484_PA_CL_VPORT_XSCALE_3                                   0x028484
#define R_028488_PA_CL_VPORT_XOFFSET_3                                  0x028488
#define R_02848C_PA_CL_VPORT_YSCALE_3                                   0x02848C
#define R_028490_PA_CL_VPORT_YOFFSET_3                                  0x028490
#define R_028494_PA_CL_VPORT_ZSCALE_3                                   0x028494
#define R_028498_PA_CL_VPORT_ZOFFSET_3                                  0x028498
#define R_02849C_PA_CL_VPORT_XSCALE_4                                   0x02849C
#define R_0284A0_PA_CL_VPORT_XOFFSET_4                                  0x0284A0
#define R_0284A4_PA_CL_VPORT_YSCALE_4                                   0x0284A4
#define R_0284A8_PA_CL_VPORT_YOFFSET_4                                  0x0284A8
#define R_0284AC_PA_CL_VPORT_ZSCALE_4                                   0x0284AC
#define R_0284B0_PA_CL_VPORT_ZOFFSET_4                                  0x0284B0
#define R_0284B4_PA_CL_VPORT_XSCALE_5                                   0x0284B4
#define R_0284B8_PA_CL_VPORT_XOFFSET_5                                  0x0284B8
#define R_0284BC_PA_CL_VPORT_YSCALE_5                                   0x0284BC
#define R_0284C0_PA_CL_VPORT_YOFFSET_5                                  0x0284C0
#define R_0284C4_PA_CL_VPORT_ZSCALE_5                                   0x0284C4
#define R_0284C8_PA_CL_VPORT_ZOFFSET_5                                  0x0284C8
#define R_0284CC_PA_CL_VPORT_XSCALE_6                                   0x0284CC
#define R_0284D0_PA_CL_VPORT_XOFFSET_6                                  0x0284D0
#define R_0284D4_PA_CL_VPORT_YSCALE_6                                   0x0284D4
#define R_0284D8_PA_CL_VPORT_YOFFSET_6                                  0x0284D8
#define R_0284DC_PA_CL_VPORT_ZSCALE_6                                   0x0284DC
#define R_0284E0_PA_CL_VPORT_ZOFFSET_6                                  0x0284E0
#define R_0284E4_PA_CL_VPORT_XSCALE_7                                   0x0284E4
#define R_0284E8_PA_CL_VPORT_XOFFSET_7                                  0x0284E8
#define R_0284EC_PA_CL_VPORT_YSCALE_7                                   0x0284EC
#define R_0284F0_PA_CL_VPORT_YOFFSET_7                                  0x0284F0
#define R_0284F4_PA_CL_VPORT_ZSCALE_7                                   0x0284F4
#define R_0284F8_PA_CL_VPORT_ZOFFSET_7                                  0x0284F8
#define R_0284FC_PA_CL_VPORT_XSCALE_8                                   0x0284FC
#define R_028500_PA_CL_VPORT_XOFFSET_8                                  0x028500
#define R_028504_PA_CL_VPORT_YSCALE_8                                   0x028504
#define R_028508_PA_CL_VPORT_YOFFSET_8                                  0x028508
#define R_02850C_PA_CL_VPORT_ZSCALE_8                                   0x02850C
#define R_028510_PA_CL_VPORT_ZOFFSET_8                                  0x028510
#define R_028514_PA_CL_VPORT_XSCALE_9                                   0x028514
#define R_028518_PA_CL_VPORT_XOFFSET_9                                  0x028518
#define R_02851C_PA_CL_VPORT_YSCALE_9                                   0x02851C
#define R_028520_PA_CL_VPORT_YOFFSET_9                                  0x028520
#define R_028524_PA_CL_VPORT_ZSCALE_9                                   0x028524
#define R_028528_PA_CL_VPORT_ZOFFSET_9                                  0x028528
#define R_02852C_PA_CL_VPORT_XSCALE_10                                  0x02852C
#define R_028530_PA_CL_VPORT_XOFFSET_10                                 0x028530
#define R_028534_PA_CL_VPORT_YSCALE_10                                  0x028534
#define R_028538_PA_CL_VPORT_YOFFSET_10                                 0x028538
#define R_02853C_PA_CL_VPORT_ZSCALE_10                                  0x02853C
#define R_028540_PA_CL_VPORT_ZOFFSET_10                                 0x028540
#define R_028544_PA_CL_VPORT_XSCALE_11                                  0x028544
#define R_028548_PA_CL_VPORT_XOFFSET_11                                 0x028548
#define R_02854C_PA_CL_VPORT_YSCALE_11                                  0x02854C
#define R_028550_PA_CL_VPORT_YOFFSET_11                                 0x028550
#define R_028554_PA_CL_VPORT_ZSCALE_11                                  0x028554
#define R_028558_PA_CL_VPORT_ZOFFSET_11                                 0x028558
#define R_02855C_PA_CL_VPORT_XSCALE_12                                  0x02855C
#define R_028560_PA_CL_VPORT_XOFFSET_12                                 0x028560
#define R_028564_PA_CL_VPORT_YSCALE_12                                  0x028564
#define R_028568_PA_CL_VPORT_YOFFSET_12                                 0x028568
#define R_02856C_PA_CL_VPORT_ZSCALE_12                                  0x02856C
#define R_028570_PA_CL_VPORT_ZOFFSET_12                                 0x028570
#define R_028574_PA_CL_VPORT_XSCALE_13                                  0x028574
#define R_028578_PA_CL_VPORT_XOFFSET_13                                 0x028578
#define R_02857C_PA_CL_VPORT_YSCALE_13                                  0x02857C
#define R_028580_PA_CL_VPORT_YOFFSET_13                                 0x028580
#define R_028584_PA_CL_VPORT_ZSCALE_13                                  0x028584
#define R_028588_PA_CL_VPORT_ZOFFSET_13                                 0x028588
#define R_02858C_PA_CL_VPORT_XSCALE_14                                  0x02858C
#define R_028590_PA_CL_VPORT_XOFFSET_14                                 0x028590
#define R_028594_PA_CL_VPORT_YSCALE_14                                  0x028594
#define R_028598_PA_CL_VPORT_YOFFSET_14                                 0x028598
#define R_02859C_PA_CL_VPORT_ZSCALE_14                                  0x02859C
#define R_0285A0_PA_CL_VPORT_ZOFFSET_14                                 0x0285A0
#define R_0285A4_PA_CL_VPORT_XSCALE_15                                  0x0285A4
#define R_0285A8_PA_CL_VPORT_XOFFSET_15                                 0x0285A8
#define R_0285AC_PA_CL_VPORT_YSCALE_15                                  0x0285AC
#define R_0285B0_PA_CL_VPORT_YOFFSET_15                                 0x0285B0
#define R_0285B4_PA_CL_VPORT_ZSCALE_15                                  0x0285B4
#define R_0285B8_PA_CL_VPORT_ZOFFSET_15                                 0x0285B8
#define R_0285BC_PA_CL_UCP_0_X                                          0x0285BC
#define R_0285C0_PA_CL_UCP_0_Y                                          0x0285C0
#define R_0285C4_PA_CL_UCP_0_Z                                          0x0285C4
#define R_0285C8_PA_CL_UCP_0_W                                          0x0285C8
#define R_0285CC_PA_CL_UCP_1_X                                          0x0285CC
#define R_0285D0_PA_CL_UCP_1_Y                                          0x0285D0
#define R_0285D4_PA_CL_UCP_1_Z                                          0x0285D4
#define R_0285D8_PA_CL_UCP_1_W                                          0x0285D8
#define R_0285DC_PA_CL_UCP_2_X                                          0x0285DC
#define R_0285E0_PA_CL_UCP_2_Y                                          0x0285E0
#define R_0285E4_PA_CL_UCP_2_Z                                          0x0285E4
#define R_0285E8_PA_CL_UCP_2_W                                          0x0285E8
#define R_0285EC_PA_CL_UCP_3_X                                          0x0285EC
#define R_0285F0_PA_CL_UCP_3_Y                                          0x0285F0
#define R_0285F4_PA_CL_UCP_3_Z                                          0x0285F4
#define R_0285F8_PA_CL_UCP_3_W                                          0x0285F8
#define R_0285FC_PA_CL_UCP_4_X                                          0x0285FC
#define R_028600_PA_CL_UCP_4_Y                                          0x028600
#define R_028604_PA_CL_UCP_4_Z                                          0x028604
#define R_028608_PA_CL_UCP_4_W                                          0x028608
#define R_02860C_PA_CL_UCP_5_X                                          0x02860C
#define R_028610_PA_CL_UCP_5_Y                                          0x028610
#define R_028614_PA_CL_UCP_5_Z                                          0x028614
#define R_028618_PA_CL_UCP_5_W                                          0x028618
#define R_02861C_PA_CL_PROG_NEAR_CLIP_Z                                 0x02861C /* >= gfx9 */
#define R_028644_SPI_PS_INPUT_CNTL_0                                    0x028644
#define   S_028644_OFFSET(x)                                          (((unsigned)(x) & 0x3F) << 0)
#define   G_028644_OFFSET(x)                                          (((x) >> 0) & 0x3F)
#define   C_028644_OFFSET                                             0xFFFFFFC0
#define   S_028644_DEFAULT_VAL(x)                                     (((unsigned)(x) & 0x3) << 8)
#define   G_028644_DEFAULT_VAL(x)                                     (((x) >> 8) & 0x3)
#define   C_028644_DEFAULT_VAL                                        0xFFFFFCFF
#define   S_028644_FLAT_SHADE(x)                                      (((unsigned)(x) & 0x1) << 10)
#define   G_028644_FLAT_SHADE(x)                                      (((x) >> 10) & 0x1)
#define   C_028644_FLAT_SHADE                                         0xFFFFFBFF
#define   S_028644_ROTATE_PC_PTR(x)                                   (((unsigned)(x) & 0x1) << 11) /* >= gfx103 */
#define   G_028644_ROTATE_PC_PTR(x)                                   (((x) >> 11) & 0x1)
#define   C_028644_ROTATE_PC_PTR                                      0xFFFFF7FF
#define   S_028644_CYL_WRAP(x)                                        (((unsigned)(x) & 0xF) << 13)
#define   G_028644_CYL_WRAP(x)                                        (((x) >> 13) & 0xF)
#define   C_028644_CYL_WRAP                                           0xFFFE1FFF
#define   S_028644_PT_SPRITE_TEX(x)                                   (((unsigned)(x) & 0x1) << 17)
#define   G_028644_PT_SPRITE_TEX(x)                                   (((x) >> 17) & 0x1)
#define   C_028644_PT_SPRITE_TEX                                      0xFFFDFFFF
#define   S_028644_DUP(x)                                             (((unsigned)(x) & 0x1) << 18)
#define   G_028644_DUP(x)                                             (((x) >> 18) & 0x1)
#define   C_028644_DUP                                                0xFFFBFFFF
#define   S_028644_FP16_INTERP_MODE(x)                                (((unsigned)(x) & 0x1) << 19) /* >= gfx8 */
#define   G_028644_FP16_INTERP_MODE(x)                                (((x) >> 19) & 0x1)
#define   C_028644_FP16_INTERP_MODE                                   0xFFF7FFFF
#define   S_028644_USE_DEFAULT_ATTR1(x)                               (((unsigned)(x) & 0x1) << 20) /* >= gfx8 */
#define   G_028644_USE_DEFAULT_ATTR1(x)                               (((x) >> 20) & 0x1)
#define   C_028644_USE_DEFAULT_ATTR1                                  0xFFEFFFFF
#define   S_028644_DEFAULT_VAL_ATTR1(x)                               (((unsigned)(x) & 0x3) << 21) /* >= gfx8 */
#define   G_028644_DEFAULT_VAL_ATTR1(x)                               (((x) >> 21) & 0x3)
#define   C_028644_DEFAULT_VAL_ATTR1                                  0xFF9FFFFF
#define   S_028644_PT_SPRITE_TEX_ATTR1(x)                             (((unsigned)(x) & 0x1) << 23) /* >= gfx8 */
#define   G_028644_PT_SPRITE_TEX_ATTR1(x)                             (((x) >> 23) & 0x1)
#define   C_028644_PT_SPRITE_TEX_ATTR1                                0xFF7FFFFF
#define   S_028644_ATTR0_VALID(x)                                     (((unsigned)(x) & 0x1) << 24) /* >= gfx8 */
#define   G_028644_ATTR0_VALID(x)                                     (((x) >> 24) & 0x1)
#define   C_028644_ATTR0_VALID                                        0xFEFFFFFF
#define   S_028644_ATTR1_VALID(x)                                     (((unsigned)(x) & 0x1) << 25) /* >= gfx8 */
#define   G_028644_ATTR1_VALID(x)                                     (((x) >> 25) & 0x1)
#define   C_028644_ATTR1_VALID                                        0xFDFFFFFF
#define R_028648_SPI_PS_INPUT_CNTL_1                                    0x028648
#define R_02864C_SPI_PS_INPUT_CNTL_2                                    0x02864C
#define R_028650_SPI_PS_INPUT_CNTL_3                                    0x028650
#define R_028654_SPI_PS_INPUT_CNTL_4                                    0x028654
#define R_028658_SPI_PS_INPUT_CNTL_5                                    0x028658
#define R_02865C_SPI_PS_INPUT_CNTL_6                                    0x02865C
#define R_028660_SPI_PS_INPUT_CNTL_7                                    0x028660
#define R_028664_SPI_PS_INPUT_CNTL_8                                    0x028664
#define R_028668_SPI_PS_INPUT_CNTL_9                                    0x028668
#define R_02866C_SPI_PS_INPUT_CNTL_10                                   0x02866C
#define R_028670_SPI_PS_INPUT_CNTL_11                                   0x028670
#define R_028674_SPI_PS_INPUT_CNTL_12                                   0x028674
#define R_028678_SPI_PS_INPUT_CNTL_13                                   0x028678
#define R_02867C_SPI_PS_INPUT_CNTL_14                                   0x02867C
#define R_028680_SPI_PS_INPUT_CNTL_15                                   0x028680
#define R_028684_SPI_PS_INPUT_CNTL_16                                   0x028684
#define R_028688_SPI_PS_INPUT_CNTL_17                                   0x028688
#define R_02868C_SPI_PS_INPUT_CNTL_18                                   0x02868C
#define R_028690_SPI_PS_INPUT_CNTL_19                                   0x028690
#define R_028694_SPI_PS_INPUT_CNTL_20                                   0x028694
#define   S_028694_OFFSET(x)                                          (((unsigned)(x) & 0x3F) << 0)
#define   G_028694_OFFSET(x)                                          (((x) >> 0) & 0x3F)
#define   C_028694_OFFSET                                             0xFFFFFFC0
#define   S_028694_DEFAULT_VAL(x)                                     (((unsigned)(x) & 0x3) << 8)
#define   G_028694_DEFAULT_VAL(x)                                     (((x) >> 8) & 0x3)
#define   C_028694_DEFAULT_VAL                                        0xFFFFFCFF
#define   S_028694_FLAT_SHADE(x)                                      (((unsigned)(x) & 0x1) << 10)
#define   G_028694_FLAT_SHADE(x)                                      (((x) >> 10) & 0x1)
#define   C_028694_FLAT_SHADE                                         0xFFFFFBFF
#define   S_028694_ROTATE_PC_PTR(x)                                   (((unsigned)(x) & 0x1) << 11) /* >= gfx103 */
#define   G_028694_ROTATE_PC_PTR(x)                                   (((x) >> 11) & 0x1)
#define   C_028694_ROTATE_PC_PTR                                      0xFFFFF7FF
#define   S_028694_DUP(x)                                             (((unsigned)(x) & 0x1) << 18)
#define   G_028694_DUP(x)                                             (((x) >> 18) & 0x1)
#define   C_028694_DUP                                                0xFFFBFFFF
#define   S_028694_FP16_INTERP_MODE(x)                                (((unsigned)(x) & 0x1) << 19) /* >= gfx8 */
#define   G_028694_FP16_INTERP_MODE(x)                                (((x) >> 19) & 0x1)
#define   C_028694_FP16_INTERP_MODE                                   0xFFF7FFFF
#define   S_028694_USE_DEFAULT_ATTR1(x)                               (((unsigned)(x) & 0x1) << 20) /* >= gfx8 */
#define   G_028694_USE_DEFAULT_ATTR1(x)                               (((x) >> 20) & 0x1)
#define   C_028694_USE_DEFAULT_ATTR1                                  0xFFEFFFFF
#define   S_028694_DEFAULT_VAL_ATTR1(x)                               (((unsigned)(x) & 0x3) << 21) /* >= gfx8 */
#define   G_028694_DEFAULT_VAL_ATTR1(x)                               (((x) >> 21) & 0x3)
#define   C_028694_DEFAULT_VAL_ATTR1                                  0xFF9FFFFF
#define   S_028694_ATTR0_VALID(x)                                     (((unsigned)(x) & 0x1) << 24) /* >= gfx8 */
#define   G_028694_ATTR0_VALID(x)                                     (((x) >> 24) & 0x1)
#define   C_028694_ATTR0_VALID                                        0xFEFFFFFF
#define   S_028694_ATTR1_VALID(x)                                     (((unsigned)(x) & 0x1) << 25) /* >= gfx8 */
#define   G_028694_ATTR1_VALID(x)                                     (((x) >> 25) & 0x1)
#define   C_028694_ATTR1_VALID                                        0xFDFFFFFF
#define R_028698_SPI_PS_INPUT_CNTL_21                                   0x028698
#define R_02869C_SPI_PS_INPUT_CNTL_22                                   0x02869C
#define R_0286A0_SPI_PS_INPUT_CNTL_23                                   0x0286A0
#define R_0286A4_SPI_PS_INPUT_CNTL_24                                   0x0286A4
#define R_0286A8_SPI_PS_INPUT_CNTL_25                                   0x0286A8
#define R_0286AC_SPI_PS_INPUT_CNTL_26                                   0x0286AC
#define R_0286B0_SPI_PS_INPUT_CNTL_27                                   0x0286B0
#define R_0286B4_SPI_PS_INPUT_CNTL_28                                   0x0286B4
#define R_0286B8_SPI_PS_INPUT_CNTL_29                                   0x0286B8
#define R_0286BC_SPI_PS_INPUT_CNTL_30                                   0x0286BC
#define R_0286C0_SPI_PS_INPUT_CNTL_31                                   0x0286C0
#define R_0286C4_SPI_VS_OUT_CONFIG                                      0x0286C4
#define   S_0286C4_VS_EXPORT_COUNT(x)                                 (((unsigned)(x) & 0x1F) << 1)
#define   G_0286C4_VS_EXPORT_COUNT(x)                                 (((x) >> 1) & 0x1F)
#define   C_0286C4_VS_EXPORT_COUNT                                    0xFFFFFFC1
#define   S_0286C4_VS_HALF_PACK(x)                                    (((unsigned)(x) & 0x1) << 6)
#define   G_0286C4_VS_HALF_PACK(x)                                    (((x) >> 6) & 0x1)
#define   C_0286C4_VS_HALF_PACK                                       0xFFFFFFBF
#define   S_0286C4_NO_PC_EXPORT(x)                                    (((unsigned)(x) & 0x1) << 7) /* >= gfx10 */
#define   G_0286C4_NO_PC_EXPORT(x)                                    (((x) >> 7) & 0x1)
#define   C_0286C4_NO_PC_EXPORT                                       0xFFFFFF7F
#define   S_0286C4_PRIM_EXPORT_COUNT(x)                               (((unsigned)(x) & 0x1F) << 8) /* >= gfx103 */
#define   G_0286C4_PRIM_EXPORT_COUNT(x)                               (((x) >> 8) & 0x1F)
#define   C_0286C4_PRIM_EXPORT_COUNT                                  0xFFFFE0FF
#define R_0286CC_SPI_PS_INPUT_ENA                                       0x0286CC
#define   S_0286CC_PERSP_SAMPLE_ENA(x)                                (((unsigned)(x) & 0x1) << 0)
#define   G_0286CC_PERSP_SAMPLE_ENA(x)                                (((x) >> 0) & 0x1)
#define   C_0286CC_PERSP_SAMPLE_ENA                                   0xFFFFFFFE
#define   S_0286CC_PERSP_CENTER_ENA(x)                                (((unsigned)(x) & 0x1) << 1)
#define   G_0286CC_PERSP_CENTER_ENA(x)                                (((x) >> 1) & 0x1)
#define   C_0286CC_PERSP_CENTER_ENA                                   0xFFFFFFFD
#define   S_0286CC_PERSP_CENTROID_ENA(x)                              (((unsigned)(x) & 0x1) << 2)
#define   G_0286CC_PERSP_CENTROID_ENA(x)                              (((x) >> 2) & 0x1)
#define   C_0286CC_PERSP_CENTROID_ENA                                 0xFFFFFFFB
#define   S_0286CC_PERSP_PULL_MODEL_ENA(x)                            (((unsigned)(x) & 0x1) << 3)
#define   G_0286CC_PERSP_PULL_MODEL_ENA(x)                            (((x) >> 3) & 0x1)
#define   C_0286CC_PERSP_PULL_MODEL_ENA                               0xFFFFFFF7
#define   S_0286CC_LINEAR_SAMPLE_ENA(x)                               (((unsigned)(x) & 0x1) << 4)
#define   G_0286CC_LINEAR_SAMPLE_ENA(x)                               (((x) >> 4) & 0x1)
#define   C_0286CC_LINEAR_SAMPLE_ENA                                  0xFFFFFFEF
#define   S_0286CC_LINEAR_CENTER_ENA(x)                               (((unsigned)(x) & 0x1) << 5)
#define   G_0286CC_LINEAR_CENTER_ENA(x)                               (((x) >> 5) & 0x1)
#define   C_0286CC_LINEAR_CENTER_ENA                                  0xFFFFFFDF
#define   S_0286CC_LINEAR_CENTROID_ENA(x)                             (((unsigned)(x) & 0x1) << 6)
#define   G_0286CC_LINEAR_CENTROID_ENA(x)                             (((x) >> 6) & 0x1)
#define   C_0286CC_LINEAR_CENTROID_ENA                                0xFFFFFFBF
#define   S_0286CC_LINE_STIPPLE_TEX_ENA(x)                            (((unsigned)(x) & 0x1) << 7)
#define   G_0286CC_LINE_STIPPLE_TEX_ENA(x)                            (((x) >> 7) & 0x1)
#define   C_0286CC_LINE_STIPPLE_TEX_ENA                               0xFFFFFF7F
#define   S_0286CC_POS_X_FLOAT_ENA(x)                                 (((unsigned)(x) & 0x1) << 8)
#define   G_0286CC_POS_X_FLOAT_ENA(x)                                 (((x) >> 8) & 0x1)
#define   C_0286CC_POS_X_FLOAT_ENA                                    0xFFFFFEFF
#define   S_0286CC_POS_Y_FLOAT_ENA(x)                                 (((unsigned)(x) & 0x1) << 9)
#define   G_0286CC_POS_Y_FLOAT_ENA(x)                                 (((x) >> 9) & 0x1)
#define   C_0286CC_POS_Y_FLOAT_ENA                                    0xFFFFFDFF
#define   S_0286CC_POS_Z_FLOAT_ENA(x)                                 (((unsigned)(x) & 0x1) << 10)
#define   G_0286CC_POS_Z_FLOAT_ENA(x)                                 (((x) >> 10) & 0x1)
#define   C_0286CC_POS_Z_FLOAT_ENA                                    0xFFFFFBFF
#define   S_0286CC_POS_W_FLOAT_ENA(x)                                 (((unsigned)(x) & 0x1) << 11)
#define   G_0286CC_POS_W_FLOAT_ENA(x)                                 (((x) >> 11) & 0x1)
#define   C_0286CC_POS_W_FLOAT_ENA                                    0xFFFFF7FF
#define   S_0286CC_FRONT_FACE_ENA(x)                                  (((unsigned)(x) & 0x1) << 12)
#define   G_0286CC_FRONT_FACE_ENA(x)                                  (((x) >> 12) & 0x1)
#define   C_0286CC_FRONT_FACE_ENA                                     0xFFFFEFFF
#define   S_0286CC_ANCILLARY_ENA(x)                                   (((unsigned)(x) & 0x1) << 13)
#define   G_0286CC_ANCILLARY_ENA(x)                                   (((x) >> 13) & 0x1)
#define   C_0286CC_ANCILLARY_ENA                                      0xFFFFDFFF
#define   S_0286CC_SAMPLE_COVERAGE_ENA(x)                             (((unsigned)(x) & 0x1) << 14)
#define   G_0286CC_SAMPLE_COVERAGE_ENA(x)                             (((x) >> 14) & 0x1)
#define   C_0286CC_SAMPLE_COVERAGE_ENA                                0xFFFFBFFF
#define   S_0286CC_POS_FIXED_PT_ENA(x)                                (((unsigned)(x) & 0x1) << 15)
#define   G_0286CC_POS_FIXED_PT_ENA(x)                                (((x) >> 15) & 0x1)
#define   C_0286CC_POS_FIXED_PT_ENA                                   0xFFFF7FFF
#define R_0286D0_SPI_PS_INPUT_ADDR                                      0x0286D0
#define   S_0286D0_PERSP_SAMPLE_ENA(x)                                (((unsigned)(x) & 0x1) << 0)
#define   G_0286D0_PERSP_SAMPLE_ENA(x)                                (((x) >> 0) & 0x1)
#define   C_0286D0_PERSP_SAMPLE_ENA                                   0xFFFFFFFE
#define   S_0286D0_PERSP_CENTER_ENA(x)                                (((unsigned)(x) & 0x1) << 1)
#define   G_0286D0_PERSP_CENTER_ENA(x)                                (((x) >> 1) & 0x1)
#define   C_0286D0_PERSP_CENTER_ENA                                   0xFFFFFFFD
#define   S_0286D0_PERSP_CENTROID_ENA(x)                              (((unsigned)(x) & 0x1) << 2)
#define   G_0286D0_PERSP_CENTROID_ENA(x)                              (((x) >> 2) & 0x1)
#define   C_0286D0_PERSP_CENTROID_ENA                                 0xFFFFFFFB
#define   S_0286D0_PERSP_PULL_MODEL_ENA(x)                            (((unsigned)(x) & 0x1) << 3)
#define   G_0286D0_PERSP_PULL_MODEL_ENA(x)                            (((x) >> 3) & 0x1)
#define   C_0286D0_PERSP_PULL_MODEL_ENA                               0xFFFFFFF7
#define   S_0286D0_LINEAR_SAMPLE_ENA(x)                               (((unsigned)(x) & 0x1) << 4)
#define   G_0286D0_LINEAR_SAMPLE_ENA(x)                               (((x) >> 4) & 0x1)
#define   C_0286D0_LINEAR_SAMPLE_ENA                                  0xFFFFFFEF
#define   S_0286D0_LINEAR_CENTER_ENA(x)                               (((unsigned)(x) & 0x1) << 5)
#define   G_0286D0_LINEAR_CENTER_ENA(x)                               (((x) >> 5) & 0x1)
#define   C_0286D0_LINEAR_CENTER_ENA                                  0xFFFFFFDF
#define   S_0286D0_LINEAR_CENTROID_ENA(x)                             (((unsigned)(x) & 0x1) << 6)
#define   G_0286D0_LINEAR_CENTROID_ENA(x)                             (((x) >> 6) & 0x1)
#define   C_0286D0_LINEAR_CENTROID_ENA                                0xFFFFFFBF
#define   S_0286D0_LINE_STIPPLE_TEX_ENA(x)                            (((unsigned)(x) & 0x1) << 7)
#define   G_0286D0_LINE_STIPPLE_TEX_ENA(x)                            (((x) >> 7) & 0x1)
#define   C_0286D0_LINE_STIPPLE_TEX_ENA                               0xFFFFFF7F
#define   S_0286D0_POS_X_FLOAT_ENA(x)                                 (((unsigned)(x) & 0x1) << 8)
#define   G_0286D0_POS_X_FLOAT_ENA(x)                                 (((x) >> 8) & 0x1)
#define   C_0286D0_POS_X_FLOAT_ENA                                    0xFFFFFEFF
#define   S_0286D0_POS_Y_FLOAT_ENA(x)                                 (((unsigned)(x) & 0x1) << 9)
#define   G_0286D0_POS_Y_FLOAT_ENA(x)                                 (((x) >> 9) & 0x1)
#define   C_0286D0_POS_Y_FLOAT_ENA                                    0xFFFFFDFF
#define   S_0286D0_POS_Z_FLOAT_ENA(x)                                 (((unsigned)(x) & 0x1) << 10)
#define   G_0286D0_POS_Z_FLOAT_ENA(x)                                 (((x) >> 10) & 0x1)
#define   C_0286D0_POS_Z_FLOAT_ENA                                    0xFFFFFBFF
#define   S_0286D0_POS_W_FLOAT_ENA(x)                                 (((unsigned)(x) & 0x1) << 11)
#define   G_0286D0_POS_W_FLOAT_ENA(x)                                 (((x) >> 11) & 0x1)
#define   C_0286D0_POS_W_FLOAT_ENA                                    0xFFFFF7FF
#define   S_0286D0_FRONT_FACE_ENA(x)                                  (((unsigned)(x) & 0x1) << 12)
#define   G_0286D0_FRONT_FACE_ENA(x)                                  (((x) >> 12) & 0x1)
#define   C_0286D0_FRONT_FACE_ENA                                     0xFFFFEFFF
#define   S_0286D0_ANCILLARY_ENA(x)                                   (((unsigned)(x) & 0x1) << 13)
#define   G_0286D0_ANCILLARY_ENA(x)                                   (((x) >> 13) & 0x1)
#define   C_0286D0_ANCILLARY_ENA                                      0xFFFFDFFF
#define   S_0286D0_SAMPLE_COVERAGE_ENA(x)                             (((unsigned)(x) & 0x1) << 14)
#define   G_0286D0_SAMPLE_COVERAGE_ENA(x)                             (((x) >> 14) & 0x1)
#define   C_0286D0_SAMPLE_COVERAGE_ENA                                0xFFFFBFFF
#define   S_0286D0_POS_FIXED_PT_ENA(x)                                (((unsigned)(x) & 0x1) << 15)
#define   G_0286D0_POS_FIXED_PT_ENA(x)                                (((x) >> 15) & 0x1)
#define   C_0286D0_POS_FIXED_PT_ENA                                   0xFFFF7FFF
#define R_0286D4_SPI_INTERP_CONTROL_0                                   0x0286D4
#define   S_0286D4_FLAT_SHADE_ENA(x)                                  (((unsigned)(x) & 0x1) << 0)
#define   G_0286D4_FLAT_SHADE_ENA(x)                                  (((x) >> 0) & 0x1)
#define   C_0286D4_FLAT_SHADE_ENA                                     0xFFFFFFFE
#define   S_0286D4_PNT_SPRITE_ENA(x)                                  (((unsigned)(x) & 0x1) << 1)
#define   G_0286D4_PNT_SPRITE_ENA(x)                                  (((x) >> 1) & 0x1)
#define   C_0286D4_PNT_SPRITE_ENA                                     0xFFFFFFFD
#define   S_0286D4_PNT_SPRITE_OVRD_X(x)                               (((unsigned)(x) & 0x7) << 2)
#define   G_0286D4_PNT_SPRITE_OVRD_X(x)                               (((x) >> 2) & 0x7)
#define   C_0286D4_PNT_SPRITE_OVRD_X                                  0xFFFFFFE3
#define     V_0286D4_SPI_PNT_SPRITE_SEL_0                           0
#define     V_0286D4_SPI_PNT_SPRITE_SEL_1                           1
#define     V_0286D4_SPI_PNT_SPRITE_SEL_S                           2
#define     V_0286D4_SPI_PNT_SPRITE_SEL_T                           3
#define     V_0286D4_SPI_PNT_SPRITE_SEL_NONE                        4
#define   S_0286D4_PNT_SPRITE_OVRD_Y(x)                               (((unsigned)(x) & 0x7) << 5)
#define   G_0286D4_PNT_SPRITE_OVRD_Y(x)                               (((x) >> 5) & 0x7)
#define   C_0286D4_PNT_SPRITE_OVRD_Y                                  0xFFFFFF1F
#define   S_0286D4_PNT_SPRITE_OVRD_Z(x)                               (((unsigned)(x) & 0x7) << 8)
#define   G_0286D4_PNT_SPRITE_OVRD_Z(x)                               (((x) >> 8) & 0x7)
#define   C_0286D4_PNT_SPRITE_OVRD_Z                                  0xFFFFF8FF
#define   S_0286D4_PNT_SPRITE_OVRD_W(x)                               (((unsigned)(x) & 0x7) << 11)
#define   G_0286D4_PNT_SPRITE_OVRD_W(x)                               (((x) >> 11) & 0x7)
#define   C_0286D4_PNT_SPRITE_OVRD_W                                  0xFFFFC7FF
#define   S_0286D4_PNT_SPRITE_TOP_1(x)                                (((unsigned)(x) & 0x1) << 14)
#define   G_0286D4_PNT_SPRITE_TOP_1(x)                                (((x) >> 14) & 0x1)
#define   C_0286D4_PNT_SPRITE_TOP_1                                   0xFFFFBFFF
#define R_0286D8_SPI_PS_IN_CONTROL                                      0x0286D8
#define   S_0286D8_NUM_INTERP(x)                                      (((unsigned)(x) & 0x3F) << 0)
#define   G_0286D8_NUM_INTERP(x)                                      (((x) >> 0) & 0x3F)
#define   C_0286D8_NUM_INTERP                                         0xFFFFFFC0
#define   S_0286D8_PARAM_GEN(x)                                       (((unsigned)(x) & 0x1) << 6) /* <= gfx10 */
#define   G_0286D8_PARAM_GEN(x)                                       (((x) >> 6) & 0x1)
#define   C_0286D8_PARAM_GEN                                          0xFFFFFFBF
#define   S_0286D8_OFFCHIP_PARAM_EN(x)                                (((unsigned)(x) & 0x1) << 7) /* >= gfx9 */
#define   G_0286D8_OFFCHIP_PARAM_EN(x)                                (((x) >> 7) & 0x1)
#define   C_0286D8_OFFCHIP_PARAM_EN                                   0xFFFFFF7F
#define   S_0286D8_LATE_PC_DEALLOC(x)                                 (((unsigned)(x) & 0x1) << 8) /* >= gfx9 */
#define   G_0286D8_LATE_PC_DEALLOC(x)                                 (((x) >> 8) & 0x1)
#define   C_0286D8_LATE_PC_DEALLOC                                    0xFFFFFEFF
#define   S_0286D8_NUM_PRIM_INTERP(x)                                 (((unsigned)(x) & 0x1F) << 9) /* >= gfx103 */
#define   G_0286D8_NUM_PRIM_INTERP(x)                                 (((x) >> 9) & 0x1F)
#define   C_0286D8_NUM_PRIM_INTERP                                    0xFFFFC1FF
#define   S_0286D8_BC_OPTIMIZE_DISABLE(x)                             (((unsigned)(x) & 0x1) << 14)
#define   G_0286D8_BC_OPTIMIZE_DISABLE(x)                             (((x) >> 14) & 0x1)
#define   C_0286D8_BC_OPTIMIZE_DISABLE                                0xFFFFBFFF
#define   S_0286D8_PS_W32_EN(x)                                       (((unsigned)(x) & 0x1) << 15) /* >= gfx10 */
#define   G_0286D8_PS_W32_EN(x)                                       (((x) >> 15) & 0x1)
#define   C_0286D8_PS_W32_EN                                          0xFFFF7FFF
#define R_0286E0_SPI_BARYC_CNTL                                         0x0286E0
#define   S_0286E0_PERSP_CENTER_CNTL(x)                               (((unsigned)(x) & 0x1) << 0)
#define   G_0286E0_PERSP_CENTER_CNTL(x)                               (((x) >> 0) & 0x1)
#define   C_0286E0_PERSP_CENTER_CNTL                                  0xFFFFFFFE
#define   S_0286E0_PERSP_CENTROID_CNTL(x)                             (((unsigned)(x) & 0x1) << 4)
#define   G_0286E0_PERSP_CENTROID_CNTL(x)                             (((x) >> 4) & 0x1)
#define   C_0286E0_PERSP_CENTROID_CNTL                                0xFFFFFFEF
#define   S_0286E0_LINEAR_CENTER_CNTL(x)                              (((unsigned)(x) & 0x1) << 8)
#define   G_0286E0_LINEAR_CENTER_CNTL(x)                              (((x) >> 8) & 0x1)
#define   C_0286E0_LINEAR_CENTER_CNTL                                 0xFFFFFEFF
#define   S_0286E0_LINEAR_CENTROID_CNTL(x)                            (((unsigned)(x) & 0x1) << 12)
#define   G_0286E0_LINEAR_CENTROID_CNTL(x)                            (((x) >> 12) & 0x1)
#define   C_0286E0_LINEAR_CENTROID_CNTL                               0xFFFFEFFF
#define   S_0286E0_POS_FLOAT_LOCATION(x)                              (((unsigned)(x) & 0x3) << 16)
#define   G_0286E0_POS_FLOAT_LOCATION(x)                              (((x) >> 16) & 0x3)
#define   C_0286E0_POS_FLOAT_LOCATION                                 0xFFFCFFFF
#define   S_0286E0_POS_FLOAT_ULC(x)                                   (((unsigned)(x) & 0x1) << 20)
#define   G_0286E0_POS_FLOAT_ULC(x)                                   (((x) >> 20) & 0x1)
#define   C_0286E0_POS_FLOAT_ULC                                      0xFFEFFFFF
#define   S_0286E0_FRONT_FACE_ALL_BITS(x)                             (((unsigned)(x) & 0x1) << 24)
#define   G_0286E0_FRONT_FACE_ALL_BITS(x)                             (((x) >> 24) & 0x1)
#define   C_0286E0_FRONT_FACE_ALL_BITS                                0xFEFFFFFF
#define R_0286E8_SPI_TMPRING_SIZE                                       0x0286E8
#define   S_0286E8_WAVES(x)                                           (((unsigned)(x) & 0xFFF) << 0)
#define   G_0286E8_WAVES(x)                                           (((x) >> 0) & 0xFFF)
#define   C_0286E8_WAVES                                              0xFFFFF000
#define   S_0286E8_WAVESIZE(x)                                        (((unsigned)(x) & 0x1FFF) << 12)
#define   G_0286E8_WAVESIZE(x)                                        (((x) >> 12) & 0x1FFF)
#define   C_0286E8_WAVESIZE                                           0xFE000FFF
#define R_028708_SPI_SHADER_IDX_FORMAT                                  0x028708 /* >= gfx10 */
#define   S_028708_IDX0_EXPORT_FORMAT(x)                              (((unsigned)(x) & 0xF) << 0)
#define   G_028708_IDX0_EXPORT_FORMAT(x)                              (((x) >> 0) & 0xF)
#define   C_028708_IDX0_EXPORT_FORMAT                                 0xFFFFFFF0
#define     V_028708_SPI_SHADER_NONE                                0
#define     V_028708_SPI_SHADER_1COMP                               1
#define     V_028708_SPI_SHADER_2COMP                               2
#define     V_028708_SPI_SHADER_4COMPRESS                           3
#define     V_028708_SPI_SHADER_4COMP                               4
#define R_02870C_SPI_SHADER_POS_FORMAT                                  0x02870C
#define   S_02870C_POS0_EXPORT_FORMAT(x)                              (((unsigned)(x) & 0xF) << 0)
#define   G_02870C_POS0_EXPORT_FORMAT(x)                              (((x) >> 0) & 0xF)
#define   C_02870C_POS0_EXPORT_FORMAT                                 0xFFFFFFF0
#define     V_02870C_SPI_SHADER_NONE                                0
#define     V_02870C_SPI_SHADER_1COMP                               1
#define     V_02870C_SPI_SHADER_2COMP                               2
#define     V_02870C_SPI_SHADER_4COMPRESS                           3
#define     V_02870C_SPI_SHADER_4COMP                               4
#define   S_02870C_POS1_EXPORT_FORMAT(x)                              (((unsigned)(x) & 0xF) << 4)
#define   G_02870C_POS1_EXPORT_FORMAT(x)                              (((x) >> 4) & 0xF)
#define   C_02870C_POS1_EXPORT_FORMAT                                 0xFFFFFF0F
#define   S_02870C_POS2_EXPORT_FORMAT(x)                              (((unsigned)(x) & 0xF) << 8)
#define   G_02870C_POS2_EXPORT_FORMAT(x)                              (((x) >> 8) & 0xF)
#define   C_02870C_POS2_EXPORT_FORMAT                                 0xFFFFF0FF
#define   S_02870C_POS3_EXPORT_FORMAT(x)                              (((unsigned)(x) & 0xF) << 12)
#define   G_02870C_POS3_EXPORT_FORMAT(x)                              (((x) >> 12) & 0xF)
#define   C_02870C_POS3_EXPORT_FORMAT                                 0xFFFF0FFF
#define   S_02870C_POS4_EXPORT_FORMAT(x)                              (((unsigned)(x) & 0xF) << 16) /* >= gfx10 */
#define   G_02870C_POS4_EXPORT_FORMAT(x)                              (((x) >> 16) & 0xF)
#define   C_02870C_POS4_EXPORT_FORMAT                                 0xFFF0FFFF
#define R_028710_SPI_SHADER_Z_FORMAT                                    0x028710
#define   S_028710_Z_EXPORT_FORMAT(x)                                 (((unsigned)(x) & 0xF) << 0)
#define   G_028710_Z_EXPORT_FORMAT(x)                                 (((x) >> 0) & 0xF)
#define   C_028710_Z_EXPORT_FORMAT                                    0xFFFFFFF0
#define     V_028710_SPI_SHADER_ZERO                                0
#define     V_028710_SPI_SHADER_32_R                                1
#define     V_028710_SPI_SHADER_32_GR                               2
#define     V_028710_SPI_SHADER_32_AR                               3
#define     V_028710_SPI_SHADER_FP16_ABGR                           4
#define     V_028710_SPI_SHADER_UNORM16_ABGR                        5
#define     V_028710_SPI_SHADER_SNORM16_ABGR                        6
#define     V_028710_SPI_SHADER_UINT16_ABGR                         7
#define     V_028710_SPI_SHADER_SINT16_ABGR                         8
#define     V_028710_SPI_SHADER_32_ABGR                             9
#define R_028714_SPI_SHADER_COL_FORMAT                                  0x028714
#define   S_028714_COL0_EXPORT_FORMAT(x)                              (((unsigned)(x) & 0xF) << 0)
#define   G_028714_COL0_EXPORT_FORMAT(x)                              (((x) >> 0) & 0xF)
#define   C_028714_COL0_EXPORT_FORMAT                                 0xFFFFFFF0
#define     V_028714_SPI_SHADER_ZERO                                0
#define     V_028714_SPI_SHADER_32_R                                1
#define     V_028714_SPI_SHADER_32_GR                               2
#define     V_028714_SPI_SHADER_32_AR                               3
#define     V_028714_SPI_SHADER_FP16_ABGR                           4
#define     V_028714_SPI_SHADER_UNORM16_ABGR                        5
#define     V_028714_SPI_SHADER_SNORM16_ABGR                        6
#define     V_028714_SPI_SHADER_UINT16_ABGR                         7
#define     V_028714_SPI_SHADER_SINT16_ABGR                         8
#define     V_028714_SPI_SHADER_32_ABGR                             9
#define   S_028714_COL1_EXPORT_FORMAT(x)                              (((unsigned)(x) & 0xF) << 4)
#define   G_028714_COL1_EXPORT_FORMAT(x)                              (((x) >> 4) & 0xF)
#define   C_028714_COL1_EXPORT_FORMAT                                 0xFFFFFF0F
#define   S_028714_COL2_EXPORT_FORMAT(x)                              (((unsigned)(x) & 0xF) << 8)
#define   G_028714_COL2_EXPORT_FORMAT(x)                              (((x) >> 8) & 0xF)
#define   C_028714_COL2_EXPORT_FORMAT                                 0xFFFFF0FF
#define   S_028714_COL3_EXPORT_FORMAT(x)                              (((unsigned)(x) & 0xF) << 12)
#define   G_028714_COL3_EXPORT_FORMAT(x)                              (((x) >> 12) & 0xF)
#define   C_028714_COL3_EXPORT_FORMAT                                 0xFFFF0FFF
#define   S_028714_COL4_EXPORT_FORMAT(x)                              (((unsigned)(x) & 0xF) << 16)
#define   G_028714_COL4_EXPORT_FORMAT(x)                              (((x) >> 16) & 0xF)
#define   C_028714_COL4_EXPORT_FORMAT                                 0xFFF0FFFF
#define   S_028714_COL5_EXPORT_FORMAT(x)                              (((unsigned)(x) & 0xF) << 20)
#define   G_028714_COL5_EXPORT_FORMAT(x)                              (((x) >> 20) & 0xF)
#define   C_028714_COL5_EXPORT_FORMAT                                 0xFF0FFFFF
#define   S_028714_COL6_EXPORT_FORMAT(x)                              (((unsigned)(x) & 0xF) << 24)
#define   G_028714_COL6_EXPORT_FORMAT(x)                              (((x) >> 24) & 0xF)
#define   C_028714_COL6_EXPORT_FORMAT                                 0xF0FFFFFF
#define   S_028714_COL7_EXPORT_FORMAT(x)                              (((unsigned)(x) & 0xF) << 28)
#define   G_028714_COL7_EXPORT_FORMAT(x)                              (((x) >> 28) & 0xF)
#define   C_028714_COL7_EXPORT_FORMAT                                 0x0FFFFFFF
#define R_028750_SX_PS_DOWNCONVERT_CONTROL                              0x028750 /* >= gfx103 */
#define   S_028750_MRT0_FMT_MAPPING_DISABLE(x)                        (((unsigned)(x) & 0x1) << 0)
#define   G_028750_MRT0_FMT_MAPPING_DISABLE(x)                        (((x) >> 0) & 0x1)
#define   C_028750_MRT0_FMT_MAPPING_DISABLE                           0xFFFFFFFE
#define   S_028750_MRT1_FMT_MAPPING_DISABLE(x)                        (((unsigned)(x) & 0x1) << 1)
#define   G_028750_MRT1_FMT_MAPPING_DISABLE(x)                        (((x) >> 1) & 0x1)
#define   C_028750_MRT1_FMT_MAPPING_DISABLE                           0xFFFFFFFD
#define   S_028750_MRT2_FMT_MAPPING_DISABLE(x)                        (((unsigned)(x) & 0x1) << 2)
#define   G_028750_MRT2_FMT_MAPPING_DISABLE(x)                        (((x) >> 2) & 0x1)
#define   C_028750_MRT2_FMT_MAPPING_DISABLE                           0xFFFFFFFB
#define   S_028750_MRT3_FMT_MAPPING_DISABLE(x)                        (((unsigned)(x) & 0x1) << 3)
#define   G_028750_MRT3_FMT_MAPPING_DISABLE(x)                        (((x) >> 3) & 0x1)
#define   C_028750_MRT3_FMT_MAPPING_DISABLE                           0xFFFFFFF7
#define   S_028750_MRT4_FMT_MAPPING_DISABLE(x)                        (((unsigned)(x) & 0x1) << 4)
#define   G_028750_MRT4_FMT_MAPPING_DISABLE(x)                        (((x) >> 4) & 0x1)
#define   C_028750_MRT4_FMT_MAPPING_DISABLE                           0xFFFFFFEF
#define   S_028750_MRT5_FMT_MAPPING_DISABLE(x)                        (((unsigned)(x) & 0x1) << 5)
#define   G_028750_MRT5_FMT_MAPPING_DISABLE(x)                        (((x) >> 5) & 0x1)
#define   C_028750_MRT5_FMT_MAPPING_DISABLE                           0xFFFFFFDF
#define   S_028750_MRT6_FMT_MAPPING_DISABLE(x)                        (((unsigned)(x) & 0x1) << 6)
#define   G_028750_MRT6_FMT_MAPPING_DISABLE(x)                        (((x) >> 6) & 0x1)
#define   C_028750_MRT6_FMT_MAPPING_DISABLE                           0xFFFFFFBF
#define   S_028750_MRT7_FMT_MAPPING_DISABLE(x)                        (((unsigned)(x) & 0x1) << 7)
#define   G_028750_MRT7_FMT_MAPPING_DISABLE(x)                        (((x) >> 7) & 0x1)
#define   C_028750_MRT7_FMT_MAPPING_DISABLE                           0xFFFFFF7F
#define R_028754_SX_PS_DOWNCONVERT                                      0x028754 /* >= gfx81 */
#define   S_028754_MRT0(x)                                            (((unsigned)(x) & 0xF) << 0)
#define   G_028754_MRT0(x)                                            (((x) >> 0) & 0xF)
#define   C_028754_MRT0                                               0xFFFFFFF0
#define     V_028754_SX_RT_EXPORT_NO_CONVERSION                     0
#define     V_028754_SX_RT_EXPORT_32_R                              1
#define     V_028754_SX_RT_EXPORT_32_A                              2
#define     V_028754_SX_RT_EXPORT_10_11_11                          3
#define     V_028754_SX_RT_EXPORT_2_10_10_10                        4
#define     V_028754_SX_RT_EXPORT_8_8_8_8                           5
#define     V_028754_SX_RT_EXPORT_5_6_5                             6
#define     V_028754_SX_RT_EXPORT_1_5_5_5                           7
#define     V_028754_SX_RT_EXPORT_4_4_4_4                           8
#define     V_028754_SX_RT_EXPORT_16_16_GR                          9
#define     V_028754_SX_RT_EXPORT_16_16_AR                          10
#define     V_028754_SX_RT_EXPORT_9_9_9_E5                          11 /* >= gfx103 */
#define   S_028754_MRT1(x)                                            (((unsigned)(x) & 0xF) << 4)
#define   G_028754_MRT1(x)                                            (((x) >> 4) & 0xF)
#define   C_028754_MRT1                                               0xFFFFFF0F
#define   S_028754_MRT2(x)                                            (((unsigned)(x) & 0xF) << 8)
#define   G_028754_MRT2(x)                                            (((x) >> 8) & 0xF)
#define   C_028754_MRT2                                               0xFFFFF0FF
#define   S_028754_MRT3(x)                                            (((unsigned)(x) & 0xF) << 12)
#define   G_028754_MRT3(x)                                            (((x) >> 12) & 0xF)
#define   C_028754_MRT3                                               0xFFFF0FFF
#define   S_028754_MRT4(x)                                            (((unsigned)(x) & 0xF) << 16)
#define   G_028754_MRT4(x)                                            (((x) >> 16) & 0xF)
#define   C_028754_MRT4                                               0xFFF0FFFF
#define   S_028754_MRT5(x)                                            (((unsigned)(x) & 0xF) << 20)
#define   G_028754_MRT5(x)                                            (((x) >> 20) & 0xF)
#define   C_028754_MRT5                                               0xFF0FFFFF
#define   S_028754_MRT6(x)                                            (((unsigned)(x) & 0xF) << 24)
#define   G_028754_MRT6(x)                                            (((x) >> 24) & 0xF)
#define   C_028754_MRT6                                               0xF0FFFFFF
#define   S_028754_MRT7(x)                                            (((unsigned)(x) & 0xF) << 28)
#define   G_028754_MRT7(x)                                            (((x) >> 28) & 0xF)
#define   C_028754_MRT7                                               0x0FFFFFFF
#define R_028758_SX_BLEND_OPT_EPSILON                                   0x028758 /* >= gfx81 */
#define   S_028758_MRT0_EPSILON(x)                                    (((unsigned)(x) & 0xF) << 0)
#define   G_028758_MRT0_EPSILON(x)                                    (((x) >> 0) & 0xF)
#define   C_028758_MRT0_EPSILON                                       0xFFFFFFF0
#define     V_028758_EXACT                                          0
#define     V_028758_11BIT_FORMAT                                   1
#define     V_028758_10BIT_FORMAT                                   3
#define     V_028758_8BIT_FORMAT                                    6
#define     V_028758_6BIT_FORMAT                                    11
#define     V_028758_5BIT_FORMAT                                    13
#define     V_028758_4BIT_FORMAT                                    15
#define   S_028758_MRT1_EPSILON(x)                                    (((unsigned)(x) & 0xF) << 4)
#define   G_028758_MRT1_EPSILON(x)                                    (((x) >> 4) & 0xF)
#define   C_028758_MRT1_EPSILON                                       0xFFFFFF0F
#define   S_028758_MRT2_EPSILON(x)                                    (((unsigned)(x) & 0xF) << 8)
#define   G_028758_MRT2_EPSILON(x)                                    (((x) >> 8) & 0xF)
#define   C_028758_MRT2_EPSILON                                       0xFFFFF0FF
#define   S_028758_MRT3_EPSILON(x)                                    (((unsigned)(x) & 0xF) << 12)
#define   G_028758_MRT3_EPSILON(x)                                    (((x) >> 12) & 0xF)
#define   C_028758_MRT3_EPSILON                                       0xFFFF0FFF
#define   S_028758_MRT4_EPSILON(x)                                    (((unsigned)(x) & 0xF) << 16)
#define   G_028758_MRT4_EPSILON(x)                                    (((x) >> 16) & 0xF)
#define   C_028758_MRT4_EPSILON                                       0xFFF0FFFF
#define   S_028758_MRT5_EPSILON(x)                                    (((unsigned)(x) & 0xF) << 20)
#define   G_028758_MRT5_EPSILON(x)                                    (((x) >> 20) & 0xF)
#define   C_028758_MRT5_EPSILON                                       0xFF0FFFFF
#define   S_028758_MRT6_EPSILON(x)                                    (((unsigned)(x) & 0xF) << 24)
#define   G_028758_MRT6_EPSILON(x)                                    (((x) >> 24) & 0xF)
#define   C_028758_MRT6_EPSILON                                       0xF0FFFFFF
#define   S_028758_MRT7_EPSILON(x)                                    (((unsigned)(x) & 0xF) << 28)
#define   G_028758_MRT7_EPSILON(x)                                    (((x) >> 28) & 0xF)
#define   C_028758_MRT7_EPSILON                                       0x0FFFFFFF
#define R_02875C_SX_BLEND_OPT_CONTROL                                   0x02875C /* >= gfx81 */
#define   S_02875C_MRT0_COLOR_OPT_DISABLE(x)                          (((unsigned)(x) & 0x1) << 0)
#define   G_02875C_MRT0_COLOR_OPT_DISABLE(x)                          (((x) >> 0) & 0x1)
#define   C_02875C_MRT0_COLOR_OPT_DISABLE                             0xFFFFFFFE
#define   S_02875C_MRT0_ALPHA_OPT_DISABLE(x)                          (((unsigned)(x) & 0x1) << 1)
#define   G_02875C_MRT0_ALPHA_OPT_DISABLE(x)                          (((x) >> 1) & 0x1)
#define   C_02875C_MRT0_ALPHA_OPT_DISABLE                             0xFFFFFFFD
#define   S_02875C_MRT1_COLOR_OPT_DISABLE(x)                          (((unsigned)(x) & 0x1) << 4)
#define   G_02875C_MRT1_COLOR_OPT_DISABLE(x)                          (((x) >> 4) & 0x1)
#define   C_02875C_MRT1_COLOR_OPT_DISABLE                             0xFFFFFFEF
#define   S_02875C_MRT1_ALPHA_OPT_DISABLE(x)                          (((unsigned)(x) & 0x1) << 5)
#define   G_02875C_MRT1_ALPHA_OPT_DISABLE(x)                          (((x) >> 5) & 0x1)
#define   C_02875C_MRT1_ALPHA_OPT_DISABLE                             0xFFFFFFDF
#define   S_02875C_MRT2_COLOR_OPT_DISABLE(x)                          (((unsigned)(x) & 0x1) << 8)
#define   G_02875C_MRT2_COLOR_OPT_DISABLE(x)                          (((x) >> 8) & 0x1)
#define   C_02875C_MRT2_COLOR_OPT_DISABLE                             0xFFFFFEFF
#define   S_02875C_MRT2_ALPHA_OPT_DISABLE(x)                          (((unsigned)(x) & 0x1) << 9)
#define   G_02875C_MRT2_ALPHA_OPT_DISABLE(x)                          (((x) >> 9) & 0x1)
#define   C_02875C_MRT2_ALPHA_OPT_DISABLE                             0xFFFFFDFF
#define   S_02875C_MRT3_COLOR_OPT_DISABLE(x)                          (((unsigned)(x) & 0x1) << 12)
#define   G_02875C_MRT3_COLOR_OPT_DISABLE(x)                          (((x) >> 12) & 0x1)
#define   C_02875C_MRT3_COLOR_OPT_DISABLE                             0xFFFFEFFF
#define   S_02875C_MRT3_ALPHA_OPT_DISABLE(x)                          (((unsigned)(x) & 0x1) << 13)
#define   G_02875C_MRT3_ALPHA_OPT_DISABLE(x)                          (((x) >> 13) & 0x1)
#define   C_02875C_MRT3_ALPHA_OPT_DISABLE                             0xFFFFDFFF
#define   S_02875C_MRT4_COLOR_OPT_DISABLE(x)                          (((unsigned)(x) & 0x1) << 16)
#define   G_02875C_MRT4_COLOR_OPT_DISABLE(x)                          (((x) >> 16) & 0x1)
#define   C_02875C_MRT4_COLOR_OPT_DISABLE                             0xFFFEFFFF
#define   S_02875C_MRT4_ALPHA_OPT_DISABLE(x)                          (((unsigned)(x) & 0x1) << 17)
#define   G_02875C_MRT4_ALPHA_OPT_DISABLE(x)                          (((x) >> 17) & 0x1)
#define   C_02875C_MRT4_ALPHA_OPT_DISABLE                             0xFFFDFFFF
#define   S_02875C_MRT5_COLOR_OPT_DISABLE(x)                          (((unsigned)(x) & 0x1) << 20)
#define   G_02875C_MRT5_COLOR_OPT_DISABLE(x)                          (((x) >> 20) & 0x1)
#define   C_02875C_MRT5_COLOR_OPT_DISABLE                             0xFFEFFFFF
#define   S_02875C_MRT5_ALPHA_OPT_DISABLE(x)                          (((unsigned)(x) & 0x1) << 21)
#define   G_02875C_MRT5_ALPHA_OPT_DISABLE(x)                          (((x) >> 21) & 0x1)
#define   C_02875C_MRT5_ALPHA_OPT_DISABLE                             0xFFDFFFFF
#define   S_02875C_MRT6_COLOR_OPT_DISABLE(x)                          (((unsigned)(x) & 0x1) << 24)
#define   G_02875C_MRT6_COLOR_OPT_DISABLE(x)                          (((x) >> 24) & 0x1)
#define   C_02875C_MRT6_COLOR_OPT_DISABLE                             0xFEFFFFFF
#define   S_02875C_MRT6_ALPHA_OPT_DISABLE(x)                          (((unsigned)(x) & 0x1) << 25)
#define   G_02875C_MRT6_ALPHA_OPT_DISABLE(x)                          (((x) >> 25) & 0x1)
#define   C_02875C_MRT6_ALPHA_OPT_DISABLE                             0xFDFFFFFF
#define   S_02875C_MRT7_COLOR_OPT_DISABLE(x)                          (((unsigned)(x) & 0x1) << 28)
#define   G_02875C_MRT7_COLOR_OPT_DISABLE(x)                          (((x) >> 28) & 0x1)
#define   C_02875C_MRT7_COLOR_OPT_DISABLE                             0xEFFFFFFF
#define   S_02875C_MRT7_ALPHA_OPT_DISABLE(x)                          (((unsigned)(x) & 0x1) << 29)
#define   G_02875C_MRT7_ALPHA_OPT_DISABLE(x)                          (((x) >> 29) & 0x1)
#define   C_02875C_MRT7_ALPHA_OPT_DISABLE                             0xDFFFFFFF
#define   S_02875C_PIXEN_ZERO_OPT_DISABLE(x)                          (((unsigned)(x) & 0x1) << 31)
#define   G_02875C_PIXEN_ZERO_OPT_DISABLE(x)                          (((x) >> 31) & 0x1)
#define   C_02875C_PIXEN_ZERO_OPT_DISABLE                             0x7FFFFFFF
#define R_028760_SX_MRT0_BLEND_OPT                                      0x028760 /* >= gfx81 */
#define   S_028760_COLOR_SRC_OPT(x)                                   (((unsigned)(x) & 0x7) << 0)
#define   G_028760_COLOR_SRC_OPT(x)                                   (((x) >> 0) & 0x7)
#define   C_028760_COLOR_SRC_OPT                                      0xFFFFFFF8
#define     V_028760_BLEND_OPT_PRESERVE_NONE_IGNORE_ALL             0
#define     V_028760_BLEND_OPT_PRESERVE_ALL_IGNORE_NONE             1
#define     V_028760_BLEND_OPT_PRESERVE_C1_IGNORE_C0                2
#define     V_028760_BLEND_OPT_PRESERVE_C0_IGNORE_C1                3
#define     V_028760_BLEND_OPT_PRESERVE_A1_IGNORE_A0                4
#define     V_028760_BLEND_OPT_PRESERVE_A0_IGNORE_A1                5
#define     V_028760_BLEND_OPT_PRESERVE_NONE_IGNORE_A0              6
#define     V_028760_BLEND_OPT_PRESERVE_NONE_IGNORE_NONE            7
#define   S_028760_COLOR_DST_OPT(x)                                   (((unsigned)(x) & 0x7) << 4)
#define   G_028760_COLOR_DST_OPT(x)                                   (((x) >> 4) & 0x7)
#define   C_028760_COLOR_DST_OPT                                      0xFFFFFF8F
#define   S_028760_COLOR_COMB_FCN(x)                                  (((unsigned)(x) & 0x7) << 8)
#define   G_028760_COLOR_COMB_FCN(x)                                  (((x) >> 8) & 0x7)
#define   C_028760_COLOR_COMB_FCN                                     0xFFFFF8FF
#define     V_028760_OPT_COMB_NONE                                  0
#define     V_028760_OPT_COMB_ADD                                   1
#define     V_028760_OPT_COMB_SUBTRACT                              2
#define     V_028760_OPT_COMB_MIN                                   3
#define     V_028760_OPT_COMB_MAX                                   4
#define     V_028760_OPT_COMB_REVSUBTRACT                           5
#define     V_028760_OPT_COMB_BLEND_DISABLED                        6
#define     V_028760_OPT_COMB_SAFE_ADD                              7
#define   S_028760_ALPHA_SRC_OPT(x)                                   (((unsigned)(x) & 0x7) << 16)
#define   G_028760_ALPHA_SRC_OPT(x)                                   (((x) >> 16) & 0x7)
#define   C_028760_ALPHA_SRC_OPT                                      0xFFF8FFFF
#define   S_028760_ALPHA_DST_OPT(x)                                   (((unsigned)(x) & 0x7) << 20)
#define   G_028760_ALPHA_DST_OPT(x)                                   (((x) >> 20) & 0x7)
#define   C_028760_ALPHA_DST_OPT                                      0xFF8FFFFF
#define   S_028760_ALPHA_COMB_FCN(x)                                  (((unsigned)(x) & 0x7) << 24)
#define   G_028760_ALPHA_COMB_FCN(x)                                  (((x) >> 24) & 0x7)
#define   C_028760_ALPHA_COMB_FCN                                     0xF8FFFFFF
#define R_028764_SX_MRT1_BLEND_OPT                                      0x028764 /* >= gfx81 */
#define R_028768_SX_MRT2_BLEND_OPT                                      0x028768 /* >= gfx81 */
#define R_02876C_SX_MRT3_BLEND_OPT                                      0x02876C /* >= gfx81 */
#define R_028770_SX_MRT4_BLEND_OPT                                      0x028770 /* >= gfx81 */
#define R_028774_SX_MRT5_BLEND_OPT                                      0x028774 /* >= gfx81 */
#define R_028778_SX_MRT6_BLEND_OPT                                      0x028778 /* >= gfx81 */
#define R_02877C_SX_MRT7_BLEND_OPT                                      0x02877C /* >= gfx81 */
#define R_028780_CB_BLEND0_CONTROL                                      0x028780
#define   S_028780_COLOR_SRCBLEND(x)                                  (((unsigned)(x) & 0x1F) << 0)
#define   G_028780_COLOR_SRCBLEND(x)                                  (((x) >> 0) & 0x1F)
#define   C_028780_COLOR_SRCBLEND                                     0xFFFFFFE0
#define     V_028780_BLEND_ZERO                                     0
#define     V_028780_BLEND_ONE                                      1
#define     V_028780_BLEND_SRC_COLOR                                2
#define     V_028780_BLEND_ONE_MINUS_SRC_COLOR                      3
#define     V_028780_BLEND_SRC_ALPHA                                4
#define     V_028780_BLEND_ONE_MINUS_SRC_ALPHA                      5
#define     V_028780_BLEND_DST_ALPHA                                6
#define     V_028780_BLEND_ONE_MINUS_DST_ALPHA                      7
#define     V_028780_BLEND_DST_COLOR                                8
#define     V_028780_BLEND_ONE_MINUS_DST_COLOR                      9
#define     V_028780_BLEND_SRC_ALPHA_SATURATE                       10
#define     V_028780_BLEND_BOTH_SRC_ALPHA                           11
#define     V_028780_BLEND_BOTH_INV_SRC_ALPHA                       12
#define     V_028780_BLEND_CONSTANT_COLOR                           13
#define     V_028780_BLEND_ONE_MINUS_CONSTANT_COLOR                 14
#define     V_028780_BLEND_SRC1_COLOR                               15
#define     V_028780_BLEND_INV_SRC1_COLOR                           16
#define     V_028780_BLEND_SRC1_ALPHA                               17
#define     V_028780_BLEND_INV_SRC1_ALPHA                           18
#define     V_028780_BLEND_CONSTANT_ALPHA                           19
#define     V_028780_BLEND_ONE_MINUS_CONSTANT_ALPHA                 20
#define   S_028780_COLOR_COMB_FCN(x)                                  (((unsigned)(x) & 0x7) << 5)
#define   G_028780_COLOR_COMB_FCN(x)                                  (((x) >> 5) & 0x7)
#define   C_028780_COLOR_COMB_FCN                                     0xFFFFFF1F
#define     V_028780_COMB_DST_PLUS_SRC                              0
#define     V_028780_COMB_SRC_MINUS_DST                             1
#define     V_028780_COMB_MIN_DST_SRC                               2
#define     V_028780_COMB_MAX_DST_SRC                               3
#define     V_028780_COMB_DST_MINUS_SRC                             4
#define   S_028780_COLOR_DESTBLEND(x)                                 (((unsigned)(x) & 0x1F) << 8)
#define   G_028780_COLOR_DESTBLEND(x)                                 (((x) >> 8) & 0x1F)
#define   C_028780_COLOR_DESTBLEND                                    0xFFFFE0FF
#define   S_028780_ALPHA_SRCBLEND(x)                                  (((unsigned)(x) & 0x1F) << 16)
#define   G_028780_ALPHA_SRCBLEND(x)                                  (((x) >> 16) & 0x1F)
#define   C_028780_ALPHA_SRCBLEND                                     0xFFE0FFFF
#define   S_028780_ALPHA_COMB_FCN(x)                                  (((unsigned)(x) & 0x7) << 21)
#define   G_028780_ALPHA_COMB_FCN(x)                                  (((x) >> 21) & 0x7)
#define   C_028780_ALPHA_COMB_FCN                                     0xFF1FFFFF
#define   S_028780_ALPHA_DESTBLEND(x)                                 (((unsigned)(x) & 0x1F) << 24)
#define   G_028780_ALPHA_DESTBLEND(x)                                 (((x) >> 24) & 0x1F)
#define   C_028780_ALPHA_DESTBLEND                                    0xE0FFFFFF
#define   S_028780_SEPARATE_ALPHA_BLEND(x)                            (((unsigned)(x) & 0x1) << 29)
#define   G_028780_SEPARATE_ALPHA_BLEND(x)                            (((x) >> 29) & 0x1)
#define   C_028780_SEPARATE_ALPHA_BLEND                               0xDFFFFFFF
#define   S_028780_ENABLE(x)                                          (((unsigned)(x) & 0x1) << 30)
#define   G_028780_ENABLE(x)                                          (((x) >> 30) & 0x1)
#define   C_028780_ENABLE                                             0xBFFFFFFF
#define   S_028780_DISABLE_ROP3(x)                                    (((unsigned)(x) & 0x1) << 31)
#define   G_028780_DISABLE_ROP3(x)                                    (((x) >> 31) & 0x1)
#define   C_028780_DISABLE_ROP3                                       0x7FFFFFFF
#define R_028784_CB_BLEND1_CONTROL                                      0x028784
#define R_028788_CB_BLEND2_CONTROL                                      0x028788
#define R_02878C_CB_BLEND3_CONTROL                                      0x02878C
#define R_028790_CB_BLEND4_CONTROL                                      0x028790
#define R_028794_CB_BLEND5_CONTROL                                      0x028794
#define R_028798_CB_BLEND6_CONTROL                                      0x028798
#define R_02879C_CB_BLEND7_CONTROL                                      0x02879C
#define R_0287A0_CB_MRT0_EPITCH                                         0x0287A0 /* gfx9 */
#define   S_0287A0_EPITCH(x)                                          (((unsigned)(x) & 0xFFFF) << 0)
#define   G_0287A0_EPITCH(x)                                          (((x) >> 0) & 0xFFFF)
#define   C_0287A0_EPITCH                                             0xFFFF0000
#define R_0287A4_CB_MRT1_EPITCH                                         0x0287A4 /* gfx9 */
#define R_0287A8_CB_MRT2_EPITCH                                         0x0287A8 /* gfx9 */
#define R_0287AC_CB_MRT3_EPITCH                                         0x0287AC /* gfx9 */
#define R_0287B0_CB_MRT4_EPITCH                                         0x0287B0 /* gfx9 */
#define R_0287B4_CB_MRT5_EPITCH                                         0x0287B4 /* gfx9 */
#define R_0287B8_CB_MRT6_EPITCH                                         0x0287B8 /* gfx9 */
#define R_0287BC_CB_MRT7_EPITCH                                         0x0287BC /* gfx9 */
#define R_0287CC_CS_COPY_STATE                                          0x0287CC
#define   S_0287CC_SRC_STATE_ID(x)                                    (((unsigned)(x) & 0x7) << 0)
#define   G_0287CC_SRC_STATE_ID(x)                                    (((x) >> 0) & 0x7)
#define   C_0287CC_SRC_STATE_ID                                       0xFFFFFFF8
#define R_0287D0_GFX_COPY_STATE                                         0x0287D0
#define   S_0287D0_SRC_STATE_ID(x)                                    (((unsigned)(x) & 0x7) << 0)
#define   G_0287D0_SRC_STATE_ID(x)                                    (((x) >> 0) & 0x7)
#define   C_0287D0_SRC_STATE_ID                                       0xFFFFFFF8
#define R_0287D4_PA_CL_POINT_X_RAD                                      0x0287D4
#define R_0287D8_PA_CL_POINT_Y_RAD                                      0x0287D8
#define R_0287DC_PA_CL_POINT_SIZE                                       0x0287DC
#define R_0287E0_PA_CL_POINT_CULL_RAD                                   0x0287E0
#define R_0287E4_VGT_DMA_BASE_HI                                        0x0287E4
#define   S_0287E4_BASE_ADDR(x)                                       (((unsigned)(x) & 0xFFFF) << 0)
#define   G_0287E4_BASE_ADDR(x)                                       (((x) >> 0) & 0xFFFF)
#define   C_0287E4_BASE_ADDR                                          0xFFFF0000
#define R_0287E8_VGT_DMA_BASE                                           0x0287E8
#define R_0287F0_VGT_DRAW_INITIATOR                                     0x0287F0
#define   S_0287F0_SOURCE_SELECT(x)                                   (((unsigned)(x) & 0x3) << 0)
#define   G_0287F0_SOURCE_SELECT(x)                                   (((x) >> 0) & 0x3)
#define   C_0287F0_SOURCE_SELECT                                      0xFFFFFFFC
#define     V_0287F0_DI_SRC_SEL_DMA                                 0
#define     V_0287F0_DI_SRC_SEL_IMMEDIATE                           1
#define     V_0287F0_DI_SRC_SEL_AUTO_INDEX                          2
#define     V_0287F0_DI_SRC_SEL_RESERVED                            3
#define   S_0287F0_MAJOR_MODE(x)                                      (((unsigned)(x) & 0x3) << 2)
#define   G_0287F0_MAJOR_MODE(x)                                      (((x) >> 2) & 0x3)
#define   C_0287F0_MAJOR_MODE                                         0xFFFFFFF3
#define     V_0287F0_DI_MAJOR_MODE_0                                0
#define     V_0287F0_DI_MAJOR_MODE_1                                1
#define   S_0287F0_SPRITE_EN_R6XX(x)                                  (((unsigned)(x) & 0x1) << 4)
#define   G_0287F0_SPRITE_EN_R6XX(x)                                  (((x) >> 4) & 0x1)
#define   C_0287F0_SPRITE_EN_R6XX                                     0xFFFFFFEF
#define   S_0287F0_NOT_EOP(x)                                         (((unsigned)(x) & 0x1) << 5)
#define   G_0287F0_NOT_EOP(x)                                         (((x) >> 5) & 0x1)
#define   C_0287F0_NOT_EOP                                            0xFFFFFFDF
#define   S_0287F0_USE_OPAQUE(x)                                      (((unsigned)(x) & 0x1) << 6)
#define   G_0287F0_USE_OPAQUE(x)                                      (((x) >> 6) & 0x1)
#define   C_0287F0_USE_OPAQUE                                         0xFFFFFFBF
#define   S_0287F0_UNROLLED_INST(x)                                   (((unsigned)(x) & 0x1) << 7) /* gfx9, gfx10 */
#define   G_0287F0_UNROLLED_INST(x)                                   (((x) >> 7) & 0x1)
#define   C_0287F0_UNROLLED_INST                                      0xFFFFFF7F
#define   S_0287F0_GRBM_SKEW_NO_DEC(x)                                (((unsigned)(x) & 0x1) << 8) /* gfx9, gfx10 */
#define   G_0287F0_GRBM_SKEW_NO_DEC(x)                                (((x) >> 8) & 0x1)
#define   C_0287F0_GRBM_SKEW_NO_DEC                                   0xFFFFFEFF
#define   S_0287F0_REG_RT_INDEX(x)                                    (((unsigned)(x) & 0x7) << 29) /* >= gfx9 */
#define   G_0287F0_REG_RT_INDEX(x)                                    (((x) >> 29) & 0x7)
#define   C_0287F0_REG_RT_INDEX                                       0x1FFFFFFF
#define R_0287F4_VGT_IMMED_DATA                                         0x0287F4
#define R_0287F8_VGT_EVENT_ADDRESS_REG                                  0x0287F8
#define   S_0287F8_ADDRESS_LOW(x)                                     (((unsigned)(x) & 0xFFFFFFF) << 0)
#define   G_0287F8_ADDRESS_LOW(x)                                     (((x) >> 0) & 0xFFFFFFF)
#define   C_0287F8_ADDRESS_LOW                                        0xF0000000
#define R_0287FC_GE_MAX_OUTPUT_PER_SUBGROUP                             0x0287FC /* >= gfx10 */
#define   S_0287FC_MAX_VERTS_PER_SUBGROUP(x)                          (((unsigned)(x) & 0x3FF) << 0)
#define   G_0287FC_MAX_VERTS_PER_SUBGROUP(x)                          (((x) >> 0) & 0x3FF)
#define   C_0287FC_MAX_VERTS_PER_SUBGROUP                             0xFFFFFC00
#define R_028800_DB_DEPTH_CONTROL                                       0x028800
#define   S_028800_STENCIL_ENABLE(x)                                  (((unsigned)(x) & 0x1) << 0)
#define   G_028800_STENCIL_ENABLE(x)                                  (((x) >> 0) & 0x1)
#define   C_028800_STENCIL_ENABLE                                     0xFFFFFFFE
#define   S_028800_Z_ENABLE(x)                                        (((unsigned)(x) & 0x1) << 1)
#define   G_028800_Z_ENABLE(x)                                        (((x) >> 1) & 0x1)
#define   C_028800_Z_ENABLE                                           0xFFFFFFFD
#define   S_028800_Z_WRITE_ENABLE(x)                                  (((unsigned)(x) & 0x1) << 2)
#define   G_028800_Z_WRITE_ENABLE(x)                                  (((x) >> 2) & 0x1)
#define   C_028800_Z_WRITE_ENABLE                                     0xFFFFFFFB
#define   S_028800_DEPTH_BOUNDS_ENABLE(x)                             (((unsigned)(x) & 0x1) << 3)
#define   G_028800_DEPTH_BOUNDS_ENABLE(x)                             (((x) >> 3) & 0x1)
#define   C_028800_DEPTH_BOUNDS_ENABLE                                0xFFFFFFF7
#define   S_028800_ZFUNC(x)                                           (((unsigned)(x) & 0x7) << 4)
#define   G_028800_ZFUNC(x)                                           (((x) >> 4) & 0x7)
#define   C_028800_ZFUNC                                              0xFFFFFF8F
#define     V_028800_FRAG_NEVER                                     0
#define     V_028800_FRAG_LESS                                      1
#define     V_028800_FRAG_EQUAL                                     2
#define     V_028800_FRAG_LEQUAL                                    3
#define     V_028800_FRAG_GREATER                                   4
#define     V_028800_FRAG_NOTEQUAL                                  5
#define     V_028800_FRAG_GEQUAL                                    6
#define     V_028800_FRAG_ALWAYS                                    7
#define   S_028800_BACKFACE_ENABLE(x)                                 (((unsigned)(x) & 0x1) << 7)
#define   G_028800_BACKFACE_ENABLE(x)                                 (((x) >> 7) & 0x1)
#define   C_028800_BACKFACE_ENABLE                                    0xFFFFFF7F
#define   S_028800_STENCILFUNC(x)                                     (((unsigned)(x) & 0x7) << 8)
#define   G_028800_STENCILFUNC(x)                                     (((x) >> 8) & 0x7)
#define   C_028800_STENCILFUNC                                        0xFFFFF8FF
#define   S_028800_STENCILFUNC_BF(x)                                  (((unsigned)(x) & 0x7) << 20)
#define   G_028800_STENCILFUNC_BF(x)                                  (((x) >> 20) & 0x7)
#define   C_028800_STENCILFUNC_BF                                     0xFF8FFFFF
#define   S_028800_ENABLE_COLOR_WRITES_ON_DEPTH_FAIL(x)               (((unsigned)(x) & 0x1) << 30)
#define   G_028800_ENABLE_COLOR_WRITES_ON_DEPTH_FAIL(x)               (((x) >> 30) & 0x1)
#define   C_028800_ENABLE_COLOR_WRITES_ON_DEPTH_FAIL                  0xBFFFFFFF
#define   S_028800_DISABLE_COLOR_WRITES_ON_DEPTH_PASS(x)              (((unsigned)(x) & 0x1) << 31)
#define   G_028800_DISABLE_COLOR_WRITES_ON_DEPTH_PASS(x)              (((x) >> 31) & 0x1)
#define   C_028800_DISABLE_COLOR_WRITES_ON_DEPTH_PASS                 0x7FFFFFFF
#define R_028804_DB_EQAA                                                0x028804
#define   S_028804_MAX_ANCHOR_SAMPLES(x)                              (((unsigned)(x) & 0x7) << 0)
#define   G_028804_MAX_ANCHOR_SAMPLES(x)                              (((x) >> 0) & 0x7)
#define   C_028804_MAX_ANCHOR_SAMPLES                                 0xFFFFFFF8
#define   S_028804_PS_ITER_SAMPLES(x)                                 (((unsigned)(x) & 0x7) << 4)
#define   G_028804_PS_ITER_SAMPLES(x)                                 (((x) >> 4) & 0x7)
#define   C_028804_PS_ITER_SAMPLES                                    0xFFFFFF8F
#define   S_028804_MASK_EXPORT_NUM_SAMPLES(x)                         (((unsigned)(x) & 0x7) << 8)
#define   G_028804_MASK_EXPORT_NUM_SAMPLES(x)                         (((x) >> 8) & 0x7)
#define   C_028804_MASK_EXPORT_NUM_SAMPLES                            0xFFFFF8FF
#define   S_028804_ALPHA_TO_MASK_NUM_SAMPLES(x)                       (((unsigned)(x) & 0x7) << 12)
#define   G_028804_ALPHA_TO_MASK_NUM_SAMPLES(x)                       (((x) >> 12) & 0x7)
#define   C_028804_ALPHA_TO_MASK_NUM_SAMPLES                          0xFFFF8FFF
#define   S_028804_HIGH_QUALITY_INTERSECTIONS(x)                      (((unsigned)(x) & 0x1) << 16)
#define   G_028804_HIGH_QUALITY_INTERSECTIONS(x)                      (((x) >> 16) & 0x1)
#define   C_028804_HIGH_QUALITY_INTERSECTIONS                         0xFFFEFFFF
#define   S_028804_INCOHERENT_EQAA_READS(x)                           (((unsigned)(x) & 0x1) << 17)
#define   G_028804_INCOHERENT_EQAA_READS(x)                           (((x) >> 17) & 0x1)
#define   C_028804_INCOHERENT_EQAA_READS                              0xFFFDFFFF
#define   S_028804_INTERPOLATE_COMP_Z(x)                              (((unsigned)(x) & 0x1) << 18)
#define   G_028804_INTERPOLATE_COMP_Z(x)                              (((x) >> 18) & 0x1)
#define   C_028804_INTERPOLATE_COMP_Z                                 0xFFFBFFFF
#define   S_028804_INTERPOLATE_SRC_Z(x)                               (((unsigned)(x) & 0x1) << 19)
#define   G_028804_INTERPOLATE_SRC_Z(x)                               (((x) >> 19) & 0x1)
#define   C_028804_INTERPOLATE_SRC_Z                                  0xFFF7FFFF
#define   S_028804_STATIC_ANCHOR_ASSOCIATIONS(x)                      (((unsigned)(x) & 0x1) << 20)
#define   G_028804_STATIC_ANCHOR_ASSOCIATIONS(x)                      (((x) >> 20) & 0x1)
#define   C_028804_STATIC_ANCHOR_ASSOCIATIONS                         0xFFEFFFFF
#define   S_028804_ALPHA_TO_MASK_EQAA_DISABLE(x)                      (((unsigned)(x) & 0x1) << 21)
#define   G_028804_ALPHA_TO_MASK_EQAA_DISABLE(x)                      (((x) >> 21) & 0x1)
#define   C_028804_ALPHA_TO_MASK_EQAA_DISABLE                         0xFFDFFFFF
#define   S_028804_OVERRASTERIZATION_AMOUNT(x)                        (((unsigned)(x) & 0x7) << 24)
#define   G_028804_OVERRASTERIZATION_AMOUNT(x)                        (((x) >> 24) & 0x7)
#define   C_028804_OVERRASTERIZATION_AMOUNT                           0xF8FFFFFF
#define   S_028804_ENABLE_POSTZ_OVERRASTERIZATION(x)                  (((unsigned)(x) & 0x1) << 27)
#define   G_028804_ENABLE_POSTZ_OVERRASTERIZATION(x)                  (((x) >> 27) & 0x1)
#define   C_028804_ENABLE_POSTZ_OVERRASTERIZATION                     0xF7FFFFFF
#define R_028808_CB_COLOR_CONTROL                                       0x028808
#define   S_028808_DISABLE_DUAL_QUAD(x)                               (((unsigned)(x) & 0x1) << 0) /* >= gfx81 */
#define   G_028808_DISABLE_DUAL_QUAD(x)                               (((x) >> 0) & 0x1)
#define   C_028808_DISABLE_DUAL_QUAD                                  0xFFFFFFFE
#define   S_028808_ENABLE_1FRAG_PS_INVOKE(x)                          (((unsigned)(x) & 0x1) << 1) /* >= gfx103 */
#define   G_028808_ENABLE_1FRAG_PS_INVOKE(x)                          (((x) >> 1) & 0x1)
#define   C_028808_ENABLE_1FRAG_PS_INVOKE                             0xFFFFFFFD
#define   S_028808_DEGAMMA_ENABLE(x)                                  (((unsigned)(x) & 0x1) << 3)
#define   G_028808_DEGAMMA_ENABLE(x)                                  (((x) >> 3) & 0x1)
#define   C_028808_DEGAMMA_ENABLE                                     0xFFFFFFF7
#define   S_028808_MODE(x)                                            (((unsigned)(x) & 0x7) << 4)
#define   G_028808_MODE(x)                                            (((x) >> 4) & 0x7)
#define   C_028808_MODE                                               0xFFFFFF8F
#define     V_028808_CB_DISABLE                                     0
#define     V_028808_CB_NORMAL                                      1
#define     V_028808_CB_ELIMINATE_FAST_CLEAR                        2
#define     V_028808_CB_RESOLVE                                     3
#define     V_028808_CB_DECOMPRESS                                  4
#define     V_028808_CB_FMASK_DECOMPRESS                            5
#define     V_028808_CB_DCC_DECOMPRESS                              6 /* >= gfx8 */
#define     V_028808_CB_RESERVED                                    7 /* >= gfx10 */
#define   S_028808_ROP3(x)                                            (((unsigned)(x) & 0xFF) << 16)
#define   G_028808_ROP3(x)                                            (((x) >> 16) & 0xFF)
#define   C_028808_ROP3                                               0xFF00FFFF
#define     V_028808_ROP3_CLEAR                                     0
#define     V_028808_X_0X05                                         5
#define     V_028808_X_0X0A                                         10
#define     V_028808_X_0X0F                                         15
#define     V_028808_ROP3_NOR                                       17
#define     V_028808_ROP3_AND_INVERTED                              34
#define     V_028808_ROP3_COPY_INVERTED                             51
#define     V_028808_ROP3_AND_REVERSE                               68
#define     V_028808_X_0X50                                         80
#define     V_028808_ROP3_INVERT                                    85
#define     V_028808_X_0X5A                                         90
#define     V_028808_X_0X5F                                         95
#define     V_028808_ROP3_XOR                                       102
#define     V_028808_ROP3_NAND                                      119
#define     V_028808_ROP3_AND                                       136
#define     V_028808_ROP3_EQUIVALENT                                153
#define     V_028808_X_0XA0                                         160
#define     V_028808_X_0XA5                                         165
#define     V_028808_ROP3_NO_OP                                     170
#define     V_028808_X_0XAF                                         175
#define     V_028808_ROP3_OR_INVERTED                               187
#define     V_028808_ROP3_COPY                                      204
#define     V_028808_ROP3_OR_REVERSE                                221
#define     V_028808_ROP3_OR                                        238
#define     V_028808_X_0XF0                                         240
#define     V_028808_X_0XF5                                         245
#define     V_028808_X_0XFA                                         250
#define     V_028808_ROP3_SET                                       255
#define R_02880C_DB_SHADER_CONTROL                                      0x02880C
#define   S_02880C_Z_EXPORT_ENABLE(x)                                 (((unsigned)(x) & 0x1) << 0)
#define   G_02880C_Z_EXPORT_ENABLE(x)                                 (((x) >> 0) & 0x1)
#define   C_02880C_Z_EXPORT_ENABLE                                    0xFFFFFFFE
#define   S_02880C_STENCIL_TEST_VAL_EXPORT_ENABLE(x)                  (((unsigned)(x) & 0x1) << 1)
#define   G_02880C_STENCIL_TEST_VAL_EXPORT_ENABLE(x)                  (((x) >> 1) & 0x1)
#define   C_02880C_STENCIL_TEST_VAL_EXPORT_ENABLE                     0xFFFFFFFD
#define   S_02880C_STENCIL_OP_VAL_EXPORT_ENABLE(x)                    (((unsigned)(x) & 0x1) << 2)
#define   G_02880C_STENCIL_OP_VAL_EXPORT_ENABLE(x)                    (((x) >> 2) & 0x1)
#define   C_02880C_STENCIL_OP_VAL_EXPORT_ENABLE                       0xFFFFFFFB
#define   S_02880C_Z_ORDER(x)                                         (((unsigned)(x) & 0x3) << 4)
#define   G_02880C_Z_ORDER(x)                                         (((x) >> 4) & 0x3)
#define   C_02880C_Z_ORDER                                            0xFFFFFFCF
#define     V_02880C_LATE_Z                                         0
#define     V_02880C_EARLY_Z_THEN_LATE_Z                            1
#define     V_02880C_RE_Z                                           2
#define     V_02880C_EARLY_Z_THEN_RE_Z                              3
#define   S_02880C_KILL_ENABLE(x)                                     (((unsigned)(x) & 0x1) << 6)
#define   G_02880C_KILL_ENABLE(x)                                     (((x) >> 6) & 0x1)
#define   C_02880C_KILL_ENABLE                                        0xFFFFFFBF
#define   S_02880C_COVERAGE_TO_MASK_ENABLE(x)                         (((unsigned)(x) & 0x1) << 7)
#define   G_02880C_COVERAGE_TO_MASK_ENABLE(x)                         (((x) >> 7) & 0x1)
#define   C_02880C_COVERAGE_TO_MASK_ENABLE                            0xFFFFFF7F
#define   S_02880C_MASK_EXPORT_ENABLE(x)                              (((unsigned)(x) & 0x1) << 8)
#define   G_02880C_MASK_EXPORT_ENABLE(x)                              (((x) >> 8) & 0x1)
#define   C_02880C_MASK_EXPORT_ENABLE                                 0xFFFFFEFF
#define   S_02880C_EXEC_ON_HIER_FAIL(x)                               (((unsigned)(x) & 0x1) << 9)
#define   G_02880C_EXEC_ON_HIER_FAIL(x)                               (((x) >> 9) & 0x1)
#define   C_02880C_EXEC_ON_HIER_FAIL                                  0xFFFFFDFF
#define   S_02880C_EXEC_ON_NOOP(x)                                    (((unsigned)(x) & 0x1) << 10)
#define   G_02880C_EXEC_ON_NOOP(x)                                    (((x) >> 10) & 0x1)
#define   C_02880C_EXEC_ON_NOOP                                       0xFFFFFBFF
#define   S_02880C_ALPHA_TO_MASK_DISABLE(x)                           (((unsigned)(x) & 0x1) << 11)
#define   G_02880C_ALPHA_TO_MASK_DISABLE(x)                           (((x) >> 11) & 0x1)
#define   C_02880C_ALPHA_TO_MASK_DISABLE                              0xFFFFF7FF
#define   S_02880C_DEPTH_BEFORE_SHADER(x)                             (((unsigned)(x) & 0x1) << 12)
#define   G_02880C_DEPTH_BEFORE_SHADER(x)                             (((x) >> 12) & 0x1)
#define   C_02880C_DEPTH_BEFORE_SHADER                                0xFFFFEFFF
#define   S_02880C_CONSERVATIVE_Z_EXPORT(x)                           (((unsigned)(x) & 0x3) << 13)
#define   G_02880C_CONSERVATIVE_Z_EXPORT(x)                           (((x) >> 13) & 0x3)
#define   C_02880C_CONSERVATIVE_Z_EXPORT                              0xFFFF9FFF
#define     V_02880C_EXPORT_ANY_Z                                   0
#define     V_02880C_EXPORT_LESS_THAN_Z                             1
#define     V_02880C_EXPORT_GREATER_THAN_Z                          2
#define     V_02880C_EXPORT_RESERVED                                3
#define   S_02880C_DUAL_QUAD_DISABLE(x)                               (((unsigned)(x) & 0x1) << 15) /* >= gfx81 */
#define   G_02880C_DUAL_QUAD_DISABLE(x)                               (((x) >> 15) & 0x1)
#define   C_02880C_DUAL_QUAD_DISABLE                                  0xFFFF7FFF
#define   S_02880C_PRIMITIVE_ORDERED_PIXEL_SHADER(x)                  (((unsigned)(x) & 0x1) << 16) /* >= gfx9 */
#define   G_02880C_PRIMITIVE_ORDERED_PIXEL_SHADER(x)                  (((x) >> 16) & 0x1)
#define   C_02880C_PRIMITIVE_ORDERED_PIXEL_SHADER                     0xFFFEFFFF
#define   S_02880C_EXEC_IF_OVERLAPPED(x)                              (((unsigned)(x) & 0x1) << 17) /* >= gfx9 */
#define   G_02880C_EXEC_IF_OVERLAPPED(x)                              (((x) >> 17) & 0x1)
#define   C_02880C_EXEC_IF_OVERLAPPED                                 0xFFFDFFFF
#define   S_02880C_POPS_OVERLAP_NUM_SAMPLES(x)                        (((unsigned)(x) & 0x7) << 20) /* >= gfx9 */
#define   G_02880C_POPS_OVERLAP_NUM_SAMPLES(x)                        (((x) >> 20) & 0x7)
#define   C_02880C_POPS_OVERLAP_NUM_SAMPLES                           0xFF8FFFFF
#define   S_02880C_PRE_SHADER_DEPTH_COVERAGE_ENABLE(x)                (((unsigned)(x) & 0x1) << 23) /* >= gfx10 */
#define   G_02880C_PRE_SHADER_DEPTH_COVERAGE_ENABLE(x)                (((x) >> 23) & 0x1)
#define   C_02880C_PRE_SHADER_DEPTH_COVERAGE_ENABLE                   0xFF7FFFFF
#define R_028810_PA_CL_CLIP_CNTL                                        0x028810
#define   S_028810_UCP_ENA_0(x)                                       (((unsigned)(x) & 0x1) << 0)
#define   G_028810_UCP_ENA_0(x)                                       (((x) >> 0) & 0x1)
#define   C_028810_UCP_ENA_0                                          0xFFFFFFFE
#define   S_028810_UCP_ENA_1(x)                                       (((unsigned)(x) & 0x1) << 1)
#define   G_028810_UCP_ENA_1(x)                                       (((x) >> 1) & 0x1)
#define   C_028810_UCP_ENA_1                                          0xFFFFFFFD
#define   S_028810_UCP_ENA_2(x)                                       (((unsigned)(x) & 0x1) << 2)
#define   G_028810_UCP_ENA_2(x)                                       (((x) >> 2) & 0x1)
#define   C_028810_UCP_ENA_2                                          0xFFFFFFFB
#define   S_028810_UCP_ENA_3(x)                                       (((unsigned)(x) & 0x1) << 3)
#define   G_028810_UCP_ENA_3(x)                                       (((x) >> 3) & 0x1)
#define   C_028810_UCP_ENA_3                                          0xFFFFFFF7
#define   S_028810_UCP_ENA_4(x)                                       (((unsigned)(x) & 0x1) << 4)
#define   G_028810_UCP_ENA_4(x)                                       (((x) >> 4) & 0x1)
#define   C_028810_UCP_ENA_4                                          0xFFFFFFEF
#define   S_028810_UCP_ENA_5(x)                                       (((unsigned)(x) & 0x1) << 5)
#define   G_028810_UCP_ENA_5(x)                                       (((x) >> 5) & 0x1)
#define   C_028810_UCP_ENA_5                                          0xFFFFFFDF
#define   S_028810_PS_UCP_Y_SCALE_NEG(x)                              (((unsigned)(x) & 0x1) << 13)
#define   G_028810_PS_UCP_Y_SCALE_NEG(x)                              (((x) >> 13) & 0x1)
#define   C_028810_PS_UCP_Y_SCALE_NEG                                 0xFFFFDFFF
#define   S_028810_PS_UCP_MODE(x)                                     (((unsigned)(x) & 0x3) << 14)
#define   G_028810_PS_UCP_MODE(x)                                     (((x) >> 14) & 0x3)
#define   C_028810_PS_UCP_MODE                                        0xFFFF3FFF
#define   S_028810_CLIP_DISABLE(x)                                    (((unsigned)(x) & 0x1) << 16)
#define   G_028810_CLIP_DISABLE(x)                                    (((x) >> 16) & 0x1)
#define   C_028810_CLIP_DISABLE                                       0xFFFEFFFF
#define   S_028810_UCP_CULL_ONLY_ENA(x)                               (((unsigned)(x) & 0x1) << 17)
#define   G_028810_UCP_CULL_ONLY_ENA(x)                               (((x) >> 17) & 0x1)
#define   C_028810_UCP_CULL_ONLY_ENA                                  0xFFFDFFFF
#define   S_028810_BOUNDARY_EDGE_FLAG_ENA(x)                          (((unsigned)(x) & 0x1) << 18)
#define   G_028810_BOUNDARY_EDGE_FLAG_ENA(x)                          (((x) >> 18) & 0x1)
#define   C_028810_BOUNDARY_EDGE_FLAG_ENA                             0xFFFBFFFF
#define   S_028810_DX_CLIP_SPACE_DEF(x)                               (((unsigned)(x) & 0x1) << 19)
#define   G_028810_DX_CLIP_SPACE_DEF(x)                               (((x) >> 19) & 0x1)
#define   C_028810_DX_CLIP_SPACE_DEF                                  0xFFF7FFFF
#define   S_028810_DIS_CLIP_ERR_DETECT(x)                             (((unsigned)(x) & 0x1) << 20)
#define   G_028810_DIS_CLIP_ERR_DETECT(x)                             (((x) >> 20) & 0x1)
#define   C_028810_DIS_CLIP_ERR_DETECT                                0xFFEFFFFF
#define   S_028810_VTX_KILL_OR(x)                                     (((unsigned)(x) & 0x1) << 21)
#define   G_028810_VTX_KILL_OR(x)                                     (((x) >> 21) & 0x1)
#define   C_028810_VTX_KILL_OR                                        0xFFDFFFFF
#define   S_028810_DX_RASTERIZATION_KILL(x)                           (((unsigned)(x) & 0x1) << 22)
#define   G_028810_DX_RASTERIZATION_KILL(x)                           (((x) >> 22) & 0x1)
#define   C_028810_DX_RASTERIZATION_KILL                              0xFFBFFFFF
#define   S_028810_DX_LINEAR_ATTR_CLIP_ENA(x)                         (((unsigned)(x) & 0x1) << 24)
#define   G_028810_DX_LINEAR_ATTR_CLIP_ENA(x)                         (((x) >> 24) & 0x1)
#define   C_028810_DX_LINEAR_ATTR_CLIP_ENA                            0xFEFFFFFF
#define   S_028810_VTE_VPORT_PROVOKE_DISABLE(x)                       (((unsigned)(x) & 0x1) << 25)
#define   G_028810_VTE_VPORT_PROVOKE_DISABLE(x)                       (((x) >> 25) & 0x1)
#define   C_028810_VTE_VPORT_PROVOKE_DISABLE                          0xFDFFFFFF
#define   S_028810_ZCLIP_NEAR_DISABLE(x)                              (((unsigned)(x) & 0x1) << 26)
#define   G_028810_ZCLIP_NEAR_DISABLE(x)                              (((x) >> 26) & 0x1)
#define   C_028810_ZCLIP_NEAR_DISABLE                                 0xFBFFFFFF
#define   S_028810_ZCLIP_FAR_DISABLE(x)                               (((unsigned)(x) & 0x1) << 27)
#define   G_028810_ZCLIP_FAR_DISABLE(x)                               (((x) >> 27) & 0x1)
#define   C_028810_ZCLIP_FAR_DISABLE                                  0xF7FFFFFF
#define   S_028810_ZCLIP_PROG_NEAR_ENA(x)                             (((unsigned)(x) & 0x1) << 28) /* >= gfx9 */
#define   G_028810_ZCLIP_PROG_NEAR_ENA(x)                             (((x) >> 28) & 0x1)
#define   C_028810_ZCLIP_PROG_NEAR_ENA                                0xEFFFFFFF
#define R_028814_PA_SU_SC_MODE_CNTL                                     0x028814
#define   S_028814_CULL_FRONT(x)                                      (((unsigned)(x) & 0x1) << 0)
#define   G_028814_CULL_FRONT(x)                                      (((x) >> 0) & 0x1)
#define   C_028814_CULL_FRONT                                         0xFFFFFFFE
#define   S_028814_CULL_BACK(x)                                       (((unsigned)(x) & 0x1) << 1)
#define   G_028814_CULL_BACK(x)                                       (((x) >> 1) & 0x1)
#define   C_028814_CULL_BACK                                          0xFFFFFFFD
#define   S_028814_FACE(x)                                            (((unsigned)(x) & 0x1) << 2)
#define   G_028814_FACE(x)                                            (((x) >> 2) & 0x1)
#define   C_028814_FACE                                               0xFFFFFFFB
#define   S_028814_POLY_MODE(x)                                       (((unsigned)(x) & 0x3) << 3)
#define   G_028814_POLY_MODE(x)                                       (((x) >> 3) & 0x3)
#define   C_028814_POLY_MODE                                          0xFFFFFFE7
#define     V_028814_X_DISABLE_POLY_MODE                            0
#define     V_028814_X_DUAL_MODE                                    1
#define   S_028814_POLYMODE_FRONT_PTYPE(x)                            (((unsigned)(x) & 0x7) << 5)
#define   G_028814_POLYMODE_FRONT_PTYPE(x)                            (((x) >> 5) & 0x7)
#define   C_028814_POLYMODE_FRONT_PTYPE                               0xFFFFFF1F
#define     V_028814_X_DRAW_POINTS                                  0
#define     V_028814_X_DRAW_LINES                                   1
#define     V_028814_X_DRAW_TRIANGLES                               2
#define   S_028814_POLYMODE_BACK_PTYPE(x)                             (((unsigned)(x) & 0x7) << 8)
#define   G_028814_POLYMODE_BACK_PTYPE(x)                             (((x) >> 8) & 0x7)
#define   C_028814_POLYMODE_BACK_PTYPE                                0xFFFFF8FF
#define   S_028814_POLY_OFFSET_FRONT_ENABLE(x)                        (((unsigned)(x) & 0x1) << 11)
#define   G_028814_POLY_OFFSET_FRONT_ENABLE(x)                        (((x) >> 11) & 0x1)
#define   C_028814_POLY_OFFSET_FRONT_ENABLE                           0xFFFFF7FF
#define   S_028814_POLY_OFFSET_BACK_ENABLE(x)                         (((unsigned)(x) & 0x1) << 12)
#define   G_028814_POLY_OFFSET_BACK_ENABLE(x)                         (((x) >> 12) & 0x1)
#define   C_028814_POLY_OFFSET_BACK_ENABLE                            0xFFFFEFFF
#define   S_028814_POLY_OFFSET_PARA_ENABLE(x)                         (((unsigned)(x) & 0x1) << 13)
#define   G_028814_POLY_OFFSET_PARA_ENABLE(x)                         (((x) >> 13) & 0x1)
#define   C_028814_POLY_OFFSET_PARA_ENABLE                            0xFFFFDFFF
#define   S_028814_VTX_WINDOW_OFFSET_ENABLE(x)                        (((unsigned)(x) & 0x1) << 16)
#define   G_028814_VTX_WINDOW_OFFSET_ENABLE(x)                        (((x) >> 16) & 0x1)
#define   C_028814_VTX_WINDOW_OFFSET_ENABLE                           0xFFFEFFFF
#define   S_028814_PROVOKING_VTX_LAST(x)                              (((unsigned)(x) & 0x1) << 19)
#define   G_028814_PROVOKING_VTX_LAST(x)                              (((x) >> 19) & 0x1)
#define   C_028814_PROVOKING_VTX_LAST                                 0xFFF7FFFF
#define   S_028814_PERSP_CORR_DIS(x)                                  (((unsigned)(x) & 0x1) << 20)
#define   G_028814_PERSP_CORR_DIS(x)                                  (((x) >> 20) & 0x1)
#define   C_028814_PERSP_CORR_DIS                                     0xFFEFFFFF
#define   S_028814_MULTI_PRIM_IB_ENA(x)                               (((unsigned)(x) & 0x1) << 21)
#define   G_028814_MULTI_PRIM_IB_ENA(x)                               (((x) >> 21) & 0x1)
#define   C_028814_MULTI_PRIM_IB_ENA                                  0xFFDFFFFF
#define   S_028814_RIGHT_TRIANGLE_ALTERNATE_GRADIENT_REF(x)           (((unsigned)(x) & 0x1) << 22) /* >= gfx9 */
#define   G_028814_RIGHT_TRIANGLE_ALTERNATE_GRADIENT_REF(x)           (((x) >> 22) & 0x1)
#define   C_028814_RIGHT_TRIANGLE_ALTERNATE_GRADIENT_REF              0xFFBFFFFF
#define   S_028814_NEW_QUAD_DECOMPOSITION(x)                          (((unsigned)(x) & 0x1) << 23) /* >= gfx9 */
#define   G_028814_NEW_QUAD_DECOMPOSITION(x)                          (((x) >> 23) & 0x1)
#define   C_028814_NEW_QUAD_DECOMPOSITION                             0xFF7FFFFF
#define   S_028814_KEEP_TOGETHER_ENABLE(x)                            (((unsigned)(x) & 0x1) << 24) /* >= gfx10 */
#define   G_028814_KEEP_TOGETHER_ENABLE(x)                            (((x) >> 24) & 0x1)
#define   C_028814_KEEP_TOGETHER_ENABLE                               0xFEFFFFFF
#define R_028818_PA_CL_VTE_CNTL                                         0x028818
#define   S_028818_VPORT_X_SCALE_ENA(x)                               (((unsigned)(x) & 0x1) << 0)
#define   G_028818_VPORT_X_SCALE_ENA(x)                               (((x) >> 0) & 0x1)
#define   C_028818_VPORT_X_SCALE_ENA                                  0xFFFFFFFE
#define   S_028818_VPORT_X_OFFSET_ENA(x)                              (((unsigned)(x) & 0x1) << 1)
#define   G_028818_VPORT_X_OFFSET_ENA(x)                              (((x) >> 1) & 0x1)
#define   C_028818_VPORT_X_OFFSET_ENA                                 0xFFFFFFFD
#define   S_028818_VPORT_Y_SCALE_ENA(x)                               (((unsigned)(x) & 0x1) << 2)
#define   G_028818_VPORT_Y_SCALE_ENA(x)                               (((x) >> 2) & 0x1)
#define   C_028818_VPORT_Y_SCALE_ENA                                  0xFFFFFFFB
#define   S_028818_VPORT_Y_OFFSET_ENA(x)                              (((unsigned)(x) & 0x1) << 3)
#define   G_028818_VPORT_Y_OFFSET_ENA(x)                              (((x) >> 3) & 0x1)
#define   C_028818_VPORT_Y_OFFSET_ENA                                 0xFFFFFFF7
#define   S_028818_VPORT_Z_SCALE_ENA(x)                               (((unsigned)(x) & 0x1) << 4)
#define   G_028818_VPORT_Z_SCALE_ENA(x)                               (((x) >> 4) & 0x1)
#define   C_028818_VPORT_Z_SCALE_ENA                                  0xFFFFFFEF
#define   S_028818_VPORT_Z_OFFSET_ENA(x)                              (((unsigned)(x) & 0x1) << 5)
#define   G_028818_VPORT_Z_OFFSET_ENA(x)                              (((x) >> 5) & 0x1)
#define   C_028818_VPORT_Z_OFFSET_ENA                                 0xFFFFFFDF
#define   S_028818_VTX_XY_FMT(x)                                      (((unsigned)(x) & 0x1) << 8)
#define   G_028818_VTX_XY_FMT(x)                                      (((x) >> 8) & 0x1)
#define   C_028818_VTX_XY_FMT                                         0xFFFFFEFF
#define   S_028818_VTX_Z_FMT(x)                                       (((unsigned)(x) & 0x1) << 9)
#define   G_028818_VTX_Z_FMT(x)                                       (((x) >> 9) & 0x1)
#define   C_028818_VTX_Z_FMT                                          0xFFFFFDFF
#define   S_028818_VTX_W0_FMT(x)                                      (((unsigned)(x) & 0x1) << 10)
#define   G_028818_VTX_W0_FMT(x)                                      (((x) >> 10) & 0x1)
#define   C_028818_VTX_W0_FMT                                         0xFFFFFBFF
#define   S_028818_PERFCOUNTER_REF(x)                                 (((unsigned)(x) & 0x1) << 11)
#define   G_028818_PERFCOUNTER_REF(x)                                 (((x) >> 11) & 0x1)
#define   C_028818_PERFCOUNTER_REF                                    0xFFFFF7FF
#define R_02881C_PA_CL_VS_OUT_CNTL                                      0x02881C
#define   S_02881C_CLIP_DIST_ENA_0(x)                                 (((unsigned)(x) & 0x1) << 0)
#define   G_02881C_CLIP_DIST_ENA_0(x)                                 (((x) >> 0) & 0x1)
#define   C_02881C_CLIP_DIST_ENA_0                                    0xFFFFFFFE
#define   S_02881C_CLIP_DIST_ENA_1(x)                                 (((unsigned)(x) & 0x1) << 1)
#define   G_02881C_CLIP_DIST_ENA_1(x)                                 (((x) >> 1) & 0x1)
#define   C_02881C_CLIP_DIST_ENA_1                                    0xFFFFFFFD
#define   S_02881C_CLIP_DIST_ENA_2(x)                                 (((unsigned)(x) & 0x1) << 2)
#define   G_02881C_CLIP_DIST_ENA_2(x)                                 (((x) >> 2) & 0x1)
#define   C_02881C_CLIP_DIST_ENA_2                                    0xFFFFFFFB
#define   S_02881C_CLIP_DIST_ENA_3(x)                                 (((unsigned)(x) & 0x1) << 3)
#define   G_02881C_CLIP_DIST_ENA_3(x)                                 (((x) >> 3) & 0x1)
#define   C_02881C_CLIP_DIST_ENA_3                                    0xFFFFFFF7
#define   S_02881C_CLIP_DIST_ENA_4(x)                                 (((unsigned)(x) & 0x1) << 4)
#define   G_02881C_CLIP_DIST_ENA_4(x)                                 (((x) >> 4) & 0x1)
#define   C_02881C_CLIP_DIST_ENA_4                                    0xFFFFFFEF
#define   S_02881C_CLIP_DIST_ENA_5(x)                                 (((unsigned)(x) & 0x1) << 5)
#define   G_02881C_CLIP_DIST_ENA_5(x)                                 (((x) >> 5) & 0x1)
#define   C_02881C_CLIP_DIST_ENA_5                                    0xFFFFFFDF
#define   S_02881C_CLIP_DIST_ENA_6(x)                                 (((unsigned)(x) & 0x1) << 6)
#define   G_02881C_CLIP_DIST_ENA_6(x)                                 (((x) >> 6) & 0x1)
#define   C_02881C_CLIP_DIST_ENA_6                                    0xFFFFFFBF
#define   S_02881C_CLIP_DIST_ENA_7(x)                                 (((unsigned)(x) & 0x1) << 7)
#define   G_02881C_CLIP_DIST_ENA_7(x)                                 (((x) >> 7) & 0x1)
#define   C_02881C_CLIP_DIST_ENA_7                                    0xFFFFFF7F
#define   S_02881C_CULL_DIST_ENA_0(x)                                 (((unsigned)(x) & 0x1) << 8)
#define   G_02881C_CULL_DIST_ENA_0(x)                                 (((x) >> 8) & 0x1)
#define   C_02881C_CULL_DIST_ENA_0                                    0xFFFFFEFF
#define   S_02881C_CULL_DIST_ENA_1(x)                                 (((unsigned)(x) & 0x1) << 9)
#define   G_02881C_CULL_DIST_ENA_1(x)                                 (((x) >> 9) & 0x1)
#define   C_02881C_CULL_DIST_ENA_1                                    0xFFFFFDFF
#define   S_02881C_CULL_DIST_ENA_2(x)                                 (((unsigned)(x) & 0x1) << 10)
#define   G_02881C_CULL_DIST_ENA_2(x)                                 (((x) >> 10) & 0x1)
#define   C_02881C_CULL_DIST_ENA_2                                    0xFFFFFBFF
#define   S_02881C_CULL_DIST_ENA_3(x)                                 (((unsigned)(x) & 0x1) << 11)
#define   G_02881C_CULL_DIST_ENA_3(x)                                 (((x) >> 11) & 0x1)
#define   C_02881C_CULL_DIST_ENA_3                                    0xFFFFF7FF
#define   S_02881C_CULL_DIST_ENA_4(x)                                 (((unsigned)(x) & 0x1) << 12)
#define   G_02881C_CULL_DIST_ENA_4(x)                                 (((x) >> 12) & 0x1)
#define   C_02881C_CULL_DIST_ENA_4                                    0xFFFFEFFF
#define   S_02881C_CULL_DIST_ENA_5(x)                                 (((unsigned)(x) & 0x1) << 13)
#define   G_02881C_CULL_DIST_ENA_5(x)                                 (((x) >> 13) & 0x1)
#define   C_02881C_CULL_DIST_ENA_5                                    0xFFFFDFFF
#define   S_02881C_CULL_DIST_ENA_6(x)                                 (((unsigned)(x) & 0x1) << 14)
#define   G_02881C_CULL_DIST_ENA_6(x)                                 (((x) >> 14) & 0x1)
#define   C_02881C_CULL_DIST_ENA_6                                    0xFFFFBFFF
#define   S_02881C_CULL_DIST_ENA_7(x)                                 (((unsigned)(x) & 0x1) << 15)
#define   G_02881C_CULL_DIST_ENA_7(x)                                 (((x) >> 15) & 0x1)
#define   C_02881C_CULL_DIST_ENA_7                                    0xFFFF7FFF
#define   S_02881C_USE_VTX_POINT_SIZE(x)                              (((unsigned)(x) & 0x1) << 16)
#define   G_02881C_USE_VTX_POINT_SIZE(x)                              (((x) >> 16) & 0x1)
#define   C_02881C_USE_VTX_POINT_SIZE                                 0xFFFEFFFF
#define   S_02881C_USE_VTX_EDGE_FLAG(x)                               (((unsigned)(x) & 0x1) << 17)
#define   G_02881C_USE_VTX_EDGE_FLAG(x)                               (((x) >> 17) & 0x1)
#define   C_02881C_USE_VTX_EDGE_FLAG                                  0xFFFDFFFF
#define   S_02881C_USE_VTX_RENDER_TARGET_INDX(x)                      (((unsigned)(x) & 0x1) << 18)
#define   G_02881C_USE_VTX_RENDER_TARGET_INDX(x)                      (((x) >> 18) & 0x1)
#define   C_02881C_USE_VTX_RENDER_TARGET_INDX                         0xFFFBFFFF
#define   S_02881C_USE_VTX_VIEWPORT_INDX(x)                           (((unsigned)(x) & 0x1) << 19)
#define   G_02881C_USE_VTX_VIEWPORT_INDX(x)                           (((x) >> 19) & 0x1)
#define   C_02881C_USE_VTX_VIEWPORT_INDX                              0xFFF7FFFF
#define   S_02881C_USE_VTX_KILL_FLAG(x)                               (((unsigned)(x) & 0x1) << 20)
#define   G_02881C_USE_VTX_KILL_FLAG(x)                               (((x) >> 20) & 0x1)
#define   C_02881C_USE_VTX_KILL_FLAG                                  0xFFEFFFFF
#define   S_02881C_VS_OUT_MISC_VEC_ENA(x)                             (((unsigned)(x) & 0x1) << 21)
#define   G_02881C_VS_OUT_MISC_VEC_ENA(x)                             (((x) >> 21) & 0x1)
#define   C_02881C_VS_OUT_MISC_VEC_ENA                                0xFFDFFFFF
#define   S_02881C_VS_OUT_CCDIST0_VEC_ENA(x)                          (((unsigned)(x) & 0x1) << 22)
#define   G_02881C_VS_OUT_CCDIST0_VEC_ENA(x)                          (((x) >> 22) & 0x1)
#define   C_02881C_VS_OUT_CCDIST0_VEC_ENA                             0xFFBFFFFF
#define   S_02881C_VS_OUT_CCDIST1_VEC_ENA(x)                          (((unsigned)(x) & 0x1) << 23)
#define   G_02881C_VS_OUT_CCDIST1_VEC_ENA(x)                          (((x) >> 23) & 0x1)
#define   C_02881C_VS_OUT_CCDIST1_VEC_ENA                             0xFF7FFFFF
#define   S_02881C_VS_OUT_MISC_SIDE_BUS_ENA(x)                        (((unsigned)(x) & 0x1) << 24)
#define   G_02881C_VS_OUT_MISC_SIDE_BUS_ENA(x)                        (((x) >> 24) & 0x1)
#define   C_02881C_VS_OUT_MISC_SIDE_BUS_ENA                           0xFEFFFFFF
#define   S_02881C_USE_VTX_GS_CUT_FLAG(x)                             (((unsigned)(x) & 0x1) << 25)
#define   G_02881C_USE_VTX_GS_CUT_FLAG(x)                             (((x) >> 25) & 0x1)
#define   C_02881C_USE_VTX_GS_CUT_FLAG                                0xFDFFFFFF
#define   S_02881C_USE_VTX_LINE_WIDTH_GFX8(x)                         (((unsigned)(x) & 0x1) << 26) /* gfx8, gfx81, gfx9 */
#define   G_02881C_USE_VTX_LINE_WIDTH_GFX8(x)                         (((x) >> 26) & 0x1)
#define   C_02881C_USE_VTX_LINE_WIDTH_GFX8                            0xFBFFFFFF
#define   S_02881C_USE_VTX_SHD_OBJPRIM_ID_GFX10(x)                    (((unsigned)(x) & 0x1) << 26) /* gfx10 */
#define   G_02881C_USE_VTX_SHD_OBJPRIM_ID_GFX10(x)                    (((x) >> 26) & 0x1)
#define   C_02881C_USE_VTX_SHD_OBJPRIM_ID_GFX10                       0xFBFFFFFF
#define   S_02881C_USE_VTX_LINE_WIDTH_GFX10(x)                        (((unsigned)(x) & 0x1) << 27) /* >= gfx10 */
#define   G_02881C_USE_VTX_LINE_WIDTH_GFX10(x)                        (((x) >> 27) & 0x1)
#define   C_02881C_USE_VTX_LINE_WIDTH_GFX10                           0xF7FFFFFF
#define   S_02881C_USE_VTX_SHD_OBJPRIM_ID_GFX9(x)                     (((unsigned)(x) & 0x1) << 27) /* gfx9 */
#define   G_02881C_USE_VTX_SHD_OBJPRIM_ID_GFX9(x)                     (((x) >> 27) & 0x1)
#define   C_02881C_USE_VTX_SHD_OBJPRIM_ID_GFX9                        0xF7FFFFFF
#define   S_02881C_USE_VTX_VRS_RATE(x)                                (((unsigned)(x) & 0x1) << 28) /* >= gfx103 */
#define   G_02881C_USE_VTX_VRS_RATE(x)                                (((x) >> 28) & 0x1)
#define   C_02881C_USE_VTX_VRS_RATE                                   0xEFFFFFFF
#define   S_02881C_BYPASS_VTX_RATE_COMBINER(x)                        (((unsigned)(x) & 0x1) << 29) /* >= gfx103 */
#define   G_02881C_BYPASS_VTX_RATE_COMBINER(x)                        (((x) >> 29) & 0x1)
#define   C_02881C_BYPASS_VTX_RATE_COMBINER                           0xDFFFFFFF
#define   S_02881C_BYPASS_PRIM_RATE_COMBINER(x)                       (((unsigned)(x) & 0x1) << 30) /* >= gfx103 */
#define   G_02881C_BYPASS_PRIM_RATE_COMBINER(x)                       (((x) >> 30) & 0x1)
#define   C_02881C_BYPASS_PRIM_RATE_COMBINER                          0xBFFFFFFF
#define R_028820_PA_CL_NANINF_CNTL                                      0x028820
#define   S_028820_VTE_XY_INF_DISCARD(x)                              (((unsigned)(x) & 0x1) << 0)
#define   G_028820_VTE_XY_INF_DISCARD(x)                              (((x) >> 0) & 0x1)
#define   C_028820_VTE_XY_INF_DISCARD                                 0xFFFFFFFE
#define   S_028820_VTE_Z_INF_DISCARD(x)                               (((unsigned)(x) & 0x1) << 1)
#define   G_028820_VTE_Z_INF_DISCARD(x)                               (((x) >> 1) & 0x1)
#define   C_028820_VTE_Z_INF_DISCARD                                  0xFFFFFFFD
#define   S_028820_VTE_W_INF_DISCARD(x)                               (((unsigned)(x) & 0x1) << 2)
#define   G_028820_VTE_W_INF_DISCARD(x)                               (((x) >> 2) & 0x1)
#define   C_028820_VTE_W_INF_DISCARD                                  0xFFFFFFFB
#define   S_028820_VTE_0XNANINF_IS_0(x)                               (((unsigned)(x) & 0x1) << 3)
#define   G_028820_VTE_0XNANINF_IS_0(x)                               (((x) >> 3) & 0x1)
#define   C_028820_VTE_0XNANINF_IS_0                                  0xFFFFFFF7
#define   S_028820_VTE_XY_NAN_RETAIN(x)                               (((unsigned)(x) & 0x1) << 4)
#define   G_028820_VTE_XY_NAN_RETAIN(x)                               (((x) >> 4) & 0x1)
#define   C_028820_VTE_XY_NAN_RETAIN                                  0xFFFFFFEF
#define   S_028820_VTE_Z_NAN_RETAIN(x)                                (((unsigned)(x) & 0x1) << 5)
#define   G_028820_VTE_Z_NAN_RETAIN(x)                                (((x) >> 5) & 0x1)
#define   C_028820_VTE_Z_NAN_RETAIN                                   0xFFFFFFDF
#define   S_028820_VTE_W_NAN_RETAIN(x)                                (((unsigned)(x) & 0x1) << 6)
#define   G_028820_VTE_W_NAN_RETAIN(x)                                (((x) >> 6) & 0x1)
#define   C_028820_VTE_W_NAN_RETAIN                                   0xFFFFFFBF
#define   S_028820_VTE_W_RECIP_NAN_IS_0(x)                            (((unsigned)(x) & 0x1) << 7)
#define   G_028820_VTE_W_RECIP_NAN_IS_0(x)                            (((x) >> 7) & 0x1)
#define   C_028820_VTE_W_RECIP_NAN_IS_0                               0xFFFFFF7F
#define   S_028820_VS_XY_NAN_TO_INF(x)                                (((unsigned)(x) & 0x1) << 8)
#define   G_028820_VS_XY_NAN_TO_INF(x)                                (((x) >> 8) & 0x1)
#define   C_028820_VS_XY_NAN_TO_INF                                   0xFFFFFEFF
#define   S_028820_VS_XY_INF_RETAIN(x)                                (((unsigned)(x) & 0x1) << 9)
#define   G_028820_VS_XY_INF_RETAIN(x)                                (((x) >> 9) & 0x1)
#define   C_028820_VS_XY_INF_RETAIN                                   0xFFFFFDFF
#define   S_028820_VS_Z_NAN_TO_INF(x)                                 (((unsigned)(x) & 0x1) << 10)
#define   G_028820_VS_Z_NAN_TO_INF(x)                                 (((x) >> 10) & 0x1)
#define   C_028820_VS_Z_NAN_TO_INF                                    0xFFFFFBFF
#define   S_028820_VS_Z_INF_RETAIN(x)                                 (((unsigned)(x) & 0x1) << 11)
#define   G_028820_VS_Z_INF_RETAIN(x)                                 (((x) >> 11) & 0x1)
#define   C_028820_VS_Z_INF_RETAIN                                    0xFFFFF7FF
#define   S_028820_VS_W_NAN_TO_INF(x)                                 (((unsigned)(x) & 0x1) << 12)
#define   G_028820_VS_W_NAN_TO_INF(x)                                 (((x) >> 12) & 0x1)
#define   C_028820_VS_W_NAN_TO_INF                                    0xFFFFEFFF
#define   S_028820_VS_W_INF_RETAIN(x)                                 (((unsigned)(x) & 0x1) << 13)
#define   G_028820_VS_W_INF_RETAIN(x)                                 (((x) >> 13) & 0x1)
#define   C_028820_VS_W_INF_RETAIN                                    0xFFFFDFFF
#define   S_028820_VS_CLIP_DIST_INF_DISCARD(x)                        (((unsigned)(x) & 0x1) << 14)
#define   G_028820_VS_CLIP_DIST_INF_DISCARD(x)                        (((x) >> 14) & 0x1)
#define   C_028820_VS_CLIP_DIST_INF_DISCARD                           0xFFFFBFFF
#define   S_028820_VTE_NO_OUTPUT_NEG_0(x)                             (((unsigned)(x) & 0x1) << 20)
#define   G_028820_VTE_NO_OUTPUT_NEG_0(x)                             (((x) >> 20) & 0x1)
#define   C_028820_VTE_NO_OUTPUT_NEG_0                                0xFFEFFFFF
#define R_028824_PA_SU_LINE_STIPPLE_CNTL                                0x028824
#define   S_028824_LINE_STIPPLE_RESET(x)                              (((unsigned)(x) & 0x3) << 0)
#define   G_028824_LINE_STIPPLE_RESET(x)                              (((x) >> 0) & 0x3)
#define   C_028824_LINE_STIPPLE_RESET                                 0xFFFFFFFC
#define   S_028824_EXPAND_FULL_LENGTH(x)                              (((unsigned)(x) & 0x1) << 2)
#define   G_028824_EXPAND_FULL_LENGTH(x)                              (((x) >> 2) & 0x1)
#define   C_028824_EXPAND_FULL_LENGTH                                 0xFFFFFFFB
#define   S_028824_FRACTIONAL_ACCUM(x)                                (((unsigned)(x) & 0x1) << 3)
#define   G_028824_FRACTIONAL_ACCUM(x)                                (((x) >> 3) & 0x1)
#define   C_028824_FRACTIONAL_ACCUM                                   0xFFFFFFF7
#define   S_028824_DIAMOND_ADJUST(x)                                  (((unsigned)(x) & 0x1) << 4)
#define   G_028824_DIAMOND_ADJUST(x)                                  (((x) >> 4) & 0x1)
#define   C_028824_DIAMOND_ADJUST                                     0xFFFFFFEF
#define R_028828_PA_SU_LINE_STIPPLE_SCALE                               0x028828
#define R_02882C_PA_SU_PRIM_FILTER_CNTL                                 0x02882C
#define   S_02882C_TRIANGLE_FILTER_DISABLE(x)                         (((unsigned)(x) & 0x1) << 0)
#define   G_02882C_TRIANGLE_FILTER_DISABLE(x)                         (((x) >> 0) & 0x1)
#define   C_02882C_TRIANGLE_FILTER_DISABLE                            0xFFFFFFFE
#define   S_02882C_LINE_FILTER_DISABLE(x)                             (((unsigned)(x) & 0x1) << 1)
#define   G_02882C_LINE_FILTER_DISABLE(x)                             (((x) >> 1) & 0x1)
#define   C_02882C_LINE_FILTER_DISABLE                                0xFFFFFFFD
#define   S_02882C_POINT_FILTER_DISABLE(x)                            (((unsigned)(x) & 0x1) << 2)
#define   G_02882C_POINT_FILTER_DISABLE(x)                            (((x) >> 2) & 0x1)
#define   C_02882C_POINT_FILTER_DISABLE                               0xFFFFFFFB
#define   S_02882C_RECTANGLE_FILTER_DISABLE(x)                        (((unsigned)(x) & 0x1) << 3)
#define   G_02882C_RECTANGLE_FILTER_DISABLE(x)                        (((x) >> 3) & 0x1)
#define   C_02882C_RECTANGLE_FILTER_DISABLE                           0xFFFFFFF7
#define   S_02882C_TRIANGLE_EXPAND_ENA(x)                             (((unsigned)(x) & 0x1) << 4)
#define   G_02882C_TRIANGLE_EXPAND_ENA(x)                             (((x) >> 4) & 0x1)
#define   C_02882C_TRIANGLE_EXPAND_ENA                                0xFFFFFFEF
#define   S_02882C_LINE_EXPAND_ENA(x)                                 (((unsigned)(x) & 0x1) << 5)
#define   G_02882C_LINE_EXPAND_ENA(x)                                 (((x) >> 5) & 0x1)
#define   C_02882C_LINE_EXPAND_ENA                                    0xFFFFFFDF
#define   S_02882C_POINT_EXPAND_ENA(x)                                (((unsigned)(x) & 0x1) << 6)
#define   G_02882C_POINT_EXPAND_ENA(x)                                (((x) >> 6) & 0x1)
#define   C_02882C_POINT_EXPAND_ENA                                   0xFFFFFFBF
#define   S_02882C_RECTANGLE_EXPAND_ENA(x)                            (((unsigned)(x) & 0x1) << 7)
#define   G_02882C_RECTANGLE_EXPAND_ENA(x)                            (((x) >> 7) & 0x1)
#define   C_02882C_RECTANGLE_EXPAND_ENA                               0xFFFFFF7F
#define   S_02882C_PRIM_EXPAND_CONSTANT(x)                            (((unsigned)(x) & 0xFF) << 8)
#define   G_02882C_PRIM_EXPAND_CONSTANT(x)                            (((x) >> 8) & 0xFF)
#define   C_02882C_PRIM_EXPAND_CONSTANT                               0xFFFF00FF
#define   S_02882C_XMAX_RIGHT_EXCLUSION(x)                            (((unsigned)(x) & 0x1) << 30)
#define   G_02882C_XMAX_RIGHT_EXCLUSION(x)                            (((x) >> 30) & 0x1)
#define   C_02882C_XMAX_RIGHT_EXCLUSION                               0xBFFFFFFF
#define   S_02882C_YMAX_BOTTOM_EXCLUSION(x)                           (((unsigned)(x) & 0x1) << 31)
#define   G_02882C_YMAX_BOTTOM_EXCLUSION(x)                           (((x) >> 31) & 0x1)
#define   C_02882C_YMAX_BOTTOM_EXCLUSION                              0x7FFFFFFF
#define R_028830_PA_SU_SMALL_PRIM_FILTER_CNTL                           0x028830 /* >= gfx9 */
#define   S_028830_SMALL_PRIM_FILTER_ENABLE(x)                        (((unsigned)(x) & 0x1) << 0)
#define   G_028830_SMALL_PRIM_FILTER_ENABLE(x)                        (((x) >> 0) & 0x1)
#define   C_028830_SMALL_PRIM_FILTER_ENABLE                           0xFFFFFFFE
#define   S_028830_TRIANGLE_FILTER_DISABLE(x)                         (((unsigned)(x) & 0x1) << 1)
#define   G_028830_TRIANGLE_FILTER_DISABLE(x)                         (((x) >> 1) & 0x1)
#define   C_028830_TRIANGLE_FILTER_DISABLE                            0xFFFFFFFD
#define   S_028830_LINE_FILTER_DISABLE(x)                             (((unsigned)(x) & 0x1) << 2)
#define   G_028830_LINE_FILTER_DISABLE(x)                             (((x) >> 2) & 0x1)
#define   C_028830_LINE_FILTER_DISABLE                                0xFFFFFFFB
#define   S_028830_POINT_FILTER_DISABLE(x)                            (((unsigned)(x) & 0x1) << 3)
#define   G_028830_POINT_FILTER_DISABLE(x)                            (((x) >> 3) & 0x1)
#define   C_028830_POINT_FILTER_DISABLE                               0xFFFFFFF7
#define   S_028830_RECTANGLE_FILTER_DISABLE(x)                        (((unsigned)(x) & 0x1) << 4)
#define   G_028830_RECTANGLE_FILTER_DISABLE(x)                        (((x) >> 4) & 0x1)
#define   C_028830_RECTANGLE_FILTER_DISABLE                           0xFFFFFFEF
#define   S_028830_SRBSL_ENABLE(x)                                    (((unsigned)(x) & 0x1) << 5) /* gfx10 */
#define   G_028830_SRBSL_ENABLE(x)                                    (((x) >> 5) & 0x1)
#define   C_028830_SRBSL_ENABLE                                       0xFFFFFFDF
#define   S_028830_SC_1XMSAA_COMPATIBLE_DISABLE(x)                    (((unsigned)(x) & 0x1) << 6) /* gfx9, gfx10 */
#define   G_028830_SC_1XMSAA_COMPATIBLE_DISABLE(x)                    (((x) >> 6) & 0x1)
#define   C_028830_SC_1XMSAA_COMPATIBLE_DISABLE                       0xFFFFFFBF
#define R_028834_PA_CL_OBJPRIM_ID_CNTL                                  0x028834 /* gfx9, gfx10 */
#define   S_028834_OBJ_ID_SEL(x)                                      (((unsigned)(x) & 0x1) << 0)
#define   G_028834_OBJ_ID_SEL(x)                                      (((x) >> 0) & 0x1)
#define   C_028834_OBJ_ID_SEL                                         0xFFFFFFFE
#define   S_028834_ADD_PIPED_PRIM_ID(x)                               (((unsigned)(x) & 0x1) << 1)
#define   G_028834_ADD_PIPED_PRIM_ID(x)                               (((x) >> 1) & 0x1)
#define   C_028834_ADD_PIPED_PRIM_ID                                  0xFFFFFFFD
#define   S_028834_EN_32BIT_OBJPRIMID(x)                              (((unsigned)(x) & 0x1) << 2) /* gfx9 */
#define   G_028834_EN_32BIT_OBJPRIMID(x)                              (((x) >> 2) & 0x1)
#define   C_028834_EN_32BIT_OBJPRIMID                                 0xFFFFFFFB
#define R_028838_PA_CL_NGG_CNTL                                         0x028838 /* >= gfx9 */
#define   S_028838_VERTEX_REUSE_OFF(x)                                (((unsigned)(x) & 0x1) << 0)
#define   G_028838_VERTEX_REUSE_OFF(x)                                (((x) >> 0) & 0x1)
#define   C_028838_VERTEX_REUSE_OFF                                   0xFFFFFFFE
#define   S_028838_INDEX_BUF_EDGE_FLAG_ENA(x)                         (((unsigned)(x) & 0x1) << 1)
#define   G_028838_INDEX_BUF_EDGE_FLAG_ENA(x)                         (((x) >> 1) & 0x1)
#define   C_028838_INDEX_BUF_EDGE_FLAG_ENA                            0xFFFFFFFD
#define   S_028838_VERTEX_REUSE_DEPTH(x)                              (((unsigned)(x) & 0xFF) << 2) /* >= gfx103 */
#define   G_028838_VERTEX_REUSE_DEPTH(x)                              (((x) >> 2) & 0xFF)
#define   C_028838_VERTEX_REUSE_DEPTH                                 0xFFFFFC03
#define R_02883C_PA_SU_OVER_RASTERIZATION_CNTL                          0x02883C /* >= gfx9 */
#define   S_02883C_DISCARD_0_AREA_TRIANGLES(x)                        (((unsigned)(x) & 0x1) << 0)
#define   G_02883C_DISCARD_0_AREA_TRIANGLES(x)                        (((x) >> 0) & 0x1)
#define   C_02883C_DISCARD_0_AREA_TRIANGLES                           0xFFFFFFFE
#define   S_02883C_DISCARD_0_AREA_LINES(x)                            (((unsigned)(x) & 0x1) << 1)
#define   G_02883C_DISCARD_0_AREA_LINES(x)                            (((x) >> 1) & 0x1)
#define   C_02883C_DISCARD_0_AREA_LINES                               0xFFFFFFFD
#define   S_02883C_DISCARD_0_AREA_POINTS(x)                           (((unsigned)(x) & 0x1) << 2)
#define   G_02883C_DISCARD_0_AREA_POINTS(x)                           (((x) >> 2) & 0x1)
#define   C_02883C_DISCARD_0_AREA_POINTS                              0xFFFFFFFB
#define   S_02883C_DISCARD_0_AREA_RECTANGLES(x)                       (((unsigned)(x) & 0x1) << 3)
#define   G_02883C_DISCARD_0_AREA_RECTANGLES(x)                       (((x) >> 3) & 0x1)
#define   C_02883C_DISCARD_0_AREA_RECTANGLES                          0xFFFFFFF7
#define   S_02883C_USE_PROVOKING_ZW(x)                                (((unsigned)(x) & 0x1) << 4)
#define   G_02883C_USE_PROVOKING_ZW(x)                                (((x) >> 4) & 0x1)
#define   C_02883C_USE_PROVOKING_ZW                                   0xFFFFFFEF
#define R_028840_PA_STEREO_CNTL                                         0x028840 /* >= gfx9 */
#define   S_028840_EN_STEREO(x)                                       (((unsigned)(x) & 0x1) << 0) /* gfx9 */
#define   G_028840_EN_STEREO(x)                                       (((x) >> 0) & 0x1)
#define   C_028840_EN_STEREO                                          0xFFFFFFFE
#define   S_028840_STEREO_MODE(x)                                     (((unsigned)(x) & 0xF) << 1)
#define   G_028840_STEREO_MODE(x)                                     (((x) >> 1) & 0xF)
#define   C_028840_STEREO_MODE                                        0xFFFFFFE1
#define   S_028840_RT_SLICE_MODE(x)                                   (((unsigned)(x) & 0x7) << 5)
#define   G_028840_RT_SLICE_MODE(x)                                   (((x) >> 5) & 0x7)
#define   C_028840_RT_SLICE_MODE                                      0xFFFFFF1F
#define   S_028840_RT_SLICE_OFFSET_GFX10(x)                           (((unsigned)(x) & 0xF) << 8) /* >= gfx10 */
#define   G_028840_RT_SLICE_OFFSET_GFX10(x)                           (((x) >> 8) & 0xF)
#define   C_028840_RT_SLICE_OFFSET_GFX10                              0xFFFFF0FF
#define   S_028840_RT_SLICE_OFFSET_GFX9(x)                            (((unsigned)(x) & 0x3) << 8) /* gfx9 */
#define   G_028840_RT_SLICE_OFFSET_GFX9(x)                            (((x) >> 8) & 0x3)
#define   C_028840_RT_SLICE_OFFSET_GFX9                               0xFFFFFCFF
#define   S_028840_VP_ID_MODE_GFX9(x)                                 (((unsigned)(x) & 0x7) << 10) /* gfx9 */
#define   G_028840_VP_ID_MODE_GFX9(x)                                 (((x) >> 10) & 0x7)
#define   C_028840_VP_ID_MODE_GFX9                                    0xFFFFE3FF
#define   S_028840_VP_ID_OFFSET_GFX9(x)                               (((unsigned)(x) & 0xF) << 13) /* gfx9 */
#define   G_028840_VP_ID_OFFSET_GFX9(x)                               (((x) >> 13) & 0xF)
#define   C_028840_VP_ID_OFFSET_GFX9                                  0xFFFE1FFF
#define   S_028840_VP_ID_MODE_GFX10(x)                                (((unsigned)(x) & 0x7) << 16) /* >= gfx10 */
#define   G_028840_VP_ID_MODE_GFX10(x)                                (((x) >> 16) & 0x7)
#define   C_028840_VP_ID_MODE_GFX10                                   0xFFF8FFFF
#define   S_028840_VP_ID_OFFSET_GFX10(x)                              (((unsigned)(x) & 0xF) << 19) /* >= gfx10 */
#define   G_028840_VP_ID_OFFSET_GFX10(x)                              (((x) >> 19) & 0xF)
#define   C_028840_VP_ID_OFFSET_GFX10                                 0xFF87FFFF
#define R_028844_PA_STATE_STEREO_X                                      0x028844 /* >= gfx10 */
#define R_028848_PA_CL_VRS_CNTL                                         0x028848 /* >= gfx103 */
#define   S_028848_VERTEX_RATE_COMBINER_MODE(x)                       (((unsigned)(x) & 0x7) << 0)
#define   G_028848_VERTEX_RATE_COMBINER_MODE(x)                       (((x) >> 0) & 0x7)
#define   C_028848_VERTEX_RATE_COMBINER_MODE                          0xFFFFFFF8
#define     V_028848_VRS_COMB_MODE_PASSTHRU                         0
#define     V_028848_VRS_COMB_MODE_OVERRIDE                         1
#define     V_028848_VRS_COMB_MODE_MIN                              2
#define     V_028848_VRS_COMB_MODE_MAX                              3
#define     V_028848_VRS_COMB_MODE_SATURATE                         4
#define   S_028848_PRIMITIVE_RATE_COMBINER_MODE(x)                    (((unsigned)(x) & 0x7) << 3)
#define   G_028848_PRIMITIVE_RATE_COMBINER_MODE(x)                    (((x) >> 3) & 0x7)
#define   C_028848_PRIMITIVE_RATE_COMBINER_MODE                       0xFFFFFFC7
#define   S_028848_HTILE_RATE_COMBINER_MODE(x)                        (((unsigned)(x) & 0x7) << 6)
#define   G_028848_HTILE_RATE_COMBINER_MODE(x)                        (((x) >> 6) & 0x7)
#define   C_028848_HTILE_RATE_COMBINER_MODE                           0xFFFFFE3F
#define   S_028848_SAMPLE_ITER_COMBINER_MODE(x)                       (((unsigned)(x) & 0x7) << 9)
#define   G_028848_SAMPLE_ITER_COMBINER_MODE(x)                       (((x) >> 9) & 0x7)
#define   C_028848_SAMPLE_ITER_COMBINER_MODE                          0xFFFFF1FF
#define   S_028848_EXPOSE_VRS_PIXELS_MASK(x)                          (((unsigned)(x) & 0x1) << 13)
#define   G_028848_EXPOSE_VRS_PIXELS_MASK(x)                          (((x) >> 13) & 0x1)
#define   C_028848_EXPOSE_VRS_PIXELS_MASK                             0xFFFFDFFF
#define   S_028848_CMASK_RATE_HINT_FORCE_ZERO(x)                      (((unsigned)(x) & 0x1) << 14)
#define   G_028848_CMASK_RATE_HINT_FORCE_ZERO(x)                      (((x) >> 14) & 0x1)
#define   C_028848_CMASK_RATE_HINT_FORCE_ZERO                         0xFFFFBFFF
#define R_028A00_PA_SU_POINT_SIZE                                       0x028A00
#define   S_028A00_HEIGHT(x)                                          (((unsigned)(x) & 0xFFFF) << 0)
#define   G_028A00_HEIGHT(x)                                          (((x) >> 0) & 0xFFFF)
#define   C_028A00_HEIGHT                                             0xFFFF0000
#define   S_028A00_WIDTH(x)                                           (((unsigned)(x) & 0xFFFF) << 16)
#define   G_028A00_WIDTH(x)                                           (((x) >> 16) & 0xFFFF)
#define   C_028A00_WIDTH                                              0x0000FFFF
#define R_028A04_PA_SU_POINT_MINMAX                                     0x028A04
#define   S_028A04_MIN_SIZE(x)                                        (((unsigned)(x) & 0xFFFF) << 0)
#define   G_028A04_MIN_SIZE(x)                                        (((x) >> 0) & 0xFFFF)
#define   C_028A04_MIN_SIZE                                           0xFFFF0000
#define   S_028A04_MAX_SIZE(x)                                        (((unsigned)(x) & 0xFFFF) << 16)
#define   G_028A04_MAX_SIZE(x)                                        (((x) >> 16) & 0xFFFF)
#define   C_028A04_MAX_SIZE                                           0x0000FFFF
#define R_028A08_PA_SU_LINE_CNTL                                        0x028A08
#define   S_028A08_WIDTH(x)                                           (((unsigned)(x) & 0xFFFF) << 0)
#define   G_028A08_WIDTH(x)                                           (((x) >> 0) & 0xFFFF)
#define   C_028A08_WIDTH                                              0xFFFF0000
#define R_028A0C_PA_SC_LINE_STIPPLE                                     0x028A0C
#define   S_028A0C_LINE_PATTERN(x)                                    (((unsigned)(x) & 0xFFFF) << 0)
#define   G_028A0C_LINE_PATTERN(x)                                    (((x) >> 0) & 0xFFFF)
#define   C_028A0C_LINE_PATTERN                                       0xFFFF0000
#define   S_028A0C_REPEAT_COUNT(x)                                    (((unsigned)(x) & 0xFF) << 16)
#define   G_028A0C_REPEAT_COUNT(x)                                    (((x) >> 16) & 0xFF)
#define   C_028A0C_REPEAT_COUNT                                       0xFF00FFFF
#define   S_028A0C_PATTERN_BIT_ORDER(x)                               (((unsigned)(x) & 0x1) << 28)
#define   G_028A0C_PATTERN_BIT_ORDER(x)                               (((x) >> 28) & 0x1)
#define   C_028A0C_PATTERN_BIT_ORDER                                  0xEFFFFFFF
#define   S_028A0C_AUTO_RESET_CNTL(x)                                 (((unsigned)(x) & 0x3) << 29)
#define   G_028A0C_AUTO_RESET_CNTL(x)                                 (((x) >> 29) & 0x3)
#define   C_028A0C_AUTO_RESET_CNTL                                    0x9FFFFFFF
#define R_028A10_VGT_OUTPUT_PATH_CNTL                                   0x028A10
#define   S_028A10_PATH_SELECT(x)                                     (((unsigned)(x) & 0x7) << 0)
#define   G_028A10_PATH_SELECT(x)                                     (((x) >> 0) & 0x7)
#define   C_028A10_PATH_SELECT                                        0xFFFFFFF8
#define R_028A14_VGT_HOS_CNTL                                           0x028A14
#define   S_028A14_TESS_MODE(x)                                       (((unsigned)(x) & 0x3) << 0)
#define   G_028A14_TESS_MODE(x)                                       (((x) >> 0) & 0x3)
#define   C_028A14_TESS_MODE                                          0xFFFFFFFC
#define R_028A18_VGT_HOS_MAX_TESS_LEVEL                                 0x028A18
#define R_028A1C_VGT_HOS_MIN_TESS_LEVEL                                 0x028A1C
#define R_028A20_VGT_HOS_REUSE_DEPTH                                    0x028A20
#define   S_028A20_REUSE_DEPTH(x)                                     (((unsigned)(x) & 0xFF) << 0)
#define   G_028A20_REUSE_DEPTH(x)                                     (((x) >> 0) & 0xFF)
#define   C_028A20_REUSE_DEPTH                                        0xFFFFFF00
#define R_028A24_VGT_GROUP_PRIM_TYPE                                    0x028A24
#define   S_028A24_PRIM_TYPE(x)                                       (((unsigned)(x) & 0x1F) << 0)
#define   G_028A24_PRIM_TYPE(x)                                       (((x) >> 0) & 0x1F)
#define   C_028A24_PRIM_TYPE                                          0xFFFFFFE0
#define     V_028A24_DI_PT_NONE                                     0
#define     V_028A24_DI_PT_POINTLIST                                1
#define     V_028A24_DI_PT_LINELIST                                 2
#define     V_028A24_DI_PT_LINESTRIP                                3
#define     V_028A24_DI_PT_TRILIST                                  4
#define     V_028A24_DI_PT_TRIFAN                                   5
#define     V_028A24_DI_PT_TRISTRIP                                 6
#define     V_028A24_DI_PT_2D_RECTANGLE                             7 /* >= gfx9 */
#define     V_028A24_DI_PT_UNUSED_0                                 7 /* <= gfx81 */
#define     V_028A24_DI_PT_UNUSED_1                                 8
#define     V_028A24_DI_PT_PATCH                                    9
#define     V_028A24_DI_PT_LINELIST_ADJ                             10
#define     V_028A24_DI_PT_LINESTRIP_ADJ                            11
#define     V_028A24_DI_PT_TRILIST_ADJ                              12
#define     V_028A24_DI_PT_TRISTRIP_ADJ                             13
#define     V_028A24_DI_PT_UNUSED_3                                 14
#define     V_028A24_DI_PT_UNUSED_4                                 15
#define     V_028A24_DI_PT_TRI_WITH_WFLAGS                          16
#define     V_028A24_DI_PT_RECTLIST                                 17
#define     V_028A24_DI_PT_LINELOOP                                 18
#define     V_028A24_DI_PT_QUADLIST                                 19
#define     V_028A24_DI_PT_QUADSTRIP                                20
#define     V_028A24_DI_PT_POLYGON                                  21
#define     V_028A24_DI_PT_2D_COPY_RECT_LIST_V0                     22 /* <= gfx81 */
#define     V_028A24_DI_PT_2D_COPY_RECT_LIST_V1                     23 /* <= gfx81 */
#define     V_028A24_DI_PT_2D_COPY_RECT_LIST_V2                     24 /* <= gfx81 */
#define     V_028A24_DI_PT_2D_COPY_RECT_LIST_V3                     25 /* <= gfx81 */
#define     V_028A24_DI_PT_2D_FILL_RECT_LIST                        26 /* <= gfx81 */
#define     V_028A24_DI_PT_2D_LINE_STRIP                            27 /* <= gfx81 */
#define     V_028A24_DI_PT_2D_TRI_STRIP                             28 /* <= gfx81 */
#define   S_028A24_RETAIN_ORDER(x)                                    (((unsigned)(x) & 0x1) << 14)
#define   G_028A24_RETAIN_ORDER(x)                                    (((x) >> 14) & 0x1)
#define   C_028A24_RETAIN_ORDER                                       0xFFFFBFFF
#define   S_028A24_RETAIN_QUADS(x)                                    (((unsigned)(x) & 0x1) << 15)
#define   G_028A24_RETAIN_QUADS(x)                                    (((x) >> 15) & 0x1)
#define   C_028A24_RETAIN_QUADS                                       0xFFFF7FFF
#define   S_028A24_PRIM_ORDER(x)                                      (((unsigned)(x) & 0x7) << 16)
#define   G_028A24_PRIM_ORDER(x)                                      (((x) >> 16) & 0x7)
#define   C_028A24_PRIM_ORDER                                         0xFFF8FFFF
#define R_028A28_VGT_GROUP_FIRST_DECR                                   0x028A28
#define   S_028A28_FIRST_DECR(x)                                      (((unsigned)(x) & 0xF) << 0)
#define   G_028A28_FIRST_DECR(x)                                      (((x) >> 0) & 0xF)
#define   C_028A28_FIRST_DECR                                         0xFFFFFFF0
#define R_028A2C_VGT_GROUP_DECR                                         0x028A2C
#define   S_028A2C_DECR(x)                                            (((unsigned)(x) & 0xF) << 0)
#define   G_028A2C_DECR(x)                                            (((x) >> 0) & 0xF)
#define   C_028A2C_DECR                                               0xFFFFFFF0
#define R_028A30_VGT_GROUP_VECT_0_CNTL                                  0x028A30
#define   S_028A30_COMP_X_EN(x)                                       (((unsigned)(x) & 0x1) << 0)
#define   G_028A30_COMP_X_EN(x)                                       (((x) >> 0) & 0x1)
#define   C_028A30_COMP_X_EN                                          0xFFFFFFFE
#define   S_028A30_COMP_Y_EN(x)                                       (((unsigned)(x) & 0x1) << 1)
#define   G_028A30_COMP_Y_EN(x)                                       (((x) >> 1) & 0x1)
#define   C_028A30_COMP_Y_EN                                          0xFFFFFFFD
#define   S_028A30_COMP_Z_EN(x)                                       (((unsigned)(x) & 0x1) << 2)
#define   G_028A30_COMP_Z_EN(x)                                       (((x) >> 2) & 0x1)
#define   C_028A30_COMP_Z_EN                                          0xFFFFFFFB
#define   S_028A30_COMP_W_EN(x)                                       (((unsigned)(x) & 0x1) << 3)
#define   G_028A30_COMP_W_EN(x)                                       (((x) >> 3) & 0x1)
#define   C_028A30_COMP_W_EN                                          0xFFFFFFF7
#define   S_028A30_STRIDE(x)                                          (((unsigned)(x) & 0xFF) << 8)
#define   G_028A30_STRIDE(x)                                          (((x) >> 8) & 0xFF)
#define   C_028A30_STRIDE                                             0xFFFF00FF
#define   S_028A30_SHIFT(x)                                           (((unsigned)(x) & 0xFF) << 16)
#define   G_028A30_SHIFT(x)                                           (((x) >> 16) & 0xFF)
#define   C_028A30_SHIFT                                              0xFF00FFFF
#define R_028A34_VGT_GROUP_VECT_1_CNTL                                  0x028A34
#define R_028A38_VGT_GROUP_VECT_0_FMT_CNTL                              0x028A38
#define   S_028A38_X_CONV(x)                                          (((unsigned)(x) & 0xF) << 0)
#define   G_028A38_X_CONV(x)                                          (((x) >> 0) & 0xF)
#define   C_028A38_X_CONV                                             0xFFFFFFF0
#define   S_028A38_X_OFFSET(x)                                        (((unsigned)(x) & 0xF) << 4)
#define   G_028A38_X_OFFSET(x)                                        (((x) >> 4) & 0xF)
#define   C_028A38_X_OFFSET                                           0xFFFFFF0F
#define   S_028A38_Y_CONV(x)                                          (((unsigned)(x) & 0xF) << 8)
#define   G_028A38_Y_CONV(x)                                          (((x) >> 8) & 0xF)
#define   C_028A38_Y_CONV                                             0xFFFFF0FF
#define   S_028A38_Y_OFFSET(x)                                        (((unsigned)(x) & 0xF) << 12)
#define   G_028A38_Y_OFFSET(x)                                        (((x) >> 12) & 0xF)
#define   C_028A38_Y_OFFSET                                           0xFFFF0FFF
#define   S_028A38_Z_CONV(x)                                          (((unsigned)(x) & 0xF) << 16)
#define   G_028A38_Z_CONV(x)                                          (((x) >> 16) & 0xF)
#define   C_028A38_Z_CONV                                             0xFFF0FFFF
#define   S_028A38_Z_OFFSET(x)                                        (((unsigned)(x) & 0xF) << 20)
#define   G_028A38_Z_OFFSET(x)                                        (((x) >> 20) & 0xF)
#define   C_028A38_Z_OFFSET                                           0xFF0FFFFF
#define   S_028A38_W_CONV(x)                                          (((unsigned)(x) & 0xF) << 24)
#define   G_028A38_W_CONV(x)                                          (((x) >> 24) & 0xF)
#define   C_028A38_W_CONV                                             0xF0FFFFFF
#define   S_028A38_W_OFFSET(x)                                        (((unsigned)(x) & 0xF) << 28)
#define   G_028A38_W_OFFSET(x)                                        (((x) >> 28) & 0xF)
#define   C_028A38_W_OFFSET                                           0x0FFFFFFF
#define R_028A3C_VGT_GROUP_VECT_1_FMT_CNTL                              0x028A3C
#define R_028A40_VGT_GS_MODE                                            0x028A40
#define   S_028A40_MODE(x)                                            (((unsigned)(x) & 0x7) << 0)
#define   G_028A40_MODE(x)                                            (((x) >> 0) & 0x7)
#define   C_028A40_MODE                                               0xFFFFFFF8
#define     V_028A40_GS_OFF                                         0
#define     V_028A40_GS_SCENARIO_A                                  1
#define     V_028A40_GS_SCENARIO_B                                  2
#define     V_028A40_GS_SCENARIO_G                                  3
#define     V_028A40_GS_SCENARIO_C                                  4
#define     V_028A40_SPRITE_EN                                      5
#define   S_028A40_RESERVED_0(x)                                      (((unsigned)(x) & 0x1) << 3)
#define   G_028A40_RESERVED_0(x)                                      (((x) >> 3) & 0x1)
#define   C_028A40_RESERVED_0                                         0xFFFFFFF7
#define   S_028A40_CUT_MODE(x)                                        (((unsigned)(x) & 0x3) << 4)
#define   G_028A40_CUT_MODE(x)                                        (((x) >> 4) & 0x3)
#define   C_028A40_CUT_MODE                                           0xFFFFFFCF
#define     V_028A40_GS_CUT_1024                                    0
#define     V_028A40_GS_CUT_512                                     1
#define     V_028A40_GS_CUT_256                                     2
#define     V_028A40_GS_CUT_128                                     3
#define   S_028A40_RESERVED_1(x)                                      (((unsigned)(x) & 0x1F) << 6)
#define   G_028A40_RESERVED_1(x)                                      (((x) >> 6) & 0x1F)
#define   C_028A40_RESERVED_1                                         0xFFFFF83F
#define   S_028A40_GS_C_PACK_EN(x)                                    (((unsigned)(x) & 0x1) << 11)
#define   G_028A40_GS_C_PACK_EN(x)                                    (((x) >> 11) & 0x1)
#define   C_028A40_GS_C_PACK_EN                                       0xFFFFF7FF
#define   S_028A40_RESERVED_2(x)                                      (((unsigned)(x) & 0x1) << 12)
#define   G_028A40_RESERVED_2(x)                                      (((x) >> 12) & 0x1)
#define   C_028A40_RESERVED_2                                         0xFFFFEFFF
#define   S_028A40_ES_PASSTHRU(x)                                     (((unsigned)(x) & 0x1) << 13)
#define   G_028A40_ES_PASSTHRU(x)                                     (((x) >> 13) & 0x1)
#define   C_028A40_ES_PASSTHRU                                        0xFFFFDFFF
#define   S_028A40_COMPUTE_MODE(x)                                    (((unsigned)(x) & 0x1) << 14) /* <= gfx7, >= gfx10 */
#define   G_028A40_COMPUTE_MODE(x)                                    (((x) >> 14) & 0x1)
#define   C_028A40_COMPUTE_MODE                                       0xFFFFBFFF
#define   S_028A40_RESERVED_3(x)                                      (((unsigned)(x) & 0x1) << 14) /* gfx8, gfx81, gfx9 */
#define   G_028A40_RESERVED_3(x)                                      (((x) >> 14) & 0x1)
#define   C_028A40_RESERVED_3                                         0xFFFFBFFF
#define   S_028A40_FAST_COMPUTE_MODE(x)                               (((unsigned)(x) & 0x1) << 15) /* <= gfx7, >= gfx10 */
#define   G_028A40_FAST_COMPUTE_MODE(x)                               (((x) >> 15) & 0x1)
#define   C_028A40_FAST_COMPUTE_MODE                                  0xFFFF7FFF
#define   S_028A40_RESERVED_4(x)                                      (((unsigned)(x) & 0x1) << 15) /* gfx8, gfx81, gfx9 */
#define   G_028A40_RESERVED_4(x)                                      (((x) >> 15) & 0x1)
#define   C_028A40_RESERVED_4                                         0xFFFF7FFF
#define   S_028A40_ELEMENT_INFO_EN(x)                                 (((unsigned)(x) & 0x1) << 16) /* <= gfx7, >= gfx10 */
#define   G_028A40_ELEMENT_INFO_EN(x)                                 (((x) >> 16) & 0x1)
#define   C_028A40_ELEMENT_INFO_EN                                    0xFFFEFFFF
#define   S_028A40_RESERVED_5(x)                                      (((unsigned)(x) & 0x1) << 16) /* gfx8, gfx81, gfx9 */
#define   G_028A40_RESERVED_5(x)                                      (((x) >> 16) & 0x1)
#define   C_028A40_RESERVED_5                                         0xFFFEFFFF
#define   S_028A40_PARTIAL_THD_AT_EOI(x)                              (((unsigned)(x) & 0x1) << 17)
#define   G_028A40_PARTIAL_THD_AT_EOI(x)                              (((x) >> 17) & 0x1)
#define   C_028A40_PARTIAL_THD_AT_EOI                                 0xFFFDFFFF
#define   S_028A40_SUPPRESS_CUTS(x)                                   (((unsigned)(x) & 0x1) << 18)
#define   G_028A40_SUPPRESS_CUTS(x)                                   (((x) >> 18) & 0x1)
#define   C_028A40_SUPPRESS_CUTS                                      0xFFFBFFFF
#define   S_028A40_ES_WRITE_OPTIMIZE(x)                               (((unsigned)(x) & 0x1) << 19)
#define   G_028A40_ES_WRITE_OPTIMIZE(x)                               (((x) >> 19) & 0x1)
#define   C_028A40_ES_WRITE_OPTIMIZE                                  0xFFF7FFFF
#define   S_028A40_GS_WRITE_OPTIMIZE(x)                               (((unsigned)(x) & 0x1) << 20)
#define   G_028A40_GS_WRITE_OPTIMIZE(x)                               (((x) >> 20) & 0x1)
#define   C_028A40_GS_WRITE_OPTIMIZE                                  0xFFEFFFFF
#define   S_028A40_ONCHIP(x)                                          (((unsigned)(x) & 0x3) << 21)
#define   G_028A40_ONCHIP(x)                                          (((x) >> 21) & 0x3)
#define   C_028A40_ONCHIP                                             0xFF9FFFFF
#define R_028A44_VGT_GS_ONCHIP_CNTL                                     0x028A44 /* >= gfx7 */
#define   S_028A44_ES_VERTS_PER_SUBGRP(x)                             (((unsigned)(x) & 0x7FF) << 0)
#define   G_028A44_ES_VERTS_PER_SUBGRP(x)                             (((x) >> 0) & 0x7FF)
#define   C_028A44_ES_VERTS_PER_SUBGRP                                0xFFFFF800
#define   S_028A44_GS_PRIMS_PER_SUBGRP(x)                             (((unsigned)(x) & 0x7FF) << 11)
#define   G_028A44_GS_PRIMS_PER_SUBGRP(x)                             (((x) >> 11) & 0x7FF)
#define   C_028A44_GS_PRIMS_PER_SUBGRP                                0xFFC007FF
#define   S_028A44_GS_INST_PRIMS_IN_SUBGRP(x)                         (((unsigned)(x) & 0x3FF) << 22) /* >= gfx9 */
#define   G_028A44_GS_INST_PRIMS_IN_SUBGRP(x)                         (((x) >> 22) & 0x3FF)
#define   C_028A44_GS_INST_PRIMS_IN_SUBGRP                            0x003FFFFF
#define R_028A48_PA_SC_MODE_CNTL_0                                      0x028A48
#define   S_028A48_MSAA_ENABLE(x)                                     (((unsigned)(x) & 0x1) << 0)
#define   G_028A48_MSAA_ENABLE(x)                                     (((x) >> 0) & 0x1)
#define   C_028A48_MSAA_ENABLE                                        0xFFFFFFFE
#define   S_028A48_VPORT_SCISSOR_ENABLE(x)                            (((unsigned)(x) & 0x1) << 1)
#define   G_028A48_VPORT_SCISSOR_ENABLE(x)                            (((x) >> 1) & 0x1)
#define   C_028A48_VPORT_SCISSOR_ENABLE                               0xFFFFFFFD
#define   S_028A48_LINE_STIPPLE_ENABLE(x)                             (((unsigned)(x) & 0x1) << 2)
#define   G_028A48_LINE_STIPPLE_ENABLE(x)                             (((x) >> 2) & 0x1)
#define   C_028A48_LINE_STIPPLE_ENABLE                                0xFFFFFFFB
#define   S_028A48_SEND_UNLIT_STILES_TO_PKR(x)                        (((unsigned)(x) & 0x1) << 3)
#define   G_028A48_SEND_UNLIT_STILES_TO_PKR(x)                        (((x) >> 3) & 0x1)
#define   C_028A48_SEND_UNLIT_STILES_TO_PKR                           0xFFFFFFF7
#define   S_028A48_SCALE_LINE_WIDTH_PAD(x)                            (((unsigned)(x) & 0x1) << 4) /* gfx9, gfx10 */
#define   G_028A48_SCALE_LINE_WIDTH_PAD(x)                            (((x) >> 4) & 0x1)
#define   C_028A48_SCALE_LINE_WIDTH_PAD                               0xFFFFFFEF
#define   S_028A48_ALTERNATE_RBS_PER_TILE(x)                          (((unsigned)(x) & 0x1) << 5) /* >= gfx9 */
#define   G_028A48_ALTERNATE_RBS_PER_TILE(x)                          (((x) >> 5) & 0x1)
#define   C_028A48_ALTERNATE_RBS_PER_TILE                             0xFFFFFFDF
#define   S_028A48_COARSE_TILE_STARTS_ON_EVEN_RB(x)                   (((unsigned)(x) & 0x1) << 6) /* >= gfx9 */
#define   G_028A48_COARSE_TILE_STARTS_ON_EVEN_RB(x)                   (((x) >> 6) & 0x1)
#define   C_028A48_COARSE_TILE_STARTS_ON_EVEN_RB                      0xFFFFFFBF
#define R_028A4C_PA_SC_MODE_CNTL_1                                      0x028A4C
#define   S_028A4C_WALK_SIZE(x)                                       (((unsigned)(x) & 0x1) << 0)
#define   G_028A4C_WALK_SIZE(x)                                       (((x) >> 0) & 0x1)
#define   C_028A4C_WALK_SIZE                                          0xFFFFFFFE
#define   S_028A4C_WALK_ALIGNMENT(x)                                  (((unsigned)(x) & 0x1) << 1)
#define   G_028A4C_WALK_ALIGNMENT(x)                                  (((x) >> 1) & 0x1)
#define   C_028A4C_WALK_ALIGNMENT                                     0xFFFFFFFD
#define   S_028A4C_WALK_ALIGN8_PRIM_FITS_ST(x)                        (((unsigned)(x) & 0x1) << 2)
#define   G_028A4C_WALK_ALIGN8_PRIM_FITS_ST(x)                        (((x) >> 2) & 0x1)
#define   C_028A4C_WALK_ALIGN8_PRIM_FITS_ST                           0xFFFFFFFB
#define   S_028A4C_WALK_FENCE_ENABLE(x)                               (((unsigned)(x) & 0x1) << 3)
#define   G_028A4C_WALK_FENCE_ENABLE(x)                               (((x) >> 3) & 0x1)
#define   C_028A4C_WALK_FENCE_ENABLE                                  0xFFFFFFF7
#define   S_028A4C_WALK_FENCE_SIZE(x)                                 (((unsigned)(x) & 0x7) << 4)
#define   G_028A4C_WALK_FENCE_SIZE(x)                                 (((x) >> 4) & 0x7)
#define   C_028A4C_WALK_FENCE_SIZE                                    0xFFFFFF8F
#define   S_028A4C_SUPERTILE_WALK_ORDER_ENABLE(x)                     (((unsigned)(x) & 0x1) << 7)
#define   G_028A4C_SUPERTILE_WALK_ORDER_ENABLE(x)                     (((x) >> 7) & 0x1)
#define   C_028A4C_SUPERTILE_WALK_ORDER_ENABLE                        0xFFFFFF7F
#define   S_028A4C_TILE_WALK_ORDER_ENABLE(x)                          (((unsigned)(x) & 0x1) << 8)
#define   G_028A4C_TILE_WALK_ORDER_ENABLE(x)                          (((x) >> 8) & 0x1)
#define   C_028A4C_TILE_WALK_ORDER_ENABLE                             0xFFFFFEFF
#define   S_028A4C_TILE_COVER_DISABLE(x)                              (((unsigned)(x) & 0x1) << 9)
#define   G_028A4C_TILE_COVER_DISABLE(x)                              (((x) >> 9) & 0x1)
#define   C_028A4C_TILE_COVER_DISABLE                                 0xFFFFFDFF
#define   S_028A4C_TILE_COVER_NO_SCISSOR(x)                           (((unsigned)(x) & 0x1) << 10)
#define   G_028A4C_TILE_COVER_NO_SCISSOR(x)                           (((x) >> 10) & 0x1)
#define   C_028A4C_TILE_COVER_NO_SCISSOR                              0xFFFFFBFF
#define   S_028A4C_ZMM_LINE_EXTENT(x)                                 (((unsigned)(x) & 0x1) << 11)
#define   G_028A4C_ZMM_LINE_EXTENT(x)                                 (((x) >> 11) & 0x1)
#define   C_028A4C_ZMM_LINE_EXTENT                                    0xFFFFF7FF
#define   S_028A4C_ZMM_LINE_OFFSET(x)                                 (((unsigned)(x) & 0x1) << 12)
#define   G_028A4C_ZMM_LINE_OFFSET(x)                                 (((x) >> 12) & 0x1)
#define   C_028A4C_ZMM_LINE_OFFSET                                    0xFFFFEFFF
#define   S_028A4C_ZMM_RECT_EXTENT(x)                                 (((unsigned)(x) & 0x1) << 13)
#define   G_028A4C_ZMM_RECT_EXTENT(x)                                 (((x) >> 13) & 0x1)
#define   C_028A4C_ZMM_RECT_EXTENT                                    0xFFFFDFFF
#define   S_028A4C_KILL_PIX_POST_HI_Z(x)                              (((unsigned)(x) & 0x1) << 14)
#define   G_028A4C_KILL_PIX_POST_HI_Z(x)                              (((x) >> 14) & 0x1)
#define   C_028A4C_KILL_PIX_POST_HI_Z                                 0xFFFFBFFF
#define   S_028A4C_KILL_PIX_POST_DETAIL_MASK(x)                       (((unsigned)(x) & 0x1) << 15)
#define   G_028A4C_KILL_PIX_POST_DETAIL_MASK(x)                       (((x) >> 15) & 0x1)
#define   C_028A4C_KILL_PIX_POST_DETAIL_MASK                          0xFFFF7FFF
#define   S_028A4C_PS_ITER_SAMPLE(x)                                  (((unsigned)(x) & 0x1) << 16)
#define   G_028A4C_PS_ITER_SAMPLE(x)                                  (((x) >> 16) & 0x1)
#define   C_028A4C_PS_ITER_SAMPLE                                     0xFFFEFFFF
#define   S_028A4C_MULTI_SHADER_ENGINE_PRIM_DISCARD_ENABLE(x)         (((unsigned)(x) & 0x1) << 17)
#define   G_028A4C_MULTI_SHADER_ENGINE_PRIM_DISCARD_ENABLE(x)         (((x) >> 17) & 0x1)
#define   C_028A4C_MULTI_SHADER_ENGINE_PRIM_DISCARD_ENABLE            0xFFFDFFFF
#define   S_028A4C_MULTI_GPU_SUPERTILE_ENABLE(x)                      (((unsigned)(x) & 0x1) << 18)
#define   G_028A4C_MULTI_GPU_SUPERTILE_ENABLE(x)                      (((x) >> 18) & 0x1)
#define   C_028A4C_MULTI_GPU_SUPERTILE_ENABLE                         0xFFFBFFFF
#define   S_028A4C_GPU_ID_OVERRIDE_ENABLE(x)                          (((unsigned)(x) & 0x1) << 19)
#define   G_028A4C_GPU_ID_OVERRIDE_ENABLE(x)                          (((x) >> 19) & 0x1)
#define   C_028A4C_GPU_ID_OVERRIDE_ENABLE                             0xFFF7FFFF
#define   S_028A4C_GPU_ID_OVERRIDE(x)                                 (((unsigned)(x) & 0xF) << 20)
#define   G_028A4C_GPU_ID_OVERRIDE(x)                                 (((x) >> 20) & 0xF)
#define   C_028A4C_GPU_ID_OVERRIDE                                    0xFF0FFFFF
#define   S_028A4C_MULTI_GPU_PRIM_DISCARD_ENABLE(x)                   (((unsigned)(x) & 0x1) << 24)
#define   G_028A4C_MULTI_GPU_PRIM_DISCARD_ENABLE(x)                   (((x) >> 24) & 0x1)
#define   C_028A4C_MULTI_GPU_PRIM_DISCARD_ENABLE                      0xFEFFFFFF
#define   S_028A4C_FORCE_EOV_CNTDWN_ENABLE(x)                         (((unsigned)(x) & 0x1) << 25)
#define   G_028A4C_FORCE_EOV_CNTDWN_ENABLE(x)                         (((x) >> 25) & 0x1)
#define   C_028A4C_FORCE_EOV_CNTDWN_ENABLE                            0xFDFFFFFF
#define   S_028A4C_FORCE_EOV_REZ_ENABLE(x)                            (((unsigned)(x) & 0x1) << 26)
#define   G_028A4C_FORCE_EOV_REZ_ENABLE(x)                            (((x) >> 26) & 0x1)
#define   C_028A4C_FORCE_EOV_REZ_ENABLE                               0xFBFFFFFF
#define   S_028A4C_OUT_OF_ORDER_PRIMITIVE_ENABLE(x)                   (((unsigned)(x) & 0x1) << 27)
#define   G_028A4C_OUT_OF_ORDER_PRIMITIVE_ENABLE(x)                   (((x) >> 27) & 0x1)
#define   C_028A4C_OUT_OF_ORDER_PRIMITIVE_ENABLE                      0xF7FFFFFF
#define   S_028A4C_OUT_OF_ORDER_WATER_MARK(x)                         (((unsigned)(x) & 0x7) << 28)
#define   G_028A4C_OUT_OF_ORDER_WATER_MARK(x)                         (((x) >> 28) & 0x7)
#define   C_028A4C_OUT_OF_ORDER_WATER_MARK                            0x8FFFFFFF
#define R_028A50_VGT_ENHANCE                                            0x028A50
#define R_028A54_VGT_GS_PER_ES                                          0x028A54
#define   S_028A54_GS_PER_ES(x)                                       (((unsigned)(x) & 0x7FF) << 0)
#define   G_028A54_GS_PER_ES(x)                                       (((x) >> 0) & 0x7FF)
#define   C_028A54_GS_PER_ES                                          0xFFFFF800
#define R_028A58_VGT_ES_PER_GS                                          0x028A58
#define   S_028A58_ES_PER_GS(x)                                       (((unsigned)(x) & 0x7FF) << 0)
#define   G_028A58_ES_PER_GS(x)                                       (((x) >> 0) & 0x7FF)
#define   C_028A58_ES_PER_GS                                          0xFFFFF800
#define R_028A5C_VGT_GS_PER_VS                                          0x028A5C
#define   S_028A5C_GS_PER_VS(x)                                       (((unsigned)(x) & 0xF) << 0)
#define   G_028A5C_GS_PER_VS(x)                                       (((x) >> 0) & 0xF)
#define   C_028A5C_GS_PER_VS                                          0xFFFFFFF0
#define R_028A60_VGT_GSVS_RING_OFFSET_1                                 0x028A60
#define   S_028A60_OFFSET(x)                                          (((unsigned)(x) & 0x7FFF) << 0)
#define   G_028A60_OFFSET(x)                                          (((x) >> 0) & 0x7FFF)
#define   C_028A60_OFFSET                                             0xFFFF8000
#define R_028A64_VGT_GSVS_RING_OFFSET_2                                 0x028A64
#define R_028A68_VGT_GSVS_RING_OFFSET_3                                 0x028A68
#define R_028A6C_VGT_GS_OUT_PRIM_TYPE                                   0x028A6C
#define   S_028A6C_OUTPRIM_TYPE(x)                                    (((unsigned)(x) & 0x3F) << 0)
#define   G_028A6C_OUTPRIM_TYPE(x)                                    (((x) >> 0) & 0x3F)
#define   C_028A6C_OUTPRIM_TYPE                                       0xFFFFFFC0
#define     V_028A6C_POINTLIST                                      0
#define     V_028A6C_LINESTRIP                                      1
#define     V_028A6C_TRISTRIP                                       2
#define     V_028A6C_RECTLIST                                       3 /* >= gfx9 */
#define   S_028A6C_OUTPRIM_TYPE_1(x)                                  (((unsigned)(x) & 0x3F) << 8)
#define   G_028A6C_OUTPRIM_TYPE_1(x)                                  (((x) >> 8) & 0x3F)
#define   C_028A6C_OUTPRIM_TYPE_1                                     0xFFFFC0FF
#define   S_028A6C_OUTPRIM_TYPE_2(x)                                  (((unsigned)(x) & 0x3F) << 16)
#define   G_028A6C_OUTPRIM_TYPE_2(x)                                  (((x) >> 16) & 0x3F)
#define   C_028A6C_OUTPRIM_TYPE_2                                     0xFFC0FFFF
#define   S_028A6C_OUTPRIM_TYPE_3(x)                                  (((unsigned)(x) & 0x3F) << 22)
#define   G_028A6C_OUTPRIM_TYPE_3(x)                                  (((x) >> 22) & 0x3F)
#define   C_028A6C_OUTPRIM_TYPE_3                                     0xF03FFFFF
#define   S_028A6C_UNIQUE_TYPE_PER_STREAM(x)                          (((unsigned)(x) & 0x1) << 31)
#define   G_028A6C_UNIQUE_TYPE_PER_STREAM(x)                          (((x) >> 31) & 0x1)
#define   C_028A6C_UNIQUE_TYPE_PER_STREAM                             0x7FFFFFFF
#define R_028A70_IA_ENHANCE                                             0x028A70
#define R_028A74_VGT_DMA_SIZE                                           0x028A74
#define R_028A78_VGT_DMA_MAX_SIZE                                       0x028A78
#define R_028A7C_VGT_DMA_INDEX_TYPE                                     0x028A7C
#define   S_028A7C_INDEX_TYPE(x)                                      (((unsigned)(x) & 0x3) << 0)
#define   G_028A7C_INDEX_TYPE(x)                                      (((x) >> 0) & 0x3)
#define   C_028A7C_INDEX_TYPE                                         0xFFFFFFFC
#define     V_028A7C_VGT_INDEX_16                                   0
#define     V_028A7C_VGT_INDEX_32                                   1
#define     V_028A7C_VGT_INDEX_8                                    2 /* >= gfx8 */
#define   S_028A7C_SWAP_MODE(x)                                       (((unsigned)(x) & 0x3) << 2)
#define   G_028A7C_SWAP_MODE(x)                                       (((x) >> 2) & 0x3)
#define   C_028A7C_SWAP_MODE                                          0xFFFFFFF3
#define     V_028A7C_VGT_DMA_SWAP_NONE                              0
#define     V_028A7C_VGT_DMA_SWAP_16_BIT                            1
#define     V_028A7C_VGT_DMA_SWAP_32_BIT                            2
#define     V_028A7C_VGT_DMA_SWAP_WORD                              3
#define   S_028A7C_BUF_TYPE(x)                                        (((unsigned)(x) & 0x3) << 4)
#define   G_028A7C_BUF_TYPE(x)                                        (((x) >> 4) & 0x3)
#define   C_028A7C_BUF_TYPE                                           0xFFFFFFCF
#define     V_028A7C_VGT_DMA_BUF_MEM                                0
#define     V_028A7C_VGT_DMA_BUF_RING                               1
#define     V_028A7C_VGT_DMA_BUF_SETUP                              2
#define     V_028A7C_VGT_DMA_PTR_UPDATE                             3 /* >= gfx8 */
#define   S_028A7C_RDREQ_POLICY(x)                                    (((unsigned)(x) & 0x3) << 6)
#define   G_028A7C_RDREQ_POLICY(x)                                    (((x) >> 6) & 0x3)
#define   C_028A7C_RDREQ_POLICY                                       0xFFFFFF3F
#define     V_028A7C_VGT_POLICY_LRU                                 0
#define     V_028A7C_VGT_POLICY_STREAM                              1
#define     V_028A7C_VGT_POLICY_BYPASS                              2 /* <= gfx7, >= gfx10 */
#define     V_028A7C_VGT_POLICY_RESERVED                            3 /* <= gfx7 */
#define   S_028A7C_ATC(x)                                             (((unsigned)(x) & 0x1) << 8) /* <= gfx7, >= gfx10 */
#define   G_028A7C_ATC(x)                                             (((x) >> 8) & 0x1)
#define   C_028A7C_ATC                                                0xFFFFFEFF
#define   S_028A7C_PRIMGEN_EN(x)                                      (((unsigned)(x) & 0x1) << 8) /* gfx9 */
#define   G_028A7C_PRIMGEN_EN(x)                                      (((x) >> 8) & 0x1)
#define   C_028A7C_PRIMGEN_EN                                         0xFFFFFEFF
#define   S_028A7C_NOT_EOP(x)                                         (((unsigned)(x) & 0x1) << 9)
#define   G_028A7C_NOT_EOP(x)                                         (((x) >> 9) & 0x1)
#define   C_028A7C_NOT_EOP                                            0xFFFFFDFF
#define   S_028A7C_REQ_PATH(x)                                        (((unsigned)(x) & 0x1) << 10)
#define   G_028A7C_REQ_PATH(x)                                        (((x) >> 10) & 0x1)
#define   C_028A7C_REQ_PATH                                           0xFFFFFBFF
#define   S_028A7C_MTYPE(x)                                           (((unsigned)(x) & 0x7) << 11) /* gfx8, gfx81, >= gfx10 */
#define   G_028A7C_MTYPE(x)                                           (((x) >> 11) & 0x7)
#define   C_028A7C_MTYPE                                              0xFFFFC7FF
#define   S_028A7C_DISABLE_INSTANCE_PACKING(x)                        (((unsigned)(x) & 0x1) << 14) /* >= gfx103 */
#define   G_028A7C_DISABLE_INSTANCE_PACKING(x)                        (((x) >> 14) & 0x1)
#define   C_028A7C_DISABLE_INSTANCE_PACKING                           0xFFFFBFFF
#define R_028A80_WD_ENHANCE                                             0x028A80 /* >= gfx7 */
#define R_028A84_VGT_PRIMITIVEID_EN                                     0x028A84
#define   S_028A84_PRIMITIVEID_EN(x)                                  (((unsigned)(x) & 0x1) << 0)
#define   G_028A84_PRIMITIVEID_EN(x)                                  (((x) >> 0) & 0x1)
#define   C_028A84_PRIMITIVEID_EN                                     0xFFFFFFFE
#define   S_028A84_DISABLE_RESET_ON_EOI(x)                            (((unsigned)(x) & 0x1) << 1)
#define   G_028A84_DISABLE_RESET_ON_EOI(x)                            (((x) >> 1) & 0x1)
#define   C_028A84_DISABLE_RESET_ON_EOI                               0xFFFFFFFD
#define   S_028A84_NGG_DISABLE_PROVOK_REUSE(x)                        (((unsigned)(x) & 0x1) << 2) /* >= gfx9 */
#define   G_028A84_NGG_DISABLE_PROVOK_REUSE(x)                    