/******************************************************************************
 * Header file for vtga.h                                                     *
 *                                                                            *
 * Copyright (c) 1994-1998 ATI Technologies Inc.  All rights reserved.        *
 ******************************************************************************/

#ifndef _VTGA_H
#define _VTGA_H

// Return codes for targa routines.

#define SUCCESS             0
#define OPEN_ERROR          1
#define MEMORY_ERROR        2
#define IMAGE_TYPE_ERROR    3

// Use BYTE alignment.

#pragma pack(1)

typedef struct
{
    char id_length;                     // File ID length.
    char cm_type;                       // 0 = no colour map, 1 = colour map.
    char image_type;                    // 1 = uncompressed, colour map.
    short  cm_origin;                   // Starting colour map index.
    short  cm_length;                   // Number of colour map entries.
    char cm_entrysize;                  // Bits/colour map entry.
    short  x_origin;                    // Starting x position.
    short  y_origin;                    // Starting y position.
    short  width;                       // Image width in pixels.
    short  height;                      // Image height in pixels.
    char pixel_depth;                   // Image bits per pixel (8, 16, 24).
    char image_coord;                   // Image start coordinates:
                                        //  0 - bottom left
                                        //  1 - bottom right
                                        //  2 - top left
                                        //  3 - top right
} TARGA_HEADER;

// Restore to default alignment.

#pragma pack()


// Routines in vtga.c

short get_targa_header (char *filename, TARGA_HEADER *header);
short set_targa_palette (char *filename);
short load_targa (char *filename, short x, int y);

#endif // _VTGA_H
