/******************************************************************************
 * ATI mach64VT/3D RAGE -specific register defines for Chapter 8 sample code. *
 *                                                                            *
 * Copyright (c) 1994-1998 ATI Technologies Inc.  All rights reserved.        *
 ******************************************************************************/

#ifndef _ATIM64VT_H
#define _ATIM64VT_H

// Since the VT is a superset of the CT, pull in standard ATIM64.H defines.

#include "atim64.h"

// Most of the new VT registers are in a separate register block offset 1KB
// behind the standard memory-mapped register base address so define this new
// base relative to the old offset.

#define REG_BLOCK_1_OFFSET      (-1024) // Offset in BYTES

// GUI MEMORY MAPPED Registers.

#define GP_IO                   0x0078  // Dword offset 1E (Register block 0)
#define GP_IO_CNTL              0x007C  // Dword offset 1F (Register block 0)

#define OVERLAY_Y_X             (0x0000 + REG_BLOCK_1_OFFSET)   // Dword 00
#define OVERLAY_Y_X_END         (0x0004 + REG_BLOCK_1_OFFSET)   // Dword 01
#define OVERLAY_VIDEO_KEY_CLR   (0x0008 + REG_BLOCK_1_OFFSET)   // Dword 02
#define OVERLAY_VIDEO_KEY_MSK   (0x000C + REG_BLOCK_1_OFFSET)   // Dword 03
#define OVERLAY_GRAPHICS_KEY_CLR    (0x0010 + REG_BLOCK_1_OFFSET)   // Dword 04
#define OVERLAY_GRAPHICS_KEY_MSK    (0x0014 + REG_BLOCK_1_OFFSET)   // Dword 05
#define OVERLAY_KEY_CNTL        (0x0018 + REG_BLOCK_1_OFFSET)   // Dword 06

#define OVERLAY_SCALE_INC       (0x0020 + REG_BLOCK_1_OFFSET)   // Dword 08
#define OVERLAY_SCALE_CNTL      (0x0024 + REG_BLOCK_1_OFFSET)   // Dword 09
#define SCALER_HEIGHT_WIDTH     (0x0028 + REG_BLOCK_1_OFFSET)   // Dword 0A
#define OVERLAY_TEST            (0x002C + REG_BLOCK_1_OFFSET)   // Dword 0B
#define SCALER_THRESHOLD        (0x0030 + REG_BLOCK_1_OFFSET)   // Dword 0C
#define SCALER_BUF0_OFFSET      (0x0034 + REG_BLOCK_1_OFFSET)   // Dword 0D
#define SCALER_BUF0_PITCH       (0x003C + REG_BLOCK_1_OFFSET)   // Dword 0F

#define SCALER_COLOUR_CNTL      (0x0150 + REG_BLOCK_1_OFFSET)   // Dword 54
#define SCALER_H_COEFF0         (0x0154 + REG_BLOCK_1_OFFSET)   // Dword 55
#define SCALER_H_COEFF1         (0x0158 + REG_BLOCK_1_OFFSET)   // Dword 56
#define SCALER_H_COEFF2         (0x015C + REG_BLOCK_1_OFFSET)   // Dword 57
#define SCALER_H_COEFF3         (0x0160 + REG_BLOCK_1_OFFSET)   // Dword 58
#define SCALER_H_COEFF4         (0x0164 + REG_BLOCK_1_OFFSET)   // Dword 59

// bus mastering registers
#define BM_FRAME_BUF_OFFSET     (0x0180 + REG_BLOCK_1_OFFSET)  // Dword 1_60
#define BM_SYSTEM_MEM_ADDR      (0x0184 + REG_BLOCK_1_OFFSET)  // Dword 1_61
#define BM_COMMAND              (0x0188 + REG_BLOCK_1_OFFSET)  // Dword 1_62
#define BM_STATUS               (0x018C + REG_BLOCK_1_OFFSET)  // Dword 1_63
#define BM_GUI_TABLE            (0x01B8 + REG_BLOCK_1_OFFSET)  // Dword 1_6E
#define BM_SYSTEM_TABLE         (0x01BC + REG_BLOCK_1_OFFSET)  // Dword 1_6F
#define BM_GUI_TABLE_CMD        0x024C  // dword 0_93h
#define BM_ADDR                 0x0248  // dword 0_92h
#define BM_DATA                 0x0248  // dword 0_92h
#define BM_HOSTDATA             0x0244  // dword 0_91h


#define CAPTURE_Y_X             (0x0040 + REG_BLOCK_1_OFFSET)   // Dword 10
#define CAPTURE_HEIGHT_WIDTH    (0x0044 + REG_BLOCK_1_OFFSET)   // Dword 11
#define VIDEO_FORMAT            (0x0048 + REG_BLOCK_1_OFFSET)   // Dword 12
#define VIDEO_CONFIG            (0x004C + REG_BLOCK_1_OFFSET)   // Dword 13
#define CAPTURE_CONFIG          (0x0050 + REG_BLOCK_1_OFFSET)   // Dword 14
#define TRIG_CNTL               (0x0054 + REG_BLOCK_1_OFFSET)   // Dword 15
#define VIDEO_SYNC_TEST         (0x0058 + REG_BLOCK_1_OFFSET)   // Dword 16

#define VMC_CONFIG              (0x0060 + REG_BLOCK_1_OFFSET)   // Dword 18
#define VMC_STATUS              (0x0064 + REG_BLOCK_1_OFFSET)   // Dword 19
#define VMC_CMD                 (0x0068 + REG_BLOCK_1_OFFSET)   // Dword 1A
#define VMC_ARG0                (0x006C + REG_BLOCK_1_OFFSET)   // Dword 1B
#define VMC_ARG1                (0x0070 + REG_BLOCK_1_OFFSET)   // Dword 1C
#define VMC_SNOOP_ARG0          (0x0074 + REG_BLOCK_1_OFFSET)   // Dword 1D
#define VMC_SNOOP_ARG1          (0x0078 + REG_BLOCK_1_OFFSET)   // Dword 1E

#define BUF0_OFFSET             (0x0080 + REG_BLOCK_1_OFFSET)   // Dword 20
#define BUF0_PITCH              (0x008C + REG_BLOCK_1_OFFSET)   // Dword 23
#define BUF1_OFFSET             (0x0098 + REG_BLOCK_1_OFFSET)   // Dword 26
#define BUF1_PITCH              (0x00A4 + REG_BLOCK_1_OFFSET)   // Dword 29
#define BUF0_CAP_ODD_OFFSET     (0x00AC + REG_BLOCK_1_OFFSET)   // Dword 2B
#define BUF1_CAP_ODD_OFFSET     (0x00B0 + REG_BLOCK_1_OFFSET)   // Dword 2C

// Front end scaler and related registers
#define SCALE_3D_CNTL           0x01FC // dword 7F
#define SCALE_DST_Y_X           0x038C // dword E3
#define SCALE_PITCH             0x01EC // dword 7B
#define SCALE_HEIGHT            0x01E0 // dword 78
#define SCALE_WIDTH             0x01DC // dword 77
#define SCALE_OFF               0x01C0 // dword 70
#define SECONDARY_SCALE_OFF     0x0378 // dword DE
#define SCALE_OFF_ACC       0x0388 // dword E2
#define SECONDARY_SCALE_OFF_ACC 0x0384 // dword E1
#define SECONDARY_SCALE_PITCH   0x0368 // dword DA
#define SCALE_PITCH_BOTH    0x0380 // dword E0
#define SCALE_HACC              0x03C8 // dword F2
#define SECONDARY_SCALE_HACC    0x03A4 // dword E9
#define SCALE_VACC              0x01F8 // dword 7E
#define SECONDARY_SCALE_VACC    0x03D4 // dword F5
#define SCALE_X_INC             0x01F0 // dword 7C
#define SECONDARY_SCALE_X_INC   0x039C // dword E7
#define SCALE_Y_INC             0x01F4 // dword 7D
#define SECONDARY_SCALE_Y_INC   0x03D0 // dword F4
#define DP_WRITE_MSK            0x02C8 // dword B2
#define ALPHA_TST_CNTL          0x0150 // dword 54
#define DP_SET_GUI_ENGINE       0x02FC // dword BF
#define TEX_CNTL                0x0374 // dword DD


#endif // _ATIM64VT_H
