/******************************************************************************
 * setmode.c - Chapter 3 sample code                                          *
 *                                                                            *
 * This program sets a display mode on the Rage 128                           *
 *                                                                            *
 * Copyright (c) 1999 ATI Technologies Inc.  All rights reserved.             *
 ******************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include "..\util\defines.h"
#include "..\util\main.h"
#include "..\util\regdef.h"

void main (int argc, char *argv[])
{
    char *framebuffer;
    WORD x, y;
    BYTE test = 0;

    get_old_mode ();

    if (!R128_Detect ())
    {
        R128_ShutDown ();
        printf ("\nCannot detect a Rage 128 based graphics adapter.");
        printf ("\nProgram terminated.");
        exit (1);
    }
    process_command_line (argc, argv);
    R128_AdapterInfo.xres = R128_AdapterInfo.xres;
    R128_AdapterInfo.yres = R128_AdapterInfo.yres;
    R128_AdapterInfo.bpp = R128_AdapterInfo.bpp;

    // detection tests!
    test = R128_FindRom ();
    if (test == 0)
    {
        R128_ShutDown ();
        printf ("\nCannot detect a Rage 128 BIOS ROM.");
        printf ("\nProgram terminated.");
        exit (1);
    }

    test = R128_RegTest ();
    if (test == 0)
    {
        R128_ShutDown ();
        printf ("\nRage 128 Scratch Register Test Failed.");
        printf ("\nProgram terminated.");
        exit (1);
    }

    test = R128_SetMode (R128_AdapterInfo.xres, R128_AdapterInfo.yres, R128_AdapterInfo.bpp);
    if (test == 0)
    {
        R128_ShutDown ();
        printf ("\nR128_SetMode Failed!");
        printf ("\nAttempted to set display mode: %d x %d, %d bits per pixel.",
               R128_AdapterInfo.xres, R128_AdapterInfo.yres, R128_AdapterInfo.bpp);
        printf ("\nProgram terminated.");
        exit (1);
    }

    // fill the screen with blue pixels
    framebuffer = (char *)R128_AdapterInfo.virtual_MEM_BASE;

    for (x=0; x<R128_AdapterInfo.xres; x++)
    {
        for (y=0; y<R128_AdapterInfo.yres; y++)
        {
            switch (R128_AdapterInfo.bpp)
            {
                case 8:     *framebuffer = 0x09;
                            framebuffer+=1;
                            break;

                case 15:
                case 16:    *framebuffer = 0x1F;
                            framebuffer+=1;
                            *framebuffer = 0x00;
                            framebuffer+=1;
                            break;

                case 24:    *framebuffer = 0xFF;
                            framebuffer+=1;
                            *framebuffer = 0x00;
                            framebuffer+=1;
                            *framebuffer = 0x00;
                            framebuffer+=1;
                            break;

                case 32:    *framebuffer = 0xFF;
                            framebuffer+=1;
                            *framebuffer = 0x00;
                            framebuffer+=1;
                            *framebuffer = 0x00;
                            framebuffer+=1;
                            *framebuffer = 0x00;
                            framebuffer+=1;
                            break;
            } // switch
        } // for (y...
    } // for (x...

    getch ();

    R128_ShutDown ();

    R128_PrintInfoStruct ();
    printf ("\nDisplay mode successfully set.");
    printf ("\nX resolution: %d, Y resolution: %d, bits per pixel: %d\n",
            R128_AdapterInfo.xres, R128_AdapterInfo.yres,
            R128_AdapterInfo.bpp);

    exit (0);

} // main

